/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DLineA;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DLineP;
import chart.chart2d.Graph2DLineSt;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartShading;
import chart.graphics.ChartTexturePattern;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Graph2DLine
extends Chart2DObject {
    protected Shape[] seriesShapes;
    protected Shape[] seriesAreaShapes;
    protected Shape[][] itemShapes;
    protected GeneralPath depthPath;
    protected GeneralPath noDepthPath;
    protected ChartPenStyle linePen;
    protected Graph2DLineNode lineNode;
    protected float startX;
    protected float unitX;
    protected float unitY;
    protected int row;
    protected int col;
    protected float[][] value;
    protected float[] absSumOfCols;
    protected float depth;
    protected float depthH = 0.0f;
    protected float depthW = 0.0f;
    protected float startOffsetW = 0.0f;
    protected float startOffsetH = 0.0f;
    protected float offsetW = 0.0f;
    protected float offsetH = 0.0f;
    protected int offsetN = 1;
    protected float[][] point;
    protected float[][] tpoint;
    protected float[][] lastpoint;
    protected float[][] tlastpoint;
    protected float[] len;
    protected float[][] lines;
    protected float[][] tLines;
    protected Line2D[][] depthlines;
    protected int gap = 5;
    protected int[] nodeStyleList;
    protected boolean isLineUnit;
    private int[] HighLightPattern;
    private int abs;
    private String[][][] contains;
    private double[] cos;
    private ChartFillPattern[] draw;
    private int drawDepthLine;

    Graph2DLine(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, int n) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.offsetN = n;
    }

    public void init() {
        int n;
        super.init();
        this.col = this.dataset.getCategorySize();
        this.row = this.dataset.getSeriesSize();
        this.value = new float[this.row][this.col];
        this.contains = new String[this.row][this.col][3];
        double d = Math.PI / 180 * (double)this.objectProperties.getDepthDirection();
        this.depth = this.objectProperties.getDepth() / (float)this.layer.getChartCount();
        this.startOffsetW = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.cos(d));
        this.startOffsetH = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.sin(d));
        this.startOffsetW = this.startOffsetW < 0.0f ? 0.0f : this.startOffsetW;
        this.startOffsetH = this.startOffsetH < 0.0f ? 0.0f : this.startOffsetH;
        this.depth *= (float)this.offsetN;
        this.depthW = (float)((double)this.depth * Math.cos(d));
        this.depthH = (float)((double)this.depth * Math.sin(d));
        this.depthW = this.depthW < 0.0f ? 0.0f : this.depthW;
        this.depthH = this.depthH < 0.0f ? 0.0f : this.depthH;
        this.offsetW = this.depthW / (float)this.offsetN;
        this.offsetH = this.depthH / (float)this.offsetN;
        int n2 = 0;
        while (n2 < this.row) {
            n = 0;
            while (n < this.col) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.value[n2][n] = 0.0f;
                } else {
                    this.value[n2][n] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.contains[n2][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n2, n);
                    } else {
                        this.contains[n2][n][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(n2, n));
                    }
                }
                ++n;
            }
            ++n2;
        }
        if (this.valueLabelPosition != 0) {
            if (this.dataset.getChartDataSetModel().isOneGroup()) {
                this.cos = new double[this.row];
                double[] dArray = new double[this.row];
                int n3 = 0;
                while (n3 < this.row) {
                    int n4 = 0;
                    while (n4 < this.col) {
                        int n5 = n3;
                        dArray[n5] = dArray[n5] + (double)Math.abs(this.value[n3][n4]);
                        ++n4;
                    }
                    if (n3 == 0 || this instanceof Graph2DLineA) {
                        this.cos[n3] = dArray[n3];
                    }
                    if ((this instanceof Graph2DLineSt || this instanceof Graph2DLineP) && n3 > 0) {
                        this.cos[n3] = dArray[n3] - dArray[n3 - 1];
                    }
                    if (this.cos[n3] == 0.0) {
                        this.cos[n3] = 1.0;
                    }
                    ++n3;
                }
            } else {
                this.cos = new double[this.col];
                n = 0;
                while (n < this.col) {
                    int n6 = 0;
                    while (n6 < this.row) {
                        if (this instanceof Graph2DLineSt || this instanceof Graph2DLineP) {
                            this.cos[n] = Math.abs(this.value[this.row - 1][n]);
                            break;
                        }
                        int n7 = n;
                        this.cos[n7] = this.cos[n7] + (double)Math.abs(this.value[n6][n]);
                        ++n6;
                    }
                    if (this.cos[n] == 0.0) {
                        this.cos[n] = 1.0;
                    }
                    ++n;
                }
            }
        }
        this.seriesAreaShapes = new Shape[this.row];
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][this.col];
        this.depthPath = new GeneralPath();
        this.noDepthPath = new GeneralPath();
        int n8 = 0;
        while (n8 < this.row) {
            this.seriesShapes[n8] = new GeneralPath();
            this.seriesAreaShapes[n8] = new GeneralPath();
            int n9 = 0;
            while (n9 < this.col) {
                this.itemShapes[n8][n9] = new GeneralPath();
                ++n9;
            }
            ++n8;
        }
        this.linePen = new ChartPenStyle();
        this.lineNode = new Graph2DLineNode();
        if (this.paper.I.getChartLegend() != null) {
            this.HighLightPattern = this.paper.I.getChartLegend().getIconStyleList();
        }
        this.point = new float[this.col][2];
        this.tpoint = new float[this.col][2];
        this.lastpoint = new float[this.col][2];
        this.tlastpoint = new float[this.col][2];
        this.lines = new float[this.col * this.row][2];
        this.tLines = new float[this.col * this.row][2];
        this.depthlines = new Line2D[this.row][this.col];
        this.unitX = this.layer.I();
        this.unitY = this.layer.Z();
        this.linePen.setPenWidth((int)this.objectProperties.getLineThickness());
        this.isLineUnit = ((ChartCategoryAxis)this.layer.getAxisX()).isLineUnit();
        this.startX = this.isLineUnit ? 0.0f : this.unitX / 2.0f;
    }

    public void locate() {
        int n = 0;
        while (n < this.row) {
            ((GeneralPath)this.seriesShapes[n]).reset();
            ((GeneralPath)this.seriesAreaShapes[n]).reset();
            int n2 = 0;
            while (n2 < this.col) {
                ((GeneralPath)this.itemShapes[n][n2]).reset();
                ++n2;
            }
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        this.abs = this.paper.getLineLegendIconDescent(this.dataset);
        int n = 0;
        while (n < this.row) {
            this.drawLine(graphics2D, n);
            ++n;
        }
        if (this.valueLabelPosition != 0) {
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.tLines, 0, this.row, this.valueLabelPosition, this.cos);
            graph2DStaticHint.paint();
        }
    }

    public void drawLine(Graphics2D graphics2D, int n) {
        ChartColorPattern chartColorPattern = null;
        if (this.seriesPattern[n] != null) {
            ChartFillPattern chartFillPattern;
            chartColorPattern = this.seriesPattern[n] instanceof ChartColorPattern ? (ChartColorPattern)this.seriesPattern[n] : (this.seriesPattern[n] instanceof ChartGradientPattern ? ((ChartGradientPattern)this.seriesPattern[n]).getStartColor() : (this.seriesPattern[n] instanceof ChartTexturePattern ? ((ChartTexturePattern)this.seriesPattern[n]).getForeground() : new ChartColorPattern()));
            this.linePen.setPenColor(chartColorPattern);
            if (this.layer.isDepth()) {
                this.drawDepthLine(graphics2D, n);
            } else {
                this.linePen.draw(graphics2D, this.seriesShapes[n]);
            }
            int n2 = 0;
            while (n2 < this.col) {
                if (((Chart1DDataSet)this.dataset).getValue(n, n2) != null) {
                    int n3 = this.objectProperties.getLineNodeStyle();
                    if (this.HighLightPattern != null) {
                        n3 = this.paper.formatLineNode(this.objectProperties.getLineNodeStyle(), this.HighLightPattern[(n + this.abs) % this.HighLightPattern.length]);
                    }
                    if (this.layer.isDepth()) {
                        this.linePen.setPenWidth(1.0f);
                        this.linePen.draw(graphics2D, this.depthlines[n][n2]);
                    } else {
                        this.lineNode.drawNode(graphics2D, (int)this.tLines[this.col * n + n2][0], (int)this.tLines[this.col * n + n2][1], n3, this.objectProperties.getLineNodeWidth(), this.objectProperties.getLineNodeHeight());
                    }
                }
                ++n2;
            }
            if (!this.layer.isDepth() && this.draw != null && this.draw.length > 0 && (chartFillPattern = this.draw[n]) != null) {
                chartFillPattern.fill(graphics2D, this.seriesAreaShapes[n]);
            }
        }
    }

    public void drawDepthLine(Graphics2D graphics2D, int n) {
        ChartFillPattern chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[n], 20);
        chartFillPattern.fill(graphics2D, this.seriesShapes[n]);
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    public Shape getShapeBySeries(int n) {
        return this.seriesShapes[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    public Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        int n3 = 0;
        while (n3 < this.row) {
            int n4 = 0;
            while (n4 < this.col) {
                if (this.itemShapes[n3][n4].contains(n, n2)) {
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n4;
                    return this.contains[n3][n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.seriesShapes.length) {
            if (this.seriesShapes[n3].intersects(n, n2, 3.0, 3.0)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void setAreaPatterns(ChartFillPattern[] chartFillPatternArray, int n) {
        if (this.draw != null) {
            return;
        }
        this.draw = new ChartFillPattern[this.row];
        if (n + this.row > chartFillPatternArray.length) {
            return;
        }
        int n2 = 0;
        while (n2 < this.row) {
            this.draw[n2] = chartFillPatternArray[n + n2];
            ++n2;
        }
        this.drawDepthLine = n + this.row;
    }

    public int getStartIndex() {
        return this.drawDepthLine;
    }

    public int searchIndex(int n, int n2) {
        int n3 = 0;
        while (n3 < this.seriesShapes.length) {
            if (this.seriesShapes[n3].intersects(n, n2, 3.0, 3.0)) {
                return n3 + this.drawDepthLine - this.row;
            }
            ++n3;
        }
        return -1;
    }
}

