/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt;

public class Rect2D {
    public double x;
    public double y;
    public double width;
    public double height;

    public Rect2D dup() {
        return new Rect2D(this.x, this.y, this.width, this.height);
    }

    public Rect2D(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public boolean intersects(Rect2D rect2D) {
        return !(rect2D.x + rect2D.width <= this.x || rect2D.y + rect2D.height <= this.y || rect2D.x >= this.x + this.width || rect2D.y >= this.y + this.height);
    }

    public Rect2D intersection(Rect2D rect2D) {
        double d = Math.max(this.x, rect2D.x);
        double d2 = Math.min(this.x + this.width, rect2D.x + rect2D.width);
        double d3 = Math.max(this.y, rect2D.y);
        double d4 = Math.min(this.y + this.height, rect2D.y + rect2D.height);
        if (d2 - d < 0.0 || d4 - d3 < 0.0) {
            return new Rect2D(0.0, 0.0, 0.0, 0.0);
        }
        return new Rect2D(d, d3, d2 - d, d4 - d3);
    }

    public Rect2D union(Rect2D rect2D) {
        double d = Math.min(this.x, rect2D.x);
        double d2 = Math.max(this.x + this.width, rect2D.x + rect2D.width);
        double d3 = Math.min(this.y, rect2D.y);
        double d4 = Math.max(this.y + this.height, rect2D.y + rect2D.height);
        return new Rect2D(d, d3, d2 - d, d4 - d3);
    }

    public boolean contains(Rect2D rect2D) {
        return this.contains(rect2D.x, rect2D.y, rect2D.width, rect2D.height);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = this.width;
        double d6 = this.height;
        if (d5 <= 0.0 || d6 <= 0.0 || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d7 = this.x;
        double d8 = this.y;
        return d >= d7 && d2 >= d8 && d + d3 <= d7 + d5 && d2 + d4 <= d8 + d6;
    }

    public boolean equals(Object object) {
        if (object instanceof Rect2D) {
            Rect2D rect2D = (Rect2D)object;
            return this.x == rect2D.x && this.y == rect2D.y && this.width == rect2D.width && this.height == rect2D.height;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public static void main(String[] stringArray) {
        Rect2D rect2D = new Rect2D(0.0, 0.0, 30.0, 30.0);
        Rect2D rect2D2 = new Rect2D(0.0, 0.0, 30.0, 25.0);
        System.out.println("r1 " + rect2D);
        System.out.println("r2 " + rect2D2);
        System.out.println("r1 contains r2 " + rect2D.contains(rect2D2));
        System.out.println("r2 contains r2 " + rect2D2.contains(rect2D));
    }
}

