/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageBar;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Graph2DGuageBars
extends Chart2DObject {
    Shape[] append;
    Shape[][] axisY;
    int contains;
    int I;
    Graph2DGuageBar[] floatValue;
    float Z;
    float C = 0.0f;
    float[] getAxisXProperties;
    float[] getAxisY;
    String[][][] getAxisY1Shapes;
    float[][] B;
    float[] D;
    float[] F;
    float[] getBounds;
    ChartLabelBase[] getCategorySize;
    float J;
    float S;
    Line2D[] getChartDataSetModel;

    Graph2DGuageBars(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    public void init() {
        super.init();
        this.contains = this.dataset.getCategorySize();
        this.I = this.dataset.getSeriesSize();
        this.floatValue = new Graph2DGuageBar[this.contains];
        this.append = new Shape[this.I];
        this.axisY = new Shape[this.I][this.contains];
        this.getAxisXProperties = new float[this.contains];
        this.getAxisY = new float[this.contains];
        this.getChartDataSetModel = new Line2D[this.contains];
        int n = 0;
        while (n < this.I) {
            this.append[n] = new GeneralPath();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.contains) {
            this.floatValue[n2] = new Graph2DGuageBar(this, n2);
            ++n2;
        }
        this.QOIV();
        this.append();
        this.axisY();
    }

    private void QOIV() {
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        if (stringArray != null) {
            int n = stringArray.length;
            this.getCategorySize = new ChartLabelBase[n];
            int n2 = 0;
            while (n2 < n) {
                this.getCategorySize[n2] = new ChartLabelBase(stringArray[n2]);
                this.getCategorySize[n2].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
                this.floatValue[n2].setCategoryLabel(this.getCategorySize[n2]);
                ++n2;
            }
        }
    }

    private void append() {
        int n;
        this.B = new float[this.I][this.contains];
        this.D = new float[this.contains];
        this.getAxisY1Shapes = new String[this.I][this.contains][3];
        int n2 = 0;
        while (n2 < this.I) {
            n = 0;
            while (n < this.contains) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.B[n2][n] = 0.0f;
                } else {
                    this.B[n2][n] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.getAxisY1Shapes[n2][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n2, n);
                    } else {
                        this.getAxisY1Shapes[n2][n][0] = this.dataset.getFormatedHintValue(number);
                    }
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < this.contains) {
            this.D[n] = this.B[0][n];
            int n3 = 0;
            while (n3 < this.I) {
                if (this.B[n3][n] > this.D[n]) {
                    this.D[n] = this.B[n3][n];
                }
                ++n3;
            }
            ++n;
        }
    }

    private void axisY() {
        float f;
        this.S = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        this.J = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.F = new float[3];
        this.getBounds = new float[3];
        this.F[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.F[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.F[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.getBounds[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.getBounds[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.getBounds[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        int n = 0;
        while (n < 3) {
            if (this.F[n] > this.getBounds[n]) {
                f = this.F[n];
                this.F[n] = this.getBounds[n];
                this.getBounds[n] = f;
            }
            bl = this.getBounds[n] == this.getBounds[n] && this.getBounds[n] == 0.0f && bl;
            ++n;
        }
        if (bl) {
            f = (this.S - this.J) / 3.0f;
            int n2 = 0;
            while (n2 < 3) {
                this.F[n2] = this.J + (float)n2 * f;
                this.getBounds[n2] = this.F[n2] + f;
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < 3) {
            if (this.F[n3] < this.J) {
                this.F[n3] = this.J;
            }
            if (this.F[n3] > this.S) {
                this.F[n3] = this.S;
            }
            if (this.getBounds[n3] < this.J) {
                this.getBounds[n3] = this.J;
            }
            if (this.getBounds[n3] > this.S) {
                this.getBounds[n3] = this.S;
            }
            ++n3;
        }
    }

    public void locate() {
        switch (this.paper.getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.contains();
                break;
            }
            case 1: {
                this.dataset();
            }
        }
    }

    private void contains() {
        this.Z = (float)(this.paper.getBounds().getWidth() * (double)this.paper.getProperties().getScaleX()) - 10.0f;
        this.C = (float)(this.paper.getBounds().getHeight() * (double)this.paper.getProperties().getScaleY() - 10.0) / (float)this.contains;
        float f = (float)this.paper.getBounds().getHeight() * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f + 5.0f;
        float f2 = (float)this.paper.getBounds().getWidth() * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f + 5.0f;
        int n = 0;
        while (n < this.contains) {
            this.getAxisXProperties[n] = f2;
            this.getAxisY[n] = f + (float)n * this.C;
            this.floatValue[n].setStartX(this.getAxisXProperties[n]);
            this.floatValue[n].setStartY(this.getAxisY[n]);
            this.floatValue[n].locate();
            ++n;
        }
    }

    private void dataset() {
        this.C = (float)(this.paper.getBounds().getHeight() * (double)this.paper.getProperties().getScaleY() - 10.0);
        this.Z = (float)(this.paper.getBounds().getWidth() * (double)this.paper.getProperties().getScaleX() - 10.0) / (float)this.contains;
        float f = (float)this.paper.getBounds().getHeight() * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f + 5.0f;
        float f2 = (float)this.paper.getBounds().getWidth() * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f + 5.0f;
        int n = 0;
        while (n < this.contains) {
            this.getAxisY[n] = f;
            this.getAxisXProperties[n] = f2 + (float)n * this.Z;
            this.floatValue[n].setStartX(this.getAxisXProperties[n]);
            this.floatValue[n].setStartY(this.getAxisY[n]);
            this.floatValue[n].locate();
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        int n;
        int n2 = 0;
        while (n2 < this.contains) {
            this.floatValue[n2].paint(graphics2D);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.I) {
            n = 0;
            while (n < this.contains) {
                this.axisY[n3][n] = this.floatValue[n].getItemShapes(n3);
                ((GeneralPath)this.append[n3]).append(this.axisY[n3][n], false);
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < this.contains) {
            this.getChartDataSetModel[n] = (Line2D)this.floatValue[n].getAxisY1Shapes();
            ++n;
        }
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    Shape[][] getItemShapes() {
        return this.axisY;
    }

    public Shape getShapeBySeries(int n) {
        return this.append[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.axisY[n][n2];
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        int n3 = 0;
        while (n3 < this.I) {
            int n4 = 0;
            while (n4 < this.contains) {
                if (this.axisY[n3][n4] != null && this.axisY[n3][n4].contains(n, n2)) {
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n4;
                    return this.getAxisY1Shapes[n3][n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public int searchSeries(int n, int n2) {
        int n3 = this.append.length;
        int n4 = 0;
        while (n4 < this.I) {
            if (this.append[n4].contains(n, n2)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public Chart2DPaper getPaper() {
        return this.paper;
    }

    public boolean searchAxisY(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.contains) {
            if (this.getChartDataSetModel[n3] != null && this.getChartDataSetModel[n3].intersects(n - 5, n2 - 5, 10.0, 10.0)) {
                this.layer.axisY.setStatus(1);
                bl = true;
            }
            ++n3;
        }
        return bl;
    }

    public Line2D[] getAxisYShape() {
        return this.getChartDataSetModel;
    }
}

