/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class ChartBackground
implements Cloneable {
    private static final ChartColorPattern QOIV = new ChartColorPattern(new Color(128, 128, 128));
    private static final String[] clone = new String[]{"None", "Raised", "Recess", "Shadow", "Solid"};
    private ChartPenStyle draw;
    private ChartFillPattern fill;
    private ChartFillPattern[] getColor = new ChartFillPattern[2];
    private boolean getFillBounds = false;
    private int getPenColor;
    private float getPenWidth;
    private float height;
    private float highlight;
    private float lineTo;

    public ChartBackground() {
        this(0, new ChartPenStyle(new ChartColorPattern("SlateGray")), new ChartColorPattern("Grey"), false, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ChartBackground(Color color) {
        this(0, new ChartPenStyle(new ChartColorPattern("SlateGray")), new ChartColorPattern(color), true, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ChartBackground(int n, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern, boolean bl, float f, float f2, float f3, float f4) {
        this.getPenColor = n;
        this.draw = chartPenStyle;
        this.fill = chartFillPattern;
        this.getColor[0] = chartFillPattern;
        this.getFillBounds = bl;
        this.getPenWidth = f;
        this.height = f2;
        this.highlight = f3;
        this.lineTo = f4;
    }

    public float getLeft() {
        return this.getPenWidth;
    }

    public float getBottom() {
        return this.height;
    }

    public float getRight() {
        return this.highlight;
    }

    public float getTop() {
        return this.lineTo;
    }

    public Rectangle2D.Float getCoreArea(Rectangle rectangle) {
        float f = this.draw.getPenWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        if (this.getPenColor == 3) {
            float_.width = (float)rectangle.width - f;
            float_.height = (float)rectangle.height - f;
            float f2 = float_.width * this.getPenWidth;
            float f3 = float_.height * this.height;
            float f4 = float_.width * this.highlight;
            float f5 = float_.height * this.lineTo;
            float_.x = (float)rectangle.x + f2;
            float_.y = (float)rectangle.y + f5;
            float_.width -= f2 + f4;
            float_.height -= f5 + f3;
        } else {
            float_.width = (float)rectangle.width - f * 2.0f;
            float_.height = (float)rectangle.height - f * 2.0f;
            float f6 = float_.width * this.getPenWidth;
            float f7 = float_.height * this.height;
            float f8 = float_.width * this.highlight;
            float f9 = float_.height * this.lineTo;
            float_.x = (float)rectangle.x + f + f6;
            float_.y = (float)rectangle.y + f + f9;
            float_.width -= f6 + f8;
            float_.height -= f9 + f7;
        }
        return float_;
    }

    public Rectangle getBounds(Rectangle2D.Float float_) {
        Rectangle rectangle = new Rectangle();
        float f = this.draw.getPenWidth();
        if (this.getPenColor == 3) {
            rectangle.width = (int)(float_.width / (1.0f - this.getPenWidth - this.highlight) + f);
            rectangle.height = (int)(float_.height / (1.0f - this.height - this.lineTo) + f);
            rectangle.x = (int)(float_.x - ((float)rectangle.width - f - float_.width) / 2.0f);
            rectangle.y = (int)(float_.y - ((float)rectangle.height - f - float_.height) / 2.0f);
        } else {
            rectangle.width = (int)(float_.width / (1.0f - this.getPenWidth - this.highlight) + f * 2.0f);
            rectangle.height = (int)(float_.height / (1.0f - this.height - this.lineTo) + f * 2.0f);
            rectangle.x = (int)(float_.x - ((float)rectangle.width - float_.width) / 2.0f);
            rectangle.y = (int)(float_.y - ((float)rectangle.height - float_.height) / 2.0f);
        }
        return rectangle;
    }

    public int getBorderStyle() {
        return this.getPenColor;
    }

    public boolean isOpaque() {
        return this.getFillBounds;
    }

    public ChartPenStyle getPen() {
        return this.draw;
    }

    public ChartColorPattern getBorderColor() {
        return this.draw.getPenColor();
    }

    public ChartFillPattern getPattern() {
        return this.fill;
    }

    public void setLeft(float f) {
        this.getPenWidth = f;
    }

    public void setBottom(float f) {
        this.height = f;
    }

    public void setRight(float f) {
        this.highlight = f;
    }

    public void setTop(float f) {
        this.lineTo = f;
    }

    public void setBorderStyle(int n) {
        this.getPenColor = n;
    }

    public void setOpaque(boolean bl) {
        this.getFillBounds = bl;
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.draw = chartPenStyle;
    }

    public void setBorderColor(ChartColorPattern chartColorPattern) {
        this.draw.setPenColor(chartColorPattern);
    }

    public void setPattern(ChartFillPattern chartFillPattern) {
        this.fill = chartFillPattern;
    }

    public void setLinePattern(ChartFillPattern chartFillPattern) {
        this.getColor[0] = chartFillPattern;
    }

    public void setAreaPattern(ChartFillPattern chartFillPattern) {
        this.getColor[1] = chartFillPattern;
    }

    public Rectangle getFillBounds(Rectangle2D.Float float_) {
        Rectangle rectangle = new Rectangle();
        float f = this.draw.getPenWidth();
        if (this.getPenColor == 3) {
            rectangle.width = (int)(float_.width * (1.0f - this.getPenWidth - this.highlight) + f);
            rectangle.height = (int)(float_.height * (1.0f - this.height - this.lineTo) + f);
            rectangle.x = (int)(float_.width * this.getPenWidth + float_.x);
            rectangle.y = (int)(float_.height * this.lineTo + float_.y);
        } else {
            rectangle.width = (int)(float_.width * (1.0f - this.getPenWidth - this.highlight));
            rectangle.height = (int)(float_.height * (1.0f - this.height - this.lineTo));
            rectangle.x = (int)(float_.width * this.getPenWidth + float_.x);
            rectangle.y = (int)(float_.height * this.lineTo + float_.y);
        }
        return rectangle;
    }

    public void paintBackground(Graphics2D graphics2D, Rectangle rectangle) {
        Cloneable cloneable;
        float f = this.draw.getPenWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        if (this.fill != null) {
            if (this.getPenColor == 3) {
                float_.x = rectangle.x;
                float_.y = rectangle.y;
                float_.width = (float)rectangle.width - f * 2.0f;
                float_.height = ((float)rectangle.height - f * 2.0f) / 20.0f;
            } else {
                float_.x = (float)rectangle.x + f;
                float_.y = (float)rectangle.y + f;
                float_.width = (float)rectangle.width - f * 2.0f;
                float_.height = ((float)rectangle.height - f * 2.0f) / 20.0f;
            }
            if (this.getColor[1] != null) {
                cloneable = new Rectangle2D.Float();
                ((Rectangle2D.Float)cloneable).x = (float)rectangle.x + f;
                ((Rectangle2D.Float)cloneable).y = (float)rectangle.y + f;
                ((Rectangle2D.Float)cloneable).width = (float)rectangle.width - f * 2.0f;
                ((Rectangle2D.Float)cloneable).height = (float)rectangle.height - f * 2.0f;
                this.getColor[1].fill(graphics2D, this.getFillBounds((Rectangle2D.Float)cloneable));
                this.getColor[0].fill(graphics2D, this.getFillBounds(float_));
            } else {
                float_.x = (float)rectangle.x + f;
                float_.y = (float)rectangle.y + f;
                float_.width = (float)rectangle.width - f * 2.0f;
                float_.height = (float)rectangle.height - f * 2.0f;
                this.fill.fill(graphics2D, this.getFillBounds(float_));
            }
        }
        switch (this.getPenColor) {
            case 4: {
                float_.x = (float)rectangle.x + f / 2.0f;
                float_.y = (float)rectangle.y + f / 2.0f;
                float_.width = (float)rectangle.width - f - 1.0f;
                float_.height = (float)rectangle.height - f - 1.0f;
                this.draw.draw(graphics2D, float_);
                break;
            }
            case 1: {
                this.QOIV(graphics2D, rectangle, 50, -30);
                break;
            }
            case 2: {
                this.QOIV(graphics2D, rectangle, -30, 50);
                break;
            }
            case 3: {
                cloneable = new ChartPenStyle(QOIV);
                ((ChartPenStyle)cloneable).setPenWidth(f);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(rectangle.x + rectangle.width) - f / 2.0f, (float)rectangle.y + f);
                generalPath.lineTo((float)(rectangle.x + rectangle.width) - f / 2.0f, (float)(rectangle.y + rectangle.height) - f / 2.0f);
                generalPath.lineTo((float)rectangle.x + f, (float)(rectangle.y + rectangle.height) - f / 2.0f);
                ((ChartPenStyle)cloneable).draw(graphics2D, generalPath);
                break;
            }
        }
    }

    private void QOIV(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
        Color color = this.draw.getPenColor().getColor();
        int n3 = (int)this.draw.getPenWidth();
        Line2D.Float float_ = new Line2D.Float();
        this.draw.setPenWidth(1.0f);
        this.draw.getPenColor().setColor(ChartGraphicsUtil.highlight(color, n));
        int n4 = 0;
        while (n4 < n3) {
            float_.setLine(rectangle.x + n4, rectangle.y + n4, rectangle.x + rectangle.width - 1 - n4, rectangle.y + n4);
            this.draw.draw(graphics2D, float_);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            float_.setLine(rectangle.x + n5, rectangle.y + n5, rectangle.x + n5, rectangle.y + rectangle.height - 1 - n5);
            this.draw.draw(graphics2D, float_);
            ++n5;
        }
        this.draw.getPenColor().setColor(ChartGraphicsUtil.highlight(color, n2));
        int n6 = 0;
        while (n6 < n3) {
            float_.setLine(rectangle.x + n6, rectangle.y + rectangle.height - 1 - n6, rectangle.x + rectangle.width - 1 - n6, rectangle.y + rectangle.height - 1 - n6);
            this.draw.draw(graphics2D, float_);
            ++n6;
        }
        int n7 = 0;
        while (n7 < n3) {
            float_.setLine(rectangle.x + rectangle.width - 1 - n7, rectangle.y + n7, rectangle.x + rectangle.width - 1 - n7, rectangle.y + rectangle.height - 1 - n7);
            this.draw.draw(graphics2D, float_);
            ++n7;
        }
        this.draw.setPenWidth(n3);
        this.draw.getPenColor().setColor(color);
    }

    public Object clone() {
        ChartFillPattern chartFillPattern = null;
        if (this.fill != null) {
            chartFillPattern = (ChartFillPattern)this.fill.clone();
        }
        return new ChartBackground(this.getPenColor, (ChartPenStyle)this.draw.clone(), chartFillPattern, this.getFillBounds, this.getPenWidth, this.height, this.highlight, this.lineTo);
    }

    public static String[] getBuiltinBorderStyles() {
        return clone;
    }

    public ChartFillPattern[] getLinePattern() {
        return this.getColor;
    }
}

