/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.executor.conditiontools;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.datasource.JDSDataField;
import com.jinfonet.dataservice.expression.executor.conditiontools.NamingCheck;
import com.jinfonet.dataservice.expression.variable.ConstantImpl;
import com.jinfonet.dataservice.relational.datasource.FormulaMapping;
import com.jinfonet.dataservice.relational.datasource.JParameter;
import com.jinfonet.dataservice.relational.datasource.ParameterMapping;
import com.jinfonet.dataservice.relational.formulatool.FormulaExecutorFactory;
import com.jinfonet.dataservice.relational.formulatool.IFormulaExecutor;
import java.text.SimpleDateFormat;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.ExpressionTypes;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperatorInformation;
import jet.dataengine.api.expression.OperatorInfoToolkit;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.calculate.IBinaryCalculateExpression;
import jet.dataengine.api.expression.calculate.ISingleCalculateExpression;
import jet.dataengine.api.expression.calculate.ITripleCalculateExpression;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.info.ITopNInformation;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.set.ITopNExpression;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.set.op.ITopNOperator;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IBinaryLogicExpression;
import jet.dataengine.api.expression.tuple.IBinaryTupleExpression;
import jet.dataengine.api.expression.tuple.IMultiTupleExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.ISingleTupleExpression;
import jet.dataengine.api.expression.tuple.ITripleConditionExpression;
import jet.dataengine.api.expression.tuple.ITripleTupleExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.tuple.op.ITupleOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.formula.JavaFormula;

public final class ExpressionInit {
    private AttributeContainer QOIV;
    private IFormulaExecutor append;
    private static DSLog applyAllConstantTimeZone;

    public ExpressionInit(AttributeContainer attributeContainer, JavaFormula javaFormula, SpecialFields specialFields) throws DSException {
        this.QOIV = attributeContainer;
        this.append = FormulaExecutorFactory.getFormulaExecutor(attributeContainer, javaFormula, specialFields, attributeContainer.getFormatedParameters());
        applyAllConstantTimeZone = DSLog.getDSLog(this.getClass().getName());
    }

    public ExpressionInit(AttributeContainer attributeContainer) throws DSException {
        this.QOIV = attributeContainer;
        applyAllConstantTimeZone = DSLog.getDSLog(this.getClass().getName());
    }

    public IExpression check(IExpression iExpression) throws DSException {
        IExpression iExpression2 = null;
        if (iExpression == null) {
            throw new DSException(2560, new String[]{"expression root is null"});
        }
        this.QOIV("uncheck exp", iExpression);
        NamingCheck.I(this.QOIV, iExpression);
        iExpression2 = this.check(iExpression, 0);
        this.QOIV("checked exp", iExpression2);
        return iExpression2;
    }

    public IFormulaExecutor getFormulaExt() {
        return this.append;
    }

    private void QOIV(String string, IExpression iExpression) throws DSException {
        String string2 = null;
        try {
            string2 = iExpression.toExpString();
        }
        catch (ConditionException conditionException) {
            throw new DSException(2561, new String[]{"input expression to string error"}, conditionException);
        }
    }

    private IExpression check(IExpression iExpression, int n) throws DSException {
        IExpression iExpression2 = iExpression;
        IExpression iExpression3 = null;
        IExpression iExpression4 = null;
        IExpression iExpression5 = null;
        if (iExpression2 == null) {
            return null;
        }
        if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
            if (n == -7) {
                this.getCompatibleNumaricType(null, iExpression2, this.QOIV, -7);
            } else {
                this.getCompatibleNumaricType(null, iExpression2, this.QOIV, n);
            }
        } else if (ExpressionToolKit.isSingleExp(iExpression2.expressionType())) {
            iExpression3 = ExpressionToolKit.isLogicExp(iExpression2.expressionType()) ? this.check(this.getValue(iExpression2, this.QOIV), -7) : this.check(this.getValue(iExpression2, this.QOIV), 0);
            this.getExpression3(iExpression2, iExpression3);
        } else if (ExpressionToolKit.isBinaryExp(iExpression2.expressionType())) {
            if (ExpressionToolKit.isLogicExp(iExpression2.expressionType())) {
                iExpression3 = this.check(this.getValue(iExpression2, this.QOIV), -7);
                iExpression4 = this.check(this.getTopNType(iExpression2, this.QOIV), -7);
            } else {
                iExpression3 = this.check(this.getValue(iExpression2, this.QOIV), 0);
                iExpression4 = this.check(this.getTopNType(iExpression2, this.QOIV), this.getAllDBFields(iExpression3));
            }
            this.applyAllConstantTimeZone(iExpression3, iExpression4);
            this.expressionType(iExpression2, iExpression3, iExpression4);
        } else if (ExpressionToolKit.isTripleExp(iExpression2.expressionType())) {
            iExpression3 = this.check(this.getValue(iExpression2, this.QOIV), 0);
            iExpression4 = this.check(this.getTopNType(iExpression2, this.QOIV), 0);
            iExpression5 = this.check(this.getTimestamp(iExpression2, this.QOIV), 0);
            this.equalsIgnoreCase(iExpression2, iExpression3, iExpression4, iExpression5);
            this.append(iExpression3, iExpression4, iExpression5);
        } else if (ExpressionToolKit.isMultiExp(iExpression2.expressionType())) {
            IExpression[] iExpressionArray = ((IMultiTupleExpression)iExpression2).getExpressions();
            if (ExpressionToolKit.isLogicExp(iExpression2.expressionType())) {
                int n2 = 0;
                while (n2 < iExpressionArray.length) {
                    iExpressionArray[n2] = this.getOperator(iExpression2, iExpressionArray[n2], this.QOIV);
                    iExpressionArray[n2] = this.check(iExpressionArray[n2], -7);
                    if (ExpressionToolKit.isConstant(iExpressionArray[n2].expressionType())) {
                        try {
                            ((IConstant)iExpressionArray[n2]).setDataType(-7);
                            this.getElementByAliasName((IConstant)iExpressionArray[n2]);
                        }
                        catch (ConditionException conditionException) {
                            throw new DSException(5007, new Object[]{"Condition Exception"}, conditionException);
                        }
                    }
                    if (ExpressionToolKit.isBooleanExp(iExpressionArray[n2].expressionType()) || ExpressionToolKit.isVariableExp(iExpressionArray[n2].expressionType())) {
                        if (ExpressionToolKit.isVariableExp(iExpressionArray[n2].expressionType())) {
                            this.getCompatibleNumaricType(null, iExpressionArray[n2], this.QOIV, 0);
                        }
                    } else {
                        throw new DSException(5010, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpressionArray[n2].expressionType())});
                    }
                    ++n2;
                }
                try {
                    ((IMultiTupleExpression)iExpression2).setExpressions(iExpressionArray);
                }
                catch (ConditionException conditionException) {
                    throw new DSException(5038, new Object[]{"Condition Exception"}, conditionException);
                }
            }
            throw new RuntimeException();
        }
        return iExpression2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void append(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws DSException {
        int n = -1;
        if (!ExpressionToolKit.isVariableExp(iExpression.expressionType())) throw new UnsupportedOperationException("not support exp in triple expressoin : " + iExpression.toString());
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            n = ((IReference)iExpression).getDataType();
        } else {
            if (!ExpressionToolKit.isFormula(iExpression.expressionType())) throw new UnsupportedOperationException("not support exp in triple expressoin, just support reference : " + iExpression.toString());
            n = ((IFormula)iExpression).getDataType();
        }
        if (!ExpressionToolKit.isVariableExp(iExpression2.expressionType()) || !ExpressionToolKit.isVariableExp(iExpression3.expressionType())) throw new UnsupportedOperationException("not support exp in triple expressoin, exp2 just support variable : " + iExpression2.toString() + ", exp3 just support variable : " + iExpression3.toString());
        if (ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            try {
                ((IConstant)iExpression2).setDataType(n);
                this.getElementByAliasName((IConstant)iExpression2);
            }
            catch (ConditionException conditionException) {
                throw new DSException(conditionException.getErrorKey(), (Throwable)conditionException);
            }
        }
        if (!ExpressionToolKit.isConstant(iExpression3.expressionType())) return;
        try {
            ((IConstant)iExpression3).setDataType(n);
            this.getElementByAliasName((IConstant)iExpression3);
            return;
        }
        catch (ConditionException conditionException) {
            throw new DSException(conditionException.getErrorKey(), (Throwable)conditionException);
        }
    }

    private void applyAllConstantTimeZone(IExpression iExpression, IExpression iExpression2) throws DSException {
        block7: {
            try {
                if (ExpressionToolKit.isBooleanExp(iExpression.expressionType()) && ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                    if (ExpressionToolKit.isConstant(iExpression2.expressionType())) {
                        ((IConstant)iExpression2).setDataType(-7);
                    }
                    break block7;
                }
                if (ExpressionToolKit.isVariableExp(iExpression.expressionType()) && ExpressionToolKit.isBooleanExp(iExpression2.expressionType())) {
                    if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
                        ((IConstant)iExpression).setDataType(-7);
                    }
                    break block7;
                }
                if (ExpressionToolKit.isVariableExp(iExpression.expressionType()) && ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                    int n = this.createReference(iExpression, iExpression2);
                    ((IVariableExpression)iExpression).setDataType(n);
                    ((IVariableExpression)iExpression2).setDataType(n);
                    break block7;
                }
                return;
            }
            catch (ConditionException conditionException) {
                throw new DSException(2562, new Object[]{"ConditionException", conditionException.getMessage()}, conditionException);
            }
        }
    }

    private int createReference(IExpression iExpression, IExpression iExpression2) throws DSException {
        if (ExpressionToolKit.isConstant(iExpression.expressionType()) && ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            return 12;
        }
        if (ExpressionToolKit.isConstant(iExpression.expressionType()) && (ExpressionToolKit.isReference(iExpression2.expressionType()) || ExpressionToolKit.isFormula(iExpression2.expressionType()))) {
            return this.endsWith((IReference)iExpression2);
        }
        if ((ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType())) && ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            return this.endsWith(iExpression);
        }
        int n = this.endsWith(iExpression);
        int n2 = this.endsWith(iExpression2);
        if (Types.isNumeric(n) && Types.isNumeric(n2)) {
            return Types.getCompatibleNumaricType(n, n2);
        }
        return n;
    }

    private int endsWith(IExpression iExpression) throws DSException {
        try {
            if (ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType())) {
                JAttribute[] jAttributeArray = this.QOIV.getAllElements();
                if (jAttributeArray != null) {
                    int n = 0;
                    while (n < jAttributeArray.length) {
                        if (iExpression.getName().equalsIgnoreCase(jAttributeArray[n].getAliasName())) {
                            return jAttributeArray[n].getDataType();
                        }
                        ++n;
                    }
                }
                throw new DSException(2563, new Object[]{"can not get field in attribute container", iExpression.getName()});
            }
            return 12;
        }
        catch (ConditionException conditionException) {
            throw new DSException(2564, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private void equalsIgnoreCase(IExpression iExpression, IExpression iExpression2, IExpression iExpression3, IExpression iExpression4) throws DSException {
        if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
            ITripleTupleExpression iTripleTupleExpression = (ITripleTupleExpression)iExpression;
            if (OperatorToolKit.isBetween(iTripleTupleExpression.getOperator().operatorType()) || OperatorToolKit.isNotBetween(iTripleTupleExpression.getOperator().operatorType())) {
                this.getName(iExpression, iExpression2, this.QOIV, 3, 1);
                this.getName(iExpression, iExpression3, this.QOIV, 3, 2);
                this.getName(iExpression, iExpression4, this.QOIV, 3, 3);
                this.getExpression2(iExpression3);
                this.getExpression2(iExpression4);
                this.getExpression(iExpression2, iExpression3, iExpression4, this.QOIV);
                return;
            }
        } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
            return;
        }
        throw new DSException(2565, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression.expressionType())});
    }

    private void expressionType(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws DSException {
        try {
            this.getName(iExpression, iExpression2, this.QOIV, 2, 1);
            this.getName(iExpression, iExpression3, this.QOIV, 2, 2);
            this.format(iExpression, iExpression2, iExpression3);
            if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
                if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
                    this.getErrorKey(iExpression, iExpression2, iExpression3, this.QOIV);
                    return;
                }
                if (ExpressionToolKit.isLogicExp(iExpression.expressionType())) {
                    this.getClass(iExpression, iExpression2, iExpression3, this.QOIV);
                    return;
                }
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                this.getAllElements(iExpression, iExpression2, iExpression3, this.QOIV);
                return;
            }
            throw new DSException(2566, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression.expressionType())});
        }
        catch (ConditionException conditionException) {
            throw new DSException(5007, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private void format(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws ConditionException, DSException {
        if (ExpressionToolKit.isConstant(iExpression2.expressionType()) || ExpressionToolKit.isConstant(iExpression3.expressionType())) {
            if (ExpressionToolKit.isLogicExp(iExpression.expressionType())) {
                if (ExpressionToolKit.isConstant(iExpression2.expressionType())) {
                    ((IConstant)iExpression2).setDataType(-7);
                    this.getElementByAliasName((IConstant)iExpression2);
                }
                if (ExpressionToolKit.isConstant(iExpression3.expressionType())) {
                    ((IConstant)iExpression3).setDataType(-7);
                    this.getElementByAliasName((IConstant)iExpression3);
                }
            } else if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
                if (!ExpressionToolKit.isConstant(iExpression2.expressionType()) && ExpressionToolKit.isConstant(iExpression3.expressionType())) {
                    ((IConstant)iExpression3).setDataType(this.getAllDBFields(iExpression2));
                    this.getElementByAliasName((IConstant)iExpression3);
                } else if (ExpressionToolKit.isConstant(iExpression2.expressionType()) && !ExpressionToolKit.isConstant(iExpression3.expressionType())) {
                    ((IConstant)iExpression2).setDataType(this.getAllDBFields(iExpression3));
                    this.getElementByAliasName((IConstant)iExpression2);
                } else if (ExpressionToolKit.isConstant(iExpression2.expressionType()) && ExpressionToolKit.isConstant(iExpression3.expressionType())) {
                    if (this.getAllDBFields(iExpression2) != 12 || this.getAllDBFields(iExpression3) != 12) {
                        this.getAliasName(iExpression2, iExpression3);
                    }
                    this.getElementByAliasName((IConstant)iExpression2);
                    this.getElementByAliasName((IConstant)iExpression3);
                }
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                // empty if block
            }
        }
    }

    private void getAliasName(IExpression iExpression, IExpression iExpression2) throws DSException, ConditionException {
        int n = this.getAllDBFields(iExpression);
        int n2 = this.getAllDBFields(iExpression2);
        if (n != 12 && n2 == 12) {
            ((IConstant)iExpression2).setDataType(this.getAllDBFields(iExpression));
        } else if (n == 12 && n2 != 12) {
            ((IConstant)iExpression).setDataType(this.getAllDBFields(iExpression2));
        } else if (n != 12 && n2 != 12) {
            if (Types.isNumeric(n) && Types.isNumeric(n2)) {
                if (n > n2) {
                    ((IConstant)iExpression2).setDataType(n);
                } else {
                    ((IConstant)iExpression).setDataType(n2);
                }
            } else if (n != n2) {
                throw new DSException(5008, new Object[]{"two sub exp data type not compatible", Types.getDataTypeName(n), Types.getDataTypeName(n2)});
            }
        }
    }

    private int getAllDBFields(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            return ((IVariableExpression)iExpression).getDataType();
        }
        if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            return -7;
        }
        if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
            return -1;
        }
        throw new DSException(5009, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression.expressionType())});
    }

    private void getAllElements(IExpression iExpression, IExpression iExpression2, IExpression iExpression3, AttributeContainer attributeContainer) {
    }

    private void getClass(IExpression iExpression, IExpression iExpression2, IExpression iExpression3, AttributeContainer attributeContainer) throws DSException {
        if (ExpressionToolKit.isBooleanExp(iExpression2.expressionType()) || ExpressionToolKit.isBooleanExp(iExpression3.expressionType()) || ExpressionToolKit.isVariableExp(iExpression2.expressionType()) || ExpressionToolKit.isVariableExp(iExpression3.expressionType())) {
            if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                this.getCompatibleNumaricType(null, iExpression2, attributeContainer, 0);
            }
            if (ExpressionToolKit.isVariableExp(iExpression3.expressionType())) {
                this.getCompatibleNumaricType(null, iExpression3, attributeContainer, 0);
            }
        } else {
            throw new DSException(5010, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression2.expressionType())});
        }
    }

    private IExpression getCompatibleNumaricType(IVariableList iVariableList, IExpression iExpression, AttributeContainer attributeContainer, int n) throws DSException {
        block18: {
            try {
                if (ExpressionToolKit.isReference(iExpression.expressionType())) {
                    String string = ((IReference)iExpression).getName();
                    this.getSortType(attributeContainer.getElementByAliasName(string), (IReference)iExpression);
                    if (n == -7 && !Types.isBooleanType(((IReference)iExpression).getDataType())) {
                        throw new DSException(5011, new Object[]{"sub exp " + iExpression + " type error, must be boolean"});
                    }
                    break block18;
                }
                if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
                    IConstant iConstant = (IConstant)iExpression;
                    this.getElementByAliasName(iConstant);
                    if (n == -7) {
                        this.getDataType(iConstant);
                    } else if (n == 0) {
                        iConstant.setDataType(12);
                    } else {
                        iConstant.setDataType(n);
                    }
                    if (iConstant.needParse()) {
                        ExpressionToolKit.applyAllConstantTimeZone(iConstant, this.QOIV.getTimeZone());
                    }
                    break block18;
                }
                if (ExpressionToolKit.isVariableList(iExpression.expressionType())) {
                    IVariableList iVariableList2 = (IVariableList)iExpression;
                    int n2 = 0;
                    while (n2 < iVariableList2.size()) {
                        IVariableExpression iVariableExpression = iVariableList2.getVariableExp(n2);
                        if (ExpressionToolKit.isConstant(iVariableExpression.expressionType())) {
                            this.getElementByAliasName((IConstant)iVariableExpression);
                        }
                        ++n2;
                    }
                    iVariableList2.setDataType(n);
                    if (iVariableList2.size() < 1) {
                        throw new DSException(5013, new Object[]{"variable list is empty at IN exp"});
                    }
                    int n3 = 0;
                    while (n3 < iVariableList2.size()) {
                        IVariableExpression iVariableExpression = iVariableList2.getVariableExp(n3);
                        if (ExpressionToolKit.isReference(iVariableExpression.expressionType()) || ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
                            throw new DSException(5013, new Object[]{"variable list can't includes " + ExpressionTypes.getExpressionName(iVariableExpression.expressionType())});
                        }
                        this.getCompatibleNumaricType(iVariableList2, iVariableExpression, attributeContainer, n);
                        ++n3;
                    }
                    break block18;
                }
                if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                    String string = ((IFormula)iExpression).getName();
                    this.getDSLog(attributeContainer.getElementByAliasName(string), (IFormula)iExpression);
                    break block18;
                }
                if (iVariableList != null && ExpressionToolKit.isParameter(iExpression.expressionType())) {
                    this.getName(iVariableList, iExpression, attributeContainer, iVariableList.size(), iVariableList.indexOf((IVariableExpression)iExpression));
                    break block18;
                }
                throw new DSException(5014, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression.expressionType())});
            }
            catch (ConditionException conditionException) {
                throw new DSException(5015, new Object[]{"Condition Exception"}, conditionException);
            }
        }
        return iExpression;
    }

    private void getDSLog(JAttribute jAttribute, IFormula iFormula) {
        try {
            iFormula.setDataType(jAttribute.getDataType());
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
    }

    private void getDataType(IConstant iConstant) throws ConditionException, DSException {
        if (iConstant.isNull()) {
            iConstant.setValue("false");
        } else {
            if (!(iConstant.getValue().equalsIgnoreCase("true") || iConstant.getValue().equalsIgnoreCase("false") || this.getDbValue(iConstant.getValue()))) {
                throw new DSException(5012, new Object[]{"sub exp " + iConstant + " data value error, must be true or false or nonzero or 0"});
            }
            if (this.getDate(iConstant)) {
                iConstant.setValue("false");
            } else if (this.getDataTypeName(iConstant)) {
                iConstant.setValue("true");
            }
        }
        iConstant.setDataType(-7);
    }

    private boolean getDataTypeName(IConstant iConstant) throws ConditionException {
        if (this.getDbValue(iConstant.getValue())) {
            return !this.getDate(iConstant);
        }
        return false;
    }

    private boolean getDate(IConstant iConstant) throws ConditionException {
        int n = -1;
        try {
            n = Integer.parseInt(iConstant.getValue());
            return n == 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean getDbValue(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(string);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    private void getElementByAliasName(IConstant iConstant) throws ConditionException {
    }

    private void getErrorKey(IExpression iExpression, IExpression iExpression2, IExpression iExpression3, AttributeContainer attributeContainer) throws DSException {
        ITupleOperator iTupleOperator = ((ITupleExpression)iExpression).getOperator();
        this.getExpression2(iExpression2);
        if (OperatorToolKit.isIn(iTupleOperator.operatorType())) {
            if (Types.isCompatible(this.getAllDBFields(iExpression2), this.getAllDBFields(iExpression3))) {
                return;
            }
            throw new DSException(5016, new Object[]{"sub exp 1 and sub exp 2 data type not compatible", ExpressionTypes.getExpressionName(iExpression2.expressionType()), ExpressionTypes.getExpressionName(iExpression3.expressionType())});
        }
        if (OperatorToolKit.isLike(iTupleOperator.operatorType())) {
            if (this.getAllDBFields(iExpression2) == 12 || this.getAllDBFields(iExpression3) == 12) {
                return;
            }
        } else {
            this.getExpression(iExpression2, iExpression3, null, attributeContainer);
            return;
        }
        throw new DSException(5017, new Object[]{"exp root semantic error"});
    }

    private void getExpression(IExpression iExpression, IExpression iExpression2, IExpression iExpression3, AttributeContainer attributeContainer) throws DSException {
        try {
            if (iExpression3 == null) {
                if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                        int n = this.getAllDBFields(iExpression);
                        int n2 = this.getAllDBFields(iExpression2);
                        if (Types.isNumeric(n) && Types.isNumeric(n)) {
                            if (this.getAllDBFields(iExpression) > this.getAllDBFields(iExpression2)) {
                                this.getExpression1(iExpression2, n);
                            } else {
                                this.getExpression1(iExpression, n2);
                            }
                            return;
                        }
                        if (this.getAllDBFields(iExpression) == this.getAllDBFields(iExpression2)) {
                            return;
                        }
                    } else if (ExpressionToolKit.isCalculateExp(iExpression2.expressionType())) {
                        return;
                    }
                } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                        return;
                    }
                    if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                        return;
                    }
                }
                throw new DSException(5018, new Object[]{"sub-exp data type not matched", iExpression.toString(), iExpression2.toString()});
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(5019, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private void getExpression1(IExpression iExpression, int n) throws ConditionException {
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            ((IReference)iExpression).setDataType(n);
        } else if (ExpressionToolKit.isFormula(iExpression.expressionType()) || ExpressionToolKit.isVariableList(iExpression.expressionType())) {
            // empty if block
        }
    }

    private void getExpression2(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isReference(iExpression.expressionType())) {
                return;
            }
            if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
                return;
            }
            if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                return;
            }
        } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
            return;
        }
        throw new DSException(5020, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression.expressionType())});
    }

    private void getExpression3(IExpression iExpression, IExpression iExpression2) throws DSException {
        if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            this.getIExpressionFactory(iExpression, iExpression2, this.QOIV);
            return;
        }
        if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
            this.getFormulaExecutor(iExpression, iExpression2, this.QOIV);
            return;
        }
        if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            this.getExpressionName(iExpression, iExpression2, this.QOIV);
            return;
        }
        throw new DSException(5021, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression.expressionType())});
    }

    private void getExpressionName(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException {
        IExpression iExpression3 = null;
        if (ExpressionToolKit.isSortExp(iExpression.expressionType())) {
            if (iExpression2 != null && (ExpressionToolKit.isTupleExp(iExpression2.expressionType()) || ExpressionToolKit.isSetExp(iExpression2.expressionType()))) {
                this.check(iExpression2, 0);
            }
            this.getFormatedParameters(iExpression, iExpression3, this.QOIV);
            return;
        }
        if (ExpressionToolKit.isTopNExp(iExpression.expressionType())) {
            if (iExpression2 != null && (ExpressionToolKit.isTupleExp(iExpression2.expressionType()) || ExpressionToolKit.isSetExp(iExpression2.expressionType()))) {
                this.check(iExpression2, 0);
            }
            this.getExpressions(iExpression, iExpression3, this.QOIV);
            return;
        }
        throw new DSException(5022, new Object[]{"not support exp type error", ExpressionTypes.getExpressionName(iExpression.expressionType())});
    }

    private void getExpressions(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException {
        ITopNOperator iTopNOperator = (ITopNOperator)((ITopNExpression)iExpression).getOperator();
        ITopNInformation iTopNInformation = (ITopNInformation)iTopNOperator.getOperatorInformation();
        if (!OperatorInfoToolkit.isTopNType(iTopNInformation.getTopNType())) {
            throw new DSException(5023, new Object[]{"topN type error"});
        }
        if (iTopNInformation.getTopNType() == 0 || iTopNInformation.getTopNType() == 1) {
            if (iTopNInformation.getN() < 0) {
                throw new DSException(5024, new Object[]{"topN N error"});
            }
            if ((iTopNInformation.getTopNType() == 3 || iTopNInformation.getTopNType() == 2) && iTopNInformation.getPercent() < 0.0) {
                throw new DSException(5025, new Object[]{"topN percent error"});
            }
        }
    }

    private void getFormatedParameters(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException {
        ISortInformation iSortInformation;
        ISortOperator iSortOperator = (ISortOperator)((ISortExpression)iExpression).getOperator();
        IOperatorInformation iOperatorInformation = iSortOperator.getOperatorInformation();
        if (OperatorInfoToolkit.isSortInformationCollector(iOperatorInformation.informationType())) {
            if (((ISortInformationCollector)iOperatorInformation).size() < 1) {
                throw new DSException(5026, new Object[]{"sort information collector was null"});
            }
            ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iOperatorInformation;
            int n = 0;
            while (n < iSortInformationCollector.size()) {
                String string;
                ISortInformation iSortInformation2 = iSortInformationCollector.getSortInformation(n);
                if (!OperatorInfoToolkit.isSortType(iSortInformation2.getSortType())) {
                    throw new DSException(5027, new Object[]{"sort type error : " + iSortInformation2.getSortType()});
                }
                try {
                    string = iSortInformation2.getReference().getName();
                }
                catch (ConditionException conditionException) {
                    throw new DSException(5028, new Object[]{"Condition Exception"}, conditionException);
                }
                if (attributeContainer.getElementByAliasName(string) == null) {
                    throw new DSException(5029, new Object[]{"reference " + string + "not found in att container"});
                }
                ++n;
            }
        } else if (OperatorInfoToolkit.isSortInformation(iOperatorInformation.informationType()) && !OperatorInfoToolkit.isSortType((iSortInformation = (ISortInformation)iOperatorInformation).getSortType())) {
            throw new DSException(5030, new Object[]{"sort type error"});
        }
    }

    private void getFormulaExecutor(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException {
    }

    private void getIExpressionFactory(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException {
        try {
            if (ExpressionToolKit.isSingleConditionExp(iExpression.expressionType())) {
                this.getSqlType(iExpression, iExpression2, attributeContainer);
                return;
            }
            if (ExpressionToolKit.isSingleLogicExp(iExpression.expressionType())) {
                this.getLength(iExpression, iExpression2, attributeContainer);
                return;
            }
            if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
                this.getMessage(iExpression, iExpression2, attributeContainer, -7);
                return;
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(5031, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private void getLength(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException {
        String string = null;
        try {
            string = iExpression2.toExpString();
            if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                this.getMessage(iExpression, iExpression2, attributeContainer, -7);
                return;
            }
            if (ExpressionToolKit.isBooleanExp(iExpression2.expressionType())) {
                return;
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(5032, new Object[]{"Condition Exception"}, conditionException);
        }
        throw new DSException(5033, new Object[]{"sub exp " + string + " data type error, must be boolean"});
    }

    private void getMessage(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer, int n) throws DSException, ConditionException {
        if (ExpressionToolKit.isReference(iExpression2.expressionType())) {
            this.getSortType(attributeContainer.getElementByAliasName(iExpression2.getName()), (IReference)iExpression2);
            return;
        }
        if (ExpressionToolKit.isParameter(iExpression2.expressionType())) {
            IExpression iExpression3 = this.getName(iExpression, iExpression2, attributeContainer, 1, 1);
            if (n == -7) {
                this.getN(iExpression3);
            }
            return;
        }
        if (ExpressionToolKit.isFormula(iExpression2.expressionType())) {
            FormulaMapping formulaMapping = (FormulaMapping)attributeContainer.getElementByAliasName(iExpression2.getName());
            if (formulaMapping.getDataType() == -7) {
                return;
            }
        } else if (ExpressionToolKit.isConstant(iExpression2.expressionType()) && n == -7) {
            this.getDataType((IConstant)iExpression2);
            return;
        }
        throw new DSException(5035, new Object[]{"sub exp " + iExpression2.toExpString() + " data type error, must be boolean"});
    }

    private void getN(IExpression iExpression) throws DSException, ConditionException {
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            IReference iReference = (IReference)iExpression;
            if (iReference.getDataType() == -7) {
                return;
            }
        } else if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
            IConstant iConstant = (IConstant)iExpression;
            if (iConstant.getDataType() == -7) {
                return;
            }
        } else {
            if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                return;
            }
            throw new DSException(5036, new Object[]{"parameter replace error"});
        }
        throw new DSException(5037, new Object[]{"parameter object must be boolean"});
    }

    private IExpression getName(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer, int n, int n2) throws DSException {
        if (ExpressionToolKit.isParameter(iExpression2.expressionType())) {
            IVariableExpression iVariableExpression = null;
            try {
                ParameterMapping parameterMapping = (ParameterMapping)attributeContainer.getElementByAliasName(iExpression2.getName());
                JParameter jParameter = parameterMapping.getParameter();
                iVariableExpression = this.getParameter(jParameter, attributeContainer) ? this.getScale(jParameter, parameterMapping, attributeContainer) : this.getTime(parameterMapping, parameterMapping.getDataType());
                if (n == 1) {
                    this.getReference(iExpression, iVariableExpression);
                } else if (n == 2) {
                    this.getPrecision(iExpression, iVariableExpression, n2);
                } else if (n == 3) {
                    this.getPercent(iExpression, iVariableExpression, n2);
                } else {
                    this.getOperatorInformation(iExpression, iVariableExpression, n2);
                }
            }
            catch (ConditionException conditionException) {
                throw new DSException(5038, new Object[]{"Condition Exception"}, conditionException);
            }
            return iVariableExpression;
        }
        return iExpression2;
    }

    private IExpression getOperator(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException {
        if (ExpressionToolKit.isParameter(iExpression2.expressionType())) {
            IVariableExpression iVariableExpression = null;
            try {
                ParameterMapping parameterMapping = (ParameterMapping)attributeContainer.getElementByAliasName(iExpression2.getName());
                JParameter jParameter = parameterMapping.getParameter();
                iVariableExpression = this.getParameter(jParameter, attributeContainer) ? this.getScale(jParameter, parameterMapping, attributeContainer) : this.getTime(parameterMapping, parameterMapping.getDataType());
            }
            catch (ConditionException conditionException) {
                throw new DSException(5038, new Object[]{"Condition Exception"}, conditionException);
            }
            return iVariableExpression;
        }
        return iExpression2;
    }

    private void getOperatorInformation(IExpression iExpression, IVariableExpression iVariableExpression, int n) throws DSException {
        block4: {
            IVariableList iVariableList = (IVariableList)iExpression;
            try {
                if (ExpressionToolKit.isConstant(iVariableExpression.expressionType())) {
                    iVariableList.setConstant((IConstant)iVariableExpression, n);
                    break block4;
                }
                if (ExpressionToolKit.isFormula(iVariableExpression.expressionType())) {
                    iVariableList.setFormula((IFormula)iVariableExpression, n);
                    break block4;
                }
                throw new DSException(5039, new Object[]{"sub exp typ error : " + ExpressionTypes.getExpressionName(iVariableExpression.expressionType())});
            }
            catch (ConditionException conditionException) {
                throw new DSException(5040, new Object[]{"can not set sub exp in IN exp"}, conditionException);
            }
        }
    }

    private boolean getParameter(JParameter jParameter, AttributeContainer attributeContainer) throws DSException {
        String string = null;
        string = jParameter.isReference() ? jParameter.getDbValue().toString() : this.getSortInformation(jParameter.getDbValue().toString());
        JDSDataField[] jDSDataFieldArray = attributeContainer.getAllDBFields();
        int n = 0;
        while (n < jDSDataFieldArray.length) {
            if (jDSDataFieldArray[n].getAliasName().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void getPercent(IExpression iExpression, IVariableExpression iVariableExpression, int n) throws ConditionException {
        if (ExpressionToolKit.isTripleConditonExp(iExpression.expressionType())) {
            if (n == 1) {
                ((ITripleConditionExpression)iExpression).setExpression1(iVariableExpression);
            } else if (n == 2) {
                ((ITripleConditionExpression)iExpression).setExpression2(iVariableExpression);
            } else if (n == 3) {
                ((ITripleConditionExpression)iExpression).setExpression3(iVariableExpression);
            }
        } else if (ExpressionToolKit.isTripleCalculateExp(iExpression.expressionType())) {
            if (n == 1) {
                ((ITripleCalculateExpression)iExpression).setExpression1(iVariableExpression);
            } else if (n == 3) {
                ((ITripleCalculateExpression)iExpression).setExpression2(iVariableExpression);
            } else if (n == 3) {
                ((ITripleCalculateExpression)iExpression).setExpression3(iVariableExpression);
            }
        }
    }

    private void getPrecision(IExpression iExpression, IVariableExpression iVariableExpression, int n) throws ConditionException {
        if (ExpressionToolKit.isBinaryTupleExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isBinaryConditionExp(iExpression.expressionType())) {
                IBinaryConditionExpression iBinaryConditionExpression = (IBinaryConditionExpression)iExpression;
                if (n == 1) {
                    iBinaryConditionExpression.setExpression1(iVariableExpression);
                } else {
                    iBinaryConditionExpression.setExpression2(iVariableExpression);
                }
            } else if (ExpressionToolKit.isBinaryLogicExp(iExpression.expressionType())) {
                IBinaryLogicExpression iBinaryLogicExpression = (IBinaryLogicExpression)iExpression;
                if (n == 1) {
                    iBinaryLogicExpression.setExpression1(iVariableExpression);
                } else {
                    iBinaryLogicExpression.setExpression2(iVariableExpression);
                }
            }
        } else if (ExpressionToolKit.isBinaryCalculateExp(iExpression.expressionType())) {
            if (n == 1) {
                ((IBinaryCalculateExpression)iExpression).setExpression1(iVariableExpression);
            } else {
                ((IBinaryCalculateExpression)iExpression).setExpression2(iVariableExpression);
            }
        }
    }

    private void getReference(IExpression iExpression, IVariableExpression iVariableExpression) throws ConditionException {
        if (ExpressionToolKit.isSingleConditionExp(iExpression.expressionType())) {
            ((ISingleConditionExpression)iExpression).setExpression(iVariableExpression);
        } else if (ExpressionToolKit.isSingleLogicExp(iExpression.expressionType())) {
            ((ISingleLogicExpression)iExpression).setExpression(iVariableExpression);
        }
    }

    private IReference getScale(JParameter jParameter, ParameterMapping parameterMapping, AttributeContainer attributeContainer) throws DSException, ConditionException {
        JDSDataField jDSDataField = (JDSDataField)attributeContainer.getElementByAliasName(jParameter.getDbValue().toString());
        if (jDSDataField != null) {
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            IReference iReference = iExpressionFactory.createReference(jDSDataField.getAliasName());
            this.getSortType(jDSDataField, iReference);
            return iReference;
        }
        throw new DSException(5041, new Object[]{"can not get JDSDataField in att container"});
    }

    private String getSortInformation(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 2);
        }
        return string;
    }

    private void getSortType(JAttribute jAttribute, IReference iReference) throws DSException {
        try {
            iReference.setDataType(jAttribute.getDataType());
            iReference.setLength(jAttribute.getLength());
            iReference.setCaseSensitive(jAttribute.isCaseSensitive());
            iReference.setCurrency(jAttribute.isCurrency());
            iReference.setNullable(jAttribute.isNullable());
            iReference.setPrecision(jAttribute.getPrecision());
            iReference.setScale(jAttribute.getScale());
        }
        catch (ConditionException conditionException) {
            throw new DSException(5042, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private void getSqlType(IExpression iExpression, IExpression iExpression2, AttributeContainer attributeContainer) throws DSException, ConditionException {
        if (ExpressionToolKit.isParameter(iExpression2.expressionType())) {
            this.getName(iExpression, iExpression2, attributeContainer, 1, 1);
        } else if (ExpressionToolKit.isConstant(iExpression2.expressionType())) {
            ((IConstant)iExpression2).setDataType(12);
            this.getElementByAliasName((IConstant)iExpression2);
        } else if (ExpressionToolKit.isReference(iExpression2.expressionType())) {
            this.getSortType(attributeContainer.getElementByAliasName(iExpression2.getName()), (IReference)iExpression2);
        } else if (ExpressionToolKit.isFormula(iExpression2.expressionType())) {
            return;
        }
    }

    private IConstant getTime(ParameterMapping parameterMapping, int n) throws DSException, ConditionException {
        String string = this.getSortInformation(parameterMapping.getName());
        ConstantImpl constantImpl = new ConstantImpl(string);
        try {
            constantImpl.setValue(this.getTimeZone(parameterMapping.getDbValue()));
            switch (n) {
                case -7: {
                    constantImpl.setDataType(-7);
                    break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    constantImpl.setDataType(-5);
                    break;
                }
                case 6: 
                case 8: {
                    constantImpl.setDataType(8);
                    break;
                }
                case 3: {
                    constantImpl.setDataType(3);
                    break;
                }
                case 12: {
                    constantImpl.setDataType(12);
                    break;
                }
                case 92: {
                    constantImpl.setDataType(92);
                    break;
                }
                case 93: {
                    constantImpl.setDataType(93);
                    break;
                }
                case 91: {
                    constantImpl.setDataType(91);
                    break;
                }
                default: {
                    throw new DSException(5044, new Object[]{"constant parameter data type error : " + n});
                }
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(5045, new Object[]{"Condition Exception"}, conditionException);
        }
        return constantImpl;
    }

    private String getTimeZone(DbValue dbValue) {
        String string = null;
        SimpleDateFormat simpleDateFormat = null;
        if (dbValue.getSqlType() == 91) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            string = simpleDateFormat.format(((DbDate)dbValue).getDate());
        } else if (dbValue.getSqlType() == 92) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            string = simpleDateFormat.format(((DbTime)dbValue).getTime());
        } else if (dbValue.getSqlType() == 93) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            string = simpleDateFormat.format(((DbTimestamp)dbValue).getTimestamp());
        } else {
            string = dbValue.toString();
        }
        return string;
    }

    private IExpression getTimestamp(IExpression iExpression, AttributeContainer attributeContainer) throws DSException {
        IExpression iExpression2 = null;
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
                iExpression2 = ((ITripleTupleExpression)iExpression).getExpression3();
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                iExpression2 = ((ITripleCalculateExpression)iExpression).getExpression3();
            }
            if (ExpressionToolKit.isParameter(iExpression2.expressionType())) {
                iExpression2 = this.getName(iExpression, iExpression2, attributeContainer, 3, 3);
            }
        } else {
            throw new DSException(5046, new Object[]{"exp type error, have not sub-exp"});
        }
        return iExpression2;
    }

    private IExpression getTopNType(IExpression iExpression, AttributeContainer attributeContainer) throws DSException {
        IExpression iExpression2 = null;
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
                iExpression2 = ((IBinaryTupleExpression)iExpression).getExpression2();
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                iExpression2 = ((IBinaryCalculateExpression)iExpression).getExpression2();
            }
            if (ExpressionToolKit.isParameter(iExpression2.expressionType())) {
                iExpression2 = this.getName(iExpression, iExpression2, attributeContainer, 2, 2);
            }
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
                iExpression2 = ((ITripleTupleExpression)iExpression).getExpression2();
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                iExpression2 = ((ITripleCalculateExpression)iExpression).getExpression2();
            }
            if (ExpressionToolKit.isParameter(iExpression2.expressionType())) {
                iExpression2 = this.getName(iExpression, iExpression2, attributeContainer, 3, 2);
            }
        } else {
            throw new DSException(5047, new Object[]{"exp type error, have not sub-exp"});
        }
        return iExpression2;
    }

    private IExpression getValue(IExpression iExpression, AttributeContainer attributeContainer) throws DSException {
        IExpression iExpression2 = null;
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
                iExpression2 = ((ISingleTupleExpression)iExpression).getExpression();
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                iExpression2 = ((ISingleCalculateExpression)iExpression).getExpression();
            } else if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
                iExpression2 = ((ISetExpression)iExpression).getExpression();
            }
            if (iExpression2 != null && ExpressionToolKit.isParameter(iExpression2.expressionType())) {
                iExpression2 = this.getName(iExpression, iExpression2, attributeContainer, 1, 1);
            }
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
                iExpression2 = ((IBinaryTupleExpression)iExpression).getExpression1();
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                iExpression2 = ((IBinaryCalculateExpression)iExpression).getExpression1();
            }
            if (iExpression2 != null && ExpressionToolKit.isParameter(iExpression2.expressionType())) {
                iExpression2 = this.getName(iExpression, iExpression2, attributeContainer, 2, 1);
            }
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
                iExpression2 = ((ITripleTupleExpression)iExpression).getExpression1();
            } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
                iExpression2 = ((ITripleCalculateExpression)iExpression).getExpression1();
            }
            if (iExpression2 != null && ExpressionToolKit.isParameter(iExpression2.expressionType())) {
                iExpression2 = this.getName(iExpression, iExpression2, attributeContainer, 3, 1);
            }
        } else {
            throw new DSException(5048, new Object[]{"exp type error, have not sub-exp"});
        }
        return iExpression2;
    }
}

