/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.TPaintBoard;
import guitools.toolkit.TransparentPeer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class TComponent
extends Component
implements TransparentPeer {
    protected boolean eraser = true;
    protected TPaintBoard tpb;
    private static int QOIV = 0;

    public TComponent() {
        this.setName("TComponent" + QOIV++);
    }

    public void addNotify() {
        this.tpb = this.getPaintBoard();
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.tpb = null;
    }

    public boolean hasEraser() {
        return this.eraser;
    }

    public void setEraser(boolean bl) {
        if (this.eraser != bl) {
            this.eraser = bl;
            this.repaint();
        }
    }

    public TPaintBoard getPaintBoard() {
        if (this.tpb == null) {
            Container container = this.getParent();
            while (container != null && !(container instanceof TPaintBoard)) {
                container = container.getParent();
            }
            this.tpb = (TPaintBoard)container;
        }
        return this.tpb;
    }

    public void repaintImage() {
        Dimension dimension = this.getSize();
        this.repaintImage(0, 0, dimension.width, dimension.height);
    }

    public void repaintImage(int n, int n2, int n3, int n4) {
        if (this.tpb != null) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            rectangle = rectangle.intersection(new Rectangle(n, n2, n3, n4));
            this.mapToBoard(rectangle);
            this.tpb.prepareRepaintImage(rectangle);
        }
    }

    public boolean isFront() {
        Container container = this.getParent();
        return container == null ? false : container.getComponent(0) == this;
    }

    public boolean isBack() {
        Container container = this.getParent();
        return container == null ? false : container.getComponent(container.getComponentCount() - 1) == this;
    }

    public void bringToTop() {
        Container container = this.getParent();
        if (container != null) {
            container.add((Component)this, 0);
            if (container instanceof TransparentPeer) {
                ((TransparentPeer)((Object)container)).bringToTop();
            }
        }
    }

    public void toZOrderPos(int n) {
        Container container = this.getParent();
        if (container != null) {
            container.add((Component)this, n);
        }
    }

    public void toFront() {
        Container container = this.getParent();
        if (container != null && !this.isFront()) {
            container.add((Component)this, 0);
        }
    }

    public void toBack() {
        Container container = this.getParent();
        if (container != null && !this.isBack()) {
            container.add(this);
        }
    }

    public void forward() {
        Container container = this.getParent();
        if (container != null && !this.isFront()) {
            container.add((Component)this, this.indexOfAtParent() - 1);
        }
    }

    public void backward() {
        Container container = this.getParent();
        if (container != null && !this.isBack()) {
            container.add((Component)this, this.indexOfAtParent() + 1);
        }
    }

    protected int indexOfAtParent() {
        Container container = this.getParent();
        if (container != null) {
            int n = container.getComponentCount() - 1;
            while (n >= 0) {
                if (container.getComponent(n) == this) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public Point mapToBoard(int n, int n2) {
        Point point = new Point(n, n2);
        this.mapToBoard(point);
        return point;
    }

    public void mapToBoard(Point point) {
        Container container = this.getParent();
        Point point2 = this.getLocation();
        point.translate(point2.x, point2.y);
        while (container != this.tpb) {
            point2 = container.getLocation();
            point.translate(point2.x, point2.y);
            container = container.getParent();
        }
    }

    public Rectangle mapToBoard(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.mapToBoard(rectangle);
        return rectangle;
    }

    public void mapToBoard(Rectangle rectangle) {
        Point point = this.mapToBoard(rectangle.x, rectangle.y);
        rectangle.setLocation(point.x, point.y);
    }

    public Point mapLocToBoard() {
        return this.mapToBoard(0, 0);
    }

    public Rectangle mapBoundsToBoard() {
        Point point = this.mapLocToBoard();
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        return rectangle;
    }

    public Point mapToComp(int n, int n2) {
        Point point = new Point(n, n2);
        this.mapToComp(point);
        return point;
    }

    public void mapToComp(Point point) {
        Container container = this.getParent();
        Point point2 = this.getLocation();
        point.translate(-point2.x, -point2.y);
        while (container != this.tpb) {
            point2 = container.getLocation();
            point.translate(-point2.x, -point2.y);
            container = container.getParent();
        }
    }

    public Rectangle mapToComp(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.mapToComp(rectangle);
        return rectangle;
    }

    public void mapToComp(Rectangle rectangle) {
        Point point = this.mapToComp(rectangle.x, rectangle.y);
        rectangle.setLocation(point.x, point.y);
    }
}

