/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.GUIContent;
import html.Hyperlinkable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GUIListLabel
extends GUIContent {
    int drawOval;

    public GUIListLabel(Hyperlinkable hyperlinkable, Font font, int n) {
        super(hyperlinkable);
        this.setFont(font);
        this.drawOval = n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getToolkit().getFontMetrics(font);
            dimension.width = 40;
            dimension.height = fontMetrics.getAscent() + fontMetrics.getDescent();
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        rectangle.x = rectangle.width - rectangle.height - 1;
        rectangle.width = 7;
        rectangle.y = (rectangle.height - rectangle.width) / 2 + 1;
        rectangle.height = rectangle.width;
        graphics.setColor(this.getForeground());
        switch (this.drawOval) {
            case 5: {
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                break;
            }
            case 6: {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                break;
            }
            case 7: {
                graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    protected void dump(String string) {
        System.out.println(string + this.toString());
    }
}

