/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBit;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbBooleanColumnBuffer
extends DbColumnBuffer {
    boolean[] QOIV;

    public boolean[] getBuffer() {
        return this.QOIV;
    }

    public DbBooleanColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.QOIV = new boolean[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.QOIV[n] = ((DbBit)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBit)dbValue).set(this.QOIV[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.writeBoolean(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = dataInput.readBoolean();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
    }
}

