/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.SortInfo;
import jet.dataengine.api.SortObject;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.groupengine.GroupImpl;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.LeafGroup;
import jet.dataengine.groupengine.LeafGroupModel;
import jet.dataengine.groupengine.MidGroup;
import jet.dataengine.groupengine.ParaLeafGroupModel;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.externalsort.MergerSort;
import jet.dataengine8.dbbuffer.RecordImpl;
import jet.dataengine8.dbbuffer.RecordTool;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;

public class SortProcessor {
    public static final int GROUP_LEVL = 0;
    public static final int DETAIL_LEVL = 1;
    private IntKeyHashtable QOIV;
    private IntKeyHashtable add;
    private ArrayList addElement;
    private ArrayList append;
    private static DSLog appendRecord = DSLog.getDSLog((class$jet$dataengine$api$SortProcessor == null ? (class$jet$dataengine$api$SortProcessor = SortProcessor.class$("jet.dataengine.api.SortProcessor")) : class$jet$dataengine$api$SortProcessor).getName());
    private int class$ = -1;
    static Class class$jet$dataengine$api$SortProcessor;

    public void doSort(IntKeyHashtable[] intKeyHashtableArray, Group group, int n) {
        this.class$ = n;
        this.QOIV = intKeyHashtableArray[0];
        this.add = intKeyHashtableArray[1];
        if (this.QOIV.size() > 0) {
            this.addElement = new ArrayList();
        }
        if (this.add.size() > 0) {
            this.append = new ArrayList();
        }
        if (this.addElement != null || this.append != null) {
            group.getGroupModel().setDataChanged(true);
            this.QOIV(group);
        }
        if (this.addElement != null) {
            this.add();
        }
        if (this.append != null) {
            this.addElement();
        }
        this.clear();
    }

    private void clear() {
        this.addElement = null;
        this.QOIV = null;
        this.append = null;
        this.add = null;
    }

    private void QOIV(Group group) {
        Vector vector;
        if (group.getGroupType() == 1) {
            ((LeafGroup)group).resetRecords();
        } else {
            ((MidGroup)group).resetSubgroups();
        }
        if (group.isAvail()) {
            int n = group.getGroupModel().getGroupIndex();
            if (this.addElement != null && this.QOIV.containsKey(n) && !this.addElement.contains(group)) {
                this.addElement.add(group);
            }
            if (this.append != null && this.add.containsKey(n)) {
                this.append.add(group);
            }
        }
        int n = (vector = group.getSubgroups()) != null ? vector.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            this.QOIV((Group)vector.elementAt(n2));
            ++n2;
        }
        Vector vector2 = group.getSiblings();
        int n3 = vector2 != null ? vector2.size() : 0;
        int n4 = 0;
        while (n4 < n3) {
            this.QOIV((Group)vector2.elementAt(n4));
            ++n4;
        }
    }

    private void add() {
        int n = 0;
        while (n < this.addElement.size()) {
            GroupImpl groupImpl = (GroupImpl)this.addElement.get(n);
            SortInfo sortInfo = (SortInfo)this.QOIV.get(groupImpl.getGroupModel().getGroupIndex());
            groupImpl.sortGroup(true, sortInfo.getSortType()[0]);
            ++n;
        }
    }

    private void addElement() {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < this.append.size()) {
            Object[] objectArray;
            LeafGroup leafGroup = (LeafGroup)this.append.get(n);
            int n2 = leafGroup.getRecordIndexs().size();
            SortInfo sortInfo = (SortInfo)this.add.get(leafGroup.getGroupModel().getGroupIndex());
            GroupModel groupModel = leafGroup.getGroupModel();
            DbColDesc[] dbColDescArray = sortInfo.getSortColDesc();
            GroupModel groupModel2 = groupModel.createSortGroupInLeaf(dbColDescArray, sortInfo.getSortType());
            JRecord jRecord = null;
            GroupModel groupModel3 = leafGroup.getGroupModel();
            jRecord = groupModel3.getType() != 5 ? ((LeafGroupModel)leafGroup.getGroupModel()).getTempRecordForOuter() : ((ParaLeafGroupModel)leafGroup.getGroupModel()).getTempRecordForOuter();
            if (this.class$ == -1) {
                l = System.currentTimeMillis();
                objectArray = this.class$jet$dataengine$api$SortProcessor(leafGroup, jRecord, sortInfo);
                this.append(leafGroup, (SortObject[])objectArray);
                l2 += System.currentTimeMillis() - l;
            } else {
                SortObject[] sortObjectArray;
                RecordModelInfo recordModelInfo;
                int n3;
                int n4;
                int n5;
                DbColDesc dbColDesc;
                l = System.currentTimeMillis();
                objectArray = sortInfo.getSortColDesc();
                DbColDesc[] dbColDescArray2 = new DbColDesc[objectArray.length + 1];
                int[] nArray = sortInfo.getSortType();
                int[] nArray2 = new int[nArray.length];
                int n6 = 0;
                while (n6 < nArray2.length) {
                    nArray2[n6] = nArray[n6] == 0 ? 1 : -1;
                    dbColDescArray2[n6] = (DbColDesc)((DbColDesc)objectArray[n6]).clone();
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, "Sort Type " + n6 + " is:" + nArray2[n6]);
                        JRLog.trace(5, "DbColDesc " + n6 + " is:" + dbColDescArray2[n6].toString());
                    }
                    ++n6;
                }
                dbColDescArray2[nArray.length] = dbColDesc = new DbColDesc(null, 4, 255, 0, 2);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "DbColDesc of record position " + nArray.length + " is:" + dbColDesc.toString());
                }
                if ((n5 = (n4 = this.class$ < 4 ? 4 : this.class$) * 1024 * 1024 / (n3 = RecordTool.getRecordLen((recordModelInfo = new RecordModelInfo(dbColDescArray2)).getColDescs()))) > n2) {
                    sortObjectArray = this.class$jet$dataengine$api$SortProcessor(leafGroup, jRecord, sortInfo);
                    this.append(leafGroup, sortObjectArray);
                    l2 += System.currentTimeMillis() - l;
                } else {
                    sortObjectArray = new MergerSort(recordModelInfo, n4, nArray2);
                    try {
                        JDbBufferCursor jDbBufferCursor = this.appendRecord((MergerSort)sortObjectArray, leafGroup, jRecord, recordModelInfo);
                        this.class$(leafGroup, jDbBufferCursor);
                        sortObjectArray.close();
                    }
                    catch (DSException dSException) {
                        appendRecord.error(4152, dSException);
                    }
                    l2 += System.currentTimeMillis() - l;
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, "MemorySize for sort tool:" + n4);
                    }
                }
            }
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "Sort record counts are:" + n2 + " for leaf group(GroupValue):" + leafGroup.getGroupValue());
            }
            ++n;
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Sort detail action elapses:" + l2);
        }
    }

    private void append(LeafGroup leafGroup, SortObject[] sortObjectArray) {
        IntVector intVector = new IntVector();
        int n = 0;
        while (n < sortObjectArray.length) {
            intVector.addElement(sortObjectArray[n].getPos());
            ++n;
        }
        leafGroup.setRecordIndexs(intVector);
    }

    private JDbBufferCursor appendRecord(MergerSort mergerSort, LeafGroup leafGroup, JRecord jRecord, RecordModelInfo recordModelInfo) throws DSException {
        IntVector intVector = leafGroup.getRecordIndexs();
        int n = intVector.size();
        DbColDesc[] dbColDescArray = recordModelInfo.getColDescs();
        RecordImpl recordImpl = null;
        DbValue dbValue = null;
        int[] nArray = new int[dbColDescArray.length - 1];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = jRecord.indexOfCell(dbColDescArray[n2].getColName());
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            jRecord.setPosition(intVector.elementAt(n3));
            jRecord.refresh(true);
            recordImpl = new RecordImpl(recordModelInfo);
            int n4 = 0;
            while (n4 < dbColDescArray.length - 1) {
                dbValue = recordImpl.getCell(n4);
                dbValue.set((DbValue)jRecord.getCell(nArray[n4]).clone());
                ++n4;
            }
            ((DbInteger)recordImpl.getCell(dbColDescArray.length - 1)).set(jRecord.getPosition());
            mergerSort.appendRecord(recordImpl);
            ++n3;
        }
        return mergerSort.finish();
    }

    private void class$(LeafGroup leafGroup, JDbBufferCursor jDbBufferCursor) throws DSException {
        JRecord jRecord = jDbBufferCursor.createRecord();
        int n = jRecord.columnCount() - 1;
        IntVector intVector = new IntVector();
        int n2 = 0;
        while (jDbBufferCursor.next()) {
            jRecord.setPosition(jDbBufferCursor.getPosition());
            jRecord.refresh(true);
            n2 = ((DbInteger)jRecord.getCell(n)).get();
            intVector.addElement(n2);
        }
        leafGroup.setRecordIndexs(intVector);
    }

    private SortObject[] class$jet$dataengine$api$SortProcessor(LeafGroup leafGroup, JRecord jRecord, SortInfo sortInfo) {
        IntVector intVector = leafGroup.getRecordIndexs();
        int n = intVector.size();
        Object[] objectArray = new SortObject[n];
        int[] nArray = sortInfo.getSortType();
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        DbColDesc[] dbColDescArray = sortInfo.getSortColDesc();
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray2[n3] = nArray[n3] == 0 ? 1 : -1;
            nArray3[n3] = jRecord.getCell(dbColDescArray[n3].getColName()).getColDesc().getColIndex();
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            jRecord.setPosition(intVector.elementAt(n4));
            jRecord.refresh(true);
            DbValue[] dbValueArray = new DbValue[n2];
            int n5 = 0;
            while (n5 < dbValueArray.length) {
                dbValueArray[n5] = (DbValue)jRecord.getCell(nArray3[n5]).clone();
                ++n5;
            }
            objectArray[n4] = new SortObject(dbValueArray, nArray2, jRecord.getPosition());
            ++n4;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

