/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.dataservice.api.schema.relational.datasource.JDSConnection;
import java.util.LinkedList;
import java.util.List;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IMulti;
import jet.dataengine.api.expression.IOperatorInformation;
import jet.dataengine.api.expression.ISingle;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.OperatorInfoToolkit;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.IConditionExpression;
import jet.dataengine.api.expression.tuple.ILogicExpression;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.util.DSLog;
import jet.dataengine8.core.pushdown.ConstatntFormulaProcessor;
import jet.dataengine8.core.pushdown.ExpPreProcess;
import jet.dataengine8.core.pushdown.NotProcessor;
import jet.dataengine8.core.pushdown.SQL92PushDownParser;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.universe.JetUSupportInfo;

public abstract class ExpPushDownParser {
    protected static IExpression root;
    protected static IExpression leafSet;
    protected static IExpression parentSet;
    protected static IExpression leafFilter;
    private static DSLog QOIV;
    protected JDSConnection connection;
    protected ResourceContainer resource;
    protected JetUSupportInfo supportInfo;
    protected List pushFilterExps;
    protected List localExps;
    protected ISortExpression localSortExp;
    protected ISortExpression pushSortExp;
    protected String sortString;
    protected String topNString;
    protected String filterString;
    static Class class$jet$dataengine8$core$pushdown$ExpPushDownParser;
    static final boolean $assertionsDisabled;

    protected ExpPushDownParser(ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo) throws DSException {
        if (resourceContainer == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"ResourceContainer was null");
        }
        this.resource = resourceContainer;
        if (jDSConnection == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"JDSConnection was null");
        }
        this.connection = jDSConnection;
        if (jetUSupportInfo == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"JetUJdbcSupportInfo was null");
        }
        this.supportInfo = jetUSupportInfo;
        this.pushFilterExps = new LinkedList();
        this.localExps = new LinkedList();
        this.localSortExp = null;
        this.pushSortExp = null;
        this.sortString = null;
        this.topNString = null;
        this.filterString = null;
    }

    public static ExpPushDownParser getInstance(IExpression iExpression, ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo) throws DSException {
        IExpression iExpression2;
        try {
            iExpression2 = ExpressionToolKit.cloneExpression(iExpression);
        }
        catch (ConditionException conditionException) {
            throw new DSException(2509, new Object[]{"Condition Exception"}, conditionException);
        }
        if (iExpression2 == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"uncheck exp was null");
        }
        if (resourceContainer == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"resource containter was null");
        }
        if (jDSConnection == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"JDSConnection was null");
        }
        if (jetUSupportInfo == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"JDSConnection was null");
        }
        iExpression2 = ExpPushDownParser.QOIV(iExpression2, resourceContainer);
        ExpPushDownParser expPushDownParser = ExpPushDownParser.add(resourceContainer, jDSConnection, jetUSupportInfo);
        expPushDownParser.parse(iExpression2);
        return expPushDownParser;
    }

    public static ExpPushDownParser getInstance(IExpression iExpression, ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo, DbValue[] dbValueArray) throws DSException {
        IExpression iExpression2;
        try {
            iExpression2 = ExpressionToolKit.cloneExpression(iExpression);
        }
        catch (ConditionException conditionException) {
            throw new DSException(2509, new Object[]{"Condition Exception"}, conditionException);
        }
        if (iExpression2 == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"uncheck exp was null");
        }
        if (resourceContainer == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"resource containter was null");
        }
        if (jDSConnection == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"JDSConnection was null");
        }
        if (jetUSupportInfo == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"JDSConnection was null");
        }
        iExpression2 = ExpPushDownParser.$assertionsDisabled(iExpression2, resourceContainer, dbValueArray);
        ExpPushDownParser expPushDownParser = ExpPushDownParser.add(resourceContainer, jDSConnection, jetUSupportInfo);
        expPushDownParser.parse(iExpression2);
        return expPushDownParser;
    }

    private static IExpression $assertionsDisabled(IExpression iExpression, ResourceContainer resourceContainer, DbValue[] dbValueArray) throws DSException {
        ExpPushDownParser.append(iExpression);
        ExpPreProcess expPreProcess = new ExpPreProcess(resourceContainer);
        expPreProcess.process(iExpression);
        ConstatntFormulaProcessor constatntFormulaProcessor = new ConstatntFormulaProcessor(resourceContainer, dbValueArray);
        constatntFormulaProcessor.processConstantFormulas(iExpression);
        ExpPushDownParser.append(iExpression);
        return iExpression;
    }

    private static IExpression QOIV(IExpression iExpression, ResourceContainer resourceContainer) throws DSException {
        ExpPushDownParser.append(iExpression);
        ExpPreProcess expPreProcess = new ExpPreProcess(resourceContainer);
        expPreProcess.process(iExpression);
        ExpPushDownParser.append(iExpression);
        return iExpression;
    }

    private static ExpPushDownParser add(ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo) throws DSException {
        return new SQL92PushDownParser(resourceContainer, jDSConnection, jetUSupportInfo);
    }

    public static ExpPushDownParser getSQL92Instance(IExpression iExpression, ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo) throws DSException {
        IExpression iExpression2;
        try {
            iExpression2 = ExpressionToolKit.cloneExpression(iExpression);
        }
        catch (ConditionException conditionException) {
            throw new DSException(2509, new Object[]{"Condition Exception"}, conditionException);
        }
        if (iExpression2 == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"uncheck exp was null");
        }
        if (resourceContainer == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"resource containter was null");
        }
        if (jDSConnection == null && !$assertionsDisabled) {
            throw new AssertionError((Object)"JDSConnection was null");
        }
        root = ExpPushDownParser.QOIV(iExpression2, resourceContainer);
        leafSet = NotProcessor.getLeafSetExp(root);
        parentSet = NotProcessor.getLastSecondLeafSetExp(root);
        leafFilter = NotProcessor.getLeafTupleExp(root);
        SQL92PushDownParser sQL92PushDownParser = new SQL92PushDownParser(resourceContainer, jDSConnection, jetUSupportInfo);
        if (leafSet == null) {
            sQL92PushDownParser.parse(leafFilter);
        } else {
            sQL92PushDownParser.parse(leafSet);
        }
        return sQL92PushDownParser;
    }

    private static void append(IExpression iExpression) throws DSException {
        try {
            QOIV.debug(2500 + iExpression.toExpString());
        }
        catch (ConditionException conditionException) {
            throw new DSException(2500, new Object[]{"exp to string error"}, conditionException);
        }
    }

    protected void parse(IExpression iExpression) throws DSException {
        try {
            if (this.buildAndExpression(iExpression)) {
                ISortExpression iSortExpression = (ISortExpression)iExpression;
                IExpression iExpression2 = iSortExpression.getExpression();
                if (iExpression2 != null) {
                    iSortExpression.setExpression(null);
                    this.parse(iExpression2);
                }
                if (this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iSortExpression)) {
                    this.pushSortExp = iSortExpression;
                } else {
                    this.localSortExp = iSortExpression;
                }
            } else if (this.class$(iExpression)) {
                IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iExpression;
                IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
                int n = 0;
                while (n < iExpressionArray.length) {
                    this.parse(iExpressionArray[n]);
                    ++n;
                }
            } else if (this.desiredAssertionStatus(iExpression)) {
                if (this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iExpression)) {
                    this.pushFilterExps.add(iExpression);
                } else {
                    this.localExps.add(iExpression);
                }
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2502, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private boolean buildAndExpression(IExpression iExpression) {
        return ExpressionToolKit.isSortExp(iExpression.expressionType());
    }

    private boolean class$(IExpression iExpression) {
        return (ExpressionToolKit.isMultiLogicExp(iExpression.expressionType()) || ExpressionToolKit.isBinaryLogicExp(iExpression.expressionType())) && OperatorToolKit.isAnd(((IMultiLogicExpression)iExpression).getOperator().operatorType());
    }

    private boolean class$jet$dataengine8$core$pushdown$ExpPushDownParser(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            return this.debug((IVariableExpression)iExpression);
        }
        if (ExpressionToolKit.isLogicExp(iExpression.expressionType())) {
            return this.containsIgnoreCase((ILogicExpression)iExpression);
        }
        if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
            return this.connection((IConditionExpression)iExpression);
        }
        if (ExpressionToolKit.isSortExp(iExpression.expressionType())) {
            return this.cloneExpression((ISortExpression)iExpression);
        }
        return false;
    }

    private boolean cloneExpression(ISortExpression iSortExpression) throws DSException {
        IOperatorInformation iOperatorInformation = ((ISortOperator)iSortExpression.getOperator()).getOperatorInformation();
        if (OperatorInfoToolkit.isSortInformation(iOperatorInformation.informationType())) {
            return this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(((ISortInformation)iOperatorInformation).getReference());
        }
        if (OperatorInfoToolkit.isSortInformationCollector(iOperatorInformation.informationType())) {
            ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iOperatorInformation;
            int n = 0;
            while (n < iSortInformationCollector.size()) {
                if (!this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iSortInformationCollector.getSortInformation(n).getReference())) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        throw new DSException(2503, new Object[]{"sort infor type error : " + iOperatorInformation.informationType()});
    }

    private boolean connection(IConditionExpression iConditionExpression) throws DSException {
        ITriple iTriple;
        IBinary iBinary;
        ISingle iSingle;
        return ExpressionToolKit.isSingleExp(iConditionExpression.expressionType()) ? this.class$jet$dataengine8$core$pushdown$ExpPushDownParser((iSingle = (ISingle)((Object)iConditionExpression)).getExpression()) : (ExpressionToolKit.isBinaryExp(iConditionExpression.expressionType()) ? this.class$jet$dataengine8$core$pushdown$ExpPushDownParser((iBinary = (IBinary)((Object)iConditionExpression)).getExpression1()) && this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iBinary.getExpression2()) : ExpressionToolKit.isTripleExp(iConditionExpression.expressionType()) && this.class$jet$dataengine8$core$pushdown$ExpPushDownParser((iTriple = (ITriple)((Object)iConditionExpression)).getExpression1()) && this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iTriple.getExpression2()) && this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iTriple.getExpression3()));
    }

    private boolean containsIgnoreCase(ILogicExpression iLogicExpression) throws DSException {
        if (OperatorToolKit.isNot(iLogicExpression.getOperator().operatorType())) {
            ISingle iSingle = (ISingle)((Object)iLogicExpression);
            if (this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iSingle.getExpression())) {
                return true;
            }
        } else if (OperatorToolKit.isOr(iLogicExpression.getOperator().operatorType())) {
            IMulti iMulti = (IMulti)((Object)iLogicExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            int n = 0;
            while (n < iExpressionArray.length) {
                if (!this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iExpressionArray[n])) {
                    return false;
                }
                ++n;
            }
        } else if (OperatorToolKit.isAnd(iLogicExpression.getOperator().operatorType())) {
            IMulti iMulti = (IMulti)((Object)iLogicExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            int n = 0;
            while (n < iExpressionArray.length) {
                if (this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iExpressionArray[n])) {
                    return true;
                }
                ++n;
            }
        } else {
            throw new DSException(2504, new Object[]{"logic exp type error : " + iLogicExpression.expressionType()});
        }
        return false;
    }

    private boolean debug(IVariableExpression iVariableExpression) throws DSException {
        try {
            if (ExpressionToolKit.isFormula(iVariableExpression.expressionType())) {
                if (this.resource.containsIgnoreCase(iVariableExpression.getName())) {
                    this.resource.getStringValue();
                    if (this.resource.wasFormula() && this.resource.wasConstantFornula() && this.resource.getFormulaPushDownString() != null && !this.resource.getFormulaPushDownString().equals("")) {
                        return true;
                    }
                }
            } else {
                if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
                    IVariableList iVariableList = (IVariableList)iVariableExpression;
                    int n = 0;
                    while (n < iVariableList.size()) {
                        if (!this.class$jet$dataengine8$core$pushdown$ExpPushDownParser(iVariableList.getVariableExp(n))) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                if (ExpressionToolKit.isConstant(iVariableExpression.expressionType())) {
                    return !((IConstant)iVariableExpression).isNull();
                }
                if (ExpressionToolKit.isReference(iVariableExpression.expressionType())) {
                    if (this.resource.containsIgnoreCase(iVariableExpression.getName())) {
                        this.resource.getStringValue();
                        if (this.resource.wasField()) {
                            return true;
                        }
                    }
                } else if (ExpressionToolKit.isParameter(iVariableExpression.expressionType())) {
                    if (this.resource.containsIgnoreCase(iVariableExpression.getName())) {
                        this.resource.getStringValue();
                        if (this.resource.wasParameter()) {
                            return true;
                        }
                    }
                } else {
                    throw new DSException(2505, new Object[]{"variable expression type error"});
                }
            }
            return false;
        }
        catch (ConditionException conditionException) {
            throw new DSException(2506, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private boolean desiredAssertionStatus(IExpression iExpression) {
        if (ExpressionToolKit.isTopNExp(iExpression.expressionType())) {
            return true;
        }
        if (ExpressionToolKit.isSortExp(iExpression.expressionType())) {
            return false;
        }
        if (!ExpressionToolKit.isBooleanExp(iExpression.expressionType())) {
            return true;
        }
        return !OperatorToolKit.isAnd(((ITupleExpression)iExpression).getOperator().operatorType());
    }

    public IExpression getLocalSetExpression() throws DSException {
        if (parentSet == null) {
            return this.localSortExp;
        }
        try {
            ((ISetExpression)parentSet).setExpression(this.localSortExp);
        }
        catch (ConditionException conditionException) {
            throw new DSException(2509, new Object[]{"Condition Exception"}, conditionException);
        }
        return root;
    }

    public IExpression getLocalConditionExpression() throws DSException {
        IExpression iExpression = null;
        IBooleanExpression iBooleanExpression = null;
        IBooleanExpression iBooleanExpression2 = null;
        if (this.localExps.size() > 0) {
            if (this.localExps.size() == 1) {
                iExpression = (IExpression)this.localExps.get(0);
            } else {
                iBooleanExpression = (IBooleanExpression)this.localExps.get(0);
                this.localExps.remove(0);
                iBooleanExpression2 = (IBooleanExpression)this.localExps.get(0);
                this.localExps.remove(0);
                try {
                    iExpression = ExpressionToolKit.buildAndExpression(iBooleanExpression, iBooleanExpression2);
                    while (this.localExps.size() > 0) {
                        iBooleanExpression2 = (IBooleanExpression)this.localExps.get(0);
                        this.localExps.remove(0);
                        iExpression = ExpressionToolKit.buildAndExpression((IBooleanExpression)iExpression, iBooleanExpression2);
                    }
                }
                catch (ConditionException conditionException) {
                    throw new DSException(2507, new Object[]{"can not build and logic exp"}, conditionException);
                }
            }
        }
        if (iExpression != null) {
            iExpression = this.equals(iExpression);
        }
        return iExpression;
    }

    private IExpression equals(IExpression iExpression) {
        return iExpression;
    }

    public abstract String getSQLConditionString() throws DSException;

    public abstract String getSQLSortString() throws DSException;

    public abstract String getSQLTopNString() throws DSException;

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$dataengine8$core$pushdown$ExpPushDownParser == null ? (class$jet$dataengine8$core$pushdown$ExpPushDownParser = ExpPushDownParser.class$("jet.dataengine8.core.pushdown.ExpPushDownParser")) : class$jet$dataengine8$core$pushdown$ExpPushDownParser).desiredAssertionStatus();
        QOIV = DSLog.getDSLog((class$jet$dataengine8$core$pushdown$ExpPushDownParser == null ? (class$jet$dataengine8$core$pushdown$ExpPushDownParser = ExpPushDownParser.class$("jet.dataengine8.core.pushdown.ExpPushDownParser")) : class$jet$dataengine8$core$pushdown$ExpPushDownParser).getName());
    }
}

