/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.cursor;

import com.jinfonet.api.datatypes.Types;
import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.OLAPException;
import jet.dataengine.api.schema.olap.cursor.RowDataMetaData;
import jet.dataengine8.olap.core.DimensionInstance;
import jet.dataengine8.olap.metadata.NamedObjectSupport;

public class CubeRowDataMetaData
extends NamedObjectSupport
implements RowDataMetaData {
    protected final int columnCount;
    protected final String[] columnName;
    protected final String[] columnLabel;
    protected final int[] columnType;
    protected final int[] columnScale;
    protected final int[] columnPrecision;

    CubeRowDataMetaData(DimensionInstance dimensionInstance) throws DSException {
        this.columnName = dimensionInstance.getAttributeQualifyNameCopy();
        this.columnLabel = dimensionInstance.getAttributeNameCopy();
        this.columnType = dimensionInstance.getAttributeType();
        this.columnScale = dimensionInstance.getScale();
        this.columnPrecision = dimensionInstance.getPrecision();
        this.columnCount = this.columnName.length;
        this.QOIV();
    }

    CubeRowDataMetaData(String string, String string2, int n, int n2, int n3) {
        this.columnCount = 1;
        this.columnName = new String[]{string};
        this.columnLabel = new String[]{string2};
        this.columnType = new int[]{n};
        this.columnScale = new int[]{n2};
        this.columnPrecision = new int[]{n3};
        this.QOIV();
    }

    private void QOIV() {
        int n = 0;
        int n2 = this.columnType.length;
        while (n < n2) {
            this.columnType[n] = Types.typeToSQLType(this.columnType[n]);
            ++n;
        }
    }

    public int getColumnCount() throws DSException {
        return this.columnCount;
    }

    public boolean isCaseSensitive(int n) throws DSException {
        return true;
    }

    public boolean isCurrency(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public int isNullable(int n) throws DSException {
        return 2;
    }

    public boolean isSigned(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public int getColumnDisplaySize(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public String getColumnLabel(int n) throws DSException {
        this.check(n);
        return this.columnLabel[n - 1];
    }

    public String getColumnName(int n) throws DSException {
        this.check(n);
        return this.columnName[n - 1];
    }

    public int getPrecision(int n) throws DSException {
        return this.columnPrecision[n - 1];
    }

    public int getScale(int n) throws DSException {
        return this.columnScale[n - 1];
    }

    public int getColumnType(int n) throws DSException {
        this.check(n);
        return this.columnType[n - 1];
    }

    public String getColumnTypeName(int n) throws DSException {
        this.check(n);
        return Types.getDataTypeName(this.columnType[n - 1]);
    }

    public String getColumnClassName(int n) throws DSException {
        this.check(n);
        return Types.getDataTypeName(this.columnType[n - 1]);
    }

    void check(int n) throws DSException {
        if (n < 1 || n > this.columnCount) {
            throw new OLAPException(3074, new String[]{String.valueOf(n)});
        }
    }
}

