/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.util.FontSets;

public class DSMultiValueContainer
extends DSContainer {
    private Render QOIV = null;
    private Vector UTFLength = new Vector();
    private Vector add = new Vector();
    private Vector booleanValue = new Vector();
    private int convertUnitToPixel = -1;

    public void add(String string) {
        this.UTFLength.add(string);
        this.add.add(string);
    }

    public void addValue(String string) {
        this.UTFLength.add(string);
    }

    public void addText(String string) {
        this.add.add(string);
    }

    public Vector getTexts() {
        return this.add;
    }

    public Vector getValues() {
        return this.UTFLength;
    }

    public void setSelectedValues(Vector vector) {
        this.booleanValue = vector;
    }

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        super.readProperties(dataInput, dSDataStreamable);
        int n2 = dataInput.readInt();
        this.UTFLength = new Vector(n2);
        if (n2 != 0) {
            n = 0;
            while (n < n2) {
                this.UTFLength.add(dataInput.readUTF());
                ++n;
            }
        }
        n2 = dataInput.readInt();
        this.add = new Vector(n2);
        if (n2 != 0) {
            n = 0;
            while (n < n2) {
                this.add.add(dataInput.readUTF());
                ++n;
            }
        }
        this.convertUnitToPixel = dataInput.readInt();
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        int n = this.UTFLength.size();
        dataOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutput.writeUTF((String)this.UTFLength.get(n2));
            ++n2;
        }
        n = this.add.size();
        dataOutput.writeInt(n);
        int n3 = 0;
        while (n3 < n) {
            dataOutput.writeUTF((String)this.add.get(n3));
            ++n3;
        }
        dataOutput.writeInt(this.convertUnitToPixel);
    }

    protected int propLength() {
        int n = super.propLength();
        n += 4;
        int n2 = this.UTFLength.size();
        int n3 = 0;
        while (n3 < n2) {
            n += DSContainer.UTFLength((String)this.UTFLength.get(n3)) + 2;
            ++n3;
        }
        n += 4;
        n2 = this.add.size();
        int n4 = 0;
        while (n4 < n2) {
            n += DSContainer.UTFLength((String)this.add.get(n4)) + 2;
            ++n4;
        }
        return n += 4;
    }

    public Render getRender() {
        switch ((Integer)this.getPropertyByName("renderType").getObject()) {
            case 8: {
                RenderList renderList = new RenderList(this);
                renderList.setValues(this.UTFLength);
                renderList.setTexts(this.add);
                this.booleanValue = (Vector)this.getPropertyByName("SelectedValues").getObject();
                if (this.booleanValue != null && this.booleanValue.size() > 0) {
                    renderList.setSelectedText(this.booleanValue);
                }
                this.QOIV = this.setInfo(renderList);
                break;
            }
            case 9: {
                RenderDropDownList renderDropDownList = new RenderDropDownList(this);
                renderDropDownList.setValues(this.UTFLength);
                renderDropDownList.setTexts(this.add);
                String string = (String)this.getPropertyByName("SelectedValue").getObject();
                if (!string.equals("")) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = this.UTFLength.size();
                    while (n2 < n3) {
                        if (((String)this.UTFLength.get(n2)).equals(string)) {
                            n = n2;
                            break;
                        }
                        ++n2;
                    }
                    renderDropDownList.setSelectedTexts((String)this.add.get(n));
                } else if (this.add.size() > 0) {
                    renderDropDownList.setSelectedTexts((String)this.add.get(0));
                }
                this.QOIV = this.setInfo(renderDropDownList);
                break;
            }
            default: {
                if (!JRLog.isError(3)) break;
                JRLog.error(3, new Exception("MultiValueContainer only can be applied to ListRender or DropDownListRender "));
            }
        }
        return this.QOIV;
    }

    public Render setInfo(Render render) {
        this.QOIV = render;
        this.QOIV.setHeight(this.getHeight());
        this.QOIV.setWidth(this.getWidth());
        int n = this.getResolution();
        String string = (String)this.getPropertyByName("FontFace").getObject();
        int n2 = 0;
        if (((Boolean)this.getPropertyByName("Bold").getObject()).booleanValue()) {
            n2 |= 1;
        }
        if (((Boolean)this.getPropertyByName("Italic").getObject()).booleanValue()) {
            n2 |= 2;
        }
        int n3 = Unit.convertUnitToPixel((Integer)this.getPropertyByName("FontSize").getObject(), n);
        this.QOIV.setFont(FontSets.getFont(string, n2, n3));
        return this.QOIV;
    }

    public void setFormIndex(int n) {
        this.convertUnitToPixel = n;
    }

    public int getFormIndex() {
        return this.convertUnitToPixel;
    }

    public Object clone() {
        return this.dup(new DSMultiValueContainer());
    }

    public DSMultiValueContainer dup(DSMultiValueContainer dSMultiValueContainer) {
        super.dup(dSMultiValueContainer);
        dSMultiValueContainer.QOIV = this.QOIV;
        dSMultiValueContainer.UTFLength = this.UTFLength;
        dSMultiValueContainer.add = this.add;
        dSMultiValueContainer.booleanValue = this.booleanValue;
        dSMultiValueContainer.convertUnitToPixel = this.convertUnitToPixel;
        return dSMultiValueContainer;
    }
}

