/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.barcode.BarcodeTable;
import jet.datastream.render.barcode.BarcodeUtil;
import jet.datastream.render.barcode.linearBarcode.BarcodeConstraints;
import jet.datastream.render.barcode.linearBarcode.LinearBarcode;

public class Barcode39
extends LinearBarcode {
    public int centreX;
    public int centreY;
    String Code39Tran;

    public Barcode39(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    public void init() {
        this.Code39Tran = this.paper.getBarMessage();
        this.centreX = this.paper.getCenterX();
        this.centreY = this.paper.getCenterY();
        this.foreColor = this.paper.getForeground();
        this.barHeight = this.paper.getBarHeight();
        this.showBottomText = this.paper.getBarHRDisplay();
        this.narrowWidth = this.paper.getBarNarrowWidth();
        this.enableCheckDigit = this.paper.getBarCheckEnable();
        this.scaleMode = this.paper.getBarScaleMode();
        this.bottomLabelFont = this.paper.getBarHRFont();
        this.startingQuietZone = this.paper.getBarQuietZone();
        this.wideToNarrowRatio = (int)this.paper.getBarRatio();
        this.unit = this.paper.getUnit();
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isOK(this.Code39Tran)) {
            this.printCode39(graphics2D, this.Code39Tran);
        }
    }

    public void calculateWidth() {
        if (this.isOK(this.Code39Tran)) {
            this.calculateCode39Width(this.Code39Tran);
        }
    }

    protected void calculateCode39Width(String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.enableCheckDigit;
        if (string.length() == 0) {
            return;
        }
        if (bl) {
            n = BarcodeUtil.checkCode2(string);
            stringBuffer = this.Code39Tran(string + String.valueOf((char)n));
        } else {
            stringBuffer = this.Code39Tran(string);
        }
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f3 *= this.unit;
        float f7 = f5 *= this.unit;
        f6 *= this.unit;
        n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (n2 != stringBuffer.length() - 1 && stringBuffer.charAt(n2) == stringBuffer.charAt(n2 + 1) && this.wideToNarrowRatio == 3) {
                ++n;
            }
            ++n2;
        }
        f = f2 = (float)this.centreX - ((float)stringBuffer.length() * f5 + f5 * (float)n) / 2.0f;
        f4 = (float)this.centreY - f3 / 2.0f;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            f7 = n3 != stringBuffer.length() - 1 && stringBuffer.charAt(n3) == stringBuffer.charAt(n3 + 1) ? (this.wideToNarrowRatio == 3 ? f5 * 2.0f : f5) : f5;
            f += f7;
            ++n3;
        }
        Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n4 = (int)rectangle2D.getWidth();
        int n5 = (int)rectangle2D.getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n4 * 2)), (int)(f3 + (float)(n5 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public StringBuffer Code39Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n > 0 && string.charAt(0) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
            stringBuffer.append("0");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                n3 = 0;
                while (n3 < 10) {
                    if (string.charAt(n2) == BarcodeTable.code39N[n3]) {
                        stringBuffer.append(BarcodeTable.code39NTranslate[n3]);
                    }
                    ++n3;
                }
            } else if (string.charAt(n2) >= 'A' && string.charAt(n2) <= 'Z') {
                n3 = 0;
                while (n3 < 26) {
                    if (string.charAt(n2) == BarcodeTable.code39C[n3]) {
                        stringBuffer.append(BarcodeTable.code39CTranslate[n3]);
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < 8) {
                    if (string.charAt(n2) == BarcodeTable.code39S[n3]) {
                        stringBuffer.append(BarcodeTable.code39STranslate[n3]);
                    }
                    ++n3;
                }
            }
            stringBuffer.append("0");
            ++n2;
        }
        if (string.charAt(n - 1) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
        }
        return stringBuffer;
    }

    public void printCode39(Graphics2D graphics2D, String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.enableCheckDigit;
        if (string.length() == 0) {
            return;
        }
        if (bl) {
            n = BarcodeUtil.checkCode2(string);
            stringBuffer = this.Code39Tran(string + String.valueOf((char)n));
        } else {
            stringBuffer = this.Code39Tran(string);
        }
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f3 *= this.unit;
        float f7 = f5 *= this.unit;
        f6 *= this.unit;
        n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (n2 != stringBuffer.length() - 1 && stringBuffer.charAt(n2) == stringBuffer.charAt(n2 + 1) && this.wideToNarrowRatio == 3) {
                ++n;
            }
            ++n2;
        }
        f = f2 = (float)this.centreX - ((float)stringBuffer.length() * f5 + f5 * (float)n) / 2.0f;
        f4 = (float)this.centreY - f3 / 2.0f;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            f7 = n3 != stringBuffer.length() - 1 && stringBuffer.charAt(n3) == stringBuffer.charAt(n3 + 1) ? (this.wideToNarrowRatio == 3 ? f5 * 2.0f : f5) : f5;
            if (stringBuffer.charAt(n3) == '1') {
                if (this.foreColor != null) {
                    graphics2D.setColor(this.foreColor);
                } else {
                    graphics2D.setColor(Color.black);
                }
                BarcodeUtil.drawbar(graphics2D, f, f4, f7, f3);
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                BarcodeUtil.drawbar(graphics2D, f, f4, f7, f3);
            }
            f += f7;
            ++n3;
        }
        if (this.showBottomText) {
            graphics2D.setColor(this.foreColor);
            graphics2D.setFont(this.bottomLabelFont);
            BarcodeUtil.printBarcodeDataM(string, graphics2D, (int)(f / 2.0f + f2 / 2.0f), (int)(f3 + f4), (int)(f - f2));
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = fontMetrics.stringWidth("" + string.charAt(0));
        int n5 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n4 * 2)), (int)(f3 + (float)(n5 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    protected boolean isOK(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            boolean bl = false;
            if (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                n3 = 0;
                while (n3 < 10) {
                    if (string.charAt(n2) == BarcodeTable.code39N[n3]) {
                        bl = true;
                    }
                    ++n3;
                }
            } else if (string.charAt(n2) >= 'A' && string.charAt(n2) <= 'Z') {
                n3 = 0;
                while (n3 < 26) {
                    if (string.charAt(n2) == BarcodeTable.code39C[n3]) {
                        bl = true;
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < 8) {
                    if (string.charAt(n2) == BarcodeTable.code39S[n3]) {
                        bl = true;
                    }
                    ++n3;
                }
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

