/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.ParaGroupModel;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.GroupTool;
import jet.ie.PJFAux;
import jet.ie.WriterTool;
import jet.ie.io.PJFDataOutput;
import jet.util.TreeIterater;

public class GroupWriter
extends GroupTool {
    private GroupModel I;
    private Vector[] QOIV;
    private long add;
    private long addElement;
    private Vector elementAt;
    private Vector firstElement;
    private Vector get;

    public GroupWriter() {
    }

    public GroupWriter(GroupModel groupModel) {
        this.I = groupModel;
    }

    public void setRootModel(GroupModel groupModel) {
        this.I = groupModel;
    }

    public void writeModel(Vector vector, PJFDataOutput pJFDataOutput) throws IOException {
        int n;
        if (this.I == null) {
            throw new Error("RootModel is not specified.");
        }
        this.groupDeclCount = this.I.getLastLeaf().getGroupIndex() + 1;
        pJFDataOutput.writeShort(this.groupDeclCount);
        this.add = pJFDataOutput.getPosition();
        this.eachLevelLength = new int[this.groupDeclCount];
        int n2 = 0;
        while (n2 < this.groupDeclCount) {
            pJFDataOutput.writeInt(0);
            ++n2;
        }
        this.addElement = pJFDataOutput.getPosition();
        this.eachLevelCount = new int[this.groupDeclCount];
        int n3 = 0;
        while (n3 < this.groupDeclCount) {
            pJFDataOutput.writeInt(0);
            ++n3;
        }
        GroupModel groupModel = this.I;
        RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(128);
        PJFDataOutput pJFDataOutput2 = new PJFDataOutput(randomByteArrayOutputStream);
        while (groupModel != null) {
            try {
                this.I(groupModel, pJFDataOutput2);
            }
            catch (DSException dSException) {
                dSException.printStackTrace();
            }
            groupModel = groupModel.nextToMe();
        }
        this.QOIV(vector);
        int n4 = 0;
        while (n4 < this.groupDeclCount - 1) {
            pJFDataOutput2.writeInt(this.eachGroupSize[n4].length);
            n = 0;
            while (n < this.eachGroupSize[n4].length) {
                pJFDataOutput2.writeInt(this.eachGroupSize[n4][n]);
                ++n;
            }
            ++n4;
        }
        n = this.firstElement == null ? 0 : this.firstElement.size();
        pJFDataOutput2.writeInt(n);
        int n5 = 0;
        while (n5 < n) {
            pJFDataOutput2.writeInt((Integer)this.firstElement.elementAt(n5));
            pJFDataOutput2.writeInt((Integer)this.get.elementAt(n5));
            ++n5;
        }
        pJFDataOutput.write(randomByteArrayOutputStream.toByteArray());
        randomByteArrayOutputStream.close();
        pJFDataOutput2.close();
    }

    private final void I(GroupModel groupModel, PJFDataOutput pJFDataOutput) throws IOException, DSException {
        int n;
        int n2 = groupModel.getGroupIndex();
        DbColDesc dbColDesc = groupModel.getPreprocess();
        int n3 = n = dbColDesc != null ? dbColDesc.getColIndex() : -1;
        if (dbColDesc != null && n == -1) {
            throw new DSException(5857, new String[]{"The coldesc is not null, but ColIndex is null"});
        }
        DbValue[] dbValueArray = groupModel.getGroupLevelValues();
        int n4 = dbValueArray == null ? 0 : dbValueArray.length;
        pJFDataOutput.writeShort(n4 + 1);
        pJFDataOutput.writeShort(n);
        String string = "";
        pJFDataOutput.writeUTF(string);
        pJFDataOutput.writeBoolean(false);
        this.eachLevelLength[n2] = dbColDesc != null ? 1 + PJFAux.getColLength(dbColDesc) : 0;
        int n5 = 0;
        while (n5 < n4) {
            pJFDataOutput.writeShort(dbValueArray[n5].getColDesc().getColIndex());
            int n6 = n2;
            this.eachLevelLength[n6] = this.eachLevelLength[n6] + (1 + PJFAux.getColLength(dbValueArray[n5].getColDesc()));
            ++n5;
        }
        DbValue[] dbValueArray2 = groupModel.getDBFieldValues();
        int n7 = dbValueArray2 == null ? 0 : dbValueArray2.length;
        pJFDataOutput.writeShort(n7);
        int n8 = 0;
        while (n8 < n7) {
            pJFDataOutput.writeShort(dbValueArray2[n8].getColDesc().getColIndex());
            int n9 = n2;
            this.eachLevelLength[n9] = this.eachLevelLength[n9] + (1 + PJFAux.getColLength(dbValueArray2[n8].getColDesc()));
            ++n8;
        }
        int n10 = groupModel instanceof ParaGroupModel ? ((ParaGroupModel)groupModel).getBranchIdx() : -1;
        pJFDataOutput.writeShort(n10);
        int[] nArray = groupModel instanceof ParaGroupModel ? ((ParaGroupModel)groupModel).getGrouplevelsBranchIdx() : null;
        n7 = nArray == null ? 0 : nArray.length;
        pJFDataOutput.writeShort(n7);
        int n11 = 0;
        while (n11 < n7) {
            pJFDataOutput.writeShort(nArray[n11]);
            ++n11;
        }
        Vector vector = groupModel instanceof ParaGroupModel ? ((ParaGroupModel)groupModel).getChildBranches() : null;
        n7 = vector == null ? 0 : vector.size();
        pJFDataOutput.writeShort(n7);
        int n12 = 0;
        while (n12 < n7) {
            pJFDataOutput.writeShort((Integer)vector.elementAt(n12));
            ++n12;
        }
    }

    private void QOIV(Vector vector) {
        int n;
        int n2;
        Object object;
        this.QOIV = new Vector[this.groupDeclCount];
        int n3 = 0;
        while (n3 < this.groupDeclCount) {
            this.QOIV[n3] = new Vector();
            ++n3;
        }
        TreeIterater treeIterater = new TreeIterater();
        int n4 = vector.size();
        Group group = null;
        int n5 = 0;
        while (n5 < n4) {
            Group group2 = (Group)vector.elementAt(n5);
            group2.resetCursor();
            treeIterater.reset(group2, false);
            object = new Stack();
            while (true) {
                int n6;
                if (group != null) {
                    n6 = group.getGroupModel().getGroupIndex();
                    if (n6 == -1) {
                        n6 = treeIterater.getLevel();
                    }
                    this.QOIV[n6].addElement(group);
                    Vector vector2 = group.getSiblings();
                    n2 = vector2 == null ? 0 : vector2.size();
                    n = 0;
                    while (n < n2) {
                        ((Stack)object).push(vector2.elementAt(n));
                        if (this.elementAt == null) {
                            this.elementAt = new Vector();
                            this.firstElement = new Vector();
                            this.get = new Vector();
                        }
                        this.elementAt.addElement(vector2.elementAt(n));
                        this.firstElement.addElement(new Integer(n6));
                        this.get.addElement(new Integer(this.QOIV[n6].size() - 1));
                        ++n;
                    }
                }
                if ((group = (Group)treeIterater.next()) != null) continue;
                if (((Vector)object).size() != 0) {
                    group = (Group)((Stack)object).pop();
                    treeIterater.reset(group, false, false);
                    n6 = group.getGroupModel().getGroupIndex();
                    if (n6 == -1) {
                        n6 = treeIterater.getLevel();
                    }
                }
                if (group == null) break;
            }
            ++n5;
        }
        this.eachGroupSize = new int[this.groupDeclCount - 1][];
        object = null;
        int n7 = 0;
        while (n7 < this.groupDeclCount) {
            Vector vector3 = this.QOIV[n7];
            this.eachLevelCount[n7] = vector3.size();
            if (this.eachLevelCount[n7] > 0) {
                object = (Group)vector3.firstElement();
            }
            if (n7 != this.groupDeclCount - 1) {
                n2 = 0;
                n2 = object.getGroupType() == 1 ? 0 : this.eachLevelCount[n7];
                this.eachGroupSize[n7] = new int[n2];
                n = 0;
                while (n < n2) {
                    this.eachGroupSize[n7][n] = ((Group)vector3.elementAt(n)).getSubgroups().size();
                    ++n;
                }
            }
            ++n7;
        }
    }

    public void writeData(PJFDataOutput pJFDataOutput) throws IOException {
        int n = 0;
        while (n < this.groupDeclCount) {
            this.add(n, pJFDataOutput);
            ++n;
        }
    }

    private void add(int n, PJFDataOutput pJFDataOutput) throws IOException {
        Vector vector = this.QOIV[n];
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            this.addElement((Group)vector.elementAt(n3), pJFDataOutput);
            ++n3;
        }
    }

    private void addElement(Group group, PJFDataOutput pJFDataOutput) throws IOException {
        DbValue[] dbValueArray;
        int n;
        DbValue dbValue;
        Vector vector = group.getBranchIdxes();
        int n2 = vector.size();
        if (n2 < 1) {
            n2 = 1;
        }
        pJFDataOutput.writeShort(n2);
        if (n2 == 1) {
            pJFDataOutput.writeInt(group.sizeOfRecords());
        } else {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = (Integer)vector.elementAt(n3);
                pJFDataOutput.writeShort(n4);
                pJFDataOutput.writeInt(group.sizeOfRecords(n4));
                ++n3;
            }
        }
        if (group.getGroupValue() != null) {
            WriterTool.writeDbValue(group.getGroupValue(), pJFDataOutput);
        }
        if ((dbValue = group.getGroupName()) != null) {
            pJFDataOutput.writeBoolean(true);
            pJFDataOutput.writeUTF(dbValue.toString());
        } else {
            pJFDataOutput.writeBoolean(false);
        }
        DbValue[] dbValueArray2 = group.getGroupLevelValues();
        if (dbValueArray2 != null) {
            int n5 = dbValueArray2.length;
            n = 0;
            while (n < n5) {
                WriterTool.writeDbValue(dbValueArray2[n], pJFDataOutput);
                ++n;
            }
        }
        if ((dbValueArray = group.getDbFieldValues()) != null) {
            n = dbValueArray.length;
            int n6 = 0;
            while (n6 < n) {
                WriterTool.writeDbValue(dbValueArray[n6], pJFDataOutput);
                ++n6;
            }
        }
        pJFDataOutput.writeInt(group.getBranchIdx());
        int n7 = n = this.elementAt == null ? -1 : this.elementAt.indexOf(group);
        if (n == -1) {
            pJFDataOutput.writeInt(-1);
            pJFDataOutput.writeInt(-1);
        } else {
            pJFDataOutput.writeInt((Integer)this.firstElement.elementAt(n));
            pJFDataOutput.writeInt((Integer)this.get.elementAt(n));
        }
    }

    public void fillBack(PJFDataOutput pJFDataOutput) throws IOException {
        long l = pJFDataOutput.getPosition();
        pJFDataOutput.seek(this.add);
        int n = 0;
        while (n < this.eachLevelLength.length) {
            pJFDataOutput.writeInt(this.eachLevelLength[n]);
            ++n;
        }
        pJFDataOutput.seek(this.addElement);
        int n2 = 0;
        while (n2 < this.eachLevelCount.length) {
            pJFDataOutput.writeInt(this.eachLevelCount[n2]);
            ++n2;
        }
        pJFDataOutput.seek(l);
    }

    static Vector I(Vector vector) {
        Vector<Group> vector2 = new Vector<Group>();
        int n = 0;
        while (n < vector.size()) {
            Group group = (Group)vector.get(n);
            while (group.getParent() != null) {
                group = group.getParent();
            }
            vector2.add(group);
            ++n;
        }
        return vector2;
    }
}

