/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipToolkit {
    public static byte[] GZip(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream){
            {
                this.def.setLevel(1);
            }
        };
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.flush();
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] UnGZip(byte[] byArray) throws IOException {
        int n = 4096;
        byte[] byArray2 = new byte[]{};
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        while (n2 != -1) {
            n2 = gZIPInputStream.read(byArray3, 0, n);
            if (n2 == -1) continue;
            byteArrayOutputStream.write(byArray3, 0, n2);
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        gZIPInputStream.close();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static void zip(OutputStream outputStream, File file) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        ZipToolkit.zip(zipOutputStream, file, file.getName());
        zipOutputStream.close();
    }

    private static void zip(ZipOutputStream zipOutputStream, File file, String string) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
            string = string.length() == 0 ? "" : string + "/";
            int n = 0;
            while (n < fileArray.length) {
                ZipToolkit.zip(zipOutputStream, fileArray[n], string + fileArray[n].getName());
                ++n;
            }
        } else {
            int n;
            zipOutputStream.putNextEntry(new ZipEntry(string));
            FileInputStream fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read()) != -1) {
                zipOutputStream.write(n);
            }
            fileInputStream.close();
        }
    }

    public static void unzip(String string, File file) throws FileNotFoundException, IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = zipInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
        }
        zipInputStream.close();
    }

    public static void unzip(InputStream inputStream, File file) throws FileNotFoundException, IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = zipInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
        }
    }
}

