/*
 * Decompiled with CFR 0.152.
 */
package jet.net2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import jet.net2.URL;

public class NetworkClient {
    private static Hashtable FALSE = new Hashtable();
    protected Socket serverSocket = null;
    public PrintStream serverOutput;
    public InputStream serverInput;

    public static String getSysProp(String string) {
        Boolean bl = (Boolean)FALSE.get(string);
        if (bl != null && bl == Boolean.FALSE) {
            return null;
        }
        if (bl == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPropertyAccess(string);
                }
                catch (SecurityException securityException) {
                    FALSE.put(string, Boolean.FALSE);
                    return null;
                }
            }
            FALSE.put(string, Boolean.TRUE);
        }
        return System.getProperty(string);
    }

    public static String getSysProp(String string, String string2) {
        String string3 = NetworkClient.getSysProp(string);
        return string3 != null ? string3 : string2;
    }

    public static int getSysProp(String string, int n) {
        String string2 = NetworkClient.getSysProp(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public static synchronized void resetProperties() {
        FALSE.clear();
    }

    public void openServer(String string, int n) throws IOException, UnknownHostException {
        if (this.serverSocket != null) {
            this.closeServer();
        }
        this.serverSocket = this.doConnect(string, n);
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), true);
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        Socket socket = new Socket(string, n);
        socket.setSoTimeout(URL.getSoTimeout());
        return socket;
    }

    public void closeServer() throws IOException {
        if (!this.serverIsOpen()) {
            return;
        }
        this.serverSocket.close();
        this.serverSocket = null;
        this.serverInput = null;
        this.serverOutput = null;
    }

    public boolean serverIsOpen() {
        return this.serverSocket != null;
    }

    public NetworkClient(String string, int n) throws IOException {
        this.openServer(string, n);
    }

    public NetworkClient() {
    }
}

