/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetColumnName;
import jet.controls.JetColumnVector;
import jet.controls.JetColumnable;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.log.JRLogger;
import jet.report.JRObjectTemplate;
import jet.report.JetRptDataContainer;
import jet.report.JetRptDataSource;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptParamLink;
import jet.report.JetRptSection;
import jet.report.JetRptSubLink;
import jet.report.JetRptSubReturnValue;
import jet.report.JetRptSystemVariable;
import jet.universe.JetUDBField;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.engine.UFileQueryEngine;
import jet.universe.engine.UPsqlQueryEngine;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.InvalidEntityException;
import jet.universe.exception.MappingFldInvalidToQuery;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.util.DbValueComparer;
import jet.util.TreeIterater;

public abstract class JetRptQueryComponent
extends JetRptDataContainer {
    public JetBoolean suppressEmpty;
    public JetNumber recordsPerPage;
    public JetNumber maxPageNumber;
    public JetString queryName;
    public JetString report;
    public JetString sqlStatement;
    public JetVector sortBy;
    public JetVector sortOrder;
    public JetVector fldColNames;
    public JetVector fldSqlTypes;
    public JetVector fldPrecisions;
    public JetVector fldScales;
    public JetVector fldNullables;
    public JetVector fldFlags;
    public JetVector fieldsBackIndex;
    public JetVector fmlColNames;
    public JetVector fmlSqlTypes;
    public JetVector fmlPrecisions;
    public JetVector fmlScales;
    public JetVector fmlNullables;
    public JetVector fmlFlags;
    public JetVector f2sFmlNames;
    public JetVector f2sSecNames;
    public JetNumber sortBySvr;
    public JetVector groupOrder;
    protected JetRptDataSource dataSource;
    protected JetUUniverse universe;
    protected String strQueryName;
    protected String strSqlStmt;
    protected UQueryEngine engine;
    private JetRptSystemVariable QOIV = new JetRptSystemVariable();
    private Vector add;
    private Vector addElement;
    private Vector afterInit;
    private Vector checkDAG;
    private Vector checkIfMappingFldsValidToQuery;
    private Vector class$;
    private Vector contains;
    private Hashtable convertSize;
    private Hashtable createEngine;
    private boolean elementAt = false;
    private boolean elements = false;
    private static JRLogger equals = JRLogger.getLogger((class$jet$report$JetRptQueryComponent == null ? (class$jet$report$JetRptQueryComponent = JetRptQueryComponent.class$("jet.report.JetRptQueryComponent")) : class$jet$report$JetRptQueryComponent).getName());
    static Class class$jet$report$JetRptQueryComponent;

    public JetRptQueryComponent() {
        this.createEngine();
        this.dataSource();
    }

    public JetRptQueryComponent(String string, Vector vector, Vector vector2) {
        this();
        this.queryName.set(string);
        this.setSubLinks(vector, vector2);
    }

    public void setSubLinks(Vector vector, Vector vector2) {
        int n;
        Vector vector3 = this.getChildren();
        int n2 = vector3.size() - 1;
        while (n2 >= 0) {
            if (vector3.elementAt(n2) instanceof JetRptSubLink) {
                this.remove((JetObject)vector3.elementAt(n2));
            }
            --n2;
        }
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                this.add((JetRptSubLink)vector.elementAt(n), 1);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                this.add((JetRptSubLink)vector2.elementAt(n), 1);
                ++n;
            }
        }
    }

    public void setDataSource(JetRptDataSource jetRptDataSource) {
        if (this.getDataSource() != null) {
            this.remove(this.dataSource);
        }
        this.add(jetRptDataSource, 0);
    }

    public void setSqlStatement(String string) {
        this.sqlStatement.set(string);
    }

    public boolean isBundled() {
        return this.getDataSource().isBundled();
    }

    public void setFetchSupportInfo(boolean bl) {
        this.elementAt = bl;
    }

    public void afterInit() {
        super.afterInit();
        if (this.elements) {
            this.prepareResources();
            this.elements = false;
        }
    }

    public String getInstancePrefix() {
        return "DataObject";
    }

    public String getPrefix() {
        return JResource.getMessage("DataObject");
    }

    public boolean getNeedPrepare() {
        return this.elements;
    }

    public void setNeedPrepare(boolean bl) {
        this.elements = bl;
    }

    public boolean prepareResources() {
        boolean bl;
        block9: {
            bl = false;
            this.contains();
            try {
                this.dataSource = this.getDataSource();
                this.universe = this.dataSource.getUniverse();
                this.strQueryName = this.dataSource.uQueryName.get();
                this.QOIV();
                if (this.add.size() <= 0) {
                    return false;
                }
                this.anchor();
                if (this.add.size() == 0) break block9;
                this.initUQueryEngine();
                this.createEngine = this.engine.getParamsBuff();
                this.convertSize(this.createEngine.keys());
                this.engine.initParameters();
                this.engine.start();
                this.checkDAG();
                if (this.checkIfMappingFldsValidToQuery != null && this.checkIfMappingFldsValidToQuery.size() != 0) {
                    this.engine.setOrderBy(this.checkIfMappingFldsValidToQuery, this.class$);
                }
                if (this.engine instanceof UPsqlQueryEngine || this.engine instanceof UFileQueryEngine) {
                    this.strSqlStmt = this.engine.getRawSqlStatement();
                }
                this.setSqlStatement(this.strSqlStmt);
                this.engine.checkDAG(null, this.convertSize, this.contains, this.createEngine);
                if (this.convertSize != null && this.convertSize.size() != 0) {
                    Hashtable hashtable = this.engine.getFormulaToSection();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (hashtable.get(string) instanceof Vector) {
                            Enumeration enumeration2 = ((Vector)hashtable.get(string)).elements();
                            while (enumeration2.hasMoreElements()) {
                                this.f2sFmlNames.add(string);
                                this.f2sSecNames.add(((JetRptSection)enumeration2.nextElement()).getInstName());
                            }
                            continue;
                        }
                        this.f2sFmlNames.add(string);
                        this.f2sSecNames.add(((JetRptSection)hashtable.get(string)).getInstName());
                    }
                }
                this.checkIfMappingFldsValidToQuery(this.engine.getColumnMap(), this.fldColNames, this.fldSqlTypes, this.fldPrecisions, this.fldScales, this.fldNullables, this.fldFlags);
                this.checkIfMappingFldsValidToQuery(this.engine.getFmlsColDescs(), this.fmlColNames, this.fmlSqlTypes, this.fmlPrecisions, this.fmlScales, this.fmlNullables, this.fmlFlags);
                this.clear(this.engine.getDbFldsBackIndex());
            }
            catch (Throwable throwable) {
                if (!equals.isErrorEnabled()) break block9;
                equals.error("", throwable);
            }
        }
        return bl;
    }

    public JetRptDataSource getDataSource() {
        if (this.getChildren().size() >= 1 && this.getChildren().elementAt(0) instanceof JetRptDataSource) {
            return (JetRptDataSource)this.getChildren().elementAt(0);
        }
        return null;
    }

    private void QOIV() {
        JetObject jetObject;
        TreeIterater treeIterater = new TreeIterater(this, false, false);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject instanceof JetRptParamLink) {
                this.checkDAG.addElement((JetRptParamLink)jetObject);
                continue;
            }
            if (!(jetObject instanceof JetRptSubReturnValue) && jetObject instanceof JetRptSubLink) {
                this.afterInit.addElement((JetRptSubLink)jetObject);
                continue;
            }
            Hashtable hashtable = jetObject.getProperties();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                JetProperty jetProperty = (JetProperty)hashtable.get(enumeration.nextElement());
                if (jetProperty.isChangeByOther()) {
                    this.add(jetObject, this.strQueryName, ((String)jetProperty.getChangeByObject()).toUpperCase());
                    continue;
                }
                if (!(jetProperty instanceof JetColumnable)) continue;
                if (jetProperty instanceof JetColumnName) {
                    String string = jetProperty.toString();
                    if (string == null || string.length() == 0) continue;
                    this.add(jetObject, this.strQueryName, string);
                    continue;
                }
                if (!(jetProperty instanceof JetVector)) continue;
                Vector vector = ((JetVector)jetProperty).get();
                int n = 0;
                while (n < vector.size()) {
                    String string = vector.elementAt(n).toString().toUpperCase();
                    if (string != null && string.length() != 0) {
                        if (jetProperty.getName().equals("Value")) {
                            this.add(jetObject, this.strQueryName, string);
                        } else {
                            this.add(null, this.strQueryName, string);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    private final void add(JetObject jetObject, String string, String string2) {
        if (!this.add.contains(string2)) {
            this.add.addElement(string2);
        }
        if (jetObject != null && jetObject instanceof JRObjectTemplate) {
            String string3 = this.dataSource.sourceName.get();
            JetUResourceEntity jetUResourceEntity = this.universe.getResourceByName(string3, string, string2);
            JetRptSection jetRptSection = null;
            if (jetUResourceEntity instanceof JetUFormula) {
                JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)jetObject;
                while (!(jetObject instanceof JetRptSection)) {
                    jetObject = (JetObject)((Object)jetObject.getParent());
                }
                jetRptSection = (JetRptSection)jetObject;
                if (jetRptSection != null) {
                    this.addElement(string2, jetRptSection);
                }
            }
        }
    }

    private final void addElement(String string, JetRptSection jetRptSection) {
        Object v = this.convertSize.get(string);
        if (v == null) {
            this.convertSize.put(string, jetRptSection);
        } else {
            Vector<Object> vector = null;
            if (!(v instanceof Vector)) {
                vector = new Vector<Object>();
                this.convertSize.put(string, vector);
                vector.addElement(v);
            } else {
                vector = (Vector<Object>)v;
            }
            vector.addElement(jetRptSection);
        }
    }

    private void anchor() throws CannotFindQuery, InvalidEntityException, MappingFldInvalidToQuery {
        String string = this.dataSource.sourceName.get();
        if (this.strQueryName == null || this.strQueryName.equals("")) {
            throw new CannotFindQuery("");
        }
        this.universe.checkIfMappingFldsValidToQuery(string, this.strQueryName, this.add);
    }

    protected void initUQueryEngine() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError, LoadUserDataSourceException {
        String string = this.dataSource.sourceName.get();
        this.engine = UQueryEngine.createEngine(this.universe, string, this.strQueryName, this.add, this.addElement, null, this.afterInit, false);
        this.engine.setResolveRpt(true);
        this.engine.setFetchSupportInfo(this.elementAt);
        this.engine.initialize();
    }

    private void checkDAG() {
        JetObject jetObject;
        String string = this.dataSource.sourceName.get();
        int n = -1;
        boolean bl = false;
        this.sortBySvr.set(0);
        TreeIterater treeIterater = new TreeIterater(this, false);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            JetUResourceEntity jetUResourceEntity;
            Object object;
            if (jetObject instanceof JetRptQueryComponent) {
                object = ((JetRptQueryComponent)jetObject).sortBy.get();
                Vector vector = ((JetRptQueryComponent)jetObject).sortOrder.get();
                int n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    String string2 = ((String)((Vector)object).elementAt(n2)).toUpperCase();
                    String string3 = (String)vector.elementAt(n2);
                    jetUResourceEntity = this.universe.getResourceByName(string, this.strQueryName, string2);
                    if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUDBField) || this.engine.supportOrderBy()) {
                        // empty if block
                    }
                    this.checkIfMappingFldsValidToQuery.add(string2);
                    if (string3.equals("ASCENDING")) {
                        this.class$.addElement("ASC");
                    } else {
                        this.class$.addElement("DESC");
                    }
                    ++n2;
                }
                this.contains.addElement("REPORT");
                continue;
            }
            if (jetObject instanceof JetRptGroupPanel) {
                object = (JetRptGroupPanel)jetObject;
                String string4 = ((JetRptGroupPanel)object).groupBy.get();
                String string5 = ((JetRptGroupPanel)object).groupOrder.get();
                if (!bl) {
                    jetUResourceEntity = this.universe.getResourceByName(string, this.strQueryName, string4);
                    if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUDBField && this.engine.supportOrderBy() && ((JetRptGroupPanel)object).specFunc.get() == -1 && (((JetRptGroupPanel)object).specNames.get() == null || ((JetRptGroupPanel)object).specNames.get().size() == 0) && !string5.equals("ORIGINAL")) {
                        int n3 = this.checkIfMappingFldsValidToQuery.indexOf(string4);
                        if (n3 != -1) {
                            this.checkIfMappingFldsValidToQuery.removeElementAt(n3);
                            this.class$.removeElementAt(n3);
                        }
                        this.checkIfMappingFldsValidToQuery.insertElementAt(string4, ++n);
                        if (string5.equals("ASCENDING")) {
                            this.class$.insertElementAt("ASC", n);
                        } else if (string5.equals("DESCENDING")) {
                            this.class$.insertElementAt("DESC", n);
                        }
                        this.sortBySvr.set(this.sortBySvr.get() + 1);
                    } else {
                        bl = true;
                    }
                }
                this.contains.addElement(string4);
                continue;
            }
            if (!(jetObject instanceof JetRptSection)) continue;
            treeIterater.skipBranch();
        }
        this.groupOrder.set(this.contains);
    }

    private void checkIfMappingFldsValidToQuery(Vector vector, JetVector jetVector, JetVector jetVector2, JetVector jetVector3, JetVector jetVector4, JetVector jetVector5, JetVector jetVector6) {
        this.class$(jetVector, jetVector2, jetVector3, jetVector4, jetVector5, jetVector6);
        this.class$jet$report$JetRptQueryComponent(vector, jetVector, jetVector2, jetVector3, jetVector4, jetVector5, jetVector6);
    }

    private void class$(JetVector jetVector, JetVector jetVector2, JetVector jetVector3, JetVector jetVector4, JetVector jetVector5, JetVector jetVector6) {
        if (jetVector != null && jetVector.get().size() != 0) {
            jetVector.clear();
            jetVector2.clear();
            jetVector3.clear();
            jetVector4.clear();
            jetVector5.clear();
            jetVector6.clear();
        }
    }

    private void class$jet$report$JetRptQueryComponent(Vector vector, JetVector jetVector, JetVector jetVector2, JetVector jetVector3, JetVector jetVector4, JetVector jetVector5, JetVector jetVector6) {
        DbColDesc dbColDesc = null;
        int n = 0;
        while (n < vector.size()) {
            dbColDesc = (DbColDesc)vector.elementAt(n);
            jetVector.add(dbColDesc.getColName());
            jetVector2.add(Integer.toString(dbColDesc.getSqlType()));
            jetVector3.add(Integer.toString(dbColDesc.getPrecision()));
            jetVector4.add(Integer.toString(dbColDesc.getScale()));
            jetVector5.add(Integer.toString(dbColDesc.getNullable()));
            jetVector6.add(Integer.toString(dbColDesc.getFlag()));
            ++n;
        }
    }

    private void clear(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.fieldsBackIndex.add(Integer.toString(nArray[n]));
            ++n;
        }
    }

    private void contains() {
        this.sqlStatement.set("");
        this.fldColNames.clear();
        this.fldSqlTypes.clear();
        this.fldPrecisions.clear();
        this.fldScales.clear();
        this.fldNullables.clear();
        this.fldFlags.clear();
        this.fieldsBackIndex.clear();
        this.fmlColNames.clear();
        this.fmlSqlTypes.clear();
        this.fmlPrecisions.clear();
        this.fmlScales.clear();
        this.fmlNullables.clear();
        this.fmlFlags.clear();
        this.f2sFmlNames.clear();
        this.f2sSecNames.clear();
        this.add = new Vector(10);
        this.addElement = new Vector(3);
        this.checkDAG = new Vector(3);
        this.afterInit = new Vector(3);
        this.checkIfMappingFldsValidToQuery = new Vector(3);
        this.class$ = new Vector(3);
        this.contains = new Vector(3);
        this.convertSize = new Hashtable(10);
        this.createEngine = new Hashtable(3);
    }

    private void convertSize(Enumeration enumeration) {
        Vector vector = this.getChildren();
        int n = vector.size() - 1;
        while (n >= 0) {
            if (vector.elementAt(n) instanceof JetRptParamLink) {
                this.remove((JetRptParamLink)vector.elementAt(n));
            }
            --n;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.add(new JetRptParamLink(string, DbValueComparer.strOper[0], string), 1);
        }
    }

    private void createEngine() {
        this.sortBy = new JetColumnVector(this, "SortBy");
        this.sortOrder = new JetVector(this, "SortOrder");
        this.fldColNames = new JetVector(this, "FldColNames");
        this.fldSqlTypes = new JetVector(this, "FldSqlTypes");
        this.fldPrecisions = new JetVector(this, "FldPrecisions");
        this.fldScales = new JetVector(this, "FldScales");
        this.fldNullables = new JetVector(this, "FldNullables");
        this.fldFlags = new JetVector(this, "FldFlags");
        this.fieldsBackIndex = new JetVector(this, "FieldsBackIndex");
        this.fmlColNames = new JetVector(this, "FmlColNames");
        this.fmlSqlTypes = new JetVector(this, "FmlSqlTypes");
        this.fmlPrecisions = new JetVector(this, "FmlPrecisions");
        this.fmlScales = new JetVector(this, "FmlScales");
        this.fmlNullables = new JetVector(this, "FmlNullables");
        this.fmlFlags = new JetVector(this, "FmlFlags");
        this.f2sFmlNames = new JetVector(this, "F2SFmlNames");
        this.f2sSecNames = new JetVector(this, "F2SSecNames");
        this.sortBySvr = new JetNumber(this, "SortBySvr");
        this.groupOrder = new JetVector(this, "GroupOrder");
        this.anchor.set(true);
    }

    private void dataSource() {
        this.suppressEmpty = new JetBoolean(this, "SuppressEmpty", true);
        this.recordsPerPage = new JetNumber(this, "RecordsPerPage", -1);
        this.maxPageNumber = new JetNumber(this, "MaxPageNumber", -1);
        this.queryName = new JetString(this, "QueryName");
        this.report = new JetString(this, "Report");
        this.sqlStatement = new JetString(this, "SQLStatement");
        this.width.setUnitValue(JRObjectTemplate.convertSize(600));
        this.height.setUnitValue(JRObjectTemplate.convertSize(80));
        this.suppressed.setTransient(false);
        this.recordsPerPage.setCanChangeByOthers(false);
        this.maxPageNumber.setCanChangeByOthers(false);
    }

    static Class class$(String string) {
        try {
            return java.lang.Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

