/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import java.util.HashMap;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.controls.JetEnumeration;
import jet.controls.JetString;
import jet.datastream.SystemVariableConstants;
import jet.naming.EnumerationConstant;
import jet.report.JRObjectTemplate;
import jet.report.JRUnSupportedSpecialTypeException;
import jet.report.JetRptField;
import jet.util.HashVector;

public class JetRptSystemField
extends JetRptField
implements SystemVariableConstants {
    public JetEnumeration fieldType;
    public JetString displayNull;
    private static HashMap BLANK_SEPARATOR = null;
    private static final HashVector CHAR_DESC = new HashVector(10);

    public JetRptSystemField() {
        this.CHAR_DESC();
        this.BLANK_SEPARATOR();
        this.setObjectType(260);
    }

    public static final int[] getAvaliableTypes() {
        int[] nArray = new int[EnumerationConstant.SYSTEM_FIELD_TYPE.length - 1];
        int n = 0;
        nArray[n++] = 2;
        nArray[n++] = 3;
        nArray[n++] = 4;
        nArray[n++] = 5;
        nArray[n++] = 8;
        nArray[n++] = 9;
        nArray[n++] = 10;
        nArray[n++] = 11;
        nArray[n++] = 12;
        nArray[n++] = 13;
        nArray[n++] = 14;
        nArray[n++] = 1;
        nArray[n++] = 6;
        nArray[n++] = 7;
        nArray[n++] = 15;
        nArray[n++] = 16;
        nArray[n++] = 17;
        nArray[n++] = 18;
        nArray[n++] = 19;
        nArray[n++] = 20;
        nArray[n++] = 21;
        return nArray;
    }

    public static final String[] getAvaliableNames() {
        int[] nArray = JetRptSystemField.getAvaliableTypes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            try {
                stringArray[n] = JetRptSystemField.getPresentationName(nArray[n]);
            }
            catch (JRUnSupportedSpecialTypeException jRUnSupportedSpecialTypeException) {
                stringArray[n] = "UnkownType";
            }
            ++n;
        }
        return stringArray;
    }

    public static final String getPresentationName(int n) throws JRUnSupportedSpecialTypeException {
        if (n < 0 || n >= EnumerationConstant.SYSTEM_FIELD_TYPE.length) {
            throw new JRUnSupportedSpecialTypeException(215002, new Object[]{new Integer(n)}, null);
        }
        String string = EnumerationConstant.SYSTEM_FIELD_TYPE[n];
        if (string == EnumerationConstant.BLANK_SEPARATOR || string.equals(EnumerationConstant.BLANK_SEPARATOR)) {
            throw new JRUnSupportedSpecialTypeException(215002, new Object[]{new Integer(n)}, null);
        }
        return string;
    }

    public static final int getFormatType(String string) throws JRUnSupportedSpecialTypeException {
        int n = 0;
        while (n < EnumerationConstant.SYSTEM_FIELD_TYPE.length) {
            String string2 = EnumerationConstant.SYSTEM_FIELD_TYPE[n];
            if (string2 != EnumerationConstant.BLANK_SEPARATOR && !string2.equals(EnumerationConstant.BLANK_SEPARATOR) && string.equals(EnumerationConstant.SYSTEM_FIELD_TYPE[n])) {
                return n;
            }
            ++n;
        }
        throw new JRUnSupportedSpecialTypeException(215002, new Object[]{string}, null);
    }

    public static DbColDesc getColDescForType(int n) throws JRUnSupportedSpecialTypeException {
        DbColDesc dbColDesc = null;
        switch (n) {
            case 1: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                dbColDesc = DbValue.CHAR_DESC;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                dbColDesc = DbValue.DATE_DESC;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                dbColDesc = DbValue.TIME_DESC;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                dbColDesc = DbValue.INTEGER_DESC;
                break;
            }
            default: {
                throw new JRUnSupportedSpecialTypeException(215002, new Object[]{new Integer(n)}, null);
            }
        }
        return dbColDesc;
    }

    public void setFieldType(int n) {
        this.fieldType.set(new Integer(n));
    }

    public int getFieldType() {
        return this.fieldType.intValue();
    }

    public void setFieldType(String string) {
        this.fieldType.set(string);
    }

    public String getInstancePrefix() {
        int n = this.getFieldType();
        if (n != -1) {
            try {
                return JetRptSystemField.getPresentationName(n);
            }
            catch (JRUnSupportedSpecialTypeException jRUnSupportedSpecialTypeException) {
                return "UnkownType";
            }
        }
        return "SpecialField";
    }

    public String getPrefix() {
        return JResource.getMessage("SpecialField");
    }

    public HashMap getIndecialMap() {
        if (BLANK_SEPARATOR != null) {
            return BLANK_SEPARATOR;
        }
        BLANK_SEPARATOR = new HashMap();
        HashMap hashMap = super.getIndecialMap();
        BLANK_SEPARATOR.putAll(hashMap);
        int n = hashMap.size();
        BLANK_SEPARATOR.put("FieldType", new Integer(n++));
        BLANK_SEPARATOR.put("DisplayNull", new Integer(n++));
        return BLANK_SEPARATOR;
    }

    private void BLANK_SEPARATOR() {
        this.fieldType = new JetEnumeration(this, "FieldType", 93);
    }

    private void CHAR_DESC() {
        this.displayNull = new JetString(this, "DisplayNull");
        this.style.setDefault(JRObjectTemplate.SPECIALFIELD_STL);
        if (this.style.getList() == null) {
            Vector<String> vector = new Vector<String>();
            vector.add(JRObjectTemplate.SPECIALFIELD_STL);
            this.style.setList(vector);
        } else if (!this.style.getList().contains(JRObjectTemplate.SPECIALFIELD_STL)) {
            this.style.getList().insertElementAt(JRObjectTemplate.SPECIALFIELD_STL, 0);
        }
    }

    public HashVector getPropGrpsDesc() {
        return this.specialCaseOfPropGrps(CHAR_DESC);
    }

    public boolean canDoConditionalFormatting() {
        int n = this.fieldType.intValue();
        return n == 1 || n == 12;
    }

    static {
        String string = null;
        Vector<String> vector = null;
        string = "Geometry";
        vector = new Vector<String>(4);
        vector.add("X");
        vector.add("Y");
        vector.add("Width");
        vector.add("Height");
        CHAR_DESC.put(string, vector);
        string = "Color";
        vector = new Vector(2);
        vector.add("Background");
        vector.add("Foreground");
        CHAR_DESC.put(string, vector);
        string = "CSS";
        vector = new Vector(3);
        vector.add("Style");
        vector.add("id");
        vector.add("class");
        CHAR_DESC.put(string, vector);
        string = "Excel";
        vector = new Vector(2);
        vector.add("ColumnIndex");
        vector.add("RowIndex");
        CHAR_DESC.put(string, vector);
        string = "Padding";
        vector = new Vector(4);
        vector.add("padding-top");
        vector.add("padding-bottom");
        vector.add("padding-left");
        vector.add("padding-right");
        CHAR_DESC.put(string, vector);
        string = "Border";
        vector = new Vector(8);
        vector.add("BorderWidth");
        vector.add("TopLine");
        vector.add("BottomLine");
        vector.add("LeftLine");
        vector.add("RightLine");
        vector.add("Shadow");
        vector.add("BorderColor");
        vector.add("ShadowColor");
        CHAR_DESC.put(string, vector);
        string = "Pattern";
        vector = new Vector(2);
        vector.add("PatternColor");
        vector.add("PatternStyle");
        CHAR_DESC.put(string, vector);
        string = "TextFormat";
        vector = new Vector(13);
        vector.add("FontFace");
        vector.add("FontSize");
        vector.add("Bold");
        vector.add("Italic");
        vector.add("StrikeOut");
        vector.add("Underline");
        vector.add("Format");
        vector.add("AutoFit");
        vector.add("MaxWidth");
        vector.add("WordWrap");
        vector.add("TransWhileToHtml");
        vector.add("VerticalAlignment");
        vector.add("HorizontalAlignment");
        CHAR_DESC.put(string, vector);
        string = "Others";
        vector = new Vector(18);
        vector.add("position");
        vector.add("ExportToDHTML");
        vector.add("Invisible");
        vector.add("Suppressed");
        vector.add("SuppressedIfNoRecords");
        vector.add("RecordLocation");
        vector.add("ExportToCSV");
        vector.add("ExportToXLS");
        vector.add("Link");
        vector.add("EnableHyperlinkOnPDF");
        vector.add("EnableHyperlinkOnExcel");
        vector.add("EnableHyperlinkOnHTML");
        vector.add("DetailReport");
        vector.add("TransferStyle");
        vector.add("GotoDetail");
        vector.add("DetailTargetFrame");
        vector.add("FieldType");
        vector.add("DisplayNull");
        vector.add("ExportToPDF");
        CHAR_DESC.put(string, vector);
        string = "TOC";
        vector = new Vector(2);
        vector.add("TOCAnchor");
        vector.add("AnchorDispValue");
        CHAR_DESC.put(string, vector);
        string = "Accessibility";
        vector = new Vector(10);
        vector.add("ExternalCSSClassValue");
        vector.add("ExternalID");
        vector.add("ExternalStyle");
        vector.add("ExternalAccessKey");
        vector.add("ExternalDir");
        vector.add("ExternalTabIndex");
        vector.add("ExternalTitle");
        vector.add("LongDesc");
        vector.add("Lang");
        vector.add("HrefLang");
        CHAR_DESC.put(string, vector);
    }
}

