/*
 * Decompiled with CFR 0.152.
 */
package jet.report.bursting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.naming.ClassType;
import jet.report.JetRptObject;
import jet.report.bursting.BurstingRecipientServerInformationImpl;
import jet.report.bursting.RecipientMappingIdentifierImpl;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientSchema;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientServerInformation;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectInfo.bursting.RecipientMappingIdentifier;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;

public class JetRptBurstingSchema
extends JetRptObject
implements BurstingSchema,
BurstingRecipientSchema {
    public JetVector burstingDataSets;
    public JetString recipientDatasourceName;
    public JetString recipientQueryName;
    public JetString recipientMappingDisk;
    public JetString recipientMappingFTP;
    public JetString recipientMappingMail;
    public JetString recipientMappingServerVersionSystem;
    public JetBoolean selectedDefaultly = new JetBoolean(this, "SelectedDefaultly", true);
    public JetVector burstingKeyColumns;
    public JetVector recipientColumns;
    public JetString recipientMappingGroup;
    public JetBoolean userMailGroup;
    public JetBoolean usePrivateFolderGroup;
    public JetString privateFolderGroup;
    public JetString recipientMappingRole;
    public JetBoolean userMailRole;
    public JetBoolean usePrivateFolderRole;
    public JetString privateFolderRole;
    public JetString recipientMappingUser;
    public JetBoolean userMailUser;
    public JetBoolean usePrivateFolderUser;
    public JetString privateFolderUser;
    private static final HashMap QOIV = new HashMap(76);

    public JetRptBurstingSchema() {
        this.burstingDataSets = new JetVector(this, "BurstingDataSets");
        this.recipientDatasourceName = new JetString(this, "RecipientDatasourceName");
        this.recipientQueryName = new JetString(this, "RecipientQueryName");
        this.recipientMappingDisk = new JetString(this, "RecipientMappingDisk");
        this.recipientMappingFTP = new JetString(this, "RecipientMappingFTP");
        this.recipientMappingMail = new JetString(this, "RecipientMappingMail");
        this.recipientMappingServerVersionSystem = new JetString(this, "RecipientMappingSerVerSys");
        this.burstingKeyColumns = new JetVector(this, "BurstingKeyColumns");
        this.recipientColumns = new JetVector(this, "RecipientColumns");
        this.recipientMappingGroup = new JetString(this, "RecipientMappingGroup");
        this.userMailGroup = new JetBoolean(this, "UserMailGroup");
        this.usePrivateFolderGroup = new JetBoolean(this, "UsePrivateFolderGroup");
        this.privateFolderGroup = new JetString(this, "PrivateFolderGroup");
        this.recipientMappingRole = new JetString(this, "RecipientMappingRole");
        this.userMailRole = new JetBoolean(this, "UserMailRole");
        this.usePrivateFolderRole = new JetBoolean(this, "UsePrivateFolderRole");
        this.privateFolderRole = new JetString(this, "PrivateFolderRole");
        this.recipientMappingUser = new JetString(this, "RecipientMappingUser");
        this.userMailUser = new JetBoolean(this, "UserMailUser");
        this.usePrivateFolderUser = new JetBoolean(this, "UsePrivateFolderUser");
        this.privateFolderUser = new JetString(this, "PrivateFolderUser");
        this.selectedDefaultly.setCanChangeByOthers(false);
        this.recipientDatasourceName.setCanChangeByOthers(false);
        this.recipientQueryName.setCanChangeByOthers(false);
        this.recipientMappingDisk.setCanChangeByOthers(false);
        this.recipientMappingFTP.setCanChangeByOthers(false);
        this.recipientMappingMail.setCanChangeByOthers(false);
        this.recipientMappingServerVersionSystem.setCanChangeByOthers(false);
        this.recipientMappingGroup.setCanChangeByOthers(false);
        this.userMailGroup.setCanChangeByOthers(false);
        this.privateFolderGroup.setCanChangeByOthers(false);
        this.recipientMappingRole.setCanChangeByOthers(false);
        this.userMailRole.setCanChangeByOthers(false);
        this.privateFolderRole.setCanChangeByOthers(false);
        this.recipientMappingUser.setCanChangeByOthers(false);
        this.userMailUser.setCanChangeByOthers(false);
        this.privateFolderUser.setCanChangeByOthers(false);
    }

    public void afterInit() {
        if (!this.isAfterInit()) {
            String string = this.getInstName();
            if (string.startsWith("jet_report_bursting_JetRptBurstingSchema")) {
                String string2 = this.getInstancePrefix();
                string2 = string2.concat(string.substring("jet_report_bursting_JetRptBurstingSchema".length()));
                this.setInstName(string2);
            }
            super.afterInit();
        }
    }

    public String[] getBurstingDataSetNames() {
        return this.burstingDataSets.toStringArray();
    }

    public BurstingRecipientSchema getBurstingRecipientSchema() {
        return this;
    }

    public String[] getSharedDataSetNames() {
        JetObject jetObject = ObjectLogicFactory.getBasicComponentLogic().getAncestorComponentByClass((JetObject)this, "jet.reportset.JetRptReport");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jetObject != null && jetObject instanceof JetRptReport) {
            List list = ObjectLogicFactory.getReportLogic().getUsedDataSet((JetRptReport)jetObject);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JetRptDataSet jetRptDataSet = (JetRptDataSet)iterator.next();
                String string = jetRptDataSet.getInstName();
                if (this.burstingDataSets.get().contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String getDatasourceName() {
        return this.recipientDatasourceName.get();
    }

    public String getQueryName() {
        return this.recipientQueryName.get();
    }

    public String getRecipientMappingDisk() {
        String string = this.recipientMappingDisk.get();
        return string == null || string.length() == 0 ? null : string;
    }

    public String getRecipientMappingFTP() {
        String string = this.recipientMappingFTP.get();
        return string == null || string.length() == 0 ? null : string;
    }

    public RecipientMappingIdentifier[] getRecipientMappingIdentifiers() {
        Vector vector = this.burstingKeyColumns.get();
        Vector vector2 = this.recipientColumns.get();
        Vector<RecipientMappingIdentifierImpl> vector3 = new Vector<RecipientMappingIdentifierImpl>();
        int n = 0;
        while (n < Math.min(vector.size(), vector2.size())) {
            String string = (String)vector.get(n);
            String string2 = (String)vector2.get(n);
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                vector3.add(new RecipientMappingIdentifierImpl(string, string2));
            }
            ++n;
        }
        return vector3.toArray(new RecipientMappingIdentifier[0]);
    }

    public String getRecipientMappingMail() {
        String string = this.recipientMappingMail.get();
        return string == null || string.length() == 0 ? null : string;
    }

    public String getRecipientMappingServerVersionSystem() {
        String string = this.recipientMappingServerVersionSystem.get();
        return string == null || string.length() == 0 ? null : string;
    }

    public BurstingRecipientServerInformation getRecipientServerInformationGroup() {
        String string = this.recipientMappingGroup.get();
        return string == null || string.length() == 0 ? null : new BurstingRecipientServerInformationImpl(string, this.userMailGroup.get(), this.usePrivateFolderGroup.get(), this.privateFolderGroup.get());
    }

    public BurstingRecipientServerInformation getRecipientServerInformationRole() {
        String string = this.recipientMappingRole.get();
        return string == null || string.length() == 0 ? null : new BurstingRecipientServerInformationImpl(string, this.userMailRole.get(), this.usePrivateFolderRole.get(), this.privateFolderRole.get());
    }

    public BurstingRecipientServerInformation getRecipientServerInformationUser() {
        String string = this.recipientMappingUser.get();
        return string == null || string.length() == 0 ? null : new BurstingRecipientServerInformationImpl(string, this.userMailUser.get(), this.usePrivateFolderUser.get(), this.privateFolderUser.get());
    }

    public HashMap getIndecialMap() {
        return QOIV;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("schema name: ").append(this.getName()).append(" [isSelectedDefaultly: ").append(this.isSelectedDefaultly()).append("]\n");
        stringBuffer.append("{BurstingDataSetNames:[");
        JetRptBurstingSchema jetRptBurstingSchema = this;
        String[] stringArray = this.getBurstingDataSetNames();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        BurstingRecipientSchema burstingRecipientSchema = jetRptBurstingSchema.getBurstingRecipientSchema();
        stringBuffer.append("]\n BurstingRecipientSchema:{datasource:");
        stringBuffer.append(burstingRecipientSchema.getDatasourceName()).append("; query: ").append(burstingRecipientSchema.getQueryName()).append(";\n\t RecipientMappingIdentifiers: [");
        RecipientMappingIdentifier[] recipientMappingIdentifierArray = burstingRecipientSchema.getRecipientMappingIdentifiers();
        int n2 = 0;
        while (n2 < recipientMappingIdentifierArray.length) {
            stringBuffer.append(recipientMappingIdentifierArray[n2]);
            if (n2 < recipientMappingIdentifierArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append("];\n\t disk: ").append(burstingRecipientSchema.getRecipientMappingDisk()).append(";\n\t ftp: ").append(burstingRecipientSchema.getRecipientMappingFTP()).append(";\n\t mail: ").append(burstingRecipientSchema.getRecipientMappingMail()).append(";\n\t version: ").append(burstingRecipientSchema.getRecipientMappingServerVersionSystem()).append(";\n\t group: ").append(burstingRecipientSchema.getRecipientServerInformationGroup()).append(";\n\t role: ").append(burstingRecipientSchema.getRecipientServerInformationRole()).append(";\n\t user: ").append(burstingRecipientSchema.getRecipientServerInformationUser()).append("}}");
        return stringBuffer.toString();
    }

    public boolean canBeBrowse() {
        return false;
    }

    public boolean isSelectedDefaultly() {
        return this.selectedDefaultly.booleanValue();
    }

    public String getName() {
        return this.getInstName();
    }

    public void setName(String string) {
        if (JetObject.getRoot(this) instanceof JetRootable) {
            this.setInstName(string);
        } else {
            this.setInstNameDirectly(string);
        }
    }

    public String getInstancePrefix() {
        return ClassType.getClassTagByClassName(this.getClass().getName());
    }

    public void setSelectedDefaultly(boolean bl) {
        this.selectedDefaultly.set(bl);
    }

    static {
        int n = 0;
        QOIV.put("AnchorDispValue", new Integer(n++));
        QOIV.put("TOCAnchor", new Integer(n++));
        QOIV.put("StyleName", new Integer(n++));
        QOIV.put("DisplayName", new Integer(n++));
        QOIV.put("BurstingDataSets", new Integer(n++));
        QOIV.put("RecipientDatasourceName", new Integer(n++));
        QOIV.put("RecipientQueryName", new Integer(n++));
        QOIV.put("RecipientMappingDisk", new Integer(n++));
        QOIV.put("RecipientMappingFTP", new Integer(n++));
        QOIV.put("RecipientMappingMail", new Integer(n++));
        QOIV.put("RecipientMappingSerVerSys", new Integer(n++));
        QOIV.put("BurstingKeyColumns", new Integer(n++));
        QOIV.put("RecipientColumns", new Integer(n++));
        QOIV.put("RecipientMappingGroup", new Integer(n++));
        QOIV.put("UserMailGroup", new Integer(n++));
        QOIV.put("PrivateFolderGroup", new Integer(n++));
        QOIV.put("RecipientMappingRole", new Integer(n++));
        QOIV.put("UserMailRole", new Integer(n++));
        QOIV.put("PrivateFolderRole", new Integer(n++));
        QOIV.put("RecipientMappingUser", new Integer(n++));
        QOIV.put("UserMailUser", new Integer(n++));
        QOIV.put("PrivateFolderUser", new Integer(n++));
        QOIV.put("UsePrivateFolderGroup", new Integer(n++));
        QOIV.put("UsePrivateFolderRole", new Integer(n++));
        QOIV.put("UsePrivateFolderUser", new Integer(n++));
        QOIV.put("SelectedDefaultly", new Integer(n++));
    }
}

