/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj.rtf;

import java.io.IOException;
import jet.textobj.rtf.ASCII_CharStream;
import jet.textobj.rtf.KwdToken;
import jet.textobj.rtf.RTFRawLexerConstants;
import jet.textobj.rtf.Token;
import jet.textobj.rtf.TokenMgrError;

public class RTFRawLexerTokenManager
implements RTFRawLexerConstants {
    static final long[] BeginToken = new long[]{0L, 0L, -1L, -1L};
    static final int[] GetImage = new int[]{1, 2, 3, 4};
    public static final String[] jjstrLiteralImages = new String[]{"", null, null, null, "{", "}", null, null, ";"};
    public static final String[] lexStateNames = new String[]{"DEFAULT"};
    static final long[] GetSuffix = new long[]{497L};
    static final long[] QOIV = new long[]{14L};
    static final long[] ReInit = new long[]{8L};
    private ASCII_CharStream SwitchTo;
    private final int[] Z = new int[8];
    private final int[] append = new int[16];
    StringBuffer backup;
    int bdata;
    int beginColumn;
    protected char curChar;
    int beginLine = 0;
    int endColumn = 0;
    int endLine;
    int getBeginColumn;
    int getBeginLine;
    int getEndColumn;

    char[] BeginToken(int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = this.SwitchTo.readChar();
            ++n2;
        }
        return cArray;
    }

    byte[] GetImage(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)this.SwitchTo.readChar();
            ++n2;
        }
        return byArray;
    }

    private final int GetSuffix(int n, long l) {
        switch (n) {
            case 0: {
                if ((l & 8L) != 0L) {
                    return 5;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int QOIV(int n, long l) {
        return this.beginColumn(this.GetSuffix(n, l), n + 1);
    }

    private final int ReInit(int n, int n2) {
        this.getEndColumn = n2;
        this.getBeginLine = n;
        return n + 1;
    }

    private final int SwitchTo() {
        switch (this.curChar) {
            case ';': {
                return this.ReInit(0, 8);
            }
            case '\\': {
                return this.Z(8L);
            }
            case '{': {
                return this.ReInit(0, 4);
            }
            case '}': {
                return this.ReInit(0, 5);
            }
        }
        return this.beginColumn(0, 0);
    }

    private final int Z(long l) {
        try {
            this.curChar = this.SwitchTo.readChar();
        }
        catch (IOException iOException) {
            this.GetSuffix(0, l);
            return 1;
        }
        switch (this.curChar) {
            case '*': {
                if ((l & 8L) == 0L) break;
                return this.ReInit(1, 3);
            }
        }
        return this.QOIV(0, l);
    }

    private final void append(int n) {
        if (this.Z[n] != this.getBeginColumn) {
            this.append[this.endLine++] = n;
            this.Z[n] = this.getBeginColumn;
        }
    }

    private final void backup(int n, int n2) {
        this.append(n);
        this.append(n2);
    }

    private final void bdata(int n, int n2) {
        do {
            this.append(GetImage[n]);
        } while (n++ != n2);
    }

    private final int beginColumn(int n, int n2) {
        int n3 = 0;
        this.endLine = 8;
        int n4 = 1;
        this.append[0] = n;
        int n5 = Integer.MAX_VALUE;
        while (true) {
            if (++this.getBeginColumn == Integer.MAX_VALUE) {
                this.beginLine();
            }
            if (this.curChar < '@') {
                long l = 1L << this.curChar;
                block22: do {
                    switch (this.append[--n4]) {
                        case 0: {
                            if ((0xF7FFFFFFFFFFD9FFL & l) != 0L) {
                                if (n5 > 7) {
                                    n5 = 7;
                                }
                                this.append(7);
                                break;
                            }
                            if (this.curChar != '\t' || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 5: {
                            if ((0xFC00FBFFFFFFFFFFL & l) == 0L || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 2: {
                            if (this.curChar != '-') break;
                            this.append(3);
                            break;
                        }
                        case 3: {
                            if ((0x3FF000000000000L & l) == 0L) continue block22;
                            if (n5 > 6) {
                                n5 = 6;
                            }
                            this.backup(3, 4);
                            break;
                        }
                        case 4: {
                            if (this.curChar != ' ' || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 6: {
                            if (this.curChar != '\t' || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 7: {
                            if ((0xF7FFFFFFFFFFD9FFL & l) == 0L) continue block22;
                            if (n5 > 7) {
                                n5 = 7;
                            }
                            this.append(7);
                            break;
                        }
                    }
                } while (n4 != n3);
            } else if (this.curChar < '\u0080') {
                long l = 1L << (this.curChar & 0x3F);
                block23: do {
                    switch (this.append[--n4]) {
                        case 0: {
                            if ((0xD7FFFFFFEFFFFFFFL & l) != 0L) {
                                if (n5 > 7) {
                                    n5 = 7;
                                }
                                this.append(7);
                                break;
                            }
                            if (this.curChar != '\\') break;
                            this.backup(1, 5);
                            break;
                        }
                        case 5: {
                            if ((0x7FFFFFE00000000L & l) != 0L) {
                                if (n5 > 6) {
                                    n5 = 6;
                                }
                                this.bdata(0, 3);
                                break;
                            }
                            if ((0xF8000001F8000001L & l) == 0L || n5 <= 6) continue block23;
                            n5 = 6;
                            break;
                        }
                        case 1: {
                            if ((0x7FFFFFE00000000L & l) == 0L) continue block23;
                            if (n5 > 6) {
                                n5 = 6;
                            }
                            this.bdata(0, 3);
                            break;
                        }
                        case 7: {
                            if ((0xD7FFFFFFEFFFFFFFL & l) == 0L) continue block23;
                            if (n5 > 7) {
                                n5 = 7;
                            }
                            this.append(7);
                            break;
                        }
                    }
                } while (n4 != n3);
            } else {
                int n6 = (this.curChar & 0xFF) >> 6;
                long l = 1L << (this.curChar & 0x3F);
                block24: do {
                    switch (this.append[--n4]) {
                        case 0: 
                        case 7: {
                            if ((BeginToken[n6] & l) == 0L) continue block24;
                            if (n5 > 7) {
                                n5 = 7;
                            }
                            this.append(7);
                            break;
                        }
                        case 5: {
                            if ((BeginToken[n6] & l) == 0L || n5 <= 6) continue block24;
                            n5 = 6;
                            break;
                        }
                    }
                } while (n4 != n3);
            }
            if (n5 != Integer.MAX_VALUE) {
                this.getEndColumn = n5;
                this.getBeginLine = n2;
                n5 = Integer.MAX_VALUE;
            }
            ++n2;
            n4 = this.endLine;
            this.endLine = n3;
            if (n4 == (n3 = 8 - this.endLine)) {
                return n2;
            }
            try {
                this.curChar = this.SwitchTo.readChar();
            }
            catch (IOException iOException) {
                return n2;
            }
        }
    }

    public RTFRawLexerTokenManager(ASCII_CharStream aSCII_CharStream) {
        this.SwitchTo = aSCII_CharStream;
    }

    public RTFRawLexerTokenManager(ASCII_CharStream aSCII_CharStream, int n) {
        this(aSCII_CharStream);
        this.SwitchTo(n);
    }

    public void ReInit(ASCII_CharStream aSCII_CharStream) {
        this.endLine = 0;
        this.getBeginLine = 0;
        this.beginLine = this.endColumn;
        this.SwitchTo = aSCII_CharStream;
        this.beginLine();
    }

    private final void beginLine() {
        this.getBeginColumn = -2147483647;
        int n = 8;
        while (n-- > 0) {
            this.Z[n] = Integer.MIN_VALUE;
        }
    }

    public void ReInit(ASCII_CharStream aSCII_CharStream, int n) {
        this.ReInit(aSCII_CharStream);
        this.SwitchTo(n);
    }

    public void SwitchTo(int n) {
        if (n >= 1 || n < 0) {
            throw new TokenMgrError("Error: Ignoring invalid lexical state : " + n + ". State unchanged.", 2);
        }
        this.beginLine = n;
    }

    private final Token curChar() {
        Token token = Token.newToken(this.getEndColumn);
        token.kind = this.getEndColumn;
        String string = jjstrLiteralImages[this.getEndColumn];
        token.image = string == null ? this.SwitchTo.GetImage() : string;
        token.beginLine = this.SwitchTo.getBeginLine();
        token.beginColumn = this.SwitchTo.getBeginColumn();
        token.endLine = this.SwitchTo.getEndLine();
        token.endColumn = this.SwitchTo.getEndColumn();
        return token;
    }

    public final Token getNextToken() {
        Token token = null;
        int n = 0;
        while (true) {
            Token token2;
            try {
                this.curChar = this.SwitchTo.BeginToken();
            }
            catch (IOException iOException) {
                this.getEndColumn = 0;
                token2 = this.curChar();
                token2.specialToken = token;
                return token2;
            }
            this.backup = null;
            this.bdata = 0;
            try {
                while (this.curChar <= '\r' && (0x2400L & 1L << this.curChar) != 0L) {
                    this.curChar = this.SwitchTo.BeginToken();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            this.getEndColumn = Integer.MAX_VALUE;
            this.getBeginLine = 0;
            n = this.SwitchTo();
            if (this.getEndColumn == Integer.MAX_VALUE) break;
            if (this.getBeginLine + 1 < n) {
                this.SwitchTo.backup(n - this.getBeginLine - 1);
            }
            if ((GetSuffix[this.getEndColumn >> 6] & 1L << (this.getEndColumn & 0x3F)) != 0L) {
                token2 = this.curChar();
                token2.specialToken = token;
                this.endColumn(token2);
                return token2;
            }
            if ((ReInit[this.getEndColumn >> 6] & 1L << (this.getEndColumn & 0x3F)) == 0L) continue;
            token2 = this.curChar();
            if (token == null) {
                token = token2;
                continue;
            }
            token2.specialToken = token;
            token = token.next = token2;
        }
        int n2 = this.SwitchTo.getEndLine();
        int n3 = this.SwitchTo.getEndColumn();
        String string = null;
        boolean bl = false;
        try {
            this.SwitchTo.readChar();
            this.SwitchTo.backup(1);
        }
        catch (IOException iOException) {
            bl = true;
            String string2 = string = n <= 1 ? "" : this.SwitchTo.GetImage();
            if (this.curChar == '\n' || this.curChar == '\r') {
                ++n2;
                n3 = 0;
            }
            ++n3;
        }
        if (!bl) {
            this.SwitchTo.backup(1);
            string = n <= 1 ? "" : this.SwitchTo.GetImage();
        }
        throw new TokenMgrError(bl, this.beginLine, n2, n3, string, this.curChar, 0);
    }

    final void endColumn(Token token) {
        switch (this.getEndColumn) {
            case 4: {
                if (this.backup == null) {
                    this.backup = new StringBuffer(jjstrLiteralImages[4]);
                } else {
                    this.backup.append(jjstrLiteralImages[4]);
                }
                token.kind = 3;
                break;
            }
            case 5: {
                if (this.backup == null) {
                    this.backup = new StringBuffer(jjstrLiteralImages[5]);
                } else {
                    this.backup.append(jjstrLiteralImages[5]);
                }
                token.kind = 5;
                break;
            }
            case 6: {
                if (this.backup == null) {
                    this.beginColumn = this.getBeginLine + 1;
                    this.backup = new StringBuffer(new String(this.SwitchTo.GetSuffix(this.bdata + this.beginColumn)));
                } else {
                    this.beginColumn = this.getBeginLine + 1;
                    this.backup.append(new String(this.SwitchTo.GetSuffix(this.bdata + this.beginColumn)));
                }
                token.kind = 6;
                KwdToken kwdToken = (KwdToken)token;
                kwdToken.init();
                if (kwdToken.specialToken != null && kwdToken.specialToken.kind == 3) {
                    kwdToken.isExt = true;
                }
                int n = kwdToken.getId();
                try {
                    switch (n) {
                        case 12: {
                            char[] cArray = new char[]{(char)Integer.parseInt(new String(this.GetImage(2), 0), 16)};
                            kwdToken.image = new String(cArray);
                            break;
                        }
                        case 107: {
                            kwdToken.bdata = this.BeginToken(kwdToken.param);
                            break;
                        }
                        case 945: {
                            kwdToken.kind = 2;
                            kwdToken.image = "" + (char)kwdToken.param;
                        }
                    }
                    break;
                }
                catch (IOException iOException) {
                    throw new TokenMgrError("Can't get enough bytes for token:" + kwdToken, 0);
                }
            }
            case 7: {
                if (this.backup == null) {
                    this.beginColumn = this.getBeginLine + 1;
                    this.backup = new StringBuffer(new String(this.SwitchTo.GetSuffix(this.bdata + this.beginColumn)));
                } else {
                    this.beginColumn = this.getBeginLine + 1;
                    this.backup.append(new String(this.SwitchTo.GetSuffix(this.bdata + this.beginColumn)));
                }
                token.kind = 2;
                break;
            }
            case 8: {
                if (this.backup == null) {
                    this.backup = new StringBuffer(jjstrLiteralImages[8]);
                } else {
                    this.backup.append(jjstrLiteralImages[8]);
                }
                token.kind = 1;
                break;
            }
        }
    }
}

