/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.UMapTable;
import toolkit.db.PsqlSelColumn;

public abstract class JetUQueryField
extends JetUResourceEntity
implements JetUQueriableField {
    public JetString colName = new JetString(this, "ColumnName");
    public JetNumber sqlType = new JetNumber(this, "SQLType");
    public JetNumber precision = new JetNumber(this, "Precision");
    public JetNumber scale = new JetNumber(this, "Scale");
    public JetNumber nullable = new JetNumber(this, "Nullable");
    public JetNumber currency = new JetNumber(this, "Currency");
    public JetBoolean array = new JetBoolean(this, "Array");
    PsqlSelColumn I;

    public JetUQueryField() {
    }

    public JetUQueryField(String string, String string2, String string3, int n, int n2, int n3, int n4) {
        this(string, string2, string3, n, n2, n3, n4, false);
    }

    public JetUQueryField(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl) {
        super(string, string2);
        this.colName.set(string3);
        this.sqlType.set(n);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(n2);
        this.scale.set(n3);
        this.nullable.set(n3);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.array.set(bl);
    }

    public JetUQueryField(String string, String string2, PsqlSelColumn psqlSelColumn) {
        super(string, string2);
        this.I = psqlSelColumn;
        this.colName.set(psqlSelColumn.getName());
        this.sqlType.set(psqlSelColumn.getType());
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(psqlSelColumn.getPrecision());
        this.scale.set(psqlSelColumn.getScale());
        this.nullable.set(psqlSelColumn.getNullable());
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.array.set(psqlSelColumn.getArray());
        psqlSelColumn.setMappingName(string);
    }

    public void setResourceName(String string) {
        super.setResourceName(string);
        this.I.setMappingName(string);
    }

    public String getFldName() {
        return this.colName.get();
    }

    public void setFldName(String string) {
        this.colName.set(string);
    }

    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int n) {
        this.sqlType.set(n);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int n) {
        this.precision.set(n);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int n) {
        this.scale.set(n);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int n) {
        this.nullable.set(n);
    }

    public boolean getArray() {
        return this.array.get();
    }

    public void setArray(boolean bl) {
        this.array.set(bl);
    }

    public DbColDesc getColDesc() {
        DbColDesc dbColDesc = new DbColDesc(this.getFldName(), this.getSqlType(), this.getPrecision(), this.getScale(), this.getNullable());
        if (this.currency.get() > 0) {
            dbColDesc.setCurrency(true);
        }
        dbColDesc.setArray(this.getArray());
        this.addCaseSensitiveInfo(dbColDesc);
        this.addEncodingPattern(dbColDesc);
        return dbColDesc;
    }

    public JetUQueriable getQueriable() {
        return this.getQuery();
    }

    public String getQueriableName() {
        JetUQueriable jetUQueriable = this.getQueriable();
        if (jetUQueriable != null) {
            return jetUQueriable.getResourceName();
        }
        return null;
    }

    public JetUQuery getQuery() {
        return (JetUQuery)this.getParent();
    }

    public String getQueryName() {
        JetUQuery jetUQuery = this.getQuery();
        if (jetUQuery != null) {
            return jetUQuery.getResourceName();
        }
        return null;
    }

    public abstract String getDefaultMapingName();

    public PsqlSelColumn getPsqlSelColumn() {
        return this.I;
    }

    public boolean isNotResolved() {
        return this.I.isNotResolved();
    }

    public String getDefinition() {
        return "real name: " + this.getQueryName() + "." + this.getFldName();
    }

    public UMapTable getMapTable() {
        JetUQuery jetUQuery = this.getQuery();
        if (jetUQuery != null) {
            return jetUQuery.getMapTable();
        }
        return null;
    }

    public String toString() {
        String string = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.getResourceName() + "|" + this.colName.get() + "|" + this.sqlType.get() + "|" + this.precision.get() + "|" + this.scale.get() + "|" + this.array.get() + "|" + " ]";
        return string;
    }

    public boolean isSimilar(JetUResourceEntity jetUResourceEntity) {
        return super.isSimilar(jetUResourceEntity) && this.sqlType.equal(((JetUQueryField)jetUResourceEntity).sqlType) && this.colName.equal(((JetUQueryField)jetUResourceEntity).colName);
    }
}

