/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JRelationModel;
import com.jinfonet.dataservice.schema.relational.TransformFieldJoin;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import com.jinfonet.dataservice.schema.relational.TransformRelationSchema;
import com.jinfonet.dataservice.schema.relational.datasource.ITransformToRelationRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.IXmlMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlTransformToRelationRule;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import jet.JRException;
import jet.connect.DbColDesc;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.FieldJoinLoader;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUPrejoin;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUTransformDataField;
import jet.universe.JetUTransformRelationModel;
import jet.universe.JetUTransformRelationSchema;
import jet.universe.JetUXMLSupportInfo;
import jet.universe.exception.AddTableViewException;
import jet.util.HashVector;
import toolkit.db.TableInfo;

public class JetUXMLConnection
extends JetUConnection {
    public static final String defaultDateFormat = "yyyy-MM-dd";
    public static final String defaultTimeFormat = "hh:mm:ss";
    public static final String defaultTimestampFormat = "yyyy-MM-dd hh:mm:ss";
    private static final JetUPrejoin[] CaseSensitive = new JetUPrejoin[0];
    private static final HashMap QOIV = new HashMap(9);
    private static final HashVector Z;

    public JetUXMLConnection() {
        this.qualifiedNamePattern = new JetEnumeration(this, "QualifiedNamePattern", 83);
        this.CaseSensitive();
    }

    public JetUConnection createNew() {
        JetUTransformRelationSchema jetUTransformRelationSchema;
        JetUXMLConnection jetUXMLConnection = new JetUXMLConnection();
        JetObject.copyProperties(jetUXMLConnection, this);
        MetadataContainerImpl metadataContainerImpl = this.getXMLMetadata();
        if (metadataContainerImpl != null) {
            jetUXMLConnection.setXMLMetadata((MetadataContainerImpl)metadataContainerImpl.deepDup());
        }
        if ((jetUTransformRelationSchema = this.getTransformRelationSchema()) != null) {
            jetUXMLConnection.setTransformRelationSchema((JetUTransformRelationSchema)jetUTransformRelationSchema.deepDup());
        }
        return jetUXMLConnection;
    }

    private void CaseSensitive() {
        this.qualifiedNamePattern.set(new Integer(1));
        this.dateFormat.set(defaultDateFormat);
        this.timeFormat.set(defaultTimeFormat);
        this.timestampFormat.set(defaultTimestampFormat);
        this.encodingPattern.set(new Integer(0));
    }

    public void InitAfterLoad() {
        try {
            JetUTransformRelationSchema jetUTransformRelationSchema = this.getTransformRelationSchema();
            if (jetUTransformRelationSchema == null) {
                return;
            }
            TransformRelationSchema transformRelationSchema = jetUTransformRelationSchema.getTransformRelationSchema();
            MetadataContainerImpl metadataContainerImpl = this.getXMLMetadata();
            FieldJoinLoader.loadFieldJoin(metadataContainerImpl, transformRelationSchema);
            this.QOIV(metadataContainerImpl);
        }
        catch (JRException jRException) {
            JetUConnection.logger.error("load prejoin have error", jRException);
        }
    }

    private void QOIV(MetadataContainerImpl metadataContainerImpl) throws JRException {
        JRelationModel[] jRelationModelArray;
        JetUTransformRelationSchema jetUTransformRelationSchema = this.getTransformRelationSchema();
        if (jetUTransformRelationSchema == null) {
            return;
        }
        try {
            jRelationModelArray = jetUTransformRelationSchema.getTransformRelationSchema().getRelationModels();
        }
        catch (DSException dSException) {
            return;
        }
        int n = 0;
        while (n < jRelationModelArray.length) {
            ITransformToRelationRule[] iTransformToRelationRuleArray = ((TransformRelationModel)jRelationModelArray[n]).getTransformToRelation().getTransformRules();
            XmlTransformToRelationRule xmlTransformToRelationRule = (XmlTransformToRelationRule)iTransformToRelationRuleArray[0];
            IXmlMappingRule[] iXmlMappingRuleArray = xmlTransformToRelationRule.getXmlMappingRules();
            int n2 = 0;
            while (n2 < iXmlMappingRuleArray.length) {
                if (iXmlMappingRuleArray[n2].getType() == 4) {
                    String string = ((XmlMappingRule)iXmlMappingRuleArray[n2]).getXmlTransformSource().getAbsoluteXpath();
                    try {
                        metadataContainerImpl.getTreeNodes(string);
                    }
                    catch (DSException dSException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void connect() throws Exception {
    }

    public void disconnect() throws Exception {
    }

    public Vector getFieldsOfTable(String string, String string2, String string3) throws SQLException {
        Vector<DbColDesc> vector = new Vector<DbColDesc>();
        JetUTransformRelationSchema jetUTransformRelationSchema = this.add(string2);
        JetUTransformRelationModel jetUTransformRelationModel = jetUTransformRelationSchema.getJetUTransformRelationModel(string3);
        JetUTransformDataField[] jetUTransformDataFieldArray = jetUTransformRelationModel.getJetUTransformDataFields();
        int n = 0;
        int n2 = jetUTransformDataFieldArray.length;
        while (n < n2) {
            JetUTransformDataField jetUTransformDataField = jetUTransformDataFieldArray[n];
            DbColDesc dbColDesc = this.Z(jetUTransformDataField);
            vector.add(dbColDesc);
            ++n;
        }
        return vector;
    }

    private DbColDesc Z(JetUTransformDataField jetUTransformDataField) {
        int n = Types.typeToSQLType(jetUTransformDataField.getDataType());
        DbColDesc dbColDesc = new DbColDesc(jetUTransformDataField.getFldName(), n, jetUTransformDataField.getPrecision(), jetUTransformDataField.getScale(), jetUTransformDataField.getNullable());
        dbColDesc.setCurrency(jetUTransformDataField.isCurrency());
        dbColDesc.setArray(dbColDesc.getSqlType() == 2003);
        if (dbColDesc.isArray()) {
            n = Types.typeToSQLType(jetUTransformDataField.getBaseDataType());
            dbColDesc.setSqlType(n);
        }
        dbColDesc.setIgnoreCase(false);
        dbColDesc.setEncode(false);
        return dbColDesc;
    }

    public boolean isConnecting() {
        return false;
    }

    public boolean cnntToSameDB(JetUConnection jetUConnection) {
        if (jetUConnection != null || jetUConnection instanceof JetUXMLConnection) {
            JetUXMLConnection jetUXMLConnection = (JetUXMLConnection)jetUConnection;
            String string = this.getXMLMetadata().uriStr.get();
            String string2 = jetUXMLConnection.getXMLMetadata().uriStr.get();
            return string.equalsIgnoreCase(string2);
        }
        return false;
    }

    public void setTransformRelationSchema(JetUTransformRelationSchema jetUTransformRelationSchema) {
        this.removeTransformRelationSchema();
        super.add(jetUTransformRelationSchema);
    }

    public JetUTransformRelationSchema getTransformRelationSchema() {
        Vector vector = this.getChildren();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            if (jetObject instanceof JetUTransformRelationSchema) {
                return (JetUTransformRelationSchema)jetObject;
            }
            ++n;
        }
        return null;
    }

    private JetUTransformRelationSchema add(String string) {
        JetUTransformRelationSchema jetUTransformRelationSchema = this.getTransformRelationSchema();
        if (jetUTransformRelationSchema == null) {
            return null;
        }
        if (jetUTransformRelationSchema.getResourceName().equals(string)) {
            return jetUTransformRelationSchema;
        }
        return null;
    }

    public void removeTransformRelationSchema() {
        Vector vector = this.getChildren();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            if (jetObject instanceof JetUTransformRelationSchema) {
                this.remove(jetObject);
            }
            ++n;
        }
    }

    public String getSchemaName() {
        JetUTransformRelationSchema jetUTransformRelationSchema = this.getTransformRelationSchema();
        if (jetUTransformRelationSchema == null) {
            return null;
        }
        return jetUTransformRelationSchema.getResourceName();
    }

    public String[] getAllTableNames(String string) throws JRException {
        JetUTransformRelationSchema jetUTransformRelationSchema = this.add(string);
        if (jetUTransformRelationSchema == null) {
            return new String[0];
        }
        JetUTransformRelationModel[] jetUTransformRelationModelArray = jetUTransformRelationSchema.getJetUTransformRelationModels();
        String[] stringArray = new String[jetUTransformRelationModelArray.length];
        int n = 0;
        int n2 = jetUTransformRelationModelArray.length;
        while (n < n2) {
            stringArray[n] = jetUTransformRelationModelArray[n].getResourceName();
            ++n;
        }
        return stringArray;
    }

    public void setXMLMetadata(MetadataContainerImpl metadataContainerImpl) {
        this.removeXMLMetadata();
        super.add(metadataContainerImpl);
    }

    public MetadataContainerImpl getXMLMetadata() {
        Vector vector = this.getChildren();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            if (jetObject instanceof MetadataContainerImpl) {
                return (MetadataContainerImpl)jetObject;
            }
            ++n;
        }
        return null;
    }

    public void removeXMLMetadata() {
        Vector vector = this.getChildren();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            if (jetObject instanceof MetadataContainerImpl) {
                this.remove(jetObject);
            }
            ++n;
        }
    }

    public TableInfo createTableInfo(String string, String string2, String string3, int n) throws SQLException {
        TableInfo tableInfo = new TableInfo(string, string2, string3, n);
        Vector vector = this.getFieldsOfTable(string, string2, string3);
        tableInfo.setColumns(vector);
        return tableInfo;
    }

    public JetUSupportInfo getSupportInfo() {
        JetObject jetObject;
        Vector vector = this.getChildren();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            jetObject = (JetObject)vector.elementAt(n);
            if (jetObject instanceof JetUXMLSupportInfo) {
                return jetObject;
            }
            ++n;
        }
        jetObject = new JetUXMLSupportInfo();
        this.add(jetObject);
        return jetObject;
    }

    public void fetchSupportInfo() throws SQLException, ClassNotFoundException {
        JetUSupportInfo jetUSupportInfo = this.getSupportInfo();
    }

    public void updateSupportInfo() throws SQLException, ClassNotFoundException {
        this.fetchSupportInfo();
    }

    public Vector addTableViews(String string, String string2, String string3, int n) throws ClassNotFoundException, SQLException, AddTableViewException {
        Vector<String> vector = new Vector<String>();
        if (n == 2) {
            return vector;
        }
        StringBuffer stringBuffer = new StringBuffer();
        JetUTransformRelationSchema jetUTransformRelationSchema = this.add(string2);
        JetUTransformRelationModel[] jetUTransformRelationModelArray = jetUTransformRelationSchema.getJetUTransformRelationModels();
        int n2 = 0;
        int n3 = jetUTransformRelationModelArray.length;
        while (n2 < n3) {
            JetUTransformRelationModel jetUTransformRelationModel = jetUTransformRelationModelArray[n2];
            String string4 = jetUTransformRelationModel.getResourceName();
            int n4 = 0;
            while (this.isNameExist(string4)) {
                string4 = string4 + String.valueOf(n4);
                ++n4;
            }
            TableInfo tableInfo = this.createTableInfo("", jetUTransformRelationSchema.getResourceName(), jetUTransformRelationModel.getResourceName(), n);
            JetUTableView jetUTableView = this.addTableView(string4, tableInfo);
            if (jetUTableView == null) {
                stringBuffer.append("Catalog Name:  \nSchema Name: " + jetUTransformRelationSchema.getResourceName() + "\n" + "Table Name: " + jetUTransformRelationModel.getResourceName());
            }
            vector.add(string4);
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            throw new AddTableViewException(0, stringBuffer.toString());
        }
        return vector;
    }

    public Vector getTypeInfo() {
        JetUSupportInfo jetUSupportInfo = this.getSupportInfo();
        return jetUSupportInfo.getTypeInfo();
    }

    protected boolean isSQLTypeCaseSensitive(int n) {
        JetUJDBCTypeInfo jetUJDBCTypeInfo = this.getTypeInfo(n);
        return jetUJDBCTypeInfo == null ? true : jetUJDBCTypeInfo.CaseSensitive.get();
    }

    public JetUPrejoin[] getAllPrejoin() throws JRException {
        JetUTransformRelationSchema jetUTransformRelationSchema = this.getTransformRelationSchema();
        if (jetUTransformRelationSchema == null) {
            return CaseSensitive;
        }
        TransformRelationSchema transformRelationSchema = jetUTransformRelationSchema.getTransformRelationSchema();
        TransformFieldJoin[] transformFieldJoinArray = transformRelationSchema.getJoin();
        ArrayList<JetUPrejoin> arrayList = new ArrayList<JetUPrejoin>(transformFieldJoinArray.length);
        Set set = this.addTableView();
        int n = 0;
        int n2 = transformFieldJoinArray.length;
        while (n < n2) {
            TransformFieldJoin transformFieldJoin = transformFieldJoinArray[n];
            String string = transformFieldJoin.getFirstRelationModel().getName();
            String string2 = transformFieldJoin.getSecondRelationModel().getName();
            if (set.contains(string) && set.contains(string2)) {
                JetUPrejoin jetUPrejoin = new JetUPrejoin();
                jetUPrejoin.tableFrom.set(string);
                jetUPrejoin.columnFrom.set(transformFieldJoin.getFirstDataField().getName());
                jetUPrejoin.tableTo.set(string2);
                jetUPrejoin.columnTo.set(transformFieldJoin.getSecondDataField().getName());
                jetUPrejoin.operator.set(transformFieldJoin.getOperator());
                int n3 = 0;
                if (transformFieldJoin.isInnerJoin()) {
                    n3 = 0;
                } else if (transformFieldJoin.isFullOuter()) {
                    n3 = 2;
                } else if (transformFieldJoin.isLeftOuter()) {
                    n3 = 4;
                } else if (transformFieldJoin.isRightOuter()) {
                    n3 = 1;
                } else if (transformFieldJoin.isUnionJoin()) {
                    n3 = 8;
                }
                jetUPrejoin.outerJoin.set(n3);
                arrayList.add(jetUPrejoin);
            }
            ++n;
        }
        return arrayList.toArray(new JetUPrejoin[arrayList.size()]);
    }

    private Set addTableView() {
        Vector vector = this.getChildren();
        HashSet<String> hashSet = new HashSet<String>(vector.size());
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            if (jetObject instanceof JetUTableView) {
                hashSet.add(((JetUTableView)jetObject).getResourceName());
            }
            ++n;
        }
        return hashSet;
    }

    public String getInstancePrefix() {
        return "XMLConnection";
    }

    public HashMap getIndecialMap() {
        return QOIV;
    }

    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return Z;
        }
        return null;
    }

    static {
        QOIV.put("Name", new Integer(0));
        QOIV.put("TimestampFormat", new Integer(1));
        QOIV.put("EncodingPattern", new Integer(2));
        QOIV.put("Description", new Integer(3));
        QOIV.put("Pre-join", new Integer(4));
        QOIV.put("TimeFormat", new Integer(5));
        QOIV.put("SecurityCheck", new Integer(6));
        QOIV.put("QualifiedNamePattern", new Integer(7));
        QOIV.put("DateFormat", new Integer(8));
        Z = new HashVector(1);
        String string = "anonymous";
        Vector<String> vector = new Vector<String>(9);
        vector.add("Name");
        vector.add("TimestampFormat");
        vector.add("Description");
        vector.add("Pre-join");
        vector.add("TimeFormat");
        vector.add("SecurityCheck");
        vector.add("QualifiedNamePattern");
        vector.add("DateFormat");
        Z.put(string, vector);
    }
}

