/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.universe.businesslogic.Attachable;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.DataElement;

public class Dimension
extends DataElement
implements DimensionInfo,
Attachable,
JetContainable {
    Vector QOIV = new Vector();

    public Dimension() {
        this.setElementType(4);
    }

    public DetailInformation[] getInformations() {
        BLNode[] bLNodeArray = this.getBLChildren();
        int n = bLNodeArray.length;
        DetailInformation[] detailInformationArray = new DetailInformation[n];
        int n2 = 0;
        while (n2 < n) {
            detailInformationArray[n2] = (DetailInformation)bLNodeArray[n2];
            ++n2;
        }
        return detailInformationArray;
    }

    public HierarchyInfo[] getHierarchies() {
        return null;
    }

    public HierarchyInfo getDefaultHierarchy() {
        return null;
    }

    public DimensionInfo copy() {
        Dimension dimension = new Dimension();
        Dimension.copyProperties(dimension, this);
        DetailInformation[] detailInformationArray = this.getInformations();
        int n = 0;
        while (n < detailInformationArray.length) {
            DetailInformation detailInformation = detailInformationArray[n].copy();
            try {
                dimension.addInfo(detailInformation);
            }
            catch (BLDupleNameException bLDupleNameException) {
                bLDupleNameException.printStackTrace();
            }
            ++n;
        }
        return dimension;
    }

    public DetailInformation addInfo(DetailInformation detailInformation) throws BLDupleNameException {
        if (this.isUsedName(detailInformation.getName())) {
            throw new BLDupleNameException(detailInformation.getName());
        }
        if (this.isUsedDisplayName(detailInformation.getDisplayName())) {
            throw new BLDupleNameException(detailInformation.getDisplayName());
        }
        this.QOIV.add(detailInformation);
        detailInformation.setBLParent(this);
        return detailInformation;
    }

    public DetailInformation removeInfoByName(String string) {
        DetailInformation detailInformation = (DetailInformation)this.getChildByName(string);
        if (detailInformation != null) {
            detailInformation.setBLParent(null);
            this.QOIV.remove(detailInformation);
        }
        return detailInformation;
    }

    public DetailInformation getInfoByName(String string) {
        DetailInformation detailInformation = (DetailInformation)this.getChildByName(string);
        return detailInformation;
    }

    public BLNode[] getBLChildren() {
        int n = this.QOIV.size();
        Enumeration enumeration = this.QOIV.elements();
        BLNode[] bLNodeArray = new BLNode[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            bLNodeArray[n2] = (BLNode)enumeration.nextElement();
            ++n2;
        }
        return bLNodeArray;
    }

    public boolean isUsedName(String string) {
        boolean bl = false;
        if (this.getChildByName(string) != null) {
            bl = true;
        }
        return bl;
    }

    public BLNode getChildByName(String string) {
        BLNode bLNode = null;
        Iterator iterator = this.QOIV.iterator();
        while (iterator.hasNext()) {
            BLNode bLNode2 = (BLNode)iterator.next();
            if (!bLNode2.getName().equalsIgnoreCase(string)) continue;
            bLNode = bLNode2;
            break;
        }
        return bLNode;
    }

    public BLNode getChildByDisplayName(String string) {
        BLNode bLNode = null;
        Iterator iterator = this.QOIV.iterator();
        while (iterator.hasNext()) {
            BLNode bLNode2 = (BLNode)iterator.next();
            if (!bLNode2.getDisplayName().equalsIgnoreCase(string)) continue;
            bLNode = bLNode2;
            break;
        }
        return bLNode;
    }

    public BLNode[] removeChildren() {
        BLNode[] bLNodeArray = this.getBLChildren();
        int n = 0;
        while (n < bLNodeArray.length) {
            bLNodeArray[n].setBLParent(null);
            ++n;
        }
        this.QOIV.clear();
        return bLNodeArray;
    }

    public BLNode removeChildByName(String string) {
        DetailInformation detailInformation = this.removeInfoByName(string);
        return detailInformation;
    }

    public JetObject add(JetObject jetObject) {
        jetObject.setParent(this);
        this.QOIV.add(jetObject);
        return jetObject;
    }

    public JetObject remove(JetObject jetObject) {
        return null;
    }

    public void broadcast(JetObject jetObject, int n) {
    }

    public Vector getChildren() {
        return this.QOIV;
    }

    public void clear() {
        this.QOIV.clear();
    }

    public boolean isSimilar(BLNode bLNode) {
        if (!super.isSimilar(bLNode)) {
            return false;
        }
        DimensionInfo dimensionInfo = (DimensionInfo)bLNode;
        BLNode[] bLNodeArray = this.getInformations();
        BLNode[] bLNodeArray2 = dimensionInfo.getInformations();
        return BLNodeImpl.isSimilar(bLNodeArray, bLNodeArray2);
    }

    public String getInstancePrefix() {
        return "Dimension";
    }

    public boolean isUsedDisplayName(String string) {
        boolean bl = false;
        Iterator iterator = this.QOIV.iterator();
        while (iterator.hasNext()) {
            BLNode bLNode = (BLNode)iterator.next();
            if (!bLNode.getDisplayName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

