/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import java.util.Vector;
import jet.ReportEnv;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.report.JetRptField;
import jet.report.JetRptMap;
import jet.report.JetRptObject;
import jet.report.JetRptPicture;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReportSet;
import jet.upgrade.UpgradeMapTo910Impl;
import jet.upgrade.UpgradePicture8To910Impl;
import jet.upgrade.UpgradeRpt;
import jet.upgrade.UpgradeRptField8To910Impl;

public class UpgradeReportSetImpl
implements UpgradeRpt {
    private UpgradeRpt BuildNumber = new UpgradeMapTo910Impl();
    private UpgradeRpt QOIV = new UpgradePicture8To910Impl();
    private UpgradeRpt ServicePack = new UpgradeRptField8To910Impl();
    private BasicComponentLogic add = ObjectLogicFactory.getBasicComponentLogic();
    protected static int OLDER_VERSION = 1;
    protected static int HIGHER_VERSION = -1;
    protected static int SAME_VERSION = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JetRptObject upgrade(JetRptObject jetRptObject) {
        if (jetRptObject instanceof JetRptReportSet) {
            JetRptReportSet jetRptReportSet;
            JetRptReportSet jetRptReportSet2 = jetRptReportSet = (JetRptReportSet)jetRptObject;
            synchronized (jetRptReportSet2) {
                block6: {
                    if (UpgradeReportSetImpl.getVersionInfo(jetRptReportSet) != SAME_VERSION) break block6;
                    JetRptReportSet jetRptReportSet3 = jetRptReportSet;
                    return jetRptReportSet3;
                }
                if (UpgradeReportSetImpl.isLowerThan910(jetRptReportSet)) {
                    this.tryUpgradeObjectB910To(jetRptReportSet);
                }
                this.updateVersionInfo(jetRptReportSet);
            }
            return jetRptReportSet;
        }
        return null;
    }

    protected JetObject tryUpgradeObjectB910To(JetObject jetObject) {
        if (jetObject instanceof JetRptMap) {
            return this.BuildNumber.upgrade((JetRptMap)jetObject);
        }
        if (jetObject instanceof JetRptPicture) {
            return this.QOIV.upgrade((JetRptPicture)jetObject);
        }
        if (jetObject instanceof JetRptField) {
            return this.ServicePack.upgrade((JetRptField)jetObject);
        }
        if (jetObject instanceof JetContainable) {
            Vector vector = ((JetContainable)((Object)jetObject)).getChildren();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                JetObject jetObject2;
                JetObject jetObject3 = (JetObject)vector.get(n2);
                if (jetObject3 != (jetObject2 = this.tryUpgradeObjectB910To(jetObject3))) {
                    this.add.remove(jetObject3);
                    this.add.add((JetContainable)((Object)jetObject), jetObject2, n2);
                }
                ++n2;
            }
        }
        return jetObject;
    }

    protected void updateVersionInfo(JetRptReportSet jetRptReportSet) {
        jetRptReportSet.major.set(9);
        jetRptReportSet.minor.set(0);
        jetRptReportSet.dot3.set(0);
        jetRptReportSet.ServicePack.set(ReportEnv.servicepack);
        jetRptReportSet.BuildNumber.set(900);
    }

    protected static int getVersionInfo(JetRptReportSet jetRptReportSet) {
        if (jetRptReportSet.major.intValue() < 9 || jetRptReportSet.minor.intValue() < 0 || jetRptReportSet.dot3.intValue() < 0 || jetRptReportSet.ServicePack.intValue() < ReportEnv.servicepack) {
            return OLDER_VERSION;
        }
        if (jetRptReportSet.major.intValue() == 9 && jetRptReportSet.minor.intValue() == 0 && jetRptReportSet.dot3.intValue() == 0 && jetRptReportSet.ServicePack.intValue() == ReportEnv.servicepack) {
            return SAME_VERSION;
        }
        return HIGHER_VERSION;
    }

    protected static boolean isLowerThan910(JetRptReportSet jetRptReportSet) {
        if (jetRptReportSet.major.intValue() < 9) {
            return true;
        }
        if (jetRptReportSet.major.intValue() == 9 && jetRptReportSet.minor.intValue() == 0) {
            return jetRptReportSet.dot3.intValue() == 0 && jetRptReportSet.ServicePack.intValue() == 0;
        }
        return false;
    }
}

