/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.common.api.JdbcDriversConfig;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.ReportEnv;
import jet.bean.JREngine;
import jet.formula.ParamDesc;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReportSet;
import jet.rptservice.util.ParameterTools;
import jet.rptservice.util.ReportTools;
import jet.universe.DataCollection;
import jet.universe.JetUFileQuery;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.businesslogic.JBusinessLogic;

public class EngineTools {
    private JREngine LoadNoCache;

    public EngineTools(JREngine jREngine) {
        this.LoadNoCache = jREngine;
    }

    public static Vector getBVs(String string) {
        Vector<String> vector = new Vector<String>();
        JetUUniverse jetUUniverse = null;
        ReportEnv.checkEnv(new Object(), null, 1);
        try {
            jetUUniverse = JetUUniverse.LoadNoCache(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (jetUUniverse != null) {
            Vector vector2 = jetUUniverse.getAllDatabaseNames();
            int n = 0;
            while (n < vector2.size()) {
                Vector vector3 = new Vector();
                String string2 = (String)vector2.elementAt(n);
                Vector vector4 = jetUUniverse.getQueriables(string2);
                int n2 = 0;
                while (vector4 != null && n2 < vector4.size()) {
                    JBusinessLogic jBusinessLogic = EngineTools.LoadNoCache((JetUQueriable)vector4.elementAt(n2));
                    if (jBusinessLogic != null) {
                        vector.add(jBusinessLogic.getName());
                    }
                    ++n2;
                }
                ++n;
            }
            jetUUniverse.free();
            jetUUniverse = null;
        }
        return vector;
    }

    private static JBusinessLogic LoadNoCache(JetUQueriable jetUQueriable) {
        if (jetUQueriable == null) {
            return null;
        }
        if (jetUQueriable instanceof JetUQuery) {
            return ((JetUQuery)jetUQueriable).getBL();
        }
        if (jetUQueriable instanceof JetUProcedure) {
            return ((JetUProcedure)jetUQueriable).getBL();
        }
        if (jetUQueriable instanceof JetUFileQuery) {
            return ((JetUFileQuery)jetUQueriable).getBL();
        }
        if (jetUQueriable instanceof JetUUserDataSource) {
            return ((JetUUserDataSource)jetUQueriable).getBL();
        }
        return null;
    }

    public ParamDesc[] getQueryParams(String string, String string2) throws Exception {
        return this.getQueryParams(string, string2, null);
    }

    public ParamDesc[] getQueryParams(String string, String string2, JdbcDriversConfig jdbcDriversConfig) throws Exception {
        if (this.LoadNoCache != null) {
            ParameterTools parameterTools = ParameterTools.getInstance();
            ParamDesc[] paramDescArray = ParameterTools.getInstance().getParamsInQuery(this.LoadNoCache.getCatalog(), string, string2);
            paramDescArray = parameterTools.sort(paramDescArray);
            parameterTools.getShowValue(paramDescArray, this.LoadNoCache.getCatalog(), string, string2, jdbcDriversConfig);
            return paramDescArray;
        }
        return null;
    }

    public ParamDesc[] ParamValueChanged(String string, String string2, ParamDesc[] paramDescArray) {
        Vector vector;
        ParamDesc paramDesc = null;
        if (string != null) {
            boolean bl = false;
            int n = 0;
            while (n < paramDescArray.length) {
                if (paramDescArray[n].name.equalsIgnoreCase(string)) {
                    paramDesc = paramDescArray[n];
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return null;
            }
        }
        if (string2 == null && paramDesc != null) {
            string2 = paramDesc.getDefaultValue();
        }
        if ((vector = paramDesc.getReferedBy()) != null && !vector.isEmpty()) {
            try {
                paramDesc.setValue(string2, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ParamDesc[] paramDescArray2 = new ParamDesc[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                paramDescArray2[n] = (ParamDesc)vector.get(n);
                ++n;
            }
            ParameterTools parameterTools = ParameterTools.getInstance();
            paramDescArray2 = parameterTools.sort(paramDescArray2);
            this.QOIV(paramDescArray2, paramDesc, paramDescArray);
            return paramDescArray2;
        }
        return null;
    }

    private void QOIV(ParamDesc[] paramDescArray, ParamDesc paramDesc, ParamDesc[] paramDescArray2) {
        Vector[] vectorArray = new Vector[2];
        DataCollection dataCollection = new DataCollection();
        Hashtable<String, ParamDesc> hashtable = new Hashtable<String, ParamDesc>();
        int n = 0;
        while (n < paramDescArray2.length) {
            hashtable.put(paramDescArray2[n].getName().toUpperCase(), paramDescArray2[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < paramDescArray.length) {
            ParamDesc paramDesc2 = paramDescArray[n2];
            if (paramDesc != null || !paramDesc2.isValuesNotEmpty()) {
                try {
                    String string = paramDesc2.getImportSql();
                    if (paramDesc2.isColumn() && string != null && string.trim().length() != 0) {
                        Vector vector = paramDesc2.getColumns();
                        String[] stringArray = new String[vector == null ? 0 : vector.size()];
                        int n3 = stringArray.length;
                        while (--n3 >= 0) {
                            stringArray[n3] = (String)vector.elementAt(n3);
                        }
                        vectorArray = dataCollection.getResultSet(this.LoadNoCache.getCatalog(), paramDesc2, hashtable);
                        paramDesc2.setValues(vectorArray[0], Locale.getDefault());
                        paramDesc2.setShowValues(vectorArray.length > 1 ? vectorArray[1] : vectorArray[0]);
                        if (vectorArray[0].isEmpty()) {
                            paramDesc2.setValue("", Locale.getDefault());
                        }
                        if (vectorArray[0] != null && !vectorArray[0].isEmpty()) {
                            paramDesc2.setDefaultIndex(0);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public Date getModifyDate() {
        return new Date(new File(this.LoadNoCache.getCatName() == null || this.LoadNoCache.getCatName().length() == 0 ? this.LoadNoCache.getReportName() : this.LoadNoCache.getCatName()).lastModified());
    }

    public static boolean isPortletReportSet(String string, String string2) throws Exception {
        JetUUniverse jetUUniverse = ReportTools.loadUniverse(string);
        JetRptReportSet jetRptReportSet = ReportTools.loadReportSet(string2, null, true, jetUUniverse);
        boolean bl = ObjectLogicFactory.getReportSetLogic().isPortletReportSet(jetRptReportSet);
        jetUUniverse.free();
        jetUUniverse = null;
        jetRptReportSet.free();
        jetRptReportSet = null;
        return bl;
    }
}

