/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.sql;

import java.util.Vector;
import jet.log.JRLogger;
import toolkit.db.sql.NameFinder;
import toolkit.db.sql.Predicate;
import toolkit.db.sql.TKTreeNode;

public class CritNode
extends TKTreeNode {
    public static final int NODE_AND = 0;
    public static final int NODE_OR = 1;
    public static final int NODE_MORE = 2;
    public int type = 0;
    public boolean localId = false;
    public String sInfo = null;
    public Predicate thePrd = null;
    public boolean notId = false;
    public String truthValue = null;
    private NameFinder QOIV = null;
    private static JRLogger addChild = JRLogger.getLogger((class$toolkit$db$sql$CritNode == null ? (class$toolkit$db$sql$CritNode = CritNode.class$("toolkit.db.sql.CritNode")) : class$toolkit$db$sql$CritNode).getName());
    static Class class$toolkit$db$sql$CritNode;

    public CritNode() {
    }

    public CritNode(NameFinder nameFinder) {
        this();
        this.QOIV = nameFinder;
    }

    public CritNode(int n) {
        this();
        this.type = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setInfo(String string) {
        this.sInfo = string;
    }

    public String getInfo() {
        return this.sInfo;
    }

    public String getConditionString() {
        String string = "";
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            CritNode critNode = (CritNode)this.children.elementAt(n2);
            switch (critNode.getType()) {
                case 0: {
                    String string2 = "";
                    if (critNode.notId) {
                        string2 = string2 + " NOT ";
                    }
                    if (critNode.thePrd != null) {
                        string2 = string2 + critNode.thePrd.toString();
                    }
                    if (critNode.truthValue != null) {
                        string2 = string2 + critNode.truthValue;
                    }
                    if (n2 == 0) {
                        string = string2;
                        break;
                    }
                    string = string + " AND " + string2;
                    break;
                }
                case 1: {
                    string = string + " OR " + (critNode.notId ? "NOT " : "") + critNode.getConditionString();
                    break;
                }
                case 2: {
                    String string2 = " ";
                    if (critNode.notId) {
                        string2 = " NOT ";
                    }
                    if (string.length() == 0) {
                        string = string + string2 + "( " + critNode.getConditionString() + " )";
                        break;
                    }
                    string = string + " AND" + string2 + "( " + critNode.getConditionString() + " )";
                    break;
                }
            }
            ++n2;
        }
        return string;
    }

    public String getFormulaString() {
        String string = "";
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            CritNode critNode = (CritNode)this.children.elementAt(n2);
            switch (critNode.getType()) {
                case 0: {
                    String string2 = "";
                    if (critNode.notId) {
                        string2 = string2 + " !";
                    }
                    if (critNode.thePrd != null) {
                        string2 = string2 + critNode.thePrd.toFmlString();
                    }
                    if (critNode.truthValue != null) {
                        string2 = string2 + critNode.truthValue;
                    }
                    if (n2 == 0) {
                        string = string2;
                        break;
                    }
                    string = string + " && " + string2;
                    break;
                }
                case 1: {
                    string = string + " || " + (critNode.notId ? "! " : "") + critNode.getFormulaString();
                    break;
                }
                case 2: {
                    String string2 = "";
                    if (critNode.notId) {
                        string2 = " !";
                    }
                    if (string.length() == 0) {
                        string = string + string2 + "(" + critNode.getFormulaString() + ")";
                        break;
                    }
                    string = string + " && " + string2 + "(" + critNode.getFormulaString() + ")";
                    break;
                }
            }
            ++n2;
        }
        return string;
    }

    public String toString() {
        return this.sInfo;
    }

    public boolean isLocal(boolean bl) {
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            CritNode critNode = (CritNode)this.children.elementAt(n2);
            switch (critNode.getType()) {
                case 0: {
                    if (critNode.thePrd == null) break;
                    if (bl) {
                        if (!critNode.thePrd.isLocal(this.QOIV)) break;
                        this.localId = true;
                        break;
                    }
                    if (!critNode.thePrd.localId) break;
                    this.localId = true;
                    return true;
                }
                case 1: 
                case 2: {
                    if (!critNode.isLocal(bl)) break;
                    this.localId = true;
                    if (bl) break;
                    return true;
                }
            }
            ++n2;
        }
        if (!bl) {
            this.localId = false;
        }
        return this.localId;
    }

    public boolean isSqlorNode() {
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            CritNode critNode = (CritNode)this.children.elementAt(n2);
            if (critNode.getType() == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isOnlyMore() {
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            CritNode critNode = (CritNode)this.children.elementAt(n2);
            switch (critNode.getType()) {
                case 0: 
                case 1: {
                    return false;
                }
                case 2: {
                    return critNode.isOnlyMore();
                }
            }
            ++n2;
        }
        return true;
    }

    public CritNode getLocalNode() {
        this.isLocal(true);
        CritNode critNode = new CritNode(2);
        critNode.localId = true;
        boolean bl = this.isSqlorNode();
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            CritNode critNode2 = (CritNode)this.children.elementAt(n2);
            switch (critNode2.getType()) {
                case 0: {
                    if (critNode2.thePrd == null) break;
                    if (critNode2.thePrd.localId) {
                        critNode.addChild(critNode2);
                        break;
                    }
                    if (!this.localId || !bl) break;
                    critNode.addChild(critNode2);
                    break;
                }
                case 1: {
                    if (!this.localId) break;
                    critNode.addChild(critNode2);
                    break;
                }
                case 2: {
                    if (critNode2.isLocal(false)) {
                        if (critNode2.isSqlorNode()) {
                            critNode.addChild(critNode2);
                            break;
                        }
                        CritNode critNode3 = critNode2.getLocalNode();
                        if (critNode3.isOnlyMore()) break;
                        critNode.addChild(critNode3);
                        break;
                    }
                    if (!this.localId || !bl) break;
                    critNode.addChild(critNode2);
                }
            }
            ++n2;
        }
        return critNode;
    }

    public CritNode getServerNode() {
        this.isLocal(true);
        CritNode critNode = new CritNode(2);
        critNode.localId = false;
        boolean bl = this.isSqlorNode();
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            CritNode critNode2 = (CritNode)this.children.elementAt(n2);
            switch (critNode2.getType()) {
                case 0: {
                    if (critNode2.thePrd == null || critNode2.thePrd.localId) break;
                    if (this.localId) {
                        if (bl) break;
                        critNode.addChild(critNode2);
                        break;
                    }
                    critNode.addChild(critNode2);
                    break;
                }
                case 1: {
                    if (this.localId) break;
                    critNode.addChild(critNode2);
                    break;
                }
                case 2: {
                    CritNode critNode3;
                    if (!critNode2.isLocal(false)) {
                        if (this.localId) {
                            if (bl) break;
                            critNode.addChild(critNode2);
                            break;
                        }
                        critNode.addChild(critNode2);
                        break;
                    }
                    if (critNode2.isSqlorNode() || (critNode3 = critNode2.getServerNode()).isOnlyMore()) break;
                    critNode.addChild(critNode3);
                }
            }
            ++n2;
        }
        return critNode;
    }

    public void getSTW(Vector vector) {
        if (!this.isSqlorNode()) {
            int n = this.children.size();
            int n2 = 0;
            while (n2 < n) {
                CritNode critNode = (CritNode)this.children.elementAt(n2);
                switch (critNode.getType()) {
                    case 0: {
                        if (critNode.thePrd == null) break;
                        critNode.thePrd.getSTW(vector);
                        break;
                    }
                    case 2: {
                        critNode.getSTW(vector);
                    }
                }
                ++n2;
            }
        }
    }

    public void setNameFinder(NameFinder nameFinder) {
        this.QOIV = nameFinder;
    }

    public String toPathString() {
        if (this.parent == null) {
            return "#" + this.sInfo;
        }
        return this.parent.toPathString() + "->" + this.sInfo;
    }

    public void printChildren() {
        if (addChild.isDebugEnabled()) {
            String string = "[ ";
            int n = this.children.size();
            int n2 = 0;
            while (n2 < n) {
                CritNode critNode = (CritNode)this.children.elementAt(n2);
                string = string + critNode.toString() + ", ";
                ++n2;
            }
            string = string + " ]";
            addChild.debug(string);
        }
    }

    public void printTree() {
        if (addChild.isDebugEnabled()) {
            String string = this.toPathString();
            this.printChildren();
            string = string + "\n";
            int n = this.children.size();
            int n2 = 0;
            while (n2 < n) {
                CritNode critNode = (CritNode)this.children.elementAt(n2);
                string = string + critNode.toString() + "{ ";
                critNode.printTree();
                string = string + critNode.toString() + " }";
                ++n2;
            }
            addChild.debug(string);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

