/*
 * Decompiled with CFR 0.152.
 */
package util;

public class Node {
    protected Node parent;
    protected int length;
    protected Node[] nodes;
    private static int append = 0;

    public Node getParent() {
        return this.parent;
    }

    public Node getRoot() {
        Node node = this.parent;
        while (node != null) {
            node = node.parent;
        }
        return node;
    }

    public Node add(Node node) {
        return this.insert(node, this.length);
    }

    public Node insert(Node node, int n) {
        if (n < 0 || n > this.length) {
            throw new IndexOutOfBoundsException("Index " + n + " out of bound " + this.length);
        }
        if (this.nodes == null) {
            this.nodes = new Node[4];
        }
        if (this.length == this.nodes.length) {
            Node[] nodeArray = new Node[this.length + this.length];
            System.arraycopy(this.nodes, 0, nodeArray, 0, this.length);
            this.nodes = nodeArray;
        }
        if (n != this.length) {
            System.arraycopy(this.nodes, n, this.nodes, n + 1, this.length - n);
        }
        this.nodes[n] = node;
        ++this.length;
        if (node.parent != null) {
            node.parent.remove(node);
        }
        node.parent = this;
        return node;
    }

    public Node remove(Node node) {
        int n = this.indexOf(node);
        return n == -1 ? null : this.remove(n);
    }

    public Node remove(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Index " + n + " out of bound " + this.length);
        }
        Node node = this.nodes[n];
        if (n != this.length - 1) {
            System.arraycopy(this.nodes, n + 1, this.nodes, n, this.length - n - 1);
        }
        --this.length;
        if (this.length > 14 && this.nodes.length - this.length > this.length) {
            Node[] nodeArray = new Node[this.length + 1];
            System.arraycopy(this.nodes, 0, nodeArray, 0, this.length);
            this.nodes = nodeArray;
        }
        node.parent = null;
        return node;
    }

    public int indexOf(Node node) {
        if (node.parent == this) {
            int n = this.length;
            while (--n >= 0) {
                if (this.nodes[n] != node) continue;
                return n;
            }
        }
        return -1;
    }

    public Node getNode(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Index " + n + " out of bound " + this.length);
        }
        return this.nodes[n];
    }

    public int getNodeCount() {
        return this.length;
    }

    public Node[] getNodes() {
        Node[] nodeArray = new Node[this.length];
        if (this.length > 0) {
            System.arraycopy(this.nodes, 0, nodeArray, 0, this.length);
        }
        return nodeArray;
    }

    public void removeAll() {
        int n = this.length;
        while (--n >= 0) {
            this.remove(n);
        }
    }
}

