/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.ContentManager;

import com.ttv.manager.Catcher.CatcherFilter;
import com.ttv.manager.Catcher.CatcherFilterByEnum;
import com.ttv.manager.Catcher.CatcherValues;
import com.ttv.manager.Catcher.CatchersResult;
import com.ttv.manager.CatcherGroup.CatcherGroupTypeEnum;
import com.ttv.manager.ConfigurationManager.ConfigurationManager;
import com.ttv.manager.DeviceManager.DeviceManager;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Metadata.MetadataEnum;
import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.Package.PackageEncryptEnum;
import com.ttv.manager.Package.PackageFile;
import com.ttv.manager.Package.PackageFilter;
import com.ttv.manager.Package.PackageSortByEnum;
import com.ttv.manager.Package.PackageStatusEnum;
import com.ttv.manager.Package.PackageType;
import com.ttv.manager.Package.PackageValues;
import com.ttv.manager.Package.PackagesResult;
import com.ttv.manager.Package.ShortPackageValues;
import com.ttv.manager.Package.ShortPackagesResult;
import com.ttv.manager.Provider.ProviderValues;
import com.ttv.manager.Provider.ProvidersResult;
import com.ttv.manager.Provider.UProviderFilter;
import com.ttv.manager.Provider.UProviderFilterByEnum;
import com.ttv.manager.Provider.UProviderSortByEnum;
import com.ttv.manager.Target.MulticastTarget;
import com.ttv.manager.Target.MulticastTargetFilter;
import com.ttv.manager.Target.MulticastTargetResult;
import com.ttv.manager.Target.MulticastTargetSortByEnum;
import com.ttv.manager.Target.UnicastTarget;
import com.ttv.manager.Target.UnicastTargetFilter;
import com.ttv.manager.Target.UnicastTargetResult;
import com.ttv.manager.Target.UnicastTargetSortByEnum;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSContentException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSDuplicateException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidMetadataException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSLinkObjectException;
import com.ttv.manager.WSException.WSObjectStateException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.FilterProperty;
import com.ttv.manager.util.MediaPathExpiryTime;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.ClientGroupTypeEnum;
import com.ttv.zBandInterface.ContentException;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.DuplicateException;
import com.ttv.zBandInterface.ExpiryTime;
import com.ttv.zBandInterface.ExpiryTimeEnum;
import com.ttv.zBandInterface.File;
import com.ttv.zBandInterface.InternalErrorException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidMetadataException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.LinkObjectException;
import com.ttv.zBandInterface.MCTarget;
import com.ttv.zBandInterface.MCTargetFilter;
import com.ttv.zBandInterface.MCTargetSortByEnum;
import com.ttv.zBandInterface.Metadata;
import com.ttv.zBandInterface.ObjectStateException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.Program;
import com.ttv.zBandInterface.ProgramFilter;
import com.ttv.zBandInterface.ProgramList;
import com.ttv.zBandInterface.ProgramPreEncryptionEnum;
import com.ttv.zBandInterface.ProgramSortByEnum;
import com.ttv.zBandInterface.ProgramStatusEnum;
import com.ttv.zBandInterface.ProgramTemplate;
import com.ttv.zBandInterface.ProgramTemplateSecurityEnum;
import com.ttv.zBandInterface.Provider;
import com.ttv.zBandInterface.ProviderFilter;
import com.ttv.zBandInterface.ProviderSortByEnum;
import com.ttv.zBandInterface.UCTarget;
import com.ttv.zBandInterface.UCTargetFilter;
import com.ttv.zBandInterface.UCTargetSortByEnum;
import com.ttv.zBandInterface.holders.MCTargetArrayHolder;
import com.ttv.zBandInterface.holders.ProgramArrayHolder;
import com.ttv.zBandInterface.holders.ProgramListArrayHolder;
import com.ttv.zBandInterface.holders.ProviderArrayHolder;
import com.ttv.zBandInterface.holders.UCTargetArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentManager {
    private static final Category log = Category.getInstance(ContentManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, ContentManager> ourInstances = new HashMap();
    private String username = null;

    public static synchronized ContentManager getInstance(String username) {
        ContentManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new ContentManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private ContentManager(String username) {
        this.username = username;
    }

    private ProviderValues translateProvider(Provider provider) {
        ProviderValues pv = new ProviderValues();
        pv.setId(provider.getId());
        pv.setName(provider.getName());
        pv.setDescription(provider.getDescription());
        return pv;
    }

    private PackageValues translateProgram(Program program) {
        Metadata[] metadata = program.getMetadata();
        ArrayList<MetadataValues> metadataValuesList = new ArrayList<MetadataValues>();
        if (metadata != null) {
            for (int i = 0; i < metadata.length; ++i) {
                metadataValuesList.add(CommonUtils.translateMetadata(metadata[i]));
            }
        }
        PackageValues packageValues = new PackageValues();
        packageValues.setId(program.getId());
        packageValues.setPackageTypeId(program.getTemplateid());
        packageValues.setProviderid(program.getProviderid());
        packageValues.setProviderName(program.getProvidername());
        packageValues.setName(program.getName());
        packageValues.setDescription(program.getDescription());
        packageValues.setTargetfolder(program.getTargetfolder());
        packageValues.setContentmodifiedtime(program.getContentmodifiedtime());
        packageValues.setmetadataValuesList(metadataValuesList);
        packageValues.setFileid(program.getFileid());
        packageValues.setHashcode(program.getHashcode());
        packageValues.setPreencryptionProgress(program.getPreencryptionprogress());
        ExpiryTime et = program.getServerexpiry();
        MediaPathExpiryTime mpet = new MediaPathExpiryTime(et.getType().getValue(), et.getTime());
        packageValues.setExpiryTime(mpet);
        if (program.getStatus().equals(ProgramStatusEnum.Available)) {
            packageValues.setStatus(PackageStatusEnum.Available.getValue());
        } else if (program.getStatus().equals(ProgramStatusEnum.Locked)) {
            packageValues.setStatus(PackageStatusEnum.Locked.getValue());
        } else if (program.getStatus().equals(ProgramStatusEnum.Staging)) {
            packageValues.setStatus(PackageStatusEnum.Staging.getValue());
        } else if (program.getStatus().equals(ProgramStatusEnum.Transmitting)) {
            packageValues.setStatus(PackageStatusEnum.Transmitting.getValue());
        }
        packageValues.setSize(program.getSize());
        packageValues.setFiles(program.getFiles());
        if (program.getPreencryption().equals(ProgramPreEncryptionEnum.Default)) {
            packageValues.setEncrypt(PackageEncryptEnum.Default.getValue());
        } else if (program.getPreencryption().equals(ProgramPreEncryptionEnum.Disabled)) {
            packageValues.setEncrypt(PackageEncryptEnum.Disabled.getValue());
        } else if (program.getPreencryption().equals(ProgramPreEncryptionEnum.Encrypted)) {
            packageValues.setEncrypt(PackageEncryptEnum.Encrypted.getValue());
        } else if (program.getPreencryption().equals(ProgramPreEncryptionEnum.Encrypting)) {
            packageValues.setEncrypt(PackageEncryptEnum.Encrypting.getValue());
        } else if (program.getPreencryption().equals(ProgramPreEncryptionEnum.ToBeEncrypted)) {
            packageValues.setEncrypt(PackageEncryptEnum.ToBeEncrypted.getValue());
        }
        packageValues.setPreencryptionFiles(program.getPreencryptionfiles());
        return packageValues;
    }

    private ShortPackageValues translateShortProgram(ProgramList program) {
        ShortPackageValues shortPackageValues = new ShortPackageValues();
        shortPackageValues.setId(program.getId());
        shortPackageValues.setName(program.getName());
        return shortPackageValues;
    }

    private ProviderFilter translateUProviderFilter(UProviderFilter uProviderFilter) {
        ProviderFilter providerFilter = new ProviderFilter();
        providerFilter.setAscending(uProviderFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToProviderFilterPropertyList(uProviderFilter.getFilterPropertyList());
        providerFilter.setFilter(CommonUtils.serializeFilter(fp));
        providerFilter.setIndex(uProviderFilter.getIndex());
        if (uProviderFilter.getLimit() == null) {
            providerFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        } else {
            providerFilter.setLimit(uProviderFilter.getLimit());
        }
        if (uProviderFilter.getSortby().equals(UProviderSortByEnum.Name.getValue())) {
            providerFilter.setSortby(ProviderSortByEnum.Name);
        }
        return providerFilter;
    }

    public ProvidersResult getProviders() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        UProviderFilter uProviderFilter = new UProviderFilter();
        return this.getProviders(uProviderFilter);
    }

    public ProvidersResult getProviders(UProviderFilter uProviderFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getProviders() start:");
        ArrayList<ProviderValues> providerValuesList = new ArrayList<ProviderValues>();
        ProviderFilter providerFilter = this.translateUProviderFilter(uProviderFilter);
        log.debug((Object)("Index : " + providerFilter.getIndex()));
        log.debug((Object)("Limit : " + providerFilter.getLimit()));
        log.debug((Object)("Ascending : " + providerFilter.getAscending()));
        if (providerFilter.getSortby() != null) {
            log.debug((Object)("Sortby : " + providerFilter.getSortby().getValue()));
        } else {
            log.debug((Object)"Sortby : null");
        }
        log.debug((Object)("Filter : " + providerFilter.getFilter()));
        ProviderArrayHolder providerArrayHolder = new ProviderArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getProviders(providerFilter, providerArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Provider[] providers = providerArrayHolder.value;
        if (providers != null) {
            log.debug((Object)("Total Providers : " + providers.length));
            for (int i = 0; i < providers.length; ++i) {
                Provider provider = providers[i];
                if (provider == null) continue;
                log.debug((Object)("provider : " + provider.getName()));
                providerValuesList.add(this.translateProvider(provider));
            }
        } else {
            log.debug((Object)"Providers is null ");
        }
        log.debug((Object)("getProviders() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return new ProvidersResult(providerValuesList, new Long(count.value));
    }

    public ProviderValues getProvider(String providerId) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ProviderValues providerValues;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getProvider() start:");
        try {
            providerValues = this.translateProvider(WSLocator.getzBandInterface(this.username).getProvider(providerId));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("getProvider() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return providerValues;
    }

    private ProgramFilter translatePackageFilter(PackageFilter packageFilter) {
        ProgramFilter programFilter = new ProgramFilter();
        if (packageFilter.getSortby().equals(PackageSortByEnum.Name.getValue())) {
            programFilter.setSortby(ProgramSortByEnum.Name);
        } else if (packageFilter.getSortby().equals(PackageSortByEnum.Provider.getValue())) {
            programFilter.setSortby(ProgramSortByEnum.Provider);
        } else if (packageFilter.getSortby().equals(PackageSortByEnum.Size.getValue())) {
            programFilter.setSortby(ProgramSortByEnum.Size);
        } else if (packageFilter.getSortby().equals(PackageSortByEnum.ContentModifiedTime.getValue())) {
            programFilter.setSortby(ProgramSortByEnum.ContentModifiedTime);
        }
        programFilter.setAscending(packageFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToProgramFilterPropertyList(packageFilter.getFilterPropertyList());
        programFilter.setFilter(CommonUtils.serializeFilter(fp));
        programFilter.setIndex(packageFilter.getIndex());
        if (packageFilter.getLimit() == null) {
            programFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        } else {
            programFilter.setLimit(packageFilter.getLimit());
        }
        return programFilter;
    }

    private MCTargetFilter translateMulticastTargetFilter(MulticastTargetFilter multicastTargetFilter) {
        MCTargetFilter targetFilter = new MCTargetFilter();
        MulticastTargetSortByEnum multicastTargetSortByEnum = multicastTargetFilter.getSortby();
        if (multicastTargetSortByEnum.equals(MulticastTargetSortByEnum.CatcherGroupName)) {
            targetFilter.setSortby(MCTargetSortByEnum.ClientGroup);
        }
        targetFilter.setAscending(targetFilter.getAscending());
        targetFilter.setFilter(CommonUtils.serializeFilter(multicastTargetFilter.getFilter()));
        targetFilter.setIndex(multicastTargetFilter.getIndex());
        targetFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        return targetFilter;
    }

    private UCTargetFilter translateUnicastTargetFilter(UnicastTargetFilter unicastTargetFilter) {
        UCTargetFilter targetFilter = new UCTargetFilter();
        UnicastTargetSortByEnum unicastTargetSortByEnum = unicastTargetFilter.getSortby();
        if (unicastTargetSortByEnum.equals(UnicastTargetSortByEnum.CatcherGroupName)) {
            targetFilter.setSortby(UCTargetSortByEnum.ClientGroup);
        }
        targetFilter.setAscending(targetFilter.getAscending());
        targetFilter.setFilter(CommonUtils.serializeFilter(unicastTargetFilter.getFilter()));
        targetFilter.setIndex(unicastTargetFilter.getIndex());
        targetFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        return targetFilter;
    }

    public ShortPackagesResult getShortPackages() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        PackageFilter packageFilter = new PackageFilter();
        packageFilter.setSortby(PackageSortByEnum.Name.getValue());
        packageFilter.setIndex(new Long(0L));
        packageFilter.setAscending(new Boolean(true));
        return this.getShortPackages(packageFilter);
    }

    public PackagesResult getPackages() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        PackageFilter packageFilter = new PackageFilter();
        packageFilter.setSortby(PackageSortByEnum.Name.getValue());
        packageFilter.setIndex(new Long(0L));
        packageFilter.setAscending(new Boolean(true));
        return this.getPackages(packageFilter);
    }

    public PackagesResult getPackages(PackageFilter packageFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getPackages() start:");
        PackagesResult result = new PackagesResult();
        if (packageFilter == null) {
            return this.getPackages();
        }
        ArrayList<PackageValues> packageValuesList = new ArrayList<PackageValues>();
        LongHolder count = new LongHolder(0L);
        ProgramFilter programFilter = this.translatePackageFilter(packageFilter);
        ProgramArrayHolder programArrayHolder = new ProgramArrayHolder();
        try {
            WSLocator.getzBandInterface(this.username).getPrograms(programFilter, programArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Program[] programs = programArrayHolder.value;
        if (programs != null) {
            for (int i = 0; i < programs.length; ++i) {
                Program program = programs[i];
                if (program == null) continue;
                packageValuesList.add(this.translateProgram(program));
            }
        }
        result = new PackagesResult(packageValuesList, new Long(count.value));
        log.debug((Object)("getPackages() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public ShortPackagesResult getShortPackages(PackageFilter packageFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getShortPackages() start:");
        ShortPackagesResult result = new ShortPackagesResult();
        if (packageFilter == null) {
            return this.getShortPackages();
        }
        ArrayList<ShortPackageValues> shortPackageValuesList = new ArrayList<ShortPackageValues>();
        LongHolder count = new LongHolder(0L);
        ProgramFilter programFilter = this.translatePackageFilter(packageFilter);
        ProgramListArrayHolder programListArrayHolder = new ProgramListArrayHolder();
        try {
            WSLocator.getzBandInterface(this.username).getHistoricalProgramList(programFilter, programListArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ProgramList[] programs = programListArrayHolder.value;
        if (programs != null) {
            for (int i = 0; i < programs.length; ++i) {
                ProgramList program = programs[i];
                if (program == null) continue;
                shortPackageValuesList.add(this.translateShortProgram(program));
            }
        }
        result = new ShortPackagesResult(shortPackageValuesList, new Long(count.value));
        log.debug((Object)("getPackages() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public PackagesResult getArchivedPackages() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        Program[] programs;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getArchivedPackages() start:");
        try {
            programs = WSLocator.getzBandInterface(this.username).getArchivedPrograms();
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ArrayList<PackageValues> packageValuesList = new ArrayList<PackageValues>();
        Long size = new Long(0L);
        if (programs != null) {
            size = new Long(programs.length);
            int i = 0;
            while ((long)i < size) {
                Program program = programs[i];
                if (program != null) {
                    packageValuesList.add(this.translateProgram(program));
                }
                ++i;
            }
        }
        log.debug((Object)("getArchivedPackages() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return new PackagesResult(packageValuesList, new Long(programs.length));
    }

    public PackagesResult getReprocessPackages() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        Program[] programs;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getReprocessPackages() start:");
        try {
            programs = WSLocator.getzBandInterface(this.username).getArchivedPrograms();
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ArrayList<PackageValues> packageValuesList = new ArrayList<PackageValues>();
        Long size = new Long(0L);
        if (programs != null) {
            size = new Long(programs.length);
            int i = 0;
            while ((long)i < size) {
                Program program = programs[i];
                if (program != null) {
                    packageValuesList.add(this.translateProgram(program));
                }
                ++i;
            }
        }
        log.debug((Object)("getReprocessPackages() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return new PackagesResult(packageValuesList, new Long(programs.length));
    }

    private Metadata translateMetadataValues(MetadataValues metadataValues) {
        Metadata metadata = new Metadata();
        metadata.setProperty(metadataValues.getProperty());
        if (metadataValues.getValue() == null) {
            metadata.setValue("");
        } else {
            metadata.setValue(metadataValues.getValue());
        }
        return metadata;
    }

    private Program translatePackageValues(PackageValues packageValues) {
        ExpiryTime et;
        ArrayList<MetadataValues> metadataArrayList = packageValues.getmetadataValuesList();
        Metadata[] metadata = null;
        if (metadataArrayList != null) {
            metadata = new Metadata[metadataArrayList.size()];
            for (int i = 0; i < metadataArrayList.size(); ++i) {
                MetadataValues metadataValues = metadataArrayList.get(i);
                metadata[i] = this.translateMetadataValues(metadataValues);
            }
        }
        Program program = new Program();
        program.setId(packageValues.getId());
        program.setTemplateid(packageValues.getPackageTypeId());
        program.setProviderid(packageValues.getProviderid());
        program.setName(packageValues.getName());
        program.setProvidername(packageValues.getProviderName());
        program.setDescription(packageValues.getDescription());
        program.setTargetfolder(packageValues.getTargetfolder());
        program.setContentmodifiedtime(packageValues.getContentmodifiedtime());
        program.setMetadata(metadata);
        program.setFileid(packageValues.getFileid());
        program.setHashcode(packageValues.getHashcode());
        program.setSize(packageValues.getSize());
        if (packageValues.getExpiryTime().getType().equals(ExpiryTimeEnum.Never.getValue())) {
            et = new ExpiryTime(ExpiryTimeEnum.Never, packageValues.getExpiryTime().getTime());
            program.setServerexpiry(et);
        } else if (packageValues.getExpiryTime().getType().equals(ExpiryTimeEnum.Relative.getValue())) {
            et = new ExpiryTime(ExpiryTimeEnum.Relative, packageValues.getExpiryTime().getTime());
            program.setServerexpiry(et);
        } else if (packageValues.getExpiryTime().getType().equals(ExpiryTimeEnum.Absolute.getValue())) {
            et = new ExpiryTime(ExpiryTimeEnum.Absolute, packageValues.getExpiryTime().getTime());
            program.setServerexpiry(et);
        }
        if (packageValues.getEncrypt().equals(PackageEncryptEnum.Default.getValue())) {
            program.setPreencryption(ProgramPreEncryptionEnum.Default);
        } else if (packageValues.getEncrypt().equals(PackageEncryptEnum.Disabled.getValue())) {
            program.setPreencryption(ProgramPreEncryptionEnum.Disabled);
        } else if (packageValues.getEncrypt().equals(PackageEncryptEnum.Encrypted.getValue())) {
            program.setPreencryption(ProgramPreEncryptionEnum.Encrypted);
        } else if (packageValues.getEncrypt().equals(PackageEncryptEnum.Encrypting.getValue())) {
            program.setPreencryption(ProgramPreEncryptionEnum.Encrypting);
        } else if (packageValues.getEncrypt().equals(PackageEncryptEnum.ToBeEncrypted.getValue())) {
            program.setPreencryption(ProgramPreEncryptionEnum.ToBeEncrypted);
        }
        program.setPreencryptionfiles(packageValues.getPreencryptionFiles());
        return program;
    }

    public String addPackage(PackageValues packageValues) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSDuplicateException {
        ExceptionManager emgr;
        String packageId;
        long begin = System.currentTimeMillis();
        log.debug((Object)"addPackage() start:");
        Program program = this.translatePackageValues(packageValues);
        String providerId = packageValues.getProviderid();
        if (providerId == null || providerId.trim().length() == 0) {
            String providerName = packageValues.getProviderName();
            if (providerName != null && providerName.trim().length() > 0) {
                UProviderFilter uProviderFilter = new UProviderFilter();
                FilterProperty filterProperty = new FilterProperty();
                filterProperty.setFilterby(UProviderFilterByEnum.Name.getValue());
                filterProperty.setFilter(providerName);
                ArrayList<FilterProperty> filterPropertyList = new ArrayList<FilterProperty>();
                filterPropertyList.add(filterProperty);
                uProviderFilter.setFilterPropertyList(filterPropertyList);
                ProvidersResult providers = this.getProviders(uProviderFilter);
                if (providers == null || providers.getProviderValues().size() == 0) {
                    providerId = this.addProvider(providerName);
                    log.debug((Object)("Creating provider [" + providerName + "] with id [" + providerId + "] programatically as it does NOT exist"));
                } else {
                    providerId = providers.getProviderValues().get(0).getId();
                }
            } else {
                providerId = "";
            }
            packageValues.setProviderid(providerId);
            program.setProviderid(providerId);
        }
        try {
            packageId = WSLocator.getzBandInterface(this.username).updateProgram(program);
        }
        catch (InvalidMetadataException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        packageValues.setId(packageId);
        log.debug((Object)("addPackage() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)(" : added package [" + packageValues.getName() + "] by user [" + this.username + "]"));
        return packageId;
    }

    public void deletePackage(String packageid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deletePackage() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteProgram(packageid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)(" : deleted package with id [" + packageid + "] by user [" + this.username + "]"));
        log.debug((Object)("deletePackage() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void deletePackages(ArrayList<String> packageids) {
        if (packageids != null) {
            for (String packageid : packageids) {
                try {
                    this.deletePackage(packageid);
                }
                catch (Exception e) {
                    log.error((Object)("Failed while deleting package with id:" + packageid), (Throwable)e);
                }
            }
        }
    }

    public void updatePackage(PackageValues packageValues) throws WSObjectStateException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException {
        Program program = this.translatePackageValues(packageValues);
        try {
            WSLocator.getzBandInterface(this.username).setProgram(program);
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (InvalidMetadataException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    public PackageValues getPackage(String packageid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        Program program;
        try {
            program = WSLocator.getzBandInterface(this.username).getProgram(packageid);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        PackageValues packageValues = this.translateProgram(program);
        return packageValues;
    }

    public String getLicenseStartDt(String packageid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        Program program;
        String LicenseStartDt = "";
        try {
            program = WSLocator.getzBandInterface(this.username).getProgram(packageid);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        PackageValues packageValues = this.translateProgram(program);
        ArrayList<MetadataValues> metaValList = packageValues.getmetadataValuesList();
        for (MetadataValues metaData : metaValList) {
            if (!metaData.getProperty().toString().equals(MetadataEnum.MP_LicenseStart.getValue())) continue;
            LicenseStartDt = metaData.getValue().toString();
            break;
        }
        return LicenseStartDt;
    }

    public String getLicenseEndDate(String packageid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        Program program;
        String LicenseEndDt = "";
        try {
            program = WSLocator.getzBandInterface(this.username).getProgram(packageid);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        PackageValues packageValues = this.translateProgram(program);
        ArrayList<MetadataValues> metaValList = packageValues.getmetadataValuesList();
        for (MetadataValues metaData : metaValList) {
            if (!metaData.getProperty().toString().equals(MetadataEnum.MP_LicenseEnd.getValue())) continue;
            LicenseEndDt = metaData.getValue();
            break;
        }
        return LicenseEndDt;
    }

    public String getXML(String packageid, String fileName) throws WSPermissionException, WSContentException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String XML;
        long begin = System.currentTimeMillis();
        log.debug((Object)"get() start:");
        log.debug((Object)("getting XML for packageid [" + packageid + "]"));
        try {
            XML = WSLocator.getzBandInterface(this.username).getXMLFile(packageid, fileName);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("get() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return XML;
    }

    public ArrayList<PackageFile> listFiles(String packageid) throws WSPermissionException, WSContentException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        File[] files;
        long begin = System.currentTimeMillis();
        log.debug((Object)"listFiles() start:");
        ArrayList<PackageFile> fList = new ArrayList<PackageFile>();
        try {
            files = WSLocator.getzBandInterface(this.username).getFiles(packageid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        if (files != null) {
            for (File file : files) {
                if (file == null) continue;
                PackageFile packageFile = new PackageFile();
                packageFile.setId(file.getId());
                packageFile.setName(file.getName());
                packageFile.setSize(file.getSize());
                packageFile.setUrl(file.getUrl());
                packageFile.setVersion(file.getVersion());
                fList.add(packageFile);
            }
        }
        log.debug((Object)("listFiles() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return fList;
    }

    public void movePackageToProvider(String packageid, String providerid) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        Program program;
        try {
            program = WSLocator.getzBandInterface(this.username).getProgram(packageid);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        program.setProviderid(providerid);
        try {
            WSLocator.getzBandInterface(this.username).setProgram(program);
        }
        catch (InvalidMetadataException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private Provider translateProviderValues(ProviderValues providerValues) {
        Provider provider = new Provider();
        provider.setId(providerValues.getId());
        provider.setName(providerValues.getName());
        provider.setDescription(providerValues.getDescription());
        return provider;
    }

    public String addProvider(String name) throws WSDuplicateException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ProviderValues providerValues = new ProviderValues();
        providerValues.setName(name);
        providerValues.setDescription("");
        return this.addProvider(providerValues);
    }

    public String addProvider(ProviderValues providerValues) throws WSDuplicateException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String providerId;
        long begin = System.currentTimeMillis();
        log.debug((Object)"addProvider() start:");
        Provider provider = this.translateProviderValues(providerValues);
        try {
            providerId = WSLocator.getzBandInterface(this.username).createProvider(provider);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("addProvider() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)(" : added provider [" + providerValues.getName() + "] by user [" + this.username + "]"));
        return providerId;
    }

    public void deleteProvider(String providerid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteProvider() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteProvider(providerid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("deleteProvider() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)(" : deleted provider [" + providerid + "] by user [" + this.username + "]"));
    }

    public void updateProvider(ProviderValues providerValues) throws WSDuplicateException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"updateProvider() start:");
        Provider provider = this.translateProviderValues(providerValues);
        try {
            WSLocator.getzBandInterface(this.username).setProvider(provider);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("updateProvider() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)(" : updated provider [" + providerValues.getName() + "] by user [" + this.username + "]"));
    }

    private PackageType translateProgramTemplate(ProgramTemplate programTemplate) {
        Metadata[] metadata = programTemplate.getMetadata();
        ArrayList<MetadataValues> metadataValuesList = new ArrayList<MetadataValues>();
        if (metadata != null) {
            for (int i = 0; i < metadata.length; ++i) {
                metadataValuesList.add(CommonUtils.translateMetadata(metadata[i]));
            }
        }
        PackageType packageType = new PackageType();
        packageType.setId(programTemplate.getId());
        packageType.setName(programTemplate.getName());
        packageType.setDescription(programTemplate.getDescription());
        packageType.setEncrypt(programTemplate.isPreencryption());
        packageType.setPreencryptionFiles(programTemplate.getPreencryptionfiles());
        packageType.setMetadataValuesList(metadataValuesList);
        return packageType;
    }

    private ProgramTemplate translatePackageType(PackageType packageType, boolean editPkgType) {
        MetadataValues metadataValues;
        int i;
        ArrayList<MetadataValues> metadataArrayList = packageType.getMetadataValuesList();
        Metadata[] metadata = null;
        if (!editPkgType) {
            if (metadataArrayList == null) {
                metadataArrayList = new ArrayList();
                metadataArrayList.add(new MetadataValues("X-VOD", "F"));
            } else {
                metadataArrayList.add(new MetadataValues("X-VOD", "F"));
            }
            metadata = new Metadata[metadataArrayList.size()];
            for (i = 0; i < metadataArrayList.size(); ++i) {
                metadataValues = metadataArrayList.get(i);
                metadata[i] = this.translateMetadataValues(metadataValues);
            }
        } else if (metadataArrayList != null) {
            metadata = new Metadata[metadataArrayList.size()];
            for (i = 0; i < metadataArrayList.size(); ++i) {
                metadataValues = metadataArrayList.get(i);
                metadata[i] = this.translateMetadataValues(metadataValues);
            }
        }
        ProgramTemplate programTemplate = new ProgramTemplate();
        programTemplate.setId(packageType.getId());
        programTemplate.setDescription(packageType.getDescription());
        programTemplate.setName(packageType.getName());
        programTemplate.setPreencryption(packageType.isEncrypt());
        programTemplate.setPreencryptionfiles(packageType.getPreencryptionFiles());
        programTemplate.setMetadata(metadata);
        programTemplate.setSecurity(ProgramTemplateSecurityEnum.value2);
        GregorianCalendar clientExpiryTime = new GregorianCalendar();
        clientExpiryTime.setTimeInMillis(604800000L);
        programTemplate.setClientexpiry(new ExpiryTime(ExpiryTimeEnum.Relative, clientExpiryTime));
        return programTemplate;
    }

    public ArrayList<PackageType> getPackageTypes() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ProgramTemplate[] programTemplates;
        try {
            programTemplates = WSLocator.getzBandInterface(this.username).getProgramTemplates();
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ArrayList<PackageType> packageTypesList = new ArrayList<PackageType>();
        if (programTemplates != null) {
            for (int i = 0; i < programTemplates.length; ++i) {
                ProgramTemplate programTemplate = programTemplates[i];
                packageTypesList.add(this.translateProgramTemplate(programTemplate));
            }
        }
        return packageTypesList;
    }

    public PackageType getPackageType(String id) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ProgramTemplate programTemplate;
        try {
            programTemplate = WSLocator.getzBandInterface(this.username).getProgramTemplate(id);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        PackageType pkgType = this.translateProgramTemplate(programTemplate);
        return pkgType;
    }

    public void addPackageType(PackageType packageType, boolean editPkgType) throws WSDuplicateException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"addPackageType() start:");
        ProgramTemplate programTemplate = this.translatePackageType(packageType, editPkgType);
        try {
            WSLocator.getzBandInterface(this.username).createProgramTemplate(programTemplate);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (InvalidMetadataException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("addPackageType() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void updatePackageType(PackageType packageType, boolean editPkgType) throws WSDuplicateException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ProgramTemplate programTemplate = this.translatePackageType(packageType, editPkgType);
        try {
            WSLocator.getzBandInterface(this.username).setProgramTemplate(programTemplate);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (InvalidMetadataException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private void deletePackageType(String packageTypeId) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deletePackageType() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteProgramTemplate(packageTypeId);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)(" : deleted package type with packagetype id [" + packageTypeId + "] by user [" + this.username + "]"));
        log.debug((Object)("deleteMulticastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void deletePackageTypes(ArrayList<String> packageTypeList) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (packageTypeList != null) {
            for (String pTypeId : packageTypeList) {
                this.deletePackageType(pTypeId);
            }
        }
    }

    public void archivePackage(String packageid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"archivePackage() start:");
        try {
            WSLocator.getzBandInterface(this.username).archiveProgram(packageid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("archivePackage() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)(" : archived package [" + packageid + "] by user [" + this.username + "]"));
    }

    public void reprocessPackage(String packageid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"reprocessPackage() start:");
        try {
            WSLocator.getzBandInterface(this.username).archiveProgram(packageid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("reprocessPackage() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)(" : reprocessed package [" + packageid + "] by user [" + this.username + "]"));
    }

    public UnicastTargetResult getUnicastTargets(UnicastTargetFilter unicastTargetFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getUnicastTargets() start:");
        UnicastTargetResult result = new UnicastTargetResult();
        ArrayList<UnicastTarget> unicastTargetsList = new ArrayList<UnicastTarget>();
        LongHolder count = new LongHolder(0L);
        UCTargetFilter ucTargetFilter = this.translateUnicastTargetFilter(unicastTargetFilter);
        UCTargetArrayHolder ucTargetArrayHolder = new UCTargetArrayHolder();
        try {
            WSLocator.getzBandInterface(this.username).getUCTargets(ucTargetFilter, ucTargetArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        UCTarget[] targets = ucTargetArrayHolder.value;
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                UCTarget target = targets[i];
                if (target == null) continue;
                unicastTargetsList.add(this.translateUnicastTarget(target));
            }
        }
        result = new UnicastTargetResult(unicastTargetsList, new Long(count.value));
        log.debug((Object)("getUnicastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    private UnicastTarget translateUnicastTarget(UCTarget target) {
        UnicastTarget unicastTarget = new UnicastTarget();
        unicastTarget.setCatchergroupId(target.getClientgroupid());
        unicastTarget.setCatcherGroupName(target.getClientgroupname());
        unicastTarget.setServiceName(target.getServicename());
        if (target.getClientgrouptype().equals(ClientGroupTypeEnum.Individual)) {
            unicastTarget.setCatcherGroupType(CatcherGroupTypeEnum.Individual);
        } else if (target.getClientgrouptype().equals(ClientGroupTypeEnum.Normal)) {
            unicastTarget.setCatcherGroupType(CatcherGroupTypeEnum.Normal);
        } else if (target.getClientgrouptype().equals(ClientGroupTypeEnum.Special)) {
            unicastTarget.setCatcherGroupType(CatcherGroupTypeEnum.Special);
        }
        return unicastTarget;
    }

    private UCTarget translateUnicastTarget(String pitchId, UnicastTarget unicastTarget) {
        UCTarget target = new UCTarget();
        target.setJobid(pitchId);
        target.setClientgroupid(unicastTarget.getCatchergroupId());
        return target;
    }

    private void addUnicastTarget(String pitchId, UnicastTarget unicastTarget) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"addUnicastTarget() start:");
        UCTarget target = this.translateUnicastTarget(pitchId, unicastTarget);
        try {
            WSLocator.getzBandInterface(this.username).createUCTarget(target);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("addUnicastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void addUnicastTargets(String pitchId, ArrayList<UnicastTarget> unicastTargets) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (unicastTargets != null) {
            for (UnicastTarget unicastTarget : unicastTargets) {
                this.addUnicastTarget(pitchId, unicastTarget);
            }
        }
    }

    private void deleteUnicastTarget(String pitchid, String catcherGroupId) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteUnicastTarget() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteUCTarget(pitchid, catcherGroupId);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)(" : deleted Unicast target with pitch id [" + pitchid + "] by user [" + this.username + "]"));
        log.debug((Object)("deleteUnicastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void deleteUnicastTargets(String pitchId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (catcherGroupIds != null) {
            for (String catcherGroupId : catcherGroupIds) {
                this.deleteUnicastTarget(pitchId, catcherGroupId);
            }
        }
    }

    public MulticastTargetResult getMutlicastTargets(MulticastTargetFilter multicastTargetFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getMulticastTargets() start:");
        MulticastTargetResult result = new MulticastTargetResult();
        ArrayList<MulticastTarget> multicastTargetsList = new ArrayList<MulticastTarget>();
        LongHolder count = new LongHolder(0L);
        MCTargetFilter mcTargetFilter = this.translateMulticastTargetFilter(multicastTargetFilter);
        MCTargetArrayHolder mcTargetArrayHolder = new MCTargetArrayHolder();
        try {
            WSLocator.getzBandInterface(this.username).getMCTargets(mcTargetFilter, mcTargetArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        MCTarget[] targets = mcTargetArrayHolder.value;
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                MCTarget target = targets[i];
                if (target == null) continue;
                multicastTargetsList.add(this.translateMulticastTarget(target));
            }
        }
        result = new MulticastTargetResult(multicastTargetsList, new Long(count.value));
        log.debug((Object)("getMulticastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    private MulticastTarget translateMulticastTarget(MCTarget target) {
        MulticastTarget multicastTarget = new MulticastTarget();
        multicastTarget.setCatchergroupId(target.getClientgroupid());
        multicastTarget.setCatcherGroupName(target.getClientgroupname());
        multicastTarget.setServiceName(target.getServicename());
        if (target.getClientgrouptype().equals(ClientGroupTypeEnum.Individual)) {
            multicastTarget.setCatcherGroupType(CatcherGroupTypeEnum.Individual);
        } else if (target.getClientgrouptype().equals(ClientGroupTypeEnum.Normal)) {
            multicastTarget.setCatcherGroupType(CatcherGroupTypeEnum.Normal);
        } else if (target.getClientgrouptype().equals(ClientGroupTypeEnum.Special)) {
            multicastTarget.setCatcherGroupType(CatcherGroupTypeEnum.Special);
        }
        return multicastTarget;
    }

    private MCTarget translateMulticastTarget(String packageId, MulticastTarget multicastTarget) {
        MCTarget target = new MCTarget();
        target.setProgramid(packageId);
        target.setClientgroupid(multicastTarget.getCatchergroupId());
        return target;
    }

    private void addMulticastTarget(String packageId, MulticastTarget pTarget) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"addPackageTarget() start:");
        MCTarget target = this.translateMulticastTarget(packageId, pTarget);
        try {
            WSLocator.getzBandInterface(this.username).createMCTarget(target);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("addMulticastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void addMulticastTargets(String packageId, ArrayList<MulticastTarget> multicastTargets) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (multicastTargets != null) {
            for (MulticastTarget multicastTarget : multicastTargets) {
                this.addMulticastTarget(packageId, multicastTarget);
            }
        }
    }

    private void deleteMulticastTarget(String packageid, String catcherGroupId) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteMulticastTarget() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteMCTarget(packageid, catcherGroupId);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)(" : deleted package target with package id [" + packageid + "] by user [" + this.username + "]"));
        log.debug((Object)("deleteMulticastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void deleteMulticastTargets(String packageId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (catcherGroupIds != null) {
            for (String catcherGroupId : catcherGroupIds) {
                this.deleteMulticastTarget(packageId, catcherGroupId);
            }
        }
    }

    public void expandTargetCatcherGroup(String catcherGroupId, String packageId) throws WSInvalidFilterException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSPermissionException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"expandTargetCatcherGroup() start:");
        CatcherFilter catcherInCGFilter = new CatcherFilter();
        ArrayList<FilterProperty> catcherfilterPropertylist = new ArrayList<FilterProperty>();
        catcherfilterPropertylist.add(new FilterProperty(CatcherFilterByEnum.CatcherGroupId.getValue(), catcherGroupId));
        catcherfilterPropertylist.add(new FilterProperty(CatcherFilterByEnum.Enabled.getValue(), "true"));
        catcherInCGFilter.setFilterPropertyList(catcherfilterPropertylist);
        CatchersResult cResult = DeviceManager.getInstance(this.username).getCatchers(catcherInCGFilter);
        long totalsize = cResult.getTotalCount();
        ArrayList<CatcherValues> filteredCatchers = cResult.getCatcherValuesList();
        for (CatcherValues catcherGroupValues : filteredCatchers) {
            MulticastTarget pTarget = null;
            pTarget = new MulticastTarget();
            pTarget.setCatchergroupId(catcherGroupValues.getId());
            pTarget.setCatcherGroupName(catcherGroupValues.getName());
            pTarget.setServiceName(catcherGroupValues.getServiceid());
            this.addMulticastTarget(packageId, pTarget);
        }
        this.deleteMulticastTarget(packageId, catcherGroupId);
        log.debug((Object)("expandTargetCatcherGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public void expandUnicastTargetCatcherGrp(String catcherGroupId, String pitchId) throws WSInvalidFilterException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSPermissionException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"expandTargetCatcherGroup() start:");
        CatcherFilter catcherInCGFilter = new CatcherFilter();
        ArrayList<FilterProperty> catcherfilterPropertylist = new ArrayList<FilterProperty>();
        catcherfilterPropertylist.add(new FilterProperty(CatcherFilterByEnum.CatcherGroupId.getValue(), catcherGroupId));
        catcherfilterPropertylist.add(new FilterProperty(CatcherFilterByEnum.Enabled.getValue(), "true"));
        catcherInCGFilter.setFilterPropertyList(catcherfilterPropertylist);
        CatchersResult cResult = DeviceManager.getInstance(this.username).getCatchers(catcherInCGFilter);
        long totalsize = cResult.getTotalCount();
        ArrayList<CatcherValues> filteredCatchers = cResult.getCatcherValuesList();
        for (CatcherValues catcherGroupValues : filteredCatchers) {
            UnicastTarget pTarget = null;
            pTarget = new UnicastTarget();
            pTarget.setCatchergroupId(catcherGroupValues.getId());
            pTarget.setCatcherGroupName(catcherGroupValues.getName());
            pTarget.setServiceName(catcherGroupValues.getServiceid());
            this.addUnicastTarget(pitchId, pTarget);
        }
        this.deleteUnicastTarget(pitchId, catcherGroupId);
        log.debug((Object)("expandTargetCatcherGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }
}

