/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.DashboardManager;

import com.ttv.manager.Dashboard.DashboardQueueValues;
import com.ttv.manager.Dashboard.DashboardStatusEnum;
import com.ttv.manager.Dashboard.NotificationValues;
import com.ttv.manager.Dashboard.NotificationsResult;
import com.ttv.manager.Dashboard.SystemStatusValues;
import com.ttv.manager.Dashboard.UserTaskValues;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.JobsPerChannel;
import com.ttv.zBandInterface.Notification;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.StatusEnum;
import com.ttv.zBandInterface.holders.JobsPerChannelArrayHolder;
import com.ttv.zBandInterface.holders.StatusEnumHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.log4j.Category;

public class DashboardManager {
    private static HashMap<String, DashboardManager> ourInstances = new HashMap();
    private static final Category log = Category.getInstance(DashboardManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private String username = null;

    public static synchronized DashboardManager getInstance(String username) {
        DashboardManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new DashboardManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private DashboardManager(String username) {
        this.username = username;
    }

    public SystemStatusValues getSystemStatus() throws WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getSystemStatus() start:");
        StatusEnumHolder system = new StatusEnumHolder();
        StringHolder systemText = new StringHolder();
        StatusEnumHolder redundancy = new StatusEnumHolder();
        StringHolder redundancyText = new StringHolder();
        FloatHolder dPercentfree = new FloatHolder();
        LongHolder dBytesfree = new LongHolder();
        IntHolder pEncrypted = new IntHolder();
        IntHolder pEncrypting = new IntHolder();
        IntHolder pTobeencrypted = new IntHolder();
        IntHolder cActive = new IntHolder();
        IntHolder cActiveNomc = new IntHolder();
        IntHolder cInactive = new IntHolder();
        IntHolder cLowdisk = new IntHolder();
        FloatHolder rPercent = new FloatHolder();
        FloatHolder jPercentfailed = new FloatHolder();
        try {
            WSLocator.getzBandInterface(this.username).getSystemStatus(system, systemText, redundancy, redundancyText, dPercentfree, dBytesfree, pEncrypted, pEncrypting, pTobeencrypted, cActive, cActiveNomc, cInactive, cLowdisk, rPercent, jPercentfailed);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the SystemStatusValues");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the SystemStatusValues");
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the SystemStatusValues");
        }
        SystemStatusValues systemStatus = this.translateSystemStatusValues(system, systemText, redundancy, redundancyText, dPercentfree, dBytesfree, pEncrypted, pEncrypting, pTobeencrypted, cActive, cActiveNomc, cInactive, cLowdisk, rPercent, jPercentfailed);
        log.debug((Object)("getSystemStatus() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return systemStatus;
    }

    private SystemStatusValues translateSystemStatusValues(StatusEnumHolder system, StringHolder systemText, StatusEnumHolder redundancy, StringHolder redundancyText, FloatHolder percentfree, LongHolder bytesfree, IntHolder encrypted, IntHolder encrypting, IntHolder tobeencrypted, IntHolder active, IntHolder activeNomc, IntHolder inactive, IntHolder lowdisk, FloatHolder percent, FloatHolder percentfailed) {
        SystemStatusValues systemStatus = new SystemStatusValues();
        if (system.value.equals(StatusEnum.None)) {
            systemStatus.setPitchingStatus(DashboardStatusEnum.None);
        } else if (system.value.equals(StatusEnum.OK)) {
            systemStatus.setPitchingStatus(DashboardStatusEnum.OK);
        } else if (system.value.equals(StatusEnum.Warning)) {
            systemStatus.setPitchingStatus(DashboardStatusEnum.Warning);
        } else if (system.value.equals(StatusEnum.Alert)) {
            systemStatus.setPitchingStatus(DashboardStatusEnum.Alert);
        }
        systemStatus.setPitchingStatusDescription(systemText.value);
        if (redundancy.value.equals(StatusEnum.None)) {
            systemStatus.setPitcherHAStatus(DashboardStatusEnum.None);
        } else if (redundancy.value.equals(StatusEnum.OK)) {
            systemStatus.setPitcherHAStatus(DashboardStatusEnum.OK);
        } else if (redundancy.value.equals(StatusEnum.Warning)) {
            systemStatus.setPitcherHAStatus(DashboardStatusEnum.Warning);
        } else if (redundancy.value.equals(StatusEnum.Alert)) {
            systemStatus.setPitcherHAStatus(DashboardStatusEnum.Alert);
        }
        systemStatus.setPitcherHAStatusDescription(redundancyText.value);
        systemStatus.setPercentSpaceFreeOnPitcher(Float.valueOf(percentfree.value));
        systemStatus.setBytesSpaceFreeOnPitcher(bytesfree.value);
        systemStatus.setPackageEncrypted(encrypted.value);
        systemStatus.setPackageEncrypting(encrypting.value);
        systemStatus.setPackageToBeEncrypted(tobeencrypted.value);
        systemStatus.setActiveCatcher(active.value);
        systemStatus.setNoMulticastCatcher(activeNomc.value);
        systemStatus.setInActiveCatcher(inactive.value);
        systemStatus.setLowDiskCatcher(lowdisk.value);
        systemStatus.setRepairPercent(Float.valueOf(percent.value));
        systemStatus.setPercentPitchedFailed(Float.valueOf(percentfailed.value));
        return systemStatus;
    }

    public NotificationsResult getSystemNotifications() throws WSDatabaseException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getSystemNotifications() start:");
        NotificationsResult result = new NotificationsResult();
        Notification[] notifications = null;
        try {
            notifications = WSLocator.getzBandInterface(this.username).getNotifications();
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the system notification values");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the system notification values");
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the system notification values");
        }
        ArrayList<NotificationValues> notificationValuesList = new ArrayList<NotificationValues>();
        if (notifications != null) {
            for (int i = 0; i < notifications.length; ++i) {
                Notification notification = notifications[i];
                if (notification == null) continue;
                NotificationValues notificationValues = this.translateNotification(notification);
                notificationValuesList.add(notificationValues);
            }
        }
        result.setNotificationValuesList(notificationValuesList);
        log.debug((Object)("getSystemNotifications() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    private NotificationValues translateNotification(Notification notification) {
        NotificationValues nValues = new NotificationValues();
        nValues.setHostname(notification.getHostname());
        nValues.setId(notification.getId());
        nValues.setLevel(notification.getLevel());
        nValues.setText(notification.getText());
        nValues.setTime(notification.getTime());
        return nValues;
    }

    public Boolean deleteNotification(Integer id) throws WSDatabaseException, WSConnectException, WSInvalidValueException, WSPermissionException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteNotification() start:");
        Boolean notificationDeleted = false;
        try {
            notificationDeleted = WSLocator.getzBandInterface(this.username).deleteNotification(id);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error deleting the system notification values");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error deleting the system notification values");
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error deleting the system notification values");
        }
        log.debug((Object)("deleteNotification() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return notificationDeleted;
    }

    public UserTaskValues getUserTasks() throws WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getUserTasks() start:");
        IntHolder unapprovedCatchers = new IntHolder();
        IntHolder stagedPitch = new IntHolder();
        IntHolder failedPitch = new IntHolder();
        JobsPerChannelArrayHolder queue = new JobsPerChannelArrayHolder();
        try {
            WSLocator.getzBandInterface(this.username).getUserTasks(unapprovedCatchers, stagedPitch, failedPitch, queue);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the user task values");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the user task values");
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the user task values");
        }
        UserTaskValues userTaskValues = this.translateUserTaskValues(unapprovedCatchers, stagedPitch, failedPitch, queue);
        log.debug((Object)("getUserTasks() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return userTaskValues;
    }

    private UserTaskValues translateUserTaskValues(IntHolder unapprovedCatchers, IntHolder stagedPitch, IntHolder failedPitch, JobsPerChannelArrayHolder queue) {
        UserTaskValues userTask = new UserTaskValues();
        log.debug((Object)"Entering translateUserTaskValues");
        userTask.setUnApprovedCatchers(unapprovedCatchers.value);
        userTask.setStagedPitch(stagedPitch.value);
        userTask.setFailedPitch(failedPitch.value);
        JobsPerChannel[] jobs = queue.value;
        ArrayList<DashboardQueueValues> dQueueValueList = new ArrayList<DashboardQueueValues>();
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                JobsPerChannel jobsPerChannel = jobs[i];
                if (jobsPerChannel == null) continue;
                DashboardQueueValues dQueueValue = new DashboardQueueValues();
                dQueueValue.setChannelid(jobsPerChannel.getChannelid());
                dQueueValue.setChannelname(jobsPerChannel.getChannelname());
                dQueueValue.setJobcount(jobsPerChannel.getJobcount());
                dQueueValueList.add(dQueueValue);
            }
        }
        userTask.setQueueValuesList(dQueueValueList);
        log.debug((Object)"Exiting translateUserTaskValues");
        return userTask;
    }
}

