/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.ScheduleManager;

import com.ttv.manager.CatcherGroup.CatcherGroupValues;
import com.ttv.manager.ConfigurationManager.ConfigurationManager;
import com.ttv.manager.ContentManager.ContentManager;
import com.ttv.manager.DeviceManager.DeviceManager;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Metadata.MetadataEnum;
import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.Package.PackageValues;
import com.ttv.manager.Pitch.PitchFilter;
import com.ttv.manager.Pitch.PitchFilterByEnum;
import com.ttv.manager.Pitch.PitchResult;
import com.ttv.manager.Pitch.PitchSortByEnum;
import com.ttv.manager.Pitch.PitchStatusEnum;
import com.ttv.manager.Pitch.PitchValues;
import com.ttv.manager.Pitch.ReconcilePitchsDetails;
import com.ttv.manager.Pitch.ReconcilePitchsStatusEnum;
import com.ttv.manager.Queue.QueueTypeEnum;
import com.ttv.manager.QueueManager.QueueManager;
import com.ttv.manager.Schedule.ScheduleByEnum;
import com.ttv.manager.Schedule.ScheduleCatcherGroups;
import com.ttv.manager.Schedule.SchedulePackages;
import com.ttv.manager.StagedPitch.StagedPitchValues;
import com.ttv.manager.StagedPitch.StagedPitchsResult;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSContentException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidMetadataException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSLinkObjectException;
import com.ttv.manager.WSException.WSObjectStateException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.WSException.WSValueNullException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.FilterProperty;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.ChannelTypeEnum;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidMetadataException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.Job;
import com.ttv.zBandInterface.JobFilter;
import com.ttv.zBandInterface.JobPriorityEnum;
import com.ttv.zBandInterface.JobSortByEnum;
import com.ttv.zBandInterface.JobStatusEnum;
import com.ttv.zBandInterface.LinkObjectException;
import com.ttv.zBandInterface.MCTarget;
import com.ttv.zBandInterface.MCTargetFilter;
import com.ttv.zBandInterface.MCTargetFilterByEnum;
import com.ttv.zBandInterface.Metadata;
import com.ttv.zBandInterface.ObjectStateException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.ReconcileJobsDetails;
import com.ttv.zBandInterface.ReconcileJobsStatusEnum;
import com.ttv.zBandInterface.UCTarget;
import com.ttv.zBandInterface.UCTargetFilter;
import com.ttv.zBandInterface.UCTargetFilterByEnum;
import com.ttv.zBandInterface.holders.JobArrayHolder;
import com.ttv.zBandInterface.holders.MCTargetArrayHolder;
import com.ttv.zBandInterface.holders.UCTargetArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleManager {
    private static final Category log = Category.getInstance(ScheduleManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, ScheduleManager> ourInstances = new HashMap();
    private String username = null;

    public static synchronized ScheduleManager getInstance(String username) {
        ScheduleManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new ScheduleManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private ScheduleManager(String username) {
        this.username = username;
    }

    public void reconcileTarget(ArrayList<SchedulePackages> packagesList, ArrayList<ScheduleCatcherGroups> catcherGroupsList, ScheduleByEnum scheduleBy, String scheduleByValue, String useSameJobId) throws WSValueNullException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException, WSLinkObjectException, WSPermissionException, WSInvalidValueException, WSObjectStateException, WSInvalidMetadataException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"target() start:");
        if (packagesList == null || catcherGroupsList != null && catcherGroupsList.size() == 0) {
            log.error((Object)"Either packages and/or catchers are not selected");
            throw new WSValueNullException("Either packages and/or catchers are not selected");
        }
        for (SchedulePackages selectedpackage : packagesList) {
            ExceptionManager emgr;
            try {
                Job currentJob = WSLocator.getzBandInterface(this.username).getJob(useSameJobId);
                Calendar startTime = this.getPitchStartTime(scheduleBy, scheduleByValue);
                currentJob.setStarttime(startTime);
                Metadata[] metadata = new Metadata[1];
                log.debug((Object)("METADATA ENUM = " + MetadataEnum.MP_RePitch.getValue()));
                metadata[0] = new Metadata(MetadataEnum.MP_RePitch.getValue(), "T");
                currentJob.setMetadata(metadata);
                WSLocator.getzBandInterface(this.username).setJob(currentJob);
            }
            catch (ObjectStateException e1) {
                emgr = ExceptionManager.getInstance(this.username);
                throw (WSObjectStateException)emgr.TranslateException(e1);
            }
            catch (InvalidMetadataException e1) {
                emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidMetadataException)emgr.TranslateException(e1);
            }
            catch (PermissionException e1) {
                emgr = ExceptionManager.getInstance(this.username);
                throw (WSPermissionException)emgr.TranslateException(e1);
            }
            catch (DatabaseException e1) {
                emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e1);
            }
            catch (InvalidValueException e1) {
                emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e1);
            }
            catch (RemoteException e1) {
                audit.error((Object)("Exception is:" + e1), (Throwable)e1);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
            for (ScheduleCatcherGroups catchergroup : catcherGroupsList) {
                MCTarget target = new MCTarget(selectedpackage.getId(), catchergroup.getId(), null, null, null);
                try {
                    WSLocator.getzBandInterface(this.username).createMCTarget(target);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr2 = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr2.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr3 = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr3.TranslateException(e);
                }
                catch (LinkObjectException e) {
                    ExceptionManager emgr4 = ExceptionManager.getInstance(this.username);
                    throw (WSLinkObjectException)emgr4.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr5 = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr5.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
            }
        }
        log.debug((Object)("target() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Targeted packages count [" + packagesList.size() + "] to catchers/groups count [" + catcherGroupsList.size() + "] by user [" + this.username + "]"));
    }

    public void multicastTarget(ArrayList<SchedulePackages> packagesList, ArrayList<ScheduleCatcherGroups> catcherGroupsList) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"multicast target() start:");
        if (packagesList == null || catcherGroupsList != null && catcherGroupsList.size() == 0) {
            log.error((Object)"Either packages and/or catchers are not selected");
            throw new WSValueNullException("Either packages and/or catchers are not selected");
        }
        for (SchedulePackages selectedpackage : packagesList) {
            for (ScheduleCatcherGroups catchergroup : catcherGroupsList) {
                MCTarget target = new MCTarget(selectedpackage.getId(), catchergroup.getId(), null, null, null);
                try {
                    WSLocator.getzBandInterface(this.username).createMCTarget(target);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (LinkObjectException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSLinkObjectException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
            }
        }
        log.debug((Object)("multicastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Targeted packages count [" + packagesList.size() + "] to catchers/groups count [" + catcherGroupsList.size() + "] by user [" + this.username + "]"));
    }

    public void unicastTarget(ArrayList<PitchValues> pitchList, ArrayList<ScheduleCatcherGroups> catcherGroupsList) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"unicastTarget() start:");
        if (pitchList == null || catcherGroupsList != null && catcherGroupsList.size() == 0) {
            log.error((Object)"Either packages and/or catchers are not selected");
            throw new WSValueNullException("Either packages and/or catchers are not selected");
        }
        for (PitchValues selectedPitch : pitchList) {
            for (ScheduleCatcherGroups catchergroup : catcherGroupsList) {
                UCTarget target = new UCTarget(selectedPitch.getId(), catchergroup.getId(), null, null, null);
                try {
                    WSLocator.getzBandInterface(this.username).createUCTarget(target);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (LinkObjectException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSLinkObjectException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
            }
        }
        log.debug((Object)("multicastTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Targeted packages count [" + pitchList.size() + "] to catchers/groups count [" + catcherGroupsList.size() + "] by user [" + this.username + "]"));
    }

    public ArrayList<String> scheduleForWebAPI(ArrayList<String> packageIdList, ArrayList<String> catcherGroupIdList, ScheduleByEnum scheduleBy, String scheduleByValue, ArrayList<String> queueList, boolean pitchviaunicast) throws WSDatabaseException, WSInvalidMetadataException, WSValueNullException, WSPermissionException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"scheduleThroughWebAPI() start:");
        if (packageIdList == null || catcherGroupIdList == null) {
            log.error((Object)"Either package and/or catcher list is null");
            log.debug((Object)("scheduleThroughWebAPI() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            throw new WSValueNullException("Either package and/or catcher list is null");
        }
        if (packageIdList.isEmpty() || catcherGroupIdList.isEmpty()) {
            log.error((Object)"Either package and/or catcher list is empty");
            log.debug((Object)("scheduleThroughWebAPI() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            throw new WSValueNullException("Either package and/or catcher list is empty");
        }
        Job job = new Job();
        job.setProgramid("");
        Calendar startTime = Calendar.getInstance();
        if (scheduleBy.equals(ScheduleByEnum.TopOfQueue)) {
            startTime.setTimeInMillis(0L);
        } else if (scheduleBy.equals(ScheduleByEnum.DateTime)) {
            Long millis = new Long(scheduleByValue);
            startTime.setTimeInMillis(millis);
        } else if (scheduleBy.equals(ScheduleByEnum.ScheduleBefore)) {
            Job beforeThisJob;
            String pitchBeforeId = scheduleByValue;
            try {
                beforeThisJob = WSLocator.getzBandInterface(this.username).getJob(pitchBeforeId);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
            long beforeThisTime = beforeThisJob.getNexttime().getTimeInMillis();
            startTime.setTimeInMillis(beforeThisTime - 1000L);
        } else if (scheduleBy.equals(ScheduleByEnum.ScheduleAfter)) {
            Job afterThisJob;
            String pitchAfterId = scheduleByValue;
            try {
                afterThisJob = WSLocator.getzBandInterface(this.username).getJob(pitchAfterId);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
            long afterThisTime = afterThisJob.getNexttime().getTimeInMillis();
            startTime.setTimeInMillis(afterThisTime + 1000L);
        } else {
            throw new WSInvalidValueException("Invalid value for parameter scheduleby");
        }
        job.setStarttime(startTime);
        job.setNexttime(startTime);
        job.setPriority(JobPriorityEnum.Normal);
        job.setBandwidth(90L);
        job.setExpanding(true);
        job.setProgramname("");
        job.setChannelname("");
        job.setChannelid("");
        if (pitchviaunicast) {
            job.setType(ChannelTypeEnum.UCAST);
        } else {
            job.setType(ChannelTypeEnum.MCAST);
        }
        String[] channelarray = null;
        if (queueList != null) {
            if (!queueList.isEmpty()) {
                channelarray = new String[queueList.size()];
                for (int i = 0; i < queueList.size(); ++i) {
                    channelarray[i] = queueList.get(i);
                }
            } else {
                log.warn((Object)"Queue is Empty");
            }
        } else {
            log.warn((Object)"Queue is null");
        }
        String[] packageIdarray = packageIdList.toArray(new String[packageIdList.size()]);
        String[] catchergroupIdarray = catcherGroupIdList.toArray(new String[catcherGroupIdList.size()]);
        try {
            String[] pitchids = WSLocator.getzBandInterface(this.username).createJob(job, packageIdarray, catchergroupIdarray, channelarray);
            ArrayList<String> pitchIdsList = new ArrayList<String>();
            for (String pitchId : pitchids) {
                pitchIdsList.add(pitchId);
            }
            ArrayList<String> arrayList = pitchIdsList;
            return arrayList;
        }
        catch (InvalidMetadataException e) {
            ExceptionManager exceptionManager = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidMetadataException");
            throw (WSInvalidMetadataException)exceptionManager.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager exceptionManager = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidMetadataException");
            throw (WSPermissionException)exceptionManager.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager exceptionManager = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidMetadataException");
            throw (WSDatabaseException)exceptionManager.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager exceptionManager = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidMetadataException");
            throw (WSInvalidValueException)exceptionManager.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("scheduleThroughWebAPI() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Scheduled packages count [" + packageIdList.size() + "] to catchers/groups count [" + catcherGroupIdList.size() + "] by user [" + this.username + "]"));
        }
    }

    public ArrayList<String> schedule(ArrayList<SchedulePackages> packagesList, ArrayList<ScheduleCatcherGroups> catcherGroupsList, ScheduleByEnum scheduleBy, String scheduleByValue, ArrayList<String> queueList, boolean unicastType, boolean staged) throws WSValueNullException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSInvalidFilterValueException {
        String useSamePitchId = null;
        log.debug((Object)"scheduling with null jobid");
        return this.schedule(packagesList, catcherGroupsList, scheduleBy, scheduleByValue, useSamePitchId, queueList, unicastType, staged);
    }

    public ArrayList<String> schedule(ArrayList<SchedulePackages> packagesList, ArrayList<ScheduleCatcherGroups> catcherGroupsList, ScheduleByEnum scheduleBy, String scheduleByValue, String useSameJobId, ArrayList<String> queueList, boolean unicastType, boolean staged) throws WSValueNullException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSInvalidFilterValueException {
        ExceptionManager emgr;
        Calendar startTime;
        long begin = System.currentTimeMillis();
        log.debug((Object)"schedule() start:");
        Job job = new Job();
        if (packagesList == null || catcherGroupsList != null && catcherGroupsList.size() == 0) {
            throw new WSValueNullException("Either packages and/or catchers are not selected");
        }
        String[] pitchids = new String[packagesList.size()];
        String[] repitchids = new String[packagesList.size()];
        ArrayList<String> pitchIdsList = new ArrayList<String>();
        ArrayList<String> packageIdList = new ArrayList<String>();
        ArrayList<String> rePitchIdList = new ArrayList<String>();
        String[] catcherGrpIdList = new String[catcherGroupsList.size()];
        int k = 0;
        for (ScheduleCatcherGroups catchergroup : catcherGroupsList) {
            catcherGrpIdList[k] = catchergroup.getId();
            log.debug((Object)("Catcher Group Id = " + catcherGrpIdList[k]));
            ++k;
        }
        int j = 0;
        int i = 0;
        for (SchedulePackages selectedpackage : packagesList) {
            String repitchCatcherIds = selectedpackage.getRepitchCatcherIds();
            if (repitchCatcherIds != null && repitchCatcherIds.trim().length() > 0) {
                Metadata[] metadata = new Metadata[]{new Metadata(MetadataEnum.MP_ReReceive.getValue(), selectedpackage.getRepitchCatcherIds()), new Metadata(MetadataEnum.MP_RePitch.getValue(), "T")};
                job.setMetadata(metadata);
                log.debug((Object)("RepitchId List = " + selectedpackage.getId()));
                rePitchIdList.add(selectedpackage.getId());
                ++j;
                continue;
            }
            log.debug((Object)("Pitch ID List = " + selectedpackage.getId()));
            packageIdList.add(selectedpackage.getId());
            ++i;
        }
        job.setProgramid("");
        if (scheduleBy.equals(ScheduleByEnum.BottomOfQueue)) {
            log.debug((Object)("Queue Id = " + queueList.get(0)));
            startTime = this.scheduleBottomOfQueue(queueList.get(0));
        } else {
            startTime = this.getPitchStartTime(scheduleBy, scheduleByValue);
        }
        log.debug((Object)("Pitch start Time = " + startTime.getTimeInMillis()));
        job.setStarttime(startTime);
        job.setNexttime(startTime);
        job.setPriority(JobPriorityEnum.Normal);
        job.setBandwidth(90L);
        job.setExpanding(true);
        job.setProgramname("");
        job.setChannelname("");
        job.setChannelid("");
        if (staged) {
            job.setOnhold(true);
            job.setStatus(JobStatusEnum.Staged);
        } else {
            job.setOnhold(false);
            job.setStatus(JobStatusEnum.Waiting);
        }
        if (unicastType) {
            job.setType(ChannelTypeEnum.UCAST);
        } else {
            job.setType(ChannelTypeEnum.MCAST);
        }
        String[] channelarray = null;
        if (queueList != null) {
            log.debug((Object)"Queue Array List is not empty");
            if (!queueList.isEmpty()) {
                channelarray = new String[queueList.size()];
                for (int l = 0; l < queueList.size(); ++l) {
                    channelarray[l] = queueList.get(l);
                }
            } else {
                log.warn((Object)"Queue is Empty");
            }
        } else {
            log.warn((Object)"Queue is null");
        }
        try {
            if (packageIdList.size() > 0) {
                log.debug((Object)("PackageIdList size = " + packageIdList.size()));
                String[] str = packageIdList.toArray(new String[packageIdList.size()]);
                pitchids = WSLocator.getzBandInterface(this.username).createJob(job, str, catcherGrpIdList, channelarray);
                log.debug((Object)("After calling createJob size of pitchids = " + pitchids.length));
            }
            if (rePitchIdList.size() > 0) {
                log.debug((Object)("RePitchId List = " + rePitchIdList.size()));
                String[] str = rePitchIdList.toArray(new String[rePitchIdList.size()]);
                for (int count = 0; count < str.length; ++count) {
                    log.debug((Object)("str[" + count + "] = " + str[count]));
                }
                log.debug((Object)("Catcher Group List Size = " + catcherGrpIdList.length));
                repitchids = WSLocator.getzBandInterface(this.username).createJob(job, str, catcherGrpIdList, channelarray);
            }
            for (String pitchId : pitchids) {
                pitchIdsList.add(pitchId);
            }
            for (String repitchId : repitchids) {
                pitchIdsList.add(repitchId);
            }
        }
        catch (InvalidMetadataException e) {
            emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidMetadataException");
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside PermissionException");
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside DatabaseException");
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidValueException");
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (Exception e) {
            log.debug((Object)("Throwing Exception " + e.getMessage()));
        }
        log.debug((Object)("schedule() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Scheduled packages count [" + packagesList.size() + "] to catchers/groups count [" + catcherGroupsList.size() + "] by user [" + this.username + "]"));
        return pitchIdsList;
    }

    public void scheduleTestPackage(ArrayList<String> catcherIds, ArrayList<String> packageIds, ArrayList<String> queueList) throws WSValueNullException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"scheduleTestPackage() start:");
        Job job = new Job();
        if (catcherIds == null || packageIds == null) {
            throw new WSValueNullException("Either packages and/or catchers are not selected");
        }
        job.setProgramid("");
        Calendar currentStartTime = Calendar.getInstance();
        currentStartTime.setTimeInMillis(currentStartTime.getTimeInMillis() + 1800000L);
        job.setStarttime(currentStartTime);
        job.setNexttime(currentStartTime);
        job.setPriority(JobPriorityEnum.Normal);
        job.setBandwidth(90L);
        job.setExpanding(true);
        job.setProgramname("");
        job.setChannelname("");
        job.setChannelid("");
        job.setType(ChannelTypeEnum.MCAST);
        String[] str = packageIds.toArray(new String[packageIds.size()]);
        for (int count = 0; count < str.length; ++count) {
            log.debug((Object)("str[" + count + "] = " + str[count]));
        }
        String[] CatcherGrpIds = catcherIds.toArray(new String[catcherIds.size()]);
        String[] QueueIds = queueList.toArray(new String[queueList.size()]);
        try {
            WSLocator.getzBandInterface(this.username).createJob(job, str, CatcherGrpIds, QueueIds);
        }
        catch (InvalidMetadataException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidMetadataException");
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside PermissionException");
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside DatabaseException");
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidValueException");
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private Calendar getPitchStartTime(ScheduleByEnum scheduleBy, String scheduleByValue) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ConfigurationManager configMgr = ConfigurationManager.getInstance(this.username);
        String userTimeZone = configMgr.getUserTimeZone();
        GregorianCalendar pitchStartTime = new GregorianCalendar(TimeZone.getTimeZone(userTimeZone));
        if (scheduleBy.equals(ScheduleByEnum.TopOfQueue)) {
            pitchStartTime.setTimeInMillis(0L);
        } else if (!scheduleBy.equals(ScheduleByEnum.BottomOfQueue)) {
            if (scheduleBy.equals(ScheduleByEnum.DateTime)) {
                Long millis = new Long(scheduleByValue);
                pitchStartTime.setTimeInMillis(millis);
            } else if (scheduleBy.equals(ScheduleByEnum.ScheduleBefore)) {
                Job beforeThisJob;
                String pitchBeforeId = scheduleByValue;
                try {
                    beforeThisJob = WSLocator.getzBandInterface(this.username).getJob(pitchBeforeId);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
                Calendar beforeThisDate = beforeThisJob.getNexttime();
                pitchStartTime.setTimeInMillis(beforeThisDate.getTimeInMillis() - 1000L);
            } else if (scheduleBy.equals(ScheduleByEnum.ScheduleAfter)) {
                Job afterThisJob;
                String pitchAfterId = scheduleByValue;
                try {
                    afterThisJob = WSLocator.getzBandInterface(this.username).getJob(pitchAfterId);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
                Calendar afterThisDate = afterThisJob.getNexttime();
                pitchStartTime.setTimeInMillis(afterThisDate.getTimeInMillis() + 1000L);
            }
        }
        return pitchStartTime;
    }

    private SchedulePackages createSchedPackages(PackageValues packageValues) {
        SchedulePackages schedulePackages = new SchedulePackages();
        schedulePackages.setId(packageValues.getId());
        schedulePackages.setName(packageValues.getName());
        return schedulePackages;
    }

    private ArrayList<ScheduleCatcherGroups> createSchedCatcherGroups(ArrayList<CatcherGroupValues> catcherGroupList) {
        ArrayList<ScheduleCatcherGroups> scheduleCatcherGroupsList = new ArrayList<ScheduleCatcherGroups>();
        for (CatcherGroupValues catcherGroupValues : catcherGroupList) {
            ScheduleCatcherGroups scg = new ScheduleCatcherGroups();
            scg.setId(catcherGroupValues.getId());
            scg.setServiceid(catcherGroupValues.getServiceid());
            scheduleCatcherGroupsList.add(scg);
        }
        return scheduleCatcherGroupsList;
    }

    private CatcherGroupValues translateMCTarget(MCTarget target) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        DeviceManager dmgr = DeviceManager.getInstance(this.username);
        return dmgr.getCatcherGroup(target.getClientgroupid());
    }

    private CatcherGroupValues translateUCTarget(UCTarget target) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        DeviceManager dmgr = DeviceManager.getInstance(this.username);
        return dmgr.getCatcherGroup(target.getClientgroupid());
    }

    public StagedPitchsResult getStagedPitchs() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidFilterValueException {
        PitchFilter stagedPitchFilter = new PitchFilter();
        ArrayList<FilterProperty> stagedPitchesFilterPropertylist = new ArrayList<FilterProperty>();
        stagedPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.Status.getValue(), PitchStatusEnum.Staged.getValue()));
        stagedPitchFilter.setFilterPropertyList(stagedPitchesFilterPropertylist);
        stagedPitchFilter.setIndex(new Long(0L));
        return this.getStagedPitchs(stagedPitchFilter);
    }

    public ArrayList<CatcherGroupValues> getCatcherGroupMCTargets(String packageid) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ArrayList<CatcherGroupValues> catcherGroupTargets = new ArrayList<CatcherGroupValues>();
        MCTargetFilter targetFilter = new MCTargetFilter();
        String filter = MCTargetFilterByEnum.ProgramId.getValue() + "=" + packageid;
        targetFilter.setFilter(filter);
        MCTargetArrayHolder targetArrayHolder = new MCTargetArrayHolder();
        LongHolder count = new LongHolder(0L);
        try {
            WSLocator.getzBandInterface(this.username).getMCTargets(targetFilter, targetArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        MCTarget[] targets = targetArrayHolder.value;
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                MCTarget target = targets[i];
                if (target == null) continue;
                catcherGroupTargets.add(this.translateMCTarget(target));
            }
        }
        return catcherGroupTargets;
    }

    public ArrayList<CatcherGroupValues> getCatcherGroupUCTargets(String pitchid) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        ArrayList<CatcherGroupValues> catcherGroupTargets = new ArrayList<CatcherGroupValues>();
        UCTargetFilter targetFilter = new UCTargetFilter();
        String filter = UCTargetFilterByEnum.JobId.getValue() + "=" + pitchid;
        targetFilter.setFilter(filter);
        UCTargetArrayHolder targetArrayHolder = new UCTargetArrayHolder();
        LongHolder count = new LongHolder(0L);
        try {
            WSLocator.getzBandInterface(this.username).getUCTargets(targetFilter, targetArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        UCTarget[] targets = targetArrayHolder.value;
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                UCTarget target = targets[i];
                if (target == null) continue;
                catcherGroupTargets.add(this.translateUCTarget(target));
            }
        }
        return catcherGroupTargets;
    }

    public StagedPitchsResult getStagedPitchs(PitchFilter satgedpitchFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidFilterValueException {
        HashMap<String, StagedPitchValues> map = new HashMap<String, StagedPitchValues>();
        QueueManager qmgr = QueueManager.getInstance(this.username);
        PitchResult result = qmgr.getPitchs(satgedpitchFilter);
        ArrayList<PitchValues> pitchValuesList = result.getPitchValuesList();
        Long totalStagedPitchs = result.getTotalCount();
        for (PitchValues pitchValues : pitchValuesList) {
            StagedPitchValues stagedPitchValues = new StagedPitchValues();
            stagedPitchValues.setPitchValues(pitchValues);
            String pitchId = pitchValues.getId();
            if (pitchValues.getQueueType().equals(QueueTypeEnum.MCAST.getValue())) {
                stagedPitchValues.setCatcherGroupList(this.getCatcherGroupMCTargets(pitchValues.getPackageid()));
            } else {
                stagedPitchValues.setCatcherGroupList(this.getCatcherGroupUCTargets(pitchId));
            }
            map.put(pitchValues.getId(), stagedPitchValues);
        }
        StagedPitchsResult stagedPitchsResult = new StagedPitchsResult(map, totalStagedPitchs);
        return stagedPitchsResult;
    }

    private ScheduleByEnum getScheduleBy(ArrayList<MetadataValues> metadataValuesList) {
        ScheduleByEnum scheduleBy = ScheduleByEnum.BottomOfQueue;
        for (MetadataValues metadataValues : metadataValuesList) {
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleType.getValue())) continue;
            scheduleBy = ScheduleByEnum.fromString(metadataValues.getValue());
            break;
        }
        return scheduleBy;
    }

    private String getScheduleValue(ArrayList<MetadataValues> metadataValuesList) {
        String scheduleValue = "";
        for (MetadataValues metadataValues : metadataValuesList) {
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleValue.getValue())) continue;
            scheduleValue = metadataValues.getValue();
            break;
        }
        return scheduleValue;
    }

    public StagedPitchValues getStagedPitch(String pitchid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSInvalidValueException {
        PitchValues pitchValues = QueueManager.getInstance(this.username).getPitch(pitchid);
        StagedPitchValues stagedPitchValues = new StagedPitchValues();
        stagedPitchValues.setPitchValues(pitchValues);
        if (pitchValues.getQueueType().equals(QueueTypeEnum.MCAST.getValue())) {
            stagedPitchValues.setCatcherGroupList(this.getCatcherGroupMCTargets(pitchValues.getPackageid()));
        } else {
            stagedPitchValues.setCatcherGroupList(this.getCatcherGroupUCTargets(pitchValues.getId()));
        }
        return stagedPitchValues;
    }

    public void approveStagedPitchs(ArrayList<String> pitchIds) throws WSDatabaseException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        long begin = System.currentTimeMillis();
        if (pitchIds != null) {
            for (String pitchId : pitchIds) {
                try {
                    Job job = WSLocator.getzBandInterface(this.username).getJob(pitchId);
                    job.setStatus(JobStatusEnum.Waiting);
                    job.setOnhold(false);
                    WSLocator.getzBandInterface(this.username).setJob(job);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
                finally {
                    log.debug((Object)("getPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
                }
            }
        }
    }

    public void rejectStagedPitchs(ArrayList<String> pitchids) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException {
        if (pitchids != null) {
            for (String pitchid : pitchids) {
                try {
                    WSLocator.getzBandInterface(this.username).deleteJob(pitchid);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    e.printStackTrace();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void unmarkStagedMetadata(PackageValues packageValues) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException {
        ArrayList<MetadataValues> metadataValuesList = packageValues.getmetadataValuesList();
        for (MetadataValues metadataValues : metadataValuesList) {
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_Staged.getValue())) continue;
            metadataValues.setValue("");
            break;
        }
        ContentManager.getInstance(this.username).updatePackage(packageValues);
    }

    public ArrayList<String> schedule(StagedPitchValues stagedPitchValues, ArrayList<String> queueList, boolean unicastType) throws WSValueNullException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSContentException, WSLinkObjectException, WSInternalErrorException, WSObjectStateException {
        String scheduleByDateString = "";
        ArrayList<String> pitchIds = new ArrayList<String>();
        return pitchIds;
    }

    public void removeCatcherGroupsFromPitch(String pitchId, ArrayList<String> catcherGroupIdList) throws WSDatabaseException, WSPermissionException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"removeCatcherGroupsFromPitch() start:");
        try {
            Job job = WSLocator.getzBandInterface(this.username).getJob(pitchId);
            if (job.getType().equals(ChannelTypeEnum.MCAST)) {
                this.deleteMCTargetCatcherGroups(job.getProgramid(), catcherGroupIdList);
            } else if (job.getType().equals(ChannelTypeEnum.UCAST)) {
                this.deleteUCTargetCatcherGroups(job.getId(), catcherGroupIdList);
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)"removeCatcherGroupsFromPitch() end:");
    }

    public void deleteMCTargetCatcherGroups(String packageId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (packageId != null && catcherGroupIds != null) {
            try {
                for (String catcherGroupId : catcherGroupIds) {
                    WSLocator.getzBandInterface(this.username).deleteMCTarget(packageId, catcherGroupId);
                }
            }
            catch (PermissionException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSPermissionException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
        }
    }

    public void deleteUCTargetCatcherGroups(String pitchId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (pitchId != null && catcherGroupIds != null) {
            try {
                for (String catcherGroupId : catcherGroupIds) {
                    WSLocator.getzBandInterface(this.username).deleteUCTarget(pitchId, catcherGroupId);
                }
            }
            catch (PermissionException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSPermissionException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
        }
    }

    public void addCatcherGroupsToPitch(String pitchId, ArrayList<String> catcherGroupIdList) throws WSDatabaseException, WSPermissionException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"addCatcherGroupsToPitch() start:");
        try {
            Job job = WSLocator.getzBandInterface(this.username).getJob(pitchId);
            if (job.getType().equals(ChannelTypeEnum.MCAST)) {
                this.addMCTargetCatcherGroups(job.getProgramid(), catcherGroupIdList);
            } else if (job.getType().equals(ChannelTypeEnum.UCAST)) {
                this.addUCTargetCatcherGroups(job.getId(), catcherGroupIdList);
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)"addCatcherGroupsToPitch() end:");
    }

    public void addMCTargetCatcherGroups(String packageId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"addMCTargetCatcherGroups() start:");
        if (packageId != null && catcherGroupIds != null) {
            for (String catcherGroupId : catcherGroupIds) {
                MCTarget target = new MCTarget();
                target.setClientgroupid(catcherGroupId);
                target.setProgramid(packageId);
                try {
                    WSLocator.getzBandInterface(this.username).createMCTarget(target);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (LinkObjectException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSLinkObjectException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
            }
        }
        log.debug((Object)"addMCTargetCatcherGroups() start:");
    }

    public void addUCTargetCatcherGroups(String pitchId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"addUCTargetCatcherGroups() start:");
        if (pitchId != null && catcherGroupIds != null) {
            for (String catcherGroupId : catcherGroupIds) {
                UCTarget target = new UCTarget();
                target.setClientgroupid(catcherGroupId);
                target.setJobid(pitchId);
                try {
                    WSLocator.getzBandInterface(this.username).createUCTarget(target);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (LinkObjectException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSLinkObjectException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
            }
        }
        log.debug((Object)"addUCTargetCatcherGroups() start:");
    }

    private void editStagedMetadata(PackageValues packageValues, ScheduleByEnum scheduleBy, String scheduleValue) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException {
        ArrayList<MetadataValues> metadataValuesList = packageValues.getmetadataValuesList();
        for (MetadataValues metadataValues : metadataValuesList) {
            if (metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleType.getValue())) {
                metadataValues.setValue(scheduleBy.getValue());
            }
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleValue.getValue())) continue;
            metadataValues.setValue(scheduleValue);
        }
        ContentManager.getInstance(this.username).updatePackage(packageValues);
    }

    public void updateStagedPitchSchedule(String packageid, ScheduleByEnum scheduleBy, String scheduleValue) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException {
        if (packageid != null && scheduleBy != null) {
            PackageValues packageValues = ContentManager.getInstance(this.username).getPackage(packageid);
            this.editStagedMetadata(packageValues, scheduleBy, scheduleValue);
        }
    }

    private ReconcilePitchsDetails translateReconcileJobsDetails(ReconcileJobsDetails reconcileJobsDetails) {
        ReconcilePitchsDetails details = new ReconcilePitchsDetails();
        ArrayList<String> newCatcherNamesList = new ArrayList<String>();
        String[] newClientNames = reconcileJobsDetails.getNewclients();
        if (newClientNames != null) {
            for (int i = 0; i < newClientNames.length; ++i) {
                String newclientname = newClientNames[i];
                if (newclientname == null) continue;
                newCatcherNamesList.add(newclientname);
            }
        }
        details.setNewCatcherNamesList(newCatcherNamesList);
        details.setNewCatcherNamesListSize(newCatcherNamesList.size());
        ArrayList<String> existingCatcherNamesList = new ArrayList<String>();
        String[] existingClientNames = reconcileJobsDetails.getExistingclients();
        if (existingClientNames != null) {
            for (int i = 0; i < existingClientNames.length; ++i) {
                String existingclientname = existingClientNames[i];
                if (existingclientname == null) continue;
                existingCatcherNamesList.add(existingclientname);
            }
        }
        details.setExistingCatcherNamesList(existingCatcherNamesList);
        details.setExistingCatcherNamesListSize(existingCatcherNamesList.size());
        details.setExistingPitchId(reconcileJobsDetails.getExistingjobid());
        details.setExistingPitchTime(reconcileJobsDetails.getExistingjobtime().getTime());
        details.setServiceid(reconcileJobsDetails.getServiceid());
        details.setQueueId(reconcileJobsDetails.getChannelid());
        details.setQueueName(reconcileJobsDetails.getChannelname());
        details.setRepitchCatcherIds(reconcileJobsDetails.getClientids());
        ArrayList<String> catcherGroupIdsList = new ArrayList<String>();
        String[] catcherGroupIds = reconcileJobsDetails.getClientgroupids();
        if (catcherGroupIds != null) {
            for (int i = 0; i < catcherGroupIds.length; ++i) {
                String catcherGroupId = catcherGroupIds[i];
                if (catcherGroupId == null) continue;
                catcherGroupIdsList.add(catcherGroupId);
            }
        }
        details.setCatcherGroupIdsList(catcherGroupIdsList);
        if (reconcileJobsDetails.getStatus().equals(ReconcileJobsStatusEnum.ConflictWithHistory)) {
            details.setStatus(ReconcilePitchsStatusEnum.ConflictWithHistory);
        } else if (reconcileJobsDetails.getStatus().equals(ReconcileJobsStatusEnum.ConflictWithWaiting)) {
            if (newCatcherNamesList.size() > 0) {
                details.setStatus(ReconcilePitchsStatusEnum.ConflictWithWaiting);
            } else {
                details.setStatus(ReconcilePitchsStatusEnum.Denied);
            }
        } else if (reconcileJobsDetails.getStatus().equals(ReconcileJobsStatusEnum.Denied)) {
            details.setStatus(ReconcilePitchsStatusEnum.Denied);
        } else if (reconcileJobsDetails.getStatus().equals(ReconcileJobsStatusEnum.NoConflict)) {
            details.setStatus(ReconcilePitchsStatusEnum.NoConflict);
        }
        return details;
    }

    public ArrayList<ReconcilePitchsDetails> reconcilePitchs(ArrayList<SchedulePackages> packagesList, ArrayList<ScheduleCatcherGroups> cgSelectionList, ScheduleByEnum scheduleBy, String scheduleByValue, ArrayList<String> queueList, boolean unicastType, boolean staged) throws WSValueNullException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSInvalidFilterValueException {
        ArrayList<ReconcilePitchsDetails> reconcilePitchsDetails = new ArrayList<ReconcilePitchsDetails>();
        for (SchedulePackages schedPackage : packagesList) {
            ReconcileJobsDetails[] reconcileJobsDetails;
            String[] catchergroupids = new String[cgSelectionList.size()];
            for (int i = 0; i < cgSelectionList.size(); ++i) {
                ScheduleCatcherGroups scg = cgSelectionList.get(i);
                catchergroupids[i] = new String(scg.getId());
            }
            try {
                reconcileJobsDetails = WSLocator.getzBandInterface(this.username).reconcileJobs(schedPackage.getId(), catchergroupids);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
            if (reconcileJobsDetails == null) continue;
            for (int j = 0; j < reconcileJobsDetails.length; ++j) {
                ReconcileJobsDetails jobDetails = reconcileJobsDetails[j];
                if (jobDetails == null) continue;
                if (jobDetails.getStatus().equals(ReconcileJobsStatusEnum.NoConflict)) {
                    ArrayList<ScheduleCatcherGroups> cgSelectionByService = new ArrayList<ScheduleCatcherGroups>();
                    for (int x = 0; x < cgSelectionList.size(); ++x) {
                        ScheduleCatcherGroups scgTemp = cgSelectionList.get(x);
                        if (!scgTemp.getServiceid().equals(jobDetails.getServiceid())) continue;
                        cgSelectionByService.add(scgTemp);
                    }
                    ArrayList<SchedulePackages> onePackageList = new ArrayList<SchedulePackages>();
                    onePackageList.add(schedPackage);
                    this.schedule(onePackageList, cgSelectionByService, scheduleBy, scheduleByValue, queueList, unicastType, staged);
                    continue;
                }
                ReconcilePitchsDetails pitchDetails = this.translateReconcileJobsDetails(jobDetails);
                pitchDetails.setPackageId(schedPackage.getId());
                pitchDetails.setPackageName(schedPackage.getName());
                pitchDetails.setScheduleBy(scheduleBy);
                pitchDetails.setScheduleValue(scheduleByValue);
                reconcilePitchsDetails.add(pitchDetails);
            }
        }
        return reconcilePitchsDetails;
    }

    private Calendar scheduleBottomOfQueue(String queueId) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSPermissionException {
        long begin = System.currentTimeMillis();
        log.debug((Object)("scheduleBottomOfQueue Start: [t=" + (double)System.currentTimeMillis() / 1000.0 + "]"));
        ConfigurationManager configMgr = ConfigurationManager.getInstance(this.username);
        String userTimeZone = configMgr.getUserTimeZone();
        GregorianCalendar pitchStartTime = new GregorianCalendar(TimeZone.getTimeZone(userTimeZone));
        int bottomQDelay = configMgr.getBottomOfQDelay().intValue();
        PitchFilter pitchFilter = new PitchFilter();
        ArrayList<FilterProperty> pendingPitchesFilterPropertylist = new ArrayList<FilterProperty>();
        String[] selectedstatusList = new String[5];
        selectedstatusList[0] = PitchStatusEnum.Waiting.getValue();
        String statusstring = "";
        for (int i = 0; i < selectedstatusList.length; ++i) {
            statusstring = i == 0 ? selectedstatusList[i] : statusstring + "|" + selectedstatusList[i];
        }
        pendingPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.Status.getValue(), statusstring));
        pendingPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.Queue.getValue(), queueId));
        pitchFilter.setFilterPropertyList(pendingPitchesFilterPropertylist);
        pitchFilter.setAscending(false);
        pitchFilter.setIndex(1L);
        pitchFilter.setLimit(1L);
        JobFilter jobFilter = this.translatePitchFilter(pitchFilter);
        JobArrayHolder jobArrayHolder = new JobArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getJobs(jobFilter, jobArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Job[] jobs = jobArrayHolder.value;
        if (jobs == null) {
            pitchStartTime.setTimeInMillis(0L);
        } else if (jobs.length == 0) {
            pitchStartTime.setTimeInMillis(0L);
        } else {
            Job lastJob = jobs[0];
            pitchStartTime.setTimeInMillis(lastJob.getCompletion().getTimeInMillis() + (long)(bottomQDelay * 1000));
        }
        log.debug((Object)("scheduleBottomOfQueue complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return pitchStartTime;
    }

    private JobFilter translatePitchFilter(PitchFilter pitchFilter) {
        log.debug((Object)"inside translatePitchFilter");
        JobFilter jobFilter = new JobFilter();
        jobFilter.setAscending(pitchFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToJobFilterPropertyList(pitchFilter.getFilterPropertyList());
        jobFilter.setFilter(CommonUtils.serializeFilter(fp));
        jobFilter.setIndex(pitchFilter.getIndex());
        jobFilter.setLimit(ConfigurationManager.getInstance(this.username).getPitchsPerPage());
        if (pitchFilter.getLimit() == null) {
            jobFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        } else {
            jobFilter.setLimit(pitchFilter.getLimit());
        }
        if (pitchFilter.getSortby().equals(PitchSortByEnum.NextTime.getValue())) {
            jobFilter.setSortby(JobSortByEnum.NextTime);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Status.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Status);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Queue.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Channel);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Package.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Program);
        }
        log.debug((Object)"End of translatePitchFilter");
        return jobFilter;
    }
}

