/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.UserAdminManager;

import com.ttv.manager.ConfigurationManager.ConfigurationManager;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.PolicyUser.PolicyUserValues;
import com.ttv.manager.PolicyUser.PolicyUsersResult;
import com.ttv.manager.PolicyUser.RoleValues;
import com.ttv.manager.PolicyUser.UPolicyUserFilter;
import com.ttv.manager.PolicyUser.UPolicyUserFilterByEnum;
import com.ttv.manager.PolicyUser.UPolicyUserSortByEnum;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSDuplicateException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.WSException.WSValueNullException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.FilterProperty;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.DuplicateException;
import com.ttv.zBandInterface.InternalErrorException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.PolicyUser;
import com.ttv.zBandInterface.PolicyUserFilter;
import com.ttv.zBandInterface.PolicyUserSortByEnum;
import com.ttv.zBandInterface.Role;
import com.ttv.zBandInterface.holders.PolicyUserArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAdminManager {
    private static HashMap<String, UserAdminManager> ourInstances = new HashMap();
    private static final Category log = Category.getInstance(UserAdminManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private String username = null;

    public static synchronized UserAdminManager getInstance(String username) {
        UserAdminManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new UserAdminManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private UserAdminManager(String username) {
        this.username = username;
    }

    private PolicyUserValues translatePolicyUser(PolicyUser policyUser) {
        if (policyUser == null) {
            return null;
        }
        ArrayList<RoleValues> roleValuesList = new ArrayList<RoleValues>();
        Role[] roles = policyUser.getRoles();
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                Role role = roles[i];
                if (role == null) continue;
                roleValuesList.add(this.translateRole(role));
            }
        }
        PolicyUserValues policyUserValues = new PolicyUserValues(policyUser.getId(), policyUser.getName(), policyUser.getLogin(), policyUser.getPassword(), policyUser.getPasswordmodifiedtime(), policyUser.getEnabled(), roleValuesList);
        return policyUserValues;
    }

    public boolean changePassword(String oldpassword, String newpassword) throws WSInternalErrorException, WSDatabaseException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        boolean result;
        long begin = System.currentTimeMillis();
        log.debug((Object)"changePassword() start:");
        try {
            result = WSLocator.getzBandInterface(this.username).changePassword(oldpassword, newpassword);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        result = true;
        if (true) {
            WSLocator.changePassword(this.username, newpassword);
        }
        log.debug((Object)("changePassword() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Password changed by [" + this.username + "]"));
        return result;
    }

    private RoleValues translateRole(Role role) {
        RoleValues roleValues = new RoleValues();
        roleValues.setId(role.getId());
        roleValues.setName(role.getName());
        roleValues.setDescription(role.getDescription());
        return roleValues;
    }

    public ArrayList<RoleValues> getRoles() throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException {
        Role[] roles;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getRoles() start:");
        ArrayList<RoleValues> roleValuesList = new ArrayList<RoleValues>();
        try {
            roles = WSLocator.getzBandInterface(this.username).getRoles();
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                Role role = roles[i];
                if (role == null) continue;
                roleValuesList.add(this.translateRole(role));
            }
        }
        log.debug((Object)("getRoles() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return roleValuesList;
    }

    public PolicyUsersResult getPolicyUsers() throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException {
        UPolicyUserFilter upolicyUserFilter = new UPolicyUserFilter();
        upolicyUserFilter.setAscending(new Boolean("true"));
        upolicyUserFilter.setIndex(new Long(0L));
        upolicyUserFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        upolicyUserFilter.setSortby(UPolicyUserSortByEnum.Name);
        return this.getPolicyUsers(upolicyUserFilter);
    }

    private PolicyUserFilter translateUPolicyUserFilter(UPolicyUserFilter upolicyUserFilter) {
        if (upolicyUserFilter == null) {
            return null;
        }
        PolicyUserFilter zpolicyUserFilter = new PolicyUserFilter();
        zpolicyUserFilter.setFilter(CommonUtils.serializeFilter(upolicyUserFilter.getFilter()));
        zpolicyUserFilter.setAscending(upolicyUserFilter.getAscending());
        zpolicyUserFilter.setIndex(upolicyUserFilter.getIndex());
        zpolicyUserFilter.setLimit(upolicyUserFilter.getLimit());
        if (upolicyUserFilter.getSortby().equals(UPolicyUserSortByEnum.Name)) {
            zpolicyUserFilter.setSortby(PolicyUserSortByEnum.Name);
        } else if (upolicyUserFilter.getSortby().equals(UPolicyUserSortByEnum.Login)) {
            zpolicyUserFilter.setSortby(PolicyUserSortByEnum.Login);
        }
        return zpolicyUserFilter;
    }

    public PolicyUsersResult getPolicyUsers(UPolicyUserFilter upolicyUserFilter) throws WSInvalidFilterException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getPolicyUsers() start:");
        PolicyUsersResult result = new PolicyUsersResult();
        if (upolicyUserFilter == null) {
            return this.getPolicyUsers();
        }
        ConfigurationManager cmgr = ConfigurationManager.getInstance(this.username);
        Long itemsPerPage = cmgr.getItemsPerPage();
        upolicyUserFilter.setLimit(itemsPerPage);
        ArrayList<PolicyUserValues> policyUserValuesList = new ArrayList<PolicyUserValues>();
        PolicyUserFilter zpolicyUserFilter = this.translateUPolicyUserFilter(upolicyUserFilter);
        PolicyUserArrayHolder policyUserArrayHolder = new PolicyUserArrayHolder();
        LongHolder count = new LongHolder(0L);
        try {
            WSLocator.getzBandInterface(this.username).getPolicyUsers(zpolicyUserFilter, policyUserArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        PolicyUser[] policyUsers = policyUserArrayHolder.value;
        if (policyUsers != null) {
            for (int i = 0; i < policyUsers.length; ++i) {
                PolicyUser policyUser = policyUsers[i];
                if (policyUser == null) continue;
                policyUserValuesList.add(this.translatePolicyUser(policyUser));
            }
        }
        result = new PolicyUsersResult(policyUserValuesList, new Long(count.value));
        log.debug((Object)("getPolicyUsers() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public PolicyUserValues getPolicyUserDetails(String userid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        PolicyUserValues policyUserValues;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getPolicyUserDetails() start:");
        try {
            policyUserValues = this.translatePolicyUser(WSLocator.getzBandInterface(this.username).getPolicyUser(userid));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("getPolicyUserDetails() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return policyUserValues;
    }

    private Role translateRoleValues(RoleValues roleValues) {
        if (roleValues == null) {
            return null;
        }
        Role role = new Role();
        role.setId(roleValues.getId());
        role.setName(roleValues.getName());
        role.setDescription(roleValues.getDescription());
        return role;
    }

    private PolicyUser translatePolicyUserValues(PolicyUserValues policyUserValues) {
        if (policyUserValues == null) {
            return null;
        }
        ArrayList<RoleValues> roleValuesList = policyUserValues.getRoleValuesList();
        Role[] roles = null;
        if (roleValuesList != null) {
            int size = roleValuesList.size();
            roles = new Role[size];
            for (int i = 0; i < size; ++i) {
                roles[i] = this.translateRoleValues(roleValuesList.get(i));
            }
        }
        PolicyUser policyUser = new PolicyUser();
        policyUser.setId(policyUserValues.getId());
        policyUser.setName(policyUserValues.getName());
        policyUser.setLogin(policyUserValues.getLogin());
        policyUser.setPassword(policyUserValues.getPassword());
        policyUser.setPasswordmodifiedtime(policyUserValues.getPasswordmodifiedtime());
        policyUser.setEnabled(policyUserValues.isEnabled());
        policyUser.setRoles(roles);
        return policyUser;
    }

    public void updatePolicyUser(PolicyUserValues policyUserValues) throws WSPermissionException, WSInternalErrorException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSValueNullException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"updatePolicyUser() start:");
        if (policyUserValues == null) {
            log.error((Object)"Invalid or null policy user");
            throw new WSValueNullException("Invalid or null policy user");
        }
        PolicyUser policyUser = this.translatePolicyUserValues(policyUserValues);
        try {
            WSLocator.getzBandInterface(this.username).setPolicyUser(policyUser);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        String newpassword = policyUserValues.getPassword();
        if (newpassword != null && newpassword.length() > 0) {
            WSLocator.changePassword(policyUserValues.getLogin(), newpassword);
        }
        log.debug((Object)("updatePolicyUser() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Updated user [" + policyUserValues.getName() + "]"));
    }

    public PolicyUserValues getPolicyUser(String userId) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        PolicyUserValues policyUserValues;
        long begin = System.currentTimeMillis();
        log.debug((Object)"get() start:");
        try {
            policyUserValues = this.translatePolicyUser(WSLocator.getzBandInterface(this.username).getPolicyUser(userId));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("get() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return policyUserValues;
    }

    public PolicyUserValues getCurrentPolicyUser() throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidValueException, WSInvalidFilterException, WSDatabaseException, WSInvalidFilterValueException {
        PolicyUserValues result = null;
        UPolicyUserFilter uPolicyUserFilter = new UPolicyUserFilter();
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.setFilterby(UPolicyUserFilterByEnum.Login.getValue());
        filterProperty.setFilter(this.username);
        ArrayList<FilterProperty> filterPropertyList = new ArrayList<FilterProperty>();
        filterPropertyList.add(filterProperty);
        uPolicyUserFilter.setFilterPropertyList(filterPropertyList);
        PolicyUsersResult policyUsersResult = this.getPolicyUsers(uPolicyUserFilter);
        if (policyUsersResult == null || policyUsersResult.getPolicyUserValuesList().size() < 1) {
            throw new WSInvalidValueException("The login name [" + this.username + "] specified is not found");
        }
        result = policyUsersResult.getPolicyUserValuesList().get(0);
        return result;
    }

    public String addPolicyUser(PolicyUserValues policyUserValues) throws WSValueNullException, WSPermissionException, WSInternalErrorException, WSDatabaseException, WSInvalidValueException, WSDuplicateException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String policyUserId;
        long begin = System.currentTimeMillis();
        log.debug((Object)"addPolicyUser() start:");
        if (policyUserValues == null) {
            throw new WSValueNullException("Invalid or null policy user");
        }
        PolicyUser policyUser = this.translatePolicyUserValues(policyUserValues);
        try {
            policyUserId = WSLocator.getzBandInterface(this.username).createPolicyUser(policyUser);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("addPolicyUser() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Added user [" + policyUserValues.getName() + "] + by [" + this.username + "]"));
        return policyUserId;
    }

    public void deletePolicyUser(String policyuserid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deletePolicyUser() start:");
        try {
            WSLocator.getzBandInterface(this.username).deletePolicyUser(policyuserid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("deletePolicyUser() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Deleted user with id [" + policyuserid + "] by [" + this.username + "]"));
    }
}

