/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.util;

import com.ttv.manager.ConfigurationManager.ConfigurationManager;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.PolicyUser;
import com.ttv.zBandInterface.ZBandInterface_BindingStub;
import com.ttv.zBandInterface.ZBandInterface_ServiceLocator;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Category;

public class WSLocator {
    private static HashMap<String, ZBandInterface_BindingStub> bindings = new HashMap();
    private static final Category log = Category.getInstance(WSLocator.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");

    private WSLocator() {
    }

    public static synchronized boolean pitcherIsAlive(String URL2) throws WSConnectException {
        boolean pitcherisalive = false;
        long begin = System.currentTimeMillis();
        log.debug((Object)"pitcherIsAlive() start:");
        try {
            URL url = new URL(URL2);
            ZBandInterface_BindingStub binding = (ZBandInterface_BindingStub)new ZBandInterface_ServiceLocator().getzBandInterface(url);
            pitcherisalive = binding.isAlive();
        }
        catch (RemoteException re) {
            log.error((Object)("Exception is:" + re), (Throwable)re);
            audit.error((Object)"Could not connect to the Pitcher");
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (MalformedURLException e) {
            log.error((Object)("Exception is:" + e), (Throwable)e);
            audit.error((Object)"Could not connect to the Pitcher, not a valid url");
            throw new WSConnectException("Could not connect to the Pitcher, not a valid url");
        }
        catch (ServiceException jre) {
            log.error((Object)("Exception is:" + (Object)((Object)jre)), (Throwable)jre);
            audit.error((Object)"Could not connect to the Pitcher, service exception");
            throw new WSConnectException("Could not connect to the Pitcher, service exception");
        }
        log.debug((Object)("pitcherIsAlive() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return pitcherisalive;
    }

    public static synchronized ZBandInterface_BindingStub getzBandInterface(String username, String url) throws WSInvalidLoginException, WSServerDownException, WSConnectException, MalformedURLException, ServiceException {
        log.debug((Object)"getzBandInterface() start:");
        long begin = System.currentTimeMillis();
        String wsURL = "";
        ZBandInterface_BindingStub binding1 = bindings.get(username);
        String password = (String)binding1._getProperty("javax.xml.rpc.security.auth.password");
        ZBandInterface_BindingStub binding = null;
        try {
            wsURL = "http://" + url + ":8080";
            binding = WSLocator.getzBandInterface(username, password, wsURL);
        }
        catch (ServiceException jre) {
            log.error((Object)("Exception is:" + (Object)((Object)jre)), (Throwable)jre);
            throw jre;
        }
        log.debug((Object)("getzBandInterface() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return binding;
    }

    public static ZBandInterface_BindingStub getzBandInterface(String username) throws WSInvalidLoginException, WSServerDownException, WSConnectException {
        ZBandInterface_BindingStub binding = bindings.get(username);
        if (binding == null) {
            audit.error((Object)("User [" + username + "] is not authorized"));
            log.error((Object)"Make sure that the user is validated first using WSLocator validateUser(..) method");
            throw new WSInvalidLoginException("User [" + username + "] is not authorized");
        }
        try {
            if (binding.isAlive()) {
                return binding;
            }
            audit.error((Object)"WARNING! The Director on the Pitcher could be down.");
            throw new WSServerDownException("WARNING! The Director on the Pitcher could be down.");
        }
        catch (RemoteException re) {
            log.error((Object)("Exception is:" + re), (Throwable)re);
            audit.error((Object)"Could not connect to the Pitcher");
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private static synchronized ZBandInterface_BindingStub getzBandInterface(String username, String password, String URL2) throws MalformedURLException, ServiceException {
        ZBandInterface_BindingStub binding = null;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getzBandInterface() start:");
        URL url = new URL(URL2);
        try {
            binding = (ZBandInterface_BindingStub)new ZBandInterface_ServiceLocator().getzBandInterface(url);
            binding._setProperty("javax.xml.rpc.security.auth.username", username);
            binding._setProperty("javax.xml.rpc.security.auth.password", password);
            if (bindings.containsKey(username)) {
                binding.setTimeout(ConfigurationManager.getInstance(username).getWsProcessingTimeout().intValue() * 1000);
            } else {
                log.info((Object)"User not yet validated, timeout set to default");
                binding.setTimeout(ConfigurationManager.WS_PROCESSING_TIMEOUT.intValue());
            }
        }
        catch (ServiceException jre) {
            log.error((Object)("Exception is:" + (Object)((Object)jre)), (Throwable)jre);
            throw jre;
        }
        log.debug((Object)("getzBandInterface() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Login success for user [" + username + "]"));
        return binding;
    }

    public static synchronized void changePassword(String username, String newpassword) throws WSInvalidLoginException, WSServerDownException, WSConnectException {
        ZBandInterface_BindingStub binding = WSLocator.getzBandInterface(username);
        if (binding != null) {
            binding._setProperty("javax.xml.rpc.security.auth.password", newpassword);
        }
    }

    public static synchronized PolicyUser validateUser(String username, String password, String URL2) throws MalformedURLException, ServiceException, WSInvalidLoginException, WSDatabaseException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"validateUser() start:");
        PolicyUser policyUser = null;
        ZBandInterface_BindingStub binding = WSLocator.getzBandInterface(username, password, URL2);
        if (binding != null) {
            try {
                policyUser = binding.validateLogin(username, password);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                log.error((Object)("Exception is:" + e), (Throwable)e);
                audit.error((Object)"Could not connect to the Pitcher");
                throw new WSConnectException("Could not connect to the Pitcher");
            }
            if (policyUser == null) {
                audit.error((Object)("User [" + username + "] is not authorized"));
                throw new WSInvalidLoginException("User [" + username + "] could not be validated. " + "Either username or password is incorrect");
            }
        } else {
            audit.error((Object)("User [" + username + "] is not authorized"));
            throw new WSInvalidLoginException("User [" + username + "] could not be validated" + " for the URL [" + URL2 + "]. Make sure the username, password and URL are correct");
        }
        bindings.put(policyUser.getLogin(), binding);
        binding.setTimeout(ConfigurationManager.getInstance(username).getWsProcessingTimeout().intValue() * 1000);
        log.debug((Object)("validateUser() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Validated user [" + username + "] for URL [" + URL2 + "]"));
        return policyUser;
    }
}

