/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.rules.upgradde;

import com.tandbergtv.marvin.udt.GenericType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;

public class UpgraddeActionParameters {
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private String password;
    private String username;
    private String oracleSid;
    private String host;

    public UpgraddeActionParameters(String host, String oracleSid, String username, String password) {
        this.host = host;
        this.oracleSid = oracleSid;
        this.username = username;
        this.password = password;
    }

    public void upgrade(boolean force) throws ClassNotFoundException, SQLException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        String url = "jdbc:oracle:thin:@" + this.host + ":1521:" + this.oracleSid;
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, this.username, this.password);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1017) {
                System.out.println("New install or incorrect username/password.");
                return;
            }
            throw e;
        }
        Statement performChecks = conn.createStatement();
        ResultSet colCheckRs = performChecks.executeQuery("SELECT COUNT(*) FROM USER_TAB_COLS WHERE TABLE_NAME = 'TRE_ACTIONPARAMETERVALUE' AND COLUMN_NAME = 'VALUE' AND DATA_TYPE = 'BLOB'");
        colCheckRs.next();
        if (colCheckRs.getInt(1) != 1) {
            System.out.println("Upgrade already performed.");
            performChecks.close();
            return;
        }
        ResultSet versionRs = performChecks.executeQuery("SELECT SETTING_VALUE FROM WFS.SYSTEM_SETTINGS WHERE SETTING_TYPE = 'RELEASE'");
        if (!force && versionRs.next() && versionRs.getString(1).compareTo("3.2.1") >= 0) {
            System.out.println("Upgrade already performed.");
            performChecks.close();
            return;
        }
        Statement addCol = conn.createStatement();
        addCol.execute("ALTER TABLE WFS.TRE_ACTIONPARAMETERVALUE ADD (VALUESTR VARCHAR2(1024 CHAR))");
        addCol.close();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        PreparedStatement update = conn.prepareStatement("UPDATE WFS.TRE_ACTIONPARAMETERVALUE SET valueStr = ? where valueId = ?");
        ResultSet rset = stmt.executeQuery("select valueId, value from WFS.tre_actionParameterValue");
        while (rset.next()) {
            String value;
            int id = rset.getInt(1);
            Blob blob = rset.getBlob(2);
            try {
                value = this.convertBlob(blob);
            }
            catch (IOException e) {
                e.printStackTrace();
                conn.rollback();
                update.close();
                stmt.close();
                return;
            }
            update.setString(1, value);
            update.setInt(2, id);
            update.addBatch();
        }
        update.executeBatch();
        conn.commit();
        update.close();
        stmt.close();
        Statement changeCol = conn.createStatement();
        changeCol.execute("ALTER TABLE WFS.TRE_ACTIONPARAMETERVALUE DROP (VALUE)");
        changeCol.execute("ALTER TABLE WFS.TRE_ACTIONPARAMETERVALUE RENAME COLUMN VALUESTR to VALUE");
        changeCol.close();
        System.out.println("Updated TRE_ACTIONPARAMETERVALUE changed value from Blob to varchar2.");
    }

    private String convertBlob(Blob blob) throws IOException, SQLException, ClassNotFoundException {
        Object obj = this.getBlobAsObject(blob);
        if (obj == null) {
            return null;
        }
        if (obj instanceof GenericType) {
            GenericType gt = (GenericType)obj;
            switch (gt.getDataType()) {
                case LONG: {
                    return String.valueOf(gt.getLongValue());
                }
                case FLOAT: {
                    return String.valueOf(gt.getFloatValue());
                }
                case BOOLEAN: {
                    return String.valueOf(gt.getBooleanValue());
                }
                case DATE: {
                    return dateFormatter.format(gt.getDateValue());
                }
                case TIME: {
                    return gt.getTimeValue();
                }
                case STRING: {
                    return gt.getStringValue();
                }
            }
            return null;
        }
        return obj.toString();
    }

    public Object getBlobAsObject(Blob value) throws IOException, SQLException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(value.getBinaryStream());
        return ois.readObject();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOracleSid() {
        return this.oracleSid;
    }

    public void setOracleSid(String oracleSid) {
        this.oracleSid = oracleSid;
    }
}

