#!/bin/sh
export ORACLE_SID=`ps -ef | grep ora_pmon | grep -v "grep ora_pmon" | awk '{print($8)}' | sed 's/ora\_pmon\_//g'`
export ORACLE_BASE=/opt/app/oracle
export ORACLE_HOME=/opt/app/oracle/product/11.2.0/db_1
/opt/app/oracle/product/11.2.0/db_1/bin/sqlplus -s /nolog << EOM
connect / as sysdba
set head off
set echo on
set serveroutput on
spool /home/oracle/scripts/stats_status.log
SELECT 'Script started at '||to_char(SYSTIMESTAMP,'mm/dd/yyyy hh24:mi:ss') FROM DUAL;

declare
  vcntwfs number;
begin
  select count(*)
  into vcntwfs
  from v\$session
  where username='WFS'
  and status='ACTIVE';
  begin
    if (vcntwfs = 0) then
        dbms_output.put_line('Collecting stats on MDM_METADATA....'); 
        dbms_stats.unlock_table_stats('WFS','MDM_METADATA');
        dbms_stats.delete_table_stats('WFS','MDM_METADATA');
        dbms_stats.gather_table_stats('WFS','MDM_METADATA');
        dbms_stats.lock_table_stats('WFS','MDM_METADATA');
    end if;
  exception
        when others then
           dbms_stats.lock_table_stats('WFS','MDM_METADATA');
  end;
end;
/

EXEC DBMS_STATS.GATHER_DATABASE_STATS;
SELECT 'Script ended at '||to_char(SYSTIMESTAMP,'mm/dd/yyyy hh24:mi:ss') FROM DUAL;
spool off
exit
EOM
