#!/bin/sh
vsid=$1
number_of_partitions_to_add="$2"
install_dir=`pwd`
if [ `whoami` != "oracle" ]; then
   echo "************************************************************************************"
   echo "Only oracle user can run this script. Please log in as oracle user and try again...!"
   echo "************************************************************************************"
   exit 1
fi

if [ "$vsid" = "" ]; then
   echo "*****************************************************************"
   echo "First parameter should be the Database SID, please try again....!"
   echo "*****************************************************************"
   exit 1
fi

if [ "$number_of_partitions_to_add" != "" ]; then  
   if  [ $number_of_partitions_to_add -lt 1 ]; then
      echo "*****************************************************************************************"
      echo "Second parameter number of partitions to be added and it should not be less than one,"
      echo "Please try again....!"
      echo "*****************************************************************************************"
      exit 1
   fi
fi

echo "------------------------------------------------------------"
echo "************** Beginning of the script *********************"

export ORACLE_SID=$vsid
sqlplus -S /nolog << EOF
conn / as sysdba
set serveroutput on
SET VERIFY OFF
set echo on
spool "${install_dir}/add_partitions.log" append
set head off
set feedback off

define num_of_partitions_to_add="$number_of_partitions_to_add"

begin
  dbms_output.put_line(chr(10)||'Script started at '||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||chr(10));

  sys.createwfsdb.add_partitions(&num_of_partitions_to_add);

  dbms_output.put_line(chr(10)||'Script ended at '||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||chr(10));
END;
/

spool off
EOF
echo "********************* End of the script ********************"
echo "------------------------------------------------------------"
