#!/bin/sh
source /home/oracle/.bash_profile
${ORACLE_HOME}/bin/sqlplus -s /nolog << EOM
connect / as sysdba
set head off
set echo on
set serveroutput on
spool /home/oracle/scripts/stats_status.log
SELECT 'Script started at '||to_char(SYSTIMESTAMP,'mm/dd/yyyy hh24:mi:ss') FROM DUAL;
execute dbms_stats.gather_schema_stats('XDB');
execute dbms_stats.gather_table_stats('WFS','MDM_METADATA',cascade=>TRUE);
execute DBMS_STATS.GATHER_DATABASE_STATS;
SELECT 'Stats Script ended at '||to_char(SYSTIMESTAMP,'mm/dd/yyyy hh24:mi:ss') FROM DUAL;
execute ctx_ddl.optimize_index(idx_name=>'wfs.mdm_index_xmltype',optlevel=>CTX_DDL.OPTLEVEL_FULL,maxtime=>30);
SELECT 'XMLIndex rebuild script ended at '||to_char(SYSTIMESTAMP,'mm/dd/yyyy hh24:mi:ss') FROM DUAL;
spool off
exit
EOM
