#!/bin/sh
################################################################
#   File-name : copy_all_xml.sh                                #
#   Purpose   : Registers new xsd into xml schema and copies   #
#               all the metadata and revision records.         #
#   Created by: Suresh Neravati                                #
#   Date      : 11/15/2012                                     #
#                                                              #
#   Modifications:                                             #
#   07/11/2013 - Added second parameter (transfermation file)  #
#                and transformation copying also.              #
################################################################

export ORACLE_SID=$1
XML_TRANS_FILE=$2
LOG_DIR="/home/oracle/scripts"
INSTALL_DIR=`pwd`

if [ "$ORACLE_SID" = "" ]; then
  echo "Database SID should not be blank, please try again....!"
  exit 1
fi

echo "***************************************************************"
echo "  XML copying script started at $(date)"
echo "***************************************************************"
if [ "X$XML_TRANS_FILE" = "X" ]; then
   XML_TRANS_FILE="copy_all.xsl"
   echo "Using default XML Transformation file $XML_TRANS_FILE."
fi
if [ ! -f "${INSTALL_DIR}/${XML_TRANS_FILE}" ];  then
   echo "Transformation file ${XML_TRANS_FILE} is missing in ${INSTALL_DIR} folder, Can not continue the script."
   exit 1
fi
if [ -f "/home/oracle/ecmf/ECMFSpec.xsd" ];  then
   cp -f /home/oracle/ecmf/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec_before_$(date +"%Y%m%d_%H%M%S").xsd
   mv -f /home/oracle/ecmf/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec_old.xsd

   cp -f /home/oracle/ecmf/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans_before_$(date +"%Y%m%d_%H%M%S").xsl 2> /dev/null
   mv -f /home/oracle/ecmf/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans_old.xsl 2> /dev/null

   cp -f ${INSTALL_DIR}/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec.xsd
   cp -f ${INSTALL_DIR}/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans.xsl 2> /dev/null
else
   mkdir -p /home/oracle/ecmf
   cp -f ${INSTALL_DIR}/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec.xsd
   cp -f ${INSTALL_DIR}/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans.xsl 2> /dev/null
fi
$ORACLE_HOME/bin/sqlplus -s / as sysdba<<SEOF
   spool $LOG_DIR/copy_all_xml.log 
   SELECT 'mdm_metadata='||count(*) "Mdm_Record_Count_before" FROM wfs.mdm_metadata UNION SELECT 'mdm_metadata_revision='||count(*) FROM wfs.mdm_metadata_revision;
   set head off
   BEGIN
      EXECUTE IMMEDIATE 'DROP TABLE WFS.mdm_metadata_backup';
   EXCEPTION WHEN OTHERS THEN NULL;
   END;
   /
   BEGIN
      EXECUTE IMMEDIATE 'DROP TABLE wfs.mdm_metadata_revision_backup';
   EXCEPTION WHEN OTHERS THEN NULL;
   END;
   /
   alter table wfs.mdm_metadata parallel;
   alter table wfs.mdm_metadata_revision parallel;

   select 'Creating temp tables.' from dual;
   CREATE TABLE wfs.mdm_metadata_backup parallel nologging as select /*+ PARALLEL(md, 32) */ xmlserialize(document object_value as clob no indent) as data_col from WFS.MDM_METADATA md;
   CREATE TABLE wfs.mdm_metadata_revision_backup parallel nologging as select /*+ PARALLEL(mdr, 32) */ xmlserialize(document object_value as clob no indent) as data_col from WFS.MDM_METADATA_REVISION mdr;

   BEGIN
      EXECUTE IMMEDIATE 'drop table WFS.mdm_metadata_rejected';
   EXCEPTION WHEN OTHERS THEN NULL;
   END;
   /
   BEGIN
      EXECUTE IMMEDIATE 'drop table WFS.mdm_metadata_revision_rejected';
   EXCEPTION WHEN OTHERS THEN NULL;
   END;
   /
   create table WFS.mdm_metadata_rejected (data_col clob);
   create table WFS.mdm_metadata_revision_rejected (data_col clob);
   spool off
SEOF

MDMCNT=$(sqlplus -S /nolog<<ZYX
  connect / as sysdba
  set pages 0
  set feedback off
  select count(*) from wfs.mdm_metadata_backup;
  exit
ZYX
)
MDMRCNT=$(sqlplus -S /nolog<<ZYX
  connect / as sysdba
  set pages 0
  set feedback off
  select count(*) from wfs.mdm_metadata_revision_backup;
  exit
ZYX
)
if ((${MDMCNT} == 0)) || ((${MDMRCNT} == 0)); then
  echo -e "\nExiting the script, since there are no metadata or revision records in temp tables....."
  echo -e "*****************************************************************************************\n"
  exit 1
fi
(

DROPXMLCNT=$(sqlplus -S /nolog<<ZYX
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT COUNT(*) FROM DBA_PROCEDURES WHERE PROCEDURE_NAME='DROP_XML_INDEXES';
  exit
ZYX
)

if ((${DROPXMLCNT} == 0)); then
$ORACLE_HOME/bin/sqlplus -s / as sysdba<<REF
   conn wfs/Wf\$1234
   set serveroutput off 
   set echo off
   set head off
   select 'Dropping xml indexes.' from dual;
   DROP INDEX wfs.mdm_index_xmltype force;
   DROP INDEX wfs.ecmfspec_xmlindex force;
   DROP INDEX wfs.ecmfspec_rev_xmlindex force;
   DROP INDEX wfs.idx_xml_path_tab force;
   DROP INDEX wfs.idx_ecmfdisplaytab_ttvid force;
   BEGIN dbms_xmlindex.dropparameter('ecmfstructuredxml_idx'); END;
   /
REF
else
$ORACLE_HOME/bin/sqlplus -s / as sysdba<<CCC
   conn wfs/Wf\$1234
   spool $LOG_DIR/copy_all_xml.log append
   set serveroutput on
   set echo off
   set head off
   BEGIN SYS.CREATEWFSDB.DROP_XML_INDEXES; EXCEPTION WHEN others THEN NULL; END;
   /
   spool off
CCC
fi
) >> /dev/null
$ORACLE_HOME/bin/sqlplus -s /nolog<<FFF  
   connect / as sysdba
   set serveroutput on
   SET VERIFY OFF
   begin 
      execute immediate 'DROP DIRECTORY XMLEVOLVEDIR'; 
   exception
      when others then
         null;
   end;
   /
   CREATE DIRECTORY XMLEVOLVEDIR AS '${INSTALL_DIR}';
   GRANT ALL ON DIRECTORY XMLEVOLVEDIR TO WFS;
   exit
FFF
$ORACLE_HOME/bin/sqlplus -s / as sysdba<<CDE
   conn wfs/Wf\$1234
   spool $LOG_DIR/copy_all_xml.log append
   set serveroutput on
   set echo off
   set head off
   ALTER SESSION SET RECYCLEBIN=OFF;
   DROP TABLE wfs.mdm_metadata;
   DROP TABLE wfs.mdm_metadata_revision;
   BEGIN DBMS_XMLSCHEMA.DELETESCHEMA('ECMFSpec.xsd',4); END;
   /
   select 'Registering XML schema.' from dual;
   BEGIN
      DBMS_XMLSCHEMA.registerSchema(
      schemaurl => 'ECMFSpec.xsd',
      SCHEMADOC => bfilename('ECMFXMLDIR','ECMFSpec.xsd'),
      gentypes => FALSE,
      OWNER => 'WFS',
      CSID => nls_charset_id('AL32UTF8'),
      OPTIONS => DBMS_XMLSCHEMA.REGISTER_BINARYXML);
   END;
   /
   select 'Creating XML tables.' from dual;
   CREATE TABLE mdm_metadata OF XMLType
     XMLTYPE STORE AS SECUREFILE BINARY XML
    XMLSCHEMA "http://xmlns.oracle.com/xdb/schemas/WFS/ECMFSpec.xsd"
    ELEMENT "ECMFSpec";
   CREATE TABLE mdm_metadata_revision OF XMLType
     XMLTYPE STORE AS SECUREFILE BINARY XML
    XMLSCHEMA "http://xmlns.oracle.com/xdb/schemas/WFS/ECMFSpec.xsd"
    element "ECMFSpec";
   select 'Copying xml documents to xml tables, Please wait..!' from dual;
   BEGIN
      FOR cur_metadata IN (SELECT DATA_COL FROM wfs.mdm_metadata_backup )
      loop
         BEGIN
            IF ('${XML_TRANS_FILE}'= 'copy_all.xsl') THEN
               INSERT INTO WFS.mdm_metadata select xmltype(cur_metadata.DATA_COL) from dual;
            ELSE
               INSERT INTO WFS.mdm_metadata 
               select xmltype(cur_metadata.DATA_COL).transform(XMLTYPE(BFILENAME('XMLEVOLVEDIR','${XML_TRANS_FILE}'),NLS_CHARSET_ID('AL32UTF8'))) from dual;
            END IF;
         exception
           WHEN others THEN
             INSERT INTO WFS.mdm_metadata_rejected select cur_metadata.DATA_COL from dual;
         end;
         COMMIT;
      END loop;
      dbms_output.put_line('Copying metadata completed successfully.');
   END;
   /
   BEGIN
      FOR cur_metadata_revision IN (SELECT DATA_COL FROM wfs.mdm_metadata_revision_backup)
      loop
         BEGIN
            IF ('${XML_TRANS_FILE}'= 'copy_all.xsl') THEN
             INSERT INTO WFS.mdm_metadata_revision select xmltype(cur_metadata_revision.DATA_COL) from dual;
            ELSE
             INSERT INTO WFS.mdm_metadata_revision 
                select xmltype(cur_metadata_revision.DATA_COL).transform(XMLTYPE(BFILENAME('XMLEVOLVEDIR','${XML_TRANS_FILE}'),NLS_CHARSET_ID('AL32UTF8'))) from dual;
            END IF;
         exception
           WHEN others THEN 
             INSERT INTO WFS.mdm_metadata_revision_rejected select cur_metadata_revision.DATA_COL from dual;
         END;
         COMMIT;
      END loop;
      dbms_output.put_line('Copying metadata revision completed successfully.');
   END;
   /
   ALTER SESSION SET RECYCLEBIN=ON;
   spool off
CDE

MDMREJCNT=$(sqlplus -S /nolog<<VWX
  connect / as sysdba
  set pages 0
  set feedback off
  select count(*) from wfs.mdm_metadata_rejected;
  exit
VWX
)
MDMRREJCNT=$(sqlplus -S /nolog<<RST
  connect / as sysdba
  set pages 0
  set feedback off
  select count(*) from wfs.mdm_metadata_revision_rejected;
  exit
RST
)
if ((${MDMREJCNT} > 0)) || ((${MDMRREJCNT} > 0)); then
$ORACLE_HOME/bin/sqlplus -s / as sysdba<<FGH
   conn wfs/Wf\$1234
   spool $LOG_DIR/copy_all_xml.log append
   set serveroutput on
   set echo off
   set head off
   BEGIN
      FOR cur_rej_mdm IN (select data_col as rej_mdm_col from wfs.mdm_metadata_rejected m)
      loop
         BEGIN
           insert into WFS.MDM_METADATA 
             select xmltype(regexp_replace(cur_rej_mdm.rej_mdm_col,'[[:cntrl:]]')).transform(XMLTYPE(BFILENAME('XMLEVOLVEDIR','${XML_TRANS_FILE}'),NLS_CHARSET_ID('AL32UTF8'))) from dual;
           commit;
         exception
           WHEN others THEN 
             BEGIN 
                insert into wfs.mdm_metadata select xmltype(cur_rej_mdm.rej_mdm_col).transform(XMLTYPE(BFILENAME('XMLEVOLVEDIR','${XML_TRANS_FILE}'),NLS_CHARSET_ID('AL32UTF8'))) from dual;
                commit;
             EXCEPTION
               WHEN others THEN null;
             END;
         END;
         COMMIT;
      END loop;
      dbms_output.put_line('Copying rejected metadata completed successfully.');
   END;
   /
   BEGIN
      FOR cur_rej_mdmr IN (select data_col as rej_mdmr_col from wfs.mdm_metadata_revision_rejected m)
      loop
         BEGIN
           insert into WFS.MDM_METADATA_REVISION 
             select xmltype(regexp_replace(cur_rej_mdmr.rej_mdmr_col,'[[:cntrl:]]')).transform(XMLTYPE(BFILENAME('XMLEVOLVEDIR','${XML_TRANS_FILE}'),NLS_CHARSET_ID('AL32UTF8'))) from dual;
           commit;
         exception
           WHEN others THEN 
             BEGIN 
                insert into wfs.mdm_metadata_revision select xmltype(cur_rej_mdmr.rej_mdmr_col).transform(XMLTYPE(BFILENAME('XMLEVOLVEDIR','${XML_TRANS_FILE}'),NLS_CHARSET_ID('AL32UTF8'))) from dual;
                commit;
             EXCEPTION
               WHEN others THEN null;
             END;
         END;
         COMMIT;
      END loop;
      dbms_output.put_line('Copying rejected metadata revision completed successfully.');
   END;
   /
   spool off
FGH
fi
$ORACLE_HOME/bin/sqlplus -s / as sysdba<<DDD
   set serveroutput on
   set echo off
   set head on
   spool $LOG_DIR/copy_all_xml.log append
   SELECT 'mdm_metadata='||count(*) "Mdm_Record_Count_after" FROM wfs.mdm_metadata UNION SELECT 'mdm_metadata_revision='||count(*) FROM wfs.mdm_metadata_revision;
   begin 
      execute immediate 'DROP DIRECTORY XMLEVOLVEDIR'; 
   exception
      when others then
         null;
   end;
   /
   spool off
   spool ${INSTALL_DIR}/recompile_invalid_objects.log
   @${ORACLE_HOME}/rdbms/admin/utlprp.sql 1 
   spool off
DDD

echo "***************************************************************"
echo "  XML copying script ended at $(date)"
echo "***************************************************************"
exit 0
