/* 
================================================================================
Database name:  WFS   
Schema Name:    WFS
Version: @version $Id: createWFS.sql,v 1.235 2013/07/23 19:11:55 mhabib Exp $                                 
DBMS name:      ORACLE Version 10.1 or 10.2                       
Script purpose: Create the WFS user and all its corresponding objects:
		 		        tables, views, sequences and constraints etc.

Created by:     Murtaza Habib 09/22/2008
NOTE:		        Must be logged on as sys user

Modifications:
SwVer   DbVer     ModifiedBy      ModifiedDate    Details  
-----   -----     -------------   ------------   -------
                  Vijay           10/13/2008   
                  Vlada           10/22/2008     PMM Inserts for mandatory TTV self partner
                  Raj             03/02/2009     Branch for Neptune project     
                  Suneeta         04/01/2009     NEPTUNE Changes. Version 2.9. Changes to PMM_PROGRESSITEM table
                  Raj/Suneeta     04/01/2009     Changes to PMM_PROGRESSITEM table
                  MH              04/27/2009     Found a bug! so, Altered TABLE PMM_TITLE to add a contraint
                  Suneeta         05/12/2009     ALTER TABLE PMM_TITLE to DROP COLUMN ISACTIVE
                  Suneeta         05/14/2009     Added PMM_TitleStatus table inserts.
                  Dipti           05/29/2009     By QA increased the table PMM_PROGRESSITEM column DESCRIPTION.
                  Suneeta         06/08/2009     Altered the table PMM_JOB to modify columns
                  Suneeta         06/17/2009     Altered the table PMM_PROGRESSITEM to modify column
                  Suneeta         07/13/2009     Created table PMM_CONTAINER_PROPERTIES
                  Suneeta         08/04/2009     Alter table PMM_PROGRESSITEM, WFS.PMM_Title_TitleListXREF
1.5    3.1.0.0    Eugene          07/21/2010     Created table PMM_CONTENT_CLASS 
1.5    3.1.0.0    Eugene          08/04/2010     Created table PMM_CONTENT_CLASS_PARTNER 
1.5    3.1.0.0    Eugene          08/05/2010     Altered table PMM_TITLE and linked the Content Class to Parter.
1.5    3.1.0.0    Nicholas        08/11/2010     Update script for MDM_ASSET table class_id from I to G for movie and preview. 
1.5    3.1.0.0    Daniel          08/11/2010     Created text index on MDM_Field value column.
1.5    3.1.0.0    Daniel          08/13/2010     Updated TRE_Event names and a new event "DELETE" has been created
1.5    3.1.0.0    Eugene          08/17/2010     Added a unique key constraint to the Name column in PMM_CONTENT_CLASS.
1.5    3.1.0.0    Sahil           08/19/2010     Altered table jbpm_variableaccess to add a new column initialvalue.
1.5    3.1.0.0    Francisco       08/19/2010     Created a new table CMS_USER_SESSION.
1.5    3.1.0.0    Vijay           08/19/2010     Added a new table PMM_PARTNER_USERS and added a new column THUMBNAIL to PMM_Partner
1.5    3.1.0.0    Raj             08/19/2010     Added a new table SITES_EXPORT_CONF_PARAMS
1.5    3.1.0.0    Vijay           08/20/2010     Created a unique key index on PMM_PARTNER_USERS
1.5    3.1.0.0    Patrik          08/23/2010     Created tables CMS_ASSETLIST,CMS_ASSETLIST_ASSET_MAP
1.5    3.2.0.0    Gunnar          08/26/2010     Created table PMM_TITLEASSET_PROPERTY
1.5    3.2.0.0    Vijay           08/31/2010     Created table PMM_TITLE_RESOURCE 
1.5    3.2.0.0    Kinjal          09/01/2010     created a default admin record
1.5    3.2.0.0    Eugene          09/09/2010     Increase the column width in PMM_CONTENT_CLASS
1.5    3.2.0.0    Suresh          09/09/2010     Title purge history table created
1.5    3.2.0.0    Patrik          09/09/2010     Created tables CMS_ASSETLIST_METADATA ,CMS_ASSETLIST_ASSET_METADATA 
1.5    3.2.1.0    Suresh          09/13/2010     Oracle Sequence initial value issue fixed.
1.5    3.2.1.0    Patrik          09/14/2010     Alter the constraint on CMS_ASSETLIST_ASSET_MAP table
1.5    3.2.1.0    Vijay           09/23/2010     Add a new record "DELETE" in PMM_TitleStatus table
1.5    3.2.1.0    Daniel          09/23/2010     Added changes for Blob to Varchar2 in Tre_ActionParameterValue table
1.5    3.2.1.0    Vijay           09/23/2010     Marking the DELETE status for some of the the title records.
1.5    3.2.2.0    Suresh          10/14/2010     Added additional datafile to the tablespace WFS_DATA.
1.5    3.2.3.0    Suresh          10/21/2010     Added foreign key constraint on PMM_TITLE_RESOURCE table.
1.5    3.2.3.0    Kinjal          10/21/2010     Adding user records for self partner in pmm_partner_users table.
1.5    3.2.3.0    Vijay           10/25/2010     Removed foreign key constraint on PMM_TITLE_RESOURCE titleid column.
1.5    3.2.4.0    Suresh          11/12/2010     Modified the script to fix the pmm_partner_users table Id issue.
2.0    3.2.5.0    Murtaza         12/15/2010     Backport fix for creating indexes on MDM_FIELD for CMS1.2->1.5 upgrade.
2.0    3.2.5.0    Vijay           12/17/2010     Added new tables CMS_LOOKUP_KEY and CMS_LOOKUP_KEY_ASSET_TYPE tables
2.0    3.2.5.0    Sanjay          01/07/2011     Added a new record prioritization in TRE_PACKAGE table.
2.0    3.2.5.0    Daniel          01/13/2011     Added a new table CMS_USER_PREFERENCES by Daniel.
2.0    3.2.5.0    Raj             02/11/2011     Added new tables for Job Schedule.
2.0    3.2.5.0    Suresh          02/23/2011     Removed the BYTE from VARCHAR2 datatypes and changed the nls_length_semantics to CHAR
2.0    3.2.5.0    Suneeta         03/02/2011     Added a column IncludeCount to tre_titlesearch table.
2.0    3.2.5.0    Suresh          03/03/2011     Altered the table pmm_properties to modify value column width.
2.0    3.2.5.0    Suneeta         03/07/2011     Added a new table TITLE_SEARCH_RESULTS_COLUMN.
2.0    3.2.5.0    Raj             03/07/2011     Added two new tables to the Job Schedule.
2.0    3.2.5.0    Suneeta         03/10/2011     Modified the CMS_USER_PREFERENCES table KEY, VALUE columns to 500 CHARs.
2.0    3.2.6.0    Suneeta         03/17/2011     Altered table TRE_TITLESEARCH to drop 3 columns and added includecount column in tre_titlefilter table.
2.0    3.2.6.0    Kinjal          03/22/2011     Dropped constraint wfs.FK_MDMASSET_ASSETMAP_ASSET_ID and insert LIST record in TTV_DATATYPE table.
2.0    3.2.6.0    Murtaza         03/23/2011     Added XML Schema registration, table and index creation etc.
2.0    3.2.6.0    Suresh          03/23/2011     Modified the trigger PMM_TITLE_PURGE_INSERTTRG for xmldb code and created views for Jreports.
2.0    3.2.6.0    Sahil           03/25/2011     Modified the sequences cache to 100 for five JBPM Sequences.
2.0    3.2.6.0    Suresh          03/25/2011     Added XMLEvolve to the script.
2.0    3.2.6.0    Sanjay          03/30/2011     Sanjay added the table SCH_JOB_DISABLED_TIMES.
2.0    3.2.6.0    Kinjal          03/31/2011     Added LookupKey and LookUpKeyAssetType table records.
2.0    3.2.6.0    Bak             04/07/2011     Bak added assettype column to pmm_titleasset_property.
2.0    3.2.6.0    Suresh          04/07/2011     Added an index on pmm_title table content_class_id column.
2.0    3.2.7.0    Murtaza         04/21/2011     Added Partiioning for EMA.
2.0    3.2.7.0    Suresh          04/21/2011     Modified the sequences cache to 100 for JBPM Log Sequence.
2.0    3.2.7.0    Suresh          04/21/2011     Removed the sub partitions from JBPM_TOKEN table.
2.0    3.2.7.0    Eugune          04/28/2011     updating the asset_type of pmm_titleasset_property from mdm_asset id.
2.0    3.2.7.0    Suresh          05/04/2011     Added an index on pmm_title table mdmdocid column.
2.0    3.2.7.0    Daniel W        05/05/2011     Updating rules tables for cms1.5 to cms2.0 data migration.
2.0    3.2.7.0    Murtaza         05/05/2011     Modified the PMM_Title index from 3 to 4 column index.
2.0    3.2.7.0    Bak Ng          05/05/2011     Added an index for mdm_metadata_revision table.
2.0    3.2.7.0    Murtaza         05/05/2011     Modified the index and added more columns.
2.0    3.2.7.0    Suresh          05/06/2011     Created separate procedure RECREATE_XML_INDEXES for xml indexes and granted the exec permission to wfs.
2.0    3.2.7.0    Murtaza         05/16/2011     Removed as per Sahil Verma. TTV_RESOURCEUSAGEHISTORY, TTV_TOKENRESOURCE, TTV_RESOURCEGROUPQUEUEITEM.
2.0    3.2.7.0    Suresh          06/02/2011     Added flexibility for the partition size.
2.0    3.2.7.0    Suresh          06/02/2011     Added a new procedure to add partions to the existing JBPM tables.
2.0.   3.2.7.0    Suresh          06/03/2011     Added dbms_output statements for add partitions log file.
2.0    3.2.8.0    Eugene          06/06/2011     Added a configuration xml file for the Default content class.
2.0    3.2.8.0    Daniel Weiner   06/06/2011     Altered the tre_predicate table column fieldLeft as Nullable.
2.0    3.2.8.0    Suresh          06/07/2011     For fixing the bug# 569, changed the column width to 4000 chars.
2.0    3.2.9.0    Nick            06/16/2011     Added a new column integer_value in CMS_ASSETLIST_ASSET_METADATA table.
2.0    3.2.9.0    Daniel Weiner   06/20/2011     updated wfs.tre_predicate and wfs.tre_titlefilter tables data in upgrade.
2.0    3.2.9.0    Eugune          06/22/2011     Removed the default content class xml file update from Upgrade path.
2.0    3.2.9.0    Kinjal          06/22/2011     Kinjal added code to modify the CMS_ROLEPERMISSIONS for Reports module.
2.0    3.2.10.0   Suresh          06/27/2011     Dropped the SYS.RECREATE_XML_INDEXES procedure.
2.0    3.2.10.0   Raj             06/30/2011     Added a new column STALE in WFS.SCH_PASTEXECUTION table.
2.0    3.2.11.0   Danny           07/12/2011     Danny rule upgrade.
2.0    3.2.12.0   Murtaza         07/25/2011     Turning on automatic sql profile implementation.
2.0    3.2.12.0   Daniel Weiner   08/02/2011     Added insert and update statements to the Rules engine tables.
2.0    3.2.13.0   Murtaza         08/04/2011     Brought back the variable cursor_sharing value to EXACT. 
2.0    3.2.13.0   Daniel Weiner   08/09/2011     Added update statements to the Rules tables.
2.0    3.2.13.0   Daniel Weiner   08/10/2011     Added two more update statements to the Rules tables.
2.0    3.2.13.0   Murtaza         08/15/2011     Added index to speed up MDM_METADATA document id lookups.
2.0    3.2.13.0   Raj             08/18/2011     Dropped the contextid column from Sites_site table and deleted pmm_context data where containertypeid=3    
2.0    3.2.13.0   Raj             08/19/2011     Request to drop seven tables.
2.0    3.2.13.0   Daniel Weiner   08/22/2011     Daniel request to change the data in tre_predicate table to fix bug 1881.
2.0    3.2.13.0   Daniel Weiner   08/24/2011     Deleted data from rules tables tre_action, tre_rule and tre_actionparametervalue for certain classNames.
2.0    3.2.14.0   Suresh          09/02/2011     Added create table privilege to WFS in the upgrade path for purge script.
2.0    3.2.14.0   Murtaza         09/08/2011     Disabled the Tuning profile.
2.0    3.2.14.0   Daniel Weiner   09/08/2011     Daniel requested to remove the changes that requested on 08/24/2011.
2.0    3.2.15.0   Murtaza/Suresh  09/21/2011     Added xml copy evolve proc
2.0    3.2.15.0   Suresh          09/22/2011     Removed the code that added for copy evolve, since the evolve script is separated from createWFS.sql
2.0    3.2.16.0   Vijay Silva     01/06/2012     Changes to cms_user and cms_role tables.
2.0    3.2.16.0   Raj             01/09/2012     Dropped unique key constraint UNQ_ASSET_MAP_ASSET_TITLE_ID in table CMS_ASSETLIST_ASSET_MAP.
2.0    3.2.17.0   Nick            01/09/2012     Addded new OSVOD fields to the ecmf spec (all these are just additional, no modifications to the existing fiels) on 01/06/2012, But no need of evolve.
2.5    3.2.18.0   Stephen Zack    12/07/2011     Added Category Manager section tables and views.
2.5    3.2.18.0   Suresh          12/15/2011     Added force option for dropping xml indexes.
2.5    3.2.18.0   Eugene          01/04/2012     Added pmm_content_class_type table.
2.5    3.2.18.0   Eugene          01/05/2012     Content class type id changed start from 0 in pmm_content_class_type table(0-Package,1-Series,2-Category).
2.5    3.2.18.0   Sanjay          01/05/2012     Added sites_mso and sites_mso_override tables.
2.5    3.2.18.0   Stephen Zack    01/10/2012     Added DISPLAY_ORDER column in CAT_FIELD_SCHEMA.
2.5    3.2.18.0   Raj             01/10/2012     Raj dropped 3 tables (PMM_SERVICE, PMM_SERVICE_PARTNERXREF and PMM_WATCHFOLDERCONFIGURATION) and also deleted SERVICE,SITE records from PMM_CONTAINERTYPE.
2.5    3.2.18.0   Stephen Zack    01/10/2012     Changed IMAGE_VALUE column from varchar2 to Blob with securefile in CAT_CATEGORY_METADATA table.
2.5    3.2.18.0   Anuj Jain       01/18/2012     Changed the path column of VW_CAT_CATEGORY_PATHS and start with condition in the query.
2.5    3.2.18.0   Stephen Zack    01/18/2012     Modified the date_value columns to TIMESTAMP WITH TIME ZONE on CAT_CATEGORY_METADATA and CAT_FIELD_DEFAULTS
2.5    3.2.18.0   Avinash         01/19/2012     Added six tables for Metadata Configuration.
2.5    3.2.18.0   Anuj Jain       01/23/2012     Changed CAT_CATOGORY.ASSOCIATED_CATEGORY_PACKAGE column from VARCHAR2 to NUMBER.
2.5    3.2.18.0   Raj             01/25/2012     Modified columns PMM_PARTNER.PROVIDERID and PMM_CONTACT.EMAIL to NULL.
2.5    3.2.18.0   Sanjay          01/25/2012     Added SITES_MSO_OVERRIDE_HISTORY table.
2.5    3.2.18.0   Daniel Weiner   02/06/2012     Added a column criteriamode to tre_titlefilter table.
2.5    3.2.18.0   Raj             02/06/2012     Dropped the table PMM_PITCHFREQUENCY.
2.5    3.2.18.0   Raj             02/09/2012     Modified the column PMM_TITLELIST.PITCHDATE to TIMESTAMP.
2.5    3.2.18.0   Anuj jain       02/10/2012     Added a new records in Category management tables.
2.5    3.2.18.0   Eugene          02/10/2012     Added category_content_class.xml.
2.5    3.2.18.0   Bak             02/10/2012     Added series_content_class.xml.
2.5    3.2.19.0   Stephen Zack    02/15/2012     Updated the start and end date record display type to DatePicker.
2.5    3.2.19.0   Suresh          02/17/2012     Bak and Eugene added Series and Category default content classes applied to the upgrade path along with partner association.
2.5    3.2.19.0   Murtaza         02/24/2012     Added seriesxml_idx.
2.5    3.2.19.0   Suneeta         02/27/2012     Added update statements for the rules tables.
2.5    3.2.19.0   Anuj Jain       02/28/2012     updated the file CAT_FIELD_SCHEMA.sql to disable the custom.
2.5    3.2.19.0   Bak             02/28/2012     Modified series_content_class.xml.
2.5    3.2.19.0   Sanjay          02/28/2012     Modified SITES_MSO_OVERRIDE_HISTORY table.
2.5    3.2.19.0   Murtaza         02/28/2012     lock stats on MDM_METADATA table
2.5    3.2.19.0   Raj             03/02/2012     Updated PMM_TITLELIST.PITCHDATE timecomponent to 00:00:00.
2.5    3.2.20.0   Murtaza         03/06/2012     Changed XML indexes. Removed structured xml xpath from unstructured index. Added Series xpath index.
2.5    3.2.20.0   Suresh          03/13/2012     Updated Series and Category content classes provided by Eugene and Bak.
2.5    3.2.20.0   Murtaza         03/16/2012     Murtaza added Fields/ExternalSeriesID/Id column to seriesfieldsxml_idx.
2.5    3.2.20.0   Raj             03/16/2012     Raj request to add a one column new table in the upgrade path.
2.5    3.2.21.0   Kinjal          03/21/2012     Added two more missing lookup key asset type records in cms_lookup_key_asset_type table to fix bug no.3730
2.5    3.2.21.0   Suneeta         03/21/2012     Suneeta added Fields/ExternalSeriesID/Id column to seriesfieldsxml_idx.
2.5    3.2.21.0   Murtaza         03/23/2012     Unlock and Lock mdm_metadata table for stats added in recreate_xml_indexes proc.
2.5    3.2.21.0   Suresh          03/26/2012     Added code to increment the sequence of users, roles, modules, permissions and user_preferences max value to max value of Id from the table + 1.
2.5    3.2.21.0   Suneeta         03/28/2012     Suneeta rules update statements code moved from cms2.5 upgrade path to immeidately after cms2.0.010.65 upgrade.
2.5    3.2.21.0   Bak             03/28/2012     Provided revised series content class.
2.5    3.2.21.0   Suresh          03/26/2012     Dropped index wfs.UNQ_ASSET_MAP_ASSET_TITLE_ID on table CMS_ASSETLIST_ASSET_MAP.
2.5    3.2.22.0   Sanjay          04/12/2012     Dropped constraint FK_SITES_MOH_SITE_TITLE on TABLE WFS.SITES_MSO_OVERRIDE_HISTORY.
3.0    3.3.0.0    Anna Simonenko  06/07/2012     Created custom field group and field tables in META_DATA_MANAGER.
3.0    3.3.1.0    Anna Simonenki  06/22/2012     Added a column uuid in mdm_custom_field_group table.
3.0    3.3.2.0    Stephen Zack    06/22/2012     Added metadata enhancement six tables.
3.0    3.3.3.0    Raj             07/06/2012     Added SCH_PASTEXECUTIONDATA table and changes to SCH_PASTEXECUTION.
3.0    3.3.4.0    Anna Simonenko  06/25/2012     Added new column multivalue in table mdm_custom_field.
3.0    3.3.4.0    Anna Simonenko  06/27/2012     Added new column field_type in table mdm_custom_field and drop column drop_down.
3.0    3.3.5.0    Stephen Zack    07/25/2012     Modified Metadata enhancement tables.
3.0    3.3.6.0    Stephen Zack    08/03/2012     Dropped constraint ME_FIELD_DEFINITION_UK1.
3.0    3.3.6.0    Sanjay          08/09/2012     altered sch_ruleparameter table value column length.
3.0    3.3.7.0    Stephen Zack    08/16/2012     Altered constraint ME_IDENTIFIER_CRITERIA_UK1.
3.0    3.3.8.0    Stephen Zack    08/21/2012     Altered table WFS.ME_CACHE_RESULT columns as nullable.
3.0    3.3.8.0    Suresh Neravati 08/22/2012     Simplified the upgrade path version code.
3.0    3.3.9.0    Raj             08/23/2012     Updated sch_pastexecution table orig_execution_time.
3.0    3.3.9.0    Daniel Weiner   08/23/2012     Added four new rules tables.
3.0    3.3.10.0   Suresh Neravati 08/24/2012     Dropped sequence and associated trigger on TRE_BULKEXECUTION.
3.0    3.3.11.0   Vishal          08/24/2012     Added alert server SQL inserts for EPG Manager.
3.0    3.3.11.0   Suneeta         08/28/2012     Added indexes for SITES_MSO tables.
3.0    3.3.12.0   Suneeta         08/29/2012     Added indexes for sch_wojob, sch_ruleparameter etc.
3.0    3.3.12.0   Sanjay          08/30/2012     Modified sch_job table name column to 300 chars.
3.0    3.3.13.0   Stephen Zack    09/06/2012     Altered table ME_IDENTIFIER_CRITERIA to add ASSET_TYPE columns.
3.0    3.3.13.0   Suresh Neravati 09/11/2012     Added code for Create cluster DB objects.
3.0    3.3.14.0   Suresh Neravati 09/12/2012     Granted select any dictionary privilage to wfs.
3.0    3.3.14.0   Murtaza         09/19/2012     Added create view permission to wfs to fix ORA-29902 error in executing ODCIIndex.
3.0    3.3.15.0   Bak Ng          09/25/2012     Added new asset type AUDIO to the CMS_LOOKUP_KEY_ASSET_TYPE table.
3.0    3.3.16.0   Mike Petrusis   10/10/2012     Increased the pmm_properties table name column to varchar2(4000).
3.0    3.3.16.0   Suresh Neravati 10/24/2012     db_cluster_instance table dropped and created a view for the cluster database.  
3.0    3.3.17.0   Suresh Neravati 10/26/2012     Added five new indexes on Jbpm tables action, transition and event.
3.0    3.3.17.0   Murtaza Habib   10/26/2012     Added four new indexes on tre tables to fix bug#5620.
3.0    3.3.17.0   Kinjal Mehta    10/26/2012     Requested to add unique constraint unq_cms_assetlist_name on cms_assetlist name column.
3.0    3.3.18.0   Francisco       10/31/2012     Francisco added Business Continuance status alert entries.
3.0    3.3.19.0   Sanjay Kattar   11/05/2012     Dropped constraint FK_SITES_MOH_MSO_ID from SITES_MSO_OVERRIDE_HISTORY table.
3.0    3.3.20.0   Suresh Neravati 11/13/2012     Correction of alert_names.pattern column value for the status for the Business Continuance Status also added 2 indexes onJBPM_VARIABLEINSTANCE table.
3.1    3.4.1.0    Francisco       02/08/2013     Added two new tables CMS_SETTING_GROUP and CMS_SETTING for neptune.
3.1    3.4.1.0    Cherise Ho      02/25/2013     Added two new tables CMS_COMPONENT and CMS_PORTAL_USER_PREFERENCES for neptune.
3.1    3.4.2.0    Cherise Ho      02/28/2013     Changed column width on Width and Height columns of CMS_PORTAL_USER_PREFERENCES.
3.1    3.4.2.0    Murtaza Habib   03/01/2013     Added Query Views for Reporting Purposes. Installs on fresh install OR upgrade.
3.1    3.4.3.0    Anna Simonenko  03/04/2013     Added two new tables SITES_MSO_MTM and SITES_MSO_SITE for SITES MSO. 
3.1    3.4.4.0    Daniel Weiner   03/06/2013     Added a new rules table tre_ruleset_mso.
3.1    3.4.4.0    Murtaza Habib   03/06/2013     Unlock stats on MDM_METADATA table.
3.1    3.4.5.0    Daniel Weiner   03/08/2013     Inserted TRE_PACKAGE record for MSO Override.
3.1    3.4.5.0    Suresh Neravati 03/11/2013     Added a view for TemplatesUsedByTitles report. 
3.1    3.4.5.0    Suresh Neravati 03/11/2013     Added a view for TitlesProcessByTemplate report. 
3.1    3.4.5.0    Suresh Neravati 03/20/2013     Added drop_xml_indexes procedure.
3.1    3.4.6.0    Daniel Weiner   03/29/2013     Removed not null constraint from two columns of sites_mso_override_history table.
3.1    3.4.7.0    Anna Simonenko  04/16/2013     Added new column ASSOCIATED_GROUP_NAME in sites_site table.
3.1    3.4.7.0    Sahil Verma     04/16/2013     Removed the alert records for Duplcates Parameter identifier.
3.1    3.4.7.0    Murtaza Habib   04/17/2013     Added a new xml index asstuniqueness_idx.
3.1    3.4.8.0    Raj             04/18/2013     Requested to modify SITES_DISTSITETITLE and SITES_TRACKSITETITLE tables to flashback archive. 
3.1    3.4.8.0    Suresh Neravati 04/22/2013     Added JPBM_Comments table under partitioning. Called RECREATE_XML_INDEXES in the end for upgrade path.
3.1    3.4.9.0    Daniel Weiner   05/09/2013     Added a new column action_name in sites_mso_override_history table.
3.1    3.4.9.0    Suresh Neravati 05/09/2013     Added a new column createdate in system_settings table.
3.1    3.4.9.0    Murtaza Habib   05/02/2013     Added Package and Package/Movie Custom Fields in structured xmlindex and removed the same from unstructured index.
3.1    3.4.10.0   Murtaza Habib   05/10/2013     Added customfield indexes and removed structured index xpath from unstructured index, removed some xpaths and included in drop parameter proc.
3.1    3.4.10.0   Suresh Neravati 05/14/2013     Added system_settingsupd on system_settings table.
3.1    3.4.11.0   Suresh Neravati 05/16/2013     Added index on REQUEST_ID column of ME_CACHE_RESULT table.
3.1    3.4.11.0   Murtaza Habib   05/20/2013     Modified the timestamp data type to timestamp with time zone and varchar2(100) for few parameter columns in recreate_xml_indexes proc.
3.1    3.4.11.0   Murtaza Habib   05/21/2013     Enabled parallelism on recreate_xml_indexes and added bigfile tablespace
3.1    3.4.11.0   Murtaza Habib   05/23/2013     Moved parallel dbms_stats before noparallel xml indexes.
3.1    3.4.11.0   Murtaza Habib   05/30/2013     Restored unstructured index to older schema for cms3.1, since new xml indexing strategy is being worked on the cms2.5.
3.1    3.4.12.0   Cherise Ho      05/31/2013     Introduced Services role and Services role. 
3.1    3.4.12.0   Eugene          07/03/2013     Added cms_setting records for content management only for fresh installation of database.
================================================================================
*/

CREATE OR REPLACE PACKAGE SYS.CREATEWFSDB AS
  PROCEDURE INSTALL_WFS( ENABLE_PARTITION VARCHAR2 DEFAULT 'FALSE', 
                         SIZE_OF_PARTITION CHAR DEFAULT 'W', 
                         ENABLE_MAX_PARTITION VARCHAR2 DEFAULT 'TRUE', 
                         NUMBER_OF_PARTITIONS NUMBER DEFAULT 10);
  PROCEDURE drop_xml_indexes;
  PROCEDURE recreate_xml_indexes;
  FUNCTION func_check_partiton_size RETURN NUMBER;
  PROCEDURE add_partitions(number_of_partitions NUMBER DEFAULT NULL);
  PROCEDURE set_version(from_version VARCHAR2, to_version VARCHAR2);
  INSTALL_FAILED EXCEPTION;
  VSCHEMA VARCHAR2(100) := 'WFS';
  vsql varchar2(32767);
  db_version varchar2(10):='3.4.12';
END;
/

CREATE OR REPLACE PACKAGE BODY SYS.createWFSDB AS
 
 /* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in install_table*/
  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    execute immediate vsql;
  exception
    when others then
          verrmsg := substr(errmsg ||' '||sqlerrm,1,4000);
          --dbms_output.put_line(verrmsg);
      if upper(mask) != 'Y' then
          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
          commit;
          raise;
      end if;
  END CREATEOBJECT;
  
/* Procedure: SetDbCreateFileDest. Sets the default directory for Oracle datafiles so the path
              need not be given when creating tablespaces. */
  PROCEDURE SETDBCREATEFILEDEST(vpath varchar2) IS
  BEGIN
    execute immediate 'alter system set db_create_file_dest='''||vpath||''' scope=both';
  END SETDBCREATEFILEDEST;

/* Procedure: CreateSeq. Creates a sequence on a primary key of a table.
              Sequence name is <tablename>SEQ.*/
  PROCEDURE CREATESEQ(vtabname varchar2, vstartwith number default 1, vcache number default null) IS
    vcolname dba_cons_columns.column_name%type;
    vsql varchar2(32000);
  BEGIN
    select dcc.column_name 
    into vcolname
    from dba_constraints dc, dba_cons_columns dcc
    where dc.owner=vschema
    and dc.owner = dcc.owner
    and dc.table_name = dcc.table_name
    and dc.table_name=upper(vtabname)
    and dc.constraint_type='P'
    and dc.constraint_name = dcc.constraint_name
    and rownum < 2;
    
		-- Create Sequence for Table
      vsql :=  'CREATE SEQUENCE '||vschema||'.'||substr(vtabname,1,26)||'_SEQ INCREMENT BY 1 START WITH '||vstartwith||' '||CASE WHEN (vcache IS NULL) THEN 'NOCACHE' ELSE 'CACHE '||TO_CHAR(vcache) END;
      CREATEOBJECT(vsql,'Create Sequence'||vtabname||'_SEQ','Y');

    -- Create before insert trigger to populate the PK column  
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||vtabname||'TRG BEFORE INSERT ON '||vschema||'.'||vtabname||' FOR EACH ROW
            BEGIN
              if (:new.'||vcolname||' is null) then
                select '||vschema||'.'||substr(vtabname,1,26)||'_SEQ.nextval into :new.'||vcolname||'  from dual;
              end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'TRG');
   END CREATESEQ;

/* Procedure: CreateUpdTimeTRG. Updates the UpdateTime column with the current date and time when any
              update statement is issued against the table.*/
  PROCEDURE CREATEUPDATETRG(vtabname varchar2) IS
    vcount number := 0;
    vsql varchar2(32000);
  BEGIN
    select count(*)
    into vcount
    from dba_tables dt, dba_tab_columns dtc
    where dt.owner=vschema
    and dt.owner = dtc.owner
    and dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dtc.column_name = 'UPDATEDATE';
    
	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||substr(vtabname,1,26)||'UPD BEFORE UPDATE ON '||vschema||'.'||vtabname||' FOR EACH ROW
            BEGIN
              select systimestamp into :new.updatedate from dual;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

  END CREATEUPDATETRG;

  PROCEDURE set_version(from_version VARCHAR2, to_version VARCHAR2) IS
     wk_message		varchar2(500);
  BEGIN
     EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_SETTINGS SET setting_value='''||to_version||''' WHERE setting_type = ''RELEASE''';  
     EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_RELEASE  SET setting_value='''||to_version||'.0'' WHERE setting_type = ''RELEASE''';  
  EXCEPTION 
     WHEN OTHERS THEN
        wk_message := 'ERROR';
        dbms_output.put_line('convertwfs error:'||SUBSTR(SQLERRM, 1, 500));
        EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                          'Unable update '||vschema||'.SYSTEM_SETTINGS from '||from_version||' to '||to_version||'.0'')';
        EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||SUBSTR(SQLERRM, 1, 500)||''')';
  END set_version;

  PROCEDURE XMLEVOLVE (mask VARCHAR2 DEFAULT 'N') IS
     vsql varchar2(2000);
  BEGIN
     vsql := 'DECLARE
                 wk_message		VARCHAR2(500);
                 err_msg		VARCHAR2(500);
                 xmldiffobj xmltype;
              BEGIN
                 SELECT XMLDIFF( XMLTYPE(BFILENAME(''ECMFXMLDIR'',''ECMFSpec_old.xsd''), NLS_CHARSET_ID(''AL32UTF8'')),
                                 XMLTYPE(BFILENAME(''ECMFXMLDIR'',''ECMFSpec.xsd''), NLS_CHARSET_ID(''AL32UTF8''))
                               ) INTO xmldiffobj
                   FROM DUAL;              
                 DBMS_XMLSCHEMA.INPLACEEVOLVE(
                    SCHEMAURL=>''http://xmlns.oracle.com/xdb/schemas/WFS/ECMFSpec.xsd'',
                    DIFFXML=> xmldiffobj,
                    FLAGS=> dbms_xmlschema.INPLACE_EVOLVE);
              END;';
     CREATEOBJECT(vsql,'Unable to XML Schema Evolve',mask);
  END XMLEVOLVE;  

  PROCEDURE create_copyevolve_proc (v_xslfilename varchar2, mask VARCHAR2 DEFAULT 'N') IS
     vsql VARCHAR2(2000);
  begin
     vsql := 'drop table "WFS.mdm_metadata_evolve"';
     createobject(vsql,'Drop table mdm_metadata_evolve failed','Y');   

     vsql := 'create or replace procedure wfs.xmlcopyevolve authid definer as
              BEGIN
                 EXECUTE IMMEDIATE ''ALTER SESSION SET RECYCLEBIN=OFF'';
                 dbms_xmlschema.copyevolve(
                     SCHEMAURLS => XDB$STRING_LIST_T(''ECMFSpec.xsd''),
                     NEWSCHEMAS => XMLSEQUENCETYPE(xmltype(xmltype(BFILENAME(''ECMFXMLDIR'', ''ECMFSpec.xsd''), NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL())),
                     TRANSFORMS => XMLSEQUENCETYPE(xmltype(xmltype(BFILENAME(''ECMFXMLDIR'', ''ECMFTrans.xsl''), NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL())),
                     PRESERVEOLDDOCS => true,
                     mapTabName => ''WFS.mdm_metadata_evolve'',
                     SCHEMAOWNERS => XDB$STRING_LIST_T(''WFS''),
                     options => DBMS_XMLSCHEMA.COPYEVOLVE_BINARY_XML    
                     );
              END;';
     createobject(vsql,'Unable to create XML Schema Copy Evolve procedure',mask);   
     
  END create_copyevolve_proc;  
  
    FUNCTION func_check_partiton_size return number AS
        TYPE t_long IS TABLE OF LONG;
        v_longarray t_long := t_long();
        hpart_date DATE:=NULL;
        lpart_date DATE:=NULL;
        partition_days NUMBER;  
    BEGIN
         partition_days:=0;
          SELECT high_value 
          BULK COLLECT INTO v_longarray 
           FROM(SELECT high_value 
            FROM dba_tab_partitions 
            WHERE table_name='JBPM_TOKEN' AND partition_name NOT IN ('P_MAX_PART') 
              AND table_owner='WFS'
            ORDER BY partition_position DESC)
            WHERE ROWNUM<3;
            
          IF v_longarray.COUNT >0 THEN
            FOR i IN 1..(v_longarray.COUNT) LOOP
              IF (hpart_date IS NULL) THEN
                hpart_date:=to_date(substr(v_longarray(i),12,10),'YYYY-MM-DD');
              ELSE
                lpart_date:=to_date(substr(v_longarray(i),12,10),'YYYY-MM-DD');
              END IF;
            END LOOP;
            partition_days:=(hpart_date-lpart_date);
          END IF;
          RETURN partition_days;      
    END func_check_partiton_size;
  
    PROCEDURE add_partitions(number_of_partitions NUMBER DEFAULT NULL) AS
      SIZE_OF_PARTITION CHAR(1);
      MAX_PARTITION_EXIST number:=0; 
      STARTDATE DATE;
      WEEK_STARTDATE DATE;
      V_NUMBER_OF_PARTITIONS NUMBER(5);
      v_long LONG;
      VSQL VARCHAR2(4000);
    BEGIN
        SELECT CASE  
                  WHEN func_check_partiton_size = 1 THEN 'D'
                  WHEN func_check_partiton_size = 7 THEN 'W'
                  WHEN func_check_partiton_size > 7 THEN 'M'
                  ELSE 'UNKNOWN'
                END  
           INTO SIZE_OF_PARTITION
           FROM DUAL;
        
           SELECT COUNT(*) INTO MAX_PARTITION_EXIST
             FROM dba_tab_partitions 
            WHERE table_name='JBPM_TOKEN' 
              AND partition_name ='P_MAX_PART'
              AND table_owner='WFS';
        
        IF (NUMBER_OF_PARTITIONS IS NULL) THEN
           SELECT (CASE SIZE_OF_PARTITION
                   WHEN 'D' THEN 365
                   WHEN 'W' THEN 52
                   WHEN 'M' THEN 12
                   END)
             INTO V_NUMBER_OF_PARTITIONS FROM DUAL;
        ELSE
           V_NUMBER_OF_PARTITIONS:=NUMBER_OF_PARTITIONS;
        END IF;
    
        SELECT high_value INTO v_long 
             FROM(SELECT high_value
              FROM dba_tab_partitions 
              WHERE table_name='JBPM_TOKEN' AND partition_name NOT IN ('P_MAX_PART') 
              AND table_owner='WFS'
              ORDER BY partition_position DESC)
              WHERE ROWNUM<2;      
        
        SELECT to_date(substr(v_long,12,10),'YYYY-MM-DD') INTO STARTDATE FROM DUAL;
        SELECT STARTDATE + (1-TO_CHAR(STARTDATE,'D')) INTO WEEK_STARTDATE FROM DUAL;
    
        IF MAX_PARTITION_EXIST = 1 THEN
          IF SIZE_OF_PARTITION='D' THEN
              FOR DY IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
                vsql :='ALTER TABLE WFS.JBPM_TOKEN SPLIT PARTITION "P_MAX_PART" AT (TO_DATE('''||TO_CHAR(STARTDATE+DY,'dd-MON-yyyy')||''',''dd-MON-yyyy'')) INTO (PARTITION P_'||TO_CHAR(STARTDATE+(DY-1),'yyyymmdd')||', PARTITION "P_MAX_PART")';
                dbms_output.put_line('ADDED PARTITION P_'||TO_CHAR(STARTDATE+(DY-1),'yyyymmdd')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(STARTDATE+DY,'dd-MON-yyyy')||''',''dd-MON-yyyy''))');
                EXECUTE IMMEDIATE VSQL;            
              END LOOP;
            ELSIF SIZE_OF_PARTITION='W' THEN
              FOR WK IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
                vsql :='ALTER TABLE WFS.JBPM_TOKEN SPLIT PARTITION "P_MAX_PART" AT (TO_DATE('''||TO_CHAR(WEEK_STARTDATE+(WK*7),'dd-MON-yyyy')||''',''dd-MON-yyyy'')) INTO (PARTITION P_'||TO_CHAR(WEEK_STARTDATE+(WK*7),'yyyyww')||', PARTITION "P_MAX_PART")';
                dbms_output.put_line('ADDED PARTITION P_'||TO_CHAR(WEEK_STARTDATE+(WK*7),'yyyyww')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(WEEK_STARTDATE+(WK*7),'dd-MON-yyyy')||''',''dd-MON-yyyy''))');
                EXECUTE IMMEDIATE VSQL;            
              END LOOP;
            ELSIF SIZE_OF_PARTITION='M' THEN
              FOR MN IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
                vsql :='ALTER TABLE WFS.JBPM_TOKEN SPLIT PARTITION "P_MAX_PART" AT (TO_DATE('''||TO_CHAR(add_months(to_date('01'||to_char(STARTDATE,'MMYYYY'),'DDMMYYYY'), mn),'dd-MON-yyyy')||''',''dd-MON-yyyy'')) INTO (PARTITION P_'||to_char(add_months(STARTDATE, mn-1),'yyyymm')||', PARTITION "P_MAX_PART")';
                dbms_output.put_line('ADDED PARTITION P_'||to_char(add_months(STARTDATE, mn-1),'yyyymm')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(add_months(to_date('01'||to_char(STARTDATE,'MMYYYY'),'DDMMYYYY'), mn),'dd-MON-yyyy')||''',''dd-MON-yyyy''))');
                EXECUTE IMMEDIATE VSQL;
              END LOOP;
            END IF;
         ELSE
            IF SIZE_OF_PARTITION='D' THEN
              FOR DY IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
                vsql :='ALTER TABLE WFS.JBPM_TOKEN ADD PARTITION P_'||TO_CHAR(STARTDATE+(DY-1),'yyyymmdd')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(STARTDATE+DY,'dd-MON-yyyy')||''',''dd-MON-yyyy''))';
                dbms_output.put_line('ADDED PARTITION P_'||TO_CHAR(STARTDATE+(DY-1),'yyyymmdd')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(STARTDATE+DY,'dd-MON-yyyy')||''',''dd-MON-yyyy''))');
                EXECUTE IMMEDIATE VSQL;            
              END LOOP;
            ELSIF SIZE_OF_PARTITION='W' THEN
              FOR WK IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
                VSQL := 'ALTER TABLE WFS.JBPM_TOKEN ADD PARTITION P_'||TO_CHAR(WEEK_STARTDATE+(WK*7),'yyyyww')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(WEEK_STARTDATE+(WK*7),'dd-MON-yyyy')||''',''dd-MON-yyyy''))';
                dbms_output.put_line('ADDED PARTITION P_'||TO_CHAR(WEEK_STARTDATE+(WK*7),'yyyyww')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(WEEK_STARTDATE+(WK*7),'dd-MON-yyyy')||''',''dd-MON-yyyy''))');
                EXECUTE IMMEDIATE VSQL;            
              END LOOP;
            ELSIF SIZE_OF_PARTITION='M' THEN
              FOR MN IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
                VSQL := 'ALTER TABLE WFS.JBPM_TOKEN ADD PARTITION P_'||to_char(add_months(STARTDATE, mn-1),'yyyymm')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(add_months(to_date('01'||to_char(STARTDATE,'MMYYYY'),'DDMMYYYY'), mn),'dd-MON-yyyy')||''',''dd-MON-yyyy''))';
                dbms_output.put_line('ADDED PARTITION P_'||to_char(add_months(STARTDATE, mn-1),'yyyymm')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(add_months(to_date('01'||to_char(STARTDATE,'MMYYYY'),'DDMMYYYY'), mn),'dd-MON-yyyy')||''',''dd-MON-yyyy''))');
                EXECUTE IMMEDIATE VSQL;            
              END LOOP;
            END IF;
         END IF;
    END add_partitions;
	/************************************************************************************************
  ----------------------------------------CREATE WFS PARTITION-------------------------------------
  *************************************************************************************************/
		PROCEDURE CREATEWFSPARTITION (SIZE_OF_PARTITION CHAR, ENABLE_MAX_PARTITION VARCHAR2, NUMBER_OF_PARTITIONS NUMBER) IS 
		  STARTDATE DATE;
		  WEEK_STARTDATE DATE;
      V_NUMBER_OF_PARTITIONS NUMBER;
		BEGIN
          IF ENABLE_MAX_PARTITION='TRUE' THEN
             SELECT (CASE SIZE_OF_PARTITION
                      WHEN 'D' THEN 365
                      WHEN 'W' THEN 52
                      WHEN 'M' THEN 12
                    END)
              INTO V_NUMBER_OF_PARTITIONS FROM DUAL;
          ELSE
             V_NUMBER_OF_PARTITIONS:=NUMBER_OF_PARTITIONS;
          END IF;
          
          SELECT SYSDATE INTO STARTDATE FROM DUAL;
          SELECT STARTDATE + (1-TO_CHAR(STARTDATE,'D')) INTO WEEK_STARTDATE FROM DUAL;
    /*------------------------------------------------------------------
									CREATE WFS PARTITION TABLES
			------------------------------------------------------------------*/
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_TOKEN ( 
          ID_                      	NUMBER(19,0) NOT NULL,
          VERSION_                 	NUMBER NOT NULL,
          NAME_                    	VARCHAR2(255) NULL,
          START_                   	TIMESTAMP(6) NULL,
          END_                     	TIMESTAMP(6) NULL,
          NODEENTER_               	TIMESTAMP(6) NULL,
          NEXTLOGINDEX_            	NUMBER NULL,
          ISABLETOREACTIVATEPARENT_	NUMBER NULL,
          ISTERMINATIONIMPLICIT_   	NUMBER NULL,
          ISSUSPENDED_             	NUMBER NULL,
          NODE_                    	NUMBER(19,0) NULL,
          PROCESSINSTANCE_         	NUMBER(19,0) NULL,
          PARENT_                  	NUMBER(19,0) NULL,
          SUBPROCESSINSTANCE_      	NUMBER(19,0) NULL,
          TOKENTYPEID              	NUMBER NOT NULL,
          OPERATIONALSTATUS      	  NUMBER(19,0) NULL,
          ADMINISTRATIVESTATUS   	  NUMBER(19,0) NULL,
          RETRYCOUNT                NUMBER DEFAULT 0 NOT NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TOKEN PRIMARY KEY (ID_) using index (create unique index '||vschema||'.PK_JBPM_TOKEN on '||vschema||'.JBPM_TOKEN(ID_) initrans 100)
          ) initrans 100';
      vsql := vsql||' PARTITION BY RANGE (CREATEDATE) '||chr(10)||'('; 
      IF SIZE_OF_PARTITION='D' THEN
        FOR DY IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
          vsql := vsql||' PARTITION P_'||TO_CHAR(STARTDATE+(DY-1),'yyyymmdd')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(STARTDATE+DY,'dd-MON-yyyy')||''',''dd-MON-yyyy'')),'||chr(10);
        END LOOP;
      ELSIF SIZE_OF_PARTITION='W' THEN
        FOR WK IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
          VSQL := VSQL||' PARTITION P_'||TO_CHAR(WEEK_STARTDATE+(WK*7),'yyyyww')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(WEEK_STARTDATE+(WK*7),'dd-MON-yyyy')||''',''dd-MON-yyyy'')),'||CHR(10);
        END LOOP;
      ELSIF SIZE_OF_PARTITION='M' THEN
        FOR MN IN 1 .. V_NUMBER_OF_PARTITIONS LOOP
          VSQL := VSQL||' PARTITION P_'||to_char(add_months(STARTDATE, mn-1),'yyyymm')||' VALUES LESS THAN (TO_DATE('''||TO_CHAR(add_months(to_date('01'||to_char(STARTDATE,'MMYYYY'),'DDMMYYYY'), mn),'dd-MON-yyyy')||''',''dd-MON-yyyy'')),'||CHR(10);
        end loop;
      END IF;
      IF (UPPER(ENABLE_MAX_PARTITION)='TRUE') THEN
        vsql := vsql||'PARTITION P_MAX_PART VALUES  LESS THAN (MAXVALUE) '||chr(10);
      ELSE
        SELECT SUBSTR(VSQL,1,LENGTH(VSQL)-2) INTO VSQL FROM DUAL;
      END IF;
      vsql := vsql||')ENABLE ROW MOVEMENT';
      
      CREATEOBJECT(vsql,'Unable to create table JBPM_TOKEN');
      CREATESEQ('JBPM_TOKEN',3,vcache=>100);
      CREATEUPDATETRG('JBPM_TOKEN');

    -- Creating Index IDX_JBPM_TOKEN_01
       vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_TOKEN_01 ON '||vschema||'.JBPM_TOKEN(PARENT_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKEN_01');

    -- Creating Index IDX_JBPM_TOKEN_02
       vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_TOKEN_02 ON '||vschema||'.JBPM_TOKEN(NODE_) initrans 100 LOCAL';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_TOKEN_02');
      
    -- creating table JBPM_PROCESSINSTANCE
    /* Partition: Child Table 1*/
    vsql :=  'CREATE TABLE '||vschema||'.JBPM_PROCESSINSTANCE ( 
          ID_                          	NUMBER(19,0) NOT NULL,
          VERSION_                     	NUMBER NOT NULL,
          START_                       	TIMESTAMP(6) NULL,
          END_                         	TIMESTAMP(6) NULL,
          ISSUSPENDED_                 	NUMBER NULL,
          PROCESSDEFINITION_           	NUMBER(19,0) NULL,
          ROOTTOKEN_                   	NUMBER(19,0) NOT NULL,
          SUPERPROCESSTOKEN_           	NUMBER(19,0) NULL,
          ADMINISTRATIVEPROCESSSTATUSID	NUMBER NOT NULL,
          OPERATIONALPROCESSSTATUSID   	NUMBER NOT NULL,
          PROCESSINSTANCETYPEID        	NUMBER NOT NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          PROCESSPRIORITYID            	NUMBER NULL,
          ISACTIVE                     	NUMBER(1,0) DEFAULT (1) NOT NULL,
          CONSTRAINT PK_JBPM_PROCESSINSTANCE PRIMARY KEY (ID_) using index (create unique index '||vschema||'.PK_JBPM_PROCESSINSTANCE on '||vschema||'.JBPM_PROCESSINSTANCE(ID_) initrans 100),
          CONSTRAINT JBPM_PINSTANCE#JBPM_TOKEN2 FOREIGN KEY (ROOTTOKEN_) REFERENCES '||vschema||'.JBPM_TOKEN (ID_)
          ) initrans 100
          PARTITION BY REFERENCE(JBPM_PINSTANCE#JBPM_TOKEN2) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table JBPM_PROCESSINSTANCE');
      CREATESEQ('JBPM_PROCESSINSTANCE',3,vcache=>100);
      CREATEUPDATETRG('JBPM_PROCESSINSTANCE');
    
    -- Creating index IDX_JBPM_PROCESSINSTANCE_01
       vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_PROCESSINSTANCE_01 ON '||vschema||'.JBPM_PROCESSINSTANCE(PROCESSDEFINITION_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSINSTANCE_01');
      
    -- Creating index  IDX_PI_OPERATIONALSTATUSID
       vsql :=  'CREATE INDEX '||vschema||'.IDX_PI_OPERATIONALSTATUSID ON '||vschema||'.JBPM_PROCESSINSTANCE(OPERATIONALPROCESSSTATUSID) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_PI_OPERATIONALSTATUSID');

    -- Creating index  IDX_PI_OPERATIONALSTATUSID
       VSQL :=  'CREATE INDEX '||vschema||'.IDX_JBPMPROCINST_ROOTTOKEN ON '||vschema||'.JBPM_PROCESSINSTANCE(ROOTTOKEN_) initrans 100 LOCAL';      
       CREATEOBJECT(VSQL,'Unable to create index IDX_JBPMPROCINST_ROOTTOKEN');


    -- creating table JBPM_VARIABLEINSTANCE
    /* Partition: Child Table 2*/
    vsql :=  'CREATE TABLE '||vschema||'.JBPM_VARIABLEINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          CONVERTER_       	CHAR(1) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          TOKENVARIABLEMAP_	NUMBER(19,0) NULL,
          PROCESSINSTANCE_ 	NUMBER(19,0) NOT NULL,
          BYTEARRAYVALUE_  	NUMBER(19,0) NULL,
          DATEVALUE_       	TIMESTAMP(6) NULL,
          DOUBLEVALUE_     	FLOAT NULL,
          LONGIDCLASS_     	VARCHAR2(255) NULL,
          LONGVALUE_       	NUMBER(19,0) NULL,
          STRINGIDCLASS_   	VARCHAR2(255) NULL,
          STRINGVALUE_     	VARCHAR2(4000) NULL,
          TASKINSTANCE_    	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_VARIABLEINSTANCE PRIMARY KEY (ID_) using index (create unique index '||vschema||'.PK_JBPM_VARIABLEINSTANCE on '||vschema||'.JBPM_VARIABLEINSTANCE(ID_) initrans 100),
          CONSTRAINT FK_VARINST_PROCESSINST FOREIGN KEY (PROCESSINSTANCE_) REFERENCES '||vschema||'.JBPM_PROCESSINSTANCE(ID_)
          ) initrans 100
          PARTITION BY REFERENCE(FK_VARINST_PROCESSINST) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table JBPM_VARIABLEINSTANCE');
      CREATESEQ('JBPM_VARIABLEINSTANCE',vcache=>100);
      CREATEUPDATETRG('JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_VARIABLEINSTANCE_01 ON '||vschema||'.JBPM_VARIABLEINSTANCE (NAME_, STRINGVALUE_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE
      vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_VARIABLEINSTANCE_02 ON '||vschema||'.JBPM_VARIABLEINSTANCE (PROCESSINSTANCE_) initrans 100 LOCAL';
      CREATEOBJECT(VSQL,'Unable to index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE');
      
    -- Create Index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_VARIABLEINSTANCE_03 ON '||vschema||'.JBPM_VARIABLEINSTANCE(TASKINSTANCE_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_VARIABLEINSTANCE_04 ON '||vschema||'.JBPM_VARIABLEINSTANCE(TOKENVARIABLEMAP_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE');

      vsql := 'CREATE INDEX '||vschema||'.idx_jbpm_vinstance_strval on  '||vschema||'.JBPM_VARIABLEINSTANCE(STRINGVALUE_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_strval'); 

      vsql := 'CREATE INDEX '||vschema||'.idx_jbpm_vinstance_longval ON '||vschema||'.JBPM_VARIABLEINSTANCE(LONGVALUE_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_longval'); 

    -- creating table JBPM_MODULEINSTANCE
    /* Partition: Child Table 3*/    
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_MODULEINSTANCE ( 
          ID_                	NUMBER(19,0) NOT NULL,
          CLASS_             	CHAR(1) NOT NULL,
          PROCESSINSTANCE_   	NUMBER(19,0) NOT NULL,
          TASKMGMTDEFINITION_	NUMBER(19,0) NULL,
          NAME_              	VARCHAR2(255) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_MODULEINSTANCE PRIMARY KEY (ID_)  using index (create unique index '||vschema||'.PK_JBPM_MODULEINSTANCE on '||vschema||'.JBPM_MODULEINSTANCE(ID_) initrans 100),
          CONSTRAINT FK_MODINST_PROCESSINST FOREIGN KEY (PROCESSINSTANCE_) REFERENCES '||vschema||'.JBPM_PROCESSINSTANCE (ID_) 
          ) initrans 100
          PARTITION BY REFERENCE(FK_MODINST_PROCESSINST) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table JBPM_MODULEINSTANCE');
      CREATESEQ('JBPM_MODULEINSTANCE',vcache=>100);
      CREATEUPDATETRG('JBPM_MODULEINSTANCE');

    -- Creating index IDX_JBPM_MODULEINSTANCE_01
       vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_MODULEINSTANCE_01 ON '||vschema||'.JBPM_MODULEINSTANCE(PROCESSINSTANCE_)  initrans 100 LOCAL';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_MODULEINSTANCE_01');

    -- creating table JBPM_TOKENVARIABLEMAP
    /* Partition: Child Table 4*/   
    vsql :=  'CREATE TABLE '||vschema||'.JBPM_TOKENVARIABLEMAP ( 
          ID_             	NUMBER(19,0) NOT NULL,
          TOKEN_          	NUMBER(19,0) NOT NULL,
          CONTEXTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TOKENVARIABLEMAP PRIMARY KEY (ID_) using index (create unique index '||vschema||'.PK_JBPM_TOKENVARIABLEMAP on '||vschema||'.JBPM_TOKENVARIABLEMAP(ID_) initrans 100),
          CONSTRAINT FK_TOKVARMAP_JBPMTOK FOREIGN KEY (TOKEN_) REFERENCES '||vschema||'.JBPM_TOKEN (ID_)
          ) initrans 100
          PARTITION BY REFERENCE(FK_TOKVARMAP_JBPMTOK) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TOKENVARIABLEMAP');
      CREATESEQ('JBPM_TOKENVARIABLEMAP',vcache=>100);
      CREATEUPDATETRG('JBPM_TOKENVARIABLEMAP');
      
    -- Creating index IDX_JBPM_TOKENVARIABLEMAP_01
      vsql :=  'CREATE INDEX '||vschema||'.IDX_JBPM_TOKENVARIABLEMAP_01 ON '||vschema||'.JBPM_TOKENVARIABLEMAP(CONTEXTINSTANCE_) initrans 100 LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKENVARIABLEMAP_01');

      VSQL :=  'CREATE INDEX '||VSCHEMA||'.IDX_JBPMTOKVARMAP_TOK ON '||VSCHEMA||'.JBPM_TOKENVARIABLEMAP(TOKEN_) initrans 100 LOCAL';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPMTOKVARMAP_TOK');
      
    -- creating table JBPM_LOG
    /* Partition: Child Table 5*/       
       vsql :=  'CREATE TABLE '||vschema||'.JBPM_LOG ( 
          ID_                   	NUMBER(19,0) NOT NULL,
          CLASS_                	CHAR(1) NOT NULL,
          INDEX_                	NUMBER NULL,
          DATE_                 	TIMESTAMP(6) NULL,
          TOKEN_                	NUMBER(19,0) NOT NULL,
          PARENT_               	NUMBER(19,0) NULL,
          MESSAGE_              	VARCHAR2(4000) NULL,
          EXCEPTION_            	VARCHAR2(4000) NULL,
          ACTION_               	NUMBER(19,0) NULL,
          NODE_                 	NUMBER(19,0) NULL,
          ENTER_                	TIMESTAMP(6) NULL,
          LEAVE_                	TIMESTAMP(6) NULL,
          DURATION_             	NUMBER(19,0) NULL,
          TRANSITION_           	NUMBER(19,0) NULL,
          CHILD_                	NUMBER(19,0) NULL,
          SOURCENODE_           	NUMBER(19,0) NULL,
          DESTINATIONNODE_      	NUMBER(19,0) NULL,
          VARIABLEINSTANCE_     	NUMBER(19,0) NULL,
          OLDBYTEARRAY_         	NUMBER(19,0) NULL,
          NEWBYTEARRAY_         	NUMBER(19,0) NULL,
          OLDDATEVALUE_         	TIMESTAMP(6) NULL,
          NEWDATEVALUE_         	TIMESTAMP(6) NULL,
          OLDDOUBLEVALUE_       	FLOAT NULL,
          NEWDOUBLEVALUE_       	FLOAT NULL,
          OLDLONGIDCLASS_       	VARCHAR2(255) NULL,
          OLDLONGIDVALUE_       	NUMBER(19,0) NULL,
          NEWLONGIDCLASS_       	VARCHAR2(255) NULL,
          NEWLONGIDVALUE_       	NUMBER(19,0) NULL,
          OLDSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          OLDSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          NEWSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          NEWSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          OLDLONGVALUE_         	NUMBER(19,0) NULL,
          NEWLONGVALUE_         	NUMBER(19,0) NULL,
          OLDSTRINGVALUE_       	VARCHAR2(4000) NULL,
          NEWSTRINGVALUE_       	VARCHAR2(4000) NULL,
          TASKINSTANCE_         	NUMBER(19,0) NULL,
          TASKACTORID_          	VARCHAR2(255) NULL,
          TASKOLDACTORID_       	VARCHAR2(255) NULL,
          SWIMLANEINSTANCE_     	NUMBER(19,0) NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NULL,
          RESOURCEID            	NUMBER NULL,
          OPERATIONALSTATUSID   	NUMBER NULL,
          ADMINISTRATIVESTATUSID	NUMBER NULL,
          CONSTRAINT PK_JBPM_LOG PRIMARY KEY (ID_) using index (create unique index '||vschema||'.PK_JBPM_LOG on '||vschema||'.JBPM_LOG(ID_) initrans 100),
          CONSTRAINT FK_JBPMLOG_JBTOK FOREIGN KEY (TOKEN_) REFERENCES '||vschema||'.JBPM_TOKEN (ID_) 
          ) initrans 100
          PARTITION BY REFERENCE(FK_JBPMLOG_JBTOK) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table JBPM_LOG');
      CREATESEQ('JBPM_LOG',vcache=>100);
      CREATEUPDATETRG('JBPM_LOG');

      -- Composite index for improving performance of Dash Board queries
      VSQL :=  'CREATE INDEX '||VSCHEMA||'.IDX_JBPM_PI_COMP ON '||VSCHEMA||'.JBPM_PROCESSINSTANCE( START_, PROCESSINSTANCETYPEID, ISACTIVE, PROCESSDEFINITION_,ID_ , OPERATIONALPROCESSSTATUSID) initrans 100 LOCAL';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPMTOKVARMAP_TOK');

        -- creating table TTV_MESSAGELOG
       vsql :=  'CREATE TABLE '||VSCHEMA||'.TTV_MESSAGELOG ( 
          MESSAGELOGID   	NUMBER(19,0) NOT NULL,
          LOGID          	NUMBER(19,0) NOT NULL,
          TYPE           	VARCHAR2(16) NOT NULL,
          MESSAGEUID     	VARCHAR2(16) NOT NULL,
          NAME           	VARCHAR2(64) NULL,
          ISINCOMING     	NUMBER(1,0) NOT NULL,
          MESSAGE        	VARCHAR2(4000) NOT NULL,
          RESOURCEID     	NUMBER NULL,
          MESSAGEDATETIME	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MESSAGELOG PRIMARY KEY (MESSAGELOGID),
          CONSTRAINT TTV_MESSAGELOG#JBPM_LOG FOREIGN KEY (LOGID) REFERENCES '||VSCHEMA||'.JBPM_LOG (ID_)
          )
          PARTITION BY REFERENCE(TTV_MESSAGELOG#JBPM_LOG) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table TTV_MESSAGELOG');
      CREATESEQ('TTV_MESSAGELOG');
      CREATEUPDATETRG('TTV_MESSAGELOG');

    -- Creating Index on TTV_MESSAGELOG (LOGID)
       vsql :=  'CREATE INDEX '||VSCHEMA||'.IDX_TTV_MESSAGELOG_01 ON '||VSCHEMA||'.TTV_MESSAGELOG (LOGID) LOCAL';
      CREATEOBJECT(VSQL,'Unable to create Index on TTV_MESSAGELOG');
/*
    -- Removed as per Sahil.
    -- creating table TTV_TOKENRESOURCE
       vsql :=  'CREATE TABLE '||VSCHEMA||'.TTV_TOKENRESOURCE ( 
          TOKENID                   	NUMBER(19,0) NOT NULL,
          RESOURCEID                	NUMBER NOT NULL,
          RESOURCEUSAGESTARTDATETIME	TIMESTAMP(6) NOT NULL,
          CREATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID           	NUMBER NOT NULL,
          CONSTRAINT PK_TTV_TOKENRESOURCE PRIMARY KEY (TOKENID),
          CONSTRAINT TTV_TOKENRESOURCE#JBPM_TOKEN FOREIGN KEY (TOKENID) REFERENCES '||VSCHEMA||'.JBPM_TOKEN (ID_)
          )
          PARTITION BY REFERENCE(TTV_TOKENRESOURCE#JBPM_TOKEN) ENABLE ROW MOVEMENT';
      CREATEOBJECT(VSQL,'Unable to create table TTV_TOKENRESOURCE');
      CREATEUPDATETRG('TTV_TOKENRESOURCE');

    -- creating table TTV_RESOURCEGROUPQUEUEITEM
       vsql :=  'CREATE TABLE '||VSCHEMA||'.TTV_RESOURCEGROUPQUEUEITEM ( 
          RESOURCEGROUPQUEUEITEMID	NUMBER NOT NULL,
          RESOURCEGROUPID         	NUMBER NOT NULL,
          QUEUEORDER              	NUMBER NOT NULL,
          TOKENID                 	NUMBER(19,0) NOT NULL,
          ALLOCATIONKEY 				    VARCHAR2(255) NULL,
          CREATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEGROUPQUEUEITEM PRIMARY KEY (RESOURCEGROUPQUEUEITEMID),
          CONSTRAINT TTV_RGROUPQUEUEITEM#JBPM_TOKEN FOREIGN KEY (TOKENID) REFERENCES '||VSCHEMA||'.JBPM_TOKEN (ID_)
          )
          PARTITION BY REFERENCE(TTV_RGROUPQUEUEITEM#JBPM_TOKEN) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUPQUEUEITEM');
      CREATESEQ('TTV_RESOURCEGROUPQUEUEITEM');
      CREATEUPDATETRG('TTV_RESOURCEGROUPQUEUEITEM');

    -- creating table TTV_RESOURCEUSAGEHISTORY
       vsql :=  'CREATE TABLE '||VSCHEMA||'.TTV_RESOURCEUSAGEHISTORY ( 
          RESOURCEUSAGEHISTORYID	NUMBER NOT NULL,
          RESOURCEID            	NUMBER NOT NULL,
          PROCESSINSTANCEID     	NUMBER(19,0) NOT NULL,
          NODEID                	NUMBER(19,0) NOT NULL,
          STARTDATETIME         	TIMESTAMP(6) NOT NULL,
          ENDDATETIME           	TIMESTAMP(6) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEUSAGEHISTORY PRIMARY KEY (RESOURCEUSAGEHISTORYID),
          CONSTRAINT TTV_RUSAGEHIST#JBPM_PINSTANCE FOREIGN KEY (PROCESSINSTANCEID) REFERENCES '||VSCHEMA||'.JBPM_PROCESSINSTANCE (ID_)
          )
          PARTITION BY REFERENCE(TTV_RUSAGEHIST#JBPM_PINSTANCE) ENABLE ROW MOVEMENT';
      CREATEOBJECT(VSQL,'Unable to create table TTV_RESOURCEUSAGEHISTORY');
      CREATESEQ('TTV_RESOURCEUSAGEHISTORY');      

*/
    -- creating table TTV_PROCESSINSTANCENOTE
       vsql :=  'CREATE TABLE '||VSCHEMA||'.TTV_PROCESSINSTANCENOTE ( 
          PROCESSINSTANCENOTEID	NUMBER NOT NULL,
          PROCESSINSTANCEID    	NUMBER NOT NULL,
          NOTE                 	VARCHAR2(4000) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSINSTANCENOTE PRIMARY KEY (PROCESSINSTANCENOTEID),
          CONSTRAINT TTV_PINSTANCENOTE#JBPM_PINST FOREIGN KEY (PROCESSINSTANCEID) REFERENCES '||VSCHEMA||'.JBPM_PROCESSINSTANCE (ID_)
          )
          PARTITION BY REFERENCE(TTV_PINSTANCENOTE#JBPM_PINST) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSINSTANCENOTE');
      CREATESEQ('TTV_PROCESSINSTANCENOTE');
      CREATEUPDATETRG('TTV_PROCESSINSTANCENOTE');

    -- Creating Index IDX_TTV_PROCESSINSTANCENOTE_01
       VSQL :=  'CREATE INDEX '||VSCHEMA||'.IDX_TTV_PROCESSINSTANCENOTE_01 ON '||VSCHEMA||'.TTV_PROCESSINSTANCENOTE(PROCESSINSTANCEID) LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_TTV_PROCESSINSTANCENOTE_01');
      
    -- creating table JBPM_TASKINSTANCE
       vsql :=  'CREATE TABLE '||VSCHEMA||'.JBPM_TASKINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          DESCRIPTION_     	VARCHAR2(4000) NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          CREATE_          	TIMESTAMP(6) NULL,
          START_           	TIMESTAMP(6) NULL,
          END_             	TIMESTAMP(6) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          PRIORITY_        	NUMBER NULL,
          ISCANCELLED_     	NUMBER NULL,
          ISSUSPENDED_     	NUMBER NULL,
          ISOPEN_          	NUMBER NULL,
          ISSIGNALLING_    	NUMBER NULL,
          ISBLOCKING_      	NUMBER NULL,
          TASK_            	NUMBER(19,0) NULL,
          TOKEN_           	NUMBER(19,0) NOT NULL,
          SWIMLANINSTANCE_ 	NUMBER(19,0) NULL,
          TASKMGMTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TASKINSTANCE PRIMARY KEY (ID_),
          CONSTRAINT JBPM_TINST#JBPM_TOKEN FOREIGN KEY (TOKEN_) REFERENCES '||VSCHEMA||'.JBPM_TOKEN(ID_)
          )
          PARTITION BY REFERENCE(JBPM_TINST#JBPM_TOKEN) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASKINSTANCE');
      CREATESEQ('JBPM_TASKINSTANCE');
      CREATEUPDATETRG('JBPM_TASKINSTANCE');

    -- Creating index IX_JBPM_TASKINSTANCE_1
       vsql :=  'CREATE INDEX '||VSCHEMA||'.IX_JBPM_TASKINSTANCE_1 ON '||VSCHEMA||'.JBPM_TASKINSTANCE(ACTORID_) LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IX_JBPM_TASKINSTANCE_1');
    
    -- Creating index IDX_JBPM_TASKINSTANCE_02
       vsql :=  'CREATE INDEX '||VSCHEMA||'.IDX_JBPM_TASKINSTANCE_02 ON '||VSCHEMA||'.JBPM_TASKINSTANCE(TASKMGMTINSTANCE_) LOCAL';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_TASKINSTANCE_02');
  
    -- Creating index IDX_JBPM_TASKINSTANCE_03
       VSQL :=  'CREATE INDEX '||VSCHEMA||'.IDX_JBPM_TASKINSTANCE_03 ON '||VSCHEMA||'.JBPM_TASKINSTANCE(TOKEN_) LOCAL';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_TASKINSTANCE_03');

    -- Since Sahil requested to add JBPM_COMMENTS table to purge script, this table also needs partitioning.       
    -- creating table JBPM_COMMENT
       vsql :=  'CREATE TABLE '||VSCHEMA||'.JBPM_COMMENT ( 
          ID_               	NUMBER(19,0) NOT NULL,
          VERSION_          	NUMBER NOT NULL,
          ACTORID_          	VARCHAR2(255) NULL,
          TIME_             	TIMESTAMP(6) NULL,
          MESSAGE_          	VARCHAR2(4000) NULL,
          TOKEN_            	NUMBER(19,0) NOT NULL,
          TASKINSTANCE_     	NUMBER(19,0) NULL,
          TOKENINDEX_       	NUMBER NULL,
          TASKINSTANCEINDEX_	NUMBER NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_COMMENT PRIMARY KEY (ID_),
          CONSTRAINT JBPM_COMMENT#JBPM_TOKEN FOREIGN KEY (TOKEN_) REFERENCES '||VSCHEMA||'.JBPM_TOKEN(ID_)
          )
          PARTITION BY REFERENCE(JBPM_COMMENT#JBPM_TOKEN) ENABLE ROW MOVEMENT';
      CREATEOBJECT(vsql,'Unable to create table JBPM_COMMENT');
      CREATESEQ('JBPM_COMMENT');
      CREATEUPDATETRG('JBPM_COMMENT');
      
    -- Creating index IDX_JBPM_COMMENT_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_COMMENT_01 ON WFS.JBPM_COMMENT(TOKEN_) LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_01');

    -- Creating index IDX_JBPM_COMMENT_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_COMMENT_02 ON WFS.JBPM_COMMENT (TASKINSTANCE_) LOCAL';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_02');
      
      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of WFS Partition Tables COMPLETED SUCCESSFULLY'')';
           
		END CREATEWFSPARTITION;

  PROCEDURE CREATEWFS(ENABLE_PARTITION VARCHAR2 DEFAULT 'FALSE',
                      SIZE_OF_PARTITION  CHAR DEFAULT 'W', 
                      ENABLE_MAX_PARTITION VARCHAR2 DEFAULT 'TRUE',
                      NUMBER_OF_PARTITIONS NUMBER DEFAULT 10) IS
  /*  
          Created By:  	Larry Roberts 12/14/2006
          Create Reason: 	Create WFS tables, sequences,triggers,views,etc
                          To create all objects in another schema beside WFS change 
                          WFS to another schema name prior to compiling and 
                          executing this procedure
          Note:		When run, this procedure will log any error message into the 
                          install_table and exit.
          Updated By:     Chris Scherlacher 8/15/2007
          Update Reason:  Updated create procedure for the WP 2.5 changes
          Updated By: 	  Daniel Weiner 6/27/2008
          Update Reason:  Added in better error handling, starting integration of PMM with the rest
          					  of the WFS scripts.
          Updated By: 	  Murtaza Habib 09/22/2008
          Update Reason:  Made the script more readable by creating modular functions/procedures.
          
  */
  
          vsql varchar2(32000);
          wk_database_path	varchar2(100);
          wk_message		varchar2(500);
          err_msg		varchar2(500);
          wk_count		number := 0;
          wk_instancename	v$instance.instance_name%type;
  
  BEGIN
          wk_message := '';
  
  /* 
  ------------------------------------
      CREATE USERS
  ------------------------------------
  */
  
    -- Drop the install_table
    vsql:='Drop table sys.install_table';
		CREATEOBJECT(vsql,'DROP INSTALL_TABLE','Y');
      
    
    -- Create Install_table
    vsql:='CREATE TABLE sys.install_table (msgdate date default sysdate, install_message varchar2(4000))';
		CREATEOBJECT(vsql,'CREATE SYS.INSTALL_TABLE');
--  
--      EXECUTE IMMEDIATE 'CREATE TABLE install_table (install_message varchar2(500))';
/*      
      -- Verify the WFS user does not exist
    BEGIN
    
      SELECT count(*)
      INTO wk_count
      FROM all_users
      WHERE username = 'WFS';
      
    END;
    
    IF wk_count < 20 THEN
    
      wk_message := 'ERROR';
      EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (sysdate,''error in installing of application database objects:  
            The WFS user already exists.'')';
  		EXECUTE IMMEDIATE 'INSERT INTO install_table values (sysdate,'''||err_msg||''')';
      GOTO bypass_install;
     
    END IF; 
*/  
    /* ------ DATAREADERROLE Role ----- */
  
    --- Create the DATAREADERROLE
	
	DECLARE
		readerRoleExists NUMBER;
    BEGIN		
	  --EXECUTE IMMEDIATE 'CREATE ROLE DATAREADERROLE NOT IDENTIFIED';
      SELECT COUNT(*) INTO readerRoleExists  FROM DBA_Roles WHERE ROLE = 'DATAREADERROLE';
      IF (readerRoleExists<1) THEN
        vsql:='CREATE ROLE DATAREADERROLE';
        CREATEOBJECT(vsql,'Unable to create the DATAREADERFOLE');
      END IF;
    END;
  
    vsql:='GRANT CONNECT TO DATAREADERROLE';
    CREATEOBJECT(vsql,'Unable to grant CONNECT to the DATAREADERROLE role.');

    vsql:='GRANT CREATE SESSION TO DATAREADERROLE';
    CREATEOBJECT(vsql,'Unable to grant SESSION to the DATAREADERROLE.');
    
    vsql:='GRANT SELECT ANY TABLE TO DATAREADERROLE';
    CREATEOBJECT(vsql,'Unable to grant SELECT ANY TABLE to the DATAREADERROLE');
  
    --- Create the DATAWRITERROLE
	DECLARE
      writerRoleExists NUMBER;
    BEGIN
       SELECT COUNT(*) INTO writerRoleExists  FROM DBA_Roles WHERE ROLE = 'DATAWRITERROLE';
      IF (writerRoleExists<1) THEN
        vsql:='CREATE ROLE DATAWRITERROLE';
        CREATEOBJECT(vsql,'Unable to create the DATAWRITERROLE');
      END IF;
    END;
  
    vsql:='GRANT CONNECT TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant CONNECT to the DATAWRITERROLE role');
  
    vsql:='GRANT CREATE SESSION TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant SESSION to the DATAWRITERROLE role');

    vsql:='GRANT DELETE ANY TABLE TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant DELETE ANY TABLE to the DATAWRITERROLE role');
  
    vsql:='GRANT INSERT ANY TABLE TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant INSERT ANY TABLE to the DATAWRITERROLE role');
    
    vsql:='GRANT UPDATE ANY TABLE TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant UPDATE ANY TABLE to the DATAWRITERROLE role');

    /*
		--------------------------------------------------------------------
		CREATE WFS USER AND TABLESPACES
		--------------------------------------------------------------------
		*/
		
		SELECT INSTANCE_NAME INTO wk_instancename FROM V$INSTANCE;

      DECLARE
         db_cluster_var varchar2(10):='FALSE';
      BEGIN
         select value into db_cluster_var from v$parameter where name='cluster_database';
         IF (db_cluster_var <> 'TRUE') THEN
            -- Set db_create_file_dest to default directory
            select substr(file_name,1,instr(file_name,decode(platform.platformname,'windows','\','/'),-1) -1)
            INTO vsql
            from dba_data_files, (select case when lower(platform_name) like '%windows%' then 'windows' else 'unix' end as platformname from v$database )  platform
            WHERE tablespace_name = 'SYSTEM';
    
            --SETDBCREATEFILEDEST(vsql);         
         END IF;         
      END;    
		
      vsql :='DROP FLASHBACK ARCHIVE CMSFLASHBACK';
			CREATEOBJECT(vsql,'Unable to Drop Flashback Archive Cmsflashback.','Y');

     -- Drop WFS_data tablespace
      vsql :='drop tablespace WFS_data including contents and datafiles';
			CREATEOBJECT(vsql,'DROP TABLESPACE WFS_data','Y');

      vsql :='drop tablespace WFS_data_archive including contents and datafiles';
			CREATEOBJECT(vsql,'DROP TABLESPACE WFS_data','Y');

      -- Creating WFS_data tablespace
      vsql :='create tablespace WFS_data datafile size 500M AUTOEXTEND ON NEXT 250M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL AUTOALLOCATE SEGMENT SPACE MANAGEMENT AUTO';
			CREATEOBJECT(vsql,'CREATE TABLESPACE WFS_data');
		
      -- Added additional datafile to the tablespace WFS_DATA by Suresh on 10-14-2010
      vsql :='ALTER TABLESPACE wfs_data ADD DATAFILE SIZE 100M AUTOEXTEND ON NEXT 200M MAXSIZE unlimited';
      CREATEOBJECT(VSQL,'ALTER TABLESPACE WFS_data');

      vsql :='create bigfile tablespace wfs_data_archive datafile size 100m autoextend on next 50m maxsize unlimited';
      CREATEOBJECT(VSQL,'Unable to create flashback archive default cmsflashback tablespace wfs_data.');
      
      vsql :='create flashback archive default cmsflashback tablespace wfs_data_archive retention 6 month';
      CREATEOBJECT(VSQL,'Unable to create flashback archive default cmsflashback tablespace wfs_data.');

		-- Set Default temp tablespace to temp
      vsql :=  'ALTER DATABASE DEFAULT TEMPORARY TABLESPACE temp';
      CREATEOBJECT(vsql,'Default Tablespace temp','Y');

		--DROP WFS USER
      vsql :=  'drop user WFS cascade';
      CREATEOBJECT(vsql,'DROP USER WFS','Y');

		--CREATE WFS USER
      vsql :=  'create user WFS identified by Wf$1234 default tablespace wfs_data';
      CREATEOBJECT(vsql,'CREATE USER wfs');
      
		--Grant privs to WFS user
      vsql :=  'grant resource, connect, create session, create table, create view to WFS';
      CREATEOBJECT(vsql,'Unable to grant dbs, resource, connect, and create session to the WFS user.');

      vsql :=  'grant create any table, create any index, select any table, update any table, insert any table, delete any table, drop any table, alter any table, drop any index, drop any type, create any type, alter any type, flashback archive administer to WFS';
      CREATEOBJECT(vsql,'Unable to grant privileges to the WFS user for xmlevolve.');

      vsql := 'grant select on smon_scn_time to wfs';
      CREATEOBJECT(vsql,'Unable to grant select on smon_scn_time to wfs.');

      vsql := 'create or replace public synonym smon_scn_time for sys.smon_scn_time';
      CREATEOBJECT(vsql,'Unable to create or replace public synonym smon_scn_time for sys.smon_scn_time.');
      
      vsql := 'GRANT CREATE ANY DIRECTORY, SELECT ANY DICTIONARY, ALTER SESSION TO WFS';
      CREATEOBJECT(vsql,'Unable to grant create any directory, alter session to wfs'); 

      vsql := 'DROP DIRECTORY ECMFXMLDIR';
      CREATEOBJECT(vsql,'Unable to DROP DIRECTORY ECMFXMLDIR','Y');
      
      vsql := 'CREATE DIRECTORY ECMFXMLDIR AS ''/home/oracle/ecmf''';
      CREATEOBJECT(vsql,'Unable to grant create directory ECMFXMLDIR');
      
      vsql := 'GRANT ALL ON DIRECTORY ECMFXMLDIR TO WFS';
      CREATEOBJECT(vsql,'Unable to grant all on directory ecmfxmldir to wfs'); 

    /* ---------- WFSDW User ---------- */
  
		--DROP WFSDW USER
      vsql :=  'drop user WFSDW cascade';
      CREATEOBJECT(vsql,'DROP USER WFSDW','Y');

		--CREATE WFS USER
      vsql :=  'create user WFSDW identified by WFSDW default tablespace WFS_data';
      CREATEOBJECT(vsql,'CREATE USER wfsdw');

		--Grant privs to WFSDW user
      vsql :=  'grant DataReaderRole, DataWriterRole,connect,resource to WFSDW';
      CREATEOBJECT(vsql,'Unable to grant DataReaderRole and DataWriterRole to the WFSDW user');

  /*
  -----------------------------------------
   CREATING ALL SEQUENCES 
  -----------------------------------------
  */
  
      vsql :=  'CREATE SEQUENCE WFS.ALERTS_HIST_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.ALERTS_HIST_ID');

  /*
  -----------------------------------------
   CREATING ALL TABLES AND PRIMARY KEYS
  -----------------------------------------
  */

    -- creating table SYSTEM_SETTINGS
      vsql :=  'CREATE TABLE WFS.SYSTEM_SETTINGS (SETTING_TYPE  VARCHAR2(25), SETTING_VALUE VARCHAR2(1024), CREATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL)';
      CREATEOBJECT(vsql,'Unable to create table SYSTEM_SETTINGS');

      vsql :=  'CREATE OR REPLACE TRIGGER '||VSCHEMA||'.system_settingsupd before update ON '||VSCHEMA||'.system_settings FOR EACH ROW BEGIN  SELECT systimestamp INTO :new.createdate FROM dual; END;';
      CREATEOBJECT(vsql,'Unable to create trigger '||VSCHEMA||'.system_settingsupd');

    -- creating table ALERTS
      vsql :=  'CREATE TABLE WFS.ALERTS ( 
          IDENTIFIER  	VARCHAR2(32) NOT NULL,
          ALERT_NAME  	VARCHAR2(64) NOT NULL,
          THRESH_COUNT	NUMBER NULL,
          THRESH_SECS 	NUMBER NULL,
          FREQ_COUNT  	NUMBER NULL,
          FREQ_SECS   	NUMBER NULL,
          TYPE        	VARCHAR2(16) NULL,
          CONSTRAINT PK_ALERTS PRIMARY KEY (IDENTIFIER)
          )';
      CREATEOBJECT(vsql,'Unable to create table ALERTS');

    -- creating table ALERTS_HIST
      vsql :=  'CREATE TABLE WFS.ALERTS_HIST ( 
          HIST_KEY  	NUMBER NOT NULL,
          TIME_KEY  	DATE NULL,
          IDENTIFIER	VARCHAR2(32) NOT NULL,
          ALERT_NAME	VARCHAR2(64) NULL,
          ALERT_TYPE	VARCHAR2(64) NULL,
          MSG       	VARCHAR2(4000) NULL,
          CONSTRAINT PK_ALERTS_HIST PRIMARY KEY (HIST_KEY))';
      CREATEOBJECT(vsql,'Unable to create table ALERTS_HIST');

    -- creating table ALERT_ACTIONS
       vsql :=  'CREATE TABLE WFS.ALERT_ACTIONS ( 
          IDENTIFIER 	VARCHAR2(32) NOT NULL,
          ACTION_TYPE	NUMBER NULL,
          DETAIL     	VARCHAR2(64) NULL 
          ) ';
      CREATEOBJECT(vsql,'Unable to create table ALERT_ACTIONS');
  
    -- creating table ALERT_ACTIONS_HIST
       vsql :=  'CREATE TABLE WFS.ALERT_ACTIONS_HIST(
                  HIST_KEY     NUMERIC(19,0)           NOT NULL,
                  ACTION_TYPE  NUMERIC(19,0),
                  DETAIL       VARCHAR2(64)) ';
      CREATEOBJECT(vsql,'Unable to create table ALERT_ACTIONS_HIST');

    -- creating table ALERT_NAMES
       vsql :=  'CREATE TABLE WFS.ALERT_NAMES(
                  ALERT_NAME  VARCHAR2(64)                 NOT NULL,
                  PATTERN     VARCHAR2(64)                 NOT NULL,
                  CONSTRAINT PK_ALERT_NAMES PRIMARY KEY (ALERT_NAME)
                  )';
      CREATEOBJECT(vsql,'Unable to create table ALERT_NAMES');

    -- creating table JBPM_ACTION
       vsql :=  'CREATE TABLE WFS.JBPM_ACTION ( 
          ID_                   	NUMBER(19,0) NOT NULL,
          CLASS                 	CHAR(1) NOT NULL,
          NAME_                 	VARCHAR2(255) NULL,
          ISPROPAGATIONALLOWED_ 	NUMBER NULL,
          ACTIONEXPRESSION_     	VARCHAR2(255) NULL,
          ISASYNC_              	NUMBER NULL,
          REFERENCEDACTION_     	NUMBER(19,0) NULL,
          ACTIONDELEGATION_     	NUMBER(19,0) NULL,
          EVENT_                	NUMBER(19,0) NULL,
          PROCESSDEFINITION_    	NUMBER(19,0) NULL,
          TIMERNAME_            	VARCHAR2(255) NULL,
          DUEDATE_              	VARCHAR2(255) NULL,
          REPEAT_               	VARCHAR2(255) NULL,
          TRANSITIONNAME_       	VARCHAR2(255) NULL,
          TIMERACTION_          	NUMBER(19,0) NULL,
          EXPRESSION_           	VARCHAR2(4000) NULL,
          EVENTINDEX_           	NUMBER NULL,
          EXCEPTIONHANDLER_     	NUMBER(19,0) NULL,
          EXCEPTIONHANDLERINDEX_	NUMBER NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ACTION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ACTION');
      CREATESEQ('JBPM_ACTION');
      CREATEUPDATETRG('JBPM_ACTION');
      
    -- Creating index IDX_JBPMACTION_REFERENCEACTION
       vsql :=  'CREATE INDEX WFS.IDX_JBPMACTION_REFERENCEACTION ON WFS.JBPM_ACTION(REFERENCEDACTION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPMACTION_REFERENCEACTION');      

       vsql := 'create index '||vschema||'.idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)');

       vsql := 'create index '||vschema||'.idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)');
      
    -- creating table JBPM_BYTEARRAY
       vsql :=  'CREATE TABLE WFS.JBPM_BYTEARRAY ( 
          ID_            	NUMBER(19,0) NOT NULL,
          NAME_          	VARCHAR2(255) NULL,
          FILEDEFINITION_	NUMBER(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_BYTEARRAY PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_BYTEARRAY');
      CREATESEQ('JBPM_BYTEARRAY');
      CREATEUPDATETRG('JBPM_BYTEARRAY');
      
    -- creating table JBPM_BYTEBLOCK
       vsql :=  'CREATE TABLE WFS.JBPM_BYTEBLOCK ( 
          PROCESSFILE_	NUMBER(19,0) NOT NULL,
          BYTES_      	RAW(1024) NULL,
          INDEX_      	NUMBER NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_BYTEBLOCK PRIMARY KEY (PROCESSFILE_, INDEX_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_BYTEBLOCK');
      CREATEUPDATETRG('JBPM_BYTEBLOCK');

    -- creating table JBPM_DECISIONCONDITIONS
       vsql :=  'CREATE TABLE WFS.JBPM_DECISIONCONDITIONS ( 
          DECISION_      	NUMBER(19,0) NOT NULL,
          TRANSITIONNAME_	VARCHAR2(255) NULL,
          EXPRESSION_    	VARCHAR2(255) NULL,
          INDEX_         	NUMBER NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_DECISIONCONDITIONS PRIMARY KEY (DECISION_, INDEX_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_DECISIONCONDITIONS');
      CREATEUPDATETRG('JBPM_DECISIONCONDITIONS');
      
    -- creating table JBPM_DELEGATION
       vsql :=  'CREATE TABLE WFS.JBPM_DELEGATION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          CLASSNAME_        	VARCHAR2(4000) NULL,
          CONFIGURATION_    	VARCHAR2(4000) NULL,
          CONFIGTYPE_       	VARCHAR2(255) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_DELEGATION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_DELEGATION');
      CREATESEQ('JBPM_DELEGATION');
      CREATEUPDATETRG('JBPM_DELEGATION');

    -- creating table JBPM_EVENT
       vsql :=  'CREATE TABLE WFS.JBPM_EVENT ( 
          ID_               	NUMBER(19,0) NOT NULL,
          EVENTTYPE_        	VARCHAR2(255) NULL,
          TYPE_             	CHAR(1) NULL,
          GRAPHELEMENT_     	NUMBER(19,0) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          NODE_             	NUMBER(19,0) NULL,
          TRANSITION_       	NUMBER(19,0) NULL,
          TASK_             	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_EVENT PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_EVENT');
      CREATESEQ('JBPM_EVENT');
      CREATEUPDATETRG('JBPM_EVENT');
      
   -- Create index IDX_JBPMEVENT_TRANSITION
       vsql :=  'CREATE INDEX WFS.IDX_JBPMEVENT_TRANSITION ON WFS.JBPM_EVENT(TRANSITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPMEVENT_TRANSITION on JBPM_EVENT table');      

       vsql := 'create index '||vschema||'.idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)');
      
    -- creating table JBPM_EXCEPTIONHANDLER
       vsql :=  'CREATE TABLE WFS.JBPM_EXCEPTIONHANDLER ( 
          ID_                	NUMBER(19,0) NOT NULL,
          EXCEPTIONCLASSNAME_	VARCHAR2(4000) NULL,
          TYPE_              	CHAR(1) NULL,
          GRAPHELEMENT_      	NUMBER(19,0) NULL,
          PROCESSDEFINITION_ 	NUMBER(19,0) NULL,
          GRAPHELEMENTINDEX_ 	NUMBER NULL,
          NODE_              	NUMBER(19,0) NULL,
          TRANSITION_        	NUMBER(19,0) NULL,
          TASK_              	NUMBER(19,0) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_EXCEPTIONHANDLER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_EXCEPTIONHANDLER');
      CREATESEQ('JBPM_EXCEPTIONHANDLER');
      CREATEUPDATETRG('JBPM_EXCEPTIONHANDLER');
      
    -- creating table JBPM_ID_GROUP
       vsql :=  'CREATE TABLE WFS.JBPM_ID_GROUP ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          TYPE_     	VARCHAR2(255) NULL,
          PARENT_   	NUMBER(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ID_GROUP PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_GROUP');
       CREATESEQ('JBPM_ID_GROUP');
      CREATEUPDATETRG('JBPM_ID_GROUP');
      
    -- creating table JBPM_ID_MEMBERSHIP
       vsql :=  'CREATE TABLE WFS.JBPM_ID_MEMBERSHIP ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          ROLE_     	VARCHAR2(255) NULL,
          USER_     	NUMBER(19,0) NULL,
          GROUP_    	NUMBER(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ID_MEMBERSHIP PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_MEMBERSHIP');
      CREATESEQ('JBPM_ID_MEMBERSHIP');
      CREATEUPDATETRG('JBPM_ID_MEMBERSHIP');

    -- creating table JBPM_ID_PERMISSIONS
       vsql :=  'CREATE TABLE WFS.JBPM_ID_PERMISSIONS ( 
          ENTITY_   	NUMBER(19,0) NOT NULL,
          CLASS_    	VARCHAR2(255) NULL,
          NAME_     	VARCHAR2(255) NULL,
          ACTION_   	VARCHAR2(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_PERMISSIONS');
  
    -- creating table JBPM_ID_USER
       vsql :=  'CREATE TABLE WFS.JBPM_ID_USER ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          EMAIL_    	VARCHAR2(255) NULL,
          PASSWORD_ 	VARCHAR2(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ID_USER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_USER');
      CREATESEQ('JBPM_ID_USER');
      CREATEUPDATETRG('JBPM_ID_USER');

    -- creating table JBPM_MESSAGE
       vsql :=  'CREATE TABLE WFS.JBPM_MESSAGE ( 
          ID_            	NUMBER(19,0) NOT NULL,
          CLASS_         	CHAR(1) NOT NULL,
          DESTINATION_   	VARCHAR2(255) NULL,
          EXCEPTION_     	VARCHAR2(255) NULL,
          ISSUSPENDED_   	NUMBER NULL,
          TOKEN_         	NUMBER(19,0) NULL,
          TEXT_          	VARCHAR2(255) NULL,
          ACTION_        	NUMBER(19,0) NULL,
          NODE_          	NUMBER(19,0) NULL,
          TRANSITIONNAME_	VARCHAR2(255) NULL,
          TASKINSTANCE_  	NUMBER(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_MESSAGE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_MESSAGE');


    -- creating table JBPM_MODULEDEFINITION
       vsql :=  'CREATE TABLE WFS.JBPM_MODULEDEFINITION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          CLASS_            	CHAR(1) NOT NULL,
          NAME_             	VARCHAR2(4000) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          STARTTASK_        	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_MODULEDEFINITION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_MODULEDEFINITION');
      CREATESEQ('JBPM_MODULEDEFINITION');
      CREATEUPDATETRG('JBPM_MODULEDEFINITION');
      
    -- creating table JBPM_NODE
       vsql :=  'CREATE TABLE WFS.JBPM_NODE ( 
          ID_                  	NUMBER(19,0) NOT NULL,
          CLASS_               	CHAR(1) NOT NULL,
          NAME_                	VARCHAR2(255) NULL,
          PROCESSDEFINITION_   	NUMBER(19,0) NULL,
          ISASYNC_             	NUMBER NULL,
          ACTION_              	NUMBER(19,0) NULL,
          SUPERSTATE_          	NUMBER(19,0) NULL,
          SUBPROCESSDEFINITION_	NUMBER(19,0) NULL,
          DECISIONEXPRESSION_  	VARCHAR2(255) NULL,
          DECISIONDELEGATION   	NUMBER(19,0) NULL,
          SIGNAL_              	NUMBER NULL,
          CREATETASKS_         	NUMBER NULL,
          ENDTASKS_            	NUMBER NULL,
          NODECOLLECTIONINDEX_ 	NUMBER NULL,
          RESOURCEGROUPID      	NUMBER NULL,
          DURATION             	VARCHAR2(500) NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          DURATIONDESCRIPTION  	VARCHAR2(500) NULL,
          CONSTRAINT PK_JBPM_NODE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_NODE');
      CREATESEQ('JBPM_NODE');
      CREATEUPDATETRG('JBPM_NODE');
    
    -- Creating Index IDX_JBPM_NODE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_NODE_01 ON WFS.JBPM_NODE(PROCESSDEFINITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_NODE_01');

    -- creating table JBPM_POOLEDACTOR
       vsql :=  'CREATE TABLE WFS.JBPM_POOLEDACTOR ( 
          ID_              	NUMBER(19,0) NOT NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          SWIMLANEINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_POOLEDACTOR PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_POOLEDACTOR');
      CREATESEQ('JBPM_POOLEDACTOR');
      CREATEUPDATETRG('JBPM_POOLEDACTOR');

    -- Creating index IX_JBPM_POOLEDACTOR_1
       vsql :=  'CREATE INDEX WFS.IDX_PLDACTR_ACTID ON WFS.JBPM_POOLEDACTOR(ACTORID_)';
      CREATEOBJECT(vsql,'Unable to create index IX_JBPM_POOLEDACTOR_1');

    -- creating table JBPM_PROCESSDEFINITION
       vsql :=  'CREATE TABLE WFS.JBPM_PROCESSDEFINITION ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          VERSION_               	NUMBER NULL,
          ISTERMINATIONIMPLICIT_ 	NUMBER NULL,
          STARTSTATE_            	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          PROCESSDEFINITIONTYPEID	NUMBER DEFAULT (1) NOT NULL,
          CONSTRAINT PK_JBPM_PROCESSDEFINITION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_PROCESSDEFINITION');
      CREATESEQ('JBPM_PROCESSDEFINITION');
      CREATEUPDATETRG('JBPM_PROCESSDEFINITION');

    -- Creating index IDX_JBPM_PROCESSDEFINITION_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_PROCESSDEFINITION_01 ON WFS.JBPM_PROCESSDEFINITION (NAME_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSDEFINITION_01 on JBPM_PROCESSDEFINITION table');

    -- Create index IDX_JBPM_PROCESSDEFINITION_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_PROCESSDEFINITION_02 ON WFS.JBPM_PROCESSDEFINITION(PROCESSDEFINITIONTYPEID)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSDEFINITION_02 on JPBM_PROCESSDEFINITION table');

    -- creating table JBPM_RUNTIMEACTION
       vsql :=  'CREATE TABLE WFS.JBPM_RUNTIMEACTION ( 
          ID_                  	NUMBER(19,0) NOT NULL,
          VERSION_             	NUMBER NOT NULL,
          EVENTTYPE_           	VARCHAR2(255) NULL,
          TYPE_                	CHAR(1) NULL,
          GRAPHELEMENT_        	NUMBER(19,0) NULL,
          PROCESSINSTANCE_     	NUMBER(19,0) NULL,
          ACTION_              	NUMBER(19,0) NULL,
          PROCESSINSTANCEINDEX_	NUMBER NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_RUNTIMEACTION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_RUNTIMEACTION');
      CREATESEQ('JBPM_RUNTIMEACTION');
      CREATEUPDATETRG('JBPM_RUNTIMEACTION');

    -- Creating index IDX_RUNTIMEACTION_01
       vsql :=  'CREATE INDEX WFS.IDX_RUNTIMEACTION_01 ON WFS.JBPM_RUNTIMEACTION(PROCESSINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_RUNTIMEACTION_01');

    -- creating table JBPM_SWIMLANE
       vsql :=  'CREATE TABLE WFS.JBPM_SWIMLANE ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          ACTORIDEXPRESSION_     	VARCHAR2(255) NULL,
          POOLEDACTORSEXPRESSION_	VARCHAR2(255) NULL,
          ASSIGNMENTDELEGATION_  	NUMBER(19,0) NULL,
          TASKMGMTDEFINITION_    	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_SWIMLANE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_SWIMLANE');
      CREATESEQ('JBPM_SWIMLANE');
      CREATEUPDATETRG('JBPM_SWIMLANE');

    -- creating table JBPM_SWIMLANEINSTANCE
       vsql :=  'CREATE TABLE WFS.JBPM_SWIMLANEINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          SWIMLANE_        	NUMBER(19,0) NULL,
          TASKMGMTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_SWIMLANEINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_SWIMLANEINSTANCE');
      CREATESEQ('JBPM_SWIMLANEINSTANCE');
      CREATEUPDATETRG('JBPM_SWIMLANEINSTANCE');

    -- Creating Index IDX_JBPM_SWIMLANEINSTANCE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_SWIMLANEINSTANCE_01 ON WFS.JBPM_SWIMLANEINSTANCE(TASKMGMTINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_SWIMLANEINSTANCE_01');

    -- creating table JBPM_TASK
       vsql :=  'CREATE TABLE WFS.JBPM_TASK ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          PROCESSDEFINITION_     	NUMBER(19,0) NULL,
          DESCRIPTION_           	VARCHAR2(4000) NULL,
          ISBLOCKING_            	NUMBER NULL,
          ISSIGNALLING_          	NUMBER NULL,
          DUEDATE_               	VARCHAR2(255) NULL,
          ACTORIDEXPRESSION_     	VARCHAR2(255) NULL,
          POOLEDACTORSEXPRESSION_	VARCHAR2(255) NULL,
          TASKMGMTDEFINITION_    	NUMBER(19,0) NULL,
          TASKNODE_              	NUMBER(19,0) NULL,
          STARTSTATE_            	NUMBER(19,0) NULL,
          ASSIGNMENTDELEGATION_  	NUMBER(19,0) NULL,
          SWIMLANE_              	NUMBER(19,0) NULL,
          TASKCONTROLLER_        	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TASK PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASK');
      CREATESEQ('JBPM_TASK');
      CREATEUPDATETRG('JBPM_TASK');

    -- Creating index IDX_JBPM_TASK_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TASK_01 ON WFS.JBPM_TASK(TASKNODE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASK_01');

    -- Creating index IDX_JBPM_TASK_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TASK_02 ON WFS.JBPM_TASK(STARTSTATE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASK_02');

    -- creating table JBPM_TASKACTORPOOL
       vsql :=  'CREATE TABLE WFS.JBPM_TASKACTORPOOL ( 
          TASKINSTANCE_	NUMBER(19,0) NOT NULL,
          POOLEDACTOR_ 	NUMBER(19,0) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASKACTORPOOL');
      CREATEUPDATETRG('JBPM_TASKACTORPOOL');
      
    -- Creating Primary Key on JBPM_TASKACTORPOOL
       vsql :=  'ALTER TABLE WFS.JBPM_TASKACTORPOOL ADD ( CONSTRAINT PK_JBPM_TASKACTORPOOL PRIMARY KEY (TASKINSTANCE_, POOLEDACTOR_))';
      CREATEOBJECT(vsql,'Unable to create Primary Key for JBPM_TASKACTORPOOL');

    -- creating table JBPM_TASKCONTROLLER
       vsql :=  'CREATE TABLE WFS.JBPM_TASKCONTROLLER ( 
          ID_                      	NUMBER(19,0) NOT NULL,
          TASKCONTROLLERDELEGATION_	NUMBER(19,0) NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TASKCONTROLLER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASKCONTROLLER');
      CREATESEQ('JBPM_TASKCONTROLLER');
      CREATEUPDATETRG('JBPM_TASKCONTROLLER');
      
    -- creating table JBPM_TIMER
       vsql :=  'CREATE TABLE WFS.JBPM_TIMER ( 
          ID_              	NUMBER(19,0) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          REPEAT_          	VARCHAR2(255) NULL,
          TRANSITIONNAME_  	VARCHAR2(255) NULL,
          EXCEPTION_       	VARCHAR2(4000) NULL,
          ISSUSPENDED_     	NUMBER NULL,
          ACTION_          	NUMBER(19,0) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          PROCESSINSTANCE_ 	NUMBER(19,0) NULL,
          TASKINSTANCE_    	NUMBER(19,0) NULL,
          GRAPHELEMENTTYPE_	VARCHAR2(255) NULL,
          GRAPHELEMENT_    	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TIMER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TIMER');
      CREATESEQ('JBPM_TIMER');
      CREATEUPDATETRG('JBPM_TIMER');

    IF (ENABLE_PARTITION != 'TRUE') THEN
    -- creating table JBPM_TOKEN
    /* Partition: Master Table */
       vsql :=  'CREATE TABLE WFS.JBPM_TOKEN ( 
          ID_                      	NUMBER(19,0) NOT NULL,
          VERSION_                 	NUMBER NOT NULL,
          NAME_                    	VARCHAR2(255) NULL,
          START_                   	TIMESTAMP(6) NULL,
          END_                     	TIMESTAMP(6) NULL,
          NODEENTER_               	TIMESTAMP(6) NULL,
          NEXTLOGINDEX_            	NUMBER NULL,
          ISABLETOREACTIVATEPARENT_	NUMBER NULL,
          ISTERMINATIONIMPLICIT_   	NUMBER NULL,
          ISSUSPENDED_             	NUMBER NULL,
          NODE_                    	NUMBER(19,0) NULL,
          PROCESSINSTANCE_         	NUMBER(19,0) NULL,
          PARENT_                  	NUMBER(19,0) NULL,
          SUBPROCESSINSTANCE_      	NUMBER(19,0) NULL,
          TOKENTYPEID              	NUMBER NOT NULL,
          OPERATIONALSTATUS      	  NUMBER(19,0) NULL,
          ADMINISTRATIVESTATUS   	  NUMBER(19,0) NULL,
          RETRYCOUNT                NUMBER DEFAULT 0 NOT NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TOKEN PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TOKEN');
      CREATESEQ('JBPM_TOKEN',3,vcache=>100);
      CREATEUPDATETRG('JBPM_TOKEN');

    -- Creating Index IDX_JBPM_TOKEN_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TOKEN_01 ON WFS.JBPM_TOKEN(PARENT_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKEN_01');

    -- Creating Index IDX_JBPM_TOKEN_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TOKEN_02 ON WFS.JBPM_TOKEN(NODE_)';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_TOKEN_02');

    -- creating table JBPM_PROCESSINSTANCE
    /* Partition: Child Table 1*/
    vsql :=  'CREATE TABLE WFS.JBPM_PROCESSINSTANCE ( 
          ID_                          	NUMBER(19,0) NOT NULL,
          VERSION_                     	NUMBER NOT NULL,
          START_                       	TIMESTAMP(6) NULL,
          END_                         	TIMESTAMP(6) NULL,
          ISSUSPENDED_                 	NUMBER NULL,
          PROCESSDEFINITION_           	NUMBER(19,0) NULL,
          ROOTTOKEN_                   	NUMBER(19,0) NULL,
          SUPERPROCESSTOKEN_           	NUMBER(19,0) NULL,
          ADMINISTRATIVEPROCESSSTATUSID	NUMBER NOT NULL,
          OPERATIONALPROCESSSTATUSID   	NUMBER NOT NULL,
          PROCESSINSTANCETYPEID        	NUMBER NOT NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          PROCESSPRIORITYID            	NUMBER NULL,
          ISACTIVE                     	NUMBER(1,0) DEFAULT (1) NOT NULL,
          CONSTRAINT PK_JBPM_PROCESSINSTANCE PRIMARY KEY (ID_),
          CONSTRAINT JBPM_PINSTANCE#JBPM_TOKEN2  FOREIGN KEY (ROOTTOKEN_) REFERENCES WFS.JBPM_TOKEN (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_PROCESSINSTANCE');
      CREATESEQ('JBPM_PROCESSINSTANCE',3,vcache=>100);
      CREATEUPDATETRG('JBPM_PROCESSINSTANCE');
    
    -- Creating index IDX_JBPM_PROCESSINSTANCE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_PROCESSINSTANCE_01 ON WFS.JBPM_PROCESSINSTANCE(PROCESSDEFINITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSINSTANCE_01');
      
    -- Creating index  IDX_PI_OPERATIONALSTATUSID
       vsql :=  'CREATE INDEX WFS.IDX_PI_OPERATIONALSTATUSID ON WFS.JBPM_PROCESSINSTANCE(OPERATIONALPROCESSSTATUSID)';
      CREATEOBJECT(vsql,'Unable to create index IDX_PI_OPERATIONALSTATUSID');

    -- creating table JBPM_VARIABLEINSTANCE
    /* Partition: Child Table 2*/
    vsql :=  'CREATE TABLE WFS.JBPM_VARIABLEINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          CONVERTER_       	CHAR(1) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          TOKENVARIABLEMAP_	NUMBER(19,0) NULL,
          PROCESSINSTANCE_ 	NUMBER(19,0) NULL,
          BYTEARRAYVALUE_  	NUMBER(19,0) NULL,
          DATEVALUE_       	TIMESTAMP(6) NULL,
          DOUBLEVALUE_     	FLOAT NULL,
          LONGIDCLASS_     	VARCHAR2(255) NULL,
          LONGVALUE_       	NUMBER(19,0) NULL,
          STRINGIDCLASS_   	VARCHAR2(255) NULL,
          STRINGVALUE_     	VARCHAR2(4000) NULL,
          TASKINSTANCE_    	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_VARIABLEINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_VARIABLEINSTANCE');
      CREATESEQ('JBPM_VARIABLEINSTANCE',vcache=>100);
      CREATEUPDATETRG('JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_01 ON WFS.JBPM_VARIABLEINSTANCE (NAME_, STRINGVALUE_)';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_02 ON WFS.JBPM_VARIABLEINSTANCE (PROCESSINSTANCE_, NAME_, STRINGVALUE_, TOKENVARIABLEMAP_, CLASS_)';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_03 ON WFS.JBPM_VARIABLEINSTANCE(TASKINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_04 ON WFS.JBPM_VARIABLEINSTANCE(TOKENVARIABLEMAP_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE');

      vsql := 'CREATE INDEX '||vschema||'.idx_jbpm_vinstance_strval on  '||vschema||'.JBPM_VARIABLEINSTANCE(STRINGVALUE_)';
      CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_strval'); 

      vsql := 'CREATE INDEX '||vschema||'.idx_jbpm_vinstance_longval ON '||vschema||'.JBPM_VARIABLEINSTANCE(LONGVALUE_)';
      CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_longval'); 
    -- creating table JBPM_MODULEINSTANCE
    /* Partition: Child Table 3*/    
       vsql :=  'CREATE TABLE WFS.JBPM_MODULEINSTANCE ( 
          ID_                	NUMBER(19,0) NOT NULL,
          CLASS_             	CHAR(1) NOT NULL,
          PROCESSINSTANCE_   	NUMBER(19,0) NULL,
          TASKMGMTDEFINITION_	NUMBER(19,0) NULL,
          NAME_              	VARCHAR2(255) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_MODULEINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_MODULEINSTANCE');
      CREATESEQ('JBPM_MODULEINSTANCE',vcache=>100);
      CREATEUPDATETRG('JBPM_MODULEINSTANCE');

    -- Creating index IDX_JBPM_MODULEINSTANCE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_MODULEINSTANCE_01 ON WFS.JBPM_MODULEINSTANCE(PROCESSINSTANCE_)';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_MODULEINSTANCE_01');

    -- creating table JBPM_TOKENVARIABLEMAP
    /* Partition: Child Table 4*/   
    vsql :=  'CREATE TABLE WFS.JBPM_TOKENVARIABLEMAP ( 
          ID_             	NUMBER(19,0) NOT NULL,
          TOKEN_          	NUMBER(19,0) NULL,
          CONTEXTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TOKENVARIABLEMAP PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TOKENVARIABLEMAP');
      CREATESEQ('JBPM_TOKENVARIABLEMAP',vcache=>100);
      CREATEUPDATETRG('JBPM_TOKENVARIABLEMAP');
      
    -- Creating index IDX_JBPM_TOKENVARIABLEMAP_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TOKENVARIABLEMAP_01 ON WFS.JBPM_TOKENVARIABLEMAP(CONTEXTINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKENVARIABLEMAP_01');

    -- creating table JBPM_LOG
    /* Partition: Child Table 5*/       
       vsql :=  'CREATE TABLE WFS.JBPM_LOG ( 
          ID_                   	NUMBER(19,0) NOT NULL,
          CLASS_                	CHAR(1) NOT NULL,
          INDEX_                	NUMBER NULL,
          DATE_                 	TIMESTAMP(6) NULL,
          TOKEN_                	NUMBER(19,0) NULL,
          PARENT_               	NUMBER(19,0) NULL,
          MESSAGE_              	VARCHAR2(4000) NULL,
          EXCEPTION_            	VARCHAR2(4000) NULL,
          ACTION_               	NUMBER(19,0) NULL,
          NODE_                 	NUMBER(19,0) NULL,
          ENTER_                	TIMESTAMP(6) NULL,
          LEAVE_                	TIMESTAMP(6) NULL,
          DURATION_             	NUMBER(19,0) NULL,
          TRANSITION_           	NUMBER(19,0) NULL,
          CHILD_                	NUMBER(19,0) NULL,
          SOURCENODE_           	NUMBER(19,0) NULL,
          DESTINATIONNODE_      	NUMBER(19,0) NULL,
          VARIABLEINSTANCE_     	NUMBER(19,0) NULL,
          OLDBYTEARRAY_         	NUMBER(19,0) NULL,
          NEWBYTEARRAY_         	NUMBER(19,0) NULL,
          OLDDATEVALUE_         	TIMESTAMP(6) NULL,
          NEWDATEVALUE_         	TIMESTAMP(6) NULL,
          OLDDOUBLEVALUE_       	FLOAT NULL,
          NEWDOUBLEVALUE_       	FLOAT NULL,
          OLDLONGIDCLASS_       	VARCHAR2(255) NULL,
          OLDLONGIDVALUE_       	NUMBER(19,0) NULL,
          NEWLONGIDCLASS_       	VARCHAR2(255) NULL,
          NEWLONGIDVALUE_       	NUMBER(19,0) NULL,
          OLDSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          OLDSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          NEWSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          NEWSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          OLDLONGVALUE_         	NUMBER(19,0) NULL,
          NEWLONGVALUE_         	NUMBER(19,0) NULL,
          OLDSTRINGVALUE_       	VARCHAR2(4000) NULL,
          NEWSTRINGVALUE_       	VARCHAR2(4000) NULL,
          TASKINSTANCE_         	NUMBER(19,0) NULL,
          TASKACTORID_          	VARCHAR2(255) NULL,
          TASKOLDACTORID_       	VARCHAR2(255) NULL,
          SWIMLANEINSTANCE_     	NUMBER(19,0) NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NULL,
          RESOURCEID            	NUMBER NULL,
          OPERATIONALSTATUSID   	NUMBER NULL,
          ADMINISTRATIVESTATUSID	NUMBER NULL,
          CONSTRAINT PK_JBPM_LOG PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_LOG');
      CREATESEQ('JBPM_LOG',vcache=>100);
      CREATEUPDATETRG('JBPM_LOG');

   -- Create index IDX_JBPM_LOG_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_LOG_01 ON WFS.JBPM_LOG (CLASS_, NODE_, TOKEN_)';
      CREATEOBJECT(VSQL,'Unable to create index IDX_JBPM_LOG_01 on JBPM_LOG table');
      
    -- creating table TTV_MESSAGELOG
       vsql :=  'CREATE TABLE WFS.TTV_MESSAGELOG ( 
          MESSAGELOGID   	NUMBER(19,0) NOT NULL,
          LOGID          	NUMBER(19,0) NOT NULL,
          TYPE           	VARCHAR2(16) NOT NULL,
          MESSAGEUID     	VARCHAR2(16) NOT NULL,
          NAME           	VARCHAR2(64) NULL,
          ISINCOMING     	NUMBER(1,0) NOT NULL,
          MESSAGE        	VARCHAR2(4000) NOT NULL,
          RESOURCEID     	NUMBER NULL,
          MESSAGEDATETIME	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MESSAGELOG PRIMARY KEY (MESSAGELOGID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MESSAGELOG');
      CREATESEQ('TTV_MESSAGELOG');
      CREATEUPDATETRG('TTV_MESSAGELOG');

    -- Creating Index on TTV_MESSAGELOG (LOGID)
       vsql :=  'CREATE INDEX WFS.IDX_TTV_MESSAGELOG_01 ON WFS.TTV_MESSAGELOG (LOGID ASC)';
      CREATEOBJECT(VSQL,'Unable to create Index on TTV_MESSAGELOG');

/* MH: 05/16/11: Removed as per Sahil.
    -- creating table TTV_TOKENRESOURCE
       vsql :=  'CREATE TABLE WFS.TTV_TOKENRESOURCE ( 
          TOKENID                   	NUMBER(19,0) NOT NULL,
          RESOURCEID                	NUMBER NOT NULL,
          RESOURCEUSAGESTARTDATETIME	TIMESTAMP(6) NOT NULL,
          CREATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID           	NUMBER NOT NULL,
          CONSTRAINT PK_TTV_TOKENRESOURCE PRIMARY KEY (TOKENID)
          )';
      CREATEOBJECT(VSQL,'Unable to create table TTV_TOKENRESOURCE');
      CREATEUPDATETRG('TTV_TOKENRESOURCE');

    -- creating table TTV_RESOURCEGROUPQUEUEITEM
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ( 
          RESOURCEGROUPQUEUEITEMID	NUMBER NOT NULL,
          RESOURCEGROUPID         	NUMBER NOT NULL,
          QUEUEORDER              	NUMBER NOT NULL,
          TOKENID                 	NUMBER(19,0) NOT NULL,
          ALLOCATIONKEY 				VARCHAR2(255) NULL,
          CREATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEGROUPQUEUEITEM PRIMARY KEY (RESOURCEGROUPQUEUEITEMID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUPQUEUEITEM');
      CREATESEQ('TTV_RESOURCEGROUPQUEUEITEM');
      CREATEUPDATETRG('TTV_RESOURCEGROUPQUEUEITEM');

    -- creating table TTV_RESOURCEUSAGEHISTORY
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEUSAGEHISTORY ( 
          RESOURCEUSAGEHISTORYID	NUMBER NOT NULL,
          RESOURCEID            	NUMBER NOT NULL,
          PROCESSINSTANCEID     	NUMBER(19,0) NOT NULL,
          NODEID                	NUMBER(19,0) NOT NULL,
          STARTDATETIME         	TIMESTAMP(6) NOT NULL,
          ENDDATETIME           	TIMESTAMP(6) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEUSAGEHISTORY PRIMARY KEY (RESOURCEUSAGEHISTORYID)
          )';
      CREATEOBJECT(VSQL,'Unable to create table TTV_RESOURCEUSAGEHISTORY');
      CREATESEQ('TTV_RESOURCEUSAGEHISTORY');

*/
    -- creating table TTV_PROCESSINSTANCENOTE
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSINSTANCENOTE ( 
          PROCESSINSTANCENOTEID	NUMBER NOT NULL,
          PROCESSINSTANCEID    	NUMBER NOT NULL,
          NOTE                 	VARCHAR2(4000) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSINSTANCENOTE PRIMARY KEY (PROCESSINSTANCENOTEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSINSTANCENOTE');
      CREATESEQ('TTV_PROCESSINSTANCENOTE');
      CREATEUPDATETRG('TTV_PROCESSINSTANCENOTE');

    -- Creating Index IDX_TTV_PROCESSINSTANCENOTE_01
       VSQL :=  'CREATE INDEX WFS.IDX_TTV_PROCESSINSTANCENOTE_01 ON WFS.TTV_PROCESSINSTANCENOTE(PROCESSINSTANCEID)';
      CREATEOBJECT(VSQL,'Unable to create index IDX_TTV_PROCESSINSTANCENOTE_01');

    -- creating table JBPM_TASKINSTANCE
       vsql :=  'CREATE TABLE WFS.JBPM_TASKINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          DESCRIPTION_     	VARCHAR2(4000) NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          CREATE_          	TIMESTAMP(6) NULL,
          START_           	TIMESTAMP(6) NULL,
          END_             	TIMESTAMP(6) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          PRIORITY_        	NUMBER NULL,
          ISCANCELLED_     	NUMBER NULL,
          ISSUSPENDED_     	NUMBER NULL,
          ISOPEN_          	NUMBER NULL,
          ISSIGNALLING_    	NUMBER NULL,
          ISBLOCKING_      	NUMBER NULL,
          TASK_            	NUMBER(19,0) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          SWIMLANINSTANCE_ 	NUMBER(19,0) NULL,
          TASKMGMTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TASKINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASKINSTANCE');
      CREATESEQ('JBPM_TASKINSTANCE');
      CREATEUPDATETRG('JBPM_TASKINSTANCE');

    -- Creating index IX_JBPM_TASKINSTANCE_1
       vsql :=  'CREATE INDEX WFS.IX_JBPM_TASKINSTANCE_1 ON WFS.JBPM_TASKINSTANCE(ACTORID_)';
      CREATEOBJECT(vsql,'Unable to create index IX_JBPM_TASKINSTANCE_1');
    
    -- Creating index IDX_JBPM_TASKINSTANCE_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TASKINSTANCE_02 ON WFS.JBPM_TASKINSTANCE(TASKMGMTINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASKINSTANCE_02');
      
    -- creating table JBPM_COMMENT
       vsql :=  'CREATE TABLE WFS.JBPM_COMMENT ( 
          ID_               	NUMBER(19,0) NOT NULL,
          VERSION_          	NUMBER NOT NULL,
          ACTORID_          	VARCHAR2(255) NULL,
          TIME_             	TIMESTAMP(6) NULL,
          MESSAGE_          	VARCHAR2(4000) NULL,
          TOKEN_            	NUMBER(19,0) NULL,
          TASKINSTANCE_     	NUMBER(19,0) NULL,
          TOKENINDEX_       	NUMBER NULL,
          TASKINSTANCEINDEX_	NUMBER NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_COMMENT PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_COMMENT');
      CREATESEQ('JBPM_COMMENT');
      CREATEUPDATETRG('JBPM_COMMENT');
      
    -- Creating index IDX_JBPM_COMMENT_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_COMMENT_01 ON WFS.JBPM_COMMENT(TOKEN_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_01');

    -- Creating index IDX_JBPM_COMMENT_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_COMMENT_02 ON WFS.JBPM_COMMENT (TASKINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_02');
  
    ELSE
      createwfspartition(SIZE_OF_PARTITION, ENABLE_MAX_PARTITION, NUMBER_OF_PARTITIONS);
    END IF;
  
    -- creating table JBPM_TRANSITION
       vsql :=  'CREATE TABLE WFS.JBPM_TRANSITION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          NAME_             	VARCHAR2(255) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          FROM_             	NUMBER(19,0) NULL,
          TO_               	NUMBER(19,0) NULL,
          FROMINDEX_        	NUMBER NULL,
          TRANSITIONTYPEID		NUMBER DEFAULT(2) NOT NULL, 
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TRANSITION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TRANSITION');
      CREATESEQ('JBPM_TRANSITION');
      CREATEUPDATETRG('JBPM_TRANSITION');
      
    -- Creating index IDX_JBPMTRANS_PROCDEFINITION
       vsql :=  'CREATE INDEX WFS.IDX_JBPMTRANS_PROCDEFINITION ON WFS.JBPM_TRANSITION(PROCESSDEFINITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPMTRANS_PROCDEFINITION');       

       vsql := 'create index '||vschema||'.idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)');

       vsql := 'create index '||vschema||'.idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)');
      
    -- creating table JBPM_VARIABLEACCESS
       vsql :=  'CREATE TABLE WFS.JBPM_VARIABLEACCESS ( 
          ID_                 	NUMBER(19,0) NOT NULL,
          VARIABLENAME_       	VARCHAR2(255) NULL,
          ACCESS_             	VARCHAR2(255) NULL,
          MAPPEDNAME_         	VARCHAR2(255) NULL,
          PROCESSSTATE_       	NUMBER(19,0) NULL,
          TASKCONTROLLER_     	NUMBER(19,0) NULL,
          INDEX_              	NUMBER NULL,
          SCRIPT_             	NUMBER(19,0) NULL,
          DATATYPEID          	NUMBER DEFAULT (2) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          VARIABLEACCESSTYPEID	NUMBER DEFAULT (2) NOT NULL,
          CONSTRAINT PK_JBPM_VARIABLEACCESS PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_VARIABLEACCESS');
      CREATESEQ('JBPM_VARIABLEACCESS');
      CREATEUPDATETRG('JBPM_VARIABLEACCESS');

    -- Creating Table SYSTEM_RELEASE
       vsql :=  'create table WFS.SYSTEM_RELEASE(
                  SETTING_TYPE        	VARCHAR(50)  	 	not null,
                  SETTING_VALUE        	VARCHAR(1024)
                  )';
      CREATEOBJECT(vsql,'Unable to create table SYSTEM_RELEASE');

    -- Creating Primary Key on SYSTEM_RELEASE
       vsql :=  'alter table WFS.SYSTEM_RELEASE add constraint PK_SYSTEM_RELEASE primary key (SETTING_TYPE)';
      CREATEOBJECT(vsql,'Unable to create Primary Key for SYSTEM_RELEASE');

    -- creating table TTV_ACCESSLEVEL
       vsql :=  'CREATE TABLE WFS.TTV_ACCESSLEVEL ( 
          ACCESSLEVELID	NUMBER NOT NULL,
          NAME         	VARCHAR2(50) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_ACCESSLEVEL PRIMARY KEY (ACCESSLEVELID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_ACCESSLEVEL');
      CREATESEQ('TTV_ACCESSLEVEL',3);
      CREATEUPDATETRG('TTV_ACCESSLEVEL');
      
    -- creating table TTV_CONNECTIONTYPE
       vsql :=  'CREATE TABLE WFS.TTV_CONNECTIONTYPE ( 
          CONNECTIONTYPEID	NUMBER NOT NULL,
          NAME            	VARCHAR2(30) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_CONNECTIONTYPE PRIMARY KEY (CONNECTIONTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_CONNECTIONTYPE');
      CREATESEQ('TTV_CONNECTIONTYPE',4);
      CREATEUPDATETRG('TTV_CONNECTIONTYPE');
      
    -- creating table TTV_DATATYPE
       vsql :=  'CREATE TABLE WFS.TTV_DATATYPE ( 
          DATATYPEID  	NUMBER NOT NULL,
          DATATYPENAME	VARCHAR2(30) NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_DATATYPE PRIMARY KEY (DATATYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_DATATYPE');
      CREATESEQ('TTV_DATATYPE',8);
      CREATEUPDATETRG('TTV_DATATYPE');

    -- creating table TTV_MONITOREDDRIVE
       vsql :=  'CREATE TABLE WFS.TTV_MONITOREDDRIVE (
          MONITOREDDRIVEID       	NUMBER NOT NULL,
          NAME                   	VARCHAR2(500) NOT NULL,
          DESCRIPTION            	VARCHAR2(500) DEFAULT ('''') NOT NULL,
          PATH                   	VARCHAR2(1000) NOT NULL,
          RESOURCEID             	NUMBER NULL,
          INTERNALDRIVEID        	NUMBER NOT NULL,
          TOTALCAPACITY          	NUMBER(19,0) NULL,
          WARNINGTHRESHOLDPERCENT	NUMBER NOT NULL,
          ERRORTHRESHOLDPERCENT  	NUMBER NOT NULL,
          CURRENTBYTESUSED       	NUMBER(19,0) DEFAULT (0) NULL,
          CURRENTDRIVESTATUSID   	NUMBER DEFAULT (0) NOT NULL,
          LASTSAMPLEDATETIME     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVE PRIMARY KEY (MONITOREDDRIVEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MONITOREDDRIVE');
      CREATESEQ('TTV_MONITOREDDRIVE',3);
      CREATEUPDATETRG('TTV_MONITOREDDRIVE');
      
    -- Creating index IX_TTV_MONITOREDDRIVE_1
       vsql :=  'create index WFS.IX_TTV_MONITOREDDRIVE_1 ON WFS.TTV_MONITOREDDRIVE (RESOURCEID,INTERNALDRIVEID)';
      CREATEOBJECT(vsql,'Unable to create index IX_TTV_MONITOREDDRIVE_1');

    -- creating table TTV_MONITOREDDRIVEHISTORY
       vsql :=  'CREATE TABLE WFS.TTV_MONITOREDDRIVEHISTORY ( 
          MONITOREDDRIVEHISTORYID	NUMBER(19,0) NOT NULL,
          MONITOREDDRIVEID       	NUMBER NOT NULL,
          CURRENTBYTESUSED       	NUMBER(19,0) NOT NULL,
          TOTALCAPACITY          	NUMBER(19,0) NOT NULL,
          WARNINGTHRESHOLDPERCENT	NUMBER NOT NULL,
          ERRORTHRESHOLDPERCENT  	NUMBER NOT NULL,
          CURRENTDRIVESTATUSID   	NUMBER NOT NULL,
          SAMPLEDATETIME         	TIMESTAMP(6) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVEHISTORY PRIMARY KEY (MONITOREDDRIVEHISTORYID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MONITOREDDRIVEHISTORY');
      CREATESEQ('TTV_MONITOREDDRIVEHISTORY',9);

    -- creating table TTV_MONITOREDDRIVESTATUS
       vsql :=  'CREATE TABLE WFS.TTV_MONITOREDDRIVESTATUS ( 
          MONITOREDDRIVESTATUSID	NUMBER NOT NULL,
          NAME                  	VARCHAR2(50) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVESTATUS PRIMARY KEY (MONITOREDDRIVESTATUSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MONITOREDDRIVESTATUS');
      CREATESEQ('TTV_MONITOREDDRIVESTATUS',3);
      CREATEUPDATETRG('TTV_MONITOREDDRIVESTATUS');
      
    -- creating table TTV_PROCDEFACCESSLEVEL
       vsql :=  'CREATE TABLE WFS.TTV_PROCDEFACCESSLEVEL ( 
          PROCESSDEFINITIONID	NUMBER(19,0) NOT NULL,
          ACCESSLEVELID      	NUMBER NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCDEFACCESSLEVEL');

    -- Creating Primary Key on TTV_PROCDEFACCESSLEVEL
       vsql :=  'ALTER TABLE WFS.TTV_PROCDEFACCESSLEVEL ADD ( CONSTRAINT PK_TTV_PROCDEFACCESSLEVEL PRIMARY KEY (PROCESSDEFINITIONID, ACCESSLEVELID))';
      CREATEOBJECT(vsql,'Unable to create Primary Key for TTV_PROCDEFACCESSLEVEL');
   
    -- creating table TTV_PROCESSDEFINITIONTYPE
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSDEFINITIONTYPE ( 
          PROCESSDEFINITIONTYPEID	NUMBER NOT NULL,
          NAME                   	VARCHAR2(50) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSDEFINITIONTYPE PRIMARY KEY (PROCESSDEFINITIONTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSDEFINITIONTYPE');
      CREATESEQ('TTV_PROCESSDEFINITIONTYPE',4);
      CREATEUPDATETRG('TTV_PROCESSDEFINITIONTYPE');


    -- creating table TTV_PROCESSINSTANCETYPE
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSINSTANCETYPE ( 
          PROCESSINSTANCETYPEID	NUMBER NOT NULL,
          NAME                 	VARCHAR2(50) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSINSTANCETYPE PRIMARY KEY (PROCESSINSTANCETYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSINSTANCETYPE');
      CREATESEQ('TTV_PROCESSINSTANCETYPE');
      CREATEUPDATETRG('TTV_PROCESSINSTANCETYPE');

    -- creating table TTV_PROCESSPRIORITY
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSPRIORITY ( 
          PROCESSPRIORITYID	NUMBER NOT NULL,
          NAME             	VARCHAR2(50) NOT NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSPRIORITY PRIMARY KEY (PROCESSPRIORITYID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSPRIORITY');
      CREATESEQ('TTV_PROCESSPRIORITY',5);
      CREATEUPDATETRG('TTV_PROCESSPRIORITY');

    -- creating table TTV_PROCESSSTATUS
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSSTATUS ( 
          PROCESSSTATUSID	NUMBER NOT NULL,
          NAME           	VARCHAR2(50) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSSTATUS PRIMARY KEY (PROCESSSTATUSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSSTATUS');
      CREATESEQ('TTV_PROCESSSTATUS',8);
      CREATEUPDATETRG('TTV_PROCESSSTATUS');

    -- creating table TTV_RESOURCE
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCE ( 
          RESOURCEID                    	NUMBER NOT NULL,
          NAME                          	VARCHAR2(50) NOT NULL,
          CONNECTIONSTRING              	VARCHAR2(255) NOT NULL,
          RESOURCETYPEID                	NUMBER NOT NULL,
          MAXCONCURRENTUSERS            	NUMBER NOT NULL,
          ADMINISTRATIVERESOURCESTATUSID	NUMBER NOT NULL,
          OPERATIONALRESOURCESTATUSID   	NUMBER NOT NULL,
          HEARTBEATCONNECTIONSTRING     	VARCHAR2(255) NULL,
          HEARTBEATFREQUENCY            	NUMBER NULL,
          ISACTIVE                      	NUMBER(1,0) NOT NULL,
          FUNCTIONALTYPE 			VARCHAR2(1024) NULL,
          IGNORETIMEOUT                   NUMBER(1,0) DEFAULT 0 NOT NULL,
          CREATEDATE                    	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                    	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          USER_NAME                     	VARCHAR2(96) NULL,
          CONSTRAINT PK_TTV_RESOURCE PRIMARY KEY (RESOURCEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCE');
      CREATESEQ('TTV_RESOURCE');
      CREATEUPDATETRG('TTV_RESOURCE');
      
    -- creating table TTV_RESOURCEGROUP
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEGROUP ( 
          RESOURCEGROUPID          	NUMBER NOT NULL,
          NAME                     	VARCHAR2(50) NOT NULL,
          RESOURCETYPEID           	NUMBER NOT NULL,
          ISINTERNALLYACQUIRED     	NUMBER(1,0) NOT NULL,
          ALLOCATIONSTRATEGYCLASSID	NUMBER NULL,
          ACCESSLEVELID            	NUMBER DEFAULT (0) NOT NULL, 
          FUNCTIONALTYPE 		        VARCHAR2(1024)  NULL,
          ISVISIBLE      		        NUMBER(1) DEFAULT(0) NOT NULL,  
          IMAGEPATH      		        VARCHAR2(4000)  NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEGROUP PRIMARY KEY (RESOURCEGROUPID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUP');
      CREATESEQ('TTV_RESOURCEGROUP',115);
      CREATEUPDATETRG('TTV_RESOURCEGROUP');
      
    -- creating table TTV_RESOURCEGROUPMEMBERSHIP
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP ( 
          RESOURCEID     	NUMBER NOT NULL,
          RESOURCEGROUPID	NUMBER NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUPMEMBERSHIP');
  
    -- Creating Primary Key on TTV_RESOURCEGROUP
       vsql :=  'ALTER TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP
          ADD ( CONSTRAINT PK_TTV_RESOURCEGROUPMEMBERSHIP
          PRIMARY KEY (RESOURCEID, RESOURCEGROUPID)
          )';
      CREATEOBJECT(vsql,'Unable to create Primary Key for TTV_RESOURCEGROUPMEMBERSHIP');

    -- creating table TTV_RESOURCESTATUS
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCESTATUS ( 
          RESOURCESTATUSID	NUMBER NOT NULL,
          NAME            	VARCHAR2(50) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCESTATUS PRIMARY KEY (RESOURCESTATUSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCESTATUS');
      CREATESEQ('TTV_RESOURCESTATUS',7);
      CREATEUPDATETRG('TTV_RESOURCESTATUS');
      
    -- creating table TTV_RESOURCETYPE
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCETYPE ( 
          RESOURCETYPEID               	NUMBER NOT NULL,
          NAME                         	VARCHAR2(50) NOT NULL,
          RESOURCECONNECTIONTYPEID     	NUMBER NOT NULL,
          INITIALIZATIONSTRATEGYCLASSID	NUMBER NULL,
          HEARTBEATSTRATEGYCLASSID     	NUMBER NULL,
          HEARTBEATCONNECTIONTYPEID    	NUMBER NULL,
          SYSTEMID       			VARCHAR2(4000)  NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCETYPE PRIMARY KEY (RESOURCETYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCETYPE');
      CREATESEQ('TTV_RESOURCETYPE',34);
      CREATEUPDATETRG('TTV_RESOURCETYPE');
    
    -- Create Unique index on the SYSTEMID column of the TTV_RESOURCETYPE table.
       vsql :=  'CREATE UNIQUE INDEX WFS.IDX_TTV_RESOURCETYPE_UK ON WFS.TTV_RESOURCETYPE(SYSTEMID)';
      CREATEOBJECT(vsql,'Unable to create a Unique index on SYSTEMID.TTV_RESOURCETYPE');
      
    -- creating table TTV_STRATEGYCLASS
       vsql :=  'CREATE TABLE WFS.TTV_STRATEGYCLASS ( 
          STRATEGYCLASSID    	NUMBER NOT NULL,
          NAME               	VARCHAR2(50) NOT NULL,
          DESCRIPTION        	VARCHAR2(500) NOT NULL,
          CLASSNAME          	VARCHAR2(4000) NULL,
          STRATEGYCLASSTYPEID	NUMBER NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_STRATEGYCLASS PRIMARY KEY (STRATEGYCLASSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_STRATEGYCLASS');
       CREATESEQ('TTV_STRATEGYCLASS',10);
      CREATEUPDATETRG('TTV_STRATEGYCLASS');

    -- creating table TTV_STRATEGYCLASSTYPE
       vsql :=  'CREATE TABLE WFS.TTV_STRATEGYCLASSTYPE ( 
          STRATEGYCLASSTYPEID	NUMBER NOT NULL,
          NAME               	VARCHAR2(50) NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_STRATEGYCLASSTYPE PRIMARY KEY (STRATEGYCLASSTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_STRATEGYCLASSTYPE');
      CREATESEQ('TTV_STRATEGYCLASSTYPE',4);
      CREATEUPDATETRG('TTV_STRATEGYCLASSTYPE');

      
    -- creating table TTV_TOKENTYPE
       vsql :=  'CREATE TABLE WFS.TTV_TOKENTYPE ( 
          TOKENTYPEID	NUMBER NOT NULL,
          NAME       	VARCHAR2(50) NULL,
          CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_TOKENTYPE PRIMARY KEY (TOKENTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_TOKENTYPE');
      CREATESEQ('TTV_TOKENTYPE');
      CREATEUPDATETRG('TTV_TOKENTYPE');
      
    -- creating table TTV_VARIABLEACCESSTYPE
       vsql :=  'CREATE TABLE WFS.TTV_VARIABLEACCESSTYPE ( 
          VARIABLEACCESSTYPEID	NUMBER NOT NULL,
          NAME                	VARCHAR2(50) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_VARIABLEACCESSTYPE PRIMARY KEY (VARIABLEACCESSTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_VARIABLEACCESSTYPE');
      CREATESEQ('TTV_VARIABLEACCESSTYPE',3);
      CREATEUPDATETRG('TTV_VARIABLEACCESSTYPE');

  
  -- Creating table UI_PROPERTIES
       vsql :=  'CREATE TABLE WFS.UI_PROPERTIES ( 
          NAME      	VARCHAR2(254) NOT NULL,
          VALUE     	VARCHAR2(254) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table UI_PROPERTIES');
  
      -- Create table TTV_SELECTOR
       vsql :=  'CREATE TABLE WFS.TTV_SELECTOR ( 
                                SELECTIONKEY		VARCHAR2(4000) 	NOT NULL,
                               PROCESSDEFINITIONID NUMBER(19,0)   	NULL,
                               CREATEDATE          DATE		NOT NULL,
                               UPDATEDATE          DATE   		NOT NULL
                              )';
      CREATEOBJECT(vsql,'Unable to create table TTV_SELECTOR');
      
      -- Create Primary Key for TTV_SELECTOR
       vsql :=  'ALTER TABLE WFS.TTV_SELECTOR ADD ( CONSTRAINT PK_TTV_SELECTOR PRIMARY KEY (SELECTIONKEY))';
      CREATEOBJECT(vsql,'Unable to create primary key for TTV_SELECTOR');
      
      -- Create table TTV_TRANSITIONTYPE
       vsql :=  'CREATE TABLE WFS.TTV_TRANSITIONTYPE (
                               TRANSITIONTYPEID    NUMBER NOT NULL,
                               NAME        VARCHAR2(50) NULL,
                               CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                               UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                               CONSTRAINT PK_TTV_TRANSITIONTYPE PRIMARY KEY (TRANSITIONTYPEID)
                              )';
      CREATEOBJECT(vsql,'Unable to create table TTV_TRANSITIONTYPE');
      CREATEUPDATETRG('TTV_TRANSITIONTYPE');
      
      -- added a new column initialvalue on jbpm_variableaccess table by Sahil on 08-19-2010
      vsql := 'ALTER TABLE '||vschema||'.jbpm_variableaccess ADD (initialvalue VARCHAR2(1024))';
      CREATEOBJECT(vsql,'Unable to add new column INITIALVALUE in jbpm_variableaccess');
      
 /*
  -----------------------------------------
   CREATING ALL VIEWS
  -----------------------------------------
  */
  
  -- Creating View VDW_NODE
       vsql :=  'CREATE VIEW WFS.VDW_NODE ( NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKID, TASKNAME, ISSTARTNODE, RESOURCEGROUPID, RESOURCEGROUPNAME, RESOURCETYPEID, RESOURCETYPENAME, TASKCONTROLLERID, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  n.ID_ NodeId,
                                  DECODE (n.CLASS_,       ''D'', ''DECISION'',
                                                      ''E'', ''END'',
                                                      ''R'', ''START'',
                                                      ''Y'', ''MANUAL'',
                                                      ''Z'', ''AUTOMATED'',
                                                      ''UNKNOWN'') NodeClass,
                                  n.NAME_ NodeName,
                                  n.PROCESSDEFINITION_ ProcessDefinitionId,
                                  d.NAME_ ProcessDefinitionName,
                                  n.NODECOLLECTIONINDEX_ NodeIndex,
                                  t.ID_ TaskId,
                                  t.NAME_ TaskName,
                                  DECODE (NVL (d.STARTSTATE_, -1), -1, 0, 1) IsStartNode,
                                  n.ResourceGroupId,
                                  NVL (g.Name, ''[N/A]'') ResourceGroupName,
                                  g.ResourceTypeId,
                                  NVL (ty.Name, ''[N/A]'') ResourceTypeName,
                                  TASKCONTROLLER_ TaskControllerId,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  n.CreateDate,
                                  n.UpdateDate
                          FROM    WFS.JBPM_NODE n
                          JOIN    WFS.JBPM_PROCESSDEFINITION d
                          ON (    d.ID_ = n.PROCESSDEFINITION_)
                          JOIN    WFS.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN WFS.TTV_ResourceGroup g
                          ON (    g.ResourceGroupId = n.ResourceGroupId)
                          LEFT JOIN WFS.TTV_ResourceType ty
                          ON (    ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN WFS.JBPM_TASK t
                          ON (    t.TASKNODE_ = n.ID_
                          OR              t.STARTSTATE_ = n.ID_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_NODE');
 
  -- Creating View VDW_PROCESSINSTANCE
       vsql :=  'CREATE VIEW WFS.VDW_PROCESSINSTANCE ( PROCESSINSTANCEID, LOCALSTARTDATE, LOCALENDDATE, ISSUSPENDED, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, ADMINSTATUSID, ADMINSTATUS, OPERSTATUSID, OPERSTATUS, PRIORITYID, PRIORITY, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  I.ID_ PROCESSINSTANCEID,
                                  START_ LOCALSTARTDATE,
                                  END_ LOCALENDDATE,
                                  ISSUSPENDED_ ISSUSPENDED,
                                  PROCESSDEFINITION_ PROCESSDEFINITIONID,
                                  NAME_ PROCESSDEFINITIONNAME,
                                  ADMINISTRATIVEPROCESSSTATUSID ADMINSTATUSID,
                                  ADS.NAME ADMINSTATUS,
                                  OPERATIONALPROCESSSTATUSID OPERSTATUSID,
                                  OPS.NAME OPERSTATUS,
                                  I.PROCESSPRIORITYID PRIORITYID,
                                  NVL (P.NAME, ''[N/A]'') PRIORITY,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  I.CREATEDATE,
                                  I.UPDATEDATE
                          FROM    WFS.JBPM_PROCESSINSTANCE I
                          JOIN    WFS.JBPM_PROCESSDEFINITION D
                          ON (    D.ID_ = PROCESSDEFINITION_)
                          JOIN    WFS.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN WFS.TTV_PROCESSPRIORITY P
                          ON (    P.PROCESSPRIORITYID = I.PROCESSPRIORITYID)
                          JOIN    WFS.TTV_PROCESSSTATUS ADS
                          ON (    ADS.PROCESSSTATUSID = ADMINISTRATIVEPROCESSSTATUSID)
                          JOIN    WFS.TTV_PROCESSSTATUS OPS
                          ON (    OPS.PROCESSSTATUSID = OPERATIONALPROCESSSTATUSID)';
      CREATEOBJECT(vsql,'Unable to create view VDW_PROCESSINSTANCE');
 
  -- Creating View VDW_LOG
       vsql :=  'CREATE OR REPLACE VIEW WFS.VDW_LOG
                          AS 
                  SELECT	l.ID_ LogId,
                          l.CLASS_ LogClass,
                          DECODE (l.CLASS_,''N'', ''NODE'',
                                          ''7'', ''MESSAGE'',
                                          ''8'', ''USAGE'',
                                          ''9'', ''QUEUE'',							
                                          ''UNKNOWN'') LogClassName,
                          l.DATE_ LocalDate,
                          n.ProcessDefinitionId,
                          n.ProcessDefinitionName,
                          p.ProcessInstanceId,
                          p.ProcessDefinitionTypeId,
                          l.NODE_ NodeId,
                          n.NodeClass,
                          n.NodeName,
                          n.NodeIndex,
                          n.IsStartNode,
                          l.ENTER_ LocalEnterDate,
                          l.LEAVE_ LocalLeaveDate,
                          l.DURATION_ Duration,
                          l.ResourceGroupId,
                          NVL (g.Name, ''[N/A]'') ResourceGroupName,
                          g.ResourceTypeId,
                          NVL (ty.Name, ''[N/A]'') ResourceTypeName,
                          l.ResourceId,
                          NVL (r.Name, ''[N/A]'') ResourceName,
                          AdministrativeStatusId	AdminStatusId,
                          ads.Name AdminStatus,
                          OperationalStatusId	OperStatusId,
                          ops.Name OperStatus,
                          INDEX_,
                          l.TOKEN_ TokenId,
                          l.CreateDate,
                          l.UpdateDate
                    FROM	WFS.JBPM_LOG l
                          JOIN	WFS.vDW_NODE n
                          ON (	n.NodeId = l.NODE_)
                          JOIN	WFS.JBPM_TOKEN t
                          ON (	t.ID_ = l.TOKEN_)
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)
                          LEFT JOIN WFS.TTV_ResourceGroup g
                          ON (	g.ResourceGroupId = l.ResourceGroupId)
                          LEFT JOIN WFS.TTV_ResourceType ty
                          ON (	ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN WFS.TTV_Resource r
                          ON (	r.ResourceId = l.ResourceId)
                          LEFT JOIN WFS.TTV_ProcessStatus ads
                          ON (	ads.ProcessStatusId = l.AdministrativeStatusId)
                          LEFT JOIN WFS.TTV_ProcessStatus ops
                          ON (	ops.ProcessStatusId = l.OperationalStatusId)';
      CREATEOBJECT(vsql,'Unable to create view VDW_LOG');
 
  -- Creating View VDW_TASKINSTANCE
  
       vsql :=  'CREATE VIEW WFS.VDW_TASKINSTANCE ( TASKINSTANCEID, TASKINSTANCENAME, LOCALCREATEDATE, LOCALENDDATE, ISCANCELLED, ISSUSPENDED, ISOPEN, TASKID, NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, TASKCONTROLLERID, TOKENID, PROCESSINSTANCEID, CURRENTADMINSTATUSID, CURRENTADMINSTATUS, CURRENTOPERSTATUSID, CURRENTOPERSTATUS, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_ TaskInstanceId,
                                  i.NAME_ TaskInstanceName,
                                  i.CREATE_ LocalCreateDate,
                                  i.END_ LocalEndDate,
                                  i.ISCANCELLED_ IsCancelled,
                                  i.ISSUSPENDED_ IsSuspended,
                                  i.ISOPEN_ IsOpen,
                                  i.TASK_ TaskId,
                                  n.NodeId,
                                  n.NodeClass,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.TaskControllerId,
                                  i.TOKEN_ TokenId,
                                  p.ProcessInstanceId,
                                  p.AdminStatusId CurrentAdminStatusId,
                                  p.AdminStatus CurrentAdminStatus,
                                  p.OperStatusId CurrentOperStatusId,
                                  p.OperStatus CurrentOperStatus,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	WFS.JBPM_TASKINSTANCE i
                          JOIN	WFS.vDW_NODE n
                          ON (	n.TaskId = i.TASK_)
                          JOIN	WFS.JBPM_TOKEN t
                          ON (	t.ID_ = i.TOKEN_)
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_TASKINSTANCE');

  -- Creating View VDW_VARIABLEACCESS
       vsql :=  'CREATE VIEW WFS.VDW_VARIABLEACCESS ( VARIABLEACCESSID, VARIABLENAME, ACCESSTYPE, MAPPEDNAME, TASKCONTROLLERID, VARIABLEINDEX, DATATYPEID, DATATYPENAME, NODEID, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	v.ID_ VariableAccessId,
                                  v.VARIABLENAME_ VariableName,
                                  v.ACCESS_ AccessType,
                                  v.MAPPEDNAME_ MappedName,
                                  v.TASKCONTROLLER_ TaskControllerId,
                                  v.Index_ VariableIndex,
                                  v.DataTypeId,
                                  t.DataTypeName,
                                  n.NodeId,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  v.CreateDate,
                                  v.UpdateDate
                          FROM	WFS.JBPM_VARIABLEACCESS v
                          JOIN	WFS.TTV_DATATYPE t
                          ON (	t.DataTypeId = v.DataTypeId)
                          JOIN	WFS.vDW_Node n
                          ON (	n.TaskControllerId = v.TASKCONTROLLER_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEACCESS');

  -- Creating View VDW_VARIABLEINSTANCE
       vsql :=  'CREATE VIEW WFS.VDW_VARIABLEINSTANCE ( VARIABLEINSTANCEID, CLASSCODE, CLASSNAME, VARIABLEINSTANCENAME, TOKENID, ISGLOBALVARIABLE, PROCESSINSTANCEID, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NUMERICVALUE, STRINGVALUE, LONGVALUE_, STRINGVALUE_, DOUBLEVALUE_, TOKENVARIABLEMAP_, TASKINSTANCEID, TASKINSTANCENAME, TASKID, NODEID, NODECLASS, NODENAME, NODEINDEX, TASKNAME, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_	VariableInstanceId,
                                  i.CLASS_ ClassCode,
                                  DECODE (i.CLASS_, ''N'', ''NULL'', ''S'', ''STRING'', ''L'', ''LONG'', ''[UNKNOWN]'') ClassName,
                                  i.NAME_ VariableInstanceName,
                                  i.TOKEN_ TokenId,
                                  DECODE (NVL (i.TOKENVARIABLEMAP_, -1), -1, 0, 1) IsGlobalVariable,
                                  i.PROCESSINSTANCE_ ProcessInstanceId,
                                  p.ProcessDefinitionId,
                                  p.ProcessDefinitionName,
                                  DECODE (i.CLASS_, ''L'', NVL (i.LONGVALUE_, i.DOUBLEVALUE_), NULL) NumericValue,
                                  DECODE (i.CLASS_, ''L'', NULL, i.STRINGVALUE_) StringValue,
                                  i.LONGVALUE_,
                                  i.STRINGVALUE_,
                                  i.DOUBLEVALUE_,
                                  i.TOKENVARIABLEMAP_,
                                  i.TASKINSTANCE_ TaskInstanceId,
                                  t.TaskInstanceName,
                                  t.TaskId,
                                  t.NodeId,
                                  t.NodeClass,
                                  t.NodeName,
                                  t.NodeIndex,
                                  t.TaskName,
                                  p.ProcessDefinitionTypeId,
                                  p.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	WFS.JBPM_VARIABLEINSTANCE i
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = i.PROCESSINSTANCE_)
                          LEFT JOIN WFS.vDW_TaskInstance t
                          ON (	t.TaskInstanceId = i.TASKINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEINSTANCE');
  
  /*
  -----------------------------------------
   CREATING TRIGGERS ON TABLES
  -----------------------------------------
  */
  -- Create Trigger TRG_JBPM_ID_PERMISSIONS_UPD
       vsql :=  'CREATE TRIGGER WFS.TRG_JBPM_ID_PERMISSIONS_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_ID_PERMISSIONS
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
      CREATEOBJECT(vsql,'Unable to create trigger TRG_JBPM_ID_PERMISSION_UPD');  
  
      -- Create Trigger TRG_TTV_SELECTOR_SEQ
      
      BEGIN
      
        execute immediate  'CREATE OR REPLACE TRIGGER WFS.TRG_TTV_SELECTOR_SEQ
                              BEFORE INSERT ON WFS.TTV_SELECTOR
                              FOR EACH ROW
                              BEGIN
                                  
                                  :NEW.CreateDate := sysdate;
                                  :NEW.UpdateDate := sysdate;
  
                              END;';
                              
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_SELECTOR_SEQ'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values ('''||err_msg||''')';
      GOTO bypass_install;
          
      END;
      
      -- Create Trigger TRG_TTV_SELECTOR_UPD   
      
      BEGIN
      
         execute immediate  'CREATE OR REPLACE TRIGGER WFS.TRG_TTV_SELECTOR_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_SELECTOR
                              FOR EACH ROW
                              BEGIN
                                  :NEW.UpdateDate := sysdate;
                              END;';
                             
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_SELECTOR_UPD'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values ('''||err_msg||''')';
      GOTO bypass_install;
          
      END;
      
  /*
  -----------------------------------------
   COMPILE PACKAGES AND PROCEDURES
  -----------------------------------------
  */
  
  -- Create Procedure SP_REINITIALIZESEQUENCE
  
                vsql :=  'CREATE OR REPLACE PROCEDURE WFS.SP_REINITIALIZESEQUENCE 
                              (tablename IN varchar2 , idcolumn IN varchar2 )
                              IS
                                  sequencename    varchar2 (100);
                                  maxsequence     INTEGER;
                                  sql_max         varchar2 (500);
                                  sql_createseq   varchar2 (500);
                                  sql_dropseq     varchar2 (500);
                                  varcount        INTEGER;
  
                              BEGIN
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Working on: '' || tablename);
  
                                  sequencename := ''WFS.'' || tablename || ''_seq'';
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Sequence:'' || sequencename);
  
                                  sql_max  := ''SELECT MAX('';
                                  sql_max  := sql_max || idcolumn;
                                  sql_max   := sql_max || '') FROM '' || tablename; 
  
                                  EXECUTE IMMEDIATE sql_max INTO varcount; 
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Current Sequence Number:'');
  
                                  varcount := NVL(varcount,0) + 1;
                                  -- DBMS_OUTPUT.PUT_LINE (varcount);
  
                                  -- Drop the sequence
                                  sql_dropseq  := ''DROP SEQUENCE '' || sequencename;
                                  -- DBMS_OUTPUT.PUT_LINE (sql_dropseq);
                                  BEGIN
                                  EXECUTE IMMEDIATE sql_dropseq;
  
                                      EXCEPTION
                                         WHEN OTHERS THEN
                                              null;
                                 END;
  
                                  -- Recreate the sequence
                                  sql_createseq   := ''CREATE SEQUENCE '' || sequencename;
                                  sql_createseq   := sql_createseq || '' START WITH '' || varcount;
                                  sql_createseq   := sql_createseq || '' INCREMENT BY 1'';
  
                                  -- DBMS_OUTPUT.PUT_LINE (sql_createseq);
  
                                  BEGIN
                                  EXECUTE IMMEDIATE sql_createseq;
  
                                   EXCEPTION
                                   WHEN OTHERS THEN
                                    null;
  
                                  END;
  
                                  DBMS_OUTPUT.PUT_LINE(''Sequence '' || sequencename || '' updated to '' || varcount);
  
                                  END;';
  
         CREATEOBJECT(vsql,'Unable to create SP_REINITIALIZESEQUENCE Procedure');
          
          
  
  /*
  -----------------------------------------
   INSERTING DEFAULT DATA INTO TABLES
  -----------------------------------------
  */
  
    -- Inserting default SYSTEM_RELEASE data
    BEGIN
    
      EXECUTE IMMEDIATE 'INSERT INTO WFS.SYSTEM_RELEASE VALUES 
                  (''RELEASE'','''||db_version||'.0'')';
                  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
        EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into SYSTEM_RELEASE'')';
        EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
        
    END;
  
  -- Inserting default TTV_CONNECTIONTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''URL'', TO_DATE(''15/06/2006 09:18:25 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:19:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''IP Address[:Port]'', TO_DATE(''15/06/2006 09:18:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:19:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Email'', TO_DATE(''15/06/2006 09:18:41 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:18:41 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
    EXCEPTION
      WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_CONNECTIONTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
    END;
  
  -- Inserting default TTV_STRATEGYCLASSTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Resource Initialization Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''Resource HeartBeat Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Resource Allocation Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_STRATEGYCLASSTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSPRIORITY data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''LOWEST'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''LOW'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''NORMAL'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''HIGH'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''HIGHEST'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSPRIORITY'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSSTATUS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''CREATED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''RUNNING'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''ERROR'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''PAUSED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''QUEUED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''CANCELLED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(6, ''STOPPED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(7, ''BUSY'', TO_DATE(''21/06/2006 06:16:19 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/06/2006 06:16:19 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID,NAME,CREATEDATE,UPDATEDATE)
    VALUES(8, ''BRANCH'', sysdate, sysdate)';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSSTATUS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default PROCESSINSTANCETYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM ProcessInstance'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV ProcessInstance'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSINSTANCETYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_TOKENTYPE data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM Token'', TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV Token'', TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_TOKENTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_ACCESSLEVEL data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''NON-ADULT'', TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''ADULT'', TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''COMMON'', TO_DATE(''11/09/2006 11:12:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 11:12:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_ACCESSLEVEL'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_VARIABLEACCESSTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM VariableAccess'', TO_DATE(''14/09/2006 09:34:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/09/2006 09:34:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV VariableAccess'', TO_DATE(''14/09/2006 09:34:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/09/2006 09:34:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_VARIABLEACCESSTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_MONITOREDDRIVESTATUS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''OK'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''WARNING'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''ERROR'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_MONITOREDDRIVESTATUS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_DATATYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''int'', TO_DATE(''05/06/2006 11:09:26 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:26 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''string'', TO_DATE(''05/06/2006 11:09:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''boolean'', TO_DATE(''05/06/2006 11:09:45 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:45 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''date'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''file'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(6, ''destination'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(7, ''duration'', TO_DATE(''30/09/2006 03:57:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/09/2006 03:57:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(8, ''url'', TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          -- Kinjal requested to insert a list value in the table on 03-22-2011
          EXECUTE IMMEDIATE 'INSERT INTO '||VSCHEMA||'.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(9, ''list'', systimestamp, systimestamp)';

      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_DATATYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default ALERTS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Resource Initialization Failure'', ''Resource Initialization Failure Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Protection Key Mismatch'', ''Protection Key Mismatch Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Saving Workorder Failed'', ''Workorder Save Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Workorder Failed'', ''Workorder Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Resource Failed'', ''Resource Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Workorder Creation Failed'', ''Create Workorder Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Database Operation Failed'', ''Database Operation Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) 
    VALUES (''Invalid Template License'', ''Invalid License for Templates Pattern'', 1,	3600, 1, 3600, ''LOG'')';

          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
	VALUES (''Template Ingest Failure'', ''Template Ingest Failure Pattern'', 1, 3600, 1, 3600, ''LOG'')';

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        VALUES (''Pitch Schedule Notification'',''Pitch Schedule Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        VALUES (''Drive Status'',''Drive Status'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        VALUES (''Planner Notification'',''Planner Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        --Vlada on Oct 21 2009
        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) 
        VALUES(''Login Failed'', ''Login Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        -- Vishal request on 08/24/2012
        vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        values (''EPGManager Publish Failure'',''EPGManager Publish Failure Pattern'',1,60,1,60,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        values (''EPGManager Merge Failure Alert'',''EPGManager Merge Failure Pattern'',1,60,1,60,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE)
        values (''EPGManager Translation Alert'',''EPGManager Translation Error Pattern'',1,60,1,60,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        values (''EPGManager Validation Rule Alert'',''EPGManager Validation Rule Failed Pattern'',1,60,1,60,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE)
        values (''EPGManager Validation Rule Abort'',''EPGManager Validation Rule Abort Pattern'',1,60,1,60,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS (IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) '||
                'VALUES (''Business Continuance status'',''Business Continuance status change pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ALERTS record for Business Continuance status change pattern');
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into ALERTS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default ALERT_ACTIONS
      BEGIN
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Resource Initialization Failure'', 1, ''7'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Protection Key Mismatch'', 1, ''5'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Workorder Creation Failed'', 1, ''9'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Workorder Failed'', 1, ''10'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Resource Failed'', 1, ''6'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Database Operation Failed'', 1, ''1'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Saving Workorder Failed'', 1, ''8'')';

          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) 
    VALUES (''Invalid Template License'', 1, ''11'')';

          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Template Ingest Failure'', 1, ''12'')';

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Planner Notification'',1,''14'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Drive Status'',1,''15'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Pitch Schedule Notification'',1,''13'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

    --Vlada on Oct 21 2009
    vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) VALUES(''Login Failed'', 1, ''4'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    
    
    -- Vishal request on 08/24/2012
    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Merge Failure Alert'',1,''19'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Publish Failure'',1,''20'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Translation Alert'',1,''16'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Validation Rule Alert'',1,''18'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Validation Rule Abort'',1,''17'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    
  
    vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER,ACTION_TYPE, DETAIL) VALUES (''Business Continuance status'',1,21)';
    CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ALERT_ACTIONS record for Business Continuance status change pattern');
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into ALERT_ACTIONS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default ALERT_NAMES data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Workorder Failed Pattern'', ''.*execution has failed.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Create Workorder Failed Pattern'', ''.*Failed to instantiate Work Order.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Resource Failed Pattern'', ''.*Failure Event for Resource.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Resource Initialization Failure Pattern'', ''.*Initialization Error.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Workorder Save Failed Pattern'', ''.*Failed to save the process.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Database Operation Failed Pattern'', ''.*SQLException.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Protection Key Mismatch Pattern'', ''.*mismatching protection keys.*'')';

	  EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN) 
    VALUES(''Invalid License for Templates Pattern'', ''.*License unavailable for template.*'')';

	  EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Template Ingest Failure Pattern'', ''.*Failed to ingest template.*'')';
    
     vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Pitch Schedule Notification Pattern'',''.*titles did not achieve status.*'')';
     CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

     vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Drive Status'',''.*drive status.*'')';
     CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

     vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Planner Notification Pattern'',''.*assets for planner.*'')';
     CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');
    
    --Change by Vlada Oct 21 2009
    vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES(ALERT_NAME, PATTERN) VALUES(''Login Failed Pattern'', ''.*login failed.*'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

    -- Vishal request on 08/24/2012.
    vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Merge Failure Pattern'',''.*Merge failed for.*'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

    vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Translation Error Pattern'',''.*Failure to translate EPG error for.*'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

    vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Validation Rule Abort Pattern'',''.*Validation rule caused abort for.*'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

    vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Validation Rule Failed Pattern'',''.*Validation rule failed for.*'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

    vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Publish Failure Pattern'',''.*Failure to publish EPG data for.*'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

    vsql := 'insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Business Continuance status change pattern'',''.*Business continuance status change.*'')';
    CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ALERT_NAMES record for Business Continuance status change pattern');
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into ALERT_NAMES'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSDEFINITIONTYPE
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM ProcessDefinition'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV ProcessDefinition'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''TTV Invisible ProcessDefinition'', TO_DATE(''03/10/2006 07:52:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''03/10/2006 07:52:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSDEFINITIONTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  
  
  -- Inserting default TTV_RESOURCESTATUSID data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Initializing'', TO_DATE(''20/06/2006 01:14:40 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:15:08 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''Online'', TO_DATE(''20/06/2006 01:14:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:15:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Offline'', TO_DATE(''20/06/2006 01:14:54 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:14:54 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''Initialization Error'', TO_DATE(''20/06/2006 01:15:14 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''23/06/2006 04:12:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''HeartBeat Error'', TO_DATE(''23/06/2006 04:12:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''23/06/2006 04:12:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (6, ''Error'')';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (7, ''Inactive'')';
    
            EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (8, ''Invalid'')';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_RESOURCESTATUS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_STRATEGYCLASS data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(1, ''XPort Initialization'', ''Initializes the XPort Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.XPortInitializationStrategy'', 1, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:46:37 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(2, ''VTPS Ping HeartBeat'', ''Sends periodic Ping messages to the VTPS Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.VTPSHeartBeatStrategy'', 2, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:47:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Default Resource Allocation'', ''Allocates resources within the Resource Group'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultResourceAllocationStrategy'', 3, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:47:29 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(5, ''Round Robin Resource Allocation'', ''Allocates resources within the Resource Group using Round Robin'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.RoundRobinResourceAllocationStrategy'', 3, 
           TO_DATE(''12/07/2006 11:49:07 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:48:02 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(6, ''Anystream Transcode Initialization'', ''Initializes the Anystream Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.AnystreamInitializationStrategy'', 1, 
           TO_DATE(''12/09/2006 11:05:31 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:30:17 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(7, ''Webservice HeartBeat'', ''HeartBeats for any subsystem that interfaces with a Webservice'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.WebserviceHeartBeatStrategy'', 2, 
           TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(8, ''XPort HeartBeat'', ''HeartBeats for XPort producer'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.XPortHeartBeatStrategy'', 2, 
           TO_DATE(''29/11/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(9, ''Anystream Heartbeat'', ''Heartbeats for Anystream Agility Transcoder'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AnystreamHeartBeatStrategy'', 2, 
           TO_DATE(''29/11/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_STRATEGYCLASS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
      -- Insert Default TTV_TRANSITIONTYPE   
      BEGIN
      
        EXECUTE IMMEDIATE 'Insert Into WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE)
          Values(1,''JBPM Standard Transition'',systimestamp,systimestamp)';
  
        EXECUTE IMMEDIATE 'Insert into WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE)
          Values(2,''TTV Transition'',systimestamp,systimestamp)';
          
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_TRANSITIONTYPE'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
          
      END;
      
      -- Inserting into table 'SYSTEM_SETTINGS'
      BEGIN
      
        EXECUTE IMMEDIATE 'INSERT INTO wfs.SYSTEM_SETTINGS (SETTING_TYPE, SETTING_VALUE) values (''RELEASE'','''||db_version||''')';
        
      EXCEPTION 
        WHEN OTHERS THEN
        
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
             (''error inserting SYSTEM_SETTINGS data'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
               
      END;
      
  /*
  -----------------------------------------
   CREATING FOREIGN KEY ON ALL TABLES
  -----------------------------------------
  */
  
    -- Creating Foreign Key on ALERTS
     vsql := 'ALTER TABLE WFS.ALERTS ADD (
                                      CONSTRAINT ALERTS#ALERT_NAMES
                                          FOREIGN KEY (ALERT_NAME) 
                                          REFERENCES WFS.ALERT_NAMES (ALERT_NAME))';
                                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for ALERTS');
  
    -- Creating Foreign Key on ALERT_ACTIONS

     vsql := 'ALTER TABLE WFS.ALERT_ACTIONS ADD (
                                      CONSTRAINT ALERT_ACTIONS#ALERTS 
                                          FOREIGN KEY (IDENTIFIER) 
                                          REFERENCES WFS.ALERTS (IDENTIFIER))';
                                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for ALERT_ACTIONS');    

  
    -- Creating Foreign Key on ALERT_ACTIONS_HIST
     vsql := 'ALTER TABLE WFS.ALERT_ACTIONS_HIST ADD (
                CONSTRAINT ALERT_ACTIONS_HIST#ALERTS_HIST 
                        FOREIGN KEY (HIST_KEY) 
                        REFERENCES WFS.ALERTS_HIST (HIST_KEY))';
                                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for ALERT_ACTIONS_HIST');
  
    -- Creating Foreign Key on JBPM_ACTION
     vsql := 'ALTER TABLE WFS.JBPM_ACTION ADD (
                                  CONSTRAINT JBPM_ACTION#JBPM_ACTION1
                                          FOREIGN KEY (TIMERACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_ACTION2 
                                          FOREIGN KEY (REFERENCEDACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_PDEFINITION 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_EHANDLER 
                                          FOREIGN KEY (EXCEPTIONHANDLER_) 
                                          REFERENCES WFS.JBPM_EXCEPTIONHANDLER (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_EVENT 
                                          FOREIGN KEY (EVENT_) 
                                          REFERENCES WFS.JBPM_EVENT (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_DELEGATION 
                                          FOREIGN KEY (ACTIONDELEGATION_) 
                                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_ACTION'); 
  
    -- Creating Foreign Key on JBPM_BYTEARRAY

     vsql :=  'ALTER TABLE WFS.JBPM_BYTEARRAY ADD (CONSTRAINT JBPM_BYTEARRAY#JBPM_MDEFINITN FOREIGN KEY (FILEDEFINITION_) REFERENCES WFS.JBPM_MODULEDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_BYTEARRAY'); 
  
    -- Creating Foreign Key on JBPM_BYTEBLOCK
     vsql :=  'ALTER TABLE WFS.JBPM_BYTEBLOCK ADD (CONSTRAINT JBPM_BYTEBLOCK#JBPM_BYTEARRAY  FOREIGN KEY (PROCESSFILE_) REFERENCES WFS.JBPM_BYTEARRAY (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_BYTEBLOCK');             
  
    -- Creating Foreign Key on JBPM_DELEGATION
     vsql :=  'ALTER TABLE WFS.JBPM_DELEGATION ADD (CONSTRAINT JBPM_DELEGATION#JBPM_PDEF  FOREIGN KEY (PROCESSDEFINITION_)  REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_DELEGATION'); 

    -- Creating Foreign Key on JBPM_EVENT
     vsql :=  'ALTER TABLE WFS.JBPM_EVENT ADD (
              CONSTRAINT JBPM_EVENT#JBPM_TRANSITION 
                      FOREIGN KEY (TRANSITION_) 
                      REFERENCES WFS.JBPM_TRANSITION (ID_),
              CONSTRAINT JBPM_EVENT#JBPM_TASK 
                      FOREIGN KEY (TASK_) 
                      REFERENCES WFS.JBPM_TASK (ID_),
              CONSTRAINT JBPM_EVENT#JBPM_PDEFINITION 
                      FOREIGN KEY (PROCESSDEFINITION_) 
                      REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_EVENT'); 

    -- Creating Foreign Key on JBPM_ID_GROUP
     vsql :=  'ALTER TABLE WFS.JBPM_ID_GROUP ADD (
                CONSTRAINT JBPM_ID_GROUP#JBPM_ID_GROUP 
                        FOREIGN KEY (PARENT_)
                        REFERENCES WFS.JBPM_ID_GROUP (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_ID_GROUP'); 

    -- Creating Foreign Key on JBPM_ID_MEMBERSHIP
     vsql :=  'ALTER TABLE WFS.JBPM_ID_MEMBERSHIP ADD (
                CONSTRAINT JBPM_ID_MEMBERSHIP#JBPM_ID_USR 
                        FOREIGN KEY (USER_) 
                        REFERENCES WFS.JBPM_ID_USER (ID_),
                CONSTRAINT JBPM_ID_MEMBERSHIP#JBPM_ID_GRP
                        FOREIGN KEY (GROUP_) 
                        REFERENCES WFS.JBPM_ID_GROUP (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_ID_MEMBERSHIP'); 


    -- Creating Foreign Key on JBPM_MODULEDEFINITION
     vsql :=      'ALTER TABLE WFS.JBPM_MODULEDEFINITION ADD (
                  CONSTRAINT JBPM_MDEFINITION#JBPM_TASK 
                          FOREIGN KEY (STARTTASK_) 
                          REFERENCES WFS.JBPM_TASK (ID_),
                  CONSTRAINT JBPM_MDEFINITION#JBPM_PDEF  
                          FOREIGN KEY (PROCESSDEFINITION_) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_MODULEDEFINITION'); 

    -- Creating Foreign Key on JBPM_NODE
     vsql :=      'ALTER TABLE WFS.JBPM_NODE ADD (
                  CONSTRAINT JBPM_NODE#JBPM_PDEFINITION1 
                          FOREIGN KEY (SUBPROCESSDEFINITION_) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                  CONSTRAINT JBPM_NODE#JBPM_NODE 
                          FOREIGN KEY (SUPERSTATE_) 
                          REFERENCES WFS.JBPM_NODE (ID_),
                  CONSTRAINT JBPM_NODE#JBPM_PDEFINITION2 
                          FOREIGN KEY (PROCESSDEFINITION_) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                  CONSTRAINT JBPM_NODE#JBPM_ACTION 
                          FOREIGN KEY (ACTION_) 
                          REFERENCES WFS.JBPM_ACTION (ID_),
                  CONSTRAINT JBPM_NODE#TTV_RESOURCEGROUP 
                          FOREIGN KEY (RESOURCEGROUPID) 
                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                  CONSTRAINT JBPM_NODE#JBPM_DELEGATION 
                          FOREIGN KEY (DECISIONDELEGATION) 
                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_NODE'); 
  
    -- Creating Foreign Key on JBPM_POOLEDACTOR
     vsql :=     'ALTER TABLE WFS.JBPM_POOLEDACTOR ADD (
                  CONSTRAINT JBPM_POOLACTR#JBPM_SLINSTANCE 
                          FOREIGN KEY (SWIMLANEINSTANCE_) 
                          REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_POOLEDACTOR'); 

  
    -- Creating Foreign Key on JBPM_PROCESSDEFINITION
     vsql := 'ALTER TABLE WFS.JBPM_PROCESSDEFINITION ADD (CONSTRAINT JBPM_PDEFINITION#TTV_PDEFTYPE FOREIGN KEY (PROCESSDEFINITIONTYPEID) REFERENCES WFS.TTV_PROCESSDEFINITIONTYPE (PROCESSDEFINITIONTYPEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_PROCESSDEFINITION'); 

    -- Creating Foreign Key on JBPM_RUNTIMEACTION
     vsql := 'ALTER TABLE WFS.JBPM_RUNTIMEACTION ADD (
              CONSTRAINT JBPM_RUNTIMEACTION#JBPM_ACTION 
                      FOREIGN KEY (ACTION_) 
                      REFERENCES WFS.JBPM_ACTION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_RUNTIMEACTION'); 

    -- Creating Foreign Key on JBPM_SWIMLANE
     vsql := 'ALTER TABLE WFS.JBPM_SWIMLANE ADD (
              CONSTRAINT JBPM_SWIMLANE#JBPM_MDEFINITION 
                      FOREIGN KEY (TASKMGMTDEFINITION_) 
                      REFERENCES WFS.JBPM_MODULEDEFINITION (ID_),
              CONSTRAINT JBPM_SWIMLANE#JBPM_DELEGATION
                      FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                      REFERENCES WFS.JBPM_DELEGATION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_SWIMLANE'); 
  
    -- Creating Foreign Key on JBPM_TASK
     vsql := 'ALTER TABLE WFS.JBPM_TASK ADD (
                CONSTRAINT JBPM_TASK#JBPM_TASKCONTROLLER 
                        FOREIGN KEY (TASKCONTROLLER_) 
                        REFERENCES WFS.JBPM_TASKCONTROLLER (ID_),
                CONSTRAINT JBPM_TASK#JBPM_MDEFINITION 
                        FOREIGN KEY (TASKMGMTDEFINITION_) 
                        REFERENCES WFS.JBPM_MODULEDEFINITION (ID_),
                CONSTRAINT JBPM_TASK#JBPM_SWIMLANE 
                        FOREIGN KEY (SWIMLANE_) 
                        REFERENCES WFS.JBPM_SWIMLANE (ID_),
                CONSTRAINT JBPM_TASK#JBPM_PDEFINITION 
                        FOREIGN KEY (PROCESSDEFINITION_) 
                        REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                CONSTRAINT JBPM_TASK#JBPM_DELEGATION 
                        FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                        REFERENCES WFS.JBPM_DELEGATION (ID_))';

    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TASK'); 

    -- Creating Foreign Key on JBPM_TASKCONTROLLER
     vsql := 'ALTER TABLE WFS.JBPM_TASKCONTROLLER ADD (
              CONSTRAINT JBPM_TCONTROLR#JBPM_DELEGATION 
                      FOREIGN KEY (TASKCONTROLLERDELEGATION_) 
                      REFERENCES WFS.JBPM_DELEGATION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TASKCONTROLLER'); 
  
  -- Creating Foreign Key on JBPM_TRANSITION
     vsql := 'ALTER TABLE WFS.JBPM_TRANSITION ADD (
              CONSTRAINT JBPM_TRANSITION#JBPM_PDEF 
                      FOREIGN KEY (PROCESSDEFINITION_) 
                      REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TRANSITION'); 
  
  -- Creating Foreign Key on JBPM_VARIABLEACCESS
     vsql := 'ALTER TABLE WFS.JBPM_VARIABLEACCESS ADD ( 
              CONSTRAINT FK_VARACC_TSKCTRL
                  FOREIGN KEY(TASKCONTROLLER_)
                  REFERENCES WFS.JBPM_TASKCONTROLLER(ID_),
              CONSTRAINT FK_VARACC_SCRIPT
                  FOREIGN KEY(SCRIPT_)
                  REFERENCES WFS.JBPM_ACTION(ID_),
              CONSTRAINT FK_JBPM_VARIABLEACCESS_VATYPE
                  FOREIGN KEY(VARIABLEACCESSTYPEID)
                  REFERENCES WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID),
              CONSTRAINT FK_JBPM_VARIABLEACCESS_TYPE
                  FOREIGN KEY(DATATYPEID)
                  REFERENCES WFS.TTV_DATATYPE(DATATYPEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_VARIABLEACCESS'); 

    IF ENABLE_PARTITION='FALSE' THEN
        -- Creating Foreign Key on JBPM_LOG
        vsql :=  'ALTER TABLE WFS.JBPM_LOG ADD (
                    CONSTRAINT JBPM_LOG#TTV_PSTATUS1 
                            FOREIGN KEY (ADMINISTRATIVESTATUSID) 
                            REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                    CONSTRAINT JBPM_LOG#TTV_PSTATUS2 
                            FOREIGN KEY (OPERATIONALSTATUSID) 
                            REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                    CONSTRAINT JBPM_LOG#TTV_RESOURCE 
                            FOREIGN KEY (RESOURCEID) 
                            REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                    CONSTRAINT JBPM_LOG#TTV_RESOURCEGROUP 
                            FOREIGN KEY (RESOURCEGROUPID) 
                            REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                    CONSTRAINT JBPM_LOG#JBPM_VARIABLEINSTANCE 
                            FOREIGN KEY (VARIABLEINSTANCE_) 
                            REFERENCES WFS.JBPM_VARIABLEINSTANCE (ID_),
                    CONSTRAINT JBPM_LOG#JBPM_TRANSITION 
                            FOREIGN KEY (TRANSITION_) 
                            REFERENCES WFS.JBPM_TRANSITION (ID_),
                    CONSTRAINT JBPM_LOG#JBPM_TASKINSTANCE 
                            FOREIGN KEY (TASKINSTANCE_) 
                            REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                    CONSTRAINT JBPM_LOG#JBPM_SWIMLANEINSTANCE 
                            FOREIGN KEY (SWIMLANEINSTANCE_) 
                            REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_),
                    CONSTRAINT JBPM_LOG#JBPM_LOG1 
                            FOREIGN KEY (PARENT_) 
                            REFERENCES WFS.JBPM_LOG (ID_),
                    CONSTRAINT JBPM_LOG#JBPM_BYTEARRAY1 
                            FOREIGN KEY (OLDBYTEARRAY_) 
                            REFERENCES WFS.JBPM_BYTEARRAY (ID_),
                    CONSTRAINT JBPM_LOG#JBPM_BYTEARRAY2 
                            FOREIGN KEY (NEWBYTEARRAY_) 
                            REFERENCES WFS.JBPM_BYTEARRAY (ID_),
                    CONSTRAINT JBPM_LOG#JBPM_ACTION 
                            FOREIGN KEY (ACTION_) 
                            REFERENCES WFS.JBPM_ACTION (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_LOG'); 
    
        -- Creating Foreign Key on JBPM_MODULEINSTANCE    
        vsql :=      'ALTER TABLE WFS.JBPM_MODULEINSTANCE ADD (
                      CONSTRAINT JBPM_MINSTANCE#JBPM_MDEF
                              FOREIGN KEY (TASKMGMTDEFINITION_) 
                              REFERENCES WFS.JBPM_MODULEDEFINITION (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_MODULEINSTANCE');    
        
        -- Creating Foreign Key on JBPM_PROCESSINSTANCE
         vsql := 'ALTER TABLE WFS.JBPM_PROCESSINSTANCE ADD (
                    CONSTRAINT JBPM_PINSTANCE#TTV_PPRIORITY
                            FOREIGN KEY (PROCESSPRIORITYID) 
                            REFERENCES WFS.TTV_PROCESSPRIORITY (PROCESSPRIORITYID),
                    CONSTRAINT JBPM_PINSTANCE#JBPM_TOKEN1 
                            FOREIGN KEY (SUPERPROCESSTOKEN_) 
                            REFERENCES WFS.JBPM_TOKEN (ID_),
                    CONSTRAINT JBPM_PINSTANCE#JBPM_PDEF 
                            FOREIGN KEY (PROCESSDEFINITION_) 
                            REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                    CONSTRAINT JBPM_PINSTANCE#TTV_PSTATUS1 
                            FOREIGN KEY (OPERATIONALPROCESSSTATUSID) 
                            REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                    CONSTRAINT JBPM_PINSTANCE#TTV_PSTATUS2 
                            FOREIGN KEY (ADMINISTRATIVEPROCESSSTATUSID) 
                            REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                    CONSTRAINT JBPM_PINSTANCE#TTV_PINSTTYPE 
                            FOREIGN KEY (PROCESSINSTANCETYPEID) 
                            REFERENCES WFS.TTV_PROCESSINSTANCETYPE (PROCESSINSTANCETYPEID))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_PROCESSINSTANCE');
    
      -- Creating Foreign Key on JBPM_TOKEN
        vsql := 'ALTER TABLE WFS.JBPM_TOKEN ADD ( 
                      CONSTRAINT FK_TOKEN_SUBPI
                          FOREIGN KEY(SUBPROCESSINSTANCE_)
                          REFERENCES WFS.JBPM_PROCESSINSTANCE(ID_),
                      CONSTRAINT FK_TOKEN_PROCINST
                          FOREIGN KEY(PROCESSINSTANCE_)
                          REFERENCES WFS.JBPM_PROCESSINSTANCE(ID_),
                      CONSTRAINT FK_TOKEN_PARENT
                          FOREIGN KEY(PARENT_)
                          REFERENCES WFS.JBPM_TOKEN(ID_),
                      CONSTRAINT FK_TOKEN_NODE
                          FOREIGN KEY(NODE_)
                          REFERENCES WFS.JBPM_NODE(ID_),
                      CONSTRAINT FK_JBPM_TOKEN_TTV_TOKENTYPE
                          FOREIGN KEY(TOKENTYPEID)
                          REFERENCES WFS.TTV_TOKENTYPE(TOKENTYPEID),
                     Constraint FK_TOKEN#PROCESSSTATUS_OPER
                          Foreign Key(OPERATIONALSTATUS)
                          References WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID),
                      Constraint FK_TOKEN#PROCESSSTATUS_ADMIN
                          Foreign Key(ADMINISTRATIVESTATUS)
                          References WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TOKEN');
    
      -- Create Foreign Key on JBPM_TOKENVARIABLEMAP
         vsql := 'ALTER TABLE WFS.JBPM_TOKENVARIABLEMAP ADD ( 
                  CONSTRAINT FK_TKVARMAP_CTXT
                      FOREIGN KEY(CONTEXTINSTANCE_)
                      REFERENCES WFS.JBPM_MODULEINSTANCE(ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TOKENVARIABLEMAP'); 
    
      -- Creating Foreign Key on JBPM_VARIABLEINSTANCE
        vsql := 'ALTER TABLE WFS.JBPM_VARIABLEINSTANCE ADD ( 
                  CONSTRAINT FK_VAR_TSKINST
                      FOREIGN KEY(TASKINSTANCE_)
                      REFERENCES WFS.JBPM_TASKINSTANCE(ID_),
                  CONSTRAINT FK_VARINST_TKVARMP
                      FOREIGN KEY(TOKENVARIABLEMAP_)
                      REFERENCES WFS.JBPM_TOKENVARIABLEMAP(ID_),
                  CONSTRAINT FK_BYTEINST_ARRAY
                      FOREIGN KEY(BYTEARRAYVALUE_)
                      REFERENCES WFS.JBPM_BYTEARRAY(ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_VARIABLEINSTANCE'); 

         -- Creating Foreign Key on TTV_MESSAGELOG
         vsql := 'ALTER TABLE WFS.TTV_MESSAGELOG ADD (
                  CONSTRAINT TTV_MESSAGELOG#TTV_RESOURCE
                          FOREIGN KEY (RESOURCEID) 
                          REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                  CONSTRAINT TTV_MESSAGELOG#JBPM_LOG
                          FOREIGN KEY (LOGID) 
                          REFERENCES WFS.JBPM_LOG (ID_))';
        CREATEOBJECT(VSQL,'Unable to create foreign Keys for TTV_MESSAGELOG'); 
/*
     -- Creating Foreign Key on TTV_TOKENRESOURCE
         vsql :=   'ALTER TABLE WFS.TTV_TOKENRESOURCE ADD (
                    CONSTRAINT TTV_TOKENRESOURCE#TTV_RGROUP 
                            FOREIGN KEY (RESOURCEGROUPID) 
                            REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                    CONSTRAINT TTV_TOKENRESOURCE#TTV_RESOURCE 
                            FOREIGN KEY (RESOURCEID) 
                            REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                    CONSTRAINT TTV_TOKENRESOURCE#JBPM_TOKEN 
                            FOREIGN KEY (TOKENID) 
                            REFERENCES WFS.JBPM_TOKEN (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_TOKENRESOURCE');     


        -- Creating Foreign Key on TTV_RESOURCEGROUPQUEUEITEM
         vsql :=  'ALTER TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ADD (
                      CONSTRAINT TTV_RGROUPQITEM#TTV_RGROUP 
                              FOREIGN KEY (RESOURCEGROUPID) 
                              REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                      CONSTRAINT TTV_RGROUPQUEUEITEM#JBPM_TOKEN 
                              FOREIGN KEY (TOKENID) 
                              REFERENCES WFS.JBPM_TOKEN (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEGROUPQUEUEITEM'); 

        -- Creating Foreign Key on TTV_RESOURCEUSAGEHISTORY
         vsql :=   'ALTER TABLE WFS.TTV_RESOURCEUSAGEHISTORY ADD (
                    CONSTRAINT TTV_RUSAGEHIST#TTV_RGROUP 
                            FOREIGN KEY (RESOURCEGROUPID) 
                            REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                    CONSTRAINT TTV_RUSAGEHIST#TTV_RESOURCE
                            FOREIGN KEY (RESOURCEID) 
                            REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                    CONSTRAINT TTV_RUSAGEHIST#JBPM_PINSTANCE 
                            FOREIGN KEY (PROCESSINSTANCEID) 
                            REFERENCES WFS.JBPM_PROCESSINSTANCE (ID_),
                    CONSTRAINT TTV_RUSAGEHIST#JBPM_NODE
                            FOREIGN KEY (NODEID) 
                            REFERENCES WFS.JBPM_NODE (ID_))';
      CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEUSAGEHISTORY'); 
*/

        -- Creating Foreign Key on TTV_PROCESSINSTANCENOTE
         vsql :=     'ALTER TABLE WFS.TTV_PROCESSINSTANCENOTE ADD (
                      CONSTRAINT TTV_PINSTANCENOTE#JBPM_PINST
                              FOREIGN KEY (PROCESSINSTANCEID) 
                              REFERENCES WFS.JBPM_PROCESSINSTANCE (ID_))';
        CREATEOBJECT(VSQL,'Unable to create foreign Keys for TTV_PROCESSINSTANCENOTE');

         --Partioning: Disabling FK linkage b/w JBPM_SWIMLANEINSTANCE and JBPM_MODULEINSTANCE
         -- Creating Foreign Key on JBPM_SWIMLANEINSTANCE
         vsql := 'ALTER TABLE WFS.JBPM_SWIMLANEINSTANCE ADD (
                    CONSTRAINT JBPM_SLINSTANCE#JBPM_MINSTANCE 
                            FOREIGN KEY (TASKMGMTINSTANCE_) 
                            REFERENCES WFS.JBPM_MODULEINSTANCE (ID_),
                    CONSTRAINT JBPM_SLINSTANCE#JBPM_SWIMLANE  
                            FOREIGN KEY (SWIMLANE_) 
                            REFERENCES WFS.JBPM_SWIMLANE (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_SWIMLANEINSTANCE'); 
    
        --Partioning: Disabling FK linkage b/w JBPM_MESSAGE and JBPM_TASKINSTANCE
        -- Creating Foreign Key on JBPM_MESSAGE
         vsql :=  'ALTER TABLE WFS.JBPM_MESSAGE ADD (
                    CONSTRAINT JBPM_MESSAGE#JBPM_TASKINSTANCE 
                            FOREIGN KEY (TASKINSTANCE_) 
                            REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                    CONSTRAINT JBPM_MESSAGE#JBPM_ACTION 
                            FOREIGN KEY (ACTION_) 
                            REFERENCES WFS.JBPM_ACTION (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_MESSAGE'); 

        --Partioning: Disabling FK linkage b/w JBPM_TIMER and JBPM_TASKINSTANCE
        -- Creating Foreign Key on JBPM_TIMER
         vsql := 'ALTER TABLE WFS.JBPM_TIMER ADD (
                  CONSTRAINT JBPM_TIMER#JBPM_TINSTANCE 
                          FOREIGN KEY (TASKINSTANCE_) 
                          REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                  CONSTRAINT JBPM_TIMER#JBPM_ACTION
                          FOREIGN KEY (ACTION_) 
                          REFERENCES WFS.JBPM_ACTION (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TIMER');

        --Partioning: Disabling FK linkage b/w JBPM_TASKACTORPOOL and JBPM_TASKINSTANCE
        -- Creating Foreign Key on JBPM_TASKACTORPOOL
         vsql := 'ALTER TABLE WFS.JBPM_TASKACTORPOOL ADD (
                  CONSTRAINT JBPM_TACTRPOOL#JBPM_POOLEDACTR 
                          FOREIGN KEY (POOLEDACTOR_) 
                          REFERENCES WFS.JBPM_POOLEDACTOR (ID_),
                  CONSTRAINT JBPM_TACTRPOOL##JBPM_TINSTANCE 
                          FOREIGN KEY (TASKINSTANCE_) 
                          REFERENCES WFS.JBPM_TASKINSTANCE (ID_))';
        CREATEOBJECT(VSQL,'Unable to create foreign Keys for JBPM_TASKACTORPOOL'); 
        
        -- Creating Foreign Key on JBPM_TASKINSTANCE
         vsql := 'ALTER TABLE WFS.JBPM_TASKINSTANCE ADD (
                  CONSTRAINT JBPM_TINSTANCE#JBPM_MINSTANCE 
                          FOREIGN KEY (TASKMGMTINSTANCE_) 
                          REFERENCES WFS.JBPM_MODULEINSTANCE (ID_),
                  CONSTRAINT JBPM_TINSTANCE#JBPM_TASK 
                          FOREIGN KEY (TASK_) 
                          REFERENCES WFS.JBPM_TASK (ID_),
                  CONSTRAINT JBPM_TINSTANCE#JBPM_SLINSTANCE 
                          FOREIGN KEY (SWIMLANINSTANCE_) 
                          REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TASKINSTANCE');  
        
            -- Creating Foreign Key on JBPM_COMMENT
        VSQL :=  'ALTER TABLE WFS.JBPM_COMMENT ADD (CONSTRAINT JBPM_COMMENT#JBPM_TASKINSTANCE FOREIGN KEY (TASKINSTANCE_) REFERENCES WFS.JBPM_TASKINSTANCE (ID_))';
        CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_COMMENT'); 
          
    END IF;


    -- Creating Foreign Key on TTV_MONITOREDDRIVE
     vsql := 'ALTER TABLE WFS.TTV_MONITOREDDRIVE ADD (
              CONSTRAINT TTV_MDRIVE#TTV_MDRIVESTATUS
                      FOREIGN KEY (CURRENTDRIVESTATUSID) 
                      REFERENCES WFS.TTV_MONITOREDDRIVESTATUS (MONITOREDDRIVESTATUSID),
              CONSTRAINT TTV_MDRIVE#TTV_RESOURCE 
                      FOREIGN KEY (RESOURCEID) 
                      REFERENCES WFS.TTV_RESOURCE (RESOURCEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MONITOREDDRIVE'); 

    -- Creating Foreign Key on TTV_MONITOREDDRIVEHISTORY
     vsql := 'ALTER TABLE WFS.TTV_MONITOREDDRIVEHISTORY ADD (
              CONSTRAINT TTV_MDRIVEHIST#TTV_MDRIVE
                      FOREIGN KEY (MONITOREDDRIVEID) 
                      REFERENCES WFS.TTV_MONITOREDDRIVE (MONITOREDDRIVEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MONITOREDDRIVEHISTORY'); 

  
    -- Creating Foreign Key on TTV_PROCDEFACCESSLEVEL
     vsql :=     'ALTER TABLE WFS.TTV_PROCDEFACCESSLEVEL ADD (
                  CONSTRAINT TTV_PROCDEFALEVEL#TTV_ALEVEL 
                          FOREIGN KEY (ACCESSLEVELID) 
                          REFERENCES WFS.TTV_ACCESSLEVEL (ACCESSLEVELID),
                  CONSTRAINT TTV_PDEFALEVEL#JBPM_PDEF
                          FOREIGN KEY (PROCESSDEFINITIONID) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_PROCDEFACCESSLEVEL');

    -- Creating Foreign Key on TTV_RESOURCE
     vsql :=   'ALTER TABLE WFS.TTV_RESOURCE ADD (
                CONSTRAINT TTV_RESOURCE#TTV_RTYPE 
                        FOREIGN KEY (RESOURCETYPEID) 
                        REFERENCES WFS.TTV_RESOURCETYPE (RESOURCETYPEID),
                CONSTRAINT TTV_RESOURCE#TTV_RSTATUS1 
                        FOREIGN KEY (OPERATIONALRESOURCESTATUSID) 
                        REFERENCES WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID),
                CONSTRAINT TTV_RESOURCE#TTV_RSTATUS2
                        FOREIGN KEY (ADMINISTRATIVERESOURCESTATUSID) 
                        REFERENCES WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCE'); 
  
    -- Creating Foreign Key on TTV_RESOURCEGROUP
     vsql :=   'ALTER TABLE WFS.TTV_RESOURCEGROUP ADD (
                CONSTRAINT TTV_RESOURCEGROUP#TTV_ALEVEL 
                        FOREIGN KEY (ACCESSLEVELID) 
                        REFERENCES WFS.TTV_ACCESSLEVEL (ACCESSLEVELID),
                CONSTRAINT TTV_RESOURCEGROUP#TTV_SGYCLASS
                        FOREIGN KEY (ALLOCATIONSTRATEGYCLASSID) 
                        REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                CONSTRAINT TTV_RESOURCEGROUP#TTV_RTYPE
                        FOREIGN KEY (RESOURCETYPEID) 
                        REFERENCES WFS.TTV_RESOURCETYPE (RESOURCETYPEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEGROUP'); 

    -- Creating Foreign Key on TTV_RESOURCEGROUPMEMBERSHIP
     vsql :=   'ALTER TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP ADD (
                CONSTRAINT TTV_RGRPMBRSHIP#TTV_RGROUP 
                        FOREIGN KEY (RESOURCEGROUPID) 
                        REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                CONSTRAINT TTV_RGRPMBRSHIP#TTV_RESOURCE 
                        FOREIGN KEY (RESOURCEID) 
                        REFERENCES WFS.TTV_RESOURCE (RESOURCEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEGROUPMEMBERSHIP'); 

    -- Creating Foreign Key on TTV_RESOURCETYPE
     vsql :=     'ALTER TABLE WFS.TTV_RESOURCETYPE ADD (
                  CONSTRAINT TTV_RESOURCETYPE#TTV_SGYCLASS1 
                          FOREIGN KEY (INITIALIZATIONSTRATEGYCLASSID) 
                          REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                  CONSTRAINT TTV_RESOURCETYPE#TTV_SGYCLASS2
                          FOREIGN KEY (HEARTBEATSTRATEGYCLASSID) 
                          REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                  CONSTRAINT TTV_RESOURCETYPE#TTV_CTYPE1
                          FOREIGN KEY (HEARTBEATCONNECTIONTYPEID) 
                          REFERENCES WFS.TTV_CONNECTIONTYPE (CONNECTIONTYPEID),
                  CONSTRAINT TTV_RESOURCETYPE#TTV_CTYPE2 
                          FOREIGN KEY (RESOURCECONNECTIONTYPEID) 
                          REFERENCES WFS.TTV_CONNECTIONTYPE (CONNECTIONTYPEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCETYPE'); 

    -- Creating Foreign Key on TTV_STRATEGYCLASS
     vsql :=   'ALTER TABLE WFS.TTV_STRATEGYCLASS ADD (
                CONSTRAINT TTV_SGYCLASS#TTV_SGYCLASSTYPE 
                        FOREIGN KEY (STRATEGYCLASSTYPEID) 
                        REFERENCES WFS.TTV_STRATEGYCLASSTYPE (STRATEGYCLASSTYPEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_STRATEGYCLASS'); 

   -- Creating Foreign Key on TTV_SELECTOR
     vsql :=     'ALTER TABLE WFS.TTV_SELECTOR
                              ADD ( CONSTRAINT TTV_SELECTOR#JBPM_PROCESSDEF
                              FOREIGN KEY(PROCESSDEFINITIONID)
                              REFERENCES WFS.JBPM_PROCESSDEFINITION("ID_")
                              ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE )';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_SELECTOR'); 
      
      -- Create Foreign Key on JBPM_TRANSITION
     vsql := 'ALTER TABLE WFS.JBPM_TRANSITION
               ADD ( CONSTRAINT FK_JBPM_TRANS_TTV_TRANSTYPE
               FOREIGN KEY(TRANSITIONTYPEID)
               REFERENCES WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID)
               ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE )';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TRANSITION'); 
                               
  /*
  ----------------------------------------
     ADD TABLE AND COLUMN COMMNETS
  ----------------------------------------
  */
  
  -- Adding Comment on the JBPM_PROCESSDEFINITION table
     vsql := 'COMMENT ON TABLE WFS.JBPM_PROCESSDEFINITION IS ''Stores general information about the process definition. Foreign Keys Node table - Start-state node in the process''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_PROCESSDEFINITION table'); 

  -- Adding comment on the JBPM_NODE table
     vsql := 'COMMENT ON TABLE WFS.JBPM_NODE IS ''Stores definition information about a node in a process definition.
                Foreign Keys
                Process Definition table - The process definition that the node belongs to 
                Process Definition table - Specify that this node calls a sub process. The sub process would complete execution before the parent process leaves this node
                Action table - Specify an action class to be executed for the node
                Node table - Specify that this node belongs to a superstate. Multiple nodes can belong to a superstate
                Delegation table - Specify that a decision has been delegated to a class''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_NODE table'); 
  
  -- Adding comment on the JBPM_TRANSITION table
     vsql :='COMMENT ON TABLE WFS.JBPM_TRANSITION IS ''Stores definition information about a transition in a process definition. 
              Foreign Keys
              Process Definition table - Specify the definition that the transition belongs to
              Node table - Specify the node that starts the transition
              Node table - Specify the node that the transition ends on''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TRANSITION table'); 
 
  -- Adding comment on the JBPM_ACTION table
     vsql :='COMMENT ON TABLE WFS.JBPM_ACTION IS ''Stores definition information about an action in a process definition.
              Foreign Keys 
              Process Definition table - Specify the definition that the action belongs to
              Event table - Specify the event that triggers the action
              Delegation table - Specify the action is delegated to
              ExceptionHandler? table - Specify the exception handler class for this action
              Action table - Specify the action is referenced by another action and
              Action table - Specify if there is a timer action''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ACTION table'); 
   
  -- Adding comment on the JBPM_DELEGATION table
     vsql :='COMMENT ON TABLE WFS.JBPM_DELEGATION IS ''Stores definition information about Java business classes that are specified in the process definition. 
              Foreign key
              Process Definition table - Specify the process definition that the delegation belongs to.''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_DELEGATION table'); 
 
  -- Adding comment on the JBPM_EVENT table
     vsql :='COMMENT ON TABLE WFS.JBPM_EVENT IS ''Stores definition information about an event that triggers an action in the process definition. 
              Foreign Keys Process Definition table - Specify the process definition that the event belongs to
              Node table - Specify the event belongs to a node
              Transition table - Specify the event belongs to a transition
              Task table - Specify the event belongs to a task''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_EVENT table'); 

  -- Adding comment on the JBPM_EXCEPTIONHANDLER table
     vsql :='COMMENT ON TABLE WFS.JBPM_EXCEPTIONHANDLER IS ''Stores definition information about an exception handler for an action.''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_EXEPTIONHANDLER table'); 

  -- Adding comment on the JBPM_DECISIONCONDITIONS table
     vsql :='COMMENT ON TABLE WFS.JBPM_DECISIONCONDITIONS IS ''Stores definition information about conditions specified in the process definition.''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_DECISIONCONDITIONS table'); 
  
  -- Adding comment on the JBPM_TASK table
     vsql :='COMMENT ON TABLE WFS.JBPM_TASK IS ''Stores definition information about tasks defined in the process definition. 
            Foreign Keys
            Process Definition table - Specify the process definition the task belongs to
            Module Definition table - Specify the TaskMgmtDefintion to be used for this task.
            Node table - Specify the node the task belongs to 
            Node table - Specify that this task belongs to the start-state of a process
            Delegation table - Specify the delegation of the task to a class
            Swimlane table - Specify the swimlane that the task uses for assignment
            Task Controller table - Specify the task assignment is delegated to a class''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASK table'); 
  
  -- Adding comment on the JBPM_TASKCONTROLLER table
     vsql :='COMMENT ON TABLE WFS.JBPM_TASKCONTROLLER IS ''Stores information that refers a task to a delegation class. 
              Foreign key
              Delegation table - Specify the class that is the controller for the task.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKCONTROLLER table'); 

  -- Adding comment on the JBPM_VARIABLEACCESS table
     vsql :='COMMENT ON TABLE WFS.JBPM_VARIABLEACCESS IS ''Stores information about the access levels for each variable associated to a particular node or task
            Foreign keys
            Node table - Specify the node that the variables belong to
            Task Controller table - Specify the task that the variables belong to
            Action table - Specify the action that the variables belong to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_VARIABLEACCESS table'); 

  -- Adding comment on the JBPM_SWIMLANE table
     vsql :='COMMENT ON TABLE WFS.JBPM_SWIMLANE IS ''Stores information about the swimlanes defined in the process definition.
              Foreign Keys
              Delegation table - Specify the class that determines assignment for this swimlane
              Module Definition table - All of the swimlanes for a process definition belong to a TaskMgmtDefintion. This is specified in the Module Definition table.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_SWIMLANE table'); 

  -- Adding comment on the JBPM_MODULEDEFINITION table
     vsql :='COMMENT ON TABLE WFS.JBPM_MODULEDEFINITION IS ''Stores information about modules used in the process definition
              Foreign Keys
              Process Definition table - Specify the process definition this module is used in
              Task table - Specify the task this module is used in''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MODULEDEFINITION table'); 
  
  -- Adding comment on the JBPM_ID_USER table
     vsql :='COMMENT ON TABLE WFS.JBPM_ID_USER IS ''Stores information about users in jBPM''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_USER table'); 
  
  -- Adding comment on the JBPM_ID_GROUP table
     vsql :='COMMENT ON TABLE WFS.JBPM_ID_GROUP IS ''Stores information about groups that users can belong to.
            Foreign Key
            ID Group - Parent/Child relationship between groups.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_GROUP table'); 
  
  -- Adding comment on the JBPM_ID_MEMBERSHIP
    vsql :='COMMENT ON TABLE WFS.JBPM_ID_MEMBERSHIP IS ''Cross reference table storing information about role and which groups a user belongs to.
        Foreign Keys
        ID Users table - Specify the user that belongs to the membership.
        ID Group table - Specify the group the membership belongs to.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_MEMBERSHIP table'); 
 
  -- Adding comment on the JBPM_ID_PERMISSIONS
    vsql :='COMMENT ON TABLE WFS.JBPM_ID_PERMISSIONS IS ''Defines permissions for a user''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_PERMISSIONS table'); 
  
  -- Adding comment on the JBPM_PROCESSINSTANCE
    vsql :='COMMENT ON TABLE WFS.JBPM_PROCESSINSTANCE IS ''Stores runtime information about an instance of a process. 
              Foreign keys
              Process Definition table - the process definition to be followed for this process instance execution 
              Token table - the root token that follows where the process execution is currently
              Token table - the super process token (if this process instance was called from another process instance)''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_PROCESSINSTANCE table'); 

  -- Adding comment on the JBPM_TOKEN table
    vsql :='COMMENT ON TABLE WFS.JBPM_TOKEN IS ''Stores information about the token representing execution location in the process instance
            Foreign keys
            Process Instance table - the process instance this token belongs to.
            Process Instance table - the sub process instance that the token belongs to.
            Node table - the node that the token points to as the current location of execution.
            Token table - parent/child relationship between tokens for a fork or sub process.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TOKEN table'); 
  
  -- Adding comment on the JBPM_MESSAGE table
    vsql :='COMMENT ON TABLE WFS.JBPM_MESSAGE IS ''Stores messages to create asynchronous processing of nodes.
            Foreign keys
            Token table - token the message belongs to
            Action table - action the message belongs to
            Node table - node the message belongs to
            Task Instance table - task instance the message belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MESSAGE table'); 
  
  -- Adding comment on JBPM_TASKINSTANCE
    vsql :='COMMENT ON TABLE WFS.JBPM_TASKINSTANCE IS ''Stores runtime information about an instance of a task
              Foreign keys
              Task table - the task that defines the instance
              Token table - the token the task belongs to
              Swimlane Instance table - the swimlane instance used to determine who works this task instance
              Module Instance table - the instance of the module to manage the task''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKINSTANCE table'); 

  -- Adding comment on JBPM_SWIMLANEINSTANCE 
    vsql :='COMMENT ON TABLE WFS.JBPM_SWIMLANEINSTANCE IS ''Stores runtime information about an instance of a swimlane
            Foreign keys
            Swimlane table - the swimlane that defines the instance
            Module Instance table - the instance of the module to manage the task''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_SWIMLANEINSTANCE table'); 

  -- Adding comment JBPM_POOLEDACTOR table
    vsql :='COMMENT ON TABLE WFS.JBPM_POOLEDACTOR IS ''Stores a list of actors for a swimlane instance
            Foreign Key 
            Swimlane Instance table - the swimlane instance the actor belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_POOLEDACTOR table'); 
  
  -- Adding comment JBPM_TASKACTORPOOL table 
    vsql :='COMMENT ON TABLE WFS.JBPM_TASKACTORPOOL IS ''Cross reference table between Pooled Actor and Task Instance
              Foreign Keys
              Pooled Actor - Actors for a swimlane instance
              Task Instance - Task the pooled actor belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKACTORPOOL table'); 

  -- Adding comment JBPM_COMMENT table 
    vsql :='COMMENT ON TABLE WFS.JBPM_COMMENT IS ''tores a comment message related to a token or task instance
              Foreign Keys
              Token table - the token the comment belongs to.
              Task Instance table - the task instance the comment belongs to.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_COMMENT table'); 

  -- Adding comment to JBPM_TOKENVARIABLEMAP table
    vsql :='COMMENT ON TABLE WFS.JBPM_TOKENVARIABLEMAP IS ''Cross reference table between token and module instances for context
            Foreign Keys
            Token table - the token representing the process execution
            Module Instance table - the context module instance for the token''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TOKENVARIABLEMAP table');

  -- Adding comment to JBPM_MODULEINSTANCE table
  
    vsql :='COMMENT ON TABLE WFS.JBPM_MODULEINSTANCE IS ''Stores runtime information about an instance of a module
            Foreign Keys
            Process Instance table - the process instance the module instance belongs to
            Module Definition table - the module definition that defines the module instance''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MODULEINSTANCE table');

  -- Adding comment on JBPM_RUNTIMEACTION table
    vsql :='COMMENT ON TABLE WFS.JBPM_RUNTIMEACTION IS ''Stores information about actions that are created at runtime
              Foreign Keys
              Process Instance table - the process instance the action belongs to
              Action table - the action definition that defines the action instance''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_RUNTIMEACTION table');
 
  -- Adding comment on JBPM_TIME table
    vsql :='COMMENT ON TABLE WFS.JBPM_TIMER IS ''Stores information about instances of timers that are running
            Foreign Keys
            Action table - The action that the timer belongs to
            Token table - the token that the timer belongs to
            Process Instance table - the process instance the timer belongs to
            Task Instance table - the task instance the timer belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TIMER table');
  
  -- Adding comment on JBPM_VARIABLEINSTANCE
    vsql :='COMMENT ON TABLE WFS.JBPM_VARIABLEINSTANCE IS ''Stores information about process variable instances
            Foreign Keys
            Token table - the token that the variables belong to
            Token Variable Map table - mapping to the module instance for the token
            Process Instance table - the process instance the variables belong to
            Byte Array table - the byte array stored for a serialized object process variable instance
            Task Instance table - the task instance the variables belong to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_VARIABLEINSTANCE table');

  -- Adding comment on JBPM_LOG table
    vsql :='COMMENT ON TABLE WFS.JBPM_LOG IS ''Stores process logs created by jBPM or application code during process execution
              Foreign Keys
              Token table - the token that the logs belong to
              Token table - the child token that the logs belong to
              Log table - parent/child relationship between logs
              Transition table - the transition the logs belong to
              Node table - the source node the logs belong to
              Node table - the destination node the logs belong to
              Variable Instance table - the variable instance that is referred to in the log
              Byte Array table - the old value of the byte array
              Byte Array table - the new value of the byte array
              Task Instance table - The task instance that is referred to in the log
              Swim Lane Instance table - the swimlane instance that is referred to in the log''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_LOG table');
  
  -- Adding comment on JBPM_BYTEARRAY table
    vsql :='COMMENT ON TABLE WFS.JBPM_BYTEARRAY IS ''Specifies the file definition module for a serialized process instance variable
            Foreign Key
            Module Definition table - Specify the file definition module''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_BYTEARRAY table');

  -- Adding comment on JBPM_BYTEBLOCK table 
    vsql :='COMMENT ON TABLE WFS.JBPM_BYTEBLOCK IS ''Stores the serialized process instance variable
            Foreign Key
            Byte Array table - The byte array that the byte block belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_BYTEBLOCK table');
  
  -- Adding comment on the ALERTS table
     vsql :='COMMENT ON TABLE WFS.ALERTS IS ''List of alerts defined in the system''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERTS table');

  -- Adding comment on ALERTS_HIST table
     vsql :='COMMENT ON TABLE WFS.ALERTS_HIST IS ''Stores history for all the alerts occurred''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERTS_HIST table');

  -- Adding comment on ALERT_ACTIONS table
     vsql :='COMMENT ON TABLE WFS.ALERT_ACTIONS IS ''Stores action information for alerts defined. Current actions supported are email and snmp traps''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERT_ACTIONS table');

  -- Adding comment on ALERT_ACTIONS_HIST table
     vsql :='COMMENT ON TABLE WFS.ALERT_ACTIONS_HIST IS ''history for all the alert action taken''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERT_ACTIONS_HIST table');
  
  -- Adding comment on ALERT_NAMES table
     vsql :='COMMENT ON TABLE WFS.ALERT_NAMES IS ''Stores alert patterns''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERT_NAMES table');

  -- Adding comment on TTV_ACCESSLEVEL table
     vsql :='COMMENT ON TABLE WFS.TTV_ACCESSLEVEL IS ''Contains all the protection keys''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_ACCESSLEVEL table');
 
  -- Adding comment on TTV_CONNECTIONTYPE table
     vsql :='COMMENT ON TABLE WFS.TTV_CONNECTIONTYPE IS ''The different types of Connection String values supported by Resource Manager. Resource Type declares the Connection Type and it expects for Resource Connection String values and Resource Heartbeat Connection String values''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_CONNECTIONTYPE table');
 
  -- Adding comment on TTV_DATATYPE table
     vsql :='COMMENT ON TABLE WFS.TTV_DATATYPE IS ''Contains list of data type supported for variables defined in the template''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_DATATYPE table');
  
  -- Adding comment on TTV_MESSAGELOG table
     vsql :='COMMENT ON TABLE WFS.TTV_MESSAGELOG IS ''Stores messages for each node''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MESSAGELOG table');

  -- Adding comment on TTV_MONITOREDDRIVE table
     vsql :='COMMENT ON TABLE WFS.TTV_MONITOREDDRIVE IS ''configuration information for san drives to be monitored''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVE table');
  
  -- Adding comment on TTV_MONITOREDDRIVEHISTORY table
     vsql :='COMMENT ON TABLE WFS.TTV_MONITOREDDRIVEHISTORY  IS ''Stores history for each of the drives configured in TTV_MONITORDRIVE''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVEHISTORY table');
  
  -- Adding comment on TTV_MONITOREDDRIVESTATUS table
     vsql :='COMMENT ON TABLE WFS.TTV_MONITOREDDRIVESTATUS IS ''Contains all possible status a drive can be in''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVESTATUS table');

  -- Adding comment on TTV_PROCDEFACCESSLEVEL table
      vsql := 'COMMENT ON TABLE WFS.TTV_PROCDEFACCESSLEVEL IS ''Mapping information between process definitions and access levels (protection keys)''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCDEFACCESSLEVEL table');
  
  -- Adding comment on TTV_PROCESSDEFINITIONTYPE table
      vsql := 'COMMENT ON TABLE WFS.TTV_PROCESSDEFINITIONTYPE IS ''Required as a result of sub-classing JBPM_PROCESSDEFINITION entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSDEFINITIONTYPE table');

  -- Adding comment on TTV_PROCESSINSTANCENOTE table
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSINSTANCENOTE IS ''Table to store notes attached to work orders while specifying reason for cancel, pause, e.t.c''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCENOTE table');
  
  -- Adding comment on TTV_PROCESSINSTANCETYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSINSTANCETYPE IS ''Required as a result of sub-classing JBPM_PROCESSINSTANCE entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCETYPE table');
  
  -- Adding comment on TTV_PROCESSPRIORITY table
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSPRIORITY IS ''Table contains the list of all possible Process Priorities available to the Workflow System.The process priority Ids assigned must be sorted from lowest priority to highest priority''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSPRIORITY table');
  
  -- Adding comment on TTV_PROCESSSTATUS table ALERTS
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSSTATUS IS ''The different Work Order / Process Status values allowed for the Operational and Administrative Status of a Process''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSSTATUS table');
  
  -- Adding comment on TTV_RESOURCE table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCE IS ''The Resources used by the Workflow System''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCE table');
  
  -- Adding comment on TTV_RESOURCEGROUP table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEGROUP IS ''The Resource Groups used by the Workflow System''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUP table');
  
  -- Adding comment on TTV_RESOURCEGROUPMEMBERSHIP table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP IS ''Table contains the many-to-many relationship between Resource Groups and Resources. The data shows the membership of each resource in a set of resource groups''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUPMEMBERSHIP table');
/*
  -- Adding comment to TTV_RESOURCEGROUPQUEITEM table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM IS ''Each Resource Group manages an ordered queue of Tokens. This table stores each of the queue items (with their order in the queue) for each resource group''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUPQUEITEM table');
*/  
  -- Adding comment to TTV_RESOURCESTATUS table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCESTATUS IS ''The different possible value for the Operational or Administrative Status of a Resource in the system''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCESTATUS table');
  
  -- Adding comment to TTV_RESOURCETYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCETYPE IS ''The different Resource Types supported by the system''';
     CREATEOBJECT(VSQL,'Unable to add comment on the TTV_RESOURCETYPE table');
/*  
  -- Adding comment to TTV_RESOURCEUSAGEHISTORY table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEUSAGEHISTORY IS ''NOT USED - THIS TABLE IS NOT USED ANYMORE''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEUSAGEHISTORY table');
*/  
  -- Adding comment to TTV_STRATEGYCLASS table
      vsql :='COMMENT ON TABLE WFS.TTV_STRATEGYCLASS IS ''The Strategy class implementations used by the Resource Manager in different scenarios (heartbeat, initialization, allocation). Each Strategy class is also aware of its Strategy Class Type''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_STRATEGYCLASS table');

  -- Adding comment to TTV_STRATEGYCLASSTYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_STRATEGYCLASSTYPE IS ''The different types of strategies that Resource Manager supports''';
     CREATEOBJECT(VSQL,'Unable to add comment on the TTV_STRATEGYCLASSTYPE table');
/*  
  -- Adding comment to TTV_TOKENRESOURCE table
      vsql :='COMMENT ON TABLE WFS.TTV_TOKENRESOURCE IS ''Maintains the relationship between tokens and the resource they use''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_TOKENRESOURCE table');
*/
  -- Adding comment to TTV_TOKENTYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_TOKENTYPE IS ''Required as a result of sub-classing JBPM_TOKEN entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_TOKENTYPE table');

  -- Adding comment to TTV_VARIABLEACCESSTYPE table ALERTS
      vsql :='COMMENT ON TABLE WFS.TTV_VARIABLEACCESSTYPE IS ''Required as a result of sub-classing JBPM_VARIABLEACCESS entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_VARIABLEACCESSYTPE table');
  
  -- Adding comment to UI_PROPERTIES table
      vsql :='COMMENT ON TABLE WFS.UI_PROPERTIES IS ''UNUSED TABLE''';
     CREATEOBJECT(vsql,'Unable to add comment on the UI_PROPERTIES table');

      -- Adding comment to TTV_TRANSITIONTYPE
      vsql :='COMMENT ON TABLE WFS.TTV_TRANSITIONTYPE IS ''Required as a result of sub-classing JBPM_TRANSITION entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_TRANSITIONTYPE table');
  
  /*
  ----------------------------------------
    Creating indexes on FK of JBPM_LOG table
  ----------------------------------------
  */
  
   --Create indexes on all Foreign keys of JBPM_LOG to prevent it getting locked exclusively when deleting rows from JBPM_VARIABLEINSTANCE table
    DECLARE
      cursor c1 is select 'CREATE INDEX '||vschema||'.IDX_JPLOG_'||substr(ucc.column_name,1,12)||'_'||ucc.position||' on '||vschema||'.JBPM_LOG('||ucc.column_name||')'||case when ENABLE_PARTITION='TRUE' then ' initrans 100 LOCAL' end as crindex
                        from dba_constraints uc, dba_cons_columns ucc , dba_constraints uc1
                        where uc.constraint_name = ucc.constraint_name
                        and uc.table_name = ucc.table_name
                        and uc.owner=ucc.owner
                        and uc.owner = upper(vschema)
                        and uc.constraint_type='R'
                        and uc.table_name = 'JBPM_LOG'
                        and uc.r_constraint_name = uc1.constraint_name
                        and uc.owner = uc1.owner;
    begin
      for r1 in c1 loop
          CREATEOBJECT(r1.crindex,'Unable to create index on JBPM_LOG table''Y');
      end loop;
    end;

  /*
  ----------------------------------------
     CREATING ALL PUBLIC SYNONYMS
  ----------------------------------------
  */
  
  /*
  ---------------------------------------------------
     GRANTING privileges to wfs_user_role
  ---------------------------------------------------
  */
  
          <<bypass_install>>
  
          COMMIT;
          
          IF wk_message = 'ERROR' THEN
          
          	--null;
            RAISE createWFSDB.INSTALL_FAILED;
             
          ELSE
          
             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''Installation of WFS schema objects completed SUCCESSFULLY'')';
             
          END IF;
          
    END CreateWFS;

	/***********************************************************************************************
	    ----------------------------------------CREATE QRTZ---------------------------------------------
	   *************************************************************************************************/
		PROCEDURE CreateQRTZ IS 
	        wk_message	varchar2(500);
	        wk_count		number;
	        err_msg		varchar2(500);
          vsql      varchar2(32000);
		BEGIN
			/*------------------------------------------------------------------
									CREATE QRTZ TABLES
			------------------------------------------------------------------*/
			-- CREATE TABLE WFS.qrtz_job_details
			vsql := 'CREATE TABLE '||vschema||'.qrtz_job_details
										  (
										    JOB_NAME  VARCHAR2(80) NOT NULL,
										    JOB_GROUP VARCHAR2(80) NOT NULL,
										    DESCRIPTION VARCHAR2(120) NULL,
										    JOB_CLASS_NAME   VARCHAR2(128) NOT NULL, 
										    IS_DURABLE VARCHAR2(1) NOT NULL,
										    IS_VOLATILE VARCHAR2(1) NOT NULL,
										    IS_STATEFUL VARCHAR2(1) NOT NULL,
										    REQUESTS_RECOVERY VARCHAR2(1) NOT NULL,
										    JOB_DATA BLOB NULL,
										    PRIMARY KEY (JOB_NAME,JOB_GROUP)
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_job_details.');
			
			-- CREATE TABLE WFS.qrtz_job_listeners
      vsql := 'CREATE TABLE '||vschema||'.qrtz_job_listeners
										  (
										    JOB_NAME  VARCHAR2(80) NOT NULL, 
										    JOB_GROUP VARCHAR2(80) NOT NULL,
										    JOB_LISTENER VARCHAR2(80) NOT NULL,
										    PRIMARY KEY (JOB_NAME,JOB_GROUP,JOB_LISTENER) ,
										    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
											REFERENCES '||vschema||'.QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_job_listeners.');
			
			-- CREATE TABLE WFS.qrtz_triggers
      vsql := 'CREATE TABLE '||vschema||'.qrtz_triggers
										  (
										    TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    JOB_NAME  VARCHAR2(80) NOT NULL, 
										    JOB_GROUP VARCHAR2(80) NOT NULL,
										    IS_VOLATILE VARCHAR2(1) NOT NULL,
										    DESCRIPTION VARCHAR2(120) NULL,
										    NEXT_FIRE_TIME NUMBER(13) NULL,
										    PREV_FIRE_TIME NUMBER(13) NULL,
										    PRIORITY NUMBER(13) NULL,
										    TRIGGER_STATE VARCHAR2(16) NOT NULL,
										    TRIGGER_TYPE VARCHAR2(8) NOT NULL,
										    START_TIME NUMBER(13) NOT NULL,
										    END_TIME NUMBER(13) NULL,
										    CALENDAR_NAME VARCHAR2(80) NULL,
										    MISFIRE_INSTR NUMBER(2) NULL,
										    JOB_DATA BLOB NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
											REFERENCES '||vschema||'.QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP) 
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_triggers.');

			-- CREATE TABLE WFS.qrtz_simple_triggers
      vsql := 'CREATE TABLE '||vschema||'.qrtz_simple_triggers
										  (
										    TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    REPEAT_COUNT NUMBER(7) NOT NULL,
										    REPEAT_INTERVAL NUMBER(12) NOT NULL,
										    TIMES_TRIGGERED NUMBER(7) NOT NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
											REFERENCES '||vschema||'.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_simple_triggers.');
	
			-- CREATE TABLE WFS.qrtz_cron_triggers
      vsql := 'CREATE TABLE '||vschema||'.qrtz_cron_triggers
										  (TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    CRON_EXPRESSION VARCHAR2(80) NOT NULL,
										    TIME_ZONE_ID VARCHAR2(80),
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
											REFERENCES '||vschema||'.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_cron_triggers.');
			
			-- CREATE TABLE WFS.qrtz_blob_triggers
			vsql := 'CREATE TABLE '||vschema||'.qrtz_blob_triggers
										  (TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    BLOB_DATA BLOB NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
										        REFERENCES '||vschema||'.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_blob_triggers.');
	
			-- CREATE TABLE WFS.qrtz_trigger_listeners
			vsql :=  'CREATE TABLE '||vschema||'.qrtz_trigger_listeners
										  (
										    TRIGGER_NAME  VARCHAR2(80) NOT NULL, 
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    TRIGGER_LISTENER VARCHAR2(80) NOT NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_LISTENER) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
											REFERENCES '||vschema||'.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_trigger_listeners.');
	
			-- CREATE TABLE WFS.qrtz_calendars
			vsql := 'CREATE TABLE '||vschema||'.qrtz_calendars
										  (CALENDAR_NAME  VARCHAR2(80) NOT NULL, 
										    CALENDAR BLOB NOT NULL,
										    PRIMARY KEY (CALENDAR_NAME) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_calendars.');
	
			-- CREATE TABLE WFS.qrtz_paused_trigger_grps
			vsql := 'CREATE TABLE '||vschema||'.qrtz_paused_trigger_grps
										  (TRIGGER_GROUP  VARCHAR2(80) NOT NULL, 
										    PRIMARY KEY (TRIGGER_GROUP) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_paused_trigger_grps.');
	
			-- CREATE TABLE WFS.qrtz_fired_triggers
			vsql := 'CREATE TABLE '||vschema||'.qrtz_fired_triggers 
										  (ENTRY_ID VARCHAR2(95) NOT NULL,
										    TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    IS_VOLATILE VARCHAR2(1) NOT NULL,
										    INSTANCE_NAME VARCHAR2(80) NOT NULL,
										    FIRED_TIME NUMBER(13) NOT NULL,
										    PRIORITY NUMBER(13) NOT NULL,
										    STATE VARCHAR2(16) NOT NULL,
										    JOB_NAME VARCHAR2(80) NULL,
										    JOB_GROUP VARCHAR2(80) NULL,
										    IS_STATEFUL VARCHAR2(1) NULL,
										    REQUESTS_RECOVERY VARCHAR2(1) NULL,
										    PRIMARY KEY (ENTRY_ID) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_fired_triggers.');
	
			-- CREATE TABLE WFS.qrtz_scheduler_state
			vsql := 'CREATE TABLE '||vschema||'.qrtz_scheduler_state 
										  (INSTANCE_NAME VARCHAR2(80) NOT NULL,
										    LAST_CHECKIN_TIME NUMBER(13) NOT NULL,
										    CHECKIN_INTERVAL NUMBER(13) NOT NULL,
										    PRIMARY KEY (INSTANCE_NAME) 
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_scheduler_state.');
	
			-- CREATE TABLE WFS.qrtz_locks
			vsql := 'CREATE TABLE '||vschema||'.qrtz_locks
										  (LOCK_NAME  VARCHAR2(40) NOT NULL, 
										    PRIMARY KEY (LOCK_NAME) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_locks.');
	
			/*------------------------------------------------------------------
									INSERT QRTZ Default Table Values
			------------------------------------------------------------------*/
			
			-- INSERTS FOR qrtz_locks
			BEGIN
				EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.qrtz_locks values(''TRIGGER_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.qrtz_locks values(''JOB_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.qrtz_locks values(''CALENDAR_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.qrtz_locks values(''STATE_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.qrtz_locks values(''MISFIRE_ACCESS'')';
			EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
	            	 					'Unable to insert into qrtz_locks.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        GOTO bypass_install;
			
			END;
	
			/*------------------------------------------------------------------
									CREATE INDEXES FOR QRTZ
			------------------------------------------------------------------*/
	
			-- CREATEING INDEXES FOR QRTZ
			BEGIN
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_j_req_recovery on '||vschema||'.qrtz_job_details(REQUESTS_RECOVERY)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_t_next_fire_time ON '||vschema||'.qrtz_triggers(NEXT_FIRE_TIME)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_t_state ON '||vschema||'.qrtz_triggers(TRIGGER_STATE)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_t_nft_st ON '||vschema||'.qrtz_triggers(NEXT_FIRE_TIME,TRIGGER_STATE)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_t_volatile ON '||vschema||'.qrtz_triggers(IS_VOLATILE)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_trig_name ON '||vschema||'.qrtz_fired_triggers(TRIGGER_NAME)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_trig_group ON '||vschema||'.qrtz_fired_triggers(TRIGGER_GROUP)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_trig_nm_gp ON '||vschema||'.qrtz_fired_triggers(TRIGGER_NAME,TRIGGER_GROUP)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_trig_volatile ON '||vschema||'.qrtz_fired_triggers(IS_VOLATILE)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_trig_inst_name ON '||vschema||'.qrtz_fired_triggers(INSTANCE_NAME)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_job_name ON '||vschema||'.qrtz_fired_triggers(JOB_NAME)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_job_group ON '||vschema||'.qrtz_fired_triggers(JOB_GROUP)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_job_stateful ON '||vschema||'.qrtz_fired_triggers(IS_STATEFUL)';
				EXECUTE IMMEDIATE 'create index '||vschema||'.idx_qrtz_ft_job_req_recovery ON '||vschema||'.qrtz_fired_triggers(REQUESTS_RECOVERY)';
			EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
	            	 					'Unable to create qrtz indexes.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        GOTO bypass_install;
			
			END;
			
			 <<bypass_install>>
	  
	          COMMIT;
	          
	          IF wk_message = 'ERROR' THEN
	          
	          	--null;
	            RAISE createWFSDB.INSTALL_FAILED;
	             
	          ELSE
	          
	             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
	           (''Installation of QRTZ COMPLETED SUCCESSFULLY'')';
	             
	          END IF;
			
		END CreateQRTZ;
   
   /***********************************************************************************************
    ----------------------------------------CREATE PMM---------------------------------------------
   *************************************************************************************************/
   --PROCEDURE CreatePMM(error out NUMBER(1,0)) IS 
   PROCEDURE CreatePMM IS 
        wk_message	varchar2(500);
        wk_count		number;
        err_msg		varchar2(500);
        vsql varchar2(32000);
	BEGIN
	
		wk_message := '';
		--DELETE FROM SYS.INSTALL_TABLE;
				
		/*------------------------------------------------------------------
								Create PMM Tables
		------------------------------------------------------------------*/
		
		-- CREATE TABLE PMM_TitleStatus
		vsql := 'CREATE TABLE '||vschema||'.PMM_TitleStatus (
                  ID_			NUMBER 		NOT NULL,
                  Description	VARCHAR(25)	NOT NULL,
                  CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                  UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                  CONSTRAINT PK_PMM_TitleStatus PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleStatus.');
    CREATEUPDATETRG('PMM_TitleStatus');
            
		-- CREATE TABLE PMM_Partner
      vsql := 'CREATE TABLE '||vschema||'.PMM_PARTNER (
                    ID_			    NUMBER 		    NOT NULL,
                    NAME			  VARCHAR2(25)  NOT NULL,
                    PartnerType	NUMBER		    NOT NULL,
                    ContextId	  NUMBER			  NULL,
                    ProviderId	VARCHAR2(25)  NULL,
                    Notes			  VARCHAR2(500)	NULL,
                    isactive 	  NUMBER(1,0)   DEFAULT(1) NOT NULL,
                    lookupkey   VARCHAR2(25) NULL,
                    CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Partner PRIMARY KEY (ID_))';
      CREATEOBJECT(vsql,'Unable to create table PMM_Partner.');
      CREATESEQ('PMM_Partner');
      CREATEUPDATETRG('PMM_Partner');

      -- Eugene Karpenko added pmm_content_class_type on 01-04-2012
      vsql := 'CREATE TABLE '||vschema||'.PMM_CONTENT_CLASS_TYPE (
                    CONTENT_CLASS_TYPE_ID NUMBER, 
                    NAME                  VARCHAR2(50 CHAR) NOT NULL,       
                    CONSTRAINT PK_PMM_CONTENT_CLASS_TYPE primary key (CONTENT_CLASS_TYPE_ID))';    
      CREATEOBJECT(vsql,'Unable to create table PMM_CONTENT_CLASS_TYPE');

      BEGIN
			  EXECUTE IMMEDIATE 'INSERT INTO '||VSCHEMA||'.pmm_content_class_type (content_class_type_id, name) VALUES (''0'', ''Package'')';
			  EXECUTE IMMEDIATE 'INSERT INTO '||VSCHEMA||'.pmm_content_class_type (content_class_type_id, name) VALUES (''1'', ''Series'')';      
			  EXECUTE IMMEDIATE 'INSERT INTO '||VSCHEMA||'.pmm_content_class_type (content_class_type_id, name) VALUES (''2'', ''Category'')';			
		  EXCEPTION 
			  WHEN OTHERS THEN
				  WK_MESSAGE := 'ERROR';
				  ERR_MSG :=SUBSTR(SQLERRM, 1, 500);
				  EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into pmm_content_class_type.'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||ERR_MSG||''')';
          GOTO BYPASS_INSTALL;		
		  END;
   
      -- create table PMM_CONTENT_CLASS by Eugene Karpenko dated 07-21-2010
      vsql := 'CREATE TABLE '||vschema||'.PMM_CONTENT_CLASS (
                    ID            NUMBER NOT NULL ENABLE,
                    NAME          VARCHAR2(25),
                    DESCRIPTION   VARCHAR2(255),
                    SPECIAL_USAGE NUMBER(1) DEFAULT 0 NOT NULL ENABLE,
                    IS_DEFAULT    NUMBER(1) DEFAULT 0 NOT NULL ENABLE,
                    DATA          CLOB,
                    CONTENT_CLASS_TYPE_ID NUMBER DEFAULT 0 NOT NULL,
                    CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                    UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                    CONSTRAINT PMM_CONTENT_CLASS_PK PRIMARY KEY (ID),
                    CONSTRAINT fk_pmm_content_class_type FOREIGN KEY (CONTENT_CLASS_TYPE_ID) REFERENCES '||vschema||'.pmm_content_class_type(content_class_type_id))';
    
      CREATEOBJECT(vsql,'Unable to create table PMM_CONTENT_CLASS');
      CREATESEQ('PMM_CONTENT_CLASS');
      CREATEUPDATETRG('PMM_CONTENT_CLASS');
      
      -- Eugene added a new index to the pmm_content_class table on 08-17-2010
      vsql := 'CREATE UNIQUE INDEX '||vschema||'.IDX_UNQ_PMM_CONTENT_CLASS_NAME ON '||vschema||'.PMM_CONTENT_CLASS(NAME)';
      CREATEOBJECT(vsql,'Unable to create index PMM_CONTENT_CLASS Name.');	
		
		      -- create table PMM_CONTENT_CLASS_PARTNER  by Eugene Karpenko dated: 08-04-2010
      vsql := 'CREATE TABLE '||vschema||'.PMM_CONTENT_CLASS_PARTNER (
                    CONTENT_CLASS_ID     NUMBER NOT NULL ENABLE,
                    PARTNER_ID           NUMBER NOT NULL ENABLE,
                    DATA                 CLOB,
                    CREATEDATE           TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                    UPDATEDATE           TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                    CONSTRAINT FK_CCPARTNER_PMMCONTCLASS FOREIGN KEY (CONTENT_CLASS_ID) REFERENCES '||vschema||'.PMM_CONTENT_CLASS(ID),
                    CONSTRAINT FK_CCPARTNER_PMMPARTNER FOREIGN KEY (PARTNER_ID) REFERENCES '||vschema||'.PMM_PARTNER(ID_),
                    CONSTRAINT PK_PMM_CONTENT_CLASS_PARTNER PRIMARY KEY (CONTENT_CLASS_ID, PARTNER_ID))';
                  
      CREATEOBJECT(vsql,'Unable to create table PMM_CONTENT_CLASS_PARTNER');
      CREATEUPDATETRG('PMM_CONTENT_CLASS_PARTNER');
    
    -- CREATE TABLE PMM_TITLE ,
    -- Add new columns CONTENT_CLASS_ID, PARTNER_ID by Eugene Karpenko dated: 08-04-2010
    vsql := 'CREATE TABLE '||vschema||'.PMM_TITLE (
										ID_					NUMBER 			NOT NULL,
										TitleStatusID		NUMBER				 NULL,
										ProviderID			NUMBER				 NULL,
										EXTERNALLOCATION 	VARCHAR2(50)		 NULL,
                    ASSET_ID        NUMBER,
                    ORIGINALTITLE_ID NUMBER,
                    ORIGINALTITLE_VERSION VARCHAR2(10),
                    LAST_MODIFIED_TIME TIMESTAMP NOT NULL,                          
                    CONTENT_CLASS_ID NUMBER, 
                    PARTNER_ID       NUMBER, 
                    RETIREMENT_DATE  TIMESTAMP,
                    MDMDOCID         NUMBER,
										CREATEDATE 			 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 			 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Title PRIMARY KEY (ID_),
                    CONSTRAINT FK_ORIGINALTITLE_TITLE_ID FOREIGN KEY (ORIGINALTITLE_ID) REFERENCES '||vschema||'.PMM_TITLE(ID_),
                    --CONSTRAINT FK_PMMCONCLSPARTNER FOREIGN KEY (CONTENT_CLASS_ID, PARTNER_ID) REFERENCES '||vschema||'.PMM_CONTENT_CLASS_PARTNER(CONTENT_CLASS_ID, PARTNER_ID),
                    CONSTRAINT FK_TITLE_PMMCONTCLASS FOREIGN KEY (CONTENT_CLASS_ID) REFERENCES '||vschema||'.PMM_CONTENT_CLASS(ID),
                    CONSTRAINT FK_TITLE_PMMPARTNER FOREIGN KEY (PARTNER_ID) REFERENCES '||vschema||'.PMM_PARTNER(ID_))';
                    
    CREATEOBJECT(vsql,'Unable to create table PMM_Title.');
    CREATESEQ('PMM_Title');
    CREATEUPDATETRG('PMM_Title');
    
    vsql := 'CREATE INDEX '||vschema||'.IDX_PMMTITLE_ASSETID ON '||vschema||'.PMM_TITLE(ASSET_ID)';
    CREATEOBJECT(vsql,'Unable to create index PMM_Title asset_id.');		

    -- Suresh added index idx_pmm_title_cc on 04/07/2011    
    VSQL := 'CREATE INDEX '||vschema||'.idx_pmm_title_cc ON '||vschema||'.pmm_title(content_class_id)';
    CREATEOBJECT(vsql,'Unable to create index PMM_Title idx_pmm_title_cc.');

    -- Suresh added index idx_pmm_title_mdmdocid on 05/04/2011    
    VSQL := 'CREATE INDEX '||VSCHEMA||'.idx_pmmtitle_id_mdmid_statid ON '||VSCHEMA||'.pmm_title(mdmdocid, id_, titlestatusid, originaltitle_id)';
    CREATEOBJECT(vsql,'Unable to create index PMM_Title idx_pmmtitle_id_mdmid_statid.');
    
		-- CREATE TABLE PMM_TitleListStatus
		vsql := 'CREATE TABLE '||vschema||'.PMM_TitleListStatus (
							ID_			NUMBER 		NOT NULL,
							Description	VARCHAR(25) NOT NULL,
							CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          		UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
              CONSTRAINT PK_PMM_TitleListStatus PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleListStatus.');
    CREATEUPDATETRG('PMM_TitleListStatus');
    
		-- CREATE TABLE PMM_LISTTYPE
    vsql := 'CREATE TABLE '||vschema||'.PMM_LISTTYPE (
										ID_			NUMBER 		NOT NULL,
										Description	VARCHAR(25) NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_LISTTYPE PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_LISTTYPE.');
		
		-- CREATE TABLE PMM_TitleList
    vsql := 'CREATE TABLE '||vschema||'.PMM_TitleList (
										ID_					NUMBER 		NOT NULL,
										NAME					VARCHAR2(50)	 NULL,
										DESCRIPTION 		VARCHAR2(255)	 NULL,
										TitleListTypeId	NUMBER		NOT NULL,
										TitleListStatusId NUMBER			 NULL,
										ProviderId			NUMBER			 NULL,
										ContextId			NUMBER			 NULL,
										PitchDate			  TIMESTAMP(6) NULL,
										IsActive				NUMBER(1,0)	DEFAULT(1) NOT NULL,
										CREATEDATE 			TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 			TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TitleList PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleList.');
    CREATESEQ('PMM_TitleList');
    CREATEUPDATETRG('PMM_TitleList');
    
		-- CREATE TABLE PMM_Title_TitleListXREF
		vsql := 'CREATE TABLE '||vschema||'.PMM_Title_TitleListXREF (
										TitleListId	NUMBER NOT NULL,
										TitleId		NUMBER NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    ORDER_ number default 0 not null,
                    CONSTRAINT PK_PMM_Title_TitleListXREF PRIMARY KEY (TitleListId, TitleId,Order_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_Title_TitleListXREF.');
		
		-- CREATE TABLE PMM_ProgressItem
		vsql := 'CREATE TABLE '||vschema||'.PMM_ProgressItem (
										ID_				NUMBER 		NOT NULL,
										TitleID			NUMBER 		NOT NULL,
										TitleListID		NUMBER 			 NULL,
										NAME				VARCHAR2(255) NOT NULL,
										DESCRIPTION 	VARCHAR2(4000)	 NULL,
										ISSUCCESSFUL	NUMBER(1,0)	DEFAULT(1) NOT NULL,
										ACTIONDATE 		TIMESTAMP(6) NOT NULL,
                    TITLEVERSION VARCHAR2(25) NOT NULL,
                    SOURCECOMPONENTNAME VARCHAR2(25) NOT NULL,
                    SOURCEENTITYNAME VARCHAR2(25),
                    SOURCEID VARCHAR2(100) NOT NULL,
                    ISACTIVE NUMBER(1,0) DEFAULT (1) NOT NULL,
										CREATEDATE 		TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 		TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_ProgressItem PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_ProgressItem.');
    CREATESEQ('PMM_ProgressItem');
    CREATEUPDATETRG('PMM_ProgressItem');
    
    -- Creating Index IDX_PMMPRGITEM_TITLEID
    vsql :=  'CREATE INDEX '||vschema||'.IDX_PMMPRGITEM_TITLEID ON '||vschema||'.PMM_ProgressItem(TITLEID)';
    CREATEOBJECT(vsql,'Unable to create index IDX_PMMPRGITEM_TITLEID');    
    
		-- CREATE TABLE PMM_TitleListDetails
		vsql := 'CREATE TABLE '||vschema||'.PMM_TitleListDetails (
										TitleListID		NUMBER NOT NULL,
										DetailTypeID	NUMBER NOT NULL,
										VALUE				VARCHAR2(255) NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TitleListDetails PRIMARY KEY (TitleListID, DetailTypeID))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleListDetails.');
    CREATEUPDATETRG('PMM_TitleListDetails');
    
		-- CREATE TABLE PMM_TitleListDetailsType

    vsql := 'CREATE TABLE '||vschema||'.PMM_TitleListDetailsType (
										ID_			NUMBER 		 NOT NULL,
										Name			VARCHAR2(25) NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
       							UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TitleListDetailsType PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleListDetailsType.');
    CREATEUPDATETRG('PMM_TitleListDetailsType');
    
		-- CREATE TABLE PMM_PartnerType
		vsql :='CREATE TABLE '||vschema||'.PMM_PartnerType (
										ID_			NUMBER 		 NOT NULL,
										NAME			VARCHAR2(50) NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_PartnerType PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_PartnerType.');
    CREATEUPDATETRG('PMM_PartnerType');
    
		-- CREATE TABLE PMM_Context
		vsql := 'CREATE TABLE '||vschema||'.PMM_Context (
										ID_					NUMBER NOT NULL,
										ContainerTypeID	NUMBER NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Context PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Context.');
    CREATESEQ('PMM_Context');
    CREATEUPDATETRG('PMM_Context');
    
		-- CREATE TABLE PMM_ContainerType
		vsql := 'CREATE TABLE '||vschema||'.PMM_ContainerType (
              ID_			NUMBER 		 NOT NULL,
							Name			VARCHAR2(10) NOT NULL,
							CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          		UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
              CONSTRAINT PK_PMM_ContainerType PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_ContainerType.');
    CREATEUPDATETRG('PMM_ContainerType');
    
		-- CREATE TABLE PMM_Contact
    vsql := 'CREATE TABLE '||vschema||'.PMM_Contact (
										ID_			NUMBER 		 NOT NULL,
										PartnerID	NUMBER 		 NOT NULL,
										FirstName	VARCHAR2(25) 	  NULL,
										LastName		VARCHAR2(25) 	  NULL,
										Email			VARCHAR2(50) NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Contact PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Contact.');
    CREATESEQ('PMM_Contact');
    CREATEUPDATETRG('PMM_Contact');
    
		-- CREATE TABLE PMM_PROPERTIES
    vsql := 'CREATE TABLE '||vschema||'.PMM_PROPERTIES (
										ID_			NUMBER 		NOT NULL,
										Name			VARCHAR2(4000 CHAR) NOT NULL,
										Value       VARCHAR2(4000)	 NULL,
										TitleId		NUMBER 		NOT NULL,
										TitleListId NUMBER 			 NULL,
										ContextId	NUMBER 			 NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_PROPERTIES PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_PROPERTIES.');
    CREATESEQ('PMM_PROPERTIES');
    CREATEUPDATETRG('PMM_PROPERTIES');
    
      --create table PMM_TITLEASSETSTATUS. By Suneeta 05/14/09
      vsql := 'create table '||vschema||'.PMM_TITLEASSETSTATUS(
                id number,
                titleid number,
                assetVersion varchar2(10),
                titlestatus number,
                CREATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP), 
                UPDATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP),
                constraint pk_pmmtitleassetstation primary key (id),
                CONSTRAINT fk_pmmtas_titleSTATUS  FOREIGN KEY (titlestatus)  REFERENCES '||vschema||'.pmm_titlestatus(id_),
                CONSTRAINT fk_pmmtas_TITLEid  FOREIGN KEY (titleid) REFERENCES '||vschema||'.pmm_title(id_)            
                )';
      CREATEOBJECT(vsql,'Unable to create table PMM_TITLEASSETSTATUS');
      CREATESEQ('PMM_TITLEASSETSTATUS');
      CREATEUPDATETRG('PMM_TITLEASSETSTATUS');

      vsql := 'CREATE INDEX '||vschema||'.IDX_PMMTAS_TITLEID ON '||vschema||'.PMM_TITLEASSETSTATUS(titleid)';
      CREATEOBJECT(vsql,'Unable to create index on PMM_TITLEASSETSTATUS titleid');
      
      --create table PMM_CONTAINER_PROPERTIES. By Suneeta 07/06/09
      vsql := 'CREATE TABLE '||vschema||'.PMM_CONTAINER_PROPERTIES(
                id number PRIMARY KEY,
                contextid number,
                name varchar2(100),
                value varchar2(250),
                CREATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                UPDATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                CONSTRAINT CONTEXTID_FK FOREIGN KEY (contextid) REFERENCES '||vschema||'.PMM_CONTEXT(id_)
                )';
      CREATEOBJECT(vsql,'Unable to create table PMM_CONTAINER_PROPERTIES');
      CREATESEQ('PMM_CONTAINER_PROPERTIES');
      CREATEUPDATETRG('PMM_CONTAINER_PROPERTIES');

      -- created table PMM_PARTNER_USERS by Vijay Silva dated 08-19-2010
      vsql := ' CREATE TABLE '||vschema||'.PMM_PARTNER_USERS (
                ID            NUMBER(10) NOT NULL,
                PARTNER_ID    NUMBER(10) NOT NULL,
                USERNAME      VARCHAR2(100) NOT NULL,
                CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                CONSTRAINT    PK_PMM_PARTNER_USERS_ID PRIMARY KEY (ID),
                CONSTRAINT    FK_PMMPTNRUSRS_PMMPARTNER FOREIGN KEY (PARTNER_ID) REFERENCES '||vschema||'.PMM_PARTNER(ID_))';  
                
      CREATEOBJECT(vsql,'Unable to create table PMM_PARTNER_USERS');
      CREATESEQ('PMM_PARTNER_USERS');
      CREATEUPDATETRG('PMM_PARTNER_USERS');
      
      -- added a new column THUMBNAIL to the PMM_PARTNER table by Vijay on 08-19-2010
      vsql := 'ALTER TABLE '||vschema||'.PMM_PARTNER ADD (THUMBNAIL BLOB)';
      CREATEOBJECT(vsql,'Unable to add new column THUMBNAIL in PMM_PARTNER');
      
      -- Created a unique key index on PMM_PARTNER_USERS(PARTNER_ID,USERNAME) for Vijay on 08-20-2010
      vsql := 'CREATE UNIQUE INDEX '||vschema||'.IDX_UNQ_PMM_PARTNER_USERS_NAME ON '||vschema||'.PMM_PARTNER_USERS(PARTNER_ID,USERNAME)';
      CREATEOBJECT(vsql,'Unable to create index PMM_PARTNER_USERS(PARTNER_ID,USERNAME)');
      
      -- created table PMM_TITLEASSET_PROPERTY by Gunnar dated 08-26-2010
      vsql := 'CREATE TABLE '||vschema||'.PMM_TITLEASSET_PROPERTY (
                  ID_         NUMBER,
                  TITLEID     NUMBER,
                  ASSETID     NUMBER,
                  NAME        VARCHAR(100),
                  VALUE       VARCHAR(256),
                  VALUE_UPDATE_DATE TIMESTAMP,
                  ASSETTYPE   VARCHAR2(50),
                  CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                  UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                  CONSTRAINT PK_PMM_TITLEASSET_PROPERTY_ID PRIMARY KEY (ID_),
                  CONSTRAINT FK_PMM_TITLEASSET_PROP_TITLEID FOREIGN KEY (TITLEID) REFERENCES '||vschema||'.PMM_TITLE(ID_),
                   CONSTRAINT UNQ_PMM_TITLEASSET_PROPERTY UNIQUE (TITLEID, ASSETID, NAME, VALUE))';  

      CREATEOBJECT(vsql,'Unable to create table PMM_TITLEASSET_PROPERTY');
      CREATESEQ('PMM_TITLEASSET_PROPERTY');
      CREATEUPDATETRG('PMM_TITLEASSET_PROPERTY'); 
      
      -- created table PMM_TITLE_RESOURCE by Vijay dated 08-31-2010
      vsql := 'CREATE TABLE WFS.PMM_TITLE_RESOURCE(
      ID_                   NUMBER,
      TITLEID               NUMBER NOT NULL, 
      RESOURCE_PATH         VARCHAR2(256) NOT NULL, 
      CREATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
      UPDATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
      CONSTRAINT PK_PMM_TITLE_RESOURCE_ID PRIMARY KEY (ID_))';  

      CREATEOBJECT(vsql,'Unable to create table PMM_TITLE_RESOURCE');
      CREATESEQ('PMM_TITLE_RESOURCE');
      CREATEUPDATETRG('PMM_TITLE_RESOURCE'); 

      -- Created history table and Trigger for the Title Purge report by Suresh Neravati 09-09-2010
      vsql := 'CREATE TABLE '||vschema||'.PMM_TITLE_PURGE_HISTORY (
                    ID_                   NUMBER,        
                    TITLE_ID              NUMBER   NOT NULL,
                    PROVIDER_ID           VARCHAR2(25) NOT NULL,
                    PROVIDER_NAME         VARCHAR2(25) NOT NULL,
                    TITLE_RETIREMENT_DATE TIMESTAMP,
                    TITLE_BRIEF           VARCHAR2(2000),          
                    PACKAGE_ASSET_ID      VARCHAR2(2000),
                    ASSET_NAME            VARCHAR2(2000),
                    LICENSE_START         DATE,
                    LICENSE_END           DATE,
                    CREATEDATE        	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE        	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TITLE_PURGE_HIST_ID PRIMARY KEY (ID_))';

      CREATEOBJECT(vsql,'Unable to create table PMM_TITLE_PURGE_HISTORY');
      CREATESEQ('PMM_TITLE_PURGE_HISTORY');
      CREATEUPDATETRG('PMM_TITLE_PURGE_HISTORY'); 

           
		/*------------------------------------------------------------------
								INSERT PMM Default Table Values
		------------------------------------------------------------------*/
		
		--Inserts for PMM_PartnerType
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_PartnerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(0,''SELF'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_PartnerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(1,''DISTRIBUTION'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_PartnerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(2,''SOURCE'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_PartnerType.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_ContainerType
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_ContainerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(1,''PARTNER'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_ContainerType.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;

		--Inserts for PMM_TITLESTATUS
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(0,''DRAFT'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(1,''COMMITTED'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(2,''READY'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(3,''APPROVED'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(4,''RETIRED'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(5,''DELETED'',sysdate, sysdate)';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_TITLESTATUS.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_TITLELISTSTATUS
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLELISTSTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(0,''NEW'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLELISTSTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(1,''READY'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLELISTSTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(2,''APPROVED'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_TITLELISTSTATUS.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_LISTTYPE
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(1,''Pitch Schedule'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(2,''Program List'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(3,''Planner'',TO_DATE(''09/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''09/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(4,''Title List'',sysdate,sysdate)';


		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_LISTTYPE.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--PMM Inserts for WFS.ttv_MONITOREDDRIVE
		BEGIN
				EXECUTE IMMEDIATE 'INSERT INTO WFS.ttv_MONITOREDDRIVE (monitoreddriveid, name, description, path, internaldriveid, totalcapacity, warningthresholdpercent, errorthresholdpercent, currentbytesused, currentdrivestatusid,CreateDate, UpdateDate) 
					VALUES (WFS.ttv_MONITOREDDRIVE_SEQ.NEXTVAL, ''Content'', ''Drive for mapped and unmapped assets in PMM'', ''/content'', 1, 100000000000, 50, 75, 0, 0, TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into ttv_MONITOREDDRIVE.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('||err_msg||')';
        GOTO bypass_install;
		
		END;
    
-- PMM Inserts for mandatory TTV self partner    
		BEGIN
				EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_CONTEXT (id_, containertypeid)  
					    VALUES(WFS.PMM_CONTEXT_SEQ.nextval, 1)';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_PARTNER (contextid, id_, isactive, name, partnertype, providerid)
					VALUES(WFS.PMM_CONTEXT_SEQ.currval, WFS.PMM_PARTNER_SEQ.nextval, 1, ''TTV'', 0, ''TTV.COM'')';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_CONTACT (id_, email, firstname, lastname, partnerid)
                VALUES(WFS.PMM_CONTACT_SEQ.nextval, ''INFO@TTV.COM'', ''TTV'', ''TTV'', WFS.PMM_PARTNER_SEQ.currval)';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into ttv self partner data.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('||err_msg||')';
        GOTO bypass_install;
		END;
		
 --     Adding new columns CONTENT CLASS ID and PARTNER ID and filling the data
 --     Per the request received from Eugene Karpenko Dated : 08/05/2010
		BEGIN
				-- inserting a default record in CONTENT_CLASS table    
				execute immediate 'INSERT INTO '||vschema||'.pmm_content_class (id, name, description, is_default, data, content_class_type_id) VALUES ('||vschema||'.PMM_CONTENT_CLASS_SEQ.nextval, ''Default'', ''Default content class'', 1,'||
                                  'XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''default_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL(),0 )';

				-- inserting a series record in CONTENT_CLASS table    
				execute immediate 'INSERT INTO '||vschema||'.pmm_content_class (id, name, description, is_default, data, content_class_type_id) VALUES ('||vschema||'.PMM_CONTENT_CLASS_SEQ.nextval, ''Series'', ''Series content class'', 0,'||
                                  'XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''series_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL(),1)';
                                  
				-- inserting a category record in CONTENT_CLASS table    
				execute immediate 'INSERT INTO '||vschema||'.pmm_content_class (id, name, description, is_default, data, content_class_type_id) VALUES ('||vschema||'.PMM_CONTENT_CLASS_SEQ.nextval, ''Category'', ''Category content class'', 0,'||
                                  'XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''category_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL(),2)';

				-- creating the records in the CONTENT_CLASS_PARTNER TABLE
				execute immediate 'INSERT INTO '||vschema||'.pmm_content_class_partner (content_class_id, partner_id) SELECT cc.id, p.id_ FROM '||vschema||'.pmm_partner p, '||vschema||'.pmm_content_class cc '||
			                          ' WHERE p.partnertype in (0,2) AND cc.is_default = 1 and content_class_type_id=0';
        -- creating the records in the CONTENT_CLASS_PARTNER TABLE for partner type 0 and 2 for series and category content class.
				execute immediate 'INSERT INTO '||vschema||'.pmm_content_class_partner (content_class_id, partner_id) SELECT cc.id, p.id_ FROM '||vschema||'.pmm_partner p, '||vschema||'.pmm_content_class cc '||
                                ' WHERE p.partnertype in (0,2) AND cc.content_class_type_id in (1,2)';
                              
				-- update the content_class_id, partner_id columns of TITLE Table with the default values
				EXECUTE IMMEDIATE 'UPDATE wfs.pmm_title SET (content_class_id, partner_id) = '||
                          		'(SELECT cc.id, p.id_ FROM wfs.pmm_partner p, wfs.pmm_content_class cc  WHERE p.partnertype = 0 AND cc.is_default = 1)';    
		EXCEPTION 
			WHEN OTHERS THEN
			   wk_message := 'ERROR';
			   err_msg :=SUBSTR(SQLERRM, 1, 500);
			   EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values (''Error in installing of application database objects:'||
                          'Unable to insert content_class_id and partner_id data.'')';
			   EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values ('||err_msg||')';
		END;

    -- Kinjal requested for "admin" record on 09-01-2010 in the pmm_partner_users table.
    vsql:='insert into wfs.pmm_partner_users (partner_id,username) values (1,''admin'')';
    CREATEOBJECT(vsql,'Unable to insert the admin record in wfs.pmm_partner_users table');

		/*------------------------------------------------------------------
								Create Foreign Keys
		------------------------------------------------------------------*/
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLE
    vsql := 'ALTER TABLE WFS.PMM_TITLE ADD (
                                  CONSTRAINT PMM_TITLE#PMM_Partner 
                                          FOREIGN KEY (ProviderID) 
                                          REFERENCES WFS.PMM_Partner (ID_),
                                  CONSTRAINT PMM_TITLE#PMM_TITLESTATUS
                                  			FOREIGN KEY (TitleStatusID) 
                                          REFERENCES WFS.PMM_TitleStatus (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLE.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLELIST
    vsql := 'ALTER TABLE WFS.PMM_TITLELIST ADD (
                                  CONSTRAINT PMM_TITLELST#PMM_CONTEXT
                                          FOREIGN KEY (ContextID) 
                                          REFERENCES WFS.PMM_CONTEXT (ID_),
                                  CONSTRAINT PMM_TITLELST#PMM_TTLELSTSTATUS
                                          FOREIGN KEY (TitleListStatusID) 
                                          REFERENCES WFS.PMM_TITLELISTSTATUS (ID_),
                                  CONSTRAINT PMM_TITLELST#PMM_TITLELSTTYPE 
                                          FOREIGN KEY (TitleListTypeID) 
                                          REFERENCES WFS.PMM_LISTTYPE (ID_),
                                  CONSTRAINT PMM_TITLELST#PMM_Partner 
                                          FOREIGN KEY (ProviderID) 
                                          REFERENCES WFS.PMM_PARTNER (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLELIST.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLE_TITLELISTXREF
		vsql := 'ALTER TABLE WFS.PMM_TITLE_TITLELISTXREF ADD (
                                  CONSTRAINT PMM_TTLE_TTLELSTXREF#PMM_TTLE
                                          FOREIGN KEY (TitleID) 
                                          REFERENCES WFS.PMM_TITLE (ID_),
                                  CONSTRAINT PMM_TTLE_TTLELSTX#PMM_TTLELST 
                                          FOREIGN KEY (TitleListID) 
                                          REFERENCES WFS.PMM_TITLELIST (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLE_TITLELISTXREF.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_PROGRESSITEM
		vsql := 'ALTER TABLE WFS.PMM_PROGRESSITEM ADD (
                                  CONSTRAINT PMM_PROGRESSITEM#PMM_TITLE
                                          FOREIGN KEY (TitleID) 
                                          REFERENCES WFS.PMM_TITLE (ID_),
                                  CONSTRAINT PMM_PRGRESSITEM#PMM_TTLELST 
                                          FOREIGN KEY (TitleListID) 
                                          REFERENCES WFS.PMM_TITLELIST (ID_))';
		    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_PROGRESSITEM.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLELISTDETAILS
		vsql := 'ALTER TABLE WFS.PMM_TITLELISTDETAILS ADD (
                                  CONSTRAINT PMM_TTLEDTLS#PMM_TTLELSTDTLS
                                          FOREIGN KEY (DetailTypeID) 
                                          REFERENCES WFS.PMM_TITLELISTDETAILSTYPE (ID_),
                                  CONSTRAINT PMM_TTLELSTDETAILS#PMM_TTLELST
                                          FOREIGN KEY (TitleListID) 
                                          REFERENCES WFS.PMM_TITLELIST (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLELISTDETAILS.');
		
		-- CREATE FOREIGN KEYS FOR PMM_PARTNER
		vsql := 'ALTER TABLE WFS.PMM_PARTNER ADD (
                                  CONSTRAINT PMM_PARTNER#PMM_PARTNERTYPE
                                          FOREIGN KEY (PartnerType) 
                                          REFERENCES WFS.PMM_PARTNERTYPE (ID_),
                                  CONSTRAINT PMM_PARTNER#PMM_CONTEXT
                                          FOREIGN KEY (ContextID) 
                                          REFERENCES WFS.PMM_CONTEXT (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_PARTNER.');
		
		-- CREATE FOREIGN KEYS FOR PMM_CONTEXT
		vsql := 'ALTER TABLE WFS.PMM_CONTEXT ADD (
                                  CONSTRAINT PMM_CONTEXT#PMM_CONTAINERTYPE
                                          FOREIGN KEY (ContainerTypeID) 
                                          REFERENCES WFS.PMM_CONTAINERTYPE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_CONTEXT.');
		
		-- CREATE FOREIGN KEYS FOR PMM_Contact 
		vsql := 'ALTER TABLE WFS.PMM_Contact ADD (
                                  CONSTRAINT PMM_Contact#PMM_Partner
                                          FOREIGN KEY (PARTNERID) 
                                          REFERENCES WFS.PMM_Partner (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_Contact.');
		
		-- CREATE FOREIGN KEYS FOR PMM_PROPERTIES 
		vsql := 'ALTER TABLE WFS.PMM_PROPERTIES ADD (
                                  CONSTRAINT PMM_PROP#PMM_TITLE
                                          FOREIGN KEY (TITLEID) 
                                          REFERENCES WFS.PMM_Title (ID_),
                                  CONSTRAINT PMM_PROP#PMM_TitleList
                                          FOREIGN KEY (TitleListId) 
                                          REFERENCES WFS.PMM_TitleList (ID_),
                                  CONSTRAINT PMM_PROP#PMM_Context
                                          FOREIGN KEY (ContextId) 
                                          REFERENCES WFS.PMM_Context (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_PROPERTIES.');
	
		<<bypass_install>>
  
          COMMIT;
          
          IF wk_message = 'ERROR' THEN
          
          	  --null;
             RAISE createWFSDB.INSTALL_FAILED;
             
          ELSE
          
             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''Installation of PMM completed SUCCESSFULLY'')';
             
          END IF;
		
	END CreatePMM;
    
  /***********************************************************************************************
    ----------------------------------------CREATE NEPTUME-----------------------------------------
   *************************************************************************************************/
   PROCEDURE CreateNEPTUNE IS 
        wk_message	varchar2(500);
        wk_count		number;
        err_msg		varchar2(500);
        vsql varchar2(32767);
   BEGIN
       vsql := 'CREATE TABLE '||vschema||'.CMS_Module (
                  ModuleId    NUMBER NOT NULL              ,
                  moduleName  VARCHAR2(100) NOT NULL UNIQUE,
                  DisplayName VARCHAR2(100) NOT NULL UNIQUE,
                  PRIMARY KEY (moduleid)
                )';
      CREATEOBJECT(vsql,'Unable to create table CMS_Module');
      CREATESEQ('CMS_Module');
    
     vsql := 'CREATE TABLE '||vschema||'.CMS_permission (
                  permissionId   NUMBER NOT NULL       ,
                  permissionName VARCHAR2(100) NOT NULL,
                  DisplayName    VARCHAR2(100) NOT NULL,
                  ModuleId       NUMBER                ,
                  ordernumber    NUMBER                ,
                  PRIMARY KEY (permissionId)           ,
                  UNIQUE (ModuleId,permissionName)     ,
                  UNIQUE (ModuleId, DisplayName)       ,
                  FOREIGN KEY (moduleid) REFERENCES '||vschema||'.cms_module(moduleid)
                )';
      CREATEOBJECT(vsql,'Unable to create table CMS_permission');
      CREATESEQ('CMS_permission');
    
     vsql := 'CREATE TABLE '||vschema||'.CMS_Role
      (
        RoleId      NUMBER NOT NULL              ,
        role_Name   VARCHAR2(100) NOT NULL UNIQUE,
        Description VARCHAR2(1000) ,
        HIDDEN      VARCHAR2(1 CHAR) DEFAULT 0 NOT NULL check (HIDDEN in (''0'',''1'')),
        PRIMARY KEY (roleid)
      )';
      CREATEOBJECT(vsql,'Unable to create table CMS_Role');
      CREATESEQ('CMS_Role',2);
    
    
      vsql := 'CREATE TABLE '||vschema||'.CMS_User
      (
        UserId   NUMBER NOT NULL              ,
        UserName VARCHAR2(100) NOT NULL UNIQUE,
        Password VARCHAR2(100) NULL       ,
        PasswordModifiedDate DATE NULL    ,
        Active     VARCHAR(1) NOT NULL            ,
        FirstName  VARCHAR2(100)                  ,
        LastName   VARCHAR2(100)                  ,
        Email      VARCHAR2(200)                  ,
        Phone      VARCHAR2(50)                   ,
        Extension  VARCHAR2(20)                    ,
        EmployeeId VARCHAR2(100)                  ,
        Department VARCHAR2(100)                  ,
        Location   VARCHAR2(100)                  ,
        Externalkey VARCHAR2(500),
        SyncDate   TIMESTAMP NULL,
        HIDDEN     VARCHAR2(1 CHAR) DEFAULT 0 NOT NULL check (HIDDEN in (''0'',''1'')),
        PRIMARY KEY (userid),
        CONSTRAINT UNQ_CMS_USER_EXTERNALKEY UNIQUE(ExternalKey)
      )';
      CREATEOBJECT(vsql,'Unable to create table CMS_User');
      CREATESEQ('CMS_User',2);    

      vsql := 'CREATE TABLE '||vschema||'.CMS_UserRoles
      (
        UserId NUMBER NOT NULL                          ,
        RoleId NUMBER NOT NULL                          ,
        PRIMARY KEY (userid,roleid)                     ,
        FOREIGN KEY (roleid) REFERENCES '||vschema||'.CMS_Role(RoleId),
        FOREIGN KEY (userid) REFERENCES '||vschema||'.cms_user(userid)
      )';
      CREATEOBJECT(vsql,'Unable to create table CMS_UserRoles');
          
      vsql := 'CREATE TABLE '||vschema||'.CMS_Rolepermissions
      (
        RoleId       NUMBER NOT NULL                    ,
        permissionId NUMBER NOT NULL                    ,
        PRIMARY KEY (roleid,permissionid)               ,
        FOREIGN KEY (roleid) REFERENCES '||vschema||'.CMS_Role(RoleId),
        FOREIGN KEY (permissionId) REFERENCES '||vschema||'.cms_permission(permissionid)
      )';
      CREATEOBJECT(vsql,'Unable to create table CMS_Rolepermissions');
      
      -- created table CMS_USER_SESSION by Francisco dated 08-19-2010
      vsql := ' CREATE TABLE '||vschema||'.CMS_USER_SESSION (
                USERSESSIONID   NUMBER(10) NOT NULL,
                USERNAME        VARCHAR2(100) NOT NULL,
                CMS_SESSION_ID  VARCHAR2(100) NOT NULL,
                --CREATION_DATE date NOT NULL,
                CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                CONSTRAINT PK_CMS_USER_SESSION_USERSESID PRIMARY KEY (USERSESSIONID))';
     
      CREATEOBJECT(vsql,'Unable to create table CMS_USER_SESSION');
      CREATESEQ('CMS_USER_SESSION');
      CREATEUPDATETRG('CMS_USER_SESSION');      
      
      --  created tables CMS_ASSETLIST,CMS_ASSETLIST_ASSET_MAP  by Patrik dated 08-23-2010
      vsql := ' CREATE TABLE '||vschema||'.CMS_ASSETLIST 
                (	ID            NUMBER, 
                  NAME          VARCHAR2(50), 
                  CONTENT_CLASS NUMBER, 
                  DESCRIPTION   VARCHAR2(255), 
                  TYPE          VARCHAR2(50), 
                  CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                  UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                  CONSTRAINT PK_CMS_ASSETLIST_ID PRIMARY KEY (ID),
                  CONSTRAINT FK_CONTENTCLASS_ASSETLIST_ID FOREIGN KEY (CONTENT_CLASS)
                        REFERENCES '||vschema||'.PMM_CONTENT_CLASS(ID),
                  CONSTRAINT unq_cms_assetlist_name UNIQUE (name))';
            
      CREATEOBJECT(vsql,'Unable to create table CMS_ASSETLIST');
      CREATESEQ('CMS_ASSETLIST');
      CREATEUPDATETRG('CMS_ASSETLIST');

      vsql := ' CREATE TABLE '||vschema||'.CMS_ASSETLIST_ASSET_MAP 
               (	ID            NUMBER, 
                  ASSETLIST_ID  NUMBER, 
                  TITLE_ID      NUMBER, 
                  ASSET_ID      NUMBER, 
                  ORDER_        NUMBER DEFAULT 0 NOT NULL ENABLE,
                  CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                  UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                  CONSTRAINT PK_CMS_ASSETLIST_ASSET_MAP_ID PRIMARY KEY (ID),
                  CONSTRAINT FK_ASSETLIST_MAP_TITLE_ID FOREIGN KEY (TITLE_ID) REFERENCES '||vschema||'.PMM_TITLE (ID_),             
                  CONSTRAINT FK_CMS_ASSETLIST_ASSET_MAP_ID FOREIGN KEY (ASSETLIST_ID) REFERENCES '||vschema||'.CMS_ASSETLIST (ID) 
                  )';

      CREATEOBJECT(vsql,'Unable to create table CMS_ASSETLIST_ASSET_MAP');
      CREATESEQ('CMS_ASSETLIST_ASSET_MAP');
      CREATEUPDATETRG('CMS_ASSETLIST_ASSET_MAP');
      
      -- Patrik request for creating two tables CMS_ASSETLIST_METADATA and CMS_ASSETLIST_ASSET_METADATA on 09-09-2010.
      vsql := 'CREATE TABLE WFS.CMS_ASSETLIST_METADATA 
                 (	ASSETLIST_ID  NUMBER, 
                    NAME          VARCHAR2(50) NOT NULL, 
                    INTEGER_VALUE NUMBER, 
                    FLOAT_VALUE   NUMBER, 
                    STRING_VALUE  VARCHAR2(50), 
                    DATE_VALUE    DATE, 
                    IMAGE_VALUE   BLOB, 
                    TIME_VALUE    VARCHAR2(20), 
                    BOOLEAN_VALUE NUMBER, 
                    DATA_TYPE     VARCHAR2(20) NOT NULL, 
                    CREATEDATE 	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_ASSETLIST_METADATA PRIMARY KEY (ASSETLIST_ID, NAME),
                    CONSTRAINT FK_CMS_ASSETLIST_METADATA_CM FOREIGN KEY (ASSETLIST_ID)
                        REFERENCES WFS.CMS_ASSETLIST (ID))';

      CREATEOBJECT(vsql,'Unable to create table CMS_ASSETLIST_METADATA');
      CREATEUPDATETRG('CMS_ASSETLIST_METADATA');                            

      vsql := 'CREATE TABLE WFS.CMS_ASSETLIST_ASSET_METADATA 
                 (	ASSETLIST_ASSETMAP_ID NUMBER, 
                    NAME                  VARCHAR2(50) NOT NULL, 
                    STRING_VALUE          VARCHAR2(255), 
                    IMAGE_VALUE           BLOB, 
                    DATA_TYPE             VARCHAR2(20) NOT NULL ENABLE, 
                    INTEGER_VALUE         NUMBER,
                    CREATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_ASSETLIST_ASSET_METAD PRIMARY KEY (ASSETLIST_ASSETMAP_ID, NAME),
                    CONSTRAINT FK_CMS_ASSETLIST_ASSET_METAD FOREIGN KEY (ASSETLIST_ASSETMAP_ID)
                        REFERENCES WFS.CMS_ASSETLIST_ASSET_MAP (ID))';
                        
      Createobject(Vsql,'Unable to create table CMS_ASSETLIST_ASSET_METADATA');
      CREATEUPDATETRG('CMS_ASSETLIST_ASSET_METADATA');     

      vsql := 'CREATE TABLE '||vschema||'.CMS_LOOKUP_KEY
                  (
                    "ID"          NUMBER(19,0) NOT NULL ,
                    "NAME"        VARCHAR2(50) NOT NULL,
                    "DESCRIPTION" VARCHAR2(255),
                    PRIMARY KEY ("ID"),
                    CONSTRAINT "CMS_LOOKUPKEY_NAME_UNIQ" UNIQUE("NAME")
                  )';
      CREATEOBJECT(VSQL,'Unable to create table CMS_LOOKUP_KEY');
      CREATESEQ('CMS_LOOKUP_KEY');
      
      vsql := 'CREATE TABLE '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE
                (
                  "ID_LOOKUP_KEY" NUMBER(19,0) NOT NULL,
                  "ASSET_TYPE"    VARCHAR2(50),
                  PRIMARY KEY ("ID_LOOKUP_KEY", "ASSET_TYPE"),
                  CONSTRAINT CMS_LOOKUP_KEY_ASSET_TYPE FOREIGN KEY("ID_LOOKUP_KEY") REFERENCES '||vschema||'.CMS_LOOKUP_KEY ("ID")
                )';
      CREATEOBJECT(VSQL,'Unable to create table CMS_LOOKUP_KEY_ASSET_TYPE');      
 
      -- Added a new table CMS_USER_PREFERENCES and also an index UQ_CMS_USER_PREF by Daniel on 01/13/2011.
      vsql := 'CREATE TABLE '||vschema||'.CMS_USER_PREFERENCES
                  ( ID          NUMBER, 
                    USERNAME    VARCHAR2(100) NOT NULL, 
                    COMPONENT   VARCHAR2(100) NOT NULL,
                    TYPE        VARCHAR2(100) NOT NULL, 
                    KEY         VARCHAR2(500) NOT NULL, 
                    VALUE       VARCHAR2(500),
                    CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_USER_PREFERENCES PRIMARY KEY (ID)
                  )';
      CREATEOBJECT(vsql,'Unable to create table CMS_USER_PREFERENCES');
      CREATESEQ('CMS_USER_PREFERENCES'); 
      CREATEUPDATETRG('CMS_USER_PREFERENCES');

       -- Avinash added six tables for Metadata Configuration on 01/19/2012.
       vsql := 'CREATE TABLE '||vschema||'.CMS_ADVISORY ( 
                    advisory    VARCHAR2(64 CHAR) NOT NULL,
                    description VARCHAR2(255 CHAR),
                    createdate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    updatedate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT pk_cms_advisory PRIMARY KEY (advisory)
                )';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_ADVISORY.');
      CREATEUPDATETRG('CMS_ADVISORY');

       vsql := 'CREATE TABLE '||vschema||'.CMS_APP_TYPE (
                    app_type   VARCHAR2(64 CHAR) NOT NULL,
                    notes      VARCHAR2(255 CHAR),
                    createdate TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    updatedate TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT pk_cms_app_type PRIMARY KEY (app_type)
                )';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_APP_TYPE.');
      CREATEUPDATETRG('CMS_APP_TYPE');

       vsql := 'CREATE TABLE '||vschema||'.CMS_GENRE (
                    genre       VARCHAR2(64 CHAR) NOT NULL,
                    description VARCHAR2(255 CHAR),
                    createdate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    updatedate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT pk_cms_genre PRIMARY KEY (genre)
                )';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_GENRE.');
      CREATEUPDATETRG('CMS_GENRE');

       vsql := 'CREATE TABLE '||vschema||'.CMS_PRODUCT (
                    product_code VARCHAR2(64 CHAR) NOT NULL,
                    description  VARCHAR2(255 CHAR),
                    createdate   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    updatedate   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT pk_cms_product PRIMARY KEY (product_code)
                )';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_PRODUCT.');
      CREATEUPDATETRG('CMS_PRODUCT');

       vsql := 'CREATE TABLE '||vschema||'.CMS_RATING (
                    rating        VARCHAR2(64 CHAR) NOT NULL,
                    rating_system VARCHAR2(64 CHAR) NOT NULL,
                    description   VARCHAR2(255 CHAR),
                    createdate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    updatedate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT pk_cms_rating PRIMARY KEY (rating, rating_system)
                )';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_RATING.');
      CREATEUPDATETRG('CMS_RATING');

       vsql := 'CREATE TABLE '||vschema||'.CMS_STUDIO (
                    display_name      VARCHAR2(64 CHAR) NOT NULL,
                    organization_name VARCHAR2(255 CHAR) NOT NULL,
                    organization_code VARCHAR2(64 CHAR),
                    description       VARCHAR2(255 CHAR),
                    createdate        TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    updatedate        TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT pk_cms_studio PRIMARY KEY (display_name)
                )';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_STUDIO.');
      CREATEUPDATETRG('CMS_STUDIO');

      vsql := 'CREATE UNIQUE INDEX '||vschema||'.UQ_CMS_USER_PREF ON '||vschema||'.CMS_USER_PREFERENCES (USERNAME, COMPONENT, TYPE, KEY)';
      CREATEOBJECT(vsql,'Unable to create index UQ_CMS_USER_PREF');
      
    -- REM INSERTING into CMS_USER  
      vsql := 'Insert into '||vschema||'.CMS_USER (USERID,USERNAME,PASSWORD,PASSWORDMODIFIEDDATE,ACTIVE,FIRSTNAME,LASTNAME,EMAIL,PHONE,EXTENSION,EMPLOYEEID,DEPARTMENT,LOCATION) 
                select 1,''admin'',''d033e22ae348aeb5660fc2140aec35850c4da997'',systimestamp,''1'',''Admin2'',''Admin'',''test@test.com'',null,null,null,null,null
                from dual';
      CREATEOBJECT(vsql,'Unable to insert into CMS_USER');

      vsql := 'INSERT INTO '||vschema||'.CMS_USER(USERNAME, PASSWORD, ACTIVE, FIRSTNAME, LASTNAME, EMAIL, HIDDEN) VALUES
               (''services'', ''8744d9c7ddf4a59d758114146ea754b670ce89ee'', ''1'', ''services2'',''services'', ''test@test.com'', ''1'')';
      CREATEOBJECT(vsql,'Unable to insert CMS_USER services');

      -- REM INSERTING into CMS_ROLE
      vsql := 'Insert into '||vschema||'.CMS_ROLE (ROLEID,ROLE_NAME,DESCRIPTION) values (1,''Admin'',''Administrator Role2'')';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');

      vsql := 'INSERT INTO '||vschema||'.CMS_ROLE(ROLE_NAME, DESCRIPTION, HIDDEN) VALUES(''_services_'', ''services role - system use only'', ''1'')';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');

      -- REM INSERTING into CMS_USERROLES
      vsql := 'Insert into '||vschema||'.CMS_USERROLES (USERID,ROLEID) values (1,1)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');    

      vsql := 'INSERT INTO '||vschema||'.CMS_USERROLES (USERID, ROLEID) SELECT u.USERID, r.ROLEID FROM '||vschema||'.CMS_USER u CROSS JOIN '||vschema||'.CMS_ROLE r WHERE u.USERNAME = ''services'' and r.ROLE_NAME = ''_services_''';
     CREATEOBJECT(vsql,'Unable to insert into CMS Services ROLE'); 

    -- REM INSERTING into CMS_MODULE
      vsql := 'Insert into '||vschema||'.CMS_MODULE (MODULEID,MODULENAME,DISPLAYNAME) values ('||vschema||'.cms_module_seq.nextval,''UserManagement'',''User Management'')';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
      
      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''View'',''View'','||vschema||'.cms_module_seq.currval,0)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
    
      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');

      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''Create'',''Create'','||vschema||'.cms_module_seq.currval,1)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
      
      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');    
      
      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''Modify'',''Modify'','||vschema||'.cms_module_seq.currval,2)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
      
      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
    
      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''Delete'',''Delete'','||vschema||'.cms_module_seq.currval,3)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
      
      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');      
    
    -- REM INSERTING into CMS_MODULE
      vsql := 'Insert into '||vschema||'.CMS_MODULE (MODULEID,MODULENAME,DISPLAYNAME) values ('||vschema||'.cms_module_seq.nextval,''RoleManagement'',''Role Management'')';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');

      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''View'',''View'','||vschema||'.cms_module_seq.currval,0)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
      
      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
    
      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''Create'',''Create'','||vschema||'.cms_module_seq.currval,1)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');      

      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
      
      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''Modify'',''Modify'','||vschema||'.cms_module_seq.currval,2)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');      

      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');      
    
      vsql := 'Insert into '||vschema||'.CMS_PERMISSION (PERMISSIONID,PERMISSIONNAME,DISPLAYNAME,MODULEID,ORDERNUMBER) values ('||vschema||'.cms_permission_seq.nextval,''Delete'',''Delete'','||vschema||'.cms_module_seq.currval,3)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');
      
      vsql := 'Insert into '||vschema||'.CMS_ROLEPERMISSIONS (ROLEID,PERMISSIONID) values (1,'||vschema||'.cms_permission_seq.currval)';
      CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE');      

      vsql := 'INSERT INTO '||vschema||'.CMS_MODULE(MODULEID, MODULENAME, DISPLAYNAME) VALUES('||vschema||'.CMS_MODULE_SEQ.nextval,''SettingsManagement'', ''Settings Management'')';
      CREATEOBJECT(vsql,'Unable to insert into CMS_MODULE');      

      vsql := 'INSERT INTO '||vschema||'.CMS_PERMISSION(PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERNUMBER) values (''View'',''View'', '||vschema||'.CMS_MODULE_SEQ.currval,0)';
      CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.CMS_PERMISSION for permission View');      

      vsql := 'INSERT INTO '||vschema||'.CMS_PERMISSION(PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERNUMBER) values (''Modify'',''Modify'', '||vschema||'.CMS_MODULE_SEQ.currval,1)';
      CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.CMS_PERMISSION for permission Modify');      

      vsql := 'INSERT INTO '||vschema||'.CMS_ROLEPERMISSIONS(ROLEID, PERMISSIONID) SELECT r.ROLEID, p.PERMISSIONID from '||vschema||'.CMS_ROLE r CROSS JOIN '||vschema||'.CMS_PERMISSION p 
               WHERE r.ROLE_NAME = ''_services_'' and p.MODULEID in (SELECT MODULEID FROM '||vschema||'.CMS_MODULE WHERE MODULENAME = ''SettingsManagement'')';
      CREATEOBJECT(vsql,'Unable to INSERT INTO '||vschema||'.CMS_ROLEPERMISSIONS for services role');

      -- Kinjal added insert records for CMS_LOOKUP_KEY and CMS_LOOKUP_KEY_ASSET_TYPE tables on 03/31/2011.
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY (NAME, DESCRIPTION) VALUES (''ORIGINAL'',''ORIGINAL'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY'); 
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''PACKAGE'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record PACKAGE');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''TITLE'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record TITLE');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''MOVIE'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record MOVIE');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''PREVIEW'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record PREVIEW');

      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''POSTER'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record POSTER');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''BOXCOVER'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record BOXCOVER');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''TRICK'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record TRICK');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''ENCRYPTED'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record ENCRYPTED');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''BARKER'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record BARKER');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''MOVIESEGMENTGROUP'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record MOVIESEGMENTGROUP');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''PREVIEWSEGMENTGROUP'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record PREVIEWSEGMENTGROUP');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''DISPLAY'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record DISPLAY');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''GAME'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record GAME');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''LOGICALCLIP'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record LOGICALCLIP');
    
      -- Added missing lookup key values to fix bug no.3730 on 03/21/2012.
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''SERIES'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record SERIES');
      
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''SEASON'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record SEASON');

      -- Bak Ng added new asset type AUDIO to the CMS_LOOKUP_KEY_ASSET_TYPE table on 09/25/2012.
      VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL ,''AUDIO'')';
      CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record AUDIO');

      -- Francisco changes on 02/07/2013.
      vsql := 'CREATE TABLE '||vschema||'.CMS_SETTING_GROUP (
                    SETTINGGROUPID NUMBER(20),
                    GROUP_PATH     VARCHAR2(255) NOT NULL,
                    PARENT_PATH    VARCHAR2(255),
                    CREATEDATE	   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_SETTING_GROUP_SGID PRIMARY KEY (SETTINGGROUPID))';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_SETTING_GROUP.');
      CREATESEQ('CMS_SETTING_GROUP');
      CREATEUPDATETRG('CMS_SETTING_GROUP');

      VSQL := 'CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_GROUP_GRPPATH ON '||vschema||'.CMS_SETTING_GROUP(GROUP_PATH)';
      CREATEOBJECT(VSQL,'Unable to CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_GROUP_GRPPATH');

      vsql := 'CREATE TABLE '||vschema||'.CMS_SETTING (
                    SETTINGID            NUMBER(20),
                    SETTING_NAME         VARCHAR2(255) NOT NULL,
                    SETTING_VALUE        CLOB,
                    CMS_SETTING_GROUP_ID NUMBER(20) NOT NULL,
                    CREATEDATE	         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT CMS_SETTING_SETTINGID_PK PRIMARY KEY (SETTINGID),
                    CONSTRAINT CMS_SETTING_SETTINGGROUPID_FK  FOREIGN KEY (CMS_SETTING_GROUP_ID) REFERENCES '||vschema||'.CMS_SETTING_GROUP(SETTINGGROUPID))';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_SETTING.');
      CREATESEQ('CMS_SETTING');
      CREATEUPDATETRG('CMS_SETTING');

      VSQL := 'CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_SNAME_GRPID ON '||vschema||'.CMS_SETTING(SETTING_NAME, CMS_SETTING_GROUP_ID)';
      CREATEOBJECT(VSQL,'Unable to CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_SNAME_GRPID');

      --  Cherise Ho changes on 02/25/2013.
      vsql := 'CREATE TABLE '||vschema||'.CMS_COMPONENT (
                    COMPONENTID NUMBER(20),
                    NAME        VARCHAR2(100) NOT NULL,
                    BASEURL     VARCHAR2(200) NOT NULL,
                    STATUSID    NUMBER,
                    CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT CMS_COMPONENT_PK PRIMARY KEY (COMPONENTID),
                    CONSTRAINT CMS_COMPONENT_UKNAME UNIQUE (NAME))';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_COMPONENT.');
      CREATESEQ('CMS_COMPONENT');
      CREATEUPDATETRG('CMS_COMPONENT');

      VSQL := 'ALTER TABLE '||vschema||'.CMS_MODULE ADD (COMPONENTID NUMBER(20))';
      CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.CMS_MODULE TO ADD COLUMN COMPONENTID');

      VSQL := 'CREATE INDEX '||vschema||'.IDX_CMS_COMPONENT_COMPID ON WFS.CMS_MODULE (COMPONENTID)';
      CREATEOBJECT(VSQL,'Unable to CREATE INDEX '||vschema||'.IDX_CMS_COMPONENT_COMPID');

      VSQL := 'ALTER TABLE '||vschema||'.CMS_MODULE ADD (CONSTRAINT CMS_MODULE_UQ_NAME UNIQUE (MODULENAME, COMPONENTID), 
                        CONSTRAINT CMS_MODULE_UQ_DISPLAYNAME UNIQUE (DISPLAYNAME, COMPONENTID),
                        CONSTRAINT CMS_MODULE_COMPONENT_FK FOREIGN KEY (COMPONENTID) REFERENCES '||vschema||'.CMS_COMPONENT (COMPONENTID))';
      CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.CMS_MODULE ADD THREE CONSTRAINTS.');

      vsql := 'CREATE TABLE '||vschema||'.CMS_PORTAL_USER_PREFERENCES (
                    ID           NUMBER(20),
                    USERNAME     VARCHAR2(100) NOT NULL,
                    COMPONENT    VARCHAR2(100) NOT NULL,
                    KEY          VARCHAR2(500) NOT NULL,
                    COLUMN_INDEX NUMBER(20),
                    ROW_INDEX    NUMBER(20),
                    WIDTH        NUMBER(24,4),
                    HEIGHT       NUMBER(24,4),
                    CREATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_PORTAL_PREFERENCES PRIMARY KEY (ID),
                    CONSTRAINT UQ_CMS_PORTAL_PREF UNIQUE (USERNAME, COMPONENT, KEY))';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_PORTAL_USER_PREFERENCES.');
      CREATESEQ('CMS_PORTAL_USER_PREFERENCES');
      CREATEUPDATETRG('CMS_PORTAL_USER_PREFERENCES');

      -- Eugene added Content Management records into cms setting tables on 06/26/2013.
      vsql := 'insert into '||vschema||'.cms_setting_group (settinggroupid, group_path, parent_path) values('||vschema||'.cms_setting_group_seq.nextval,''com.ericsson.cms.contentmgmt.autofill'',''com.ericsson.cms.contentmgmt'')';
      CREATEOBJECT(VSQL,'Unable to insert contentmgmt into '||vschema||'.cms_setting_group.');

      vsql := 'insert into '||vschema||'.cms_setting (setting_name, setting_value, cms_setting_group_id) values(''providers.provider[0].displayName'',''Asset ID Generator'','||vschema||'.cms_setting_group_seq.currval)';
      CREATEOBJECT(VSQL,'Unable to insert Asset ID Generator into '||vschema||'.cms_setting.');

      vsql := 'insert into '||vschema||'.cms_setting (setting_name, setting_value, cms_setting_group_id) values (''providers.provider[0].javaClass'',''com.tandbergtv.metadata.cablelabsvod11.ui.AssetIdGenerator'','||vschema||'.cms_setting_group_seq.currval)';
      CREATEOBJECT(VSQL,'Unable to insert AssetIdGenerator into '||vschema||'.cms_setting.');

      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CreateNEPTUNE completed SUCCESSFULLY'')';
             
    commit;

   END CreateNEPTUNE;

  /***********************************************************************************************
    ----------------------------------------CREATE METADATA MANAGER----------------------------------
   *************************************************************************************************/
   PROCEDURE CreateMETADATAMANAGER IS 
        wk_message	varchar2(500);
        wk_count		number;
        err_msg		varchar2(500);
        vsql varchar2(32767);
   BEGIN

      vsql := 'CREATE TABLE '||vschema||'.mdm_ASSET (
        ID 			NUMBER	 		NOT NULL,
        CLASS_ID 	VARCHAR2(1)		NOT NULL,
        TYPE 		VARCHAR2(50)	NOT NULL,
        CREATE_DATE	TIMESTAMP		DEFAULT		systimestamp	NULL,
        UPDATE_DATE	TIMESTAMP		DEFAULT		systimestamp	NULL,
        STATE		NUMBER			DEFAULT		0,
        ROOTASSET_ID		NUMBER			NULL, 
        EXTERNALREVISION	NVARCHAR2(50)   NULL,
        LATESTREVISION 	NUMBER(10)	 	DEFAULT		1		NOT NULL,
        ORIGINALASSET_ID NUMBER,
        ORIGINALASSET_REVISION NUMBER(5,0),
        PRIMARY KEY(ID),
        CONSTRAINT fk_mdmasset_rootassetid FOREIGN KEY(ROOTASSET_ID) REFERENCES '||vschema||'.mdm_ASSET(ID),
        CONSTRAINT FK_ORIGINALASSET_ASSET_ID FOREIGN KEY (ORIGINALASSET_ID) REFERENCES '||vschema||'.MDM_ASSET(ID)
        )';
      CREATEOBJECT(vsql,'Unable to create table mdm_ASSET');        
      
      vsql := 'CREATE TABLE '||vschema||'.mdm_RELATION (
        ID		 			NUMBER			NOT NULL,
        OWNING_ASSET_ID		NUMBER	 		NOT NULL,
        TARGET_ASSET_ID 	NUMBER					,
        CLASS_ID 			VARCHAR2(50)	NOT NULL,
        DIRECTION			NUMBER(1,0)				,
        CREATE_DATE			TIMESTAMP		DEFAULT 	systimestamp	NULL,
        UPDATE_DATE			TIMESTAMP		DEFAULT 	systimestamp	NULL,
        ADDREVISION 		NUMBER(10)	 	DEFAULT		1				NOT NULL,
        DELETEREVISION 		NUMBER(10)	 	DEFAULT		0,
        PRIMARY KEY(ID),
        CONSTRAINT fk_rel_asset_id FOREIGN KEY(OWNING_ASSET_ID) REFERENCES '||vschema||'.mdm_ASSET(ID),
        CONSTRAINT fk_rel_asset_target FOREIGN KEY(TARGET_ASSET_ID) REFERENCES '||vschema||'.mdm_ASSET(ID)        
      )';
      CREATEOBJECT(vsql,'Unable to create table mdm_RELATION');        
      
      vsql := 'CREATE TABLE '||vschema||'.mdm_FIELD (
        ID		 			NUMBER			NOT NULL,
        TTVXPATH			NVARCHAR2(500)	NOT NULL, 
        VALUE				  VARCHAR2(2000), 
        LARGEVALUE			CLOB,
        DATEVALUE			DATE,
        INTVALUE			NUMBER,
        FLOATVALUE			NUMBER,
        DATATYPE			NVARCHAR2(50),
        INDICES				NVARCHAR2(100), 
        ROOTASSET_ID		NUMBER			NULL, 
        ASSET_ID			NUMBER			NULL,
        PARSABLE			NUMBER(1,0)		DEFAULT		1		NOT NULL,
        primary key (ID),
        CONSTRAINT fk_field_asset_rootassetid FOREIGN KEY(ROOTASSET_ID) REFERENCES '||vschema||'.mdm_ASSET(ID),
        CONSTRAINT fk_field_asset_id FOREIGN KEY(ASSET_ID) REFERENCES '||vschema||'.mdm_ASSET(ID)        
      )';
      CREATEOBJECT(vsql,'Unable to create table mdm_FIELD');
      
      vsql := 'CREATE TABLE '||vschema||'.mdm_FIELDREVISION (
        ID		 			NUMBER			NOT NULL,
        TTVXPATH			NVARCHAR2(500)	NOT NULL, 
        VALUE				NVARCHAR2(2000),
        DATEVALUE			DATE,
        INTVALUE			NUMBER,
        FLOATVALUE			NUMBER,
        LARGEVALUE			CLOB,
        DATATYPE			NVARCHAR2(50),
        INDICES				NVARCHAR2(100), 
        ROOTASSET_ID		NUMBER			NULL, 
        ASSET_ID			NUMBER			NULL,
        ADDREVISION 		NUMBER(10)	 	DEFAULT		1		NOT NULL,
        DELETEREVISION 		NUMBER(10)	 	DEFAULT		0,
        REVISIONNUMBER 		NUMBER(10)	 	DEFAULT		1		NOT NULL,
        PARSABLE			NUMBER(1,0)		DEFAULT		1		NOT NULL,
        primary key (ID),
        CONSTRAINT fk_fieldrv_asset_rootassetid FOREIGN KEY(ROOTASSET_ID) REFERENCES '||vschema||'.mdm_ASSET(ID),
        CONSTRAINT fk_fieldrevision_asset_id FOREIGN KEY(ASSET_ID) REFERENCES '||vschema||'.mdm_ASSET(ID)        
      )';
      CREATEOBJECT(vsql,'Unable to create table mdm_FIELDREVISION');      
      
      vsql := 'CREATE TABLE '||vschema||'.mdm_ROOTASSETREVISION (
        ID		 			NUMBER			NOT NULL,
        ASSET_ID			NUMBER			NOT NULL,
        EXTERNALREVISION	NVARCHAR2(50)   NULL,
        REVISIONNUMBER 		NUMBER(10)	 	DEFAULT		1		NOT NULL,
        REVISIONSOURCE		VARCHAR2(50)	NULL,
        REVISIONCOMMENT		VARCHAR2(500),
        REVISIONTIME		TIMESTAMP		DEFAULT 	systimestamp   NOT NULL,
        DRAFT				NUMBER(1,0)		DEFAULT		0,
        primary key (ID),
        CONSTRAINT unique_rootassetrevision UNIQUE (ASSET_ID,REVISIONNUMBER)
      )';
      CREATEOBJECT(vsql,'Unable to create table mdm_ROOTASSETREVISION');      
      
      vsql := 'CREATE TABLE '||vschema||'.mdm_RULESET (
        ID			NUMBER	 		NOT NULL,
        NAME		VARCHAR2(50)	NULL,
        SPEC		VARCHAR2(50)	NULL,
        CREATE_DATE	TIMESTAMP		DEFAULT		systimestamp	NULL,
        UPDATE_DATE	TIMESTAMP		DEFAULT		systimestamp	NULL,
        PRIMARY KEY(ID)
      )';
      CREATEOBJECT(vsql,'Unable to create table mdm_RULESET');      
      
      vsql := 'CREATE TABLE '||vschema||'.mdm_RULE (
        ID			NUMBER			NOT NULL,
        XPATH		VARCHAR2(200)	NULL,
        ISREQUIRED	NUMBER(1,0)		NULL,
        RULESET_ID	NUMBER	 		NULL,
        CREATE_DATE	TIMESTAMP		DEFAULT 	systimestamp	NULL,
        UPDATE_DATE	TIMESTAMP		DEFAULT 	systimestamp	NULL,
        PRIMARY KEY(ID),
        CONSTRAINT fk_rule_ruleset_id FOREIGN KEY(RULESET_ID) REFERENCES '||vschema||'.mdm_RULESET(ID)
      )';
      CREATEOBJECT(vsql,'Unable to create table mdm_RULE');

      vsql := 'CREATE TABLE '||vschema||'.MDM_CUSTOM_FIELD_GROUP (
        GROUP_ID     NUMBER NOT NULL,
        NAME         VARCHAR2(255) ,
        DISPLAY_NAME VARCHAR2(255) NOT NULL,
        ASSET_PATH   VARCHAR2(255) NOT NULL,
        UUID         VARCHAR2(255) ,
        CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
        UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
        CONSTRAINT mdm_custom_field_group_pk PRIMARY KEY (GROUP_ID)
        )';
      CREATEOBJECT(vsql,'Unable to create table MDM_CUSTOM_FIELD_GROUP');
      CREATESEQ('MDM_CUSTOM_FIELD_GROUP'); 
      CREATEUPDATETRG('MDM_CUSTOM_FIELD_GROUP');

      vsql := 'CREATE TABLE '||vschema||'.MDM_CUSTOM_FIELD (
        CUSTOM_FIELD_ID        NUMBER NOT NULL,
        NAME                   VARCHAR2(255) NOT NULL,
        DATA_TYPE              VARCHAR2(20),
        JOB_PARAMETER          VARCHAR2(1),
        JOB_SCHEDULE_PARAMETER VARCHAR2(1),
        GROUP_ID               NUMBER NOT NULL,
        DISPLAY_NAME           VARCHAR2(255) NOT NULL,
        MULTIVALUE             VARCHAR(1 CHAR),
        FIELD_TYPE             NUMBER(3) DEFAULT 1 NOT NULL,
        CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
        UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
        CONSTRAINT mdm_custom_field_pk PRIMARY KEY (CUSTOM_FIELD_ID),
        CONSTRAINT fk_mdm_custom_field_group_id FOREIGN KEY(GROUP_ID) 
            REFERENCES '||vschema||'.MDM_CUSTOM_FIELD_GROUP(GROUP_ID)
        )';
      CREATEOBJECT(vsql,'Unable to create table MDM_CUSTOM_FIELD');
      CREATESEQ('MDM_CUSTOM_FIELD'); 
      CREATEUPDATETRG('MDM_CUSTOM_FIELD');

      --Create Indexes
      
      vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHVALUEAST_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","VALUE","ASSET_ID")';
      CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHVALUEAST_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHINTASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","INTVALUE","ASSET_ID")';
      CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHINTASSET_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHDTASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","DATEVALUE","ASSET_ID")';
      CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHDTASSET_IND');

      vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHFLOATASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","FLOATVALUE","ASSET_ID")';
      CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHFLOATASSET_IND');

      vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHPARSASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","PARSABLE","ASSET_ID")';
      CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHPARSASSET_IND');

      vsql := 'CREATE INDEX '||vschema||'.MDM_FIELDASSETID_IND ON '||vschema||'.MDM_FIELD(ASSET_ID)';
      CREATEOBJECT(vsql,'Unable to create index MDM_FIELDASSETID_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.MDM_FIELD_ROOTASSET_ID_IND ON '||vschema||'.MDM_FIELD(ROOTASSET_ID)';
      CREATEOBJECT(vsql,'Unable to create index MDM_FIELD_ROOTASSET_ID_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.MDM_ASSETCOM_IND ON '||vschema||'.MDM_ASSET(ID,STATE,ROOTASSET_ID,TYPE,CLASS_ID)';
      CREATEOBJECT(vsql,'Unable to create index MDM_ASSETCOM_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.MDM_ASSET_ROOTASSET_ID_IND ON '||vschema||'.MDM_ASSET(ROOTASSET_ID)';
      CREATEOBJECT(vsql,'Unable to create index MDM_ASSET_ROOTASSET_ID_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.MDM_RELATION_TAR_ASSET_IND ON '||vschema||'.MDM_RELATION(TARGET_ASSET_ID)';
      CREATEOBJECT(vsql,'Unable to create index MDM_RELATION_TAR_ASSET_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.MDM_RELATION_OWN_ASSET_IND ON '||vschema||'.MDM_RELATION(OWNING_ASSET_ID)';
      CREATEOBJECT(vsql,'Unable to create index MDM_RELATION_OWN_ASSET_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.FIELDREVISION_ASSET_ID ON '||vschema||'.MDM_FIELDREVISION(ASSET_ID)';
      CREATEOBJECT(vsql,'Unable to create index FIELDREVISION_ASSET_ID');
      
      vsql := 'CREATE INDEX '||vschema||'.MDMFLDREV_VALUEXPATH_IND ON '||vschema||'.MDM_FIELDREVISION (VALUE,TTVXPATH)';
      CREATEOBJECT(vsql,'Unable to create index MDMFLDREV_VALUEXPATH_IND');
      
      --Create Sequences
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_ASSET_SEQ INCREMENT BY 1 START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_ASSET_SEQ');
        
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_RELATION_SEQ	INCREMENT BY 1	START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_RELATION_SEQ');
      
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_FIELD_SEQ	INCREMENT BY 1	START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_FIELD_SEQ');
      
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_FIELDREVISION_SEQ	INCREMENT BY 1	START WITH 101	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_FIELDREVISION_SEQ');
      
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_CFG_SEQ	INCREMENT BY 1	START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_CFG_SEQ');
        
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_CFD_SEQ	INCREMENT BY 1	START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_CFD_SEQ');
      
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_RULESET_SEQ	INCREMENT BY 1	START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_RULESET_SEQ');
      
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_ROOTASSETREVISION_SEQ	INCREMENT BY 1	START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_ROOTASSETREVISION_SEQ');
      
      vsql := 'CREATE SEQUENCE '||vschema||'.mdm_RULE_SEQ	INCREMENT BY 1	START WITH 1	NOMAXVALUE';
      CREATEOBJECT(vsql,'Unable to create SEQUENCE mdm_RULE_SEQ');
      
      -- Created an text index for Daniel on 08-11-2010
      vsql := 'CREATE INDEX '||vschema||'.CTX_IDX_MDM_FIELD_VALUE ON '||vschema||'.MDM_FIELD(VALUE) INDEXTYPE IS CTXSYS.CTXCAT';
      CREATEOBJECT(vsql,'Unable to create text index CTX_IDX_MDM_FIELD_VALUE on MDM_FIELD(VALUE)');	

      -- Update script for MDM_ASSET table class_id value from I to G for Movie and Preview (Nicholas request Dated 08-11-2010)
      BEGIN
          EXECUTE IMMEDIATE 'UPDATE wfs.mdm_asset SET class_id=''G'' WHERE type IN (''MOVIE'',''PREVIEW'')';
        EXCEPTION 
         WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values (''Error in installing of application database objects:'||
                  'Unable to update the class_id in mdm_asset table.'')';
            EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values ('||err_msg||')';
       END;
          
      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CreateMETADATAMANAGER completed SUCCESSFULLY'')';
  END CreateMETADATAMANAGER;

  /***********************************************************************************************
    ----------------------------------------CREATE METADATA MANAGER XML---------------------------
   *************************************************************************************************/
   PROCEDURE CreateMETADATAMANAGER_XML IS 
        wk_message	varchar2(500);
        wk_count		number;
        err_msg		varchar2(500);
        vsql varchar2(32767);
   BEGIN
      vsql := 'BEGIN
                 DBMS_XMLSCHEMA.REGISTERSCHEMA(
                    SCHEMAURL => ''ECMFSpec.xsd'',
                    SCHEMADOC => BFILENAME(''ECMFXMLDIR'',''ECMFSpec.xsd''),
                    GENTYPES => FALSE,
                    OWNER => ''WFS'',
                    CSID => NLS_CHARSET_ID(''AL32UTF8''),
                    OPTIONS => DBMS_XMLSCHEMA.REGISTER_BINARYXML);
              END;';
      CREATEOBJECT(vsql,'Unable to REGISTER XMLSCHEMA FOR ECMFSpec.xsd');

      vsql := 'CREATE TABLE '||vschema||'.mdm_metadata OF XMLType
                   XMLTYPE STORE AS SECUREFILE BINARY XML
                   XMLSCHEMA "http://xmlns.oracle.com/xdb/schemas/WFS/ECMFSpec.xsd"
                   ELEMENT "ECMFSpec"';
      CREATEOBJECT(vsql,'Unable to CREATE TABLE '||vschema||'.mdm_metadata');
  
      vsql := 'CREATE TABLE '||vschema||'.mdm_metadata_revision OF XMLType
                   XMLTYPE STORE AS SECUREFILE BINARY XML
                   XMLSCHEMA "http://xmlns.oracle.com/xdb/schemas/WFS/ECMFSpec.xsd"
                   element "ECMFSpec"';
      CREATEOBJECT(vsql,'Unable to CREATE TABLE '||vschema||'.mdm_metadata_revision');
       
      -- Trigger created on PMM_Title table for Purge Report by Suresh Neravati on 09-09-2010 and modified on 03/23/2011 for xml qry.
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.PMM_TITLE_PURGE_INSERTTRG'|| 
              ' AFTER UPDATE OR INSERT ON '||vschema||'.PMM_TITLE FOR EACH ROW'|| 
              ' BEGIN'|| 
                 ' IF (NVL(:NEW.RETIREMENT_DATE,(SYSTIMESTAMP-10000)) <> NVL(:OLD.RETIREMENT_DATE,(SYSTIMESTAMP-10000))'||  
                    '  AND :OLD.ORIGINALTITLE_ID IS NULL) THEN'|| 
                          ' INSERT INTO WFS.PMM_TITLE_PURGE_HISTORY (TITLE_ID, PROVIDER_ID, '|| 
                                 ' PROVIDER_NAME, TITLE_RETIREMENT_DATE, TITLE_BRIEF, '|| 
                                 ' PACKAGE_ASSET_ID, ASSET_NAME,LICENSE_START,LICENSE_END)'|| 
                           ' SELECT :NEW.ID_, p.PROVIDERID,  p.NAME, :NEW.RETIREMENT_DATE, '||
                                  ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value'') AS title_brief, '||
                                  ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Fields/Identifier/Id'') as package_assetid, '||
                                  ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Fields/AssetName'') AS asset_name, '||
                                  ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart'') as licensing_startdt, '||
                                  ' EXTRACTVALUE(SYS_NC_ROWINFO$,''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd'') AS licensing_enddt '||
                           '   FROM '||vschema||'.mdm_metadata  vmf, '||vschema||'.pmm_partner p '||
                           '  WHERE extractvalue(sys_nc_rowinfo$, ''/ECMFSpec/@documentId'') = :NEW.MDMDOCID '||
                           '    AND (p.id_ = :NEW.PARTNER_ID); '|| 
                 ' END IF;'|| 
               ' END;';
      CREATEOBJECT(vsql,'Unable to create trigger PMM_TITLE_PURGE_INSERTTRG');
     
      VSQL := 'CREATE VIEW '||vschema||'.VDW_MDM_Metadata_Fields AS '|| 
               ' SELECT  extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId'') as document_id, '|| 
                       ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Fields/AssetName'') AS asset_name, '|| 
                       ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Fields/Identifier/Id'') as package_assetid, '|| 
                       ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart'') as licensing_startdt, '|| 
                       ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd'') as licensing_enddt, '|| 
                       ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value'') AS title_brief '|| 
               ' FROM '||VSCHEMA||'.mdm_metadata mdm';
      CREATEOBJECT(VSQL,'Unable to create view '||vschema||'.VDW_MDM_Metadata_Fields');      
      
      VSQL := 'CREATE VIEW '||vschema||'.vdw_MissingContent AS '||  
              ' SELECT pp.PROVIDERID AS "PROVIDER_ID", '|| 
                     ' pp.NAME AS "PROVIDER_NAME", '||  
                     ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Fields/AssetName'') AS asset_name, '|| 
                     ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Fields/Identifier/Id'') AS package_assetid, '|| 
                     ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart'') as licensing_startdt, '|| 
                     ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd'') AS licensing_enddt, '|| 
                     ' extractvalue(sys_nc_rowinfo$,''/ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value'') AS title_brief '|| 
              ' FROM (SELECT ID, XMLTYPE(DATA) AS A '||  
                     '  FROM '||vschema||'.PMM_CONTENT_CLASS ) PCC, '|| 
                    ' XMLTABLE(''/metadata/asset'' PASSING PCC.A COLUMNS  "path" VARCHAR2(1000) PATH ''@path'', '|| 
                    ' "requiresFile" varchar2(1000) path ''@requiresFile'', '||
                    ' "isHidden" varchar2(1000) path ''@isHidden'') XMLPCC, '||
                    ' '||VSCHEMA||'.PMM_TITLE pt, '|| 
                    ' '||vschema||'.mdm_metadata mm, '|| 
                    ' '||vschema||'.pmm_partner pp '|| 
              ' WHERE XMLPCC."requiresFile"=''true'' '|| 
                ' AND xmlpcc."isHidden" is null '||
                ' AND xmlpcc."path"!=''PACKAGE'' '|| 
                ' AND pt.CONTENT_CLASS_ID= PCC.ID '|| 
                ' and pp.id_ = pt.partner_id '|| 
                ' AND xmlcast(xmlquery(''/ECMFSpec/@documentId'' passing mm.object_value returning content) as number) = pt.mdmdocid '||
                ' AND extract(mm.object_value,''/ECMFSpec/''||replace(replace(initcap(xmlpcc."path"), ''clip'', ''Clip''),''segmentgroup'',''SegmentGroup'')||''/File/Fields/Locator/Description[Text="ORIGINAL"]'') IS NULL '||
                ' AND extract(mm.object_value,''/ECMFSpec/''||replace(replace(initcap(xmlpcc."path"), ''clip'', ''Clip''),''segmentgroup'',''SegmentGroup'')) IS NOT NULL';
      CREATEOBJECT(VSQL,'Unable to create view '||vschema||'.vdw_MissingContent');
      
      RECREATE_XML_INDEXES;

      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CreateMETADATAMANAGER_XML completed SUCCESSFULLY'')';
  END CreateMETADATAMANAGER_XML;

/**************************************************************************************************
  ------------------------------------ Recreate XML Indexes -------------------------------------
**************************************************************************************************/
   
  PROCEDURE DROP_XML_INDEXES IS
  BEGIN
      VSQL := 'DROP INDEX '||VSCHEMA||'.mdm_index_xmltype force';
      CREATEOBJECT(vsql,'Unable to DROP INDEX '||vschema||'.mdm_index_xmltype','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.ecmfspec_xmlindex force';
      CREATEOBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.ecmfspec_xmlindex','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.ecmfspec_rev_xmlindex force';
      CREATEOBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.ecmfspec_rev_xmlindex','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.idx_xml_path_tab force';
      CREATEOBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.idx_xml_path_tab','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid force';
      CREATEOBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.idx_xml_path_tab','Y');

      --STRUCTURED Index for display fields
      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfstructuredxml_idx''); END;';
      CREATEOBJECT(vsql,'Unable to dropparameter of xmlindex ecmfstructuredxml_idx','Y');
      
      --Murtaza removed parameter seriesxml_idx on 02/24/2012.
      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfseriesxml_idx''); END;';
      CREATEOBJECT(vsql,'Unable to dropparameter of xmlindex ecmfseriesxml_idx','Y');

      --Murtaza removed parameter seriesxml_idx on 03/06/2012.
      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfseriesfldsxml_idx''); END;';
      CREATEOBJECT(VSQL,'Unable to dropparameter of xmlindex ecmfseriesfldsxml_idx','Y');

      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfasstuniqueness_idx''); END;';
      createobject(vsql,'Unable to dropparameter of xmlindex ecmfseriesfldsxml_idx','Y');

      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfpkgcustomflds_idx''); END;';
      CREATEOBJECT(VSQL,'Unable to dropparameter of xmlindex ecmfseriesfldsxml_idx','Y');

      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfmovcustomflds_idx''); END;';
      createobject(vsql,'Unable to dropparameter of xmlindex ecmfseriesfldsxml_idx','Y');

      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmftlecustomflds_idx''); END;';
      createobject(vsql,'Unable to dropparameter of xmlindex ecmfseriesfldsxml_idx','Y');
      
      VSQL := 'DROP INDEX '||VSCHEMA||'.ECMFPKGASSTID_idx';
      CREATEOBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.ECMFPKGASSTID_idx','Y');

      VSQL := 'DROP INDEX '||VSCHEMA||'.ecmftitleasstid_idx';
      CREATEOBJECT(VSQL,'Unable to DROP INDEX '||VSCHEMA||'.ecmftitleasstid_idx','Y');

      VSQL := 'BEGIN dbms_xmlindex.dropparameter(''ecmfasstuniqueness_idx''); END;';
      CREATEOBJECT(vsql,'Unable to dropparameter of xmlindex ecmfasstuniqueness_idx','Y');

  END DROP_XML_INDEXES;
 
  PROCEDURE ReCreate_XML_INDEXES IS
  BEGIN
      DROP_XML_INDEXES;
      
      vsql := 'alter table '||vschema||'.mdm_metadata parallel';
      CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.mdm_metadata');
      
      vsql := 'alter table '||vschema||'.mdm_metadata_revision parallel';
      CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.mdm_metadata_revision');

        --context index 
      vsql := 'CREATE INDEX '||vschema||'.mdm_index_xmltype ON '||vschema||'.MDM_METADATA(OBJECT_VALUE) INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS (''SYNC (ON COMMIT)'') PARALLEL';
      CREATEOBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.mdm_index_xmltype');
      
      vsql := 'ALTER INDEX '||vschema||'.mdm_index_xmltype  NOPARALLEL';
      createobject(vsql,'Unable to alter INDEX '||vschema||'.mdm_index_xmltype');

       --Unstructed Index on MDM_METADATA
      vsql := 'CREATE INDEX '||vschema||'.ecmfspec_xmlindex ON '||vschema||'.mdm_metadata(OBJECT_VALUE) INDEXTYPE IS XDB.XMLIndex PARAMETERS (''PATH TABLE path_tab ASYNC (SYNC ALWAYS)'')';
      CREATEOBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.ecmfspec_xmlindex');
      
       --Unstructed Index on MDM_METADATA
/*      VSQL := 'CREATE INDEX '||VSCHEMA||'.ecmfspec_xmlindex ON '||VSCHEMA||'.mdm_metadata(OBJECT_VALUE) INDEXTYPE IS XDB.XMLIndex PARAMETERS (''PATH TABLE path_tab ASYNC (SYNC ALWAYS) PATHS(EXCLUDE(/ECMFSpec/@documentId /ECMFSpec/Package/Fields/Identifier/Id  /ECMFSpec/Package/Title/Fields/Title/ShortTitle/Value  /ECMFSpec/Package/Fields/Version/Major  /ECMFSpec/Package/Title/Fields/Rights/LicensingWindowStart  /ECMFSpec/Package/Title/Fields/Rights/LicensingWindowEnd  /ECMFSpec/Package/Fields/AssetName  /ECMFSpec/Package/Title/Fields/BillingInfo/SuggestedPrice/Value /ECMFSpec/Package/Title/Fields/Duration/Duration /ECMFSpec/Package/Title/Fields/ProviderInfo/Identifier/Id /ECMFSpec/Package/Fields/ProviderInfo/Identifier/Id /ECMFSpec/Series/Fields/AssetName /ECMFSpec/Series/Fields/AssetClass /ECMFSpec/Series/Title/Fields/Title/ShortTitle/Value /ECMFSpec/Package/Fields/CustomFields/CustomField /ECMFSpec/Package/Movie/Fields/CustomFields/CustomField /ECMFSpec/Package/Title/Fields/CustomFields/CustomField))'') PARALLEL';
      CREATEOBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.ecmfspec_xmlindex');
*/      
      VSQL := 'create index '||VSCHEMA||'.idx_xml_path_tab on '||VSCHEMA||'.path_tab(rid,sys_orderkey_depth(order_key),order_key) parallel';
      CREATEOBJECT(VSQL,'Unable to CREATE INDEX '||VSCHEMA||'.idx_xml_path_tab');
      
      VSQL := 'alter index '||VSCHEMA||'.idx_xml_path_tab noparallel';
      createobject(vsql,'Unable to alter INDEX '||vschema||'.idx_xml_path_tab');

      vsql := 'BEGIN
                   dbms_xmlindex.registerparameter(
                      ''ecmfstructuredxml_idx'',
                      ''ADD_GROUP GROUP ecmfdisplayfields
                      XMLTable ecmfdisplay_tab ''''/ECMFSpec''''
                      COLUMNS ttvid number path ''''@documentId'''',
                      PackageAssetId varchar2(4000 CHAR) path ''''Package/Fields/Identifier/Id'''',
                      titlebrief varchar2(4000 CHAR) path ''''Package/Title/Fields/Title/ShortTitle/Value'''',
                      versionmajor number path ''''Package/Fields/Version/Major'''',
                      licwinstrt timestamp with time zone path ''''Package/Title/Fields/Rights/LicensingWindowStart'''',
                      licwinend timestamp with time zone path ''''Package/Title/Fields/Rights/LicensingWindowEnd'''',
                      Assetname varchar2(4000 CHAR) path ''''Package/Fields/AssetName'''',
                      PriceValue number path ''''Package/Title/Fields/BillingInfo/SuggestedPrice/Value'''',
                      Duration varchar2(4000 CHAR) path ''''Package/Title/Fields/Duration/Duration'''',
                      TProviderId varchar2(4000 CHAR) path ''''Package/Title/Fields/ProviderInfo/Identifier/Id'''',
                      PProviderId varchar2(4000 CHAR) path ''''Package/Fields/ProviderInfo/Identifier/Id''''
                      '');
                END;';
      CREATEOBJECT(vsql,'Unable to registerparameter for xmlindex');

      --Add Structured index to unstructed index
      vsql := 'ALTER INDEX '||vschema||'.ecmfspec_xmlindex parameters(''PARAM ecmfstructuredxml_idx'')';
      CREATEOBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmfspec_xmlindex parameters');

      --Murtaza added index to speed up MDM_METADATA document id lookups
      VSQL := 'create index '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid on '||VSCHEMA||'.ecmfdisplay_tab(ttvid) parallel';
      CREATEOBJECT(VSQL,'Unable to create index '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid on ecmfdisplay_tab(ttvid)');

      vsql := 'alter index '||vschema||'.idx_ecmfdisplaytab_ttvid noparallel';
      createobject(vsql,'Unable to alter index '||vschema||'.idx_ecmfdisplaytab_ttvid');

      -- Murtaza added seriesxml_idx on 02/24/2012.
      vsql := 'BEGIN
                   dbms_xmlindex.registerparameter(
                      ''ecmfseriesxml_idx'',
                      ''ADD_GROUP GROUP ecmfseriesfields
                      XMLTable ecmfseries_tab ''''/ECMFSpec/Series/Season''''
                      COLUMNS SeriesAssetID number path ''''@assetId'''',
                      SeriesAssetName varchar2(4000) path ''''Fields/AssetName'''',
                      SeriesSeasonID varchar2(4000) path ''''Fields/SeasonID/Id''''
                      '');
                END;';
      CREATEOBJECT(vsql,'Unable to registerparameter for ecmfseriesxml_idx xml index.');

      --Add Structured index to unstructed index
      VSQL := 'ALTER INDEX '||VSCHEMA||'.ecmfspec_xmlindex parameters(''PARAM ecmfseriesxml_idx'')';
      CREATEOBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmfseriesxml_idx parameters');

      -- Murtaza added seriesfieldsxml_idx on 03/06/2012.
      vsql := 'BEGIN
                   DBMS_XMLINDEX.REGISTERPARAMETER(
                      ''ecmfseriesfldsxml_idx'',
                      ''ADD_GROUP GROUP ecmfseriesfldfields
                      XMLTable ecmfseriesfld_tab ''''/ECMFSpec/Series''''
                      COLUMNS 
                      SeriesFldAssetClass varchar2(4000) path ''''Fields/AssetClass'''',
                      SeriesFldAssetName varchar2(4000) path ''''Fields/AssetName'''',
                      SeriesFldDesc varchar2(4000) path ''''Fields/Description/Text'''',
                      SeriesFldId varchar2(4000) path ''''Fields/ExternalSeriesID/Id'''',
                      SeriesFldTvNetwork varchar2(4000) path ''''Title/Fields/TvId/Network'''',
                      SeriesFldTitleBrief varchar2(4000) path ''''Title/Fields/Title/ShortTitle/Value''''
                      '');
                END;';
      CREATEOBJECT(VSQL,'Unable to registerparameter for ecmfseriesfldsxml_idx xml index.');

      --Add Structured index to unstructed index
      VSQL := 'ALTER INDEX '||VSCHEMA||'.ECMFSPEC_XMLINDEX PARAMETERS(''PARAM ecmfseriesfldsxml_idx'')';
      CREATEOBJECT(VSQL,'Unable to ALTER INDEX '||VSCHEMA||'.ecmfseriesfldsxml_idx parameters');
      
      --Bak added an index for mdm_metadata_revision table on 05/05/2011
      VSQL := 'create index '||VSCHEMA||'.ecmfspec_rev_xmlindex on '||VSCHEMA||'.mdm_metadata_revision(object_value) '||
              ' indextype is xdb.xmlindex parameters (''PATH TABLE path_rev_tab ASYNC (SYNC ALWAYS) '||
              ' PATHS (INCLUDE (/ECMFSpec/@documentId  /ECMFSpec/@revision))'') PARALLEL';
      CREATEOBJECT(VSQL,'Unable to create index '||VSCHEMA||'.ecmfspec_rev_xmlindex on mdm_metadata_revision(object_value)');

      VSQL := 'alter index '||VSCHEMA||'.ecmfspec_rev_xmlindex NOPARALLEL';
      createobject(vsql,'Unable to alter index '||vschema||'.ecmfspec_rev_xmlindex');
       
       --Murtaza added index asstuniqueness_idx on 04/22/2013 
      vsql := 'BEGIN
                   dbms_xmlindex.registerparameter(
                      ''ecmfasstuniqueness_idx'',
                      ''ADD_GROUP GROUP ecmfasstuniqueness
                        XMLTable ecmfassetcheck_tab ''''//*''''
                          COLUMNS 
                          AnyAssetId varchar2(4000) path ''''Fields/Identifier/Id'''',
                          AnyProviderId varchar2(4000) path ''''Fields/ProviderInfo/Identifier/Id''''
                      '');
                END;';
      CREATEOBJECT(vsql,'Unable to registerparameter for ecmfasstuniqueness_idx');

      --Add Structured index to unstructed index      
      vsql := 'ALTER INDEX '||vschema||'.ECMFSPEC_XMLINDEX parameters(''PARAM ecmfasstuniqueness_idx'')';
      CREATEOBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmfasstuniqueness_idx parameters');

      --Add index on asset id
      vsql := 'create index '||vschema||'.ecmfasstunqchk_idx01 on '||vschema||'.ecmfassetcheck_tab(anyassetid) parallel';
      CREATEOBJECT(vsql,'Unable to create INDEX '||vschema||'.ecmfasstunqchk_idx01');

      vsql := 'alter index '||vschema||'.ecmfasstunqchk_idx01 noparallel';
      createobject(vsql,'Unable to alter INDEX '||vschema||'.ecmfasstunqchk_idx01');
      
       --Murtaza added index Package CustomFields on 05/02/2013 
      vsql := 'BEGIN
                  DBMS_XMLINDEX.REGISTERPARAMETER(
                  ''ecmfpkgcustomflds_idx'',
                  ''ADD_GROUP GROUP ecmfpkgcustomflds
                      XMLTable ecmfpkgcustomflds_tab ''''/ECMFSpec/Package/Fields/CustomFields/CustomField''''
                      COLUMNS 
                      cfname varchar2(4000) path ''''@name'''',
                      cfdatetmval timestamp with time zone path ''''DatetimeValue'''',
                      cfvalue varchar2(1000) path ''''Value'''',
                      cfboolval varchar2(100) path ''''BooleanValue'''',
                      cfintval NUMBER path ''''IntegerValue'''',
                      cftimval varchar2(100) path ''''TimeValue'''',
                      cffloatval NUMBER path ''''FloatValue''''
                      '');
                  end;';

      CREATEOBJECT(vsql,'Unable to registerparameter for ecmfpkgcustomflds_idx');

      --Add ecmfpkgcustomflds_idx Structured index to unstructured index      
      vsql := 'alter index '||vschema||'.ecmfspec_xmlindex parameters(''PARAM ecmfpkgcustomflds_idx'')';
      CREATEOBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmfpkgcustomflds_idx parameters');

      vsql := 'create index '||vschema||'.ecmfpkgcfname_idx on '||vschema||'.ecmfpkgcustomflds_tab(cfname) parallel';      
      createobject(vsql,'Unable to create index '||vschema||'.ecmfpkgcfname_idx on ecmfpkgcustomflds_tab(cfname)');
      
      vsql := 'alter index '||vschema||'.ecmfpkgcfname_idx noparallel';      
      createobject(vsql,'Unable to alter index '||vschema||'.ecmfpkgcfname_idx noparallel');

       --Murtaza added index Package Movie CustomFields on 05/02/2013 
      vsql := 'BEGIN
                  DBMS_XMLINDEX.REGISTERPARAMETER(
                  ''ecmfmovcustomflds_idx'',
                  ''ADD_GROUP GROUP ecmfmovcustomflds
                      XMLTable ecmfmovcustomflds_tab ''''/ECMFSpec/Package/Movie/Fields/CustomFields/CustomField''''
                      COLUMNS 
                      cfname varchar2(4000) path ''''@name'''',
                      cfdatetmval timestamp with time zone path ''''DatetimeValue'''',
                      cfvalue varchar2(1000) path ''''Value'''',
                      cfboolval varchar2(100) path ''''BooleanValue'''',
                      cfintval NUMBER path ''''IntegerValue'''',
                      cftimval varchar2(100) path ''''TimeValue'''',
                      cffloatval NUMBER path ''''FloatValue''''
                      '');
                  end;';

      CREATEOBJECT(vsql,'Unable to registerparameter for ecmfmovcustomflds_idx');

      --Add ecmfpkgcustomflds_idx Structured index to unstructured index      
      vsql := 'alter index '||vschema||'.ecmfspec_xmlindex parameters(''PARAM ecmfmovcustomflds_idx'')';
      CREATEOBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmfmovcustomflds_idx parameters');

      vsql := 'create index '||vschema||'.ecmfmovcfname_idx on '||vschema||'.ecmfmovcustomflds_tab(cfname) parallel';      
      createobject(vsql,'Unable to create index '||vschema||'.ecmfpkgcfname_idx on ecmfmovcustomflds_tab(cfname)');

      vsql := 'alter index '||vschema||'.ecmfmovcfname_idx noparallel';      
      createobject(vsql,'Unable to alter index '||vschema||'.ecmfpkgcfname_idx noparallel');

       --Murtaza added index Package Title CustomFields on 05/10/2013 
      vsql := 'BEGIN
                  DBMS_XMLINDEX.REGISTERPARAMETER(
                  ''ecmftlecustomflds_idx'',
                  ''ADD_GROUP GROUP ecmftlecustomflds
                      XMLTable ecmftlecustomflds_tab ''''/ECMFSpec/Package/Title/Fields/CustomFields/CustomField''''
                      COLUMNS 
                      cfname varchar2(4000) path ''''@name'''',
                      cfdatetmval timestamp with time zone path ''''DatetimeValue'''',
                      cfvalue varchar2(1000) path ''''Value'''',
                      cfboolval varchar2(100) path ''''BooleanValue'''',
                      cfintval NUMBER path ''''IntegerValue'''',
                      cftimval varchar2(100) path ''''TimeValue'''',
                      cffloatval NUMBER path ''''FloatValue''''
                      '');
                  end;';

      CREATEOBJECT(vsql,'Unable to registerparameter for ecmftlecustomflds_idx');

      --Add ecmftlecustomflds_idx Structured index to unstructured index      
      vsql := 'alter index '||vschema||'.ecmfspec_xmlindex parameters(''PARAM ecmftlecustomflds_idx'')';
      CREATEOBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmftlecustomflds_idx parameters');

      vsql := 'create index '||vschema||'.ecmftlecfname_idx on '||vschema||'.ecmftlecustomflds_tab(cfname) parallel';      
      createobject(vsql,'Unable to create index '||vschema||'.ecmftlecfname_idx on ecmftlecustomflds_tab(cfname)');

      vsql := 'alter index '||vschema||'.ecmftlecfname_idx noparallel';      
      createobject(vsql,'Unable to create index '||vschema||'.ecmftlecfname_idx on ecmftlecustomflds_tab(cfname)');

      dbms_stats.gather_table_stats('WFS','MDM_METADATA',cascade=>true,degree=>dbms_stats.auto_degree);

      vsql := 'alter index '||vschema||'.ecmfspec_xmlindex noparallel';      
      createobject(vsql,'Unable to alter index '||vschema||'.ecmfspec_xmlindex');

      vsql := 'alter table '||vschema||'.mdm_metadata_revision noparallel';
      CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.mdm_metadata_revision noparallel');
      
      vsql := 'alter table '||vschema||'.mdm_metadata noparallel';
      CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.mdm_metadata noparallel');

      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of XML INDEXES completed SUCCESSFULLY'')';
  END ReCreate_XML_INDEXES;

  /***********************************************************************************************
    ----------------------------------------CREATE RULES-------------------------------------------
   *************************************************************************************************/
    PROCEDURE createRULES IS
		wk_message	varchar2(500);
		wk_release	varchar2 (25);	
		wk_count		number := 0;	
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN

      vsql := 'create table '||vschema||'.Tre_Package (
          packageId number(10,0) not null, 
          n_Version number(10,0) not null, 
          name nvarchar2 (255) not null, 
          createdate DATE default (SYSDATE), 
          updatedate DATE default (SYSDATE), 
          primary key (packageId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_Package');
      CREATESEQ('TRE_PACKAGE');
      
      vsql := 'create table '||vschema||'.Tre_Predicate (
          predicateId NUMBER not null,
          CLASS_ID varchar2(255) not null,
          n_Version number(10,0) not null, 
          fieldLeft NVARCHAR2(1024) null,
          fieldRight NVARCHAR2(1024) null,
          fieldLeftSectionType NVARCHAR2(64) null,
          fieldRightSectionType NVARCHAR2(64) null,
          fieldTypeLhs NVARCHAR2(32) not null,
          fieldTypeRhs NVARCHAR2(32) null,
          not_ NUMBER(1,0) default(0) not null,
          operator  NVARCHAR2(32) not null,
          ParentPredicateId NUMBER(10,0),
          childOrder NUMBER(10,0),
          ignorecase NUMBER(1,0) default 0,
          createdate DATE default (SYSDATE), 
          updatedate DATE default (SYSDATE), 
          primary key (predicateId),
          constraint FK_TrePred_TrePred_Parent foreign key (parentPredicateId) references '||vschema||'.Tre_Predicate(predicateId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_Predicate');
      CREATESEQ('Tre_Predicate');
      
      vsql := 'create table '||vschema||'.Tre_PredicateValue (
          predicateId NUMBER not null,
          value_ NVARCHAR2(2000) not null,
          order_ NUMBER null,
          constraint FK_PredicateVal_Predicate foreign key (predicateId) references '||vschema||'.Tre_Predicate(predicateId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_PredicateValue');
       
      vsql := 'create table '||vschema||'.Tre_expNode (
          nodeId NUMBER not null, 
          CLASS_ID varchar2(10) not null,
          predicateId NUMBER, 
          operator varchar2(256) null,
          parentId NUMBER null, 
          order_	 NUMBER null,
          createdate DATE default (SYSDATE), 
          updatedate DATE default (SYSDATE), 
          primary key (nodeId),
          constraint FK_ExpNode_ExpNode_Parent foreign key (parentId) references '||vschema||'.Tre_expNode(nodeId),
          constraint FK_ExpNode_predicate foreign key (predicateId) references '||vschema||'.Tre_Predicate(predicateId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_expNode');
      CREATESEQ('Tre_expNode');
      
      vsql := 'create table '||vschema||'.Tre_TitleFilter (
          titleFilterId			NUMBER,
          rootNodeId				NUMBER,
          sortColumnName			NVARCHAR2 (256),
          sortColumnSection		NVARCHAR2 (256),
          sortOrder				NVARCHAR2 (256),
          includecount number(1,0) default 0,
          sortfieldtype number, 
          criteriamode NUMBER DEFAULT 0 NOT NULL,
          primary key (titleFilterId),
          constraint FK_TitleFilter_ExpNode foreign key (rootNodeId) references '||vschema||'.Tre_expNode(nodeId))';        
      CREATEOBJECT(vsql,'Unable to create table Tre_TitleFilter');
      CREATESEQ('tre_titleFilter');
      
      vsql := 'create table '||vschema||'.Tre_RuleSet (
          ruleSetId number(10,0) not null, 
          n_Version number(10,0) not null,
          ruleName nvarchar2 (255) not null,
          packageId NUMBER null, 
          titleFilterId NUMBER null,
          enabled NUMBER(1,0) default(1),
          order_ number default 0,
          runOnGlobal NUMBER(1,0) default (1) not null ,
          uuid varchar2(36) not null,
          class_id VARCHAR2(10) DEFAULT ''RS'' NOT NULL,
          createdate DATE default (SYSDATE),
          updatedate DATE default (SYSDATE),
          primary key (ruleSetId),
		  constraint treRULESET_UUID_UNIQUE UNIQUE (UUID),
          constraint FK_RULESET_PACKAGE foreign key (PackageId) references '||vschema||'.Tre_Package(packageId),
          constraint FK_TreeNode_Filter foreign key (titleFilterId) references '||vschema||'.Tre_TitleFilter(titleFilterId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_RuleSet');
      CREATESEQ('Tre_ruleSet');
      
      vsql := 'create table '||vschema||'.Tre_event (
          eventId NUMBER not null, 
          name nvarchar2 (25), 
          description nvarchar2 (255), 
          createdate DATE default (SYSDATE), 
          updatedate DATE default (SYSDATE), 
          primary key (eventId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_event');
          
      vsql := 'create table '||vschema||'.Tre_RULESET_EVENT (
          eventId number(10,0) not null, 
          RuleSetId number(10,0) not null, 
          primary key (RuleSetId, eventId),
          constraint FK_RULESETEVENT_RULE foreign key (RuleSetId) references '||vschema||'.Tre_RuleSet(ruleSetId),
          constraint FK_RULESETEVENT_EVENT foreign key (eventId) references '||vschema||'.Tre_event(eventId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_RULESET_EVENT');
      
      vsql := 'create table '||vschema||'.Tre_rule (
          ruleId number(10,0) not null, 
          n_Version number(10,0) not null, 
          message nvarchar2 (512) null,
          ruleSetId NUMBER, 
          rootNodeId NUMBER, 
          createdate DATE default (SYSDATE), 
          updatedate DATE default (SYSDATE), 
          order_ number(10,0),
          CLASS_ID VARCHAR2(2) default (''SR'') not null ,
          className VARCHAR2(1024),
          primary key (ruleId),
          constraint FK_RuleSet_Rule foreign key (ruleSetId) references '||vschema||'.Tre_RuleSet(ruleSetId),
          constraint FK_Rule_ExpNode foreign key (rootNodeId) references '||vschema||'.Tre_expNode(nodeId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_rule');
      CREATESEQ('TRE_RULE');
      
      vsql := 'create table '||vschema||'.Tre_action (
          actionId number(10,0) not null, 
          method nvarchar2 (512) not null, 
          order_ NUMBER null, 
          createdate DATE default (SYSDATE), 
          updatedate DATE default (SYSDATE), 
          ruleId number(10,0), 
          primary key (actionId),
          constraint FK_Rule_Action foreign key (ruleId) references '||vschema||'.Tre_rule(ruleId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_action');
      CREATESEQ('TRE_ACTION');
      
      vsql := 'create table '||vschema||'.Tre_ActionParameterValue (
          valueId number(10,0) not null, 
          name nvarchar2(256) not null,
          value varchar2(1024) null, 
          createdate DATE default (SYSDATE), 
          updatedate DATE default (SYSDATE), 
          actionId number(10,0),
          order_ number(10,0), 
          primary key (valueId),
          constraint FK_WOMP_WOParamValue foreign key (actionId) references '||vschema||'.Tre_action(actionId))';
      CREATEOBJECT(vsql,'Unable to create table Tre_ActionParameterValue');
    
      vsql := 'create table '||vschema||'.Tre_TitleSearch (
          titleSearchId NUMBER not null,
          titleFilterId NUMBER not null,
          name NVARCHAR2(256)  not null,
          userName NVARCHAR2(256)  not null,
          shared NUMBER(1,0)  not null,
          primary key(titleSearchId),
          constraint FK_TitleSearch_Filter foreign key (titleFilterId) references '||vschema||'.Tre_TitleFilter(titleFilterId),
          constraint TRE_TITLESEARCH_UNIQ UNIQUE (NAME,USERNAME))';        
      CREATEOBJECT(vsql,'Unable to create table Tre_TitleSearch');
      CREATESEQ('tre_titleSearch');
      
      vsql := 'create table '||vschema||'.Tre_CustomRuleParameter (
                parameterId NUMBER not null,
                ruleId NUMBER null,
                value_ VARCHAR2(2000) not null,
                key_ varchar2(512) not null,
                order_ NUMBER,
                primary key(parameterId),
                constraint FK_Rule_CRParameter foreign key (ruleId) references '||vschema||'.Tre_Rule(ruleId)
              )';
      CREATEOBJECT(vsql,'Unable to create table Tre_CustomRuleParameter');
      CREATESEQ('Tre_CustomRuleParameter');

      vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION (
                CORRELATIONID      VARCHAR2(128 BYTE),
                WORKFLOWREFERNCEID VARCHAR2(256 BYTE),
                FINISHED           NUMBER(1,0) DEFAULT(0),
                CREATEDATE         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                UPDATEDATE         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                CONSTRAINT TRE_BULKEXEC_CORRELATIONID_PK PRIMARY KEY ("CORRELATIONID"))';
      CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION');
      CREATEUPDATETRG('TRE_BULKEXECUTION');

      vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_CONTENTPROC (
                correlationId REFERENCES '||vschema||'.tre_bulkExecution,
                titleId       REFERENCES '||vschema||'.pmm_title,
                ruleSetId     REFERENCES '||vschema||'.Tre_RuleSet,
                CREATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                UPDATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                CONSTRAINT TRE_BULK_CONTENTPROC_CORRID_PK PRIMARY KEY(correlationId, titleId, ruleSetId))';
      CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION_CONTENTPROC');
      CREATEUPDATETRG('TRE_BULKEXECUTION_CONTENTPROC');

      vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_GENERAL (
                correlationId REFERENCES '||vschema||'.tre_bulkExecution,
                titleId       REFERENCES '||vschema||'.pmm_title,
                CREATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                UPDATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                CONSTRAINT TRE_BULK_GENERL_CORRID_PK PRIMARY KEY(correlationId, titleId))';
      CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION_GENERAL');
      CREATEUPDATETRG('TRE_BULKEXECUTION_GENERAL');

      vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_FAILEDTITLES (
                correlationId REFERENCES '||vschema||'.tre_bulkExecution,
                titleId       REFERENCES '||vschema||'.pmm_title,
                CREATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                UPDATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                CONSTRAINT TRE_BULK_FAILTITLES_CORRID_PK PRIMARY KEY(correlationId, titleId))';
      CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION_FAILEDTITLES');
      CREATEUPDATETRG('TRE_BULKEXECUTION_FAILEDTITLES');

      -- Suneeta Added a new table TITLE_SEARCH_RESULTS_COL on 03-07-2011
      vsql := 'CREATE TABLE '||vschema||'.TITLE_SEARCH_RESULTS_COL (
                id          NUMBER NOT NULL, 
                name        VARCHAR2(2000) NOT NULL, 
                order_      NUMBER NOT NULL, 
                searchId    NUMBER NOT NULL,
                createdate  DATE default (SYSDATE), 
                updatedate  DATE default (SYSDATE),                 
                CONSTRAINT PK_SEARCH_RESULTS_ID PRIMARY KEY (ID),
                CONSTRAINT FK_SEARCH_RESULTS_SEARCH_ID FOREIGN KEY (searchId) REFERENCES '||vschema||'.TRE_TITLESEARCH (TITLESEARCHID)
              )';
      CREATEOBJECT(vsql,'Unable to create table TITLE_SEARCH_RESULTS_COL');
      CREATESEQ('TITLE_SEARCH_RESULTS_COL');
      CREATEUPDATETRG('TITLE_SEARCH_RESULTS_COL'); 
      
      -- Daniel Weiner Added a new table tre_ruleset_mso on 03-06-2013
      vsql := 'CREATE TABLE '||vschema||'.tre_ruleset_mso (
                rulesetid     NUMBER,
                msoid         NUMBER,
                createdate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                updatedate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                CONSTRAINT pk_tre_ruleset_mso_rs_msoid primary key(rulesetid, msoid),
                CONSTRAINT fk_rulesetmso_ruleset FOREIGN KEY (rulesetid) REFERENCES '||vschema||'.tre_ruleset(rulesetid))';
      CREATEOBJECT(vsql,'Unable to create table tre_ruleset_mso');
      CREATEUPDATETRG('tre_ruleset_mso');

      vsql := 'create sequence '||vschema||'.tre_ActionParamValue_seq NOCACHE';
      CREATEOBJECT(vsql,'Unable to create sequence tre_ActionParamValue_seq');
        
      vsql := 'create sequence '||vschema||'.Tre_predicateValue_seq NOCACHE';
      CREATEOBJECT(vsql,'Unable to create sequence Tre_predicateValue_seq');
      
      -- updated event names and a new event "DELETE" has been created by Daniel Weiner on 08-13-2010
      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(0,''INGESTED'',''Occurs when a title is ingested.'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');

      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(1,''UICREATED'',''Occurs when a title is created through the UI.'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');

      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(2,''UIUPDATED'',''Occurs when a title is updated through the UI.'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');

      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(3,''NORMALIZED'',''Occurs when a title is nationalized.'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');

      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(4,''SCHEDULE'',''Can be triggered through an job in PMM job module.'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');

      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(5,''TARGETED'',''Used for content processing rules when a title is finished being targeted.'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');

      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(6,''PURGE'',''Can be triggered through an job in PMM job module.'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');
      
      vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(7,''DELETED'','''')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');
            
      vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(1,1,''VALIDATION'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_PACKAGE');

      vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(2,1,''NORMALIZATION'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_PACKAGE');

      vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(3,1,''TARGETING'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_PACKAGE');

      vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(4,1,''PROCESSING'')';
      CREATEOBJECT(vsql,'Unable to insert into Tre_PACKAGE');

      -- Sanjay: 01/07/2011 added a new record for Prioritization in tre_package table.
      vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(5,1,''PRIORITIZATION'')';
      createobject(vsql,'Unable to insert into Tre_PACKAGE');

      -- Daniel added a new record for Licensing in tre_package table on 02/07/2012.
      vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(6,1,''LICENSING'')';
      createobject(vsql,'Unable to insert into Tre_PACKAGE');

      -- Daniel added a new record for MSO Override in tre_package table on 03/08/2013.
      vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(7,1,''MSOOVERRIDE'')';
      createobject(vsql,'Unable to insert into Tre_PACKAGE');

      -- Murtaza added four indexed to fix bug#5620
      vsql := 'create index '||vschema||'.idx_tre_action_ruleid on '||vschema||'.tre_action (ruleid)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_action_ruleid on '||vschema||'.tre_action (ruleid)'); 

      vsql := 'create index '||vschema||'.idx_tre_actionparmval_actionid on '||vschema||'.tre_actionparametervalue(actionid)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_actionparmval_actionid on '||vschema||'.tre_actionparametervalue(actionid)');

      vsql := 'create index '||vschema||'.idx_tre_expnode_parentid on '||vschema||'.tre_expnode(parentid)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_expnode_parentid on '||vschema||'.tre_expnode(parentid)');

      vsql := 'create index '||vschema||'.idx_tre_rule_rulesetid on '||vschema||'.tre_rule(rulesetid)';
      CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_rule_rulesetid on '||vschema||'.tre_rule(rulesetid)');
      
      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of createRULES completed SUCCESSFULLY'')';

      commit;
    END createRULES;

  /***********************************************************************************************
   ----------------------------------------CREATE SITES------------------------------------------
   *************************************************************************************************/
    PROCEDURE createSITES IS
		wk_message	varchar2(500);
		startNum	NUMBER;
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN

      vsql := 'CREATE TABLE '||vschema||'.SITES_SITETYPE (
                  ID_ NUMBER NOT NULL ENABLE,
                  TYPE VARCHAR2(255) NOT NULL,
                  CONSTRAINT SITES_SITETYPE_PK PRIMARY KEY (ID_),
                  CONSTRAINT SITES_SITETYPE_UK1 UNIQUE (TYPE)
                )';
      CREATEOBJECT(vsql,'Unable to create table sites_sitetype','Y');

      vsql := 'CREATE TABLE '||vschema||'.SITES_DISTRIBUTION_OPTION (
        ID_ NUMBER NOT NULL,
        NAME VARCHAR2(255) NOT NULL,
        CONSTRAINT SITES_DISTRIBUTION_OPTION_PK PRIMARY KEY (ID_),
        CONSTRAINT SITES_DISTRIBUTION_OPTION_UK1 UNIQUE (NAME)
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_DISTRIBUTION_OPTION','Y');
      
      vsql := 'CREATE TABLE '||vschema||'.SITES_DISTRIBUTION_STATUS (
        ID_ NUMBER NOT NULL ,
        NAME VARCHAR2(255) NOT NULL ,
        CONSTRAINT SITES_DISTRIBUTION_STATUS_PK PRIMARY KEY (ID_),
        CONSTRAINT SITES_DISTRIBUTION_STATUS_UK1 UNIQUE (NAME)
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_DISTRIBUTION_STATUS','Y');
      
      vsql := 'CREATE TABLE '||vschema||'.SITES_TRACKING_STATUS (
        ID_ NUMBER NOT NULL ,
        NAME VARCHAR2(255) NOT NULL ,
        CONSTRAINT SITES_TRACKING_STATUS_PK PRIMARY KEY (ID_),
        CONSTRAINT SITES_TRACKING_STATUS_UK1 UNIQUE (NAME)
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_TRACKING_STATUS','Y');
      
      vsql := 'CREATE TABLE '||vschema||'.SITES_SITE (
        ID_ NUMBER NOT NULL,
        EXTERNALID VARCHAR2(255),
        NAME VARCHAR2(255) NOT NULL ,
        DESCRIPTION VARCHAR2(1000),
        ACTIVE NUMBER(1,0) DEFAULT 1 NOT NULL ,
        TYPE NUMBER NOT NULL ENABLE,
        METADATA_FORMAT VARCHAR2(255),
        FILE_LOOKUP_KEYS VARCHAR2(1000),
        DISTRIBUTION_OPTION NUMBER,
        ALERT_DELAY_PERIOD NUMBER,
        ASSOCIATED_RESOURCE_ID NUMBER,
        DIST_TEMPLATE_NAME VARCHAR2(1000),
        EXPORT_PLUGIN_NAME VARCHAR2(255),
        ASSOCIATED_GROUP_NAME VARCHAR2(255),
        CONSTRAINT SITES_SITE_PK PRIMARY KEY (ID_),
        CONSTRAINT SITES_SITE_UK2 UNIQUE (NAME),
        CONSTRAINT SITES_SITE_SITES_SITETYPE_FK1 FOREIGN KEY (TYPE) REFERENCES '||vschema||'.SITES_SITETYPE (ID_) ,
        CONSTRAINT SITES_SITE_SITES_DISTRIBU_FK1 FOREIGN KEY (DISTRIBUTION_OPTION) REFERENCES '||vschema||'.SITES_DISTRIBUTION_OPTION (ID_) ,
        CONSTRAINT SITES_SITE_TTV_RESOURCE_FK1 FOREIGN KEY (ASSOCIATED_RESOURCE_ID) REFERENCES '||vschema||'.TTV_RESOURCE (RESOURCEID)
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_SITE','Y');
      CREATESEQ('SITES_SITE');      
      
      vsql := 'CREATE TABLE '||vschema||'.SITES_SITELINK (
        PARENT NUMBER NOT NULL ,
        CHILD NUMBER NOT NULL ,
        CONSTRAINT SITES_SITELINK_PK PRIMARY KEY (PARENT, CHILD),
        CONSTRAINT SITES_SITELINK_SITES_SITE_FK1 FOREIGN KEY (PARENT) REFERENCES '||vschema||'.SITES_SITE (ID_) ,
        CONSTRAINT SITES_SITELINK_SITES_SITE_FK2 FOREIGN KEY (CHILD) REFERENCES '||vschema||'.SITES_SITE (ID_) 
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_SITELINK','Y');
      
      vsql := 'CREATE TABLE '||vschema||'.SITES_DISTSITETITLE (
        SITEID NUMBER NOT NULL ,
        TITLEID NUMBER NOT NULL ,
        ID_ NUMBER NOT NULL ,
        STATUS NUMBER,
        STATUS_UPDATED_TIME TIMESTAMP(6),
        DISTRIBUTED_VERSION VARCHAR2(255 ),
        CONSTRAINT SITES_DISTSITETITLE_PK PRIMARY KEY (ID_),
        CONSTRAINT SITES_DISTSITETITLE_UK1 UNIQUE (TITLEID),
        CONSTRAINT SITES_DISTSITETITLE_SITES_FK1 FOREIGN KEY (SITEID) REFERENCES '||vschema||'.SITES_SITE (ID_) ,
        CONSTRAINT SITES_DISTSITETITLE_PMM_T_FK1 FOREIGN KEY (TITLEID) REFERENCES '||vschema||'.PMM_TITLE (ID_) ,
        CONSTRAINT SITES_DISTSITETITLE_SITES_FK2 FOREIGN KEY (STATUS) REFERENCES '||vschema||'.SITES_DISTRIBUTION_STATUS (ID_) 
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_DISTSITETITLE','Y');
      CREATESEQ('SITES_DISTSITETITLE');      

      vsql := 'CREATE TABLE '||vschema||'.SITES_DIST_CONF_PARAMS (
        SITEID NUMBER NOT NULL ,
        NAME VARCHAR2(255) NOT NULL ,
        VALUE VARCHAR2(255),
        CONSTRAINT SITES_DIST_CONF_PARAMS_PK PRIMARY KEY (SITEID, NAME),
        CONSTRAINT SITES_DIST_CONF_PARAMS_SI_FK1 FOREIGN KEY (SITEID) REFERENCES '||vschema||'.SITES_SITE (ID_) 
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_DIST_CONF_PARAMS','Y');
      
      vsql := 'CREATE TABLE '||vschema||'.SITES_TRACKSITETITLE (
        SITEID NUMBER NOT NULL ,
        TITLEID NUMBER NOT NULL ,
        STATUS NUMBER,
        STATUS_UPDATED_TIME TIMESTAMP(6),
        CONSTRAINT SITES_TRACKSITETITLE_PK PRIMARY KEY (SITEID, TITLEID),
        CONSTRAINT SITES_TRACKSITETITLE_SITE_FK1 FOREIGN KEY (SITEID) REFERENCES '||vschema||'.SITES_SITE (ID_), 
        CONSTRAINT SITES_TRACKSITETITLE_SITE_FK2 FOREIGN KEY (STATUS) REFERENCES '||vschema||'.SITES_TRACKING_STATUS (ID_), 
        CONSTRAINT SITES_TRACKSITETITLE_PMM__FK1 FOREIGN KEY (TITLEID) REFERENCES '||vschema||'.PMM_TITLE (ID_)
      )';
      CREATEOBJECT(vsql,'Unable to create table SITES_TRACKSITETITLE','Y');

      --Sanjay's addition
      vsql := 'CREATE TABLE '||vschema||'.SITE_MONITORING (
                ID NUMBER NOT NULL,
                SITE_ID NUMBER NOT NULL,
                PLUGIN_ID VARCHAR2(100) NOT NULL,
                ASSOCIATED VARCHAR2(1),
                MONITORING_ENABLED VARCHAR2(1),
                MONITORING_TYPE VARCHAR2(100) DEFAULT ''UNKNOWN'',
                CREATEDATE DATE DEFAULT (SYSDATE),
                UPDATEDATE DATE DEFAULT (SYSDATE),
                PRIMARY KEY (ID)
              )';
      CREATEOBJECT(vsql,'Unable to create table SITE_MONITORING','Y');
      CREATESEQ('SITE_MONITORING');
      
      vsql := 'CREATE UNIQUE INDEX '||vschema||'.SITE_MONITORING_UK1 ON '||vschema||'.SITE_MONITORING (SITE_ID, PLUGIN_ID, MONITORING_TYPE)';
      CREATEOBJECT(vsql,'Unable to create index SITE_MONITORING_UK1','Y');

      vsql := 'create table '||vschema||'.sites_site_ruleset (
                  ruleSetId NUMBER,
                  siteId NUMBER,
                  primary key(ruleSetId, siteId),
                  constraint FK_siteRuleset_Ruleset foreign key (ruleSetId) references '||vschema||'.Tre_RuleSet,
                  constraint FK_siteRuleset_site foreign key (siteId) references '||vschema||'.SITES_SITE
                )';
      CREATEOBJECT(vsql,'Unable to create table sites_site_ruleset','Y');

      --Create Site Indexes
      vsql := 'CREATE INDEX '||vschema||'.site_ruleset_siteid ON '||vschema||'.sites_site_ruleset(siteId)';
      CREATEOBJECT(vsql,'Unable to create index site_ruleset_siteid','Y');     
      
      -- Created a new table SITES_EXPORT_CONF_PARAMS per request from Raj on 08-19-2010
      vsql := 'CREATE TABLE '||vschema||'.SITES_EXPORT_CONF_PARAMS (
                  SITEID NUMBER NOT NULL ,
                  NAME VARCHAR2(255) NOT NULL ,
                  VALUE VARCHAR2(255),
                  CONSTRAINT PK_SITES_EXPORT_CONF_PARAMS PRIMARY KEY (SITEID, NAME),
                  CONSTRAINT FK_SITES_EXPORT_CONF_PARAMS_SI FOREIGN KEY (SITEID) 
                  REFERENCES '||vschema||'.SITES_SITE (ID_))';
      CREATEOBJECT(vsql,'Unable to create table SITES_EXPORT_CONF_PARAMS','Y');

      -- Sanjay added sites_mso and sites_mso_override tables on 01/05/2012.
      vsql := 'CREATE TABLE '||vschema||'.SITES_MSO (
                   MSO_ID     NUMBER PRIMARY KEY,
                   MSO_NAME   VARCHAR2(255) NOT NULL,
                   SITE_ID    NUMBER NOT NULL,
                   CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT FK_SITE_ID FOREIGN KEY (SITE_ID)REFERENCES '||vschema||'.SITES_SITE (ID_)
                  )';
      CREATEOBJECT(VSQL,'Unable to create table SITES_MSO');
      CREATESEQ('SITES_MSO');      
      CREATEUPDATETRG('SITES_MSO');
      
      vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_OVERRIDE (
                   OVERRIDE_ID        NUMBER PRIMARY KEY,
                   MSO_ID             NUMBER NOT NULL,
                   FIELD_XPATH        VARCHAR2(1000) NOT NULL,
                   SEARCH_VALUE       VARCHAR2(1000) NOT NULL,
                   REPLACEMENT_VALUE  VARCHAR2(1000) NOT NULL,
                   CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT FK_MSO_ID FOREIGN KEY (MSO_ID) REFERENCES '||vschema||'.SITES_MSO(MSO_ID)
                   )';
      CREATEOBJECT(VSQL,'Unable to create table SITES_MSO_OVERRIDE');
      CREATESEQ('SITES_MSO_OVERRIDE');
      CREATEUPDATETRG('SITES_MSO_OVERRIDE');

      -- Suneeta Puranik request on 08/28/2012
      vsql := 'CREATE INDEX '||vschema||'.sites_mso_override_xpath_idx ON '||vschema||'.sites_mso_override(field_xpath)';
      CREATEOBJECT(vsql,'Unable to create index sites_mso_override_xpath_idx'); 

      vsql := 'CREATE INDEX '||vschema||'.sites_mso_override_mso_idx ON '||vschema||'.sites_mso_override(mso_id)';
      CREATEOBJECT(vsql,'Unable to create index sites_mso_override_mso_idx');

      vsql := 'CREATE INDEX '||vschema||'.sites_mso_site_idx ON '||vschema||'.sites_mso(site_id)';
      CREATEOBJECT(vsql,'Unable to create index sites_mso_site_idx');
      
      -- Sanjay added SITES_MSO_OVERRIDE_HISTORY table on 01/25/2012.
      vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY (
                   OVERRIDE_HISTORY_ID  NUMBER,
                   SITE_TITLE_ID        NUMBER NOT NULL,
                   TIME_APPLIED         TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL,
                   DISTRIBUTED_VERSION  VARCHAR2(255 CHAR),
                   FIELD_XPATH          VARCHAR2(1000) DEFAULT '''' NOT NULL,
                   SEARCH_VALUE         VARCHAR2(1000) DEFAULT '''',
                   REPLACEMENT_VALUE    VARCHAR2(1000) DEFAULT '''',
                   MSO_ID               NUMBER NOT NULL,
                   MSO_NAME             VARCHAR2(1000),
                   ACTION_NAME          VARCHAR2(255),
                   CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,                   
                   CONSTRAINT PK_SITES_MSO_OVERRIDE_HISTORY PRIMARY KEY(OVERRIDE_HISTORY_ID)
                   )';
      CREATEOBJECT(VSQL,'Unable to create table SITES_MSO_OVERRIDE_HISTORY');
      CREATESEQ('SITES_MSO_OVERRIDE_HISTORY');
      CREATEUPDATETRG('SITES_MSO_OVERRIDE_HISTORY');

      -- Anna Simonenko changes on 03/04/2013.
      vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_MTM (
                    MSO_ID          NUMBER,
                    MSO_NAME        VARCHAR2(255) NOT NULL,
                    MSO_DESCRIPTION VARCHAR2(255),
                    CREATEDATE	    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_SITES_MSO_MTM_ID PRIMARY KEY (MSO_ID))';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.SITES_MSO_MTM.');
      CREATESEQ('SITES_MSO_MTM');
      CREATEUPDATETRG('SITES_MSO_MTM');

      vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_SITE (
                    MSO_ID       NUMBER NOT NULL,
                    SITE_ID      NUMBER NOT NULL,
                    CREATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_SITES_MSO_SITE_MSO_SITE PRIMARY KEY (MSO_ID, SITE_ID),
                    CONSTRAINT FK_SITES_MSO_SITE_MSO_ID FOREIGN KEY (MSO_ID) REFERENCES '||vschema||'.SITES_MSO_MTM (MSO_ID),
                    CONSTRAINT FK_SITES_MSO_SITE_SITE_ID FOREIGN KEY (SITE_ID) REFERENCES '||vschema||'.SITES_SITE (ID_))';
      CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.SITES_MSO_SITE.');
      CREATEUPDATETRG('SITES_MSO_SITE');
          
      -- Daniel Weiner Added a new table tre_ruleset_mso on 03-06-2013, below is the table foreign key constraint
      vsql := 'ALTER TABLE '||vschema||'.tre_ruleset_mso ADD CONSTRAINT fk_rulesetmso_mso FOREIGN KEY (msoid) REFERENCES '||vschema||'.sites_mso_mtm(mso_id)';
      CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.tre_ruleset_mso ADD CONSTRAINT fk_rulesetmso_mso');               

      -- Sanjay request on 11/06/2012
      vsql := 'CREATE INDEX '||vschema||'.sites_mso_or_hist_msoid_idx ON '||vschema||'.SITES_MSO_OVERRIDE_HISTORY(MSO_ID)';
      CREATEOBJECT(vsql,'Unable to create index sites_mso_or_hist_msoid_idx'); 

      vsql := 'CREATE INDEX '||vschema||'.sites_mso_or_hist_tleid_idx ON '||vschema||'.SITES_MSO_OVERRIDE_HISTORY(SITE_TITLE_ID)';
      CREATEOBJECT(vsql,'Unable to create index sites_mso_or_hist_tleid_idx');

      --- Raj altered Distribution and tracking sites tables to flashback archive on 04/18/2013.
      vsql := 'alter table '||vschema||'.SITES_DISTSITETITLE flashback archive';
      CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_DISTSITETITLE flashback archive.'); 

      vsql := 'alter table '||vschema||'.SITES_TRACKSITETITLE flashback archive';
      CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_TRACKSITETITLE flashback archive.');

      -- SITES_DISTRIBUTION_OPTION
      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_OPTION (ID_,NAME) VALUES(0, ''IMMEDIATE'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_OPTION','Y');
      
      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_OPTION (ID_,NAME) VALUES (1,''TIMED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_OPTION','Y');
      
      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_OPTION (ID_, NAME) VALUES (2, ''MANUAL'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_OPTION','Y');

      -- SITES_DISTRIBUTION_STATUS
      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_STATUS (ID_, NAME) VALUES (0, ''TARGETED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_STATUS (ID_, NAME) VALUES (1, ''READY_FOR_DISTRIBUTION'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_STATUS (ID_, NAME) VALUES (2, ''IN_PROGRESS'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_STATUS (ID_, NAME) VALUES (3, ''DISTRIBUTED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_DISTRIBUTION_STATUS (ID_, NAME) VALUES (4, ''FAILED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_DISTRIBUTION_STATUS','Y');

      -- SITES_SITETYPE
      vsql := 'INSERT INTO '||vschema||'.SITES_SITETYPE (ID_, TYPE) VALUES (1, ''LOGICAL'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_SITETYPE','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_SITETYPE (ID_, TYPE) VALUES (2, ''DISTRIBUTION'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_SITETYPE','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_SITETYPE (ID_, TYPE) VALUES (3, ''TRACKING'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_SITETYPE','Y');

      -- Sanjay added Mediapath record to the sites_sitetype table on 01/10/2012.
      vsql := 'INSERT INTO '||vschema||'.SITES_SITETYPE (ID_, TYPE) VALUES (4, ''MEDIAPATH'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_SITETYPE','Y');
      
      -- SITES_TRACKING_STATUS
      vsql := 'INSERT INTO '||vschema||'.SITES_TRACKING_STATUS (ID_, NAME) VALUES (0, ''TARGETED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_TRACKING_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_TRACKING_STATUS (ID_, NAME) VALUES (1, ''DEPLOYMENT_IN_PROGRESS'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_TRACKING_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_TRACKING_STATUS (ID_, NAME) VALUES (2, ''DEPLOYMENT_FAILED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_TRACKING_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_TRACKING_STATUS (ID_, NAME) VALUES (3, ''DEPLOYED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_TRACKING_STATUS','Y');

      vsql := 'INSERT INTO '||vschema||'.SITES_TRACKING_STATUS (ID_, NAME) VALUES (4, ''NOT_DEPLOYED'')';
      CREATEOBJECT(vsql,'Unable to insert SITES_TRACKING_STATUS','Y');

      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CreateSITES completed SUCCESSFULLY'')';

      commit;
    END createSITES;
    
  /***********************************************************************************************
   ----------------------------------------CREATE WP STUDIO------------------------------------------
   *************************************************************************************************/
    PROCEDURE createWPSTUDIO IS
		wk_message	varchar2(500);
		startNum	NUMBER;
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN

      --WP Studio User
      vschema := 'WPTB';	
      vsql := 'drop tablespace TEMPLATEBUILDER_DATA including contents and datafiles';
      CREATEOBJECT(vsql,'Unable to drop tablespace TEMPLATEBUILDER_DATA','Y');

      vsql := 'create tablespace TEMPLATEBUILDER_DATA datafile size 100M autoextend on extent management local autoallocate';
      CREATEOBJECT(vsql,'Unable to create tablespace TEMPLATEBUILDER_DATA');
      
      vsql := 'drop tablespace TEMPLATEBUILDER_INDEX including contents and datafiles';
      CREATEOBJECT(vsql,'Unable to drop tablespace TEMPLATEBUILDER_INDEX','Y');

      vsql := 'create tablespace TEMPLATEBUILDER_INDEX datafile size 100M autoextend on extent management local autoallocate';
      CREATEOBJECT(vsql,'Unable to create tablespace TEMPLATEBUILDER_INDEX');

      vsql := 'drop user wptb cascade';
      CREATEOBJECT(vsql,'Unable to drop user wptb','Y');

      vsql := 'create user WPTB identified by wptb default tablespace TEMPLATEBUILDER_DATA';
      CREATEOBJECT(vsql,'Unable to create user WPTB');

      vsql := 'grant resource,connect to WPTB';
      CREATEOBJECT(vsql,'Unable to grant roles to wptb');

      vsql := 'alter user WPTB quota unlimited on TEMPLATEBUILDER_DATA';
      CREATEOBJECT(vsql,'Unable to alter user WPTB');

      vsql := 'alter user WPTB quota unlimited on TEMPLATEBUILDER_INDEX';
      CREATEOBJECT(vsql,'Unable to alter user WPTB');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_CONNECTIONTYPE(
                         CONNECTIONTYPEID	NUMBER		NOT NULL,
                         NAME			VARCHAR2(50) 	NOT NULL,
                         CREATEDATE     	TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_CONNNECTIONTYPE PRIMARY KEY(CONNECTIONTYPEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_CONNECTIONTYPE');
      CREATEUPDATETRG('TB_CONNECTIONTYPE');
       
      vsql := 'CREATE TABLE '||vschema||'.TB_ADAPTORTYPE(
                         ADAPTORTYPEID	NUMBER		NOT NULL,
                         NAME		VARCHAR2(50)	NOT NULL,
                         CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_ADAPTORTYPE PRIMARY KEY(ADAPTORTYPEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_ADAPTORTYPE');
      CREATEUPDATETRG('TB_ADAPTORTYPE');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_ADAPTORSCOPE(
                         ADAPTORSCOPEID	NUMBER		NOT NULL,
                         NAME		VARCHAR2(50)	NOT NULL,
                         CREATEDATE     TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_ADAPTORSCOPE PRIMARY KEY(ADAPTORSCOPEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_ADAPTORSCOPE');
      CREATEUPDATETRG('TB_ADAPTORSCOPE');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_NODEDEFINITIONTYPE(
                         NODEDEFINITIONTYPEID	NUMBER		NOT NULL,
                         NAME			VARCHAR2(50)	NOT NULL,
                         CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_NODEDEFINITIONTYPE PRIMARY KEY(NODEDEFINITIONTYPEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_NODEDEFINITIONTYPE');
      CREATEUPDATETRG('TB_NODEDEFINITIONTYPE');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_LOCK(
                         LOCKID		NUMBER		NOT NULL,
                         OWNERID	VARCHAR2(4000) 	NOT NULL,
                         LOCKSTARTDATE	DATE		NOT NULL,
                         CREATEDATE     TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_LOCK PRIMARY KEY(LOCKID))';
      CREATEOBJECT(vsql,'Unable to create table TB_LOCK');
      CREATEUPDATETRG('TB_LOCK');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_PROTECTIONKEY(
                         PROTECTIONKEYID	NUMBER		NOT NULL,
                         NAME		        VARCHAR2(50)	NOT NULL,
                         CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_PROTECTIONKEY PRIMARY KEY(PROTECTIONKEYID),
                         CONSTRAINT UK_TB_PROTECTIONKEY UNIQUE(NAME))';
      CREATEOBJECT(vsql,'Unable to create table TB_PROTECTIONKEY');
      CREATEUPDATETRG('TB_PROTECTIONKEY');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_RESOURCETYPE(
                         RESOURCETYPEID			NUMBER 		NOT NULL,
                         SYSTEMID			VARCHAR2(10)	NOT NULL UNIQUE,
                         NAME				VARCHAR2(50)	NOT NULL,
                         DESCRIPTION			VARCHAR2(256)	NULL,
                         CONNECTIONTYPEID		NUMBER		NOT NULL,
                         ADAPTORTYPEID			NUMBER 		NULL,
                         ADAPTORSCOPEID			NUMBER		NULL,
                         REQUIRESINITIALIZATION		NUMBER(1)	NOT NULL CHECK(REQUIRESINITIALIZATION in (0,1)),
                         INITIALIZATIONSTRATEGYCLASS	VARCHAR2(256)	NULL,
                         REQUIRESHEARTBEAT		NUMBER(1)	NOT NULL CHECK(REQUIRESHEARTBEAT in (0,1)),
                         HEARTBEATSTRATEGYCLASS		VARCHAR2(256)	NULL,
                         HEARTBEATCONNECTIONTYPEID	NUMBER		NULL,
                         ADAPTORCLASSNAME		VARCHAR2(256)	NULL,
                         MESSAGEIDENTIFICATIONCLASSNAME	VARCHAR2(256)   NULL,
                         DEFAULTPROTOCOL		VARCHAR2(256)	NULL,
                         VERSION  NUMBER		NOT NULL,
                         ISDIRTY  NUMBER(1)	NOT NULL CHECK(ISDIRTY in (0,1)),
                         MESSAGESEQUENCENUMBER  NUMBER DEFAULT(0) NOT NULL,
                         OUTOFTHEBOX  NUMBER(1) DEFAULT(0) NOT NULL,
                         CREATEDATE TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_RESOURCETYPE PRIMARY KEY(RESOURCETYPEID),
                         CONSTRAINT FK_RESOURCETYPE_CNNTYP FOREIGN KEY (CONNECTIONTYPEID)  REFERENCES '||vschema||'.TB_CONNECTIONTYPE(CONNECTIONTYPEID),
                         CONSTRAINT FK_RESOURCETYPE_ADTTYP FOREIGN KEY (ADAPTORTYPEID) REFERENCES '||vschema||'.TB_ADAPTORTYPE(ADAPTORTYPEID),
                         CONSTRAINT FK_RESOURCETYPE_ADTSCP FOREIGN KEY (ADAPTORSCOPEID) REFERENCES '||vschema||'.TB_ADAPTORTYPE(ADAPTORTYPEID),
                         CONSTRAINT FK_RESOURCETYPE_HBCNNTYP FOREIGN KEY (HEARTBEATCONNECTIONTYPEID) REFERENCES '||vschema||'.TB_CONNECTIONTYPE(CONNECTIONTYPEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_RESOURCETYPE');
      CREATEUPDATETRG('TB_RESOURCETYPE');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_RESOURCEGROUP(
                         RESOURCEGROUPID			NUMBER		NOT NULL,
                         NAME				VARCHAR2(50)	NOT NULL,
                         DESCRIPTION			VARCHAR2(256)	NULL,
                         RESOURCETYPEID			NUMBER		NULL,
                         FUNCTIONALTYPE			VARCHAR2(256)	NULL,
                         ISINTERNALLYACQUIRED		NUMBER(1)	NOT NULL CHECK(ISINTERNALLYACQUIRED IN (0,1)),
                         IMAGE				BLOB		NULL,
                         PROTECTIONKEYID		NUMBER		NULL,
                         VERSION			NUMBER		NOT NULL,
                         ISDIRTY			NUMBER(1)	NOT NULL CHECK(ISDIRTY IN (0,1)),
                         ALLOCATIONSTRATEGYCLASSNAME	VARCHAR2(256)	NULL,
                         IMAGEFILENAME			VARCHAR2(150)	NULL,
                         CREATEDATE     	        TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	        TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_RESOURCEGROUP PRIMARY KEY(RESOURCEGROUPID),
                         CONSTRAINT FK_RESOURCEGROUP_RSRCTYP FOREIGN KEY(RESOURCETYPEID) REFERENCES '||vschema||'.TB_RESOURCETYPE(RESOURCETYPEID),
                         CONSTRAINT FK_RESOURCEGROUP_PRTCKY FOREIGN KEY(PROTECTIONKEYID) REFERENCES '||vschema||'.TB_PROTECTIONKEY(PROTECTIONKEYID))';
      CREATEOBJECT(vsql,'Unable to create table TB_RESOURCEGROUP');
      CREATEUPDATETRG('TB_RESOURCEGROUP');
    
      vsql := 'CREATE TABLE '||vschema||'.TB_MESSAGE(
                         MESSAGEID	NUMBER		NOT NULL,
                         UID_		VARCHAR2(10)	NOT NULL UNIQUE,
                         NAME		VARCHAR2(50)	NOT NULL,
                         DESCRIPTION	VARCHAR2(256)	NULL,
                         RESOURCETYPEID	NUMBER		NULL,
                         ISINCOMMING	NUMBER(1)	NOT NULL CHECK(ISINCOMMING IN (0,1)),
                         PROTOCOL	VARCHAR2(256)	NULL,
                         CREATEDATE    	TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_MESSAGE PRIMARY KEY(MESSAGEID),
                         CONSTRAINT FK_MESSAGE_RSRCTYP FOREIGN KEY(RESOURCETYPEID) REFERENCES '||vschema||'.TB_RESOURCETYPE(RESOURCETYPEID))';        
      CREATEOBJECT(vsql,'Unable to create table TB_MESSAGE');
      CREATEUPDATETRG('TB_MESSAGE');
      
      vsql := 'CREATE TABLE '||vschema||'.TB_NODEDEFINITION(
                         NODEDEFINITIONID	NUMBER		NOT NULL,
                         NAME			VARCHAR2(50)	NOT NULL,
                         NODEDEFINITIONTYPEID	NUMBER		NOT NULL,
                         RESOURCETYPEID		NUMBER		NULL,
                         XML			CLOB		NULL,
                         GPDXML			CLOB		NULL,
                         LOCKID		        NUMBER		NULL,
                         CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_NODEDEFINITION PRIMARY KEY(NODEDEFINITIONID),
                         CONSTRAINT FK_NODEDEFINITION_NDDEFTYP FOREIGN KEY(NODEDEFINITIONTYPEID) REFERENCES '||vschema||'.TB_NODEDEFINITIONTYPE(NODEDEFINITIONTYPEID),
                         CONSTRAINT FK_NODEDEFINITION_RSRCTYP FOREIGN KEY(RESOURCETYPEID) REFERENCES '||vschema||'.TB_RESOURCETYPE(RESOURCETYPEID),
                         CONSTRAINT FK_NODEDEFINITION_LCK FOREIGN KEY(LOCKID) REFERENCES WPTB.TB_LOCK(LOCKID))';
      CREATEOBJECT(vsql,'Unable to create table TB_NODEDEFINITION');
      CREATEUPDATETRG('TB_NODEDEFINITION');
        
      vsql := 'CREATE TABLE '||vschema||'.TB_MESSAGENODEDEFINITIONMAP(
                         MESSAGEID		NUMBER	NOT NULL,
                         NODEDEFINITIONID	NUMBER 	NOT NULL,
                         CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_MESSAGENODEDEFINITIONMAP PRIMARY KEY(MESSAGEID, NODEDEFINITIONID),
                         CONSTRAINT FK_MSGNDDEFMP_MSG FOREIGN KEY(MESSAGEID) REFERENCES '||vschema||'.TB_MESSAGE(MESSAGEID),
                         CONSTRAINT FK_MSGNDDEFMP_NDDEF FOREIGN KEY(NODEDEFINITIONID) REFERENCES '||vschema||'.TB_NODEDEFINITION(NODEDEFINITIONID))';
      CREATEOBJECT(vsql,'Unable to create table TB_MESSAGENODEDEFINITIONMAP');
      CREATEUPDATETRG('TB_MESSAGENODEDEFINITIONMAP');

      vsql := 'CREATE TABLE '||vschema||'.TB_RESOURCETYPEPARAMETER(
                         RESOURCETYPEPARAMETERID NUMBER		NOT NULL,
                         RESOURCETYPEID		NUMBER		NOT NULL,
                         PARAMETERCLASS		VARCHAR2(50)	NOT NULL,
                         PARAMETERNAME		VARCHAR2(50)	NOT NULL,
                         VALUE			VARCHAR2(256)	NOT NULL,
                         CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_RESOURCETYPEPARAMETER PRIMARY KEY(RESOURCETYPEPARAMETERID),
                         CONSTRAINT FK_RSRCTYPPRMTR_RSRCTYP FOREIGN KEY(RESOURCETYPEID) REFERENCES '||vschema||'.TB_RESOURCETYPE(RESOURCETYPEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_RESOURCETYPEPARAMETER');
      CREATESEQ('TB_RESOURCETYPEPARAMETER');
      CREATEUPDATETRG('TB_RESOURCETYPEPARAMETER');

      vsql := 'CREATE UNIQUE INDEX '||vschema||'.IDX_TB_RSRCTYPPRMTR_UK ON '||vschema||'.TB_RESOURCETYPEPARAMETER(RESOURCETYPEID, PARAMETERCLASS, PARAMETERNAME)';
      CREATEOBJECT(vsql,'Unable to create index IDX_TB_RSRCTYPPRMTR_UK');

      vsql := 'CREATE TABLE '||vschema||'.TB_TEMPLATE(
                         TEMPLATEID		NUMBER		NOT NULL,
                         NAME			VARCHAR2(50)	NOT NULL,
                         VERSION		NUMBER		NOT NULL,
                         XML			CLOB		NULL,
                         GPDXML			CLOB		NULL,
                         ISDIRTY		NUMBER(1)	NOT NULL CHECK(ISDIRTY IN (0,1)),
                         ISEXPORTABLE	        NUMBER(1)	NOT NULL CHECK(ISEXPORTABLE IN (0,1)),
                         LOCKID			NUMBER		NULL,
                         ISACTIVE		NUMBER(1)	DEFAULT(1) NOT NULL CHECK(ISACTIVE IN (0,1)),
                         CREATEDATE     	TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6)    DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_TEMPLATE PRIMARY KEY(TEMPLATEID),
                         CONSTRAINT FK_TEMPLATE_LOCK FOREIGN KEY(LOCKID) REFERENCES '||vschema||'.TB_LOCK(LOCKID))';
      CREATEOBJECT(vsql,'Unable to create table TB_TEMPLATE');
      CREATEUPDATETRG('TB_TEMPLATE');

      vsql := 'CREATE TABLE '||vschema||'.TB_TEMPLATEPROTECTIONKEYMAP(
                         PROTECTIONKEYID	NUMBER	      NOT NULL,
                         TEMPLATEID	        NUMBER 	      NOT NULL,
                         CREATEDATE     	TIMESTAMP(6)  DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6)  DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_TEMPLATEPROTECTIONKEYMAP PRIMARY KEY(PROTECTIONKEYID, TEMPLATEID),
                         CONSTRAINT FK_TMPPRTCKYMP_PRTCKY FOREIGN KEY(PROTECTIONKEYID) REFERENCES '||vschema||'.TB_PROTECTIONKEY(PROTECTIONKEYID),
                         CONSTRAINT FK_TMPPRTCKYMP_TMP FOREIGN KEY(TEMPLATEID) REFERENCES '||vschema||'.TB_TEMPLATE(TEMPLATEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_TEMPLATEPROTECTIONKEYMAP');
      CREATEUPDATETRG('TB_TEMPLATEPROTECTIONKEYMAP');

      vsql := 'CREATE TABLE '||vschema||'.TB_RESOURCEGROUPTEMPLATEMAP(
                         RESOURCEGROUPID    NUMBER	  NOT NULL,
                         TEMPLATEID	    NUMBER 	  NOT NULL,
                         CREATEDATE         TIMESTAMP(6)  DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE         TIMESTAMP(6)  DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_RESOURCEGROUPTEMPLATEMAP PRIMARY KEY(RESOURCEGROUPID, TEMPLATEID),
                         CONSTRAINT FK_RSRCGPTMPMP_RSRCGP FOREIGN KEY(RESOURCEGROUPID) REFERENCES '||vschema||'.TB_RESOURCEGROUP(RESOURCEGROUPID),
                         CONSTRAINT FK_RSRCGPTMPMP_TMP FOREIGN KEY(TEMPLATEID) REFERENCES '||vschema||'.TB_TEMPLATE(TEMPLATEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_RESOURCEGROUPTEMPLATEMAP');
      CREATEUPDATETRG('TB_RESOURCEGROUPTEMPLATEMAP');

      vsql := 'CREATE TABLE '||vschema||'.TB_NODEDEFINITIONTEMPLATEMAP(
                         NODEDEFINITIONID	NUMBER	NOT NULL,
                         TEMPLATEID		NUMBER 	NOT NULL,
                         CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_NDDFNTNTMPLTMP PRIMARY KEY(NODEDEFINITIONID, TEMPLATEID),
                         CONSTRAINT FK_NDDEFTMPMP_NDDEF FOREIGN KEY(NODEDEFINITIONID) REFERENCES '||vschema||'.TB_NODEDEFINITION(NODEDEFINITIONID),
                         CONSTRAINT FK_NDDEFTMPMP_TMP FOREIGN KEY(TEMPLATEID) REFERENCES '||vschema||'.TB_TEMPLATE(TEMPLATEID))';
      CREATEOBJECT(vsql,'Unable to create table TB_NODEDEFINITIONTEMPLATEMAP');
      CREATEUPDATETRG('TB_NODEDEFINITIONTEMPLATEMAP');

      vsql := 'CREATE TABLE '||vschema||'.TB_NODEDEFINITIONPARENTMAP(
                         NODEDEFINITIONID	NUMBER 	      NOT NULL,
                         NODEDEFINITIONPARENTID	NUMBER 	      NOT NULL,
                         CREATEDATE     	TIMESTAMP(6)  DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE     	TIMESTAMP(6)  DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT PK_TB_NODEDEFINITIONPARENTMAP PRIMARY KEY(NODEDEFINITIONID, NODEDEFINITIONPARENTID),
                         CONSTRAINT FK_NODEDEFINITIONPARENT_CHILD FOREIGN KEY(NODEDEFINITIONID) REFERENCES '||vschema||'.TB_NODEDEFINITION(NODEDEFINITIONID),
                         CONSTRAINT FK_NODEDEFINITIONPARENT_PARENT FOREIGN KEY(NODEDEFINITIONPARENTID) REFERENCES '||vschema||'.TB_NODEDEFINITION(NODEDEFINITIONID))';
      CREATEOBJECT(vsql,'Unable to insert into Tre_Event');
      CREATEUPDATETRG('TB_NODEDEFINITIONPARENTMAP');
      


      vsql := 'INSERT INTO '||vschema||'.TB_CONNECTIONTYPE (CONNECTIONTYPEID, NAME) VALUES(0,''URL'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_CONNECTIONTYPE');

      vsql := 'INSERT INTO '||vschema||'.TB_CONNECTIONTYPE (CONNECTIONTYPEID, NAME) VALUES(1,''IP/Port'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_CONNECTIONTYPE');

      vsql := 'INSERT INTO '||vschema||'.TB_CONNECTIONTYPE (CONNECTIONTYPEID, NAME) VALUES(2,''Email'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_CONNECTIONTYPE');

      vsql := 'INSERT INTO '||vschema||'.TB_ADAPTORTYPE (ADAPTORTYPEID, NAME) VALUES(0, ''NONE'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_ADAPTORTYPE');
      
      vsql := 'INSERT INTO '||vschema||'.TB_ADAPTORTYPE (ADAPTORTYPEID, NAME) VALUES(1, ''DEFAULT'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_ADAPTORTYPE');

      vsql := 'INSERT INTO '||vschema||'.TB_ADAPTORTYPE (ADAPTORTYPEID, NAME) VALUES(2, ''CUSTOM'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_ADAPTORTYPE');

      vsql := 'INSERT INTO '||vschema||'.TB_ADAPTORSCOPE (ADAPTORSCOPEID, NAME) VALUES(0, ''APPLICATION'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_ADAPTORSCOPE');

      vsql := 'INSERT INTO '||vschema||'.TB_ADAPTORSCOPE (ADAPTORSCOPEID, NAME) VALUES(1, ''MESSAGE'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_ADAPTORSCOPE');

      vsql := 'INSERT INTO '||vschema||'.TB_NODEDEFINITIONTYPE(NODEDEFINITIONTYPEID, NAME)  VALUES(0, ''SINGLENODE'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_NODEDEFINITIONTYPE');

      vsql := 'INSERT INTO '||vschema||'.TB_NODEDEFINITIONTYPE(NODEDEFINITIONTYPEID, NAME) VALUES(1, ''SUPERSTATE'')';
      CREATEOBJECT(vsql,'Unable to insert into TB_NODEDEFINITIONTYPE');

      EXECUTE IMMEDIATE 'SELECT  CASE WHEN MAX(RESOURCETYPEID) IS NULL  THEN 1 ELSE MAX(RESOURCETYPEID)+ 1 END FROM	'||vschema||'.TB_RESOURCETYPE' INTO startNum;
    
  	  vsql := 'CREATE SEQUENCE '||vschema||'.TB_RESOURCETYPE_SEQ INCREMENT BY 1 START WITH '||startNum;
      CREATEOBJECT(vsql,'Unable to create seq TB_RESOURCETYPE_SEQ');
      
      EXECUTE IMMEDIATE 'SELECT  CASE WHEN MAX(MESSAGEID) IS NULL  THEN 1 ELSE MAX(MESSAGEID)+ 1 END FROM	'||vschema||'.TB_MESSAGE' INTO startNum;
  
      vsql := 'CREATE SEQUENCE '||vschema||'.TB_MESSAGE_SEQ INCREMENT BY 1 START WITH '||startNum;
      CREATEOBJECT(vsql,'Unable to create seq TB_MESSAGE_SEQ');
      
    	EXECUTE IMMEDIATE 'SELECT  CASE WHEN MAX(NODEDEFINITIONID) IS NULL  THEN 1 ELSE MAX(NODEDEFINITIONID)+ 1 END FROM	'||vschema||'.TB_NODEDEFINITION' INTO startNum;
  
      vsql := 'CREATE SEQUENCE '||vschema||'.TB_NODEDEFINITION_SEQ INCREMENT BY 1 START WITH '||startNum; 
      CREATEOBJECT(vsql,'Unable to create seq TB_NODEDEFINITION_SEQ');
      
      vsql := 'CREATE SEQUENCE '||vschema||'.TB_LOCK_SEQ INCREMENT BY 1 START WITH 1';
      CREATEOBJECT(vsql,'Unable to create seq TB_LOCK_SEQ');
  
      vsql := 'CREATE SEQUENCE '||vschema||'.TB_TEMPLATE_SEQ INCREMENT BY 1 START WITH 1';
      CREATEOBJECT(vsql,'Unable to create seq TB_TEMPLATE_SEQ');
                        
      vsql := 'CREATE SEQUENCE '||vschema||'.TB_PROTECTIONKEY_SEQ INCREMENT BY 1 START WITH 1';
      CREATEOBJECT(vsql,'Unable to create seq TB_PROTECTIONKEY_SEQ');
                        
      vsql := 'CREATE SEQUENCE '||vschema||'.TB_RESOURCEGROUP_SEQ INCREMENT BY 1 START WITH 1';
      CREATEOBJECT(vsql,'Unable to create seq TB_PROTECTIONKEY_SEQ');


      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CreateWPStudio completed SUCCESSFULLY'')';

      commit;
    END createWPSTUDIO;
    
    /***********************************************************************************************
   ----------------------------------------CREATE JOB SCHEDULE------------------------------------------
   *************************************************************************************************/
    PROCEDURE CreateJobSchedule IS
		wk_message	varchar2(500);
		startNum	NUMBER;
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN

      --Job Schedule User
      vschema := 'WFS';	

      -- Raj created Job Schedule tables on 02/11/2011
      vsql := 'CREATE TABLE '||vschema||'.SCH_RULETYPE(
                      ID          NUMBER NOT NULL,
                      TYPE        VARCHAR2(50) NOT NULL,
                      CONSTRAINT PK_SCH_RULETYPE PRIMARY KEY (ID))';
      CREATEOBJECT(vsql,'Unable to create table SCH_RULETYPE');

      vsql := 'INSERT INTO '||vschema||'.SCH_RULETYPE (ID, TYPE) VALUES(0,''ON_DATE'')';
      CREATEOBJECT(vsql,'Unable to insert into SCH_RULETYPE');
      
      vsql := 'INSERT INTO '||vschema||'.SCH_RULETYPE (ID, TYPE) VALUES(1,''EVERY_N_DAYS'')';
      CREATEOBJECT(vsql,'Unable to insert into SCH_RULETYPE');
      
      vsql := 'INSERT INTO '||vschema||'.SCH_RULETYPE (ID, TYPE) VALUES(2,''ON_DAY_EVERY_N_WEEKS'')';
      CREATEOBJECT(vsql,'Unable to insert into SCH_RULETYPE');
      
      vsql := 'INSERT INTO '||vschema||'.SCH_RULETYPE (ID, TYPE) VALUES(3,''N_DAYS_FROM_METADATA'')';
      CREATEOBJECT(vsql,'Unable to insert into SCH_RULETYPE');      
      
      vsql := 'CREATE TABLE '||vschema||'.SCH_RULE(
                      ID_         NUMBER NOT NULL,
                      RULETYPEID  NUMBER NOT NULL,
                      STARTDATE   TIMESTAMP,
                      ENDDATE     TIMESTAMP,
                      CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_SCH_RULE PRIMARY KEY (ID_),
                      CONSTRAINT FK_SCH_RULE_SCH_RULETYPE FOREIGN KEY (RULETYPEID) REFERENCES '||vschema||'.SCH_RULETYPE (ID))';
      CREATEOBJECT(vsql,'Unable to create table SCH_RULE');
      CREATESEQ('SCH_RULE');
      CREATEUPDATETRG('SCH_RULE');                         

      vsql := 'CREATE TABLE '||vschema||'.SCH_RULEPARAMETER(
                      ID_         NUMBER NOT NULL,
                      RULEID      NUMBER NOT NULL,
                      VALUE       VARCHAR2(1000 CHAR) NOT NULL,
                      ORDER_      NUMBER NOT NULL,
                      CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_SCH_RULEPARAMETER PRIMARY KEY (ID_),
                      CONSTRAINT FK_SCH_RULEPARAMETER_SCH_RULE FOREIGN KEY (RULEID) REFERENCES '||vschema||'.SCH_RULE (ID_))';
      CREATEOBJECT(vsql,'Unable to create table SCH_RULEPARAMETER');
      CREATESEQ('SCH_RULEPARAMETER');
      CREATEUPDATETRG('SCH_RULEPARAMETER');  

      vsql := 'CREATE TABLE '||vschema||'.SCH_JOB(
                      ID                      NUMBER NOT NULL,
                      NAME                    VARCHAR2(300 CHAR),
                      RULEID                  NUMBER,
                      ASSOCIATED_ENTITY_TYPE  VARCHAR2(255),
                      ASSOCIATION_DESCRIPTION VARCHAR2(2000),
                      CALLBACK_CLASS          VARCHAR2(1000),
                      ACTIVE                  NUMBER(1) DEFAULT 0 NOT NULL,
                      CREATEDATE TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_SCH_JOB PRIMARY KEY (ID),
                      CONSTRAINT FK_SCH_JOB_RULEID FOREIGN KEY (RULEID) REFERENCES '||vschema||'.SCH_RULE (ID_))';
      CREATEOBJECT(vsql,'Unable to create table SCH_JOB');
      CREATESEQ('SCH_JOB');
      CREATEUPDATETRG('SCH_JOB');
      
      vsql := 'CREATE TABLE '||vschema||'.SCH_ASSOCIATED_ENTITIES(
                      JOB_ID      NUMBER NOT NULL,
                      ENTITY_ID   NUMBER NOT NULL,
                      CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_SCH_ASSOCIATED_ENTITIES PRIMARY KEY (ENTITY_ID, JOB_ID),
                      CONSTRAINT FK_SCH_ASSOCIATED_ENTITS_JOBID FOREIGN KEY (JOB_ID) REFERENCES '||vschema||'.SCH_JOB (ID))';
      CREATEOBJECT(vsql,'Unable to create table SCH_ASSOCIATED_ENTITIES');
      CREATEUPDATETRG('SCH_ASSOCIATED_ENTITIES');      

      vsql := 'CREATE TABLE '||vschema||'.SCH_WOJOB (
                      ID           NUMBER NOT NULL,
                      JOBID        NUMBER NOT NULL,
                      TEMPLATENAME VARCHAR2(255) NOT NULL,
                      PRIORITY     VARCHAR2(50) NOT NULL,
                      CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,                      
                      CONSTRAINT PK_SCJ_WOJOB PRIMARY KEY (ID),
                      CONSTRAINT FK_SCH_WOJOB_SCH_JOB FOREIGN KEY (JOBID) REFERENCES '||vschema||'.SCH_JOB (ID))';
      CREATEOBJECT(vsql,'Unable to create table SCH_WOJOB');
      CREATESEQ('SCH_WOJOB');
      CREATEUPDATETRG('SCH_WOJOB');
      
      vsql := 'CREATE TABLE '||vschema||'.SCH_WOJOB_MAPPARAMS (
                      WOJOBID NUMBER NOT NULL ,
                      NAME    VARCHAR2(1000) NOT NULL ,
                      VALUE   VARCHAR2(1000),
                      CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL, 
                      CONSTRAINT PK_SCH_WOJOB_MAPPARAMS PRIMARY KEY (WOJOBID, NAME),
                      CONSTRAINT FK_SCH_WOJOB_MAPPARAMS_SCJ_W FOREIGN KEY (WOJOBID) REFERENCES '||vschema||'.SCH_WOJOB (ID))';
      CREATEOBJECT(vsql,'Unable to create table SCH_WOJOB_MAPPARAMS');
      CREATEUPDATETRG('SCH_WOJOB_MAPPARAMS');

      -- Suneeta Puranik request on 08/29/2012
      vsql := 'CREATE INDEX '||vschema||'.sch_ruleparameter_value_idx ON '||vschema||'.sch_ruleparameter(value)';
      CREATEOBJECT(vsql,'Unable to create index sch_ruleparameter_value_idx'); 

      vsql := 'CREATE INDEX '||vschema||'.sch_wojob_job_idx ON '||vschema||'.sch_wojob(jobid)';
      CREATEOBJECT(vsql,'Unable to create index sch_wojob_job_idx');
      
      -- Raj added a new table SCH_PASTEXECUTION on 03/24/2011
      vsql := 'CREATE TABLE '||VSCHEMA||'.SCH_PASTEXECUTION  (
                      id             NUMBER NOT NULL,
                      job_id         NUMBER NOT NULL,
                      execution_time TIMESTAMP NOT NULL,
                      enabled        number(1,0) not null,
                      stale          number(1,0) default 0 not null,
                      ORIG_EXECUTION_TIME TIMESTAMP,
                      FINISHED  NUMBER(1,0),
                      createdate  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      updatedate  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT sch_history_pk PRIMARY KEY (id),
                      CONSTRAINT fk_sch_history_sch_job FOREIGN KEY (job_id) REFERENCES '||VSCHEMA||'.sch_job (ID))';
      CREATEOBJECT(vsql,'Unable to create table sch_pastexecution');
      CREATESEQ('SCH_PASTEXECUTION');
      CREATEUPDATETRG('SCH_PASTEXECUTION');
      
         
      VSQL := 'CREATE TABLE '||VSCHEMA||'.SCH_PASTEXECUTIONDATA (
                  PASTEXEC_ID   NUMBER    NOT NULL,
                  NAME          VARCHAR2(255) NOT NULL,
                  VALUE         BLOB,
                  CONSTRAINT SCH_PASTEXEDATA_PK PRIMARY KEY (PASTEXEC_ID,NAME),
                  CONSTRAINT SCH_PASTEXEDATA_FK1 FOREIGN KEY (PASTEXEC_ID) REFERENCES '||vschema||'.SCH_PASTEXECUTION(ID))';
      CREATEOBJECT(vsql,'Unable to create table SCH_PASTEXECUTIONDATA');      

      -- Sanjay added a new table SCH_JOB_DISABLED_TIMES on 03/30/2011
      vsql := 'CREATE TABLE '||VSCHEMA||'.SCH_JOB_DISABLED_TIMES (
                      JOB_ID        NUMBER NOT NULL,
                      DISABLED_TIME NUMBER NOT NULL,
                      CREATEDATE    TIMESTAMP (6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE    TIMESTAMP (6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_SCH_JOB_DISABLED_TIMES PRIMARY KEY (JOB_ID, DISABLED_TIME),
                      CONSTRAINT FK_SCH_JOB_DISABLED_SCH_JOB FOREIGN KEY (JOB_ID) REFERENCES '||VSCHEMA||'.SCH_JOB(ID))';
      CREATEOBJECT(vsql,'Unable to create table SCH_JOB_DISABLED_TIMES');
      CREATEUPDATETRG('SCH_JOB_DISABLED_TIMES');
      
      vsql := 'CREATE INDEX '||vschema||'.SCH_JOB_ENTITY_TYPE_IND ON '||vschema||'.SCH_JOB(ASSOCIATED_ENTITY_TYPE)';
      CREATEOBJECT(vsql,'Unable to create index SCH_JOB_ENTITY_TYPE_IND');
      
      vsql := 'CREATE INDEX '||vschema||'.SCH_RULEPARAMETER_RULEID_IND ON '||vschema||'.SCH_RULEPARAMETER(RULEID)';
      CREATEOBJECT(vsql,'Unable to create index SCH_RULEPARAMETER_RULEID_IND');   
      
      VSQL := 'CREATE INDEX '||VSCHEMA||'.SCH_PASTEXECUTION_TIME_IND ON '||VSCHEMA||'.SCH_PASTEXECUTION(EXECUTION_TIME)';
      CREATEOBJECT(vsql,'Unable to create index SCH_PASTEXECUTION_TIME_IND');
      
      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CreateJobSchedule completed SUCCESSFULLY'')';

      COMMIT;
    END CreateJobSchedule;
  /*------------------------------------------------------------------
  Create CAT Tables
  ------------------------------------------------------------------*/
    PROCEDURE CreateCAT IS
      wk_message	varchar2(500);
      startNum	NUMBER;
      err_msg		varchar2(500);
      vsql      varchar2(32767);
    BEGIN

      --Category Manager User
      vschema := 'WFS';	
      -- Stephen Zack added Category Manager tables on 12/07/2011.
      -- Anuj Jain request to change ASSOCIATED_CATEGORY_PACKAGE from VARCHAR2 to NUMBER 0n 01/23/2012.
      vsql := 'CREATE TABLE '||vschema||'.CAT_CATEGORY (
                    ID                 NUMBER,    
                    PARENT_CATEGORY_ID NUMBER,    
                    NAME               VARCHAR2(1024 CHAR) NOT NULL,    
                    ASSOCIATED_CATEGORY_PACKAGE NUMBER,  
                    UPDATED_BY         VARCHAR2(100 CHAR),
                    CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    INTERNAL_VERSION NUMBER DEFAULT 0 NOT NULL,
                    CONSTRAINT CAT_CATEGORY_PK PRIMARY KEY (ID),    
                    CONSTRAINT CAT_CATEGORY_UK1 UNIQUE (PARENT_CATEGORY_ID, NAME),    
                    CONSTRAINT CAT_CATEGORY_CAT_CATEGORY_FK1 FOREIGN KEY (PARENT_CATEGORY_ID) REFERENCES '||vschema||'.CAT_CATEGORY (ID))';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CAT_CATEGORY.');
      CREATESEQ('CAT_CATEGORY');
      CREATEUPDATETRG('CAT_CATEGORY');

      vsql := 'INSERT INTO '||vschema||'.cat_category (id, parent_category_id, name, associated_category_package, internal_version) VALUES (0,0,''Categories'',null,''0'')';
      CREATEOBJECT(vsql,'Unable to INSERT RECORD INTO '||vschema||'.cat_category .');
      
      vsql := 'CREATE TABLE '||vschema||'.CAT_FIELD_DATA_TYPES (    
                    DATA_TYPE VARCHAR2(20 CHAR),    
                    CONSTRAINT CAT_FIELD_DATA_TYPES_PK PRIMARY KEY (DATA_TYPE))';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.CAT_FIELD_DATA_TYPES.');

      vsql := 'CREATE TABLE '||vschema||'.CAT_FIELD_DISPLAY_TYPES (    
                    DISPLAY_TYPE VARCHAR2(10 CHAR),    
                    CONSTRAINT CAT_FIELD_DISPLAY_TYPES_PK PRIMARY KEY (DISPLAY_TYPE))';
      CREATEOBJECT(vsql,'Unable to create table CAT_FIELD_DISPLAY_TYPES.');

      vsql := 'CREATE TABLE '||vschema||'.CAT_FIELD_SCHEMA (    
                    ID               NUMBER,    
                    PARENT_FIELD_ID  NUMBER DEFAULT 0 NOT NULL,    
                    NAME             VARCHAR2(256 CHAR) NOT NULL,    
                    FIELD_TYPE       VARCHAR2(256 CHAR) NOT NULL,    
                    MIN_OCC          NUMBER DEFAULT 0 NOT NULL,    
                    MAX_OCC          NUMBER DEFAULT 0 NOT NULL,    
                    DATA_TYPE        VARCHAR2(20 CHAR) NOT NULL,    
                    DISPLAY_TYPE     VARCHAR2(20 CHAR),    
                    REQUIRED_CREATE  CHAR(1),    
                    REQUIRED_EXPORT  CHAR(1),    
                    IS_ENABLED       CHAR(1) DEFAULT ''T'',    
                    VALIDATION_REGEX VARCHAR2(1024 CHAR),    
                    IS_UNIQUE        CHAR(1) DEFAULT ''F'' NOT NULL,    
                    MIN_LEN          NUMBER,    
                    MAX_LEN          NUMBER,
                    DISPLAY_ORDER    NUMBER,   -- Steve request for adding this column on 01/10/2012.
                    UPDATED_BY       VARCHAR2(100),
                    CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT CAT_FIELD_SCHEMA_PK PRIMARY KEY (ID),    
                    CONSTRAINT CAT_FIELD_SCHEMA_UK1 UNIQUE (PARENT_FIELD_ID, NAME),    
                    CONSTRAINT CAT_FIELD_SCHEMA_CAT_FIEL_FK1 FOREIGN KEY (PARENT_FIELD_ID) REFERENCES '||vschema||'.CAT_FIELD_SCHEMA (ID),
                    CONSTRAINT CAT_FIELD_SCHEMA_DATA_TYPE_FK1 FOREIGN KEY (DATA_TYPE) REFERENCES '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE),
                    CONSTRAINT CAT_FIELD_SCHEMA_DISP_TYPE_FK1 FOREIGN KEY (DISPLAY_TYPE) REFERENCES '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE))';
      CREATEOBJECT(vsql,'Unable to create table CAT_FIELD_SCHEMA.');
      CREATESEQ(vtabname=>'CAT_FIELD_SCHEMA', vstartwith=>12);
      CREATEUPDATETRG('CAT_FIELD_SCHEMA');

      vsql := 'CREATE TABLE '||vschema||'.CAT_CATEGORY_METADATA (    
                    ID           NUMBER,    
                    CATEGORY_ID  NUMBER NOT NULL,    
                    FIELD_ID     NUMBER NOT NULL,    
                    STRING_VALUE VARCHAR2(1024 CHAR),    
                    NUMBER_VALUE NUMBER,    
                    DATE_VALUE   TIMESTAMP WITH TIME ZONE,    
                    IMAGE_VALUE  BLOB,    
                    OCC_NUM      NUMBER,    
                    CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT CAT_CATEGORY_METADATA_PK PRIMARY KEY (ID),     
                    CONSTRAINT CAT_CATEGORY_METADATA_UK1 UNIQUE (CATEGORY_ID, FIELD_ID, OCC_NUM),    
                    CONSTRAINT CAT_CATEGORY_METADATA_CAT_FK1 FOREIGN KEY (CATEGORY_ID) REFERENCES '||vschema||'.CAT_CATEGORY (ID),    
                    CONSTRAINT CAT_CATEGORY_METADATA_CAT_FK2 FOREIGN KEY (FIELD_ID) REFERENCES '||vschema||'.CAT_FIELD_SCHEMA (ID))
                    LOB(IMAGE_VALUE) STORE AS SECUREFILE';
      CREATEOBJECT(vsql,'Unable to create table CAT_CATEGORY_METADATA.');
      CREATESEQ('CAT_CATEGORY_METADATA');
      CREATEUPDATETRG('CAT_CATEGORY_METADATA');

      vsql := 'CREATE TABLE '||vschema||'.CAT_FIELD_DEFAULTS (    
                    ID           NUMBER,    
                    FIELD_ID     NUMBER NOT NULL,    
                    IS_DEFAULT   CHAR(1),    
                    KEY_VALUE    VARCHAR2(100 CHAR),    
                    STRING_VALUE VARCHAR2(256 CHAR),    
                    NUMBER_VALUE NUMBER,    
                    DATE_VALUE   TIMESTAMP WITH TIME ZONE,    
                    IMAGE_VALUE BLOB,    
                    CREATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT CAT_FIELD_DEFAULTS_PK PRIMARY KEY (ID),    
                    CONSTRAINT CAT_FIELD_DEFAULTS_CAT_FI_FK1 FOREIGN KEY (FIELD_ID) REFERENCES '||vschema||'.CAT_FIELD_SCHEMA (ID))';
      CREATEOBJECT(vsql,'Unable to create table CAT_FIELD_DEFAULTS.');
      CREATESEQ('CAT_FIELD_DEFAULTS');
      CREATEUPDATETRG('CAT_FIELD_DEFAULTS');

      vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VW_CAT_CATEGORY_PATHS AS
                    SELECT name, 
                           id, 
                           parent_category_id, 
                           substr(sys_connect_by_path(name,''/''),2, LENGTH(sys_connect_by_path(name,''/'')))  path, 
                           createdate, 
                           associated_category_package
                      FROM '||vschema||'.CAT_CATEGORY 
                START WITH id > 0 and parent_category_id = 0
                CONNECT BY NOCYCLE PRIOR id = parent_category_id';
      CREATEOBJECT(VSQL,'Unable to create view VW_CAT_CATEGORY_PATHS.');

      BEGIN
      -- INSERTING into CAT_FIELD_DATA_TYPES
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''Boolean'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''DateTimeZone'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''Decimal'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''Image'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''Integer'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''Number Choice'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''Set'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''String'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DATA_TYPES (DATA_TYPE) values (''String Choice'')';
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          err_msg    :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'Insert into install_table(install_message) values (''error in inserting CAT_FIELD_DATA_TYPES data :'')';
          EXECUTE IMMEDIATE 'Insert into install_table(install_message) values ('''||err_msg||''')';
          GOTO bypass_install;
      END;

      BEGIN
      -- INSERTING into CAT_FIELD_DISPLAY_TYPES
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''CheckBox'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''ComboBox'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''Hyperlink'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''Image'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''Section'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''Table'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''Text'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''TextArea'')';
        EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_DISPLAY_TYPES (DISPLAY_TYPE) values (''DatePicker'')';
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          err_msg    :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'Insert into install_table(install_message) values (''error in inserting CAT_FIELD_DISPLAY_TYPES data :'')';
          EXECUTE IMMEDIATE 'Insert into install_table(install_message) values ('''||err_msg||''')';
          GOTO bypass_install;
      END;

      BEGIN
       -- INSERTING INTO CAT_FIELD_SCHEMA
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (0,0,''Category Metadata'',''Standard'',1,1,''Set'',''Section'',''T'',''T'',''T'',null,''F'',null,null,0)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (1,0,''Standard Fields'',''Standard'',1,1,''Set'',''Section'',''T'',''T'',''T'',null,''F'',null,null,1)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (2,1,''Locale Names'',''Standard'',1,1,''Set'',''Table'',''T'',''T'',''T'',null,''F'',null,null,1)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (3,2,''Locale'',''Standard'',1,0,''String'',''Text'',''T'',''T'',''T'',''^.+$'',''T'',null,null,1)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (4,2,''Name'',''Standard'',1,0,''String'',''Text'',''T'',''T'',''T'',''^[^/]+$'',''F'',null,null,2)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (5,1,''Alternate ID'',''Standard'',0,0,''String'',''Text'',''F'',''F'',''T'',''^.+$'',''T'',null,null,2)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (6,1,''Provider QA Contact'',''Standard'',0,1,''String'',''TextArea'',''F'',''F'',''T'',''^.+$'',''T'',null,null,3)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (7,1,''URL Id'',''Standard'',1,1,''String'',''Text'',''F'',''F'',''T'',''^.+$'',''T'',null,null,4)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (8,1,''Provider Version'',''Standard'',0,1,''Integer'',''Text'',''F'',''F'',''T'',''^[0-9]+$'',''T'',null,null,5)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (9,1,''Start Date'',''Standard'',0,1,''DateTimeZone'',''DatePicker'',''F'',''F'',''T'',''yyyy-MM-dd'',''T'',null,null,6)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) values (10,1,''End Date'',''Standard'',0,1,''DateTimeZone'',''DatePicker'',''F'',''F'',''T'',''yyyy-MM-dd'',''T'',null,null,7)';
          EXECUTE IMMEDIATE 'Insert into '||vschema||'.CAT_FIELD_SCHEMA (ID,PARENT_FIELD_ID,NAME,FIELD_TYPE,MIN_OCC,MAX_OCC,DATA_TYPE,DISPLAY_TYPE,REQUIRED_CREATE,REQUIRED_EXPORT,IS_ENABLED,VALIDATION_REGEX,IS_UNIQUE,MIN_LEN,MAX_LEN,DISPLAY_ORDER) VALUES (11,0,''Custom Fields'',''Custom'',1,0,''Set'',''Section'',''T'',''T'',''F'',null,''F'',null,null,2)';

      EXCEPTION
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg    :=SUBSTR(SQLERRM, 1, 500);
            EXECUTE IMMEDIATE 'Insert into install_table(install_message) values (''error in inserting CAT_FIELD_SCHEMA data :'')';
            EXECUTE IMMEDIATE 'Insert into install_table(install_message) values ('''||err_msg||''')';
            GOTO bypass_install;
      END;
     <<bypass_install>>	  
     COMMIT;
        IF wk_message = 'ERROR' THEN
          RAISE createWFSDB.INSTALL_FAILED;
        ELSE
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of Category Mgmt completed SUCCESSFULLY'')';
        END IF;
    END CreateCAT;

  /*------------------------------------------------------------------
                    Create MetaEnhancement
  ------------------------------------------------------------------*/
    PROCEDURE CreateMetaEnhancement IS
      wk_message	varchar2(500);
      startNum	NUMBER;
      err_msg		varchar2(500);
      vsql      varchar2(32767);
    BEGIN

      vschema := 'WFS';	
      -- Stephen Zack added Metadata Enhancement tables on 07/25/2012.
      vsql := 'drop sequence '||vschema||'.ME_CACHE_RESULT_SEQ';
      CREATEOBJECT(vsql,'Unable to drop sequence '||vschema||'.ME_CACHE_RESULT_SEQ.','Y');
      vsql := 'drop sequence '||vschema||'.ME_ENHANCED_FIELD_SEQ';
      CREATEOBJECT(vsql,'Unable to drop sequence '||vschema||'.ME_ENHANCED_FIELD_SEQ.','Y');
      vsql := 'drop sequence '||vschema||'.ME_FIELD_DEFINITION_SEQ';
      CREATEOBJECT(vsql,'Unable to drop sequence '||vschema||'.ME_FIELD_DEFINITION_SEQ.','Y');
      vsql := 'drop sequence '||vschema||'.ME_IDENTIFIER_KEY_SEQ';
      CREATEOBJECT(vsql,'Unable to drop sequence '||vschema||'.ME_IDENTIFIER_KEY_SEQ.','Y');
      vsql := 'drop sequence '||vschema||'.ME_SUBS_PROFILE_PARAMETER_SEQ';
      CREATEOBJECT(vsql,'Unable to drop sequence '||vschema||'.ME_SUBS_PROFILE_PARAMETER_SEQ.','Y');
      vsql := 'drop sequence '||vschema||'.ME_SUBS_PROFILE_SEQ';
      CREATEOBJECT(vsql,'Unable to drop sequence '||vschema||'.ME_SUBS_PROFILE_SEQ.','Y');

      vsql := 'drop table '||vschema||'.ME_CACHE_RESULT cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_CACHE_RESULT.','Y');
      vsql := 'drop table '||vschema||'.ME_ENHANCED_FIELD cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_ENHANCED_FIELD.','Y');
      vsql := 'drop table '||vschema||'.ME_IDENTIFIER_KEY cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_IDENTIFIER_KEY.','Y');
      vsql := 'drop table '||vschema||'.ME_IDENTIFIER_CRITERIA cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_IDENTIFIER_CRITERIA.','Y');
      vsql := 'drop table '||vschema||'.ME_REQUEST cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_REQUEST.','Y');
      vsql := 'drop table '||vschema||'.ME_FIELD_DEFINITION cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_FIELD_DEFINITION.','Y');
      vsql := 'drop table '||vschema||'.ME_SUBS_PROFILE_PARAMETER cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_SUBS_PROFILE_PARAMETER.','Y');
      vsql := 'drop table '||vschema||'.ME_SUBS_PROFILE cascade constraints';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.ME_SUBS_PROFILE.','Y');

      vsql := 'CREATE TABLE '||vschema||'.ME_SUBS_PROFILE (	
                   ID          NUMBER, 
                   NAME        VARCHAR2(255 CHAR) NOT NULL, 
                   PLUGIN_NAME VARCHAR2(255 CHAR) NOT NULL,
                   CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT  ME_PROFILE_PK PRIMARY KEY (ID),
                   CONSTRAINT  ME_PROFILE_UK1 UNIQUE (NAME))';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_SUBS_PROFILE.');
      CREATESEQ('ME_SUBS_PROFILE');
      CREATEUPDATETRG('ME_SUBS_PROFILE');

      vsql := 'CREATE TABLE '||vschema||'.ME_REQUEST (	
                   ID            	NUMBER, 
                   REQUEST_KEY  	VARCHAR(255 CHAR) NOT NULL, 
                   TITLE 		      CLOB NOT NULL,
                   CREATEDATE     TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE     TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT ME_REQUEST_PK PRIMARY KEY (ID),
                   CONSTRAINT ME_REQUEST_UK1 UNIQUE (REQUEST_KEY)
                   ) LOB (TITLE) STORE AS BASICFILE';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_REQUEST.');
      CREATESEQ('ME_REQUEST');
      CREATEUPDATETRG('ME_REQUEST');

      vsql := 'CREATE TABLE '||vschema||'.ME_CACHE_RESULT (	
                   ID            NUMBER, 
                   REQUEST_ID    NUMBER NOT NULL, 
                   PROFILE_ID    NUMBER NOT NULL, 
                   REMOTE_ID     VARCHAR2(255 CHAR), 
                   TITLE         VARCHAR2(4000 CHAR) NOT NULL, 
                   YEAR          NUMBER, 
                   TYPE          VARCHAR2(255 CHAR) NOT NULL, 
                   THUMBNAIL     VARCHAR2(4000 CHAR), 
                   ACTORS        VARCHAR2(4000 CHAR), 
                   RANKING       NUMBER, 
                   STATUS	   	   VARCHAR2(20 CHAR) DEFAULT ''AVAILABLE'' NOT NULL,
                   CREATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   METADATA 	   CLOB,
                   CONSTRAINT ME_CACHE_RESULT_PK PRIMARY KEY (ID),
                   CONSTRAINT ME_CACHE_RESULT_ME_PROFIL_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID),
                   CONSTRAINT ME_CACHE_RESULT_PMM_TITLE_FK1 FOREIGN KEY (REQUEST_ID) REFERENCES '||vschema||'.ME_REQUEST(ID)
                   ) LOB (METADATA) STORE AS BASICFILE';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_CACHE_RESULT.');
      CREATESEQ('ME_CACHE_RESULT');
      CREATEUPDATETRG('ME_CACHE_RESULT');

      vsql := 'CREATE TABLE '||vschema||'.ME_FIELD_DEFINITION (	
                   ID         NUMBER, 
                   PROFILE_ID NUMBER NOT NULL, 
                   MAPPING    VARCHAR2(100 CHAR)  NOT NULL, 
                   NAME       VARCHAR2(100 CHAR)  NOT NULL, 
                   DATATYPE   VARCHAR2(100 CHAR)  NOT NULL,
                   PATH       VARCHAR2(4000 CHAR) NULL, 
                   CREATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT ME_FIELD_DEFINITION_PK PRIMARY KEY (ID),
                   CONSTRAINT ME_FIELD_DEF_ME_PROFIL_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID))';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_FIELD_DEFINITION.');
      CREATESEQ('ME_FIELD_DEFINITION');
      CREATEUPDATETRG('ME_FIELD_DEFINITION');

      vsql := 'CREATE TABLE '||vschema||'.ME_ENHANCED_FIELD (	
                   ID         NUMBER, 
                   PROFILE_ID NUMBER NOT NULL, 
                   FIELD_ID   NUMBER NOT NULL,
                   CREATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT ME_ENHANCED_FIELDS_PK PRIMARY KEY (ID),
                   CONSTRAINT ME_ENHANCED_FIELDS_UK1 UNIQUE (PROFILE_ID, FIELD_ID),
                   CONSTRAINT ME_ENHANCED_FIELDS_ME_FIE_FK1 FOREIGN KEY (FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                   CONSTRAINT ME_ENHANCED_FIELDS_ME_PRO_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID))';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_ENHANCED_FIELD.');
      CREATESEQ('ME_ENHANCED_FIELD');
      CREATEUPDATETRG('ME_ENHANCED_FIELD');

      vsql := 'CREATE TABLE '||vschema||'.ME_IDENTIFIER_CRITERIA (	
                   ID               NUMBER, 
                   PROFILE_ID       NUMBER NOT NULL, 
                   KEY_FIELD_ID     NUMBER NOT NULL, 
                   VALUE_FIELD_PATH VARCHAR2(4000 CHAR) NOT NULL,
                   ASSET_TYPE       VARCHAR2(255 CHAR),
                   CREATEDATE       TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE       TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT ME_IDENTIFIER_CRITERIA_PK PRIMARY KEY (ID),
                   CONSTRAINT ME_IDENTIFIER_CRITERIA_UK1 UNIQUE (PROFILE_ID, KEY_FIELD_ID),
                   CONSTRAINT ME_IDENTIFIER_CRI_ME_FIEL_FK1 FOREIGN KEY (KEY_FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                   CONSTRAINT ME_IDENTIFIER_CRI_ME_PROF_FK1 foreign key (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID))';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_IDENTIFIER_CRITERIA.');
      CREATESEQ('ME_IDENTIFIER_CRITERIA');
      CREATEUPDATETRG('ME_IDENTIFIER_CRITERIA');

      vsql := 'CREATE TABLE '||vschema||'.ME_SUBS_PROFILE_PARAMETER (	
                   ID         NUMBER, 
                   PROFILE_ID NUMBER NOT NULL, 
                   NAME       VARCHAR2(255 CHAR) NOT NULL, 
                   VALUE      VARCHAR2(4000 CHAR),
                   CREATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   UPDATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                   CONSTRAINT ME_SUBS_PROFILE_PARAMETER_PK PRIMARY KEY (ID),
                   CONSTRAINT ME_SUBS_PROFILE_PARAMETER_UK1 UNIQUE (PROFILE_ID, NAME),
                   CONSTRAINT ME_SUBS_PROFILE_PARAMETER_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE(ID))';
      CREATEOBJECT(vsql,'Unable to create table '||vschema||'.ME_SUBS_PROFILE_PARAMETER.');
      CREATESEQ('ME_SUBS_PROFILE_PARAMETER');
      CREATEUPDATETRG('ME_SUBS_PROFILE_PARAMETER');

      -- Suresh Neravati added the index me_cache_result_request_idx on 05/16/2013.
      vsql := 'CREATE INDEX '||vschema||'.ME_CACHE_RESULT_REQUEST_IDX ON '||vschema||'.ME_CACHE_RESULT( REQUEST_ID)';
      CREATEOBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.ME_CACHE_RESULT_REQUEST_IDX');

     <<bypass_install>>	  
     COMMIT;
        IF wk_message = 'ERROR' THEN
          RAISE createWFSDB.INSTALL_FAILED;
        ELSE
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of Metadata Enhancement completed SUCCESSFULLY'')';
        END IF;
    END CreateMetaEnhancement;
  /*------------------------------------------------------------------
                    Create ClusterObjects
  ------------------------------------------------------------------*/
    PROCEDURE CreateClusterObjects IS
      wk_message	varchar2(500);
      startNum	  number;
      err_msg		  varchar2(500);
      vsql        varchar2(32767);
    BEGIN
      vsql := 'DROP FUNCTION '||vschema||'.fn_db_instance_status';
      CREATEOBJECT(vsql,'Unable to drop function '||vschema||'.fn_db_instance_status.','Y'); 

      vsql := 'DROP TABLE '||vschema||'.db_cluster_instances';
      CREATEOBJECT(vsql,'Unable to drop table '||vschema||'.db_cluster_instances.','Y');

      vsql := 'CREATE OR REPLACE VIEW '||vschema||'.db_cluster_instances AS   
                SELECT SUBSTR(v.target_name,length(v.target_name)) AS INST_ID,
                     SUBSTR(v.target_name,instr(v.target_name,''_'')+1) AS DB_INSTANCE_NAME,
                     v.host_name as HOST_NAME,
                     case when (i.inst_id>0) then ''Active'' else ''Down'' end AS DATABASE_ROLE,
                     IC.INET_ADDRESS AS IP_ADDRESS,
                     case when (i.inst_id is null) then 3 else 1 end AS DB_INST_STATUS
                FROM MGMT$HW_NIC ic,
                     mgmt$ha_info_all v,
                     GV$INSTANCE i
               WHERE ic.host_name   = v.host_name
                 AND v.host_name    = i.host_name (+) 
                 AND v.target_type  = ''oracle_database''
                 AND ic.name        = ''eth0'' 
                 and i.status   (+) = ''OPEN''
               ORDER BY inst_id';
      CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.db_cluster_instances.');

         <<bypass_install>>	  
     COMMIT;
        IF wk_message = 'ERROR' THEN
          RAISE createWFSDB.INSTALL_FAILED;
        ELSE
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CMS Cluster DB Objects completed SUCCESSFULLY'')';
        END IF;
    END CreateClusterObjects;

  /*************************************************************************************************
   -------------------------------------Create Inter Dependent--------------------------------------
   *************************************************************************************************/
    PROCEDURE CreateInterDependent IS
		wk_message	varchar2(500);
		startNum	NUMBER;
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN
      VSCHEMA := 'WFS';	
   
      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''Installation of CreateInterDependent completed SUCCESSFULLY'')';
      COMMIT;
    END CreateInterDependent; 
    
    -- checks the pre-requisits
    PROCEDURE pre_req(p_req_met in out boolean) is
      wk_release	varchar2 (25);    
    BEGIN
        EXECUTE IMMEDIATE 'delete from install_table where install_message like ''%Error%''';
        vschema := 'WFS';
        
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM '||vschema||'.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF WK_RELEASE =  '2.9' THEN  -- Note: DB Version 2.9 = CMS Version 1.2    
            declare
              vCnt number:=0;
            BEGIN
               EXECUTE IMMEDIATE 'select count(count(*)) from '||VSCHEMA||'.tre_titlesearch group by name, username having count(*)>1' INTO VCNT;
               IF VCNT>0 THEN
                  EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''SQL- Error: Duplicate rows for TRE_TITLESEARCH (name,username).  After resolving run the script again.'')';
                  p_req_met:= FALSE;
               end if;
            END;
        end if;        
    END pre_req;

  /*************************************************************************************************
   -------------------------------------Create VIEWS for Querying-----------------------------------
   *************************************************************************************************/
    PROCEDURE CreateQueryViews IS
		wk_message	varchar2(500);
		startNum	NUMBER;
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN
      VSCHEMA := 'WFS';	


-- (1) VDW_WO_MASTER_CHILD
        vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VDW_WO_MASTER_CHILD AS
                    SELECT level                         as wo_tree_level, 
                         JP.ID_                        AS workorder_id,
                         jp.PROCESSDEFINITION_         AS Template_id,
                         jd.name_                      as Template_name, 
                         jp.PROCESSPRIORITYID          AS process_priority_id,
                         pp.name                       AS process_priority,
                         jp.START_                     AS wo_start_time,
                         jp.END_                       AS wo_end_time,
                         jp.createdate                 AS wo_create_date,
                         jp.updatedate                 AS wo_update_date,       
                         JT.ID_                        AS token_id,
                         jp.SUPERPROCESSTOKEN_         AS super_process_token,
                         jp.ROOTTOKEN_                 AS root_token,
                         jt.parent_                    as token_parent_id,
                         jt.OPERATIONALSTATUS          AS process_status_id,
                         case when ps.name=''STOPPED'' then ''COMPLETED'' else ps.name end AS process_status       
                    FROM '||vschema||'.JBPM_TOKEN JT 
                    join '||vschema||'.JBPM_PROCESSINSTANCE JP on (JT.PROCESSINSTANCE_ = JP.ID_ )
                    left outer join '||vschema||'.TTV_PROCESSPRIORITY pp on (jp.PROCESSPRIORITYID=pp.PROCESSPRIORITYID)
                    join '||vschema||'.TTV_PROCESSSTATUS ps on (jt.OPERATIONALSTATUS= ps.PROCESSSTATUSID)
                    left outer join '||vschema||'.JBPM_processdefinition jd on (jp.PROCESSDEFINITION_ = jd.id_)
                    where jp.isactive =1
                    START WITH JP.SUPERPROCESSTOKEN_ IS NULL AND jt.parent_ is null 
                    CONNECT BY  JP.SUPERPROCESSTOKEN_= PRIOR JT.ID_  OR jt.parent_ = prior jt.id_
                    order siblings by jp.id_, jp.start_';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_WO_MASTER_CHILD');

-- (2) VDW_WO_NODE_LOG
        vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VDW_WO_NODE_LOG AS
                    SELECT JP.ID_         as workorder_id,
                           JT.ID_         as token_id ,
                           jd.name_       as template_name, 
                           jl.node_       as node_id,
                           jn.name_       as node_name, 
                           jl.enter_      as node_enter_time, 
                           jl.leave_      as node_leave_time, 
                           jl.index_      as log_index
                      FROM '||vschema||'.JBPM_TOKEN JT, 
                           '||vschema||'.JBPM_PROCESSINSTANCE JP, 
                           '||vschema||'.jbpm_processdefinition jd, 
                           '||vschema||'.jbpm_log jl, 
                           '||vschema||'.jbpm_node jn
                     WHERE JT.PROCESSINSTANCE_ = JP.ID_ 
                       and JL.token_ = jt.ID_
                       and jl.node_ = jn.id_ 
                       and jl.class_ = ''N''  
                       and jp.processdefinition_ = jd.id_
                     order by jp.id_,jl.enter_';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_WO_NODE_LOG');

-- (3) VDW_WO_VARIABLEINSTANCE
        vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VDW_WO_VARIABLEINSTANCE AS
                    SELECT JP.ID_   as workorder_id,
                           JT.ID_   as token_id ,
                           vi.NAME_ as variable_name,
                           case when vi.STRINGVALUE_ is not null then vi.STRINGVALUE_ 
                                when vi.LONGVALUE_ is not null then to_char(vi.LONGVALUE_)
                                when vi.DOUBLEVALUE_ is not null then to_char(vi.DOUBLEVALUE_)
                                when vi.DATEVALUE_ is not null then to_char(vi.DATEVALUE_,''YYYY-MM-DD HH24:MI:SS.FF'')
                                when vi.BYTEARRAYVALUE_ is not null then to_char(vi.BYTEARRAYVALUE_)
                                else null end as variable_value               
                      FROM  '||vschema||'.JBPM_TOKEN JT, '||vschema||'.JBPM_PROCESSINSTANCE JP, '||vschema||'.jbpm_variableinstance vi
                            WHERE JT.PROCESSINSTANCE_ = JP.ID_ 
                             and vi.processinstance_ = jp.id_';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_WO_VARIABLEINSTANCE');

-- (4) VDW_TITLE_WO_DETAILS (no hierarchy)

        vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VDW_TITLE_WO_DETAILS AS
                  SELECT  
                          t.id_                 as title_id,
                          x.document_id         as document_id,
                          x.provider_id         as provider_id, 
                          x.provider_name       as provider_name,  
                          x.title_brief         as title_brief, 
                          x.license_start_date  as license_start_date, 
                          x.license_end_date    as license_end_date, 
                          x.asset_id            as package_asset_id,
                          x.asset_name          as asset_name,
                          jp.id_                as workorder_id,
                          jp.start_             as workorder_start_time,
                          jp.end_               as workorder_end_time,
                          jp.operationalprocessstatusid as workorder_status_id,
                          ps.name                       as workorder_status
                    FROM  '||vschema||'.MDM_METADATA mdm   
                    join xmltable(''/ECMFSpec'' passing mdm.object_value 
                                  columns document_id        NUMBER         path ''@documentId'',
                                          provider_id        VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Identifier/Id'',
                                          provider_name      VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Name'',
                                          asset_name         VARCHAR2(4000) path ''Package/Fields/AssetName'',
                                          asset_id           VARCHAR2(4000) path ''Package/Fields/Identifier/Id'',
                                          license_start_date VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowStart'',
                                          license_end_date   VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowEnd'',
                                          title_brief        VARCHAR2(4000) path ''Package/Title/Fields/Title/ShortTitle/Value''
                                 ) x on (1=1)
                    join '||vschema||'.pmm_title t on ( t.mdmdocid= extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId'') ) 
                    join '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    join '||vschema||'.jbpm_variableinstance vi on (t.id_ = vi.stringvalue_ )
                    join '||vschema||'.jbpm_processinstance jp  on (vi.name_=''titleId'' and vi.processinstance_ = jp.id_)
                    join '||vschema||'.ttv_processstatus ps on (jp.operationalprocessstatusid=ps.processstatusid)';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_TITLE_WO_DETAILS');

-- select * from WFS.VDW_TITLE_WO_DETAILS where workorder_status_id=6;
  
-- (4a) VDW_TITLE_WO_NODE_LOG_DETAILS (no hierarchy)
        vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VDW_TITLE_WO_NODE_LOG_DETAILS AS
                  SELECT  
                          t.id_                 as title_id,
                          x.document_id         as document_id,
                          x.provider_id         as provider_id, 
                          x.provider_name       as provider_name,  
                          x.title_brief         as title_brief, 
                          x.license_start_date  as license_start_date, 
                          x.license_end_date    as license_end_date, 
                          x.asset_id            as package_asset_id,
                          x.asset_name          as asset_name,
                          jp.id_                as workorder_id,
                          JN.NAME_              as NODE_NAME,
                          JL.ENTER_             as NODE_ENTER_TIME, 
                          jl.leave_             as node_leave_time,
                          jl.duration_          as node_completion_time_seconds
                    FROM  '||vschema||'.MDM_METADATA mdm   
                    join xmltable(''/ECMFSpec'' passing mdm.object_value 
                                  columns document_id        NUMBER         path ''@documentId'',
                                          provider_id        VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Identifier/Id'',
                                          provider_name      VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Name'',
                                          asset_name         VARCHAR2(4000) path ''Package/Fields/AssetName'',
                                          asset_id           VARCHAR2(4000) path ''Package/Fields/Identifier/Id'',
                                          license_start_date VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowStart'',
                                          license_end_date   VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowEnd'',
                                          title_brief        VARCHAR2(4000) path ''Package/Title/Fields/Title/ShortTitle/Value''
                                 ) x on (1=1)
                    join '||vschema||'.pmm_title t on ( t.mdmdocid= extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId'') )
                    join '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    join '||vschema||'.jbpm_variableinstance vi on (t.id_ = vi.stringvalue_ and vi.name_=''titleId'')
                    join '||vschema||'.jbpm_processinstance jp  on (vi.processinstance_ = jp.id_)
                    join '||vschema||'.jbpm_processdefinition jd on (jp.processdefinition_ = jd.id_)
                    join '||vschema||'.jbpm_token jt on (jt.processinstance_ = jp.id_ )
                    join '||vschema||'.jbpm_log jl  on (JL.token_ = jt.ID_)
                    join '||vschema||'.JBPM_NODE JN on (JL.NODE_ = JN.ID_ and JL.CLASS_ = ''N'')';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_TITLE_WO_NODE_LOG_DETAILS');

-- (5) VDW_TITLE_MASTER_CHILD (with hierarchy)
        vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'.VDW_TITLE_MASTER_CHILD AS
                  SELECT level                  AS title_tree_level,
                         t.ID_                  AS title_id,
                         t.titlestatusid        AS title_status_id,  
                         ts.description         AS title_status_desc,
                         t.providerid           AS provider_id, 
                         prov.name              AS provider_name,
                         t.originaltitle_id     AS original_title_id,
                         t.content_class_id     AS content_class_id,
                         t.partner_id           AS partner_id,
                         ptnr.name              AS partner_name,
                         t.retirement_date      AS title_retirement_date,
                         t.createdate           AS title_create_date,
                         t.updatedate           AS title_update_date, 
                         x.document_id          AS document_id, 
                         x.title_brief          AS title_brief,
                         x.asset_name           AS asset_name,
                         x.asset_id             AS package_assetid,
                         to_timestamp(x.license_startdt,''YYYY-MM-DD"T"HH24:MI:SS.FF'') AS licensing_startdt,
                         to_timestamp(x.license_enddt,''YYYY-MM-DD"T"HH24:MI:SS.FF'')   AS licensing_enddt       
                    FROM '||vschema||'.mdm_metadata mdm
                     join xmltable(''/ECMFSpec'' passing mdm.object_value 
                                  columns document_id     NUMBER path ''@documentId'',
                                          asset_name      VARCHAR2(4000) path ''Package/Fields/AssetName'',
                                          asset_id        VARCHAR2(4000) path ''Package/Fields/Identifier/Id'',
                                          license_startdt VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowStart'',
                                          license_enddt   VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowEnd'',
                                          title_brief     VARCHAR2(4000) path ''Package/Title/Fields/Title/ShortTitle/Value''
                                 ) x on (1=1)
                    JOIN '||vschema||'.pmm_title t on ( t.mdmdocid= extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId''))
                    JOIN '||vschema||'.PMM_TITLESTATUS ts on (t.titlestatusid = ts.id_)
                    left outer join '||vschema||'.PMM_PARTNER prov on (t.providerid = prov.id_)
                    left outer join '||vschema||'.PMM_PARTNER ptnr on (t.partner_id = ptnr.id_)
                    START WITH t.originaltitle_id IS NULL
                  CONNECT BY  t.originaltitle_id = PRIOR t.id_
                  ORDER SIBLINGS BY t.id_';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_TITLE_MASTER_CHILD');

-- (6) VDW_TITLE_METADATA (without hierarchy)
        vsql := 'CREATE OR REPLACE FORCE VIEW WFS.VDW_TITLE_METADATA AS
                    SELECT 
                    T.ID_ AS TITLEID,
                    T.ORIGINALTITLE_ID AS MASTER_TITLE_ID,
                    ts.description as TITLE_STATUS,
                    X.document_id,
                    X.provider_id,
                    X.provider_name,
                    X.asset_name,
                    X.asset_id,
                    X.license_start_date,
                    X.license_end_date,
                    X.title_brief,
                    X.package_asset_class,
                    X.package_asset_id,
                    X.package_asset_name,
                    X.package_creation_date,
                    X.package_description,
                    X.package_metadata_spec_version,
                    X.package_product,
                    X.package_provider,
                    X.package_provider_id,
                    X.package_version_major,
                    X.package_version_minor,
                    X.title_asset_id,
                    X.title_asset_name,
                    X.title_asset_description,
                    X.title_asset_class,
                    X.title_aondweb_available,
                    X.title_aontv_available,
                    X.title_association_id,
                    X.TITLE_BILLING_ID,
                    XMLCAST(XMLQUERY(''string-join(Category/Text, ",")'' PASSING x.category_xmltype RETURNING CONTENT) AS VARCHAR2(4000)) AS TITLE_Category,                        
                    X.title_closed_captioning,
                    X.title_contract_name,
                    X.title_Country_of_Origin,
                    X.title_Display_Run_Time,
                    X.title_EXT_ASSET_ID,
                    X.title_EXT_title_ID,
                    X.title_Episode_ID,
                    X.title_Episode_Name,
                    X.title_Genre,
                    X.title_IAP_AVAILABLE,
                    X.title_Licensing_Window_End,
                    X.title_Licensing_Window_Start,
                    X.title_Maximum_Viewing_Length,
                    X.title_Product,
                    X.title_Propagation_Priority,
                    X.title_Provider,
                    X.title_Provider_ID,
                    X.title_Provider_QA_Contact,
                    X.title_QC_COMPLETE,
                    X.title_QC_REQUIRED,
                    X.title_Rating,
                    X.title_Run_Time,
                    X.title_Show_Type,
                    X.title_Studio_Name,
                    X.title_Studio_Royalty_Percent,
                    X.title_Suggested_Price,
                    X.title_Summary_Long,
                    X.title_Summary_Medium,
                    X.title_Summary_Short,
                    X.title_TRAILER_NUM,
                    X.title_Title,
                    X.title_Title_Brief,
                    X.title_Title_Sort_Name,
                    X.TITLE_VOD_CODE,
                    X.TITLE_YEAR,
                    PSource.TITLE_SOURCE_SEQNO,
                    PSource.TITLE_ROLE_NAME,
                    PSOURCE.TITLE_CHARACTER_NAME,
                    PSOURCE.TITLE_CONTACT_DISPNAME,	  
                    pmovie.MOVIE_SEQNO ,
                    pmovie.MOVIE_Asset_Class, 
                    pmovie.MOVIE_Asset_ID, 
                    pmovie.MOVIE_Asset_Name, 
                    pmovie.MOVIE_Audio_Type, 
                    pmovie.MOVIE_Bit_Rate, 
                    pmovie.MOVIE_Content, 
                    pmovie.MOVIE_Content_CheckSum, 
                    pmovie.MOVIE_Content_Filesize, 
                    pmovie.MOVIE_Copy_Protection, 
                    pmovie.MOVIE_Creation_Date,
                    pmovie.MOVIE_Description, 
                    pmovie.MOVIE_Dubbed_Languages, 
                    pmovie.MOVIE_Encryption, 
                    pmovie.MOVIE_HDContent, 
                    pmovie.MOVIE_Languages, 
                    pmovie.MOVIE_Provider, 
                    pmovie.MOVIE_Provider_ID, 
                    pmovie.MOVIE_Screen_Format, 
                    pmovie.MOVIE_SUBTITLE_LANGUAGES, 
                    PMOVIE.MOVIE_STREAM_FORMAT,
                    pposter.POSTER_SEQNO ,
                    pposter.POSTER_Content_Checksum, 
                    pposter.POSTER_Content_Filesize, 
                    pposter.POSTER_CREATION_DATE,
                    PPOSTER.POSTER_IMAGE_ASPECT_RATIO,
                    ppreview.PREVIEW_SEQNO,
                    ppreview.PREVIEW_Audio_Type, 
                    ppreview.PREVIEW_Bit_Rate, 
                    ppreview.PREVIEW_Content, 
                    ppreview.PREVIEW_Content_Checksum, 
                    ppreview.PREVIEW_Content_Filesize, 
                    ppreview.PREVIEW_Creation_Date,
                    ppreview.PREVIEW_Dubbed_Languages, 
                    ppreview.PREVIEW_HDContent, 
                    ppreview.PREVIEW_Languages, 
                    ppreview.PREVIEW_Provider, 
                    ppreview.PREVIEW_Provider_ID, 
                    ppreview.PREVIEW_QC_COMPLETE, 
                    ppreview.PREVIEW_Rating, 
                    ppreview.PREVIEW_Run_Time,
                    ppreview.PREVIEW_SCREEN_FORMAT, 
                    PPREVIEW.PREVIEW_SUBTITLE_LANGUAGES,
                    pencrypted.ENCRYPTED_SEQNO,
                    pencrypted.ENCRYPTED_Content,
                    pencrypted.ENCRYPTED_Content_Checksum,
                    pencrypted.ENCRYPTED_Content_Filesize,
                    pencrypted.ENCRYPTED_Creation_Date,
                    pencrypted.ENCRYPTED_Asset_Encrypted,
                    pencrypted.ENCRYPTED_Encryption_KeyBlock,
                    pencrypted.ENCRYPTED_Encryption_Sysinfo,
                    pencrypted.ENCRYPTED_Encryption_Type
                    FROM  MDM_METADATA m
                      join xmltable(''/ECMFSpec'' passing m.object_value 
                                    columns document_id                      NUMBER         path ''@documentId'',
                                            provider_id                      VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Identifier/Id'',
                                            provider_name                    VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Name'',
                                            asset_name                       VARCHAR2(4000) path ''Package/Fields/AssetName'',
                                            asset_id                         VARCHAR2(4000) path ''Package/Fields/Identifier/Id'',
                                            license_start_date               VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowStart'',
                                            license_end_date                 VARCHAR2(4000) path ''Package/Title/Fields/Rights/LicensingWindowEnd'',
                                            title_brief                      VARCHAR2(4000) path ''Package/Title/Fields/Title/ShortTitle/Value'',
                                            package_asset_class              VARCHAR2(4000) path ''Package/Fields/AssetClass'',
                                            package_asset_id                 VARCHAR2(4000) path ''Package/Fields/Identifier/Id'',
                                            package_asset_name               VARCHAR2(4000) path ''Package/Fields/AssetName'',
                                            package_creation_date            VARCHAR2(4000) path ''Package/Fields/CreationInfo/CreateDate'',
                                            package_description              VARCHAR2(4000) path ''Package/Fields/Description/Text'',
                                            package_metadata_spec_version    VARCHAR2(4000) path ''Package/Fields/MetadataSpecVersion'',
                                            package_product                  VARCHAR2(4000) path ''Package/Fields/ProductInfo/Name'',
                                            package_provider                 VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Name'',
                                            package_provider_id              VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Identifier/Id'',
                                            package_version_major            VARCHAR2(4000) path ''Package/Fields/Version/Major'',
                                            package_version_minor            VARCHAR2(4000) path ''Package/Fields/Version/Minor'',
                                            title_asset_id                   VARCHAR2(4000) path ''Package/Title/Fields/Identifier/Id'',
                                            title_asset_name                 VARCHAR2(4000) path ''Package/Title/Fields/AssetName'',
                                            title_asset_description          VARCHAR2(4000) path ''Package/Title/Fields/Description/Text'',
                                            title_asset_class                VARCHAR2(4000) path ''Package/Title/Fields/AssetClass'',
                                            title_aondweb_available          VARCHAR2(4000) path ''Package/Title/Fields/CustomFields/CustomField[@name="AONDWEB_AVAILABLE"]/BooleanValue'',
                                            title_aontv_available            VARCHAR2(4000) path ''Package/Title/Fields/CustomFields/CustomField[@name="AONTV_AVAILABLE"]/BooleanValue'',
                                            title_association_id             VARCHAR2(4000) path ''Package/Title/Fields/CustomFields/CustomField[@name="ASSOCIATION_ID"]/Value'',
                                            TITLE_BILLING_ID                 VARCHAR2(4000) PATH ''Package/Title/Fields/BillingInfo/Identifier/Id'',
                                            CATEGORY_XMLTYPE                 xmltype        path  ''Package/Title/Fields/Categories/Category'',                        
                                            title_closed_captioning	         VARCHAR2(4000) path 	''Package/Title/Fields/Caption/Value'', 
                                            title_contract_name 	           VARCHAR2(4000) path 	''Package/Title/Fields/Rights/Contract/Name'', 
                                            title_Country_of_Origin          VARCHAR2(4000) path 	''Package/Title/Fields/CreationInfo/Place/Country'', 
                                            title_Display_Run_Time	         VARCHAR2(4000) path 	''Package/Title/Fields/Duration/DisplayDuration'', 
                                            title_EXT_ASSET_ID	             VARCHAR2(4000) path 	''Package/Title/Fields/CustomFields/CustomField[@name="EXT_ASSET_ID"]/Value'', 
                                            title_EXT_title_ID	             VARCHAR2(4000) path 	''Package/Title/Fields/CustomFields/CustomField[@name="EXT_title_ID"]/Value'', 
                                            title_Episode_ID 	               VARCHAR2(4000) path 	''Package/Title/Fields/Episode/Identifier/Id'', 
                                            title_Episode_Name 	             VARCHAR2(4000) path 	''Package/Title/Fields/Episode/Name/Value'', 
                                            title_Genre 	                   VARCHAR2(4000) path 	''Package/Title/Fields/Genres/Genre[1]/Value'', 
                                            title_IAP_AVAILABLE 	           VARCHAR2(4000) path 	''Package/Title/Fields/CustomFields/CustomField[@name="IAP_AVAILABLE"]/BooleanValue'', 
                                            title_Licensing_Window_End	     VARCHAR2(4000) path 	''Package/Title/Fields/Rights/LicensingWindowEnd'', 
                                            title_Licensing_Window_Start	   VARCHAR2(4000) path 	''Package/Title/Fields/Rights/LicensingWindowStart'',
                                            title_Maximum_Viewing_Length	   VARCHAR2(4000) path 	''Package/Title/Fields/Rights/MaxViewingLimit'', 
                                            title_Product 	                 VARCHAR2(4000) path 	''Package/Title/Fields/ProductInfo/Name'', 
                                            title_Propagation_Priority 	     VARCHAR2(4000) path 	''Package/Title/Fields/PropagationPriority'', 
                                            title_Provider	                 VARCHAR2(4000) path 	''Package/Title/Fields/ProviderInfo/Name'', 
                                            title_Provider_ID	               VARCHAR2(4000) path 	''Package/Title/Fields/ProviderInfo/Identifier/Id'', 
                                            title_Provider_QA_Contact	       VARCHAR2(4000) path 	''Package/Title/Fields/ProviderQAContact/Value'', 
                                            title_QC_COMPLETE	               VARCHAR2(4000) path 	''Package/Title/Fields/CustomFields/CustomField[@name="QC_COMPLETE"]/BooleanValue'', 
                                            title_QC_REQUIRED 	             VARCHAR2(4000) path 	''Package/Title/Fields/CustomFields/CustomField[@name="QC_REQUIRED"]/BooleanValue'', 
                                            title_Rating 	                   VARCHAR2(4000) path 	''Package/Title/Fields/Rating/RatingValues/RatingValue[1]/Value'', 
                                            title_Run_Time 	                 VARCHAR2(4000) path 	''Package/Title/Fields/Duration/Duration'',
                                            title_Show_Type 	               VARCHAR2(4000) path 	''Package/Title/Fields/ShowType'', 
                                            title_Studio_Name	               VARCHAR2(4000) path 	''Package/Title/Fields/CreationInfo/Studio/Name'', 
                                            title_Studio_Royalty_Percent	   VARCHAR2(4000) path 	''Package/Title/Fields/CreationInfo/Studio/RoyaltyInfo/RoyaltyPercent/@value'', 
                                            title_Suggested_Price	           VARCHAR2(4000) path 	''Package/Title/Fields/BillingInfo/SuggestedPrice/Value'', 
                                            title_Summary_Long 	             VARCHAR2(4000) path 	''Package/Title/Fields/Summary/DisplaySummary/Value'', 
                                            title_Summary_Medium 	           VARCHAR2(4000) path 	''Package/Title/Fields/Summary/MediumSummary/Value'', 
                                            title_Summary_Short	             VARCHAR2(4000) path 	''Package/Title/Fields/Summary/ShortSummary/Value'', 
                                            title_TRAILER_NUM	               VARCHAR2(4000) path 	''Package/Title/Fields/CustomFields/CustomField[@name="TRAILER_NUM"]/Value'', 
                                            title_Title	                     VARCHAR2(4000) path 	''Package/Title/Fields/Title/DisplayTitle/Value'', 
                                            title_Title_Brief 	             VARCHAR2(4000) path 	''Package/Title/Fields/Title/ShortTitle/Value'', 
                                            title_Title_Sort_Name 	         VARCHAR2(4000) path 	''Package/Title/Fields/Title/SortTitle/Value'', 
                                            title_VOD_CODE 	                 VARCHAR2(4000) path 	''Package/Title/Fields/CustomFields/CustomField[@name="VOD_CODE"]/Value'', 
                                            TITLE_YEAR	                     VARCHAR2(4000) PATH 	''Package/Title/Fields/CreationInfo/PublicationDate'', 
                                            SOURCES_XMLTYPE                    XMLTYPE        PATH  ''Package/Title/Fields/Sources/Source'',
                                            MOVIE_XMLTYPE                    XMLTYPE        PATH  ''Package/Movie'',
                                            POSTER_XMLTYPE                   XMLTYPE        PATH  ''Package/Poster'',                        
                                            PREVIEW_XMLTYPE                  XMLTYPE        PATH  ''Package/Preview'',
                                            ENCRYPTED_XMLTYPE                xmltype        PATH  ''Package/Encrypted''
                                   ) X on (1=1)
                       left outer JOIN XMLTABLE(''Source'' PASSING x.SOURCES_XMLTYPE 
                                    COLUMNS 		                    
                                            TITLE_SOURCE_SEQNO FOR ORDINALITY,
                                            TITLE_ROLE_NAME 	             VARCHAR2(4000) PATH 	''Role/Name'', 
                                            TITLE_CHARACTER_NAME           VARCHAR2(4000) PATH 	''CharacterName'',
                                            TITLE_CONTACT_DISPNAME         VARCHAR2(4000) PATH 	''Contact/DisplayName''
                      ) PSOURCE on (1=1)
                       left outer JOIN XMLTABLE(''Movie'' PASSING x.MOVIE_XMLTYPE 
                                    COLUMNS 		                    
                                            Movie_SEQNO FOR ORDINALITY,
                                            MOVIE_Asset_Class 	             VARCHAR2(4000) path 	''Fields/AssetClass'', 
                                            MOVIE_Asset_ID	                 VARCHAR2(4000) path 	''Fields/Identifier/Id'', 
                                            MOVIE_ASSET_NAME	               VARCHAR2(4000) PATH 	''Fields/AssetName'', 
                                            MOVIE_Audio_Type	               xmltype path 	''Fields/Video/AudioInfos/AudioInfo/Value'', 
                                            MOVIE_Bit_Rate	                 VARCHAR2(4000) path 	''Fields/Video/BitRate/@value'', 
                                            MOVIE_Content	                   VARCHAR2(4000) path 	''Fields/Content/Locator/Uri'', 
                                            MOVIE_Content_CheckSum	         VARCHAR2(4000) path 	''Fields/Content/Checksum'', 
                                            MOVIE_Content_Filesize	         VARCHAR2(4000) path 	''Fields/Content/Size/length'', 
                                            MOVIE_Copy_Protection 	         VARCHAR2(4000) path 	''Fields/Copyright/CopyProtection'', 
                                            MOVIE_Creation_Date	             VARCHAR2(4000) path 	''Fields/CreationInfo/CreateDate'',
                                            MOVIE_DESCRIPTION 	             varchar2(4000) PATH 	''Fields/Description/Text'', 
                                            MOVIE_Dubbed_Languages 	         xmltype  path 	''Fields/DubbedLanguages/DubbedLanguage/@value'', 
                                            MOVIE_Encryption	               VARCHAR2(4000) path 	''Fields/Encryption/Value'', 
                                            MOVIE_HDCONTENT	                 VARCHAR2(4000) PATH 	''Fields/Video/HDContent'', 
                                            MOVIE_Languages	                 xmltype path 	''Fields/Languages/Language/@value'', 
                                            MOVIE_Provider 	                 VARCHAR2(4000) path 	''Fields/ProviderInfo/Name'', 
                                            MOVIE_Provider_ID 	             VARCHAR2(4000) path 	''Fields/ProviderInfo/Identifier/Id'', 
                                            MOVIE_Screen_Format	             VARCHAR2(4000) path 	''Fields/Video/ScreenFormat'', 
                                            MOVIE_Subtitle_Languages         VARCHAR2(4000) path 	''Fields/SubTitleLanguage/@value'', 
                                            MOVIE_STREAM_FORMAT	             VARCHAR2(4000) PATH 	''Fields/Video/StreamFormat''
                    ) PMOVIE on (1=1)
                    left outer JOIN XMLTABLE(''Poster'' PASSING x.POSTER_XMLTYPE 
                                    COLUMNS 		                    
                                            POSTER_SEQNO FOR ORDINALITY,
                                            POSTER_Content_Checksum	         VARCHAR2(4000) path 	''Fields/Content/Checksum'', 
                                            POSTER_Content_Filesize	         VARCHAR2(4000) path 	''Fields/Content/Size/length'', 
                                            POSTER_Creation_Date	           VARCHAR2(4000) path 	''Fields/CreationInfo/CreateDate'',
                                            POSTER_IMAGE_ASPECT_RATIO        VARCHAR2(4000) PATH 	''Fields/Image/AspectRatio''
                    ) PPOSTER on (1=1)
                    left outer JOIN XMLTABLE(''Preview'' PASSING x.PREVIEW_XMLTYPE 
                                    COLUMNS 		                    
                                            PREVIEW_SEQNO FOR ORDINALITY,
                                            PREVIEW_Audio_Type 	             xmltype path 	''Fields/Video/AudioInfos/AudioInfo/Value'', 
                                            PREVIEW_BIT_RATE 	               VARCHAR2(4000) PATH 	''Fields/Video/BitRate/@value'', 
                                            PREVIEW_CONTENT 	               VARCHAR2(4000) PATH 	''Fields/Content/Locator/Uri'', 
                                            PREVIEW_Content_Checksum         VARCHAR2(4000) path 	''Fields/Content/Checksum'', 
                                            PREVIEW_Content_Filesize         VARCHAR2(4000) path 	''Fields/Content/Size/length'', 
                                            PREVIEW_CREATION_DATE	           varchar2(4000) PATH 	''Fields/CreationInfo/CreateDate'',
                                            PREVIEW_Dubbed_Languages         xmltype  path 	''Fields/DubbedLanguages/DubbedLanguage/@value'', 
                                            PREVIEW_HDContent 	             VARCHAR2(4000) path 	''Fields/Video/HDContent'', 
                                            PREVIEW_Languages	               xmltype path 	''Fields/Languages/Language/@value'', 
                                            PREVIEW_Provider	               VARCHAR2(4000) path 	''Fields/ProviderInfo/Name'', 
                                            PREVIEW_Provider_ID	             VARCHAR2(4000) path 	''Fields/ProviderInfo/Identifier/Id'', 
                                            PREVIEW_QC_COMPLETE	             VARCHAR2(4000) PATH 	''Fields/CustomFields/CustomField[@name="QC_COMPLETE"]/BooleanValue'', 
                                            PREVIEW_Rating	                 xmltype path 	''Fields/Rating/RatingValues/RatingValue/Value'', 
                                            PREVIEW_Run_Time	               VARCHAR2(4000) path 	''Fields/Duration/Duration'',
                                            PREVIEW_Screen_Format	           VARCHAR2(4000) path 	''Fields/Video/ScreenFormat'', 
                                            PREVIEW_SUBTITLE_LANGUAGES       VARCHAR2(4000) PATH 	''Fields/SubTitleLanguage/@value'' 
                    ) PPREVIEW on (1=1)
                    left outer JOIN XMLTABLE(''Encrypted'' PASSING x.ENCRYPTED_XMLTYPE 
                                    COLUMNS 		                    
                                            ENCRYPTED_SEQNO FOR ORDINALITY,
                                            ENCRYPTED_Content 	             VARCHAR2(4000) path 	''Fields/Content/Locator/Uri'', 
                                            ENCRYPTED_Content_Checksum       VARCHAR2(4000) path 	''Fields/Content/Checksum'', 
                                            ENCRYPTED_Content_Filesize       VARCHAR2(4000) path 	''Fields/Content/Size/length'', 
                                            ENCRYPTED_Creation_Date	         VARCHAR2(4000) path 	''Fields/CreationInfo/CreateDate'',
                                            ENCRYPTED_Asset_Encrypted	       VARCHAR2(4000) path 	''Fields/Identifier/Id'', 
                                            ENCRYPTED_Encryption_KeyBlock	   VARCHAR2(4000) path 	''Fields/Encryption/KeyBlock'', 
                                            ENCRYPTED_Encryption_Sysinfo	   VARCHAR2(4000) path 	''Fields/Encryption/SystemInfo'', 
                                            ENCRYPTED_Encryption_Type	       VARCHAR2(4000) path 	''Fields/Encryption/Type''
                    ) pencrypted on (1=1)
                      JOIN WFS.PMM_TITLE T ON ( T.MDMDOCID= XMLCAST(XMLQUERY(''/ECMFSpec/@documentId'' PASSING M.OBJECT_VALUE RETURNING CONTENT) AS NUMBER)) 
                      JOIN WFS.PMM_TITLESTATUS TS ON (T.TITLESTATUSID = TS.ID_)';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_TITLE_MASTER_CHILD');

        -- Suresh Neravati adde a view for Templates used by Titles report on 03/11/2013.
        vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VW_REP_TEMPLATES_USED_BY_TITLE AS
                 select x.document_id                      AS document_id,
                        x.provider_id                      AS provider_id, 
                        x.provider_name                    AS provider_name, 
                        x.title_brief                      AS title_brief, 
                        x.asset_id                         AS asset_id, 
                        jp.PROCESSDEFINITION_              AS template_id,
                        LPAD('' '', 2*(level-1))||jd.name_ AS template_name, 
                        t.id_                              AS title_id,
                        JP.ID_                             AS wo_id,
                        JP.START_                          AS wo_start_time,
                        JP.END_                            AS wo_end_time,
                        level                              AS wo_level,
                        case when level=1 then 1 else 0 end AS wo_count,
                        substr(to_char((JP.end_ - JP.start_) DAY(4) TO second(0)),2,10)|| 
                             case when JP.end_ is not null then '':'' else null end 
                             ||trim(to_char(round(extract(SECOND from (JP.end_ - JP.start_))),''09''))  AS wo_duration,
                        case when level=1 then (round((extract(second from (JP.end_ - JP.start_))+
                               extract(minute from (JP.end_ - JP.start_))*60 +
                               extract(hour from (JP.end_ - JP.start_))*60*60 +
                               extract(day from (JP.end_ - JP.start_))*60*60*24),0)) else 0 end as wo_duration_seconds,
                        ps.processstatusid               AS wo_process_status_id,
                        case when ps.name=''STOPPED'' then ''COMPLETED'' else ps.name end AS wo_process_status
                 from '||vschema||'.JBPM_TOKEN JT 
                 join '||vschema||'.JBPM_PROCESSINSTANCE JP on (JT.PROCESSINSTANCE_ = JP.ID_ )
                 join '||vschema||'.TTV_PROCESSSTATUS ps on (jt.OPERATIONALSTATUS= ps.PROCESSSTATUSID)
                 join '||vschema||'.jbpm_variableinstance vi on (vi.processinstance_=jp.id_ and vi.name_=''titleId'')
                 join '||vschema||'.pmm_title t on (t.id_ = trim(vi.STRINGVALUE_) and vi.stringvalue_ is not null )
                 join '||vschema||'.JBPM_processdefinition jd on (jp.PROCESSDEFINITION_ = jd.id_)
                 join '||vschema||'.mdm_metadata mdm on ( t.mdmdocid= extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId''))
                 join xmltable(''/ECMFSpec'' passing mdm.object_value 
                                 columns document_id     NUMBER path ''@documentId'',
                                         provider_id     VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Identifier/Id'',
                                         provider_name   VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Name'',
                                         asset_id        VARCHAR2(4000) path ''Package/Fields/Identifier/Id'',
                                         title_brief     VARCHAR2(4000) path ''Package/Title/Fields/Title/ShortTitle/Value''
                                ) x on (1=1)
                 where jp.isactive =1 
                 start with JP.SUPERPROCESSTOKEN_ is null and jt.parent_ is null 
                 connect by  JP.SUPERPROCESSTOKEN_= prior JT.ID_ 
                 order siblings by x.provider_name, x.title_brief,jp.START_';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VW_REP_TEMPLATES_USED_BY_TITLE');
 
         vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VW_REP_TITLES_PROSSBY_TEMPLATE AS  
                  select x.document_id                    AS document_id,
                         x.provider_id                    AS provider_id, 
                         x.provider_name                  AS provider_name, 
                         x.title_brief                    AS title_brief, 
                         x.asset_id                       AS asset_id, 
                         jp.PROCESSDEFINITION_            AS Template_id,
                         jd.name_                         AS Template_name, 
                         t.id_                            AS title_id,
                         JP.ID_                           AS wo_id,
                         JP.START_                        AS wo_start_time,
                         JP.END_                          AS wo_end_time,
                         1 AS wo_count,
                         substr(to_char((JP.end_ - JP.start_) DAY(4) TO second(0)),2,10)||
                             case when JP.end_ is not null then '':'' else null end
                         ||trim(to_char(round(extract(SECOND from (JP.end_ - JP.start_))),''09''))  AS wo_duration,
                         round((extract(second from (JP.end_ - JP.start_))+
                                   extract(minute from (JP.end_ - JP.start_))*60 +
                                   extract(hour from (JP.end_ - JP.start_))*60*60 +
                                   extract(day from (JP.end_ - JP.start_))*60*60*24),0) AS wo_duration_seconds,
                         ps.processstatusid               AS wo_process_status_id,
                         case when ps.name=''STOPPED'' then ''COMPLETED'' else ps.name end AS wo_process_status
                  from '||vschema||'.JBPM_PROCESSINSTANCE JP 
                  join '||vschema||'.TTV_PROCESSSTATUS ps on (jp.OPERATIONALPROCESSSTATUSID= ps.PROCESSSTATUSID) 
                  join '||vschema||'.jbpm_variableinstance vi on (vi.processinstance_=jp.id_ and vi.name_=''titleId'')
                  join '||vschema||'.pmm_title t on (t.id_ = trim(vi.STRINGVALUE_) and vi.stringvalue_ is not null )
                  join '||vschema||'.JBPM_processdefinition jd on (jp.PROCESSDEFINITION_ = jd.id_)
                  join '||vschema||'.mdm_metadata mdm on ( t.mdmdocid= extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId''))
                  join xmltable(''/ECMFSpec'' passing mdm.object_value 
                                  columns document_id     NUMBER path ''@documentId'',
                                          provider_id     VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Identifier/Id'',
                                          provider_name   VARCHAR2(4000) path ''Package/Fields/ProviderInfo/Name'',
                                          asset_name      VARCHAR2(4000) path ''Package/Fields/AssetName'',
                                          asset_id        VARCHAR2(4000) path ''Package/Fields/Identifier/Id'',
                                          title_brief     VARCHAR2(4000) path ''Package/Title/Fields/Title/ShortTitle/Value''
                                 ) x on (1=1)
                  where jp.isactive =1';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VW_REP_TITLES_PROSSBY_TEMPLATE');

        vsql := 'CREATE OR REPLACE VIEW '||vschema||'.VDW_SITES_DIST_SITE_TITLE AS
                  SELECT   sdst.titleid             as titleid, 
                           sdst.siteid              as dist_site_id, 
                           ss.name                  as dist_site_name,
                           sdst.status              as dist_site_status_id, 
                           sds.name                 as dist_site_status,
                           sdst.status_updated_time as dist_site_time,
                           ss.metadata_format       as dist_site_metadata_format,
                           ss.dist_template_name    as dist_template_name  
                    FROM wfs.sites_distsitetitle sdst 
                    JOIN wfs.sites_site ss on (sdst.siteid = ss.id_ ) and ss.active=1
                    JOIN wfs.sites_distribution_status sds on (sds.id_= sdst.status)';
        CREATEOBJECT(vsql,'Unable to create or replace view '||vschema||'.VDW_SITES_DIST_SITE_TITLE');

    END CreateQueryViews ; 

   
    --PROCEDURE ConvertWFS(error out NUMBER(1,0)) IS
    PROCEDURE ConvertWFS IS
		wk_message	varchar2(500);
		wk_release	varchar2 (25);	
		wk_count		number := 0;	
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN
	/*
    ---------------------------------------------------------------------------
            Start of Convert release 2.5.0.0 to 2.7.0.0
    ---------------------------------------------------------------------------
    */

        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_RELEASE
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '2.5.0.0' THEN
    
	        BEGIN      
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_SETTINGS SET setting_value=''2.7''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_RELEASE  SET setting_value=''2.7.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update WFS.SYSTEM_SETTINGS from 1.6 to 1.7.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;
        END IF;

   /*
    ---------------------------------------------------------------------------
            Start of Convert release 2.6.0.0 to 2.7.0.0
    ---------------------------------------------------------------------------
    */

        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_RELEASE
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '2.6.0.0' THEN
    		--TODO: call recreate authorization for 2.6
	        BEGIN      
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_SETTINGS SET setting_value=''2.7''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_RELEASE  SET setting_value=''2.7.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update WFS.SYSTEM_SETTINGS from 1.6 to 1.7.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;
        END IF;
        
   /*
    ---------------------------------------------------------------------------
            Start of Convert release 2.7.0.0 to 2.8.0.0
    ---------------------------------------------------------------------------
    */
 		
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
		  IF wk_release =  '2.7' THEN
		  	 BEGIN
				EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ADD (ALLOCATIONKEY VARCHAR2(255) NULL)';
			 EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable ADD ALLOCATIONKEY to WFS.TTV_RESOURCEGROUPQUEUEITEM.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install;
			 END;
			 
			 --create objects associated with PMM
			 BEGIN
	        		CreatePMM(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE '(''An error occured while running the CreatePMM procedure.'')';
	        	GOTO bypass_install; 
	       END;
	       
	       --Create the QRTZ objects
	       BEGIN
	        		CreateQRTZ(); 
	       EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE '(''An error occured while running the CreateQRTZ procedure.'')';
	        	GOTO bypass_install; 
	       END;
	       
			 BEGIN
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_SETTINGS SET setting_value=''2.8''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_RELEASE  SET setting_value=''2.8.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update WFS.SYSTEM_SETTINGS from 2.7 to 2.8.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;

		  END IF;

   /*
    ---------------------------------------------------------------------------
            Start of Convert release 2.8.0.0 to 2.9.0.0 (Neptune)
    ---------------------------------------------------------------------------
    */
 		
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
		  IF wk_release =  '2.8' THEN
        vsql := 'alter table '||vschema||'.ttv_resource drop constraint FK_TTV_RESOURCE_USERDATA';
        CREATEOBJECT(vsql,'Unable to drop constraint FK_TTV_RESOURCE_USERDATA','Y');

        vsql := 'drop table '||vschema||'.TTV_MODULE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_MODULE','Y');

        vsql := 'drop sequence '||vschema||'.TTV_MODULE_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_MODULE_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_PERMISSION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_PERMISSION','Y');

        vsql := 'drop sequence '||vschema||'.TTV_PERMISSION_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_PERMISSION_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_ACTION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_ACTION','Y');
			 
        vsql := 'drop sequence '||vschema||'.TTV_ACTION_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_ACTION_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_MENUITEM cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_MENUITEM','Y');

        vsql := 'drop sequence '||vschema||'.TTV_MENUITEM_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_MENUITEM_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_BIGROLEPERMISSION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_BIGROLEPERMISSION','Y');

        vsql := 'drop sequence '||vschema||'.TTV_BIGROLEPERMISSION_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_BIGROLEPERMISSION_SEQ','Y');

        vsql := 'drop table '||vschema||'.BIGROLEPERMISSION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table BIGROLEPERMISSION','Y');

        vsql := 'drop table '||vschema||'.BIGROLE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table BIGROLE','Y');

        vsql := 'drop table '||vschema||'.BIGROLE_ROLE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table BIGROLE_ROLE','Y');

        vsql := 'drop table '||vschema||'.USER_BIGROLE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table USER_BIGROLE','Y');

        vsql := 'drop table '||vschema||'.USER_DATA cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table USER_DATA','Y');

        vsql := 'drop table '||vschema||'.USERS_REALM cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table USERS_REALM','Y');
        
        /* Suneeta changes on 3/29/09 */
        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM add (titleRevision varchar2(25) not null, sourcecomponentname varchar2(25) not null,sourceEntityName varchar2(25),sourceId varchar2(100) not null)';
        CREATEOBJECT(vsql,'Add pmm_progressitem.titlerevision,sourcecomponentname,sourceEntityName,sourceId','Y');        

        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM drop (tokenid,processid) cascade constraints';
        CREATEOBJECT(vsql,'Drop pmm_progressitem (tokenid,processid) columns','Y');

        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM rename column TITLEREVISION to TITLEVERSION';
        CREATEOBJECT(vsql,'alter table PMM_PROGRESSITEM rename TITLEREVISION','Y');

        vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD ASSET_ID NUMBER';
        CREATEOBJECT(vsql,'alter table PMM_TITLE ADD ASSET_ID','Y');

        /* Raj changes on 3/29/09 */
        vsql := 'drop table '||vschema||'.PMM_TITLEMETADATA cascade constraints';
        CREATEOBJECT(vsql,'Drop table PMM_TITLEMETADATA','Y');

        vsql := 'alter table '||vschema||'.PMM_TITLE drop (TITLENAME,SPECIFICATION,PARENTID,ROOTTITLEID,INTERNALLOCATION,METADATALOCATION) cascade constraints';
        CREATEOBJECT(vsql,'alter table PMM_TITLE drop columns','Y');
        
        /* Suneeta changes on 5/12/2009 */
        vsql := 'alter table '||vschema||'.PMM_TITLE drop ISACTIVE cascade constraints';
        CREATEOBJECT(vsql,'alter table PMM_TITLE drop column ISACTIVE','Y');
        
        /* By Suneeta 05/14/09 */
         vsql := 'merge into '||vschema||'.PMM_TitleStatus p
          using (select 0 as id, ''DRAFT'' as descr from dual) a
          on (p.id_ = a.id)
          when matched then
          update set p.description = a.descr
          when not matched then
          insert (id_,description)
          values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 0','Y');

        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 1 as id, ''COMMITTED'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 1','Y');

        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 2 as id, ''READY'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 2','Y');
        
        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 3 as id, ''APPROVED'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 3','Y');

        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 4 as id, ''RETIRED'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 4','Y');
       
        --create table PMM_TITLEASSETSTATUS. 
        vsql := 'create table '||vschema||'.PMM_TITLEASSETSTATUS(
                  id number,
                  titleid number,
                  assetVersion varchar2(10),
                  titlestatus number,
                  CREATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP), 
                  UPDATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP),
                  constraint pk_pmmtitleassetstation primary key (id),
                  CONSTRAINT fk_pmmtas_titleSTATUS  FOREIGN KEY (titlestatus)  REFERENCES '||vschema||'.pmm_titlestatus(id_),
                  CONSTRAINT fk_pmmtas_TITLEid  FOREIGN KEY (titleid) REFERENCES '||vschema||'.pmm_title(id_)            
                  )';
        CREATEOBJECT(vsql,'Unable to create table PMM_TITLEASSETSTATUS','Y');
        CREATESEQ('PMM_TITLEASSETSTATUS');
        CREATEUPDATETRG('PMM_TITLEASSETSTATUS');

        --alter table PMM_PROGRESSITEM. By QA/Dipti. 05/29/09
        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM modify (DESCRIPTION varchar2(1000))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_PROGRESSITEM ','Y');
        
        --alter table PMM_JOB. By Suneeta. 06/08/09
        vsql := 'ALTER TABLE '||vschema||'.PMM_JOB MODIFY (TEMPLATENAME VARCHAR2(255) NULL)';
        CREATEOBJECT(vsql,'Unable to alter table PMM_JOB','Y');

        vsql := 'ALTER TABLE '||vschema||'.PMM_JOB MODIFY (PROCESSPRIORITYID NUMBER NULL)';
        CREATEOBJECT(vsql,'Unable to alter table PMM_JOB','Y');
        
        --alter table PMM_PROGRESSITEM . By Suneeta. 06/17/09
        vsql := 'ALTER TABLE '||vschema||'.PMM_PROGRESSITEM MODIFY (name varchar(50))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_PROGRESSITEM','Y');

        --create table PMM_CONTAINER_PROPERTIES. By Suneeta 07/06/09
        vsql := 'CREATE TABLE '||vschema||'.PMM_CONTAINER_PROPERTIES(
                  id number PRIMARY KEY,
                  contextid number,
                  name varchar2(100),
                  value varchar2(250),
                  CREATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                  UPDATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                  CONSTRAINT CONTEXTID_FK FOREIGN KEY (contextid) REFERENCES '||vschema||'.PMM_CONTEXT(id_)
                  )';
        CREATEOBJECT(vsql,'Unable to create table PMM_CONTAINER_PROPERTIES','Y');
        CREATESEQ('PMM_CONTAINER_PROPERTIES');
        CREATEUPDATETRG('PMM_CONTAINER_PROPERTIES');
        
        --By Suneeta 07/29/09
        vsql := 'insert into '||vschema||'.pmm_listtype (id_, description) values(4, ''Title List'')';
        CREATEOBJECT(vsql,'Unable to insert into pmm_listtype','Y');

        vsql := 'alter table '||vschema||'.pmm_title_titlelistxref add ORDER_ number default 0 not null';
        CREATEOBJECT(vsql,'Unable to alter table pmm_title_titlelistxref','Y');
        
        --By Suneeta 08/04/09
        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM add ISACTIVE NUMBER(1,0) DEFAULT (1) not null';
        CREATEOBJECT(vsql,'Unable to alter table PMM_PROGRESSITEM','Y');
        
        vsql := 'alter table '||vschema||'.PMM_Title_TitleListXREF drop constraint PK_PMM_TITLE_TITLELISTXREF';
        CREATEOBJECT(vsql,'Unable to alter table PMM_Title_TitleListXREF','Y');
        
        vsql := 'alter table '||vschema||'.PMM_Title_TitleListXREF ADD (CONSTRAINT PK_PMM_Title_TitleListXREF PRIMARY KEY (TitleListId, TitleId,ORDER_))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_Title_TitleListXREF','Y');

        vsql := 'alter table '||vschema||'.JBPM_VARIABLEINSTANCE modify (stringvalue_ varchar2(4000))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_Title_TitleListXREF','Y');

        --By Sahil, 08/24/09
	      vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Pitch Schedule Notification Pattern'',''.*titles did not achieve status.*'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Drive Status'',''.*drive status.*'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Planner Notification Pattern'',''.*assets for planner.*'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) VALUES (''Pitch Schedule Notification'',''Pitch Schedule Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) VALUES (''Drive Status'',''Drive Status'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) VALUES (''Planner Notification'',''Planner Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Planner Notification'',1,''14'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

        vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Drive Status'',1,''15'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

        vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Pitch Schedule Notification'',1,''13'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

        vsql := 'DELETE FROM '||vschema||'.TTV_MONITOREDDRIVEHISTORY';
        CREATEOBJECT(vsql,'Unable to delete from TTV_MONITOREDDRIVEHISTORY');
        
        vsql := 'DELETE FROM '||vschema||'.ttv_MONITOREDDRIVE';
        CREATEOBJECT(vsql,'Unable to delete from ttv_MONITOREDDRIVE');
        
        vsql := 'INSERT INTO '||vschema||'.ttv_MONITOREDDRIVE (monitoreddriveid, name, description, path, internaldriveid, totalcapacity, warningthresholdpercent, errorthresholdpercent, currentbytesused, currentdrivestatusid,CreateDate, UpdateDate) 
					VALUES ('||vschema||'.ttv_MONITOREDDRIVE_SEQ.NEXTVAL, ''Content'', ''Drive for mapped and unmapped assets in PMM'', ''/content'', 1, 100000000000, 50, 75, 0, 0, sysdate,sysdate)';        
        CREATEOBJECT(vsql,'Unable to insert into ttv_MONITOREDDRIVE');

        vsql := 'ALTER TABLE '||vschema||'.pmm_progressitem modify (name varchar2(255))';        
        CREATEOBJECT(vsql,'Unable to alter table pmm_progressitem name column');

        vsql := 'ALTER TABLE '||vschema||'.alerts_hist modify (msg varchar2(4000))';        
        CREATEOBJECT(vsql,'Unable to alter table alerts_hist msg column');
        
        --Vlada on Oct 21 2009
        vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES(ALERT_NAME, PATTERN) VALUES(''Login Failed Pattern'', ''.*Login failed for.*'')';
        CREATEOBJECT(vsql,'Unable to insert into alert_names','Y');
        
        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
            VALUES(''Login Failed'', ''Login Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) VALUES(''Login Failed'', 1, ''4'')';
        CREATEOBJECT(vsql,'Unable to insert into alert_actions','Y');

        --Create indexes on all Foreign keys of JBPM_LOG to prevent it getting locked exclusively when deleting rows from JBPM_VARIABLEINSTANCE table
        declare
          cursor c1 is select 'CREATE INDEX '||vschema||'.IDX_JPLOG_'||substr(ucc.column_name,1,12)||'_'||ucc.position||' on '||vschema||'.JBPM_LOG('||ucc.column_name||')' as crindex
                        from dba_constraints uc, dba_cons_columns ucc , dba_constraints uc1
                        where uc.constraint_name = ucc.constraint_name
                        and uc.table_name = ucc.table_name
                        and uc.owner=ucc.owner
                        and uc.owner = upper(vschema)
                        and uc.constraint_type='R'
                        and uc.table_name = 'JBPM_LOG'
                        and uc.r_constraint_name = uc1.constraint_name
                        and uc.owner = uc1.owner;
        begin
          for r1 in c1 loop
              CREATEOBJECT(r1.crindex,'Unable to create index on JBPM_LOG table','Y');
          end loop;
        end;

       BEGIN
	        		EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''2.9''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''2.9.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
          dbms_output.put_line('convertwfs error:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update '||vschema||'.SYSTEM_SETTINGS from 2.8 to 2.9.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;

		  END IF;
      
/*
    ---------------------------------------------------------------------------
            Start of Convert release 2.9.0.0 to 3.0.0.0 (CMS 1.2)
    ---------------------------------------------------------------------------
    */
 		
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
		  IF wk_release =  '2.9' THEN
      
        --removed unused column
        vsql := 'alter table '||vschema||'.tre_rule drop column text';
        CREATEOBJECT(vsql,'Unable to alter table tre_rule','Y');
        
        -- add in not operator
        vsql := 'alter table '||vschema||'.Tre_Predicate add (not_ NUMBER(1,0) default(0) not null)';
        CREATEOBJECT(vsql,'Unable to alter table tre_predicate','Y');
        
        vsql := 'UPDATE '||vschema||'.TRE_PREDICATE SET NOT_ = 1, OPERATOR= ''EQUAL'' WHERE OPERATOR= ''NOTEQUAL''';
        CREATEOBJECT(vsql,'Unable to update tre_predicate');
        
        vsql := 'UPDATE '||vschema||'.TRE_PREDICATE SET NOT_ = 1, OPERATOR= ''IN'' WHERE OPERATOR= ''NOTIN''';
        CREATEOBJECT(vsql,'Unable to update tre_predicate');
        
        vsql := 'UPDATE '||vschema||'.TRE_PREDICATE SET NOT_ = 1, OPERATOR= ''ISEMPTY'' WHERE OPERATOR= ''ISNOTEMPTY''';
        CREATEOBJECT(vsql,'Unable to update tre_predicate');

        vsql := 'UPDATE '||vschema||'.TRE_PREDICATE SET NOT_ = 1, OPERATOR= ''CONTAINS'' WHERE OPERATOR= ''DOESNOTCONTAIN''';
        CREATEOBJECT(vsql,'Unable to update tre_predicate');
        
        vsql := 'create table '||vschema||'.Tre_TitleSearch (
          titleSearchId NUMBER not null,
          titleFilterId NUMBER not null,
          name NVARCHAR2(256)  not null,
          userName NVARCHAR2(256)  not null,
          shared NUMBER(1,0)  not null,
          primary key(titleSearchId)
        )';
        CREATEOBJECT(vsql,'Unable to create table tre_titlesearch','Y');
        
        vsql := 'alter table '||vschema||'.Tre_TitleSearch add constraint FK_TitleSearch_Filter foreign key (titleFilterId) references '||vschema||'.Tre_TitleFilter';
        CREATEOBJECT(vsql,'Unable to alter table tre_titlesearch','Y');

        vsql := 'ALTER TABLE '||vschema||'.TRE_TITLESEARCH ADD CONSTRAINT TRE_TITLESEARCH_UNIQ UNIQUE (NAME,USERNAME)';
        CREATEOBJECT(vsql,'Unable to alter table tre_titlesearch','Y');

        vsql := 'create sequence '||vschema||'.tre_titleSearch_seq NOCACHE';
        CREATEOBJECT(vsql,'Unable to create sequence','Y');
        
        vsql := 'alter table '||vschema||'.Tre_Predicate add (fieldTypeLhs NVARCHAR2(32))';
        CREATEOBJECT(vsql,'Unable to alter table tre_predicate','Y');

        vsql := 'alter table '||vschema||'.Tre_Predicate add (fieldTypeRhs NVARCHAR2(32))';
        CREATEOBJECT(vsql,'Unable to alter table tre_predicate','Y');
        
        vsql := 'update '||vschema||'.Tre_Predicate set fieldTypeLhs = ''asset'' where fieldTypeLhs is null';
        CREATEOBJECT(vsql,'Unable to update tre_predicate','Y');
        
        vsql := 'UPDATE '||vschema||'.tre_ruleset set CREATEDATE= SYSDATE, UPDATEDATE=SYSDATE WHERE CREATEDATE IS NULL';
        CREATEOBJECT(vsql,'Unable to update tre_ruleset','Y');
        
        vsql := 'alter table '||vschema||'.TRE_PREDICATE MODIFY(fieldLeft NVARCHAR2(1024) null)';
        CREATEOBJECT(vsql,'Unable to alter table tre_predicate','Y');
        
        --added two events
        vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(5,''Targeted'',''Used for content processing rules when a title is finished being targeted.'')';
        CREATEOBJECT(vsql,'Unable to insert into Tre_Event','Y');

        vsql := 'insert into '||vschema||'.Tre_Event(EventId, Name, Description) VALUES(6,''Purge'',''Can be triggered through an job in PMM job module.'')';
        CREATEOBJECT(vsql,'Unable to insert into Tre_Event','Y');
      
        --Danny changes
        vsql := 'alter table '||vschema||'.Tre_RuleSet add (runOnGlobal NUMBER(1,0) default (1) not null )';
        CREATEOBJECT(vsql,'Unable to alter table Tre_RuleSet','Y');

        vsql := 'alter table '||vschema||'.Tre_Rule add (CLASS_ID VARCHAR2(2) default (''SR'') not null ,className VARCHAR2(1024))';
        CREATEOBJECT(vsql,'Unable to alter table Tre_Rule','Y');
        
        vsql := 'create table '||vschema||'.Tre_CustomRuleParameter (
                  parameterId NUMBER not null,
                  ruleId NUMBER null,
                  value_ VARCHAR2(2000) not null,
                  key_ varchar2(512) not null,
                  order_ NUMBER,
                  primary key(parameterId),
                  constraint FK_Rule_CRParameter foreign key (ruleId) references '||vschema||'.Tre_Rule(ruleId)
                )';
        CREATEOBJECT(vsql,'Unable to create table Tre_CustomRuleParameter','Y');
        CREATESEQ('Tre_CustomRuleParameter');

        --Suneeta's change for PMM module
        vsql := 'alter table '||vschema||'.pmm_job add (ISSCHEDULEONLY number default (0))';
        CREATEOBJECT(vsql,'Unable to alter table pmm_job','Y');
        
        vsql := 'alter table '||vschema||'.pmm_job modify (name varchar2(50))';
        CREATEOBJECT(vsql,'Unable to alter table pmm_job','Y');

        --Vijay's change for Metadata Manager
        vsql := 'ALTER TABLE '||vschema||'.MDM_ASSET ADD (ORIGINALASSET_ID NUMBER,ORIGINALASSET_REVISION NUMBER(5,0),
                                            CONSTRAINT FK_ORIGINALASSET_ASSET_ID FOREIGN KEY (ORIGINALASSET_ID) REFERENCES '||vschema||'.MDM_ASSET(ID))';
        CREATEOBJECT(vsql,'Unable to alter table MDM_ASSET','Y');

        --Raj's Site addition to workflow
        createSITES();

        --Vijay's new addition
        -- Add new columns for the original title ID and the original title version
        vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD (ORIGINALTITLE_ID NUMBER,
                  ORIGINALTITLE_VERSION VARCHAR2(10),
                  LAST_MODIFIED_TIME TIMESTAMP DEFAULT(SYSTIMESTAMP) NOT NULL,
                  CONSTRAINT FK_ORIGINALTITLE_TITLE_ID  FOREIGN KEY (ORIGINALTITLE_ID) REFERENCES '||vschema||'.PMM_TITLE(ID_))';
        CREATEOBJECT(vsql,'Unable to alter table pmm_title','Y');
        
        -- Reset the default value for last modified time
        vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE MODIFY LAST_MODIFIED_TIME DEFAULT(null)';
        CREATEOBJECT(vsql,'Unable to alter table pmm_title','Y');

        vsql := 'alter table '||vschema||'.tre_ruleset add(uuid varchar2(36))';
        CREATEOBJECT(vsql,'Unable to alter table tre_ruleset','Y');

        vsql := 'update '||vschema||'.TRE_RULESET rs 
        set rs.uuid = 
        (WITH data AS (SELECT sys_guid() uuid, rulesetId FROM '||vschema||'.TRE_RULESET)
            SELECT  substr(uuid,1,8) || ''-'' || 
                         substr(uuid,9,4) || ''-'' || 
                         substr(uuid,13,4) || ''-'' || 
                         substr(uuid,17,4) || ''-'' || 
                         substr(uuid,21,12) finaluuid
            FROM data
                  where data.rulesetId = rs.rulesetId)';
        CREATEOBJECT(vsql,'Unable to update tre_ruleset.uuid');
                  
        vsql := 'alter table '||vschema||'.tre_ruleset modify(uuid varchar2(36) not null)';
        CREATEOBJECT(vsql,'Unable to alter table tre_ruleset','Y');

        --By Kinjal 04/29/10
        vsql := 'update '||vschema||'.alert_names set pattern = ''.*login failed.*'' where alert_name = ''Login Failed Pattern''';
        CREATEOBJECT(vsql,'Unable to update alert_names');

        -- By Suneeta 04/29/10
        vsql := 'insert into '||vschema||'.pmm_containertype (id_, name) values (3, ''SITE'')';
        CREATEOBJECT(vsql,'Unable to insert pmm_containertype','Y');
        
        --By Sahil 04/30/10
        vsql := 'alter table '||vschema||'.ttv_resource add (IGNORETIMEOUT number(1,0) default 0 not null)';
        CREATEOBJECT(vsql,'Unable to alter table ttv_resource','Y');
        
        vsql := 'alter table '||vschema||'.jbpm_token add (retrycount number default 0 not null)';
        CREATEOBJECT(vsql,'Unable to alter table jbpm_token','Y');
      
        --By Sanjay 04/10/10
        vsql := 'ALTER TABLE '||vschema||'.TRE_RULESET ADD CONSTRAINT trerulesetUUID_UNIQUE UNIQUE(UUID)';
        CREATEOBJECT(vsql,'Unable to alter table TRE_RULESET','Y');
        
        --By Kinjal 05/24/10
        vsql := 'alter table '||vschema||'.pmm_progressitem modify (description varchar2(4000))';
        CREATEOBJECT(vsql,'Unable to alter table pmm_progressitem','Y');        

         --By Sahil 05/24/10
        vsql := 'alter table '||vschema||'.ttv_monitoreddrive modify (TOTALCAPACITY null)';
        CREATEOBJECT(vsql,'Unable to alter table ttv_monitoreddrive','Y'); 
        
       BEGIN
	        		EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.0''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.0.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
          dbms_output.put_line('convertwfs error:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update '||vschema||'.SYSTEM_SETTINGS from 2.9 to 3.0.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;

		  END IF;

/*
    ---------------------------------------------------------------------------
            Start of Convert release 3.0.0.0 (CMS 1.2) to 3.1.0.0(CMS 1.5)
    ---------------------------------------------------------------------------
    */
 		
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        IF wk_release =  '3.0' THEN        
        -- create table PMM_CONTENT_CLASS by Eugene Karpenko dated 07/21/2010
          vsql := 'CREATE TABLE '||vschema||'.PMM_CONTENT_CLASS (
                    ID            NUMBER NOT NULL ENABLE,
                    NAME          VARCHAR2(25),
                    DESCRIPTION   VARCHAR2(250),
                    SPECIAL_USAGE NUMBER(1) DEFAULT 0 NOT NULL ENABLE,
                    IS_DEFAULT    NUMBER(1) DEFAULT 0 NOT NULL ENABLE,
                    DATA          CLOB,
                    CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                    UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                    CONSTRAINT PMM_CONTENT_CLASS_PK PRIMARY KEY (ID))';
        
          CREATEOBJECT(vsql,'Unable to create table PMM_CONTENT_CLASS','Y');
          CREATESEQ('PMM_CONTENT_CLASS');
          CREATEUPDATETRG('PMM_CONTENT_CLASS');
          
          vsql := 'CREATE TABLE '||vschema||'.PMM_CONTENT_CLASS_PARTNER (
                    CONTENT_CLASS_ID     NUMBER NOT NULL ENABLE,
                    PARTNER_ID           NUMBER NOT NULL ENABLE,
                    DATA                 CLOB,
                    CREATEDATE           TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                    UPDATEDATE           TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                    CONSTRAINT FK_CCPARTNER_PMMCONTCLASS FOREIGN KEY (CONTENT_CLASS_ID) REFERENCES '||vschema||'.PMM_CONTENT_CLASS(ID),
                    CONSTRAINT FK_CCPARTNER_PMMPARTNER FOREIGN KEY (PARTNER_ID) REFERENCES '||vschema||'.PMM_PARTNER(ID_),
                    CONSTRAINT PK_PMM_CONTENT_CLASS_PARTNER PRIMARY KEY (CONTENT_CLASS_ID, PARTNER_ID))';
                      
          CREATEOBJECT(vsql,'Unable to create table PMM_CONTENT_CLASS_PARTNER','Y');
          CREATEUPDATETRG('PMM_CONTENT_CLASS_PARTNER');

        -- Add new columns to PMM_TITLE and creating new table  by Eugene Karpenko dated: 08/04/2010
          vsql := 'alter table '||vschema||'.PMM_TITLE add (CONTENT_CLASS_ID NUMBER, PARTNER_ID NUMBER,
                    CONSTRAINT FK_TITLE_PMMCONTCLASS FOREIGN KEY (CONTENT_CLASS_ID) REFERENCES '||vschema||'.PMM_CONTENT_CLASS(ID),
                    CONSTRAINT FK_TITLE_PMMPARTNER FOREIGN KEY (PARTNER_ID) REFERENCES '||vschema||'.PMM_PARTNER(ID_))';
          CREATEOBJECT(vsql,'Add PMM_TITLE.CONTENT_CLASS_ID,PARTNER_ID','Y');
--CONSTRAINT FK_PMMCONCLSPARTNER FOREIGN KEY (CONTENT_CLASS_ID, PARTNER_ID) REFERENCES '||vschema||'.PMM_CONTENT_CLASS_PARTNER(CONTENT_CLASS_ID, PARTNER_ID),          
                    
           --     Adding new columns CONTENT CLASS ID and PARTNER ID and filling the data
           --     Per the request received from Eugene Karpenko Dated : 08/05/2010
          BEGIN      
              -- inserting a default record in CONTENT_CLASS table    
              EXECUTE IMMEDIATE 'INSERT INTO wfs.pmm_content_class (id, name, description, is_default) VALUES (wfs.PMM_CONTENT_CLASS_SEQ.nextval, ''Default'', ''Default content class'', 1)';
      
              -- creating the records in the CONTENT_CLASS_PARTNER TABLE
              EXECUTE IMMEDIATE 'INSERT INTO wfs.pmm_content_class_partner (content_class_id, partner_id) SELECT cc.id, p.id_ FROM wfs.pmm_partner p, wfs.pmm_content_class cc '||
                                      ' WHERE p.partnertype in (0,2) AND cc.is_default = 1';
         
              -- update the content_class_id, partner_id columns of TITLE Table with the default values
              EXECUTE IMMEDIATE 'UPDATE wfs.pmm_title SET (content_class_id, partner_id) = '||
                                    '(SELECT cc.id, p.id_ FROM wfs.pmm_partner p, wfs.pmm_content_class cc  WHERE p.partnertype = 0 AND cc.is_default = 1)';          
            EXCEPTION 
              WHEN OTHERS THEN
                 wk_message := 'ERROR';
                 err_msg :=SUBSTR(SQLERRM, 1, 500);
                 EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values (''Error in installing of application database objects:'||
                                  'Unable to insert content_class_id and partner_id data.'')';
                 EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values ('||err_msg||')';
            END;

          
          -- Update script for MDM_ASSET table class_id value from I to G for Movie and Preview (Nicholas request Dated 08/11/2010)
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE wfs.mdm_asset SET class_id=''G'' WHERE type IN (''MOVIE'',''PREVIEW'')';
          EXCEPTION 
            WHEN OTHERS THEN
               wk_message := 'ERROR';
               err_msg :=SUBSTR(SQLERRM, 1, 500);
               EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values (''Error in installing of application database objects:'||
                                'Unable to update the class_id in mdm_asset table.'')';
               EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values ('||err_msg||')';
          END;
          
          -- updated event names and a new event "DELETE" has been created by Daniel Weiner on 08-13-2010
          BEGIN
          
              EXECUTE IMMEDIATE 'UPDATE WFS.TRE_EVENT SET NAME = ''INGESTED'' WHERE EVENTID = 0';
              EXECUTE IMMEDIATE 'UPDATE WFS.TRE_EVENT SET NAME = ''UICREATED'' WHERE EVENTID = 1';
              EXECUTE IMMEDIATE 'UPDATE WFS.TRE_EVENT SET NAME = ''UIUPDATED'' WHERE EVENTID = 2';
              EXECUTE IMMEDIATE 'UPDATE WFS.TRE_EVENT SET NAME = ''NORMALIZED'' WHERE EVENTID = 3';
              EXECUTE IMMEDIATE 'UPDATE WFS.TRE_EVENT SET NAME = ''SCHEDULE'' WHERE EVENTID = 4';
              EXECUTE IMMEDIATE 'UPDATE WFS.TRE_EVENT SET NAME = ''TARGETED'' WHERE EVENTID = 5';
              EXECUTE IMMEDIATE 'UPDATE WFS.TRE_EVENT SET NAME = ''PURGE'' WHERE EVENTID = 6';
              EXECUTE IMMEDIATE 'INSERT INTO WFS.TRE_EVENT (EVENTID, NAME) VALUES(7,''DELETED'')';
  
          EXCEPTION 
            WHEN OTHERS THEN
               wk_message := 'ERROR';
               err_msg :=SUBSTR(SQLERRM, 1, 500);
               EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values (''Error in installing of application database objects:'||
                                'Unable to update the TRE_EVENT table.'')';
               EXECUTE IMMEDIATE 'INSERT INTO wfs.install_table(install_message) values ('||err_msg||')';
          END;

          -- Created an text index for Daniel on 08-11-2010
          -- Following four steps to change the column name and then we are creating the index.  
          -- This is because we can not create text index on the nvarchar2 column
          vsql := 'ALTER TABLE '||vschema||'.MDM_FIELD ADD (VALUE_NEW VARCHAR2(2000))';
          CREATEOBJECT(vsql,'Step-1 : Unable to ALTER TABLE '||vschema||'.MDM_FIELD to ADD column (VALUE_NEW VARCHAR2(2000))','Y');

          vsql := 'UPDATE '||vschema||'.MDM_FIELD SET VALUE_NEW=VALUE';
          CREATEOBJECT(vsql,'Step-2 : Unable to UPDATE '||vschema||'.MDM_FIELD SET VALUE_NEW=VALUE','Y');

          vsql := 'ALTER TABLE '||vschema||'.MDM_FIELD DROP COLUMN VALUE';
          CREATEOBJECT(vsql,'Step-3 : Unable to DROP column VALUE in '||vschema||'.MDM_FIELD table','Y');

          vsql := 'ALTER TABLE '||vschema||'.MDM_FIELD RENAME COLUMN VALUE_NEW TO VALUE';
          CREATEOBJECT(vsql,'Step-4 : Unable to RENAME column VALUE_NEW to VALUE on '||vschema||'.MDM_FIELD','Y');
          
          -- Created an text index 
          vsql := 'CREATE INDEX '||vschema||'.CTX_IDX_MDM_FIELD_VALUE ON '||vschema||'.MDM_FIELD(VALUE) INDEXTYPE IS CTXSYS.CTXCAT';
          CREATEOBJECT(vsql,'Unable to create text index CTX_IDX_MDM_FIELD_VALUE on MDM_FIELD(VALUE)','Y');	


          -- Eugene added a new index and unique key constraint to the pmm_content_class table name column on 08-17-2010
          vsql := 'CREATE UNIQUE INDEX '||vschema||'.IDX_UNQ_PMM_CONTENT_CLASS_NAME ON '||vschema||'.PMM_CONTENT_CLASS(NAME)';
          CREATEOBJECT(vsql,'Unable to create index PMM_CONTENT_CLASS Name.','Y');	
          
          vsql := 'ALTER TABLE '||vschema||'.PMM_CONTENT_CLASS ADD CONSTRAINT UK_PMM_CONTENT_CLASS_NAME UNIQUE (NAME)';
          CREATEOBJECT(vsql,'Unable to add a CONSTRAINT to the PMM_CONTENT_CLASS Name column.','Y');
          
                -- created table CMS_USER_SESSION by Francisco dated 08-19-2010
          vsql := ' CREATE TABLE '||vschema||'.CMS_USER_SESSION (
                    USERSESSIONID   NUMBER(10) NOT NULL,
                    USERNAME        VARCHAR2(100) NOT NULL,
                    CMS_SESSION_ID  VARCHAR2(100) NOT NULL,
                    --CREATION_DATE date NOT NULL,
                    CREATEDATE      TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                    UPDATEDATE      TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_USER_SESSION_USERSESID PRIMARY KEY (USERSESSIONID))';
         
          CREATEOBJECT(vsql,'Unable to create table CMS_USER_SESSION','Y');
          CREATESEQ('CMS_USER_SESSION');
          CREATEUPDATETRG('CMS_USER_SESSION');
      
          -- added a new column initialvalue on jbpm_variableaccess table by Sahil on 08-19-2010
          vsql := 'ALTER TABLE '||vschema||'.jbpm_variableaccess ADD (initialvalue VARCHAR2(1024))';
          CREATEOBJECT(vsql,'Unable to add new column INITIALVALUE in jbpm_variableaccess','Y');
	        
          -- created table PMM_PARTNER_USERS by Vijay Silva dated 08-19-2010
          vsql := ' CREATE TABLE '||vschema||'.PMM_PARTNER_USERS (
                    ID            NUMBER(10) NOT NULL,
                    PARTNER_ID    NUMBER(10) NOT NULL,
                    USERNAME      VARCHAR2(100) NOT NULL,
                    CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                    UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT    PK_PMM_PARTNER_USERS_ID PRIMARY KEY (ID),
                    CONSTRAINT    FK_PMMPTNRUSRS_PMMPARTNER FOREIGN KEY (PARTNER_ID) REFERENCES '||vschema||'.PMM_PARTNER(ID_))';  
                    
          CREATEOBJECT(vsql,'Unable to create table PMM_PARTNER_USERS','Y');
          CREATESEQ('PMM_PARTNER_USERS');
          CREATEUPDATETRG('PMM_PARTNER_USERS');
          
          -- added a new column THUMBNAIL to the PMM_PARTNER table by Vijay on 08-19-2010
          vsql := 'ALTER TABLE '||vschema||'.PMM_PARTNER ADD (THUMBNAIL BLOB)';
          CREATEOBJECT(vsql,'Unable to add new column THUMBNAIL in PMM_PARTNER','Y');
          
          -- Created a new table SITES_EXPORT_CONF_PARAMS per request from Raj on 08-19-2010
          vsql := 'CREATE TABLE '||vschema||'.SITES_EXPORT_CONF_PARAMS (
                      SITEID NUMBER NOT NULL ,
                      NAME VARCHAR2(255) NOT NULL ,
                      VALUE VARCHAR2(255),
                      CONSTRAINT PK_SITES_EXPORT_CONF_PARAMS PRIMARY KEY (SITEID, NAME),
                      CONSTRAINT FK_SITES_EXPORT_CONF_PARAMS_SI FOREIGN KEY (SITEID) 
                      REFERENCES '||vschema||'.SITES_SITE (ID_))';
          CREATEOBJECT(vsql,'Unable to create table SITES_EXPORT_CONF_PARAMS','Y');
          
          -- Altered the table SITES_SITE to add new column EXPORT_PLUGIN_NAME per request from Raj on 08-19-2010
          vsql := 'ALTER TABLE '||vschema||'.SITES_SITE ADD (EXPORT_PLUGIN_NAME VARCHAR2(255))';
          CREATEOBJECT(vsql,'Unable to add new column EXPORT_PLUGIN_NAME in SITES_SITE','Y');
                  
          -- Created a unique key index on PMM_PARTNER_USERS(PARTNER_ID,USERNAME) for Vijay on 08-20-2010
          vsql := 'CREATE UNIQUE INDEX '||vschema||'.IDX_UNQ_PMM_PARTNER_USERS_NAME ON '||vschema||'.PMM_PARTNER_USERS(PARTNER_ID,USERNAME)';
          CREATEOBJECT(vsql,'Unable to create index PMM_PARTNER_USERS(PARTNER_ID,USERNAME)','Y');	
                
          --  created tables CMS_ASSETLIST,CMS_ASSETLIST_ASSET_MAP  by Patrik dated 08-23-2010
          vsql := ' CREATE TABLE '||vschema||'.CMS_ASSETLIST 
                    (	ID            NUMBER, 
                      NAME          VARCHAR2(50), 
                      CONTENT_CLASS NUMBER, 
                      DESCRIPTION   VARCHAR2(255), 
                      TYPE          VARCHAR2(50), 
                      CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                      UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_CMS_ASSETLIST_ID PRIMARY KEY (ID),
                      CONSTRAINT FK_CONTENTCLASS_ASSETLIST_ID FOREIGN KEY (CONTENT_CLASS)
                            REFERENCES '||vschema||'.PMM_CONTENT_CLASS(ID))';
                
          CREATEOBJECT(vsql,'Unable to create table CMS_ASSETLIST','Y');
          CREATESEQ('CMS_ASSETLIST');
          CREATEUPDATETRG('CMS_ASSETLIST');
    
          vsql := ' CREATE TABLE '||vschema||'.CMS_ASSETLIST_ASSET_MAP 
                   (	ID            NUMBER, 
                      ASSETLIST_ID  NUMBER, 
                      TITLE_ID      NUMBER, 
                      ASSET_ID      NUMBER, 
                      ORDER_        NUMBER DEFAULT 0 NOT NULL ENABLE,
                      CREATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                      UPDATEDATE    TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_CMS_ASSETLIST_ASSET_MAP_ID PRIMARY KEY (ID),
                      CONSTRAINT FK_ASSETLIST_MAP_TITLE_ID FOREIGN KEY (TITLE_ID) REFERENCES '||vschema||'.PMM_TITLE (ID_),             
                      CONSTRAINT FK_CMS_ASSETLIST_ASSET_MAP_ID FOREIGN KEY (ASSETLIST_ID) REFERENCES '||vschema||'.CMS_ASSETLIST (ID), 
                      CONSTRAINT UNQ_ASSET_MAP_ASSET_TITLE_ID UNIQUE (ASSET_ID, TITLE_ID))';            
    
          CREATEOBJECT(vsql,'Unable to create table CMS_ASSETLIST_ASSET_MAP','Y');
          CREATESEQ('CMS_ASSETLIST_ASSET_MAP');
          CREATEUPDATETRG('CMS_ASSETLIST_ASSET_MAP');
      
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.1''     WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.1.0.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.0 to 3.1.'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO bypass_install; 
          END;

      END IF;
/*
    --------------------------------------------------------------------------------------
            Start of Convert release 3.1.0.0 (CMS 1.5.000.382) to 3.2.0.0(CMS 1.5.000.387)
    --------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.1' THEN 
        
          -- created table PMM_TITLEASSET_PROPERTY by Gunnar dated 08-26-2010
          vsql := 'CREATE TABLE '||vschema||'.PMM_TITLEASSET_PROPERTY (
                      ID_         NUMBER,
                      TITLEID     NUMBER,
                      ASSETID     NUMBER,
                      NAME        VARCHAR(100),
                      VALUE       VARCHAR(256),
                      VALUE_UPDATE_DATE TIMESTAMP,
                      CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                      UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                      CONSTRAINT PK_PMM_TITLEASSET_PROPERTY_ID PRIMARY KEY (ID_),
                      CONSTRAINT FK_PMM_TITLEASSET_PROP_TITLEID FOREIGN KEY (TITLEID) REFERENCES '||vschema||'.PMM_TITLE(ID_),
                      CONSTRAINT FK_PMM_TITLEASSET_PROP_ASSETID FOREIGN KEY (ASSETID) REFERENCES '||vschema||'.MDM_ASSET(ID),
                      CONSTRAINT UNQ_PMM_TITLEASSET_PROPERTY UNIQUE (TITLEID, ASSETID, NAME, VALUE))';  
                      
          CREATEOBJECT(vsql,'Unable to create table PMM_TITLEASSET_PROPERTY','Y');
          CREATESEQ('PMM_TITLEASSET_PROPERTY');
          CREATEUPDATETRG('PMM_TITLEASSET_PROPERTY'); 
 
          -- Added a new column RETIREMENT_DATE to the table PMM_TITLE by Gunnar dated 08-26-2010
          vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD (RETIREMENT_DATE TIMESTAMP)';
          CREATEOBJECT(vsql,'Unable to add new column RETIREMENT_DATE in PMM_TITLE','Y');          

          -- created table PMM_TITLE_RESOURCE by Vijay dated 08-31-2010
          vsql := 'CREATE TABLE WFS.PMM_TITLE_RESOURCE(
          ID_                   NUMBER,
          TITLEID               NUMBER NOT NULL, 
          RESOURCE_PATH         VARCHAR2(256) NOT NULL, 
          CREATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_PMM_TITLE_RESOURCE_ID PRIMARY KEY (ID_))';  
    
          CREATEOBJECT(vsql,'Unable to create table PMM_TITLE_RESOURCE','Y');
          CREATESEQ('PMM_TITLE_RESOURCE');
          CREATEUPDATETRG('PMM_TITLE_RESOURCE'); 

          -- Kinjal requested for "admin" record on 09-01-2010 in the pmm_partner_users table.          
          vsql:='MERGE INTO '||vschema||'.PMM_PARTNER_USERS a USING (SELECT id_ FROM '||vschema||'.pmm_partner WHERE providerid=''TTV.COM'') b '||
                'ON (a.partner_id = b.id_ and a.username = ''admin'') WHEN NOT MATCHED THEN INSERT(partner_id,username) VALUES (b.id_,''admin'')';
          CREATEOBJECT(vsql,'Unable to insert the admin record in wfs.pmm_partner_users table','Y');
          
          -- Eugene request on 09-09-2010 to increase the column width in PMM_CONTENT_CLASS
          vsql := 'ALTER TABLE '||vschema||'.PMM_CONTENT_CLASS MODIFY(DESCRIPTION VARCHAR2(255))';
          CREATEOBJECT(vsql,'Unable to increase the PMM_CONTENT_CLASS table DESCRIPTION column','Y');

          -- Created history table and Trigger for the Title Purge report by Suresh Neravati 09-09-2010
          vsql := 'CREATE TABLE '||vschema||'.PMM_TITLE_PURGE_HISTORY (
                        ID_                   NUMBER,        
                        TITLE_ID              NUMBER   NOT NULL,
                        PROVIDER_ID           VARCHAR2(25) NOT NULL,
                        PROVIDER_NAME         VARCHAR2(25) NOT NULL,
                        TITLE_RETIREMENT_DATE TIMESTAMP,
                        TITLE_BRIEF           VARCHAR2(2000),          
                        PACKAGE_ASSET_ID      VARCHAR2(2000),
                        ASSET_NAME            VARCHAR2(2000),
                        LICENSE_START         DATE,
                        LICENSE_END           DATE,
                        CREATEDATE        	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        UPDATEDATE        	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        CONSTRAINT PK_PMM_TITLE_PURGE_HIST_ID PRIMARY KEY (ID_))';

          CREATEOBJECT(vsql,'Unable to create table PMM_TITLE_PURGE_HISTORY','Y');
          CREATESEQ('PMM_TITLE_PURGE_HISTORY');
          CREATEUPDATETRG('PMM_TITLE_PURGE_HISTORY'); 
          
          -- Trigger created on PMM_Title table for Purge Report by Suresh Neravati on 09-09-2010
          vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.PMM_TITLE_PURGE_INSERTTRG'|| 
                  ' AFTER UPDATE OR INSERT ON '||vschema||'.PMM_TITLE FOR EACH ROW'|| 
                  ' BEGIN'|| 
                     ' IF (NVL(:NEW.RETIREMENT_DATE,(SYSTIMESTAMP-10000)) <> NVL(:OLD.RETIREMENT_DATE,(SYSTIMESTAMP-10000))'||  
                        '  AND :OLD.ORIGINALTITLE_ID IS NULL) THEN'|| 
                              ' INSERT INTO WFS.PMM_TITLE_PURGE_HISTORY (TITLE_ID, PROVIDER_ID, '|| 
                                     ' PROVIDER_NAME, TITLE_RETIREMENT_DATE, TITLE_BRIEF, '|| 
                                     ' PACKAGE_ASSET_ID, ASSET_NAME,LICENSE_START,LICENSE_END)'|| 
                              ' SELECT :NEW.ID_, P.PROVIDERID, P.NAME, :NEW.RETIREMENT_DATE,'|| 
                                     ' MAX (scf2.VALUE)      AS "Title Brief", '||  
                                     ' MAX (scf3.VALUE)      AS "Package Asset Id", '||  
                                     ' MAX (scf4.VALUE)      AS "Asset Name", '||  
                                     ' MAX (scf5.DATEVALUE)  AS "License Start", '||  
                                     ' MAX (scf6.DATEVALUE)  AS "License End" '|| 
                               ' FROM '||vschema||'.PMM_Partner P '|| 
                               ' JOIN '||vschema||'.MDM_ASSET PACKAGE_ASSET ON (:NEW.ASSET_ID = PACKAGE_ASSET.ID) '|| 
                               ' LEFT JOIN '||vschema||'.MDM_ASSET TITLE_ASSET ON (TITLE_ASSET.ROOTASSET_ID = PACKAGE_ASSET.ID AND TITLE_ASSET.TYPE =''TITLE'')'|| 
                               ' LEFT JOIN '||vschema||'.MDM_RELATION TITLE_ASSET_RELATION ON(TITLE_ASSET_RELATION.OWNING_ASSET_ID = PACKAGE_ASSET.ID AND TITLE_ASSET_RELATION.TARGET_ASSET_ID = TITLE_ASSET.ID)'|| 
                               ' LEFT JOIN '||vschema||'.MDM_FIELD scf3 ON (scf3.ASSET_ID = PACKAGE_ASSET.ID AND scf3.TTVXPATH = ''/tns:Fields/tns:Identifier/tns:Id'') '|| 
                               ' LEFT JOIN '||vschema||'.MDM_FIELD scf4 ON (scf4.ASSET_ID = PACKAGE_ASSET.ID AND scf4.TTVXPATH = ''/tns:Fields/tns:AssetName'') '|| 
                               ' LEFT JOIN '||vschema||'.MDM_FIELD scf2 ON (scf2.ASSET_ID = TITLE_ASSET.ID AND scf2.TTVXPATH = ''/tns:Fields/tns:Title/tns:ShortTitle/tns:Value'') '|| 
                               ' LEFT JOIN '||vschema||'.MDM_FIELD scf5 ON (scf5.ASSET_ID = TITLE_ASSET.ID AND scf5.TTVXPATH = ''/tns:Fields/tns:Rights/tns:LicensingWindowStart'') '|| 
                               ' LEFT JOIN '||vschema||'.MDM_FIELD scf6 ON (SCF6.ASSET_ID = TITLE_ASSET.ID AND SCF6.TTVXPATH = ''/tns:Fields/tns:Rights/tns:LicensingWindowEnd'') '|| 
                              ' WHERE (TITLE_ASSET_RELATION.DELETEREVISION IS NULL OR TITLE_ASSET_RELATION.DELETEREVISION = 0)'|| 
                                ' AND P.ID_ = :NEW.PARTNER_ID '|| 
                              ' GROUP BY :NEW.ID_, P.PROVIDERID, P.NAME, :NEW.RETIREMENT_DATE;'|| 
                     ' END IF;'|| 
                   ' END;';
          CREATEOBJECT(vsql,'Unable to create trigger PMM_TITLE_PURGE_INSERTTRG','Y');  
          
          -- Patrik request for creating two tables CMS_ASSETLIST_METADATA and CMS_ASSETLIST_ASSET_METADATA on 09-09-2010.
          vsql := 'CREATE TABLE WFS.CMS_ASSETLIST_METADATA 
                     (	ASSETLIST_ID  NUMBER, 
                        NAME          VARCHAR2(50) NOT NULL, 
                        INTEGER_VALUE NUMBER, 
                        FLOAT_VALUE   NUMBER, 
                        STRING_VALUE  VARCHAR2(50), 
                        DATE_VALUE    DATE, 
                        IMAGE_VALUE   BLOB, 
                        TIME_VALUE    VARCHAR2(20), 
                        BOOLEAN_VALUE NUMBER, 
                        DATA_TYPE     VARCHAR2(20) NOT NULL, 
                        CREATEDATE 	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        UPDATEDATE 	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        CONSTRAINT PK_CMS_ASSETLIST_METADATA PRIMARY KEY (ASSETLIST_ID, NAME),
                        CONSTRAINT FK_CMS_ASSETLIST_METADATA_CM FOREIGN KEY (ASSETLIST_ID)
                            REFERENCES WFS.CMS_ASSETLIST (ID))';

          CREATEOBJECT(vsql,'Unable to create table CMS_ASSETLIST_METADATA','Y');
          CREATEUPDATETRG('CMS_ASSETLIST_METADATA');                            

          vsql := 'CREATE TABLE WFS.CMS_ASSETLIST_ASSET_METADATA 
                     (	ASSETLIST_ASSETMAP_ID NUMBER, 
                        NAME                  VARCHAR2(50) NOT NULL, 
                        STRING_VALUE          VARCHAR2(255), 
                        IMAGE_VALUE           BLOB, 
                        DATA_TYPE             VARCHAR2(20) NOT NULL ENABLE, 
                        CREATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        UPDATEDATE 	          TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        CONSTRAINT PK_CMS_ASSETLIST_ASSET_METAD PRIMARY KEY (ASSETLIST_ASSETMAP_ID, NAME),
                        CONSTRAINT FK_CMS_ASSETLIST_ASSET_METAD FOREIGN KEY (ASSETLIST_ASSETMAP_ID)
                            REFERENCES WFS.CMS_ASSETLIST_ASSET_MAP (ID))';
                            
          CREATEOBJECT(vsql,'Unable to create table CMS_ASSETLIST_ASSET_METADATA','Y');
          CREATEUPDATETRG('CMS_ASSETLIST_ASSET_METADATA'); 
             
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2''     WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.0.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.1 to 3.2.'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO bypass_install; 
          END;
  
        END IF;
/*
    --------------------------------------------------------------------------------------
            Start of Convert release 3.2.0.0 (CMS 1.5.000.387) to 3.2.1.0(CMS 1.5.000.389)
    --------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF WK_RELEASE =  '3.2' THEN 
        
          -- Patrik quested to alter the constraint on CMS_ASSETLIST_ASSET_MAP table on 09-14-2010
          vsql := 'ALTER TABLE '||vschema||'.CMS_ASSETLIST_ASSET_MAP DROP  CONSTRAINT UNQ_ASSET_MAP_ASSET_TITLE_ID';
          CREATEOBJECT(vsql,'Unable to drop constraint UNQ_ASSET_MAP_ASSET_TITLE_ID','Y');
          vsql := 'ALTER TABLE '||vschema||'.CMS_ASSETLIST_ASSET_MAP ADD  CONSTRAINT UNQ_ASSET_MAP_ASSET_TITLE_ID UNIQUE (ASSETLIST_ID, ASSET_ID, TITLE_ID)';
          CREATEOBJECT(vsql,'Unable to add constraint UNQ_ASSET_MAP_ASSET_TITLE_ID with three columns','Y');
          
          -- Vijay requested to add a new record "DELETE" in PMM_TitleStatus table on 09-23-2010
          EXECUTE IMMEDIATE 'INSERT INTO '||vschema||'.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate) VALUES (5,''DELETED'',sysdate, sysdate)';

          -- Daniel request for blob changes on 09-23-2010
          vsql := 'ALTER TABLE '||vschema||'.TRE_ACTIONPARAMETERVALUE DROP (ISLITERAL)';
          createobject(vsql,'Unable to drop column ISLITERAL in TRE_ACTIONPARAMETERVALUE','Y');   

          vsql := 'UPDATE '||vschema||'.TRE_PREDICATE SET FIELDLEFTSECTIONTYPE = ''PACKAGE/''||FIELDLEFTSECTIONTYPE WHERE FIELDLEFTSECTIONTYPE <> ''PMM_TITLE'' AND FIELDLEFTSECTIONTYPE NOT LIKE ''PACKAGE%''';
          createobject(vsql,'Unable to update FIELDLEFTSECTIONTYPE data in TRE_PREDICATE table','Y');   
          
          vsql := 'UPDATE '||vschema||'.TRE_PREDICATE SET FIELDLEFT = ''PACKAGE/''||FIELDLEFT WHERE FIELDLEFTSECTIONTYPE <> ''PMM_TITLE'' AND FIELDLEFT NOT LIKE ''PACKAGE%'' AND FIELDLEFT NOT LIKE ''/%''';
          createobject(vsql,'Unable to update FIELDLEFT data in TRE_PREDICATE table','Y');            

          vsql := 'UPDATE '||vschema||'.TRE_ACTIONPARAMETERVALUE SET VALUE = ''PACKAGE/''||VALUE WHERE NAME IN (''sectionType'', ''rootxpath'', ''xpath'') '||
                      'AND VALUE IS NOT NULL AND VALUE <> ''PMM_TITLE'' and VALUE not in (''id'', ''status'', ''contentClassId'') AND VALUE NOT LIKE ''PACKAGE%'' AND VALUE NOT LIKE ''/%''';
          createobject(vsql,'Unable to update VALUE data in TRE_ACTIONPARAMETERVALUE table','Y');   
          
          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.change(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.change(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   
          
          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.insertAfter(String, String, String, Boolean, String, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.InsertAfter(String, String, String, Boolean, GenericType, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   
          
          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.multiply(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.multiply(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier2(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier2(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.round(String, String, String, Boolean, Long, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.round(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.prefix(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.prefix(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.removeFirstXChars(String, String, String, Boolean, Long, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.removeFirstXChars(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier4(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier4(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.insertBefore(String, String, String, Boolean, String, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.InsertBefore(String, String, String, Boolean, GenericType, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.removeAfter(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.RemoveAfter(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.removeBefore(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.RemoveBefore(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.append(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.append(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');  

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.add(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.add(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.divide(String, String, String, Boolean, GenericType, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.divide(String, String, String, Boolean, String, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');  

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.subtract(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.subtract(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier3(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier3(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.replace(String, String, String, Boolean, String, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.replace(String, String, String, Boolean, GenericType, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.addTop(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.AddTop(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');  

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.removeLastXChars(String, String, String, Boolean, Long, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.removeLastXChars(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.addChild(String, String, String, Boolean, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.AddChild(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier1(String, String, String, Boolean, GenericType, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceTier1(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.truncate(String, String, String, Boolean, Long, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.truncate(String, String, String, Boolean, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action SET METHOD   = ''com.tandbergtv.marvin.actions.NormalizationActions.replaceAfter(String, String, String, Boolean, String, String, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.ReplaceAfter(String, String, String, Boolean, GenericType, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');   

          vsql := 'UPDATE '||vschema||'.Tre_Action set method   = ''com.tandbergtv.marvin.actions.normalizationactions.replacebefore(string, string, string, boolean, string, string, evaluatorresults, title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.ReplaceBefore(String, String, String, Boolean, GenericType, GenericType, EvaluatorResults, Title)''';
          createobject(vsql,'Unable to update METHOD data in Tre_Action table','Y');             

          -- Updating the Title records for DELETE status by Vijay on 09-23-2010
          vsql := 'update '||vschema||'.pmm_title set titlestatusid = 5 where id_ in (select title.id_ from '||vschema||'.pmm_title title join '||vschema||'.mdm_asset asset'|| 
                  ' on title.asset_id = asset.id where asset.state = 0)';
          createobject(vsql,'Unable to update titlestatusid in pmm_title table','Y');  
          
          begin
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.1''     WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.1.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2 to 3.2.1'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              goto bypass_install; 
          END;
  
        END IF;        
/*
    --------------------------------------------------------------------------------------
            Start of Convert release 3.2.1.0 (CMS 1.5.000.389) to 3.2.2.0(CMS 1.5.010.395)
    --------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF WK_RELEASE =  '3.2.1' THEN 

          -- Added additional datafile to the tablespace WFS_DATA by Suresh on 10-14-2010
          vsql :='ALTER TABLESPACE wfs_data ADD DATAFILE SIZE 100M AUTOEXTEND ON NEXT 200M MAXSIZE unlimited';
          CREATEOBJECT(VSQL,'ALTER TABLESPACE WFS_data');
 
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.2''     WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.2.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.1 to 3.2.2'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO bypass_install; 
          END;  
          
        END IF;

/*
    --------------------------------------------------------------------------------------
            Start of Convert release 3.2.2.0(CMS 1.5.010.395) to 3.2.3.0(CMS 1.5.010.397)
    --------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF WK_RELEASE =  '3.2.2' THEN 

          -- Adding user records for self partner in pmm_partner_users table per Kinjal on 10-21-2010
          vsql :='insert into '||vschema||'.pmm_partner_users (partner_id, username) '||
                 'select p.id_, u.username from '||vschema||'.cms_user u,  '||vschema||'.pmm_partner p where p. partnertype=0 and username<>''admin''';
          CREATEOBJECT(VSQL,'Unable to create user records for self partner in pmm_partner_users','Y');
          
          begin
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.3''     WHERE setting_type = ''RELEASE''';  
            execute immediate 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.3.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.2 to 3.2.3'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO bypass_install; 
          END;  
          
        END IF;        
        
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.3.0 (CMS 1.5.010.397) to 3.2.4.0(CMS 1.5.010.398)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        if wk_release =  '3.2.3' then 
          begin
             EXECUTE IMMEDIATE 'DELETE FROM WFS.PMM_PARTNER_USERS WHERE PARTNER_ID NOT IN (SELECT ID_ FROM WFS.PMM_PARTNER)';
          
             BEGIN
                 EXECUTE IMMEDIATE 'ALTER TABLE '||vschema||'.PMM_PARTNER_USERS ADD CONSTRAINT FK_PMMPTNRUSRS_PMMPARTNER '|| 
                 'FOREIGN KEY (PARTNER_ID) REFERENCES WFS.PMM_PARTNER(ID_)';
             EXCEPTION
                WHEN others THEN
                  NULL;
             end;
             -- Changed the code to fix the PMM_partner_Users id issue by Suresh Dt.11-12-2010.
             vsql := 'MERGE INTO '||vschema||'.PMM_PARTNER_USERS a USING (SELECT id_ FROM '||vschema||'.pmm_partner WHERE providerid=''TTV.COM'') b'||
             ' ON (a.partner_id = b.id_ and a.username = ''admin'') WHEN NOT MATCHED THEN INSERT(partner_id,username) VALUES (b.id_,''admin'')';
             createobject(vsql,'Unable to create the record in PMM_PARTNER_USERS table','Y');  
             
             COMMIT;          
          exception
              when others then
                 execute immediate 'INSERT INTO install_table(install_message) values(''Error '''||SUBSTR(SQLERRM, 1, 200)||''')'; 
          end;
          
          begin
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.4''     WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.4.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.3.0 to 3.2.4.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;

        end if;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.4.0 (CMS 1.5.010.398) to 3.2.5.0(CMS 2.0.000.2)
            Backport for ATT upgrade from CMS 1.2 -> CMS 2.0. Masking all errors!
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        if wk_release =  '3.2.4' then 
          begin
            vsql := 'DROP INDEX '||vschema||'.mdm_FIELDVAL_IND';
            CREATEOBJECT(vsql,'Unable to drop index mdm_FIELDVAL_IND','Y');

            vsql := 'DROP INDEX '||vschema||'.mdm_FIELDXPATH_IND';
            CREATEOBJECT(vsql,'Unable to drop index mdm_FIELDXPATH_IND','Y');

            vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHVALUEAST_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","VALUE","ASSET_ID")';
            CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHVALUEAST_IND','Y');
            
            vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHINTASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","INTVALUE","ASSET_ID")';
            CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHINTASSET_IND','Y');
            
            vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHDTASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","DATEVALUE","ASSET_ID")';
            CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHDTASSET_IND','Y');
      
            vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHFLOATASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","FLOATVALUE","ASSET_ID")';
            CREATEOBJECT(vsql,'Unable to create index MDMFLD_XPATHFLOATASSET_IND','Y');
      
            vsql := 'CREATE INDEX '||vschema||'.MDMFLD_XPATHPARSASSET_IND ON '||vschema||'.MDM_FIELD("TTVXPATH","PARSABLE","ASSET_ID")';
            CREATEOBJECT(VSQL,'Unable to create index MDMFLD_XPATHPARSASSET_IND','Y');
 
             
            VSQL := 'ALTER TABLE WPTB.TB_LOCK MODIFY (OWNERID	VARCHAR2(4000))';
            CREATEOBJECT(VSQL,'Unable to ALTER OWNERID COLUMN IN TB_LOCK TABLE','Y');  
            

            VSQL := 'INSERT INTO WPTB.TB_ADAPTORTYPE (ADAPTORTYPEID, NAME) VALUES(0, ''NONE'')';
            CREATEOBJECT(vsql,'Unable to insert into TB_ADAPTORTYPE','Y');
      
            VSQL := 'INSERT INTO WPTB.TB_ADAPTORTYPE (ADAPTORTYPEID, NAME) VALUES(1, ''DEFAULT'')';
            CREATEOBJECT(vsql,'Unable to insert into TB_ADAPTORTYPE','Y');

            vsql := 'INSERT INTO WPTB.TB_ADAPTORTYPE (ADAPTORTYPEID, NAME) VALUES(2, ''CUSTOM'')';
            createobject(vsql,'Unable to insert into TB_ADAPTORTYPE','Y');
            
 
            /* Vijay: 12/17/10: CMS_LOOKUP_KEY and CMS_LOOKUP_KEY_ASSET_TYPE tables */
            vsql := 'CREATE TABLE '||vschema||'.CMS_LOOKUP_KEY
                      (
                        "ID"          NUMBER NOT NULL ,
                        "NAME"        VARCHAR2(50) NOT NULL,
                        "DESCRIPTION" VARCHAR2(255),
                        PRIMARY KEY ("ID"),
                        CONSTRAINT "CMS_LOOKUPKEY_NAME_UNIQ" UNIQUE("NAME")
                      )';
           CREATEOBJECT(VSQL,'Unable to create table CMS_LOOKUP_KEY','Y');
           CREATESEQ('CMS_LOOKUP_KEY');
          
           vsql := 'CREATE TABLE '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE
                    (
                      "ID_LOOKUP_KEY" NUMBER NOT NULL,
                      "ASSET_TYPE"    VARCHAR2(50) NOT NULL,
                      PRIMARY KEY ("ID_LOOKUP_KEY", "ASSET_TYPE"),
                      CONSTRAINT CMS_LOOKUP_KEY_ASSET_TYPE FOREIGN KEY("ID_LOOKUP_KEY") REFERENCES '||vschema||'.CMS_LOOKUP_KEY ("ID")
                    )';
           CREATEOBJECT(VSQL,'Unable to create table CMS_LOOKUP_KEY_ASSET_TYPE','Y');      

           -- Sanjay: 01/07/2011 added a new record for Prioritization in tre_package table.
            vsql := 'INSERT INTO '||vschema||'.TRE_PACKAGE (PACKAGEID, N_VERSION, NAME) VALUES (5, 1, ''PRIORITIZATION'')';
            CREATEOBJECT(VSQL,'Unable to INSERT A PRIORITIZATION record in TRE_PACKAGE','Y');

          -- Added a new table CMS_USER_PREFERENCES and also an index UQ_CMS_USER_PREF by Daniel on 01/13/2011.
          vsql := 'CREATE TABLE '||vschema||'.CMS_USER_PREFERENCES
                      ( ID          NUMBER, 
                        USERNAME    VARCHAR2(100) NOT NULL, 
                        COMPONENT   VARCHAR2(100) NOT NULL,
                        TYPE        VARCHAR2(100) NOT NULL, 
                        KEY         VARCHAR2(500) NOT NULL, 
                        VALUE       VARCHAR2(500),
                        CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                        CONSTRAINT PK_CMS_USER_PREFERENCES PRIMARY KEY (ID)
                      )';
          CREATEOBJECT(vsql,'Unable to create table CMS_USER_PREFERENCES','Y');
          CREATESEQ('CMS_USER_PREFERENCES'); 
          CREATEUPDATETRG('CMS_USER_PREFERENCES');
          
          vsql := 'CREATE UNIQUE INDEX '||vschema||'.UQ_CMS_USER_PREF ON '||vschema||'.CMS_USER_PREFERENCES (USERNAME, COMPONENT, TYPE, KEY)';
          CREATEOBJECT(vsql,'Unable to create index UQ_CMS_USER_PREF','Y');

          -- Raj created new tables on 02/11/2011 for Job Schedule module.
          CreateJobSchedule;

          -- Changing all the BYTES from VARCHAR2 datatype By Suresh 02-23-2011
          vsql := 'DECLARE '||
            'cursor c1 is select ''alter table '||vschema||'.''||dt.table_name||'' modify (''||dtc.column_name||'' ''||dtc.data_type||''(''||dtc.data_length||''))'' as myvar '||
                           'from dba_tab_columns dtc, dba_tables dt '||
                          'where dtc.table_name = dt.table_name  '||
                            'and dt.owner=''WFS''  '||
                            'and dtc.data_Type=''VARCHAR2''  '||
                            'and dtc.char_used=''B'' '||
                            'and dtc.owner=dt.owner '||
                            'and dtc.table_name not like ''%$CTX%'' '||
                            'and (dt.table_name,dtc.column_name) not in (select table_name,column_name from dba_indexes where owner=''WFS'' and index_type!=''NORMAL''); '||
          'begin '||
          '  for r1 in c1 loop '||
          '    BEGIN '||
          '      execute immediate r1.myvar; '||
          '    exception '||
          '      when others then null; '||
          '    end; '||
          '  END loop; '||
          'end; ';
          CREATEOBJECT(vsql,'Unable to change the BYTES from VARCHAR2','Y'); 

          -- on 03-02-2011 Suneeta added a new column includeCount to the tre_titlesearch table.
          vsql := 'ALTER TABLE '||vschema||'.tre_titlesearch ADD includeCount NUMBER(1) DEFAULT(0) NOT NULL';
          CREATEOBJECT(vsql,'Unable to alter table'||vschema||'.tre_titlesearch','Y');

          -- Suresh Altered the pmm_properties.value to varchar2(4000) on 03-03-2011
          VSQL := 'alter table '||vschema||'.pmm_properties modify (value  VARCHAR2(4000))';
          CREATEOBJECT(VSQL,'Unable to alter the column '||VSCHEMA||'.pmm_properties.value width','Y');
          
          -- Suneeta Added a new table TITLE_SEARCH_RESULTS_COL on 03-07-2011
          vsql := 'CREATE TABLE '||vschema||'.TITLE_SEARCH_RESULTS_COL (
                    id          NUMBER NOT NULL, 
                    name        VARCHAR2(2000) NOT NULL, 
                    order_      NUMBER NOT NULL, 
                    searchId    NUMBER NOT NULL,
                    createdate  DATE default (SYSDATE), 
                    updatedate  DATE default (SYSDATE),                 
                    CONSTRAINT PK_SEARCH_RESULTS_ID PRIMARY KEY (ID),
                    CONSTRAINT FK_SEARCH_RESULTS_SEARCH_ID FOREIGN KEY (searchId) REFERENCES '||vschema||'.TRE_TITLESEARCH (TITLESEARCHID)
                  )';
          CREATEOBJECT(vsql,'Unable to create table TITLE_SEARCH_RESULTS_COL','Y');
          createseq('TITLE_SEARCH_RESULTS_COL');
          CREATEUPDATETRG('TITLE_SEARCH_RESULTS_COL');

          -- Suneeta Added two new coluimns to table tre_titlesearch on 03-07-2011
          VSQL := 'alter table '||VSCHEMA||'.tre_titlesearch add ( sortorder number default 0, sort_col_name VARCHAR2(2000) default ''id'')';
          CREATEOBJECT(vsql,'Unable to alter table'||vschema||'.tre_titlesearch','Y');
          
          END;
          begin
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.5''     WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.5.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.4.0 to 3.2.5.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;

       end if;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.5.0 (CMS 2.0.010.2) to 3.2.6.0(CMS 2.0.000.28)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        if wk_release =  '3.2.5' then 
          BEGIN

            -- Suneeta dropped three coluimns from table tre_titlesearch and added includecount column to tre_titlefilter on 03-17-2011
            VSQL := 'alter table '||VSCHEMA||'.tre_titlesearch drop (sortorder, sort_col_name, includecount)';
            CREATEOBJECT(vsql,'Unable to alter table'||vschema||'.tre_titlesearch to drop three columns','Y');
            
            VSQL := 'alter table '||VSCHEMA||'.tre_titlefilter add (includecount number(1) default 0)';
            CREATEOBJECT(vsql,'Unable to alter table'||vschema||'.tre_titlefilter for add includecount column','Y');
  
            -- Kinjal request to drop constraint on cms_assetlist_asset_map and adding a List value record in TTV_DATATYPE  on 03-22-2011
            VSQL := 'alter table '||VSCHEMA||'.cms_assetlist_asset_map drop constraint FK_MDMASSET_ASSETMAP_ASSET_ID';
            CREATEOBJECT(vsql,'Unable to alter table'||vschema||'.cms_assetlist_asset_map to drop constraint','Y');  
            
            VSQL := 'insert into '||VSCHEMA||'.TTV_DATATYPE (DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE) values (9, ''list'', sysdate, sysdate)';          
            CREATEOBJECT(vsql,'Unable to insert LIST record into table'||vschema||'.TTV_DATATYPE','Y'); 
  
            -- Suresh Neravati added XMLDB script and recreated the Title Purge Trigger with XML query on 03/23/2011
            vsql := 'GRANT CREATE ANY DIRECTORY, ALTER SESSION TO WFS';
            CREATEOBJECT(vsql,'Unable to grant create any directory, alter session to wfs','Y'); 
      
            vsql := 'DROP DIRECTORY ECMFXMLDIR';
            CREATEOBJECT(vsql,'Unable to DROP DIRECTORY ECMFXMLDIR','Y');
            
            vsql := 'CREATE DIRECTORY ECMFXMLDIR AS ''/home/oracle/ecmf''';
            CREATEOBJECT(vsql,'Unable to grant create directory ECMFXMLDIR','Y');
            
            vsql := 'GRANT ALL ON DIRECTORY ECMFXMLDIR TO WFS';
            CREATEOBJECT(VSQL,'Unable to grant all on directory ecmfxmldir to wfs','Y'); 
            
            VSQL := 'ALTER TABLE '||VSCHEMA||'.pmm_title add (mdmdocid number)';
            CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.pmm_title to add mdmdocid column','Y');
            
            vsql := 'ALTER TABLE '||vschema||'.pmm_title drop constraint pmm_title_asset';
            CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.pmm_title disable constraint pmm_title_asset','Y');
      
            VSQL := 'ALTER TABLE '||VSCHEMA||'.mdm_rootassetrevision drop constraint fk_rootassetrevision_asset_id';
            CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.mdm_rootassetrevision disable constraint fk_rootassetrevision_asset_id','Y');
      
            vsql := 'ALTER TABLE '||vschema||'.pmm_titleasset_property drop constraint fk_pmm_titleasset_prop_assetid';
            CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.pmm_titleasset_property disable constraint fk_pmm_titleasset_prop_assetid','Y');
      
            VSQL := 'ALTER TABLE '||VSCHEMA||'.tre_titlefilter add (sortfieldtype number)';
            CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.tre_titlefilter add sortfieldtype number','Y');
      
            VSQL := 'ALTER TABLE '||VSCHEMA||'.tre_titlefilter DROP (issortfieldmetadata, isinternalsearch, issearchfieldmetadata, searchproperty, externalinstanceid)';
            CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||VSCHEMA||'.tre_titlefilter to DROP five columns','Y');

            CreateMETADATAMANAGER_XML;

            -- Raj added a new table SCH_PASTEXECUTION on 03/24/2011
            VSQL := 'CREATE TABLE '||VSCHEMA||'.SCH_PASTEXECUTION  (
                            id             NUMBER NOT NULL,
                            job_id         NUMBER NOT NULL,
                            execution_time TIMESTAMP NOT NULL,
                            enabled        number(1,0) not null,
                            createdate  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                            updatedate  TIMESTAMP DEFAULT (SYSTIMESTAMP) NOT NULL,
                            CONSTRAINT sch_history_pk PRIMARY KEY (id),
                            CONSTRAINT fk_sch_history_sch_job FOREIGN KEY (job_id) REFERENCES '||VSCHEMA||'.sch_job (ID))';
            CREATEOBJECT(vsql,'Unable to create table sch_pastexecution','Y');
            CREATESEQ('SCH_PASTEXECUTION');
            CREATEUPDATETRG('SCH_PASTEXECUTION');
            
            VSQL := 'CREATE INDEX '||VSCHEMA||'.SCH_PASTEXECUTION_TIME_IND ON '||VSCHEMA||'.SCH_PASTEXECUTION(EXECUTION_TIME)';
            CREATEOBJECT(vsql,'Unable to create index SCH_PASTEXECUTION_TIME_IND','Y');

            -- Sanjay added a new table SCH_JOB_DISABLED_TIMES on 03/30/2011
            vsql := 'CREATE TABLE '||VSCHEMA||'.SCH_JOB_DISABLED_TIMES (
                            JOB_ID        NUMBER NOT NULL,
                            DISABLED_TIME NUMBER NOT NULL,
                            CREATEDATE    TIMESTAMP (6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                            UPDATEDATE    TIMESTAMP (6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                            CONSTRAINT PK_SCH_JOB_DISABLED_TIMES PRIMARY KEY (JOB_ID, DISABLED_TIME),
                            CONSTRAINT FK_SCH_JOB_DISABLED_SCH_JOB FOREIGN KEY (JOB_ID) REFERENCES '||VSCHEMA||'.SCH_JOB(ID))';
            CREATEOBJECT(VSQL,'Unable to create table SCH_JOB_DISABLED_TIMES','Y');
            CREATEUPDATETRG('SCH_JOB_DISABLED_TIMES');
    
            -- Kinjal added insert records for CMS_LOOKUP_KEY and CMS_LOOKUP_KEY_ASSET_TYPE tables on 03/31/2011.
          BEGIN
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY (NAME, DESCRIPTION) VALUES (''ORIGINAL'',''ORIGINAL'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY'); 
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''PACKAGE'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record PACKAGE','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''TITLE'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record TITLE','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''MOVIE'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record MOVIE','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''PREVIEW'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record PREVIEW','Y');
      
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''POSTER'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record POSTER','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''BOXCOVER'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record BOXCOVER','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''TRICK'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record TRICK','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''ENCRYPTED'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record ENCRYPTED','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''BARKER'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record BARKER','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''MOVIESEGMENTGROUP'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record MOVIESEGMENTGROUP','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''PREVIEWSEGMENTGROUP'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record PREVIEWSEGMENTGROUP','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''DISPLAY'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record DISPLAY','Y');
            
            VSQL := 'INSERT INTO '||VSCHEMA||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||VSCHEMA||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''GAME'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record GAME','Y');
            
            VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ('||vschema||'.CMS_LOOKUP_KEY_SEQ.CURRVAL,''LOGICALCLIP'')';
            CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record LOGICALCLIP','Y');

            -- Bak added assettype column to the pmm_titleasset_property table on 04/07/2011
            VSQL := 'ALTER TABLE '||vschema||'.pmm_titleasset_property ADD assettype VARCHAR2(50)';
            CREATEOBJECT(VSQL,'Unable to alter table pmm_titleasset_property to add assettype','Y');    

            -- Suresh added index idx_pmm_title_cc on 04/07/2011    
            VSQL := 'CREATE INDEX '||vschema||'.idx_pmm_title_cc ON '||vschema||'.pmm_title(content_class_id)';
            CREATEOBJECT(VSQL,'Unable to create index PMM_Title idx_pmm_title_cc.','Y');
          
          EXCEPTION
            WHEN OTHERS THEN NULL;
          END; 
           
          END;
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.6''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.6.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.5.0 to 3.2.6.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;

       end if;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.6.0 (CMS 2.0.000.28) to 3.2.7.0(CMS 2.0.000.30)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        if wk_release =  '3.2.6' then 
          begin
            -- Eugene updating the asset_type of pmm_titleasset_property from mdm_asset id on 04/28/2011
            vsql := 'update wfs.pmm_titleasset_property p set p.assettype = (select a.type from wfs.mdm_asset a where a.id = p.assetid)';
            createobject(vsql,'Unable to update pmm_titleasset_property set assettype','Y');
 
            -- Suresh added index idx_pmm_title_mdmdocid on 05/04/2011    
            vsql := 'CREATE INDEX '||vschema||'.idx_pmmtitle_id_mdmid_statid ON '||vschema||'.pmm_title(mdmdocid, id_, titlestatusid, originaltitle_id)';
            createobject(vsql,'Unable to create index PMM_Title idx_pmmtitle_id_mdmid_statid.','Y');
            
            -- Daniel Weiner updated rules tables wfs.tre_predicate and wfs.tre_ActionParameterValue on 05/05/2011 for cms1.5 to cms2.0 data migration.
            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/@assetId'' WHERE fieldLeft like ''/tns:Fields/tns:TTVId%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt1','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/@assetId'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:TTVId%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt1','Y');
            
            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/BillingInfo/ProviderId/Id'' WHERE fieldLeft = ''/tns:Fields/tns:BillingInfo/tns:QuoteProviderId''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt2','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/BillingInfo/ProviderId/Id'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value = ''/tns:Fields/tns:BillingInfo/tns:QuoteProviderId''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt2','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Encryption/Asset/Id'' WHERE fieldLeft like ''/tns:Fields/tns:Encryption/tns:Asset/tns:Identifier%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt3','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Encryption/Asset/Id'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Encryption/tns:Asset/tns:Identifier%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt3','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rating/RatingValues/RatingValue/Value'' WHERE fieldLeft = ''/tns:Fields/tns:Rating/tns:Value''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt4','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Rating/RatingValues/RatingValue/Value'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value =  ''/tns:Fields/tns:Rating/tns:Value''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt4','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rating/RatingValues/RatingValue/Value/System'' WHERE fieldLeft = ''/tns:Fields/tns:Rating/tns:Value/@system''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt5','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Rating/RatingValues/RatingValue/ValueSystem/'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value =  ''/tns:Fields/tns:Rating/tns:Value/@system''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt5','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:SubTitleLanguage'', ''SubTitleLanguages/SubTitleLanguage'') WHERE fieldLeft like ''/tns:Fields/tns:SubTitleLanguage%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt6','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:SubTitleLanguage'', ''SubTitleLanguages/SubTitleLanguage'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:SubTitleLanguage%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt6','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Theme'', ''Themes/Theme'') WHERE fieldLeft like ''/tns:Fields/tns:CategoryTheme/tns:Theme%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt7','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Theme'', ''Themes/Theme'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:CategoryTheme/tns:Theme%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt7','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:ProviderContentTier'', ''ProviderContentTiers/ProviderContentTier'') WHERE fieldLeft like ''/tns:Fields/tns:ProviderContentTier%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt8','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:ProviderContentTier'', ''ProviderContentTiers/ProviderContentTier'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:ProviderContentTier%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt8','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Rule'', ''Rules/Rule'') WHERE fieldLeft like ''/tns:Fields/tns:Rule%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt9','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Rule'', ''Rules/Rule'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Rule%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt9','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Chapter'', ''Chapters/Chapter'') WHERE fieldLeft like ''/tns:Fields/tns:Chapter%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt10','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Chapter'', ''Chapters/Chapter'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Chapter%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt10','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:TargetAudience'', ''TargetAudiences/TargetAudience'') WHERE fieldLeft like ''/tns:Fields/tns:Rating/tns:TargetAudience%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt11','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:TargetAudience'', ''TargetAudiences/TargetAudience'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Rating/tns:TargetAudience%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt11','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate set fieldleft = replace(fieldleft, ''tns:Source'', ''Sources/Source'') where fieldleft like ''/tns:Fields/tns:CreationInfo/tns:Source%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt12','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Source'', ''Sources/Source'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:CreationInfo/tns:Source%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt12','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Label'', ''Labels/Label'') WHERE fieldLeft like ''/tns:Fields/tns:Rating/tns:Label%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt13','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Label'', ''Labels/Label'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Rating/tns:Label%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt13','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Category'', ''Categories/Category'') WHERE fieldLeft like ''/tns:Fields/tns:Category%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt14','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Category'', ''Categories/Category'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Category%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt14','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:DubbedLanguage'', ''DubbedLanguages/DubbedLanguage'') WHERE fieldLeft like ''/tns:Fields/tns:DubbedLanguage%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt15','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:DubbedLanguage'', ''DubbedLanguages/DubbedLanguage'')WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:DubbedLanguage%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt15','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Language'', ''Languages/Language'') WHERE fieldLeft like ''/tns:Fields/tns:Language%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt16','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Language'', ''Languages/Language'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Language%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt16','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Genre'', ''Genres/Genre'') WHERE fieldLeft like ''/tns:Fields/tns:Genre%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt17','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Genre'', ''Genres/Genre'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Genre%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt17','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Type'', ''Types/Type'') WHERE fieldLeft like ''/tns:Fields/tns:Audio/tns:Type%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt18','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Type'', ''Types/Type'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Audio/tns:Type%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt18','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Source'', ''Sources/Source'') WHERE fieldLeft like ''/tns:Fields/tns:Source%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt19','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Source'', ''Sources/Source'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Source%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt19','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:ContentAdvisory'', ''ContentAdvisories/ContentAdvisory'') WHERE fieldLeft like ''/tns:Fields/tns:Rating/tns:ContentAdvisory%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt20','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:ContentAdvisory'', ''ContentAdvisories/ContentAdvisory'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Rating/tns:ContentAdvisory%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt20','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:MSORating'', ''MSORatings/MSORating'') WHERE fieldLeft like ''/tns:Fields/tns:Rating/tns:MSORating%''';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt21','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:MSORating'', ''MSORatings/MSORating'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/tns:Fields/tns:Rating/tns:MSORating%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt21','Y');

            vsql := 'UPDATE '||vschema||'.tre_actionparametervalue SET VALUE = NULL
            where valueId in (SELECT other.valueId
            FROM '||vschema||'.tre_actionparametervalue st
            JOIN '||vschema||'.tre_actionparametervalue other
            ON(st.actionId = other.actionId)
            WHERE st.NAME = ''sectionType'' AND other.NAME IN (''rootxpath'', ''xpath'')
            AND st.VALUE = other.VALUE)';
            createobject(vsql,'Unable to update tre_actionparametervalue','Y');
            
            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Receiver/Version/IntegerValue''
            WHERE fieldLeft = ''/tns:Fields/tns:Receiver/tns:Version/tns:Value''';
            createobject(vsql,'Unable to update tre_Predicate','Y');
            
            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Receiver/Version/IntegerValue''
            WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'')
            and value = ''/tns:Fields/tns:Receiver/tns:Version/tns:Value''';
            createobject(vsql,'Unable to update tre_ActionParameterValue','Y');
            
            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:Audio'', ''Video/AudioInfos/AudioInfo'')
            WHERE fieldLeft like ''/tns:Fields/tns:Audio%''';
            createobject(vsql,'Unable to update tre_Predicate','Y');
            
            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:Audio'', ''Video/AudioInfos/AudioInfo'')
            WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'')
            and value like ''/tns:Fields/tns:Audio%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue','Y');
            
            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:MaxViewLimit'', ''MaxViewLimits/MaxViewLimit'')
            WHERE fieldLeft like ''/tns:Fields/tns:Rights/tns:MaxViewLimit%''';
            createobject(vsql,'Unable to update tre_Predicate','Y');
            
            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''tns:MaxViewLimit'', ''MaxViewLimits/MaxViewLimit'')
            WHERE NAME IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'')
            AND VALUE LIKE ''/tns:Fields/tns:Rights/tns:MaxViewLimit%''';
            createobject(vsql,'Unable to update tre_ActionParameterValue','Y');

            vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''tns:'', '''') WHERE fieldleft IS NOT NULL';
            createobject(vsql,'Unable to update tre_Predicate SET fieldLeft - stmt22','Y');

            vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = REPLACE(value, ''tns:'', '''') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value is not null';
            createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt22','Y');

            --Bak added an index for mdm_metadata_revision table on 05/05/2011
            vsql := 'create index '||vschema||'.ecmfspec_rev_xmlindex on '||vschema||'.mdm_metadata_revision(object_value) indextype is xdb.xmlindex parameters (''PATH TABLE path_rev_tab ASYNC (SYNC ALWAYS) PATHS (INCLUDE (/ECMFSpec/@documentId  /ECMFSpec/@revision))'')';
            createobject(vsql,'Unable to create index ecmfspec_rev_xmlindex on mdm_metadata_revision(object_value)','Y');
          END; 
           
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.7''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.7.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.6.0 to 3.2.7.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;

       end if;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.7.0 (CMS 2.0.000.30) to 3.2.8.0(CMS 2.0.000.43)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        if wk_release =  '3.2.7' then 
          -- Daniel Weiner modified the table column tre_predicate modify.fieldLeft as nullable.
          vsql:='alter table '||vschema||'.tre_predicate modify ( fieldLeft NVARCHAR2(1024) null)';
          CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.tre_predicate table column fieldLeft as nullable.','Y');
          
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.8''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.8.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.7.0 to 3.2.8.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              goto bypass_install; 
          END;

       end if;        

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.8.0 (CMS 2.0.000.43) to 3.2.9.0(CMS 2.0.000.46)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        IF WK_RELEASE =  '3.2.8' THEN 
          -- Nick added a new column in wfs.cms_assetlist_asset_metadata table on 06/06/2011.
          VSQL:='ALTER TABLE '||VSCHEMA||'.cms_assetlist_asset_metadata ADD(integer_value NUMBER)';
          CREATEOBJECT(vsql,'Unable to added a new column in '||vschema||'.cms_assetlist_asset_metadata table.','Y');

          -- Daniel Weiner request for updating wfs.tre_predicate and wfs.tre_titlefilter tables on 06/20/2011.
          VSQL:='UPDATE '||VSCHEMA||'.TRE_PREDICATE SET FIELDLEFT = NULL WHERE FIELDLEFTSECTIONTYPE = FIELDLEFT';
          CREATEOBJECT(vsql,'Unable to update '||vschema||'.TRE_PREDICATE table FIELDLEFT column','Y');

          VSQL:='UPDATE '||VSCHEMA||'.TRE_TITLEFILTER SET  SORTCOLUMNNAME = ''ID'', SORTORDER = ''DESCENDING'', SORTFIELDTYPE=1 '||
                ' WHERE TITLEFILTERID IN (SELECT titlefilterId FROM '||VSCHEMA||'.tre_titlesearch) AND sortColumnName IS NULL';
          CREATEOBJECT(VSQL,'Unable to update '||VSCHEMA||'.TRE_TITLEFILTER table SORTCOLUMNNAME and SORTORDER columns','Y');

          -- Kinjal added code to modify the CMS_ROLEPERMISSIONS for Reports module. on 06/22/2011.
          VSQL:='DECLARE
                   VREPORTING_CNT NUMBER;  VMODULE_CNT NUMBER;
                   VMODULEID NUMBER; VPERMISSION_CNT NUMBER;
                   VPERMISSIONID NUMBER; VROLEPERMISSIONS_CNT NUMBER;
                  BEGIN
                     SELECT COUNT(*) INTO VREPORTING_CNT
                       FROM '||VSCHEMA||'.CMS_MODULE WHERE MODULENAME IN (''Reporting'');
                      
                     IF VREPORTING_CNT = 1 THEN
                        SELECT COUNT(*) INTO VMODULE_CNT
                          FROM '||VSCHEMA||'.CMS_MODULE WHERE MODULENAME = ''Reports'' ; 
                     
                        IF VMODULE_CNT=0 THEN
                           INSERT INTO '||VSCHEMA||'.CMS_MODULE (MODULEID, MODULENAME, DISPLAYNAME) VALUES ('||VSCHEMA||'.CMS_MODULE_SEQ.NEXTVAL,''Reports'',''Reports'');
                           INSERT INTO '||VSCHEMA||'.CMS_PERMISSION (PERMISSIONID, PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERNUMBER) 
                            VALUES ('||VSCHEMA||'.CMS_PERMISSION_SEQ.NEXTVAL, ''View'',''View'', '||VSCHEMA||'.CMS_MODULE_SEQ.CURRVAL,0);
                           VPERMISSIONID:='||VSCHEMA||'.CMS_PERMISSION_SEQ.CURRVAL;
                           
                        ELSE          
                          SELECT MODULEID INTO VMODULEID FROM '||VSCHEMA||'.CMS_MODULE WHERE MODULENAME = ''Reports'';
                          SELECT COUNT(*) INTO VPERMISSION_CNT
                            FROM '||VSCHEMA||'.CMS_PERMISSION WHERE MODULEID IN (
                               SELECT MODULEID FROM '||VSCHEMA||'.CMS_MODULE WHERE MODULENAME = ''Reports'');
                  
                          IF VPERMISSION_CNT=0 THEN  
                             INSERT INTO '||VSCHEMA||'.CMS_PERMISSION (PERMISSIONID, PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERNUMBER) 
                              VALUES ('||VSCHEMA||'.CMS_PERMISSION_SEQ.NEXTVAL, ''View'',''View'', VMODULEID,0);
                              VPERMISSIONID:='||VSCHEMA||'.CMS_PERMISSION_SEQ.CURRVAL;
                          ELSE
                             SELECT PERMISSIONID INTO VPERMISSIONID
                               FROM '||VSCHEMA||'.CMS_PERMISSION WHERE MODULEID IN (
                               SELECT MODULEID FROM '||VSCHEMA||'.CMS_MODULE WHERE MODULENAME = ''Reports'');
                          END IF;        
                        END IF;    

                        SELECT COUNT(*) INTO VROLEPERMISSIONS_CNT 
                         FROM '||VSCHEMA||'.CMS_ROLEPERMISSIONS 
                         WHERE PERMISSIONID IN (SELECT PERMISSIONID FROM '||VSCHEMA||'.CMS_PERMISSION WHERE MODULEID IN 
                                                 (SELECT MODULEID FROM '||VSCHEMA||'.CMS_MODULE WHERE MODULENAME =''Reports''));

                        IF VROLEPERMISSIONS_CNT=0 THEN
                           UPDATE '||VSCHEMA||'.CMS_ROLEPERMISSIONS SET PERMISSIONID=VPERMISSIONID
                            WHERE PERMISSIONID IN (SELECT PERMISSIONID FROM '||VSCHEMA||'.CMS_PERMISSION WHERE MODULEID IN 
                                                    (SELECT MODULEID FROM '||VSCHEMA||'.CMS_MODULE WHERE MODULENAME =''Reporting''));
                        END IF;
                        
                        COMMIT;
                     END IF;   
                  END;';
          CREATEOBJECT(vsql,'Unable to update '||vschema||'.CMS_ROLEPERMISSIONS table data','Y');
          
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.9''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.9.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.8.0 to 3.2.9.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              goto bypass_install; 
          END;
       END IF;  

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.9.0(CMS 2.0.000.46) to 3.2.10.0(CMS 2.0.000.51)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        IF WK_RELEASE =  '3.2.9' THEN 
          -- Suresh dropped the procedure SYS.RECREATE_XML_INDEXES on 06/27/2011.
          VSQL:='DROP PROCEDURE SYS.RECREATE_XML_INDEXES';
          CREATEOBJECT(VSQL,'Unable to drop procedure sys.recreate_xml_indexes','Y');

          -- Raj added a new column in the table wfs.SCH_PASTEXECUTION on 06/30/2011.
          VSQL:='alter table '||VSCHEMA||'.SCH_PASTEXECUTION add (stale number(1,0) default 0 not null)';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.SCH_PASTEXECUTION to add column stale.','Y');
          
          VSQL:='UPDATE '||VSCHEMA||'.tre_Predicate SET fieldLeft = ''/Fields/Content/Size/length'' WHERE fieldLeft = ''/Fields/Size/@length''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_Predicate','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_ActionParameterValue SET value = ''/Fields/Content/Size/length'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value = ''/Fields/Size/@length''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_ActionParameterValue','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_Predicate SET fieldLeft = ''/FIELDS/CONTENT/SIZE/HEIGHT'' WHERE fieldLeft = ''/Fields/Size/@height''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_Predicate','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_ActionParameterValue SET value = ''/Fields/Content/Size/height'' WHERE NAME IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND VALUE = ''/Fields/Size/@height''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_ActionParameterValue','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_Predicate SET fieldLeft = ''/Fields/Content/Size/width'' WHERE fieldLeft = ''/Fields/Size/@width''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_Predicate','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_ActionParameterValue SET value = ''/Fields/Content/Size/width'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND VALUE = ''/Fields/Size/@width''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_ActionParameterValue','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_Predicate SET fieldLeft = ''/FIELDS/RIGHTS/VIEWLIMITS/VIEWLIMIT'' WHERE fieldLeft = ''/Fields/Rights/MaxViewLimits/MaxViewLimit''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_Predicate','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_ActionParameterValue SET value = ''/Fields/Rights/ViewLimits/ViewLimit'' WHERE NAME IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND VALUE = ''/Fields/Rights/MaxViewLimits/MaxViewLimit''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_ActionParameterValue','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_Predicate SET fieldLeft = ''/Fields/Video/AudioInfos/AudioInfo/Value'' WHERE fieldLeft = ''/Fields/Video/AudioInfos/AudioInfo/Types/Type''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_Predicate','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_ActionParameterValue SET value = ''/Fields/Video/AudioInfos/AudioInfo/Value'' WHERE NAME IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND VALUE = ''/Fields/Video/AudioInfos/AudioInfo/Types/Type''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_ActionParameterValue','Y');

          BEGIN
            execute immediate 'UPDATE '||VSCHEMA||'.SYSTEM_SETTINGS SET setting_value=''3.2.10''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.10.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.9.0 to 3.2.10.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;  
       
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.10.0(CMS 2.0.000.51) to 3.2.11.0(CMS 2.0.000.53)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        IF WK_RELEASE =  '3.2.10' THEN 

          VSQL:='UPDATE '||VSCHEMA||'.tre_Predicate SET fieldLeft = ''/Fields/TrickModeRestrictions/TrickModeRestriction'' WHERE fieldLeft = ''/Fields/Video/TrickModesRestricted''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_Predicate','Y');

          VSQL:='UPDATE '||VSCHEMA||'.tre_ActionParameterValue SET value = ''/Fields/TrickModeRestrictions/TrickModeRestriction'' WHERE NAME IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND VALUE = ''/Fields/Video/TrickModesRestricted''';
          CREATEOBJECT(VSQL,'Unable to alter table '||VSCHEMA||'.tre_ActionParameterValue','Y');
          BEGIN
            execute immediate 'UPDATE '||VSCHEMA||'.SYSTEM_SETTINGS SET setting_value=''3.2.11''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.11.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.10.0 to 3.2.11.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;  
       
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.11.0(CMS 2.0.000.53) to 3.2.12.0(CMS 2.0.010.56)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        IF WK_RELEASE =  '3.2.11' THEN 
/*
        begin
          dbms_sqltune.set_auto_tuning_task_parameter( 'LOCAL_TIME_LIMIT', 3600);
          dbms_sqltune.set_auto_tuning_task_parameter( 'ACCEPT_SQL_PROFILES', 'TRUE');
          DBMS_SQLTUNE.SET_AUTO_TUNING_TASK_PARAMETER( 'MAX_SQL_PROFILES_PER_EXEC', 20);
          dbms_sqltune.set_auto_tuning_task_parameter( 'MAX_AUTO_SQL_PROFILES', 200);
        END; 
*/
          -- Daniel Weiner added below insert and update statements to the Rules engine tables on 08/02/2011.        
          VSQL := 'INSERT INTO '||vschema||'.tre_actionparametervalue(valueId, NAME, VALUE, actionid, order_) '||
                  ' SELECT '||vschema||'.tre_actionparamValue_seq.nextval, ''forMatchedRhs'', CASE WHEN apv.VALUE IS NULL THEN ''false'' ELSE ''true'' END , ta.actionId, 7 '||
                  ' FROM '||vschema||'.tre_action ta JOIN '||vschema||'.tre_actionparametervalue apv ON(ta.actionid = apv.actionid) '||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.copy(String, String, String, Boolean, String, String, String, EvaluatorResults, Title)'''||
                  ' and apv.name = ''rootxpathRhs''';
          CREATEOBJECT(VSQL,'Unable to insert into '||vschema||'.Tre_PACKAGE','Y');
      
          VSQL := 'UPDATE  '||VSCHEMA||'.tre_actionparametervalue SET order_ = order_ + 1 '||
                  ' WHERE actionId IN (SELECT actionId FROM '||vschema||'.tre_action WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.copy(String, String, String, Boolean, String, String, String, EvaluatorResults, Title)'')'||
                  '  AND ((NAME = ''matchedItems'' AND ORDER_ = 7) OR (NAME = ''title'' AND ORDER_ = 8))';
          CREATEOBJECT(VSQL,'Unable to UPDATE  '||vschema||'.tre_actionparametervalue','Y');
      
          VSQL := 'UPDATE '||vschema||'.tre_action '||
                  '   SET   METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.copy(String, String, String, Boolean, String, String, String, Boolean, EvaluatorResults, Title)'''||
                  ' WHERE METHOD = ''com.tandbergtv.marvin.actions.NormalizationActions.copy(String, String, String, Boolean, String, String, String, EvaluatorResults, Title)''';
          CREATEOBJECT(VSQL,'Unable to UPDATE '||vschema||'.tre_action ','Y');
      
          VSQL := 'UPDATE '||vschema||'.tre_predicate SET IGNORECASE = 0 WHERE OPERATOR =''CONTAINS''';
          CREATEOBJECT(VSQL,'Unable to UPDATE '||vschema||'.tre_predicate','Y');
        
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.12''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.12.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.11.0 to 3.2.12.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;  
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.12.0(CMS 2.0.010.56) to 3.2.13.0(CMS 2.0.010.59)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
        IF WK_RELEASE =  '3.2.12' THEN 

          BEGIN
            EXECUTE IMMEDIATE 'alter system set cursor_sharing=EXACT';
          END;

          --Daniel Weiner added update statements to the Rules tables on 08/09/2011.
          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = fieldLeft||''/@value'' WHERE fieldLeft in ('||
                  '''/Fields/Description/Language'',''/Fields/CreationInfo/Title/FeatureTitle/Language'',''/Fields/CreationInfo/Title/OriginalTitle/Language'','||
                  '''/Fields/Languages/Language'',''/Fields/Identifier/Locator/Description/Language'',''/Fields/CreationInfo/Title/ShortTitle/Language'','||
                  '''/Fields/SubTitle/FeatureTitle/Language'',''/Fields/Content/Medium/Description/Language'',''/Fields/Title/OriginalTitle/Language'','||
                  '''/Fields/Content/Description/Language'',''/Fields/Video/AudioInfos/AudioInfo/Language'',''/Fields/Title/FeatureTitle/Language'','||
                  '''/Fields/SubTitleLanguages/SubTitleLanguage'',''/Fields/Languages'',''/Fields/Video/BitRate'','||
                  '''/Fields/Content/Locator/Description/Language'',''/Fields/Summary/DisplaySummary/Language'',''/Fields/DubbedLanguages'','||
                  '''/Fields/Title/SortTitle/Language'',''/Fields/ProviderInfo/ReferenceIdentifier/Locator/Description/Language'',''/Fields/ProviderInfo/Identifier/Description/Language'','||
                  '''/Fields/Title/SearchTitle/Language'',''/Fields/OriginalFile/Description/Language'',''/Fields/Language'','||
                  '''/Fields/CreationInfo/Sources/Source/Role/Locator/Description/Language'',''/Fields/Awards/Award/Sources/Source/Role/Locator/Description/Language'',''/Fields/SubTitle/OriginalTitle/Language'','||
                  '''/Fields/SubTitle/SearchTitle/Language'',''/Fields/SubTitleLanguages'',''/Fields/DubbedLanguages/DubbedLanguage'','||
                  '''/Fields/Audio/Language'',''/Fields/Review/Language'',''/Fields/Episode/Name/Language'','||
                  '''/Fields/Identifier/Description/Language'',''/Fields/CreationInfo/Title/SortTitle/Language'',''/Fields/Summary/ShortSummary/Language'','||
                  '''/Fields/Title/DisplayTitle/Language'',''/Fields/ProviderInfo/Identifier/Locator/Description/Language'',''/Fields/SubTitle/ShortTitle/Language'','||
                  '''/Fields/CreationInfo/Title/SearchTitle/Language'',''/Fields/SubTitle/DisplayTitle/Language'',''/Fields/SubTitle/SortTitle/Language'','||
                  '''/Fields/Awards/Award/Language'',''/Fields/Content/Medium/Locator/Description/Language'',''/Fields/CreationInfo/Title/DisplayTitle/Language'','||
                  '''/Fields/ProviderInfo/ReferenceIdentifier/Description/Language'',''/Fields/Summary/MediumSummary/Language'',''/Fields/Title/ShortTitle/Language'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_1','Y');
          
          vsql := 'UPDATE '||vschema||'.tre_actionparametervalue SET value = value||''/@value'' WHERE name in (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value in ('||
                  '''/Fields/Description/Language'',''/Fields/CreationInfo/Title/FeatureTitle/Language'',''/Fields/CreationInfo/Title/OriginalTitle/Language'','||
                  '''/Fields/Languages/Language'',''/Fields/Identifier/Locator/Description/Language'',''/Fields/CreationInfo/Title/ShortTitle/Language'','||
                  '''/Fields/SubTitle/FeatureTitle/Language'',''/Fields/Content/Medium/Description/Language'',''/Fields/Title/OriginalTitle/Language'','||
                  '''/Fields/Content/Description/Language'',''/Fields/Video/AudioInfos/AudioInfo/Language'',''/Fields/Title/FeatureTitle/Language'','||
                  '''/Fields/SubTitleLanguages/SubTitleLanguage'',''/Fields/Languages'',''/Fields/Video/BitRate'','||
                  '''/Fields/Content/Locator/Description/Language'',''/Fields/Summary/DisplaySummary/Language'',''/Fields/DubbedLanguages'','||
                  '''/Fields/Title/SortTitle/Language'',''/Fields/ProviderInfo/ReferenceIdentifier/Locator/Description/Language'',''/Fields/ProviderInfo/Identifier/Description/Language'','||
                  '''/Fields/Title/SearchTitle/Language'',''/Fields/OriginalFile/Description/Language'',''/Fields/Language'','||
                  '''/Fields/CreationInfo/Sources/Source/Role/Locator/Description/Language'',''/Fields/Awards/Award/Sources/Source/Role/Locator/Description/Language'',''/Fields/SubTitle/OriginalTitle/Language'','||
                  '''/Fields/SubTitle/SearchTitle/Language'',''/Fields/SubTitleLanguages'',''/Fields/DubbedLanguages/DubbedLanguage'','||
                  '''/Fields/Audio/Language'',''/Fields/Review/Language'',''/Fields/Episode/Name/Language'','||
                  '''/Fields/Identifier/Description/Language'',''/Fields/CreationInfo/Title/SortTitle/Language'',''/Fields/Summary/ShortSummary/Language'','||
                  '''/Fields/Title/DisplayTitle/Language'',''/Fields/ProviderInfo/Identifier/Locator/Description/Language'',''/Fields/SubTitle/ShortTitle/Language'','||
                  '''/Fields/CreationInfo/Title/SearchTitle/Language'',''/Fields/SubTitle/DisplayTitle/Language'',''/Fields/SubTitle/SortTitle/Language'','||
                  '''/Fields/Awards/Award/Language'',''/Fields/Content/Medium/Locator/Description/Language'',''/Fields/CreationInfo/Title/DisplayTitle/Language'','||
                  '''/Fields/ProviderInfo/ReferenceIdentifier/Description/Language'',''/Fields/Summary/MediumSummary/Language'',''/Fields/Title/ShortTitle/Language'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_1','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = fieldLeft||''/@assetId'' WHERE fieldLeft in ('||
                  '''/ECMFSpec/Package/Movie/LogicalClip'',''/ECMFSpec/Package/Trick'',''/ECMFSpec/Package/Encrypted'','||
                  '''/ECMFSpec/Package/Preview/LogicalClip'',''/ECMFSpec/Package/Boxcover'',''/ECMFSpec/Package/Poster'','||
                  '''/ECMFSpec/Package/Title'',''/ECMFSpec/Package/Barker'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_2','Y');

          vsql := 'UPDATE '||vschema||'.tre_actionparametervalue SET value = value||''/@assetId'' WHERE name in (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value in ('||
                  '''/ECMFSpec/Package/Movie/LogicalClip'',''/ECMFSpec/Package/Trick'',''/ECMFSpec/Package/Encrypted'','||
                  '''/ECMFSpec/Package/Preview/LogicalClip'',''/ECMFSpec/Package/Boxcover'',''/ECMFSpec/Package/Poster'','||
                  '''/ECMFSpec/Package/Title'',''/ECMFSpec/Package/Barker'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_2','Y');

          vsql := 'UPDATE '||vschema||'.tre_predicate SET fieldleft = fieldleft||''/Name'' WHERE fieldleft in (''/Fields/ApplicationInfo'',''/Fields/ProductInfo'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_3','Y');

          vsql := 'UPDATE '||vschema||'.tre_actionparametervalue SET value = value||''/Name'' WHERE name in (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value in ('||
                  '''/Fields/ApplicationInfo'',''/Fields/ProductInfo'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_3','Y');

          vsql := 'UPDATE '||vschema||'.tre_predicate SET fieldleft = fieldleft||''/TrickModeRestriction'' WHERE fieldleft IN ('||
                  '''/Fields/Image/ContentPointer/TrickModeRestrictions'',''/Fields/TrickModeRestrictions'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_4','Y');

          vsql := 'UPDATE '||vschema||'.tre_actionparametervalue SET value = value||''/TrickModeRestriction'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value IN ('||
                  '''/Fields/Image/ContentPointer/TrickModeRestrictions'',''/Fields/TrickModeRestrictions'')';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_4','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/ProviderQAContact/Value'' WHERE fieldLeft = ''/Fields/ProviderQAContact''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_5','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/ProviderQAContact/Value'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/ProviderQAContact''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_5','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rights/ViewLimits/ViewLimit'' WHERE fieldLeft = ''/Fields/Rights/ViewLimits''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_6','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Rights/ViewLimits/ViewLimit'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Rights/ViewLimits''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_6','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/TTVId/Version'' WHERE fieldLeft = ''/Fields/TTVId''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_7','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/TTVId/Version'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/TTVId''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_7','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Chapters/Chapter'' WHERE fieldLeft = ''/Fields/Chapters''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_8','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Chapters/Chapter'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Chapters''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_8','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rating/MSORatings/MSORating'' WHERE fieldLeft = ''/Fields/Rating/MSORatings''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_9','Y');

          vsql := 'UPDATE '||vschema||'.tre_actionparametervalue SET value = ''/Fields/Rating/MSORatings/MSORating'' WHERE name in (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Rating/MSORatings''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_9','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/OSVOD/PackageUsages/PackageUsage'' WHERE fieldLeft = ''/Fields/OSVOD/PackageUsages''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_10','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/OSVOD/PackageUsages/PackageUsage'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/OSVOD/PackageUsages''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_10','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rules/Rule'' WHERE fieldLeft = ''/Fields/Rules''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_11','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Rules/Rule'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Rules''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_11','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rating/TargetAudiences/TargetAudience'' WHERE fieldLeft = ''/Fields/Rating/TargetAudiences''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_12','Y');

          vsql := 'UPDATE '||vschema||'.tre_actionparametervalue SET value = ''/Fields/Rating/TargetAudiences/TargetAudience'' WHERE name in (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Rating/TargetAudiences''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_12','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/OSVOD/PackageRefs/PackageRef'' WHERE fieldLeft = ''/Fields/OSVOD/PackageRefs''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_13','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/OSVOD/PackageRefs/PackageRef'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/OSVOD/PackageRefs''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_13','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rating/Labels/Label'' WHERE fieldLeft = ''/Fields/Rating/Labels''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_14','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Rating/Labels/Label'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Rating/Labels''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_14','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rating/ContentAdvisories/ContentAdvisory'' WHERE fieldLeft = ''/Fields/Rating/ContentAdvisories''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110809_15','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Rating/ContentAdvisories/ContentAdvisory'' WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Rating/ContentAdvisories''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110809_15','Y');

          --Daniel Weiner added update statements to the Rules tables on 08/10/2011.
          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rating/RatingValues/RatingValue/System'' WHERE fieldLeft = ''/Fields/Rating/RatingValues/RatingValue/Value/System''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_Predicate stmt_20110810_1','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = ''/Fields/Rating/RatingValues/RatingValue/System'' WHERE NAME IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') AND value = ''/Fields/Rating/RatingValues/RatingValue/ValueSystem/''';
          createobject(vsql,'Unable to insert into '||vschema||'.tre_actionparametervalue stmt_20110810_1','Y');

          --Murtaza added index to speed up MDM_METADATA document id lookups on 08/15/11
          VSQL := 'create index '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid on '||VSCHEMA||'.ecmfdisplay_tab(ttvid)';
          CREATEOBJECT(VSQL,'Unable to create index '||VSCHEMA||'.idx_ecmfdisplaytab_ttvid on ecmfdisplay_tab(ttvid)','Y');
      
          --Raj requested on 08/18/2011 to drop the contextid column from Sites_site table and deleted pmm_context data where containertypeid=3
          vsql := 'alter table '||VSCHEMA||'.sites_site drop column contextid CASCADE CONSTRAINTS';
          createobject(vsql,'Unable to alter table '||VSCHEMA||'..sites_site drop column contextid','Y');

          vsql := 'delete from '||VSCHEMA||'.pmm_context where containertypeid=3';
          createobject(vsql,'Unable to delete from '||vschema||'.pmm_context where containertypeid=3','Y');

          -- On 08/19/2011 received a request from Raj to drop the below seven tables.
          vsql := 'drop table '||VSCHEMA||'.pmm_job cascade constraints';
          createobject(vsql,'Unable to drop table '||VSCHEMA||'.pmm_job cascade constraints','Y');
          
          vsql := 'drop table '||VSCHEMA||'.pmm_jobparameter cascade constraints';
          createobject(vsql,'Unable to drop table '||VSCHEMA||'.pmm_jobparameter cascade constraints','Y');

          vsql := 'drop table '||VSCHEMA||'.pmm_rule cascade constraints';
          createobject(vsql,'Unable to drop table '||VSCHEMA||'.pmm_rule cascade constraints','Y');

          vsql := 'drop table '||VSCHEMA||'.pmm_ruleparameter cascade constraints';
          createobject(vsql,'Unable to drop table '||VSCHEMA||'.pmm_ruleparameter cascade constraints','Y');

          vsql := 'drop table '||VSCHEMA||'.pmm_ruletype cascade constraints';
          createobject(vsql,'Unable to drop table '||VSCHEMA||'.pmm_ruletype cascade constraints','Y');

          vsql := 'drop table '||VSCHEMA||'.pmm_ruletypeparameter cascade constraints';
          createobject(vsql,'Unable to drop table '||VSCHEMA||'.pmm_ruletypeparameter cascade constraints','Y');

          vsql := 'drop table '||VSCHEMA||'.pmm_ruletypeparameterdatatype cascade constraints';
          createobject(vsql,'Unable to drop table '||VSCHEMA||'.pmm_ruletypeparameterdatatype cascade constraints','Y');

          -- Daniel request to change the upper case values to lower case in tre_predicate table to fix bug 1881
          vsql:='UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Rights/ViewLimits/ViewLimit'' WHERE fieldLeft = ''/FIELDS/RIGHTS/VIEWLIMITS/VIEWLIMIT''';
          createobject(vsql,'Unable to alter table '||vschema||'.tre_Predicate','Y');

          vsql:='UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Content/Size/height'' WHERE fieldLeft = ''/FIELDS/CONTENT/SIZE/HEIGHT''';
          createobject(vsql,'Unable to alter table '||vschema||'.tre_Predicate','Y');
          
          COMMIT;

          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.13''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.13.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.12.0 to 3.2.13.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.13.0(CMS 2.0.010.59) to 3.2.14.0(CMS 2.0.000.62)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        if wk_release =  '3.2.13' then 
		  --Suresh added create table privs to WFS user for purge script
          vsql :=  'grant create table to WFS';
          CREATEOBJECT(vsql,'Unable to grant create table to the WFS user.','Y');        

      /* Murtaza Turns off automatic sql profiles on 09/08/2011. */
        begin
          dbms_sqltune.set_auto_tuning_task_parameter( 'LOCAL_TIME_LIMIT', 1200);
          dbms_sqltune.set_auto_tuning_task_parameter( 'ACCEPT_SQL_PROFILES', 'FALSE');
          dbms_sqltune.set_auto_tuning_task_parameter( 'MAX_SQL_PROFILES_PER_EXEC', 20);
          dbms_sqltune.set_auto_tuning_task_parameter( 'MAX_AUTO_SQL_PROFILES', 10000);
        END;

          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.14''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.14.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.13.0 to 3.2.14.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          end;
        END IF;
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.14.0(CMS 2.0.010.62) to 3.2.15.0(CMS 2.0.010.65)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.14'  THEN 
		      --Suresh added code for copy evolve
          vsql :=  'grant create view,create any table, create any index, select any table, update any table, insert any table, delete any table, drop any table, alter any table, drop any index, drop any type, create any type, alter any type to WFS';
          createobject(vsql,'Unable to grant privileges to the WFS user for xmlevolve.','Y');
          BEGIN
            execute immediate 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.15''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.15.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.14.0 to 3.2.15.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          end;
        END IF;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.15.0(CMS 2.0.010.65) to 3.2.17.0(CMS 2.0.020.09)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.15.1'  THEN   -- After the DB Evolve, CMS 2.0.010.65 db reach to this upgrade path.
		      -- Vijay changes to cms_user and cms_role tables on 01/06/2012.
          vsql :=  'ALTER TABLE '||vschema||'.CMS_Role DROP COLUMN externalkey';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_Role DROP COLUMN externalkey','Y');
          
          vsql :=  'ALTER TABLE '||vschema||'.CMS_User ADD (ExternalKey VARCHAR2(500), SyncDate TIMESTAMP NULL, CONSTRAINT UNQ_CMS_USER_EXTERNALKEY UNIQUE(ExternalKey))';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_User ADD columns ExternalKey, SyncDate.','Y');

          vsql :=  'ALTER TABLE '||vschema||'.CMS_User MODIFY (PASSWORD VARCHAR2(100) NULL, PasswordModifiedDate DATE NULL)';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_User to MODIFY PASSWORD and PasswordModifiedDate.','Y');

          -- Raj dropped unique key constraint UNQ_ASSET_MAP_ASSET_TITLE_ID in table CMS_ASSETLIST_ASSET_MAP on 01/09/2012.
          vsql := 'ALTER TABLE '||vschema||'.CMS_ASSETLIST_ASSET_MAP DROP CONSTRAINT UNQ_ASSET_MAP_ASSET_TITLE_ID DROP INDEX';
          CREATEOBJECT(vsql,'Unable to drop constraint UNQ_ASSET_MAP_ASSET_TITLE_ID','Y');

        -- Suneeta added following updates on 02/27/2012
          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''/Fields/OSVOD/AssociationId'', ''/Fields/OSVOD/AssociationIds/AssociationId'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/Fields/OSVOD/AssociationId''';
          createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt23','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''/Fields/OSVOD/ViewingWindow'', ''/Fields/OSVOD/ViewingWindows/ViewingWindow'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/Fields/OSVOD/ViewingWindow''';
          createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt24','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''/Fields/Avail'', ''/Fields/Avails/Avail'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/Fields/Avail%''';
          createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt25','Y');

          vsql := 'UPDATE '||vschema||'.tre_ActionParameterValue SET value = replace(value, ''/Fields/Language/@value'', ''/Fields/Languages/Language/@value'') WHERE name IN (''rootxpath'', ''xpath'', ''xpathRhs'', ''rootxpathRhs'') and value like ''/Fields/Language/@value''';
          createobject(vsql,'Unable to update tre_ActionParameterValue SET value - stmt26','Y');
            
          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/OSVOD/AssociationIds/AssociationId'' WHERE fieldLeft = ''/Fields/OSVOD/AssociationId''';
          CREATEOBJECT(VSQL,'Unable to update tre_Predicate - stmt1','Y');
            
          VSQL := 'UPDATE '||VSCHEMA||'.tre_Predicate SET fieldLeft = ''/Fields/OSVOD/ViewingWindows/ViewingWindow'' WHERE fieldLeft = ''/Fields/OSVOD/ViewingWindow''';
          createobject(vsql,'Unable to update tre_Predicate - stmt2','Y');

          vsql := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = replace(fieldLeft, ''/Fields/Avail'', ''/Fields/Avails/Avail'') WHERE fieldLeft like ''/Fields/Avail%''';
          createobject(vsql,'Unable to update tre_Predicate - stmt3','Y'); 

          VSQL := 'UPDATE '||vschema||'.tre_Predicate SET fieldLeft = ''/Fields/Languages/Language/@value'' WHERE fieldLeft = ''/Fields/Language/@value''';
          CREATEOBJECT(VSQL,'Unable to update tre_Predicate - stmt4','Y');

          BEGIN
            execute immediate 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.16''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.16.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.15.0 to 3.2.16.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;

        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.16'  THEN 
		      -- Nick addded new OSVOD fields to the ecmf spec (all these are just additional, no modifications to the existing fiels) on 01/06/2012. 
          -- XMLEVOLVE;
          NULL;
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.17.1''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.17.1'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.16.0 to 3.2.17.1'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.17.0(CMS 2.0.020.19) to 3.2.18.0(CMS 2.5.000.6)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.17.1'  THEN -- After the DB Evolve, CMS 2.0.020.19 db reach to this upgrade path.
		      --Stephen Zack created Category manager tables and views on 12/07/2011
           CreateCAT;

          -- Eugene Karpenko added pmm_content_class_type on 01-04-2012
          vsql := 'CREATE TABLE '||vschema||'.PMM_CONTENT_CLASS_TYPE (
                        CONTENT_CLASS_TYPE_ID NUMBER, 
                        NAME                  VARCHAR2(50 CHAR) NOT NULL,       
                        CONSTRAINT PK_PMM_CONTENT_CLASS_TYPE primary key (CONTENT_CLASS_TYPE_ID))';    
          CREATEOBJECT(vsql,'Unable to create table PMM_CONTENT_CLASS_TYPE','Y');

          -- Eugene Karpenko on 01-05-2012 for content class type id should start from 0 in pmm_content_class_type table.
          BEGIN
			      EXECUTE IMMEDIATE 'INSERT INTO '||VSCHEMA||'.pmm_content_class_type (content_class_type_id, name) VALUES (''0'', ''Package'')';
			      EXECUTE IMMEDIATE 'INSERT INTO '||VSCHEMA||'.pmm_content_class_type (content_class_type_id, name) VALUES (''1'', ''Series'')';      
			      EXECUTE IMMEDIATE 'INSERT INTO '||VSCHEMA||'.pmm_content_class_type (content_class_type_id, name) VALUES (''2'', ''Category'')';			
		      EXCEPTION 
			      WHEN OTHERS THEN
				      WK_MESSAGE := 'ERROR';
				      ERR_MSG :=SUBSTR(SQLERRM, 1, 500);
				      EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					    'Unable to insert into pmm_content_class_type.'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||ERR_MSG||''')';
              GOTO BYPASS_INSTALL;		
		      END;

          VSQL := 'ALTER TABLE '||VSCHEMA||'.pmm_content_class ADD ( 
                         content_class_type_id NUMBER DEFAULT 0 NOT NULL,
                         CONSTRAINT fk_pmm_content_class_type FOREIGN KEY (CONTENT_CLASS_TYPE_ID) REFERENCES '||VSCHEMA||'.pmm_content_class_type(content_class_type_id))';
          CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||VSCHEMA||'.pmm_content_class for adding content_class_type_id','Y');

          -- Sanjay added sites_mso and sites_mso_override tables on 01/05/2012.
          vsql := 'CREATE TABLE '||vschema||'.SITES_MSO (
                          MSO_ID     NUMBER PRIMARY KEY,
                          MSO_NAME   VARCHAR2(255) NOT NULL,
                          SITE_ID    NUMBER NOT NULL,
                          CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                          UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                          CONSTRAINT FK_SITE_ID FOREIGN KEY (SITE_ID)REFERENCES '||vschema||'.SITES_SITE (ID_)
                        )';
          CREATEOBJECT(VSQL,'Unable to create table SITES_MSO','Y');
          CREATESEQ('SITES_MSO');      
          CREATEUPDATETRG('SITES_MSO');
      
          vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_OVERRIDE (
                          OVERRIDE_ID        NUMBER PRIMARY KEY,
                          MSO_ID             NUMBER NOT NULL,
                          FIELD_XPATH        VARCHAR2(1000) NOT NULL,
                          SEARCH_VALUE       VARCHAR2(1000) NOT NULL,
                          REPLACEMENT_VALUE  VARCHAR2(1000) NOT NULL,
                          CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                          UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                          CONSTRAINT FK_MSO_ID FOREIGN KEY (MSO_ID) REFERENCES '||vschema||'.SITES_MSO(MSO_ID)
                        )';
          CREATEOBJECT(VSQL,'Unable to create table SITES_MSO_OVERRIDE','Y');
          CREATESEQ('SITES_MSO_OVERRIDE');
          CREATEUPDATETRG('SITES_MSO_OVERRIDE');

          -- Sanjay added Mediapath to the sites_sitetype table on 01/10/2012.
          vsql := 'INSERT INTO '||vschema||'.SITES_SITETYPE (ID_, TYPE) VALUES (4, ''MEDIAPATH'')';
          CREATEOBJECT(vsql,'Unable to insert SITES_SITETYPE','Y');

          -- Raj request to drop 3 tables and delete SERVICE and site records from PMM_CONTAINERTYPE on 01/10/2012
          vsql := 'drop table '||vschema||'.pmm_service_partnerxref';
          createobject(vsql,'Unable to DROP table '||vschema||'.pmm_service_partnerxref.','Y');

          vsql := 'drop table '||vschema||'.pmm_service';
          createobject(vsql,'Unable to DROP table '||vschema||'.pmm_service','Y');

          vsql := 'drop sequence '||vschema||'.pmm_service_seq';
          createobject(vsql,'Unable to drop sequence '||vschema||'.pmm_service_seq.','Y');

          vsql := 'drop table '||vschema||'.pmm_watchfolderconfiguration';
          createobject(vsql,'Unable to DROP table '||vschema||'.pmm_watchfolderconfiguration.','Y');

          vsql := 'drop sequence '||vschema||'.PMM_WatchFlderConfig_SEQ';
          createobject(vsql,'Unable to drop sequence '||vschema||'.PMM_WatchFlderConfig_SEQ.','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_CONTAINER_PROPERTIES WHERE CONTEXTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE'')))';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_CONTAINER_PROPERTIES','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_TITLE_TITLELISTXREF WHERE TITLELISTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_TITLELIST WHERE CONTEXTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE''))))';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_TITLE_TITLELISTXREF','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_TITLELISTDETAILS WHERE TITLELISTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_TITLELIST WHERE CONTEXTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE''))))';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_TITLELISTDETAILS','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_PROPERTIES WHERE TITLELISTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_TITLELIST WHERE CONTEXTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE''))))';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_PROPERTIES','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_PROGRESSITEM WHERE TITLELISTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_TITLELIST WHERE CONTEXTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE''))))';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_PROGRESSITEM','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_TITLELIST WHERE CONTEXTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE'')))';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_TITLELIST','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_PROPERTIES WHERE CONTEXTID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE'')));';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_PROPERTIES','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_CONTEXT WHERE CONTAINERTYPEID IN 
                     ( SELECT ID_ FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE''))';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_CONTEXT','Y');

          vsql := 'DELETE FROM '||vschema||'.PMM_CONTAINERTYPE WHERE UPPER(NAME) IN (''SERVICE'',''SITE'')';
          createobject(vsql,'Unable to delete records from table '||vschema||'.PMM_CONTAINERTYPE','Y');

          -- Avinash added six tables for Metadata Configuration on 01/19/2012.
          vsql := 'CREATE TABLE '||vschema||'.CMS_ADVISORY ( 
                       advisory    VARCHAR2(64 CHAR) NOT NULL,
                       description VARCHAR2(255 CHAR),
                       createdate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       updatedate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT pk_cms_advisory PRIMARY KEY (advisory)
                   )';
         CREATEOBJECT(VSQL,'Unable to create table '||VSCHEMA||'.CMS_ADVISORY.','Y');
         CREATEUPDATETRG('CMS_ADVISORY');

          vsql := 'CREATE TABLE '||vschema||'.CMS_APP_TYPE (
                       app_type   VARCHAR2(64 CHAR) NOT NULL,
                       notes      VARCHAR2(255 CHAR),
                       createdate TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       updatedate TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT pk_cms_app_type PRIMARY KEY (app_type)
                   )';
         CREATEOBJECT(VSQL,'Unable to create table '||VSCHEMA||'.CMS_APP_TYPE.','Y');
         CREATEUPDATETRG('CMS_APP_TYPE');

         vsql := 'CREATE TABLE '||vschema||'.CMS_GENRE (
                       genre       VARCHAR2(64 CHAR) NOT NULL,
                       description VARCHAR2(255 CHAR),
                       createdate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       updatedate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT pk_cms_genre PRIMARY KEY (genre)
                   )';
         CREATEOBJECT(VSQL,'Unable to create table '||VSCHEMA||'.CMS_GENRE.','Y');
         CREATEUPDATETRG('CMS_GENRE');

          vsql := 'CREATE TABLE '||vschema||'.CMS_PRODUCT (
                       product_code VARCHAR2(64 CHAR) NOT NULL,
                       description  VARCHAR2(255 CHAR),
                       createdate   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       updatedate   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT pk_cms_product PRIMARY KEY (product_code)
                   )';
         CREATEOBJECT(VSQL,'Unable to create table '||VSCHEMA||'.CMS_PRODUCT.','Y');
         CREATEUPDATETRG('CMS_PRODUCT');

          vsql := 'CREATE TABLE '||vschema||'.CMS_RATING (
                       rating        VARCHAR2(64 CHAR) NOT NULL,
                       rating_system VARCHAR2(64 CHAR) NOT NULL,
                       description   VARCHAR2(255 CHAR),
                       createdate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       updatedate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT pk_cms_rating PRIMARY KEY (rating, rating_system)
                   )';
         CREATEOBJECT(VSQL,'Unable to create table '||VSCHEMA||'.CMS_RATING.','Y');
         CREATEUPDATETRG('CMS_RATING');

          vsql := 'CREATE TABLE '||vschema||'.CMS_STUDIO (
                       display_name      VARCHAR2(64 CHAR) NOT NULL,
                       organization_name VARCHAR2(255 CHAR) NOT NULL,
                       organization_code VARCHAR2(64 CHAR),
                       description       VARCHAR2(255 CHAR),
                       createdate        TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       updatedate        TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT pk_cms_studio PRIMARY KEY (display_name)
                   )';
         CREATEOBJECT(VSQL,'Unable to create table '||VSCHEMA||'.CMS_STUDIO.','Y');
         CREATEUPDATETRG('CMS_STUDIO');

         --Raj modified columns PMM_PARTNER.PROVIDERID and PMM_CONTACT.EMAIL to NULL on 01/25/2012.
         vsql := 'ALTER TABLE '||vschema||'.PMM_PARTNER MODIFY (PROVIDERID NULL)';
         createobject(vsql,'Unable to ALTER TABLE '||vschema||'.PMM_PARTNER modify column PROVIDERID to NULL.','Y');

         vsql := 'ALTER TABLE '||vschema||'.PMM_CONTACT MODIFY (EMAIL NULL)';
         createobject(vsql,'Unable to ALTER TABLE '||vschema||'.PMM_CONTACT modify column EMAIL to NULL.','Y');
         
         -- Sanjay added SITES_MSO_OVERRIDE_HISTORY table on 01/25/2012.
         vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY (
                       OVERRIDE_HISTORY_ID  NUMBER,
                       SITE_TITLE_ID        NUMBER NOT NULL,
                       OVERRIDE_ID          NUMBER NOT NULL,
                       TIME_APPLIED         TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL,
                       DISTRIBUTED_VERSION  VARCHAR2(255 CHAR),
                       CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,                   
                       CONSTRAINT PK_SITES_MSO_OVERRIDE_HISTORY PRIMARY KEY(OVERRIDE_HISTORY_ID),
                       CONSTRAINT FK_SITES_MOH_SITE_TITLE FOREIGN KEY (SITE_TITLE_ID) REFERENCES '||vschema||'.SITES_DISTSITETITLE(TITLEID),
                       CONSTRAINT FK_SITES_MOH_OVERRIDE_ID FOREIGN KEY (OVERRIDE_ID)  REFERENCES '||vschema||'.SITES_MSO_OVERRIDE(OVERRIDE_ID)
                   )';
         CREATEOBJECT(VSQL,'Unable to create table SITES_MSO_OVERRIDE_HISTORY','Y');
         CREATESEQ('SITES_MSO_OVERRIDE_HISTORY');
         CREATEUPDATETRG('SITES_MSO_OVERRIDE_HISTORY');

         -- Daniel Weiner added CRITERIAMODE column to TRE_TITLEFILTER table on 02/07/2012.
         vsql := 'ALTER TABLE '||vschema||'.TRE_TITLEFILTER ADD(CRITERIAMODE NUMBER DEFAULT 0 NOT NULL)';
         CREATEOBJECT(VSQL,'Unable to added CRITERIAMODE column to '||vschema||'TRE_TITLEFILTER table.','Y');

         vsql := 'INSERT INTO '||vschema||'.TRE_PACKAGE (PACKAGEID, N_VERSION, NAME) VALUES(6,1,''LICENSING'')';
         CREATEOBJECT(VSQL,'Unable to INSERT LICENSING record into '||vschema||'.TRE_PACKAGE table.','Y');

         --Raj dropped table PMM_PITCHFREQUENCY on 02/07/2012.
         vsql := 'drop table '||vschema||'.PMM_PITCHFREQUENCY';
         CREATEOBJECT(VSQL,'Unable to drop table '||vschema||'.PMM_PITCHFREQUENCY.','Y');

         vsql := 'drop sequence '||vschema||'.PMM_PitchFrequency_SEQ';
         createobject(vsql,'Unable to drop sequence '||vschema||'.PMM_PitchFrequency_SEQ.','Y');

         vsql := 'ALTER TABLE '||vschema||'.PMM_TitleList MODIFY (PITCHDATE TIMESTAMP(6))';
         createobject(vsql,'Unable to ALTER TABLE '||vschema||'.PMM_TitleList column PITCHDATE.','Y');    

         VSQL := 'UPDATE '||VSCHEMA||'.PMM_TitleList SET PITCHDATE = TO_DATE(TO_CHAR(PITCHDATE,''mm/dd/yyyy''),''mm/dd/yyyy'')';
         createobject(vsql,'Unable to UPDATE '||vschema||'.PMM_TitleList PITCHDATE TIME TO 00:00:00.','Y');
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.18''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.18.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.17.0 to 3.2.18.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.18.0(CMS 2.5.000.6) to 3.2.19.0(CMS 2.5.010.xx)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.18'  THEN 

         -- Stephen Zack Updated start and end date records of CAT_FIELD_SCHEMA tables on 12/15/2011
         vsql := 'UPDATE '||vschema||'.CAT_FIELD_SCHEMA SET DISPLAY_TYPE=''DatePicker'' where NAME in (''Start Date'',''End Date'')';
         createobject(vsql,'Unable to UPDATE '||vschema||'.CAT_FIELD_SCHEMA DISPLAY_TYPE of Start and End Date to DatePicker.','Y');    

         -- Bak and Eugene added Series and Category default content classes on 02/10/2012.
         vsql := 'INSERT INTO '||vschema||'.pmm_content_class (id, name, description, is_default, data, content_class_type_id) VALUES ('||vschema||'.PMM_CONTENT_CLASS_SEQ.nextval, '||
                         '''Series'', ''Series content class'', 0, XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''series_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL(),1)';
         createobject(vsql,'Unable to INSERT series_content_class INTO '||vschema||'.pmm_content_class.','Y');

         vsql := 'INSERT INTO '||vschema||'.pmm_content_class (id, name, description, is_default, data, content_class_type_id) VALUES ('||vschema||'.PMM_CONTENT_CLASS_SEQ.nextval, '||
                         '''Category'', ''Category content class'', 0, XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''category_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL(),2)';
         createobject(vsql,'Unable to INSERT category_content_class INTO '||vschema||'.pmm_content_class.','Y');

        -- creating the PARTNER and CONTENT_CLASS relation for partner type 0 and 2 and content_class type series and category.
         vsql := 'INSERT INTO '||vschema||'.pmm_content_class_partner (content_class_id, partner_id) '||
                         ' SELECT cc.id, p.id_ FROM '||vschema||'.pmm_partner p, '||vschema||'.pmm_content_class cc '||
                                ' WHERE p.partnertype in (0,2) AND cc.content_class_type_id in (1,2) and cc.name in (''Series'',''Category'')';
         createobject(vsql,'Unable to INSERT INTO '||vschema||'.pmm_content_class_partner for Series and Category records.','Y');

         -- Murtaza added seriesxml_idx on 02/24/2012.
         vsql := 'BEGIN
                   dbms_xmlindex.registerparameter(
                      ''ecmfseriesxml_idx'',
                      ''ADD_GROUP GROUP ecmfseriesfields
                      XMLTable ecmfseries_tab ''''/ECMFSpec/Series/Season''''
                      COLUMNS SeriesAssetID number path ''''@assetId'''',
                      SeriesAssetName varchar2(4000) path ''''Fields/AssetName'''',
                      SeriesSeasonID varchar2(4000) path ''''Fields/SeasonID/Id''''
                      '');
                END;';
         createobject(vsql,'Unable to registerparameter for ecmfseriesxml_idx xml index.','Y');

         VSQL := 'ALTER INDEX '||VSCHEMA||'.ecmfspec_xmlindex parameters(''PARAM ecmfseriesxml_idx'')';
         CREATEOBJECT(vsql,'Unable to ALTER INDEX '||vschema||'.ecmfseriesxml_idx parameters','Y');

           -- Anuj Jain updated the file CAT_FIELD_SCHEMA to disable the custom fields.
          VSQL := 'UPDATE '||vschema||'.CAT_FIELD_SCHEMA set IS_ENABLED=''F'' where name=''Custom Fields''';
          createobject(vsql,'Unable to UPDATE '||vschema||'.CAT_FIELD_SCHEMA to disable the custom fields','Y');

          -- Bak provided modified series content class xml.
          VSQL := 'update '||vschema||'.PMM_CONTENT_CLASS set data=xmltype(BFILENAME(''ECMFXMLDIR'', ''series_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL() where name=''Series''';
          createobject(vsql,'Unable to update '||vschema||'.PMM_CONTENT_CLASS to update the series_content_class.xml','Y');

          -- Sanjay modifications on 02/28/2012 to SITES_MSO_OVERRIDE_HISTORY table.
          vsql := 'ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY ADD (
                         FIELD_XPATH       VARCHAR2(1000) DEFAULT '''' NOT NULL,
                         SEARCH_VALUE      VARCHAR2(1000) DEFAULT '''' NOT NULL,
                         REPLACEMENT_VALUE VARCHAR2(1000) DEFAULT '''' NOT NULL,
                         MSO_ID            NUMBER)';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY to add 4 new columns.','Y');

          vsql := 'UPDATE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY moh SET moh.mso_id = (SELECT mo.mso_id FROM '||vschema||'.sites_mso_override mo WHERE mo.override_id = moh.override_id)';
          createobject(vsql,'Unable to UPDATE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY mso_id data','Y');
          
          vsql := 'ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY MODIFY MSO_ID NUMBER NOT NULL';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY MODIFY MSO_ID','Y');

          vsql := 'ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY ADD CONSTRAINT FK_SITES_MOH_MSO_ID FOREIGN KEY (MSO_ID) REFERENCES '||vschema||'.SITES_MSO(MSO_ID)';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY ADD CONSTRAINT FK_SITES_MOH_MSO_ID','Y');

          vsql := 'ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY DROP COLUMN OVERRIDE_ID';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY DROP COLUMN OVERRIDE_ID','Y');

          -- Suresh removed the recreate_xml_indexes from db_evolve script and moved to upgrade path, since the db_evolve script is running prior to db_upgrade.      
          -- Commenting out. Calling now in latest CMS 3.1 upgrade path.
          /* recreate_xml_indexes; */
          
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''3.2.19''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''3.2.19.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.18.0 to 3.2.19.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;


/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.19.0(CMS 2.5.000.12) to 3.2.20.0(CMS 2.5.000.16)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.19'  THEN 
         -- Eugene provided revised Category content classes on 03/08/2012.
         VSQL := 'UPDATE '||VSCHEMA||'.pmm_content_class set data=XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''category_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL() WHERE name = ''Category''';
         CREATEOBJECT(VSQL,'Unable to UPDATE category_content_class in '||vschema||'.pmm_content_class.','Y');

         -- Bak provided revised Seriescontent classes on 03/13/2012.
         VSQL := 'UPDATE '||VSCHEMA||'.pmm_content_class set data=XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''series_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL() WHERE name = ''Series''';
         createobject(vsql,'Unable to UPDATE series_content_class in '||vschema||'.pmm_content_class.','Y');

         -- Raj request to add a one column new table in the upgrade path
         VSQL := 'CREATE TABLE '||VSCHEMA||'.TMP_UPGRADE(
                         value varchar2(100 byte),
                         createdate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         updatedate  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT pk_tmp_upgrade PRIMARY KEY (value)
                         )';
         CREATEOBJECT(VSQL,'Unable to CREATE TABLE '||VSCHEMA||'.TMP_UPGRADE.','Y');
         CREATEUPDATETRG('TMP_UPGRADE');
                       
          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_SETTINGS SET setting_value=''3.2.20''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_RELEASE  SET setting_value=''3.2.20.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.19.0 to 3.2.20.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;
/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.20.0(CMS 2.5.000.16) to 3.2.21.0(CMS 2.5.000.21)
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.20'  THEN 
         -- Added missing lookup key values to fix bug no.3730 on 03/21/2012.
          VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ((select id from '||vschema||'.CMS_LOOKUP_KEY where name=''ORIGINAL''),''SERIES'')';
          CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record SERIES','Y');
      
          VSQL := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ((select id from '||vschema||'.CMS_LOOKUP_KEY where name=''ORIGINAL''),''SEASON'')';
          CREATEOBJECT(VSQL,'Unable to insert into CMS_LOOKUP_KEY_ASSET_TYPE record SEASON','Y');

          -- Suneeta added new columns in series/seasons index on 03/21/2012.
          -- commenting out. Calling now later in CMS 3.1.x upgrade path
          /* recreate_xml_indexes; */

          -- Suresh changes on 03/26/2012 for max value of user, role, module, and permission sequence.
          VSQL := 'DECLARE
                     TYPE SEQUENCELIST IS VARRAY(4) OF VARCHAR2(30);
                     SEQ_LIST SEQUENCELIST;
                     SEQ_NEXT_VAL NUMBER;
                     TBL_MAX_VAL  NUMBER;
                     SEQ_NEWVAL NUMBER;
                   BEGIN
                     SEQ_LIST := SEQUENCELIST(''USER'',''ROLE'',''MODULE'',''PERMISSION'');
                     FOR I IN SEQ_LIST.FIRST .. SEQ_LIST.LAST LOOP
                       EXECUTE IMMEDIATE ''SELECT '||vschema||'.CMS_''||SEQ_LIST(I)||''_SEQ.NEXTVAL FROM DUAL'' INTO SEQ_NEXT_VAL;
                       EXECUTE IMMEDIATE ''SELECT NVL(MAX(''||SEQ_LIST(I)||''ID),0) FROM '||vschema||'.CMS_''||SEQ_LIST(I) INTO TBL_MAX_VAL;
                       IF TBL_MAX_VAL > SEQ_NEXT_VAL THEN 
                         FOR X IN (SEQ_NEXT_VAL+1) .. TBL_MAX_VAL LOOP
                           EXECUTE IMMEDIATE ''SELECT '||vschema||'.CMS_''||SEQ_LIST(I)||''_SEQ.NEXTVAL FROM DUAL'' INTO SEQ_NEWVAL;
                         END LOOP;
                       END IF;
                       SEQ_NEXT_VAL:=0;
                       TBL_MAX_VAL:=0;
                     END LOOP;
                   END;';
          CREATEOBJECT(VSQL,'Unable to ALTER USER, ROLE, MODULE AND PERMISSION SEQUENCES.','Y');

          VSQL := 'DECLARE
                     SEQ_NEXT_VAL NUMBER;
                     TBL_MAX_VAL  NUMBER;
                     SEQ_NEWVAL NUMBER;
                   BEGIN
                     EXECUTE IMMEDIATE ''SELECT '||vschema||'.CMS_USER_PREFERENCES_SEQ.NEXTVAL FROM DUAL'' INTO SEQ_NEXT_VAL;
                     EXECUTE IMMEDIATE ''SELECT NVL(MAX(ID),0) FROM '||vschema||'.CMS_USER_PREFERENCES'' INTO TBL_MAX_VAL;
                     IF TBL_MAX_VAL > SEQ_NEXT_VAL THEN 
                       FOR X IN (SEQ_NEXT_VAL+1) .. TBL_MAX_VAL LOOP
                         EXECUTE IMMEDIATE ''SELECT '||vschema||'.CMS_USER_PREFERENCES_SEQ.NEXTVAL FROM DUAL'' INTO SEQ_NEWVAL;
                       END LOOP;
                     END IF;
                   END;';
          CREATEOBJECT(VSQL,'Unable to ALTER SEQUENCE CMS_USER_PREFERENCES_SEQ.','Y');

         -- Bak provided revised Seriescontent classes on 03/28/2012.
         VSQL := 'UPDATE '||VSCHEMA||'.pmm_content_class set data=XMLTYPE(BFILENAME(''ECMFXMLDIR'', ''series_content_class.xml''),NLS_CHARSET_ID(''AL32UTF8'')).GETCLOBVAL() WHERE name = ''Series''';
         createobject(vsql,'Unable to UPDATE series_content_class in '||vschema||'.pmm_content_class.','Y');

          -- Suresh dropped index UNQ_ASSET_MAP_ASSET_TITLE_ID on table CMS_ASSETLIST_ASSET_MAP on 03/30/2012.
          vsql := 'DROP INDEX '||vschema||'.UNQ_ASSET_MAP_ASSET_TITLE_ID';
          CREATEOBJECT(vsql,'Unable to drop index UNQ_ASSET_MAP_ASSET_TITLE_ID','Y');

          BEGIN
            EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_SETTINGS SET setting_value=''3.2.21''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_RELEASE  SET setting_value=''3.2.21.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.20.0 to 3.2.21.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.21.0(CMS 2.5.000.21) to 3.2.22.0(CMS 2.5.000.25) 
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.21'  THEN 
         -- Sanjay changes on 04/12/2012 to drop constraint fk_sites_moh_site_title
          VSQL := 'alter table '||VSCHEMA||'.sites_mso_override_history drop constraint fk_sites_moh_site_title';
          CREATEOBJECT(VSQL,'Unable to drop constraint fk_sites_moh_site_title','Y');

          begin
            execute immediate 'UPDATE '||VSCHEMA||'.SYSTEM_SETTINGS SET setting_value=''3.2.22''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_RELEASE  SET setting_value=''3.2.22.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.21.0 to 3.2.22.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;

/*
    ----------------------------------------------------------------------------------------------
            Start of Convert release 3.2.22.0(CMS 2.5.000.25) to 3.3.0.0(CMS 3.0.000.xx) -- chg 1 
    ----------------------------------------------------------------------------------------------
*/
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '3.2.22'  THEN 
         -- Anna changes on 06/07/2012 to create custom field group and field tables
          vsql := 'CREATE TABLE '||vschema||'.MDM_CUSTOM_FIELD_GROUP (
                         GROUP_ID     NUMBER NOT NULL,
                         NAME         VARCHAR2(255) ,
                         DISPLAY_NAME VARCHAR2(255) NOT NULL,
                         ASSET_PATH   VARCHAR2(255) NOT NULL,
                         CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT mdm_custom_field_group_pk PRIMARY KEY (GROUP_ID)
                         )';
          CREATEOBJECT(vsql,'Unable to create table MDM_CUSTOM_FIELD_GROUP','Y');
          CREATESEQ('MDM_CUSTOM_FIELD_GROUP'); 
          CREATEUPDATETRG('MDM_CUSTOM_FIELD_GROUP');

          vsql := 'CREATE TABLE '||vschema||'.MDM_CUSTOM_FIELD (
                         CUSTOM_FIELD_ID        NUMBER NOT NULL,
                         NAME                   VARCHAR2(255) NOT NULL,
                         DATA_TYPE              VARCHAR2(20),
                         DROP_DOWN              VARCHAR2(1),
                         JOB_PARAMETER          VARCHAR2(1),
                         JOB_SCHEDULE_PARAMETER VARCHAR2(1),
                         GROUP_ID               NUMBER NOT NULL,
                         DISPLAY_NAME           VARCHAR2(255) NOT NULL,
                         CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                         CONSTRAINT mdm_custom_field_pk PRIMARY KEY (CUSTOM_FIELD_ID),
                         CONSTRAINT fk_mdm_custom_field_group_id FOREIGN KEY(GROUP_ID) 
                             REFERENCES '||vschema||'.MDM_CUSTOM_FIELD_GROUP(GROUP_ID)
                         )';
          CREATEOBJECT(vsql,'Unable to create table MDM_CUSTOM_FIELD','Y');
          CREATESEQ('MDM_CUSTOM_FIELD'); 
          CREATEUPDATETRG('MDM_CUSTOM_FIELD');

          begin
            execute immediate 'UPDATE '||VSCHEMA||'.SYSTEM_SETTINGS SET setting_value=''3.3.0''   WHERE setting_type = ''RELEASE''';  
            EXECUTE IMMEDIATE 'UPDATE '||VSCHEMA||'.SYSTEM_RELEASE  SET setting_value=''3.3.0.0'' WHERE setting_type = ''RELEASE''';  
            EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg :=SUBSTR(SQLERRM, 1, 500);
            dbms_output.put_line('convertwfs error:'||err_msg);
            execute immediate 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
                            'Unable update '||vschema||'.SYSTEM_SETTINGS from 3.2.22.0 to 3.3.0.0'')';
                EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
              GOTO BYPASS_INSTALL; 
          END;
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release 3.3.0.0(CMS 3.0.000.xx) to 3.3.1.0(CMS 3.0.000.xx) -- chg 2 
    ---------------------------------------------------------------------------------------------- 
*/
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF wk_release =  '3.3.0'  THEN 
         -- Anna changes on 06/22/2012 to add column uuid in custom field group table
          vsql := 'ALTER TABLE '||vschema||'.MDM_CUSTOM_FIELD_GROUP ADD UUID VARCHAR2(255)';
          CREATEOBJECT(vsql,'Unable to ALTER table MDM_CUSTOM_FIELD_GROUP to ADD COLUMN UUID','Y');
          set_version('3.3.0','3.3.1');
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release 3.3.1.0(CMS 3.0.000.xx) to 3.3.2.0(CMS 3.0.000.xx) -- chg 3 
    ---------------------------------------------------------------------------------------------- 
*/
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF wk_release =  '3.3.1'  THEN 
          -- Steve added six Metadata Enhancement tables on 06/22/2012.
          vsql := 'CREATE TABLE '||vschema||'.ME_SUBS_PROFILE (	
                       ID          NUMBER, 
                       NAME        VARCHAR2(4000) NOT NULL, 
                       CONNECTION  VARCHAR2(4000) NOT NULL, 
                       PLUGIN_NAME VARCHAR2(4000) NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT  ME_PROFILE_PK PRIMARY KEY (ID),
                       CONSTRAINT  ME_PROFILE_UK1 UNIQUE (NAME))';
          CREATEOBJECT(vsql,'Unable to create table ME_SUBS_PROFILE','Y');
          CREATESEQ('ME_SUBS_PROFILE',1000); 
          CREATEUPDATETRG('ME_SUBS_PROFILE');
          
          vsql := 'CREATE TABLE '||vschema||'.ME_CACHE_RESULT (	
                       ID            NUMBER, 
                       TITLE_ID      NUMBER NOT NULL, 
                       PROFILE_ID    NUMBER NOT NULL, 
                       REQUEST_KEY   VARCHAR2(400) NOT NULL, 
                       RESULT_WEIGHT NUMBER DEFAULT 0, 
                       REMOTE_ID     VARCHAR2(1000) NOT NULL, 
                       NAME          VARCHAR2(4000) NOT NULL, 
                       YEAR          NUMBER NOT NULL, 
                       TYPE          VARCHAR2(4000) NOT NULL, 
                       THUMBNAIL     VARCHAR2(4000), 
                       ACTORS        VARCHAR2(4000), 
                       RANKING       NUMBER, 
                       ENHANCED_FIELDS CLOB,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT ME_CACHE_RESULT_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_CACHE_RESULT_UK1 UNIQUE (TITLE_ID, PROFILE_ID, REQUEST_KEY, REMOTE_ID),
                       CONSTRAINT ME_CACHE_RESULT_ME_PROFIL_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID),
                       CONSTRAINT ME_CACHE_RESULT_PMM_TITLE_FK1 FOREIGN KEY (TITLE_ID) REFERENCES '||vschema||'.PMM_TITLE (ID_)
                       ) LOB (ENHANCED_FIELDS) STORE AS BASICFILE';
          CREATEOBJECT(vsql,'Unable to create table ME_CACHE_RESULT','Y');
          CREATESEQ('ME_CACHE_RESULT',1000); 
          CREATEUPDATETRG('ME_CACHE_RESULT');
          
          vsql := 'CREATE TABLE '||vschema||'.ME_FIELD_DEFINITION (	
                       ID         NUMBER, 
                       SOURCE     VARCHAR2(100)  NOT NULL, 
                       PATH       VARCHAR2(4000) NOT NULL, 
                       DATATYPE   VARCHAR2(100)  NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT ME_FIELD_DEFINITION_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_FIELD_DEFINITION_UK1 UNIQUE (SOURCE, PATH))';
          CREATEOBJECT(vsql,'Unable to create table ME_FIELD_DEFINITION','Y');
          CREATESEQ('ME_FIELD_DEFINITION',1000); 
          CREATEUPDATETRG('ME_FIELD_DEFINITION');
          
          vsql := 'CREATE TABLE '||vschema||'.ME_ENHANCED_FIELD (	
                       ID         NUMBER, 
                       PROFILE_ID NUMBER NOT NULL, 
                       FIELD_ID   NUMBER NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT ME_ENHANCED_FIELDS_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_ENHANCED_FIELDS_UK1 UNIQUE (PROFILE_ID, FIELD_ID),
                       CONSTRAINT ME_ENHANCED_FIELDS_ME_FIE_FK1 FOREIGN KEY (FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                       CONSTRAINT ME_ENHANCED_FIELDS_ME_PRO_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID))';
          CREATEOBJECT(vsql,'Unable to create table ME_ENHANCED_FIELD','Y');
          CREATESEQ('ME_ENHANCED_FIELD',1000); 
          CREATEUPDATETRG('ME_ENHANCED_FIELD');
          
          vsql := 'CREATE TABLE '||vschema||'.ME_IDENTIFIER_KEY (	
                       ID             NUMBER, 
                       PROFILE_ID     NUMBER NOT NULL, 
                       KEY_FIELD_ID   NUMBER NOT NULL, 
                       VALUE_FIELD_ID NUMBER NOT NULL,
                       CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT ME_IDENTIFIER_KEY_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_IDENTIFIER_KEY_UK1 UNIQUE (PROFILE_ID, KEY_FIELD_ID, VALUE_FIELD_ID),
                       CONSTRAINT ME_IDENTIFIER_KEY_ME_FIEL_FK1 FOREIGN KEY (KEY_FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                       CONSTRAINT ME_IDENTIFIER_KEY_ME_FIEL_FK2 FOREIGN KEY (VALUE_FIELD_ID) REFERENCES '||vschema||'.ME_FIELD_DEFINITION (ID),
                       constraint ME_IDENTIFIER_KEY_ME_PROF_FK1 foreign key (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE (ID))';
          CREATEOBJECT(vsql,'Unable to create table ME_IDENTIFIER_KEY','Y');
          CREATESEQ('ME_IDENTIFIER_KEY',1000); 
          CREATEUPDATETRG('ME_IDENTIFIER_KEY');
    
          vsql := 'CREATE TABLE '||vschema||'.ME_SUBS_PROFILE_PARAMETER (	
                       ID         NUMBER, 
                       PROFILE_ID NUMBER NOT NULL, 
                       NAME       VARCHAR2(4000) NOT NULL, 
                       VALUE      VARCHAR2(4000),
                       CREATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT ME_SUBS_PROFILE_PARAMETER_PK PRIMARY KEY (ID),
                       CONSTRAINT ME_SUBS_PROFILE_PARAMETER_UK1 UNIQUE (PROFILE_ID, NAME),
                       CONSTRAINT ME_SUBS_PROFILE_PARAMETER_FK1 FOREIGN KEY (PROFILE_ID) REFERENCES '||vschema||'.ME_SUBS_PROFILE(ID))';
          CREATEOBJECT(vsql,'Unable to create table ME_SUBS_PROFILE_PARAMETER','Y');
          CREATESEQ('ME_SUBS_PROFILE_PARAMETER',1000); 
          CREATEUPDATETRG('ME_SUBS_PROFILE_PARAMETER');
          set_version('3.3.1','3.3.2');
        END IF;

/*  ----------------------------------------------------------------------------------------------
            Start of Convert release 3.3.2.0(CMS 3.0.000.xx) to 3.3.3.0(CMS 3.0.000.xx) -- chg 4 
    ---------------------------------------------------------------------------------------------- 
*/
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.2'  THEN 

          VSQL := 'ALTER TABLE '||VSCHEMA||'.SCH_PASTEXECUTION  ADD(ORIG_EXECUTION_TIME TIMESTAMP,FINISHED  NUMBER(1,0))';
          createobject(vsql,'Unable to ALTER TABLE '||vschema||'.SCH_PASTEXECUTION  ORIG_EXECUTION_TIME,FINISHED','Y');
         
          VSQL := 'CREATE TABLE '||VSCHEMA||'.SCH_PASTEXECUTIONDATA (
                      PASTEXEC_ID   NUMBER    NOT NULL,
                      NAME          VARCHAR2(255) NOT NULL,
                      VALUE         BLOB,
                      CONSTRAINT SCH_PASTEXEDATA_PK PRIMARY KEY (PASTEXEC_ID,NAME),
                      CONSTRAINT SCH_PASTEXEDATA_FK1 FOREIGN KEY (PASTEXEC_ID) REFERENCES '||vschema||'.SCH_PASTEXECUTION(ID))';
          CREATEOBJECT(vsql,'Unable to create table SCH_PASTEXECUTIONDATA','Y');
          set_version('3.3.2','3.3.3');
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.3.0(CMS 3.0.000.xx) to 3.3.4.0(CMS 3.0.000.xx) -- chg 5 (sprint-3) 
    ---------------------------------------------------------------------------------------------- 
*/
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.3'  THEN 

          VSQL := 'ALTER TABLE '||vschema||'.mdm_custom_field ADD (multivalue VARCHAR(1 CHAR), field_type NUMBER(3) DEFAULT 1 NOT NULL)';
          createobject(vsql,'Unable to alter table '||vschema||'.mdm_custom_field to add multivalue and field_type columns.','Y');

          VSQL := 'ALTER TABLE '||VSCHEMA||'.mdm_custom_field DROP COLUMN drop_down';
          createobject(vsql,'Unable to alter table '||VSCHEMA||'.mdm_custom_field  drop column DROP_DOWN','Y');
          set_version('3.3.3','3.3.4');
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.4.0(CMS 3.0.000.xx) to 3.3.5.0(CMS 3.0.000.xx) -- chg 6  
    ---------------------------------------------------------------------------------------------- 
*/
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.4'  THEN 
          CreateMetaEnhancement();        
          set_version('3.3.4','3.3.5');
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.5.0(CMS 3.0.000.xx) to 3.3.6.0(CMS 3.0.000.xx) -- chg 7  
    ---------------------------------------------------------------------------------------------- 
*/
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.5'  THEN 
          VSQL := 'ALTER TABLE '||VSCHEMA||'.ME_FIELD_DEFINITION DROP CONSTRAINT ME_FIELD_DEFINITION_UK1 DROP INDEX';
          createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_FIELD_DEFINITION DROP CONSTRAINT ME_FIELD_DEFINITION_UK1 DROP INDEX','Y');       

          VSQL := 'ALTER TABLE '||VSCHEMA||'.sch_ruleparameter MODIFY value VARCHAR2(1000 CHAR)';
          createobject(vsql,'Unable to alter table '||VSCHEMA||'.sch_ruleparameter MODIFY value VARCHAR2(1000 CHAR)','Y');
          set_version('3.3.5','3.3.6');
        END IF;
/*  ----------------------------------------------------------------------------------------------
            Start of Convert release from 3.3.6.0(CMS 3.0.000.xx) to 3.3.7.0(CMS 3.0.000.xx) -- chg 8  
    ---------------------------------------------------------------------------------------------- 
*/
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.6'  THEN 
          VSQL := 'alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA drop constraint ME_IDENTIFIER_CRITERIA_UK1 drop index';
          createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA drop constraint ME_IDENTIFIER_CRITERIA_UK1','Y');       

          VSQL := 'alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA add (constraint ME_IDENTIFIER_CRITERIA_UK1 UNIQUE (PROFILE_ID, KEY_FIELD_ID))';
          createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_IDENTIFIER_CRITERIA add constraint ME_IDENTIFIER_CRITERIA_UK1 UNIQUE (PROFILE_ID, KEY_FIELD_ID))','Y');
          set_version('3.3.6','3.3.7');
        END IF;

/*---- Start of Convert release from 3.3.7.0(CMS 3.0.000.xx) to 3.3.8.0(CMS 3.0.000.xx) -- chg 9 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;

        IF WK_RELEASE =  '3.3.7'  THEN 
          VSQL := 'alter table '||VSCHEMA||'.ME_CACHE_RESULT  modify (REMOTE_ID NULL, YEAR NULL)';
          createobject(vsql,'Unable to alter table '||VSCHEMA||'.ME_CACHE_RESULT  TO modify REMOTE_ID and YEAR columns to NULL)','Y');       
          set_version('3.3.7','3.3.8');
        END IF;

/*---- Start of Convert release from 3.3.8.0(CMS 3.0.000.xx) to 3.3.9.0(CMS 3.0.000.xx) -- chg 10 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;

        IF WK_RELEASE =  '3.3.8'  THEN 
          VSQL := 'update '||VSCHEMA||'.sch_pastexecution set orig_execution_time = execution_time, finished = 1';
          createobject(vsql,'Unable to update '||VSCHEMA||'.sch_pastexecution set orig_execution_time and finished columns.','Y');

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION (
                       CORRELATIONID      VARCHAR2(128 BYTE),
                       WORKFLOWREFERNCEID VARCHAR2(256 BYTE),
                       FINISHED           NUMBER(1,0) DEFAULT(0),
                       CREATEDATE         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT TRE_BULKEXEC_CORRELATIONID_PK PRIMARY KEY ("CORRELATIONID"))';
          CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION','Y');
          CREATEUPDATETRG('TRE_BULKEXECUTION');

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_CONTENTPROC (
                       correlationId REFERENCES '||vschema||'.tre_bulkExecution,
                       titleId       REFERENCES '||vschema||'.pmm_title,
                       ruleSetId     REFERENCES '||vschema||'.Tre_RuleSet,
                       CREATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT TRE_BULK_CONTENTPROC_CORRID_PK PRIMARY KEY(correlationId, titleId, ruleSetId))';
          CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION_CONTENTPROC','Y');
          CREATEUPDATETRG('TRE_BULKEXECUTION_CONTENTPROC');

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_GENERAL (
                       correlationId REFERENCES '||vschema||'.tre_bulkExecution,
                       titleId       REFERENCES '||vschema||'.pmm_title,
                       CREATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT TRE_BULK_GENERL_CORRID_PK     PRIMARY KEY(correlationId, titleId))';
          CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION_GENERAL','Y');
          CREATEUPDATETRG('TRE_BULKEXECUTION_GENERAL');

          vsql := 'CREATE TABLE '||vschema||'.TRE_BULKEXECUTION_FAILEDTITLES (
                       correlationId REFERENCES '||vschema||'.tre_bulkExecution,
                       titleId       REFERENCES '||vschema||'.pmm_title,
                       CREATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       UPDATEDATE    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                       CONSTRAINT TRE_BULK_FAILTITLES_CORRID_PK     PRIMARY KEY(correlationId, titleId))';
          CREATEOBJECT(vsql,'Unable to create table TRE_BULKEXECUTION_FAILEDTITLES','Y');
          CREATEUPDATETRG('TRE_BULKEXECUTION_FAILEDTITLES');
         set_version('3.3.8','3.3.9');
        END IF;

/*---- Start of Convert release from 3.3.9.0(CMS 3.0.000.xx) to 3.3.10.0(CMS 3.0.000.xx) -- chg 10 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.9'  THEN 
          VSQL := 'DROP TRIGGER '||vschema||'.TRE_BULKEXECUTIONTRG';
          createobject(vsql,'Unable to DROP TRIGGER '||vschema||'.TRE_BULKEXECUTIONTRG.','Y');       
          VSQL := 'DROP SEQUENCE '||vschema||'.TRE_BULKEXECUTION_SEQ';
          createobject(vsql,'Unable to DROP SEQUENCE '||vschema||'.TRE_BULKEXECUTION_SEQ.','Y');
          set_version('3.3.9','3.3.10');
        END IF;

/*---- Start of Convert release from 3.3.10.0(CMS 3.0.000.xx) to 3.3.11.0(CMS 3.0.000.xx) -- chg 11 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.10'  THEN 
          -- Vishal request on 08/24/2012.
          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Merge Failure Pattern'',''.*Merge failed for.*'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Translation Error Pattern'',''.*Failure to translate EPG error for.*'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Validation Rule Abort Pattern'',''.*Validation rule caused abort for.*'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Validation Rule Failed Pattern'',''.*Validation rule failed for.*'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

          vsql := 'Insert into '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''EPGManager Publish Failure Pattern'',''.*Failure to publish EPG data for.*'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
          values (''EPGManager Publish Failure'',''EPGManager Publish Failure Pattern'',1,60,1,60,''LOG'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
          values (''EPGManager Merge Failure Alert'',''EPGManager Merge Failure Pattern'',1,60,1,60,''LOG'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE)
          values (''EPGManager Translation Alert'',''EPGManager Translation Error Pattern'',1,60,1,60,''LOG'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
          values (''EPGManager Validation Rule Alert'',''EPGManager Validation Rule Failed Pattern'',1,60,1,60,''LOG'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

          vsql := 'Insert into '||vschema||'.ALERTS (IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE)
          values (''EPGManager Validation Rule Abort'',''EPGManager Validation Rule Abort Pattern'',1,60,1,60,''LOG'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

          vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) VALUES(''Login Failed'', 1, ''4'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    
    
          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Merge Failure Alert'',1,''19'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Publish Failure'',1,''20'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Translation Alert'',1,''16'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Validation Rule Alert'',1,''18'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    

          vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''EPGManager Validation Rule Abort'',1,''17'')';
          CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

          -- Suneeta Puranik request on 08/28/2012
          vsql := 'CREATE INDEX '||vschema||'.sites_mso_override_xpath_idx ON '||vschema||'.sites_mso_override(field_xpath)';
          CREATEOBJECT(vsql,'Unable to create index sites_mso_override_xpath_idx','Y'); 

          vsql := 'CREATE INDEX '||vschema||'.sites_mso_override_mso_idx ON '||vschema||'.sites_mso_override(mso_id)';
          CREATEOBJECT(vsql,'Unable to create index sites_mso_override_mso_idx','Y');

          vsql := 'CREATE INDEX '||vschema||'.sites_mso_site_idx ON '||vschema||'.sites_mso(site_id)';
          CREATEOBJECT(vsql,'Unable to create index sites_mso_site_idx','Y');
          set_version('3.3.10','3.3.11');
        END IF;

/*---- Start of Convert release from 3.3.11.0(CMS 3.0.000.xx) to 3.3.12.0(CMS 3.0.000.xx) -- chg 12 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.11'  THEN 
      -- Suneeta Puranik request on 08/29/2012
          vsql := 'CREATE INDEX '||vschema||'.sch_ruleparameter_value_idx ON '||vschema||'.sch_ruleparameter(value)';
          CREATEOBJECT(vsql,'Unable to create index sch_ruleparameter_value_idx','Y'); 

          vsql := 'CREATE INDEX '||vschema||'.sch_wojob_job_idx ON '||vschema||'.sch_wojob(jobid)';
          CREATEOBJECT(vsql,'Unable to create index sch_wojob_job_idx','Y');

          vsql := 'ALTER TABLE '||vschema||'.sch_job MODIFY (name VARCHAR2(300 CHAR))';
          CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.sch_job MODIFY name to 300 CHAR.','Y');
          set_version('3.3.11','3.3.12');
        END IF;

/*---- Start of Convert release from 3.3.12.0(CMS 3.0.000.xx) to 3.3.13.0(CMS 3.0.000.xx) -- chg 13 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.12'  THEN 
      -- 
          vsql := 'ALTER TABLE '||vschema||'.ME_IDENTIFIER_CRITERIA ADD (ASSET_TYPE VARCHAR2(255 CHAR))';
          CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.ME_IDENTIFIER_CRITERIA ADD (ASSET_TYPE VARCHAR2(255 CHAR))','Y'); 
          set_version('3.3.12','3.3.13');
        END IF;

/*---- Start of Convert release from 3.3.13.0(CMS 3.0.000.xx) to 3.3.14.0(CMS 3.0.000.xx) -- chg 14 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.13'  THEN 
          vsql := 'GRANT create view,SELECT ANY DICTIONARY TO WFS';
          CREATEOBJECT(vsql,'Unable to GRANT SELECT ANY DICTIONARY TO WFS','Y'); 
          set_version('3.3.13','3.3.14');
        END IF;

/*---- Start of Convert release from 3.3.14.0(CMS 3.0.000.xx) to 3.3.15.0(CMS 3.0.000.xx) -- chg 15 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.14'  THEN 
          vsql := 'INSERT INTO '||vschema||'.CMS_LOOKUP_KEY_ASSET_TYPE (ID_LOOKUP_KEY,ASSET_TYPE) VALUES ((select id from '||vschema||'.CMS_LOOKUP_KEY where name=''ORIGINAL''),''AUDIO'')';
          CREATEOBJECT(vsql,'Unable to Insert Asset Type AUDIO into CMS_LOOKUP_KEY_ASSET_TYPE','Y'); 
          set_version('3.3.14','3.3.15');
        END IF;

/*---- Start of Convert release from 3.3.15.0(CMS 3.0.000.xx) to 3.3.16.0(CMS 3.0.000.xx) -- chg 16 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.15'  THEN 
          vsql := 'ALTER TABLE '||vschema||'.pmm_properties MODIFY (name VARCHAR2(4000 CHAR))';
          CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.pmm_properties MODIFY (name VARCHAR2(4000 CHAR))','Y'); 
          set_version('3.3.15','3.3.16');
        END IF;

/*---- Start of Convert release from 3.3.16.0(CMS 3.0.000.xx) to 3.3.17.0(CMS 3.0.000.xx) -- chg 17 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.16'  THEN 
          vsql := 'create index '||vschema||'.idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_event on '||vschema||'.jbpm_action (event_)','Y'); 
          vsql := 'create index '||vschema||'.idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpmaction_exceptionhndlr on '||vschema||'.jbpm_action (exceptionhandler_)','Y');
          vsql := 'create index '||vschema||'.idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_transition_from on '||vschema||'.jbpm_transition (from_)','Y');
          vsql := 'create index '||vschema||'.idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_transition_to on '||vschema||'.jbpm_transition (to_)','Y');
          vsql := 'create index '||vschema||'.idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_jbpm_event_task_node on '||vschema||'.jbpm_event (task_,node_)','Y');

          vsql := 'create index '||vschema||'.idx_tre_action_ruleid on '||vschema||'.tre_action (ruleid)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_action_ruleid on '||vschema||'.tre_action (ruleid)','Y'); 
          vsql := 'create index '||vschema||'.idx_tre_actionparmval_actionid on '||vschema||'.tre_actionparametervalue(actionid)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_actionparmval_actionid on '||vschema||'.tre_actionparametervalue(actionid)','Y');
          vsql := 'create index '||vschema||'.idx_tre_expnode_parentid on '||vschema||'.tre_expnode(parentid)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_expnode_parentid on '||vschema||'.tre_expnode(parentid)','Y');
          vsql := 'create index '||vschema||'.idx_tre_rule_rulesetid on '||vschema||'.tre_rule(rulesetid)';
          CREATEOBJECT(vsql,'Unable to create index '||vschema||'.idx_tre_rule_rulesetid on '||vschema||'.tre_rule(rulesetid)','Y');

          vsql := 'alter table '||vschema||'.cms_assetlist add constraint unq_cms_assetlist_name UNIQUE (name)';
          CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.cms_assetlist add constraint unq_cms_assetlist_name UNIQUE (name)','Y');
          set_version('3.3.16','3.3.17');
        END IF;

/*---- Start of Convert release from 3.3.17.0(CMS 3.0.000.xx) to 3.3.18.0(CMS 3.0.000.xx) -- chg 18 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.17'  THEN 
          vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) VALUES (''Business Continuance status change pattern'',''.*Business continuance stat change.*'')';
          CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.alert_names record forBusiness Continuance status change pattern','Y');

          vsql := 'INSERT INTO '||vschema||'.ALERTS (IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) '||
                  ' VALUES (''Business Continuance status'',''Business Continuance status change pattern'',1,3600,1,3600,''LOG'')';
          CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ALERTS record for Business Continuance status change pattern','Y');

          vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER,ACTION_TYPE, DETAIL) VALUES (''Business Continuance status'',1,21)';
          CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.ALERT_ACTIONS record for Business Continuance status change pattern','Y');
          set_version('3.3.17','3.3.18');
        END IF;  

/*---- Start of Convert release from 3.3.18.0(CMS 3.0.000.xx) to 3.3.19.0(CMS 3.0.000.xx) -- chg 19 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.18'  THEN 
          VSQL := 'alter table '||VSCHEMA||'.SITES_MSO_OVERRIDE_HISTORY drop constraint FK_SITES_MOH_MSO_ID';
          CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_MSO_OVERRIDE_HISTORY to drop constraint FK_SITES_MOH_MSO_ID','Y');
          
          -- Sanjay request on 11/06/2012          
          vsql := 'alter table '||vschema||'.SITES_MSO_OVERRIDE_HISTORY add mso_name varchar2(1000)';
          CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_MSO_OVERRIDE_HISTORY add mso_name','Y');

          vsql := 'CREATE INDEX '||vschema||'.sites_mso_or_hist_msoid_idx ON '||vschema||'.SITES_MSO_OVERRIDE_HISTORY(MSO_ID)';
          CREATEOBJECT(vsql,'Unable to create index sites_mso_or_hist_msoid_idx','Y'); 
    
          VSQL := 'CREATE INDEX '||VSCHEMA||'.sites_mso_or_hist_tleid_idx ON '||VSCHEMA||'.SITES_MSO_OVERRIDE_HISTORY(SITE_TITLE_ID)';
          CREATEOBJECT(vsql,'Unable to create index sites_mso_or_hist_tleid_idx','Y');

          set_version('3.3.18','3.3.19');
        END IF;

/*---- Start of Convert release from 3.3.19.0(CMS 3.0.000.xx) to 3.3.20.0(CMS 3.0.000.xx) -- chg 20 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.19'  THEN 
          VSQL := 'update '||VSCHEMA||'.ALERT_NAMES set pattern=''.*Business continuance status change.*'' where alert_name=''Business Continuance status change pattern''';
          CREATEOBJECT(vsql,'Unable to update '||VSCHEMA||'.ALERT_NAMES set pattern=''.*Business continuance status change.*''','Y');

          vsql := 'CREATE INDEX '||vschema||'.idx_jbpm_vinstance_strval on  '||vschema||'.JBPM_VARIABLEINSTANCE(STRINGVALUE_)';
          CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_strval','Y'); 

          vsql := 'CREATE INDEX '||vschema||'.idx_jbpm_vinstance_longval ON '||vschema||'.JBPM_VARIABLEINSTANCE(LONGVALUE_)';
          CREATEOBJECT(vsql,'Unable to create index idx_jbpm_vinstance_longval','Y'); 

          set_version('3.3.19','3.3.20');
        END IF;

/*---- Start of Convert release from 3.3.20.0(CMS 3.0.000.xx) to 3.4.1 (CMS 3.1.000.xx) -- chg 1 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.3.20'  THEN 
          -- Francisco changes on 02/07/2013.
          vsql := 'CREATE TABLE '||vschema||'.CMS_SETTING_GROUP (
                    SETTINGGROUPID NUMBER(20),
                    GROUP_PATH     VARCHAR2(255) NOT NULL,
                    PARENT_PATH    VARCHAR2(255),
                    CREATEDATE	   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	   TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_SETTING_GROUP_SGID PRIMARY KEY (SETTINGGROUPID))';
          CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_SETTING_GROUP.','Y');
          CREATESEQ('CMS_SETTING_GROUP');
          CREATEUPDATETRG('CMS_SETTING_GROUP');

          VSQL := 'CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_GROUP_GRPPATH ON '||vschema||'.CMS_SETTING_GROUP(GROUP_PATH)';
          CREATEOBJECT(VSQL,'Unable to CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_GROUP_GRPPATH','Y');

          vsql := 'CREATE TABLE '||vschema||'.CMS_SETTING (
                    SETTINGID            NUMBER(20),
                    SETTING_NAME         VARCHAR2(255) NOT NULL,
                    SETTING_VALUE        CLOB,
                    CMS_SETTING_GROUP_ID NUMBER(20) NOT NULL,
                    CREATEDATE	         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	         TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT CMS_SETTING_SETTINGID_PK PRIMARY KEY (SETTINGID),
                    CONSTRAINT CMS_SETTING_SETTINGGROUPID_FK  FOREIGN KEY (CMS_SETTING_GROUP_ID) REFERENCES '||vschema||'.CMS_SETTING_GROUP(SETTINGGROUPID))';
          CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_SETTING.','Y');
          CREATESEQ('CMS_SETTING');
          CREATEUPDATETRG('CMS_SETTING');

          VSQL := 'CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_SNAME_GRPID ON '||vschema||'.CMS_SETTING(SETTING_NAME, CMS_SETTING_GROUP_ID)';
          CREATEOBJECT(VSQL,'Unable to CREATE UNIQUE INDEX '||vschema||'.IDX_CMS_SETTING_SNAME_GRPID','Y');

          --  Cherise Ho changes on 02/25/2013.
          vsql := 'CREATE TABLE '||vschema||'.CMS_COMPONENT (
                    COMPONENTID NUMBER(20),
                    NAME        VARCHAR2(100) NOT NULL,
                    BASEURL     VARCHAR2(200) NOT NULL,
                    STATUSID    NUMBER,
                    CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT CMS_COMPONENT_PK PRIMARY KEY (COMPONENTID),
                    CONSTRAINT CMS_COMPONENT_UKNAME UNIQUE (NAME))';
          CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_COMPONENT.','Y');
          CREATESEQ('CMS_COMPONENT');
          CREATEUPDATETRG('CMS_COMPONENT');

          VSQL := 'ALTER TABLE '||vschema||'.CMS_MODULE ADD (COMPONENTID NUMBER(20))';
          CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.CMS_MODULE TO ADD COLUMN COMPONENTID','Y');

          VSQL := 'CREATE INDEX '||vschema||'.IDX_CMS_COMPONENT_COMPID ON WFS.CMS_MODULE (COMPONENTID)';
          CREATEOBJECT(VSQL,'Unable to CREATE INDEX '||vschema||'.IDX_CMS_COMPONENT_COMPID','Y');

          VSQL := 'ALTER TABLE '||vschema||'.CMS_MODULE ADD (CONSTRAINT CMS_MODULE_UQ_NAME UNIQUE (MODULENAME, COMPONENTID), 
                        CONSTRAINT CMS_MODULE_UQ_DISPLAYNAME UNIQUE (DISPLAYNAME, COMPONENTID),
                        CONSTRAINT CMS_MODULE_COMPONENT_FK FOREIGN KEY (COMPONENTID) REFERENCES '||vschema||'.CMS_COMPONENT (COMPONENTID))';
          CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.CMS_MODULE ADD THREE CONSTRAINTS.','Y');

          vsql := 'CREATE TABLE '||vschema||'.CMS_PORTAL_USER_PREFERENCES (
                    ID           NUMBER(20),
                    USERNAME     VARCHAR2(100) NOT NULL,
                    COMPONENT    VARCHAR2(100) NOT NULL,
                    KEY          VARCHAR2(500) NOT NULL,
                    COLUMN_INDEX NUMBER(20),
                    ROW_INDEX    NUMBER(20),
                    WIDTH        NUMBER(20,4),
                    HEIGHT       NUMBER(20,4),
                    CREATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_CMS_PORTAL_PREFERENCES PRIMARY KEY (ID),
                    CONSTRAINT UQ_CMS_PORTAL_PREF UNIQUE (USERNAME, COMPONENT, KEY))';
          CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.CMS_PORTAL_USER_PREFERENCES.','Y');
          CREATESEQ('CMS_PORTAL_USER_PREFERENCES');
          CREATEUPDATETRG('CMS_PORTAL_USER_PREFERENCES');

          vsql := 'DECLARE
                      x NUMBER;
                    BEGIN
                      SELECT COUNT(*) INTO x FROM WFS.CMS_PORTAL_USER_PREFERENCES;
                      IF x = 0 THEN
                        /* default column settings */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, innerusertable.USERNAME, ''__column__0'', ''__column__0'', 0, -1, 0.5, -1
                          FROM (SELECT DISTINCT USERNAME FROM '||vschema||'.CMS_USER_PREFERENCES WHERE TYPE LIKE ''portlet.order'') innerusertable;
                        
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, innerusertable.USERNAME, ''__column__1'', ''__column__1'', 1, -1, 0.5, -1
                          FROM (SELECT DISTINCT USERNAME FROM '||vschema||'.CMS_USER_PREFERENCES WHERE TYPE LIKE ''portlet.order'') innerusertable;
                        
                        /* Content Portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, USERNAME, ''Content'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                            FROM '||vschema||'.CMS_USER_PREFERENCES
                           WHERE TYPE LIKE ''portlet.order''
                             AND KEY in (''ACTIVITY'', ''LAST_MODIFIED'');
                        
                        /* Content Trafficking Portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, USERNAME, ''Content Trafficking'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            AND KEY in (''ALERT_LIST'');
                        
                        /* Workflow portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, USERNAME, ''Workflow'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''ACTIVE_RESOURCES'', ''RESOURCE_LIST'', ''RESOURCE_GROUP_QUEUE_LIST'', ''USER_TASK_LIST'', ''WFS.QueuedUserTasksPortlet'', ''WO_STATUS'');
                        
                        /* External Tools portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, USERNAME, ''External Tools'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''CLICK_THROUGH'');
                        
                        /* Sites portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, USERNAME, ''Sites'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''DISTRIBUTION'');
                        
                        /* Scheduler portlets */
                        INSERT INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES (ID, USERNAME, COMPONENT, KEY, COLUMN_INDEX, ROW_INDEX, WIDTH, HEIGHT)
                          SELECT '||vschema||'.CMS_PORTAL_USER_PREFERENCE_SEQ.nextval, USERNAME, ''Scheduler'', KEY, mod(VALUE,2), trunc(VALUE/2), 0.5, 79
                          FROM '||vschema||'.CMS_USER_PREFERENCES
                          WHERE TYPE LIKE ''portlet.order''
                            and KEY in (''UPCOMINGJOBS'');
                      END IF;
                    END;';
          CREATEOBJECT(vsql,'Unable to INSERT '||vschema||'.CMS_USER_PREFERENCES data INTO '||vschema||'.CMS_PORTAL_USER_PREFERENCES','Y'); 

          set_version('3.3.20','3.4.1');
        END IF;

/*---- Start of Convert release from 3.4.1(CMS 3.0.000.xx) to 3.4.2 (CMS 3.1.000.xx) -- chg 2 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.1'  THEN 
          vsql := 'ALTER TABLE '||vschema||'.CMS_PORTAL_USER_PREFERENCES MODIFY (
                    WIDTH        NUMBER(24,4),
                    HEIGHT       NUMBER(24,4))';
          CREATEOBJECT(VSQL,'Unable to ALTER table '||vschema||'.CMS_PORTAL_USER_PREFERENCES.','Y');

          set_version('3.4.1','3.4.2');
        END IF;

/*---- Start of Convert release from 3.4.2(CMS 3.0.000.xx) to 3.4.3 (CMS 3.1.000.xx) -- chg 3 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.2'  THEN 
          -- Anna Simonenko changes on 03/04/2013.
          vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_MTM (
                    MSO_ID          NUMBER,
                    MSO_NAME        VARCHAR2(255) NOT NULL,
                    MSO_DESCRIPTION VARCHAR2(255),
                    CREATEDATE	    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_SITES_MSO_MTM_ID PRIMARY KEY (MSO_ID))';
          CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.SITES_MSO_MTM.','Y');
          CREATESEQ('SITES_MSO_MTM');
          CREATEUPDATETRG('SITES_MSO_MTM');

          vsql := 'CREATE TABLE '||vschema||'.SITES_MSO_SITE (
                    MSO_ID       NUMBER NOT NULL,
                    SITE_ID      NUMBER NOT NULL,
                    CREATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE	 TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_SITES_MSO_SITE_MSO_SITE PRIMARY KEY (MSO_ID, SITE_ID),
                    CONSTRAINT FK_SITES_MSO_SITE_MSO_ID FOREIGN KEY (MSO_ID) REFERENCES '||vschema||'.SITES_MSO_MTM (MSO_ID),
                    CONSTRAINT FK_SITES_MSO_SITE_SITE_ID FOREIGN KEY (SITE_ID) REFERENCES '||vschema||'.SITES_SITE (ID_))';
          CREATEOBJECT(VSQL,'Unable to create table '||vschema||'.SITES_MSO_SITE.','Y');
          CREATEUPDATETRG('SITES_MSO_SITE');

          set_version('3.4.2','3.4.3');
        END IF;

/*---- Start of Convert release from 3.4.3(CMS 3.0.000.xx) to 3.4.4 (CMS 3.1.000.xx) -- chg 4 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.3'  THEN       
          -- Daniel Weiner Added a new table tre_ruleset_mso on 03-06-2013
          vsql := 'CREATE TABLE '||vschema||'.tre_ruleset_mso (
                    rulesetid     NUMBER,
                    msoid         NUMBER,
                    createdate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    updatedate    TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT pk_tre_ruleset_mso_rs_msoid primary key(rulesetid, msoid),
                    CONSTRAINT fk_rulesetmso_ruleset FOREIGN KEY (rulesetid) REFERENCES '||vschema||'.tre_ruleset(rulesetid),  
                    CONSTRAINT fk_rulesetmso_mso FOREIGN KEY (msoid) REFERENCES '||vschema||'.sites_mso_mtm(mso_id))';
          CREATEOBJECT(vsql,'Unable to create table '||vschema||'.tre_ruleset_mso','Y');
          CREATEUPDATETRG('tre_ruleset_mso');

          vsql := 'ALTER TABLE '||vschema||'.tre_ruleset ADD (class_id VARCHAR2(10) DEFAULT ''RS'' NOT NULL)';
          CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.tre_ruleset to add column class_id.','Y');

          VSQL := 'begin dbms_stats.unlock_table_stats(''WFS'',''MDM_METADATA''); end;';
          CREATEOBJECT(VSQL,'Unable to unlock mdm_metadata stats');

          set_version('3.4.3','3.4.4');
        END IF;

/*---- Start of Convert release from 3.4.4(CMS 3.0.000.xx) to 3.4.5 (CMS 3.1.000.xx) -- chg 5 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.4'  THEN       
          -- Daniel added a new record for MSO Override in tre_package table on 03/08/2013.
          vsql := 'insert into '||vschema||'.Tre_PACKAGE(PACKAGEID, N_VERSION,NAME) values(7,1,''MSOOVERRIDE'')';
          createobject(vsql,'Unable to insert into Tre_PACKAGE','Y');

          set_version('3.4.4','3.4.5');
        END IF;

/*---- Start of Convert release from 3.4.5(CMS 3.0.000.xx) to 3.4.6 (CMS 3.1.000.xx) -- chg 6 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.5'  THEN 
          -- Daniel Weiner removed not null constraint from two columns of sites_mso_override_history table.
          vsql := 'ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY MODIFY (search_value NULL, replacement_value NULL)';
          CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.SITES_MSO_OVERRIDE_HISTORY MODIFY search_value and replacement_value to NULL','Y'); 

          set_version('3.4.5','3.4.6');
        END IF;

/*---- Start of Convert release from 3.4.6(CMS 3.0.000.xx) to 3.4.7 (CMS 3.1.000.xx) -- chg 7 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.6'  THEN 
          -- Anna Simonenko added new column ASSOCIATED_GROUP_NAME in sites_site table on 04/16/2013.
          vsql := 'ALTER TABLE '||vschema||'.sites_site ADD (ASSOCIATED_GROUP_NAME VARCHAR2(255))';
          CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.sites_site add column ASSOCIATED_GROUP_NAME.','Y'); 

          vsql := 'delete from '||vschema||'.ALERT_ACTIONS where IDENTIFIER=''Duplicate Parameters''';
          CREATEOBJECT(vsql,'Unable to delete record from '||vschema||'.ALERT_ACTIONS where IDENTIFIER=''Duplicate Parameters''','Y'); 

          vsql := 'delete from '||vschema||'.ALERTS where IDENTIFIER=''Duplicate Parameters''';
          CREATEOBJECT(vsql,'Unable to delete record from '||vschema||'.ALERTS where IDENTIFIER=''Duplicate Parameters''','Y'); 

          vsql := 'delete from '||vschema||'.ALERT_NAMES where ALERT_NAME=''Duplicate Parameters For Workorder Pattern''';
          CREATEOBJECT(vsql,'Unable to delete record from '||vschema||'.ALERT_NAMES where ALERT_NAME=''Duplicate Parameters For Workorder Pattern''','Y'); 

          set_version('3.4.6','3.4.7');
        END IF;

/*---- Start of Convert release from 3.4.7(CMS 3.0.000.xx) to 3.4.8 (CMS 3.1.000.xx) -- chg 8 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.7'  THEN 
          --- Raj altered Distribution and tracking sites tables to flashback archive on 04/18/2013.
          vsql :='DROP FLASHBACK ARCHIVE CMSFLASHBACK';
          CREATEOBJECT(vsql,'Unable to Drop Flashback Archive Cmsflashback.','Y');

          vsql :='drop tablespace WFS_data_archive including contents and datafiles';
          CREATEOBJECT(vsql,'DROP TABLESPACE WFS_data','Y');

          vsql :='create bigfile tablespace wfs_data_archive datafile size 100m autoextend on next 50m maxsize unlimited';
          CREATEOBJECT(VSQL,'Unable to create flashback archive default cmsflashback tablespace wfs_data.');
      
          vsql :='create flashback archive default cmsflashback tablespace wfs_data_archive retention 6 month';
          CREATEOBJECT(VSQL,'Unable to create flashback archive default cmsflashback tablespace wfs_data.');
          
          vsql :=  'grant flashback archive administer to WFS';
          CREATEOBJECT(vsql,'Unable to grant flashback archive administer to WFS.','Y');

          vsql := 'grant select on smon_scn_time to wfs';
          CREATEOBJECT(vsql,'Unable to grant select on smon_scn_time to wfs.','Y');

          vsql := 'create or replace public synonym smon_scn_time for sys.smon_scn_time';
          CREATEOBJECT(vsql,'Unable to create or replace public synonym smon_scn_time for sys.smon_scn_time.','Y');

          vsql := 'alter table '||vschema||'.SITES_DISTSITETITLE flashback archive';
          CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_DISTSITETITLE flashback archive.','Y'); 

          vsql := 'alter table '||vschema||'.SITES_TRACKSITETITLE flashback archive';
          CREATEOBJECT(vsql,'Unable to alter table '||vschema||'.SITES_TRACKSITETITLE flashback archive.','Y');

          RECREATE_XML_INDEXES;

          set_version('3.4.7','3.4.8');
        END IF;

/*---- Start of Convert release from 3.4.8(CMS 3.0.000.xx) to 3.4.9 (CMS 3.1.000.xx) -- chg 9 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.8'  THEN 
          --- Daniel added new column ACTION_NAME in sites_mso_override_history on 04/18/2013.
          vsql :='ALTER TABLE '||vschema||'.sites_mso_override_history ADD(ACTION_NAME VARCHAR2(255))';
          CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.sites_mso_override_history ADD column ACTION_NAME.','Y');

          vsql :=  'UPDATE '||vschema||'.sites_mso_override_history SET action_name = ''overrideLegacy''';
          CREATEOBJECT(vsql,'Unable to UPDATE action_name column in '||vschema||'.sites_mso_override_history.','Y');

          --- Suresh Neravati added a new column in system_settings table.
          vsql :='ALTER TABLE '||vschema||'.system_settings ADD(CREATEDATE TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL)';
          CREATEOBJECT(VSQL,'Unable to ALTER TABLE '||vschema||'.system_settings add column CREATEDATE.','Y');

          set_version('3.4.8','3.4.9');
        END IF;

/*---- Start of Convert release from 3.4.9(CMS 3.0.000.213) to 3.4.10 (CMS 3.1.000.xx) -- chg 10 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.9'  THEN 
          -- Suresh Neravati added a trigger system_settingsupd on 05/14/2013. 
          vsql :=  'CREATE OR REPLACE TRIGGER '||VSCHEMA||'.system_settingsupd before update ON '||VSCHEMA||'.system_settings FOR EACH ROW BEGIN  SELECT systimestamp INTO :new.createdate FROM dual; END;';
          CREATEOBJECT(vsql,'Unable to create trigger '||VSCHEMA||'.system_settingsupd','Y');

          set_version('3.4.9','3.4.10');
        END IF;

/*---- Start of Convert release from 3.4.10(CMS 3.0.000.213) to 3.4.11 (CMS 3.1.000.xx) -- chg 11 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.10'  THEN 
          -- Suresh Neravati added the index me_cache_result_request_idx on 05/16/2013.
          vsql := 'CREATE INDEX '||vschema||'.ME_CACHE_RESULT_REQUEST_IDX ON '||vschema||'.ME_CACHE_RESULT( REQUEST_ID)';
          CREATEOBJECT(vsql,'Unable to CREATE INDEX '||vschema||'.ME_CACHE_RESULT_REQUEST_IDX','Y');

          set_version('3.4.10','3.4.11');
        END IF;

/*---- Start of Convert release from 3.4.11(CMS 3.0.000.213) to 3.4.12 (CMS 3.1.000.xx) -- chg 12 --- */
        EXECUTE IMMEDIATE 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' INTO wk_release;
        IF WK_RELEASE =  '3.4.11'  THEN 
          vsql := 'ALTER TABLE '||vschema||'.CMS_ROLE ADD HIDDEN VARCHAR2(1 CHAR) DEFAULT 0 NOT NULL check (HIDDEN in (''0'',''1''))';
          CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_ROLE ADD HIDDEN column','Y');
          
          vsql := 'INSERT INTO '||vschema||'.CMS_ROLE(ROLE_NAME, DESCRIPTION, HIDDEN) VALUES(''_services_'', ''services role - system use only'', ''1'')';
          CREATEOBJECT(vsql,'Unable to insert into CMS_ROLE','Y');

          vsql := 'ALTER TABLE '||vschema||'.CMS_USER ADD HIDDEN VARCHAR2(1 CHAR) DEFAULT 0 NOT NULL check (HIDDEN in (''0'',''1''))';
          CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.CMS_USER ADD HIDDEN column','Y');      

          vsql := 'INSERT INTO '||vschema||'.CMS_USER(USERNAME, PASSWORD, ACTIVE, FIRSTNAME, LASTNAME, EMAIL, HIDDEN) VALUES
                   (''services'', ''8744d9c7ddf4a59d758114146ea754b670ce89ee'', ''1'', ''services2'',''services'', ''test@test.com'', ''1'')';
          CREATEOBJECT(vsql,'Unable to insert CMS_USER services','Y');
          
          vsql := 'INSERT INTO '||vschema||'.CMS_USERROLES (USERID, ROLEID) SELECT u.USERID, r.ROLEID FROM '||vschema||'.CMS_USER u CROSS JOIN '||vschema||'.CMS_ROLE r WHERE u.USERNAME = ''services'' and r.ROLE_NAME = ''_services_''';
          CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.CMS_USERROLES for the ROLE Services','Y'); 
          
          vsql := 'DECLARE 
                     settingsModuleId NUMBER;
                   BEGIN
                     BEGIN
                       SELECT MODULEID INTO settingsModuleId FROM '||vschema||'.CMS_MODULE WHERE MODULENAME = ''SettingsManagement'';
                       EXCEPTION
                         WHEN NO_DATA_FOUND THEN settingsModuleId := NULL;
                     END;
                     IF settingsModuleId IS NULL THEN
                       INSERT INTO '||vschema||'.CMS_MODULE(MODULEID, MODULENAME, DISPLAYNAME) VALUES ('||vschema||'.CMS_MODULE_SEQ.nextval,''SettingsManagement'', ''Settings Management'');
                       INSERT INTO '||vschema||'.CMS_PERMISSION(PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERNUMBER) values (''View'', ''View'', '||vschema||'.CMS_MODULE_SEQ.currval, 0 );
                       INSERT INTO '||vschema||'.CMS_PERMISSION(PERMISSIONNAME, DISPLAYNAME, MODULEID, ORDERNUMBER) values (''Modify'', ''Modify'', '||vschema||'.CMS_MODULE_SEQ.currval, 1);
                     END IF;
                     SELECT MODULEID INTO settingsModuleId FROM '||vschema||'.CMS_MODULE WHERE MODULENAME = ''SettingsManagement'';
                     INSERT INTO '||vschema||'.CMS_ROLEPERMISSIONS(ROLEID, PERMISSIONID) (SELECT r.ROLEID, p.PERMISSIONID from '||vschema||'.CMS_ROLE r CROSS JOIN '||vschema||'.CMS_PERMISSION p 
                      WHERE r.ROLE_NAME = ''_services_'' and p.MODULEID = settingsModuleId);
                   END;';
          CREATEOBJECT(vsql,'Unable to insert into '||vschema||'.CMS_MODULE, '||vschema||'.CMS_PERMISSION and '||vschema||'.CMS_ROLEPERMISSIONS','Y');

          set_version('3.4.11',''||db_version ||'');
        END IF;

        <<bypass_install>>
  
          COMMIT;
          
          IF wk_message = 'ERROR' THEN
          	
          	 RAISE createWFSDB.INSTALL_FAILED;
             
          ELSE
          
             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''Upgrade of CMS completed SUCCESSFULLY'')';
             
          END IF;
    END ConvertWFS;

    PROCEDURE INSTALL_WFS(ENABLE_PARTITION VARCHAR2 DEFAULT 'FALSE', 
                          SIZE_OF_PARTITION CHAR DEFAULT 'W', 
                          ENABLE_MAX_PARTITION VARCHAR2 DEFAULT 'TRUE', 
                          NUMBER_OF_PARTITIONS NUMBER DEFAULT 10 ) IS
		  error		number(1,0) := 0;
        wk_count	number;
        wk_message varchar2(255);
        err_msg		varchar2(500);
        v_lastrelease varchar2(100);
    BEGIN
      EXECUTE IMMEDIATE 'alter system set deferred_segment_creation=false';
      EXECUTE IMMEDIATE 'alter system set nls_length_semantics=char';
      EXECUTE IMMEDIATE 'alter session set nls_length_semantics=char';
      dbms_stats.set_global_prefs('stale_percent','5');
      /* Turns on automatic sql profiles for tuning purposes. */
/*      begin
          dbms_sqltune.set_auto_tuning_task_parameter( 'LOCAL_TIME_LIMIT', 3600);
          dbms_sqltune.set_auto_tuning_task_parameter( 'ACCEPT_SQL_PROFILES', 'TRUE');
          DBMS_SQLTUNE.SET_AUTO_TUNING_TASK_PARAMETER( 'MAX_SQL_PROFILES_PER_EXEC', 20);
          DBMS_SQLTUNE.SET_AUTO_TUNING_TASK_PARAMETER( 'MAX_AUTO_SQL_PROFILES', 200);
      END;
*/ 
		  SELECT COUNT(*) 
		  INTO 	wk_count 
		  FROM 	dba_tables 
		  WHERE	OWNER = 'WFS';

        IF wk_count < 20 THEN
        	  BEGIN
	        	  CREATEWFS(ENABLE_PARTITION, SIZE_OF_PARTITION, ENABLE_MAX_PARTITION, NUMBER_OF_PARTITIONS);
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('||sqlerrm||'An error occured while running the createWFS procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        	  CreatePMM(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''An error occured while running the CreatePMM procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        		CreateQRTZ(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''An error occured while running the CreateQRTZ procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        		CreateNEPTUNE(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||'An error occured while running the CreateNEPTUNE procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        		CreateMETADATAMANAGER(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||'An error occured while running the CreateMETADATAMANAGER procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        		CreateMETADATAMANAGER_XML(); 
              --Null;
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||'An error occured while running the CreateMETADATAMANAGER_XML procedure.'')';
	        	GOTO BYPASS_INSTALL; 
	        END;
	        BEGIN
	        		createRULES(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||'An error occured while running the createRULES procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        		createSITES(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||'An error occured while running the createSITES procedure.'')';
	        	GOTO bypass_install; 
	        END;
          BEGIN
          		createWPStudio();
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||' An error occured while running the createWPStudio procedure.'')';
	        	GOTO bypass_install; 
        END;
        BEGIN
          		CreateJobSchedule();
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||' An error occured while running the CreateJobSchedule procedure.'')';
	        	GOTO bypass_install; 
        END;
        BEGIN
	    		CreateCAT(); 
	    EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
				dbms_output.put_line('Error Message:'||err_msg);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||'An error occured while running the CreateCAT procedure.'')';
	    	GOTO bypass_install; 
	    END;
        BEGIN
        		CreateMetaEnhancement(); 
        EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
				dbms_output.put_line('Error Message:'||err_msg);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||'An error occured while running the CreateMetaEnhancement procedure.'')';
        	GOTO bypass_install; 
        END;
        BEGIN
          CreateInterDependent();
        EXCEPTION 
          when OTHERS then
            wk_message := 'ERROR';
            err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
            dbms_output.put_line('Error Message:'||err_msg);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||' An error occured while running the CreateInterDependent procedure.'')';
            GOTO bypass_install; 
        END; 
        ELSE
          DECLARE
            vreq_met Boolean:= TRUE;
          BEGIN
              pre_req(vreq_met);
              if vreq_met then                
               convertwfs();
              end if;
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||' An error occured while running the convertWFS procedure.'')';
	        	GOTO bypass_install; 
        END;
        END IF;
        begin
          /* Create Query Views for Fresh Install and Upgrade */
          CreateQueryViews();
          IF dbms_utility.is_cluster_database THEN
             CreateClusterObjects();
          END IF;
        EXCEPTION 
          WHEN OTHERS THEN
            wk_message := 'ERROR';
            err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
            DBMS_OUTPUT.PUT_LINE('Error Message:'||ERR_MSG);
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||' An error occured while running the CreateQueryViews and CreateClusterObjects procedure.'')';
            GOTO bypass_install; 
        END;      
		  <<bypass_install>>
		  COMMIT;
        IF wk_message = 'ERROR' THEN        	
        	 null;
        ELSE
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''CMS script execution completed SUCCESSFULLY'')';
        END IF;
    END INSTALL_WFS;  
END createWFSDB;
/

BEGIN
/* To Enable Partitions use the following parameter:
     1)  ENABLE_PARTITION     : TRUE enables partition.  FALSE is default.
     2)  SIZE_OF_PARTITION    : D for Daily, W for Weekly and M for Monthly.
     3)  ENABLE_MAX_PARTITION : TRUE enables to create a max partition by default, however new partitions have to be split.
                                FALSE allows adding partitions without splitting.
     4)  NUMBER_OF_PARTITIONS : By default 10 partitions will be created when ENABLE_MAX_PART is FALSE.

		    createWFSdb.install_wfs(ENABLE_PARTITION  => 'FALSE',
		                            SIZE_OF_PARTITION => 'W',      
		                            ENABLE_MAX_PARTITION  => 'TRUE',
		                            NUMBER_OF_PARTITIONS  =>  10);  
*/
    createWFSdb.install_wfs(); -- Do not use any parameter for NO PARTITIONs option.
END;
/

GRANT execute ON SYS.createWFSdb to wfs;

exit
