#!/bin/sh

export ORACLE_SID=$1
LOG_DIR="/home/oracle/scripts"
INSTALL_DIR=`pwd`
TRANS_FILE=""

if [ "$ORACLE_SID" = "" ]; then
  echo "Database SID should not be blank, please try again....!"
  exit 1
fi

DB_CONS=$(sqlplus -S /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT count(username) FROM v\$session WHERE username = 'WFS' and status <> 'KILLED';
  exit
SQL1
)

if [ "$DB_CONS" -gt 0 ]; then
  echo ""
  echo "Please shutdown CMS to close all the database connections and try again....!"
  echo ""
  exit 1
fi

DB_VERSION=$(sqlplus -S /nolog<<MNO
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT setting_value FROM WFS.SYSTEM_SETTINGS WHERE setting_type = 'RELEASE';
  exit
MNO
)

if [ "${DB_VERSION}" = "3.3.20" ]; then
  sh $INSTALL_DIR/copy_all_xml.sh $ORACLE_SID
else

$ORACLE_HOME/bin/sqlplus -s /nolog<<SQEOF  
   connect / as sysdba
   set serveroutput on
   SET VERIFY OFF
   begin 
      execute immediate 'DROP DIRECTORY XMLEVOLVEDIR'; 
   exception
      when others then
         null;
   end;
   /
   CREATE DIRECTORY XMLEVOLVEDIR AS '${INSTALL_DIR}';
   GRANT ALL ON DIRECTORY XMLEVOLVEDIR TO WFS;
   exit
SQEOF

TRANS_FILE="copy_all.xsl"

$ORACLE_HOME/bin/sqlplus -s /nolog<<EOF  
connect / as sysdba
set serveroutput on
SET VERIFY OFF
set echo on
spool ${LOG_DIR}/Copyevolve.log append

grant create any table, create any index, select any table, update any table, insert any table, delete any table, drop any table, alter any table, drop any index, drop any type, create any type, alter any type to WFS;

conn wfs/Wf\$1234
set serveroutput on
WHENEVER SQLERROR EXIT SQL.SQLCODE

begin
  execute immediate 'DROP TABLE "mdm_metadata_evolve"';
exception
  when others then null;
end;
/
ALTER SESSION SET RECYCLEBIN=OFF;

DECLARE
   vcnt_deps number(6);
   verrmsg varchar2(32000);
BEGIN
   select count(*) into vcnt_deps
     from user_dependencies d, user_xml_schemas x
    where d.referenced_type = 'XML SCHEMA'
      and d.referenced_name = x.int_objname
      and x.schema_url = 'ECMFSpec.xsd'
      and name not in ('MDM_METADATA','MDM_METADATA_REVISION');
    
   if vcnt_deps > 0 then
      dbms_xmlschema.copyevolve(
         SCHEMAURLS => XDB\$STRING_LIST_T('ECMFSpec.xsd'),
         NEWSCHEMAS => XMLSEQUENCETYPE(xmltype(xmltype(BFILENAME('XMLEVOLVEDIR', 'ECMFSpec.xsd'), NLS_CHARSET_ID('AL32UTF8')).GETCLOBVAL())),
         TRANSFORMS => XMLSEQUENCETYPE(xmltype(xmltype(BFILENAME('XMLEVOLVEDIR', '${TRANS_FILE}'), NLS_CHARSET_ID('AL32UTF8')).GETCLOBVAL())),
         PRESERVEOLDDOCS => true,
         mapTabName => 'mdm_metadata_evolve',
         force => TRUE,
         SCHEMAOWNERS => XDB\$STRING_LIST_T('WFS'),
         options => DBMS_XMLSCHEMA.COPYEVOLVE_BINARY_XML    
         );
   else 
      dbms_xmlschema.copyevolve(
         SCHEMAURLS => XDB\$STRING_LIST_T('ECMFSpec.xsd'),
         NEWSCHEMAS => XMLSEQUENCETYPE(xmltype(xmltype(BFILENAME('XMLEVOLVEDIR', 'ECMFSpec.xsd'), NLS_CHARSET_ID('AL32UTF8')).GETCLOBVAL())),
         TRANSFORMS => XMLSEQUENCETYPE(xmltype(xmltype(BFILENAME('XMLEVOLVEDIR', '${TRANS_FILE}'), NLS_CHARSET_ID('AL32UTF8')).GETCLOBVAL())),
         PRESERVEOLDDOCS => true,
         mapTabName => 'mdm_metadata_evolve',
         SCHEMAOWNERS => XDB\$STRING_LIST_T('WFS'),
         options => DBMS_XMLSCHEMA.COPYEVOLVE_BINARY_XML    
         );
   end if;
   dbms_output.put_line('DB Evolve completed successfully at '||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss'));

EXCEPTION
   WHEN others THEN
      verrmsg := substr(sqlerrm,1,500);
      dbms_output.put_line('***Error '||SQLCODE||'-'||verrmsg);
      raise;
END;
/

ALTER SESSION SET RECYCLEBIN=ON;

spool off
EOF

$ORACLE_HOME/bin/sqlplus -s /nolog<<SQ1  
   connect / as sysdba
   set serveroutput on
   SET VERIFY OFF
   begin 
      execute immediate 'DROP DIRECTORY XMLEVOLVEDIR'; 
   exception
      when others then
         null;
   end;
   /
   exit
SQ1


$ORACLE_HOME/bin/sqlplus -s /nolog<<IDXSQ  
   connect / as sysdba
   set serveroutput on
   SET VERIFY OFF
   begin 
     sys.createwfsdb.recreate_xml_indexes;
   exception
      when others then
         dbms_output.put_line('***Error '||SQLCODE||'-'||substr(sqlerrm,1,500));
   end;
   /
   exit
IDXSQ
fi
exit
