#!/bin/sh
INSTALL_DIR=$1
CM_SW_VERSION=`cat cm_sw_version.txt`

if [ -f "/home/oracle/ecmf/ECMFSpec.xsd" ];  then
   cp -f /home/oracle/ecmf/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec_before_$(date +"%Y%m%d_%H%M%S").xsd
   mv -f /home/oracle/ecmf/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec_old.xsd

   cp -f /home/oracle/ecmf/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans_before_$(date +"%Y%m%d_%H%M%S").xsl 2> /dev/null
   mv -f /home/oracle/ecmf/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans_old.xsl 2> /dev/null

   cp -f ${INSTALL_DIR}/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec.xsd
   cp -f ${INSTALL_DIR}/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans.xsl 2> /dev/null
else
   mkdir -p /home/oracle/ecmf
   cp -f ${INSTALL_DIR}/ECMFSpec.xsd /home/oracle/ecmf/ECMFSpec.xsd
   cp -f ${INSTALL_DIR}/ECMFTrans.xsl /home/oracle/ecmf/ECMFTrans.xsl 2> /dev/null
fi
cp -f ${INSTALL_DIR}/default_content_class.xml /home/oracle/ecmf/default_content_class.xml
cp -f ${INSTALL_DIR}/category_content_class.xml /home/oracle/ecmf/category_content_class.xml
cp -f ${INSTALL_DIR}/series_content_class.xml /home/oracle/ecmf/series_content_class.xml

mkdir -p /home/oracle/scripts/cms

cp -f ${INSTALL_DIR}/purge_error_log_script.sql  /home/oracle/scripts/cms/purge_error_log_script.sql
cp -f ${INSTALL_DIR}/purge_cms_wos.sh            /home/oracle/scripts/cms/purge_cms_wos.sh
cp -f ${INSTALL_DIR}/purge_cms_data_readme.txt   /home/oracle/scripts/cms/purge_cms_data_readme.txt
cp -f ${INSTALL_DIR}/PurgeCMS.sql                /home/oracle/scripts/cms/PurgeCMS.sql
cp -f ${INSTALL_DIR}/purge_cms_titles.sh         /home/oracle/scripts/cms/purge_cms_titles.sh
cp -f ${INSTALL_DIR}/purge_cms_titles.sql        /home/oracle/scripts/cms/purge_cms_titles.sql
cp -f ${INSTALL_DIR}/purge_cms_data.sh           /home/oracle/scripts/cms/purge_cms_data.sh
cp -f ${INSTALL_DIR}/purge_cms_me_requests.sql   /home/oracle/scripts/cms/purge_cms_me_requests.sql
cp -f ${INSTALL_DIR}/purge_cms_me.sh             /home/oracle/scripts/cms/purge_cms_me.sh

chmod 755 /home/oracle/scripts/cms/*.sh
touch /home/oracle/scripts/cms/purge_titles.log /home/oracle/scripts/cms/purge_wo.log /home/oracle/scripts/cms/purge_cms.log


sqlplus '/ as sysdba' @createWFS.sql
sqlplus '/ as sysdba' @createCM.sql "WFS" "$CM_SW_VERSION"

sqlplus -S /nolog <<EOF
connect / as sysdba
set serveroutput on
SET VERIFY OFF
set echo on
set pagesize 100
set linesize 200 
column INSTALL_MESSAGE format a80
  select * from install_table;
EOF
IS_RACDB=$(sqlplus -S /nolog<<AFG
  connect / as sysdba
  set pages 0
  set feedback off
  select case value when 'TRUE' then 1 else 0 end  from v\$parameter where name = 'cluster_database';
  exit
AFG
)

if [ "${IS_RACDB}" -eq 0 ]; then
   cp -f ${INSTALL_DIR}/collect_db_stats.sh /home/oracle/scripts/collect_db_stats.sh 2>1 >> /dev/null
   chmod 755 /home/oracle/scripts/collect_db_stats.sh
   crontab -l > ${INSTALL_DIR}/old_crontab
   sed -i "/collect_db_stats[.]*/d" ${INSTALL_DIR}/old_crontab
   sed -i "/purge_cms_data[.]*/d" ${INSTALL_DIR}/old_crontab
   echo "0 3 * * * /home/oracle/scripts/collect_db_stats.sh" >> ${INSTALL_DIR}/old_crontab
   echo "0 2 * * * /home/oracle/scripts/cms/purge_cms_data.sh 99999 180 180 180 >> /home/oracle/scripts/cms/purge_cms.log" >> ${INSTALL_DIR}/old_crontab

   crontab ${INSTALL_DIR}/old_crontab
   echo "Added the Database Statistics collection job to the crontab successfully....."
elif [ "${IS_RACDB}" -eq 1 ]; then
	RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
	NODE1_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE1"` 
	NODE2_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE2"`

   ssh "oracle@${NODE1_HOSTNAME}" "/usr/bin/scp -r ${INSTALL_DIR}/RAC_collect_db_stats.sh /home/oracle/scripts/RAC_collect_db_stats.sh 2>1 >> /dev/null"
   ssh "oracle@${NODE2_HOSTNAME}" "/usr/bin/scp -r ${INSTALL_DIR}/RAC_collect_db_stats.sh /home/oracle/scripts/RAC_collect_db_stats.sh 2>1 >> /dev/null"
   ssh "oracle@${NODE1_HOSTNAME}" "mkdir -p /home/oracle/scripts/cms;/usr/bin/scp -rv ${INSTALL_DIR}/[P,p]urge* /home/oracle/scripts/cms ;chmod 755 /home/oracle/scripts/cms/*.sh 2>1 >> /dev/null"
   ssh "oracle@${NODE2_HOSTNAME}" "mkdir -p /home/oracle/scripts/cms;/usr/bin/scp -rv ${INSTALL_DIR}/[P,p]urge* /home/oracle/scripts/cms ;chmod 755 /home/oracle/scripts/cms/*.sh 2>1 >> /dev/null"
   
   export ORACLE_HOME="/opt/app/oracle/product/11.2.0/db_1"
   ${ORACLE_HOME}/bin/sqlplus -S /nolog<<XYZ
    connect / as sysdba
    set serveroutput on
    declare
      DB_STATS_FOUND number :=0;      
    begin     
      SELECT count(*) INTO DB_STATS_FOUND FROM DBA_SCHEDULER_JOBS where job_name='RAC_COLLECT_DB_STATS_JOB';
      IF (DB_STATS_FOUND=0) THEN
      begin
         dbms_scheduler.drop_job( job_name => 'sys.RAC_collect_db_stats_job', force => TRUE, commit_semantics => 'ABSORB_ERRORS');
         exception when others then null;
      end;

      begin
         dbms_scheduler.drop_program( program_name => 'sys.RAC_collect_db_stats_prog', force => TRUE);
         exception when others then null;
      end;

      begin
         dbms_scheduler.create_program(
            program_name =>   'sys.RAC_collect_db_stats_prog',
            program_type =>   'executable',
            program_action => '/home/oracle/scripts/RAC_collect_db_stats.sh',
            enabled =>        TRUE);
         dbms_scheduler.create_job(
            job_name =>        'sys.RAC_collect_db_stats_job',
            program_name =>    'sys.RAC_collect_db_stats_prog',
            repeat_interval => 'FREQ=DAILY; BYHOUR=3');
         dbms_scheduler.enable('sys.RAC_collect_db_stats_job');
         dbms_scheduler.set_attribute('sys.RAC_collect_db_stats_job','logging_level',DBMS_SCHEDULER.LOGGING_FULL);
      end;
         dbms_output.put_line('Added the Database Statistics collection job to the database scheduler successfully.....');
      ELSE
	 dbms_output.put_line('Database collect stats job is already scheduled in the database.');
      END IF;

    end;
    /
XYZ


 export ORACLE_HOME="/opt/app/oracle/product/11.2.0/db_1"
   ${ORACLE_HOME}/bin/sqlplus -S /nolog<<ABC
    connect / as sysdba
    set serveroutput on
    declare
      DB_STATS_FOUND number :=0;      
    begin     
      SELECT count(*) INTO DB_STATS_FOUND FROM DBA_SCHEDULER_JOBS where job_name='RAC_PURGE_CMS_DATA_JOB';
      IF (DB_STATS_FOUND=0) THEN
      begin
         dbms_scheduler.drop_job( job_name => 'sys.RAC_PURGE_CMS_DATA_JOB', force => TRUE, commit_semantics => 'ABSORB_ERRORS');
         exception when others then null;
      end;

      begin
         dbms_scheduler.drop_program( program_name => 'sys.RAC_PURGE_CMS_DATA_PROG', force => TRUE);
         exception when others then null;
      end;

      begin
         dbms_scheduler.create_program(
            program_name =>   'sys.RAC_PURGE_CMS_DATA_PROG',
            program_type =>   'executable',
            program_action => '/home/oracle/scripts/cms/purge_cms_data.sh',
            enabled =>        TRUE);
			DBMS_SCHEDULER.DISABLE(name=>'"SYS"."RAC_PURGE_CMS_DATA_PROG"',force=>TRUE);
			DBMS_SCHEDULER.SET_ATTRIBUTE(
			name=>'"SYS"."RAC_PURGE_CMS_DATA_PROG"',
			attribute=>'NUMBER_OF_ARGUMENTS',
			value=>4);
			DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT(
			program_name=>'"SYS"."RAC_PURGE_CMS_DATA_PROG"',
			argument_name=>'"NO_OF_TITLES"',
			argument_position=>1,
			argument_type=>'NUMBER',
			default_value=>'999999',
			out_argument=>FALSE);
			DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT(
			program_name=>'"SYS"."RAC_PURGE_CMS_DATA_PROG"',
			argument_name=>'"TITLE_RETEN_DAYS"',
			argument_position=>2,
			argument_type=>'NUMBER',
			default_value=>'180',
			out_argument=>FALSE);
			DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT(
			program_name=>'"SYS"."RAC_PURGE_CMS_DATA_PROG"',
			argument_name=>'"WO_RETEN_DAYS"',
			argument_position=>3,
			argument_type=>'NUMBER',
			default_value=>'180',
			out_argument=>FALSE);
			DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT(
			program_name=>'"SYS"."RAC_PURGE_CMS_DATA_PROG"',
			argument_name=>'"ME_RETEN_DAYS"',
			argument_position=>4,
			argument_type=>'NUMBER',
			default_value=>'180',
			out_argument=>FALSE);
			DBMS_SCHEDULER.ENABLE(name=>'"SYS"."RAC_PURGE_CMS_DATA_PROG"');

			dbms_scheduler.create_job(
            job_name =>        'sys.RAC_PURGE_CMS_DATA_JOB',
            program_name =>    'sys.RAC_PURGE_CMS_DATA_PROG',
            repeat_interval => 'FREQ=DAILY; BYHOUR=2');
         dbms_scheduler.enable('sys.RAC_PURGE_CMS_DATA_JOB');
         dbms_scheduler.set_attribute('sys.RAC_PURGE_CMS_DATA_JOB','logging_level',DBMS_SCHEDULER.LOGGING_FULL);
      end;
         dbms_output.put_line('Added the Database purge job to the database scheduler successfully.....');
      ELSE
	 dbms_output.put_line('Database purge job is already scheduled in the database.');
      END IF;

    end;
    /
ABC
fi
exit 0

