#!/bin/sh
vsid="ttv"
vdays_keep_data=$1
source /home/oracle/.bash_profile
install_dir="/home/oracle/scripts/cms"
if [ `whoami` != "oracle" ]; then
   echo "************************************************************************************"
   echo "Only oracle user can run this script. Please log in as oracle user and try again...!"
   echo "************************************************************************************"
   exit 1
fi

if [ "$vsid" = "" ]; then
   echo "*****************************************************************"
   echo " Database SID should not be null, please try again....!"
   echo "*****************************************************************"
   exit 1
fi

if [ "$vdays_keep_data" = "" ]; then
   echo "*****************************************************************************************"
   echo "First parameter should be the number of days to maintain previous data in the days,"
   echo "Please try again....!"
   echo "*****************************************************************************************"
   exit 1
fi

if [ $vdays_keep_data -lt 1 ]; then
   echo "*****************************************************************************************"
   echo "First parameter number of days to maintain previous data should not be less than one,"
   echo "Please try again....!"
   echo "*****************************************************************************************"
   exit 1
fi

echo "------------------------------------------------------------"
echo "****** Beginning of Metadata Enhancement purge script ******"
${ORACLE_HOME}/bin/sqlplus -s /nolog <<SQL
connect / as sysdba
grant execute on dbms_lock to wfs;
SQL
# BUILD PURGE_WFS_ME PACKAGE
${ORACLE_HOME}/bin/sqlplus -s 'wfs/Wf$1234' @${install_dir}/purge_cms_me_requests.sql

# EXECUTE PURGE_OLDDATA
${ORACLE_HOME}/bin/sqlplus -s /nolog <<EOF
connect / as sysdba
set feedback off
grant create any table to wfs;
connect wfs/Wf\$1234
set serveroutput on
SET VERIFY OFF
set echo on
spool "${install_dir}/purge_cms_me.log" append
set head off
set feedback off

define days_keep_data="$vdays_keep_data"

DECLARE
   v_days_keep_data number;
   purge_date date;   
BEGIN
   dbms_output.put_line(chr(10)||'Script started at '||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss'));

   select to_number('&days_keep_data') into v_days_keep_data from dual;
   dbms_output.put_line('***Script is purging requests older than '||to_char(v_days_keep_data)||' days .......');

   WFS.PURGE_WFS_ME.PURGE_OLDDATA(v_days_keep_data); 

   dbms_output.put_line('Script ended at '||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||chr(10));
END;
/
spool off
EOF

echo "***** End of the Metadata Enhancement purge script *********"
echo "------------------------------------------------------------"

exit

