SET FEEDBACK OFF
set serveroutput on
CREATE OR REPLACE
PACKAGE PURGE_WFS_ME
AS
	PROCEDURE PURGE_OLDDATA (retention_days IN number default 30);
  PROCEDURE disable_enable_tbl_constraints(p_table_name IN VARCHAR2, p_enable_disable IN VARCHAR2);
	vsql VARCHAR2(32767);
  can_not_disable_cons EXCEPTION;
  PRAGMA EXCEPTION_INIT(can_not_disable_cons, -20101);
  err_msg VARCHAR2(500);
END;
/
CREATE OR REPLACE
PACKAGE BODY purge_wfs_me
AS

/* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in DELETE_ME_LOG table */
PROCEDURE createobject(
    vsql   VARCHAR2,
    errmsg VARCHAR2 DEFAULT NULL,
    mask   VARCHAR2 DEFAULT 'N')
IS
  verrmsg VARCHAR2(32000);
BEGIN
  --dbms_output.put_line('SQL:'||vsql);
  EXECUTE IMMEDIATE VSQL;
EXCEPTION
WHEN OTHERS THEN
  verrmsg := SUBSTR(errmsg ||' '||sqlerrm,1,4000);
  --dbms_output.put_line(verrmsg);
  IF UPPER(MASK) != 'Y' THEN
    EXECUTE IMMEDIATE 'INSERT INTO DELETE_ME_LOG values('''||REPLACE(verrmsg,'''')||''','''||SYSDATE||''')';
    COMMIT;
    RAISE;
  END IF;
END CREATEOBJECT;

  PROCEDURE disable_enable_tbl_constraints(p_table_name IN VARCHAR2, p_enable_disable IN VARCHAR2) IS
    tbl_const_count NUMBER:=1;
    const_disable   NUMBER:=1;
    iterations      NUMBER:=0;
    enable_disable  VARCHAR2(50);
    opp_cons_status VARCHAR2(10);
  BEGIN
      IF UPPER(P_ENABLE_DISABLE)='E' THEN
        enable_disable:= 'ENABLE NOVALIDATE';
        opp_cons_status := 'DISABLED';
      ELSIF UPPER(P_ENABLE_DISABLE)='D' THEN
        enable_disable:= 'DISABLE';
        opp_cons_status := 'ENABLED';
      END IF;
      --dbms_output.put_line('TABLE_NAME='||p_table_name);
      FOR x IN (SELECT 'ALTER TABLE '||owner||'.'||table_name||' '||enable_disable||' CONSTRAINT '||constraint_name AS CONST_STR
                  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE='R' AND status=''|| opp_cons_status ||'' AND R_CONSTRAINT_NAME IN (
                      SELECT CONSTRAINT_NAME FROM USER_CONSTRAINTS
                       WHERE constraint_type='P' AND table_name=upper(p_table_name)))
       LOOP
         const_disable:=1;
         iterations:=0;
         --dbms_output.put_line('     '||x.CONST_STR);
         WHILE (const_disable=1 )
         LOOP
           EXIT WHEN (iterations > 360);
           BEGIN
             --dbms_output.put_line('     const_disable='||const_disable ||', iterations='||iterations);
             EXECUTE IMMEDIATE x.CONST_STR; 
             const_disable:=0;
           EXCEPTION
             WHEN OTHERS THEN 
                dbms_lock.sleep(seconds =>5);
                const_disable:=1;
           END;
           iterations:=iterations+1;
         END LOOP; /* END OF WHILE LOOP */
         IF ( const_disable=1 and UPPER(P_ENABLE_DISABLE)='D') THEN
           --dbms_output.put_line('..... At Raise exception ...');
           err_msg :='Can not disable constraint - '||x.CONST_STR;
           raise_application_error(-20101, 'Can not disable constraint on table '||p_table_name);   
         END IF;
       END LOOP;/* END OF FOR LOOP */
  END disable_enable_tbl_constraints;

PROCEDURE PURGE_OLDDATA(
    retention_days IN number default 30)
IS
  wk_message VARCHAR2(500);
  err_msg    VARCHAR2(500);
  TYPE t_tables IS TABLE OF VARCHAR2(30);
  const_tables t_tables;
BEGIN
	-- Drop the DELETE_ME_LOG
  VSQL:='Drop table DELETE_ME_LOG';
  CREATEOBJECT(vsql,'DROP DELETE_ME_LOG','Y');
  
  -- Create DELETE_ME_LOG table
  VSQL:='CREATE TABLE DELETE_ME_LOG(Message varchar2(4000), recordTime timestamp default systimestamp)';
  CREATEOBJECT(vsql,'CREATE DELETE_ME_LOG');
  
  VSQL:='INSERT INTO DELETE_ME_LOG (Message, recordTime) VALUES(''Purge ME requests script started'',systimestamp)';
  CREATEOBJECT(vsql,'INSERT DELETE_ME_LOG');

  /* Disable table constraints */
  const_tables:= t_tables('ME_CACHE_RESULT','ME_REQUEST');
  FOR i IN const_tables.FIRST .. const_tables.LAST
  LOOP
    --DBMS_OUTPUT.PUT_LINE('TABLE_NAME='||const_tables(i));
    disable_enable_tbl_constraints(const_tables(i),'D');
  END LOOP;

  VSQL := 'INSERT INTO DELETE_ME_LOG (Message, recordTime) VALUES(''Finished disable constraints'',systimestamp)';
  CREATEOBJECT(VSQL,'disable constraints');
  DBMS_OUTPUT.PUT_LINE('Finished disabling constraints');
  commit;  

    -- Drop and recreate the table tmpPurgeRequestId to store all delete candidate records
    vsql:='Drop table tmpPurgeRequestId';
    CREATEOBJECT(VSQL,'DROP tmpPurgeRequestId','Y');
    VSQL:='CREATE TABLE tmpPurgeRequestId(requestId, PRIMARY KEY(requestId)) 
                        ORGANIZATION INDEX 
                        NOLOGGING        
			AS SELECT DISTINCT id              
			FROM WFS.ME_REQUEST              
			WHERE createdate < (to_date(to_char(sysdate, ''yyyy-mm-dd''),''yyyy-mm-dd'')- '||retention_days||')';
    CREATEOBJECT(VSQL,'CREATE tmpPurgeRequestId','Y');
    
    VSQL:='delete from ME_CACHE_RESULT where request_id in (select requestId from tmpPurgeRequestId)';        
    CREATEOBJECT(VSQL,'DELETE ME_CACHE_RESULT','Y');
    VSQL:='INSERT INTO DELETE_ME_LOG (Message, recordTime) VALUES(''Purge Metadata Enhancement cache results completed'',systimestamp)';
    CREATEOBJECT(VSQL,'INSERT INTO DELETE_ME_LOG for ME_CACHE_RESULT','Y');
    
    VSQL:='delete from ME_REQUEST where id in (select requestId from tmpPurgeRequestId)';        
    CREATEOBJECT(VSQL,'DELETE ME_REQUEST','Y');
    VSQL:='INSERT INTO DELETE_ME_LOG (Message, recordTime) VALUES(''Purge Metadata Enhancement requests completed'',systimestamp)';
    CREATEOBJECT(VSQL,'INSERT INTO DELETE_ME_LOG for ME_REQUEST','Y');

    /* Enable table constraints */
    FOR i IN const_tables.FIRST .. const_tables.LAST
    LOOP
      --DBMS_OUTPUT.PUT_LINE('TABLE_NAME='||const_tables(i));
      disable_enable_tbl_constraints(const_tables(i),'E');
    END LOOP;

    VSQL := 'INSERT INTO DELETE_ME_LOG (Message, recordTime) VALUES(''Finished enable constraints'',systimestamp)';
    CREATEOBJECT(VSQL,'enable constraints');
    DBMS_OUTPUT.PUT_LINE('Finished enabling constraints');

  COMMIT;
  VSQL:='INSERT INTO DELETE_ME_LOG (Message, recordTime) VALUES(''Purge Metadata Enhancement requests scripts completed successfully'',systimestamp)';
  CREATEOBJECT(vsql,'INSERT DELETE_ME_LOG');
EXCEPTION
    WHEN can_not_disable_cons THEN
      VSQL := 'INSERT INTO DELETE_ME_LOG (MESSAGE, RECORDTIME) VALUES('''||ERR_MSG||''', SYSTIMESTAMP)';
       CREATEOBJECT(VSQL,'insert DELETE_ME_LOG ERROR for database table constraint disable!');
       COMMIT;
       RAISE;
WHEN OTHERS THEN
  ROLLBACK;
  ERR_MSG :=SUBSTR(SQLERRM, 1, 500);
  VSQL    := 'INSERT INTO DELETE_ME_LOG (MESSAGE, RECORDTIME) VALUES(err_msg, SYSTIMESTAMP)';
  CREATEOBJECT(VSQL,'insert DELETE_ME_LOG ERROR!');
  COMMIT;
END PURGE_OLDDATA;

END PURGE_WFS_ME;
/
EXIT
