#!/bin/ksh
##
## Data Refresh from production!!!
##
echo    "*****************************************************************************"
echo -e "   Data warehouse data refresh script started at $(date)."
echo    "*****************************************************************************"
echo -e "\nRefreshing Data warehouse data with Production data........"
filetimestamp=$(date +%Y%m%d%H%M%S)
export LOG_BASE="/home/oracle/DWT1/log"
export ORACLE_BASE=/opt/app/oracle
export ORACLE_SID=`ps -ef | grep ora_pmon | grep -v "grep ora_pmon" | awk '{print($8)}' | sed 's/ora\_pmon\_//g'`
export ORACLE_HOME=$ORACLE_BASE/product/11.2.0/db_1
export PATH=$ORACLE_HOME/bin:$PATH:$HOME/bin:/usr/bin:/bin:/usr/bin/X11/:/usr/local/bin:
export LD_LIBRARY_PATH=$ORACLE_HOME/lib

if [ ! -d "$LOG_BASE" ]; then
      # create os soft link to /opt/app/oracle/log folder
      RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
      NODE1_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE1"`
      NODE2_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE2"`
      ssh "oracle@${NODE1_HOSTNAME}" "/bin/mkdir -p /home/oracle/DWT1;/bin/ln -s /clusfiles/DWT1/log /home/oracle/DWT1"
      ssh "oracle@${NODE2_HOSTNAME}" "/bin/mkdir -p /home/oracle/DWT1;/bin/ln -s /clusfiles/DWT1/log /home/oracle/DWT1"
fi
#
$ORACLE_HOME/bin/sqlplus /nolog << EOM
    connect wfsdw/wfsdw
    PROMPT Refreshing Data Warehouse Database DIM and FACT Tables with Production Database Data. PLEASE WAIT!
    set termout on echo on serveroutput on
    spool $LOG_BASE/DRLogNew$filetimestamp.log
    begin
	WFSDW.PKG_ADMIN.SPMD_LOADDATA;
   end;
   /
   spool off
   set echo off termout off serveroutput off
   exit
EOM

echo -e "\nWarehouse data refresh completed successfully, please check the $LOG_BASE/DRLog_$filetimestamp.log for details......!\n"

# Deletes the first four lines of the log
sed -e '1,4d'  $LOG_BASE/DRLogNew$filetimestamp.log >  $LOG_BASE/DRLog_$filetimestamp.log
rm $LOG_BASE/DRLogNew$filetimestamp.log

#Delete log files older than 30 days
find $LOG_BASE/*.log -mtime +30 -exec rm {} \;

echo    "*****************************************************************************"
echo -e "   Data warehouse data refresh script ended at $(date)."
echo    "*****************************************************************************"
