#!/bin/ksh
##
## create the data warehouse
##
export ORACLE_SID=$1
export log_directory=$2
create_wfsdw_log=cms_warehouse_install.log
echo " "
echo "Creating the WatchPointDW database objects........"

sqlplus -s /nolog <<EOM5
   connect / as sysdba
   set serveroutput on
   spool ${log_directory}/${create_wfsdw_log}
   
   @createWFS_DW.sql
   prompt Executing the package, this will take few minutes PLEASE WAIT.......
   execute createWFSDWDB.createWFS_DW;

   @createWFSmd_DW.sql
   @createWFSload_DW.sql
   @createWFSagg_DW.sql
   @createWFSadmin_DW.sql
   @createWFSreport_DW.sql
   set define ~
   set define &
   @loadWFSdim_DW.sql

   set serveroutput on
   set verify off
   set echo on
   set pagesize 100
   set linesize 200 
   column INSTALL_MESSAGE format a80
   select * from install_table;
   spool off
EOM5



#sqlplus "/ as sysdba" @checkInstallStatus.sql $ORACLE_SID


