#!/bin/sh

DB_INSTALL_LOG=cmsdwinstall.log
CREATE_WFS_DB_LOG=createWFSDW.log
INSTALL_DIR="/home/oracle/scripts/install/installdw"
IS_RACDB=$(sqlplus -S /nolog<<AFG
  connect / as sysdba
  set pages 0
  set feedback off
  select case value when 'TRUE' then 1 else 0 end  from v\$parameter where name = 'cluster_database';
  exit
AFG
)

if [ "${IS_RACDB}" -eq 0 ]; then
   ORACLE_SID="ttv"
elif [ "${IS_RACDB}" -eq 1 ]; then
   ORACLE_SID=`ps -ef | grep ora_pmon | grep -v "grep ora_pmon" | awk '{print($8)}' | sed 's/ora\_pmon\_//g'`
fi
#
#if [ ${ORACLE_SID} = DWT1 ]; then
#grep -q DWT1 /etc/oratab
#if [ $? -ne 0 ]; then
#        echo "Adding DWT1 entry in /etc/oratab"
#        echo "DWT1:/opt/oracle/product/11.2.0/db_1:Y" >> /etc/oratab
#fi
#fi

#chown -R oracle:dba /opt/oracle/admin/DWT1
cd ${INSTALL_DIR}

/bin/sh ${INSTALL_DIR}/masterDW.sh ${ORACLE_SID} 2>&1 | tee ${INSTALL_DIR}/${DB_INSTALL_LOG}

echo "*********************************************************"
if [ ! -f ${INSTALL_DIR}/${DB_INSTALL_LOG} ] 
then
     echo "CMS DW Install script probably failed!  ${INSTALL_DIR}/${DB_INSTALL_LOG} file is not exists..!"
     echo "*********************************************************"
     exit 1
else
     if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-\|Warning" "${INSTALL_DIR}/${DB_INSTALL_LOG}"  
     then
            echo "CMS DW Install script probably failed! Check ${INSTALL_DIR}/${DB_INSTALL_LOG} file for any errors"
            echo "*********************************************************"
            exit 1
     else
            echo "CMS DW INSTALL SCRIPT SUCCEEDED!"
     fi
fi
echo "*********************************************************"
exit 0
