#Master CMS Datawarehouse script to be executed as oracle user
#Make sure you are in the required directory
#cd $ORACLE_BASE/admin/DWT1/scripts
#
HOST_NAME=`hostname`
CURRENT_PATH=`pwd`
ORACLE_SID=$1
#
echo -e "\nOracle SID=${ORACLE_SID}\n"
#
#Create DW DB
#if [ ${ORACLE_SID} = DWT1 ]; then
#echo "Creating DWT1 instance"
#sh ${CURRENT_PATH}/DWT1.sh
#fi
#
IS_RACDB=$(sqlplus -S /nolog<<AFG
  connect / as sysdba
  set pages 0
  set feedback off
  select case value when 'TRUE' then 1 else 0 end  from v\$parameter where name = 'cluster_database';
  exit
AFG
)

if [ "${IS_RACDB}" -eq 0 ]; then
   #Change HOSTNAME to machine name
   echo "Replacing hostname to machine name"
   sed -e "s/HOSTNAME/$HOST_NAME/g" -e "s/ORACLE_SID/${ORACLE_SID}/g" < ${CURRENT_PATH}/netcabackup.rsp > ${CURRENT_PATH}/netca.rsp
   #
   echo "Invoking netca to create WFS_PRODUCTIONDB tnsnames entry"
   netca /silent -responsefile ${CURRENT_PATH}/netca.rsp
fi
#
echo "Creating DW Schema and Objects"
sh ${CURRENT_PATH}/createWFS_DW.ksh ${ORACLE_SID} ${CURRENT_PATH}
#
if [ "${IS_RACDB}" -eq 0 ]; then
echo "Setting up cron job to refresh DW."
   sed "s/ORACLE_SID/${ORACLE_SID}/" < ${CURRENT_PATH}/crontabwfsdw.bak > ${CURRENT_PATH}/crontabwfsdw
   crontab -l >  ${CURRENT_PATH}/crontab_old
   sed "s/^.*DataRefresh.*//" < ${CURRENT_PATH}/crontab_old > ${CURRENT_PATH}/crontab_local
   sed "/^$/d"  ${CURRENT_PATH}/crontab_local >> ${CURRENT_PATH}/crontabwfsdw
   crontab ${CURRENT_PATH}/crontabwfsdw
   echo "Added the Warehouse ETL job to the crontab successfully....."
elif [ "${IS_RACDB}" -eq 1 ]; then
   echo -e "\nSetting up ETL job in database scheduled jobs....\n"
   #export ORACLE_SID=${ORA_SID}
   export ORACLE_HOME="/opt/app/oracle/product/11.2.0/db_1"
   ${ORACLE_HOME}/bin/sqlplus -s /nolog<<EOF
       connect / as sysdba
       begin
          dbms_scheduler.drop_job( job_name => 'sys.dw_etl_data_refresh_job', force => TRUE, commit_semantics => 'ABSORB_ERRORS');
       exception 
          when others then null;
       end;
       /
       begin
          dbms_scheduler.drop_program( program_name => 'sys.dw_etl_data_refresh_prog', force => TRUE);
       exception
          when others then null;
       end;
       /
       begin
         dbms_scheduler.create_program(
                  program_name =>   'sys.dw_etl_data_refresh_prog',
                  program_type =>   'executable',
                  program_action => '/home/oracle/scripts/install/installdw/RAC_DW_DataRefresh.ksh',
                  enabled =>        TRUE);
         dbms_scheduler.create_job(
                  job_name =>        'sys.dw_etl_data_refresh_job',
                  program_name =>    'sys.dw_etl_data_refresh_prog',
                  repeat_interval => 'FREQ=DAILY; BYHOUR=2');
        dbms_scheduler.enable('sys.dw_etl_data_refresh_job');
        dbms_scheduler.set_attribute('sys.dw_etl_data_refresh_job','logging_level',DBMS_SCHEDULER.LOGGING_FULL);
      end;
      /
EOF
fi
