#!/bin/sh
EPGMANAGER_XML_DIR="/home/oracle/epgmanager"
EPGMANAGER_PUB_DIR="/home/oracle/epgpublish"
EPGMANAGER_SCHEMA_FILE="ETV_EPG.xsd"
CVS_PATH=`pwd`
EPG_DB_VERSION=`cat epgDbVersion.txt`
#
echo `date` 
echo "Creating EPG Manager Schema and Objects" 
#
if [ ! -d ${EPGMANAGER_XML_DIR} ]; then
	echo "Creating ${EPGMANAGER_XML_DIR} directory"
	mkdir -p ${EPGMANAGER_XML_DIR}
fi
#
IS_RACDB=$(sqlplus -S /nolog<<AFG
  connect / as sysdba
  set pages 0
  set feedback off
  select case value when 'TRUE' then 1 else 0 end  from v\$parameter where name = 'cluster_database';
  exit
AFG
)

if [ "${IS_RACDB}" -eq 1 ]; then
  RAC_CONF_DIR="/home/oracle/scripts/rac/racconfig"
  NODE1_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE1"`
  NODE2_HOSTNAME=`sh ${RAC_CONF_DIR}/get_var_value.sh "DB_NODE2"`
  CURRENTHOST=`hostname`
  if [ "${CURRENTHOST}" = "${NODE1_HOSTNAME}" ]; then
    OTHERHOST=${NODE2_HOSTNAME}
  elif [ "${CURRENTHOST}" = "${NODE2_HOSTNAME}" ]; then
    OTHERHOST=${NODE1_HOSTNAME}
  fi
  if [ ! "${OTHERHOST}" = "" ] && [ -d "/clusfiles/epgpublish" ]; then
     if [ ! -d ${EPGMANAGER_PUB_DIR} ]; then
        /bin/ln -s /clusfiles/epgpublish /home/oracle
        ssh "oracle@${OTHERHOST}" "/bin/ln -s /clusfiles/epgpublish /home/oracle"
     fi
  fi
else
  if [ ! -d ${EPGMANAGER_PUB_DIR} ]; then
     echo "Creating ${EPGMANAGER_PUB_DIR} directory"
     mkdir -p ${EPGMANAGER_PUB_DIR}
  fi
fi
#
echo "Copying ${CVS_PATH}/${EPGMANAGER_SCHEMA_FILE} to ${EPGMANAGER_XML_DIR} directory"
cp -fv ${CVS_PATH}/${EPGMANAGER_SCHEMA_FILE} ${EPGMANAGER_XML_DIR}/${EPGMANAGER_SCHEMA_FILE} 
#
echo "Creating EPG Manager schema..."
sqlplus '/ as sysdba' @${CVS_PATH}/createepgmgr.sql ${EPG_DB_VERSION}

#delete the schema..Oracle should by now have copied it internally to it's schema folder
rm -rf ${EPGMANAGER_XML_DIR}

echo "Creating EPG Import Stored Procedures"
sqlplus 'epgmanager/epgmanager' @${CVS_PATH}/mergeepg.sql

echo "Creating EPG Export Stored Procedures"
sqlplus 'epgmanager/epgmanager' @${CVS_PATH}/exportepg.sql

echo "Done"

