create or replace
PACKAGE EPGMERGE AS
   procedure load(v_filename varchar2 default 'Guidedata.xml', provider_id number default -1);
   procedure merge(provider_id number default -1, overwriteWithEmpty CHAR default 'Y', truncateProduction CHAR default 'N', daysBehindNowToKeep number default 14);
   procedure truncateprod;
   procedure truncatestg;   
   
   procedure purgeProduction(daysBehindNowToKeep number default 14);
   procedure purgeAlarmActivity(daysBehindNowToKeep number default 365);

   
    --Threshold time for schedule downloads
  vcurrentdatetime timestamp with time zone;
  const_nls_charset_id constant varchar2(100) := 'UTF-8';

  const_COMPONENT_NAME_INGEST constant nvarchar2(100) := 'INGEST';
  const_COMPONENT_NAME_MERGE constant nvarchar2(100) := 'MERGE';
  const_COMPONENT_NAME_EXPORT constant nvarchar2(100) := 'EXPORT_TO_STG';
  const_COMPONENT_NAME_PUBLISH constant nvarchar2(100) := 'EXPORT_TO_XML';
 
  const_ALARM_SEVERITY_WARNING constant nvarchar2(100) := 'WARNING';
  const_ALARM_SEVERITY_ERROR constant nvarchar2(100) := 'ERROR';
  const_ALARM_SEVERITY_CRITICAL constant nvarchar2(100) := 'CRITICAL';
  const_ALARM_SEVERITY_INFO constant nvarchar2(100) := 'INFORMATION';
  
  vschema varchar2(100) := 'EPGMANAGER';
    
  END EPGMERGE;
  /
 create or replace
PACKAGE BODY EPGMERGE AS

FUNCTION IS_TABLE_EXISTS (IN_TABLE_NAME VARCHAR2) RETURN boolean is
counter number(5) := 0;
begin
  select count(1) into counter from user_tables where TABLE_NAME=UPPER(IN_TABLE_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;

--Autonomous transaction procedure
  procedure autonomoustransaction(vsql varchar2,errmsg varchar2 default NULL, mask varchar2 default 'N') is
  PRAGMA AUTONOMOUS_TRANSACTION;
    verrmsg varchar2(32000);
  begin
    execute immediate vsql;
    commit;
  exception
    when others then
          verrmsg := errmsg ||' '||sqlerrm;
          select cast(verrmsg as varchar2(4000))
          into verrmsg
          from dual;
      if upper(mask) != 'Y' then
          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
          commit;
          raise;
      end if;
  end;
  
  
  procedure epgguidedatalogging(vsql varchar2) is
  begin
    autonomoustransaction('insert into epgguidedata_log(description) values ('''||vsql||''')');
  end;


  /* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in install_table*/
  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
--    dbms_output.put_line(vsql);
    execute immediate vsql;
  exception
    when others then
          verrmsg := errmsg ||' '||sqlerrm||' '||vsql;
          select cast(verrmsg as varchar2(4000))
          into verrmsg
          from dual;
      if upper(mask) != 'Y' then
          autonomoustransaction ('INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')');
          raise;
      end if;
  END CREATEOBJECT;
  
  PROCEDURE InsertProgramEntityMapping(alt_table_name varchar2, data_type varchar2, alt_column_name1 varchar2, alt_column_name2 varchar2 default '') IS
  vsql varchar(2000);
  column2_name varchar(200);
  column2_select1 varchar(200);
  column2_select2 varchar(200);
  column2_check varchar(2000);
  BEGIN
  
  epgguidedatalogging('Start of '||alt_table_name||' entity mapping merge');

  column2_select1 := '''''';
  if alt_column_name2 is not null then
    column2_name := '||'' ''||apt.'||alt_column_name2||'';
    column2_check := ' and em.alt_column_name2='''||alt_column_name2||''' and
       	em.alt_column_value2 = apt.'||alt_column_name2||'';
      column2_select1 := 'apt.'||alt_column_name2;
    column2_select2 := ', '||alt_column_name2;
  end if;

vsql:='insert into entity_mapping (
    		id,
    		name,
    		table_name,
    		column_name,
    		alt_column_name1,
    		alt_column_value1,
    		alt_column_name2,
    		alt_column_value2,
    		data_type)
    select
    	entity_mapping_seq.nextval as id,
    	'''||alt_table_name||'.''||apt.'||alt_column_name1||' '||column2_name||' as name,
    	'''||alt_table_name||''' as table_name,
      ''VALUE'' as column_name,
    	'''||alt_column_name1||''' as alt_column_name1,
    	apt.'||alt_column_name1||' as alt_column_value1,
    	'''||alt_column_name2||''' as alt_column_name2,
    	'||column2_select1||' as alt_column_value2,
    	'''||data_type||''' as data_type
    FROM entity_mapping em right outer join
       (
       		select distinct '||alt_column_name1||column2_select2||'
       		from '||alt_table_name||'
       	) apt
       	on
		em.Table_Name='''||alt_table_name||''' and
       	em.alt_column_name1='''||alt_column_name1||''' and
       	em.alt_column_value1 = apt.'||alt_column_name1||' '||column2_check||'
     	where em.table_name is null';
      
      --DBMS_OUTPUT.put_line(vsql);
      
      CREATEOBJECT(vsql,'Entity Mapping Program Insert');
      
  END InsertProgramEntityMapping;
  
  PROCEDURE InsertScheduleEntityMapping(alt_table_name varchar2, data_type varchar2, alt_column_name1 varchar2, alt_column_name2 varchar2 default '') IS
  vsql varchar(2000);
  column2_name varchar(200);
  column2_select1 varchar(200);
  column2_select2 varchar(200);
  column2_check varchar(2000);
  BEGIN
  
  epgguidedatalogging('Start of '||alt_table_name||' entity mapping merge');

  column2_select1 := '''''';
  if alt_column_name2 is not null then
    column2_name := '||'' ''||ast.'||alt_column_name2||'';
    column2_check := ' and em.alt_column_name2='''||alt_column_name2||''' and
       	em.alt_column_value2 = ast.'||alt_column_name2||'';
      column2_select1 := 'ast.'||alt_column_name2;
    column2_select2 := ', '||alt_column_name2;
  end if;

vsql:='insert into entity_mapping (
    		id,
    		name,
    		table_name,
    		column_name,
    		alt_column_name1,
    		alt_column_value1,
    		alt_column_name2,
    		alt_column_value2,
    		data_type)
    select
    	entity_mapping_seq.nextval as id,
    	'''||alt_table_name||'.''||ast.'||alt_column_name1||' '||column2_name||' as name,
    	'''||alt_table_name||''' as table_name,
      	''VALUE'' as column_name,
    	'''||alt_column_name1||''' as alt_column_name1,
    	ast.'||alt_column_name1||' as alt_column_value1,
    	'''||alt_column_name2||''' as alt_column_name2,
    	'||column2_select1||' as alt_column_value2,
    	'''||data_type||''' as data_type
    FROM entity_mapping em right outer join
       (
       		select distinct '||alt_column_name1||column2_select2||'
       		from '||alt_table_name||'
       	) ast
       	on
		em.Table_Name='''||alt_table_name||''' and
       	em.alt_column_name1='''||alt_column_name1||''' and
       	em.alt_column_value1 = ast.'||alt_column_name1||' '||column2_check||'
     	where em.table_name is null';
      
      --DBMS_OUTPUT.put_line(vsql);
      
      CREATEOBJECT(vsql,'Entity Mapping Schedule Insert');
      
  END InsertScheduleEntityMapping;
  
  function getpropertyvalue(property_key varchar2) return nvarchar2 as
  property_value nvarchar2(2000);
 -- language_id backend_application_resources.language%type;
  begin
 --    select value into language_id from config_setting where key='I18N_LANGUAGE_ID';

  --  if language_id is null then
  --    language_id :='en';
  --  end if;

   -- select value into property_value from backend_application_resources where key = property_key and language = language_id;

  -- if (property_value is null) then
      return property_key;
   -- else
    --  return property_value;
   -- end if;
end;


  /* Procedure: SetDbCreateFileDest. Sets the default directory for Oracle datafiles so the path
              need not be given when creating tablespaces. */
  PROCEDURE SETDBCREATEFILEDEST(vpath varchar2) IS
  BEGIN
    execute immediate 'alter system set db_create_file_dest='''||vpath||''' scope=both';
  END SETDBCREATEFILEDEST;
  
  --Create Alarms
  procedure alarmactivitylogging(vdesc nvarchar2,
  				vcomponent nvarchar2 default const_COMPONENT_NAME_INGEST, 
  				vseverity nvarchar2 default const_ALARM_SEVERITY_INFO) is
    vsql varchar2(32767);
  begin
      vsql := 'insert into alarm_activitylog (ID,SEVERITY,COMPONENT,DESCRIPTION,CREATED_BY,UPDATED_BY)
                select alarm_activitylog_seq.nextval,'''||vseverity||''','''||vcomponent||''',
                      substr('''||vdesc||''',1,2000),''SYSTEM'',''SYSTEM''
                      from dual';
      --dbms_output.put_line(vsql);
     autonomoustransaction(vsql);
  end alarmactivitylogging;
  
   /* Procedure: Populate vmaxscheduledatetime variable*/
  PROCEDURE init is
  BEGIN
    begin
      select current_timestamp + numtodsinterval(nvl(value,0),'SECOND')
      into vcurrentdatetime
      from config_setting, dual
      where key = 'EPG_Schedule_Delay_Secs';
    exception
      when others then
        select current_timestamp
        into vcurrentdatetime
        from dual;
    end;
    
  end init;
  
  			
  procedure purgeProduction(daysBehindNowToKeep number default 14) is
   	programIdList varchar2(32767);
   	vsql varchar2(32767);
   	scheduleCount number;
   	programCount number;
   	cutDateTime timestamp with time zone;
    CURSOR programIds(cutDate timestamp with time zone) is select unique program_id from schedule where (START_TIME < cutDate) and ( program_id not in (select unique program_id from schedule where START_TIME > cutDate) and rownum < 1000 );
   begin
	   -- clean up old data
	   -- look for schedule entires more than 'daysBehindNowToKeep' old and remove them
	   -- then if no other schedule id references the same program id, also remove the related program id records from
	   -- 	Schedule Event id
	   --	schedule series attrib
	   --	schedule generic,
	   --	Program 
	   --   program rating
		-- program audio comp			
		-- program subtitle comp		
		-- program cast firstname		
		-- program cast lastname		
		-- program credits lastname		
		-- program credits firstname
		-- program generic
		
	   -- get the cutoff date
      select current_timestamp - numtodsinterval(daysBehindNowToKeep,'DAY')
      into cutDateTime
      from  dual;
      
	 select count(schedule_id) into scheduleCount from Schedule where START_TIME < cutDateTime;      
		
      epgguidedatalogging('purge: daysBehindNowToKeep: '||to_char(daysBehindNowToKeep)||' cutDate:'||cutDateTime||' Schedules to purge:'||to_char(scheduleCount));
	 
	 
	 if scheduleCount > 0 then
	 	 
	 	-- get the program id list
	 	programIdList :='(';
  	 	for pi in programIds(cutDateTime) LOOP
		    if programIdList != '(' then
      			programIdList:=programIdList||', '||pi.program_id;
    		else
	      		programIdList:=programIdList||pi.program_id;
    		end if;
    		programCount := programIds%rowcount;
  		end loop;
  		programIdList :=programIdList||') ';
		 
		-- drop schedule records.
	 	delete from schedule where START_TIME < cutDateTime;
		 
		-- drop schedule support table records
		vsql := 'delete from SCHEDULE_EVENT_ID where program_id in '||programIdList;
		CREATEOBJECT(vsql,'purge schedule_event_id');
		
		vsql := 'delete from SCHEDULE_SERIES_ATTRIB where program_id in '||programIdList;
		CREATEOBJECT(vsql,'purge schedule_series_attrib');
		
		vsql := 'delete from SCHEDULE_GENERIC where program_id in'||programIdList;
		CREATEOBJECT(vsql,'purge schedule_generic');
	
		epgguidedatalogging('Purging '||programCount||' program records');
	
		-- drop program table records
		vsql:='delete from program where program_id in '||programIdList;
		CREATEOBJECT(vsql,'purge program');
		
		-- support tables will getcleaned up by foreign key cascade deletes
	
		if scheduleCount > 0 or programCount > 0 then
			alarmactivitylogging('Completed purge of old production data. Removed '||scheduleCount||' schedules, '||programCount||' programs older than '||cutDateTime,const_COMPONENT_NAME_MERGE);
		end if;
		
	end if;
	
   end purgeProduction;
   
   procedure purgeAlarmActivity(daysBehindNowToKeep number default 365) is
   	vsql varchar2(32767);
   	alarmCount number;
   	cutDateTime timestamp with time zone;
   begin
		-- remove old entries from alarm activity log...
	  select current_timestamp - numtodsinterval(daysBehindNowToKeep,'DAY')
      into cutDateTime
      from  dual;
	
	 epgguidedatalogging('purgeAlarmActivity:  daysBehindNowToKeep:'||to_char(daysBehindNowToKeep)||' cutDate: '||cutDateTime);
	 
	 -- insert the dump logic here to save records before they are purged.
		
	  delete from alarm_activitylog where CREATE_DATE < cutDateTime;
	  
	  -- insert the dump logic here to save records before they are purged
	  
	  delete from EPGGUIDEDATA_LOG where LOGDATETIME < cutDateTime;
	   
   end purgeAlarmActivity;
  
  PROCEDURE truncateprod is
  BEGIN
   
	-- for now we wipe the production tables on each run.
	-- clearly this won't work going forward.
	

   EXECUTE IMMEDIATE 'delete from lineup';
   EXECUTE IMMEDIATE 'truncate table lineup_generic';	     
   EXECUTE IMMEDIATE 'truncate table schedule';
   EXECUTE IMMEDIATE 'truncate table schedule_event_id';
   EXECUTE IMMEDIATE 'truncate table schedule_series_attrib';
   EXECUTE IMMEDIATE 'truncate table schedule_generic';
   EXECUTE IMMEDIATE 'truncate table headend_generic';   
   EXECUTE IMMEDIATE 'delete from headend';
   EXECUTE IMMEDIATE 'delete from program';
   EXECUTE IMMEDIATE 'truncate table program_rating';   
   EXECUTE IMMEDIATE 'truncate table program_audio_comp';   
   EXECUTE IMMEDIATE 'truncate table program_generic';     
   EXECUTE IMMEDIATE 'truncate table program_cast';  
   EXECUTE IMMEDIATE 'truncate table program_subtitle_comp';   
   EXECUTE IMMEDIATE 'truncate table program_credits';
   EXECUTE IMMEDIATE 'truncate table station_generic';   
   EXECUTE IMMEDIATE 'delete from station';

   commit;
     
  END truncateprod;
  
  PROCEDURE truncatestg is
  BEGIN
   
	-- for now we wipe the production tables on each run.
	-- clearly this won't work going forward.
	
   EXECUTE IMMEDIATE 'truncate table stg_lineup';
   EXECUTE IMMEDIATE 'truncate table stg_lineup_generic';
   EXECUTE IMMEDIATE 'truncate table stg_schedule';
   EXECUTE IMMEDIATE 'truncate table stg_schedule_event_id';
   EXECUTE IMMEDIATE 'truncate table stg_schedule_series_attrib';
   EXECUTE IMMEDIATE 'truncate table stg_schedule_generic';   
   EXECUTE IMMEDIATE 'delete from stg_headend';
   EXECUTE IMMEDIATE 'truncate table stg_headend_generic';
   EXECUTE IMMEDIATE 'delete from stg_program';
   EXECUTE IMMEDIATE 'truncate table stg_program_rating';   
   EXECUTE IMMEDIATE 'truncate table stg_program_audio_comp';   
   EXECUTE IMMEDIATE 'truncate table stg_program_generic';    
   EXECUTE IMMEDIATE 'truncate table stg_program_cast';
   EXECUTE IMMEDIATE 'truncate table stg_program_subtitle_comp';   
   EXECUTE IMMEDIATE 'truncate table stg_program_credits'; 
   EXECUTE IMMEDIATE 'delete from stg_station';
   EXECUTE IMMEDIATE 'truncate table stg_station_generic';

   commit;
     
  END truncatestg;
  
    procedure delete_leftover_files(v_filename varchar2) is

	  type vtabdeletefilename is table of varchar2(4000) INDEX BY PLS_INTEGER;

	  vdeletefilenames vtabdeletefilename;

			begin

			  select any_path

			  bulk collect into vdeletefilenames

			  from resource_view

			  where any_path like '/public/epgmanager/%'

			  and any_path != '/public/epgmanager/'||v_filename;



			  if vdeletefilenames.count > 0 then

			     FOR indx IN 1 .. vdeletefilenames.COUNT

			     LOOP

			      dbms_xdb.deleteresource(vdeletefilenames(indx),dbms_xdb.delete_recursive_force);

			     END LOOP;

			  end if;

			end;
   
  procedure processepgdata(providerName nvarchar2, v_filename varchar2) is
    vsql varchar2(32767);
    vcurrentdatetimeforlog timestamp with time zone;
    minutesittook varchar2(20);
    secondsittook varchar2(20);
    hoursittook varchar2(20);
--    bytesToLoad number;
--    totalSecondsItTook number;
--    rate number;
   cursor programCasts is select spv.database_key as programId, xmldata.role as role, xmldata.firstname as firstname, xmldata.lastname as lastname
                                  from stg_program_view spv,
                                                   XMLTABLE('/CAST_NAME_ROLE' passing spv.cast_name_role columns
                                                   role NVARCHAR2(200) path 'CAST_ROLE_DESC',
                                                   firstname NVARCHAR2(200) path 'CAST_FIRST_NAME',
                                                   lastname NVARCHAR2(100) path 'CAST_LAST_NAME'
                                                   ) xmldata
                                                   where spv.cast_name_role is not null;                                              
                                                   
                                                   
   cursor programCredits is select spv.database_key as programId, xmldata.role as role, xmldata.firstname as firstname, xmldata.lastname as lastname
                                  from stg_program_view spv,
                                                   XMLTABLE('/CREDITS_NAME_ROLE' passing spv.credits_name_role columns
                                                   role NVARCHAR2(200) path 'CREDITS_ROLE_DESC',
                                                   firstname NVARCHAR2(200) path 'CREDITS_FIRST_NAME',
                                                   lastname NVARCHAR2(100) path 'CREDITS_LAST_NAME'
                                                   ) xmldata
                                                   where spv.credits_name_role is not null;
   maxSeq number;
    
  begin

    --Logging start of load
--	select dbms_lob.getlength(xmltype.getclobval(res)) into bytesToLoad from RESOURCE_VIEW where ANY_PATH like CONCAT('%',v_filename);

    epgguidedatalogging('Start of EPG File for '||providerName||' of file '||v_filename); --||' of size '||to_char(bytesToLoad));
    vcurrentdatetimeforlog := current_timestamp;
    alarmactivitylogging('Starting EPG load for provider '||providerName, const_COMPONENT_NAME_INGEST);

    truncatestg();

    vsql := 'truncate table err$_stg_headend';
    CREATEOBJECT(vsql,'truncate table err$_stg_headend');

    epgguidedatalogging('Start of Staging Headend load. StartTime = '||current_timestamp);

    vsql := 'INSERT /*+ append */ INTO stg_headend (FILENAME,
    HEADEND_ID,
    COMMUNITY_NAME,
    COUNTY_NAME,
    COUNTY_SIZE,
    ST_COUNTY_CODE,
    STATE,
    ZIPCODE,
    DMA_CODE,
    DMA_NAME,
    MSO_CODE,
    DMA_RANK,
    HEADEND_NAME,
    HEADEND_LOCATION,
    MSO_NAME,
    TIME_ZONE)
    SELECT '''||v_filename||''',
    HE_HEADEND_ID,
    HE_COMMUNITY_NAME,
    HE_COUNTY_NAME,
    HE_COUNTY_SIZE,
    HE_ST_COUNTY_CODE,
    HE_STATE_SERVED,
    HE_ZIP_CODE,
    HE_DMA_CODE,
    HE_DMA_NAME,
    HE_MSO_CODE,
    HE_DMA_RANK,
    HE_HEADEND_NAME,
    HE_HEADEND_LOCATION,
    HE_MSO_NAME,
    HE_TIME_ZONE_CODE FROM stg_headend_view
    log errors into err$_stg_headend reject limit 0';
    CREATEOBJECT(vsql,'LOAD INTO STG_HEADEND');
    commit;
    
    /* stg_headend_generic */
    epgguidedatalogging('Start of Staging Headend_Generic Load');    
 
     vsql := 'truncate table err$_stg_headend_generic';
    CREATEOBJECT(vsql,'truncate err$_stg_headend_generic');
    
    vsql := 'insert into stg_headend_generic(FILENAME,
    HEADEND_ID,
	ASSET,
	NAME,
	VALUE ) 
    select '''||v_filename||''',
    shv.he_headend_id,
    xmldata.asset,
	xmldata.name, 
	xmldata.value
    from stg_headend_view shv,
      XMLTABLE(''/HE_GENERIC'' passing shv.he_generic columns
		asset NVARCHAR2(200) path ''@Asset'',
		name NVARCHAR2(200) path ''@Name'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE shv.he_generic is not null
    log errors into err$_stg_headend_generic reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_headend_generic');
  
    commit;

    
    epgguidedatalogging('Start of Staging Station Load');
    
    vsql := 'truncate table err$_stg_station';
    CREATEOBJECT(vsql,'truncate err$_stg_station');

    --To resolve a bug with character mismatch with station_id, we are creating a temp table and then populating values into stg_station
    vsql := 'drop table temp_station';
    CREATEOBJECT(vsql,'drop table temp_station','Y');

    vsql := 'CREATE TABLE TEMP_STATION
    (FILENAME,
    STATION_ID,
    TIME_ZONE,
    STATION_NAME,
    CALL_SIGN,
    AFFILIATION,
    CITY,
    STATE,
    ZIPCODE,
    COUNTRY,
    DMA_NAME,
    DMA_NUMBER,
    FCC_CHANNEL_NUM,
    USER_DATA1,
    USER_DATA2,
    USER_DATA3,
    USER_DATA4,
    USER_DATA5,
    USER_DATA6,
    USER_DATA7,
    USER_DATA8,
    USER_DATA9,
    USER_DATA10) nologging
    AS
    SELECT '''||v_filename||''',
    STATION_ID,
    STATION_TIME_ZONE,
    STATION_NAME,
    STATION_CALL_SIGN,
    STATION_AFFIL,
    STATION_CITY,
    STATION_STATE,
    STATION_ZIP_CODE,
    STATION_COUNTRY,
    DMA_NAME,
    DMA_NUM,
    FCC_CHANNEL_NUM,
    USER_DATA1,
    USER_DATA2,
    USER_DATA3,
    USER_DATA4,
    USER_DATA5,
    USER_DATA6,
    USER_DATA7,
    USER_DATA8,
    USER_DATA9,
    USER_DATA10
    FROM STG_STATION_VIEW';
    CREATEOBJECT(vsql,'create table temp_station');


    vsql := 'INSERT /*+ append */ INTO STG_STATION
    (FILENAME,
    STATION_ID,
    TIME_ZONE,
    STATION_NAME,
    CALL_SIGN,
    AFFILIATION,
    CITY,
    STATE,
    ZIPCODE,
    COUNTRY,
    DMA_NAME,
    DMA_NUMBER,
    FCC_CHANNEL_NUM,
    USER_DATA1,
    USER_DATA2,
    USER_DATA3,
    USER_DATA4,
    USER_DATA5,
    USER_DATA6,
    USER_DATA7,
    USER_DATA8,
    USER_DATA9,
    USER_DATA10)
    SELECT FILENAME,
    STATION_ID,
    TIME_ZONE,
    STATION_NAME,
    CALL_SIGN,
    AFFILIATION,
    CITY,
    STATE,
    ZIPCODE,
    COUNTRY,
    DMA_NAME,
    DMA_NUMBER,
    FCC_CHANNEL_NUM,
    USER_DATA1,
    USER_DATA2,
    USER_DATA3,
    USER_DATA4,
    USER_DATA5,
    USER_DATA6,
    USER_DATA7,
    USER_DATA8,
    USER_DATA9,
    USER_DATA10
    FROM TEMP_STATION
    log errors into err$_stg_station reject limit 0';
    CREATEOBJECT(vsql,'LOAD INTO stg_station');
    commit;
    
    /* stg_headend_generic */
    epgguidedatalogging('Start of Staging Station_Generic Load');    
 
     vsql := 'truncate table err$_stg_station_generic';
    CREATEOBJECT(vsql,'truncate err$_stg_station_generic');
    
    vsql := 'insert into stg_station_generic(FILENAME,
    STATION_ID,
	ASSET,
	NAME,
	VALUE ) 
    select '''||v_filename||''',
    ssv.station_id,
    xmldata.asset,
	xmldata.name, 
	xmldata.value
    from stg_station_view ssv,
      XMLTABLE(''/STATION_GENERIC'' passing ssv.station_generic columns
		asset NVARCHAR2(200) path ''@Asset'',
		name NVARCHAR2(200) path ''@Name'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE ssv.station_generic is not null
    log errors into err$_stg_station_generic reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_station_generic');
  
    commit;
   
    epgguidedatalogging('Start of Staging Lineup Load');

    vsql := 'truncate table err$_stg_lineup';
    CREATEOBJECT(vsql,'truncate table err$_stg_lineup');

    --To resolve a bug with character mismatch with station_id, we are creating a temp table and then populating values into stg_lineup
    vsql := 'drop table temp_lineup';
    CREATEOBJECT(vsql,'drop table temp_lineup','Y');

    vsql := 'CREATE TABLE TEMP_LINEUP (FILENAME,
    CL_ROW_ID,
    CL_STATION_NUM,
    CL_HEADEND_ID,
    CL_DEVICE,
    CL_TMS_CHAN,
    CL_SERVICE_TIER,
    CL_EFFECTIVE_DATE,
    CL_EXPIRATION_DATE) nologging
    AS
    SELECT '''||v_filename||''',
    CL_ROW_ID,
    CL_STATION_NUM,
    CL_HEADEND_ID,
    CL_DEVICE,
    CL_TMS_CHAN,
    CL_SERVICE_TIER,
    case when cl_effective_date is not null then to_timestamp_tz(CL_EFFECTIVE_DATE||'' UTC'',''YYYY-MM-DD"T"HH24:MI:SS.FF TZR'') else null end as CL_EFFECTIVE_DATE,
    case when cl_expiration_date is not null then to_timestamp_tz(CL_EXPIRATION_DATE ||'' UTC'',''YYYY-MM-DD"T"HH24:MI:SS.FF TZR'') else null end as CL_EXPIRATION_DATE
    FROM STG_LINEUP_VIEW';
    CREATEOBJECT(vsql,'CREATE TABLE TEMP_LINEUP');

    vsql := 'INSERT /*+ append */ INTO STG_LINEUP (FILENAME,
    LINEUP_ID,
    STATION_ID,
    HEADEND_ID,
    DEVICE,
    TMS_CHANNEL,
    SERVICE_TIER,
    EFFECTIVE_DATE,
    EXPIRATION_DATE)
    SELECT FILENAME,
    CL_ROW_ID,
    CL_STATION_NUM,
    CL_HEADEND_ID,
    CL_DEVICE,
    CL_TMS_CHAN,
    CL_SERVICE_TIER,
    CL_EFFECTIVE_DATE,
    CL_EXPIRATION_DATE FROM TEMP_LINEUP
    log errors into err$_stg_lineup reject limit 0';
    CREATEOBJECT(vsql,'LOAD INTO STG_LINEUP');

    commit;
    
        /* stg_lineup_generic */
    epgguidedatalogging('Start of Staging Lineup_Generic Load');    
 
     vsql := 'truncate table err$_stg_lineup_generic';
    CREATEOBJECT(vsql,'truncate err$_stg_lineup_generic');
    
    vsql := 'insert into stg_lineup_generic(FILENAME,
    LINEUP_ID,
	HEADEND_ID,
	STATION_ID,
	ASSET,
	NAME,
	VALUE ) 
    select '''||v_filename||''',
    slv.CL_ROW_ID,
	slv.CL_HEADEND_ID,
	slv.CL_STATION_NUM,
    xmldata.asset,
	xmldata.name, 
	xmldata.value
    from stg_lineup_view slv,
      XMLTABLE(''/CL_GENERIC'' passing slv.cl_generic columns
		asset NVARCHAR2(200) path ''@Asset'',
		name NVARCHAR2(200) path ''@Name'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE slv.cl_generic is not null
    log errors into err$_stg_lineup_generic reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_lineup_generic');
  
    epgguidedatalogging('Start of Staging Program Load');

    vsql := 'truncate table err$_stg_program';
    CREATEOBJECT(vsql,'truncate err$_stg_program');

    vsql := 'DROP INDEX IDX_STGPRG_PRGID';
    CREATEOBJECT(vsql,'drop index IDX_STGPRG_PRGID','Y');

    vsql := 'insert /*+ append */ into stg_program(FILENAME,
        PROGRAM_ID,
        LANGUAGE,
        TITLE,
        REDUCED_TITLE1,
        REDUCED_TITLE2,
        REDUCED_TITLE3,
        REDUCED_TITLE4,
        ALT_TITLE,
        REDUCED_DESCRIPTION1,
        REDUCED_DESCRIPTION2,
        REDUCED_DESCRIPTION3,
        REDUCED_DESCRIPTION4,
        ADVISORY_DESC1,
        ADVISORY_DESC2,
        ADVISORY_DESC3,
        ADVISORY_DESC4,
        ADVISORY_DESC5,
        ADVISORY_DESC6,
        GENRE_DESC1,
        GENRE_DESC2,
        GENRE_DESC3,
        GENRE_DESC4,
        GENRE_DESC5,
        GENRE_DESC6,
        DESCRIPTION1,
        DESCRIPTION2,
        YEAR_PROGRAM,
        MPAA_RATING,
        STAR_RATING,
        RUN_TIME,
        COLOR_CODE,
        PROGRAM_LANGUAGE,
        COUNTRY_OF_ORIGIN,
        MADE_FOR_TV,
        SOURCE_TYPE,
        SHOW_TYPE,
        HOLIDAY,
        SYNDICATE_EPISODE_NUM,
        ALT_SYNDICATE_EPI_NUM,
        EPISODE_TITLE,
        NET_SYN_SOURCE,
        NET_SYN_TYPE,
        ORG_STUDIO,
        GAME_DATETIME,
        GAME_TIMEZONE,
        ORG_AIR_DATE,
        UNIQUE_ID,
        USER_DATA1 ,
        USER_DATA2 ,
        USER_DATA3 ,
        USER_DATA4 ,
        USER_DATA5 ,
        USER_DATA6 ,
        USER_DATA7 ,
        USER_DATA8 ,
        USER_DATA9 ,
        USER_DATA10 ,
        USER_DATA11 ,
        USER_DATA12 ,
        USER_DATA13 
        )
        select '''||v_filename||''',
        DATABASE_KEY,
        LANGUAGE,
        TITLE,
        REDUCED_TITLE1,
        REDUCED_TITLE2,
        REDUCED_TITLE3,
        REDUCED_TITLE4,
        ALT_TITLE,
        REDUCED_DESC1,
        REDUCED_DESC2,
        REDUCED_DESC3,
        REDUCED_DESC4,
        ADVISORY_DESC1,
        ADVISORY_DESC2,
        ADVISORY_DESC3,
        ADVISORY_DESC4,
        ADVISORY_DESC5,
        ADVISORY_DESC6,
        GENRE_DESC1,
        GENRE_DESC2,
        GENRE_DESC3,
        GENRE_DESC4,
        GENRE_DESC5,
        GENRE_DESC6,
        DESCRIPTION1,
        DESCRIPTION2,
        YEAR_PROGRAM,
        MPAA_RATING,
        STAR_RATING,
        RUN_TIME,
        COLOR_CODE,
        PROGRAM_LANGUAGE,
        ORG_COUNTRY,
        MADE_FOR_TV,
        SOURCE_TYPE,
        SHOW_TYPE,
        HOLIDAY,
        SYN_EPI_NUM,
        ALT_SYN_EPI_NUM,
        EPI_TITLE,
        NET_SYN_SOURCE,
        NET_SYN_TYPE,
        ORG_STUDIO,
        case when GAME_DATE is not null then to_timestamp_tz(GAME_DATE||'' UTC'',''YYYY-MM-DD"T"HH24:MI:SS.FF TZR'') else null end as GAME_DATE,
        GAME_TIMEZONE,
        case when ORG_AIR_DATE is not null then to_timestamp_tz(ORG_AIR_DATE ||'' UTC'',''YYYY-MM-DD"T"HH24:MI:SS.FF TZR'') else null end as ORG_AIR_DATE,
        UNIQUE_ID,
        USER_DATA1 ,
        USER_DATA2 ,
        USER_DATA3 ,
        USER_DATA4 ,
        USER_DATA5 ,
        USER_DATA6 ,
        USER_DATA7 ,
        USER_DATA8 ,
        USER_DATA9 ,
        USER_DATA10,
        USER_DATA11,
        USER_DATA12,
        USER_DATA13
      from stg_program_view
    log errors into err$_stg_program reject limit 0';
    CREATEOBJECT(vsql,'LOAD INTO stg_program');

    commit;

    vsql := 'CREATE INDEX IDX_STGPRG_PRGID ON STG_PROGRAM(program_id) nologging';
    CREATEOBJECT(vsql,'create index stg_program','Y');

	--removed a long commented code for deleting repeated programs while porting from TSTV
     commit;
     
     /* program stage support tables */
     
     /* load into stg_program_rating */
     
    epgguidedatalogging('Start of Staging Program_Rating Load');
     vsql := 'truncate table err$_stg_program_rating';
    CREATEOBJECT(vsql,'truncate err$_stg_program_rating');

    vsql := 'insert into stg_program_rating(FILENAME,
    PROGRAM_ID,
	AUTHORITY,
	VALUE ) 
    select '''||v_filename||''',
    spv.database_key,
    xmldata.authority,
    xmldata.value
    from stg_program_view spv,
      XMLTABLE(''/PROGRAM_RATING'' passing spv.program_rating columns
		authority NVARCHAR2(100) path ''@Authority'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE spv.program_rating is not null
    log errors into err$_stg_program_rating reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_program_rating');

    commit;
      
    /* staged program audio compononent */
     
    epgguidedatalogging('Start of Staging Program_Audio_Comp Load');

    vsql := 'truncate table err$_STG_PROGRAM_AUDIO_COMP';
    CREATEOBJECT(vsql,'truncate err$_STG_PROGRAM_AUDIO_COMP');

    vsql := 'insert into stg_program_audio_comp(FILENAME,
  			PROGRAM_ID,
			TLA,
			TYPE,
			LANGUAGE,
  			ATTRIBUTE_TYPE, 
			VALUE ) 
    	select '''||v_filename||''', 
			spv.DATABASE_KEY,  
			xml1."type"||'' ''||xml1."language"||'' ''||xml2."AttributeType",
			xml1."type", 
			xml1."language", 
			xml2."AttributeType", 
			xml2."Value" 
		from stg_program_view spv,
  		XMLTABLE ( ''/AUDIO_COMPONENT'' passing spv.audio_component COLUMNS
  			"type" nvarchar2(200) path ''@Type'' ,
  			"language" nvarchar2(200) path ''@Language'',
  			"Attribute" XMLType path ''ComponentAttribute''
  		) as xml1,
  		XMLTABLE ( ''ComponentAttribute'' passing xml1."Attribute" COLUMNS
  			"AttributeType" nvarchar2(200) path ''@AttributeType'',
  			"Value" nvarchar2(200) path ''.''
 		) as xml2 WHERE spv.audio_component is not null
		log errors into err$_stg_program_audio_comp reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_program_audio_comp');

    commit;
    
    /* staged program subtitle components */
    epgguidedatalogging('Start of Staging Program_Subtitle_Comp Load');
 
    vsql := 'truncate table err$_STG_PROGRAM_SUBTITLE_COMP';
    CREATEOBJECT(vsql,'truncate err$_STG_PROGRAM_SUBTITLE_COMP');
    
    vsql := 'insert into stg_program_subtitle_comp(FILENAME,
  			PROGRAM_ID,
			TLA,
			TYPE,
			LANGUAGE,
  			ATTRIBUTE_TYPE, 
			VALUE ) 
    	select '''||v_filename||''', 
			spv.DATABASE_KEY, 
 			xml1."type"||'' ''||xml1."language"||'' ''||xml2."AttributeType",
			xml1."type", 
			xml1."language", 
			xml2."AttributeType", 
			xml2."Value" 
		from stg_program_view spv,
  		XMLTABLE ( ''/SUBTITLE_COMPONENT'' passing spv.subtitle_component COLUMNS
  			"type" nvarchar2(200) path ''@Type'' ,
  			"language" nvarchar2(200) path ''@Language'',
  			"Attribute" XMLType path ''ComponentAttribute''
  		) as xml1,
  		XMLTABLE ( ''ComponentAttribute'' passing xml1."Attribute" COLUMNS
  			"AttributeType" nvarchar2(200) path ''@AttributeType'',
  			"Value" nvarchar2(200) path ''.''
 		) as xml2 WHERE spv.subtitle_component is not null
		log errors into err$_stg_program_subtitle_comp reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_program_subtitle_comp');
    
    commit;
 

    epgguidedatalogging('Start of Staging Program_Cast Load');
    IF IS_TABLE_EXISTS('ERR$_STG_PROGRAM_CAST') THEN
      vsql := 'truncate table err$_STG_PROGRAM_CAST';
      CREATEOBJECT(vsql,'truncate err$_STG_PROGRAM_CAST');
    END IF;
    IF IS_TABLE_EXISTS('STG_PROGRAM_CAST') THEN
	  for programCast in programCasts loop
                select nvl(max(SEQ),0) into maxSeq from stg_program_cast where program_id=programCast.programId and role=programCast.role;
                
                insert into stg_program_cast(filename,program_id, role, seq, first_name, last_name)
                values(v_filename, programCast.programId, programCast.role, maxSeq+1, programCast.firstname, programCast.lastname);
  
	  end loop;
    END IF;

    commit;

    epgguidedatalogging('Start of Staging Program_Credits Load');
    
    IF IS_TABLE_EXISTS('err$_STG_PROGRAM_CREDITS') THEN
      vsql := 'truncate table err$_STG_PROGRAM_CREDITS';
      CREATEOBJECT(vsql,'truncate err$_STG_PROGRAM_CREDITS');
    END IF;    
    
    IF IS_TABLE_EXISTS('STG_PROGRAM_CREDITS') THEN
	  for programCredit in programCredits loop
                select nvl(max(SEQ),0) into maxSeq from stg_program_credits where program_id=programCredit.programId and role=programCredit.role;
                
                insert into stg_program_credits(filename,program_id, role, seq, first_name, last_name)
                values(v_filename, programCredit.programId, programCredit.role, maxSeq+1, programCredit.firstname, programCredit.lastname);
  
	  end loop;
    END IF;

    commit;

    


    /* stg_program_generic */
    epgguidedatalogging('Start of Staging Program_Generic Load');    
 
     vsql := 'truncate table err$_stg_program_generic';
    CREATEOBJECT(vsql,'truncate err$_stg_program_generic');
    
    vsql := 'insert into stg_program_generic(FILENAME,
    PROGRAM_ID,
	ASSET,
	NAME,
	VALUE ) 
    select '''||v_filename||''',
    spv.database_key,
    xmldata.asset,
	xmldata.name, 
	xmldata.value
    from stg_program_view spv,
      XMLTABLE(''/PROGRAM_GENERIC'' passing spv.program_generic columns
		asset NVARCHAR2(200) path ''@Asset'',
		name NVARCHAR2(200) path ''@Name'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE spv.program_generic is not null
    log errors into err$_stg_program_generic reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_program_generic');
  
    commit;
    
    /* end of program support stage loads */
   
    epgguidedatalogging('Start of Staging Schedule Load');

    vsql := 'truncate table err$_stg_schedule';
    CREATEOBJECT(vsql,'truncate err$_stg_schedule');

    vsql := 'DROP INDEX IDX_STGSCH_PK';
    CREATEOBJECT(vsql,'Drop Index IDX_STGSCH_PK','Y');

    vsql := 'DROP INDEX index_sid_stg_schedule';
    CREATEOBJECT(vsql,'Drop Index index_sid_stg_schedule','Y');

    commit;

    vsql := 'insert into stg_schedule(FILENAME,
    STATION_ID,
    PROGRAM_ID,
    SCHEDULE_LANGUAGE,
    start_time,
    DURATION,
    PART_NUMBER,
    NO_OF_PARTS,
	SERIES_ID,
    CC,
    STEREO,
    REPEAT,
    LIVE_TAPE_DELAY,
    SUBTITLED,
    PREMIERE_FINALE,
    JOINED_IN_PROGRESS,
    CABLE_IN_CLASSROOM,
    TV_RATING,
    SAP,
    BLACKOUT,
    SEX_RATING,
    VIOLENCE_RATING,
    LANGUAGE_RATING,
    DIALOG_RATING,
    FV_RATING,
    ENHANCED,
    THREE_D,
    LETTERBOX,
    HD_TV,
    DOLBY,
    DVS,
    REQUEST_RECORD,
     USER_DATA1,
     USER_DATA2,
     USER_DATA3,
     USER_DATA4,
     USER_DATA5,
     USER_DATA6,
     USER_DATA7,
     USER_DATA8,
     USER_DATA9,
     USER_DATA10,
     USER_DATA11
	)
    SELECT '''||v_filename||''',
    STATION_NUM,
    DATABASE_KEY,
    SCHEDULE_LANGUAGE,
 	 to_timestamp_tz(AIR_DATE||'' UTC'',''YYYY-MM-DD"T"HH24:MI:SS.FF TZR'')  as AIR_DATE,
     /** The Duration Format is HHMMSS  054530 **/
    (floor(to_number(DURATION)/10000)) *60 *60 + floor (mod(to_number(DURATION),10000) /100)*60 + mod(to_number(DURATION),100) as DURATION,
   PART_NUM,
    NUM_OF_PARTS,
	SERIES_ID,
    CC,
    STEREO,
    REPEAT,
    LIVE_TAPE_DELAY,
    SUBTITLED,
    PREMIERE_FINALE,
    JOINED_IN_PROGRESS,
    CABLE_IN_THE_CLASSROOM,
    TV_RATING,
    SAP,
    BLACKOUT,
    SEX_RATING,
    VIOLENCE_RATING,
    LANGUAGE_RATING,
    DIALOG_RATING,
    FV_RATING,
    ENHANCED,
    THREE_D,
    LETTERBOX,
    HDTV,
    DOLBY,
    DVS,
    REQUEST_RECORD,
     USER_DATA1,
     USER_DATA2,
     USER_DATA3,
     USER_DATA4,
     USER_DATA5,
     USER_DATA6,
     USER_DATA7,
     USER_DATA8,
     USER_DATA9,
     USER_DATA10,
     USER_DATA11
    from stg_schedule_view
    log errors into err$_stg_schedule reject limit 0';
    CREATEOBJECT(vsql,'LOAD INTO stg_schedule');

    commit;
    vsql := 'CREATE INDEX IDX_STGSCH_PK ON STG_SCHEDULE(STATION_ID,PROGRAM_ID,start_time)  nologging';
    CREATEOBJECT(vsql,'Create Index IDX_STGSCH_PK','Y');

    commit;
    vsql :=' create index index_sid_stg_schedule on stg_schedule(PROGRAM_ID)   nologging';
    CREATEOBJECT(vsql,'create index on program_id on the table STG_SCHEDULE');

    commit;
     
    epgguidedatalogging('Start of Staging Schedule_event_id Load');
    
    vsql := 'truncate table err$_stg_schedule_event_id';
    CREATEOBJECT(vsql,'truncate err$_stg_schedule_event_id');
    
    /* stg schedule event id */
    vsql := 'insert into stg_schedule_event_id(FILENAME,
    PROGRAM_ID,
	IDENTIFIER_TYPE,
	VALUE ) 
    select '''||v_filename||''',
    ssv.database_key,
    xmldata.identifiertype,
	xmldata.value
    from stg_schedule_view ssv,
      XMLTABLE(''/EVENT_ID'' passing ssv.event_id columns
		identifiertype NVARCHAR2(100) path ''@IdentifierType'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE ssv.event_id is not null
    log errors into err$_stg_schedule_event_id reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_schedule_event_id');
  
    commit;
    
    epgguidedatalogging('Start of Staging Schedule_series_attrib Load');
    
    vsql := 'truncate table err$_stg_schedule_series_attri';
    CREATEOBJECT(vsql,'truncate err$_stg_schedule_series_attri');
    
    /* stg schedule series attribute */
    vsql := 'insert into stg_schedule_series_attrib(FILENAME,
    PROGRAM_ID,
	ATTRIBUTE_TYPE,
	VALUE ) 
    select '''||v_filename||''',
    ssv.database_key,
    xmldata.attributetype,
	xmldata.value
    from stg_schedule_view ssv,
      XMLTABLE(''/SERIES_LINK/SeriesAttribute'' passing ssv.series_link columns
		attributetype NVARCHAR2(100) path ''@AttributeType'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE ssv.series_link is not null
    log errors into err$_stg_schedule_series_attri reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_schedule_series_attrib');
  
    commit;
    
    epgguidedatalogging('Start of Staging Schedule_Generic Load');
        
     vsql := 'truncate table err$_stg_schedule_generic';
    CREATEOBJECT(vsql,'truncate err$_stg_schedule_generic');
    
    /* stg schedule generic */
    vsql := 'insert into stg_schedule_generic(FILENAME,
    PROGRAM_ID,
	ASSET,
	NAME,
	VALUE ) 
    select '''||v_filename||''',
    ssv.database_key,
    xmldata.asset,
	xmldata.name, 
	xmldata.value
    from stg_schedule_view ssv,
      XMLTABLE(''/SCHEDULE_GENERIC'' passing ssv.schedule_generic columns
		asset NVARCHAR2(200) path ''@Asset'',
		name NVARCHAR2(200) path ''@Name'',
		value NVARCHAR2(100) path ''text()''
      ) xmldata
    WHERE ssv.schedule_generic is not null
    log errors into err$_stg_schedule_generic reject limit unlimited';
    CREATEOBJECT(vsql,'LOAD INTO stg_schedule_generic');
  
    commit;

   SELECT floor(Extract(Minute from (current_timestamp - vcurrentdatetimeforlog))) into minutesittook from dual;
   SELECT floor(Extract(Second from (current_timestamp - vcurrentdatetimeforlog))) into secondsittook from dual;
   SELECT floor(Extract(Hour from (current_timestamp - vcurrentdatetimeforlog))) into hoursittook from dual;
   
--   totalSecondsItTook := TO_NUMBER(secondsittook) + ( TO_NUMBER(minutesittook) * 60 ) + ( TO_NUMBER(hoursittook) * 3600 );
--   rate := ( bytesToLoad / 128 ) / totalSecondsItTook; -- this should give us Kb/s kilobits per second. 
   
    epgguidedatalogging('End of Staging Load. It took '||hoursittook||' hours '||LPAD(minutesittook,2,'0')||' minutes and '||LPAD(secondsittook,2,'0')||' seconds');-- at a rate of '||to_char(rate)||' kbps');


    --Logging End of loading EPG File to Staging tables
    
    alarmactivitylogging('Finished EPG load for provider '||providerName||' (took '||hoursittook||':'||LPAD(minutesittook,2,0)||':'||LPAD(secondsittook,2,'0')||')', const_COMPONENT_NAME_INGEST);
    
  end processepgdata;
  
  procedure mergetstvWithEmpty (provider_name nvarchar2) is
    vsql varchar2(32767);
    vsqlwhere varchar2(32767);
    vschsqlwhere varchar2(32767);
    vmaxschedulestarttime schedule.start_time%type;
    vminstgschdate timestamp(0) with time zone;
    vmaxstgschdate timestamp(0) with time zone;
    vcnt_affectedrecording number := 0;
    is_epg_sch_conflict_completed varchar2(1) := 'Y';
     
    --sch_prg_md_chng_update_p_v backend_application_resources.value%type := getpropertyvalue('schedule_program_metadata_changed_to_update');
   -- sch_prg_md_chng_delete_p_v backend_application_resources.value%type := getpropertyvalue('schedule_program_metadata_changed_to_delete');
   -- sch_prg_md_chng_too_late_p_v backend_application_resources.value%type := getpropertyvalue('schedule_program_metadata_changed_too_late');
   -- rm_name_p_v  backend_application_resources.value%type := getpropertyvalue('rm_name');
   -- id_p_v  backend_application_resources.value%type := getpropertyvalue('id');
   -- schedule_start_time_p_v  backend_application_resources.value%type := getpropertyvalue('schedule_start_time');
   -- program_title_p_v  backend_application_resources.value%type := getpropertyvalue('program_title');
   -- station_call_sign_p_v  backend_application_resources.value%type := getpropertyvalue('station_call_sign');
   -- rcs_p_v backend_application_resources.value%type := getpropertyvalue('rcs');
   -- system_p_v backend_application_resources.value%type := getpropertyvalue('system');
    --prg_md_chng_p_v backend_application_resources.value%type := getpropertyvalue('program_metadata_changed');
  begin

     
    /* Headend Merge */
    epgguidedatalogging('Start of Merge Headend');
    
    vsql := 'merge into headend hprod
    using stg_headend hstg 
    on (hstg.headend_id = hprod.headend_id)
    when matched then
    update set 
		hprod.community_name = hstg.community_name, 
		hprod.county_name = hstg.county_name, 
		hprod.county_size = hstg.county_size, 
		hprod.st_county_code = hstg.st_county_code, 
		hprod.state = hstg.state , 
		hprod.zipcode = hstg.zipcode, 
		hprod.dma_code = hstg.dma_code, 
		hprod.dma_name = hstg.dma_name , 
		hprod.mso_code = hstg.mso_code, 
		hprod.dma_rank = hstg.dma_rank , 
		hprod.headend_name = hstg.headend_name , 
		hprod.headend_location = hstg.headend_location, 
		hprod.mso_name = hstg.mso_name, 
		hprod.time_zone = hstg.time_zone, 
		hprod.created_by = ''SYSTEM'', 
		hprod.updated_by = ''SYSTEM''
    when not matched then
    insert (hprod.headend_id,hprod.community_name, hprod.county_name, hprod.county_size, hprod.st_county_code, hprod.state, hprod.zipcode, hprod.dma_code, hprod.dma_name, hprod.mso_code, hprod.dma_rank, hprod.headend_name, hprod.headend_location, hprod.mso_name, hprod.time_zone, hprod.created_by,hprod.updated_by)
    values (hstg.headend_id,hstg.community_name, hstg.county_name, hstg.county_size, hstg.st_county_code, hstg.state, hstg.zipcode, hstg.dma_code, hstg.dma_name, hstg.mso_code, hstg.dma_rank, hstg.headend_name, hstg.headend_location, hstg.mso_name, hstg.time_zone,''SYSTEM'',''SYSTEM'')';
 
    CREATEOBJECT(vsql,'MERGE INTO HEADEND');

    --need to be fixed for the changes to alarmactivity log but I just dont understand what its doing :(
	-- vsql := 'select alarm_activitylog_seq.nextval,'||const_ALARM_SEVERITY_MAJOR||','''||getpropertyvalue('MERGE')||''',
     --             replace(replace(replace('''||getpropertyvalue('defaulting_headend_timezone_to_UTC')||''', ''{0}'', he.headend_name), ''{1}'', he.headend_location), ''{2}'',he.headend_id),

       --           ''EPG_DOWNLOAD'',23,'''||getpropertyvalue('system')||''','''||getpropertyvalue('system')||'''
       --           from (select he.headend_id, he.headend_location, he.headend_name from headend he where not exists (
        --    (SELECT 1 from V$TIMEZONE_NAMES vt where vt.TZNAME not in (''GMT+0'',''GMT-0'',''ROC'')  and vt.tzname = he.time_zone))) he';

     --vsql := 'insert into alarm_activitylog (ID,SEVERITY,COMPONENT,DESCRIPTION,CREATED_BY,UPDATED_BY) ' || vsql ;

     --CREATEOBJECT(vsql,'Creating alarms for headends that have invalid time zones ');
     
   	epgguidedatalogging('Start of Headend_Generic merge');    
    
    -- merge into headend_generic
    merge into headend_generic hg
    using stg_headend_generic hgstg
    on (hgstg.headend_id = hg.headend_id and
       	hg.asset = hgstg.asset and
    	hg.name = hgstg.name )
    when matched then
    update set 
    	hg.value = hgstg.value,
	    hg.CREATED_BY = 'SYSTEM',
    	hg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	hg.headend_id,
    	hg.asset,
    	hg.name,
    	hg.value,
 	   	hg.CREATED_BY,
    	hg.UPDATED_BY
    )
    values (    
    	hgstg.headend_id,
    	hgstg.asset,
    	hgstg.name,
    	hgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );

    -- InsertHeadendEntityMapping('HEADEND_GENERIC','String','Asset','Name');
    
    commit;

     update headend set time_zone = 'UTC' where headend_id in (select he.headend_id from headend he where not exists (
            (SELECT 1 from V$TIMEZONE_NAMES vt where vt.TZNAME not in ('GMT+0','GMT-0','ROC')  and vt.tzname = he.time_zone)));

    commit;

     /* Station */
     epgguidedatalogging('Start of Merge Station');

    vsql := 'merge into station sprod
    using stg_station sstg
    on (sstg.station_id = sprod.station_id)
    when matched then
    update set
    sprod.station_name = sstg.station_name,
    sprod.time_zone = sstg.time_zone,
    sprod.call_sign = sstg.call_sign,
    sprod.city = sstg.city,
    sprod.state = sstg.state,
    sprod.zipcode = sstg.zipcode,
    sprod.country = sstg.country,
    sprod.dma_name = sstg.dma_name,
    sprod.dma_number = sstg.dma_number,
    sprod.fcc_channel_num = sstg.fcc_channel_num,
    sprod.affiliation = sstg.affiliation ,
    sprod.USER_DATA1 = sstg.USER_DATA1,
    sprod.USER_DATA2 = sstg.USER_DATA2,
    sprod.USER_DATA3 = sstg.USER_DATA3,
    sprod.USER_DATA4 = sstg.USER_DATA4,
    sprod.USER_DATA5 = sstg.USER_DATA5,
    sprod.USER_DATA6 = sstg.USER_DATA6,
    sprod.USER_DATA7 = sstg.USER_DATA7,
    sprod.USER_DATA8 = sstg.USER_DATA8,
    sprod.USER_DATA9 = sstg.USER_DATA9,
    sprod.USER_DATA10 = sstg.USER_DATA10,
    sprod.created_by = ''SYSTEM'', sprod.updated_by = ''SYSTEM''
    when not matched then
    insert (sprod.station_id,sprod.station_name, sprod.time_zone, sprod.call_sign, sprod.city, sprod.state, sprod.zipcode, sprod.country, sprod.dma_name, sprod.dma_number, sprod.fcc_channel_num, sprod.affiliation,
     sprod.USER_DATA1,
     sprod.USER_DATA2,
     sprod.USER_DATA3,
     sprod.USER_DATA4,
     sprod.USER_DATA5,
     sprod.USER_DATA6,
     sprod.USER_DATA7,
     sprod.USER_DATA8,
     sprod.USER_DATA9,
     sprod.USER_DATA10,
     sprod.created_by, sprod.updated_by)
    values (sstg.station_id,sstg.station_name, sstg.time_zone, sstg.call_sign, sstg.city, sstg.state,sstg.zipcode,sstg.country, sstg.dma_name, sstg.dma_number, sstg.fcc_channel_num,sstg.affiliation,
     sstg.USER_DATA1,
     sstg.USER_DATA2,
     sstg.USER_DATA3,
     sstg.USER_DATA4,
     sstg.USER_DATA5,
     sstg.USER_DATA6,
     sstg.USER_DATA7,
     sstg.USER_DATA8,
     sstg.USER_DATA9,
     sstg.USER_DATA10,
    ''SYSTEM'', ''SYSTEM'')
    log errors into err$_station reject limit unlimited';
    CREATEOBJECT(vsql,'MERGE INTO STATION');

    commit;
    
    epgguidedatalogging('Start of Station_Generic merge');    
    
    -- merge into Station_generic
    merge into station_generic sg
    using stg_station_generic sgstg
    on (sgstg.station_id = sg.station_id and
       	sg.asset = sgstg.asset and
    	sg.name = sgstg.name )
    when matched then
    update set 
    	sg.value = sgstg.value,
	    sg.CREATED_BY = 'SYSTEM',
    	sg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	sg.station_id,
    	sg.asset,
    	sg.name,
    	sg.value,
 	   	sg.CREATED_BY,
    	sg.UPDATED_BY
    )
    values (    
    	sgstg.station_id,
    	sgstg.asset,
    	sgstg.name,
    	sgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );

    -- InsertStationEntityMapping('STATION_GENERIC','String','Asset','Name');


/* Lineup */
     epgguidedatalogging('Start of Merge Lineup');

    vsql := 'merge into lineup lprod
    using stg_lineup lstg
    on (lstg.lineup_id = lprod.lineup_id and lprod.headend_id = lstg.headend_id and lprod.station_id = lstg.station_id)
    when matched then
    update set lprod.device = lstg.device, lprod.tms_channel = lstg.tms_channel, lprod.service_tier = lstg.service_tier, lprod.effective_date = lstg.effective_date, lprod.expiration_date = lstg.expiration_date , lprod.created_by = ''SYSTEM'' , lprod.updated_by = ''SYSTEM''
    when not matched then
    insert (lprod.lineup_id,lprod.device, lprod.tms_channel, lprod.service_tier, lprod.effective_date, lprod.expiration_date, lprod.headend_id, lprod.station_id, lprod.created_by, lprod.updated_by)
    values (lstg.lineup_id,lstg.device, lstg.tms_channel, lstg.service_tier, lstg.effective_date, lstg.expiration_date, lstg.headend_id, lstg.station_id, ''SYSTEM'', ''SYSTEM'')
    log errors into err$_lineup reject limit unlimited';
    CREATEOBJECT(vsql,'MERGE INTO LINEUP');

    commit;
    
    epgguidedatalogging('Start of Lineup_Generic merge');    
    
     -- merge into Lineup_generic
    merge into lineup_generic lg
    using stg_lineup_generic lgstg
    on (lgstg.lineup_id = lg.lineup_id and
    	lgstg.headend_id = lg.headend_id and
    	lgstg.station_id = lg.station_id and
       	lg.asset = lgstg.asset and
    	lg.name = lgstg.name )
    when matched then
    update set 
    	lg.value = lgstg.value,
	    lg.CREATED_BY = 'SYSTEM',
    	lg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	lg.lineup_id,
    	lg.headend_id,
    	lg.station_id,
    	lg.asset,
    	lg.name,
    	lg.value,
 	   	lg.CREATED_BY,
    	lg.UPDATED_BY
    )
    values (    
    	lgstg.lineup_id,
    	lgstg.headend_id,
    	lgstg.station_id,
    	lgstg.asset,
    	lgstg.name,
    	lgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
   
    
    -- this one might not be possible...
    -- InsertLineupEntityMapping('LINEUP_GENERIC','String','Asset','Name');
    
    
     /*Program */
     epgguidedatalogging('Start of Program merge');

    merge into program pprod
    using stg_program pstg
    on (pstg.program_id = pprod.program_id)
    when matched then
    update set pprod.LANGUAGE = pstg.language,
    pprod.TITLE = pstg.title,
    pprod.REDUCED_TITLE1 = pstg.REDUCED_TITLE1 ,
    pprod.REDUCED_TITLE2 = pstg.REDUCED_TITLE2,
    pprod.REDUCED_TITLE3 = pstg.REDUCED_TITLE3,
    pprod.REDUCED_TITLE4 = pstg.REDUCED_TITLE4,
    pprod.ALT_TITLE = pstg.ALT_TITLE,
    pprod.REDUCED_DESCRIPTION1 = pstg.REDUCED_DESCRIPTION1,
    pprod.REDUCED_DESCRIPTION2 = pstg.REDUCED_DESCRIPTION2,
    pprod.REDUCED_DESCRIPTION3 = pstg.REDUCED_DESCRIPTION3,
    pprod.REDUCED_DESCRIPTION4 = pstg.REDUCED_DESCRIPTION4,
    pprod.ADVISORY_DESC1 = pstg.ADVISORY_DESC1,
    pprod.ADVISORY_DESC2 = pstg.ADVISORY_DESC2,
    pprod.ADVISORY_DESC3 = pstg.ADVISORY_DESC3,
    pprod.ADVISORY_DESC4 = pstg.ADVISORY_DESC4,
    pprod.ADVISORY_DESC5 = pstg.ADVISORY_DESC5,
    pprod.ADVISORY_DESC6 = pstg.ADVISORY_DESC6,
    pprod.GENRE_DESC1 = pstg. GENRE_DESC1,
    pprod.GENRE_DESC2 = pstg. GENRE_DESC2,
    pprod.GENRE_DESC3 = pstg. GENRE_DESC3,
    pprod.GENRE_DESC4 = pstg. GENRE_DESC4,
    pprod.GENRE_DESC5 = pstg. GENRE_DESC5,
    pprod.GENRE_DESC6 = pstg. GENRE_DESC6,
    pprod.DESCRIPTION1 = pstg.DESCRIPTION1,
    pprod.DESCRIPTION2 = pstg.DESCRIPTION2,
    pprod.YEAR_PROGRAM = pstg.YEAR_PROGRAM,
    pprod.MPAA_RATING = pstg.MPAA_RATING,
    pprod.STAR_RATING = pstg.STAR_RATING,
    pprod.RUN_TIME = pstg.RUN_TIME,
    pprod.COLOR_CODE = pstg.COLOR_CODE,
    pprod.PROGRAM_LANGUAGE = pstg.PROGRAM_LANGUAGE,
    pprod.COUNTRY_OF_ORIGIN = pstg.COUNTRY_OF_ORIGIN,
    pprod.MADE_FOR_TV = pstg.MADE_FOR_TV,
    pprod.SOURCE_TYPE = pstg.SOURCE_TYPE,
    pprod.SHOW_TYPE = pstg.SHOW_TYPE,
    pprod.HOLIDAY = pstg.HOLIDAY,
    pprod.SYNDICATE_EPISODE_NUM = pstg.SYNDICATE_EPISODE_NUM,
    pprod.ALT_SYNDICATE_EPI_NUM = pstg.ALT_SYNDICATE_EPI_NUM,
    pprod.EPISODE_TITLE = pstg.EPISODE_TITLE,
    pprod.NET_SYN_SOURCE = pstg.NET_SYN_SOURCE,
    pprod.NET_SYN_TYPE = pstg.NET_SYN_TYPE,
    pprod.ORG_STUDIO = pstg.ORG_STUDIO,
    pprod.GAME_DATETIME = pstg.GAME_DATETIME,
    pprod.GAME_TIMEZONE = pstg.GAME_TIMEZONE,
    pprod.ORG_AIR_DATE = pstg.ORG_AIR_DATE,
    pprod.UNIQUE_ID = pstg.UNIQUE_ID,
    pprod.USER_DATA1 = pstg.user_data1,
    pprod.USER_DATA2 = pstg.user_data2,
    pprod.USER_DATA3 = pstg.user_data3,
    pprod.USER_DATA4 = pstg.user_data4,
    pprod.USER_DATA5 = pstg.user_data5,
    pprod.USER_DATA6 = pstg.user_data6,
    pprod.USER_DATA7 = pstg.user_data7,
    pprod.USER_DATA8 = pstg.user_data8,
    pprod.USER_DATA9 = pstg.user_data9,
    pprod.USER_DATA10 = pstg.user_data10,
    pprod.USER_DATA11 = pstg.user_data11,
    pprod.USER_DATA12 = pstg.user_data12,
    pprod.USER_DATA13 = pstg.user_data13,
    pprod.CREATED_BY = 'SYSTEM',
    pprod.UPDATED_BY = 'SYSTEM'
    when not matched then
    insert (pprod.PROGRAM_ID,
    pprod.LANGUAGE,
    pprod.TITLE,
    pprod.REDUCED_TITLE1,
    pprod.REDUCED_TITLE2,
    pprod.REDUCED_TITLE3,
    pprod.REDUCED_TITLE4,
    pprod.ALT_TITLE,
    pprod.REDUCED_DESCRIPTION1,
    pprod.REDUCED_DESCRIPTION2,
    pprod.REDUCED_DESCRIPTION3,
    pprod.REDUCED_DESCRIPTION4,
    pprod.ADVISORY_DESC1,
    pprod.ADVISORY_DESC2,
    pprod.ADVISORY_DESC3,
    pprod.ADVISORY_DESC4,
    pprod.ADVISORY_DESC5,
    pprod.ADVISORY_DESC6,
    pprod.GENRE_DESC1,
    pprod.GENRE_DESC2,
    pprod.GENRE_DESC3,
    pprod.GENRE_DESC4,
    pprod.GENRE_DESC5,
    pprod.GENRE_DESC6,
    pprod.DESCRIPTION1,
    pprod.DESCRIPTION2,
    pprod.YEAR_PROGRAM,
    pprod.MPAA_RATING,
    pprod.STAR_RATING,
    pprod.RUN_TIME,
    pprod.COLOR_CODE,
    pprod.PROGRAM_LANGUAGE,
    pprod.COUNTRY_OF_ORIGIN,
    pprod.MADE_FOR_TV,
    pprod.SOURCE_TYPE,
    pprod.SHOW_TYPE,
    pprod.HOLIDAY,
    pprod.SYNDICATE_EPISODE_NUM,
    pprod.ALT_SYNDICATE_EPI_NUM,
    pprod.EPISODE_TITLE,
    pprod.NET_SYN_SOURCE,
    pprod.NET_SYN_TYPE,
    pprod.ORG_STUDIO,
    pprod.GAME_DATETIME,
    pprod.GAME_TIMEZONE,
    pprod.ORG_AIR_DATE,
    pprod.UNIQUE_ID,
    pprod.USER_DATA1,
    pprod.USER_DATA2,
    pprod.USER_DATA3,
    pprod.USER_DATA4,
    pprod.USER_DATA5,
    pprod.USER_DATA6,
    pprod.USER_DATA7,
    pprod.USER_DATA8,
    pprod.USER_DATA9,
    pprod.USER_DATA10,
    pprod.USER_DATA11,
    pprod.USER_DATA12,
    pprod.USER_DATA13,
    pprod.CREATED_BY,
    pprod.UPDATED_BY)
    values (pstg.program_id,
    pstg.LANGUAGE,
    pstg.TITLE,
    pstg.REDUCED_TITLE1,
    pstg.REDUCED_TITLE2,
    pstg.REDUCED_TITLE3,
    pstg.REDUCED_TITLE4,
    pstg.ALT_TITLE,
    pstg.REDUCED_DESCRIPTION1,
    pstg.REDUCED_DESCRIPTION2,
    pstg.REDUCED_DESCRIPTION3,
    pstg.REDUCED_DESCRIPTION4,
    pstg.ADVISORY_DESC1,
    pstg.ADVISORY_DESC2,
    pstg.ADVISORY_DESC3,
    pstg.ADVISORY_DESC4,
    pstg.ADVISORY_DESC5,
    pstg.ADVISORY_DESC6,
    pstg.GENRE_DESC1,
    pstg.GENRE_DESC2,
    pstg.GENRE_DESC3,
    pstg.GENRE_DESC4,
    pstg.GENRE_DESC5,
    pstg.GENRE_DESC6,
    pstg.DESCRIPTION1,
    pstg.DESCRIPTION2,
    pstg.YEAR_PROGRAM,
    pstg.MPAA_RATING,
    pstg.STAR_RATING,
    pstg.RUN_TIME,
    pstg.COLOR_CODE,
    pstg.PROGRAM_LANGUAGE,
    pstg.COUNTRY_OF_ORIGIN,
    pstg.MADE_FOR_TV,
    pstg.SOURCE_TYPE,
    pstg.SHOW_TYPE,
    pstg.HOLIDAY,
    pstg.SYNDICATE_EPISODE_NUM,
    pstg.ALT_SYNDICATE_EPI_NUM,
    pstg.EPISODE_TITLE,
    pstg.NET_SYN_SOURCE,
    pstg.NET_SYN_TYPE,
    pstg.ORG_STUDIO,
    pstg.GAME_DATETIME,
    pstg.GAME_TIMEZONE,
    pstg.ORG_AIR_DATE,
    pstg.UNIQUE_ID,
    pstg.USER_DATA1,
    pstg.USER_DATA2,
    pstg.USER_DATA3,
    pstg.USER_DATA4,
    pstg.USER_DATA5,
    pstg.USER_DATA6,
    pstg.USER_DATA7,
    pstg.USER_DATA8,
    pstg.USER_DATA9,
    pstg.USER_DATA10,
    pstg.USER_DATA11,
    pstg.USER_DATA12,
    pstg.USER_DATA13,
    'SYSTEM',
    'SYSTEM');


 	epgguidedatalogging('Start of Program_rating merge');    
    
    -- merge into program_rating
    merge into program_rating pr
    using stg_program_rating prstg
    on (prstg.program_id = pr.program_id and prstg.authority = pr.authority)
    when matched then
    update set 
    	pr.value = prstg.value,
	    pr.CREATED_BY = 'SYSTEM',
    	pr.UPDATED_BY = 'SYSTEM'
    
    when not matched then
    insert (
    	pr.program_id,
    	pr.authority,
    	pr.value,
 	   	pr.CREATED_BY,
    	pr.UPDATED_BY
    )
    values (
    	prstg.program_id,
    	prstg.authority,
    	prstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertProgramEntityMapping('PROGRAM_RATING','String','Authority');
  
  	epgguidedatalogging('Start of Program_Audio_Comp merge');    
    
    -- merge into program_audio_comp
    merge into program_audio_comp pac
    using stg_program_audio_comp pacstg
    on (pacstg.program_id = pac.program_id and
     	pac.tla = pacstg.tla )
    when matched then
    update set 
    	pac.value = pacstg.value,
	    pac.CREATED_BY = 'SYSTEM',
    	pac.UPDATED_BY = 'SYSTEM'
    when not matched then
    insert (
    	pac.program_id,
    	pac.tla,
    	pac.type,
    	pac.language,
    	pac.attribute_type,
    	pac.value,
 	   	pac.CREATED_BY,
    	pac.UPDATED_BY
    )
    values (
    	pacstg.program_id,
    	pacstg.type||' '||pacstg.language||' '||pacstg.attribute_type,
    	pacstg.type,
    	pacstg.language,
    	pacstg.attribute_type,
    	pacstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertProgramEntityMapping('PROGRAM_AUDIO_COMP','String','TLA');

    epgguidedatalogging('Start of Program_Subtitle_Comp merge');    
    
    -- merge into program_subtitle_comp
    merge into program_subtitle_comp psc
    using stg_program_subtitle_comp pscstg
    on (pscstg.program_id = psc.program_id and 
       	psc.tla = pscstg.tla )
    when matched then
    update set 
    	psc.value = pscstg.value,
	    psc.CREATED_BY = 'SYSTEM',
    	psc.UPDATED_BY = 'SYSTEM'
    
    when not matched then
    insert (
    	psc.program_id,
    	psc.tla,
    	psc.type,
    	psc.language,
    	psc.attribute_type,
    	psc.value,
 	   	psc.CREATED_BY,
    	psc.UPDATED_BY
    )
    values (
    	pscstg.program_id,
    	pscstg.type||' '||pscstg.language||' '||pscstg.attribute_type,
    	pscstg.type,
    	pscstg.language,
    	pscstg.attribute_type,
    	pscstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    -- InsertProgramEntityMapping('PROGRAM_SUBTITLE_COMP','String','TLA');


    
IF (IS_TABLE_EXISTS('STG_PROGRAM_CAST') AND IS_TABLE_EXISTS('PROGRAM_CAST')) THEN
       epgguidedatalogging('Start of Program_Cast merge'); 
       
       -- merge into program_cast
       merge into program_cast pc
       using stg_program_cast pcstg
       on (pcstg.program_id = pc.program_id and 
       pcstg.seq = pc.seq and
       pcstg.role = pc.role)
       when matched then
       update set 
       	pc.c_id = pcstg.c_id,
       	pc.first_name = pcstg.first_name,
       	pc.middle_name = pcstg.middle_name,
       	pc.last_name = pcstg.last_name,
        pc.CREATED_BY = 'SYSTEM',
       	pc.UPDATED_BY = 'SYSTEM'    
       when not matched then
       insert (
       	pc.program_id,
       	pc.c_id,
       	pc.seq,
       	pc.role,
       	pc.first_name,
       	pc.middle_name,
       	pc.last_name,
        pc.CREATED_BY,
       	pc.UPDATED_BY
       )
       values (    
       	pcstg.program_id,
       	pcstg.c_id,
       	pcstg.seq,
       	pcstg.role,
       	pcstg.first_name,
       	pcstg.middle_name,
       	pcstg.last_name,
        'SYSTEM',
       	'SYSTEM'
       );
END IF;

 -- InsertProgramEntityMapping('PROGRAM_CAST','String','ROLE');
 IF (IS_TABLE_EXISTS('STG_PROGRAM_CREDITS') AND IS_TABLE_EXISTS('PROGRAM_CREDITS')) THEN
       epgguidedatalogging('Start of Program_Credits merge');    
       
       -- merge into program_credits
       merge into program_credits pc
       using stg_program_credits pcstg
       on (pcstg.program_id = pc.program_id and 
       pcstg.seq = pc.seq and
       pcstg.role = pc.role)
       when matched then
       update set 
       	pc.c_id = pcstg.c_id,
       	pc.first_name = pcstg.first_name,
       	pc.middle_name = pcstg.middle_name,
       	pc.last_name = pcstg.last_name,
        pc.CREATED_BY = 'SYSTEM',
       	pc.UPDATED_BY = 'SYSTEM'    
       when not matched then
       insert (
       	pc.program_id,
       	pc.c_id,
       	pc.seq,
       	pc.role,
       	pc.first_name,
       	pc.middle_name,
       	pc.last_name,
        pc.CREATED_BY,
       	pc.UPDATED_BY
       )
       values (    
       	pcstg.program_id,
       	pcstg.c_id,
       	pcstg.seq,
       	pcstg.role,
       	pcstg.first_name,
       	pcstg.middle_name,
       	pcstg.last_name,
        'SYSTEM',
       	'SYSTEM'
       );
 END IF;

    
   
  
   -- InsertProgramEntityMapping('PROGRAM_CREDITS','String','ROLE');
    
 	epgguidedatalogging('Start of Program_Generic merge');    
    
    -- merge into program_generic
    merge into program_generic pg
    using stg_program_generic pgstg
    on (pgstg.program_id = pg.program_id and
       	pg.asset = pgstg.asset and
    	pg.name = pgstg.name )
    when matched then
    update set 
    	pg.value = pgstg.value,
	    pg.CREATED_BY = 'SYSTEM',
    	pg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	pg.program_id,
    	pg.asset,
    	pg.name,
    	pg.value,
 	   	pg.CREATED_BY,
    	pg.UPDATED_BY
    )
    values (    
    	pgstg.program_id,
    	pgstg.asset,
    	pgstg.name,
    	pgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );

    -- InsertProgramEntityMapping('PROGRAM_GENERIC','String','Asset','Name');
    
    commit;
    
    --SCHEDULE MERGE
   epgguidedatalogging('Start of Schedule Merge');
    
    -- Clean temp table
    vsql := 'truncate  table temp_station_sch_range';
    CREATEOBJECT(vsql,'DROP TABLE temp_station_sch_range','Y');
    
    --Get max start time from schedule
    select nvl(max(start_time),vcurrentdatetime)
    into vmaxschedulestarttime
    from schedule;
    
    -- New time window (min start time and max end time)
   -- select greatest(min(start_time),vcurrentdatetime) as minstgschdate, greatest(max(start_time + numtodsinterval(duration,'SECOND')),vcurrentdatetime)  as maxstgschdate
    --into vminstgschdate, vmaxstgschdate
    --from stg_schedule;
    
    --Rather than above we consider the time window as-is from the incoming schedule and not necessarily starting or ending on current datetime
    select min(start_time) as minstgschdate, max(start_time + numtodsinterval(duration,'SECOND'))  as maxstgschdate
    into vminstgschdate, vmaxstgschdate
    from stg_schedule;
    
    -- Get the time ranges for all the stations that need to be changed (stations in stg_stations)
    -- there can be some stations who dont have a schedule. Include those too
    insert into temp_station_sch_range(station_id, first_schedule_start_time, last_schedule_end_time)
          select sst.station_id,  min(start_time) as minstgschdate, max(start_time + numtodsinterval(duration,'SECOND'))  as maxstgschdate
          from stg_schedule ssch right join stg_station sst on (sst.station_id = ssch.station_id)
    group by sst.station_id;
    
    -- Delete from schedule all entries whose programs start on or after the current schedule start time and before current end time
    -- and which are not mentioned in the new schedule entries
    -- but whose station are mentioned in the new station entries 
    -- In short remove entries whose stations have now disappeared from the new schedule but whose stations are mentioned in the new staions.    
    
    delete from schedule s
           where
           s.start_time >= vminstgschdate
           and s.start_time < vmaxstgschdate
           and not exists (select 1 from stg_schedule stg
                           where stg.start_time = s.start_time and
                           stg.station_id = s.station_id and
                           stg.program_id = s.program_id
                          )
          and exists (select 1 from stg_station sst join temp_station_sch_range tssr on (sst.station_id = tssr.station_id)
                       where sst.station_id = s.station_id  and s.start_time >= nvl(tssr.first_schedule_start_time,vminstgschdate)
                       and s.start_time <  nvl(tssr.last_schedule_end_time,vmaxstgschdate)
                    );
    
     -- dont understand the where clause above...s.start_time >= nvl(... tssr.firsr_schedile_start_time will always be null due to the right join above and the not exist in this SQL
    
    -- dont need temp_schedule-conflict
    
             --Merge the schedule records
          merge into schedule sprod
          using (select * from stg_schedule /* where start_time > nvl(vcurrentdatetime,current_timestamp )*/) sstg
          on (sstg.program_id = sprod.program_id and sstg.station_id = sprod.station_id and sstg.start_time = sprod.start_time)
          when matched then
          update set sprod.schedule_language = sstg.schedule_language,
          sprod.end_time = sstg.end_time,
          sprod.duration = sstg.duration,
          sprod.tv_rating = sstg.tv_rating,
          sprod.hd_tv = sstg.hd_tv,
          sprod.part_number = sstg.part_number,
          sprod.no_of_parts = sstg.no_of_parts,
          sprod.cc = sstg.cc,
          sprod.stereo = sstg.stereo,
          sprod.live_tape_delay = sstg.live_tape_delay,
          sprod.subtitled = sstg.subtitled,
          sprod.premiere_finale = sstg.premiere_finale,
          sprod.joined_in_progress = sstg.joined_in_progress,
          sprod.cable_in_classroom = sstg.cable_in_classroom,
          sprod.sap = sstg.sap,
          sprod.sex_rating = sstg.sex_rating,
          sprod.violence_rating = sstg.violence_rating,
          sprod.language_rating = sstg.language_rating,
          sprod.dialog_rating = sstg.dialog_rating,
          sprod.fv_rating = sstg.fv_rating,
          sprod.enhanced = sstg.enhanced,
          sprod.three_d = sstg.three_d,
          sprod.letterbox = sstg.letterbox,
          sprod.dvs = sstg.dvs,
          sprod.series_id = sstg.series_id,
          sprod.request_record = sstg.request_record,
          sprod.repeat = sstg.repeat,
          sprod.blackout = sstg.blackout,
          sprod.dolby = sstg.dolby,
          sprod.USER_DATA1 = sstg.user_data1,
          sprod.USER_DATA2 = sstg.user_data2,
          sprod.USER_DATA3 = sstg.user_data3,
          sprod.USER_DATA4 = sstg.user_data4,
          sprod.USER_DATA5 = sstg.user_data5,
          sprod.USER_DATA6 = sstg.user_data6,
          sprod.USER_DATA7 = sstg.user_data7,
          sprod.USER_DATA8 = sstg.user_data8,
          sprod.USER_DATA9 = sstg.user_data9,
          sprod.USER_DATA10 = sstg.user_data10,
          sprod.USER_DATA11 = sstg.user_data11,
          sprod.created_by = 'SYSTEM',
          sprod.updated_by = 'SYSTEM'
          when not matched then
          insert (sprod.schedule_id,
          sprod.SCHEDULE_LANGUAGE,
          sprod.STATION_ID,
          sprod.PROGRAM_ID,
          sprod.START_TIME,
          sprod.END_TIME,
          sprod.DURATION,
          sprod.TV_RATING,
          sprod.HD_TV,
          sprod.PART_NUMBER,
          sprod.NO_OF_PARTS,
          sprod.CC,
          sprod.STEREO,
          sprod.LIVE_TAPE_DELAY,
          sprod.SUBTITLED,
          sprod.PREMIERE_FINALE,
          sprod.JOINED_IN_PROGRESS,
          sprod.CABLE_IN_CLASSROOM,
          sprod.SAP,
          sprod.SEX_RATING,
          sprod.VIOLENCE_RATING,
          sprod.LANGUAGE_RATING,
          sprod.DIALOG_RATING,
          sprod.FV_RATING,
          sprod.ENHANCED,
          sprod.THREE_D,
          sprod.LETTERBOX,
          sprod.DVS,
          sprod.series_id,
          sprod.REQUEST_RECORD,
          sprod.REPEAT,
          sprod.BLACKOUT,
          sprod.DOLBY,
          sprod.USER_DATA1,
          sprod.USER_DATA2,
          sprod.USER_DATA3,
          sprod.USER_DATA4,
          sprod.USER_DATA5,
          sprod.USER_DATA6,
          sprod.USER_DATA7,
          sprod.USER_DATA8,
          sprod.USER_DATA9,
          sprod.USER_DATA10,
          sprod.USER_DATA11,
          sprod.CREATED_BY,
          sprod.UPDATED_BY)
          values (SCHEDULE_SEQ.nextval,
          sstg.SCHEDULE_LANGUAGE,
          sstg.STATION_ID,
          sstg.PROGRAM_ID,
          sstg.start_time,
          sstg.end_time,
          sstg.DURATION,
          sstg.TV_RATING,
          sstg.HD_TV,
          sstg.PART_NUMBER,
          sstg.NO_OF_PARTS,
          sstg.CC,
          sstg.STEREO,
          sstg.LIVE_TAPE_DELAY,
          sstg.SUBTITLED,
          sstg.PREMIERE_FINALE,
          sstg.JOINED_IN_PROGRESS,
          sstg.CABLE_IN_CLASSROOM,
          sstg.SAP,
          sstg.SEX_RATING,
          sstg.VIOLENCE_RATING,
          sstg.LANGUAGE_RATING,
          sstg.DIALOG_RATING,
          sstg.FV_RATING,
          sstg.ENHANCED,
          sstg.THREE_D,
          sstg.LETTERBOX,
          sstg.DVS,
          sstg.series_id,
          sstg.REQUEST_RECORD,
          sstg.REPEAT,
          sstg.BLACKOUT,
          sstg.DOLBY,
          sstg.USER_DATA1,
          sstg.USER_DATA2,
          sstg.USER_DATA3,
          sstg.USER_DATA4,
          sstg.USER_DATA5,
          sstg.USER_DATA6,
          sstg.USER_DATA7,
          sstg.USER_DATA8,
          sstg.USER_DATA9,
          sstg.USER_DATA10,
          sstg.USER_DATA11,
          'SYSTEM',
          'SYSTEM');
          
	epgguidedatalogging('Start of Schedule_Event_Id merge');    
    
    -- merge into schedule_event_id
    merge into schedule_event_id sei
    using stg_schedule_event_id seistg
    on (seistg.program_id = sei.program_id and
        	sei.identifier_type = seistg.identifier_type )
    when matched then
    update set 
    	sei.value = seistg.value,
	    sei.CREATED_BY = 'SYSTEM',
    	sei.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	sei.program_id,
    	sei.identifier_type,
    	sei.value,
 	   	sei.CREATED_BY,
    	sei.UPDATED_BY
    )
    values (    
    	seistg.program_id,
    	seistg.identifier_type,
    	seistg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertScheduleEntityMapping('SCHEDULE_EVENT_ID','String','IDENTIFIER_TYPE');
          
	epgguidedatalogging('Start of Schedule_Series_Attrib merge');    
    
    -- merge into schedule_series_attrib
    merge into schedule_series_attrib ssa
    using stg_schedule_series_attrib ssastg
    on (ssastg.program_id = ssa.program_id and 
        	ssa.attribute_type = ssastg.attribute_type)
    when matched then
    update set 
    	ssa.value = ssastg.value,
	    ssa.CREATED_BY = 'SYSTEM',
    	ssa.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	ssa.program_id,
    	ssa.attribute_type,
    	ssa.value,
 	   	ssa.CREATED_BY,
    	ssa.UPDATED_BY
    )
    values (    
    	ssastg.program_id,
    	ssastg.attribute_type,
    	ssastg.value,
	    'SYSTEM',
    	'SYSTEM'
    );          
    -- InsertScheduleEntityMapping('SCHEDULE_SERIES_ATTRIB','String','ATTRIBUTE_TYPE');

 	epgguidedatalogging('Start of Schedule_Generic merge');    
    
    -- merge into schedule_generic
    merge into schedule_generic sg
    using stg_schedule_generic sgstg
    on (sgstg.program_id = sg.program_id and
   		sg.asset = sgstg.asset and
    	sg.name = sgstg.name)
    when matched then
    update set 
    	sg.value = sgstg.value,
	    sg.CREATED_BY = 'SYSTEM',
    	sg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	sg.program_id,
    	sg.asset,
    	sg.name,
    	sg.value,
 	   	sg.CREATED_BY,
    	sg.UPDATED_BY
    )
    values (    
    	sgstg.program_id,
    	sgstg.asset,
    	sgstg.name,
    	sgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertScheduleEntityMapping('SCHEDULE_GENERIC','String','ASSET','NAME');
    
    commit;
    
 end mergetstvWithEmpty;
 
 procedure mergetstvWithoutEmpty(providerName nvarchar2 ) is
     vsql varchar2(32767);
     vmaxschedulestarttime schedule.start_time%type;
    vminstgschdate timestamp(0) with time zone;
    vmaxstgschdate timestamp(0) with time zone;

 begin
	     /* Headend Merge */
    epgguidedatalogging('Start of Merge Headend');
    
    vsql := 'merge into headend hprod
    using stg_headend hstg 
    on (hstg.headend_id = hprod.headend_id)
    when matched then
    update set 
		hprod.community_name = NVL2(hstg.community_name, hstg.community_name, hprod.community_name),
		hprod.county_name = NVL2(hstg.county_name,hstg.county_name, hprod.county_name),
		hprod.county_size = NVL2(hstg.county_size, hstg.county_size,hprod.county_size),
		hprod.st_county_code = NVL2(hstg.st_county_code, hstg.st_county_code,hprod.st_county_code),
		hprod.state = NVL2(hstg.state , hstg.state ,hprod.state),
		hprod.zipcode = NVL2(hstg.zipcode, hstg.zipcode,hprod.zipcode),
		hprod.dma_code = NVL2(hstg.dma_code, hstg.dma_code,hprod.dma_code),
		hprod.dma_name = NVL2(hstg.dma_name , hstg.dma_name ,hprod.dma_name),
		hprod.mso_code = NVL2(hstg.mso_code, hstg.mso_code, hprod.mso_code),
		hprod.dma_rank = NVL2(hstg.dma_rank , hstg.dma_rank ,hprod.dma_rank),
		hprod.headend_name = NVL2(hstg.headend_name , hstg.headend_name ,hprod.headend_name),
		hprod.headend_location = NVL2(hstg.headend_location, hstg.headend_location,hprod.headend_location),
		hprod.mso_name = NVL2(hstg.mso_name,hstg.mso_name, hprod.mso_name),
		hprod.time_zone = NVL2(hstg.time_zone, hstg.time_zone,hprod.time_zone),
		hprod.created_by = ''SYSTEM'', 
		hprod.updated_by = ''SYSTEM''
    when not matched then
    insert (hprod.headend_id,hprod.community_name, hprod.county_name, hprod.county_size, hprod.st_county_code, hprod.state, hprod.zipcode, hprod.dma_code, hprod.dma_name, hprod.mso_code, hprod.dma_rank, hprod.headend_name, hprod.headend_location, hprod.mso_name, hprod.time_zone, hprod.created_by,hprod.updated_by)
    values (hstg.headend_id,hstg.community_name, hstg.county_name, hstg.county_size, hstg.st_county_code, hstg.state, hstg.zipcode, hstg.dma_code, hstg.dma_name, hstg.mso_code, hstg.dma_rank, hstg.headend_name, hstg.headend_location, hstg.mso_name, hstg.time_zone,''SYSTEM'',''SYSTEM'')';
 
    CREATEOBJECT(vsql,'MERGE INTO HEADEND');
    
    update headend set time_zone = 'UTC' where headend_id in (select he.headend_id from headend he where not exists (
          (SELECT 1 from V$TIMEZONE_NAMES vt where vt.TZNAME not in ('GMT+0','GMT-0','ROC')  and vt.tzname = he.time_zone)));

    commit;
    
  	epgguidedatalogging('Start of Headend_Generic merge');    
    
    -- merge into headend_generic
    merge into headend_generic hg
    using stg_headend_generic hgstg
    on (hgstg.headend_id = hg.headend_id and
       	hg.asset = hgstg.asset and
    	hg.name = hgstg.name )
    when matched then
    update set 
    	hg.value = NVL2(hgstg.value, hgstg.value, hg.value),
	    hg.CREATED_BY = 'SYSTEM',
    	hg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	hg.headend_id,
    	hg.asset,
    	hg.name,
    	hg.value,
 	   	hg.CREATED_BY,
    	hg.UPDATED_BY
    )
    values (    
    	hgstg.headend_id,
    	hgstg.asset,
    	hgstg.name,
    	hgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );

    -- InsertHeadendEntityMapping('HEADEND_GENERIC','String','Asset','Name');


         /* Station */
     epgguidedatalogging('Start of Merge Station');

    vsql := 'merge into station sprod
    using stg_station sstg
    on (sstg.station_id = sprod.station_id)
    when matched then
    update set
    sprod.station_name = NVL2(sstg.station_name,sstg.station_name,sprod.station_name),
    sprod.time_zone = NVL2(sstg.time_zone,sstg.time_zone,sprod.time_zone),
    sprod.call_sign = NVL2(sstg.call_sign,sstg.call_sign,sprod.call_sign),
    sprod.city = NVL2(sstg.city,sstg.city,sprod.city),
    sprod.state = NVL2(sstg.state,sstg.state,sprod.state),
    sprod.zipcode = NVL2(sstg.zipcode,sstg.zipcode,sprod.zipcode),
    sprod.country = NVL2(sstg.country,sstg.country,sprod.country),
    sprod.dma_name = NVL2(sstg.dma_name,sstg.dma_name,sprod.dma_name),
    sprod.dma_number = NVL2(sstg.dma_number,sstg.dma_number,sprod.dma_number),
    sprod.fcc_channel_num = NVL2(sstg.fcc_channel_num,sstg.fcc_channel_num,sprod.fcc_channel_num),
    sprod.affiliation = NVL2(sstg.affiliation ,sstg.affiliation ,sprod.affiliation),
    sprod.USER_DATA1 = NVL2(sstg.USER_DATA1,sstg.USER_DATA1,sprod.USER_DATA1),
    sprod.USER_DATA2 = NVL2(sstg.USER_DATA2,sstg.USER_DATA2,sprod.USER_DATA2),
    sprod.USER_DATA3 = NVL2(sstg.USER_DATA3,sstg.USER_DATA3,sprod.USER_DATA3),
    sprod.USER_DATA4 = NVL2(sstg.USER_DATA4,sstg.USER_DATA4,sprod.USER_DATA4),
    sprod.USER_DATA5 = NVL2(sstg.USER_DATA5,sstg.USER_DATA5,sprod.USER_DATA5),
    sprod.USER_DATA6 = NVL2(sstg.USER_DATA6,sstg.USER_DATA6,sprod.USER_DATA6),
    sprod.USER_DATA7 = NVL2(sstg.USER_DATA7,sstg.USER_DATA7,sprod.USER_DATA7),
    sprod.USER_DATA8 = NVL2(sstg.USER_DATA8,sstg.USER_DATA8,sprod.USER_DATA8),
    sprod.USER_DATA9 = NVL2(sstg.USER_DATA9,sstg.USER_DATA9,sprod.USER_DATA9),
    sprod.USER_DATA10 = NVL2(sstg.USER_DATA10,sstg.USER_DATA10,sprod.USER_DATA10),
    sprod.created_by = ''SYSTEM'',
	sprod.updated_by = ''SYSTEM''
    when not matched then
    insert (sprod.station_id,sprod.station_name, sprod.time_zone, sprod.call_sign, sprod.city, sprod.state, sprod.zipcode, sprod.country, sprod.dma_name, sprod.dma_number, sprod.fcc_channel_num, sprod.affiliation,
     sprod.USER_DATA1,
     sprod.USER_DATA2,
     sprod.USER_DATA3,
     sprod.USER_DATA4,
     sprod.USER_DATA5,
     sprod.USER_DATA6,
     sprod.USER_DATA7,
     sprod.USER_DATA8,
     sprod.USER_DATA9,
     sprod.USER_DATA10,
     sprod.created_by, sprod.updated_by)
    values (sstg.station_id,sstg.station_name, sstg.time_zone, sstg.call_sign, sstg.city, sstg.state,sstg.zipcode,sstg.country, sstg.dma_name, sstg.dma_number, sstg.fcc_channel_num,sstg.affiliation,
     sstg.USER_DATA1,
     sstg.USER_DATA2,
     sstg.USER_DATA3,
     sstg.USER_DATA4,
     sstg.USER_DATA5,
     sstg.USER_DATA6,
     sstg.USER_DATA7,
     sstg.USER_DATA8,
     sstg.USER_DATA9,
     sstg.USER_DATA10,
    ''SYSTEM'',
	 ''SYSTEM'')
    log errors into err$_station reject limit unlimited';
    CREATEOBJECT(vsql,'MERGE INTO STATION');

    commit;
    
       epgguidedatalogging('Start of Station_Generic merge');    
    
    -- merge into Station_generic
    merge into station_generic sg
    using stg_station_generic sgstg
    on (sgstg.station_id = sg.station_id and
       	sg.asset = sgstg.asset and
    	sg.name = sgstg.name )
    when matched then
    update set 
    	sg.value = NVL2(sgstg.value, sgstg.value, sg.value),
	    sg.CREATED_BY = 'SYSTEM',
    	sg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	sg.station_id,
    	sg.asset,
    	sg.name,
    	sg.value,
 	   	sg.CREATED_BY,
    	sg.UPDATED_BY
    )
    values (    
    	sgstg.station_id,
    	sgstg.asset,
    	sgstg.name,
    	sgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );

    -- InsertStationEntityMapping('STATION_GENERIC','String','Asset','Name');



    /* Lineup */
     epgguidedatalogging('Start of Merge Lineup');

    vsql := 'merge into lineup lprod
    using stg_lineup lstg
    on (lstg.lineup_id = lprod.lineup_id and lprod.headend_id = lstg.headend_id and lprod.station_id = lstg.station_id)
    when matched then
    update set 
		lprod.device = NVL2(lstg.device, lstg.device,lprod.device),
		lprod.tms_channel = NVL2(lstg.tms_channel, lstg.tms_channel,lprod.tms_channel),
		lprod.service_tier = NVL2(lstg.service_tier, lstg.service_tier,lprod.service_tier),
		lprod.effective_date = NVL2(lstg.effective_date, lstg.effective_date, lprod.effective_date),
		lprod.expiration_date = NVL2(lstg.expiration_date , lstg.expiration_date, lprod.expiration_date),
		lprod.created_by = ''SYSTEM'' , 
		lprod.updated_by = ''SYSTEM''
    when not matched then
    insert (lprod.lineup_id,lprod.device, lprod.tms_channel, lprod.service_tier, lprod.effective_date, lprod.expiration_date, lprod.headend_id, lprod.station_id, lprod.created_by, lprod.updated_by)
    values (lstg.lineup_id,lstg.device, lstg.tms_channel, lstg.service_tier, lstg.effective_date, lstg.expiration_date, lstg.headend_id, lstg.station_id, ''SYSTEM'', ''SYSTEM'')
    log errors into err$_lineup reject limit unlimited';
    CREATEOBJECT(vsql,'MERGE INTO LINEUP');

    commit;

   epgguidedatalogging('Start of Lineup_Generic merge');    
    
     -- merge into Lineup_generic
    merge into lineup_generic lg
    using stg_lineup_generic lgstg
    on (lgstg.lineup_id = lg.lineup_id and
    	lgstg.headend_id = lg.headend_id and
    	lgstg.station_id = lg.station_id and
       	lg.asset = lgstg.asset and
    	lg.name = lgstg.name )
    when matched then
    update set 
    	lg.value = NVL2(lgstg.value,lgstg.value,lg.value),
	    lg.CREATED_BY = 'SYSTEM',
    	lg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	lg.lineup_id,
    	lg.headend_id,
    	lg.station_id,
    	lg.asset,
    	lg.name,
    	lg.value,
 	   	lg.CREATED_BY,
    	lg.UPDATED_BY
    )
    values (    
    	lgstg.lineup_id,
    	lgstg.headend_id,
    	lgstg.station_id,
    	lgstg.asset,
    	lgstg.name,
    	lgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
   
    
    -- this one might now be possible...
    -- InsertLineupEntityMapping('LINEUP_GENERIC','String','Asset','Name');    
    
    /*Program */
    epgguidedatalogging('Start of Program merge');

    merge into program pprod
    using stg_program pstg
    on (pstg.program_id = pprod.program_id)
    when matched then
    update set 
    pprod.LANGUAGE = NVL2(pstg.language,pstg.language,pprod.LANGUAGE),
    pprod.TITLE = NVL2(pstg.title,pstg.title,pprod.TITLE),
    pprod.REDUCED_TITLE1 = NVL2(pstg.REDUCED_TITLE1 ,pstg.REDUCED_TITLE1,pprod.REDUCED_TITLE1),
    pprod.REDUCED_TITLE2 = NVL2(pstg.REDUCED_TITLE2,pstg.REDUCED_TITLE2,pprod.REDUCED_TITLE2),
    pprod.REDUCED_TITLE3 = NVL2(pstg.REDUCED_TITLE3,pstg.REDUCED_TITLE3,pprod.REDUCED_TITLE3),
    pprod.REDUCED_TITLE4 = NVL2(pstg.REDUCED_TITLE4,pstg.REDUCED_TITLE4,pprod.REDUCED_TITLE4),
    pprod.ALT_TITLE = NVL2(pstg.ALT_TITLE,pstg.ALT_TITLE,pprod.ALT_TITLE),
    pprod.REDUCED_DESCRIPTION1 = NVL2(pstg.REDUCED_DESCRIPTION1,pstg.REDUCED_DESCRIPTION1,pprod.REDUCED_DESCRIPTION1),
    pprod.REDUCED_DESCRIPTION2 = NVL2(pstg.REDUCED_DESCRIPTION2,pstg.REDUCED_DESCRIPTION2,pprod.REDUCED_DESCRIPTION2),
    pprod.REDUCED_DESCRIPTION3 = NVL2(pstg.REDUCED_DESCRIPTION3,pstg.REDUCED_DESCRIPTION3,pprod.REDUCED_DESCRIPTION3),
    pprod.REDUCED_DESCRIPTION4 = NVL2(pstg.REDUCED_DESCRIPTION4,pstg.REDUCED_DESCRIPTION4,pprod.REDUCED_DESCRIPTION4),
    pprod.ADVISORY_DESC1 = NVL2(pstg.ADVISORY_DESC1,pstg.ADVISORY_DESC1,pprod.ADVISORY_DESC1),
    pprod.ADVISORY_DESC2 = NVL2(pstg.ADVISORY_DESC2,pstg.ADVISORY_DESC2,pprod.ADVISORY_DESC2),
    pprod.ADVISORY_DESC3 = NVL2(pstg.ADVISORY_DESC3,pstg.ADVISORY_DESC3,pprod.ADVISORY_DESC3),
    pprod.ADVISORY_DESC4 = NVL2(pstg.ADVISORY_DESC4,pstg.ADVISORY_DESC4,pprod.ADVISORY_DESC4),
    pprod.ADVISORY_DESC5 = NVL2(pstg.ADVISORY_DESC5,pstg.ADVISORY_DESC5,pprod.ADVISORY_DESC5),
    pprod.ADVISORY_DESC6 = NVL2(pstg.ADVISORY_DESC6,pstg.ADVISORY_DESC6,pprod.ADVISORY_DESC6),
    pprod.GENRE_DESC1 = NVL2(pstg.GENRE_DESC1,pstg.GENRE_DESC1,pprod.GENRE_DESC1),
    pprod.GENRE_DESC2 = NVL2(pstg.GENRE_DESC2,pstg.GENRE_DESC2,pprod.GENRE_DESC2),
    pprod.GENRE_DESC3 = NVL2(pstg.GENRE_DESC3,pstg.GENRE_DESC3,pprod.GENRE_DESC3),
    pprod.GENRE_DESC4 = NVL2(pstg.GENRE_DESC4,pstg.GENRE_DESC4,pprod.GENRE_DESC4),
    pprod.GENRE_DESC5 = NVL2(pstg.GENRE_DESC5,pstg.GENRE_DESC5,pprod.GENRE_DESC5),
    pprod.GENRE_DESC6 = NVL2(pstg.GENRE_DESC6,pstg.GENRE_DESC6,pprod.GENRE_DESC6),
    pprod.DESCRIPTION1 = NVL2(pstg.DESCRIPTION1,pstg.DESCRIPTION1,pprod.DESCRIPTION1),
    pprod.DESCRIPTION2 = NVL2(pstg.DESCRIPTION2,pstg.DESCRIPTION2,pprod.DESCRIPTION2),
    pprod.YEAR_PROGRAM = NVL2(pstg.YEAR_PROGRAM,pstg.YEAR_PROGRAM,pprod.YEAR_PROGRAM),
    pprod.MPAA_RATING = NVL2(pstg.MPAA_RATING,pstg.MPAA_RATING,pprod.MPAA_RATING),
    pprod.STAR_RATING = NVL2(pstg.STAR_RATING,pstg.STAR_RATING,pprod.STAR_RATING),
    pprod.RUN_TIME = NVL2(pstg.RUN_TIME,pstg.RUN_TIME,pprod.RUN_TIME),
    pprod.COLOR_CODE = NVL2(pstg.COLOR_CODE,pstg.COLOR_CODE,pprod.COLOR_CODE),
    pprod.PROGRAM_LANGUAGE = NVL2(pstg.PROGRAM_LANGUAGE,pstg.PROGRAM_LANGUAGE,pprod.PROGRAM_LANGUAGE),
    pprod.COUNTRY_OF_ORIGIN = NVL2(pstg.COUNTRY_OF_ORIGIN,pstg.COUNTRY_OF_ORIGIN,pprod.COUNTRY_OF_ORIGIN),
    pprod.MADE_FOR_TV = NVL2(pstg.MADE_FOR_TV,pstg.MADE_FOR_TV,pprod.MADE_FOR_TV),
    pprod.SOURCE_TYPE = NVL2(pstg.SOURCE_TYPE,pstg.SOURCE_TYPE,pprod.SOURCE_TYPE),
    pprod.SHOW_TYPE = NVL2(pstg.SHOW_TYPE,pstg.SHOW_TYPE,pprod.SHOW_TYPE),
    pprod.HOLIDAY = NVL2(pstg.HOLIDAY,pstg.HOLIDAY,pprod.HOLIDAY),
    pprod.SYNDICATE_EPISODE_NUM = NVL2(pstg.SYNDICATE_EPISODE_NUM,pstg.SYNDICATE_EPISODE_NUM,pprod.SYNDICATE_EPISODE_NUM),
    pprod.ALT_SYNDICATE_EPI_NUM = NVL2(pstg.ALT_SYNDICATE_EPI_NUM,pstg.ALT_SYNDICATE_EPI_NUM,pprod.ALT_SYNDICATE_EPI_NUM),
    pprod.EPISODE_TITLE = NVL2(pstg.EPISODE_TITLE,pstg.EPISODE_TITLE,pprod.EPISODE_TITLE),
    pprod.NET_SYN_SOURCE = NVL2(pstg.NET_SYN_SOURCE,pstg.NET_SYN_SOURCE,pprod.NET_SYN_SOURCE),
    pprod.NET_SYN_TYPE = NVL2(pstg.NET_SYN_TYPE,pstg.NET_SYN_TYPE,pprod.NET_SYN_TYPE),
    pprod.ORG_STUDIO = NVL2(pstg.ORG_STUDIO,pstg.ORG_STUDIO,pprod.ORG_STUDIO),
    pprod.GAME_DATETIME = NVL2(pstg.GAME_DATETIME, pstg.GAME_DATETIME, pprod.GAME_DATETIME),
    pprod.GAME_TIMEZONE = NVL2(pstg.GAME_TIMEZONE,pstg.GAME_TIMEZONE,pprod.GAME_TIMEZONE),
    pprod.ORG_AIR_DATE = NVL2(pstg.ORG_AIR_DATE, pstg.ORG_AIR_DATE, pprod.ORG_AIR_DATE),
    pprod.UNIQUE_ID = NVL2(pstg.UNIQUE_ID,pstg.UNIQUE_ID,pprod.UNIQUE_ID),
    pprod.USER_DATA1 = NVL2(pstg.user_data1,pstg.user_data1,pprod.USER_DATA1),
    pprod.USER_DATA2 = NVL2(pstg.user_data2,pstg.user_data2,pprod.USER_DATA2),
    pprod.USER_DATA3 = NVL2(pstg.user_data3,pstg.user_data3,pprod.USER_DATA3),
    pprod.USER_DATA4 = NVL2(pstg.user_data4,pstg.user_data4,pprod.USER_DATA4),
    pprod.USER_DATA5 = NVL2(pstg.user_data5,pstg.user_data5,pprod.USER_DATA5),
    pprod.USER_DATA6 = NVL2(pstg.user_data6,pstg.user_data6,pprod.USER_DATA6),
    pprod.USER_DATA7 = NVL2(pstg.user_data7,pstg.user_data7,pprod.USER_DATA7),
    pprod.USER_DATA8 = NVL2(pstg.user_data8,pstg.user_data8,pprod.USER_DATA8),
    pprod.USER_DATA9 = NVL2(pstg.user_data9,pstg.user_data9,pprod.USER_DATA9),
    pprod.USER_DATA10 = NVL2(pstg.user_data10,pstg.user_data10,pprod.USER_DATA10),
    pprod.USER_DATA11 = NVL2(pstg.user_data11,pstg.user_data11,pprod.USER_DATA11),
    pprod.USER_DATA12 = NVL2(pstg.user_data12,pstg.user_data12,pprod.USER_DATA12),
    pprod.USER_DATA13 = NVL2(pstg.user_data13,pstg.user_data13,pprod.USER_DATA13),
    pprod.CREATED_BY = 'SYSTEM',
    pprod.UPDATED_BY = 'SYSTEM'
    when not matched then
    insert (pprod.PROGRAM_ID,
    pprod.LANGUAGE,
    pprod.TITLE,
    pprod.REDUCED_TITLE1,
    pprod.REDUCED_TITLE2,
    pprod.REDUCED_TITLE3,
    pprod.REDUCED_TITLE4,
    pprod.ALT_TITLE,
    pprod.REDUCED_DESCRIPTION1,
    pprod.REDUCED_DESCRIPTION2,
    pprod.REDUCED_DESCRIPTION3,
    pprod.REDUCED_DESCRIPTION4,
    pprod.ADVISORY_DESC1,
    pprod.ADVISORY_DESC2,
    pprod.ADVISORY_DESC3,
    pprod.ADVISORY_DESC4,
    pprod.ADVISORY_DESC5,
    pprod.ADVISORY_DESC6,
    pprod.GENRE_DESC1,
    pprod.GENRE_DESC2,
    pprod.GENRE_DESC3,
    pprod.GENRE_DESC4,
    pprod.GENRE_DESC5,
    pprod.GENRE_DESC6,
    pprod.DESCRIPTION1,
    pprod.DESCRIPTION2,
    pprod.YEAR_PROGRAM,
    pprod.MPAA_RATING,
    pprod.STAR_RATING,
    pprod.RUN_TIME,
    pprod.COLOR_CODE,
    pprod.PROGRAM_LANGUAGE,
    pprod.COUNTRY_OF_ORIGIN,
    pprod.MADE_FOR_TV,
    pprod.SOURCE_TYPE,
    pprod.SHOW_TYPE,
    pprod.HOLIDAY,
    pprod.SYNDICATE_EPISODE_NUM,
    pprod.ALT_SYNDICATE_EPI_NUM,
    pprod.EPISODE_TITLE,
    pprod.NET_SYN_SOURCE,
    pprod.NET_SYN_TYPE,
    pprod.ORG_STUDIO,
    pprod.GAME_DATETIME,
    pprod.GAME_TIMEZONE,
    pprod.ORG_AIR_DATE,
    pprod.UNIQUE_ID,
    pprod.USER_DATA1,
    pprod.USER_DATA2,
    pprod.USER_DATA3,
    pprod.USER_DATA4,
    pprod.USER_DATA5,
    pprod.USER_DATA6,
    pprod.USER_DATA7,
    pprod.USER_DATA8,
    pprod.USER_DATA9,
    pprod.USER_DATA10,
    pprod.USER_DATA11,
    pprod.USER_DATA12,
    pprod.USER_DATA13,
    pprod.CREATED_BY,
    pprod.UPDATED_BY)
    values (pstg.program_id,
    pstg.LANGUAGE,
    pstg.TITLE,
    pstg.REDUCED_TITLE1,
    pstg.REDUCED_TITLE2,
    pstg.REDUCED_TITLE3,
    pstg.REDUCED_TITLE4,
    pstg.ALT_TITLE,
    pstg.REDUCED_DESCRIPTION1,
    pstg.REDUCED_DESCRIPTION2,
    pstg.REDUCED_DESCRIPTION3,
    pstg.REDUCED_DESCRIPTION4,
    pstg.ADVISORY_DESC1,
    pstg.ADVISORY_DESC2,
    pstg.ADVISORY_DESC3,
    pstg.ADVISORY_DESC4,
    pstg.ADVISORY_DESC5,
    pstg.ADVISORY_DESC6,
    pstg.GENRE_DESC1,
    pstg.GENRE_DESC2,
    pstg.GENRE_DESC3,
    pstg.GENRE_DESC4,
    pstg.GENRE_DESC5,
    pstg.GENRE_DESC6,
    pstg.DESCRIPTION1,
    pstg.DESCRIPTION2,
    pstg.YEAR_PROGRAM,
    pstg.MPAA_RATING,
    pstg.STAR_RATING,
    pstg.RUN_TIME,
    pstg.COLOR_CODE,
    pstg.PROGRAM_LANGUAGE,
    pstg.COUNTRY_OF_ORIGIN,
    pstg.MADE_FOR_TV,
    pstg.SOURCE_TYPE,
    pstg.SHOW_TYPE,
    pstg.HOLIDAY,
    pstg.SYNDICATE_EPISODE_NUM,
    pstg.ALT_SYNDICATE_EPI_NUM,
    pstg.EPISODE_TITLE,
    pstg.NET_SYN_SOURCE,
    pstg.NET_SYN_TYPE,
    pstg.ORG_STUDIO,
    pstg.GAME_DATETIME,
    pstg.GAME_TIMEZONE,
    pstg.ORG_AIR_DATE,
    pstg.UNIQUE_ID,
    pstg.USER_DATA1,
    pstg.USER_DATA2,
    pstg.USER_DATA3,
    pstg.USER_DATA4,
    pstg.USER_DATA5,
    pstg.USER_DATA6,
    pstg.USER_DATA7,
    pstg.USER_DATA8,
    pstg.USER_DATA9,
    pstg.USER_DATA10,
    pstg.USER_DATA11,
    pstg.USER_DATA12,
    pstg.USER_DATA13,
    'SYSTEM',
    'SYSTEM');

    epgguidedatalogging('Start of Program_rating merge');    
    
    -- merge into program_rating
    merge into program_rating pr
    using stg_program_rating prstg
    on (prstg.program_id = pr.program_id and prstg.authority = pr.authority)
    when matched then
    update set 
    	pr.value = NVL2(prstg.value,prstg.value,pr.value),
	    pr.CREATED_BY = 'SYSTEM',
    	pr.UPDATED_BY = 'SYSTEM'
    
    when not matched then
    insert (
    	pr.program_id,
    	pr.authority,
    	pr.value,
 	   	pr.CREATED_BY,
    	pr.UPDATED_BY
    )
    values (
    	prstg.program_id,
    	prstg.authority,
    	prstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertProgramEntityMapping('PROGRAM_RATING','String','Authority');
  
  	epgguidedatalogging('Start of Program_Audio_Comp merge');    
    
    -- merge into program_audio_comp
    merge into program_audio_comp pac
    using stg_program_audio_comp pacstg
    on (pacstg.program_id = pac.program_id and
     	pac.tla = pacstg.tla )
    when matched then
    update set 
    	pac.value = NVL2(pacstg.value,pacstg.value,pac.value),
	    pac.CREATED_BY = 'SYSTEM',
    	pac.UPDATED_BY = 'SYSTEM'
    when not matched then
    insert (
    	pac.program_id,
    	pac.tla,
    	pac.type,
    	pac.language,
    	pac.attribute_type,
    	pac.value,
 	   	pac.CREATED_BY,
    	pac.UPDATED_BY
    )
    values (
    	pacstg.program_id,
    	pacstg.type||' '||pacstg.language||' '||pacstg.attribute_type,
    	pacstg.type,
    	pacstg.language,
    	pacstg.attribute_type,
    	pacstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertProgramEntityMapping('PROGRAM_AUDIO_COMP','String','TLA');

    epgguidedatalogging('Start of Program_Subtitle_Comp merge');    
    
    -- merge into program_subtitle_comp
    merge into program_subtitle_comp psc
    using stg_program_subtitle_comp pscstg
    on (pscstg.program_id = psc.program_id and 
       	psc.tla = pscstg.tla )
    when matched then
    update set 
    	psc.value = NVL2(pscstg.value,pscstg.value,psc.value),
	    psc.CREATED_BY = 'SYSTEM',
    	psc.UPDATED_BY = 'SYSTEM'
    
    when not matched then
    insert (
    	psc.program_id,
    	psc.tla,
    	psc.type,
    	psc.language,
    	psc.attribute_type,
    	psc.value,
 	   	psc.CREATED_BY,
    	psc.UPDATED_BY
    )
    values (
    	pscstg.program_id,
    	pscstg.type||' '||pscstg.language||' '||pscstg.attribute_type,
    	pscstg.type,
    	pscstg.language,
    	pscstg.attribute_type,
    	pscstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    -- InsertProgramEntityMapping('PROGRAM_SUBTITLE_COMP','String','TLA');

    IF (IS_TABLE_EXISTS('STG_PROGRAM_CAST') AND IS_TABLE_EXISTS('PROGRAM_CAST')) THEN
       epgguidedatalogging('Start of Program_Cast merge');    
       
       -- merge into program_cast
       merge into program_cast pc
       using stg_program_cast pcstg
       on (pcstg.program_id = pc.program_id and 
       pcstg.seq = pc.seq and
       pcstg.role = pc.role)
       when matched then
       update set 
       	pc.c_id = NVL2(pcstg.c_id, pcstg.c_id, pc.c_id),
       	pc.first_name = NVL2(pcstg.first_name, pcstg.first_name, pc.first_name),
       	pc.middle_name = NVL2(pcstg.middle_name, pcstg.middle_name, pc.middle_name),
       	pc.last_name = NVL2(pcstg.last_name, pcstg.last_name, pc.last_name),
        pc.CREATED_BY = 'SYSTEM',
       	pc.UPDATED_BY = 'SYSTEM'    
       when not matched then
       insert (
       	pc.program_id,
       	pc.c_id,
       	pc.seq,
       	pc.role,
       	pc.first_name,
       	pc.middle_name,
       	pc.last_name,
        pc.CREATED_BY,
       	pc.UPDATED_BY
       )
       values (    
       	pcstg.program_id,
       	pcstg.c_id,
       	pcstg.seq,
       	pcstg.role,
       	pcstg.first_name,
       	pcstg.middle_name,
       	pcstg.last_name,
        'SYSTEM',
       	'SYSTEM'
       );

    END IF;

 
  -- InsertProgramEntityMapping('PROGRAM_CAST','String','ROLE');
    
    IF (IS_TABLE_EXISTS('STG_PROGRAM_CREDITS') AND IS_TABLE_EXISTS('PROGRAM_CREDITS')) THEN
       epgguidedatalogging('Start of Program_Credits merge');    
       
       -- merge into program_credits
       merge into program_credits pc
       using stg_program_credits pcstg
       on (pcstg.program_id = pc.program_id and 
       pcstg.seq = pc.seq and
       pcstg.role = pc.role)
       when matched then
       update set 
       	pc.c_id = NVL2(pcstg.c_id, pcstg.c_id, pc.c_id),
       	pc.first_name = NVL2(pcstg.first_name, pcstg.first_name, pc.first_name),
       	pc.middle_name = NVL2(pcstg.middle_name, pcstg.middle_name, pc.middle_name),
       	pc.last_name = NVL2(pcstg.last_name, pcstg.last_name, pc.last_name),
        pc.CREATED_BY = 'SYSTEM',
       	pc.UPDATED_BY = 'SYSTEM'    
       when not matched then
       insert (
       	pc.program_id,
       	pc.c_id,
       	pc.seq,
       	pc.role,
       	pc.first_name,
       	pc.middle_name,
       	pc.last_name,
        pc.CREATED_BY,
       	pc.UPDATED_BY
       )
       values (    
       	pcstg.program_id,
       	pcstg.c_id,
       	pcstg.seq,
       	pcstg.role,
       	pcstg.first_name,
       	pcstg.middle_name,
       	pcstg.last_name,
        'SYSTEM',
       	'SYSTEM'
       );
    END IF;
    
 


    
 	epgguidedatalogging('Start of Program_Generic merge');    
    
    -- merge into program_generic
    merge into program_generic pg
    using stg_program_generic pgstg
    on (pgstg.program_id = pg.program_id and
       	pg.asset = pgstg.asset and
    	pg.name = pgstg.name )
    when matched then
    update set 
    	pg.value = NVL2(pgstg.value,pgstg.value,pg.value),
	    pg.CREATED_BY = 'SYSTEM',
    	pg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	pg.program_id,
    	pg.asset,
    	pg.name,
    	pg.value,
 	   	pg.CREATED_BY,
    	pg.UPDATED_BY
    )
    values (    
    	pgstg.program_id,
    	pgstg.asset,
    	pgstg.name,
    	pgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );

    -- InsertProgramEntityMapping('PROGRAM_GENERIC','String','Asset','Name');
    
    commit;

        --SCHEDULE MERGE
    epgguidedatalogging('Start of Schedule Merge');
    
    -- Clean temp table
    vsql := 'truncate  table temp_station_sch_range';
    CREATEOBJECT(vsql,'DROP TABLE temp_station_sch_range','Y');
    
    --Get max start time from schedule
    select nvl(max(start_time),vcurrentdatetime)
    into vmaxschedulestarttime
    from schedule;
    
    
    -- we consider the time window as-is from the incoming schedule and not necessarily starting or ending on current datetime
    select min(start_time) as minstgschdate, max(start_time + numtodsinterval(duration,'SECOND'))  as maxstgschdate
    into vminstgschdate, vmaxstgschdate
    from stg_schedule;
    
    -- Get the time ranges for all the stations that need to be changed (stations in stg_stations)
    -- there can be some stations who dont have a schedule. Include those too
    insert into temp_station_sch_range(station_id, first_schedule_start_time, last_schedule_end_time)
          select sst.station_id,  min(start_time) as minstgschdate, max(start_time + numtodsinterval(duration,'SECOND'))  as maxstgschdate
          from stg_schedule ssch right join stg_station sst on (sst.station_id = ssch.station_id)
    group by sst.station_id;
    
    -- Delete from schedule all entries whose programs start on or after the current schedule start time and before current end time
    -- and which are not mentioned in the new schedule entries
    -- but whose station are mentioned in the new station entries 
    -- In short remove entries whose stations have now disappeared from the new schedule but whose stations are mentioned in the new staions.    
    
    delete from schedule s
           where
           s.start_time >= vminstgschdate
           and s.start_time < vmaxstgschdate
           and not exists (select 1 from stg_schedule stg
                           where stg.start_time = s.start_time and
                           stg.station_id = s.station_id and
                           stg.program_id = s.program_id
                          )
          and exists (select 1 from stg_station sst join temp_station_sch_range tssr on (sst.station_id = tssr.station_id)
                       where sst.station_id = s.station_id  and s.start_time >= nvl(tssr.first_schedule_start_time,vminstgschdate)
                       and s.start_time <  nvl(tssr.last_schedule_end_time,vmaxstgschdate)
                    );
    
     -- dont understand the where clause above...s.start_time >= nvl(... tssr.firsr_schedile_start_time will always be null due to the right join above and the not exist in this SQL
    
    
             --Merge the schedule records
          merge into schedule sprod
          using (select * from stg_schedule /* where start_time > nvl(vcurrentdatetime,current_timestamp )*/) sstg
          on (sstg.program_id = sprod.program_id and sstg.station_id = sprod.station_id and sstg.start_time = sprod.start_time)
          when matched then
          update set 
          sprod.schedule_language = NVL2(sstg.schedule_language,sstg.schedule_language,sprod.schedule_language),
          sprod.end_time = NVL2(sstg.end_time, sstg.end_time, sprod.end_time),
          sprod.duration = NVL2(sstg.duration, sstg.duration, sprod.duration),
          sprod.tv_rating = NVL2(sstg.tv_rating,sstg.tv_rating,sprod.tv_rating),
          sprod.hd_tv = NVL2(sstg.hd_tv,sstg.hd_tv,sprod.hd_tv),
          sprod.part_number = NVL2(sstg.part_number,sstg.part_number,sprod.part_number),
          sprod.no_of_parts = NVL2(sstg.no_of_parts,sstg.no_of_parts,sprod.no_of_parts),
          sprod.cc = NVL2(sstg.cc,sstg.cc,sprod.cc),
          sprod.stereo = NVL2(sstg.stereo,sstg.stereo,sprod.stereo),
          sprod.live_tape_delay = NVL2(sstg.live_tape_delay,sstg.live_tape_delay,sprod.live_tape_delay),
          sprod.subtitled = NVL2(sstg.subtitled,sstg.subtitled,sprod.subtitled),
          sprod.premiere_finale = NVL2(sstg.premiere_finale,sstg.premiere_finale,sprod.premiere_finale),
          sprod.joined_in_progress = NVL2(sstg.joined_in_progress,sstg.joined_in_progress,sprod.joined_in_progress),
          sprod.cable_in_classroom = NVL2(sstg.cable_in_classroom,sstg.cable_in_classroom,sprod.cable_in_classroom),
          sprod.sap = NVL2(sstg.sap,sstg.sap,sprod.sap),
          sprod.sex_rating = NVL2(sstg.sex_rating,sstg.sex_rating,sprod.sex_rating),
          sprod.violence_rating = NVL2(sstg.violence_rating,sstg.violence_rating,sprod.violence_rating),
          sprod.language_rating = NVL2(sstg.language_rating,sstg.language_rating,sprod.language_rating),
          sprod.dialog_rating = NVL2(sstg.dialog_rating,sstg.dialog_rating,sprod.dialog_rating),
          sprod.fv_rating = NVL2(sstg.fv_rating,sstg.fv_rating, sprod.fv_rating),
          sprod.enhanced = NVL2(sstg.enhanced,sstg.enhanced,sprod.enhanced),
          sprod.three_d = NVL2(sstg.three_d,sstg.three_d, sprod.three_d),
          sprod.letterbox = NVL2(sstg.letterbox,sstg.letterbox,sprod.letterbox),
          sprod.dvs = NVL2(sstg.dvs,sstg.dvs,sprod.dvs),
          sprod.series_id = NVL2(sstg.series_id,sstg.series_id,sprod.series_id),
          sprod.request_record = NVL2(sstg.request_record,sstg.request_record,sprod.request_record),
          sprod.repeat = NVL2(sstg.repeat,sstg.repeat,sprod.repeat),
          sprod.blackout = NVL2(sstg.blackout,sstg.blackout,sprod.blackout),
          sprod.dolby = NVL2(sstg.dolby,sstg.dolby,sprod.dolby),
          sprod.USER_DATA1 = NVL2(sstg.user_data1,sstg.user_data1,sprod.USER_DATA1),
          sprod.USER_DATA2 = NVL2(sstg.user_data2,sstg.user_data2,sprod.USER_DATA2),
          sprod.USER_DATA3 = NVL2(sstg.user_data3,sstg.user_data3,sprod.USER_DATA3),
          sprod.USER_DATA4 = NVL2(sstg.user_data4,sstg.user_data4,sprod.USER_DATA4),
          sprod.USER_DATA5 = NVL2(sstg.user_data5,sstg.user_data5,sprod.USER_DATA5),
          sprod.USER_DATA6 = NVL2(sstg.user_data6,sstg.user_data6,sprod.USER_DATA6),
          sprod.USER_DATA7 = NVL2(sstg.user_data7,sstg.user_data7,sprod.USER_DATA7),
          sprod.USER_DATA8 = NVL2(sstg.user_data8,sstg.user_data8,sprod.USER_DATA8),
          sprod.USER_DATA9 = NVL2(sstg.user_data9,sstg.user_data9,sprod.USER_DATA9),
          sprod.USER_DATA10 = NVL2(sstg.user_data10,sstg.user_data10,sprod.USER_DATA10),
          sprod.USER_DATA11 = NVL2(sstg.user_data11,sstg.user_data11,sprod.USER_DATA11),
          sprod.created_by = 'SYSTEM',
          sprod.updated_by = 'SYSTEM'
          when not matched then
          insert (sprod.schedule_id,
          sprod.SCHEDULE_LANGUAGE,
          sprod.STATION_ID,
          sprod.PROGRAM_ID,
          sprod.START_TIME,
          sprod.END_TIME,
          sprod.DURATION,
          sprod.TV_RATING,
          sprod.HD_TV,
          sprod.PART_NUMBER,
          sprod.NO_OF_PARTS,
          sprod.CC,
          sprod.STEREO,
          sprod.LIVE_TAPE_DELAY,
          sprod.SUBTITLED,
          sprod.PREMIERE_FINALE,
          sprod.JOINED_IN_PROGRESS,
          sprod.CABLE_IN_CLASSROOM,
          sprod.SAP,
          sprod.SEX_RATING,
          sprod.VIOLENCE_RATING,
          sprod.LANGUAGE_RATING,
          sprod.DIALOG_RATING,
          sprod.FV_RATING,
          sprod.ENHANCED,
          sprod.THREE_D,
          sprod.LETTERBOX,
          sprod.DVS,
          sprod.series_id,
          sprod.REQUEST_RECORD,
          sprod.REPEAT,
          sprod.BLACKOUT,
          sprod.DOLBY,
          sprod.USER_DATA1,
          sprod.USER_DATA2,
          sprod.USER_DATA3,
          sprod.USER_DATA4,
          sprod.USER_DATA5,
          sprod.USER_DATA6,
          sprod.USER_DATA7,
          sprod.USER_DATA8,
          sprod.USER_DATA9,
          sprod.USER_DATA10,
          sprod.USER_DATA11,
          sprod.CREATED_BY,
          sprod.UPDATED_BY)
          values (SCHEDULE_SEQ.nextval,
          sstg.SCHEDULE_LANGUAGE,
          sstg.STATION_ID,
          sstg.PROGRAM_ID,
          sstg.start_time,
          sstg.end_time,
          sstg.DURATION,
          sstg.TV_RATING,
          sstg.HD_TV,
          sstg.PART_NUMBER,
          sstg.NO_OF_PARTS,
          sstg.CC,
          sstg.STEREO,
          sstg.LIVE_TAPE_DELAY,
          sstg.SUBTITLED,
          sstg.PREMIERE_FINALE,
          sstg.JOINED_IN_PROGRESS,
          sstg.CABLE_IN_CLASSROOM,
          sstg.SAP,
          sstg.SEX_RATING,
          sstg.VIOLENCE_RATING,
          sstg.LANGUAGE_RATING,
          sstg.DIALOG_RATING,
          sstg.FV_RATING,
          sstg.ENHANCED,
          sstg.THREE_D,
          sstg.LETTERBOX,
          sstg.DVS,
          sstg.series_id,
          sstg.REQUEST_RECORD,
          sstg.REPEAT,
          sstg.BLACKOUT,
          sstg.DOLBY,
          sstg.USER_DATA1,
          sstg.USER_DATA2,
          sstg.USER_DATA3,
          sstg.USER_DATA4,
          sstg.USER_DATA5,
          sstg.USER_DATA6,
          sstg.USER_DATA7,
          sstg.USER_DATA8,
          sstg.USER_DATA9,
          sstg.USER_DATA10,
          sstg.USER_DATA11,
          'SYSTEM',
          'SYSTEM');
          
	epgguidedatalogging('Start of Schedule_Event_Id merge');    
    
    -- merge into schedule_event_id
    merge into schedule_event_id sei
    using stg_schedule_event_id seistg
    on (seistg.program_id = sei.program_id and
        	sei.identifier_type = seistg.identifier_type )
    when matched then
    update set 
    	sei.value = NVL2(seistg.value,seistg.value,sei.value),
	    sei.CREATED_BY = 'SYSTEM',
    	sei.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	sei.program_id,
    	sei.identifier_type,
    	sei.value,
 	   	sei.CREATED_BY,
    	sei.UPDATED_BY
    )
    values (    
    	seistg.program_id,
    	seistg.identifier_type,
    	seistg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertScheduleEntityMapping('SCHEDULE_EVENT_ID','String','IDENTIFIER_TYPE');
          
	epgguidedatalogging('Start of Schedule_Series_Attrib merge');    
    
    -- merge into schedule_series_attrib
    merge into schedule_series_attrib ssa
    using stg_schedule_series_attrib ssastg
    on (ssastg.program_id = ssa.program_id and 
        	ssa.attribute_type = ssastg.attribute_type)
    when matched then
    update set 
    	ssa.value = NVL2(ssastg.value,ssastg.value,ssa.value),
	    ssa.CREATED_BY = 'SYSTEM',
    	ssa.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	ssa.program_id,
    	ssa.attribute_type,
    	ssa.value,
 	   	ssa.CREATED_BY,
    	ssa.UPDATED_BY
    )
    values (    
    	ssastg.program_id,
    	ssastg.attribute_type,
    	ssastg.value,
	    'SYSTEM',
    	'SYSTEM'
    );          
    -- InsertScheduleEntityMapping('SCHEDULE_SERIES_ATTRIB','String','ATTRIBUTE_TYPE');

 	epgguidedatalogging('Start of Schedule_Generic merge');    
    
    -- merge into schedule_generic
    merge into schedule_generic sg
    using stg_schedule_generic sgstg
    on (sgstg.program_id = sg.program_id and
   		sg.asset = sgstg.asset and
    	sg.name = sgstg.name)
    when matched then
    update set 
    	sg.value = NVL2(sgstg.value,sgstg.value,sg.value),
	    sg.CREATED_BY = 'SYSTEM',
    	sg.UPDATED_BY = 'SYSTEM'    
    when not matched then
    insert (
    	sg.program_id,
    	sg.asset,
    	sg.name,
    	sg.value,
 	   	sg.CREATED_BY,
    	sg.UPDATED_BY
    )
    values (    
    	sgstg.program_id,
    	sgstg.asset,
    	sgstg.name,
    	sgstg.value,
	    'SYSTEM',
    	'SYSTEM'
    );
    
    -- InsertScheduleEntityMapping('SCHEDULE_GENERIC','String','ASSET','NAME');
    
    commit;

 end;
 
 
 procedure merge(provider_id number default -1, overwriteWithEmpty CHAR default 'Y', truncateProduction CHAR default 'N', daysBehindNowToKeep number default 14) is
 
    vcurrentdatetimeforlog timestamp with time zone;
    minutesittook varchar2(20);
    secondsittook varchar2(20);
 	hoursittook varchar2(20);    
    providerName nvarchar2(50);
    
    headendCount varchar2(20) := 'unknown';
    lineupCount varchar2(20):= 'unknown';
    stationCount varchar2(20):= 'unknown';
    programCount varchar2(20):= 'unknown';
    scheduleCount varchar2(20):= 'unknown';
    scheduleTop varchar2(20):= 'unknown';
    scheduleBot varchar2(20):= 'unknown';

 begin
	 	
   init();
   
   epgguidedatalogging('merge: provider_id:'||provider_id||' overwriteWithEmpty:'||overwriteWithEmpty||' truncateProduction:'||truncateProduction||' daysBehindNowToKeep:'||daysBehindNowToKeep);
   
   providerName := 'Unknown';
   begin
   	select Name into ProviderName from Provider where id = provider_id;
   exception
   	when NO_DATA_FOUND then
   		providerName := 'unknown';
   end;
   
   if truncateProduction = 'Y' then
   	alarmactivitylogging('Truncating Production Data prior to merge of provider '||providerName,const_COMPONENT_NAME_MERGE);
   	epgguidedatalogging('Truncating Production Data prior to merge of provider '||providerName); 	
   	truncateprod();
   else
    -- perform purge...
    purgeProduction(daysBehindNowToKeep);
   end if;
        
    alarmactivitylogging('Start of EPG merge for provider '||providerName,const_COMPONENT_NAME_MERGE);
    vcurrentdatetimeforlog := current_timestamp;
    
 	-- call sub merges based on overwriteWithEmpty
 	if overwriteWithEmpty = 'Y' then
    	epgguidedatalogging('Start of Merge '||providerName||' with Empty Strings. StartTime = '||current_timestamp); 	
 		mergetstvWithEmpty(providerName);
 	else
	    epgguidedatalogging('Start of Merge '||providerName||' withOUT Empty String. StartTime = '||current_timestamp);
 		mergetstvWithoutEmpty(providerName);
 	end if;
 
   SELECT floor(Extract(Minute from (current_timestamp - vcurrentdatetimeforlog))) into minutesittook from dual;
   SELECT floor(Extract(Second from (current_timestamp - vcurrentdatetimeforlog))) into secondsittook from dual;
   SELECT floor(Extract(Hour from (current_timestamp - vcurrentdatetimeforlog))) into hoursittook from dual;
   
   begin
   	select count(*) into headendCount from stg_headend;
   	select count(*) into lineupCount from stg_lineup;
   	select count(*) into stationCount from stg_station;
   	select count(*) into programCount from stg_program;
   	select count(*) into scheduleCount from stg_schedule;
   	select to_char(min(START_TIME), 'FMMon dd, YYYY') into scheduleBot from stg_schedule;
   	select to_char(max(START_TIME), 'FMMon dd, YYYY') into scheduleTop from stg_schedule;
	alarmactivitylogging('EPG Merge Report: Provider: '||providerName||' Headends ('||headendCount||'), Lineups ('||lineupCount||'), Stations ('||stationCount||'), Programs ('||programCount||'), Schedules ('||scheduleCount||',  '||scheduleBot||' to '||scheduleTop||' )', const_COMPONENT_NAME_MERGE);
   	
	exception
		when NO_DATA_FOUND then
			epgguidedatalogging('Merge Report failure.');			
	end;
   
   
	
    epgguidedatalogging('End of Merge. It took '||hoursittook||' hours '||LPAD(minutesittook,2,'0')||' minutes and '||LPAD(secondsittook,2,'0')||' seconds');
    
    alarmactivitylogging('Finished EPG merge for provider '||providerName||' (took '||hoursittook||':'||LPAD(minutesittook,2,'0')||':'||LPAD(secondsittook,2,'0')||')', const_COMPONENT_NAME_MERGE);
     
   commit;
   
   
   exception
   	when others then
    alarmactivitylogging('Abnormal Error during EPG merge for '||providerName||' '||SQLERRM, const_COMPONENT_NAME_MERGE, const_ALARM_SEVERITY_ERROR);   
    epgguidedatalogging('Abnormal Merge error. Abort. '||SQLERRM);
    
   	raise;

 end merge;
 
 procedure load(v_filename varchar2 default 'Guidedata.xml', provider_id number default -1) is
   passValidation boolean := false;
   providerName nvarchar2(50) := 'unknown';
  begin
    init();
    delete_leftover_files(v_filename);
    
    epgguidedatalogging('load: v_filename: '||v_filename||' provider_id: '||to_char(provider_id));
  
    
    begin
    	select name into providerName from provider where id = provider_id;
    exception
    	when NO_DATA_FOUND then
    	providerName := 'unknown';
    end;
    
    -- pull data into staging tables
    processepgdata(providerName, v_filename);
    commit;
    
    dbms_xdb.deleteresource('/public/epgmanager/'||v_filename,dbms_xdb.delete_recursive_force);

    commit;
  exception
    when others then
      -- Error Code 11 = EPG Download Abnormal Error
      dbms_xdb.deleteresource('/public/epgmanager/'||v_filename,dbms_xdb.delete_recursive_force);
      commit;
      
      DECLARE
      	sError varchar2(2000) := SQLERRM;
      BEGIN
	    if INSTR(sError,'FK_STG_LINEUP_STATION') != 0 then
	    	alarmactivitylogging('Invalid EPG Data for provider '||providerName||'. LINEUP rows reference non existant STATION.', const_COMPONENT_NAME_INGEST, const_ALARM_SEVERITY_ERROR);  
	    elsif INSTR(sError,'FK_STG_HEADEND_LINEUP') != 0 then
	    	alarmactivitylogging('Invalid EPG Data for provider '||providerName||'. LINEUP rows reference non existant HEADEND.', const_COMPONENT_NAME_INGEST, const_ALARM_SEVERITY_ERROR);  
	    elsif INSTR(sError, 'FK_STG_STATION_SCHEDULE') != 0 then
	    	alarmactivitylogging('Invalid EPG Data for provider '||providerName||'. SCHEDULE rows reference non existant STATION.', const_COMPONENT_NAME_INGEST, const_ALARM_SEVERITY_ERROR);  
	    elsif INSTR(sError, 'FK_STG_SCHEDULE_PROGRAM') != 0 then
	    	alarmactivitylogging('Invalid EPG Data for provider '||providerName||'. SCHEDULE rows reference non existant PROGRAM.', const_COMPONENT_NAME_INGEST, const_ALARM_SEVERITY_ERROR);  	    
	    else
	    	alarmactivitylogging('Invalid EPG Data for provider '||providerName||' '||sError, const_COMPONENT_NAME_INGEST, const_ALARM_SEVERITY_ERROR);  	    	
	    end if;   
	   END;
     
    epgguidedatalogging('Abnormal Load error. Abort. '||SQLERRM);
    
      raise;

  end load;
END EPGMERGE;
/
exit