
--set echo on
set serveroutput on

def RCS_DB_VERSION=&1

CREATE OR REPLACE PACKAGE TSTVDB AS
  procedure installtstv;
  procedure droptstv;
  procedure killhangingresourcelocksession;
  vschema varchar2(100) := 'RCS';
  success boolean;
END TSTVDB;
/

create or replace
PACKAGE BODY TSTVDB AS

 FUNCTION IS_TABLE_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2) RETURN boolean is

counter number(5) := 0;
begin
  select count(1) into counter from dba_tables where owner=UPPER(IN_OWNER) AND TABLE_NAME=UPPER(IN_TABLE_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;



 FUNCTION IS_COLUMN_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2) RETURN boolean is

counter number(5) := 0;
begin
  select count(1) into counter from DBA_TAB_COLS where owner=UPPER(IN_OWNER) AND TABLE_NAME=UPPER(IN_TABLE_NAME) AND COLUMN_NAME=UPPER(IN_COLUMN_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;

FUNCTION IS_INDEX_EXISTS (IN_OWNER VARCHAR2, IN_INDEX_NAME VARCHAR2) RETURN boolean is

counter number(5) := 0;
begin
  select count(1) into counter from DBA_INDEXES where owner=UPPER(IN_OWNER)  AND INDEX_NAME=UPPER(IN_INDEX_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;

FUNCTION IS_COLUMN_VALUE_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2, IN_COLUMN_VALUE varchar2, IN_DATA_TYPE VARCHAR2 DEFAULT 'VARCHAR2') RETURN boolean is

counter number(5) := 0;
vsql varchar2(1000);
begin
  IF upper(IN_DATA_TYPE) = 'NUMBER' THEN
  vsql := 'select count(1) from '||IN_OWNER||'.'||IN_TABLE_NAME||' WHERE '||IN_COLUMN_NAME||'='||IN_COLUMN_VALUE;
  ELSIF (upper(IN_DATA_TYPE) = 'VARCHAR' OR upper(IN_DATA_TYPE) = 'VARCHAR2') THEN
  vsql := 'select count(1) from '||IN_OWNER||'.'||IN_TABLE_NAME||' WHERE upper('||IN_COLUMN_NAME||')=upper('''||IN_COLUMN_VALUE||''')';
  END IF;
  EXECUTE IMMEDIATE vsql INTO counter;

  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;

FUNCTION IS_CONSTRAINT_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_CONSTRAINT_NAME VARCHAR2) RETURN boolean is

counter number(5) := 0;
begin
  select count(1) into counter from  dba_constraints where owner =UPPER(IN_OWNER) and table_name=UPPER(IN_TABLE_NAME) AND CONSTRAINT_NAME=UPPER(IN_CONSTRAINT_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;

FUNCTION GET_COLUMN_DATA_TYPE (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2) RETURN VARCHAR2 is

v_data_type varchar2(200) ;
begin
  SELECT DATA_TYPE INTO v_data_type FROM DBA_TAB_COLS WHERE OWNER=UPPER(IN_OWNER) AND TABLE_NAME = UPPER(IN_TABLE_NAME) AND COLUMN_NAME=UPPER(IN_COLUMN_NAME);
  return v_data_type;
end;

FUNCTION IS_COLUMN_ALLOW_NULLS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2) RETURN boolean is

v_nullable varchar2(200) ;
begin
  SELECT NULLABLE INTO v_nullable FROM DBA_TAB_COLS WHERE OWNER=UPPER(IN_OWNER) AND TABLE_NAME = UPPER(IN_TABLE_NAME) AND COLUMN_NAME=UPPER(IN_COLUMN_NAME);
  IF v_nullable = 'Y' then
    return true;
  else
    return false;
 end if;
end;

 FUNCTION IS_SEQUENCE_EXISTS (IN_SEQUENCE_OWNER VARCHAR2, IN_SEQUENCE_NAME VARCHAR2) RETURN boolean is

counter number(5) := 0;
begin
  select count(1) into counter from dba_sequences where sequence_owner=upper(IN_SEQUENCE_OWNER) AND sequence_name=upper(IN_SEQUENCE_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;

FUNCTION IS_VIEW_EXISTS (IN_OWNER VARCHAR2, IN_VIEW_NAME VARCHAR2) RETURN boolean is

counter number(5) := 0;
begin
  select count(1) into counter from dba_views where owner=upper(IN_OWNER) AND VIEW_NAME=upper(IN_VIEW_NAME);
  if counter > 0  then
    return true;
  else
  return false;
  end if;
end;


  PROCEDURE CONFIGXMLDB AS
    newconfig XMLType;
	success boolean;
  BEGIN
    SELECT
      updateXML(
        DBMS_XDB.cfg_get(),
        '/xdbconfig/sysconfig/protocolconfig/ftpconfig/session-timeout/text()',
        999999999,
       '/xdbconfig/sysconfig/protocolconfig/ftpconfig/ftp-port/text()',
       2100
        )
      INTO newconfig
      FROM DUAL;

    DBMS_XDB.cfg_update(newconfig);

    SELECT
      updateXML(
        DBMS_XDB.cfg_get(),
        '/xdbconfig/sysconfig/call-timeout/text()',
        999999999,
        '/xdbconfig/sysconfig/default-lock-timeout/text()',
        999999999)
      INTO newconfig
      FROM DUAL;

    DBMS_XDB.cfg_update(newconfig);

    SELECT
      updateXML(
        DBMS_XDB.cfg_get(),
        '/xdbconfig/sysconfig/protocolconfig/common/session-timeout/text()',
        999999999,
       '/xdbconfig/sysconfig/persistent-sessions/text()',
       'true')
      INTO newconfig
      FROM DUAL;

    DBMS_XDB.cfg_update(newconfig);

    SELECT
      updateXML(
        DBMS_XDB.cfg_get(),
        '/xdbconfig/sysconfig/protocolconfig/ftpconfig/buffer-size/text()',
        1048496)
      INTO newconfig
      FROM DUAL;

    DBMS_XDB.cfg_update(newconfig);
    
     -- create FTP folder /public/rcs
    if not DBMS_XDB.existsresource('/public/rcs') then
    	success := DBMS_XDB.createfolder('/public/rcs');
    end if;

    END CONFIGXMLDB;

/* Procedure: SetDbCreateFileDest. Sets the default directory for Oracle datafiles so the path
              need not be given when creating tablespaces. */
  PROCEDURE SETDBCREATEFILEDEST(vpath varchar2) IS
  BEGIN
    execute immediate 'alter system set db_create_file_dest='''||vpath||''' scope=both';
  END SETDBCREATEFILEDEST;

   /* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in install_table*/
  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    execute immediate vsql;
  exception
    when others then
          verrmsg := errmsg ||' '||sqlerrm;
          select cast(verrmsg as varchar2(4000))
          into verrmsg
          from dual;
      if upper(mask) != 'Y' then
          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
          commit;
          raise;
      end if;
  END CREATEOBJECT;

  procedure droptstv is
    vsql varchar2(32767);
  begin
    vsql := 'drop table stg_schedule';
    CREATEOBJECT(vsql,'Drop table stg_schedule','Y');

    vsql := 'drop table stg_program';
    CREATEOBJECT(vsql,'Drop table stg_program','Y');

    vsql := 'drop table stg_program';
    CREATEOBJECT(vsql,'Drop table stg_program','Y');

  end;

/* Procedure: CreateUpdTimeTRG. Updates the UpdateTime column with the current date and time when any
              update statement is issued against the table.*/
  PROCEDURE CREATEUPDATETRG(vtabname varchar2) IS
    vcount number := 0;
    vsql varchar2(32000);
  BEGIN
    select count(*)
    into vcount
    from dba_tables dt, dba_tab_columns dtc
    where dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dt.owner = dtc.owner
    and dt.owner = vschema
    and dtc.column_name = 'UPDATE_DATE';

	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||vtabname||'UPD BEFORE UPDATE ON '||vschema||'.'||vtabname||' FOR EACH ROW
            DECLARE
              vcurrent_timestamp timestamp with time zone;
            BEGIN
				if (:new.update_date is null) then
	                select current_timestamp into vcurrent_timestamp from dual;
	                :new.update_date := vcurrent_timestamp;
				end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

    select count(*)
    into vcount
    from dba_tables dt, dba_tab_columns dtc
    where dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dt.owner = dtc.owner
    and dt.owner = vschema
    and dtc.column_name = 'CREATE_DATE';

	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||vtabname||'CRT BEFORE INSERT ON '||vschema||'.'||vtabname||' FOR EACH ROW
            DECLARE
              vcurrent_timestamp timestamp with time zone;
            BEGIN
              if (:new.create_date is null or :new.update_date is null) then
                select current_timestamp into vcurrent_timestamp from dual;
                :new.create_date := vcurrent_timestamp;
                :new.update_date := vcurrent_timestamp;
              end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

   END CREATEUPDATETRG;

/* Procedure: CreateSeq. Creates a sequence on a primary key of a table.
              Sequence name is <tablename>_SEQ.*/
  PROCEDURE CREATESEQ(vtabname varchar2, vstartwith number default 1) IS
    vcolname dba_cons_columns.column_name%type;
    vsql varchar2(32000);
  BEGIN
    select dcc.column_name
    into vcolname
    from dba_constraints dc, dba_cons_columns dcc
    where dc.owner=vschema
    and dc.owner = dcc.owner
    and dc.table_name = dcc.table_name
    and dc.table_name=upper(vtabname)
    and dc.constraint_type='P'
    and dc.constraint_name = dcc.constraint_name
    and rownum < 2;

		-- Create Sequence for Table
      vsql :=  'CREATE SEQUENCE '||vschema||'.'||vtabname||'_SEQ INCREMENT BY 1 START WITH '||vstartwith||' NOCACHE';
      CREATEOBJECT(vsql,'Create Sequence'||vtabname||'_SEQ');

    -- Create before insert trigger to populate the PK column
     if (vcolname = 'RECORDING_QUEUE_ID') then 
       
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||vtabname||'TRG BEFORE INSERT ON '||vschema||'.'||vtabname||' FOR EACH ROW
            DECLARE
              vseq number;
            BEGIN
              if (:new.'||vcolname||' is null) then
                select '||vschema||'.'||vtabname||'_SEQ.nextval into vseq from dual;
                :new.'||vcolname||' := vseq;
                  insert into temp_rec_queue_list values (:new.'||vcolname||');
              end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'TRG');
    else 
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||vtabname||'TRG BEFORE INSERT ON '||vschema||'.'||vtabname||' FOR EACH ROW
            DECLARE
              vseq number;
            BEGIN
              if (:new.'||vcolname||' is null) then
                select '||vschema||'.'||vtabname||'_SEQ.nextval into vseq from dual;
                :new.'||vcolname||' := vseq;          
              end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'TRG');
    end if;
   END CREATESEQ;


  procedure createtstv IS
    vsql varchar2(32767);
  BEGIN
/*    --drop table epgxmlfiles
    vsql := 'drop table epgxmlfiles purge';
    CREATEOBJECT(vsql,'Drop table epgxmlfiles','Y');
*/
    --Create install_table for logging errors
    vsql := 'CREATE TABLE install_Table( msgdate date default sysdate,install_message varchar2(4000))';
    CREATEOBJECT(vsql,'Create table install_table','Y');

   /********************** CREATE WFS USER AND TABLESPACES ******************/

    -- Set db_create_file_dest to default directory
    select substr(file_name,1,instr(file_name,decode(platform.platformname,'windows','\','/'),-1) -1)
    INTO vsql
    from dba_data_files, (select case when lower(platform_name) like '%windows%' then 'windows' else 'unix' end as platformname from v$database )  platform
    WHERE tablespace_name = 'SYSTEM';

    --SETDBCREATEFILEDEST(vsql);

     -- Drop WFS_data tablespace
      vsql :='drop tablespace tstv_rcs including contents and datafiles';
			CREATEOBJECT(vsql,'DROP TABLESPACE tstv_rcs','Y');

      -- Creating WFS_data tablespace
      vsql :='create tablespace tstv_rcs datafile size 500M AUTOEXTEND ON NEXT 250M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL AUTOALLOCATE SEGMENT SPACE MANAGEMENT AUTO';
			CREATEOBJECT(vsql,'CREATE TABLESPACE tstv_rcs');

		-- Set Default temp tablespace to temp
      vsql :=  'ALTER DATABASE DEFAULT TEMPORARY TABLESPACE temp';
      CREATEOBJECT(vsql,'Default Tablespace temp','Y');

		--DROP RCS USER
      vsql :=  'drop user RCS cascade';
      CREATEOBJECT(vsql,'DROP USER RCS','Y');

		--CREATE RCS USER
      vsql :=  'create user RCS identified by RcS1234 default tablespace tstv_rcs';
      CREATEOBJECT(vsql,'CREATE USER RCS');

		--Grant privs to RCS user
      vsql :=  'grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to RCS';
      CREATEOBJECT(vsql,'Unable to grant resource, connect, and create session to the RCS user.');

      vsql := 'grant all on dbms_xmlschema to RCS';
      CREATEOBJECT(vsql,'Unable to grant all on dbms_xmlschema to RCS');

      vsql := 'grant all on dbms_errlog to RCS';
      CREATEOBJECT(vsql,'Unable to grant all on dbms_errlog to RCS');

      vsql := 'grant create database link to RCS';
      CREATEOBJECT(vsql,'Unable to grant create database link to RCS');

      --Recreate directory tstvxmldir
      vsql := 'drop directory tstvxmldir';
      CREATEOBJECT(vsql,'Unable to drop directory tstvxmldir','Y');

      vsql := 'create directory tstvxmldir as ''/home/oracle/tstv''';
      CREATEOBJECT(vsql,'Unable to create directory tstvxmldir');

      vsql := 'grant all on directory tstvxmldir to public,rcs';
      CREATEOBJECT(vsql,'Unable to grant all on directory tstvxmldir');

      --Register Schema ETV_EPG.xsd
      vsql := 'BEGIN
                DBMS_XMLSCHEMA.registerSchema(
                  SCHEMAURL => ''ETV_EPG.xsd'',
                  SCHEMADOC => bfilename(''TSTVXMLDIR'',''ETV_EPG.xsd''),
                  OWNER => ''RCS'',
                  CSID => nls_charset_id(''AL32UTF8'')
                  );
               END;';
      CREATEOBJECT(vsql,'Unable to registerSchema ETV_EPG.xsd');

    /********************** RCS Production tables *********************/

    vsql := 'CREATE TABLE '||vschema||'.install_Table( msgdate date default sysdate,install_message varchar2(4000))';
    CREATEOBJECT(vsql,'Create table install_table','Y');
    
    vsql := 'CREATE TABLE '||vschema||'.TEMP_REC_QUEUE_LIST
     (    
       RECORDING_QUEUE_ID NUMBER
     )';
    CREATEOBJECT(vsql,'create table TEMP_REC_QUEUE_LIST');

    vsql := 'CREATE TABLE '||vschema||'.TEMP_REC_RULES
     (	RECORDING_ID NUMBER,
      PROGRAM_TITLE NVARCHAR2(1000),
      PROGRAM_DESCRIPTION NVARCHAR2(2000),
      OFFSET_START_TIME NUMBER(22,0),
      OFFSET_END_TIME NUMBER(22,0),
      RECORDING_MODE NVARCHAR2(50),
      PRIORITY NUMBER(2,0),
      PROVIDER_QA_CONTACT NVARCHAR2(128),
      CATALOG_ENTRY NUMBER(1,0),
      BILLING_ID NVARCHAR2(5),
      MPAA_RATING NVARCHAR2(1000),
      TV_RATING NVARCHAR2(1000),
      PROVIDER_ID NVARCHAR2(20),
      PROVIDER_NAME NVARCHAR2(128),
      PRODUCT NVARCHAR2(20),
      CATEGORY NVARCHAR2(2000),
	  AUDIO_TYPE NVARCHAR2(14),
      MAX_COPIES NUMBER(10,0),
      PREVIEW_PERIOD NUMBER(10,0),
	  REDUNDANCY_COUNT NUMBER(3,0),
      LICENCE_START_DATE TIMESTAMP (9) WITH TIME ZONE,
      LICENSE_END_DATE TIMESTAMP (9) WITH TIME ZONE,
      REPEAT NVARCHAR2(1),
      CREATED_BY CHAR(6),
      UPDATED_BY CHAR(6),
      CREATE_DATE DATE,
      UPDATE_DATE DATE,
      SCHEDULE_ID NUMBER(19,0),
      HEADEND_ID NVARCHAR2(100),
      RM_ID NUMBER (19,0),
      POOL_ID NUMBER (19,0),
      STATION_ID NVARCHAR2(100),
      RIGHT_ID NUMBER(19,0),
      RULE_ID NUMBER(19,0),
      RULE_CREATE_DATE TIMESTAMP (6),
      RIGHT_CREATE_DATE timestamp(6),
      EPISODE_TITLE NVARCHAR2(1000),
      PROGRAM_ID NVARCHAR2(100),
      HD_TV NVARCHAR2(1),
      CC NVARCHAR2(1),
      SCHEDULE_START_TIME TIMESTAMP (0) WITH TIME ZONE,
      SCHEDULE_END_TIME TIMESTAMP (0) WITH TIME ZONE,
      SCHEDULE_DURATION NUMBER(10,0),
      CONTRACT_ID NUMBER(19,0),
      YEAR_PROGRAM NVARCHAR2(100),
      RL_STATION_OFFSET NUMBER(10,0),
		ADVISORIES	NVARCHAR2(1024),
		REQUEST_RECORD VARCHAR2(1),
		RIGHT_ID_USED_FOR_APPROVAL NUMBER(19,0),
		start_offset_adjustment_flag number(1) default 0,
		end_offset_adjustment_flag number(1) default 0,
		POSTER_IMAGE_NAME	NVARCHAR2(256) ,
     	POSTER_DESCRIPTION NVARCHAR2(1024)
      )';
    CREATEOBJECT(vsql,'create table temp_rec_rules');

    vsql := 'CREATE INDEX '||vschema||'.TRR_RECORDING_ID ON '||vschema||'.TEMP_REC_RULES (RECORDING_ID)';
    CREATEOBJECT(vsql,'create index TRR_RECORDING_ID');

    vsql := 'create table '||vschema||'.temp_old_right_rec_map
      (	recording_id NUMBER,
      schedule_id NUMBER(19,0),
      pool_id NUMBER(19,0),
      rm_id NUMBER(19,0),
      SCHEDULE_START_TIME TIMESTAMP (0) WITH TIME ZONE ,
      SCHEDULE_END_TIME TIMESTAMP (0) WITH TIME ZONE,
      SCHEDULE_DURATION NUMBER(10) ,
      station_id NVARCHAR2(100),
      program_id NVARCHAR2(100),
      hd_tv NVARCHAR2(1),
      cc NVARCHAR2(1),
      repeat  NVARCHAR2(1),
      RM_NAME NVARCHAR2 (64) NOT NULL ,
      RM_IP_ADDRESS NVARCHAR2 (16)  NOT NULL ,
      RM_PORT  NUMBER (10,0)  NOT NULL ,
      episode_title NVARCHAR2(1000),
      STATION_OFFSET NUMBER(10,0),
      headend_location  NVARCHAR2(100),
      contract_id NUMBER(19,0),
      year_program NVARCHAR2(100),
      asset_id  NVARCHAR2 (100)  NOT NULL ,
      title_asset_id NVARCHAR2 (100)  NOT NULL ,
      movie_asset_id  NVARCHAR2 (100)  NOT NULL ,
      PROGRAM_TITLE  NVARCHAR2(1000),
      program_description  NVARCHAR2(2000),
      offset_start_time NUMBER(22,0),
      offset_end_time  NUMBER(22,0),
      recording_mode NVARCHAR2(50),
      priority NUMBER(2,0),
      state NUMBER,
      provider_qa_contact  NVARCHAR2(128),
      catalog_entry  NUMBER(1,0),
      billing_id NVARCHAR2(5),
      mpaa_rating NVARCHAR2(1000),
      tv_rating NVARCHAR2(1000),
      provider_id NVARCHAR2(20),
      provider_name NVARCHAR2(128),
      product NVARCHAR2(20),
      category NVARCHAR2(2000),
      audio_type NVARCHAR2(14),
      max_copies NUMBER(10,0),
      preview_period NUMBER(10,0),
	  licence_start_date TIMESTAMP (9) WITH TIME ZONE,
      license_end_date TIMESTAMP (9) WITH TIME ZONE,
      request_type NUMBER(1,0),
      vod_start_time NUMBER (10,0) ,
      vod_duration NUMBER (10,0) ,
      vod_restrictions NVARCHAR2 (100) ,
      rti_start_time  NUMBER (10,0) ,
      rti_duration NUMBER (10,0) ,
      rti_restrictions NVARCHAR2 (100) ,
      qc_start_time NUMBER (10,0) ,
      qc_duration NUMBER (10,0) ,
      qc_restrictions NVARCHAR2 (100) ,
      created_by NVARCHAR2(50) NOT NULL,
      updated_by NVARCHAR2(50) NOT NULL,
      create_date  TIMESTAMP  NOT NULL ,
      update_date  TIMESTAMP  NOT NULL ,
      toupdate NUMBER(1),
      advisories 	NVARCHAR2(1024),
      REDUNDANCY_COUNT NUMBER(3,0),
      POSTER_IMAGE_NAME	NVARCHAR2(256) ,
      POSTER_DESCRIPTION NVARCHAR2(1024),
      POSTER_ASSET_ID NVARCHAR2 (100) NULL)';
    CREATEOBJECT(vsql,'create table temp_old_right_rec_map');

    vsql := 'CREATE INDEX '||vschema||'.TORRM_RECORDING_ID ON '||vschema||'.temp_old_right_rec_map (RECORDING_ID)';
    CREATEOBJECT(vsql,'create index TORRM_RECORDING_ID');

    vsql := 'CREATE TABLE '||vschema||'.TEMP_RECS_AFTER_RIGHT_DELETION
      (
        SCHEDULE_ID  NUMBER(19,0),
        RECORDING_ID NUMBER(19,0),
        POOL_ID      NUMBER(19,0),
        RM_ID        NUMBER(19,0),
        HEADEND_ID NVARCHAR2(100),
        RM_LINEUP_ID    NUMBER(19,0),
        OLDEST_RIGHT_ID NUMBER(19,0),
        OLDER_RIGHT_ID  NUMBER(19,0),
        TOUPDATE        NUMBER(1),
        ADJUSTED_SCHEDULE_START_TIME TIMESTAMP(0) WITH TIME ZONE,
        ADJUSTED_SCHEDULE_END_TIME TIMESTAMP(0) WITH TIME ZONE)';
    CREATEOBJECT(vsql,'create table TEMP_RECS_AFTER_RIGHT_DELETION');

    vsql := 'CREATE TABLE '||vschema||'.TEMP_OLDEST_RIGHT_RECS
      ( SCHEDULE_ID  NUMBER(19,0),
        RECORDING_ID NUMBER(19,0),
        POOL_ID      NUMBER(19,0),
        RM_ID        NUMBER(19,0),
        HEADEND_ID NVARCHAR2(100),
        RM_LINEUP_ID    NUMBER(19,0),
        OLDEST_RIGHT_ID NUMBER(19,0),
        ADJUSTED_SCHEDULE_START_TIME TIMESTAMP(0) WITH TIME ZONE,
        ADJUSTED_SCHEDULE_END_TIME TIMESTAMP(0) WITH TIME ZONE )';
    CREATEOBJECT(vsql,'create table TEMP_OLDEST_RIGHT_RECS');

    vsql := 'CREATE TABLE '||vschema||'.TEMP_OLDER_RIGHT_RECORDABLES
      ( SCHEDULE_ID NUMBER(19,0),
        RIGHT_ID NUMBER(19,0),
        RM_ID NUMBER (19,0))
        ';
    CREATEOBJECT(vsql,'create table TEMP_OLDER_RIGHT_RECORDABLES');

    vsql := 'create table '||vschema||'.temp_sch_recordable_right_map
      ( schedule_id number(19,0),
        right_id number(19,0))';
    CREATEOBJECT(vsql,'create table temp_sch_recordable_right_map');

    vsql := 'CREATE TABLE '||vschema||'.TEMP_RECORDING_LOG
      ( "RECORDING_LOG_ID" NUMBER(19,0),
        "RECORDING_ID"     NUMBER,
        "SCHEDULE_ID"      NUMBER(19,0),
        "HEADEND_ID" NVARCHAR2(100),
        "POOL_ID" NUMBER(19,0),
        "LOG_MESSAGE" NVARCHAR2(2000),
        SUB_COMPONENT_STATUS NUMBER(19,0),
		SUB_COMPONENT_TYPE 	NVARCHAR2(256),
		SUB_COMPONENT_ID 	NVARCHAR2(256),
        "CREATED_BY" NVARCHAR2(50),
        "UPDATED_BY" NVARCHAR2(50),
        "CREATE_DATE" TIMESTAMP (0) WITH TIME ZONE,
        "UPDATE_DATE" TIMESTAMP (0) WITH TIME ZONE,
        "OLDRECORDINGID" NUMBER(19,0) )';
    CREATEOBJECT(vsql,'create table TEMP_RECORDING_LOG');

    vsql := 'create table '||vschema||'.temp_del_conflicted_recables(right_id number(19,0), schedule_id number(19,0)) ';
    CREATEOBJECT(vsql,'create table temp_del_conflicted_recables');

    vsql := ' create index '||vschema||'.i_sid_del_conflict_recables on '||vschema||'.temp_del_conflicted_recables(schedule_id)  ';
    CREATEOBJECT(vsql,'create index for shedule_id on  temp_del_conflicted_recables');

    vsql := ' CREATE TABLE '||vschema||'.temp_schedule_conflicts
		  (
		  schedule_id NUMBER(19,0),
		  schedule_start_time TIMESTAMP(0) WITH TIME zone,
		  program_title NVARCHAR2(1000),
		  station_call_sign NVARCHAR2(100),
		  rr_flag_change NUMBER(1),
		  duration_change NUMBER(1)
		  ) ';
    CREATEOBJECT(vsql,' CREATE TABLE temp_schedule_conflicts');

    vsql := ' CREATE INDEX '||vschema||'.index_sid_temp_sch_conflicts ON '||vschema||'.temp_schedule_conflicts(schedule_id)  ';
    CREATEOBJECT(vsql,'create index for shedule_id on  temp_schedule_conflicts');


    vsql := 'CREATE TABLE '||vschema||'.ERROR_CODE
    (
     ERROR_CODE NUMBER (5,0)  NOT NULL ,
     DESCRIPTION NVARCHAR2 (250)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT ERROR_CODE_PK PRIMARY KEY ( ERROR_CODE )
    )';
    CREATEOBJECT(vsql,'create TABLE ERROR_CODE');



  vsql := 'CREATE TABLE '||vschema||'.MESSAGE
   (
    UUID VARCHAR2(128 BYTE) NOT NULL ,
	TYPE VARCHAR2(128 BYTE) NOT NULL ,
	MESSAGE CLOB NOT NULL ENABLE,
	DELIVERED VARCHAR2(10 BYTE) NOT NULL ,
	CLASSIFICATION VARCHAR2(10 BYTE),
	CONSTRAINT PK_MESSAGE PRIMARY KEY ("UUID")
   )';
   CREATEOBJECT(vsql, 'create TABLE MESSAGE');



   vsql := 'CREATE TABLE '||vschema||'.X_CATEGORY
  (
	PROGAMID VARCHAR2(20 BYTE),
	CATEGORY VARCHAR2(200 BYTE)
   ) ';
    CREATEOBJECT(vsql,'create table X_CATEGORY');



    vsql := 'CREATE TABLE '||vschema||'.X_DESC(
    PROGRAMID VARCHAR2(20 BYTE),
	DESCRIPTION VARCHAR2(2500 BYTE)
   ) ';
   CREATEOBJECT(vsql,'create table X_DESC');


    vsql := 'CREATE TABLE '||vschema||'.X_LINE(
    CL_ROW_ID VARCHAR2(20 BYTE),
	CL_STATION_NUM VARCHAR2(20 BYTE),
	CL_HEADEND_ID VARCHAR2(20 BYTE),
	CL_TMS_CHAN VARCHAR2(20 BYTE),
	CL_SERVICE_TIER VARCHAR2(20 BYTE),
	CL_EFFECTIVE_DATE VARCHAR2(40 BYTE),
	CL_EXPIRATION_DATE VARCHAR2(40 BYTE)
   ) ';
   CREATEOBJECT(vsql,'create table X_LINE');




  vsql := 'CREATE TABLE '||vschema||'.X_LOCK (
        BLOCK NVARCHAR2(20) NOT NULL ENABLE
   ) ';
   CREATEOBJECT(vsql,'create table X_LOCK');




   vsql := 'CREATE TABLE '||vschema||'.X_PROGRAMME (
    DATABASE_KEY VARCHAR2(20 BYTE),
	LANGUAGE VARCHAR2(2 BYTE),
	TITLE VARCHAR2(500 BYTE),
	REDUCED_TITLE VARCHAR2(500 BYTE),
	ALT_TITLE VARCHAR2(500 BYTE),
	REDUCED_DESC VARCHAR2(2500 BYTE),
	GENRE_DESC1 VARCHAR2(200 BYTE),
	GENRE_DESC2 VARCHAR2(200 BYTE),
	GENRE_DESC3 VARCHAR2(200 BYTE),
	GENRE_DESC4 VARCHAR2(200 BYTE),
	GENRE_DESC5 VARCHAR2(200 BYTE),
	GENRE_DESC6 VARCHAR2(200 BYTE),
	DESC1 VARCHAR2(2500 BYTE),
	ORG_STUDIO VARCHAR2(20 BYTE),
	TIMESHIFT_RESTART VARCHAR2(200 BYTE),
	TIMESHIFT_REPLAY VARCHAR2(200 BYTE),
	EVENT_ID VARCHAR2(200 BYTE),
	EPISODE VARCHAR2(200 BYTE),
	EPISODE_ID VARCHAR2(200 BYTE),
	SEASON_PREMIERE VARCHAR2(200 BYTE),
	"LAST-CHANCE" VARCHAR2(200 BYTE),
	PPV VARCHAR2(200 BYTE),
	DESC2 VARCHAR2(2500 BYTE),
	EPI_TITLE VARCHAR2(2000 BYTE),
	EPI_TITLE2 VARCHAR2(2000 BYTE)
 ) ';
	   CREATEOBJECT(vsql,'create table X_PROGRAMME');



   vsql := 'CREATE TABLE '||vschema||'.X_SCHEDULE (
  	STATION_NUM VARCHAR2(20 BYTE),
	DATABASE_KEY VARCHAR2(20 BYTE),
	LANGUAGE VARCHAR2(20 BYTE),
	AIR_DATE VARCHAR2(40 BYTE),
	DURATION VARCHAR2(20 BYTE),
	CC VARCHAR2(20 BYTE),
	TV_RATING VARCHAR2(20 BYTE)
 ) ';
	CREATEOBJECT(vsql,'create table X_SCHEDULE');


vsql := 'CREATE TABLE '||vschema||'.X_STATION
   (
   STATION_NUM VARCHAR2(20 BYTE),
   STATION_NAME VARCHAR2(200 BYTE),
   STATION_CALL_SIGN VARCHAR2(200 BYTE),
   STATION_AFFIL VARCHAR2(200 BYTE),
   STATION_ORIG VARCHAR2(40 BYTE)
 ) ';
	 CREATEOBJECT(vsql,'create table X_STATION');


vsql := 'CREATE TABLE '||vschema||'.X_SUBTITLE
   (
   PROGRAMID VARCHAR2(20 BYTE),
   SUBTITLE VARCHAR2(2000 BYTE)
   )';
	 CREATEOBJECT(vsql,'create table X_SUBTITLE');


  vsql := 'CREATE TABLE '||vschema||'.TX_ESB_MESSAGES
   				(	MESSAGE_ID VARCHAR2(255 BYTE) NOT NULL ENABLE,
					DATA_COLUMN CLOB NOT NULL ENABLE,
					STATUS_COL VARCHAR2(255 BYTE) NOT NULL ENABLE,
					TIMESTAMP_COL VARCHAR2(255 BYTE))';
  CREATEOBJECT(vsql,'create table TX_ESB_MESSAGES');

    vsql := 'CREATE TABLE '||vschema||'.ALARM_ACTIVITYLOG
    (
      ID          	NUMBER(19,0) NOT NULL,
      TYPE        	NUMBER(2,0) NOT NULL,
      SEVERITY    	NUMBER(2,0) NOT NULL,
      COMPONENT   	NVARCHAR2(64) NOT NULL,
      DESCRIPTION 	NVARCHAR2(2000) NOT NULL,
      REFERENCE_ID	NUMBER(19,0) NULL,
      EVENT_NAME  	NVARCHAR2(100) NULL,
      ACKNOWLEDGED	NUMBER (1, 0) DEFAULT 0  NOT NULL,
      CREATED_BY  	NVARCHAR2(50) NOT NULL,
      UPDATED_BY  	NVARCHAR2(50) NOT NULL,
      CREATE_DATE 	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
      UPDATE_DATE 	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
      ERROR_CODE  	NUMBER(10,0),
      CONSTRAINT PK_ALARM_ACTIVITYLOG PRIMARY KEY(ID),
      CONSTRAINT ALARM_ERR_CODE_FK FOREIGN KEY (ERROR_CODE) REFERENCES '||vschema||'.ERROR_CODE (ERROR_CODE),
      CONSTRAINT FK_ALARM_SELF FOREIGN KEY ( REFERENCE_ID) REFERENCES '||vschema||'.ALARM_ACTIVITYLOG ( ID) )';
    CREATEOBJECT(vsql,'create table ALARM_ACTIVITYLOG');
    CREATESEQ('ALARM_ACTIVITYLOG');

    vsql := 'CREATE INDEX '||vschema||'.IDX_AAL_COMPONENT ON '||vschema||'.ALARM_ACTIVITYLOG(COMPONENT)';
    CREATEOBJECT(vsql,'create INDEX IDX_AAL_COMPONENT');

    vsql := 'CREATE INDEX '||vschema||'.IDX_AAL_EVENTNAME ON '||vschema||'.ALARM_ACTIVITYLOG(EVENT_NAME)';
    CREATEOBJECT(vsql,'create INDEX IDX_AAL_EVENTNAME');

    vsql := 'CREATE INDEX '||vschema||'.IDX_REFERENCE_ID ON '||vschema||'.ALARM_ACTIVITYLOG(REFERENCE_ID)';
    CREATEOBJECT(vsql,'create INDEX IDX_REFERENCE_ID');


    vsql := 'CREATE TABLE '||vschema||'.COPYRIGHT_HOLDER
    (
     COPYRIGHT_HOLDER_ID NUMBER (19,0) NOT NULL ,
     NAME NVARCHAR2 (250)   NOT NULL ,
     COMPANY_NAME NVARCHAR2 (250)  NOT NULL ,
     ADDRESS NVARCHAR2 (250) ,
     CITY NVARCHAR2 (50) ,
     STATE NVARCHAR2 (50) ,
     STATUS NUMBER(1,0) DEFAULT 1 NOT NULL,
     ZIPCODE NVARCHAR2 (50) ,
     COUNTRY NVARCHAR2 (50) ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_COPYRIGHT_HOLDER PRIMARY KEY ( COPYRIGHT_HOLDER_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE COPYRIGHT_HOLDER');
    CREATESEQ('COPYRIGHT_HOLDER');

    vsql := 'CREATE INDEX '||vschema||'.IDX_CH_NAME_STATUS ON '||vschema||'.COPYRIGHT_HOLDER(NAME,STATUS)';
    CREATEOBJECT(vsql,'create INDEX IDX_CH_NAME_STATUS');

    vsql := 'CREATE TABLE '||vschema||'.CONTRACT
    (
     CONTRACT_ID NUMBER(19,0)  NOT NULL ,
     TITLE NVARCHAR2 (500)  NOT NULL ,
     STATUS NUMBER (1,0) DEFAULT 1  NOT NULL ,
     EFFECTIVE_DATE TIMESTAMP (0) WITH TIME ZONE  NOT NULL ,
     EXPIRY_DATE TIMESTAMP (0) WITH TIME ZONE  NOT NULL ,
     NOTES NVARCHAR2 (2000) ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     COPYRIGHT_HOLDER_ID NUMBER(19,0) NOT NULL,
     CONSTRAINT PK_CONTRACT PRIMARY KEY ( CONTRACT_ID ),
     CONSTRAINT FK_CONTRACT_CPYRGHT_HLDR FOREIGN KEY (COPYRIGHT_HOLDER_ID) REFERENCES '||vschema||'.COPYRIGHT_HOLDER(COPYRIGHT_HOLDER_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE CONTRACT');
    CREATESEQ('CONTRACT');

    vsql := 'CREATE INDEX '||vschema||'.IDX_CONTRACT_EFFECT_EXPIRY_DT ON '||vschema||'.CONTRACT(EFFECTIVE_DATE,EXPIRY_DATE)';
    CREATEOBJECT(vsql,'create index IDX_CONTRACT_EFFECT_EXPIRY_DT');

    vsql := 'CREATE TABLE '||vschema||'.CONTRACT_DOCUEMENT
    (
     CONTRACT_DOCUMENT_ID NUMBER (19,0)  NOT NULL ,
     CONTRACT_FILE_NAME NVARCHAR2 (250)  NOT NULL ,
     CONTRACT_FILE BLOB  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     CONTRACT_ID NUMBER(19,0) NOT NULL,
     CONSTRAINT PK_CONTRACT_DOCUMENT PRIMARY KEY ( CONTRACT_DOCUMENT_ID),
     CONSTRAINT FILE_NAME_UNIQUE UNIQUE ( CONTRACT_ID, CONTRACT_FILE_NAME ),
     CONSTRAINT FK_CONTRACT_DOCUMENT_CONTRACT FOREIGN KEY ( CONTRACT_ID) REFERENCES '||vschema||'.CONTRACT ( CONTRACT_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE CONTRACT_DOCUEMENT');

    vsql := 'CREATE SEQUENCE '||vschema||'.CONTRACT_DOCUMENT_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create SEQUENCE CONTRACT_DOCUMENT_SEQ');

    vsql := 'CREATE TABLE '||vschema||'.CONTACT
    (
     CONTACT_ID NUMBER(19,0) NOT NULL ,
     NAME NVARCHAR2 (250)  NOT NULL ,
     OFFICE_PHONE NVARCHAR2 (50) ,
     HOME_PHONE NVARCHAR2 (50) ,
     CELL_PHONE NVARCHAR2 (50) ,
     FAX NVARCHAR2 (50) ,
     EMAIL NVARCHAR2 (50) ,
     NOTES NVARCHAR2 (2000) ,
     PRIMARY_CONTACT NUMBER (1,0) DEFAULT 0 ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     COPYRIGHT_HOLDER_ID NUMBER(19,0),
     CONSTRAINT PK_CONTACT PRIMARY KEY ( CONTACT_ID ),
     CONSTRAINT FK_CONTACT_COPYRIGHT_HOLDER FOREIGN KEY ( COPYRIGHT_HOLDER_ID) REFERENCES '||vschema||'.COPYRIGHT_HOLDER ( COPYRIGHT_HOLDER_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE CONTACT');
    CREATESEQ('CONTACT');

    vsql := 'CREATE INDEX '||vschema||'.IDX_CONTACT_COPYRGHTID ON '||vschema||'.CONTACT(COPYRIGHT_HOLDER_ID)';
    CREATEOBJECT(vsql,'create index IDX_CONTACT_COPYRGHTID ');

    vsql := 'CREATE TABLE '||vschema||'.HEADEND
    (
     HEADEND_ID NVARCHAR2(100) NOT NULL ,
     COMMUNITY_NAME NVARCHAR2 (200) ,
     COUNTY_NAME NVARCHAR2 (200) ,
     COUNTY_SIZE NVARCHAR2 (1) ,
     ST_COUNTY_CODE NVARCHAR2 (100) ,
     STATE NVARCHAR2 (64) ,
     ZIPCODE NVARCHAR2 (100),
     DMA_CODE NVARCHAR2 (100) ,
     DMA_NAME NVARCHAR2 (300) ,
     MSO_CODE NUMBER(22,0) ,
     DMA_RANK NVARCHAR2 (10) ,
     HEADEND_NAME NVARCHAR2 (1000) ,
     HEADEND_LOCATION NVARCHAR2 (100) NOT NULL ,
     MSO_NAME NVARCHAR2 (200) NOT NULL ,
     TIME_ZONE NVARCHAR2 (100) NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_HEADEND PRIMARY KEY ( HEADEND_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE HEADEND');

    vsql := 'CREATE TABLE '||vschema||'.STATION
    (
     STATION_ID NVARCHAR2 (100)  NOT NULL ,
     STATION_NAME NVARCHAR2 (100) ,
     TIME_ZONE NVARCHAR2 (100) ,
     CALL_SIGN NVARCHAR2 (100) NOT NULL ,
     CITY NVARCHAR2 (100) ,
     STATE NVARCHAR2 (100) ,
     ZIPCODE NVARCHAR2 (100) ,
     COUNTRY NVARCHAR2 (100) ,
     DMA_NAME NVARCHAR2 (100) ,
     DMA_NUMBER NVARCHAR2 (100) ,
     FCC_CHANNEL_NUM NVARCHAR2 (100) ,
     AFFILIATION NVARCHAR2 (100) NOT NULL ,
     STATION_LOCKED NVARCHAR2(1) DEFAULT ''N'',
     USER_DATA1 VARCHAR2(1000),
     USER_DATA2 VARCHAR2(1000),
     USER_DATA3 VARCHAR2(1000),
     USER_DATA4 VARCHAR2(1000),
     USER_DATA5 VARCHAR2(1000),
     USER_DATA6 VARCHAR2(1000),
     USER_DATA7 VARCHAR2(1000),
     USER_DATA8 VARCHAR2(1000),
     USER_DATA9 VARCHAR2(1000),
     USER_DATA10 VARCHAR2(1000),
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_STATION PRIMARY KEY ( STATION_ID )
    ) ';
    CREATEOBJECT(vsql,'create table STATION');

    vsql := 'CREATE INDEX '||vschema||'.IDX_STATION_CALLSIGN ON '||vschema||'.STATION(CALL_SIGN)';
    CREATEOBJECT(vsql,'create index IDX_STATION_CALLSIGN');

    vsql := 'CREATE INDEX '||vschema||'.IDX_STATION_STATIONNAME ON '||vschema||'.STATION(STATION_NAME)';
    CREATEOBJECT(vsql,'create index IDX_STATION_STATIONNAME');

    vsql := 'CREATE TABLE '||vschema||'.LINEUP
    (
     LINEUP_ID NUMBER(19,0) NOT NULL ,
     DEVICE NVARCHAR2 (2) ,
     TMS_CHANNEL NVARCHAR2 (20) NOT NULL ,
     SERVICE_TIER NVARCHAR2 (1) NOT NULL ,
     EFFECTIVE_DATE TIMESTAMP(0) WITH TIME ZONE ,
     EXPIRATION_DATE TIMESTAMP(0) WITH TIME ZONE ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     HEADEND_ID NVARCHAR2(100) NOT NULL ,
     STATION_ID NVARCHAR2 (100)  NOT NULL,
     CONSTRAINT PK_LINEUP PRIMARY KEY ( LINEUP_ID, HEADEND_ID, STATION_ID ),
     CONSTRAINT FK_LINEUP_STATION FOREIGN KEY (STATION_ID) REFERENCES '||vschema||'.STATION(STATION_ID),
     CONSTRAINT FK_HEADEND_LINEUP FOREIGN KEY ( HEADEND_ID) REFERENCES '||vschema||'.HEADEND ( HEADEND_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE LINEUP');

    vsql := 'CREATE INDEX '||vschema||'.IDX_L_STATIONID_HEADENDID ON '||vschema||'.LINEUP(STATION_ID,HEADEND_ID)';
    CREATEOBJECT(vsql,'create INDEX IDX_L_STATIONID_HEADENDID');

    vsql := 'CREATE TABLE '||vschema||'.RM
    (
     RM_ID NUMBER (19,0)  NOT NULL ,
     PARENT_RM_ID NUMBER(19,0) DEFAULT NULL,
     NAME NVARCHAR2 (64) NOT NULL ,
     IP_ADDRESS NVARCHAR2 (16)  NOT NULL ,
     PORT NUMBER (10, 0)  NOT NULL ,
     BACK_OFFICE_IP_ADDRESS NVARCHAR2(16)  NOT NULL ,
     BACK_OFFICE_PORT NUMBER (5, 0)  NOT NULL ,
     EXPORT_ATTEMPTS NUMBER (2, 0)  NOT NULL ,
     EXPORT_ATTEMPTS_INTERVAL NUMBER(10, 0)  NOT NULL ,
     OPERATIONAL_STATE NUMBER (1,0) DEFAULT 0  NOT NULL ,
     REQUESTED_STATE NUMBER (1,0) DEFAULT 0 ,
     IS_DELETED NUMBER (1,0) DEFAULT 0 ,
     PRE_PROVISIONING_INTERVAL NUMBER (5, 0) DEFAULT 0 NOT NULL ,
     START_BLACK_OUT NUMBER (5, 0) DEFAULT 0 NOT NULL ,
     STOP_BLACK_OUT NUMBER (5, 0) DEFAULT 0 NOT NULL ,
     STOP_SUPPORTED NUMBER (1,0) DEFAULT 0 NOT NULL ,
     PACKAGER_URL NVARCHAR2 (250) ,
     RM_TYPE NVARCHAR2 (50)  NOT NULL ,
     VERSION		NVARCHAR2(50),
     SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     HEADEND_ID NVARCHAR2(100) NOT NULL,
     CONSTRAINT PK_RTM PRIMARY KEY ( RM_ID ),
     CONSTRAINT FK_RM_HE FOREIGN KEY (HEADEND_ID) REFERENCES '||vschema||'.HEADEND(HEADEND_ID),
     CONSTRAINT FK_PA_RM FOREIGN KEY (PARENT_RM_ID) REFERENCES '||vschema||'.RM(RM_ID)
    )';
    CREATEOBJECT(vsql,'create table RM');
    CREATESEQ('RM');
   
    vsql := 'CREATE INDEX '||vschema||'.IDX_RM_HEADENDID ON '||vschema||'.RM(HEADEND_ID)';
    CREATEOBJECT(vsql,'create INDEX IDX_RM_HEADENDID');

    vsql := 'CREATE TABLE '||vschema||'.MAINTENANCE_WINDOW
    (
     MAINTENANCE_WINDOW_ID NUMBER (19,0)  NOT NULL ,
     START_TIME TIMESTAMP(0) WITH TIME ZONE NOT NULL,
     DURATION NUMBER (19,0)  NOT NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     RM_ID NUMBER (19,0) ,
     CONSTRAINT PK_MAINTENANCE_WINDOW PRIMARY KEY ( MAINTENANCE_WINDOW_ID ),
     CONSTRAINT FK_MW_RM FOREIGN KEY (RM_ID) REFERENCES '||vschema||'.RM(RM_ID)
    )';
    CREATEOBJECT(vsql,'create table MAINTENANCE_WINDOW');
    CREATESEQ('MAINTENANCE_WINDOW');

    vsql := 'CREATE INDEX '||vschema||'.IDX_MW_RMID ON '||vschema||'.MAINTENANCE_WINDOW(RM_ID)';
    CREATEOBJECT(vsql,'create INDEX IDX_MW_RMID');

    vsql := 'CREATE TABLE '||vschema||'.RIGHT
    (
     RIGHT_ID NUMBER (19,0)  NOT NULL ,
     STATE NUMBER (1, 0) DEFAULT 1  NOT NULL ,
     NAME NVARCHAR2 (250)  NOT NULL ,
     START_DATE  TIMESTAMP(0) WITH TIME ZONE ,
     END_DATE  TIMESTAMP(0) WITH TIME ZONE ,
     START_TIME INTERVAL DAY TO SECOND(0),
     END_TIME INTERVAL DAY TO SECOND(0),
     DAY_OF_WEEK NVARCHAR2 (100) ,
     AUTO_APPROVE NUMBER (1, 0) DEFAULT 0  NOT NULL ,
     REPEAT NVARCHAR2(1)  ,
     HD  NVARCHAR2(1) ,
     LIVE  NVARCHAR2(100) ,
     RECORDING_MODE NVARCHAR2 (50)  NOT NULL ,
     OFFSET_START_TIME NUMBER(22,0) ,
     OFFSET_END_TIME NUMBER(22,0) ,
     PRIORITY NUMBER (2, 0)  NOT NULL ,
     PROVIDER_QA_CONTACT NVARCHAR2 (128) ,
     CATALOG_ENTRY NUMBER (1, 0) DEFAULT 0  NOT NULL ,
     BILLING_ID NVARCHAR2 (5) DEFAULT ''0''  NOT NULL ,
     MPAA_RATING NVARCHAR2 (1000)  NOT NULL ,
     TV_RATING NVARCHAR2 (1000)  NOT NULL ,
     PROVIDER_ID NVARCHAR2 (20)  NOT NULL ,
     PROVIDER_NAME NVARCHAR2 (128)  NOT NULL,
     PRODUCT NVARCHAR2 (20)  NOT NULL ,
     CATEGORY NVARCHAR2 (2000)  NOT NULL ,
     AUDIO_TYPE NVARCHAR2 (14) NOT NULL ,
     MAX_COPIES NUMBER (10, 0),
     PREVIEW_PERIOD NUMBER(10, 0),
	 LICENSE_RELATIVE_START NUMBER(19,0) NOT NULL,
     LICENSE_RELATIVE_DURATION NUMBER(19,0) NOT NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     CONTRACT_ID NUMBER(19,0) NOT NULL,
     DYNEXPR VARCHAR2(4000),
     CONSTRAINT PK_RIGHT PRIMARY KEY ( RIGHT_ID ),
     CONSTRAINT FK_RIGHT_CONTRACT FOREIGN KEY ( CONTRACT_ID) REFERENCES '||vschema||'.CONTRACT ( CONTRACT_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE RIGHT');
    CREATESEQ('RIGHT');

    vsql := 'CREATE INDEX '||vschema||'.IDX_R_STARTDT_ENDDT ON '||vschema||'.RIGHT(START_DATE,END_DATE)';
    CREATEOBJECT(vsql,'create INDEX IDX_R_STARTDT_ENDDT');

    vsql := 'CREATE INDEX '||vschema||'.IDX_R_AUTOAPPROVE ON '||vschema||'.RIGHT(AUTO_APPROVE)';
    CREATEOBJECT(vsql,'create INDEX IDX_R_AUTOAPPROVE');

    vsql := 'CREATE TABLE '||vschema||'.RIGHT_RM_MAP
    (
     RIGHT_ID NUMBER(19,0)  NOT NULL ,
     RM_ID NUMBER(19,0)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_RIGHT_RM_MAP PRIMARY KEY ( RIGHT_ID, RM_ID),
     CONSTRAINT FK_RIGHT_RM_MAP_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID),
     CONSTRAINT FK_RIGHT_RM_MAP_RIGHT FOREIGN KEY ( RIGHT_ID) REFERENCES '||vschema||'.RIGHT ( RIGHT_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE RIGHT_RM_MAP');

    vsql := 'CREATE TABLE '||vschema||'.RIGHT_EXCLUDED_RM_MAP
    (
     RIGHT_ID NUMBER(19,0)  NOT NULL ,
     RM_ID NUMBER(19,0)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_RIGHT_EXCLUDED_RM_MAP PRIMARY KEY ( RIGHT_ID, RM_ID ),
     CONSTRAINT FK_RIGHT_EXCLUDED_RM_MAP_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID),
     CONSTRAINT FK_RIGHT_EXCL_RM_MAP_RIGHT FOREIGN KEY ( RIGHT_ID) REFERENCES '||vschema||'.RIGHT ( RIGHT_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE RIGHT_EXCLUDED_RM_MAP');

    vsql := 'CREATE TABLE '||vschema||'.PROGRAM
    (
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL ,
     LANGUAGE NVARCHAR2 (100) NOT NULL ,
     TITLE NVARCHAR2 (1000) NOT NULL ,
     REDUCED_TITLE1 NVARCHAR2 (1000) NOT NULL ,
     REDUCED_TITLE2 NVARCHAR2 (1000) ,
     REDUCED_TITLE3 NVARCHAR2 (1000) ,
     REDUCED_TITLE4 NVARCHAR2 (1000) ,
     ALT_TITLE NVARCHAR2 (1000) ,
     REDUCED_DESCRIPTION1 NVARCHAR2 (1000) ,
     REDUCED_DESCRIPTION2 NVARCHAR2 (1000) ,
     REDUCED_DESCRIPTION3 NVARCHAR2 (1000) ,
     REDUCED_DESCRIPTION4 NVARCHAR2 (1000) ,
     ADVISORY_DESC1 NVARCHAR2 (100) ,
     ADVISORY_DESC2 NVARCHAR2 (100) ,
     ADVISORY_DESC3 NVARCHAR2 (100) ,
     ADVISORY_DESC4 NVARCHAR2 (100) ,
     ADVISORY_DESC5 NVARCHAR2 (100) ,
     ADVISORY_DESC6 NVARCHAR2 (100) ,
     GENRE_DESC1 NVARCHAR2 (100) ,
     GENRE_DESC2 NVARCHAR2 (100) ,
     GENRE_DESC3 NVARCHAR2 (100) ,
     GENRE_DESC4 NVARCHAR2 (100) ,
     GENRE_DESC5 NVARCHAR2 (100) ,
     GENRE_DESC6 NVARCHAR2 (100) ,
     DESCRIPTION1 NVARCHAR2 (2000) NOT NULL ,
     DESCRIPTION2 NVARCHAR2 (2000) ,
     YEAR_PROGRAM NVARCHAR2 (100) ,
     MPAA_RATING NVARCHAR2 (1000) ,
     STAR_RATING NVARCHAR2 (1000) ,
     RUN_TIME VARCHAR2 (100) ,
     COLOR_CODE NVARCHAR2 (100) ,
     PROGRAM_LANGUAGE NVARCHAR2 (100) ,
     COUNTRY_OF_ORIGIN NVARCHAR2 (100) ,
     MADE_FOR_TV NVARCHAR2 (1) ,
     SOURCE_TYPE NVARCHAR2 (100) ,
     SHOW_TYPE NVARCHAR2 (200) ,
     HOLIDAY NVARCHAR2 (100) ,
     SYNDICATE_EPISODE_NUM NVARCHAR2 (100) ,
     ALT_SYNDICATE_EPI_NUM NVARCHAR2 (100) ,
     EPISODE_TITLE NVARCHAR2 (1000) ,
     NET_SYN_SOURCE NVARCHAR2 (100) ,
     NET_SYN_TYPE NVARCHAR2 (100) ,
     ORG_STUDIO NVARCHAR2 (100) NOT NULL ,
     GAME_DATETIME TIMESTAMP(0) WITH TIME ZONE ,
     GAME_TIMEZONE NVARCHAR2 (100) ,
     ORG_AIR_DATE TIMESTAMP(0)  WITH TIME ZONE,
     UNIQUE_ID NVARCHAR2 (100) ,
     USER_DATA1 VARCHAR2(1000),
     USER_DATA2 VARCHAR2(1000),
     USER_DATA3 VARCHAR2(1000),
     USER_DATA4 VARCHAR2(1000),
     USER_DATA5 VARCHAR2(1000),
     USER_DATA6 VARCHAR2(1000),
     USER_DATA7 VARCHAR2(1000),
     USER_DATA8 VARCHAR2(1000),
     USER_DATA9 VARCHAR2(1000),
     USER_DATA10 VARCHAR2(1000),
     USER_DATA11 VARCHAR2(1000),
     USER_DATA12 VARCHAR2(1000),
     USER_DATA13 VARCHAR2(1000),
     PROGRAM_GENERIC XMLTYPE,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_PROGRAM PRIMARY KEY ( PROGRAM_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE PROGRAM');

    vsql := 'CREATE TABLE '||vschema||'.CONFIG_SETTING
    (
     KEY NVARCHAR2 (1024)  NOT NULL ,
     VALUE NVARCHAR2 (2000) ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_CONFIG_SETTING PRIMARY KEY ( KEY )
    )';
    CREATEOBJECT(vsql,'create TABLE CONFIG_SETTING');

    vsql := 'CREATE TABLE '||vschema||'.RM_LINEUP
    (
     RM_ID NUMBER(19,0)  NOT NULL ,
     STATION_ID NVARCHAR2 (100)  NOT NULL ,
     HEADEND_ID NVARCHAR2(100) NOT NULL ,
     LINEUP_ID NUMBER(19,0)  NOT NULL ,
     MULTICAST_IP_ADDRESS NVARCHAR2 (100)  NOT NULL ,
     MULTICAST_PORT NUMBER (5,0)  NOT NULL ,
     OFFSET NUMBER (10,0) DEFAULT 0  NOT NULL ,
     SD_MIN_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL ,
     SD_MAX_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL ,
     HD_MIN_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL ,
     HD_MAX_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL ,
     CHANNEL_NUMBER NUMBER (10,0),
     LOCATION NVARCHAR2(32) ,
	 MEDIATYPE NVARCHAR2(200),
     MANIFESTNAME NVARCHAR2(200),
     PUBLISHPOINT NVARCHAR2(200),
     SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_RM_LINEUP PRIMARY KEY ( RM_ID, STATION_ID, HEADEND_ID ),
     CONSTRAINT FK_RM_LINEUP_LINEUP FOREIGN KEY ( LINEUP_ID,HEADEND_ID,STATION_ID) REFERENCES '||vschema||'.LINEUP ( LINEUP_ID,HEADEND_ID,STATION_ID),
     CONSTRAINT FK_RM_LINEUP_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE RM_LINEUP');

    vsql := 'CREATE TABLE '||vschema||'.ADI_XML_SITE
    (
     ADI_XML_SITE_ID NUMBER (19,0) NOT NULL ,
     NAME NVARCHAR2 (100)  NOT NULL ,
     URL NVARCHAR2 (1000)  NOT NULL ,
     SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     RM_ID NUMBER(19,0)  NOT NULL,
     CONSTRAINT ADI_XML_SITE_PK PRIMARY KEY ( ADI_XML_SITE_ID ),
     CONSTRAINT XML_SITE_NAME_UNIQUE UNIQUE(RM_ID,NAME),
     CONSTRAINT ADI_XML_SITE_RM_FK FOREIGN KEY (RM_ID) REFERENCES '||vschema||'.RM(RM_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE ADI_XML_SITE');
    CREATESEQ('ADI_XML_SITE');

    vsql := 'CREATE TABLE '||vschema||'.SCHEDULE
    (
     SCHEDULE_ID NUMBER(19,0) NOT NULL ,
     SCHEDULE_LANGUAGE NVARCHAR2 (100) NOT NULL ,
     STATION_ID NVARCHAR2 (100)  NOT NULL ,
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL ,
     START_TIME TIMESTAMP (0) WITH TIME ZONE  NOT NULL ,
     END_TIME TIMESTAMP (0) WITH TIME ZONE ,
     DURATION NUMBER (10,0) NOT NULL ,
     DAY_OF_WEEK AS (trim((to_char(start_time,''DAY'')))),
     RECORDABLE NUMBER (1,0) DEFAULT 0 ,
     TV_RATING NVARCHAR2 (1000) ,
     HD_TV NVARCHAR2 (1) ,
     PART_NUMBER NUMBER (10,0) ,
     NO_OF_PARTS NUMBER (10,0) ,
     CC NVARCHAR2 (1) NOT NULL ,
     STEREO NVARCHAR2 (1) ,
     LIVE_TAPE_DELAY NVARCHAR2 (100) ,
     SUBTITLED NVARCHAR2 (1) ,
     PREMIERE_FINALE NVARCHAR2 (100) ,
     JOINED_IN_PROGRESS NVARCHAR2 (1) ,
     CABLE_IN_CLASSROOM NVARCHAR2 (1) ,
     SAP NVARCHAR2 (1) ,
     SEX_RATING NVARCHAR2 (1) ,
     VIOLENCE_RATING NVARCHAR2 (1) ,
     LANGUAGE_RATING NVARCHAR2 (1) ,
     DIALOG_RATING NVARCHAR2 (1) ,
     FV_RATING NVARCHAR2 (1) ,
     ENHANCED NVARCHAR2 (1) ,
     THREE_D NVARCHAR2 (1) ,
     LETTERBOX NVARCHAR2 (1) ,
     DVS NVARCHAR2 (1) ,
     SERIES_LINK XMLTYPE,
     REPEAT NVARCHAR2 (1) ,
     BLACKOUT NVARCHAR2 (1) ,
     DOLBY NVARCHAR2 (100) ,
     REQUEST_RECORD VARCHAR2(1),
  	 USER_DATA1 VARCHAR2(1000),
     USER_DATA2 VARCHAR2(1000),
     USER_DATA3 VARCHAR2(1000),
     USER_DATA4 VARCHAR2(1000),
     USER_DATA5 VARCHAR2(1000),
     USER_DATA6 VARCHAR2(1000),
     USER_DATA7 VARCHAR2(1000),
     USER_DATA8 VARCHAR2(1000),
     USER_DATA9 VARCHAR2(1000),
     USER_DATA10 VARCHAR2(1000),
     USER_DATA11 VARCHAR2(1000),
     SCHEDULE_GENERIC XMLTYPE,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_SCHEDULE PRIMARY KEY ( SCHEDULE_ID ),
     CONSTRAINT FK_STATION_SCHEDULE FOREIGN KEY ( STATION_ID) REFERENCES '||vschema||'.STATION ( STATION_ID),
     CONSTRAINT FK_SCHEDULE_PROGRAM FOREIGN KEY ( PROGRAM_ID) REFERENCES '||vschema||'.PROGRAM ( PROGRAM_ID)
    ) ';
    CREATEOBJECT(vsql,'create table SCHEDULE');
    CREATESEQ('SCHEDULE');

    vsql := 'COMMENT ON COLUMN '||vschema||'.SCHEDULE.DURATION IS ''Duration in seconds''';
    CREATEOBJECT(vsql,'create table COMMENT ON COLUMN SCHEDULE.DURATION ');

    vsql := 'CREATE UNIQUE INDEX '||vschema||'.IDX_SCHED_UNIQ_IND ON '||vschema||'.SCHEDULE (PROGRAM_ID,STATION_ID,START_TIME)';
    CREATEOBJECT(vsql,'create index IDX_SCHED_UNIQ_IND');

    vsql := 'CREATE INDEX '||vschema||'.IDX_SCHED_START_END_TIME ON '||vschema||'.SCHEDULE (START_TIME,END_TIME)';
    CREATEOBJECT(vsql,'create index IDX_SCHED_START_END_TIME');

    vsql := 'CREATE INDEX '||vschema||'.IDX_SCH_STATION_ID ON '||vschema||'.SCHEDULE(STATION_ID)';
    CREATEOBJECT(VSQL,'create index IDX_SCH_STATION_ID');


       vsql := 'CREATE TABLE '||vschema||'.RTC_POOL
    (
     POOL_ID NUMBER(19,0) NOT NULL ,
     NAME NVARCHAR2 (50) ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     RM_ID NUMBER(19,0) NOT NULL,
     CONSTRAINT PK_RTC_POOL PRIMARY KEY ( POOL_ID ),
     CONSTRAINT FK_RTC_POOL_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID)
    )';
    CREATEOBJECT(vsql,'create table rtc_pool');
    CREATESEQ('RTC_POOL');

	vsql := 'CREATE INDEX '||vschema||'.IDX_RTCPOOL_RMID ON '||vschema||'.RTC_POOL(RM_ID)';
    CREATEOBJECT(vsql,'create index IDX_RTCPOOL_RMID');

    vsql := 'CREATE TABLE '||vschema||'.RECORDING
    (
     RECORDING_ID NUMBER(19,0) NOT NULL ,
     PROGRAM_TITLE NVARCHAR2 (1000) ,
     PROGRAM_DESCRIPTION NVARCHAR2 (2000) ,
     OFFSET_START_TIME NUMBER(22,0) ,
     OFFSET_END_TIME NUMBER(22,0) ,
     RECORDING_MODE NVARCHAR2 (50) ,
     PRIORITY NUMBER (2,0) ,
     PROVIDER_QA_CONTACT NVARCHAR2 (128) ,
     CATALOG_ENTRY NUMBER (1,0) ,
     BILLING_ID NVARCHAR2 (5)  NOT NULL ,
     MPAA_RATING NVARCHAR2 (1000)  NOT NULL ,
     TV_RATING NVARCHAR2 (1000)  NOT NULL ,
     PROVIDER_ID NVARCHAR2 (20)  NOT NULL ,
     PROVIDER_NAME NVARCHAR2 (128)  NOT NULL ,
     PRODUCT NVARCHAR2 (20)  NOT NULL ,
     CATEGORY NVARCHAR2 (2000)  NOT NULL ,
     STATUS NUMBER(2,0) DEFAULT 3 NOT NULL ,
     AUDIO_TYPE NVARCHAR2 (14)  NOT NULL ,
     MAX_COPIES NUMBER (10,0) ,
     PREVIEW_PERIOD NUMBER(10,0),
	 REDUNDANCY_COUNT NUMBER(3,0),
     LICENCE_START_DATE TIMESTAMP (0) WITH TIME ZONE ,
     LICENSE_END_DATE TIMESTAMP (0) WITH TIME ZONE  NOT NULL ,
     APPROVAL_TYPE NVARCHAR2(100) DEFAULT ''AUTO'' NOT NULL,
     SCHEDULE_ID NUMBER(19,0) NOT NULL,
	 POOL_ID NUMBER(19,0) NOT NULL ,
	 ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     TITLE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     MOVIE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     POSTER_ASSET_ID NVARCHAR2 (100) NULL ,
     STATUS_CODE      	NUMBER(10,0) NOT NULL,
     CONTENT_URL		NVARCHAR2(1024) ,
     ADJUSTED_START_TIME TIMESTAMP (0) WITH TIME ZONE NOT NULL ,
     ADJUSTED_END_TIME TIMESTAMP (0) WITH TIME ZONE NOT NULL,
     POSTER_IMAGE_NAME	NVARCHAR2(256) NULL,
     POSTER_DESCRIPTION NVARCHAR2(1024) NULL,
     WARNING NUMBER(1,0) DEFAULT 0,
 	 CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     CONSTRAINT PK_RECORDING PRIMARY KEY ( RECORDING_ID ),
     CONSTRAINT RECORDING_UK0 UNIQUE ( SCHEDULE_ID, POOL_ID ),
     CONSTRAINT FK_RECORDING_SCHEDULE FOREIGN KEY ( SCHEDULE_ID) REFERENCES '||vschema||'.SCHEDULE ( SCHEDULE_ID),
     CONSTRAINT FK_RECORDING_POOL_ID FOREIGN KEY (POOL_ID) REFERENCES '||vschema||'.RTC_POOL (POOL_ID)
    ) ';
    CREATEOBJECT(vsql,'create TABLE RECORDING');
    CREATESEQ('RECORDING');
           
    vsql := 'CREATE TABLE '||vschema||'.HA_RM_REC_STATUS
  	(
	 RECORDING_ID NUMBER(19,0) NOT NULL ,
	 RM_ID        NUMBER(19,0) NOT NULL,
	 STATUS       NUMBER(2,0) DEFAULT 3 NOT NULL ENABLE,
	 STATUS_CODE  NUMBER(10,0) NOT NULL,
	 CONTENT_URL NVARCHAR2(1024),
	 WARNING NUMBER(1,0) DEFAULT 0,
	 CONSTRAINT PK_TEMP_HA_RM_REC PRIMARY KEY (RECORDING_ID,RM_ID)
	)';
	CREATEOBJECT(vsql,'create TABLE HA_RM_REC_STATUS');

    vsql := 'CREATE TABLE '||vschema||'.TEMP_SS_REC
    (
     RECORDING_ID NUMBER(19,0) NOT NULL ,
     POOL_ID NUMBER(19,0) NOT NULL,
	 RM_ID NUMBER(19,0) NOT NULL,
     STATUS NUMBER(2,0) DEFAULT 3 NOT NULL,
     STATUS_CODE      	NUMBER(10,0) NOT NULL,
     CONTENT_URL		NVARCHAR2(1024),
     WARNING			NUMBER(1,0) DEFAULT 0,
     CONSTRAINT PK_TEMP_SS_REC PRIMARY KEY ( RECORDING_ID,POOL_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE TEMP_SS_REC');



    vsql := 'CREATE TABLE '||vschema||'.RTC
    (
     RTC_ID NUMBER (19,0)  NOT NULL ,
     NAME NVARCHAR2 (64)  NOT NULL ,
     IP_ADDRESS NVARCHAR2 (16)  NOT NULL ,
     PORT NUMBER (10,0)  NOT NULL ,
     CAPACITY NUMBER (3,0) DEFAULT 50 NOT NULL ,
     MAXIMUM_BAND_WIDTH NUMBER (10,0) ,
     MAXIMUM_STORAGE NUMBER (10,0) ,
     OPERATIONAL_STATE NUMBER (1,0) DEFAULT 0  NOT NULL ,
     REQUESTED_STATE NUMBER (1,0) DEFAULT 0  NOT NULL ,
     SERVICE_NAME NVARCHAR2 (500)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     POOL_ID NUMBER(19,0) NOT NULL,
     USER_ID NVARCHAR2(256),
     PASSWORD NVARCHAR2(1024),
     DOMAIN NVARCHAR2(256),
     HOST_IP_ADDRESS NVARCHAR2(16),
     VERSION		NVARCHAR2(50),
     SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL,
     CONSTRAINT PK_RTC PRIMARY KEY ( RTC_ID ),
     CONSTRAINT RTC_NAME_UNIQUE UNIQUE( POOL_ID , NAME),
     CONSTRAINT FK_RTC_RTC_POOL FOREIGN KEY ( POOL_ID) REFERENCES '||vschema||'.RTC_POOL ( POOL_ID)
    )';
    CREATEOBJECT(vsql,'create table RTC');
    CREATESEQ('RTC');

    vsql := 'CREATE TABLE '||vschema||'.EPG_PROVIDER_CONFIG
    (
     EPG_PROVIDER_ID NUMBER (19,0) NOT NULL ,
     NAME NVARCHAR2 (250)  UNIQUE NOT NULL ,
     PATH NVARCHAR2 (250)  NOT NULL ,
     EPG_READ_FREQUENCY NUMBER(10,0) NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_EPG_PROVIDER_CONFIG PRIMARY KEY ( EPG_PROVIDER_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE EPG_PROVIDER_CONFIG ');
    CREATESEQ('EPG_PROVIDER_CONFIG');

    vsql := 'CREATE TABLE '||vschema||'.CAST_CREDITS
    (
     CAST_CREDITS_ID NUMBER (19,0) NOT NULL ,
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL ,
     FIRST_NAME NVARCHAR2 (100) ,
     LAST_NAME NVARCHAR2 (100) ,
     DESCRIPTION NVARCHAR2 (100) ,
     TYPE NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_CAST_CREDITS PRIMARY KEY ( CAST_CREDITS_ID ),
     CONSTRAINT FK_PROGRAM_CAST_CREW FOREIGN KEY ( PROGRAM_ID) REFERENCES '||vschema||'.PROGRAM ( PROGRAM_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE CAST_CREDITS ');
    CREATESEQ('CAST_CREDITS');

    vsql := 'CREATE INDEX '||vschema||'.IDX_CC_PROGRAMID ON '||vschema||'.CAST_CREDITS(PROGRAM_ID)';
    CREATEOBJECT(vsql,'create INDEX IDX_CC_PROGRAMID');

    vsql := 'CREATE TABLE '||vschema||'.RIGHT_PROGRAM_MAP
    (
     RIGHT_ID NUMBER(19,0) NOT NULL ,
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT RIGHT_PROGRAM_MAPPING_PK PRIMARY KEY ( PROGRAM_ID, RIGHT_ID ),
     CONSTRAINT RIGHT_PRG_MAP_RIGHT_FK FOREIGN KEY ( RIGHT_ID) REFERENCES '||vschema||'.RIGHT ( RIGHT_ID),
     CONSTRAINT RIGHT_PRG_MAP_PRG_FK FOREIGN KEY ( PROGRAM_ID) REFERENCES '||vschema||'.PROGRAM ( PROGRAM_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE RIGHT_PROGRAM_MAP');

    vsql := 'CREATE TABLE '||vschema||'.ENTITY_MAPPING
        (
          MAPPING_ID NUMBER(19,0) NOT NULL,
          NAME NVARCHAR2(2000) NOT NULL,
          TABLE_NAME NVARCHAR2(2000) NOT NULL,
          COLUMN_NAME NVARCHAR2(2000) NOT NULL,
          GENERIC_NAME NVARCHAR2(2000),
          ASSET_TYPE NUMBER(2, 0),
          TYPE NUMBER(2, 0) NOT NULL,
          CONSTRAINT PK_ENTITY_MAPPING PRIMARY KEY ( MAPPING_ID )
        )';
    CREATEOBJECT(vsql,'create TABLE ENTITY_MAPPING');
    CREATESEQ('ENTITY_MAPPING');

    vsql := 'CREATE TABLE '||vschema||'.TRIAL_USE_DEFINITION
        (
          TRIAL_USE_FIELD_ID NUMBER(19,0) NOT NULL,
          ASSET_TYPE NUMBER(2, 0) NOT NULL,
          NAME NVARCHAR2(2000) NOT NULL,
          VALUE_TYPE NUMBER(2, 0) NOT NULL,
          VALUE NVARCHAR2(2000),
          MAPPING_ID NUMBER(19,0),
          DESCRIPTION NVARCHAR2(2000) NOT NULL,
          CREATED_BY NVARCHAR2(50),
          UPDATED_BY NVARCHAR2(50),
          CREATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
          UPDATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
          CONSTRAINT PK_TRIAL_USE_DEFINITION PRIMARY KEY ( TRIAL_USE_FIELD_ID ),
          CONSTRAINT TRIAL_USE_DEFINITION_UK0 UNIQUE ( DESCRIPTION ),
          CONSTRAINT TRIAL_USE_DEF_ENTITY_MAP_FK1 FOREIGN KEY (MAPPING_ID) REFERENCES '||vschema||'.ENTITY_MAPPING (MAPPING_ID)
        )';
    CREATEOBJECT(vsql,'create TABLE TRIAL_USE_DEFINITION');

    vsql := 'CREATE SEQUENCE '||vschema||'.TRIAL_USE_FIELD_DEF_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create SEQUENCE TRIAL_USE_FIELD_DEF_SEQ');

    vsql := 'CREATE TABLE '||vschema||'.REC_TRIAL_USE_FIELDS
      (
        TRIAL_USE_FIELD_ID NUMBER(19,0) NOT NULL,
        ASSET_TYPE NUMBER(2, 0) NOT NULL,
        NAME NVARCHAR2(2000) NOT NULL,
        VALUE_TYPE NUMBER(2, 0) NOT NULL,
        VALUE NVARCHAR2(2000),
        MAPPING_ID NUMBER(19,0),
        RECORDING_ID NUMBER(19,0) NOT NULL,
        DESCRIPTION NVARCHAR2(2000) NOT NULL,
        CREATED_BY NVARCHAR2(50),
        UPDATED_BY NVARCHAR2(50),
        CREATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
        UPDATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
        CONSTRAINT PK_REC_TRIAL_USE_FIELDS PRIMARY KEY ( TRIAL_USE_FIELD_ID ),
        CONSTRAINT REC_TRIAL_USE_ENTITY_MAP_FK1 FOREIGN KEY (MAPPING_ID) REFERENCES '||vschema||'.ENTITY_MAPPING (MAPPING_ID),
        CONSTRAINT REC_TRIAL_USE_RECORDING_FK FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING(RECORDING_ID)
      )  ';
    CREATEOBJECT(vsql,'create TABLE REC_TRIAL_USE_FIELDS');

    vsql := 'CREATE SEQUENCE '||vschema||'.REC_TRIAL_USE_FIELD_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create SEQUENCE REC_TRIAL_USE_FIELD_SEQ');
	
	vsql := 'create index '||vschema||'.rec_tuf_rec_id_idx on '||vschema||'.rec_trial_use_fields(recording_id)';
	CREATEOBJECT(vsql,vsql);

	

    vsql := 'CREATE TABLE '||vschema||'.RIGHT_TRIAL_USE_FIELDS
        (
          TRIAL_USE_FIELD_ID NUMBER(19,0) NOT NULL,
          ASSET_TYPE NUMBER(2, 0) NOT NULL,
          NAME NVARCHAR2(2000) NOT NULL,
          VALUE_TYPE NUMBER(2, 0) NOT NULL,
          VALUE NVARCHAR2(2000),
          MAPPING_ID NUMBER(19,0),
          RIGHT_ID NUMBER(19,0) NOT NULL,
          DESCRIPTION NVARCHAR2(2000) NOT NULL,
          CREATED_BY NVARCHAR2(50),
          UPDATED_BY NVARCHAR2(50),
          CREATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
          UPDATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
          CONSTRAINT PK_RIGHT_TRIAL_USE_FIELDS PRIMARY KEY ( TRIAL_USE_FIELD_ID ),
          CONSTRAINT RIGHT_TRIAL_USE_FIELDS_UK0 UNIQUE ( RIGHT_ID, DESCRIPTION ),
          CONSTRAINT RIGHT_TRIAL_USE_ENTITY_MAP_FK1 FOREIGN KEY (MAPPING_ID) REFERENCES '||vschema||'.ENTITY_MAPPING (MAPPING_ID)
        )';
    CREATEOBJECT(vsql,'create TABLE RIGHT_TRIAL_USE_FIELDS');

    vsql := 'CREATE SEQUENCE '||vschema||'.RIGHT_TRIAL_USE_FIELD_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create SEQUENCE RIGHT_TRIAL_USE_FIELD_SEQ');

    vsql := 'CREATE TABLE '||vschema||'.RULE_TRIAL_USE_FIELDS
        (
          TRIAL_USE_FIELD_ID NUMBER(19,0) NOT NULL,
          ASSET_TYPE NUMBER(2, 0) NOT NULL,
          NAME NVARCHAR2(2000) NOT NULL,
          VALUE_TYPE NUMBER(2, 0) NOT NULL,
          VALUE NVARCHAR2(2000),
          MAPPING_ID NUMBER(19,0),
          RULE_ID NUMBER(19,0) NOT NULL,
          DESCRIPTION NVARCHAR2(2000) NOT NULL,
          CREATED_BY NVARCHAR2(50),
          UPDATED_BY NVARCHAR2(50),
          CREATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
          UPDATE_DATE TIMESTAMP(0) WITH TIME ZONE NOT NULL,
          CONSTRAINT PK_RULE_TRIAL_USE_FIELDS PRIMARY KEY ( TRIAL_USE_FIELD_ID ),
          CONSTRAINT RULE_TRIAL_USE_FIELDS_UK0 UNIQUE ( RULE_ID, DESCRIPTION ),
          CONSTRAINT RULE_TRIAL_USE_ENTITY_MAP_FK1 FOREIGN KEY (MAPPING_ID) REFERENCES '||vschema||'.ENTITY_MAPPING (MAPPING_ID)
        )';
    CREATEOBJECT(vsql,'create TABLE RULE_TRIAL_USE_FIELDS');

    vsql := 'CREATE SEQUENCE '||vschema||'.RULE_TRIAL_USE_FIELD_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create SEQUENCE RULE_TRIAL_USE_FIELD_SEQ');

    vsql := 'CREATE TABLE '||vschema||'.RECORDING_QUEUE
    (
     RECORDING_QUEUE_ID NUMBER(19,0) NOT NULL,
     RECORDING_ID NUMBER(19,0) NOT NULL ,
     SCHEDULE_ID NUMBER(19,0) NOT NULL ,
     POOL_ID NUMBER(19,0) NOT NULL ,
     RM_ID NUMBER(19,0) NOT NULL ,
     SCHEDULE_START_TIME TIMESTAMP (0) WITH TIME ZONE  NOT NULL ,
     SCHEDULE_END_TIME TIMESTAMP (0) WITH TIME ZONE ,
     SCHEDULE_DURATION NUMBER (10,0) ,
     STATION_ID NVARCHAR2 (100)  NOT NULL ,
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL ,
     HD_TV NVARCHAR2 (1) ,
     CC NVARCHAR2 (1) ,
     REPEAT NVARCHAR2 (1) ,
     RM_NAME NVARCHAR2 (64) NOT NULL ,
     RM_IP_ADDRESS NVARCHAR2 (16)  NOT NULL ,
     RM_PORT NUMBER (10,0)  NOT NULL ,
     EPISODE_TITLE NVARCHAR2 (1000) ,
     STATION_OFFSET NUMBER (10,0) DEFAULT 0  NOT NULL ,
     HEADEND_NAME NVARCHAR2 (1000) ,
     CONTRACT_ID NUMBER(19,0) NOT NULL ,
     YEAR_PROGRAM NVARCHAR2 (100) ,
     ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     TITLE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     MOVIE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     POSTER_ASSET_ID NVARCHAR2 (100) NULL ,
     PROGRAM_TITLE NVARCHAR2 (1000) ,
     PROGRAM_DESCRIPTION NVARCHAR2 (2000) ,
     OFFSET_START_TIME NUMBER(22,0) ,
     OFFSET_END_TIME NUMBER(22,0) ,
     RECORDING_MODE NVARCHAR2 (50) ,
     PRIORITY NUMBER (2,0) ,
     STATE NUMBER (2,0) DEFAULT 0  NOT NULL ,
     PROVIDER_QA_CONTACT NVARCHAR2 (128) ,
     CATALOG_ENTRY NUMBER (1,0) ,
     BILLING_ID NVARCHAR2 (5) ,
     MPAA_RATING NVARCHAR2 (1000) ,
     TV_RATING NVARCHAR2 (1000) ,
     PROVIDER_ID NVARCHAR2 (20) NOT NULL ,
     PROVIDER_NAME NVARCHAR2 (128) NOT NULL,
     PRODUCT NVARCHAR2 (20) ,
     CATEGORY NVARCHAR2 (2000) ,
     AUDIO_TYPE NVARCHAR2 (14) ,
     MAX_COPIES NUMBER (10,0) ,
     PREVIEW_PERIOD NUMBER(10,0),
	 REDUNDANCY_COUNT NUMBER(3,0),
     LICENCE_START_DATE TIMESTAMP (0) WITH TIME ZONE ,
     LICENSE_END_DATE TIMESTAMP (0) WITH TIME ZONE ,
     REQUEST_TYPE NUMBER (2,0) NOT NULL,
     VOD_START_TIME NUMBER (10,0) ,
     VOD_DURATION NUMBER (10,0) ,
     VOD_RESTRICTIONS NVARCHAR2 (100) ,
     RTI_START_TIME NUMBER (10,0) ,
     RTI_DURATION NUMBER (10,0) ,
     RTI_RESTRICTIONS NVARCHAR2 (100) ,
     QC_START_TIME NUMBER (10,0) ,
     QC_DURATION NUMBER (10,0) ,
     QC_RESTRICTIONS NVARCHAR2 (100) ,
     ADVISORIES	NVARCHAR2 (1024) ,
     POSTER_IMAGE_NAME	NVARCHAR2(256) NULL,
     POSTER_DESCRIPTION NVARCHAR2(1024) NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE DATE  NOT NULL ,
     UPDATE_DATE DATE  NOT NULL,
     CONSTRAINT PK_RECORDING_QUEUE PRIMARY KEY ( RECORDING_QUEUE_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE RECORDING_QUEUE');
    CREATESEQ('RECORDING_QUEUE');

    vsql := 'CREATE TABLE '||vschema||'.RECORDABLE_RIGHTS_MAP
    (
     SCHEDULE_ID NUMBER(19,0) NOT NULL ,
     RIGHT_ID NUMBER(19,0) NOT NULL ,
     RM_ID NUMBER (19, 0) NOT NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT RECORDABLE_RIGHTS_MAP_PK PRIMARY KEY (SCHEDULE_ID, RIGHT_ID, RM_ID),
	 CONSTRAINT FK_REC_RIGHTS_MAP_SCH FOREIGN KEY (SCHEDULE_ID) REFERENCES '||vschema||'.SCHEDULE (SCHEDULE_ID),
	CONSTRAINT FK_REC_RIGHTS_MAP_RIGHT FOREIGN KEY (RIGHT_ID, RM_ID) REFERENCES '||vschema||'.RIGHT_RM_MAP (RIGHT_ID, RM_ID)
	 ) ';
    CREATEOBJECT(vsql,'create TABLE RECORDABLE_RIGHTS_MAP');

    vsql := 'CREATE TABLE '||vschema||'.RECORDING_LOG
    (
    RECORDING_LOG_ID	NUMBER(19,0) NOT NULL,
    RECORDING_ID    	NUMBER(19,0) NOT NULL,
    LOG_MESSAGE     	NVARCHAR2(2000) NOT NULL,
    SUB_COMPONENT_STATUS NUMBER(19,0),
	SUB_COMPONENT_TYPE 	NVARCHAR2(256),
	SUB_COMPONENT_ID 	NVARCHAR2(256),
    CREATED_BY      	NVARCHAR2(50) NOT NULL,
    UPDATED_BY      	NVARCHAR2(50) NOT NULL,
    CREATE_DATE     	TIMESTAMP(0) WITH TIME ZONE  NOT NULL,
    UPDATE_DATE     	TIMESTAMP(0) WITH TIME ZONE  NOT NULL,
    CONSTRAINT PK_RECORDING_LOG PRIMARY KEY ( RECORDING_LOG_ID ),
    CONSTRAINT FK_REC_LOG_RECORDING FOREIGN KEY ( RECORDING_ID) REFERENCES '||vschema||'.RECORDING ( RECORDING_ID)
    )  ';
    CREATEOBJECT(vsql,'create TABLE RECORDING_LOG');
    CREATESEQ('RECORDING_LOG');

    vsql := 'CREATE INDEX '||vschema||'.IDX_RECORDLOG_RECORDINGID ON '||vschema||'.RECORDING_LOG(RECORDING_ID)';
    CREATEOBJECT(vsql,'create index IDX_RECORDLOG_RECORDINGID');

    vsql := 'CREATE TABLE '||vschema||'.PLAYBACK_WINDOW_RESTRICTIONS
    (
     RESTRICTION_ID NUMBER (19,0) NOT NULL ,
     START_TIME NUMBER (10,0) DEFAULT 0  NOT NULL ,
     DURATION NUMBER (10,0) DEFAULT 0  NOT NULL ,
     RESTRICTIONS NVARCHAR2 (100) ,
     TYPE NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL ,
     RIGHT_ID NUMBER(19,0) ,
     RECORDING_ID NUMBER(19,0),
     CONSTRAINT PK_PLAYBACK_WINDOW_RESTR PRIMARY KEY ( RESTRICTION_ID ),
     CONSTRAINT FK_PLAYBACK_RESTR_RIGHT FOREIGN KEY ( RIGHT_ID) REFERENCES '||vschema||'.RIGHT ( RIGHT_ID),
     CONSTRAINT FK_PLAYBACK_RESTR_REC FOREIGN KEY ( RECORDING_ID) REFERENCES '||vschema||'.RECORDING ( RECORDING_ID)
     )';
    CREATEOBJECT(vsql,'create TABLE PLAYBACK_WINDOW_RESTRICTIONS');

    vsql := 'CREATE INDEX '||vschema||'.IDX_PWR_RIGHTID ON '||vschema||'.PLAYBACK_WINDOW_RESTRICTIONS(RIGHT_ID)';
    CREATEOBJECT(vsql,'create index IDX_PWR_RIGHTID');

    vsql := 'CREATE INDEX '||vschema||'.IDX_PWR_RECORDINGID ON '||vschema||'.PLAYBACK_WINDOW_RESTRICTIONS(RECORDING_ID)';
    CREATEOBJECT(vsql,'create index IDX_PWR_RIGHTID');

    vsql := 'CREATE SEQUENCE '||vschema||'.PLAYBACK_WINDOW_RESTR_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create SEQUENCE PLAYBACK_WINDOW_RESTR_SEQ');

    vsql := 'CREATE TABLE '||vschema||'.SERIES
    (
     SERIES_ID NVARCHAR2 (100)  NOT NULL ,
     TITLE NVARCHAR2 (250) ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_SERIES PRIMARY KEY ( SERIES_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE SERIES');

    vsql := 'CREATE TABLE '||vschema||'.RECORDING_RULES
    (
     RULE_ID NUMBER (19,0)  NOT NULL ,
     NAME NVARCHAR2 (250)  NOT NULL ,
     START_DATE TIMESTAMP(0) WITH TIME ZONE,
     END_DATE TIMESTAMP(0) WITH TIME ZONE  ,
     START_TIME INTERVAL DAY TO SECOND(0),
     END_TIME INTERVAL DAY TO SECOND(0),
     DAY_OF_WEEK NVARCHAR2 (100) ,
     STATE NUMBER (1,0) DEFAULT 1  NOT NULL ,
     REPEAT NVARCHAR2(1)  ,
     HD  NVARCHAR2(1) ,
     LIVE  NVARCHAR2(100) ,
     BILLING_ID NVARCHAR2(5) DEFAULT 0  NOT NULL ,
     MPAA_RATING NVARCHAR2 (1000)  NOT NULL ,
     OFFSET_START_TIME NUMBER (22,0) ,
     OFFSET_END_TIME NUMBER (22,0) ,
     PRIORITY NUMBER (2,0)  NOT NULL ,
     TV_RATING NVARCHAR2 (1000)  NOT NULL ,
     CATEGORY NVARCHAR2 (2000)  NOT NULL ,
     PRODUCT NVARCHAR2 (20) ,
     PROVIDER_ID NVARCHAR2 (20)  NOT NULL ,
     PROVIDER_NAME NVARCHAR2 (128) NOT NULL ,
     AUDIO_TYPE NVARCHAR2 (14) NOT NULL ,
     PROVIDER_QA_CONTACT NVARCHAR2 (128) ,
     MAX_COPIES NUMBER (10,0) ,
     PREVIEW_PERIOD NUMBER(10,0),
	 REDUNDANCY_COUNT NUMBER(3,0),
     CATALOG_ENTRY NUMBER (1,0) DEFAULT 0  NOT NULL ,
     AUTO_APPROVE NUMBER (1,0) DEFAULT 0  NOT NULL ,
     DYNEXPR VARCHAR2(4000),
     ATTACH_POSTER NUMBER(1, 0) NOT NULL,
     POSTER_IMAGE_NAME	NVARCHAR2(256) NULL,
     POSTER_DESCRIPTION NVARCHAR2(1024) NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT RECORDING_RULES_PK PRIMARY KEY ( RULE_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE RECORDING_RULES');
    CREATESEQ('RECORDING_RULES');

    vsql := 'CREATE INDEX '||vschema||'.IDX_RR_STATE_STTM_EDTM ON '||vschema||'.RECORDING_RULES(STATE,START_DATE,END_DATE)';
    CREATEOBJECT(vsql,'create INDEX IDX_RR_STATE_STTM_EDTM');

    vsql := 'CREATE TABLE '||vschema||'.RECORDING_REC_RULES_MAP
    (
     RECORDING_ID NUMBER(19,0) NOT NULL ,
     RULE_ID NUMBER (19,0) NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT RECORDING_REC_RULES_MAP_PK PRIMARY KEY ( RECORDING_ID, RULE_ID ),
     CONSTRAINT REC_RULES_FK FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID),
     CONSTRAINT FK_REC_REC_RULES_MAP FOREIGN KEY ( RECORDING_ID) REFERENCES '||vschema||'.RECORDING ( RECORDING_ID)
    )  ';
    CREATEOBJECT(vsql,'create TABLE RECORDING_REC_RULES_MAP');

    vsql := 'CREATE TABLE '||vschema||'.REC_RULES_STATION_MAP
    (
     RULE_ID NUMBER (19,0)  NOT NULL ,
     STATION_ID NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT REC_RULES_STATION_MAP_PK PRIMARY KEY ( RULE_ID, STATION_ID ),
     CONSTRAINT REC_RULES_STATION_MAP_FK FOREIGN KEY (STATION_ID) REFERENCES '||vschema||'.STATION ( STATION_ID),
     CONSTRAINT REC_RULES_STAT_RECRULES_FK FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE REC_RULES_STATION_MAP');

    vsql := 'CREATE TABLE '||vschema||'.REC_RULES_SERIES_MAP
    (
     RULE_ID NUMBER (19,0)  NOT NULL ,
     SERIES_ID NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT REC_RULES_SERIES_MAP_PK PRIMARY KEY ( RULE_ID, SERIES_ID ),
     CONSTRAINT REC_RULES_SERIES_MAP_FK FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID),
     CONSTRAINT REC_RULES_SERIES_MAP_SERIES_FK FOREIGN KEY ( SERIES_ID) REFERENCES '||vschema||'.SERIES ( SERIES_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE REC_RULES_SERIES_MAP');

    vsql := ' CREATE TABLE '||vschema||'.REC_RULES_RM_MAP
    (
     RULE_ID NUMBER(19,0)  NOT NULL ,
     RM_ID NUMBER(19,0)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_RULE_RM_MAP PRIMARY KEY ( RULE_ID, RM_ID),
     CONSTRAINT FK_REC_RULES_RM_MAP_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID),
     CONSTRAINT FK_REC_RULES_RM_MAP_RIGHT FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE REC_RULES_RM_MAP');

    vsql := 'CREATE TABLE '||vschema||'.REC_RULES_EXCLUDED_RM_MAP
    (
     RULE_ID NUMBER(19,0)  NOT NULL ,
     RM_ID NUMBER(19,0)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_REC_RULES_EXCLUDED_RM_MAP PRIMARY KEY ( RULE_ID, RM_ID ),
     CONSTRAINT FK_RULES_EXCLUDED_RM_MAP_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID),
     CONSTRAINT FK_RULES_EXCL_RM_MAP_RULE FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE REC_RULES_EXCLUDED_RM_MAP');

    vsql := 'CREATE TABLE '||vschema||'.RIGHT_SERIES_MAP
    (
     RIGHT_ID NUMBER(19,0)  NOT NULL ,
     SERIES_ID NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT RIGHT_SERIES_MAPPING_PK PRIMARY KEY ( RIGHT_ID,SERIES_ID ),
     CONSTRAINT RIGHT_SERIES_MAPPING_RIGHT_FK FOREIGN KEY ( RIGHT_ID) REFERENCES '||vschema||'.RIGHT ( RIGHT_ID),
     CONSTRAINT RIGHT_SERIES_MAPPING_SERIES_FK FOREIGN KEY ( SERIES_ID) REFERENCES '||vschema||'.SERIES ( SERIES_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE RIGHT_SERIES_MAP');

    vsql := 'CREATE TABLE '||vschema||'.REC_RULES_PROGRAM_MAP
    (
     RULE_ID NUMBER (19,0)  NOT NULL ,
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT REC_RULES_PROGRAM_MAP_PK PRIMARY KEY ( RULE_ID, PROGRAM_ID ),
     CONSTRAINT REC_RULES_PRG_MAP_FK FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID),
     CONSTRAINT REC_RULES_PRG_MAP_PRG_FK FOREIGN KEY ( PROGRAM_ID) REFERENCES '||vschema||'.PROGRAM ( PROGRAM_ID)
    )';
    CREATEOBJECT(vsql,'create TABLE REC_RULES_PROGRAM_MAP');

    vsql := 'CREATE TABLE '||vschema||'.RIGHT_STATION_MAP
    (
     RIGHT_ID NUMBER(19,0) NOT NULL ,
     STATION_ID NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_RIGHT_STATION_MAP PRIMARY KEY ( RIGHT_ID, STATION_ID ),
     CONSTRAINT RIGHT_STATN_MAP_STATN_FK FOREIGN KEY ( STATION_ID) REFERENCES '||vschema||'.STATION ( STATION_ID),
     CONSTRAINT FK_RIGHT_STATION_MAP_RIGHT FOREIGN KEY ( RIGHT_ID) REFERENCES '||vschema||'.RIGHT ( RIGHT_ID)
    )';
    CREATEOBJECT(vsql,'create table RIGHT_STATION_MAP');

    vsql := 'CREATE TABLE '||vschema||'.SERIES_PROGRAM_MAP
    (
     SERIES_ID NVARCHAR2 (100)  NOT NULL ,
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP  NOT NULL ,
     UPDATE_DATE TIMESTAMP  NOT NULL,
     CONSTRAINT PK_SERIES_PRG_MAP PRIMARY KEY (  PROGRAM_ID,SERIES_ID ),
     CONSTRAINT FK_SERIES_PRG_MAP_SERIES FOREIGN KEY ( SERIES_ID) REFERENCES '||vschema||'.SERIES ( SERIES_ID),
     CONSTRAINT FK_SERIES_PRG_MAP_PRG FOREIGN KEY ( PROGRAM_ID) REFERENCES '||vschema||'.PROGRAM ( PROGRAM_ID)
    )';
    CREATEOBJECT(vsql,'create table SERIES_PROGRAM_MAP');

    vsql := 'create index '||vschema||'.index_series_id_s_p_map on '||vschema||'.series_program_map(series_id) ';
    CREATEOBJECT(vsql,'create index for series_id on the table SERIES_PROGRAM_MAP');

    vsql := 'create index '||vschema||'.index_program_id_s_p_map on '||vschema||'.series_program_map(program_id) ';
    CREATEOBJECT(vsql,'create index for program_id on the table SERIES_PROGRAM_MAP');


    vsql := 'CREATE TABLE '||vschema||'.METADATA_CONFIG
    (
     ID_ NVARCHAR2 (1024) NOT NULL ,
     NAME NVARCHAR2 (1024) NOT NULL ,
     TYPE NVARCHAR2 (100) NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL ,
     UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
     CREATE_DATE TIMESTAMP(0)  NOT NULL ,
     UPDATE_DATE TIMESTAMP(0)  NOT NULL,
     CONSTRAINT PK_METADATA_CONFIG PRIMARY KEY ("ID_", "NAME", "TYPE" )
    )';
    CREATEOBJECT(vsql,'create table METADATA_CONFIG');

    vsql := 'CREATE TABLE '||vschema||'.ALARM2CURRENTTABLE
      (CURRENTTABLEINDEX2   INTEGER       NOT NULL,
       POSITIONNUMBERC2     INTEGER       NOT NULL,
       PORTNUMBERC2         INTEGER       NOT NULL,
       ALARMIDC2            INTEGER       NOT NULL,
       ALARMTYPEC2          INTEGER       NOT NULL,
       ALARMTEXTC2          VARCHAR2(255) NOT NULL,
       SOURCETEXTC2         VARCHAR2(255) NOT NULL,
       SEVERITYLEVELC2      INTEGER       NOT NULL,
       REFERENCENUMBERC2    INTEGER       NOT NULL,
       MODULETYPEC2         INTEGER       NOT NULL,
       CREATEDATE     	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
       UPDATEDATE     	  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
       CONSTRAINT PK_ALARM2CURRENTTABLE PRIMARY KEY( CURRENTTABLEINDEX2 )
      )';
    CREATEOBJECT(vsql,'create table ALARM2CURRENTTABLE');

    vsql := 'CREATE TABLE '||vschema||'.Login_Attempts
              ( UserId   NUMBER NOT NULL,
                FailedLoginCount  NUMBER (1,0) NOT NULL,
                LastFailedLoginDate DATE NOT NULL,
                PRIMARY KEY (userid)
              )';
    CREATEOBJECT(vsql,'CREATE TABLE Login_Attempts');

	 vsql := ' create table '||vschema||'.temp_deleted_recordings
				(rm_id number(19,0),
				rm_name nvarchar2(200),
				program_title nvarchar2(1000),
				 station_call_sign nvarchar2(100),
				  schedule_start_time TIMESTAMP with time zone) nologging
			';

    CREATEOBJECT(vsql,'CREATE TABLE temp_deleted_recordings');

    vsql := 'CREATE TABLE '||vschema||'.STILL_IMAGE_REPOSITORY (
					IMAGE_NAME				NVARCHAR2(256) NOT NULL,
					FILE_NAME				NVARCHAR2(256) NOT NULL,
					ASPECT_RATIO			NVARCHAR2(32),
					FILE_SIZE				NUMBER(19,0) NOT NULL,
					CHECK_SUM				NVARCHAR2(32) NOT NULL,
					THUMB_NAIL				BLOB NOT NULL,
					IMAGE					BLOB NOT NULL,
					CREATED_BY NVARCHAR2 (50)  NOT NULL ,
					UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
					CREATE_DATE TIMESTAMP  NOT NULL ,
					UPDATE_DATE TIMESTAMP  NOT NULL,
                    CONSTRAINT PK_STILL_IMAGE_REPOSITORY PRIMARY KEY (IMAGE_NAME))
                    LOB(IMAGE) STORE AS SECUREFILE,
                    LOB(THUMB_NAIL) STORE AS SECUREFILE';
    CREATEOBJECT(vsql,'CREATE TABLE STILL_IMAGE_REPOSITORY');

    vsql := 'CREATE TABLE '||vschema||'.STILL_IMAGE_RM_SYNC (
					IMAGE_NAME				NVARCHAR2(256) NOT NULL,
					RM_ID					NUMBER (19,0)  NOT NULL,
					CREATED_BY NVARCHAR2 (50)  NOT NULL ,
					UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
					CREATE_DATE TIMESTAMP  NOT NULL ,
					UPDATE_DATE TIMESTAMP  NOT NULL,
                    CONSTRAINT PK_STILL_IMAGE_RM_SYNC PRIMARY KEY (IMAGE_NAME, RM_ID),
                    CONSTRAINT FK_SIMG_SIMG_RM_SYNC FOREIGN KEY (IMAGE_NAME) REFERENCES '||vschema||'.STILL_IMAGE_REPOSITORY (IMAGE_NAME),
                    CONSTRAINT FK_RM_SIMG_RM_SYNC FOREIGN KEY (RM_ID) REFERENCES '||vschema||'.RM (RM_ID))';
    CREATEOBJECT(vsql,'CREATE TABLE STILL_IMAGE_RM_SYNC');

    /********** INSERT ROWS ****************************/
    -- Inserting Error codes and description with user as system
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(0, ''Recording_Invalid'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(200, ''Recording_Pending'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(201, ''Recording_Locked'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(202, ''Recording_Capturing'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(203, ''Recording_Capture_Complete'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(204, ''Recording_Archived'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(205, ''Recording_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(206, ''Recording_Capture_Pending'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(207, ''Recording_Provisioning'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(208, ''Recording_Provisioned'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(209, ''Recording_RtiWaitingForFtpContentPushToComplete'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(210, ''Recording_RtiFtpContentPushCompleted'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(211, ''Recording_Completed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(212, ''Rti_Ftp_Content_Push_Partial'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(213, ''Partial_Success'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(214, ''All_Capture_Pending'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(215, ''Some_Capture_Pending_Some_Capturing'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(216, ''All_Capturing'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(217, ''Some_Capture_Pending_Some_Capture_Complete'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(218, ''Some_Capture_Pending_Some_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(219, ''Some_Capturing_Some_Capture_Complete'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(220, ''Some_Capturing_Some_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(221, ''All_Capture_Complete'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(222, ''Some_Capture_Complete_Some_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(223, ''All_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(224, ''Some_Capture_Extended_Some_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(225, ''All_Capture_Extend_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(300, ''Recording_Cancelled'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(301, ''Recording_Stopped'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(400, ''Recording_DistributionFailure'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(401, ''Recording_SourceFailure'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(402, ''Recording_SetupFailure'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(500, ''Recording_SendFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(501, ''Recording_CaptureScheduleRequestFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(505, ''Recording_CaptureExtendRequestFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(506, ''Recording_CaptureDeleteRequestFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(507, ''Recording_RtiFtpContentPushFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(502, ''Recording_ProvisioningRequestFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(503, ''Recording_CapacityOverflow'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(504, ''Recording_PoolCapacityOverflow'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(509, ''Recording_AdiXmlSiteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(510, ''Recording_AlreadyProcessed'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(511, ''Recording_RtiZeroFtpPushURLs'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(599, ''Recording_Rejected'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(600, ''Recording_TimedOut'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1, ''EPG_Download_Error'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(10, ''EPG_XMLSCHEMA_VALIDATE_FAILED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(11, ''EPG_DOWNLOAD_ABNORMAL_ERROR'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(12, ''EPG_SCHEDULE_CHANGE'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(13, ''EPG_PROGRAM_CHANGE'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(14, ''EPG_RECORDING_OFFSET_ERROR'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(15, ''RESOURCE_LOCKING_FAILED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(16, ''EPG_DOWNLOAD_FTP_PUSH_FAILED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(17, ''EPG_ADAPTER_FAILED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(18, ''RIGHTS_EXECUTION_FAILED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(19, ''RULES_EXECUTION_FAILED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(20, ''auto_approve_right_rule_failed'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(21, ''EPG_INGEST_SKIPPED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(22, ''EPG_INGEST_SKIPPED_FOR_MAINTENANCE_MODE'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(23, ''INVALID_HEADEND_TIME_ZONE'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(24, ''EPG_SCHEDULE_CHANGE_RECORDING_DELETED'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(25, ''still_image_rm_sync_interrupted'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(26, ''still_image_rm_sync_failed'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');


    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(50, ''Recording_Queue_System_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(51, ''Recording_Send_To_RM_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(101, ''rcs_UpdateFailed_Params'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(777, ''RM_Services_Down'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(778, ''RM_In_Maintenance_Mode'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1400, ''Recording_Invalid_Request_Format'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1403, ''Recording_Invalid_Adi_Format'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1404, ''Recording_INVALID_SOURCE_ID'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1409, ''Recording_INVALID_RECORD_TIME_FORMAT'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1410, ''Recording_UNDEFINED'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1411, ''Recording_RESOURCE_CONSTRAINT'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1412, ''Recording_TIME_CONSTRAINT'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1413, ''Recording_INVALID_ASSET_ID'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1414, ''Recording_INVALID_FORMATTING'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1415, ''Recording_LOCKED'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1416, ''Recording_INVALID_LICENSING_WINDOW'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');


    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1451, ''Recording_UNSUPPORTED_DISTRIBUTION_METHOD'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1452, ''Recording_DUPLICATE'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1500, ''Recording_INTERNAL_SERVER_ERROR'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1501, ''RM_Status_Changed_To_Offline_DB_Error_Message'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1502, ''RTC_Status_Changed_To_Offline_DB_Error_Message'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1503, ''RM_Id_Not_Matching_With_RM_Status_Response_DB_Error_Message'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(1504, ''RM_Status_Servlet_Request_Failed_DB_Error_Message'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2000, ''CopyrightHolder_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2001, ''CopyrightHolder_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2002, ''CopyrightHolder_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');


    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2020, ''Contract_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2021, ''Contract_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2022, ''Contract_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');


    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2040, ''Right_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2041, ''Right_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2042, ''Right_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');


    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2060, ''RecordingRule_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2061, ''RecordingRule_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2062, ''RecordingRule_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2080, ''Recording_QuickApproveFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2081, ''Recording_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2082, ''Recording_StopFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(2083, ''Recording_ApproveFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6001, ''rm_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6002, ''rm_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6003, ''rm_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6004, ''rm_DownstreamDeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6005, ''epg_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6006, ''epg_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6007, ''epg_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6008, ''rtcRemote_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6009, ''rtc_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6010, ''rtcRemote_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6011, ''rtc_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6012, ''rtcRemote_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6013, ''rtc_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6014, ''rmRemote_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6015, ''rmRemote_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6016, ''rmRemote_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6017, ''channelRemote_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6018, ''channelRemote_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6019, ''channel_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6020, ''channel_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6021, ''channel_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6022, ''channelRemote_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6023, ''trialUseConfig.addFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6024, ''trialUseConfig.deleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(6025, ''trialUseConfig.updateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)
    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                VALUES(1300, ''User_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                VALUES(1301, ''User_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                 VALUES(1302,''User_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                 VALUES(1310, ''Role_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                VALUES(1311, ''Role_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                 VALUES(1312, ''Role_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                 VALUES(1701, ''maintenanceWindow.unableToAcquireRecordingLock'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                 VALUES(1702, ''maintenanceWindow.unexpectedError'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                 VALUES(1703, ''rcs.error.operationalState.epgInProgress'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code','Y');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleLanguage'',''SCHEDULE'',''SCHEDULE_LANGUAGE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.startTime'',''SCHEDULE'',''START_TIME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.endTime'',''SCHEDULE'',''END_TIME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.duration'',''SCHEDULE'',''DURATION'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.tvRating'',''SCHEDULE'',''TV_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.hd'',''SCHEDULE'',''HD_TV'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.partNumber'',''SCHEDULE'',''PART_NUMBER'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.noOfParts'',''SCHEDULE'',''NO_OF_PARTS'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.cc'',''SCHEDULE'',''CC'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stereo'',''SCHEDULE'',''STEREO'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.liveTapeDelay'',''SCHEDULE'',''LIVE_TAPE_DELAY'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.subtitled'',''SCHEDULE'',''SUBTITLED'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.premiereFinale'',''SCHEDULE'',''PREMIERE_FINALE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.joinedInProgress'',''SCHEDULE'',''JOINED_IN_PROGRESS'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.cableInClassroom'',''SCHEDULE'',''CABLE_IN_CLASSROOM'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.sap'',''SCHEDULE'',''SAP'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.sexRating'',''SCHEDULE'',''SEX_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.violenceRating'',''SCHEDULE'',''VIOLENCE_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.languageRating'',''SCHEDULE'',''LANGUAGE_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.dialogRating'',''SCHEDULE'',''DIALOG_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.fvRating'',''SCHEDULE'',''FV_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.enhanced'',''SCHEDULE'',''ENHANCED'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.threeD'',''SCHEDULE'',''THREE_D'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.letterBox'',''SCHEDULE'',''LETTERBOX'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.dvs'',''SCHEDULE'',''DVS'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.repeat'',''SCHEDULE'',''REPEAT'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.blackout'',''SCHEDULE'',''BLACKOUT'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.dolby'',''SCHEDULE'',''DOLBY'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.requestToRecord'',''SCHEDULE'',''REQUEST_RECORD'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programId'',''PROGRAM'',''PROGRAM_ID'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.language'',''PROGRAM'',''LANGUAGE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.title'',''PROGRAM'',''TITLE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedTitle1'',''PROGRAM'',''REDUCED_TITLE1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedTitle2'',''PROGRAM'',''REDUCED_TITLE2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedTitle3'',''PROGRAM'',''REDUCED_TITLE3'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedTitle4'',''PROGRAM'',''REDUCED_TITLE4'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.altTitle'',''PROGRAM'',''ALT_TITLE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedDescription1'',''PROGRAM'',''REDUCED_DESCRIPTION1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedDescription2'',''PROGRAM'',''REDUCED_DESCRIPTION2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedDescription3'',''PROGRAM'',''REDUCED_DESCRIPTION3'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.reducedDescription4'',''PROGRAM'',''REDUCED_DESCRIPTION4'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.advisoryDescription1'',''PROGRAM'',''ADVISORY_DESC1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.advisoryDescription2'',''PROGRAM'',''ADVISORY_DESC2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.advisoryDescription3'',''PROGRAM'',''ADVISORY_DESC3'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.advisoryDescription4'',''PROGRAM'',''ADVISORY_DESC4'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.advisoryDescription5'',''PROGRAM'',''ADVISORY_DESC5'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.advisoryDescription6'',''PROGRAM'',''ADVISORY_DESC6'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.genereDescription1'',''PROGRAM'',''GENRE_DESC1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.genereDescription2'',''PROGRAM'',''GENRE_DESC2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.genereDescription3'',''PROGRAM'',''GENRE_DESC3'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.genereDescription4'',''PROGRAM'',''GENRE_DESC4'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.genereDescription5'',''PROGRAM'',''GENRE_DESC5'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.genereDescription6'',''PROGRAM'',''GENRE_DESC6'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.description1'',''PROGRAM'',''DESCRIPTION1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.description2'',''PROGRAM'',''DESCRIPTION2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.year'',''PROGRAM'',''YEAR_PROGRAM'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.mpaaRating'',''PROGRAM'',''MPAA_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.starRating'',''PROGRAM'',''STAR_RATING'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.runTime'',''PROGRAM'',''RUN_TIME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.colorCode'',''PROGRAM'',''COLOR_CODE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programLanguage'',''PROGRAM'',''PROGRAM_LANGUAGE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.countryOfOrigin'',''PROGRAM'',''COUNTRY_OF_ORIGIN'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.madeForTV'',''PROGRAM'',''MADE_FOR_TV'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.sourceType'',''PROGRAM'',''SOURCE_TYPE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.showType'',''PROGRAM'',''SHOW_TYPE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.holiday'',''PROGRAM'',''HOLIDAY'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.syndicateEpisodeNum'',''PROGRAM'',''SYNDICATE_EPISODE_NUM'',1)
    '; CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.altSyndicateEpisodeNum'',''PROGRAM'',''ALT_SYNDICATE_EPI_NUM'',1)
    '; CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.episodeTitle'',''PROGRAM'',''EPISODE_TITLE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.netSynSource'',''PROGRAM'',''NET_SYN_SOURCE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.netSynType'',''PROGRAM'',''NET_SYN_TYPE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.orgStudio'',''PROGRAM'',''ORG_STUDIO'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.gameDateTime'',''PROGRAM'',''GAME_DATETIME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.gameTimezone'',''PROGRAM'',''GAME_TIMEZONE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.orgAirDate'',''PROGRAM'',''ORG_AIR_DATE'',1) ';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.uniqueId'',''PROGRAM'',''UNIQUE_ID'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.seriesId'',''SCHEDULE'',''SERIES_LINK'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationId'',''STATION'',''STATION_ID'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationName'',''STATION'',''STATION_NAME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationTimezone'',''STATION'',''TIME_ZONE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.callSign'',''STATION'',''CALL_SIGN'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationCity'',''STATION'',''CITY'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationState'',''STATION'',''STATE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationZipcode'',''STATION'',''ZIPCODE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationCountry'',''STATION'',''COUNTRY'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.dmaName'',''STATION'',''DMA_NAME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.dmaNumber'',''STATION'',''DMA_NUMBER'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.fccChannelNumber'',''STATION'',''FCC_CHANNEL_NUM'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.affiliation'',''STATION'',''AFFILIATION'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData1'',''PROGRAM'',''USER_DATA1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData2'',''PROGRAM'',''USER_DATA2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData3'',''PROGRAM'',''USER_DATA3'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData4'',''PROGRAM'',''USER_DATA4'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData5'',''PROGRAM'',''USER_DATA5'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData6'',''PROGRAM'',''USER_DATA6'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData7'',''PROGRAM'',''USER_DATA7'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData8'',''PROGRAM'',''USER_DATA8'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData9'',''PROGRAM'',''USER_DATA9'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData10'',''PROGRAM'',''USER_DATA10'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData11'',''PROGRAM'',''USER_DATA11'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData12'',''PROGRAM'',''USER_DATA12'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.programUserData13'',''PROGRAM'',''USER_DATA13'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData1'',''SCHEDULE'',''USER_DATA1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData2'',''SCHEDULE'',''USER_DATA2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData3'',''SCHEDULE'',''USER_DATA3'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData4'',''SCHEDULE'',''USER_DATA4'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData5'',''SCHEDULE'',''USER_DATA5'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData6'',''SCHEDULE'',''USER_DATA6'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData7'',''SCHEDULE'',''USER_DATA7'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData8'',''SCHEDULE'',''USER_DATA8'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData9'',''SCHEDULE'',''USER_DATA9'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData10'',''SCHEDULE'',''USER_DATA10'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.scheduleUserData11'',''SCHEDULE'',''USER_DATA11'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData1'',''STATION'',''USER_DATA1'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData2'',''STATION'',''USER_DATA2'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData3'',''STATION'',''USER_DATA3'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData4'',''STATION'',''USER_DATA4'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData5'',''STATION'',''USER_DATA5'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData6'',''STATION'',''USER_DATA6'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData7'',''STATION'',''USER_DATA7'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData8'',''STATION'',''USER_DATA8'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData9'',''STATION'',''USER_DATA9'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.stationUserData10'',''STATION'',''USER_DATA10'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendId'',''HEADEND'',''HEADEND_ID'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendCommunityName'',''HEADEND'',''COMMUNITY_NAME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendCountyName'',''HEADEND'',''COUNTY_NAME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendStCountyCode'',''HEADEND'',''ST_COUNTY_CODE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendCountySize'',''HEADEND'',''COUNTY_SIZE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendState'',''HEADEND'',''STATE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendZipCode'',''HEADEND'',''ZIPCODE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendDMACode'',''HEADEND'',''DMA_CODE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendDMAName'',''HEADEND'',''DMA_NAME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendMSOCode'',''HEADEND'',''MSO_CODE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendDMARank'',''HEADEND'',''DMA_RANK'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendName'',''HEADEND'',''HEADEND_NAME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendLocation'',''HEADEND'',''HEADEND_LOCATION'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendMSOName'',''HEADEND'',''MSO_NAME'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendTimezone'',''HEADEND'',''TIME_ZONE'',1)';
    CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

		-- EPG driven auto-approve fields

 	vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleLanguage'',''SCHEDULE'',''SCHEDULE_LANGUAGE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.duration'',''SCHEDULE'',''DURATION'',2, 5,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.tvRating'',''SCHEDULE'',''TV_RATING'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.partNumber'',''SCHEDULE'',''PART_NUMBER'',2, 5,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.noOfParts'',''SCHEDULE'',''NO_OF_PARTS'',2, 5,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.cc'',''SCHEDULE'',''CC'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stereo'',''SCHEDULE'',''STEREO'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');


    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.subtitled'',''SCHEDULE'',''SUBTITLED'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.premiereFinale'',''SCHEDULE'',''PREMIERE_FINALE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.joinedInProgress'',''SCHEDULE'',''JOINED_IN_PROGRESS'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.cableInClassroom'',''SCHEDULE'',''CABLE_IN_CLASSROOM'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.sap'',''SCHEDULE'',''SAP'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.sexRating'',''SCHEDULE'',''SEX_RATING'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.violenceRating'',''SCHEDULE'',''VIOLENCE_RATING'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.languageRating'',''SCHEDULE'',''LANGUAGE_RATING'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dialogRating'',''SCHEDULE'',''DIALOG_RATING'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.fvRating'',''SCHEDULE'',''FV_RATING'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.enhanced'',''SCHEDULE'',''ENHANCED'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.threeD'',''SCHEDULE'',''THREE_D'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.letterBox'',''SCHEDULE'',''LETTERBOX'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dvs'',''SCHEDULE'',''DVS'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.blackout'',''SCHEDULE'',''BLACKOUT'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dolby'',''SCHEDULE'',''DOLBY'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.requestToRecord'',''SCHEDULE'',''REQUEST_RECORD'',2, 4,''DROPDOWN_Y'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programId'',''PROGRAM'',''PROGRAM_ID'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.language'',''PROGRAM'',''LANGUAGE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programTitle'',''PROGRAM'',''TITLE,REDUCED_TITLE1,REDUCED_TITLE2,REDUCED_TITLE3,REDUCED_TITLE4'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');


    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.altTitle'',''PROGRAM'',''ALT_TITLE'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programDescription'',''PROGRAM'',''DESCRIPTION1,DESCRIPTION2,REDUCED_DESCRIPTION1,REDUCED_DESCRIPTION2,REDUCED_DESCRIPTION3,REDUCED_DESCRIPTION4'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.advisoryDescription'',''PROGRAM'',''ADVISORY_DESC1,ADVISORY_DESC2,ADVISORY_DESC3,ADVISORY_DESC4,ADVISORY_DESC5,ADVISORY_DESC6'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.genereDescription'',''PROGRAM'',''GENRE_DESC1,GENRE_DESC2,GENRE_DESC3,GENRE_DESC4,GENRE_DESC5,GENRE_DESC6'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.year'',''PROGRAM'',''YEAR_PROGRAM'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.mpaaRating'',''PROGRAM'',''MPAA_RATING'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.starRating'',''PROGRAM'',''STAR_RATING'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.runTime'',''PROGRAM'',''RUN_TIME'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.colorCode'',''PROGRAM'',''COLOR_CODE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programLanguage'',''PROGRAM'',''PROGRAM_LANGUAGE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.countryOfOrigin'',''PROGRAM'',''COUNTRY_OF_ORIGIN'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.madeForTV'',''PROGRAM'',''MADE_FOR_TV'',2, 4,''DROPDOWN_YN'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.sourceType'',''PROGRAM'',''SOURCE_TYPE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.showType'',''PROGRAM'',''SHOW_TYPE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.holiday'',''PROGRAM'',''HOLIDAY'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.syndicateEpisodeNum'',''PROGRAM'',''SYNDICATE_EPISODE_NUM'',2, 4,''TEXTFIELD'')
    ';CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.altSyndicateEpisodeNum'',''PROGRAM'',''ALT_SYNDICATE_EPI_NUM'',2, 4,''TEXTFIELD'')
    ';CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.episodeTitle'',''PROGRAM'',''EPISODE_TITLE'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.netSynSource'',''PROGRAM'',''NET_SYN_SOURCE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.netSynType'',''PROGRAM'',''NET_SYN_TYPE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.orgStudio'',''PROGRAM'',''ORG_STUDIO'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.gameTimezone'',''PROGRAM'',''GAME_TIMEZONE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.uniqueId'',''PROGRAM'',''UNIQUE_ID'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');


    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationId'',''STATION'',''STATION_ID'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationName'',''STATION'',''STATION_NAME'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationTimezone'',''STATION'',''TIME_ZONE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.callSign'',''STATION'',''CALL_SIGN'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationCity'',''STATION'',''CITY'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationState'',''STATION'',''STATE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationZipcode'',''STATION'',''ZIPCODE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationCountry'',''STATION'',''COUNTRY'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dmaName'',''STATION'',''DMA_NAME'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dmaNumber'',''STATION'',''DMA_NUMBER'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.fccChannelNumber'',''STATION'',''FCC_CHANNEL_NUM'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.affiliation'',''STATION'',''AFFILIATION'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData1'',''PROGRAM'',''USER_DATA1'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData2'',''PROGRAM'',''USER_DATA2'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData3'',''PROGRAM'',''USER_DATA3'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData4'',''PROGRAM'',''USER_DATA4'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData5'',''PROGRAM'',''USER_DATA5'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData6'',''PROGRAM'',''USER_DATA6'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData7'',''PROGRAM'',''USER_DATA7'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData8'',''PROGRAM'',''USER_DATA8'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData9'',''PROGRAM'',''USER_DATA9'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData10'',''PROGRAM'',''USER_DATA10'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData11'',''PROGRAM'',''USER_DATA11'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData12'',''PROGRAM'',''USER_DATA12'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData13'',''PROGRAM'',''USER_DATA13'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData1'',''SCHEDULE'',''USER_DATA1'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData2'',''SCHEDULE'',''USER_DATA2'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData3'',''SCHEDULE'',''USER_DATA3'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData4'',''SCHEDULE'',''USER_DATA4'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData5'',''SCHEDULE'',''USER_DATA5'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData6'',''SCHEDULE'',''USER_DATA6'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData7'',''SCHEDULE'',''USER_DATA7'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData8'',''SCHEDULE'',''USER_DATA8'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData9'',''SCHEDULE'',''USER_DATA9'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData10'',''SCHEDULE'',''USER_DATA10'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData11'',''SCHEDULE'',''USER_DATA11'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData1'',''STATION'',''USER_DATA1'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData2'',''STATION'',''USER_DATA2'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData3'',''STATION'',''USER_DATA3'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData4'',''STATION'',''USER_DATA4'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData5'',''STATION'',''USER_DATA5'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData6'',''STATION'',''USER_DATA6'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData7'',''STATION'',''USER_DATA7'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData8'',''STATION'',''USER_DATA8'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData9'',''STATION'',''USER_DATA9'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData10'',''STATION'',''USER_DATA10'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendId'',''HEADEND'',''HEADEND_ID'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendCommunityName'',''HEADEND'',''COMMUNITY_NAME'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendCountyName'',''HEADEND'',''COUNTY_NAME'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendStCountyCode'',''HEADEND'',''ST_COUNTY_CODE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendCountySize'',''HEADEND'',''COUNTY_SIZE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendState'',''HEADEND'',''STATE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendZipCode'',''HEADEND'',''ZIPCODE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendDMACode'',''HEADEND'',''DMA_CODE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendDMAName'',''HEADEND'',''DMA_NAME'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendMSOCode'',''HEADEND'',''MSO_CODE'',2, 5,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendDMARank'',''HEADEND'',''DMA_RANK'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendName'',''HEADEND'',''HEADEND_NAME'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendLocation'',''HEADEND'',''HEADEND_LOCATION'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendMSOName'',''HEADEND'',''MSO_NAME'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendTimezone'',''HEADEND'',''TIME_ZONE'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.lineupDevice'',''LINEUP'',''device'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.lineupId'',''LINEUP'',''LINEUP_ID'',2, 5,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.serviceTier'',''LINEUP'',''SERVICE_TIER'',2, 4,''SELECT_TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.tmsChannel'',''LINEUP'',''TMS_CHANNEL'',2, 4,''SELECT_TEXTFIELD'')';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.seriesId'',''SERIES'',''SERIES_ID'',2, 4,''TEXTFIELD'')';
   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');

    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.seriesTitle'',''SERIES'',''TITLE'',2, 4,''TEXTFIELD'')';
         CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');


    --vsql := 'INSERT INTO '||vschema||'.config_setting
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''EPG_Download_Processing'', ''N'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

	 vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''Is_EPG_Schedule_Conflict_Completed'', ''Y'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');



    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''Last_EPG_Completion_Time'', '''', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''rcsOperationalState'', ''1'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''TVRatingPrefix'', ''TV'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''EPG_Schedule_Delay_Secs'', ''60'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''APPLICATION_TIMEZONE_KEY'', ''UTC'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''APPLICATION_DB_SERVER_TIMEZONE_KEY'', ''UTC'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''RECORDING_CLEANER_THRESHOLD'', ''120'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Version information will be updated by installer.
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''version'', ''&RCS_DB_VERSION'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Version information will be updated by installer.
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''EPG_AUTOCREATE_RECORDING_SPAN'', ''86400'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Recordables Resource Lock to serialize all recordable operations in the system
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''RECORDABLES_RESOURCE_LOCK'', ''SERIALIZE_TRANSACTION'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Recordings Resource Lock to serialize all recording operations in the system
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''RECORDINGS_RESOURCE_LOCK'', ''SERIALIZE_TRANSACTION'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Timeout for Recordables and Recordings resource lock
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''RESOURCE_TIMEOUT_SECS'', ''30'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Num of Channels per page to be displayed in Program Guide page
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''channelsPerPage'', ''20'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Time Display Format to be displayed in Program Guide page
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''timeDisplayFormat'', ''24'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    --Movie Asset Generation logic
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''MOVIE_ASSET_ID_GEN_LOGIC_KEY'', ''DEFAULT'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

    commit;


    /********************** EPG STAGING OBJECTS **************************/
    --Staging Program rows
    vsql := 'create or replace view '||vschema||'.stg_program_view as
    SELECT xmlcolumns.*
    FROM (select sys_nc_rowinfo$ as res  from guide_tab ) rv,
    XMLTABLE(''/GuideData/SlicerGuideData/PROGRAM/row''
    PASSING rv.res
    COLUMNS
    DATABASE_KEY nvarchar2(100) PATH ''DATABASE_KEY'',
    LANGUAGE nvarchar2(100) PATH ''LANGUAGE'',
    TITLE nvarchar2(1000) PATH ''TITLE'',
    REDUCED_TITLE1 nvarchar2(1000) PATH ''REDUCED_TITLE[1]'',
    REDUCED_TITLE2 nvarchar2(1000) PATH ''REDUCED_TITLE[2]'',
    REDUCED_TITLE3 nvarchar2(1000) PATH ''REDUCED_TITLE[3]'',
    REDUCED_TITLE4 nvarchar2(1000) PATH ''REDUCED_TITLE[4]'',
    ALT_TITLE nvarchar2(1000) PATH ''ALT_TITLE'',
    REDUCED_DESC1 nvarchar2(1000) PATH ''REDUCED_DESC[1]'',
    REDUCED_DESC2 nvarchar2(1000) PATH ''REDUCED_DESC[2]'',
    REDUCED_DESC3 nvarchar2(1000) PATH ''REDUCED_DESC[3]'',
    REDUCED_DESC4 nvarchar2(1000) PATH ''REDUCED_DESC[4]'',
    ADVISORY_DESC1 nvarchar2(100) PATH ''ADVISORY_DESC[1]'',
    ADVISORY_DESC2 nvarchar2(100) PATH ''ADVISORY_DESC[2]'',
    ADVISORY_DESC3 nvarchar2(100) PATH ''ADVISORY_DESC[3]'',
    ADVISORY_DESC4 nvarchar2(100) PATH ''ADVISORY_DESC[4]'',
    ADVISORY_DESC5 nvarchar2(100) PATH ''ADVISORY_DESC[5]'',
    ADVISORY_DESC6 nvarchar2(100) PATH ''ADVISORY_DESC[6]'',
    /* CAST_CREDITS*/
    CAST_NAME_ROLE xmltype PATH ''CAST_NAME_ROLE'',
    /* CAST_CREDITS*/
    CREDITS_NAME_ROLE xmltype PATH ''CREDITS_NAME_ROLE'',
    GENRE_DESC1 nvarchar2(100) PATH ''GENRE_DESC[1]'',
    GENRE_DESC2 nvarchar2(100) PATH ''GENRE_DESC[2]'',
    GENRE_DESC3 nvarchar2(100) PATH ''GENRE_DESC[3]'',
    GENRE_DESC4 nvarchar2(100) PATH ''GENRE_DESC[4]'',
    GENRE_DESC5 nvarchar2(100) PATH ''GENRE_DESC[5]'',
    GENRE_DESC6 nvarchar2(100) PATH ''GENRE_DESC[6]'',
    DESCRIPTION1 nvarchar2(2000) PATH ''DESC[1]'',
    DESCRIPTION2 nvarchar2(2000) PATH ''DESC[2]'',
    YEAR_PROGRAM nvarchar2(100) PATH ''YEAR'',
    MPAA_RATING nvarchar2(1000) PATH ''MPAA_RATING'',
    STAR_RATING nvarchar2(1000) PATH ''STAR_RATING'',
    PROGRAM_RATING xmltype PATH ''PROGRAM_RATING'',
    RUN_TIME varchar2(100) PATH ''RUN_TIME'',
    COLOR_CODE nvarchar2(100) PATH ''COLOR_CODE'',
    PROGRAM_LANGUAGE nvarchar2(100) PATH ''PROGRAM_LANGUAGE'',
    AUDIO_COMPONENT xmltype PATH ''AUDIO_COMPONENT'',
    SUBTITLE_COMPONENT xmltype PATH ''SUBTITLE_COMPONENT'',
    ORG_COUNTRY nvarchar2(100) PATH ''ORG_COUNTRY'',
    MADE_FOR_TV nvarchar2(1) PATH ''MADE_FOR_TV'',
    SOURCE_TYPE nvarchar2(100) PATH ''SOURCE_TYPE'',
    SHOW_TYPE nvarchar2(200) PATH ''SHOW_TYPE'',
    HOLIDAY nvarchar2(100) PATH ''HOLIDAY'',
    SYN_EPI_NUM nvarchar2(100) PATH ''SYN_EPI_NUM'',
    ALT_SYN_EPI_NUM nvarchar2(100) PATH ''ALT_SYN_EPI_NUM'',
    EPI_TITLE nvarchar2(2000) PATH ''EPI_TITLE'',
    NET_SYN_SOURCE nvarchar2(100) PATH ''NET_SYN_SOURCE'',
    NET_SYN_TYPE nvarchar2(100) PATH ''NET_SYN_TYPE'',
    ORG_STUDIO nvarchar2(100) PATH ''ORG_STUDIO'',
    /* GAME_DATETIME stores all game date,time,hhmmss */
    GAME_DATE varchar2(100) PATH ''GAME_DATE'',
    GAME_TIMEZONE varchar2(100) PATH ''GAME_TIME_ZONE'',
    ORG_AIR_DATE varchar2(100) PATH ''ORG_AIR_DATE'',
    UNIQUE_ID  nvarchar2(100) PATH ''UNIQUE_ID'',
    USER_DATA1	varchar2(1000) PATH ''USER_DATA[1]'',
    USER_DATA2	varchar2(1000) PATH ''USER_DATA[2]'',
    USER_DATA3	varchar2(1000) PATH ''USER_DATA[3]'',
    USER_DATA4	varchar2(1000) PATH ''USER_DATA[4]'',
    USER_DATA5	varchar2(1000) PATH ''USER_DATA[5]'',
    USER_DATA6	varchar2(1000) PATH ''USER_DATA[6]'',
    USER_DATA7	varchar2(1000) PATH ''USER_DATA[7]'',
    USER_DATA8	varchar2(1000) PATH ''USER_DATA[8]'',
    USER_DATA9	varchar2(1000) PATH ''USER_DATA[9]'',
    USER_DATA10	varchar2(1000) PATH ''USER_DATA[10]'',
    USER_DATA11	varchar2(1000) PATH ''USER_DATA[11]'',
    USER_DATA12	varchar2(1000) PATH ''USER_DATA[12]'',
    USER_DATA13	varchar2(1000) PATH ''USER_DATA[13]'',
    PROGRAM_GENERIC  xmltype PATH ''PROGRAM_GENERIC''
    ) xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_program_view');

    --Staging HEADEND row
    vsql := 'create or replace view '||vschema||'.stg_HEADEND_view as
    SELECT xmlcolumns.*
    FROM (select sys_nc_rowinfo$ as res  from guide_tab ) rv,
    XMLTABLE(''/GuideData/SlicerGuideData/HEADEND/row''
    PASSING rv.res
    COLUMNS
    HE_HEADEND_ID	nvarchar2(100) PATH ''HE_HEADEND_ID'',
    HE_COMMUNITY_NAME		nvarchar2(200) PATH ''HE_COMMUNITY_NAME'',
    HE_COUNTY_NAME		nvarchar2(200)  PATH ''HE_COUNTY_NAME'',
    HE_COUNTY_SIZE		nvarchar2(1) PATH ''HE_COUNTY_SIZE'',
    HE_ST_COUNTY_CODE		nvarchar2(100) PATH ''HE_ST_COUNTY_CODE'',
    HE_STATE_SERVED		nvarchar2(2) PATH ''HE_STATE_SERVED'',
    HE_ZIP_CODE		nvarchar2(100) PATH ''HE_ZIP_CODE'',
    HE_DMA_CODE		nvarchar2(100) PATH ''HE_DMA_CODE'',
    HE_DMA_NAME		nvarchar2(300) PATH ''HE_DMA_NAME'',
    HE_MSO_CODE		number PATH ''HE_MSO_CODE'',
    HE_DMA_RANK		nvarchar2(10) PATH ''HE_DMA_RANK'',
    HE_HEADEND_NAME		nvarchar2(1000) PATH ''HE_HEADEND_NAME'',
    HE_HEADEND_LOCATION		nvarchar2(100)  PATH ''HE_HEADEND_LOCATION'',
    HE_MSO_NAME		nvarchar2(200) PATH ''HE_MSO_NAME'',
    HE_TIME_ZONE_CODE		nvarchar2(100)  PATH ''HE_TIME_ZONE_CODE'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_headend_view');

    --Get LINEUP rows
    vsql := 'create or replace view '||vschema||'.stg_LINEUP_view as
    SELECT xmlcolumns.*
    FROM (select sys_nc_rowinfo$ as res  from guide_tab ) rv,
    XMLTABLE(''/GuideData/SlicerGuideData/LINEUP/row''
    PASSING rv.res
    COLUMNS
    CL_ROW_ID	number PATH ''CL_ROW_ID'',
    CL_STATION_NUM	nvarchar2(100) PATH ''CL_STATION_NUM'',
    CL_HEADEND_ID	nvarchar2(100) PATH ''CL_HEADEND_ID'',
    CL_DEVICE		nvarchar2(2) PATH ''CL_DEVICE'',
    CL_TMS_CHAN		nvarchar2(20) PATH ''CL_TMS_CHAN'',
    CL_SERVICE_TIER		nvarchar2(1) PATH ''CL_SERVICE_TIER'',
    CL_EFFECTIVE_DATE	varchar2(100) PATH ''CL_EFFECTIVE_DATE'',
    CL_EXPIRATION_DATE		varchar2(100) PATH ''CL_EXPIRATION_DATE'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_lineup_view');

    vsql := 'create or replace view '||vschema||'.stg_SCHEDULE_view as
    SELECT xmlcolumns.*
    FROM (select sys_nc_rowinfo$ as res  from guide_tab ) rv,
    XMLTABLE(''/GuideData/SlicerGuideData/SCHEDULE/row''
    PASSING rv.res
    COLUMNS
    STATION_NUM 	NVARCHAR2 (100) PATH ''STATION_NUM'',
    DATABASE_KEY 	nvarchar2(100) PATH ''DATABASE_KEY'',
    SCHEDULE_LANGUAGE		nvarchar2(100) PATH ''LANGUAGE'',
    AIR_DATE 	varchar2(200) PATH ''AIR_DATE'',
    DURATION 		varchar2(100) PATH ''DURATION'',
    EVENT_ID		xmltype PATH ''EVENT_ID'',
    PART_NUM 		number PATH ''PART_NUM'',
    NUM_OF_PARTS 		number PATH ''NUM_OF_PARTS'',
    SERIES_LINK			xmltype PATH ''SERIES_LINK'',
    CC varchar2(1) PATH ''CC'',
    STEREO 		varchar2(1) PATH ''STEREO'',
    REPEAT 		varchar2(1) PATH ''REPEAT'',
    LIVE_TAPE_DELAY 	varchar2(100) PATH ''LIVE_TAPE_DELAY'',
    SUBTITLED varchar2(1) PATH ''SUBTITLED'',
    PREMIERE_FINALE 	varchar2(100)  PATH ''PREMIERE_FINALE'',
    JOINED_IN_PROGRESS 		varchar2(1)  PATH ''JOINED_IN_PROGRESS'',
    CABLE_IN_THE_CLASSROOM 		varchar2(1) PATH ''CABLE_IN_THE_CLASSROOM'',
    TV_RATING 		varchar2(1000)  PATH ''TV_RATING'',
    SAP varchar2(1) PATH ''SAP'',
    BLACKOUT varchar2(1) PATH ''BLACKOUT'',
    SEX_RATING varchar2(1) PATH ''SEX_RATING'',
    VIOLENCE_RATING varchar2(1) PATH ''VIOLENCE_RATING'',
    LANGUAGE_RATING varchar2(1) PATH ''LANGUAGE_RATING'',
    DIALOG_RATING varchar2(1)  PATH ''DIALOG_RATING'',
    FV_RATING varchar2(1)  PATH ''FV_RATING'',
    ENHANCED varchar2(1) PATH ''ENHANCED'',
    THREE_D varchar2(1) PATH ''THREE_D'',
    LETTERBOX varchar2(1) PATH ''LETTERBOX'',
    HDTV varchar2(1) PATH ''HDTV'',
    DOLBY nvarchar2(100) PATH ''DOLBY'',
    DVS varchar2(1) PATH ''DVS'',
    USER_DATA1	varchar2(1000) PATH ''USER_DATA[1]'',
    USER_DATA2	varchar2(1000) PATH ''USER_DATA[2]'',
    USER_DATA3	varchar2(1000) PATH ''USER_DATA[3]'',
    USER_DATA4	varchar2(1000) PATH ''USER_DATA[4]'',
    USER_DATA5	varchar2(1000) PATH ''USER_DATA[5]'',
    USER_DATA6	varchar2(1000) PATH ''USER_DATA[6]'',
    USER_DATA7	varchar2(1000) PATH ''USER_DATA[7]'',
    USER_DATA8	varchar2(1000) PATH ''USER_DATA[8]'',
    USER_DATA9	varchar2(1000) PATH ''USER_DATA[9]'',
    USER_DATA10	varchar2(1000) PATH ''USER_DATA[10]'',
    USER_DATA11	varchar2(1000) PATH ''USER_DATA[11]'',
    SCHEDULE_GENERIC xmltype PATH ''SCHEDULE_GENERIC'',
    REQUEST_RECORD varchar2(1) PATH ''REQUEST_RECORD'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_schedule_view');

    vsql := 'create or replace view '||vschema||'.stg_STATION_view as
    SELECT xmlcolumns.*
    FROM (select sys_nc_rowinfo$ as res  from guide_tab ) rv,
    XMLTABLE(''/GuideData/SlicerGuideData/STATION/row''
    PASSING rv.res
    COLUMNS
    STATION_ID 	nvarchar2(100) PATH ''STATION_NUM'',
    STATION_TIME_ZONE nvarchar2(100) PATH ''STATION_TIME_ZONE'',
    STATION_NAME nvarchar2(100) PATH ''STATION_NAME'',
    STATION_CALL_SIGN nvarchar2(100) PATH ''STATION_CALL_SIGN'',
    STATION_AFFIL nvarchar2(100) PATH ''STATION_AFFIL'',
    STATION_CITY nvarchar2(100) PATH ''STATION_CITY'',
    STATION_STATE nvarchar2(100) PATH ''STATION_STATE'',
    STATION_ZIP_CODE nvarchar2(100) PATH ''STATION_ZIP_CODE'',
    STATION_COUNTRY nvarchar2(100) PATH ''STATION_COUNTRY'',
    DMA_NAME nvarchar2(100) PATH ''DMA_NAME'',
    DMA_NUM nvarchar2(100) PATH ''DMA_NUM'',
    FCC_CHANNEL_NUM nvarchar2(100) PATH ''FCC_CHANNEL_NUM'',
    USER_DATA1	varchar2(1000) PATH ''USER_DATA[1]'',
    USER_DATA2	varchar2(1000) PATH ''USER_DATA[2]'',
    USER_DATA3	varchar2(1000) PATH ''USER_DATA[3]'',
    USER_DATA4	varchar2(1000) PATH ''USER_DATA[4]'',
    USER_DATA5	varchar2(1000) PATH ''USER_DATA[5]'',
    USER_DATA6	varchar2(1000) PATH ''USER_DATA[6]'',
    USER_DATA7	varchar2(1000) PATH ''USER_DATA[7]'',
    USER_DATA8	varchar2(1000) PATH ''USER_DATA[8]'',
    USER_DATA9	varchar2(1000) PATH ''USER_DATA[9]'',
    USER_DATA10	varchar2(1000) PATH ''USER_DATA[10]''
    ) xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_station_view');

    vsql := 'DROP TABLE '||vschema||'."STG_HEADEND" PURGE';
    CREATEOBJECT(vsql,'Drop table stg_headend','Y');

    vsql := 'CREATE TABLE '||vschema||'."STG_HEADEND"
    (	"FILENAME" VARCHAR2(4000 BYTE),
    "HEADEND_ID" NVARCHAR2(100),
    "COMMUNITY_NAME" NVARCHAR2(200),
    "COUNTY_NAME" NVARCHAR2(200),
    "COUNTY_SIZE" NVARCHAR2(1),
    "ST_COUNTY_CODE" NVARCHAR2(100),
    "STATE" NVARCHAR2(2),
    "ZIPCODE" NVARCHAR2(100),
    "DMA_CODE" NVARCHAR2(100),
    "DMA_NAME" NVARCHAR2(300),
    "MSO_CODE" NUMBER,
    "DMA_RANK" NVARCHAR2(10),
    "HEADEND_NAME" NVARCHAR2(1000),
    "HEADEND_LOCATION" NVARCHAR2(100),
    "MSO_NAME" NVARCHAR2(200),
    "TIME_ZONE" NVARCHAR2(100)
    ) nologging';
    CREATEOBJECT(vsql,'create table stg_headend');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STG_HEADEND" PURGE';
    CREATEOBJECT(vsql,'Drop table err$_stg_headend','Y');

    vsql := 'BEGIN
                DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STG_HEADEND'', ERR_LOG_TABLE_OWNER => '''||vschema||''');
             END;';
    CREATEOBJECT(vsql,'create table err$_stg_headend');

    vsql := 'DROP TABLE '||vschema||'."STG_LINEUP" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_LINEUP','Y');

    vsql := 'CREATE TABLE '||vschema||'."STG_LINEUP"
    (	"FILENAME" VARCHAR2(4000 BYTE),
    "ROW_ID" NUMBER,
    "STATION_NUM" nvarchar2(100),
    "HEADEND_ID" nvarchar2(100),
    "DEVICE" NVARCHAR2(2),
    "TMS_CHANNEL" NVARCHAR2(20),
    "SERVICE_TIER" NVARCHAR2(1),
    "EFFECTIVE_DATE" TIMESTAMP (0)	WITH TIME ZONE,
    "EXPIRATION_DATE" TIMESTAMP (0)	WITH TIME ZONE
    ) nologging';
    CREATEOBJECT(vsql,'create table stg_lineup');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STG_LINEUP" PURGE';
    CREATEOBJECT(vsql,'Drop table err$_STG_LINEUP','Y');

    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STG_LINEUP'', ERR_LOG_TABLE_OWNER => '''||vschema||''');
    END;';
    CREATEOBJECT(vsql,'create table err$_stg_lineup');

    vsql := 'DROP TABLE '||vschema||'."STG_STATION" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_STATION','Y');

    vsql := 'CREATE TABLE '||vschema||'."STG_STATION"
    (	"FILENAME" VARCHAR2(4000 BYTE),
    "STATION_ID" NVARCHAR2(100),
    "TIME_ZONE" NVARCHAR2(100),
    "STATION_NAME" NVARCHAR2(100),
    "CALL_SIGN" NVARCHAR2(100),
    "AFFILIATION" NVARCHAR2(100),
    "CITY" NVARCHAR2(100),
    "STATE" NVARCHAR2(100),
    "ZIPCODE" NVARCHAR2(100),
    "COUNTRY" NVARCHAR2(100),
    "DMA_NAME" NVARCHAR2(100),
    "DMA_NUMBER" NVARCHAR2(100),
    "FCC_CHANNEL_NUM" NVARCHAR2(100),
    "USER_DATA1" VARCHAR2(1000),
    "USER_DATA2" VARCHAR2(1000),
    "USER_DATA3" VARCHAR2(1000),
    "USER_DATA4" VARCHAR2(1000),
    "USER_DATA5" VARCHAR2(1000),
    "USER_DATA6" VARCHAR2(1000),
    "USER_DATA7" VARCHAR2(1000),
    "USER_DATA8" VARCHAR2(1000),
    "USER_DATA9" VARCHAR2(1000),
    "USER_DATA10" VARCHAR2(1000)
     ) nologging';
    CREATEOBJECT(vsql,'create table stg_station');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STG_STATION" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_STATION','Y');

    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STG_STATION'', ERR_LOG_TABLE_OWNER => '''||vschema||''');
    END;';
    CREATEOBJECT(vsql,'create table err$_stg_station');

    vsql := 'DROP TABLE '||vschema||'."STG_PROGRAM" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_PROGRAM','Y');

    vsql := 'CREATE TABLE '||vschema||'."STG_PROGRAM"
    (	"FILENAME" VARCHAR2(4000 BYTE),
      "PROGRAM_ID" NVARCHAR2(100),
      "LANGUAGE" NVARCHAR2(100),
      "TITLE" NVARCHAR2(1000),
      "REDUCED_TITLE1" NVARCHAR2(1000),
      "REDUCED_TITLE2" NVARCHAR2(1000),
      "REDUCED_TITLE3" NVARCHAR2(1000),
      "REDUCED_TITLE4" NVARCHAR2(1000),
      "ALT_TITLE" NVARCHAR2(1000),
      "REDUCED_DESCRIPTION1" NVARCHAR2(1000),
      "REDUCED_DESCRIPTION2" NVARCHAR2(1000),
      "REDUCED_DESCRIPTION3" NVARCHAR2(1000),
      "REDUCED_DESCRIPTION4" NVARCHAR2(1000),
      "ADVISORY_DESC1" NVARCHAR2(100),
      "ADVISORY_DESC2" NVARCHAR2(100),
      "ADVISORY_DESC3" NVARCHAR2(100),
      "ADVISORY_DESC4" NVARCHAR2(100),
      "ADVISORY_DESC5" NVARCHAR2(100),
      "ADVISORY_DESC6" NVARCHAR2(100),
      "GENRE_DESC1" NVARCHAR2(100),
      "GENRE_DESC2" NVARCHAR2(100),
      "GENRE_DESC3" NVARCHAR2(100),
      "GENRE_DESC4" NVARCHAR2(100),
      "GENRE_DESC5" NVARCHAR2(100),
      "GENRE_DESC6" NVARCHAR2(100),
      "DESCRIPTION1" NVARCHAR2(2000),
      "DESCRIPTION2" NVARCHAR2(2000),
      "YEAR_PROGRAM" NVARCHAR2(100),
      "MPAA_RATING" NVARCHAR2(1000),
      "STAR_RATING" NVARCHAR2(1000),
      "RUN_TIME" VARCHAR2(100),
      "COLOR_CODE" NVARCHAR2(100),
      "PROGRAM_LANGUAGE" NVARCHAR2(100),
      "COUNTRY_OF_ORIGIN" NVARCHAR2(100),
      "MADE_FOR_TV" NVARCHAR2(1),
      "SOURCE_TYPE" NVARCHAR2(100),
      "SHOW_TYPE" NVARCHAR2(200),
      "HOLIDAY" NVARCHAR2(100),
      "SYNDICATE_EPISODE_NUM" NVARCHAR2(100),
      "ALT_SYNDICATE_EPI_NUM" NVARCHAR2(100),
      "EPISODE_TITLE" NVARCHAR2(1000),
      "NET_SYN_SOURCE" NVARCHAR2(100),
      "NET_SYN_TYPE" NVARCHAR2(100),
      "ORG_STUDIO" NVARCHAR2(100),
      "GAME_DATETIME" TIMESTAMP (0) WITH TIME ZONE,
      "GAME_TIMEZONE" NVARCHAR2(100),
      "ORG_AIR_DATE" TIMESTAMP (0) WITH TIME ZONE,
      "UNIQUE_ID" NVARCHAR2(100),
      "USER_DATA1" VARCHAR2(1000),
      "USER_DATA2" VARCHAR2(1000),
      "USER_DATA3" VARCHAR2(1000),
      "USER_DATA4" VARCHAR2(1000),
      "USER_DATA5" VARCHAR2(1000),
      "USER_DATA6" VARCHAR2(1000),
      "USER_DATA7" VARCHAR2(1000),
      "USER_DATA8" VARCHAR2(1000),
      "USER_DATA9" VARCHAR2(1000),
      "USER_DATA10" VARCHAR2(1000),
      "USER_DATA11" VARCHAR2(1000),
      "USER_DATA12" VARCHAR2(1000),
      "USER_DATA13" VARCHAR2(1000),
      "PROGRAM_GENERIC" XMLTYPE,
      "CAST_NAME_ROLE" XMLTYPE,
      "CREDITS_NAME_ROLE" XMLTYPE,
      "PROGRAM_RATING" XMLTYPE,
      "AUDIO_COMPONENT"	XMLTYPE,
      "SUBTITLE_COMPONENT"	XMLTYPE
    ) nologging';
    CREATEOBJECT(vsql,'create table STG_PROGRAM');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STG_PROGRAM" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_PROGRAM','Y');

    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STG_PROGRAM'', ERR_LOG_TABLE_OWNER => '''||vschema||''',skip_unsupported=>TRUE);
    END;';
    CREATEOBJECT(vsql,'create table err$_STG_PROGRAM');

/*    vsql := 'CREATE INDEX "IDX_STGPRG_PRGID" ON STG_PROGRAM(DATABASE_KEY)';
    CREATEOBJECT(vsql,'Create Index IDX_STGPRG_PRGID','Y');
*/
    vsql := 'DROP TABLE '||vschema||'."STG_SCHEDULE" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_SCHEDULE','Y');

    vsql := 'CREATE TABLE '||vschema||'."STG_SCHEDULE"
       (	"FILENAME" VARCHAR2(4000 BYTE),
      "STATION_NUM" NVARCHAR2 (100),
      "DATABASE_KEY" NVARCHAR2(100),
      "SCHEDULE_LANGUAGE" NVARCHAR2(100),
      "START_TIME" TIMESTAMP(0) with time zone,
      "END_TIME" timestamp(0) with time zone as (start_time + numtodsinterval(duration,''SECOND'')),
      "DURATION" NUMBER,
      "PART_NUMBER" NUMBER,
      "NO_OF_PARTS" NUMBER,
      "CC" NVARCHAR2(1),
      "STEREO" NVARCHAR2(1),
      "REPEAT" NVARCHAR2(1),
      "LIVE_TAPE_DELAY" NVARCHAR2(100),
      "SUBTITLED" NVARCHAR2(1),
      "PREMIERE_FINALE" NVARCHAR2(100),
      "JOINED_IN_PROGRESS" NVARCHAR2(1),
      "CABLE_IN_CLASSROOM" NVARCHAR2(1),
      "TV_RATING" NVARCHAR2(1000),
      "SAP" NVARCHAR2(1),
      "BLACKOUT" NVARCHAR2(1),
      "SEX_RATING" NVARCHAR2(1),
      "VIOLENCE_RATING" NVARCHAR2(1),
      "LANGUAGE_RATING" NVARCHAR2(1),
      "DIALOG_RATING" NVARCHAR2(1),
      "FV_RATING" NVARCHAR2(1),
      "ENHANCED" NVARCHAR2(1),
      "THREE_D" NVARCHAR2(1),
      "LETTERBOX" NVARCHAR2(1),
      "HD_TV" NVARCHAR2(1),
      "DOLBY" NVARCHAR2(100),
      "DVS" NVARCHAR2(1),
      "EVENT_ID" XMLTYPE,
      "SERIES_LINK" XMLTYPE,
      "USER_DATA1" VARCHAR2(1000),
      "USER_DATA2" VARCHAR2(1000),
      "USER_DATA3" VARCHAR2(1000),
      "USER_DATA4" VARCHAR2(1000),
      "USER_DATA5" VARCHAR2(1000),
      "USER_DATA6" VARCHAR2(1000),
      "USER_DATA7" VARCHAR2(1000),
      "USER_DATA8" VARCHAR2(1000),
      "USER_DATA9" VARCHAR2(1000),
      "USER_DATA10" VARCHAR2(1000),
      "USER_DATA11" VARCHAR2(1000),
      "SCHEDULE_GENERIC"	XMLTYPE,
      "REQUEST_RECORD" VARCHAR2(1)
       ) nologging';
    CREATEOBJECT(vsql,'create table STG_SCHEDULE');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STG_SCHEDULE" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_SCHEDULE','Y');

    vsql := 'BEGIN
              DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STG_SCHEDULE'', ERR_LOG_TABLE_OWNER => '''||vschema||''',skip_unsupported=>TRUE);
            END;';
    CREATEOBJECT(vsql,'create table err$_STG_SCHEDULE');
/*
    vsql := 'CREATE INDEX "IDX_STGSCH_PK" ON STG_SCHEDULE(STATION_NUM,DATABASE_KEY,AIR_DATE)';
    CREATEOBJECT(vsql,'Create Index IDX_STGSCH_PK','Y');
*/
    vsql := 'DROP TABLE '||vschema||'."STG_CASTCREDITS" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_CASTCREDITS','Y');

    vsql := 'CREATE TABLE '||vschema||'."STG_CASTCREDITS"
       (	"FILENAME" VARCHAR2(4000),
          "DATABASE_KEY" NVARCHAR2(100),
          "TYPE" NVARCHAR2(100),
          "FIRST_NAME" NVARCHAR2(100),
          "LAST_NAME" NVARCHAR2(100),
          "ROLE_DESC" NVARCHAR2(100)
       ) nologging';
    CREATEOBJECT(vsql,'create table STG_SCHEDULE');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STG_CASTCREDITS" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_CASTCREDITS','Y');

    vsql := 'BEGIN
              DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STG_CASTCREDITS'', ERR_LOG_TABLE_OWNER => '''||vschema||''');
            END;';
    CREATEOBJECT(vsql,'create table err$_stg_castcredits','Y');

    vsql := 'DROP TABLE '||vschema||'."STG_SERIES" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_SERIES','Y');

    vsql := 'CREATE TABLE '||vschema||'.STG_SERIES(FILENAME VARCHAR2(4000 BYTE),
              PROGRAM_ID NVARCHAR2(100),
              SERIES_ID NVARCHAR2(100)) nologging';
    CREATEOBJECT(vsql,'create table STG_SERIES');

    vsql := 'DROP TABLE '||vschema||'.epgguidedata_log PURGE';
    CREATEOBJECT(vsql,'Drop table epgguidedata_log','Y');

    vsql := 'CREATE TABLE '||vschema||'.epgguidedata_log(logdatetime timestamp default localtimestamp,
              description clob)';
    CREATEOBJECT(vsql,'create table epgguidedata_log');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STG_SERIES" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_SERIES','Y');

    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STG_SERIES'', ERR_LOG_TABLE_OWNER => '''||vschema||''');
    END;';
    CREATEOBJECT(vsql,'create table err$_STG_SERIES');

    vsql := 'DROP TABLE '||vschema||'."ERR$_STATION" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STATION','Y');

    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.STATION'', ERR_LOG_TABLE_OWNER => '''||vschema||''');
    END;';
    CREATEOBJECT(vsql,'create table err$_STATION');

    vsql := 'DROP TABLE '||vschema||'."ERR$_LINEUP" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_LINEUP','Y');

    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => '''||vschema||'.LINEUP'', ERR_LOG_TABLE_OWNER => '''||vschema||''');
    END;';
    CREATEOBJECT(vsql,'create table err$_LINEUP');

/*    vsql := 'DROP SEQUENCE EPGXMLFILES_SEQ';
    CREATEOBJECT(vsql,'drop sequence epgxmlfiles_seq','Y');

    vsql := 'CREATE SEQUENCE EPGXMLFILES_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create sequence epgxmlfiles_seq');
*/
    createupdatetrg('CONFIG_SETTING');
    createupdatetrg('HEADEND');
    createupdatetrg('LINEUP');
    createupdatetrg('SERIES');
    createupdatetrg('SERIES_PROGRAM_MAP');
    createupdatetrg('STATION');
    createupdatetrg('PROGRAM');
    createupdatetrg('SCHEDULE');
    createupdatetrg('RECORDING');
    createupdatetrg('RECORDING_QUEUE');
    createupdatetrg('CAST_CREDITS');
    createupdatetrg('ALARM_ACTIVITYLOG');
    createupdatetrg('RECORDING_LOG');
    createupdatetrg('ERROR_CODE');
    --Insert data
    vsql := 'insert into '||vschema||'.config_setting(key,value,created_by,updated_by) values (''PROGRAM.METADATA'',''TITLE,DESCRIPTION1,MPAA_RATING,EPISODE_TITLE'',''SYSTEM'',''SYSTEM'')';
    CREATEOBJECT(vsql,'insert into config_setting PROGRAM METADATA','Y');

    vsql := 'insert into '||vschema||'.config_setting(key,value,created_by,updated_by) values (''SCHEDULE.METADATA'',''REPEAT,CC,TV_RATING'',''SYSTEM'',''SYSTEM'')';
    CREATEOBJECT(vsql,'insert into config_setting SCHEDULE METADATA','Y');

    commit;

    /************************** TSTV USER / ROLES ***********************/


    vsql := 'CREATE TABLE '||vschema||'.USER_EXT
        (
          USERID  NUMBER NOT NULL,
          ALL_RM_ACCESS NUMBER (1, 0) DEFAULT 1 NOT NULL ,
          CREATED_BY NVARCHAR2 (50) NOT NULL ,
          UPDATED_BY NVARCHAR2 (50) NOT NULL ,
          CREATE_DATE TIMESTAMP  NOT NULL ,
          UPDATE_DATE TIMESTAMP  NOT NULL ,
          CONSTRAINT USER_EXT_PK  PRIMARY KEY ( USERID )
    )';
    CREATEOBJECT(vsql,'create TABLE USER_EXT');

    -- For admin user insert all_rm_access permission
   vsql := ' insert into '||vschema||'.user_ext(userid, all_rm_access, create_date, update_date, created_by, updated_by)
			values (1, 1, current_timestamp, current_timestamp, ''system'',''system'')';

	CREATEOBJECT(vsql,'Inserting the admin record into USER_EXT');


    vsql := 'CREATE TABLE '||vschema||'.USER_RM_MAP
        (
            USERID  NUMBER NOT NULL,
            RM_ID	NUMBER(19,0) NOT NULL ,
            CONSTRAINT USER_RM_MAP_PK   PRIMARY KEY ( USERID, RM_ID )
    )';
    CREATEOBJECT(vsql,'create TABLE USER_RM_MAP');

	vsql :='CREATE TABLE '||vschema||'.rec_rules_auto_approve_fields
    (
      id  number (19,0) not null,
      rule_id    NUMBER(19,0) NOT NULL ,
      mapping_id NUMBER(19,0) NOT NULL,
      value nvarchar2(2000) NOT NULL ,
      compare_operator VARCHAR2(10) DEFAULT ''='',
      CREATED_BY NVARCHAR2(50) NOT NULL ,
      UPDATED_BY NVARCHAR2(50) NOT NULL ,
      CREATE_DATE TIMESTAMP (6) NOT NULL ,
      UPDATE_DATE TIMESTAMP (6) NOT NULL ,
      CONSTRAINT REC_RULES_AA_FIELD_PK PRIMARY KEY (id),
      CONSTRAINT REC_RULES_AA_FIELD_UNIQUE unique  (rule_id, mapping_id,value),
      CONSTRAINT RR_AA_F_REC_RULES_FK FOREIGN KEY (rule_id) REFERENCES '||vschema||'.RECORDING_RULES (rule_id),
      CONSTRAINT RR_AA_F_ENTITY_MAPPING_FK FOREIGN KEY (mapping_id) REFERENCES '||vschema||'.ENTITY_MAPPING (mapping_id)
    )';
	CREATEOBJECT(vsql,'create TABLE rec_rules_auto_approve_fields');

	vsql := 'create table '||vschema||'.temp_station_sch_range
					(
						STATION_ID NVARCHAR2(100) primary key,
						first_schedule_start_time timestamp(0) with time zone,
						last_schedule_end_time timestamp(0) with time zone
					)';
	CREATEOBJECT(vsql, 'create TABLE temp_station_sch_range');

	vsql := ' create table '||vschema||'.temp_program_ids(program_id NVARCHAR2(100)) ';

	CREATEOBJECT(vsql, 'create TABLE temp_program_ids');


	vsql := 'CREATE SEQUENCE '||vschema||'.rec_rules_aa_fields_SEQ START WITH 1 INCREMENT BY 1';
	CREATEOBJECT(vsql,'create SEQUENCE rec_rules_aa_fields_SEQ');
	
	vsql := ' create table '||vschema||'.temp_recordings_for_rules(recording_id number(19))';
	CREATEOBJECT(vsql,vsql);
		 
 	vsql := ' CREATE INDEX '||vschema||'.temp_recordings_for_rules_idx ON '||vschema||'.temp_recordings_for_rules (RECORDING_ID)';
	CREATEOBJECT(vsql,vsql);
	 	 	
	 
    commit;


    /******************************** CREATE VIEWS ************************************/
      vsql := 'create or replace view '||vschema||'.stg_SCHEDULE_view as
    SELECT xmlcolumns.*
    FROM (select sys_nc_rowinfo$ as res  from guide_tab ) rv,
    XMLTABLE(''/GuideData/SlicerGuideData/SCHEDULE/row''
    PASSING rv.res
    COLUMNS
    STATION_NUM 	NVARCHAR2 (100) PATH ''STATION_NUM'',
    DATABASE_KEY 	nvarchar2(100) PATH ''DATABASE_KEY'',
    SCHEDULE_LANGUAGE		nvarchar2(100) PATH ''LANGUAGE'',
    AIR_DATE 	varchar2(200) PATH ''AIR_DATE'',
    DURATION 		varchar2(100) PATH ''DURATION'',
    EVENT_ID		xmltype PATH ''EVENT_ID'',
    PART_NUM 		number PATH ''PART_NUM'',
    NUM_OF_PARTS 		number PATH ''NUM_OF_PARTS'',
    SERIES_LINK			xmltype PATH ''SERIES_LINK'',
    CC varchar2(1) PATH ''CC'',
    STEREO 		varchar2(1) PATH ''STEREO'',
    REPEAT 		varchar2(1) PATH ''REPEAT'',
    LIVE_TAPE_DELAY 	varchar2(100) PATH ''LIVE_TAPE_DELAY'',
    SUBTITLED varchar2(1) PATH ''SUBTITLED'',
    PREMIERE_FINALE 	varchar2(100)  PATH ''PREMIERE_FINALE'',
    JOINED_IN_PROGRESS 		varchar2(1)  PATH ''JOINED_IN_PROGRESS'',
    CABLE_IN_THE_CLASSROOM 		varchar2(1) PATH ''CABLE_IN_THE_CLASSROOM'',
    TV_RATING 		varchar2(1000)  PATH ''TV_RATING'',
    SAP varchar2(1) PATH ''SAP'',
    BLACKOUT varchar2(1) PATH ''BLACKOUT'',
    SEX_RATING varchar2(1) PATH ''SEX_RATING'',
    VIOLENCE_RATING varchar2(1) PATH ''VIOLENCE_RATING'',
    LANGUAGE_RATING varchar2(1) PATH ''LANGUAGE_RATING'',
    DIALOG_RATING varchar2(1)  PATH ''DIALOG_RATING'',
    FV_RATING varchar2(1)  PATH ''FV_RATING'',
    ENHANCED varchar2(1) PATH ''ENHANCED'',
    THREE_D varchar2(1) PATH ''THREE_D'',
    LETTERBOX varchar2(1) PATH ''LETTERBOX'',
    HDTV varchar2(1) PATH ''HDTV'',
    DOLBY nvarchar2(100) PATH ''DOLBY'',
    DVS varchar2(1) PATH ''DVS'',
    USER_DATA1	varchar2(1000) PATH ''USER_DATA[1]'',
    USER_DATA2	varchar2(1000) PATH ''USER_DATA[2]'',
    USER_DATA3	varchar2(1000) PATH ''USER_DATA[3]'',
    USER_DATA4	varchar2(1000) PATH ''USER_DATA[4]'',
    USER_DATA5	varchar2(1000) PATH ''USER_DATA[5]'',
    USER_DATA6	varchar2(1000) PATH ''USER_DATA[6]'',
    USER_DATA7	varchar2(1000) PATH ''USER_DATA[7]'',
    USER_DATA8	varchar2(1000) PATH ''USER_DATA[8]'',
    USER_DATA9	varchar2(1000) PATH ''USER_DATA[9]'',
    USER_DATA10	varchar2(1000) PATH ''USER_DATA[10]'',
    USER_DATA11	varchar2(1000) PATH ''USER_DATA[11]'',
    SCHEDULE_GENERIC xmltype PATH ''SCHEDULE_GENERIC'',
    REQUEST_RECORD varchar2(1) PATH ''REQUEST_RECORD'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_schedule_view');


    vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."REC_RULES_VIEW" ("CONTRACT_TITLE", "SCHEDULE_ID", "RULE_ID", "SCHEDULE_START_TIME", "SCHEDULE_END_TIME", "PROGRAM_TITLE", "STATION_CALL_SIGN", "RM_ID","HEADEND_ID", "POOL_ID") AS
          select distinct contract_title, schedule_id,rule_id,sstart_time,send_time,program_title,station_call_sign,rm_id,headend_id, pool_id
          from
                (select rm.rm_id as rm_id, rm.headend_id as headend_id, rtc_pool.pool_id,
                c.title as contract_title,s.schedule_id as schedule_id,rr.rule_id as rule_id,s.station_id as sstation_id,
                sta.call_sign as station_call_sign,s.program_id as sprogram_id, p.title as program_title,
                s.start_time as sstart_time, s.end_time as send_time,
                upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat,
                case when upper(s.live_tape_delay) = ''DELAY'' then cast(''TAPE'' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
                upper(trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY''))) as sdayofweek,
                upper(nvl(trim(rr.day_of_week),trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY'')))) as rdayofweek,
                rr.start_date as rstart_date, rr.end_date as rend_date,
                upper(rr.repeat) as rrepeat, upper(rr.hd) as rhd_tv, upper(rr.live) as rlive,
                nvl(rpm.program_id,s.program_id) as rpmprogram_id,
                case
                  when rserm.series_id  is null then nvl(rserm.program_id,s.program_id)
                  when rserm.series_id  is not null then rserm.program_id
                end as rsermprogram_id,
                nvl(rstam.station_id,s.station_id) as rstamstation_id
                from '||vschema||'.schedule s
                join '||vschema||'.contract c on (c.status = 1 and s.recordable=1 and s.start_time >= current_timestamp and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
                join '||vschema||'.recording_rules rr on (rr.state =1 and ((s.start_time >= rr.start_date and s.end_time <= rr.end_date) OR (rr.start_date is null and rr.end_date is null)))
                join '||vschema||'.program p on (s.program_id = p.program_id)
                join '||vschema||'.station sta on (sta.station_id = s.station_id)
				join (select rrm.schedule_id,rrm.rm_id , r.right_id, r.contract_id
                        from '||vschema||'.recordable_rights_map rrm ,   '||vschema||'.right r
                        where r.right_id = rrm.right_id and r.state=1 ) rrmouter
                      on (rrmouter.schedule_id = s.schedule_id
                          and rrmouter.contract_id = c.contract_id)
                join '||vschema||'.right_rm_map rightrm on (rightrm.right_id = rrmouter.right_id and rrmouter.rm_id = rightrm.rm_id)
                join '||vschema||'.rec_rules_rm_map rrrm on (rightrm.rm_id = rrrm.rm_id and rr.rule_id = rrrm.rule_id)
                join '||vschema||'.rm on (rm.rm_id = rightrm.rm_id)
                join '||vschema||'.headend he on (rm.headend_id = he.headend_id)
                join '||vschema||'.rtc_pool on (rm.rm_id = rtc_pool.rm_id)
                join '||vschema||'.rm_lineup rl on (rl.rm_id = rm.rm_id and rl.station_id=sta.station_id and rl.headend_id = rm.headend_id)
                left outer join '||vschema||'.rec_rules_program_map rpm on (rr.rule_id = rpm.rule_id )
                left outer join (select rserm_inner.series_id as series_id, rserm_inner.rule_id as rule_id, spm.program_id as program_id
                    from '||vschema||'.rec_rules_series_map rserm_inner left outer join '||vschema||'.series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm
                    on (rr.rule_id = rserm.rule_id)
                left outer join '||vschema||'.rec_rules_station_map rstam on (rr.rule_id = rstam.rule_id)
                 where
                 	   NVL(rr.start_time,to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))) <= to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))
                          AND NVL(rr.end_time + numtodsinterval(TO_CHAR(s.start_time at TIME zone TO_CHAR(he.time_zone),''J''),''DAY''),
                          to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss'')))
                           >= to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss''))

                ) recinnerview
          where sstation_id = rstamstation_id
          and sprogram_id = rpmprogram_id
          and sprogram_id = rsermprogram_id
          and  rdayofweek like ''%''||sdayofweek||''%''
          and (srepeat = rrepeat or rrepeat is null)
          and (shd_tv = rhd_tv or rhd_tv is null)
          and (slive = rlive or rlive is null)
          and not exists (select 1 from '||vschema||'.recording r where r.schedule_id = recinnerview.schedule_id and r.pool_id = recinnerview.pool_id  and r.status <> 1)';
          CREATEOBJECT(vsql,'CREATE VIEW REC_RULES_VIEW');

  vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."REC_RULES_SCHEDULECHK_VIEW" ("RECORDING_ID","RULE_ID") AS
            select distinct recording_id, rule_id
            from
                  (select r.recording_id,s.schedule_id as schedule_id,rr.rule_id as rule_id,s.station_id as sstation_id,
                  s.program_id as sprogram_id,
                  s.start_time as sstart_time, s.end_time as send_time,
                  upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat,
                  case when upper(s.live_tape_delay) = ''DELAY'' then cast(''TAPE'' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
                   upper(trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY''))) as sdayofweek,
                   upper(nvl(trim(rr.day_of_week),trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY'')))) as rdayofweek,
                  rr.start_date as rstart_date, rr.end_date as rend_date,
                  upper(rr.repeat) as rrepeat, upper(rr.hd) as rhd_tv, upper(rr.live) as rlive,
                  nvl(rpm.program_id,s.program_id) as rpmprogram_id,
                  case
                  when rserm.series_id  is null then nvl(rserm.program_id,s.program_id)
                  when rserm.series_id  is not null then rserm.program_id
                end as rsermprogram_id,
                  nvl(rstam.station_id,s.station_id) as rstamstation_id
                  from '||vschema||'.schedule s
                  join '||vschema||'.contract c on (c.status = 1 and s.recordable=1 and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
                      join recording_rules rr on (rr.state =1 and ((s.start_time >= rr.start_date and s.end_time <= rr.end_date) OR (rr.start_date is null and rr.end_date is null)))
                  join '||vschema||'.rec_rules_rm_map rrrm on (rr.rule_id = rrrm.rule_id)
                  join '||vschema||'.rm on (rm.rm_id = rrrm.rm_id)
                  join '||vschema||'.headend he on (rm.headend_id = he.headend_id)
                  join '||vschema||'.rtc_pool on (rtc_pool.rm_id = rm.rm_id)
                  join '||vschema||'.recording r on (r.schedule_id = s.schedule_id and r.pool_id = rtc_pool.pool_id)
                  left outer join '||vschema||'.rec_rules_program_map rpm on (rr.rule_id = rpm.rule_id )
                  left outer join (select rserm_inner.series_id as series_id, rserm_inner.rule_id as rule_id, spm.program_id as program_id
                      from '||vschema||'.rec_rules_series_map rserm_inner left outer join '||vschema||'.series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm
                      on (rr.rule_id = rserm.rule_id)
                  left outer join '||vschema||'.rec_rules_station_map rstam on (rr.rule_id = rstam.rule_id)
                  where
                   NVL(rr.start_time,to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))) <= to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))
                          AND NVL(rr.end_time + numtodsinterval(TO_CHAR(s.start_time at TIME zone TO_CHAR(he.time_zone),''J''),''DAY''),
                          to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss'')))
                           >= to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss''))


                  )
            where sstation_id = rstamstation_id
            and sprogram_id = rpmprogram_id
            and sprogram_id = rsermprogram_id
            and  rdayofweek like ''%''||sdayofweek||''%''
            and (srepeat = rrepeat or rrepeat is null)
            and (shd_tv = rhd_tv or rhd_tv is null)
            and (slive = rlive or rlive is null)';

    CREATEOBJECT(vsql,'CREATE VIEW REC_RULES_SCHEDULECHK_VIEW');

    vsql := 'CREATE OR REPLACE VIEW '||vschema||'.RECORDING_QUEUE_VIEW AS
            SELECT *
            FROM
              (SELECT recq.recording_queue_id,
                rm_id,
                rank() over (partition BY recq.rm_id order by recq.schedule_start_time,recq.recording_queue_id) AS rankrows
              FROM '||vschema||'.recording_queue recq
              ) recqueue
            WHERE recqueue.rankrows=1';
    CREATEOBJECT(vsql,'CREATE VIEW RECORDING_QUEUE_VIEW');

    vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."STG_PROGRAM_GENERIC_VIEW" ("PROGRAM_ID", "ASSETTYPE", "TRIALNAME", "TRAILNAMEVALUE") AS
            select pstg.program_id,decode(upper(xmldata.assettype), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3) as assettype ,xmldata.trialname,xmldata.trialnamevalue
          from '||vschema||'.stg_program pstg ,
            XMLTABLE(''/PROGRAM_GENERIC/PROGRAM_GENERIC'' passing pstg.program_generic columns
                assettype VARCHAR2(100) path ''@Asset'',
                TrialName NVARCHAR2(100) path ''@Name''
                ,trialnamevalue NVARCHAR2(100) path ''text()''
                ) xmldata
          where pstg.program_Generic is not null';
    CREATEOBJECT(vsql,'CREATE VIEW STG_PROGRAM_GENERIC_VIEW');

    vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."STG_SCHEDULE_GENERIC_VIEW" ("PROGRAM_ID", "STATION_ID", "START_TIME", "ASSETTYPE", "TRIALNAME", "TRAILNAMEVALUE") AS
            select sstg.database_key,sstg.station_num,sstg.start_time,decode(upper(xmldata.assettype), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3) as assettype,xmldata.trialname,xmldata.trialnamevalue
          from '||vschema||'.stg_schedule sstg ,
            XMLTABLE(''/SCHEDULE_GENERIC/SCHEDULE_GENERIC'' passing sstg.schedule_generic columns
                assettype VARCHAR2(100) path ''@Asset'',
                TrialName NVARCHAR2(100) path ''@Name''
                ,trialnamevalue NVARCHAR2(100) path ''text()''
                ) xmldata
          where sstg.schedule_Generic is not null';
    CREATEOBJECT(vsql,'CREATE VIEW STG_SCHEDULE_GENERIC_VIEW');

    vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."PROGRAM_GENERIC" ("PROGRAM_ID", "ASSET_TYPE", "NAME", "VALUE", "MAPPING_ID") AS
        select p.program_id,CAST (decode(upper(xmldata.asset_type), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3) AS NUMBER) as asset_type, xmldata.name,xmldata.value, em.mapping_id
        from '||vschema||'.program p ,
          XMLTABLE(''/PROGRAM_GENERIC/PROGRAM_GENERIC'' passing p.program_generic columns
              asset_type VARCHAR2(100) path ''@Asset'',
              name NVARCHAR2(100) path ''@Name''
              ,value NVARCHAR2(100) path ''text()''
              ) xmldata
              ,'||vschema||'.entity_mapping em
        where p.program_Generic is not null
        and upper(em.table_name)=''PROGRAM'' and upper(em.column_name)=''PROGRAM_GENERIC'' and em.generic_name = xmldata.name and em.asset_type = decode(upper(xmldata.asset_type), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3)';
    CREATEOBJECT(vsql,'CREATE VIEW PROGRAM_GENERIC');


    vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."SCHEDULE_GENERIC" ("SCHEDULE_ID", "ASSET_TYPE", "NAME", "VALUE", "MAPPING_ID") AS
        select s.schedule_id, CAST (decode(upper(xmldata.asset_type), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3) AS NUMBER) as asset_type,xmldata.name,xmldata.value, em.mapping_id
        from '||vschema||'.schedule s ,
          XMLTABLE(''/SCHEDULE_GENERIC/SCHEDULE_GENERIC'' passing s.schedule_generic columns
              asset_type VARCHAR2(100) path ''@Asset'',
              name NVARCHAR2(100) path ''@Name''
              ,value NVARCHAR2(100) path ''text()''
              ) xmldata
              ,'||vschema||'.entity_mapping em
        where s.schedule_Generic is not null
          and upper(em.table_name)=''SCHEDULE'' and upper(em.column_name)=''SCHEDULE_GENERIC'' and em.generic_name = xmldata.name and em.asset_type = decode(upper(xmldata.asset_type), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3)';
    CREATEOBJECT(vsql,'CREATE VIEW SCHEDULE_GENERIC');

    /********************** CREATE RCS LOGON TRIGGER ******************/
    vsql := 'create or replace TRIGGER rcs_after_logon_trigger
    AFTER LOGON ON '||vschema||'.SCHEMA
    declare
      vtimezonesql varchar2(4000);
    BEGIN
      begin
        select ''alter session set time_zone = ''''''||value||'''''' ''
        into vtimezonesql
        from '||vschema||'.config_setting c, v$timezone_names tn
        where c.key = ''APPLICATION_DB_SERVER_TIMEZONE_KEY''
        and tn.tzname = c.value
        group by value;
      execute immediate vtimezonesql;
      exception
        when others then
          null;
      end;

    END;';
    CREATEOBJECT(vsql,'Create RCS LOGON TRIGGER','Y');

     vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
	        VALUES(''I18N_LANGUAGE_ID'', ''en'', ''System'', ''System'', current_timestamp, current_timestamp)';
     CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

     vsql := 'create table '||vschema||'.BACKEND_APPLICATION_RESOURCES ( KEY VARCHAR2(2000) NOT NULL, VALUE NVARCHAR2(2000) , LANGUAGE VARCHAR2(20) DEFAULT ''en'' NOT NULL , constraint PK_BACKEND_APP_RESOURCES  PRIMARY KEY (KEY, LANGUAGE))';
		     CREATEOBJECT(vsql,'Create table BACKEND_APPLICATION_RESOURCES');
	 vsql := 'create table '||vschema||'.temp_BACKEND_APP_RESOURCES( KEY VARCHAR2(2000) NOT NULL, VALUE NVARCHAR2(2000), LANGUAGE VARCHAR2(20) DEFAULT ''en'' NOT NULL)';
     CREATEOBJECT(vsql,'create table temp_BACKEND_APP_RESOURCES');

	    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''XMLTVenabled'', ''1'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

     --vsql := 'INSERT INTO '||vschema||'.config_setting
    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      VALUES(''XMLTVmin'', ''30'', ''System'', ''System'', current_timestamp, current_timestamp)';
    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');

     vsql := 'INSERT INTO install_Table values(sysdate,''RCS Schema Version &RCS_DB_VERSION install has completed SUCCESSFULLY.'')';
    CREATEOBJECT(vsql,'insert into install_table','Y');

END createtstv ;

  PROCEDURE convertTSTV AS
    vsql varchar2(32767);
    vtstvdbver varchar2(100);
  BEGIN
    begin
      execute immediate 'SELECT value from '||vschema||'.config_setting where key=''version'''  into vtstvdbver;
    exception
      when others then
        vtstvdbver := '3.2.0002';
    end;
	if is_table_exists('sys', 'install_Table') = false then
		vsql := 'CREATE TABLE install_Table( msgdate date default sysdate,install_message varchar2(4000))';
    	CREATEOBJECT(vsql,'Create table install_table');
    end if;

	vsql := ' declare
					      vtimezonesql varchar2(4000);
					    BEGIN
					      begin
					        select ''alter session set time_zone = ''''''||value||'''''' ''
					        into vtimezonesql
					        from '||vschema||'.config_setting c, v$timezone_names tn
					        where c.key = ''APPLICATION_DB_SERVER_TIMEZONE_KEY''
					        and tn.tzname = c.value
					        group by value;
					      execute immediate vtimezonesql;
					      exception
					        when others then
					          null;
					      end;

					    END;';
       CREATEOBJECT(vsql,'Updating the session timezone with RCS timezone');

    if vtstvdbver = '3.2.0002' then
      if is_index_exists (vschema, 'index_series_id_s_p_map') = false then
          vsql := 'create index '||vschema||'.index_series_id_s_p_map on '||vschema||'.series_program_map(series_id) ';
          CREATEOBJECT(vsql,'create index for series_id on the table SERIES_PROGRAM_MAP');
      end if;
      if is_index_exists (vschema, 'index_program_id_s_p_map') = false then
        vsql := 'create index '||vschema||'.index_program_id_s_p_map on '||vschema||'.series_program_map(program_id) ';
        CREATEOBJECT(vsql,'create index for program_id on the table SERIES_PROGRAM_MAP');
      end if;

      if is_table_exists(vschema, 'temp_schedule_conflicts') = false then

         vsql := ' CREATE TABLE '||vschema||'.temp_schedule_conflicts
        (
        schedule_id NUMBER(19,0),
        schedule_start_time TIMESTAMP(0) WITH TIME zone,
        program_title NVARCHAR2(1000),
        station_call_sign NVARCHAR2(100),
        rr_flag_change NUMBER(1)
       ) ';
      	CREATEOBJECT(vsql,' CREATE TABLE temp_schedule_conflicts');
     end if;

       if is_table_exists(vschema, 'temp_del_conflicted_recables') = false then
        vsql := ' create table '||vschema||'.temp_del_conflicted_recables(right_id number(19,0), schedule_id number(19,0)) ';
        CREATEOBJECT(vsql,'create table temp_del_conflicted_recables');
      end if;
      if is_index_exists (vschema, 'i_sid_del_conflict_recables') = false then
        vsql := ' create index '||vschema||'.i_sid_del_conflict_recables on '||vschema||'.temp_del_conflicted_recables(schedule_id)  ';
        CREATEOBJECT(vsql,'create index for shedule_id on  temp_del_conflicted_recables');
      end if;
    end if;

    if vtstvdbver < '3.3.000.0' then

          vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      		VALUES(''older_version'', '''||VTSTVDBVER||''', ''System'', ''System'', current_timestamp, current_timestamp)';
		CREATEOBJECT(vsql,' Inserting the previous RCS Web version ');



    	/************************ Migration Path for Recordings from 3.2 to 3.3 ***********************/

       /* Delete soft deleted recordings before migration.
       TSTV 3.2 does not have RM info for soft deleted recordings. RM info is required in TSTV 3.3 */
      if is_table_exists(vschema, 'rec_trial_use_fields') = true then
	       vsql := 'delete from '||vschema||'.rec_trial_use_fields rtuf
	      where rtuf.recording_id in (
	      select r.recording_id from '||vschema||'.recording r where r.status=1)';
	      CREATEOBJECT(vsql,'delete rec_trial_use_fields');
      end if;
	 if is_table_exists(vschema, 'RECORDING_REC_RULES_MAP') = true then
	      vsql := 'delete from '||vschema||'.RECORDING_REC_RULES_MAP rrrm
	      where rrrm.recording_id in (
	      select r.recording_id from '||vschema||'.recording r where r.status=1)';
	      CREATEOBJECT(vsql,'delete RECORDING_REC_RULES_MAP');
	 end if;

	  if is_table_exists(vschema, 'PLAYBACK_WINDOW_RESTRICTIONS') = true then
	      vsql := 'delete from '||vschema||'.PLAYBACK_WINDOW_RESTRICTIONS pwr
	      where pwr.recording_id in (
	      select r.recording_id from '||vschema||'.recording r where r.status=1)';
	      CREATEOBJECT(vsql,'delete PLAYBACK_WINDOW_RESTRICTIONS');
	  end if;

	 if is_table_exists(vschema, 'RECORDING_LOG') = true then
	      vsql := 'delete from '||vschema||'.RECORDING_LOG rl
	      where rl.recording_id in (
	      select r.recording_id from '||vschema||'.recording r where r.status=1)';
	      CREATEOBJECT(vsql,'delete RECORDING_LOG');
	 end if;

	 if is_table_exists(vschema, 'recording_rtc_pool_map') = true then
		  vsql := 'delete from '||vschema||'.recording_rtc_pool_map rl
	      where rl.recording_id in (
	      select r.recording_id from '||vschema||'.recording r where r.status=1)';
	      CREATEOBJECT(vsql,'delete recording_rtc_pool_map');
	 end if;

	 if is_table_exists(vschema, 'recording') = true then
	      vsql := 'delete from '||vschema||'.recording r
	      where r.status=1';
	      CREATEOBJECT(vsql,'delete recording');
	end if;
      declare
        TYPE VSQLTAB IS TABLE OF VARCHAR2(4000);
        vsql vsqltab;
      BEGIN
        SELECT SQLCMD
        BULK COLLECT INTO VSQL
        FROM
        (SELECT 'drop trigger '||vschema||'.'||TRIGGER_NAME AS SQLCMD FROM DBA_TRIGGERS
        WHERE OWNER = vschema and TABLE_NAME IN ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP')
        UNION
        SELECT STMT.SQLCMD FROM
        (SELECT
        'alter table '||vschema||'.'||TABLE_NAME||' drop constraint '||CONSTRAINT_NAME||' cascade' as sqlcmd
        FROM DBA_CONSTRAINTS
        WHERE OWNER=vschema and TABLE_NAME IN ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP')
        AND CONSTRAINT_TYPE IN ('R','P','U')
        order by constraint_type desc) STMT
        UNION
        SELECT 'drop index '||vschema||'.'||INDEX_NAME AS SQLCMD FROM DBA_INDEXES
        WHERE owner=vschema and TABLE_NAME IN ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP')
--        UNION
--        SELECT 'drop table '||vschema||'.'||TABLE_NAME||' purge' AS SQLCMD FROM DBA_TABLES
--        WHERE owner=vschema and TABLE_NAME like 'PREMIG%' or table_name like 'TMPMIG%'
        ) ;

        IF VSQL.COUNT > 0 THEN
          FOR I IN 1..VSQL.LAST LOOP
            BEGIN
              EXECUTE IMMEDIATE VSQL(I);
            EXCEPTION
              WHEN OTHERS THEN
                NULL;
            END;
          end loop;
        END IF;

      END;
     if is_table_exists(vschema, 'tmpmig_recording') = false
          and is_table_exists(vschema, 'recording_rtc_pool_map') = true
          and is_table_exists(vschema, 'recording') = true  then
          vsql := 'CREATE TABLE '||vschema||'.tmpmig_recording
            (
              RECORDING_ID,
              PROGRAM_TITLE,
              PROGRAM_DESCRIPTION,
              OFFSET_START_TIME,
              OFFSET_END_TIME,
              RECORDING_MODE,
              PRIORITY,
              PROVIDER_QA_CONTACT,
              CATALOG_ENTRY,
              BILLING_ID,
              MPAA_RATING,
              TV_RATING,
              PROVIDER_ID,
              PROVIDER_NAME,
              PRODUCT,
              CATEGORY,
              STATUS,
              AUDIO_TYPE,
              MAX_COPIES,
              PREVIEW_PERIOD,
			  LICENCE_START_DATE,
              LICENSE_END_DATE,
              APPROVAL_TYPE  default ''AUTO'',
              SCHEDULE_ID,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE,
              POOL_ID,
              ASSET_ID,
              TITLE_ASSET_ID,
              MOVIE_ASSET_ID,
              STATUS_CODE,
              CONTENT_URL,
              ADJUSTED_START_TIME,
              ADJUSTED_END_TIME,
              newrecording_id
            ) AS
          SELECT rrpm.RECORDING_ID,
            r.PROGRAM_TITLE,
            r.PROGRAM_DESCRIPTION,
            r.OFFSET_START_TIME,
            r.OFFSET_END_TIME,
            r.RECORDING_MODE,
            r.PRIORITY,
            r.PROVIDER_QA_CONTACT,
            r.CATALOG_ENTRY,
            r.BILLING_ID,
            r.MPAA_RATING,
            r.TV_RATING,
            r.PROVIDER_ID,
            r.PROVIDER_NAME,
            r.PRODUCT,
            r.CATEGORY,
            r.STATUS,
            r.AUDIO_TYPE,
            r.MAX_COPIES,
            r.PREVIEW_PERIOD,
			r.LICENCE_START_DATE,
            r.LICENSE_END_DATE,
            r.APPROVAL_TYPE,
            r.SCHEDULE_ID,
            r.CREATED_BY,
            r.UPDATED_BY,
            r.CREATE_DATE,
            r.UPDATE_DATE,
            rrpm.POOL_ID,
            rrpm.ASSET_ID,
            rrpm.TITLE_ASSET_ID,
            rrpm.MOVIE_ASSET_ID,
            rrpm.STATUS_CODE,
            rrpm.CONTENT_URL,
            rrpm.ADJUSTED_START_TIME,
            rrpm.ADJUSTED_END_TIME,
            CASE
              WHEN r.recording_id = lag(r.recording_id,1) over (order by r.recording_id)
              THEN '||vschema||'.recording_seq.nextval
              ELSE NULL
            END
          FROM '||vschema||'.recording r,
            '||vschema||'.recording_rtc_pool_map rrpm
          WHERE r.recording_id = rrpm.recording_id';
          CREATEOBJECT(vsql,'CREATE TABLE tmpmig_recording');
      end if;

      if is_table_exists(vschema, 'tmpmig_recording_log') = false
          and is_table_exists(vschema, 'TMPMIG_RECORDING') = true
          and is_table_exists(vschema, 'recording_log') = true
          then
          vsql := 'CREATE TABLE '||vschema||'.tmpmig_recording_log
            (
              RECORDING_LOG_ID,
              RECORDING_ID,
              LOG_MESSAGE,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE
            ) AS
          SELECT
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN rl.RECORDING_LOG_ID
          ELSE '||vschema||'.recording_log_seq.nextval
            END,
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN tmr.RECORDING_ID
              ELSE tmr.newrecording_id
            END,
            rl.LOG_MESSAGE,
            rl.CREATED_BY,
            rl.UPDATED_BY,
            rl.CREATE_DATE,
            rl.UPDATE_DATE
          FROM '||vschema||'.recording_log rl,
            '||vschema||'.TMPMIG_RECORDING TMR
          where rl.RECORDING_ID = TMR.RECORDING_ID';
          CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_recording_log');
      end if;

      if is_table_exists(vschema, 'tmpmig_pwr') = false
          and is_table_exists(vschema, 'TMPMIG_RECORDING') = true
          and is_table_exists(vschema, 'playback_window_restrictions') = true then
          vsql := 'CREATE TABLE '||vschema||'.tmpmig_pwr
            (
              RESTRICTION_ID,
              START_TIME,
              DURATION,
              RESTRICTIONS,
              TYPE,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE,
              RIGHT_ID,
              RECORDING_ID
            ) AS
          SELECT
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN pwr.RESTRICTION_ID
          ELSE '||vschema||'.playback_window_restr_seq.nextval
            END,
            pwr.START_TIME,
            pwr.DURATION,
            pwr.RESTRICTIONS,
            pwr.TYPE,
            pwr.CREATED_BY,
            pwr.UPDATED_BY,
            pwr.CREATE_DATE,
            pwr.UPDATE_DATE,
            pwr.RIGHT_ID,
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN tmr.RECORDING_ID
              ELSE tmr.newrecording_id
            END
          FROM '||vschema||'.playback_window_restrictions pwr,
            '||vschema||'.tmpmig_recording tmr
          where TMR.RECORDING_ID(+) = PWR.RECORDING_ID';
          CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_pwr');
       end if;
      if is_table_exists(vschema, 'tmpmig_rtuf') = false
          and is_table_exists(vschema, 'TMPMIG_RECORDING') = true
          and is_table_exists(vschema, 'rec_trial_use_Fields') = true
            then
          vsql := 'CREATE table '||vschema||'.tmpmig_rtuf ( TRIAL_USE_FIELD_ID, ASSET_TYPE, NAME, VALUE_TYPE, VALUE, MAPPING_ID, RECORDING_ID, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          AS
            SELECT
              CASE
                WHEN rtuf.TRIAL_USE_FIELD_ID=lag(rtuf.TRIAL_USE_FIELD_ID,1) over (order by rtuf.TRIAL_USE_FIELD_ID)
            THEN '||vschema||'.rec_trial_use_field_seq.nextval
                ELSE rtuf.TRIAL_USE_FIELD_ID
              END,
              rtuf.ASSET_TYPE,
              rtuf.NAME,
              rtuf.VALUE_TYPE,
              rtuf.VALUE,
              rtuf.MAPPING_ID,
              CASE
                WHEN tmr.newrecording_id IS NULL
                THEN tmr.RECORDING_ID
                ELSE tmr.newrecording_id
              END,
              rtuf.DESCRIPTION,
              rtuf.CREATED_BY,
              rtuf.UPDATED_BY,
              rtuf.CREATE_DATE,
              rtuf.UPDATE_DATE
            FROM '||vschema||'.rec_trial_use_Fields rtuf,
              '||vschema||'.tmpmig_recording tmr
            where TMR.RECORDING_ID = RTUF.RECORDING_ID';
           CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_rtuf');
        end if;
        if is_table_exists(vschema, 'tmpmig_recording_rec_rules_map') = false
            and is_table_exists(vschema, 'TMPMIG_RECORDING') = true
            and is_table_exists(vschema, 'recording_rec_rules_map') = true
            then
            vsql := 'CREATE TABLE '||vschema||'.tmpmig_recording_rec_rules_map
              (
                RECORDING_ID,
                RULE_ID,
                CREATED_BY,
                UPDATED_BY,
                CREATE_DATE,
                UPDATE_DATE
              ) AS
            SELECT
              CASE
                WHEN tmr.newrecording_id IS NULL
                THEN tmr.RECORDING_ID
                ELSE tmr.newrecording_id
              END,
              rrrm.RULE_ID,
              rrrm.CREATED_BY,
              rrrm.UPDATED_BY,
              rrrm.CREATE_DATE,
              rrrm.UPDATE_DATE
            FROM '||vschema||'.recording_rec_rules_map rrrm,
              '||vschema||'.tmpmig_recording tmr
            WHERE rrrm.recording_id = tmr.recording_id';
             CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_recording_rec_rules_map');
      end if;

      if is_table_exists(vschema, 'tmpmig_recordable_rights_map') = false
          and is_table_exists(vschema, 'recordable_rights_map') = true then
          --Migrating RECORDABLE_RIGHTS_MAP
          vsql := 'CREATE TABLE '||vschema||'.tmpmig_recordable_rights_map
            (
              SCHEDULE_ID,
              RIGHT_ID,
              RM_ID,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE
            ) AS
          SELECT DISTINCT rcdrm.SCHEDULE_ID,
            rcdrm.RIGHT_ID,
            rrm.RM_ID,
            rcdrm.CREATED_BY,
            rcdrm.UPDATED_BY,
            rcdrm.CREATE_DATE,
            rcdrm.UPDATE_DATE
          FROM '||vschema||'.recordable_rights_map rcdrm,
            '||vschema||'.right_rm_map rrm
          WHERE RCDRM.RIGHT_ID = RRM.RIGHT_ID';
           CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_recordable_rights_map');
      end if;

      /**************** START Redefining RECORDABLE_RIGHTS_MAP ******************/
      if is_table_exists(vschema, 'TMPMIG_RECORDABLE_RIGHTS_MAP') = true and is_table_exists(vschema, 'premig_recordable_rights_map') = false
          and is_table_exists(vschema, 'recordable_rights_map') = true then
        VSQL:='ALTER TABLE '||vschema||'.recordable_rights_map RENAME TO premig_recordable_rights_map';
        CREATEOBJECT(VSQL,'rename TABLE recordable_rights_map');
      end if;
      if is_table_exists(vschema, 'TMPMIG_RECORDABLE_RIGHTS_MAP') = true
          and is_table_exists(vschema, 'RECORDABLE_RIGHTS_MAP') = false
          then
        VSQL:='ALTER TABLE '||vschema||'.TMPMIG_RECORDABLE_RIGHTS_MAP RENAME to RECORDABLE_RIGHTS_MAP';
        CREATEOBJECT(VSQL,'rename TABLE TMPMIG_RECORDABLE_RIGHTS_MAP');
      end if;

      if is_constraint_exists (vschema, 'RECORDABLE_RIGHTS_MAP','RECORDABLE_RIGHTS_MAP_PK') = false then
        vsql:='ALTER TABLE '||vschema||'.RECORDABLE_RIGHTS_MAP ADD ( CONSTRAINT RECORDABLE_RIGHTS_MAP_PK PRIMARY KEY (SCHEDULE_ID, RIGHT_ID, RM_ID) , CONSTRAINT FK_REC_RIGHTS_MAP_SCH FOREIGN KEY (SCHEDULE_ID) REFERENCES '||vschema||'.SCHEDULE (SCHEDULE_ID) , CONSTRAINT FK_REC_RIGHTS_MAP_RIGHT FOREIGN KEY (RIGHT_ID, RM_ID) REFERENCES '||vschema||'.RIGHT_RM_MAP (RIGHT_ID, RM_ID) )';
        CREATEOBJECT(VSQL,'alter TABLE RECORDABLE_RIGHTS_MAP');
      end if;
      /**************** START Redefining RECORDING ******************/

      if is_table_exists(vschema, 'tmpmig_recording') = true then
          vsql:='UPDATE '||vschema||'.tmpmig_recording
                SET recording_id       = newrecording_id
                WHERE NEWRECORDING_ID IS NOT NULL';
          CREATEOBJECT(VSQL,'update TABLE tmpmig_recording');
      end if;
      if is_table_exists(vschema, 'tmpmig_recording') = true and is_table_exists(vschema, 'recording') = true and is_table_exists(vschema, 'premig_recording') = false then
          VSQL:='ALTER TABLE  '||vschema||'.recording RENAME TO premig_recording';
          CREATEOBJECT(VSQL,'RENAME TABLE recording');
      end if;

      if is_table_exists(vschema, 'tmpmig_recording') = true and  is_table_exists(vschema, 'recording') = false then
          VSQL:='ALTER TABLE '||vschema||'.tmpmig_recording RENAME TO recording';
          CREATEOBJECT(VSQL,'rename TABLE tmpmig_recording');
      end if;

      if is_constraint_exists (vschema, 'RECORDING','PK_RECORDING') = false then
        VSQL:='ALTER TABLE '||VSCHEMA||'.RECORDING ADD (CONSTRAINT PK_RECORDING PRIMARY KEY (RECORDING_ID) , CONSTRAINT RECORDING_UK1 UNIQUE (SCHEDULE_ID, POOL_ID) , CONSTRAINT FK_RECORDING_SCHEDULE FOREIGN KEY (SCHEDULE_ID) REFERENCES '||vschema||'.SCHEDULE (SCHEDULE_ID) , CONSTRAINT FK_RECORDING_POOL_ID FOREIGN KEY (POOL_ID) REFERENCES '||vschema||'.RTC_POOL (POOL_ID) )';
        CREATEOBJECT(VSQL,'alter TABLE recording');
      end if;
----      if is_constraint_exists (vschema, 'RECORDING_LOG','FK_REC_LOG_RECORDING') = false then
----        VSQL:='ALTER TABLE '||VSCHEMA||'.RECORDING_LOG ADD CONSTRAINT FK_REC_LOG_RECORDING FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING (RECORDING_ID) ';
----        CREATEOBJECT(VSQL,'alter TABLE recording_log');
----      end if;
--      if is_constraint_exists (vschema, 'RECORDING_REC_RULES_MAP','FK_REC_REC_RULES_MAP') = false then
--        VSQL:='ALTER TABLE '||VSCHEMA||'.RECORDING_REC_RULES_MAP ADD CONSTRAINT FK_REC_REC_RULES_MAP FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING (RECORDING_ID) ';
--        CREATEOBJECT(VSQL,'alter TABLE RECORDING_REC_RULES_MAP');
--      end if;
--      if is_constraint_exists (vschema, 'PLAYBACK_WINDOW_RESTRICTIONS','FK_PLAYBACK_RESTR_REC') = false then
--        VSQL:='ALTER TABLE '||VSCHEMA||'.PLAYBACK_WINDOW_RESTRICTIONS ADD CONSTRAINT FK_PLAYBACK_RESTR_REC FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING (RECORDING_ID) ';
--        CREATEOBJECT(VSQL,'ALTER TABLE PLAYBACK_WINDOW_RESTRICTIONS');
--      end if;

	--CREATE UNIQUE INDEX RCS.RECORDING_UK1 ON RCS.RECORDING (SCHEDULE_ID, POOL_ID);
      vsql:='CREATE OR REPLACE TRIGGER '||vschema||'.RECORDINGTRG BEFORE
                INSERT ON '||vschema||'.RECORDING FOR EACH ROW
              DECLARE
                vseq NUMBER;
              BEGIN
                IF ( :new.RECORDING_ID IS NULL ) THEN
                     :new.RECORDING_ID := '||vschema||'.RECORDING_SEQ.nextval;
                END IF;
              END;';
      CREATEOBJECT(VSQL,'CREATE TRIGGER RECORDINGTRG');

      vsql:='CREATE OR REPLACE TRIGGER '||vschema||'.RECORDINGUPD BEFORE
              UPDATE ON '||vschema||'.RECORDING FOR EACH ROW DECLARE vcurrent_timestamp TIMESTAMP
            WITH TIME zone;
            BEGIN
              SELECT CURRENT_TIMESTAMP INTO vcurrent_timestamp FROM dual;
              :new.update_date := vcurrent_timestamp;
            END;';
      CREATEOBJECT(VSQL,'CREATE TRIGGER RECORDINGUPD');

      vsql:='CREATE OR REPLACE TRIGGER '||vschema||'.RECORDINGCRT BEFORE
              INSERT ON '||vschema||'.RECORDING FOR EACH ROW DECLARE vcurrent_timestamp TIMESTAMP
            WITH TIME zone;
            BEGIN
              IF (:old.create_date IS NULL OR :old.update_date IS NULL) THEN
                SELECT CURRENT_TIMESTAMP INTO vcurrent_timestamp FROM dual;
                :new.create_date := vcurrent_timestamp;
                :new.update_date := vcurrent_timestamp;
              END IF;
            END;';
      CREATEOBJECT(VSQL,'CREATE TRIGGER RECORDINGCRT');

      /**************** START Redefining RECORDING_LOG ******************/
      if is_table_exists(vschema, 'TMPMIG_RECORDING_LOG') = true and is_table_exists(vschema, 'RECORDING_LOG') = true and is_table_exists(vschema, 'PREMIG_RECORDING_LOG') = false then
        VSQL:='ALTER TABLE '||vschema||'.RECORDING_LOG RENAME TO PREMIG_RECORDING_LOG';
        CREATEOBJECT(VSQL,'RENAME RECORDING_LOG');
      end if;

      if is_table_exists(vschema, 'TMPMIG_RECORDING_LOG') = true and is_table_exists(vschema, 'RECORDING_LOG') =false then
        VSQL:='ALTER TABLE '||vschema||'.TMPMIG_RECORDING_LOG RENAME TO RECORDING_LOG';
        CREATEOBJECT(VSQL,'RENAME TMPMIG_RECORDING_LOG');
      end if;

      if is_constraint_exists (vschema, 'RECORDING_LOG','PK_RECORDING_LOG_01') = false then
        VSQL:='ALTER TABLE '||vschema||'.RECORDING_LOG ADD CONSTRAINT PK_RECORDING_LOG_01 PRIMARY KEY (RECORDING_LOG_ID)' ;
        CREATEOBJECT(VSQL,'alter table RECORDING_LOG');
      end if;
      if is_constraint_exists (vschema, 'RECORDING_LOG','FK_RECORDING_LOG_RECORDING') = false then
        vsql:='ALTER TABLE '||vschema||'.RECORDING_LOG ADD CONSTRAINT FK_RECORDING_LOG_RECORDING FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING (RECORDING_ID) ';
        CREATEOBJECT(VSQL,'ALTER TABLE RECORDING_LOG');
      end if;

      if is_index_exists (vschema, 'IDX_RECORDLOG_RECORDINGID') = false then
        vsql:='CREATE INDEX '||vschema||'.IDX_RECORDLOG_RECORDINGID ON '||vschema||'.RECORDING_LOG  (    RECORDING_ID  )';
        CREATEOBJECT(VSQL,'CREATE INDEX IDX_RECORDLOG_RECORDINGID');
      end if;

      vsql:='CREATE OR REPLACE TRIGGER '||vschema||'.RECORDING_LOGTRG BEFORE
              INSERT ON '||vschema||'.RECORDING_LOG FOR EACH ROW DECLARE VSEQ NUMBER;
              BEGIN
                IF (:new.RECORDING_LOG_ID IS NULL) THEN
                  SELECT '||vschema||'.RECORDING_LOG_SEQ.nextval INTO vseq FROM dual;
                  :new.RECORDING_LOG_ID := vseq;
                END IF;
              END;';
       CREATEOBJECT(VSQL,'CREATE TRIGGER RECORDING_LOGTRG');

      vsql:='CREATE OR REPLACE TRIGGER '||vschema||'.RECORDING_LOGUPD BEFORE
              UPDATE ON '||vschema||'.RECORDING_LOG FOR EACH ROW
              DECLARE vcurrent_timestamp TIMESTAMP WITH TIME zone;
              BEGIN
                SELECT CURRENT_TIMESTAMP INTO vcurrent_timestamp FROM dual;
                :new.update_date := vcurrent_timestamp;
              END;';
       CREATEOBJECT(VSQL,'CREATE TRIGGER RECORDING_LOGUPD');

      vsql:='CREATE OR REPLACE TRIGGER '||vschema||'.RECORDING_LOGCRT BEFORE
              INSERT ON '||vschema||'.RECORDING_LOG FOR EACH ROW
              DECLARE vcurrent_timestamp TIMESTAMP WITH TIME zone;
            BEGIN
              IF (:old.create_date IS NULL OR :old.update_date IS NULL) THEN
                SELECT CURRENT_TIMESTAMP INTO vcurrent_timestamp FROM dual;
                :new.create_date := vcurrent_timestamp;
                :new.update_date := vcurrent_timestamp;
              END IF;
            END;';
       CREATEOBJECT(VSQL,'CREATE TRIGGER RECORDING_LOGCRT');

      /**************** START Redefining PLAYBACK_WINDOW_RESTRICTIONS ******************/
      if is_table_exists(vschema, 'tmpmig_pwr') = true and is_table_exists(vschema, 'PLAYBACK_WINDOW_RESTRICTIONS') = true and is_table_exists(vschema, 'PREMIG_PLAYBACK_WIN_RESTRICT') = false then
        VSQL:='ALTER TABLE '||vschema||'.PLAYBACK_WINDOW_RESTRICTIONS RENAME TO PREMIG_PLAYBACK_WIN_RESTRICT';
        CREATEOBJECT(VSQL,'rename PLAYBACK_WINDOW_RESTRICTIONS');
      end if;
      if is_table_exists(vschema, 'tmpmig_pwr') = true and is_table_exists(vschema, 'PLAYBACK_WINDOW_RESTRICTIONS') = false  then
        VSQL:='ALTER TABLE '||vschema||'.tmpmig_pwr RENAME TO PLAYBACK_WINDOW_RESTRICTIONS';
        CREATEOBJECT(VSQL,'RENAME tmpmig_pwr');
      end if;
      if is_constraint_exists (vschema, 'PLAYBACK_WINDOW_RESTRICTIONS','PK_PLAYBACK_WINDOW_RESTR_01') = false then
        VSQL:='ALTER TABLE '||VSCHEMA||'.PLAYBACK_WINDOW_RESTRICTIONS ADD (CONSTRAINT PK_PLAYBACK_WINDOW_RESTR_01 PRIMARY KEY (RESTRICTION_ID), CONSTRAINT FK_PLAYBACK_RESTR_RIGHT_01 FOREIGN KEY (RIGHT_ID) REFERENCES '||VSCHEMA||'.RIGHT (RIGHT_ID) ,CONSTRAINT FK_PLAYBACK_RESTR_REC_01 FOREIGN KEY (RECORDING_ID) REFERENCES '||VSCHEMA||'.RECORDING (RECORDING_ID) )';
        CREATEOBJECT(VSQL,'ALTER TABLE PLAYBACK_WINDOW_RESTRICTIONS');
      end if;
      if is_index_exists (vschema, 'IDX_PWR_RIGHTID') = false then
        VSQL:='CREATE INDEX '||VSCHEMA||'.IDX_PWR_RIGHTID ON '||VSCHEMA||'.PLAYBACK_WINDOW_RESTRICTIONS(RIGHT_ID)';
        CREATEOBJECT(VSQL,'CREATE index IDX_PWR_RIGHTID');
      end if;
      if is_index_exists (vschema, 'IDX_PWR_RECORDINGID') = false then
        VSQL:='CREATE INDEX '||VSCHEMA||'.IDX_PWR_RECORDINGID ON '||VSCHEMA||'.PLAYBACK_WINDOW_RESTRICTIONS(RECORDING_ID)';
        CREATEOBJECT(VSQL,'CREATE index IDX_PWR_RECORDINGID');
      end if;
      /*********** START redefining REC_TRIAL_USE_FIELDS ******************************/
      if is_table_exists(vschema, 'tmpmig_RTUF') = true  and is_table_exists(vschema, 'REC_TRIAL_USE_FIELDS') = true and is_table_exists(vschema, 'PREMIG_REC_TRIAL_USE_FLDS') = false then
        VSQL:='ALTER TABLE '||VSCHEMA||'.REC_TRIAL_USE_FIELDS RENAME TO PREMIG_REC_TRIAL_USE_FLDS';
        CREATEOBJECT(VSQL,'RENAME REC_TRIAL_USE_FIELDS');
      end if;
      if is_table_exists(vschema, 'tmpmig_RTUF') = true  and is_table_exists(vschema, 'REC_TRIAL_USE_FIELDS') = false then
        VSQL:='ALTER TABLE '||VSCHEMA||'.tmpmig_RTUF RENAME TO REC_TRIAL_USE_FIELDS';
        CREATEOBJECT(VSQL,'RENAME tmpmig_RTUF');
      end if;

      if is_constraint_exists (vschema, 'REC_TRIAL_USE_FIELDS','PK_REC_TRIAL_USE_FIELDS') = false then
        VSQL:='ALTER TABLE '||VSCHEMA||'.REC_TRIAL_USE_FIELDS ADD ( CONSTRAINT PK_REC_TRIAL_USE_FIELDS PRIMARY KEY (TRIAL_USE_FIELD_ID),CONSTRAINT REC_TRIAL_USE_ENTITY_MAP_FK1 FOREIGN KEY (MAPPING_ID) REFERENCES '||VSCHEMA||'.ENTITY_MAPPING (MAPPING_ID) )';
        CREATEOBJECT(VSQL,'ALTER TABLE REC_TRIAL_USE_FIELDS');
      end if;
      /*********** START redefining RECORDING_REC_RULES_MAP ******************************/

      if  is_table_exists(vschema, 'TMPMIG_RECORDING_REC_RULES_MAP') = true and is_table_exists(vschema, 'RECORDING_REC_RULES_MAP') = true and is_table_exists(vschema, 'PREMIG_RECORDING_REC_RULES_MAP') = false then
        VSQL:='ALTER TABLE '||VSCHEMA||'.RECORDING_REC_RULES_MAP RENAME TO PREMIG_RECORDING_REC_RULES_MAP';
        CREATEOBJECT(VSQL,'RENAME RECORDING_REC_RULES_MAP');
      end if;
      if is_table_exists(vschema, 'TMPMIG_RECORDING_REC_RULES_MAP') = true and  is_table_exists(vschema, 'RECORDING_REC_RULES_MAP') = false then
        vsql:='ALTER TABLE '||VSCHEMA||'.TMPMIG_RECORDING_REC_RULES_MAP RENAME TO RECORDING_REC_RULES_MAP';
        CREATEOBJECT(VSQL,'RENAME TMPMIG_RECORDING_REC_RULES_MAP');
      end if;
      if is_constraint_exists (vschema, 'RECORDING_REC_RULES_MAP','PK_RECORDING_REC_RULES_MAP') = false then
        vsql:='ALTER TABLE '||vschema||'.RECORDING_REC_RULES_MAP ADD (CONSTRAINT PK_RECORDING_REC_RULES_MAP PRIMARY KEY (RECORDING_ID, RULE_ID) , CONSTRAINT FK_REC_RULES_MAP_REC_RULES_01 FOREIGN KEY (RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES (RULE_ID) , CONSTRAINT FK_REC_RULES_MAP_REC_01 FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING (RECORDING_ID) )';
        CREATEOBJECT(VSQL,'ALTER TABLE RECORDING_REC_RULES_MAP');
      end if;
      /*********** START redefining RECORDING_RTC_POOL_MAP ******************************/

      if is_table_exists(vschema, 'RECORDING_RTC_POOL_MAP') = true and is_table_exists(vschema, 'PREMIG_RECORDING_RTC_POOL_MAP') = false  then
        VSQL:='ALTER TABLE '||VSCHEMA||'.RECORDING_RTC_POOL_MAP RENAME TO PREMIG_RECORDING_RTC_POOL_MAP';
        CREATEOBJECT(VSQL,'RENAME RECORDING_RTC_POOL_MAP');
      end if;
      if is_column_exists(vschema, 'RECORDING','NEWRECORDING_ID') = true then
        VSQL:='ALTER TABLE '||VSCHEMA||'.RECORDING DROP COLUMN NEWRECORDING_ID';
        CREATEOBJECT(VSQL,'DROP COLUMN NEWRECORDING_ID');
      end if;
      /*********** END Migration Path for Recordings from 3.2 to 3.3 ******************************/



    		/**  Right Start Time End Time upgrade script	**/
      if is_column_exists(vschema, 'right','start_time') = false then
        vsql := ' alter table '||vschema||'.right add (start_time interval day to second(0), end_time interval day to second(0)) ';
        CREATEOBJECT(vsql,' alter table right add (start_time interval day to second(0), end_time interval day to second(0)) ');
      end if;
		/** Recording Rules   Start Time and End Time upgrade script **/
      if is_index_exists (vschema, 'IDX_RR_STATE_STTM_EDTM') = true then
        vsql := ' drop index '||vschema||'.IDX_RR_STATE_STTM_EDTM ';
        CREATEOBJECT(vsql,' drop index IDX_RR_STATE_STTM_EDTM ');
      end if;
      if is_column_exists(vschema, 'recording_rules','start_date') = false then
        vsql := ' alter table '||vschema||'.recording_rules rename column start_time to start_date ';
        CREATEOBJECT(vsql,' alter table recording_rules rename column start_time to start_date ');
      end if;
      if is_column_exists(vschema, 'recording_rules','end_date') = false then
        vsql := ' alter table '||vschema||'.recording_rules rename column end_time to end_date ';
        CREATEOBJECT(vsql,' alter table recording_rules rename column end_time to end_date ');
      end if;
      if is_column_exists(vschema, 'recording_rules','start_time') = false then
        vsql := ' alter table '||vschema||'.recording_rules add (start_time interval day to second(0), end_time interval day to second(0)) ';
        CREATEOBJECT(vsql,' alter table recording_rules add (start_time interval day to second(0), end_time interval day to second(0)) ');
      end if;
      if is_index_exists (vschema, 'IDX_RR_STATE_STTM_EDTM') = false then
        vsql := ' CREATE INDEX '||vschema||'.IDX_RR_STATE_STTM_EDTM ON '||vschema||'.RECORDING_RULES(STATE,START_DATE,END_DATE) ';
        CREATEOBJECT(vsql,' CREATE INDEX IDX_RR_STATE_STTM_EDTM ON RECORDING_RULES(STATE,START_DATE,END_DATE) ');
      end if;
      if is_column_exists(vschema, 'stg_program','program_id') = false then
        vsql := ' alter table '||vschema||'.stg_program rename column  database_key to program_id ';
        CREATEOBJECT(vsql,'Renaming the column database_key to program_id in the stg_program table');
      end if;
      if is_column_exists(vschema, 'stg_schedule','start_time') = false then
        vsql := ' alter table '||vschema||'.stg_schedule rename column air_date to start_time ';
        CREATEOBJECT(vsql,'Renaming the column air_date to start_time in the stg_schedule table');
      end if;
      if is_column_exists(vschema, 'stg_schedule','end_time') = false then
        vsql := ' alter table '||vschema||'.stg_schedule add end_time timestamp(0) with time zone as (start_time + numtodsinterval(duration, ''SECOND'')) ';
        CREATEOBJECT(vsql,'Adding a derived column, end_time to the table stg_schedule');
     end if;

	  /** Station_num data type changes **/
    if is_index_exists (vschema, 'IDX_STGSCH_PK') = true then
     vsql := 'drop index '||vschema||'.IDX_STGSCH_PK';
     CREATEOBJECT(vsql,'Droping the index IDX_STGSCH_PK', 'Y');
    end if;

   	 vsql := ' truncate table '||vschema||'.stg_schedule';
     CREATEOBJECT(vsql,'Truncate table stg_schedule');

     if get_column_data_type (vschema, 'stg_schedule','station_num') != UPPER('nvarchar2') THEN
       vsql := ' alter table '||vschema||'.stg_schedule modify station_num nvarchar2(100) ';
       CREATEOBJECT(vsql,'modifying the station_num column type to nvarchar2(100)');
     end if;
   	 /** Station_num data type changes **/
     if is_column_exists(vschema, 'temp_schedule_conflicts','duration_change') = false then
   	  vsql := ' alter table '||vschema||'.temp_schedule_conflicts add duration_change NUMBER(1) ';
   	  CREATEOBJECT(vsql,' Adding duration_change column to the temp_schedule_conflicts table ');
     end if;

      --IS_COLUMN_VALUE_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2, IN_COLUMN_VALUE varchar2, IN_DATA_TYPE VARCHAR2 DEFAULT 'VARCHAR2')
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','510','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(510, ''Recording_AlreadyProcessed'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','599','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(599,''Recording_Rejected'',''System'',''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
      end if;
     if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1452','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(1452, ''Recording_DUPLICATE'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
     end if;

      if is_column_exists(vschema, 'RM_LINEUP','CHANNEL_NUMBER') = false then
        vsql := 'alter table '||vschema||'.RM_LINEUP add CHANNEL_NUMBER NUMBER (10,0)';
        CREATEOBJECT(vsql,'alter TABLE rm_lineup');
      end if;
      if is_column_exists(vschema, 'RM','PRE_PROVISIONING_INTERVAL') = false then
        vsql := 'alter table '||vschema||'.RM add PRE_PROVISIONING_INTERVAL NUMBER (5, 0) DEFAULT 0 NOT NULL ';
        CREATEOBJECT(vsql,'alter TABLE rm_lineup');
      end if;
      if is_column_exists(vschema, 'ALARM_ACTIVITYLOG','ACKNOWLEDGED') = false then
        vsql := 'alter table '||vschema||'.ALARM_ACTIVITYLOG add ACKNOWLEDGED	NUMBER (1,0) DEFAULT 0  NOT NULL ';
        CREATEOBJECT(vsql,'alter TABLE ALARM_ACTIVITYLOG');
      end if;

      vsql := 'UPDATE '||vschema||'.ALARM_ACTIVITYLOG SET ACKNOWLEDGED = 1';
      CREATEOBJECT(vsql,'update TABLE ALARM_ACTIVITYLOG');

      if is_column_exists(vschema, 'RM','VERSION') = false then
        vsql := 'alter table '||vschema||'.RM add VERSION	NVARCHAR2(50)';
        CREATEOBJECT(vsql,'alter TABLE RM');
      end if;
      if is_column_exists(vschema, 'RTC','VERSION') = false then
        vsql := 'alter table '||vschema||'.RTC add VERSION NVARCHAR2(50)';
        CREATEOBJECT(vsql,'alter TABLE RTC');
      end if;
      if is_column_allow_nulls(vschema, 'RIGHT','OFFSET_START_TIME') = false then
        vsql := 'ALTER TABLE '||vschema||'.RIGHT MODIFY (OFFSET_START_TIME NUMBER(22,0) NULL, OFFSET_END_TIME NUMBER(22,0) NULL)';
        CREATEOBJECT(vsql,'alter TABLE RIGHT');
      end if;

      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1300','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                  VALUES(1300, ''User_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1301','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                  VALUES(1301, ''User_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1302','NUMBER') = false then
         vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                     VALUES(1302,''User_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1310','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                   VALUES(1310, ''Role_CreateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1311','NUMBER') = false then
      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                VALUES(1311, ''Role_UpdateFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1312','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                   VALUES(1312, ''Role_DeleteFailed'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','20','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(20,''auto_approve_right_rule_failed'',''System'',''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','21','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(21, ''EPG_INGEST_SKIPPED'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','22','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
            VALUES(22, ''EPG_INGEST_SKIPPED_FOR_MAINTENANCE_MODE'', ''System'', ''System'', current_timestamp, current_timestamp)';
          CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','23','NUMBER') = false then
         vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(23, ''INVALID_HEADEND_TIME_ZONE'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1701','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                   VALUES(1701, ''maintenanceWindow.unableToAcquireRecordingLock'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1702','NUMBER') = false then
      vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                 VALUES(1702, ''maintenanceWindow.unexpectedError'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'insert into error_code');
      end if;
      if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','1703','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
                   VALUES(1703, ''rcs.error.operationalState.epgInProgress'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'insert into error_code');
      end if;

      if is_column_value_exists(vschema,'config_setting','key','Last_EPG_Completion_Time','VARCHAR2') = false then
        vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(''Last_EPG_Completion_Time'', '''', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
      end if;
      if is_column_value_exists(vschema,'config_setting','key','rcsOperationalState','VARCHAR2') = false then
        vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(''rcsOperationalState'', ''1'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
      end if;
      if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendId','VARCHAR2') = false then
        vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
          VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendId'',''HEADEND'',''HEADEND_ID'',1)';
        CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
      end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendCommunityName','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendCommunityName'',''HEADEND'',''COMMUNITY_NAME'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;

     if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendCountyName','VARCHAR2') = false then
        vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
          VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendCountyName'',''HEADEND'',''COUNTY_NAME'',1)';
        CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;

    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendStCountyCode','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendStCountyCode'',''HEADEND'',''ST_COUNTY_CODE'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;

    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendCountySize','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendCountySize'',''HEADEND'',''COUNTY_SIZE'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendState','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendState'',''HEADEND'',''STATE'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;

    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendZipCode','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendZipCode'',''HEADEND'',''ZIPCODE'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;

    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendDMACode','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendDMACode'',''HEADEND'',''DMA_CODE'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendDMAName','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendDMAName'',''HEADEND'',''DMA_NAME'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendMSOCode','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendMSOCode'',''HEADEND'',''MSO_CODE'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendDMARank','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendDMARank'',''HEADEND'',''DMA_RANK'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendName','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendName'',''HEADEND'',''HEADEND_NAME'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
   end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendLocation','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendLocation'',''HEADEND'',''HEADEND_LOCATION'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendMSOName','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendMSOName'',''HEADEND'',''MSO_NAME'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;
    if is_column_value_exists(vschema,'ENTITY_MAPPING','NAME','dynamicTrialUseField.headendTimezone','VARCHAR2') = false then
      vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE)
        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''dynamicTrialUseField.headendTimezone'',''HEADEND'',''TIME_ZONE'',1)';
      CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
    end if;

	--Version information will be updated by installer.
    if is_column_value_exists(vschema,'config_setting','key','tstvversion','VARCHAR2') = false then
          vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(''tstvversion'', ''5.0.000'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
    end if;

    if is_table_exists(vschema, 'MAINTENANCE_WINDOW') = false then
      vsql := 'CREATE TABLE '||vschema||'.MAINTENANCE_WINDOW
      (
       MAINTENANCE_WINDOW_ID NUMBER (19,0)  NOT NULL ,
       START_TIME  TIMESTAMP(0) WITH TIME ZONE NOT NULL,
       DURATION NUMBER (19,0)  NOT NULL,
       CREATED_BY NVARCHAR2 (50)  NOT NULL ,
       UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
       CREATE_DATE TIMESTAMP  NOT NULL ,
       UPDATE_DATE TIMESTAMP  NOT NULL ,
       RM_ID NUMBER (19,0) ,
       CONSTRAINT PK_MAINTENANCE_WINDOW PRIMARY KEY ( MAINTENANCE_WINDOW_ID ),
       CONSTRAINT FK_MW_RM FOREIGN KEY (RM_ID) REFERENCES '||vschema||'.RM(RM_ID)
      )';
      CREATEOBJECT(vsql,'create table MAINTENANCE_WINDOW');
    end if;

    if is_sequence_exists(vschema,'MAINTENANCE_WINDOW_SEQ') = false then
      CREATESEQ('MAINTENANCE_WINDOW');
    end if;
    if is_index_exists (vschema, 'IDX_MW_RMID') = false then
      vsql := 'CREATE INDEX '||vschema||'.IDX_MW_RMID ON '||vschema||'.MAINTENANCE_WINDOW(RM_ID)';
      CREATEOBJECT(vsql,'create INDEX IDX_MW_RMID');
    end if;
    if is_column_exists(vschema, 'temp_rec_rules','pool_id') = false then
      vsql :=' alter table '||vschema||'.temp_rec_rules add (pool_id number(19,0)) ';
      CREATEOBJECT(vsql,' Adding the POOL_ID column to the temp_rec_rules table ');
    end if;

    if is_column_exists(vschema, 'temp_older_right_recordables','RM_ID') = false then
      vsql :=' ALTER TABLE '||vschema||'.temp_older_right_recordables ADD (RM_ID NUMBER(19,0)) ';
      CREATEOBJECT(vsql,' Adding the RM_ID column to the temp_older_right_recordables table ');
    end if;

     vsql := 'update '||vschema||'.stg_station set fcc_channel_num = null, dma_number = null  ';
     CREATEOBJECT(vsql,'updating the columns fcc_channel_num and dma_number with null values');

     if get_column_data_type (vschema, 'stg_station','fcc_channel_num') != UPPER('nvarchar2') THEN
       vsql := 'alter table '||vschema||'.stg_station modify  (fcc_channel_num nvarchar2(100), dma_number nvarchar2(100)) ';
       CREATEOBJECT(vsql,'Modifying the fcc_channel_num and dma_number columns data types to nvarchar2');
      end if;
      if is_table_exists(vschema, 'REC_RULES_RM_MAP') = false then
           vsql := ' CREATE TABLE '||vschema||'.REC_RULES_RM_MAP
        (
         RULE_ID NUMBER(19,0)  NOT NULL ,
         RM_ID NUMBER(19,0)  NOT NULL ,
         CREATED_BY NVARCHAR2 (50)  NOT NULL ,
         UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
         CREATE_DATE TIMESTAMP  NOT NULL ,
         UPDATE_DATE TIMESTAMP  NOT NULL,
         CONSTRAINT PK_RULE_RM_MAP PRIMARY KEY ( RULE_ID, RM_ID),
         CONSTRAINT FK_REC_RULES_RM_MAP_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID),
         CONSTRAINT FK_REC_RULES_RM_MAP_RIGHT FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID)
        )';
        CREATEOBJECT(vsql,'create TABLE REC_RULES_RM_MAP');
      end if;
      if is_table_exists(vschema, 'REC_RULES_EXCLUDED_RM_MAP') = false then
        vsql := 'CREATE TABLE '||vschema||'.REC_RULES_EXCLUDED_RM_MAP
        (
         RULE_ID NUMBER(19,0)  NOT NULL ,
         RM_ID NUMBER(19,0)  NOT NULL ,
         CREATED_BY NVARCHAR2 (50)  NOT NULL ,
         UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
         CREATE_DATE TIMESTAMP  NOT NULL ,
         UPDATE_DATE TIMESTAMP  NOT NULL,
         CONSTRAINT PK_REC_RULES_EXCLUDED_RM_MAP PRIMARY KEY ( RULE_ID, RM_ID ),
         CONSTRAINT FK_RULES_EXCLUDED_RM_MAP_RM FOREIGN KEY ( RM_ID) REFERENCES '||vschema||'.RM ( RM_ID),
         CONSTRAINT FK_RULES_EXCL_RM_MAP_RULE FOREIGN KEY ( RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES ( RULE_ID)
        )';
        CREATEOBJECT(vsql,'create TABLE REC_RULES_EXCLUDED_RM_MAP');
      end if;

      if is_table_exists(vschema, 'USER_EXT') = false then
        vsql := 'CREATE TABLE '||vschema||'.USER_EXT
                (
              USERID  NUMBER NOT NULL,
              ALL_RM_ACCESS NUMBER (1, 0) DEFAULT 1 NOT NULL ,
              CREATED_BY NVARCHAR2 (50) NOT NULL ,
              UPDATED_BY NVARCHAR2 (50) NOT NULL ,
              CREATE_DATE TIMESTAMP  NOT NULL ,
              UPDATE_DATE TIMESTAMP  NOT NULL ,
              CONSTRAINT USER_RM_PK  PRIMARY KEY ( USERID )
        )';
        CREATEOBJECT(vsql,'create TABLE USER_EXT');
      end if;

    if is_table_exists(vschema, 'USER_RM_MAP') = false then
      vsql := 'CREATE TABLE '||vschema||'.USER_RM_MAP
           (
              USERID  NUMBER NOT NULL,
              RM_ID	NUMBER(19,0) NOT NULL ,
              CONSTRAINT USER_RM_MAP_PK   PRIMARY KEY ( USERID, RM_ID )
      )';
    CREATEOBJECT(vsql,'create TABLE USER_RM_MAP');
    end if;


    if IS_COLUMN_VALUE_EXISTS(vschema,'config_setting','key','Is_EPG_Schedule_Conflict_Completed','VARCHAR2') = false then
         vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(''Is_EPG_Schedule_Conflict_Completed'', ''Y'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
    end if;

    if is_table_exists(vschema, 'TEMP_SS_REC') = false then
      vsql := 'CREATE TABLE '||vschema||'.TEMP_SS_REC
      (
       RECORDING_ID NUMBER(19,0) NOT NULL ,
       POOL_ID NUMBER(19,0) NOT NULL,
       STATUS NUMBER(2,0) DEFAULT 3 NOT NULL,
       STATUS_CODE      	NUMBER(10,0) NOT NULL,
       CONTENT_URL		NVARCHAR2(1024),
       CONSTRAINT PK_TEMP_SS_RECORDING01 PRIMARY KEY ( RECORDING_ID,POOL_ID )
      )';
      CREATEOBJECT(vsql,'create TABLE TEMP_SS_REC');
    end if;
    if is_table_exists(vschema, 'TEMP_SS_RECORDING') = true then
      vsql := 'DROP TABLE '||vschema||'."TEMP_SS_RECORDING" PURGE';
      CREATEOBJECT(vsql,'Drop table TEMP_SS_RECORDING','Y');
    end if;
    if is_table_exists(vschema, 'TEMP_SS_REC_RTCPOOLMAP') = true then
      vsql := 'DROP TABLE '||vschema||'."TEMP_SS_REC_RTCPOOLMAP" PURGE';
      CREATEOBJECT(vsql,'Drop table TEMP_SS_REC_RTCPOOLMAP','Y');
    end if;
    if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','1416','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
            VALUES(1416, ''Recording_INVALID_LICENSING_WINDOW'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    end if;

     vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."REC_RULES_VIEW" ("CONTRACT_TITLE", "SCHEDULE_ID", "RULE_ID", "SCHEDULE_START_TIME", "SCHEDULE_END_TIME", "PROGRAM_TITLE", "STATION_CALL_SIGN", "RM_ID","HEADEND_ID", "POOL_ID") AS
          select distinct contract_title, schedule_id,rule_id,sstart_time,send_time,program_title,station_call_sign,rm_id,headend_id, pool_id
          from
                (select rm.rm_id as rm_id, rm.headend_id as headend_id, rtc_pool.pool_id,
                c.title as contract_title,s.schedule_id as schedule_id,rr.rule_id as rule_id,s.station_id as sstation_id,
                sta.call_sign as station_call_sign,s.program_id as sprogram_id, p.title as program_title,
                s.start_time as sstart_time, s.end_time as send_time,
                upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat,
                case when upper(s.live_tape_delay) = ''DELAY'' then cast(''TAPE'' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
                upper(trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY''))) as sdayofweek,
                upper(nvl(trim(rr.day_of_week),trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY'')))) as rdayofweek,
                rr.start_date as rstart_date, rr.end_date as rend_date,
                upper(rr.repeat) as rrepeat, upper(rr.hd) as rhd_tv, upper(rr.live) as rlive,
                nvl(rpm.program_id,s.program_id) as rpmprogram_id,
                case
                  when rserm.series_id  is null then nvl(rserm.program_id,s.program_id)
                  when rserm.series_id  is not null then rserm.program_id
                end as rsermprogram_id,
                nvl(rstam.station_id,s.station_id) as rstamstation_id
                from '||vschema||'.schedule s
                join '||vschema||'.contract c on (c.status = 1 and s.recordable=1 and s.start_time >= current_timestamp and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
                join '||vschema||'.recording_rules rr on (rr.state =1 and ((s.start_time >= rr.start_date and s.end_time <= rr.end_date) OR (rr.start_date is null and rr.end_date is null)))
                join '||vschema||'.program p on (s.program_id = p.program_id)
                join '||vschema||'.station sta on (sta.station_id = s.station_id)
				join (select rrm.schedule_id,rrm.rm_id , r.right_id, r.contract_id
                        from '||vschema||'.recordable_rights_map rrm ,   '||vschema||'.right r
                        where r.right_id = rrm.right_id and r.state=1 ) rrmouter
                      on (rrmouter.schedule_id = s.schedule_id
                          and rrmouter.contract_id = c.contract_id)
                join '||vschema||'.right_rm_map rightrm on (rightrm.right_id = rrmouter.right_id and rrmouter.rm_id = rightrm.rm_id)
                join '||vschema||'.rec_rules_rm_map rrrm on (rightrm.rm_id = rrrm.rm_id and rr.rule_id = rrrm.rule_id)
                join '||vschema||'.rm on (rm.rm_id = rightrm.rm_id)
                join '||vschema||'.headend he on (rm.headend_id = he.headend_id)
                join '||vschema||'.rtc_pool on (rm.rm_id = rtc_pool.rm_id)
                join '||vschema||'.rm_lineup rl on (rl.rm_id = rm.rm_id and rl.station_id=sta.station_id and rl.headend_id = rm.headend_id)
                left outer join '||vschema||'.rec_rules_program_map rpm on (rr.rule_id = rpm.rule_id )
                left outer join (select rserm_inner.series_id as series_id, rserm_inner.rule_id as rule_id, spm.program_id as program_id
                    from '||vschema||'.rec_rules_series_map rserm_inner left outer join '||vschema||'.series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm
                    on (rr.rule_id = rserm.rule_id)
                left outer join '||vschema||'.rec_rules_station_map rstam on (rr.rule_id = rstam.rule_id)
                 where
                 	   NVL(rr.start_time,to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))) <= to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))
                          AND NVL(rr.end_time + numtodsinterval(TO_CHAR(s.start_time at TIME zone TO_CHAR(he.time_zone),''J''),''DAY''),
                          to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss'')))
                           >= to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss''))

                ) recinnerview
          where sstation_id = rstamstation_id
          and sprogram_id = rpmprogram_id
          and sprogram_id = rsermprogram_id
          and  rdayofweek like ''%''||sdayofweek||''%''
          and (srepeat = rrepeat or rrepeat is null)
          and (shd_tv = rhd_tv or rhd_tv is null)
          and (slive = rlive or rlive is null)
          and not exists (select 1 from '||vschema||'.recording r where r.schedule_id = recinnerview.schedule_id and r.pool_id = recinnerview.pool_id  and r.status <> 1)';
          CREATEOBJECT(vsql,'CREATE VIEW REC_RULES_VIEW');

  vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."REC_RULES_SCHEDULECHK_VIEW" ("RECORDING_ID","RULE_ID") AS
            select distinct recording_id, rule_id
            from
                  (select r.recording_id,s.schedule_id as schedule_id,rr.rule_id as rule_id,s.station_id as sstation_id,
                  s.program_id as sprogram_id,
                  s.start_time as sstart_time, s.end_time as send_time,
                  upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat,
                  case when upper(s.live_tape_delay) = ''DELAY'' then cast(''TAPE'' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
                   upper(trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY''))) as sdayofweek,
                   upper(nvl(trim(rr.day_of_week),trim(to_char(s.start_time at time zone to_char(he.time_zone),''DAY'')))) as rdayofweek,
                  rr.start_date as rstart_date, rr.end_date as rend_date,
                  upper(rr.repeat) as rrepeat, upper(rr.hd) as rhd_tv, upper(rr.live) as rlive,
                  nvl(rpm.program_id,s.program_id) as rpmprogram_id,
                  case
                  when rserm.series_id  is null then nvl(rserm.program_id,s.program_id)
                  when rserm.series_id  is not null then rserm.program_id
                end as rsermprogram_id,
                  nvl(rstam.station_id,s.station_id) as rstamstation_id
                  from '||vschema||'.schedule s
                  join '||vschema||'.contract c on (c.status = 1 and s.recordable=1 and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
                      join recording_rules rr on (rr.state =1 and ((s.start_time >= rr.start_date and s.end_time <= rr.end_date) OR (rr.start_date is null and rr.end_date is null)))
                  join '||vschema||'.rec_rules_rm_map rrrm on (rr.rule_id = rrrm.rule_id)
                  join '||vschema||'.rm on (rm.rm_id = rrrm.rm_id)
                  join '||vschema||'.headend he on (rm.headend_id = he.headend_id)
                  join '||vschema||'.rtc_pool on (rtc_pool.rm_id = rm.rm_id)
                  join '||vschema||'.recording r on (r.schedule_id = s.schedule_id and r.pool_id = rtc_pool.pool_id)
                  left outer join '||vschema||'.rec_rules_program_map rpm on (rr.rule_id = rpm.rule_id )
                  left outer join (select rserm_inner.series_id as series_id, rserm_inner.rule_id as rule_id, spm.program_id as program_id
                      from '||vschema||'.rec_rules_series_map rserm_inner left outer join '||vschema||'.series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm
                      on (rr.rule_id = rserm.rule_id)
                  left outer join '||vschema||'.rec_rules_station_map rstam on (rr.rule_id = rstam.rule_id)
                  where
                   NVL(rr.start_time,to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))) <= to_dsinterval(''0 ''||TO_CHAR (s.start_time at TIME zone TO_CHAR(he.time_zone), ''hh24:mi:ss''))
                          AND NVL(rr.end_time + numtodsinterval(TO_CHAR(s.start_time at TIME zone TO_CHAR(he.time_zone),''J''),''DAY''),
                          to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss'')))
                           >= to_dsinterval(TO_CHAR (s.end_time at TIME zone TO_CHAR(he.time_zone), ''J hh24:mi:ss''))


                  )
            where sstation_id = rstamstation_id
            and sprogram_id = rpmprogram_id
            and sprogram_id = rsermprogram_id
            and  rdayofweek like ''%''||sdayofweek||''%''
            and (srepeat = rrepeat or rrepeat is null)
            and (shd_tv = rhd_tv or rhd_tv is null)
            and (slive = rlive or rlive is null)';

    CREATEOBJECT(vsql,'CREATE VIEW REC_RULES_SCHEDULECHK_VIEW');

      if is_view_exists(vschema, 'RULES_EDIT_CHK_VIEW') = true then
        vsql := ' drop view '||vschema||'.RULES_EDIT_CHK_VIEW ';
        CREATEOBJECT(vsql,'drop view  RULES_EDIT_CHK_VIEW','Y');
      end if;
     if is_view_exists(vschema, 'RIGHTS_EDIT_CHK_VIEW') = true then
        vsql := ' drop view '||vschema||'.RIGHTS_EDIT_CHK_VIEW ';
        CREATEOBJECT(vsql,'drop view  RIGHTS_EDIT_CHK_VIEW','Y');
     end if;

	vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."STG_PROGRAM_GENERIC_VIEW" ("PROGRAM_ID", "ASSETTYPE", "TRIALNAME", "TRAILNAMEVALUE") AS
        select pstg.program_id,decode(upper(xmldata.assettype), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3) as assettype ,xmldata.trialname,xmldata.trialnamevalue
      from '||vschema||'.stg_program pstg ,
        XMLTABLE(''/PROGRAM_GENERIC/PROGRAM_GENERIC'' passing pstg.program_generic columns
            assettype VARCHAR2(100) path ''@Asset'',
            TrialName NVARCHAR2(100) path ''@Name''
            ,trialnamevalue NVARCHAR2(100) path ''text()''
            ) xmldata
      where pstg.program_Generic is not null';
	CREATEOBJECT(vsql,'CREATE VIEW STG_PROGRAM_GENERIC_VIEW');

    vsql := 'CREATE OR REPLACE FORCE VIEW '||vschema||'."STG_SCHEDULE_GENERIC_VIEW" ("PROGRAM_ID", "STATION_ID", "START_TIME", "ASSETTYPE", "TRIALNAME", "TRAILNAMEVALUE") AS
            select sstg.database_key,sstg.station_num,sstg.start_time,decode(upper(xmldata.assettype), ''MOVIE'', 1, ''PACKAGE'', 2, ''TITLE'', 3) as assettype,xmldata.trialname,xmldata.trialnamevalue
          from '||vschema||'.stg_schedule sstg ,
            XMLTABLE(''/SCHEDULE_GENERIC/SCHEDULE_GENERIC'' passing sstg.schedule_generic columns
                assettype VARCHAR2(100) path ''@Asset'',
                TrialName NVARCHAR2(100) path ''@Name''
                ,trialnamevalue NVARCHAR2(100) path ''text()''
                ) xmldata
          where sstg.schedule_Generic is not null';
    CREATEOBJECT(vsql,'CREATE VIEW STG_SCHEDULE_GENERIC_VIEW');

          if is_table_exists(vschema, 'Login_Attempts') = false then
              vsql := 'CREATE TABLE '||vschema||'.Login_Attempts
                        ( UserId   NUMBER NOT NULL,
                          FailedLoginCount  NUMBER (1,0) NOT NULL,
                          LastFailedLoginDate DATE NOT NULL,
                          PRIMARY KEY (userid)
                        )';
              CREATEOBJECT(vsql,'CREATE TABLE Login_Attempts');
          end if;


    end if;

    if vtstvdbver < '3.3.000.1' then
      if is_column_exists(vschema, 'RM','START_BLACK_OUT') = false then
        vsql := 'alter table '||vschema||'.RM add START_BLACK_OUT NUMBER (5, 0) DEFAULT 0 NOT NULL ';
        CREATEOBJECT(vsql,'alter TABLE rm_lineup');
      end if;
      if is_column_exists(vschema, 'RM','STOP_BLACK_OUT') = false then
        vsql := 'alter table '||vschema||'.RM add STOP_BLACK_OUT NUMBER (5, 0) DEFAULT 0 NOT NULL ';
        CREATEOBJECT(vsql,'alter TABLE rm_lineup');
      end if;
      if is_column_exists(vschema, 'RM','STOP_SUPPORTED') = false then
        vsql := 'alter table '||vschema||'.RM add STOP_SUPPORTED NUMBER (1, 0) DEFAULT 0 NOT NULL ';
        CREATEOBJECT(vsql,'alter TABLE rm_lineup');
      end if;
      vsql := ' update '||vschema||'.rm set pre_provisioning_interval=120, start_black_out=120, stop_black_out=2, stop_supported=1 where upper(trim(rm_type)) in (''ETV'', ''ISA'',''XCSWS'')';
      CREATEOBJECT(vsql,'Updating values for new added columns to ETV, ISA, XCSWS Rms');
	  vsql := '  update '||vschema||'.rm set pre_provisioning_interval=480, start_black_out=480, stop_black_out=0, stop_supported=0 where upper(trim(rm_type))=''L2V''';
	  CREATEOBJECT(vsql,'Updating values for new added columns to L2V Rms');


      if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','24','NUMBER') = false then
        vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
         VALUES(24, ''EPG_SCHEDULE_CHANGE_RECORDING_DELETED'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
      end if;

	 --Movie Asset Generation logic
      if IS_COLUMN_VALUE_EXISTS(vschema,'config_setting','key','MOVIE_ASSET_ID_GEN_LOGIC_KEY','VARCHAR2') = false then
        vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        VALUES(''MOVIE_ASSET_ID_GEN_LOGIC_KEY'', ''DEFAULT'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
      end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','778','NUMBER') = false then
       vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
            VALUES(778, ''RM_In_Maintenance_Mode'', ''System'', ''System'', current_timestamp, current_timestamp)';
      CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
     end if;

     if is_table_exists(vschema, 'temp_deleted_recordings') = false then
       vsql := ' create table '||vschema||'.temp_deleted_recordings
            (rm_id number(19,0),
            rm_name nvarchar2(200),
            program_title nvarchar2(1000),
             station_call_sign nvarchar2(100),
              schedule_start_time TIMESTAMP with time zone) nologging
          ';

      CREATEOBJECT(vsql,'CREATE TABLE temp_deleted_recordings');
    end if;
     if is_column_exists(vschema, 'RM','SENT_TO_RM') = false then
		      vsql := 'alter table '||vschema||'.RM add SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL ';
		      CREATEOBJECT(vsql,'alter TABLE RM');
	    end if;
		if is_column_exists(vschema, 'ADI_XML_SITE','SENT_TO_RM') = false then
	      vsql := 'alter table '||vschema||'.ADI_XML_SITE add SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL ';
	      CREATEOBJECT(vsql,'alter TABLE ADI_XML_SITE');
	    end if;

		if is_column_exists(vschema, 'RM_LINEUP','SENT_TO_RM') = false then
		  vsql := 'alter table '||vschema||'.RM_LINEUP add SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL ';
	      CREATEOBJECT(vsql,'alter TABLE RM_LINEUP');
		end if;
		if is_column_exists(vschema, 'RTC','SENT_TO_RM') = false then
	      vsql := 'alter table '||vschema||'.RTC add SENT_TO_RM NUMBER (1, 0) DEFAULT 0 NOT NULL ';
	      CREATEOBJECT(vsql,'alter TABLE RTC');
		end if;




	end if;

  IF VTSTVDBVER < '3.3.000.2' THEN
      if is_index_exists (vschema, 'IDX_SCH_STATION_ID') = false then
          vsql := 'CREATE INDEX '||VSCHEMA||'.IDX_SCH_STATION_ID ON '||VSCHEMA||'.SCHEDULE(STATION_ID)';
          CREATEOBJECT(vsql,'create index IDX_SCH_STATION_ID');
      end if;

	END IF;

    IF VTSTVDBVER < '3.3.000.3' THEN
      if is_column_exists(vschema, 'RM_LINEUP','LOCATION') = false then
        vsql := 'ALTER TABLE '||vschema||'.RM_LINEUP ADD LOCATION NVARCHAR2(32) ';
        CREATEOBJECT(vsql,'alter TABLE RM_LINEUP');
      end if;
      if is_column_exists(vschema, 'temp_rec_rules','start_offset_adjustment_flag') = false then
      	vsql := 'alter table '||vschema||'.temp_rec_rules add start_offset_adjustment_flag number(1) default 0 ';
        CREATEOBJECT(vsql,'alter TABLE temp_rec_rules');
      end if;
      if is_column_exists(vschema, 'temp_rec_rules','end_offset_adjustment_flag') = false then
      	vsql := 'alter table '||vschema||'.temp_rec_rules add end_offset_adjustment_flag number(1) default 0 ';
        CREATEOBJECT(vsql,'alter TABLE temp_rec_rules');
      end if;

    END IF;

	IF VTSTVDBVER < '3.3.000.4' THEN

	vsql := 'merge into '||vschema||'.rec_rules_rm_map rrmp
 			using (

		        select distinct rr.rule_id, rl.rm_id from
		       '||vschema||'.recording_rules rr join '||vschema||'.rec_rules_station_map rrsm on (rr.rule_id = rrsm.rule_id  and rr.state !=2)
		        join '||vschema||'.rm_lineup rl on (rrsm.station_id = rl.station_id)
            join '||vschema||'.rm on (rl.rm_id = rm.rm_id and rm.is_deleted !=1)
		        union
		 		select distinct rr.rule_id, rms.rm_id from
		        '||vschema||'.recording_rules rr  left outer join '||vschema||'.rec_rules_station_map rrsm on (rr.rule_id = rrsm.rule_id  )
		        join (select rl.rm_id from '||vschema||'.rm_lineup rl join '||vschema||'.rm on (rl.rm_id = rm.rm_id and rm.is_deleted !=1)) rms on (rrsm.rule_id is null)
            		where  rms.rm_id is not null and rr.state !=2

				 ) rule_rms on (rrmp.rule_id = rule_rms.rule_id and rule_rms.rm_id is not null)
				 when not matched then
				 insert (rule_id, rm_id, created_by, updated_by, create_date, update_date) values
				  (rule_rms.rule_id, rule_rms.rm_id, ''system'',''system'', current_timestamp, current_timestamp)';
		CREATEOBJECT(vsql,'adding recording rules and rm map ');

		vsql :=' update '||vschema||'.recording_rules rr set state=2 where rr.state !=2 and rule_id in
          (select rule_id from '||vschema||'.rec_rules_station_map rrsm where rrsm.rule_id = rr.rule_id
            and not exists ( select 1 from '||vschema||'.rm_lineup rl join '||vschema||'.rm on (rl.rm_id = rm.rm_id and rm.is_deleted !=1) where rl.station_id = rrsm.station_id)
          )

            ';
    	CREATEOBJECT(vsql,'deleting the rules that have stations which are not part of non-deleted RM lineup ');



	 vsql :='merge into '||vschema||'.right_excluded_rm_map remp using

		 (select distinct right_id, rm_id from '||vschema||'.rm natural join '||vschema||'.right where rm.is_deleted !=1 and right.state !=2
		  minus
		  select right_id , rm_id from '||vschema||'.right_rm_map
		  ) right_ex_rms on (remp.right_id = right_ex_rms.right_id and remp.rm_id = right_ex_rms.rm_id)

		  when not matched then
		   insert (right_id, rm_id, created_by, updated_by, create_date, update_date) values
						  (right_ex_rms.right_id, right_ex_rms.rm_id, ''system'',''system'', current_timestamp, current_timestamp)
		  ';
	 CREATEOBJECT(vsql,'Adding Right excluded RM list');

		vsql :='merge into '||vschema||'.rec_rules_excluded_rm_map rremp using

		 (select distinct rule_id, rm_id from '||vschema||'.rm natural join '||vschema||'.recording_rules rr where rm.is_deleted !=1 and rr.state !=2
		  minus
		  select rule_id , rm_id from '||vschema||'.rec_rules_rm_map
		  ) rule_ex_rms on (rremp.rule_id = rule_ex_rms.rule_id and rremp.rm_id = rule_ex_rms.rm_id)

		  when not matched then
		   insert (rule_id, rm_id, created_by, updated_by, create_date, update_date) values
						  (rule_ex_rms.rule_id, rule_ex_rms.rm_id, ''system'',''system'', current_timestamp, current_timestamp)
		  ';
		CREATEOBJECT(vsql,'Adding Rule excluded RM list');
	end if;

	IF VTSTVDBVER < '3.3.000.5' THEN
	 	if is_column_value_exists(vschema,'ERROR_CODE','ERROR_CODE','511','NUMBER') = false then
        	vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          		VALUES(511, ''Recording_RtiZeroFtpPushURLs'', ''System'', ''System'', current_timestamp, current_timestamp)';
        	CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
     	end if;
     	if is_table_exists(vschema, 'BACKEND_APPLICATION_RESOURCES') = false then
		     vsql := 'create table '||vschema||'.BACKEND_APPLICATION_RESOURCES ( KEY VARCHAR2(2000) NOT NULL, VALUE NVARCHAR2(2000) , LANGUAGE VARCHAR2(20) DEFAULT ''en'' NOT NULL , constraint PK_BACKEND_APP_RESOURCES  PRIMARY KEY (KEY, LANGUAGE))';
		     CREATEOBJECT(vsql,'Create table BACKEND_APPLICATION_RESOURCES');
		end if;

		if is_table_exists(vschema, 'temp_BACKEND_APP_RESOURCES') = false then
			 vsql := 'create table '||vschema||'.temp_BACKEND_APP_RESOURCES( KEY VARCHAR2(2000) NOT NULL, VALUE NVARCHAR2(2000), LANGUAGE VARCHAR2(20) DEFAULT ''en'' NOT NULL)';
		     CREATEOBJECT(vsql,'create table temp_BACKEND_APP_RESOURCES');
     	end if;

     	if IS_COLUMN_VALUE_EXISTS(vschema,'config_setting','key','I18N_LANGUAGE_ID','VARCHAR2') = false then
	        vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
	        VALUES(''I18N_LANGUAGE_ID'', ''en'', ''System'', ''System'', current_timestamp, current_timestamp)';
        	CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
     	end if;

    end if;

	IF VTSTVDBVER < '4.0.000.0' THEN
	    vsql := 'grant create database link to RCS';
    		CREATEOBJECT(vsql,'Unable to grant create database link to RCS');

		if is_column_exists(vschema, 'RECORDING','POSTER_ASSET_ID') = false then
      		vsql := 'alter table '||vschema||'.RECORDING add POSTER_ASSET_ID NVARCHAR2 (100) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING');
      	end if;
      	if is_column_exists(vschema, 'RECORDING','POSTER_IMAGE_NAME') = false then
      		vsql := 'alter table '||vschema||'.RECORDING add POSTER_IMAGE_NAME	NVARCHAR2(256) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING');
      	end if;
      	if is_column_exists(vschema, 'RECORDING','POSTER_DESCRIPTION') = false then
      		vsql := 'alter table '||vschema||'.RECORDING add POSTER_DESCRIPTION NVARCHAR2(1024) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING');
      	end if;

		if is_column_exists(vschema, 'RECORDING_QUEUE','POSTER_ASSET_ID') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_QUEUE add POSTER_ASSET_ID NVARCHAR2 (100) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_QUEUE');
      	end if;
      	if is_column_exists(vschema, 'RECORDING_QUEUE','POSTER_IMAGE_NAME') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_QUEUE add POSTER_IMAGE_NAME	NVARCHAR2(256) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_QUEUE');
      	end if;
      	if is_column_exists(vschema, 'RECORDING_QUEUE','POSTER_DESCRIPTION') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_QUEUE add POSTER_DESCRIPTION NVARCHAR2(1024) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_QUEUE');
      	end if;

      	if is_column_exists(vschema, 'RECORDING_RULES','ATTACH_POSTER') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_RULES add ATTACH_POSTER NUMBER(1, 0) default 0 NOT NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_RULES');
      	end if;
      	if is_column_exists(vschema, 'RECORDING_RULES','POSTER_IMAGE_NAME') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_RULES add POSTER_IMAGE_NAME	NVARCHAR2(256) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_RULES');
      	end if;
      	if is_column_exists(vschema, 'RECORDING_RULES','POSTER_DESCRIPTION') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_RULES add POSTER_DESCRIPTION NVARCHAR2(1024) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_RULES');
      	end if;

      	if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','25','NUMBER') = false then
      		vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        				VALUES(25, ''still_image_rm_sync_interrupted'', ''System'', ''System'', current_timestamp, current_timestamp)';
    		CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    	end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','26','NUMBER') = false then
    		vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        				VALUES(26, ''still_image_rm_sync_failed'', ''System'', ''System'', current_timestamp, current_timestamp)';
    		CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
    	end if;

      	if is_table_exists(vschema, 'STILL_IMAGE_REPOSITORY') = false then
      		vsql := 'CREATE TABLE '||vschema||'.STILL_IMAGE_REPOSITORY (
					IMAGE_NAME				NVARCHAR2(256) NOT NULL,
					FILE_NAME				NVARCHAR2(256) NOT NULL,
					ASPECT_RATIO			NVARCHAR2(32),
					FILE_SIZE				NUMBER(19,0) NOT NULL,
					CHECK_SUM				NVARCHAR2(32) NOT NULL,
					THUMB_NAIL				BLOB NOT NULL,
					IMAGE					BLOB NOT NULL,
					CREATED_BY NVARCHAR2 (50)  NOT NULL ,
					UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
					CREATE_DATE TIMESTAMP  NOT NULL ,
					UPDATE_DATE TIMESTAMP  NOT NULL,
                    CONSTRAINT PK_STILL_IMAGE_REPOSITORY PRIMARY KEY (IMAGE_NAME))
                    LOB(IMAGE) STORE AS SECUREFILE,
                    LOB(THUMB_NAIL) STORE AS SECUREFILE';
		     CREATEOBJECT(vsql,'create table STILL_IMAGE_REPOSITORY');
     	end if;
     	if is_table_exists(vschema, 'STILL_IMAGE_RM_SYNC') = false then
    		vsql := 'CREATE TABLE '||vschema||'.STILL_IMAGE_RM_SYNC (
					IMAGE_NAME				NVARCHAR2(256) NOT NULL,
					RM_ID					NUMBER (19,0)  NOT NULL,
					CREATED_BY NVARCHAR2 (50)  NOT NULL ,
					UPDATED_BY NVARCHAR2 (50)  NOT NULL ,
					CREATE_DATE TIMESTAMP  NOT NULL ,
					UPDATE_DATE TIMESTAMP  NOT NULL,
                    CONSTRAINT PK_STILL_IMAGE_RM_SYNC PRIMARY KEY (IMAGE_NAME, RM_ID),
                    CONSTRAINT FK_SIMG_SIMG_RM_SYNC FOREIGN KEY (IMAGE_NAME) REFERENCES '||vschema||'.STILL_IMAGE_REPOSITORY (IMAGE_NAME),
                    CONSTRAINT FK_RM_SIMG_RM_SYNC FOREIGN KEY (RM_ID) REFERENCES '||vschema||'.RM (RM_ID))';
		     CREATEOBJECT(vsql,'create table STILL_IMAGE_RM_SYNC');
     	end if;
	--Update for Multiple Categories
      vsql := 'ALTER TABLE '||vschema||'.TEMP_REC_RULES MODIFY (CATEGORY NVARCHAR2(2000))';
      CREATEOBJECT(vsql,'modify table TEMP_REC_RULES for multiple category');

      vsql := 'ALTER TABLE '||vschema||'.temp_old_right_rec_map MODIFY (CATEGORY NVARCHAR2(2000))';
      CREATEOBJECT(vsql,'modify table temp_old_right_rec_map for multiple category');

      vsql := 'ALTER TABLE '||vschema||'.RIGHT MODIFY (CATEGORY NVARCHAR2(2000))';
      CREATEOBJECT(vsql,'modify table RIGHT for multiple category');

      vsql := 'ALTER TABLE '||vschema||'.RECORDING MODIFY (CATEGORY NVARCHAR2(2000))';
      CREATEOBJECT(vsql,'modify table RECORDING for multiple category');

      vsql := 'ALTER TABLE '||vschema||'.RECORDING_QUEUE MODIFY (CATEGORY NVARCHAR2(2000))';
      CREATEOBJECT(vsql,'modify table RECORDING_QUEUE for multiple category');

      vsql := 'ALTER TABLE '||vschema||'.RECORDING_RULES MODIFY (CATEGORY NVARCHAR2(2000))';
      CREATEOBJECT(vsql,'modify table RECORDING_RULES for multiple category');

      vsql := 'ALTER TABLE '||vschema||'.CONFIG_SETTING MODIFY (VALUE NVARCHAR2(2000) )';
      CREATEOBJECT(vsql,'modify table Config_Setting for multiple category');

	  --Update for Recording same assett on mutltiple RTCs
	  if is_column_exists(vschema, 'TEMP_REC_RULES','REDUNDANCY_COUNT') = false then
      		vsql := 'alter table '||vschema||'.TEMP_REC_RULES add REDUNDANCY_COUNT NUMBER(3,0) ';
        	CREATEOBJECT(vsql,'alter TABLE TEMP_REC_RULES');
      end if;

	  if is_column_exists(vschema, 'temp_old_right_rec_map', 'REDUNDANCY_COUNT') = false then
			vsql := 'alter table '||vschema||'.temp_old_right_rec_map add REDUNDANCY_COUNT NUMBER(3,0) ';
        	CREATEOBJECT(vsql,'alter TABLE temp_old_right_rec_map');
      end if;

	  if is_column_exists(vschema, 'RECORDING', 'REDUNDANCY_COUNT') = false then
			vsql := 'alter table '||vschema||'.RECORDING add REDUNDANCY_COUNT NUMBER(3,0) default 1 ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING');
      end if;

	  if is_column_exists(vschema, 'RECORDING_QUEUE', 'REDUNDANCY_COUNT') = false then
			vsql := 'alter table '||vschema||'.RECORDING_QUEUE add REDUNDANCY_COUNT NUMBER(3,0) default 1 ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_QUEUE');
      end if;

	  if is_column_exists(vschema, 'RECORDING_RULES', 'REDUNDANCY_COUNT') = false then
			vsql := 'alter table '||vschema||'.RECORDING_RULES add REDUNDANCY_COUNT NUMBER(3,0) default 1 ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_RULES');
      end if;


      if is_column_exists(vschema, 'RECORDING_LOG','SUB_COMPONENT_STATUS') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_LOG add SUB_COMPONENT_STATUS NUMBER(19,0) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_LOG');
      end if;
      if is_column_exists(vschema, 'RECORDING_LOG','SUB_COMPONENT_TYPE') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_LOG add SUB_COMPONENT_TYPE NVARCHAR2(256) ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_LOG');
      end if;

      if is_column_exists(vschema, 'RECORDING_LOG','SUB_COMPONENT_ID') = false then
      		vsql := 'alter table '||vschema||'.RECORDING_LOG add SUB_COMPONENT_ID NVARCHAR2(256) ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING_LOG');
      end if;

      if is_column_exists(vschema, 'TEMP_RECORDING_LOG','SUB_COMPONENT_STATUS') = false then
      		vsql := 'alter table '||vschema||'.TEMP_RECORDING_LOG add SUB_COMPONENT_STATUS NUMBER(19,0) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE TEMP_RECORDING_LOG');
      end if;
      if is_column_exists(vschema, 'TEMP_RECORDING_LOG','SUB_COMPONENT_TYPE') = false then
      		vsql := 'alter table '||vschema||'.TEMP_RECORDING_LOG add SUB_COMPONENT_TYPE NVARCHAR2(256) ';
        	CREATEOBJECT(vsql,'alter TABLE TEMP_RECORDING_LOG');
      end if;

      if is_column_exists(vschema, 'TEMP_RECORDING_LOG','SUB_COMPONENT_ID') = false then
      		vsql := 'alter table '||vschema||'.TEMP_RECORDING_LOG add SUB_COMPONENT_ID NVARCHAR2(256) ';
        	CREATEOBJECT(vsql,'alter TABLE TEMP_RECORDING_LOG');
      end if;


      if is_column_exists(vschema, 'TEMP_SS_REC','WARNING') = false then
      		vsql := 'alter table '||vschema||'.TEMP_SS_REC add WARNING NUMBER(1,0) DEFAULT 0 ';
        	CREATEOBJECT(vsql,'alter TABLE TEMP_SS_REC');
      end if;
      if is_column_exists(vschema, 'RECORDING','WARNING') = false then
      		vsql := 'alter table '||vschema||'.RECORDING add WARNING NUMBER(1,0) DEFAULT 0 ';
        	CREATEOBJECT(vsql,'alter TABLE RECORDING');
      end if;
      if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','212','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(212, ''Rti_Ftp_Content_Push_Partial'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	  end if;
      if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','213','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(213, ''Partial_Success'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','214','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(214, ''All_Capture_Pending'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','215','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(215, ''Some_Capture_Pending_Some_Capturing'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','216','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(216, ''All_Capturing'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','217','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(217, ''Some_Capture_Pending_Some_Capture_Complete'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','218','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(218, ''Some_Capture_Pending_Some_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','219','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(219, ''Some_Capturing_Some_Capture_Complete'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','220','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(220, ''Some_Capturing_Some_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','221','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(221, ''All_Capture_Complete'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','222','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(222, ''Some_Capture_Complete_Some_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
     if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','223','NUMBER') = false then
		    vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
		        VALUES(223, ''All_Capture_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
		    '; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
	 end if;
	end if;
	IF VTSTVDBVER < '4.0.000.1' THEN
		if is_column_exists(vschema, 'temp_old_right_rec_map','POSTER_ASSET_ID') = false then
      		vsql := 'alter table '||vschema||'.temp_old_right_rec_map add POSTER_ASSET_ID NVARCHAR2 (100) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE temp_old_right_rec_map');
      	end if;
      	if is_column_exists(vschema, 'temp_old_right_rec_map','POSTER_IMAGE_NAME') = false then
      		vsql := 'alter table '||vschema||'.temp_old_right_rec_map add POSTER_IMAGE_NAME	NVARCHAR2(256) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE temp_old_right_rec_map');
      	end if;
      	if is_column_exists(vschema, 'temp_old_right_rec_map','POSTER_DESCRIPTION') = false then
      		vsql := 'alter table '||vschema||'.temp_old_right_rec_map add POSTER_DESCRIPTION NVARCHAR2(1024) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE temp_old_right_rec_map');
      	end if;

      	if is_column_exists(vschema, 'TEMP_REC_RULES','POSTER_IMAGE_NAME') = false then
      		vsql := 'alter table '||vschema||'.TEMP_REC_RULES add POSTER_IMAGE_NAME	NVARCHAR2(256) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE TEMP_REC_RULES');
      	end if;
      	if is_column_exists(vschema, 'TEMP_REC_RULES','POSTER_DESCRIPTION') = false then
      		vsql := 'alter table '||vschema||'.TEMP_REC_RULES add POSTER_DESCRIPTION NVARCHAR2(1024) NULL ';
        	CREATEOBJECT(vsql,'alter TABLE TEMP_REC_RULES');
      	end if;
	    if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','224','NUMBER') = false then
			     vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
	    		    VALUES(224, ''Some_Capture_Extended_Some_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
	    		'; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
		 end if;
	    if IS_COLUMN_VALUE_EXISTS(vschema,'ERROR_CODE','ERROR_CODE','225','NUMBER') = false then
	    		 vsql := 'INSERT INTO '||vschema||'.ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
	        		VALUES(225, ''All_Capture_Extend_Failed'', ''System'', ''System'', current_timestamp, current_timestamp)
	    		'; CREATEOBJECT(vsql,'INSERT INTO ERROR_CODE');
		 end if;
        if is_table_exists(vschema, 'EXPORT_GATEWAY') = false then
    		vsql := 'CREATE TABLE '||vschema||'.EXPORT_GATEWAY (
					UNIQUE_ID NUMBER(19,0) NOT NULL ,
					DATA_COLUMN VARCHAR2(255 BYTE) NOT NULL ,
					STATUS_COL VARCHAR2(255 BYTE) NOT NULL ,
					TIMESTAMP_COL VARCHAR2(255 BYTE),
					DIR VARCHAR2(2000 BYTE),
					CONSTRAINT PK_EXPORT_GATEWAY PRIMARY KEY (UNIQUE_ID))';
		     CREATEOBJECT(vsql,'create table EXPORT_GATEWAY');
     	end if;
        if is_sequence_exists(vschema,'EXPORT_GATEWAY_SEQ') = false then
      	     CREATESEQ('EXPORT_GATEWAY');
        end if;
        if is_table_exists(vschema, 'EXP_SCHEDULE') = false then
        vsql := 'CREATE TABLE '||vschema||'.EXP_SCHEDULE(
				FILENAM VARCHAR2(4000 BYTE),
				STATION_NUM NVARCHAR2(100),
				DATABASE_KEY NVARCHAR2(100),
				SCHEDULE_LANGUAGE NVARCHAR2(100),
				START_TIME NVARCHAR2(100),
				END_TIME NVARCHAR2(100),
				DURATION NUMBER,
				PART_NUMBER NUMBER,
				NO_OF_PARTS NUMBER,
				CC NVARCHAR2(1),
				STEREO NVARCHAR2(1),
				REPEAT NVARCHAR2(1),
				LIVE_TAPE_DELAY NVARCHAR2(100),
				SUBTITLED NVARCHAR2(1),
				PREMIERE_FINALE NVARCHAR2(100),
				JOINED_IN_PROGRESS NVARCHAR2(1),
				CABLE_IN_CLASSROOM NVARCHAR2(1),
				TV_RATING NVARCHAR2(1000),
				SAP NVARCHAR2(1),
				BLACKOUT NVARCHAR2(1),
				SEX_RATING NVARCHAR2(1),
				VIOLENCE_RATING NVARCHAR2(1),
				LANGUAGE_RATING NVARCHAR2(1),
				DIALOG_RATING NVARCHAR2(1),
				FV_RATING NVARCHAR2(1),
				ENHANCED NVARCHAR2(1),
				THREE_D NVARCHAR2(1),
				LETTERBOX NVARCHAR2(1),
				HD_TV NVARCHAR2(1),
				DOLBY NVARCHAR2(100),
				DVS NVARCHAR2(1),
				EVENT_ID XMLTYPE ,
				SERIES_LINK XMLTYPE ,
				USER_DATA1 VARCHAR2(1000 BYTE),
				USER_DATA2 VARCHAR2(1000 BYTE),
				USER_DATA3 VARCHAR2(1000 BYTE),
				USER_DATA4 VARCHAR2(1000 BYTE),
				USER_DATA5 VARCHAR2(1000 BYTE),
				USER_DATA6 VARCHAR2(1000 BYTE),
				USER_DATA7 VARCHAR2(1000 BYTE),
				USER_DATA8 VARCHAR2(1000 BYTE),
				USER_DATA9 VARCHAR2(1000 BYTE),
				USER_DATA10 VARCHAR2(1000 BYTE),
				USER_DATA11 VARCHAR2(1000 BYTE),
				SCHEDULE_GENERIC XMLTYPE ,
				REQUEST_RECORD VARCHAR2(1 BYTE),
				SCHEDULE_ID VARCHAR2(20 BYTE),
				PROGRAM_ID VARCHAR2(20 BYTE),
				STATION_ID VARCHAR2(20 BYTE),
                RECORDABLE NUMBER)';
		     CREATEOBJECT(vsql,'create table EXP_SCHEDULE');
     	end if;

	    if is_table_exists(vschema, 'MESSAGE') = false then
    		vsql := 'CREATE TABLE '||vschema||'.MESSAGE
   			(
    			UUID VARCHAR2(128 BYTE) NOT NULL ,
				TYPE VARCHAR2(128 BYTE) NOT NULL ,
				MESSAGE CLOB NOT NULL ENABLE,
				DELIVERED VARCHAR2(10 BYTE) NOT NULL ,
				CLASSIFICATION VARCHAR2(10 BYTE),
				CONSTRAINT PK_MESSAGE PRIMARY KEY ("UUID"))';
		     CREATEOBJECT(vsql,'create table MESSAGE');
     	end if;
	    if is_table_exists(vschema, 'TX_ESB_MESSAGES') = false then
    		vsql := 'CREATE TABLE '||vschema||'.TX_ESB_MESSAGES
   				(	MESSAGE_ID VARCHAR2(255 BYTE) NOT NULL ENABLE,
					DATA_COLUMN CLOB NOT NULL ENABLE,
					STATUS_COL VARCHAR2(255 BYTE) NOT NULL ENABLE,
					TIMESTAMP_COL VARCHAR2(255 BYTE))';
    		CREATEOBJECT(vsql,'create table TX_ESB_MESSAGES');
     	end if;
	end if;
	if VTSTVDBVER < '4.0.000.2' THEN

			-- EPG driven auto-approve fields
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleLanguage','VARCHAR2') = false then
			vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
			        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleLanguage'',''SCHEDULE'',''SCHEDULE_LANGUAGE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.duration','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.duration'',''SCHEDULE'',''DURATION'',2, 5,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.tvRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.tvRating'',''SCHEDULE'',''TV_RATING'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.partNumber','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.partNumber'',''SCHEDULE'',''PART_NUMBER'',2, 5,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.noOfParts','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.noOfParts'',''SCHEDULE'',''NO_OF_PARTS'',2, 5,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.cc','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.cc'',''SCHEDULE'',''CC'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stereo','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stereo'',''SCHEDULE'',''STEREO'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.subtitled','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.subtitled'',''SCHEDULE'',''SUBTITLED'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.premiereFinale','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.premiereFinale'',''SCHEDULE'',''PREMIERE_FINALE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.joinedInProgress','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.joinedInProgress'',''SCHEDULE'',''JOINED_IN_PROGRESS'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.cableInClassroom','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.cableInClassroom'',''SCHEDULE'',''CABLE_IN_CLASSROOM'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		 end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.sap','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.sap'',''SCHEDULE'',''SAP'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.sexRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.sexRating'',''SCHEDULE'',''SEX_RATING'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.violenceRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.violenceRating'',''SCHEDULE'',''VIOLENCE_RATING'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.languageRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.languageRating'',''SCHEDULE'',''LANGUAGE_RATING'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.dialogRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		       VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dialogRating'',''SCHEDULE'',''DIALOG_RATING'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.fvRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.fvRating'',''SCHEDULE'',''FV_RATING'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.enhanced','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.enhanced'',''SCHEDULE'',''ENHANCED'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.threeD','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.threeD'',''SCHEDULE'',''THREE_D'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.letterBox','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.letterBox'',''SCHEDULE'',''LETTERBOX'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.dvs','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dvs'',''SCHEDULE'',''DVS'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.blackout','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.blackout'',''SCHEDULE'',''BLACKOUT'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.dolby','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dolby'',''SCHEDULE'',''DOLBY'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.requestToRecord','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.requestToRecord'',''SCHEDULE'',''REQUEST_RECORD'',2, 4,''DROPDOWN_Y'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programId','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programId'',''PROGRAM'',''PROGRAM_ID'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.language','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.language'',''PROGRAM'',''LANGUAGE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programTitle','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programTitle'',''PROGRAM'',''TITLE,REDUCED_TITLE1,REDUCED_TITLE2,REDUCED_TITLE3,REDUCED_TITLE4'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.altTitle','VARCHAR2') = false then

		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.altTitle'',''PROGRAM'',''ALT_TITLE'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programDescription','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programDescription'',''PROGRAM'',''DESCRIPTION1,DESCRIPTION2,REDUCED_DESCRIPTION1,REDUCED_DESCRIPTION2,REDUCED_DESCRIPTION3,REDUCED_DESCRIPTION4'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.advisoryDescription','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.advisoryDescription'',''PROGRAM'',''ADVISORY_DESC1,ADVISORY_DESC2,ADVISORY_DESC3,ADVISORY_DESC4,ADVISORY_DESC5,ADVISORY_DESC6'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		 end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.genereDescription','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.genereDescription'',''PROGRAM'',''GENRE_DESC1,GENRE_DESC2,GENRE_DESC3,GENRE_DESC4,GENRE_DESC5,GENRE_DESC6'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.year','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.year'',''PROGRAM'',''YEAR_PROGRAM'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.mpaaRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.mpaaRating'',''PROGRAM'',''MPAA_RATING'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.starRating','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.starRating'',''PROGRAM'',''STAR_RATING'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.runTime','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.runTime'',''PROGRAM'',''RUN_TIME'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.colorCode','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.colorCode'',''PROGRAM'',''COLOR_CODE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programLanguage','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programLanguage'',''PROGRAM'',''PROGRAM_LANGUAGE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.countryOfOrigin','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.countryOfOrigin'',''PROGRAM'',''COUNTRY_OF_ORIGIN'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.madeForTV','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.madeForTV'',''PROGRAM'',''MADE_FOR_TV'',2, 4,''DROPDOWN_YN'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.sourceType','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.sourceType'',''PROGRAM'',''SOURCE_TYPE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.showType','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.showType'',''PROGRAM'',''SHOW_TYPE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.holiday','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.holiday'',''PROGRAM'',''HOLIDAY'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.syndicateEpisodeNum','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.syndicateEpisodeNum'',''PROGRAM'',''SYNDICATE_EPISODE_NUM'',2, 4,''TEXTFIELD'')';
			CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;
		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.altSyndicateEpisodeNum','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.altSyndicateEpisodeNum'',''PROGRAM'',''ALT_SYNDICATE_EPI_NUM'',2, 4,''TEXTFIELD'')';
			CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.episodeTitle','VARCHAR2') = false then

		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.episodeTitle'',''PROGRAM'',''EPISODE_TITLE'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.netSynSource','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.netSynSource'',''PROGRAM'',''NET_SYN_SOURCE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.netSynType','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.netSynType'',''PROGRAM'',''NET_SYN_TYPE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.orgStudio','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.orgStudio'',''PROGRAM'',''ORG_STUDIO'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.gameTimezone','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.gameTimezone'',''PROGRAM'',''GAME_TIMEZONE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;


		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.uniqueId','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.uniqueId'',''PROGRAM'',''UNIQUE_ID'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;


		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationId','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationId'',''STATION'',''STATION_ID'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationName','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationName'',''STATION'',''STATION_NAME'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationTimezone','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationTimezone'',''STATION'',''TIME_ZONE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.callSign','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.callSign'',''STATION'',''CALL_SIGN'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationCity','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationCity'',''STATION'',''CITY'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationState','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationState'',''STATION'',''STATE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationZipcode','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationZipcode'',''STATION'',''ZIPCODE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationCountry','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationCountry'',''STATION'',''COUNTRY'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.dmaName','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dmaName'',''STATION'',''DMA_NAME'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.dmaNumber','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.dmaNumber'',''STATION'',''DMA_NUMBER'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.fccChannelNumber','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.fccChannelNumber'',''STATION'',''FCC_CHANNEL_NUM'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.affiliation','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.affiliation'',''STATION'',''AFFILIATION'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData1','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData1'',''PROGRAM'',''USER_DATA1'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData2','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData2'',''PROGRAM'',''USER_DATA2'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData3','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		        VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData3'',''PROGRAM'',''USER_DATA3'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData4','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData4'',''PROGRAM'',''USER_DATA4'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData5','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData5'',''PROGRAM'',''USER_DATA5'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData6','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData6'',''PROGRAM'',''USER_DATA6'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData7','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData7'',''PROGRAM'',''USER_DATA7'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData8','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData8'',''PROGRAM'',''USER_DATA8'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData9','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData9'',''PROGRAM'',''USER_DATA9'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData10','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData10'',''PROGRAM'',''USER_DATA10'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData11','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData11'',''PROGRAM'',''USER_DATA11'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData12','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData12'',''PROGRAM'',''USER_DATA12'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.programUserData13','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.programUserData13'',''PROGRAM'',''USER_DATA13'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData1','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData1'',''SCHEDULE'',''USER_DATA1'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData2','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData2'',''SCHEDULE'',''USER_DATA2'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData3','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData3'',''SCHEDULE'',''USER_DATA3'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData4','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData4'',''SCHEDULE'',''USER_DATA4'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData5','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData5'',''SCHEDULE'',''USER_DATA5'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData6','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData6'',''SCHEDULE'',''USER_DATA6'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData7','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData7'',''SCHEDULE'',''USER_DATA7'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData8','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData8'',''SCHEDULE'',''USER_DATA8'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData9','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData9'',''SCHEDULE'',''USER_DATA9'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData10','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData10'',''SCHEDULE'',''USER_DATA10'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.scheduleUserData11','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.scheduleUserData11'',''SCHEDULE'',''USER_DATA11'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData1','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData1'',''STATION'',''USER_DATA1'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData2','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData2'',''STATION'',''USER_DATA2'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData3','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData3'',''STATION'',''USER_DATA3'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData4','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData4'',''STATION'',''USER_DATA4'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData5','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData5'',''STATION'',''USER_DATA5'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData6','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData6'',''STATION'',''USER_DATA6'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData7','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData7'',''STATION'',''USER_DATA7'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData8','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData8'',''STATION'',''USER_DATA8'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData9','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData9'',''STATION'',''USER_DATA9'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.stationUserData10','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.stationUserData10'',''STATION'',''USER_DATA10'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendId','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendId'',''HEADEND'',''HEADEND_ID'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendCommunityName','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendCommunityName'',''HEADEND'',''COMMUNITY_NAME'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendCountyName','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendCountyName'',''HEADEND'',''COUNTY_NAME'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendStCountyCode','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendStCountyCode'',''HEADEND'',''ST_COUNTY_CODE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendCountySize','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendCountySize'',''HEADEND'',''COUNTY_SIZE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendState','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendState'',''HEADEND'',''STATE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendZipCode','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendZipCode'',''HEADEND'',''ZIPCODE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendDMACode','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendDMACode'',''HEADEND'',''DMA_CODE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendDMAName','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendDMAName'',''HEADEND'',''DMA_NAME'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendMSOCode','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendMSOCode'',''HEADEND'',''MSO_CODE'',2, 5,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendDMARank','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendDMARank'',''HEADEND'',''DMA_RANK'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendName','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendName'',''HEADEND'',''HEADEND_NAME'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendLocation','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendLocation'',''HEADEND'',''HEADEND_LOCATION'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendMSOName','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendMSOName'',''HEADEND'',''MSO_NAME'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.headendTimezone','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.headendTimezone'',''HEADEND'',''TIME_ZONE'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.lineupDevice','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.lineupDevice'',''LINEUP'',''device'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.lineupId','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.lineupId'',''LINEUP'',''LINEUP_ID'',2, 5,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.serviceTier','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.serviceTier'',''LINEUP'',''SERVICE_TIER'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.tmsChannel','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.tmsChannel'',''LINEUP'',''TMS_CHANNEL'',2, 4,''SELECT_TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

	     if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.seriesId','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.seriesId'',''SERIES'',''SERIES_ID'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		if IS_COLUMN_VALUE_EXISTS(vschema,'ENTITY_MAPPING','NAME','autoApproveEpgDrivenField.seriesTitle','VARCHAR2') = false then
		    vsql := 'INSERT INTO '||vschema||'.ENTITY_MAPPING(MAPPING_ID, NAME, TABLE_NAME, COLUMN_NAME, TYPE, ASSET_TYPE, GENERIC_NAME)
		      VALUES('||vschema||'.ENTITY_MAPPING_SEQ.NEXTVAL,''autoApproveEpgDrivenField.seriesTitle'',''SERIES'',''TITLE'',2, 4,''TEXTFIELD'')';
		   CREATEOBJECT(vsql,'INSERT INTO ENTITY_MAPPING');
		end if;

		   vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS_CODE=216 WHERE STATUS_CODE=202';
    	 CREATEOBJECT(vsql,'UPDATE RECORDING');

	     vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS_CODE=221 WHERE STATUS_CODE=203';
    	 CREATEOBJECT(vsql,'UPDATE RECORDING');

	     vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS_CODE=223 WHERE STATUS_CODE=205';
	     CREATEOBJECT(vsql,'UPDATE RECORDING');

    	 vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS_CODE=214 WHERE STATUS_CODE=206';
	     CREATEOBJECT(vsql,'UPDATE RECORDING');

    	 vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS_CODE=225 WHERE STATUS_CODE=505';
	     CREATEOBJECT(vsql,'UPDATE RECORDING');

    	 vsql := 'UPDATE '||vschema||'.RECORDING SET STATUS_CODE=223 WHERE STATUS_CODE=501';
     	 CREATEOBJECT(vsql,'UPDATE RECORDING');

		if is_table_exists(vschema, 'rec_rules_auto_approve_fields') = false then
			vsql :='CREATE TABLE '||vschema||'.rec_rules_auto_approve_fields
		    (
		      id  number (19,0) not null,
		      rule_id    NUMBER(19,0) NOT NULL ,
		      mapping_id NUMBER(19,0) NOT NULL,
		      value nvarchar2(2000) NOT NULL ,
		      compare_operator VARCHAR2(10) DEFAULT ''='',
		      CREATED_BY NVARCHAR2(50) NOT NULL ,
		      UPDATED_BY NVARCHAR2(50) NOT NULL ,
		      CREATE_DATE TIMESTAMP (6) NOT NULL ,
		      UPDATE_DATE TIMESTAMP (6) NOT NULL ,
		      CONSTRAINT REC_RULES_AA_FIELD_PK PRIMARY KEY (id),
		      CONSTRAINT REC_RULES_AA_FIELD_UNIQUE unique  (rule_id, mapping_id,value),
		      CONSTRAINT RR_AA_F_REC_RULES_FK FOREIGN KEY (rule_id) REFERENCES '||vschema||'.RECORDING_RULES (rule_id),
		      CONSTRAINT RR_AA_F_ENTITY_MAPPING_FK FOREIGN KEY (mapping_id) REFERENCES '||vschema||'.ENTITY_MAPPING (mapping_id)
		    )';
			CREATEOBJECT(vsql,'create TABLE rec_rules_auto_approve_fields');
		end if;
		if is_sequence_exists(vschema,'rec_rules_aa_fields_SEQ') = false then
			vsql := 'CREATE SEQUENCE '||vschema||'.rec_rules_aa_fields_SEQ START WITH 1 INCREMENT BY 1';
			CREATEOBJECT(vsql,'create SEQUENCE rec_rules_aa_fields_SEQ');
		END IF;

		-- data migration of the epg driven rules

		vsql := 'insert into '||vschema||'.REC_RULES_AUTO_APPROVE_FIELDS (id, rule_id, mapping_id, value, compare_operator, created_by, create_date, updated_by, update_date)
			  	(
			    select
			        '||vschema||'.rec_rules_aa_fields_SEQ.nextval, rule_id,
			       (select mapping_id from '||vschema||'.entity_mapping where type=2 and upper(column_name) = ''REQUEST_RECORD'' and upper(table_name)=''SCHEDULE'') as mapping_id,
			         ''Y'', ''='',''SYSTEM'',current_timestamp, ''SYSTEM'',current_timestamp from '||vschema||'.recording_rules rr where rr.auto_approve =1 and rr.dynexpr=''UPPER(SCHEDULE.REQUEST_RECORD) = ''''Y''''''
			         and not exists
			         ( select 1 from '||vschema||'.REC_RULES_AUTO_APPROVE_FIELDS rraaf where rraaf.rule_id=rr.rule_id and rraaf.mapping_id = (select mapping_id from '||vschema||'.entity_mapping where type=2 and upper(column_name) = ''REQUEST_RECORD'' and upper(table_name)=''SCHEDULE'')
			          and rraaf.value=''Y'')

			   )';
		CREATEOBJECT(vsql,'EPG Driven Rules data migration');
	end if; -- End of 4.0.000.2

	if VTSTVDBVER < '4.0.000.3' THEN
		if is_table_exists(vschema, 'EXP_GENERIC') = false then
	     	vsql := 'CREATE TABLE '||vschema||'.EXP_GENERIC
	   			(
					PROGRAM_ID VARCHAR2(20 BYTE),
					TIMESHIFT_REPLAY VARCHAR2(20 BYTE),
					SEASON_FINALE VARCHAR2(200 BYTE),
					TIMESHIFT_RESTART VARCHAR2(20 BYTE),
					EPISODE_ID VARCHAR2(20 BYTE),
					TRICK_PLAY_RESTRICTED VARCHAR2(20 BYTE),
                    PPV VARCHAR2(20 BYTE)
	   			)';
	   			CREATEOBJECT(vsql, 'create TABLE EXP_GENERIC');
   		end if;


	end if;

	if VTSTVDBVER < '4.0.000.4' THEN
	  --vsql := 'INSERT INTO '||vschema||'.config_setting
	if IS_COLUMN_VALUE_EXISTS(vschema,'config_setting','key','XMLTVenabled','VARCHAR2') = false then
	    vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
	      VALUES(''XMLTVenabled'', ''1'', ''System'', ''System'', current_timestamp, current_timestamp)';
	    CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
    end if;

    if IS_COLUMN_VALUE_EXISTS(vschema,'config_setting','key','XMLTVmin','VARCHAR2') = false then
    	vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      	VALUES(''XMLTVmin'', ''30'', ''System'', ''System'', current_timestamp, current_timestamp)';
    	CREATEOBJECT(vsql,'INSERT INTO CONFIG_SETTING');
    end if;


    if is_column_exists(vschema, 'EXP_GENERIC','PPV') = false then
      		vsql := 'alter table '||vschema||'.EXP_GENERIC add PPV NVARCHAR2(20) ';
        	CREATEOBJECT(vsql,'alter TABLE EXP_GENERIC');
     end if;
    if is_column_exists(vschema, 'EXP_GENERIC','PREMIER') = false then
      		vsql := 'alter table '||vschema||'.EXP_GENERIC add PREMIER NVARCHAR2(20) ';
        	CREATEOBJECT(vsql,'alter TABLE EXP_GERNIC');
     end if;



  end if;

  if VTSTVDBVER < '4.1.000.0' THEN
	  if is_table_exists(vschema, 'temp_station_sch_range') = false then
		vsql := '	create table '||vschema||'.temp_station_sch_range
				(
					STATION_ID NVARCHAR2(100) primary key,
					first_schedule_start_time timestamp(0) with time zone,
					last_schedule_end_time timestamp(0) with time zone
				)';
		CREATEOBJECT(vsql, 'create TABLE temp_station_sch_range');

	   	end if;
	  if is_table_exists(vschema, 'temp_program_ids') = false then
	   	vsql := ' create table '||vschema||'.temp_program_ids(program_id NVARCHAR2(100)) ';
		CREATEOBJECT(vsql, 'create TABLE temp_program_ids');
	  end if;

   	  if is_table_exists(vschema, 'X_CATEGORY') = false then
   		 vsql := 'CREATE TABLE '||vschema||'.X_CATEGORY
  				(
				PROGAMID VARCHAR2(20 BYTE),
				CATEGORY VARCHAR2(200 BYTE)
			     ) ';
			    CREATEOBJECT(vsql,'create table X_CATEGORY');
		end if;

	 if is_table_exists(vschema, 'X_DESC') = false then
        vsql := 'CREATE TABLE '||vschema||'.X_DESC(
               PROGRAMID VARCHAR2(20 BYTE),
	           DESCRIPTION VARCHAR2(2500 BYTE)
   				) ';
   				CREATEOBJECT(vsql,'create table X_DESC');
		end  if;

	if is_table_exists(vschema, 'X_LINE') = false then
	    vsql := 'CREATE TABLE '||vschema||'.X_LINE(
		    CL_ROW_ID VARCHAR2(20 BYTE),
			CL_STATION_NUM VARCHAR2(20 BYTE),
			CL_HEADEND_ID VARCHAR2(20 BYTE),
			CL_TMS_CHAN VARCHAR2(20 BYTE),
			CL_SERVICE_TIER VARCHAR2(20 BYTE),
			CL_EFFECTIVE_DATE VARCHAR2(40 BYTE),
			CL_EXPIRATION_DATE VARCHAR2(40 BYTE)
		   ) ';
	   		CREATEOBJECT(vsql,'create table X_LINE');
 	  end  if;

	if is_table_exists(vschema, 'X_LOCK') = false then
	  	vsql := 'CREATE TABLE '||vschema||'.X_LOCK (
	        BLOCK NVARCHAR2(20) NOT NULL ENABLE
	   		) ';
	   		CREATEOBJECT(vsql,'create table X_LOCK');

	 end  if;

		if is_table_exists(vschema, 'X_PROGRAMME') = false then
		   vsql := 'CREATE TABLE '||vschema||'.X_PROGRAMME (
		    DATABASE_KEY VARCHAR2(20 BYTE),
			LANGUAGE VARCHAR2(2 BYTE),
			TITLE VARCHAR2(500 BYTE),
			REDUCED_TITLE VARCHAR2(500 BYTE),
			ALT_TITLE VARCHAR2(500 BYTE),
			REDUCED_DESC VARCHAR2(2500 BYTE),
			GENRE_DESC1 VARCHAR2(200 BYTE),
			GENRE_DESC2 VARCHAR2(200 BYTE),
			GENRE_DESC3 VARCHAR2(200 BYTE),
			GENRE_DESC4 VARCHAR2(200 BYTE),
			GENRE_DESC5 VARCHAR2(200 BYTE),
			GENRE_DESC6 VARCHAR2(200 BYTE),
			DESC1 VARCHAR2(2500 BYTE),
			ORG_STUDIO VARCHAR2(20 BYTE),
			TIMESHIFT_RESTART VARCHAR2(200 BYTE),
			TIMESHIFT_REPLAY VARCHAR2(200 BYTE),
			EVENT_ID VARCHAR2(200 BYTE),
			EPISODE VARCHAR2(200 BYTE),
			EPISODE_ID VARCHAR2(200 BYTE),
			SEASON_PREMIERE VARCHAR2(200 BYTE),
			"LAST-CHANCE" VARCHAR2(200 BYTE),
			PPV VARCHAR2(200 BYTE),
			DESC2 VARCHAR2(2500 BYTE),
			EPI_TITLE VARCHAR2(2000 BYTE),
			EPI_TITLE2 VARCHAR2(2000 BYTE)
		 ) ';
			   CREATEOBJECT(vsql,'create table X_PROGRAMME');
		  end  if;

		if is_table_exists(vschema, 'X_SCHEDULE') = false then
		   vsql := 'CREATE TABLE '||vschema||'.X_SCHEDULE (
		  	STATION_NUM VARCHAR2(20 BYTE),
			DATABASE_KEY VARCHAR2(20 BYTE),
			LANGUAGE VARCHAR2(20 BYTE),
			AIR_DATE VARCHAR2(40 BYTE),
			DURATION VARCHAR2(20 BYTE),
			CC VARCHAR2(20 BYTE),
			TV_RATING VARCHAR2(20 BYTE)
		 ) ';
			CREATEOBJECT(vsql,'create table X_SCHEDULE');
		  end  if;


		if is_table_exists(vschema, 'X_STATION') = false then
		vsql := 'CREATE TABLE '||vschema||'.X_STATION
		   (
		   STATION_NUM VARCHAR2(20 BYTE),
		   STATION_NAME VARCHAR2(200 BYTE),
		   STATION_CALL_SIGN VARCHAR2(200 BYTE),
		   STATION_AFFIL VARCHAR2(200 BYTE),
		   STATION_ORIG VARCHAR2(40 BYTE)
		 ) ';
			 CREATEOBJECT(vsql,'create table X_STATION');
		  end  if;

		if is_table_exists(vschema, 'X_STATION') = false then
		vsql := 'CREATE TABLE '||vschema||'.X_SUBTITLE
		   (
		   PROGRAMID VARCHAR2(20 BYTE),
		   SUBTITLE VARCHAR2(2000 BYTE)
		   )';
			 CREATEOBJECT(vsql,'create table X_SUBTITLE');

		   end  if;

		if is_constraint_exists (vschema, 'REC_TRIAL_USE_FIELDS','REC_TRIAL_USE_RECORDING_FK') = false then
        	vsql:='ALTER TABLE '||vschema||'.REC_TRIAL_USE_FIELDS ADD CONSTRAINT REC_TRIAL_USE_RECORDING_FK FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING (RECORDING_ID) ';
        	CREATEOBJECT(VSQL,'ALTER TABLE REC_TRIAL_USE_FIELDS');
      	end if;

		-- Delete the schema registration
	 vsql := 'BEGIN
	 		    DBMS_XMLSCHEMA.deleteSchema(
					SCHEMAURL => ''http://xmlns.oracle.com/xdb/schemas/'||vschema||'/ETV_EPG.xsd'',delete_option=>DBMS_XMLSchema.DELETE_CASCADE_FORCE);
			END;';

	CREATEOBJECT(vsql,'DBMS_XMLSCHEMA.deleteSchema ETV_EPG.xsd', 'Y');

   	    --Register Schema ETV_EPG.xsd
      vsql := 'BEGIN
                DBMS_XMLSCHEMA.registerSchema(
                  SCHEMAURL => ''ETV_EPG.xsd'',
                  SCHEMADOC => bfilename(''TSTVXMLDIR'',''ETV_EPG.xsd''),
                  OWNER => ''RCS'',
                  CSID => nls_charset_id(''AL32UTF8'')
                  );
               END;';
      CREATEOBJECT(vsql,'Unable to registerSchema ETV_EPG.xsd', 'Y');


  end if;

	if VTSTVDBVER < '4.1.000.6' THEN
		vsql := ' alter table '||vschema||'.recording_log modify recording_id  not null ';
		CREATEOBJECT(vsql,'alter table rcs.recording_log modify recording_id  not null', 'Y');

 		vsql := ' alter table '||vschema||'.REC_TRIAL_USE_FIELDS modify recording_id  not null ';
 		CREATEOBJECT(vsql,'alter table rcs.recording_log modify recording_id  not null', 'Y');

 		vsql := ' alter table '||vschema||'.RECORDING_REC_RULES_MAP modify recording_id  not null ';
 		CREATEOBJECT(vsql,'alter table rcs.recording_log modify recording_id  not null', 'Y');

		if is_constraint_exists (vschema, 'RECORDING_REC_RULES_MAP','FK_REC_RULES_MAP_REC_01') = true then
             vsql:='ALTER TABLE '||vschema||'.RECORDING_REC_RULES_MAP RENAME CONSTRAINT FK_REC_RULES_MAP_REC_01 TO FK_REC_REC_RULES_MAP ';
             CREATEOBJECT(vsql,'ALTER TABLE RECORDING_REC_RULES_MAP RENAME CONSTRAINT FK_REC_RULES_MAP_REC_01 TO FK_REC_REC_RULES_MAP');
       end if;

	end if;

	if VTSTVDBVER < '5.0.000.0' THEN

	-- TODO schema names are hardcoded in the queries, and they have to be replaced with constants instead
	
	-- Append _rcs to the username if matches any other user name in the cms db except admin, and it checks two levels
	
	  vsql := ' update rcs.cms_user rcu set username=username||''_rcs_rcs'' where rcu.username in (select username from wfs.cms_user wcu where wcu.username !=''admin'')
                                                                  and not exists (select 1 from  wfs.cms_user wcu where wcu.username !=''admin'' and wcu.username=rcu.username||''_rcs'')
                                                                  and 1 = (select count(1) from rcs.cms_user rcu1 where rcu1.username=rcu.username||''_rcs'')';
    CREATEOBJECT(vsql,'double update check', 'Y');
                                                                  
   	vsql := ' update rcs.cms_role rcu set role_name=role_name||''_rcs_rcs'' where rcu.role_name in (select role_name from wfs.cms_role wcu where wcu.role_name !=''Admin'')
                                                                  and not exists (select 1 from  wfs.cms_role wcu where wcu.role_name !=''Admin'' and wcu.role_name=rcu.role_name||''_rcs'')
                                                                  and 1 = (select count(1) from rcs.cms_role rcu1 where rcu1.role_name=rcu.role_name||''_rcs'')';
                                                                  
	CREATEOBJECT(vsql,'double update check', 'Y');
	
	vsql := ' update rcs.cms_user rcu set username=username||''_rcs'' where rcu.username in (select username from wfs.cms_user wcu where wcu.username !=''admin'')'; 
	CREATEOBJECT(vsql,'Append _rcs to the username if matches any other user name in the cms db except admin', 'Y');
	
	-- Append _rcs to the role_name if matches any other role name in the cms db except Admin, and it checks two  levels
	
	vsql := ' update rcs.cms_role rcr set role_name  =role_name||''_rcs'' where rcr.role_name in (select role_name from wfs.cms_role wcr where wcr.role_name !=''Admin'')'; 
	CREATEOBJECT(vsql,'Append _rcs to the role_name if matches any other role name in the cms db except Admin', 'Y');
	
	-- Copying the users from rcs to cms

	vsql := ' INSERT INTO  wfs.cms_user (userid, USERNAME,PASSWORD,PASSWORDMODIFIEDDATE,ACTIVE,FIRSTNAME,LASTNAME,EMAIL,PHONE,EXTENSION,EMPLOYEEID,DEPARTMENT,LOCATION,EXTERNALKEY,SYNCDATE)
 				SELECT wfs.cms_user_seq.nextval, r.USERNAME,r.PASSWORD,r.PASSWORDMODIFIEDDATE,r.ACTIVE,r.FIRSTNAME,r.LASTNAME,r.EMAIL,r.PHONE,r.EXTENSION,r.EMPLOYEEID,
 				r.DEPARTMENT,r.LOCATION,NULL,NULL FROM rcs.cms_user r  where not exists (select 1 from wfs.cms_user w where r.username = w.username) ';
 	CREATEOBJECT(vsql,'Migrating the RCS users to CMS users');


  -- insert the role from rcs to cms
  vsql := ' INSERT INTO wfs.cms_role(roleid, ROLE_NAME,DESCRIPTION) SELECT wfs.cms_role_seq.nextval, rcr.ROLE_NAME,rcr.DESCRIPTION FROM rcs.cms_role rcr where not exists (select 1 from wfs.cms_role wcr where wcr.role_name = rcr.role_name) ';
  CREATEOBJECT(vsql,'Migrating the RCS Roles to CMS Roles');


	-- insert the userrole combinations

	vsql :=' merge into wfs.cms_userroles wur_main using
	  (
	  select wcu.userid, wcr.roleid from wfs.cms_user wcu , wfs.cms_role wcr where (wcu.username,wcr.role_name)
	  in (
	       select rcu.username, rcr.role_name from RCS.cms_userroles rcur join rcs.cms_user rcu on (rcur.userid = rcu.userid) join rcs.cms_role rcr on (rcur.roleid = rcr.roleid)

	    )
	   ) temp on ( wur_main.userid= temp.userid and wur_main.roleid = temp.roleid)

	   when not matched  then
	   insert (userid, roleid) values (temp.userid, temp.roleid)';

  CREATEOBJECT(vsql,'Merging user userroles from rcs to cms');

    -- insert the modules from rcs to cms

 vsql := ' insert into wfs.cms_module (moduleid, modulename, displayname)  select wfs.cms_module_seq.nextval, modulename, ''TSTV ''||DISPLAYNAME AS displayname from rcs.cms_module rcm
  			where not exists (select 1 from wfs.cms_module wcm where rcm.modulename = wcm.modulename)';

 CREATEOBJECT(vsql,'Merging modules from rcs to cms');


 -- insert into wfs cms_permission from rcs cms_permission


 vsql :=' merge into wfs.cms_permission wcp_main using
  (
    select wcm.moduleid, mod_temp.* from wfs.cms_module wcm join
    ( select rcm.modulename, rcp.permissionname, rcp.displayname, rcp.ordernumber from rcs.cms_permission rcp join rcs.cms_module rcm on (rcp.moduleid = rcm.moduleid) ) mod_temp on (wcm.modulename = mod_temp.modulename)
  ) temp on ( wcp_main.moduleid = temp.moduleid and wcp_main.permissionname = temp.permissionname)

  when not matched then
  insert (permissionid, permissionname, displayname, moduleid, ordernumber) values (wfs.cms_permission_seq.nextval, temp.permissionname, temp.displayname, temp.moduleid, temp.ordernumber)';

 CREATEOBJECT(vsql,'Merging cms_permission from rcs to cms');


-- insert the role permissions

  vsql := ' merge into wfs.cms_rolepermissions scrp_main using
  (
      select temp1.roleid, temp1.permissionid from (
        select rcr.roleid, rcp.permissionid,  rcr.role_name, rcm.modulename, rcp.permissionname from wfs.cms_role rcr join wfs.cms_permission rcp on (1=1) join wfs.cms_module rcm on (rcm.moduleid = rcp.moduleid)
      ) temp1 join
      (
        select rcr.role_name, rcm.modulename, rcp.permissionname from rcs.cms_rolepermissions rcrp join rcs.cms_role rcr on (rcrp.roleid = rcr.roleid) join rcs.cms_permission rcp on (rcp.permissionid = rcrp.permissionid) join rcs.cms_module rcm on (rcm.moduleid = rcp.moduleid)
      ) temp2 on (temp1.role_name=temp2.role_name and temp1.modulename = temp2.modulename and temp1.permissionname = temp2.permissionname)

  ) temp on ( scrp_main.roleid = temp.roleid and scrp_main.permissionid = temp.permissionid)
  when not matched then
  insert (roleid, permissionid) values (temp.roleid, temp.permissionid)';

  CREATEOBJECT(vsql,'Merging rolepermissions from rcs to cms');



  -- Inserting new user ids and corresponding rm permissions into RCS

	vsql := ' create table rcs.temp_user_ext as
		select wcu.userid, temp.all_rm_access from wfs.cms_user wcu join
		(
		  select rcu.username, rue.all_rm_access from rcs.user_ext rue join rcs.cms_user rcu on (rue.userid = rcu.userid)
		) temp on (wcu.username = temp.username) ';
	CREATEOBJECT(vsql,'Creating a temp table for user_ext');

	vsql := ' delete from rcs.user_ext ';
	CREATEOBJECT(vsql,'delete from rcs.user_ext');

	vsql := 'insert into rcs.user_ext(userid, all_rm_access, create_date, update_date, created_by, updated_by)
	select userid, all_rm_access, current_timestamp, current_timestamp, ''system'',''system'' from rcs.temp_user_ext';
	CREATEOBJECT(vsql,'insert into rcs.user_ext');
      
        vsql := ' update rcs.rm set port=8443 where port=8080 and is_deleted=0 ';
        CREATEOBJECT(vsql,'update rcs.rm set port=8443');

      vsql := ' update rcs.recording_queue set rm_port = 8443 where rm_port=8080 ';
        CREATEOBJECT(vsql,'update rcs.recording_queue set rm_port=8443');


	vsql := ' drop table rcs.temp_user_ext ';
	CREATEOBJECT(vsql,'drop table rcs.temp_user_ext ', 'Y');


	vsql := ' create table rcs.temp_user_rm_map as

				select wcu.userid, temp.rm_id from wfs.cms_user wcu join
				(
				 select rcu.username, rurm.rm_id from rcs.user_rm_map rurm  join rcs.cms_user rcu on (rurm.userid = rcu.userid)
				) temp on (wcu.username = temp.username) ';

	CREATEOBJECT(vsql,'create table temp_user_rm_map ');

	vsql := ' 	delete from rcs.user_rm_map ';
	CREATEOBJECT(vsql,'delete from rcs.user_rm_map ');

	vsql := ' 	insert into rcs.user_rm_map (userid, rm_id)
	select userid, rm_id from rcs.temp_user_rm_map ';

	CREATEOBJECT(vsql,'insert into rcs.user_rm_map ');

	vsql := ' drop table rcs.temp_user_rm_map ';
  	CREATEOBJECT(vsql,'drop table rcs.temp_user_rm_map ', 'Y');


	-- Dropping the netpune's User and Roles related tables from rcs schema

		if is_table_exists(vschema, 'cms_rolepermissions') = true then
		    vsql := ' drop table '||vschema||'.cms_rolepermissions cascade constraints';
		    CREATEOBJECT(vsql,' drop table '||vschema||'.cms_rolepermissions cascade constraints', 'Y');
		end  if;

		if is_table_exists(vschema, 'cms_permission') = true then
		  vsql := ' drop table '||vschema||'.cms_permission cascade constraints';
		  CREATEOBJECT(vsql,' drop table '||vschema||'.cms_permission cascade constraints', 'Y');
		end if;

		if is_table_exists(vschema, 'cms_module') = true then
		  vsql := ' drop table '||vschema||'.cms_module cascade constraints';
		  CREATEOBJECT(vsql,' drop table '||vschema||'.cms_module cascade constraints', 'Y');
		end if;

		if is_table_exists(vschema, 'cms_userroles') = true then
		  vsql := ' drop table '||vschema||'.cms_userroles cascade constraints';
		  CREATEOBJECT(vsql,' drop table '||vschema||'.cms_userroles cascade constraints', 'Y');
		end if;

		if is_table_exists(vschema, 'cms_role') = true then
		  vsql := ' drop table '||vschema||'.cms_role cascade constraints';
		  CREATEOBJECT(vsql,' drop table '||vschema||'.cms_role cascade constraints', 'Y');
		end if;

		if is_table_exists(vschema, 'cms_user') = true then
		  vsql := ' drop table '||vschema||'.cms_user cascade constraints';
		  CREATEOBJECT(vsql,' drop table '||vschema||'.cms_user cascade constraints', 'Y');
		end if;

		if IS_SEQUENCE_EXISTS(vschema, 'cms_user_seq') = true then
		  vsql := ' drop sequence '||vschema||'.cms_user_seq ';
		  CREATEOBJECT(vsql,' drop sequence '||vschema||'.cms_user_seq ', 'Y');
		end if;

		if IS_SEQUENCE_EXISTS(vschema, 'cms_role_seq') = true then
		  vsql := ' drop sequence '||vschema||'.cms_role_seq ';
		  CREATEOBJECT(vsql,' drop sequence '||vschema||'.cms_role_seq ', 'Y');
		end if;


		if IS_SEQUENCE_EXISTS(vschema, 'cms_module_seq') = true then
		  vsql := ' drop sequence '||vschema||'.cms_module_seq ';
		  CREATEOBJECT(vsql,' drop sequence '||vschema||'.cms_module_seq ', 'Y');
		end if;

		if IS_SEQUENCE_EXISTS(vschema, 'cms_permission_seq') = true then
		  vsql := ' drop sequence '||vschema||'.cms_permission_seq ';
		  CREATEOBJECT(vsql,' drop sequence '||vschema||'.cms_permission_seq ', 'Y');
		end if;
		
		if is_index_exists (vschema, 'IDX_REFERENCE_ID') = false then
			 vsql := 'CREATE INDEX '||vschema||'.IDX_REFERENCE_ID ON '||vschema||'.ALARM_ACTIVITYLOG(REFERENCE_ID)';
	    	CREATEOBJECT(vsql,'create INDEX IDX_REFERENCE_ID');
    	end if;
    	
    	if is_index_exists (vschema, 'rec_tuf_rec_id_idx') = false then
    		vsql := 'create index '||vschema||'.rec_tuf_rec_id_idx on '||vschema||'.rec_trial_use_fields(recording_id)';
			CREATEOBJECT(vsql,vsql);
		end if;


	 end if;
	 
	 if VTSTVDBVER < '5.0.000.8' THEN
		 if is_table_exists(vschema, 'temp_recordings_for_rules') = false then
		 	vsql := ' create table '||vschema||'.temp_recordings_for_rules(recording_id number(19))';
		 	CREATEOBJECT(vsql,vsql);
		 end if;
		 if is_index_exists (vschema, 'temp_recordings_for_rules_idx') = false then
		  	vsql := ' CREATE INDEX '||vschema||'.temp_recordings_for_rules_idx ON '||vschema||'.temp_recordings_for_rules (RECORDING_ID)';
		 	CREATEOBJECT(vsql,vsql);
		 end if;
	end if;


	if VTSTVDBVER < '6.0.000.0' THEN
		--Dont trackthis any more...
	  	vsql := ' delete from  '||vschema||'.config_setting where key=''tstvversion'''; 
	 	CREATEOBJECT(vsql,vsql);
	    -- HA changes on RCS
	     vsql := 'alter table '||vschema||'.RM ADD PARENT_RM_ID NUMBER(19,0) DEFAULT NULL ';
        CREATEOBJECT(vsql,'alter TABLE rm');
         vsql := 'alter table '||vschema||'.RM ADD CONSTRAINT FK_PA_RM FOREIGN KEY (PARENT_RM_ID) REFERENCES '||vschema||'.RM(RM_ID) ';
    	CREATEOBJECT(vsql,'alter TABLE rm');
    	vsql:= 'alter table '||vschema||'.TEMP_SS_REC ADD (RM_ID NUMBER(19,0) NOT NULL)';
    	CREATEOBJECT(vsql,'alter TABLE TEMP_SS_REC');
        vsql := 'CREATE TABLE '||vschema||'.HA_RM_REC_STATUS
	  	(
		 RECORDING_ID NUMBER(19,0) NOT NULL ,
		 RM_ID        NUMBER(19,0) NOT NULL,
		 STATUS       NUMBER(2,0) DEFAULT 3 NOT NULL ENABLE,
		 STATUS_CODE  NUMBER(10,0) NOT NULL,
		 CONTENT_URL NVARCHAR2(1024),
		 WARNING NUMBER(1,0) DEFAULT 0,
		 CONSTRAINT PK_TEMP_HA_RM_REC PRIMARY KEY (RECORDING_ID,RM_ID)
		)';
		CREATEOBJECT(vsql,'create TABLE HA_RM_REC_STATUS');
         vsql := 'drop table '||vschema||'.exp_schedule';
         CREATEOBJECT(vsql,'Drop table exp_schedule','Y');
         vsql := 'drop table '||vschema||'.exp_generic';
         CREATEOBJECT(vsql,'Drop table exp_generic','Y');
         vsql := 'drop table '||vschema||'.export_gateway';
         CREATEOBJECT(vsql,'Drop table export_gateway','Y'); 
         vsql := 'drop package '||vschema||'.processXMLTV';
         CREATEOBJECT(vsql,'Drop package processXMLTV','Y');
         vsql := 'drop trigger '||vschema||'.RECORDING_QUEUETRG';
         CREATEOBJECT(vsql,'Drop trigger Recording_queueTrg', 'y');
         vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.RECORDING_QUEUETRG BEFORE INSERT ON '||vschema||'.RECORDING_QUEUE FOR EACH ROW
            DECLARE
              vseq number;
            BEGIN
              if (:new.RECORDING_QUEUE_ID is null) then
                select '||vschema||'.RECORDING_QUEUE_SEQ.nextval into vseq from dual;
                :new.RECORDING_QUEUE_ID := vseq;
                  insert into temp_rec_queue_list values (:new.RECORDING_QUEUE_ID);
              end if;
            END;';
         CREATEOBJECT(vsql,'Create Trigger RECORDING_QUEUETRG', 'Y');          
        
         vsql := 'CREATE TABLE '||vschema||'.TEMP_REC_QUEUE_LIST
         (
             RECORDING_QUEUE_ID NUMBER
         )';
         CREATEOBJECT(vsql,'create table TEMP_REC_QUEUE_LIST');
	     -- create FTP folder /public/rcs
            if not DBMS_XDB.existsresource('/public/rcs') then
    	        success := DBMS_XDB.createfolder('/public/rcs');
            end if;
			if is_column_exists(vschema, 'RM_LINEUP', 'MEDIATYPE') = false then
				vsql := 'alter table '||vschema||'.RM_LINEUP add MEDIATYPE NVARCHAR2(200)';
				CREATEOBJECT(vsql,'alter TABLE rm_lineup add mediatype');
			end if;
			if is_column_exists(vschema, 'RM_LINEUP', 'PUBLISHPOINT') = false then
				vsql := 'alter table '||vschema||'.RM_LINEUP add PUBLISHPOINT NVARCHAR2(200)';
				CREATEOBJECT(vsql,'alter TABLE rm_lineup add publishpoint');
			end if;
			if is_column_exists(vschema, 'RM_LINEUP', 'MANIFESTNAME' ) = false then
				vsql := 'alter table '||vschema||'.RM_LINEUP add MANIFESTNAME NVARCHAR2(200)';
				CREATEOBJECT(vsql,'alter TABLE rm_lineup add manifestname');
			end if;
        end if; -- upgrade ended

	--Version information will be updated by installer.
    	vsql := ' update '||vschema||'.config_setting set VALUE = ''&RCS_DB_VERSION'', UPDATE_DATE = current_timestamp where KEY = ''version''';
		CREATEOBJECT(vsql,' Updating the RCS Web version ');

	 vsql := 'INSERT INTO install_Table values(sysdate,''Upgrade to RCS Schema Version &RCS_DB_VERSION completed SUCCESSFULLY.'')';
      CREATEOBJECT(vsql,'insert into install_table');
    --Version information will be updated by installer.

    commit;

  END convertTSTV;

  procedure installtstv AS
    vcounttab number := 0;
  begin
	  SELECT COUNT(1)
    INTO 	vcounttab
		FROM 	dba_tables
		WHERE	OWNER = upper(vschema);

      IF vcounttab = 0 THEN
        	BEGIN
	        	  CONFIGXMLDB();
              createtstv();
       	-- EXCEPTION
          --WHEN OTHERS THEN
            --	rollback;
             -- raise;
	        END;
      ELSE
	        BEGIN
            convertTSTV();
       	-- EXCEPTION
          --WHEN OTHERS THEN
            --	rollback;
             -- raise;
	        END;
      END IF;

  end installtstv;

  procedure killhangingresourcelocksession is

	  cursor hanging_sessions is select sid, serial# from v$session where upper(username)='RCS'
	      and exists (select 1 from v$locked_object vo where session_id = sid
	                    and exists(select 1 from dba_objects do where upper(do.owner)='RCS' and upper(do.object_name) = 'CONFIG_SETTING' and do.object_id = vo.object_id)
	                 );
	  begin
	      for sessions in hanging_sessions
	        loop
	          execute immediate 'alter system kill session '''||sessions.sid||','||sessions.serial#||'''';
	        end loop;

 end killhangingresourcelocksession;

END TSTVDB;
/

begin
 tstvdb.installtstv();
 
  -- granting execute privileges on tstvdb to RCS to run the killhangingresourcelocksession stored procedure
 execute immediate 'grant execute on tstvdb to RCS';
  
end;
/

exit

