--set echo on
set serveroutput on

create or replace
PACKAGE TSTVRCSDBArchive AS
  procedure setuprcsarchivedb;
  procedure RUNARCHIVEONRCSDB;
  vschema varchar2(5) := 'RCS';
  v_rcsarchive_schema varchar2(10) := 'RCSARCHIVE';
  v_partition_years number(2) := 3;
  vsql varchar2(32767);
  vsqlclob clob;
  TIMEZONE VARCHAR2(100);
  
END TSTVRCSDBArchive;
/
create or replace
PACKAGE BODY TSTVRCSDBArchive AS

	 FUNCTION IS_TABLE_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2) RETURN boolean is

	counter number(5) := 0;
	begin
	  select count(1) into counter from dba_tables where owner=UPPER(IN_OWNER) AND TABLE_NAME=UPPER(IN_TABLE_NAME);
	  if counter > 0  then
	    return true;
	  else
	  return false;
	  end if;
	end;


	 FUNCTION IS_COLUMN_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2) RETURN boolean is

	counter number(5) := 0;
	begin
	  select count(1) into counter from DBA_TAB_COLS where owner=UPPER(IN_OWNER) AND TABLE_NAME=UPPER(IN_TABLE_NAME) AND COLUMN_NAME=UPPER(IN_COLUMN_NAME);
	  if counter > 0  then
	    return true;
	  else
	  return false;
	  end if;
	end;

	FUNCTION IS_INDEX_EXISTS (IN_OWNER VARCHAR2, IN_INDEX_NAME VARCHAR2) RETURN boolean is

	counter number(5) := 0;
	begin
	  select count(1) into counter from DBA_INDEXES where owner=UPPER(IN_OWNER)  AND INDEX_NAME=UPPER(IN_INDEX_NAME);
	  if counter > 0  then
	    return true;
	  else
	  return false;
	  end if;
	end;

	FUNCTION IS_COLUMN_VALUE_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2, IN_COLUMN_VALUE varchar2, IN_DATA_TYPE VARCHAR2 DEFAULT 'VARCHAR2') RETURN boolean is

	counter number(5) := 0;
	vsql varchar2(1000);
	begin
	  IF upper(IN_DATA_TYPE) = 'NUMBER' THEN
	  vsql := 'select count(1) from '||IN_OWNER||'.'||IN_TABLE_NAME||' WHERE '||IN_COLUMN_NAME||'='||IN_COLUMN_VALUE;
	  ELSIF (upper(IN_DATA_TYPE) = 'VARCHAR' OR upper(IN_DATA_TYPE) = 'VARCHAR2') THEN
	  vsql := 'select count(1) from '||IN_OWNER||'.'||IN_TABLE_NAME||' WHERE upper('||IN_COLUMN_NAME||')=upper('''||IN_COLUMN_VALUE||''')';
	  END IF;
	  EXECUTE IMMEDIATE vsql INTO counter;

	  if counter > 0  then
	    return true;
	  else
	  return false;
	  end if;
	end;

	FUNCTION IS_CONSTRAINT_EXISTS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_CONSTRAINT_NAME VARCHAR2) RETURN boolean is

	counter number(5) := 0;
	begin
	  select count(1) into counter from  dba_constraints where owner =UPPER(IN_OWNER) and table_name=UPPER(IN_TABLE_NAME) AND CONSTRAINT_NAME=UPPER(IN_CONSTRAINT_NAME);
	  if counter > 0  then
	    return true;
	  else
	  return false;
	  end if;
	end;

	FUNCTION GET_COLUMN_DATA_TYPE (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2) RETURN VARCHAR2 is

	v_data_type varchar2(200) ;
	begin
	  SELECT DATA_TYPE INTO v_data_type FROM DBA_TAB_COLS WHERE OWNER=UPPER(IN_OWNER) AND TABLE_NAME = UPPER(IN_TABLE_NAME) AND COLUMN_NAME=UPPER(IN_COLUMN_NAME);
	  return v_data_type;
	end;

	FUNCTION IS_COLUMN_ALLOW_NULLS (IN_OWNER VARCHAR2, IN_TABLE_NAME VARCHAR2, IN_COLUMN_NAME VARCHAR2) RETURN boolean is

	v_nullable varchar2(200) ;
	begin
	  SELECT NULLABLE INTO v_nullable FROM DBA_TAB_COLS WHERE OWNER=UPPER(IN_OWNER) AND TABLE_NAME = UPPER(IN_TABLE_NAME) AND COLUMN_NAME=UPPER(IN_COLUMN_NAME);
	  IF v_nullable = 'Y' then
	    return true;
	  else
	    return false;
	 end if;
	end;

	 FUNCTION IS_SEQUENCE_EXISTS (IN_SEQUENCE_OWNER VARCHAR2, IN_SEQUENCE_NAME VARCHAR2) RETURN boolean is

	counter number(5) := 0;
	begin
	  select count(1) into counter from dba_sequences where sequence_owner=upper(IN_SEQUENCE_OWNER) AND sequence_name=upper(IN_SEQUENCE_NAME);
	  if counter > 0  then
	    return true;
	  else
	  return false;
	  end if;
	end;

	FUNCTION IS_VIEW_EXISTS (IN_OWNER VARCHAR2, IN_VIEW_NAME VARCHAR2) RETURN boolean is

	counter number(5) := 0;
	begin
	  select count(1) into counter from dba_views where owner=upper(IN_OWNER) AND VIEW_NAME=upper(IN_VIEW_NAME);
	  if counter > 0  then
	    return true;
	  else
	  return false;
	  end if;
	end;

	   /* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in install_table*/
	  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
	    verrmsg varchar2(32000);
	  BEGIN
	    execute immediate vsql;
	  exception
	    when others then
	          verrmsg := errmsg ||' '||sqlerrm;
	          select cast(verrmsg as varchar2(4000))
	          into verrmsg
	          from dual;
	      if upper(mask) != 'Y' then
	          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
	          commit;
	          raise;
	      end if;
	  END CREATEOBJECT;

	  PROCEDURE CREATEOBJECT(vsql clob, errmsg varchar2, mask varchar2 default 'N') IS
	    verrmsg varchar2(32000);
	  BEGIN
	    execute immediate vsql;
	  exception
	    when others then
	          verrmsg := errmsg ||' '||sqlerrm;
	          select cast(verrmsg as varchar2(4000))
	          into verrmsg
	          from dual;
	      if upper(mask) != 'Y' then
	          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
	          commit;
	          raise;
	      end if;
	  END CREATEOBJECT;

   PROCEDURE CREATEUPDATETRG(vtabname varchar2) IS
    vcount number := 0;
    vsql varchar2(32000);
  BEGIN
    select count(*)
    into vcount
    from dba_tables dt, dba_tab_columns dtc
    where dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dt.owner = dtc.owner
    and dt.owner = vschema
    and dtc.column_name = 'UPDATE_DATE';

	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||vtabname||'UPD BEFORE UPDATE ON '||vschema||'.'||vtabname||' FOR EACH ROW
            DECLARE
              vcurrent_timestamp timestamp with time zone;
            BEGIN
				if (:new.update_date is null) then
	                select current_timestamp into vcurrent_timestamp from dual;
	                :new.update_date := vcurrent_timestamp;
				end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

    select count(*)
    into vcount
    from dba_tables dt, dba_tab_columns dtc
    where dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dt.owner = dtc.owner
    and dt.owner = vschema
    and dtc.column_name = 'CREATE_DATE';

	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER '||vschema||'.'||vtabname||'CRT BEFORE INSERT ON '||vschema||'.'||vtabname||' FOR EACH ROW
            DECLARE
              vcurrent_timestamp timestamp with time zone;
            BEGIN
              if (:new.create_date is null or :new.update_date is null) then
                select current_timestamp into vcurrent_timestamp from dual;
                :new.create_date := vcurrent_timestamp;
                :new.update_date := vcurrent_timestamp;
              end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

   END CREATEUPDATETRG;

  function get_table_ddl(table_name varchar2, schema_name varchar2, partition_clause varchar2 default 'N') return clob is

  vlength number(7) :=0;
  begin
      select dbms_metadata.get_ddl('TABLE', table_name, schema_name) into vsqlclob from dual;
      if ( partition_clause = 'N') then
        select regexp_instr(vsqlclob, '* PARTITION', 1, 1,0, 'i') into vlength from dual;
          if vlength > 0 then
            select substr(vsqlclob, 0, regexp_instr(vsqlclob, '* PARTITION', 1, 1,0, 'i')  ) into vsqlclob  from dual;
         end if;
      end if;
    return vsqlclob;
  end get_table_ddl;


procedure alterForeignKeys (vtable_name varchar2, vschema varchar2, operation varchar2 ) IS


BEGIN

          for tab_constraints in (
              select table_name, constraint_name from dba_constraints where owner = upper(vschema) and
                                    table_name =upper(vtable_name)
                                    and constraint_type in ('R')
                minus
               select c1.table_name, c1.constraint_name from dba_constraints c1 join dba_constraints c2 on (c1.r_constraint_name = c2.constraint_name)
                where  c2.table_name in ('RECORDING', 'SCHEDULE')  and c1.constraint_type in ('R') and c1.table_name =upper(vtable_name) and c1.owner = upper(vschema) and c2.owner = upper(vschema)
              )
              loop
                vsql :=' alter table '||vschema||'.'||tab_constraints.table_name||' '||operation||'  constraint '||tab_constraints.constraint_name;

                  begin
                    execute immediate vsql;

                    exception
                      when others then
                        NULL;
                  end;

              end loop;

end ALTERFOREIGNKEYS;

procedure RESETHIGHWATERMARK IS

BEGIN


       VSQL := ' drop index  '||VSCHEMA||'.IDX_SCHED_UNIQ_IND ';
        CREATEOBJECT(VSQL, VSQL, 'Y');
       VSQL := ' drop index  '||VSCHEMA||'.IDX_SCHED_START_END_TIME ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      VSQL := ' ALTER TABLE '||VSCHEMA||'.SCHEDULE ENABLE ROW MOVEMENT ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.SCHEDULE shrink space  cascade ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.SCHEDULE shrink space  compact ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      VSQL := ' ALTER TABLE '||VSCHEMA||'.SCHEDULE SHRINK SPACE ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

    VSQL := 'CREATE UNIQUE INDEX '||VSCHEMA||'.IDX_SCHED_UNIQ_IND ON '||VSCHEMA||'.SCHEDULE (PROGRAM_ID,STATION_ID,START_TIME)';
    CREATEOBJECT(vsql,'create index IDX_SCHED_UNIQ_IND', 'Y');

    VSQL := 'CREATE INDEX '||VSCHEMA||'.IDX_SCHED_START_END_TIME ON '||VSCHEMA||'.SCHEDULE (START_TIME,END_TIME)';
    CREATEOBJECT(vsql,'create index IDX_SCHED_START_END_TIME' , 'Y');

    VSQL := 'CREATE INDEX '||VSCHEMA||'.IDX_SCH_STATION_ID ON '||VSCHEMA||'.SCHEDULE(STATION_ID)';
    CREATEOBJECT(VSQL,'create index IDX_SCH_STATION_ID', 'Y');



      VSQL := ' ALTER TABLE '||VSCHEMA||'.REC_TRIAL_USE_FIELDS ENABLE ROW MOVEMENT ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.REC_TRIAL_USE_FIELDS shrink space  cascade ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.REC_TRIAL_USE_FIELDS shrink space  compact ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      VSQL := ' ALTER TABLE '||VSCHEMA||'.REC_TRIAL_USE_FIELDS SHRINK SPACE ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_REC_RULES_MAP ENABLE ROW MOVEMENT ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_REC_RULES_MAP shrink space  cascade ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_REC_RULES_MAP shrink space  compact ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_REC_RULES_MAP SHRINK SPACE ';
      CREATEOBJECT(VSQL, VSQL, 'Y');




      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_LOG ENABLE ROW MOVEMENT ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_LOG shrink space  cascade ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_LOG shrink space  compact ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING_LOG SHRINK SPACE ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      -- recording_rtc_pool_map
         if is_table_exists(vschema, 'recording_rtc_pool_map') = true then

          VSQL := ' ALTER TABLE '||VSCHEMA||'.recording_rtc_pool_map ENABLE ROW MOVEMENT ';
          CREATEOBJECT(VSQL, VSQL, 'Y');


          VSQL := ' ALTER TABLE '||VSCHEMA||'.recording_rtc_pool_map shrink space  cascade ';
          CREATEOBJECT(VSQL, VSQL, 'Y');


          VSQL := ' ALTER TABLE '||VSCHEMA||'.recording_rtc_pool_map shrink space  compact ';
          CREATEOBJECT(VSQL, VSQL, 'Y');

          VSQL := ' ALTER TABLE '||VSCHEMA||'.recording_rtc_pool_map SHRINK SPACE ';
          CREATEOBJECT(VSQL, VSQL, 'Y');

        END IF;


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING ENABLE ROW MOVEMENT ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING shrink space  cascade ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING shrink space  compact ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDING SHRINK SPACE ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDABLE_RIGHTS_MAP ENABLE ROW MOVEMENT ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDABLE_RIGHTS_MAP shrink space  cascade ';
      CREATEOBJECT(VSQL, VSQL, 'Y');


      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDABLE_RIGHTS_MAP shrink space  compact ';
      CREATEOBJECT(VSQL, VSQL, 'Y');

      VSQL := ' ALTER TABLE '||VSCHEMA||'.RECORDABLE_RIGHTS_MAP SHRINK SPACE ';
      CREATEOBJECT(VSQL, VSQL, 'Y');




        VSQL := ' ALTER TABLE '||VSCHEMA||'.ALARM_ACTIVITYLOG ENABLE ROW MOVEMENT ';
        CREATEOBJECT(VSQL, VSQL, 'Y');


        VSQL := ' ALTER TABLE '||VSCHEMA||'.ALARM_ACTIVITYLOG shrink space  cascade ';
        CREATEOBJECT(VSQL, VSQL, 'Y');


        VSQL := ' ALTER TABLE '||VSCHEMA||'.ALARM_ACTIVITYLOG shrink space  compact ';
        CREATEOBJECT(VSQL, VSQL, 'Y');

        VSQL := ' ALTER TABLE '||VSCHEMA||'.ALARM_ACTIVITY_LOG SHRINK SPACE ';
        CREATEOBJECT(VSQL, VSQL, 'Y');


end  RESETHIGHWATERMARK;




   procedure upgradercsdbtosupportarchive is

    V_ISPARTITIONSUPPORTED VARCHAR2(50) :='FALSE';

    vrcsdbver varchar2(50);
    volder_version varchar2(20);
    vcount number;
    begin
	    execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
      vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''Upgrading RCS DB to support archiving is started'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
      CREATEOBJECT(VSQL,'insert into ALARM_ACTIVITYLOG', 'Y');
      commit;
      
 	  /**
	  Disabling the Partitioning based DB Archive Feature since Non-Partitioning strategy works fine with larger amounts of
	  databases. Partitioning based DB Archive feature requires future maintenance work.
	  */
    --  select value into v_ispartitionsupported from  v$option where upper(parameter)=upper('Partitioning');
    
      execute immediate 'Select value from '||vschema||'.config_setting where key=''version''' into vrcsdbver;
     if (v_isPartitionSupported = 'TRUE' and vrcsdbver >= '3.3.000.0' ) THEN
     -- Remove all the constraints from the required  tables
          declare
              TYPE VSQLTAB IS TABLE OF VARCHAR2(4000);
              vsql vsqltab;
            BEGIN
              SELECT SQLCMD
              BULK COLLECT INTO VSQL
              FROM
              (SELECT 'drop trigger '||VSCHEMA||'.'||TRIGGER_NAME AS SQLCMD FROM DBA_TRIGGERS
              WHERE OWNER = vschema and TABLE_NAME IN ('SCHEDULE','RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP', 'ALARM_ACTIVITYLOG')
              UNION
              SELECT STMT.SQLCMD FROM
              (select
              'alter table '||vschema||'.'||TABLE_NAME||' rename constraint '||CONSTRAINT_NAME||' to '||CONSTRAINT_NAME||'8' as sqlcmd
              FROM DBA_CONSTRAINTS
              WHERE OWNER=VSCHEMA AND TABLE_NAME IN ('SCHEDULE','RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP', 'ALARM_ACTIVITYLOG')
              AND CONSTRAINT_TYPE IN ('R','P','U')-- and ( R_CONSTRAINT_NAME is null or R_CONSTRAINT_NAME not IN ( 'PK_SCHEDULE', 'PK_RECORDING'))
              order by constraint_type desc) stmt
              union
                     SELECT STMT1.SQLCMD FROM
              (select
              'alter table '||vschema||'.'||TABLE_NAME||' drop constraint '||CONSTRAINT_NAME||' cascade' as sqlcmd
              from dba_constraints
              WHERE OWNER=VSCHEMA AND TABLE_NAME IN ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP', 'ALARM_ACTIVITYLOG')
              and constraint_type in ('R')-- and ( R_CONSTRAINT_NAME is null or R_CONSTRAINT_NAME not IN ( 'PK_SCHEDULE', 'PK_RECORDING'))
              order by constraint_type desc) STMT1
              union
              SELECT 'alter index '||VSCHEMA||'.'||INDEX_NAME||' rename to '||INDEX_NAME||'8' AS SQLCMD FROM DBA_INDEXES
              WHERE owner=vschema and TABLE_NAME IN ('SCHEDULE','RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP', 'ALARM_ACTIVITYLOG')
              ) ;

              IF VSQL.COUNT > 0 THEN
                FOR I IN 1..VSQL.LAST LOOP
                  BEGIN
                    EXECUTE IMMEDIATE VSQL(I);
                  EXCEPTION
                    WHEN OTHERS THEN
                      NULL;
                  END;
                end loop;
              END IF;

            END;

--          for tab_constraints in (  SELECT TABLE_NAME, CONSTRAINT_NAME FROM USER_CONSTRAINTS WHERE
--                                    TABLE_NAME IN ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP', 'ALARM_ACTIVITYLOG')
--                                    AND CONSTRAINT_TYPE IN ('R','P','U') AND  R_CONSTRAINT_NAME  IN ( 'PK_SCHEDULE', 'PK_RECORDING'))
--              LOOP
--                vsql :=' alter table '||VSCHEMA||'.'||TAB_CONSTRAINTS.TABLE_NAME||' rename constraint '||TAB_CONSTRAINTS.CONSTRAINT_NAME||' to '||TAB_CONSTRAINTS.CONSTRAINT_NAME||'9';
--                EXECUTE IMMEDIATE vsql;
--              end loop;

    -- rename the tables

     vsql :='ALTER TABLE '||vschema||'.schedule RENAME TO schedule_old';
     CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.schedule RENAME TO schedule_old');

     vsql :='ALTER TABLE '||vschema||'.recordable_rights_map RENAME TO recordable_rights_map_old';
     CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.recordable_rights_map RENAME TO recordable_rights_map_old');

     vsql :='ALTER TABLE '||vschema||'.recording RENAME TO recording_old';
     CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.recording RENAME TO recording_old');

    if is_table_exists(vschema, 'recording_rtc_pool_map') = true then
      vsql :='ALTER TABLE '||vschema||'.recording_rtc_pool_map RENAME TO recording_rtc_pool_map_old';
     CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.recording_rtc_pool_map RENAME TO recording_rtc_pool_map_old');
    end if;

    vsql :='ALTER TABLE '||vschema||'.RECORDING_LOG RENAME TO RECORDING_LOG_old';
    CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.RECORDING_LOG RENAME TO RECORDING_LOG_old');

    vsql :='ALTER TABLE '||vschema||'.rec_trial_use_fields RENAME TO rec_trial_use_fields_old';
    CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.rec_trial_use_fields RENAME TO rec_trial_use_fields_old');

    vsql :='ALTER TABLE '||vschema||'.RECORDING_REC_RULES_MAP RENAME TO RECORDING_REC_RULES_MAP_old';
    CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.RECORDING_REC_RULES_MAP RENAME TO RECORDING_REC_RULES_MAP_old');

    vsql :='ALTER TABLE '||vschema||'.ALARM_ACTIVITYLOG RENAME TO ALARM_ACTIVITYLOG_old';
    CREATEOBJECT(VSQL,'ALTER TABLE '||vschema||'.ALARM_ACTIVITYLOG RENAME TO ALARM_ACTIVITYLOG_old');


    -- create a new tables with partition
          vsqlclob := get_table_ddl('SCHEDULE', 'RCSARCHIVE');
         select replace (replace(vsqlclob, '"RCSARCHIVE"."SCHEDULE"', '"RCS"."SCHEDULE"' ), 'TSTV_RCS_ARCHIVE', 'TSTV_RCS') into vsqlclob from dual;

            vsqlclob := vsqlclob || '   partition by range (start_time_vir)
                                subpartition by list (recordable)
                                  (
                                      partition before_max_value values less than (maxvalue)
                                        ( subpartition before_max_value_all  values (0, 1)
                                        )
                                  ) enable row movement ';


          CREATEOBJECT(vsqlclob,'Creating  a partitioned SCHEDULE table from RCSARCHIVE to RCS');

            -- RECORDING TABLE
--           select dbms_metadata.get_ddl('TABLE', 'RECORDING', 'RCSARCHIVE') into vsqlclob from dual;
--           select substr(vsqlclob, 0, regexp_instr(vsqlclob, '* PARTITION', 1, 1,0, 'i')  ) into vsqlclob  from dual;
            vsqlclob := get_table_ddl('RECORDING', 'RCSARCHIVE');
           select replace (replace (replace(vsqlclob, '"RCSARCHIVE"."RECORDING"','"RCS"."RECORDING"' ),'TSTV_RCS_ARCHIVE', 'TSTV_RCS'), '"RCSARCHIVE"."SCHEDULE"','"RCS"."SCHEDULE"')  into vsqlclob from dual;
          vsqlclob := vsqlclob || ' PARTITION BY REFERENCE (FK_RECORDING_SCHEDULE) ENABLE ROW MOVEMENT ';
          createobject(vsqlclob,'Creating RECORDING table from RCSARCHIVE to RCS');

         -- RECORDABLE_RIGHTS_MAP
--          select dbms_metadata.get_ddl('TABLE', 'RECORDABLE_RIGHTS_MAP', 'RCSARCHIVE') into vsqlclob from dual;
--           select substr(vsqlclob, 0, regexp_instr(vsqlclob, '* PARTITION', 1, 1,0, 'i')  ) into vsqlclob  from dual;
          vsqlclob := get_table_ddl('RECORDABLE_RIGHTS_MAP', 'RCSARCHIVE');
         select replace(replace (replace (replace(vsqlclob, '"RCSARCHIVE"."RECORDABLE_RIGHTS_MAP"','"RCS"."RECORDABLE_RIGHTS_MAP"' ), 'TSTV_RCS_ARCHIVE','TSTV_RCS'),'"RCSARCHIVE"."SCHEDULE"', '"RCS"."SCHEDULE"'), '"RCSARCHIVE"."RIGHT_RM_MAP"','"RCS"."RIGHT_RM_MAP"')   into vsqlclob from dual;
         vsqlclob := vsqlclob || ' PARTITION BY REFERENCE (FK_REC_RIGHTS_MAP_SCH) ENABLE ROW MOVEMENT ';

          createobject(vsqlclob,'Creating RECORDABLE_RIGHTS_MAP table from RCSARCHIVE to RCS');

          -- RECORDING_LOG
            vsqlclob := get_table_ddl('RECORDING_LOG', 'RCSARCHIVE');
            select replace (replace (replace(vsqlclob,'"RCSARCHIVE"."RECORDING_LOG"', '"RCS"."RECORDING_LOG"' ), 'TSTV_RCS_ARCHIVE','TSTV_RCS'),'"RCSARCHIVE"."RECORDING"', '"RCS"."RECORDING"')  into vsqlclob from dual;

            vsqlclob := vsqlclob || ' PARTITION BY REFERENCE (FK_REC_LOG_RECORDING) ENABLE ROW MOVEMENT ';

            CREATEOBJECT(vsqlclob,'Creating RECORDING_LOG table from RCSARCHIVE to RCS');


        -- Add the foreign key constraint on to RCS Schema


        -- REC_TRIAL_USE_FIELDS
        vsqlclob := get_table_ddl('REC_TRIAL_USE_FIELDS', 'RCSARCHIVE');
        select replace (replace (replace(vsqlclob,'"RCSARCHIVE"."REC_TRIAL_USE_FIELDS"', '"RCS"."REC_TRIAL_USE_FIELDS"' ), 'TSTV_RCS_ARCHIVE','TSTV_RCS'),'"RCSARCHIVE"."RECORDING"', '"RCS"."RECORDING"')  into vsqlclob from dual;
         vsqlclob := vsqlclob || ' PARTITION BY REFERENCE (REC_TRIAL_USE_RECORDING_FK) ENABLE ROW MOVEMENT ';
        CREATEOBJECT(vsqlclob,'Creating REC_TRIAL_USE_FIELDS table from RCSARCHIVE to RCS');


        -- RECORDING_REC_RULES_MAP
        vsqlclob := get_table_ddl('RECORDING_REC_RULES_MAP', 'RCSARCHIVE');
        select replace (replace (replace(vsqlclob,'"RCSARCHIVE"."RECORDING_REC_RULES_MAP"', '"RCS"."RECORDING_REC_RULES_MAP"' ), 'TSTV_RCS_ARCHIVE','TSTV_RCS'),'"RCSARCHIVE"."RECORDING"', '"RCS"."RECORDING"')  into vsqlclob from dual;
         vsqlclob := vsqlclob || ' PARTITION BY REFERENCE (FK_REC_REC_RULES_MAP) ENABLE ROW MOVEMENT ';
        CREATEOBJECT(vsqlclob,'Creating RECORDING_REC_RULES_MAP table from RCSARCHIVE to RCS');

          -- ALARM_ACTIVITYLOG
          vsqlclob := get_table_ddl('ALARM_ACTIVITYLOG', 'RCSARCHIVE');
          select replace(replace(vsqlclob, '"RCSARCHIVE"."ALARM_ACTIVITYLOG"', '"RCS"."ALARM_ACTIVITYLOG"' ), 'TSTV_RCS_ARCHIVE','TSTV_RCS') into vsqlclob from dual;

           vsqlclob := vsqlclob || '  partition by range (CREATE_DATE_VIR)
	               ( partition before_max_value values less than (maxvalue) ) enable row movement ';

           CREATEOBJECT(vsqlclob,'Creating  ALARM_ACTIVITYLOG table from RCSARCHIVE to RCS');



      -- Exchange the partition with the old table data
     vsql := ' alter table '||vschema||'.schedule exchange subpartition before_max_value_all with table '||vschema||'.schedule_old update indexes';
     CREATEOBJECT(VSQL,'alter table '||VSCHEMA||'.schedule exchange subpartition before_max_value_all with table '||VSCHEMA||'.schedule_old update indexes');


    -- recordable_rights_map
    VSQL := 'alter table '||VSCHEMA||'.RECORDABLE_RIGHTS_MAP_OLD add  CONSTRAINT "FK_REC_RIGHTS_MAP_SCH9" FOREIGN KEY ("SCHEDULE_ID") REFERENCES  '||VSCHEMA||'."SCHEDULE" ("SCHEDULE_ID") ';
    createobject(vsql,'alter table '||vschema||'.RECORDABLE_RIGHTS_MAP_OLD  CONSTRAINT "FK_REC_RIGHTS_MAP_SCH9" FOREIGN KEY ("SCHEDULE_ID") REFERENCES  '||vschema||'.SCHEDULE ("SCHEDULE_ID")' );


    -- exchange the partition with the old table data
     ALTERFOREIGNKEYS ('RECORDABLE_RIGHTS_MAP', 'RCS', 'DISABLE');
     vsql := ' alter table '||vschema||'.RECORDABLE_RIGHTS_MAP exchange PARTITION before_max_value_all with table '||vschema||'.RECORDABLE_RIGHTS_MAP_OLD update indexes';
     CREATEOBJECT(VSQL,' alter table '||VSCHEMA||'.RECORDABLE_RIGHTS_MAP exchange PARTITION before_max_value_all with table '||VSCHEMA||'.RECORDABLE_RIGHTS_MAP_OLD update indexes');
     ALTERFOREIGNKEYS ('RECORDABLE_RIGHTS_MAP', 'RCS', 'ENABLE');

    -- RECORDING


     vsql := 'alter table '||vschema||'.RECORDING_OLD add CONSTRAINT "FK_RECORDING_SCHEDULE9" FOREIGN KEY ("SCHEDULE_ID") REFERENCES '||vschema||'."SCHEDULE" ("SCHEDULE_ID")';
    CREATEOBJECT(VSQL,'alter table '||VSCHEMA||'.RECORDING_OLD add CONSTRAINT "FK_RECORDING_SCHEDULE9" FOREIGN KEY ("SCHEDULE_ID") REFERENCES '||VSCHEMA||'.SCHEDULE" ("SCHEDULE_ID")');

      ALTERFOREIGNKEYS ('RECORDING', 'RCS', 'DISABLE');
     -- exchange the partition with the old table data
     vsql := ' alter table '||vschema||'.RECORDING exchange PARTITION before_max_value_all with table '||vschema||'.RECORDING_OLD update indexes';
     CREATEOBJECT(VSQL,' alter table '||VSCHEMA||'.RECORDING exchange PARTITION before_max_value_all with table '||VSCHEMA||'.RECORDING_OLD update indexes');
     ALTERFOREIGNKEYS ('RECORDING', 'RCS', 'ENABLE');

      -- RECORDING_LOG
          vsql := 'alter table '||vschema||'.RECORDING_LOG_OLD add CONSTRAINT "FK_REC_LOG_RECORDING9" FOREIGN KEY ("RECORDING_ID") REFERENCES '||vschema||'."RECORDING" ("RECORDING_ID")';
         CREATEOBJECT(vsql,'alter table '||vschema||'.RECORDING_LOG_OLD add CONSTRAINT "FK_REC_LOG_RECORDING9" FOREIGN KEY ("RECORDING_ID") REFERENCES '||vschema||'."RECORDING" ("RECORDING_ID")' );

          ALTERFOREIGNKEYS ('RECORDING_LOG', 'RCS', 'DISABLE');
          -- exchange the partition with the old table data
         vsql := ' alter table '||vschema||'.RECORDING_LOG exchange PARTITION before_max_value_all with table '||vschema||'.RECORDING_LOG_OLD update indexes';
         CREATEOBJECT(VSQL,' alter table '||VSCHEMA||'.RECORDING_LOG exchange PARTITION before_max_value_all with table '||VSCHEMA||'.RECORDING_LOG_OLD update indexes');
          ALTERFOREIGNKEYS ('RECORDING_LOG', 'RCS', 'ENABLE');

    --REC_TRIAL_USE_FIELDS
     vsql := 'alter table '||vschema||'.REC_TRIAL_USE_FIELDS_OLD add CONSTRAINT "REC_TRIAL_USE_REC_FK9" FOREIGN KEY ("RECORDING_ID") REFERENCES '||vschema||'."RECORDING" ("RECORDING_ID")';
    CREATEOBJECT(vsql,'alter table '||vschema||'.REC_TRIAL_USE_FIELDS_OLD add CONSTRAINT "REC_TRIAL_USE_REC_FK9" FOREIGN KEY ("RECORDING_ID") REFERENCES '||vschema||'."RECORDING" ("RECORDING_ID")' );

    ALTERFOREIGNKEYS ('REC_TRIAL_USE_FIELDS', 'RCS', 'DISABLE');
       -- exchange the partition with the old table data
         vsql := ' alter table '||vschema||'.REC_TRIAL_USE_FIELDS exchange PARTITION before_max_value_all with table '||vschema||'.REC_TRIAL_USE_FIELDS_OLD update indexes';
         CREATEOBJECT(VSQL,' alter table '||VSCHEMA||'.REC_TRIAL_USE_FIELDS exchange PARTITION before_max_value_all with table '||VSCHEMA||'.REC_TRIAL_USE_FIELDS_OLD update indexes');
    ALTERFOREIGNKEYS ('REC_TRIAL_USE_FIELDS', 'RCS', 'ENABLE');

    --RECORDING_REC_RULES_MAP
     vsql := 'alter table '||vschema||'.RECORDING_REC_RULES_MAP_OLD add CONSTRAINT "FK_REC_REC_RULES_MAP9" FOREIGN KEY ("RECORDING_ID") REFERENCES '||vschema||'."RECORDING" ("RECORDING_ID")';
    CREATEOBJECT(vsql,'alter table '||vschema||'.RECORDING_REC_RULES_MAP_OLD add CONSTRAINT "FK_REC_REC_RULES_MAP9" FOREIGN KEY ("RECORDING_ID") REFERENCES '||vschema||'."RECORDING" ("RECORDING_ID")' );

    ALTERFOREIGNKEYS ('RECORDING_REC_RULES_MAP', 'RCS', 'DISABLE');
     -- exchange the partition with the old table data
       vsql := ' alter table '||vschema||'.RECORDING_REC_RULES_MAP exchange PARTITION before_max_value_all with table '||vschema||'.RECORDING_REC_RULES_MAP_OLD update indexes';
       CREATEOBJECT(VSQL,' alter table '||VSCHEMA||'.RECORDING_REC_RULES_MAP exchange PARTITION before_max_value_all with table '||VSCHEMA||'.RECORDING_REC_RULES_MAP_OLD update indexes');
  ALTERFOREIGNKEYS ('RECORDING_REC_RULES_MAP', 'RCS', 'ENABLE');
   --Alarm_activitylog

     -- exchange the partition with the old table data
        ALTERFOREIGNKEYS ('ALARM_ACTIVITYLOG', 'RCS', 'DISABLE');
       vsql := ' alter table '||vschema||'.Alarm_activitylog exchange PARTITION before_max_value with table '||vschema||'.Alarm_activitylog_OLD update indexes';
       CREATEOBJECT(VSQL,' alter table '||VSCHEMA||'.Alarm_activitylog exchange PARTITION before_max_value with table '||VSCHEMA||'.Alarm_activitylog_OLD update indexes');
      ALTERFOREIGNKEYS ('ALARM_ACTIVITYLOG', 'RCS', 'ENABLE');

      -- Looks like Oracle bug
  		   -- There is a problem with alter table '||vschema||'.ALARM_ACTIVITYLOG add ACKNOWLEDGED	NUMBER (1,0) DEFAULT 0 NOT NULL from 3.2 to 3.3 migration to support exchange partition
       -- The work around is  drop the column before creating the partitioning and readd the column  to the table in both rcs and RCSArchive schemas after exchange partition
        execute immediate 'SELECT count(1) from '||vschema||'.config_setting where key=''older_version'''  into vcount;
        if  vcount > 0 then
            execute immediate 'Select value from '||vschema||'.config_setting where key=''older_version''' into volder_version;
             if volder_version < '3.3.000.0' THEN
                vsql := 'alter table '||vschema||'.ALARM_ACTIVITYLOG add ACKNOWLEDGED	NUMBER (1,0) DEFAULT 0 NOT NULL ';
               CREATEOBJECT(VSQL,vsql);
               vsql := 'UPDATE '||vschema||'.ALARM_ACTIVITYLOG SET ACKNOWLEDGED = 1';
             CREATEOBJECT(VSQL,vsql);
              vsql := 'alter table '||vschema||'.ALARM_ACTIVITYLOG_OLD add ACKNOWLEDGED	NUMBER (1,0) DEFAULT 0 NOT NULL ';
              CREATEOBJECT(VSQL,vsql);
               vsql := 'UPDATE '||vschema||'.ALARM_ACTIVITYLOG SET ACKNOWLEDGED = 1';
              CREATEOBJECT(VSQL,vsql);
           vsql := 'alter table '||v_rcsarchive_schema||'.ALARM_ACTIVITYLOG add ACKNOWLEDGED	NUMBER (1,0) DEFAULT 0 NOT NULL ';
              CREATEOBJECT(VSQL,vsql);
               vsql := 'UPDATE '||v_rcsarchive_schema||'.ALARM_ACTIVITYLOG SET ACKNOWLEDGED = 1';
               CREATEOBJECT(VSQL,vsql);
           vsql := ' delete from '||vschema||'.config_setting where KEY = ''older_version''';
          CREATEOBJECT(vsql,' Deleting the RCS Web version ');
    
            end if;
    end if;
  -- PLAYBACK_WINDOW_RESTRICTIONS

    -- just rename the table, add constraints and inxexes
     vsql:='ALTER TABLE '||vschema||'.PLAYBACK_WINDOW_RESTRICTIONS ADD (CONSTRAINT FK_PLAYBACK_RESTR_RIGHT_01 FOREIGN KEY (RIGHT_ID) REFERENCES '||vschema||'.RIGHT (RIGHT_ID) ,CONSTRAINT FK_PLAYBACK_RESTR_REC_01 FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING (RECORDING_ID) )';
     CREATEOBJECT(VSQL,'ALTER TABLE PLAYBACK_WINDOW_RESTRICTIONS');

    -- split the schedule table partitions
    vsql := 'ALTER TABLE '|| vschema||'.SCHEDULE SPLIT SUBPARTITION before_max_value_all values (0) into (subpartition before_max_value_non_recs, subpartition before_max_value_recs) update indexes';
    CREATEOBJECT(vsql,'ALTER TABLE '|| vschema||'.SCHEDULE SPLIT SUBPARTITION before_max_value_all values (0) into (subpartition before_max_value_non_recs, subpartition before_max_value_recs) update indexes');

    FOR i IN -13..(v_partition_years * 12) -1
      LOOP
        vsql := ' ALTER TABLE '|| vschema||'.SCHEDULE SPLIT partition before_max_value  at (TO_DATE(''1-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ';
       CREATEOBJECT(VSQL,' ALTER TABLE '|| vschema||'.SCHEDULE SPLIT partition before_max_value  at (TO_DATE(''1-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ');
        vsql := ' ALTER TABLE '|| vschema||'.SCHEDULE SPLIT partition before_max_value  at (TO_DATE(''16-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ';
        CREATEOBJECT(VSQL,' ALTER TABLE '|| vschema||'.SCHEDULE SPLIT partition before_max_value  at (TO_DATE(''16-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ');
    end loop;

     -- split the alarm_activitylog table partition

     FOR i IN -13..(v_partition_years * 12) -1
      LOOP
        vsql := ' ALTER TABLE '|| vschema||'.Alarm_activitylog SPLIT partition before_max_value  at (TO_DATE(''1-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ';
       CREATEOBJECT(VSQL,' ALTER TABLE '|| vschema||'.Alarm_activitylog SPLIT partition before_max_value  at (TO_DATE(''1-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ');
        vsql := ' ALTER TABLE '|| vschema||'.Alarm_activitylog SPLIT partition before_max_value  at (TO_DATE(''16-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ';
        CREATEOBJECT(VSQL,' ALTER TABLE '|| vschema||'.Alarm_activitylog SPLIT partition before_max_value  at (TO_DATE(''16-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY'')) into ( partition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ', partition before_max_value) update indexes ');
    end loop;

    -- add triggers
      createupdatetrg('SCHEDULE');
      createupdatetrg('RECORDING');
      createupdatetrg('ALARM_ACTIVITYLOG');
      createupdatetrg('RECORDING_LOG');

    -- add indexes
      VSQL := 'CREATE UNIQUE INDEX '||VSCHEMA||'.IDX_SCHED_UNIQ_IND ON '||VSCHEMA||'.SCHEDULE (PROGRAM_ID,STATION_ID,START_TIME)';
      CREATEOBJECT(vsql,'create index IDX_SCHED_UNIQ_IND', 'Y');

      VSQL := 'CREATE INDEX '||VSCHEMA||'.IDX_SCHED_START_END_TIME ON '||VSCHEMA||'.SCHEDULE (START_TIME,END_TIME)';
      CREATEOBJECT(vsql,'create index IDX_SCHED_START_END_TIME', 'Y');

      VSQL := 'CREATE INDEX '||VSCHEMA||'.IDX_SCH_STATION_ID ON '||VSCHEMA||'.SCHEDULE(STATION_ID)';
      CREATEOBJECT(VSQL,'create index IDX_SCH_STATION_ID', 'Y');

      VSQL:='CREATE INDEX '||VSCHEMA||'.IDX_RECORDLOG_RECORDINGID ON '||VSCHEMA||'.RECORDING_LOG (RECORDING_ID)';
      CREATEOBJECT(VSQL,'CREATE INDEX IDX_RECORDLOG_RECORDINGID', 'Y');

    -- rebuild the indexes for all the required tables
     for table_indexes in  (select index_name from user_indexes where table_owner = vschema and table_name in ('SCHEDULE','RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP', 'ALARM_ACTIVITYLOG'))
     loop
        vsql := ' ALTER INDEX ' || table_indexes.index_name|| ' REBUILD ' ;
      CREATEOBJECT(VSQL,' ALTER INDEX ' || table_indexes.index_name|| ' REBUILD ');
     end loop;

     else
        insert into install_table(msgdate, install_message) values (sysdate, 'The current oracle version does not support partitioning and hence archiving feature will be based on non-partitioning strategy');
        commit;
     end if;

     -- Remove all the constraints from all the tables
    -- rename the tables
    --
    -- create a new table with partition
    -- exchange the partition with the old table data
    -- split the partitions
    -- add triggers
    -- add indexes
    -- rebuild the indexes for all the tables
    execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
    vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''Upgrading RCS DB to support archiving is completed'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
      CREATEOBJECT(VSQL,'insert into ALARM_ACTIVITYLOG', 'Y');
    commit;
  end upgradeRCSDBToSupportArchive;

	procedure installRCSArchiveDB is

    vsql_clob clob;
	  v_isPartitionSupported varchar2(50) :='FALSE';
    vrcsdbver varchar2(30) ;
    volder_version varchar2(20);
    vcount number;
     BEGIN
	   /********************** CREATE RCSARCHIVE USER AND TABLESPACES ******************/
		  execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
      vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
      values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''Setting up RCS Archive DB is started'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
      CREATEOBJECT(VSQL,'insert into ALARM_ACTIVITYLOG', 'Y');
      commit;

		  execute immediate 'Select value from '||vschema||'.config_setting where key=''version''' into vrcsdbver;
      		
		  /**
		  Disabling the Partitioning based DB Archive Feature since Non-Partitioning strategy works fine with larger amounts of
		  databases. Partitioning based DB Archive feature requires future maintenance work.
		  */
		  --select value into v_isPartitionSupported from  v$option where upper(parameter)=upper('Partitioning');


	      vsql :='drop tablespace tstv_rcs_archive including contents and datafiles';
				CREATEOBJECT(vsql,'DROP TABLESPACE tstv_rcs_archive','Y');

	      -- Creating tstv_rcs_archive tablespace
	      vsql :='create tablespace tstv_rcs_archive datafile size 500M AUTOEXTEND ON NEXT 250M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL AUTOALLOCATE SEGMENT SPACE MANAGEMENT AUTO';
				CREATEOBJECT(vsql,'CREATE TABLESPACE tstv_rcs_archive');

		  --CREATE RCSARCHIVE USER
	      vsql :=  'create user RCSARCHIVE identified by RcSarchive1234 default tablespace tstv_rcs_archive';
	      CREATEOBJECT(vsql,'CREATE USER RCSARCHIVE');

			--Grant privs to RCSARCHIVE user
	      vsql :=  'grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to RCSARCHIVE';
	      CREATEOBJECT(vsql,'Unable to grant resource, connect, and create session to the RCSARCHIVE user.');

	      vsql := 'grant all on dbms_xmlschema to RCSARCHIVE';
	      CREATEOBJECT(vsql,'Unable to grant all on dbms_xmlschema to RCSARCHIVE');

	      vsql := 'grant all on dbms_errlog to RCSARCHIVE';
	      CREATEOBJECT(vsql,'Unable to grant all on dbms_errlog to RCSARCHIVE');

	      vsql := 'grant create database link to RCSARCHIVE';
	      CREATEOBJECT(vsql,'Unable to grant create database link to RCSARCHIVE');

	      vsql := 'grant references on '||vschema||'.schedule to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.schedule to rcsarchive');

	      vsql := 'grant references on '||vschema||'.program to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.program to rcsarchive');

	      vsql := 'grant references on '||vschema||'.station to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.station to rcsarchive');

	      vsql := 'grant references on '||vschema||'.rtc_pool to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.rtc_pool to rcsarchive');


        vsql := 'grant references on '||vschema||'.headend to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.headend to rcsarchive');

        vsql := 'grant references on '||vschema||'.rm to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.rm to rcsarchive');

	       vsql := 'grant references on '||vschema||'.right to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.right to rcsarchive');


    	vsql := 'grant references on '||vschema||'.ENTITY_MAPPING to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.ENTITY_MAPPING to rcsarchive');

      vsql := 'grant references on '||vschema||'.RECORDING_RULES to rcsarchive';
	      CREATEOBJECT(vsql,'grant references on '||vschema||'.RECORDING_RULES to rcsarchive');

      vsql := 'grant references on '||vschema||'.ERROR_CODE to rcsarchive';
	    CREATEOBJECT(vsql,'grant references on '||vschema||'.ERROR_CODE to rcsarchive');


	      --grant references on rcs.schedule to rcsarchive


       -- RIGHT_RM_MAP TABLE
      select replace (replace (dbms_metadata.get_ddl('TABLE', 'RIGHT_RM_MAP', 'RCS'), '"RCS"."RIGHT_RM_MAP"', '"RCSARCHIVE"."RIGHT_RM_MAP"' ),  'TSTV_RCS', 'TSTV_RCS_ARCHIVE') into vsql from dual;
      CREATEOBJECT(vsql,'Creating RIGHT_RM_MAP table from RCS to RCSARCHIVE');

     if (v_isPartitionSupported = 'TRUE' and vrcsdbver >='3.3.000.0') THEN

          vsql := 'alter table '||vschema||'.SCHEDULE add START_TIME_VIR TIMESTAMP (9)  AS (TO_TIMESTAMP(TO_CHAR("START_TIME",''mm-dd-yyyy hh24:mi:ss''),''mm-dd-yyyy hh24:mi:ss'')) ';
          createobject(vsql,'alter table '||vschema||'.SCHEDULE add START_TIME_VIR TIMESTAMP (9)  AS (TO_TIMESTAMP(TO_CHAR("START_TIME",''mm-dd-yyyy hh24:mi:ss''),''mm-dd-yyyy hh24:mi:ss'')) ', 'Y');
           vsqlclob := get_table_ddl('SCHEDULE', 'RCS');
          select replace (replace(vsqlclob, '"RCS"."SCHEDULE"', '"RCSARCHIVE"."SCHEDULE"' ), 'TSTV_RCS', 'TSTV_RCS_ARCHIVE') into vsql from dual;

            vsql := vsql || '  partition by range (start_time_vir)
	               subpartition by list (recordable) ( ';
            FOR i IN -13..(v_partition_years * 12) -1 LOOP
              vsql := vsql || ' partition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ' VALUES LESS THAN (TO_DATE(''1-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY''))';
              vsql := vsql || '  ( subpartition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY')||'_non_recs VALUES (0),
                                  subpartition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY')||'_recs VALUES (1)
                                 )';
              vsql  := vsql || '
                                , ';
              vsql := vsql || ' partition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ' VALUES LESS THAN (TO_DATE(''16-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY''))';
              vsql := vsql || '  ( subpartition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY')||'_non_recs VALUES (0),
                                  subpartition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY')||'_recs VALUES (1)
                                 )';
              vsql  := vsql || ' , ';
            END LOOP;
              vsql := vsql || ' partition after_1_'||to_char(add_months(sysdate,v_partition_years * 12), 'MON')||'_'||to_char(add_months(sysdate, v_partition_years * 12), 'YY') || ' VALUES LESS THAN (MAXVALUE)';
              vsql := vsql || '  ( subpartition after_1_'||to_char(add_months(sysdate, v_partition_years * 12), 'MON')||'_'||to_char(add_months(sysdate, v_partition_years * 12), 'YY')||'_non_recs VALUES (0),
                                  subpartition after_1_'||to_char(add_months(sysdate, v_partition_years * 12), 'MON')||'_'||to_char(add_months(sysdate, v_partition_years * 12), 'YY')||'_recs VALUES (1)
                                 )';

             vsql := vsql || ' ) enable row movement ';


          CREATEOBJECT(vsql,'Creating  SCHEDULE table from RCS to RCSARCHIVE');

          vsql := ' alter table '||vschema||'.recording_log modify recording_id  not null ';
          CREATEOBJECT(vsql,'alter table recording_log modify recording_id  not null', 'Y');

          vsql := ' alter table '||vschema||'.REC_TRIAL_USE_FIELDS modify recording_id  not null ';
          CREATEOBJECT(vsql,'alter table recording_log modify recording_id  not null', 'Y');

          vsql := ' alter table '||vschema||'.RECORDING_REC_RULES_MAP modify recording_id  not null ';
          CREATEOBJECT(vsql,'alter table recording_log modify recording_id  not null', 'Y');

         -- RECORDING TABLE
          vsqlclob := get_table_ddl('RECORDING', 'RCS');
          select replace (replace (replace(vsqlclob, '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."SCHEDULE"','"RCSARCHIVE"."SCHEDULE"')  into vsql from dual;
          vsql := vsql || ' PARTITION BY REFERENCE (FK_RECORDING_SCHEDULE) ENABLE ROW MOVEMENT ';
          CREATEOBJECT(vsql,'Creating RECORDING table from RCS to RCSARCHIVE');

         -- RECORDABLE_RIGHTS_MAP
          vsqlclob := get_table_ddl('RECORDABLE_RIGHTS_MAP', 'RCS');
         select replace(replace (replace (replace(vsqlclob, '"RCS"."RECORDABLE_RIGHTS_MAP"','"RCSARCHIVE"."RECORDABLE_RIGHTS_MAP"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."SCHEDULE"','"RCSARCHIVE"."SCHEDULE"'),'"RCS"."RIGHT_RM_MAP"', '"RCSARCHIVE"."RIGHT_RM_MAP"')   into vsql from dual;
         vsql := vsql || ' PARTITION BY REFERENCE (FK_REC_RIGHTS_MAP_SCH) ENABLE ROW MOVEMENT ';

         CREATEOBJECT(vsql,'Creating RECORDABLE_RIGHTS_MAP table from RCS to RCSARCHIVE');

        --recording_rtc_pool_map
        if is_table_exists(vschema, 'recording_rtc_pool_map') = true then
                vsqlclob := get_table_ddl('RECORDING_RTC_POOL_MAP', 'RCS');
                 select replace (replace (replace(vsqlclob, '"RCS"."RECORDING_RTC_POOL_MAP"','"RCSARCHIVE"."RECORDING_RTC_POOL_MAP"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
                  vsql := vsql || ' PARTITION BY REFERENCE (FK_REC_RTC_POOL_MAP_RECORDING) ENABLE ROW MOVEMENT ';

              CREATEOBJECT(vsql,'Creating RECORDING_RTC_POOL_MAP table from RCS to RCSARCHIVE');

               vsql := ' alter table '||vschema||'.recording_log  add constraint FK_REC_LOG_RECORDING  FOREIGN KEY(RECORDING_ID) REFERENCES '||vschema||'.RECORDING(RECORDING_ID)';
               CREATEOBJECT(vsql,' alter table '||vschema||'.recording_log  add constraint FK_REC_LOG_RECORDING  FOREIGN KEY(RECORDING_ID) REFERENCES '||vschema||'.RECORDING(RECORDING_ID)', 'Y');

            -- RECORDING_LOG
            vsqlclob := get_table_ddl('RECORDING_LOG', 'RCS');
            select replace  (replace (replace (replace(vsqlclob, '"RCS"."RECORDING_LOG"','"RCSARCHIVE"."RECORDING_LOG"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"'), '"RCS"."RECORDING_RTC_POOL_MAP"','"RCSARCHIVE"."RECORDING_RTC_POOL_MAP"')  into vsql from dual;

            vsql := vsql || ' PARTITION BY REFERENCE (FK_REC_LOG_RECORDING) ENABLE ROW MOVEMENT ';

              CREATEOBJECT(vsql,'Creating RECORDING_LOG table from RCS to RCSARCHIVE');
        else
            -- RECORDING_LOG
                if is_constraint_exists (vschema, 'RECORDING_LOG','FK_RECORDING_LOG_RECORDING') = true then
                   vsql:='ALTER TABLE '||vschema||'.RECORDING_LOG RENAME CONSTRAINT FK_RECORDING_LOG_RECORDING TO FK_REC_LOG_RECORDING ';
                   CREATEOBJECT(vsql,'Creating RECORDING_LOG table from RCS to RCSARCHIVE');
                end if;
                vsqlclob := get_table_ddl('RECORDING_LOG', 'RCS');
            select replace (replace (replace(vsqlclob, '"RCS"."RECORDING_LOG"','"RCSARCHIVE"."RECORDING_LOG"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;

            vsql := vsql || ' PARTITION BY REFERENCE (FK_REC_LOG_RECORDING) ENABLE ROW MOVEMENT ';

              CREATEOBJECT(vsql,'Creating RECORDING_LOG table from RCS to RCSARCHIVE');

       end if;

        -- Add the foreign key constraint on to RCS Schema

        vsql := 'alter table '||vschema||'.REC_TRIAL_USE_FIELDS  add CONSTRAINT REC_TRIAL_USE_RECORDING_FK FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING(RECORDING_ID)';
        CREATEOBJECT(vsql,'Add foreign key  REC_TRIAL_USE_RECORDING_FK FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING(RECORDING_ID)', 'Y');

        -- REC_TRIAL_USE_FIELDS
        vsqlclob := get_table_ddl('REC_TRIAL_USE_FIELDS', 'RCS');
        select replace (replace (replace(vsqlclob, '"RCS"."REC_TRIAL_USE_FIELDS"','"RCSARCHIVE"."REC_TRIAL_USE_FIELDS"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
         vsql := vsql || ' PARTITION BY REFERENCE (REC_TRIAL_USE_RECORDING_FK) ENABLE ROW MOVEMENT ';
        CREATEOBJECT(vsql,'Creating REC_TRIAL_USE_FIELDS table from RCS to RCSARCHIVE');


        -- RECORDING_REC_RULES_MAP
         if is_constraint_exists (vschema, 'RECORDING_REC_RULES_MAP','FK_REC_RULES_MAP_REC_01') = true then
             vsql:='ALTER TABLE '||vschema||'.RECORDING_REC_RULES_MAP RENAME CONSTRAINT FK_REC_RULES_MAP_REC_01 TO FK_REC_REC_RULES_MAP ';
             CREATEOBJECT(vsql,'ALTER TABLE RECORDING_REC_RULES_MAP RENAME CONSTRAINT FK_REC_RULES_MAP_REC_01 TO FK_REC_REC_RULES_MAP');
        end if;
        vsqlclob := get_table_ddl('RECORDING_REC_RULES_MAP', 'RCS');
        select replace (replace (replace(vsqlclob, '"RCS"."RECORDING_REC_RULES_MAP"','"RCSARCHIVE"."RECORDING_REC_RULES_MAP"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
         vsql := vsql || ' PARTITION BY REFERENCE (FK_REC_REC_RULES_MAP) ENABLE ROW MOVEMENT ';
        CREATEOBJECT(vsql,'Creating RECORDING_REC_RULES_MAP table from RCS to RCSARCHIVE');

        -- PLAYBACK_WINDOW_RESTRICTIONS
        select replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'PLAYBACK_WINDOW_RESTRICTIONS', 'RCS'), '"RCS"."PLAYBACK_WINDOW_RESTRICTIONS"','"RCSARCHIVE"."PLAYBACK_WINDOW_RESTRICTIONS"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
        CREATEOBJECT(vsql,'Creating PLAYBACK_WINDOW_RESTRICTIONS table from RCS to RCSARCHIVE');

        -- ALARM_ACTIVITYLOG
       -- There is a problem with alter table '||vschema||'.ALARM_ACTIVITYLOG add ACKNOWLEDGED	NUMBER (1,0) DEFAULT 0 NOT NULL from 3.2 to 3.3 migration to support exchange partition
       -- The work around is  drop the column before creating the partitioning and readd the column  to the table in both rcs and RCSArchive schemas after exchange partition
       execute immediate 'SELECT count(1) from '||vschema||'.config_setting where key=''older_version'''  into vcount;
        if  vcount > 0 then
          execute immediate 'Select value from '||vschema||'.config_setting where key=''older_version''' into volder_version;
           if volder_version < '3.3.000.0' THEN
            vsql := 'alter table '||vschema||'.ALARM_ACTIVITYLOG drop column ACKNOWLEDGED ';
            createobject(vsql,'alter table '||vschema||'.ALARM_ACTIVITYLOG drop column ACKNOWLEDGED', 'Y');
          end if;
       end if;
        vsql := 'alter table '||vschema||'.ALARM_ACTIVITYLOG add CREATE_DATE_VIR TIMESTAMP (9)  AS (TO_TIMESTAMP(TO_CHAR("CREATE_DATE",''mm-dd-yyyy hh24:mi:ss''),''mm-dd-yyyy hh24:mi:ss'')) ';
          createobject(vsql,'alter table '||vschema||'.ALARM_ACTIVITYLOG add CREATE_DATE_VIR TIMESTAMP (9)  AS (TO_TIMESTAMP(TO_CHAR("CREATE_DATE",''mm-dd-yyyy hh24:mi:ss''),''mm-dd-yyyy hh24:mi:ss'')) ', 'Y');
         vsqlclob := get_table_ddl('ALARM_ACTIVITYLOG', 'RCS');
          select replace(replace(vsqlclob, '"RCS"."ALARM_ACTIVITYLOG"', '"RCSARCHIVE"."ALARM_ACTIVITYLOG"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE') into vsql from dual;

           vsql := vsql || '  partition by range (CREATE_DATE_VIR)
	               ( ';
            FOR i IN -13..(v_partition_years * 12) -1 LOOP
              vsql := vsql || ' partition before_1_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ' VALUES LESS THAN (TO_DATE(''1-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY''))';
              vsql  := vsql || ' , ';
              vsql := vsql || ' partition before_16_'||to_char(add_months(sysdate, i), 'MON')||'_'||to_char(add_months(sysdate, i), 'YY') || ' VALUES LESS THAN (TO_DATE(''16-'||to_char(add_months(sysdate, i), 'MON')||'-'||to_char(add_months(sysdate, i), 'YYYY')||''', ''DD-MON-YYYY''))';
              vsql  := vsql || ' , ';
            END LOOP;
              vsql := vsql || ' partition before_max_value  VALUES LESS THAN (MAXVALUE)';
              vsql := vsql || ' ) enable row movement ';


          createobject(vsql,'Creating  ALARM_ACTIVITYLOG table from RCS to RCSARCHIVE');


      else

           select replace (replace (dbms_metadata.get_ddl('TABLE', 'SCHEDULE', 'RCS'), '"RCS"."SCHEDULE"', '"RCSARCHIVE"."SCHEDULE"' ),  'TSTV_RCS', 'TSTV_RCS_ARCHIVE') into vsql from dual;
           CREATEOBJECT(vsql,'Creating  SCHEDULE table from RCS to RCSARCHIVE');

            -- RECORDING TABLE
          select replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'RECORDING', 'RCS'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."SCHEDULE"','"RCSARCHIVE"."SCHEDULE"')  into vsql from dual;
          CREATEOBJECT(vsql,'Creating RECORDING table from RCS to RCSARCHIVE');

         -- RECORDABLE_RIGHTS_MAP
         select replace(replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'RECORDABLE_RIGHTS_MAP', 'RCS'), '"RCS"."RECORDABLE_RIGHTS_MAP"','"RCSARCHIVE"."RECORDABLE_RIGHTS_MAP"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."SCHEDULE"','"RCSARCHIVE"."SCHEDULE"'),'"RCS"."RIGHT_RM_MAP"', '"RCSARCHIVE"."RIGHT_RM_MAP"')   into vsql from dual;
         CREATEOBJECT(vsql,'Creating RECORDABLE_RIGHTS_MAP table from RCS to RCSARCHIVE');

        --recording_rtc_pool_map
        if is_table_exists(vschema, 'recording_rtc_pool_map') = true then
                 select replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'RECORDING_RTC_POOL_MAP', 'RCS'), '"RCS"."RECORDING_RTC_POOL_MAP"','"RCSARCHIVE"."RECORDING_RTC_POOL_MAP"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
               CREATEOBJECT(vsql,'Creating RECORDING_RTC_POOL_MAP table from RCS to RCSARCHIVE');

            -- RECORDING_LOG
            if is_constraint_exists (vschema, 'RECORDING_LOG','FK_RECORDING_LOG_RECORDING') = true then
                   vsql:='ALTER TABLE '||vschema||'.RECORDING_LOG RENAME CONSTRAINT FK_RECORDING_LOG_RECORDING TO FK_REC_LOG_RECORDING ';
                   createobject(vsql,'Creating RECORDING_LOG table from RCS to RCSARCHIVE');
            end if;
            select replace  (replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'RECORDING_LOG', 'RCS'), '"RCS"."RECORDING_LOG"','"RCSARCHIVE"."RECORDING_LOG"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"'), '"RCS"."RECORDING_RTC_POOL_MAP"','"RCSARCHIVE"."RECORDING_RTC_POOL_MAP"')  into vsql from dual;

             CREATEOBJECT(vsql,'Creating RECORDING_RTC_POOL_MAP table from RCS to RCSARCHIVE');
        else
            -- RECORDING_LOG
            select replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'RECORDING_LOG', 'RCS'), '"RCS"."RECORDING_LOG"','"RCSARCHIVE"."RECORDING_LOG"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;

            CREATEOBJECT(vsql,'Creating RECORDING_LOG table from RCS to RCSARCHIVE');

       end if;


        -- Add the foreign key constraint on REC_TRIAL_USE_FIELDS

        vsql := 'alter table '||vschema||'.REC_TRIAL_USE_FIELDS  add CONSTRAINT REC_TRIAL_USE_RECORDING_FK FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING(RECORDING_ID)';
        CREATEOBJECT(vsql,'Add foreign key  REC_TRIAL_USE_RECORDING_FK FOREIGN KEY (RECORDING_ID) REFERENCES '||vschema||'.RECORDING(RECORDING_ID)', 'Y');

        -- REC_TRIAL_USE_FIELDS
        select replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'REC_TRIAL_USE_FIELDS', 'RCS'), '"RCS"."REC_TRIAL_USE_FIELDS"','"RCSARCHIVE"."REC_TRIAL_USE_FIELDS"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
        CREATEOBJECT(vsql,'Creating REC_TRIAL_USE_FIELDS table from RCS to RCSARCHIVE');


        -- RECORDING_REC_RULES_MAP
        select replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'RECORDING_REC_RULES_MAP', 'RCS'), '"RCS"."RECORDING_REC_RULES_MAP"','"RCSARCHIVE"."RECORDING_REC_RULES_MAP"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
        CREATEOBJECT(vsql,'Creating RECORDING_REC_RULES_MAP table from RCS to RCSARCHIVE');

        -- PLAYBACK_WINDOW_RESTRICTIONS
        select replace (replace (replace(dbms_metadata.get_ddl('TABLE', 'PLAYBACK_WINDOW_RESTRICTIONS', 'RCS'), '"RCS"."PLAYBACK_WINDOW_RESTRICTIONS"','"RCSARCHIVE"."PLAYBACK_WINDOW_RESTRICTIONS"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE'), '"RCS"."RECORDING"','"RCSARCHIVE"."RECORDING"')  into vsql from dual;
        CREATEOBJECT(vsql,'Creating PLAYBACK_WINDOW_RESTRICTIONS table from RCS to RCSARCHIVE');

        -- ALARM_ACTIVITYLOG

          select replace(replace(dbms_metadata.get_ddl('TABLE', 'ALARM_ACTIVITYLOG', 'RCS'), '"RCS"."ALARM_ACTIVITYLOG"', '"RCSARCHIVE"."ALARM_ACTIVITYLOG"' ),'TSTV_RCS', 'TSTV_RCS_ARCHIVE') into vsql from dual;
          createobject(vsql,'Creating  ALARM_ACTIVITYLOG table from RCS to RCSARCHIVE');


      end if;

          vsql := 'insert into '||vschema||'.config_setting(key, value, created_by, updated_by, create_date, update_date) values (''archivedb_version'', '''||vrcsdbver||''', ''SYSTEM'',''SYSTEM'',CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
          createobject(vsql,'INSERT INTO CONFIG_SETTING ');

          vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(''OLD_DATA_TO_BE_ARCHIVED'', ''NON_RECORDABLES'', ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(VSQL,'INSERT INTO CONFIG_SETTING');

         vsql := 'INSERT INTO '||vschema||'.config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          VALUES(''OLD_DATA_RETENTION_PERIOD'', 90, ''System'', ''System'', current_timestamp, current_timestamp)';
        CREATEOBJECT(VSQL,'INSERT INTO CONFIG_SETTING');


          vsql := 'INSERT INTO install_table values('''||sysdate||''',''RCS Archive Database '||vrcsdbver||' Version  installation has completed SUCCESSFULLY.'')';
         createobject(vsql,'insert into install_table','Y');
execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
        vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''Setting up RCS Archive DB is completed'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
        CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');


          commit;


          UPGRADERCSDBTOSUPPORTARCHIVE();


   EXCEPTION
    when others then
    rollback;
    execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(sqlerrm,'''')||''')';
    commit;
    execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
        vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 1, 3, ''RCS'', ''Setting up RCS Archive DB is failed. Please contact the administrator '', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
        CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');

     commit;


	end installrcsarchivedb;

	procedure upgradeRCSArchiveDB is
	v_isPartitionSupported varchar2(30);
  vrcsdbver  varchar2(100);
  vrcsarchivedbver  varchar2(100);
  vcount number(5);
  v_isUpgradedFrom32 varchar(30) := 'FALSE';
  begin
	  execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
      vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
    values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''RCS Archive DB upgrade is started'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
    CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');

   execute immediate 'SELECT value from '||vschema||'.config_setting where key=''version'''  into vrcsdbver;
   execute immediate 'SELECT count(1) from '||vschema||'.config_setting where key=''archivedb_version'''  into vcount;
   if vcount > 0 then
      execute immediate 'SELECT value from '||vschema||'.config_setting where key=''archivedb_version'''  into vrcsarchivedbver;

      -- upgrade path
      if vrcsarchivedbver < '3.3.000.0'  and vrcsdbver >= '3.3.000.0' then
              if is_table_exists(v_rcsarchive_schema, 'rec_trial_use_fields') = true then
               vsql := 'delete from '||v_rcsarchive_schema||'.rec_trial_use_fields rtuf
              where rtuf.recording_id in (
              select r.recording_id from '||v_rcsarchive_schema||'.recording r where r.status=1)';
              CREATEOBJECT(vsql,'delete rec_trial_use_fields');
            end if;
         if is_table_exists(v_rcsarchive_schema, 'RECORDING_REC_RULES_MAP') = true then
              vsql := 'delete from '||v_rcsarchive_schema||'.RECORDING_REC_RULES_MAP rrrm
              where rrrm.recording_id in (
              select r.recording_id from '||v_rcsarchive_schema||'.recording r where r.status=1)';
              CREATEOBJECT(vsql,'delete RECORDING_REC_RULES_MAP');
         end if;

          if is_table_exists(v_rcsarchive_schema, 'PLAYBACK_WINDOW_RESTRICTIONS') = true then
              vsql := 'delete from '||v_rcsarchive_schema||'.PLAYBACK_WINDOW_RESTRICTIONS pwr
              where pwr.recording_id in (
              select r.recording_id from '||v_rcsarchive_schema||'.recording r where r.status=1)';
              CREATEOBJECT(vsql,'delete PLAYBACK_WINDOW_RESTRICTIONS');
          end if;

         if is_table_exists(v_rcsarchive_schema, 'RECORDING_LOG') = true then
              vsql := 'delete from '||v_rcsarchive_schema||'.RECORDING_LOG rl
              where rl.recording_id in (
              select r.recording_id from '||v_rcsarchive_schema||'.recording r where r.status=1)';
              CREATEOBJECT(vsql,'delete RECORDING_LOG');
         end if;

         if is_table_exists(v_rcsarchive_schema, 'recording_rtc_pool_map') = true then
            vsql := 'delete from '||v_rcsarchive_schema||'.recording_rtc_pool_map rl
              where rl.recording_id in (
              select r.recording_id from '||v_rcsarchive_schema||'.recording r where r.status=1)';
              CREATEOBJECT(vsql,'delete recording_rtc_pool_map');
         end if;

         if is_table_exists(v_rcsarchive_schema, 'recording') = true then
              vsql := 'delete from '||v_rcsarchive_schema||'.recording r
              where r.status=1';
              CREATEOBJECT(vsql,'delete recording');
        end if;
        declare
        type vsqltab is table of varchar2(4000);
        vsql1 vsqltab;
      BEGIN
        select sqlcmd
        BULK COLLECT INTO VSQL1
        FROM
        (SELECT 'drop trigger '||v_rcsarchive_schema||'.'||TRIGGER_NAME AS SQLCMD FROM DBA_TRIGGERS
        WHERE OWNER = v_rcsarchive_schema and TABLE_NAME IN ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP')
        UNION
        SELECT STMT.SQLCMD FROM
        (SELECT
        'alter table '||v_rcsarchive_schema||'.'||TABLE_NAME||' drop constraint '||CONSTRAINT_NAME||' cascade' as sqlcmd
        FROM DBA_CONSTRAINTS
        WHERE OWNER=v_rcsarchive_schema and TABLE_NAME IN ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP')
        AND CONSTRAINT_TYPE IN ('R','P','U')
        order by constraint_type desc) STMT
        UNION
        select 'drop index '||v_rcsarchive_schema||'.'||index_name as sqlcmd from dba_indexes
        where owner=v_rcsarchive_schema and table_name in ('RECORDING','RECORDING_RTC_POOL_MAP','RECORDING_LOG','PLAYBACK_WINDOW_RESTRICTIONS','RECORDING_REC_RULES_MAP','REC_TRIAL_USE_FIELDS','RECORDABLE_RIGHTS_MAP')
        UNION
        SELECT 'drop table '||v_rcsarchive_schema||'.'||TABLE_NAME||' purge' AS SQLCMD FROM DBA_TABLES
        WHERE owner=v_rcsarchive_schema and TABLE_NAME like 'PREMIG%' or table_name like 'TMPMIG%'

        ) ;

        if vsql1.count > 0 then
          FOR I IN 1..VSQL1.LAST LOOP
            begin
              EXECUTE IMMEDIATE VSQL1(I);
            EXCEPTION
              WHEN OTHERS THEN
                NULL;
            END;
          end loop;
        END IF;

      END;
     if is_table_exists(v_rcsarchive_schema, 'tmpmig_recording') = false
          and is_table_exists(v_rcsarchive_schema, 'recording_rtc_pool_map') = true
          and is_table_exists(v_rcsarchive_schema, 'recording') = true  then
          vsql := 'CREATE TABLE '||v_rcsarchive_schema||'.tmpmig_recording
            (
              RECORDING_ID,
              PROGRAM_TITLE,
              PROGRAM_DESCRIPTION,
              OFFSET_START_TIME,
              OFFSET_END_TIME,
              RECORDING_MODE,
              PRIORITY,
              PROVIDER_QA_CONTACT,
              CATALOG_ENTRY,
              BILLING_ID,
              MPAA_RATING,
              TV_RATING,
              PROVIDER_ID,
              PROVIDER_NAME,
              PRODUCT,
              CATEGORY,
              STATUS,
              AUDIO_TYPE,
              MAX_COPIES,
              PREVIEW_PERIOD,
			  LICENCE_START_DATE,
              LICENSE_END_DATE,
              APPROVAL_TYPE  default ''AUTO'',
              SCHEDULE_ID,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE,
              POOL_ID,
              ASSET_ID,
              TITLE_ASSET_ID,
              MOVIE_ASSET_ID,
              STATUS_CODE,
              CONTENT_URL,
              ADJUSTED_START_TIME,
              ADJUSTED_END_TIME,
              newrecording_id
            ) AS
          SELECT rrpm.RECORDING_ID,
            r.PROGRAM_TITLE,
            r.PROGRAM_DESCRIPTION,
            r.OFFSET_START_TIME,
            r.OFFSET_END_TIME,
            r.RECORDING_MODE,
            r.PRIORITY,
            r.PROVIDER_QA_CONTACT,
            r.CATALOG_ENTRY,
            r.BILLING_ID,
            r.MPAA_RATING,
            r.TV_RATING,
            r.PROVIDER_ID,
            r.PROVIDER_NAME,
            r.PRODUCT,
            r.CATEGORY,
            r.STATUS,
            r.AUDIO_TYPE,
            r.MAX_COPIES,
            r.PREVIEW_PERIOD,
            r.LICENCE_START_DATE,
            r.LICENSE_END_DATE,
            r.APPROVAL_TYPE,
            r.SCHEDULE_ID,
            r.CREATED_BY,
            r.UPDATED_BY,
            r.CREATE_DATE,
            r.UPDATE_DATE,
            rrpm.POOL_ID,
            rrpm.ASSET_ID,
            rrpm.TITLE_ASSET_ID,
            rrpm.MOVIE_ASSET_ID,
            rrpm.STATUS_CODE,
            rrpm.CONTENT_URL,
            rrpm.ADJUSTED_START_TIME,
            rrpm.ADJUSTED_END_TIME,
            CASE
              WHEN r.recording_id = lag(r.recording_id,1) over (order by r.recording_id)
              THEN '||vschema||'.recording_seq.nextval
              ELSE NULL
            END
          FROM '||v_rcsarchive_schema||'.recording r,
            '||v_rcsarchive_schema||'.recording_rtc_pool_map rrpm
          WHERE r.recording_id = rrpm.recording_id';
          CREATEOBJECT(vsql,'CREATE TABLE tmpmig_recording');
      end if;

      if is_table_exists(v_rcsarchive_schema, 'tmpmig_recording_log') = false
          and is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING') = true
          and is_table_exists(v_rcsarchive_schema, 'recording_log') = true
          then
          vsql := 'CREATE TABLE '||v_rcsarchive_schema||'.tmpmig_recording_log
            (
              RECORDING_LOG_ID,
              RECORDING_ID,
              LOG_MESSAGE,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE
            ) AS
          SELECT
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN rl.RECORDING_LOG_ID
          ELSE '||vschema||'.recording_log_seq.nextval
            END,
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN tmr.RECORDING_ID
              ELSE tmr.newrecording_id
            END,
            rl.LOG_MESSAGE,
            rl.CREATED_BY,
            rl.UPDATED_BY,
            rl.CREATE_DATE,
            rl.UPDATE_DATE
          FROM '||v_rcsarchive_schema||'.recording_log rl,
            '||v_rcsarchive_schema||'.TMPMIG_RECORDING TMR
          where rl.RECORDING_ID = TMR.RECORDING_ID';
          CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_recording_log');
      end if;

      if is_table_exists(v_rcsarchive_schema, 'tmpmig_pwr') = false
          and is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING') = true
          and is_table_exists(v_rcsarchive_schema, 'playback_window_restrictions') = true then
          vsql := 'CREATE TABLE '||v_rcsarchive_schema||'.tmpmig_pwr
            (
              RESTRICTION_ID,
              START_TIME,
              DURATION,
              RESTRICTIONS,
              TYPE,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE,
              RIGHT_ID,
              RECORDING_ID
            ) AS
          SELECT
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN pwr.RESTRICTION_ID
          ELSE '||vschema||'.playback_window_restr_seq.nextval
            END,
            pwr.START_TIME,
            pwr.DURATION,
            pwr.RESTRICTIONS,
            pwr.TYPE,
            pwr.CREATED_BY,
            pwr.UPDATED_BY,
            pwr.CREATE_DATE,
            pwr.UPDATE_DATE,
            pwr.RIGHT_ID,
            CASE
              WHEN tmr.newrecording_id IS NULL
              THEN tmr.RECORDING_ID
              ELSE tmr.newrecording_id
            END
          FROM '||v_rcsarchive_schema||'.playback_window_restrictions pwr,
            '||v_rcsarchive_schema||'.tmpmig_recording tmr
          where TMR.RECORDING_ID(+) = PWR.RECORDING_ID';
          CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_pwr');
       end if;
      if is_table_exists(v_rcsarchive_schema, 'tmpmig_rtuf') = false
          and is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING') = true
          and is_table_exists(v_rcsarchive_schema, 'rec_trial_use_Fields') = true
            then
          vsql := 'CREATE table '||v_rcsarchive_schema||'.tmpmig_rtuf ( TRIAL_USE_FIELD_ID, ASSET_TYPE, NAME, VALUE_TYPE, VALUE, MAPPING_ID, RECORDING_ID, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          AS
            SELECT
              CASE
                WHEN rtuf.TRIAL_USE_FIELD_ID=lag(rtuf.TRIAL_USE_FIELD_ID,1) over (order by rtuf.TRIAL_USE_FIELD_ID)
            THEN '||vschema||'.rec_trial_use_field_seq.nextval
                ELSE rtuf.TRIAL_USE_FIELD_ID
              END,
              rtuf.ASSET_TYPE,
              rtuf.NAME,
              rtuf.VALUE_TYPE,
              rtuf.VALUE,
              rtuf.MAPPING_ID,
              CASE
                WHEN tmr.newrecording_id IS NULL
                THEN tmr.RECORDING_ID
                ELSE tmr.newrecording_id
              END,
              rtuf.DESCRIPTION,
              rtuf.CREATED_BY,
              rtuf.UPDATED_BY,
              rtuf.CREATE_DATE,
              rtuf.UPDATE_DATE
            FROM '||v_rcsarchive_schema||'.rec_trial_use_Fields rtuf,
              '||v_rcsarchive_schema||'.tmpmig_recording tmr
            where TMR.RECORDING_ID = RTUF.RECORDING_ID';
           CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_rtuf');
        end if;
        if is_table_exists(v_rcsarchive_schema, 'tmpmig_recording_rec_rules_map') = false
            and is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING') = true
            and is_table_exists(v_rcsarchive_schema, 'recording_rec_rules_map') = true
            then
            vsql := 'CREATE TABLE '||v_rcsarchive_schema||'.tmpmig_recording_rec_rules_map
              (
                RECORDING_ID,
                RULE_ID,
                CREATED_BY,
                UPDATED_BY,
                CREATE_DATE,
                UPDATE_DATE
              ) AS
            SELECT
              CASE
                WHEN tmr.newrecording_id IS NULL
                THEN tmr.RECORDING_ID
                ELSE tmr.newrecording_id
              END,
              rrrm.RULE_ID,
              rrrm.CREATED_BY,
              rrrm.UPDATED_BY,
              rrrm.CREATE_DATE,
              rrrm.UPDATE_DATE
            FROM '||v_rcsarchive_schema||'.recording_rec_rules_map rrrm,
              '||v_rcsarchive_schema||'.tmpmig_recording tmr
            WHERE rrrm.recording_id = tmr.recording_id';
             CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_recording_rec_rules_map');
      end if;

      if is_table_exists(v_rcsarchive_schema, 'tmpmig_recordable_rights_map') = false
          and is_table_exists(v_rcsarchive_schema, 'recordable_rights_map') = true then
          --Migrating RECORDABLE_RIGHTS_MAP
          vsql := 'CREATE TABLE '||v_rcsarchive_schema||'.tmpmig_recordable_rights_map
            (
              SCHEDULE_ID,
              RIGHT_ID,
              RM_ID,
              CREATED_BY,
              UPDATED_BY,
              CREATE_DATE,
              UPDATE_DATE
            ) AS
          SELECT DISTINCT rcdrm.SCHEDULE_ID,
            rcdrm.RIGHT_ID,
            rrm.RM_ID,
            rcdrm.CREATED_BY,
            rcdrm.UPDATED_BY,
            rcdrm.CREATE_DATE,
            rcdrm.UPDATE_DATE
          FROM '||v_rcsarchive_schema||'.recordable_rights_map rcdrm,
            '||v_rcsarchive_schema||'.right_rm_map rrm
          WHERE RCDRM.RIGHT_ID = RRM.RIGHT_ID';
           CREATEOBJECT(VSQL,'CREATE TABLE tmpmig_recordable_rights_map');
      end if;


      /**************** START Redefining RECORDABLE_RIGHTS_MAP ******************/
      if is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDABLE_RIGHTS_MAP') = true and is_table_exists(v_rcsarchive_schema, 'premig_recordable_rights_map') = false
          and is_table_exists(v_rcsarchive_schema, 'recordable_rights_map') = true then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.recordable_rights_map RENAME TO premig_recordable_rights_map';
        CREATEOBJECT(VSQL,'rename TABLE recordable_rights_map');
      end if;
      if is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDABLE_RIGHTS_MAP') = true
          and is_table_exists(v_rcsarchive_schema, 'RECORDABLE_RIGHTS_MAP') = false
          then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.TMPMIG_RECORDABLE_RIGHTS_MAP RENAME to RECORDABLE_RIGHTS_MAP';
        CREATEOBJECT(VSQL,'rename TABLE TMPMIG_RECORDABLE_RIGHTS_MAP');
      end if;

      if is_constraint_exists (v_rcsarchive_schema, 'RECORDABLE_RIGHTS_MAP','RECORDABLE_RIGHTS_MAP_PK') = false then
        vsql:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDABLE_RIGHTS_MAP ADD ( CONSTRAINT RECORDABLE_RIGHTS_MAP_PK PRIMARY KEY (SCHEDULE_ID, RIGHT_ID, RM_ID) , CONSTRAINT FK_REC_RIGHTS_MAP_SCH FOREIGN KEY (SCHEDULE_ID) REFERENCES '||v_rcsarchive_schema||'.SCHEDULE (SCHEDULE_ID) , CONSTRAINT FK_REC_RIGHTS_MAP_RIGHT FOREIGN KEY (RIGHT_ID, RM_ID) REFERENCES '||v_rcsarchive_schema||'.RIGHT_RM_MAP (RIGHT_ID, RM_ID) )';
        CREATEOBJECT(VSQL,'alter TABLE RECORDABLE_RIGHTS_MAP');
      end if;
      /**************** START Redefining RECORDING ******************/

      if is_table_exists(v_rcsarchive_schema, 'tmpmig_recording') = true then
          vsql:='UPDATE '||v_rcsarchive_schema||'.tmpmig_recording
                SET recording_id       = newrecording_id
                WHERE NEWRECORDING_ID IS NOT NULL';
          CREATEOBJECT(VSQL,'update TABLE tmpmig_recording');
      end if;
      if is_table_exists(v_rcsarchive_schema, 'tmpmig_recording') = true and is_table_exists(v_rcsarchive_schema, 'recording') = true and is_table_exists(v_rcsarchive_schema, 'premig_recording') = false then
          VSQL:='ALTER TABLE  '||v_rcsarchive_schema||'.recording RENAME TO premig_recording';
          CREATEOBJECT(VSQL,'RENAME TABLE recording');
      end if;

      if is_table_exists(v_rcsarchive_schema, 'tmpmig_recording') = true and  is_table_exists(v_rcsarchive_schema, 'recording') = false then
          VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.tmpmig_recording RENAME TO recording';
          CREATEOBJECT(VSQL,'rename TABLE tmpmig_recording');
      end if;

      if is_constraint_exists (v_rcsarchive_schema, 'RECORDING','PK_RECORDING') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING ADD (CONSTRAINT PK_RECORDING PRIMARY KEY (RECORDING_ID) , CONSTRAINT RECORDING_UK1 UNIQUE (SCHEDULE_ID, POOL_ID) , CONSTRAINT FK_RECORDING_SCHEDULE FOREIGN KEY (SCHEDULE_ID) REFERENCES '||v_rcsarchive_schema||'.SCHEDULE (SCHEDULE_ID) , CONSTRAINT FK_RECORDING_POOL_ID FOREIGN KEY (POOL_ID) REFERENCES '||vschema||'.RTC_POOL (POOL_ID) )';
        CREATEOBJECT(VSQL,'alter TABLE recording');
      end if;


      /**************** START Redefining RECORDING_LOG ******************/
      if is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING_LOG') = true and is_table_exists(v_rcsarchive_schema, 'RECORDING_LOG') = true and is_table_exists(v_rcsarchive_schema, 'PREMIG_RECORDING_LOG') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING_LOG RENAME TO PREMIG_RECORDING_LOG';
        CREATEOBJECT(VSQL,'RENAME RECORDING_LOG');
      end if;

      if is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING_LOG') = true and is_table_exists(v_rcsarchive_schema, 'RECORDING_LOG') =false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.TMPMIG_RECORDING_LOG RENAME TO RECORDING_LOG';
        CREATEOBJECT(VSQL,'RENAME TMPMIG_RECORDING_LOG');
      end if;

      if is_constraint_exists (v_rcsarchive_schema, 'RECORDING_LOG','PK_RECORDING_LOG_01') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING_LOG ADD CONSTRAINT PK_RECORDING_LOG_01 PRIMARY KEY (RECORDING_LOG_ID)' ;
        CREATEOBJECT(VSQL,'alter table RECORDING_LOG');
      end if;
      if is_constraint_exists (v_rcsarchive_schema, 'RECORDING_LOG','FK_REC_LOG_RECORDING') = false then
        vsql:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING_LOG ADD CONSTRAINT FK_REC_LOG_RECORDING FOREIGN KEY (RECORDING_ID) REFERENCES '||v_rcsarchive_schema||'.RECORDING (RECORDING_ID) ';
        CREATEOBJECT(VSQL,'ALTER TABLE RECORDING_LOG');
      end if;

      if is_index_exists (v_rcsarchive_schema, 'IDX_RECORDLOG_RECORDINGID') = false then
        vsql:='CREATE INDEX '||v_rcsarchive_schema||'.IDX_RECORDLOG_RECORDINGID ON '||v_rcsarchive_schema||'.RECORDING_LOG  (    RECORDING_ID  )';
        CREATEOBJECT(VSQL,'CREATE INDEX IDX_RECORDLOG_RECORDINGID');
      end if;


      /**************** START Redefining PLAYBACK_WINDOW_RESTRICTIONS ******************/
      if is_table_exists(v_rcsarchive_schema, 'tmpmig_pwr') = true and is_table_exists(v_rcsarchive_schema, 'PLAYBACK_WINDOW_RESTRICTIONS') = true and is_table_exists(v_rcsarchive_schema, 'PREMIG_PLAYBACK_WIN_RESTRICT') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.PLAYBACK_WINDOW_RESTRICTIONS RENAME TO PREMIG_PLAYBACK_WIN_RESTRICT';
        CREATEOBJECT(VSQL,'rename PLAYBACK_WINDOW_RESTRICTIONS');
      end if;
      if is_table_exists(v_rcsarchive_schema, 'tmpmig_pwr') = true and is_table_exists(v_rcsarchive_schema, 'PLAYBACK_WINDOW_RESTRICTIONS') = false  then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.tmpmig_pwr RENAME TO PLAYBACK_WINDOW_RESTRICTIONS';
        CREATEOBJECT(VSQL,'RENAME tmpmig_pwr');
      end if;
      if is_constraint_exists (v_rcsarchive_schema, 'PLAYBACK_WINDOW_RESTRICTIONS','PK_PLAYBACK_WINDOW_RESTR_01') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.PLAYBACK_WINDOW_RESTRICTIONS ADD (CONSTRAINT PK_PLAYBACK_WINDOW_RESTR_01 PRIMARY KEY (RESTRICTION_ID), CONSTRAINT FK_PLAYBACK_RESTR_RIGHT_01 FOREIGN KEY (RIGHT_ID) REFERENCES '||VSCHEMA||'.RIGHT (RIGHT_ID) ,CONSTRAINT FK_PLAYBACK_RESTR_REC_01 FOREIGN KEY (RECORDING_ID) REFERENCES '||v_rcsarchive_schema||'.RECORDING (RECORDING_ID) )';
        CREATEOBJECT(VSQL,'ALTER TABLE PLAYBACK_WINDOW_RESTRICTIONS');
      end if;
      if is_index_exists (v_rcsarchive_schema, 'IDX_PWR_RIGHTID') = false then
        VSQL:='CREATE INDEX '||v_rcsarchive_schema||'.IDX_PWR_RIGHTID ON '||v_rcsarchive_schema||'.PLAYBACK_WINDOW_RESTRICTIONS(RIGHT_ID)';
        CREATEOBJECT(VSQL,'CREATE index IDX_PWR_RIGHTID');
      end if;
      if is_index_exists (v_rcsarchive_schema, 'IDX_PWR_RECORDINGID') = false then
        VSQL:='CREATE INDEX '||v_rcsarchive_schema||'.IDX_PWR_RECORDINGID ON '||v_rcsarchive_schema||'.PLAYBACK_WINDOW_RESTRICTIONS(RECORDING_ID)';
        CREATEOBJECT(VSQL,'CREATE index IDX_PWR_RECORDINGID');
      end if;
      /*********** START redefining REC_TRIAL_USE_FIELDS ******************************/
      if is_table_exists(v_rcsarchive_schema, 'tmpmig_RTUF') = true  and is_table_exists(v_rcsarchive_schema, 'REC_TRIAL_USE_FIELDS') = true and is_table_exists(v_rcsarchive_schema, 'PREMIG_REC_TRIAL_USE_FLDS') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.REC_TRIAL_USE_FIELDS RENAME TO PREMIG_REC_TRIAL_USE_FLDS';
        CREATEOBJECT(VSQL,'RENAME REC_TRIAL_USE_FIELDS');
      end if;
      if is_table_exists(v_rcsarchive_schema, 'tmpmig_RTUF') = true  and is_table_exists(v_rcsarchive_schema, 'REC_TRIAL_USE_FIELDS') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.tmpmig_RTUF RENAME TO REC_TRIAL_USE_FIELDS';
        CREATEOBJECT(VSQL,'RENAME tmpmig_RTUF');
      end if;

      if is_constraint_exists (v_rcsarchive_schema, 'REC_TRIAL_USE_FIELDS','PK_REC_TRIAL_USE_FIELDS') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.REC_TRIAL_USE_FIELDS ADD ( CONSTRAINT PK_REC_TRIAL_USE_FIELDS PRIMARY KEY (TRIAL_USE_FIELD_ID),CONSTRAINT REC_TRIAL_USE_ENTITY_MAP_FK1 FOREIGN KEY (MAPPING_ID) REFERENCES '||VSCHEMA||'.ENTITY_MAPPING (MAPPING_ID) )';
        CREATEOBJECT(VSQL,'ALTER TABLE REC_TRIAL_USE_FIELDS');
      end if;
      /*********** START redefining RECORDING_REC_RULES_MAP ******************************/

      if  is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING_REC_RULES_MAP') = true and is_table_exists(v_rcsarchive_schema, 'RECORDING_REC_RULES_MAP') = true and is_table_exists(v_rcsarchive_schema, 'PREMIG_RECORDING_REC_RULES_MAP') = false then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING_REC_RULES_MAP RENAME TO PREMIG_RECORDING_REC_RULES_MAP';
        CREATEOBJECT(VSQL,'RENAME RECORDING_REC_RULES_MAP');
      end if;
      if is_table_exists(v_rcsarchive_schema, 'TMPMIG_RECORDING_REC_RULES_MAP') = true and  is_table_exists(v_rcsarchive_schema, 'RECORDING_REC_RULES_MAP') = false then
        vsql:='ALTER TABLE '||v_rcsarchive_schema||'.TMPMIG_RECORDING_REC_RULES_MAP RENAME TO RECORDING_REC_RULES_MAP';
        CREATEOBJECT(VSQL,'RENAME TMPMIG_RECORDING_REC_RULES_MAP');
      end if;
      if is_constraint_exists (v_rcsarchive_schema, 'RECORDING_REC_RULES_MAP','PK_RECORDING_REC_RULES_MAP') = false then
        vsql:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING_REC_RULES_MAP ADD (CONSTRAINT PK_RECORDING_REC_RULES_MAP PRIMARY KEY (RECORDING_ID, RULE_ID) , CONSTRAINT FK_REC_RULES_MAP_REC_RULES_01 FOREIGN KEY (RULE_ID) REFERENCES '||vschema||'.RECORDING_RULES (RULE_ID) , CONSTRAINT FK_REC_RULES_MAP_REC_01 FOREIGN KEY (RECORDING_ID) REFERENCES '||v_rcsarchive_schema||'.RECORDING (RECORDING_ID) )';
        CREATEOBJECT(VSQL,'ALTER TABLE RECORDING_REC_RULES_MAP');
      end if;
      /*********** START redefining RECORDING_RTC_POOL_MAP ******************************/

      if is_table_exists(v_rcsarchive_schema, 'RECORDING_RTC_POOL_MAP') = true and is_table_exists(v_rcsarchive_schema, 'PREMIG_RECORDING_RTC_POOL_MAP') = false  then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING_RTC_POOL_MAP RENAME TO PREMIG_RECORDING_RTC_POOL_MAP';
        CREATEOBJECT(VSQL,'RENAME RECORDING_RTC_POOL_MAP');
      end if;
      if is_column_exists(v_rcsarchive_schema, 'RECORDING','NEWRECORDING_ID') = true then
        VSQL:='ALTER TABLE '||v_rcsarchive_schema||'.RECORDING DROP COLUMN NEWRECORDING_ID';
        CREATEOBJECT(VSQL,'DROP COLUMN NEWRECORDING_ID');
      end if;
      /*********** END Migration Path for Recordings from 3.2 to 3.3 ******************************/
      if is_column_exists(v_rcsarchive_schema, 'ALARM_ACTIVITYLOG','ACKNOWLEDGED') = false then
        vsql := 'alter table '||v_rcsarchive_schema||'.ALARM_ACTIVITYLOG add ACKNOWLEDGED	NUMBER (1,0) DEFAULT 0  NOT NULL ';
        CREATEOBJECT(vsql,'alter TABLE '||v_rcsarchive_schema||'.ALARM_ACTIVITYLOG');
      end if;

      vsql := 'UPDATE '||v_rcsarchive_schema||'.ALARM_ACTIVITYLOG SET ACKNOWLEDGED = 1';
      createobject(vsql,'update '||v_rcsarchive_schema||'.TABLE ALARM_ACTIVITYLOG');

      v_isUpgradedFrom32 := 'TRUE';

      end if;

        if vrcsarchivedbver < '3.3.000.2'  and vrcsdbver >= '3.3.000.2' then
            if is_index_exists (v_rcsarchive_schema, 'IDX_SCH_STATION_ID') = false then
              vsql := 'CREATE INDEX '||v_rcsarchive_schema||'.IDX_SCH_STATION_ID ON '||v_rcsarchive_schema||'.SCHEDULE(STATION_ID)';
              CREATEOBJECT(vsql,''||v_rcsarchive_schema||'.create index IDX_SCH_STATION_ID');
            end if;
      end if;
       if vrcsarchivedbver < '4.0.000.0'  and vrcsdbver >= '4.0.000.0' then
              if is_column_exists(v_rcsarchive_schema, 'RECORDING','POSTER_ASSET_ID') = false then
              vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING add POSTER_ASSET_ID NVARCHAR2 (100) NULL ';
              CREATEOBJECT(vsql,'alter TABLE RECORDING');
            end if;
            if is_column_exists(v_rcsarchive_schema, 'RECORDING','POSTER_IMAGE_NAME') = false then
              vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING add POSTER_IMAGE_NAME	NVARCHAR2(256) NULL ';
              CREATEOBJECT(vsql,'alter TABLE RECORDING');
            end if;
            if is_column_exists(v_rcsarchive_schema, 'RECORDING','POSTER_DESCRIPTION') = false then
              vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING add POSTER_DESCRIPTION NVARCHAR2(1024) NULL ';
              CREATEOBJECT(vsql,'alter TABLE RECORDING');
            end if;

            vsql := 'ALTER TABLE '||v_rcsarchive_schema||'.RECORDING MODIFY (CATEGORY NVARCHAR2(2000))';
           createobject(vsql,'ALTER TABLE '||v_rcsarchive_schema||'.RECORDING MODIFY (CATEGORY NVARCHAR2(2000))');

            if is_column_exists(v_rcsarchive_schema, 'RECORDING', 'REDUNDANCY_COUNT') = false then
            vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING add REDUNDANCY_COUNT NUMBER(3,0) default 1 ';
                CREATEOBJECT(vsql,'alter table '||v_rcsarchive_schema||'.RECORDING add REDUNDANCY_COUNT NUMBER(3,0) default 1 ');
            end if;

            if is_column_exists(v_rcsarchive_schema, 'RECORDING_LOG','SUB_COMPONENT_STATUS') = false then
              vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING_LOG add SUB_COMPONENT_STATUS NUMBER(19,0) NULL ';
              CREATEOBJECT(vsql,'alter table '||v_rcsarchive_schema||'.RECORDING_LOG add SUB_COMPONENT_STATUS NUMBER(19,0) NULL ');
          end if;
          if is_column_exists(v_rcsarchive_schema, 'RECORDING_LOG','SUB_COMPONENT_TYPE') = false then
              vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING_LOG add SUB_COMPONENT_TYPE NVARCHAR2(256) ';
              CREATEOBJECT(vsql,'alter table '||v_rcsarchive_schema||'.RECORDING_LOG add SUB_COMPONENT_TYPE NVARCHAR2(256) ');
          end if;

          if is_column_exists(v_rcsarchive_schema, 'RECORDING_LOG','SUB_COMPONENT_ID') = false then
              vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING_LOG add SUB_COMPONENT_ID NVARCHAR2(256) ';
              CREATEOBJECT(vsql,'alter table '||v_rcsarchive_schema||'.RECORDING_LOG add SUB_COMPONENT_TYPE NVARCHAR2(256) ');
          end if;

          if is_column_exists(v_rcsarchive_schema, 'RECORDING','WARNING') = false then
              vsql := 'alter table '||v_rcsarchive_schema||'.RECORDING add WARNING NUMBER(1,0) DEFAULT 0 ';
              createobject(vsql,'alter TABLE RECORDING');
          end if;

      end if;
        if vrcsarchivedbver < '4.0.000.2' and vrcsdbver >= '4.0.000.2' then

            vsql := 'UPDATE '||v_rcsarchive_schema||'.RECORDING SET STATUS_CODE=216 WHERE STATUS_CODE=202';
           CREATEOBJECT(vsql,'UPDATE RECORDING');

           vsql := 'UPDATE '||v_rcsarchive_schema||'.RECORDING SET STATUS_CODE=221 WHERE STATUS_CODE=203';
           CREATEOBJECT(vsql,'UPDATE RECORDING');

           vsql := 'UPDATE '||v_rcsarchive_schema||'.RECORDING SET STATUS_CODE=223 WHERE STATUS_CODE=205';
           CREATEOBJECT(vsql,'UPDATE RECORDING');

           vsql := 'UPDATE '||v_rcsarchive_schema||'.RECORDING SET STATUS_CODE=214 WHERE STATUS_CODE=206';
           CREATEOBJECT(vsql,'UPDATE RECORDING');

           vsql := 'UPDATE '||v_rcsarchive_schema||'.RECORDING SET STATUS_CODE=225 WHERE STATUS_CODE=505';
           CREATEOBJECT(vsql,'UPDATE RECORDING');

           vsql := 'UPDATE '||v_rcsarchive_schema||'.RECORDING SET STATUS_CODE=223 WHERE STATUS_CODE=501';
           createobject(vsql,'UPDATE RECORDING');

        end if;

      end if; --

--      if v_isUpgradedFrom32 = 'TRUE' THEN
--          execute immediate 'select count(1) from dba_tab_partitions where table_name=''SCHEDULE'' and table_owner='||vschema  into vcount;
--
--          if vcount > 0 then
--              execute immediate 'select count(1) from dba_tab_partitions where table_name=''RECORDING'' and table_owner='||vschema  into vcount;
--               if vcount = 0 then
--                    -- doPartitioningAfterUpgrade();
--                    select 1+1 into vcount from dual;
--               end if;
--          end if;
--
--      end if;

    vsql := ' update '||vschema||'.config_setting set VALUE = '''||vrcsdbver||''', UPDATE_DATE = current_timestamp where KEY = ''archivedb_version''';
		CREATEOBJECT(vsql,' Updating the RCS Archive DB version ');

    vsql := 'INSERT INTO install_Table values(sysdate,''Upgrade to RCS DB Archive Version '||vrcsdbver||' completed SUCCESSFULLY.'')';
    CREATEOBJECT(VSQL,'insert into install_table');

    execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;

      vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
    values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''Upgrade to RCS DB Archive Version '||vrcsdbver||' completed SUCCESSFULLY.'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
    CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');

     commit;

       EXCEPTION
    when others then
    	rollback;
	  execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(sqlerrm,'''')||''')';
    	commit;
    	execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
        vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
        values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 1, 3, ''RCS'', ''Upgrade to RCS DB Archive Version '||vrcsdbver||' is failed. Please contact the Administrator '', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
        CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');
      commit;

	end upgradeRCSArchiveDB;

    procedure archivepartition (vpartition_name varchar2) is
  vrcsdbver  varchar2(100);
  partition_count number(5);
  records_count number;
  min_start_time RCS.SCHEDULE.START_TIME%type;
  max_start_time RCS.SCHEDULE.START_TIME%type;
  begin
      select count(1) into partition_count from dba_tab_partitions where table_owner='RCS' and table_name='ALARM_ACTIVITYLOG' and partition_name = upper( vpartition_name);
         if (partition_count > 0 ) then
             execute immediate '  select count(1) from '||vschema||'.ALARM_ACTIVITYLOG partition ("'||upper(vpartition_name)||'")' into records_count;
                if (records_count > 0 ) then
                      -- execute the archive
                      execute immediate 'select min(create_date), max(create_date) from '||vschema||'.ALARM_ACTIVITYLOG partition ("'||upper(vpartition_name)||'")' into min_start_time, max_start_time;

                VSQL := ' merge into '||V_RCSARCHIVE_SCHEMA||'.ALARM_ACTIVITYLOG aa1
                          using (  select rec.* from '||VSCHEMA||'.ALARM_ACTIVITYLOG rec  where
                         create_date_vir between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS')||''',''DD-MON-YYYY HH24:MI:SS'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS')||''',''DD-MON-YYYY HH24:MI:SS'')
                         ) aa2 on (aa1.id = aa2.id)

                         when not matched then

                         insert (aa1.ID,aa1.TYPE,aa1.SEVERITY,aa1.COMPONENT,aa1.DESCRIPTION,aa1.REFERENCE_ID,aa1.EVENT_NAME,aa1.ACKNOWLEDGED,
                         aa1.CREATED_BY,aa1.UPDATED_BY,aa1.CREATE_DATE,aa1.UPDATE_DATE,aa1.ERROR_CODE)
                         values
                         (aa2.ID,aa2.TYPE,aa2.SEVERITY,aa2.COMPONENT,aa2.DESCRIPTION,aa2.REFERENCE_ID,
                         aa2.EVENT_NAME,aa2.ACKNOWLEDGED,
                         aa2.CREATED_BY,aa2.UPDATED_BY,aa2.CREATE_DATE,aa2.UPDATE_DATE,aa2.ERROR_CODE) ';

                      createobject (vsql, 'insert into   ALARM_ACTIVITYLOG');

              VSQL := ' delete from '||VSCHEMA||'.ALARM_ACTIVITYLOG  where
                         create_date_vir between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS')||''',''DD-MON-YYYY HH24:MI:SS'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS')||''',''DD-MON-YYYY HH24:MI:SS'')
                         ';
                  createobject (vsql, 'delete  ALARM_ACTIVITYLOG');

                commit;
                end if;
         end if;

    -- archive alarm_activitylog table data

  end archivePartition;



  procedure archiverecssubpartition (vpartition_name varchar2) is
  vrcsdbver  varchar2(100);
  vsubpartition_name varchar2(100);
  partition_count number(5);
  records_count number;
  min_start_time RCS.SCHEDULE.START_TIME%type;
  max_start_time RCS.SCHEDULE.START_TIME%type;
   begin
    --  schedule related data
      vsubpartition_name := vpartition_name||'_RECS';
       select count(1) into partition_count from dba_tab_subpartitions where table_owner='RCS' and table_name='SCHEDULE' and subpartition_name = upper( vsubpartition_name);
         if (partition_count > 0 ) then
             execute immediate '  select count(1) from '||vschema||'.SCHEDULE subpartition ("'||upper(vsubpartition_name)||'")' into records_count;
                if (records_count >0 ) then
                  -- execute the archive
              -- Playback_window_restrictions
                  execute immediate 'select min(start_time), max(start_time) from '||vschema||'.SCHEDULE subpartition ("'||vsubpartition_name||'")' into min_start_time, max_start_time;
--
                -- RCS to RCSArchive

               -- SCHEDULE
               VSQL := ' merge into '||V_RCSARCHIVE_SCHEMA||'.SCHEDULE dsch
                  using ( select * from '||VSCHEMA||'.SCHEDULE
                          where  recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')

                        )

                        ssch on (dsch.schedule_id = ssch.schedule_id)
            when not matched then
          insert (dsch.schedule_id,
          dsch.SCHEDULE_LANGUAGE,
          dsch.STATION_ID,
          dsch.PROGRAM_ID,
          dsch.START_TIME,
          dsch.END_TIME,
          dsch.DURATION,
          dsch.TV_RATING,
          dsch.HD_TV,
          dsch.PART_NUMBER,
          dsch.NO_OF_PARTS,
          dsch.CC,
          dsch.STEREO,
          dsch.LIVE_TAPE_DELAY,
          dsch.SUBTITLED,
          dsch.PREMIERE_FINALE,
          dsch.JOINED_IN_PROGRESS,
          dsch.CABLE_IN_CLASSROOM,
          dsch.SAP,
          dsch.SEX_RATING,
          dsch.VIOLENCE_RATING,
          dsch.LANGUAGE_RATING,
          dsch.DIALOG_RATING,
          dsch.FV_RATING,
          dsch.ENHANCED,
          dsch.THREE_D,
          dsch.LETTERBOX,
          dsch.DVS,
          dsch.series_link,
          dsch.REQUEST_RECORD,
          dsch.REPEAT,
          dsch.BLACKOUT,
          dsch.DOLBY,
          dsch.USER_DATA1,
          dsch.USER_DATA2,
          dsch.USER_DATA3,
          dsch.USER_DATA4,
          dsch.USER_DATA5,
          dsch.USER_DATA6,
          dsch.USER_DATA7,
          dsch.USER_DATA8,
          dsch.USER_DATA9,
          dsch.USER_DATA10,
          dsch.USER_DATA11,
          dsch.SCHEDULE_GENERIC,
          dsch.CREATED_BY,
          dsch.UPDATED_BY,
          dsch.CREATE_date,
          dsch.UPDATE_date
          )
          values
          (ssch.schedule_id,
          ssch.SCHEDULE_LANGUAGE,
          ssch.STATION_ID,
          ssch.PROGRAM_ID,
          ssch.START_TIME,
          ssch.END_TIME,
          ssch.DURATION,
          ssch.TV_RATING,
          ssch.HD_TV,
          ssch.PART_NUMBER,
          ssch.NO_OF_PARTS,
          ssch.CC,
          ssch.STEREO,
          ssch.LIVE_TAPE_DELAY,
          ssch.SUBTITLED,
          ssch.PREMIERE_FINALE,
          ssch.JOINED_IN_PROGRESS,
          ssch.CABLE_IN_CLASSROOM,
          ssch.SAP,
          ssch.SEX_RATING,
          ssch.VIOLENCE_RATING,
          ssch.LANGUAGE_RATING,
          ssch.DIALOG_RATING,
          ssch.FV_RATING,
          ssch.ENHANCED,
          ssch.THREE_D,
          ssch.LETTERBOX,
          ssch.DVS,
          ssch.series_link,
          ssch.REQUEST_RECORD,
          ssch.REPEAT,
          ssch.BLACKOUT,
          ssch.DOLBY,
          ssch.USER_DATA1,
          ssch.USER_DATA2,
          ssch.USER_DATA3,
          ssch.USER_DATA4,
          ssch.USER_DATA5,
          ssch.USER_DATA6,
          ssch.USER_DATA7,
          ssch.USER_DATA8,
          ssch.USER_DATA9,
          ssch.USER_DATA10,
          ssch.USER_DATA11,
          ssch.SCHEDULE_GENERIC,
          ssch.CREATED_BY,
          ssch.UPDATED_BY,
          ssch.CREATE_date,
          ssch.UPDATE_date
          )';
          createobject(vsql, 'merge schedule');

          VSQL :=' MERGE INTO '||v_rcsarchive_schema||'.RIGHT_RM_MAP RRM1 USING '||VSCHEMA||'.RIGHT_RM_MAP RRM2 ON (RRM1.RIGHT_ID= RRM2.RIGHT_ID AND RRM1.RM_ID = RRM2.RM_ID)
                WHEN NOT MATCHED THEN
                INSERT (RRM1.RIGHT_ID, RRM1.RM_ID, RRM1.CREATED_BY, RRM1.UPDATED_BY, RRM1.CREATE_DATE, RRM1.UPDATE_DATE)
                VALUES (RRM2.RIGHT_ID, RRM2.RM_ID, RRM2.CREATED_BY, RRM2.UPDATED_BY, RRM2.CREATE_DATE, RRM2.UPDATE_DATE) ';

           CREATEOBJECT (VSQL, 'MERGE into   RIGHT_RM_MAP');

               -- RECORDABLE_RIGHTS_MAP
            vsql := ' insert into '||v_rcsarchive_schema||'.RECORDABLE_RIGHTS_MAP select rec.* from '||vschema||'.RECORDABLE_RIGHTS_MAP rec
                        where rec.schedule_id in
                      (
                      select schedule_id from '||vschema||'.schedule where  recordable =1 and  start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
           createobject (vsql, 'insert into   RECORDABLE_RIGHTS_MAP');

            vsql := 'delete from '||vschema||'.RECORDABLE_RIGHTS_MAP rec
                        where rec.schedule_id in
                      (
                      select schedule_id from '||vschema||'.schedule where  recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          CREATEOBJECT (VSQL, 'delete from RECORDABLE_RIGHTS_MAP');

                        --RECORDING
            VSQL := ' insert into '||V_RCSARCHIVE_SCHEMA||'.RECORDING select rec.* from '||VSCHEMA||'.RECORDING rec
                        where  rec.schedule_id in
                       (
                       select schedule_id from '||vschema||'.schedule where recordable =1 and  start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
           CREATEOBJECT (VSQL, 'insert into   RECORDING');

          vsql := ' insert into '||v_rcsarchive_schema||'.rec_trial_use_fields select rtuf.* from '||vschema||'.rec_trial_use_fields rtuf
                      join '||vschema||'.recording rec on (rtuf.recording_id = rec.recording_id) where rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
         createobject (vsql, 'insert into   rec_trial_use_fields');

         VSQL := 'delete from '||VSCHEMA||'.rec_trial_use_fields rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where  recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )
                  )';
        createobject (vsql, 'delete from rec_trial_use_fields');

         vsql := ' insert into '||v_rcsarchive_schema||'.RECORDING_REC_RULES_MAP select rtuf.* from '||vschema||'.RECORDING_REC_RULES_MAP rtuf
                      join '||vschema||'.recording rec on (rtuf.recording_id = rec.recording_id) where rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
         createobject (vsql, 'insert into   RECORDING_REC_RULES_MAP');

         VSQL := 'delete from '||VSCHEMA||'.RECORDING_REC_RULES_MAP rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where recordable =1 and  start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )
                  )';
        createobject (vsql, 'delete from RECORDING_REC_RULES_MAP');

        vsql := ' insert into '||v_rcsarchive_schema||'.RECORDING_LOG select rtuf.* from '||vschema||'.RECORDING_LOG rtuf
                      join '||vschema||'.recording rec on (rtuf.recording_id = rec.recording_id) where rec.schedule_id in
                   (
                   select schedule_id from '||vschema||'.schedule where recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
         createobject (vsql, 'insert into   RECORDING_LOG');

         VSQL := 'delete from '||VSCHEMA||'.RECORDING_LOG rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                     )
                  )';
        createobject (vsql, 'delete from RECORDING_LOG');

         vsql := ' merge into '||v_rcsarchive_schema||'.playback_window_restrictions rapwr using

                          (select pwr.* from '||vschema||'.playback_window_restrictions pwr join '||vschema||'.recording rec on (rec.recording_id = pwr.recording_id)
                          where schedule_id in (
                                  select schedule_id from '||vschema||'.schedule where recordable =1 and  start_time between
                                 to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                                 to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')

                          ))  rpwr on (rapwr.restriction_id = rpwr.restriction_id)
                           when not matched then
                            insert( RESTRICTION_ID,
                                                START_TIME,
                                                DURATION,
                                                RESTRICTIONS,
                                                TYPE,
                                                CREATED_BY,
                                                UPDATED_BY,
                                                CREATE_DATE,
                                                UPDATE_DATE,
                                                RIGHT_ID,
                                                RECORDING_ID)
                        values ( rpwr.RESTRICTION_ID,
                                        rpwr.start_time,
                                                rpwr.duration,
                                                rpwr.restrictions,
                                                rpwr.type,
                                                ''SYSTEM'',
                                                ''SYSTEM'',
                                                current_timestamp,
                                                current_timestamp,
                                                 null,
                                                 rpwr.recording_id
                              )';

                    createobject (vsql, 'merge playback_window_restrictions');

              VSQL := ' delete from '||VSCHEMA||'.playback_window_restrictions where recording_id in
                        ( select recording_id from '||VSCHEMA||'.recording rec
                        where schedule_id in (
                        select schedule_id from '||vschema||'.schedule where recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      ) )';

              CREATEOBJECT (VSQL, 'delete playback_window_restrictions');


           vsql := 'delete from '||vschema||'.RECORDING rec
                        where rec.schedule_id in
                      (
                      select schedule_id from '||vschema||'.schedule where recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          createobject (vsql, 'delete from RECORDING');


         VSQL := 'delete from  '||vschema||'.schedule where recordable =1 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')';

         CREATEOBJECT (VSQL, 'delete from RECORDING');

                end if;
         END IF;

  end archiverecssubpartition;

  procedure archivenonrecssubpartition (vpartition_name varchar2) is
  vrcsdbver  varchar2(100);
  vsubpartition_name varchar2(100);
  partition_count number(5);
  records_count number;
  MIN_START_TIME RCS.SCHEDULE.START_TIME%type;
  max_start_time RCS.SCHEDULE.START_TIME%type;
   begin
    -- only schedule data
      vsubpartition_name := vpartition_name||'_NON_RECS';
       select count(1) into partition_count from dba_tab_subpartitions where table_owner='RCS' and table_name='SCHEDULE' and subpartition_name = upper( vsubpartition_name);
         if (partition_count >=1 ) then
             execute immediate '  select count(1) from '||vschema||'.SCHEDULE subpartition ("'||upper(vsubpartition_name)||'")' into records_count;
                if (records_count >0 ) then
                     -- execute the archive
                        execute immediate 'select min(start_time), max(start_time) from '||vschema||'.SCHEDULE subpartition ("'||vsubpartition_name||'")' into min_start_time, max_start_time;
                       -- only non_recordables, only schedule table
                                      VSQL := ' merge into '||V_RCSARCHIVE_SCHEMA||'.SCHEDULE dsch
                  using ( select * from '||VSCHEMA||'.SCHEDULE
                          where recordable = 0 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')

                        )

                        ssch on (dsch.schedule_id = ssch.schedule_id)
            when not matched then
          insert (dsch.schedule_id,
          dsch.SCHEDULE_LANGUAGE,
          dsch.STATION_ID,
          dsch.PROGRAM_ID,
          dsch.START_TIME,
          dsch.END_TIME,
          dsch.DURATION,
          dsch.TV_RATING,
          dsch.HD_TV,
          dsch.PART_NUMBER,
          dsch.NO_OF_PARTS,
          dsch.CC,
          dsch.STEREO,
          dsch.LIVE_TAPE_DELAY,
          dsch.SUBTITLED,
          dsch.PREMIERE_FINALE,
          dsch.JOINED_IN_PROGRESS,
          dsch.CABLE_IN_CLASSROOM,
          dsch.SAP,
          dsch.SEX_RATING,
          dsch.VIOLENCE_RATING,
          dsch.LANGUAGE_RATING,
          dsch.DIALOG_RATING,
          dsch.FV_RATING,
          dsch.ENHANCED,
          dsch.THREE_D,
          dsch.LETTERBOX,
          dsch.DVS,
          dsch.series_link,
          dsch.REQUEST_RECORD,
          dsch.REPEAT,
          dsch.BLACKOUT,
          dsch.DOLBY,
          dsch.USER_DATA1,
          dsch.USER_DATA2,
          dsch.USER_DATA3,
          dsch.USER_DATA4,
          dsch.USER_DATA5,
          dsch.USER_DATA6,
          dsch.USER_DATA7,
          dsch.USER_DATA8,
          dsch.USER_DATA9,
          dsch.USER_DATA10,
          dsch.USER_DATA11,
          dsch.SCHEDULE_GENERIC,
          dsch.CREATED_BY,
          dsch.UPDATED_BY,
          dsch.CREATE_date,
          dsch.UPDATE_date
          )
          values
          (ssch.schedule_id,
          ssch.SCHEDULE_LANGUAGE,
          ssch.STATION_ID,
          ssch.PROGRAM_ID,
          ssch.START_TIME,
          ssch.END_TIME,
          ssch.DURATION,
          ssch.TV_RATING,
          ssch.HD_TV,
          ssch.PART_NUMBER,
          ssch.NO_OF_PARTS,
          ssch.CC,
          ssch.STEREO,
          ssch.LIVE_TAPE_DELAY,
          ssch.SUBTITLED,
          ssch.PREMIERE_FINALE,
          ssch.JOINED_IN_PROGRESS,
          ssch.CABLE_IN_CLASSROOM,
          ssch.SAP,
          ssch.SEX_RATING,
          ssch.VIOLENCE_RATING,
          ssch.LANGUAGE_RATING,
          ssch.DIALOG_RATING,
          ssch.FV_RATING,
          ssch.ENHANCED,
          ssch.THREE_D,
          ssch.LETTERBOX,
          ssch.DVS,
          ssch.series_link,
          ssch.REQUEST_RECORD,
          ssch.REPEAT,
          ssch.BLACKOUT,
          ssch.DOLBY,
          ssch.USER_DATA1,
          ssch.USER_DATA2,
          ssch.USER_DATA3,
          ssch.USER_DATA4,
          ssch.USER_DATA5,
          ssch.USER_DATA6,
          ssch.USER_DATA7,
          ssch.USER_DATA8,
          ssch.USER_DATA9,
          ssch.USER_DATA10,
          ssch.USER_DATA11,
          ssch.SCHEDULE_GENERIC,
          ssch.CREATED_BY,
          ssch.UPDATED_BY,
          ssch.CREATE_date,
          ssch.UPDATE_date
          )';
          createobject(vsql, 'merge schedule');

          vsql := 'delete from '||vschema||'.RECORDABLE_RIGHTS_MAP rec
                        where rec.schedule_id in
                      (
                      select schedule_id from '||vschema||'.schedule where  recordable =0 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          CREATEOBJECT (VSQL, 'delete from RECORDABLE_RIGHTS_MAP');


         VSQL := 'delete from '||VSCHEMA||'.rec_trial_use_fields rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where  recordable =0 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )
                  )';
        createobject (vsql, 'delete from rec_trial_use_fields');



         VSQL := 'delete from '||VSCHEMA||'.RECORDING_REC_RULES_MAP rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where recordable =0 and  start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )
                  )';
        createobject (vsql, 'delete from RECORDING_REC_RULES_MAP');


         VSQL := 'delete from '||VSCHEMA||'.RECORDING_LOG rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (
                    select schedule_id from '||vschema||'.schedule where recordable =0 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                     )
                  )';
        createobject (vsql, 'delete from RECORDING_LOG');

           VSQL := ' delete from '||VSCHEMA||'.playback_window_restrictions where recording_id in
                        ( select recording_id from '||VSCHEMA||'.recording rec
                        where schedule_id in (
                        select schedule_id from '||vschema||'.schedule where recordable =0 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      ) )';

              CREATEOBJECT (VSQL, 'delete playback_window_restrictions');


           vsql := 'delete from '||vschema||'.RECORDING rec
                        where rec.schedule_id in
                      (
                      select schedule_id from '||vschema||'.schedule where recordable =0 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          createobject (vsql, 'delete from RECORDING');


           VSQL := ' delete from '||VSCHEMA||'.schedule where recordable = 0 and start_time between
                         to_timestamp_tz('''||to_char(min_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')  and
                         to_timestamp_tz('''||to_char(max_start_time,'DD-MON-YYYY HH24:MI:SS TZR')||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                  ';
           createobject(vsql, 'delete schedule');


           COMMIT;

        end if;
      end if;


  end archivenonrecssubpartition;

	procedure runarchiveonrcsdb is
  v_isPartitionSupported varchar2(30);
  vcount number(5);

  old_data_to_be_archived varchar2(1000) :='NON_RECORDABLES';--'ALL','NON_RECORDABLES';
  old_data_retention_period number(3,0) :=90;-- (15, 30) for new
  vcount1 number(5);
  old_data_retention_to_date date;
  old_data_retention_to_day number(2);
  v_archiveUserCount number :=0;
   temp_date date ;
    no_parts number(1) ;
    vpartition_name varchar2(100);
    vsubpartition_name varchar2(100);
    partition_count number(5);
    records_count number;
	  -- data_to_be_purged=NON_RECORDABLES
  begin
  
  	 execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
	 
	 vsql := 'alter session set time_zone='''||TIMEZONE||'''';
	 CREATEOBJECT(vsql,' Setting up the timezone with the non-offset value');

    -- check for RCSArchive user , if RCSARCHIVE does not exist, just exit from the proc
    SELECT COUNT(1)
        INTO 	v_archiveUserCount
      FROM 	dba_tables
      WHERE	OWNER = upper(v_rcsarchive_schema);

     if  v_archiveusercount = 0 then
        -- write the log message
          
					
        	insert into INSTALL_TABLE(MSGDATE, INSTALL_MESSAGE) values (sysdate, 'RCSArchive DB is not yet confiured. Please install TSTV RCS Archive DB first and then run Archive. Please contact the administrator');
          vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
          values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 1, 3, ''RCS'', '' RCSArchive DB is not yet configured. Please install TSTV RCS Archive DB first and then run Archive. Please contact the administrator'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
          CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');

        return;
     end if;
	
	vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
    values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''Archiving is started on RCS DB'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
    CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');
  
    commit;

   execute immediate 'SELECT count(1) from '||vschema||'.config_setting where UPPER(key)=UPPER(''old_data_to_be_archived'')'  into vcount1;
   IF (VCOUNT1 > 0 ) THEN
      execute immediate 'SELECT value from '||vschema||'.config_setting where UPPER(key)=UPPER(''old_data_to_be_archived'')'  into old_data_to_be_archived;
   end if;

   execute immediate 'SELECT count(1) from '||vschema||'.config_setting where UPPER(key)=UPPER(''old_data_retention_period'')'  into vcount1;
   IF (VCOUNT1 > 0 ) THEN
      execute immediate 'SELECT value from '||vschema||'.config_setting where UPPER(key)=UPPER(''old_data_retention_period'')'  into old_data_retention_period;
   END IF;
  select (TO_DATE(TO_CHAR(sysdate,'MM-DD-YYYY'),'MM-DD-YYYY') - old_data_retention_period) into old_data_retention_to_date  from dual;
  execute immediate ' select count(1) from dba_tab_subpartitions where table_owner='''||vschema||''' and table_name=''SCHEDULE''' into vcount1;

   if (vcount1 > 0 ) then

  -- partition based archivingd
           -- DROP THE TEMP TABLES
--           vsql := ' drop table '|| vschema || '.SCHEDULE_TEMP CASCADE CONSTRAINTS  PURGE';
--           createobject(vsql,vsql,'Y');
--           vsql := ' drop table '|| vschema || '.RECORDABLE_RIGHTS_MAP_TEMP CASCADE CONSTRAINTS  PURGE';
--           createobject(vsql,vsql,'Y');
--           vsql := ' drop table '|| vschema || '.RECORDING_TEMP  CASCADE CONSTRAINTS  PURGE';
--           createobject(vsql,vsql,'Y');
--           vsql := ' drop table '|| vschema || '.RECORDING_LOG_TEMP CASCADE CONSTRAINTS  PURGE';
--           createobject(vsql,vsql,'Y');
--           vsql := ' drop table '|| vschema || '.REC_TRIAL_USE_FIELDS_TEMP CASCADE CONSTRAINTS  PURGE';
--           createobject(vsql,vsql,'Y');
--           vsql := ' drop table '|| vschema || '.RECORDING_REC_RULES_MAP_TEMP  CASCADE CONSTRAINTS  PURGE';
--           createobject(vsql,vsql,'Y');
--           vsql := ' drop table '|| vschema || '.ALARM_ACTIVITYLOG_TEMP CASCADE CONSTRAINTS  PURGE';
--           CREATEOBJECT(vsql,vsql,'Y');
--
--            vsqlclob := get_table_ddl('SCHEDULE', 'RCS');
--            select replace(replace (replace(replace(vsqlclob, '"RCS"."SCHEDULE"', '"RCS"."SCHEDULE_TEMP"' ), 'FK_STATION_SCHEDULE', 'FK_STATION_SCHEDULE1' ), 'PK_SCHEDULE', 'PK_SCHEDULE1'), 'FK_SCHEDULE_PROGRAM', 'FK_SCHEDULE_PROGRAM1') into vsqlclob from dual;
----            vsqlclob := vsqlclob || ' nologging';
--            CREATEOBJECT(vsqlclob,'Creating a SCHEDULE_TEMP table from SCHEDULE');
--
--
--            vsqlclob := get_table_ddl('RECORDABLE_RIGHTS_MAP', 'RCS');
--            select replace(replace (replace(replace(vsqlclob, '"RCS"."RECORDABLE_RIGHTS_MAP"', '"RCS"."RECORDABLE_RIGHTS_MAP_TEMP"' ), 'RECORDABLE_RIGHTS_MAP_PK', 'RECORDABLE_RIGHTS_MAP_PK1' ), 'FK_REC_RIGHTS_MAP_SCH', 'FK_REC_RIGHTS_MAP_SCH1'), 'FK_REC_RIGHTS_MAP_RIGHT', 'FK_REC_RIGHTS_MAP_RIGHT1') into vsqlclob from dual;
----            vsqlclob := vsqlclob || ' nologging';
--            CREATEOBJECT(vsqlclob,'Creating a RECORDABLE_RIGHTS_MAP_TEMP table from RECORDABLE_RIGHTS_MAP');
--
--
--            vsqlclob := get_table_ddl('RECORDING', 'RCS');
--            select replace(replace(replace (replace(replace(vsqlclob, '"RCS"."RECORDING"', '"RCS"."RECORDING_TEMP"' ) ,'PK_RECORDING', 'PK_RECORDING1' ), 'RECORDING_UK0', 'RECORDING_UK01'), 'FK_RECORDING_SCHEDULE', 'FK_RECORDING_SCHEDULE1'), 'FK_RECORDING_POOL_ID','FK_RECORDING_POOL_ID1') into vsqlclob from dual;
----            vsqlclob := vsqlclob || ' nologging';
--            CREATEOBJECT(vsqlclob,'Creating a RECORDING_temp table from RECORDING');
--
--            vsqlclob := get_table_ddl('RECORDING_LOG', 'RCS');
--            select replace (replace(replace(VSQLCLOB, '"RCS"."RECORDING_LOG"', '"RCS"."RECORDING_LOG_TEMP"' ), 'PK_RECORDING_LOG', 'PK_RECORDING_LOG1' ), 'FK_REC_LOG_RECORDING', 'FK_REC_LOG_RECORDING1') into VSQLCLOB from DUAL;
----            vsqlclob := vsqlclob || ' nologging';
--            CREATEOBJECT(vsqlclob,'Creating  RECORDING_LOG_TEMP table from RECORDING_LOG');
--
--
--            vsqlclob := get_table_ddl('REC_TRIAL_USE_FIELDS', 'RCS');
--            select replace(replace(replace(replace(vsqlclob, '"RCS"."REC_TRIAL_USE_FIELDS"', '"RCS"."REC_TRIAL_USE_FIELDS_TEMP"' ),
--            'PK_REC_TRIAL_USE_FIELDS', 'PK_REC_TRIAL_USE_FIELDS1' )
--            , 'REC_TRIAL_USE_ENTITY_MAP_FK', 'REC_TRIAL_USE_ENTITY_MAP_FK1'),
--            'REC_TRIAL_USE_RECORDING_FK','REC_TRIAL_USE_RECORDING_FK1')
--            into VSQLCLOB from DUAL;
----            vsqlclob := vsqlclob || ' nologging';
--            CREATEOBJECT(vsqlclob,'Creating  REC_TRIAL_USE_FIELDS_TEMP table from REC_TRIAL_USE_FIELDS');
--
--            vsqlclob := get_table_ddl('RECORDING_REC_RULES_MAP', 'RCS');
--            select REPLACE(replace(replace(replace(VSQLCLOB, '"RCS"."RECORDING_REC_RULES_MAP"', '"RCS"."RECORDING_REC_RULES_MAP_TEMP"' ), 'RECORDING_REC_RULES_MAP_PK', 'RECORDING_REC_RULES_MAP_PK1' ), 'REC_RULES_FK', 'REC_RULES_FK1'),'FK_REC_REC_RULES_MAP','FK_REC_REC_RULES_MAP1') into VSQLCLOB from DUAL;
----            vsqlclob := vsqlclob || ' nologging';
--            createobject(vsqlclob,'Creating  REC_TRIAL_USE_FIELDS_TEMP table from REC_TRIAL_USE_FIELDS');
--
--            vsqlclob := get_table_ddl('ALARM_ACTIVITYLOG', 'RCS');
--            select replace(replace (replace(replace(vsqlclob, '"RCS"."ALARM_ACTIVITYLOG"', '"RCS"."ALARM_ACTIVITYLOG_TEMP"' ) ,'PK_ALARM_ACTIVITYLOG', 'PK_ALARM_ACTIVITYLOG1' ), 'ALARM_ERR_CODE_FK', 'ALARM_ERR_CODE_FK1'), 'FK_ALARM_SELF', 'FK_ALARM_SELF1') into vsqlclob from dual;
----            vsqlclob := vsqlclob || ' nologging';
--            CREATEOBJECT(vsqlclob,'Creating a ALARM_ACTIVITYLOG_TEMP table from ALARM_ACTIVITYLOG');

        -- all old schedule related data
            select to_number(to_char(old_data_retention_to_date, 'dd')) into  old_data_retention_to_day from dual;

     -- get the partition information
     --
     vpartition_name :='BEFORE_1_'||to_char(old_data_retention_to_date, 'MON')||'_'||to_char(old_data_retention_to_date, 'yy');
     ARCHIVENONRECSSUBPARTITION(VPARTITION_NAME);

     if (upper(trim(old_data_to_be_archived)) ='ALL' ) then
        archiverecssubpartition(vpartition_name);
     end if;
     archivepartition(upper(vpartition_name));
     if (old_data_retention_to_day >= 16) then
         vpartition_name := 'BEFORE_16_'||to_char(old_data_retention_to_date, 'MON')||'_'||to_char(old_data_retention_to_date, 'yy');
         archivenonrecssubpartition(vpartition_name);
          if (upper(trim(old_data_to_be_archived)) ='ALL' ) then
            archiverecssubpartition(vpartition_name);
          end if;
         archivepartition(upper(vpartition_name));
    end if;
    temp_date := to_date ('1-'||to_char(old_data_retention_to_date , 'mm-yyyy'), 'dd-mm-yyyy');
    loop
      TEMP_DATE := ADD_MONTHS(TEMP_DATE, -1);
      vpartition_name := 'BEFORE_1_'||to_char(temp_date, 'MON')||'_'||to_char(temp_date, 'YY');

      select count(1) into partition_count from dba_tab_partitions where table_owner='RCS' and table_name='SCHEDULE' and partition_name = upper( vpartition_name);
       if (partition_count > 0 ) then
         archivenonrecssubpartition(vpartition_name);
         if (upper(trim(old_data_to_be_archived)) ='ALL' ) then
            archiverecssubpartition(vpartition_name);
          end if;
         archivepartition(upper(vpartition_name));
       else
            exit;
       end if;
      vpartition_name := 'BEFORE_16_'||to_char(temp_date, 'MON')||'_'||to_char(temp_date, 'YY');
      select count(1) into partition_count from dba_tab_partitions where table_owner='RCS' and table_name='SCHEDULE' and partition_name = upper( vpartition_name);
       if (partition_count > 0 ) then
         archivenonrecssubpartition(vpartition_name);
         if (upper(trim(old_data_to_be_archived)) ='ALL' ) then
            archiverecssubpartition(vpartition_name);
          end if;
         archivepartition(upper(vpartition_name));
       else
            exit;
       end if;
    end loop;


  else
      -- non_partition based archiving
     if (upper(trim(old_data_to_be_archived)) ='ALL' ) then


              -- SCHEDULE
              vsql := ' merge into '||v_rcsarchive_schema||'.SCHEDULE dsch
                  using (select sch.* from '||vschema||'.SCHEDULE sch where
                            sch.start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                        )    ssch on (dsch.schedule_id = ssch.schedule_id)
            when not matched then
          insert (dsch.schedule_id,
          dsch.SCHEDULE_LANGUAGE,
          dsch.STATION_ID,
          dsch.PROGRAM_ID,
          dsch.START_TIME,
          dsch.END_TIME,
          dsch.DURATION,
          dsch.TV_RATING,
          dsch.HD_TV,
          dsch.PART_NUMBER,
          dsch.NO_OF_PARTS,
          dsch.CC,
          dsch.STEREO,
          dsch.LIVE_TAPE_DELAY,
          dsch.SUBTITLED,
          dsch.PREMIERE_FINALE,
          dsch.JOINED_IN_PROGRESS,
          dsch.CABLE_IN_CLASSROOM,
          dsch.SAP,
          dsch.SEX_RATING,
          dsch.VIOLENCE_RATING,
          dsch.LANGUAGE_RATING,
          dsch.DIALOG_RATING,
          dsch.FV_RATING,
          dsch.ENHANCED,
          dsch.THREE_D,
          dsch.LETTERBOX,
          dsch.DVS,
          dsch.series_link,
          dsch.REQUEST_RECORD,
          dsch.REPEAT,
          dsch.BLACKOUT,
          dsch.DOLBY,
          dsch.USER_DATA1,
          dsch.USER_DATA2,
          dsch.USER_DATA3,
          dsch.USER_DATA4,
          dsch.USER_DATA5,
          dsch.USER_DATA6,
          dsch.USER_DATA7,
          dsch.USER_DATA8,
          dsch.USER_DATA9,
          dsch.USER_DATA10,
          dsch.USER_DATA11,
          dsch.SCHEDULE_GENERIC,
          dsch.CREATED_BY,
          dsch.UPDATED_BY,
          dsch.CREATE_date,
          dsch.UPDATE_date
          )
          values
          (ssch.schedule_id,
          ssch.SCHEDULE_LANGUAGE,
          ssch.STATION_ID,
          ssch.PROGRAM_ID,
          ssch.START_TIME,
          ssch.END_TIME,
          ssch.DURATION,
          ssch.TV_RATING,
          ssch.HD_TV,
          ssch.PART_NUMBER,
          ssch.NO_OF_PARTS,
          ssch.CC,
          ssch.STEREO,
          ssch.LIVE_TAPE_DELAY,
          ssch.SUBTITLED,
          ssch.PREMIERE_FINALE,
          ssch.JOINED_IN_PROGRESS,
          ssch.CABLE_IN_CLASSROOM,
          ssch.SAP,
          ssch.SEX_RATING,
          ssch.VIOLENCE_RATING,
          ssch.LANGUAGE_RATING,
          ssch.DIALOG_RATING,
          ssch.FV_RATING,
          ssch.ENHANCED,
          ssch.THREE_D,
          ssch.LETTERBOX,
          ssch.DVS,
          ssch.series_link,
          ssch.REQUEST_RECORD,
          ssch.REPEAT,
          ssch.BLACKOUT,
          ssch.DOLBY,
          ssch.USER_DATA1,
          ssch.USER_DATA2,
          ssch.USER_DATA3,
          ssch.USER_DATA4,
          ssch.USER_DATA5,
          ssch.USER_DATA6,
          ssch.USER_DATA7,
          ssch.USER_DATA8,
          ssch.USER_DATA9,
          ssch.USER_DATA10,
          ssch.USER_DATA11,
          ssch.SCHEDULE_GENERIC,
          ssch.CREATED_BY,
          ssch.UPDATED_BY,
          ssch.CREATE_date,
          ssch.UPDATE_date)';

          CREATEOBJECT (VSQL, 'Merging schedule from RCS to RCSArchive');

       VSQL :=' MERGE INTO '||v_rcsarchive_schema||'.RIGHT_RM_MAP RRM1 USING '||VSCHEMA||'.RIGHT_RM_MAP RRM2 ON (RRM1.RIGHT_ID= RRM2.RIGHT_ID AND RRM1.RM_ID = RRM2.RM_ID)
                WHEN NOT MATCHED THEN
                INSERT (RRM1.RIGHT_ID, RRM1.RM_ID, RRM1.CREATED_BY, RRM1.UPDATED_BY, RRM1.CREATE_DATE, RRM1.UPDATE_DATE)
                VALUES (RRM2.RIGHT_ID, RRM2.RM_ID, RRM2.CREATED_BY, RRM2.UPDATED_BY, RRM2.CREATE_DATE, RRM2.UPDATE_DATE) ';

           CREATEOBJECT (VSQL, 'MERGE into   RIGHT_RM_MAP');

              -- RECORDABLE_RIGHTS_MAP
            vsql := ' insert into '||v_rcsarchive_schema||'.RECORDABLE_RIGHTS_MAP select rec.* from '||vschema||'.RECORDABLE_RIGHTS_MAP rec
                        where rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
           createobject (vsql, 'insert into   RECORDABLE_RIGHTS_MAP');

           vsql := 'delete from '||vschema||'.RECORDABLE_RIGHTS_MAP rec
                        where rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          CREATEOBJECT (VSQL, 'delete from RECORDABLE_RIGHTS_MAP');


                         --RECORDING
            vsql := ' insert into '||v_rcsarchive_schema||'.RECORDING select  DISTINCT rec.* from '||vschema||'.RECORDING rec
                        where rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
           CREATEOBJECT (VSQL, 'insert into   RECORDING');


         vsql := ' insert into '||v_rcsarchive_schema||'.rec_trial_use_fields select rtuf.* from '||vschema||'.rec_trial_use_fields rtuf
                      join '||vschema||'.recording rec on (rtuf.recording_id = rec.recording_id) where rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )';
         createobject (vsql, 'insert into   rec_trial_use_fields');

         VSQL := 'delete from '||VSCHEMA||'.rec_trial_use_fields rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING  rec where  rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )
                  )';
        createobject (vsql, 'delete from rec_trial_use_fields');

         vsql := ' insert into '||v_rcsarchive_schema||'.RECORDING_REC_RULES_MAP select rtuf.* from '||vschema||'.RECORDING_REC_RULES_MAP rtuf
                      join '||vschema||'.recording rec on (rtuf.recording_id = rec.recording_id) where rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )';
         createobject (vsql, 'insert into   RECORDING_REC_RULES_MAP');

         VSQL := 'delete from '||VSCHEMA||'.RECORDING_REC_RULES_MAP rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )
                  )';
        createobject (vsql, 'delete from RECORDING_REC_RULES_MAP');

        vsql := ' insert into '||v_rcsarchive_schema||'.RECORDING_LOG select rtuf.* from '||vschema||'.RECORDING_LOG rtuf
                      join '||vschema||'.recording rec on (rtuf.recording_id = rec.recording_id) where rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )';
         createobject (vsql, 'insert into   RECORDING_LOG');

         VSQL := 'delete from '||VSCHEMA||'.RECORDING_LOG rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )
                  )';
        createobject (vsql, 'delete from RECORDING_LOG');

        if is_table_exists(v_rcsarchive_schema, 'recording_rtc_pool_map') = true then
          vsql := ' insert into '||v_rcsarchive_schema||'.recording_rtc_pool_map select rtuf.* from '||vschema||'.recording_rtc_pool_map rtuf
                        join '||vschema||'.recording rec on (rtuf.recording_id = rec.recording_id) where rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
           createobject (vsql, 'insert into   recording_rtc_pool_map');

           VSQL := 'delete from '||VSCHEMA||'.recording_rtc_pool_map rtuf  where rtuf.recording_id in
                    (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )
                    )';
          createobject (vsql, 'delete from recording_rtc_pool_map');


        end if;

            vsql := ' INSERT into '||v_rcsarchive_schema||'.playback_window_restrictions select pwr.* from '||vschema||'.playback_window_restrictions pwr join '||vschema||'.recording rec on (rec.recording_id = pwr.recording_id)
                          where schedule_id in
                          (
                                  select schedule_id from '||vschema||'.schedule where
                                  start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                          )

                          ';

                    createobject (vsql, 'INSERT playback_window_restrictions');

              VSQL := ' delete from '||VSCHEMA||'.playback_window_restrictions where recording_id in
                        ( select recording_id from '||VSCHEMA||'.recording rec
                         where schedule_id in
                          (
                                  select schedule_id from '||vschema||'.schedule where
                                  start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                          )
                        )';
              CREATEOBJECT (VSQL, 'delete playback_window_restrictions');


           vsql := 'delete from '||vschema||'.RECORDING rec
                        where rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          createobject (vsql, 'delete from RECORDING');



          vsql := ' delete from '||vschema||'.SCHEDULE  where
                            start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')';

          createobject (vsql, 'Deleting schedule from RCS ');

              --ALARM_ACTIVITYLOG
          vsql := ' insert into '||v_rcsarchive_schema||'.ALARM_ACTIVITYLOG select aal.* from '||vschema||'.ALARM_ACTIVITYLOG aal
                      where aal.create_date < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    ';
         createobject (vsql, 'insert into   ALARM_ACTIVITYLOG');

         vsql := 'delete from '||vschema||'.ALARM_ACTIVITYLOG aal where
                      aal.create_date < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    ';
        createobject (vsql, 'delete from ALARM_ACTIVITYLOG');


      else
          -- only non_recordables, only schedule table
          vsql := ' merge into '||v_rcsarchive_schema||'.SCHEDULE dsch
                  using (select sch.* from '||vschema||'.SCHEDULE sch where recordable = 0 and
                            sch.start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                        )    ssch on (dsch.schedule_id = ssch.schedule_id)
            when not matched then
          insert (dsch.schedule_id,
          dsch.SCHEDULE_LANGUAGE,
          dsch.STATION_ID,
          dsch.PROGRAM_ID,
          dsch.START_TIME,
          dsch.END_TIME,
          dsch.DURATION,
          dsch.TV_RATING,
          dsch.HD_TV,
          dsch.PART_NUMBER,
          dsch.NO_OF_PARTS,
          dsch.CC,
          dsch.STEREO,
          dsch.LIVE_TAPE_DELAY,
          dsch.SUBTITLED,
          dsch.PREMIERE_FINALE,
          dsch.JOINED_IN_PROGRESS,
          dsch.CABLE_IN_CLASSROOM,
          dsch.SAP,
          dsch.SEX_RATING,
          dsch.VIOLENCE_RATING,
          dsch.LANGUAGE_RATING,
          dsch.DIALOG_RATING,
          dsch.FV_RATING,
          dsch.ENHANCED,
          dsch.THREE_D,
          dsch.LETTERBOX,
          dsch.DVS,
          dsch.series_link,
          dsch.REQUEST_RECORD,
          dsch.REPEAT,
          dsch.BLACKOUT,
          dsch.DOLBY,
          dsch.USER_DATA1,
          dsch.USER_DATA2,
          dsch.USER_DATA3,
          dsch.USER_DATA4,
          dsch.USER_DATA5,
          dsch.USER_DATA6,
          dsch.USER_DATA7,
          dsch.USER_DATA8,
          dsch.USER_DATA9,
          dsch.USER_DATA10,
          dsch.USER_DATA11,
          dsch.SCHEDULE_GENERIC,
          dsch.CREATED_BY,
          dsch.UPDATED_BY,
          dsch.CREATE_date,
          dsch.UPDATE_date
          )
          values
          (ssch.schedule_id,
          ssch.SCHEDULE_LANGUAGE,
          ssch.STATION_ID,
          ssch.PROGRAM_ID,
          ssch.START_TIME,
          ssch.END_TIME,
          ssch.DURATION,
          ssch.TV_RATING,
          ssch.HD_TV,
          ssch.PART_NUMBER,
          ssch.NO_OF_PARTS,
          ssch.CC,
          ssch.STEREO,
          ssch.LIVE_TAPE_DELAY,
          ssch.SUBTITLED,
          ssch.PREMIERE_FINALE,
          ssch.JOINED_IN_PROGRESS,
          ssch.CABLE_IN_CLASSROOM,
          ssch.SAP,
          ssch.SEX_RATING,
          ssch.VIOLENCE_RATING,
          ssch.LANGUAGE_RATING,
          ssch.DIALOG_RATING,
          ssch.FV_RATING,
          ssch.ENHANCED,
          ssch.THREE_D,
          ssch.LETTERBOX,
          ssch.DVS,
          ssch.series_link,
          ssch.REQUEST_RECORD,
          ssch.REPEAT,
          ssch.BLACKOUT,
          ssch.DOLBY,
          ssch.USER_DATA1,
          ssch.USER_DATA2,
          ssch.USER_DATA3,
          ssch.USER_DATA4,
          ssch.USER_DATA5,
          ssch.USER_DATA6,
          ssch.USER_DATA7,
          ssch.USER_DATA8,
          ssch.USER_DATA9,
          ssch.USER_DATA10,
          ssch.USER_DATA11,
          ssch.SCHEDULE_GENERIC,
          ssch.CREATED_BY,
          ssch.UPDATED_BY,
          ssch.CREATE_date,
          ssch.UPDATE_date
          )';

          createobject (vsql, 'Merging schedule from RCS to RCSArchive');


         vsql := 'delete from '||vschema||'.RECORDABLE_RIGHTS_MAP rec
                        where rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where  recordable = 0 and start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          CREATEOBJECT (VSQL, 'delete from RECORDABLE_RIGHTS_MAP');


         VSQL := 'delete from '||VSCHEMA||'.rec_trial_use_fields rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING  rec where  rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where   recordable = 0 and start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )
                  )';
        createobject (vsql, 'delete from rec_trial_use_fields');

        VSQL := 'delete from '||VSCHEMA||'.RECORDING_REC_RULES_MAP rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where   recordable = 0 and start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )
                  )';
        createobject (vsql, 'delete from RECORDING_REC_RULES_MAP');

         VSQL := 'delete from '||VSCHEMA||'.RECORDING_LOG rtuf  where rtuf.recording_id in
                  (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                    (select schedule_id from '||vschema||'.schedule where   recordable = 0 and start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    )
                  )';
        createobject (vsql, 'delete from RECORDING_LOG');

        if is_table_exists(v_rcsarchive_schema, 'recording_rtc_pool_map') = true then

           VSQL := 'delete from '||VSCHEMA||'.recording_rtc_pool_map rtuf  where rtuf.recording_id in
                    (select recording_id from '||vschema||'.RECORDING rec where  rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where   recordable = 0 and start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )
                    )';
          createobject (vsql, 'delete from recording_rtc_pool_map');


        end if;
             VSQL := ' delete from '||VSCHEMA||'.playback_window_restrictions where recording_id in
                        ( select recording_id from '||VSCHEMA||'.recording rec
                         where schedule_id in
                          (
                                  select schedule_id from '||vschema||'.schedule where
                                    recordable = 0 and  start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                          )
                        )';
              CREATEOBJECT (VSQL, 'delete playback_window_restrictions');


           vsql := 'delete from '||vschema||'.RECORDING rec
                        where rec.schedule_id in
                      (select schedule_id from '||vschema||'.schedule where   recordable = 0 and start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                      )';
          createobject (vsql, 'delete from RECORDING');


          vsql := ' delete from '||vschema||'.SCHEDULE  where recordable = 0 and
                            start_time < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')';

          createobject (vsql, 'Deleting schedule from RCS ');

                      --ALARM_ACTIVITYLOG
          vsql := ' insert into '||v_rcsarchive_schema||'.ALARM_ACTIVITYLOG select aal.* from '||vschema||'.ALARM_ACTIVITYLOG aal where
                      aal.create_date < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    ';
         createobject (vsql, 'insert into   ALARM_ACTIVITYlOG');

         vsql := 'delete from '||vschema||'.ALARM_ACTIVITYLOG aal where
                      aal.create_date < to_timestamp_tz('''||to_char(old_data_retention_to_date,'DD-MON-YYYY HH24:MI:SS')||' UTC'||''',''DD-MON-YYYY HH24:MI:SS TZR'')
                    ';
        createobject (vsql, 'delete from ALARM_ACTIVITYLOG');

       end if;

     end if;

     execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;

    vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
    values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 3, 5, ''RCS'', ''Archiving is completed on RCS DB'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'') ) ';
    CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');

    commit;
    RESETHIGHWATERMARK();

  EXCEPTION
    when others then
    	rollback;
  	 execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(sqlerrm,'''')||''')';
	commit;
    execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
        vsql := 'insert into '||vschema||'.ALARM_ACTIVITYLOG (id, type, SEVERITY, COMPONENT, DESCRIPTION, EVENT_NAME, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE )
        values('||vschema||'.ALARM_ACTIVITYLOG_SEQ.NEXTVAL, 1, 3, ''RCS'', ''Archiving is failed on RCS DB. Please contact the administrator'', ''RCS_ARCHIVE_DB'', ''SYSTEM'', ''SYSTEM'', to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR''), to_timestamp_tz('''||to_char(CURRENT_TIMESTAMP,'DD-MON-YYYY HH24:MI:SS')||' '||TIMEZONE||''',''DD-MON-YYYY HH24:MI:SS TZR'')) ';
        CREATEOBJECT(VSQL,' insert into ALARM_ACTIVITYLOG', 'Y');
	commit;


	end runArchiveOnRCSDB;

	procedure setupRCSArchiveDB as

		 vcounttab number := 0;
		 v_archiveUserCount number :=0;

		 begin
		     --Create install_table for logging errors



			if is_table_exists('sys', 'install_Table') = false then
				vsql := 'CREATE TABLE install_Table( msgdate date default sysdate,install_message varchar2(4000))';
		    	CREATEOBJECT(vsql,'Create table install_table');
		  end if;



      SELECT COUNT(1)
	    INTO 	vcounttab
			FROM 	dba_tables
			WHERE	OWNER = upper(vschema);

		    IF vcounttab >= 1 THEN
				BEGIN
					execute immediate ' SELECT UPPER(VALUE) FROM '||VSCHEMA||'.CONFIG_SETTING WHERE  KEY=''APPLICATION_DB_SERVER_TIMEZONE_KEY''' into TIMEZONE;
					vsql := 'alter session set time_zone='''||TIMEZONE||'''';
					CREATEOBJECT(vsql,' Setting up the timezone with the non-offset value');
			    	SELECT COUNT(1)
		    				INTO 	v_archiveUserCount
							FROM 	dba_tables
							WHERE	OWNER = upper(v_rcsarchive_schema);

		                if  v_archiveUserCount = 0 THEN

                      installRCSArchiveDB();
		               else
		                  upgradeRCSArchiveDB();
		            end if;

		    END;
	      ELSE
		  BEGIN
	      	insert into INSTALL_TABLE(MSGDATE, INSTALL_MESSAGE) values (sysdate, 'Setting up RCSArchive DB is required RCS DB. Please install TSTV RCS first and then setup RCSArchive DB');
          commit;

			END;
	      END IF;


	  -- check for RCS user

		-- check for RCSArchive User
		-- check for the partitioning

		-- check for the TSTV RCS Version

		-- Install the RCSArchive Schema

	end setupRCSArchiveDB;

end TSTVRCSDBArchive;
/
begin
  TSTVRCSDBArchive.setupRCSArchiveDB();
end;
/
exit